/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.jdbc.internal;

import com.google.cloud.sql.jdbc.Savepoint;
import com.google.cloud.sql.jdbc.internal.Util;
import com.google.protos.cloud.sql.Client;
import java.sql.SQLException;

public final class ConnectionOperationHelper {
    public static Client.OpProto nativeSQL(String sql) {
        return Client.OpProto.newBuilder().setType(Client.OpProto.OpType.NATIVE_SQL).setSql(sql).build();
    }

    public static Client.OpProto rollback() throws SQLException {
        return ConnectionOperationHelper.rollback(null);
    }

    public static Client.OpProto rollback(java.sql.Savepoint savepoint) throws SQLException {
        Client.SavePoint.Builder savepointBuilder = Client.SavePoint.newBuilder();
        if (savepoint != null) {
            String name = savepoint.getSavepointName();
            if (!Util.isEmpty(name)) {
                savepointBuilder.setName(name);
            }
            if (savepoint.getSavepointId() != 0) {
                savepointBuilder.setId(savepoint.getSavepointId());
            }
        }
        Client.OpProto.Builder builder = Client.OpProto.newBuilder().setType(Client.OpProto.OpType.ROLLBACK);
        if (savepointBuilder.hasId() || savepointBuilder.hasName()) {
            builder.setSavepoint(savepointBuilder);
        }
        return builder.build();
    }

    public static Client.OpProto commit() {
        return Client.OpProto.newBuilder().setType(Client.OpProto.OpType.COMMIT).build();
    }

    public static Client.OpProto savePoint() {
        return ConnectionOperationHelper.savePoint(null);
    }

    public static Client.OpProto savePoint(String savepointName) {
        Client.OpProto.Builder builder = Client.OpProto.newBuilder().setType(Client.OpProto.OpType.SET_SAVEPOINT);
        if (savepointName != null && savepointName.length() > 0) {
            builder.setSavepoint(Client.SavePoint.newBuilder().setName(savepointName).build());
        }
        return builder.build();
    }

    public static Client.OpProto autoCommit(boolean autoCommit) {
        return Client.OpProto.newBuilder().setType(Client.OpProto.OpType.SET_AUTO_COMMIT).setAutoCommit(autoCommit).build();
    }

    public static Client.OpProto readOnly(boolean readOnly) {
        return Client.OpProto.newBuilder().setType(Client.OpProto.OpType.SET_READ_ONLY).setReadOnly(readOnly).build();
    }

    public static Client.OpProto transactionIsolation(int level) {
        return Client.OpProto.newBuilder().setType(Client.OpProto.OpType.SET_TRANSACTION_ISOLATION_LEVEL).setTransactionIsolationLevel(Client.TransactionIsolationLevel.valueOf(level)).build();
    }

    public static Client.OpProto setCatalog(String catalog) {
        return Client.OpProto.newBuilder().setType(Client.OpProto.OpType.SET_CATALOG).setCatalog(catalog).build();
    }

    public static Client.OpProto closeStatement(long statementId) {
        return Client.OpProto.newBuilder().setType(Client.OpProto.OpType.CLOSE_STATEMENT).setStatementId(statementId).build();
    }

    public static Client.OpProto ping() {
        return Client.OpProto.newBuilder().setType(Client.OpProto.OpType.PING).build();
    }

    public static Client.OpProto nextResult(long statementId) {
        return Client.OpProto.newBuilder().setType(Client.OpProto.OpType.NEXT_RESULT).setStatementId(statementId).build();
    }

    public static Savepoint asJdbcSavePoint(Client.SavePoint s) {
        return new Savepoint(Long.valueOf(s.getId()).intValue(), s.getName());
    }
}

