﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
//using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Drawing.Drawing2D;
using System.Diagnostics;

namespace CharLCD
{
    public class LcdDisplay : System.Windows.Forms.PictureBox
    {
        public LcdDisplay()
        {
        }

        public string Text
        {
            set
            {
                base.Image = GetImage(GetDotImage(value));
            }
        }


        private Bitmap GetImage(List<DotImage> dots)
        {
            // ビットマップとGraphicsオブジェクトの作成
            Bitmap bmp = new Bitmap(this.Width, this.Height);
            Graphics g = Graphics.FromImage(bmp);

            // ブラシの作成
            Brush brush = new SolidBrush(Color.Black);
            // ビットマップをブラシで塗る
            foreach(DotImage dot in dots)
            {
                Point location = dot.Location;
                Size size = dot.Size;
                g.FillRectangle(brush,new Rectangle(location, size));
            }
            
            brush.Dispose();
            g.Dispose();
            // ビットマップをボタンの背景にセット
            return bmp;
        }

        private List<DotImage> GetDotImage(string text)
        {
            List<DotImage> listDots = new List<DotImage>();

            string[] lcdTextAry = text.Split('\n');
            string[] line = new string[4];
            line[0] = "";
            line[1] = "";
            line[2] = "";
            line[3] = "";
            if (lcdTextAry.Length > 4)
            {
                MessageBox.Show("4行以内で入力してください");
            }
            switch (lcdTextAry.Length){
                case 4:
                    line[0] = lcdTextAry[0];
                    line[1] = lcdTextAry[1];
                    line[2] = lcdTextAry[2];
                    line[3] = lcdTextAry[3];
                    break;
                case 3:
                    line[0] = lcdTextAry[0];
                    line[1] = lcdTextAry[1];
                    line[2] = lcdTextAry[2];
                    break;
                case 2:
                    line[0] = lcdTextAry[0];
                    line[1] = lcdTextAry[1];
                    break;
                case 1:
                    line[0] = lcdTextAry[0];
                    break;
                case 0:
                default:
                    break;
            }

            int linenum = 0;
            int x = 0;
            foreach (string lines in line)
            {
                foreach (Char c in lines.ToCharArray())
                {
                    Size size = new Size((int)DotSize.X, (int)DotSize.Y);
                    Point pointbase = new Point(size.Width * ((int)CharSize.X + 1) * x , size.Height * ((int)CharSize.Y + 2) * linenum);
                    listDots.AddRange(GetDotLocation(c, pointbase, size));
                    x++;
                    if (x >= 20)
                        break;
                }
                x = 0;
                linenum++;
            }
            return listDots;
        }

        enum DotSize { X = 2, Y = 2 };
        enum CharSize { X = 5, Y = 7 };

        private List<DotImage> GetDotLocation(Char c, Point baseLocation, Size size)
        {
            List<DotImage> dots = new List<DotImage>();
            int x = 0;
            int y = 0;
            foreach (bool[] line in GetDotPatern(c))
            {
                foreach (bool dot in line)
                {
                    if (dot)
                    {
                        dots.Add(new DotImage(new Point(baseLocation.X + (int)DotSize.X * x + 20, baseLocation.Y + (int)DotSize.Y * y + 10), size));
                    }
                    x++;
                }
                x = 0;
                y++;
            }
            return dots;
        }

        private bool[][] GetDotPatern(Char c)
        {
            //http://www.allshore.com/pdf/Hitachi_HD44780.pdf
            string[] line = new string[7];
            switch (c)
            {
                case '0':
                    line[0] = " *** ";
                    line[1] = "*   *";
                    line[2] = "*  **";
                    line[3] = "* * *";
                    line[4] = "**  *";
                    line[5] = "*   *";
                    line[6] = " *** ";
                    break;
                case '1':
                    line[0] = "  *  ";
                    line[1] = " **  ";
                    line[2] = "  *  ";
                    line[3] = "  *  ";
                    line[4] = "  *  ";
                    line[5] = "  *  ";
                    line[6] = " *** ";
                    break;
                case '2':
                    line[0] = " *** ";
                    line[1] = "*   *";
                    line[2] = "    *";
                    line[3] = "   * ";
                    line[4] = "  *  ";
                    line[5] = " *   ";
                    line[6] = "*****";
                    break;
                case '3':
                    line[0] = "*****";
                    line[1] = "   * ";
                    line[2] = "  *  ";
                    line[3] = "   * ";
                    line[4] = "    *";
                    line[5] = "*   *";
                    line[6] = " *** ";
                    break;
                case '4':
                    line[0] = "   * ";
                    line[1] = "  ** ";
                    line[2] = " * * ";
                    line[3] = "*  * ";
                    line[4] = "*****";
                    line[5] = "   * ";
                    line[6] = "   * ";
                    break;
                case '5':
                    line[0] = "*****";
                    line[1] = "*    ";
                    line[2] = "**** ";
                    line[3] = "    *";
                    line[4] = "    *";
                    line[5] = "*   *";
                    line[6] = " ***";
                    break;
                case '6':
                    line[0] = "  ** ";
                    line[1] = " *   ";
                    line[2] = "*    ";
                    line[3] = "**** ";
                    line[4] = "*   *";
                    line[5] = "*   *";
                    line[6] = " ***";
                    break;
                case '7':
                    line[0] = "*****";
                    line[1] = "*   *";
                    line[2] = "   *";
                    line[3] = "  *";
                    line[4] = "  *";
                    line[5] = "  *";
                    line[6] = "  *";
                    break;
                case '8':
                    line[0] = " *** ";
                    line[1] = "*   *";
                    line[2] = "*   *";
                    line[3] = " *** ";
                    line[4] = "*   *";
                    line[5] = "*   *";
                    line[6] = " *** ";
                    break;
                case '9':
                    line[0] = " *** ";
                    line[1] = "*   *";
                    line[2] = "*   *";
                    line[3] = " ****";
                    line[4] = "    *";
                    line[5] = "   * ";
                    line[6] = " **  ";
                    break;
                case ':':
                    line[0] = "     ";
                    line[1] = " **  ";
                    line[2] = " **  ";
                    line[3] = "     ";
                    line[4] = " **  ";
                    line[5] = " **  ";
                    line[6] = "     ";
                    break;
                case ';':
                    line[0] = "     ";
                    line[1] = " **  ";
                    line[2] = " **  ";
                    line[3] = "     ";
                    line[4] = " **  ";
                    line[5] = "  *  ";
                    line[6] = " *   ";
                    break;
                case '<':
                    line[0] = "   * ";
                    line[1] = "  *  ";
                    line[2] = " *   ";
                    line[3] = "*    ";
                    line[4] = " *   ";
                    line[5] = "  *  ";
                    line[6] = "   *";
                    break;
                case '=':
                    line[0] = "     ";
                    line[1] = "     ";
                    line[2] = "*****";
                    line[3] = "     ";
                    line[4] = "*****";
                    line[5] = "     ";
                    line[6] = "     ";
                    break;
                case '>':
                    line[0] = " *   ";
                    line[1] = "  *  ";
                    line[2] = "   * ";
                    line[3] = "    *";
                    line[4] = "   * ";
                    line[5] = "  *  ";
                    line[6] = " *   ";
                    break;
                case '?':
                    line[0] = " *** ";
                    line[1] = "*   *";
                    line[2] = "    *";
                    line[3] = "   * ";
                    line[4] = "  *  ";
                    line[5] = "     ";
                    line[6] = "  *  ";
                    break;
                case ' ':
                    line[0] = "     ";
                    line[1] = "     ";
                    line[2] = "     ";
                    line[3] = "     ";
                    line[4] = "     ";
                    line[5] = "     ";
                    line[6] = "     ";
                    break;
                case '!':
                    line[0] = "  *  ";
                    line[1] = "  *  ";
                    line[2] = "  *  ";
                    line[3] = "  *  ";
                    line[4] = "     ";
                    line[5] = "     ";
                    line[6] = "  *  ";
                    break;
                case '\"':
                    line[0] = " * * ";
                    line[1] = " * * ";
                    line[2] = " * * ";
                    line[3] = "     ";
                    line[4] = "     ";
                    line[5] = "     ";
                    line[6] = "     ";
                    break;
                case '#':
                    line[0] = " * * ";
                    line[1] = " * * ";
                    line[2] = "*****";
                    line[3] = " * * ";
                    line[4] = "*****";
                    line[5] = " * * ";
                    line[6] = " * * ";
                    break;
                case '$':
                    line[0] = "  *  ";
                    line[1] = " ****";
                    line[2] = "* *  ";
                    line[3] = " *** ";
                    line[4] = "  * *";
                    line[5] = "**** ";
                    line[6] = "  *  ";
                    break;
                case '%':
                    line[0] = "**   ";
                    line[1] = "**  *";
                    line[2] = "   * ";
                    line[3] = "  *  ";
                    line[4] = " *   ";
                    line[5] = "*  **";
                    line[6] = "   **";
                    break;
                case '&':
                    line[0] = " **  ";
                    line[1] = "*  * ";
                    line[2] = "* *  ";
                    line[3] = " *   ";
                    line[4] = "* * *";
                    line[5] = "*  * ";
                    line[6] = " ** *";
                    break;
                case '\'':
                    line[0] = " **  ";
                    line[1] = "  *  ";
                    line[2] = " *   ";
                    line[3] = "     ";
                    line[4] = "     ";
                    line[5] = "     ";
                    line[6] = "     ";
                    break;
                case '(':
                    line[0] = "  *  ";
                    line[1] = " *   ";
                    line[2] = "*    ";
                    line[3] = "*    ";
                    line[4] = "*    ";
                    line[5] = " *   ";
                    line[6] = "  *  ";
                    break;
                case ')':
                    line[0] = "*    ";
                    line[1] = " *   ";
                    line[2] = "  *  ";
                    line[3] = "  *  ";
                    line[4] = "  *  ";
                    line[5] = " *   ";
                    line[6] = "*    ";
                    break;
                case '*':
                    line[0] = "     ";
                    line[1] = "  *  ";
                    line[2] = "* * *";
                    line[3] = " *** ";
                    line[4] = "* * *";
                    line[5] = "  *  ";
                    line[6] = "     ";
                    break;
                case '+':
                    line[0] = "     ";
                    line[1] = "  *  ";
                    line[2] = "  *  ";
                    line[3] = "*****";
                    line[4] = "  *  ";
                    line[5] = "  *  ";
                    line[6] = "     ";
                    break;
                case ',':
                    line[0] = "     ";
                    line[1] = "     ";
                    line[2] = "     ";
                    line[3] = "     ";
                    line[4] = " **  ";
                    line[5] = "  *  ";
                    line[6] = " *   ";
                    break;
                case '-':
                    line[0] = "     ";
                    line[1] = "     ";
                    line[2] = "     ";
                    line[3] = "*****";
                    line[4] = "     ";
                    line[5] = "     ";
                    line[6] = "     ";
                    break;
                case '.':
                    line[0] = "     ";
                    line[1] = "     ";
                    line[2] = "     ";
                    line[3] = "     ";
                    line[4] = "     ";
                    line[5] = " **  ";
                    line[6] = " **  ";
                    break;
                case '/':
                    line[0] = "     ";
                    line[1] = "    *";
                    line[2] = "   * ";
                    line[3] = "  *  ";
                    line[4] = " *   ";
                    line[5] = "*    ";
                    line[6] = "     ";
                    break;
                case '@':
                    line[0] = " *** ";
                    line[1] = "*   *";
                    line[2] = "    *";
                    line[3] = " ** *";
                    line[4] = "* * *";
                    line[5] = "* * *";
                    line[6] = " *** ";
                    break;
                case 'A':
                    line[0] = " *** ";
                    line[1] = "*   *";
                    line[2] = "*   *";
                    line[3] = "*   *";
                    line[4] = "*****";
                    line[5] = "*   *";
                    line[6] = "*   *";
                    break;
                case 'B':
                    line[0] = "**** ";
                    line[1] = "*   *";
                    line[2] = "*   *";
                    line[3] = "**** ";
                    line[4] = "*   *";
                    line[5] = "*   *";
                    line[6] = "**** ";
                    break;
                case 'C':
                    line[0] = " *** ";
                    line[1] = "*   *";
                    line[2] = "*    ";
                    line[3] = "*    ";
                    line[4] = "*    ";
                    line[5] = "*   *";
                    line[6] = " *** ";
                    break;
                case 'D':
                    line[0] = "***  ";
                    line[1] = "*  * ";
                    line[2] = "*   *";
                    line[3] = "*   *";
                    line[4] = "*   *";
                    line[5] = "*  * ";
                    line[6] = "***  ";
                    break;
                case 'E':
                    line[0] = "*****";
                    line[1] = "*    ";
                    line[2] = "*    ";
                    line[3] = "**** ";
                    line[4] = "*    ";
                    line[5] = "*    ";
                    line[6] = "*****";
                    break;
                case 'F':
                    line[0] = "*****";
                    line[1] = "*    ";
                    line[2] = "*    ";
                    line[3] = "**** ";
                    line[4] = "*    ";
                    line[5] = "*    ";
                    line[6] = "*    ";
                    break;
                case 'G':
                    line[0] = " *** ";
                    line[1] = "*   *";
                    line[2] = "*    ";
                    line[3] = "* ***";
                    line[4] = "*   *";
                    line[5] = "*   *";
                    line[6] = " ****";
                    break;
                case 'H':
                    line[0] = "*   *";
                    line[1] = "*   *";
                    line[2] = "*   *";
                    line[3] = "*****";
                    line[4] = "*   *";
                    line[5] = "*   *";
                    line[6] = "*   *";
                    break;
                case 'I':
                    line[0] = " *** ";
                    line[1] = "  *  ";
                    line[2] = "  *  ";
                    line[3] = "  *  ";
                    line[4] = "  *  ";
                    line[5] = "  *  ";
                    line[6] = " *** ";
                    break;
                case 'J':
                    line[0] = "  ***";
                    line[1] = "   * ";
                    line[2] = "   * ";
                    line[3] = "   * ";
                    line[4] = "   * ";
                    line[5] = "*  * ";
                    line[6] = " **  ";
                    break;
                case 'K':
                    line[0] = "*   *";
                    line[1] = "*  * ";
                    line[2] = "* *  ";
                    line[3] = "**   ";
                    line[4] = "* *  ";
                    line[5] = "*  * ";
                    line[6] = "*   *";
                    break;
                case 'L':
                    line[0] = "*    ";
                    line[1] = "*    ";
                    line[2] = "*    ";
                    line[3] = "*    ";
                    line[4] = "*    ";
                    line[5] = "*    ";
                    line[6] = "*****";
                    break;
                case 'M':
                    line[0] = "*   *";
                    line[1] = "** **";
                    line[2] = "* * *";
                    line[3] = "* * *";
                    line[4] = "*   *";
                    line[5] = "*   *";
                    line[6] = "*   *";
                    break;
                case 'N':
                    line[0] = "*   *";
                    line[1] = "*   *";
                    line[2] = "**  *";
                    line[3] = "* * *";
                    line[4] = "*  **";
                    line[5] = "*   *";
                    line[6] = "*   *";
                    break;
                case 'O':
                    line[0] = " *** ";
                    line[1] = "*   *";
                    line[2] = "*   *";
                    line[3] = "*   *";
                    line[4] = "*   *";
                    line[5] = "*   *";
                    line[6] = " *** ";
                    break;
                case 'P':
                    line[0] = "**** ";
                    line[1] = "*   *";
                    line[2] = "*   *";
                    line[3] = "**** ";
                    line[4] = "*    ";
                    line[5] = "*    ";
                    line[6] = "*    ";
                    break;
                case 'Q':
                    line[0] = " *** ";
                    line[1] = "*   *";
                    line[2] = "*   *";
                    line[3] = "*   *";
                    line[4] = "* * *";
                    line[5] = "*  * ";
                    line[6] = " ** *";
                    break;
                case 'R':
                    line[0] = "**** ";
                    line[1] = "*   *";
                    line[2] = "*   *";
                    line[3] = "**** ";
                    line[4] = "* *  ";
                    line[5] = "*  * ";
                    line[6] = "*   *";
                    break;
                case 'S':
                    line[0] = " ****";
                    line[1] = "*    ";
                    line[2] = "*    ";
                    line[3] = " *** ";
                    line[4] = "    *";
                    line[5] = "    *";
                    line[6] = "**** ";
                    break;
                case 'T':
                    line[0] = "*****";
                    line[1] = "  *  ";
                    line[2] = "  *  ";
                    line[3] = "  *  ";
                    line[4] = "  *  ";
                    line[5] = "  *  ";
                    line[6] = "  *  ";
                    break;
                case 'U':
                    line[0] = "*   *";
                    line[1] = "*   *";
                    line[2] = "*   *";
                    line[3] = "*   *";
                    line[4] = "*   *";
                    line[5] = "*   *";
                    line[6] = " *** ";
                    break;
                case 'V':
                    line[0] = "*   *";
                    line[1] = "*   *";
                    line[2] = "*   *";
                    line[3] = "*   *";
                    line[4] = "*   *";
                    line[5] = " * * ";
                    line[6] = "  *";
                    break;
                case 'W':
                    line[0] = "*   *";
                    line[1] = "*   *";
                    line[2] = "*   *";
                    line[3] = "* * *";
                    line[4] = "* * *";
                    line[5] = "* * *";
                    line[6] = " * * ";
                    break;
                case 'X':
                    line[0] = "*   *";
                    line[1] = "*   *";
                    line[2] = " * * ";
                    line[3] = "  *  ";
                    line[4] = " * * ";
                    line[5] = "*   *";
                    line[6] = "*   *";
                    break;
                case 'Y':
                    line[0] = "*   *";
                    line[1] = "*   *";
                    line[2] = "*   *";
                    line[3] = " * * ";
                    line[4] = "  *  ";
                    line[5] = "  *  ";
                    line[6] = "  *  ";
                    break;
                case 'Z':
                    line[0] = "*****";
                    line[1] = "    *";
                    line[2] = "   * ";
                    line[3] = "  *  ";
                    line[4] = " *   ";
                    line[5] = "*    ";
                    line[6] = "*****";
                    break;
                case '[':
                    line[0] = "***  ";
                    line[1] = "*    ";
                    line[2] = "*    ";
                    line[3] = "*    ";
                    line[4] = "*    ";
                    line[5] = "*    ";
                    line[6] = "***  ";
                    break;
                case '\\':
                    line[0] = "*   *";
                    line[1] = " * * ";
                    line[2] = "*****";
                    line[3] = "  *  ";
                    line[4] = "*****";
                    line[5] = "  *  ";
                    line[6] = "  *  ";
                    break;
                case ']':
                    line[0] = "  ***";
                    line[1] = "    *";
                    line[2] = "    *";
                    line[3] = "    *";
                    line[4] = "    *";
                    line[5] = "    *";
                    line[6] = "  ***";
                    break;
                case '^':
                    line[0] = "  *  ";
                    line[1] = " * * ";
                    line[2] = "*   *";
                    line[3] = "     ";
                    line[4] = "     ";
                    line[5] = "     ";
                    line[6] = "     ";
                    break;
                case '_':
                    line[0] = "     ";
                    line[1] = "     ";
                    line[2] = "     ";
                    line[3] = "     ";
                    line[4] = "     ";
                    line[5] = "     ";
                    line[6] = "*****";
                    break;
                case '`':
                    line[0] = " *   ";
                    line[1] = "  *  ";
                    line[2] = "   * ";
                    line[3] = "     ";
                    line[4] = "     ";
                    line[5] = "     ";
                    line[6] = "     ";
                    break;
                case 'a':
                    line[0] = "     ";
                    line[1] = "     ";
                    line[2] = " *** ";
                    line[3] = "    *";
                    line[4] = " ****";
                    line[5] = "*   *";
                    line[6] = " ****";
                    break;
                case 'b':
                    line[0] = "*    ";
                    line[1] = "*    ";
                    line[2] = "* ** ";
                    line[3] = "**  *";
                    line[4] = "*   *";
                    line[5] = "*   *";
                    line[6] = "****";
                    break;
                case 'c':
                    line[0] = "     ";
                    line[1] = "     ";
                    line[2] = " *** ";
                    line[3] = "*    ";
                    line[4] = "*    ";
                    line[5] = "*   *";
                    line[6] = " *** ";
                    break;
                case 'd':
                    line[0] = "    *";
                    line[1] = "    *";
                    line[2] = " ** *";
                    line[3] = "*  **";
                    line[4] = "*   *";
                    line[5] = "*   *";
                    line[6] = " ****";
                    break;
                case 'e':
                    line[0] = "     ";
                    line[1] = "     ";
                    line[2] = " *** ";
                    line[3] = "*   *";
                    line[4] = "*****";
                    line[5] = "*    ";
                    line[6] = " *** ";
                    break;
                case 'f':
                    line[0] = "  ** ";
                    line[1] = " *  *";
                    line[2] = " *   ";
                    line[3] = "***  ";
                    line[4] = " *   ";
                    line[5] = " *   ";
                    line[6] = " *   ";
                    break;
                case 'g':
                    line[0] = " ****";
                    line[1] = "*   *";
                    line[2] = "*   *";
                    line[3] = " ****";
                    line[4] = "    *";
                    line[5] = "    *";
                    line[6] = " *** ";
                    break;
                case 'h':
                    line[0] = "*    ";
                    line[1] = "*    ";
                    line[2] = "* ** ";
                    line[3] = "**  *";
                    line[4] = "*   *";
                    line[5] = "*   *";
                    line[6] = "*   *";
                    break;
                case 'i':
                    line[0] = "  *  ";
                    line[1] = "     ";
                    line[2] = " **  ";
                    line[3] = "  *  ";
                    line[4] = "  *  ";
                    line[5] = "  *  ";
                    line[6] = " *** ";
                    break;
                case 'j':
                    line[0] = "   * ";
                    line[1] = "     ";
                    line[2] = "  ** ";
                    line[3] = "   * ";
                    line[4] = "   * ";
                    line[5] = "*  * ";
                    line[6] = " **  ";
                    break;
                case 'k':
                    line[0] = "*    ";
                    line[1] = "*    ";
                    line[2] = "*  * ";
                    line[3] = "* *  ";
                    line[4] = "**   ";
                    line[5] = "* *  ";
                    line[6] = "*  * ";
                    break;
                case 'l':
                    line[0] = " **  ";
                    line[1] = "  *  ";
                    line[2] = "  *  ";
                    line[3] = "  *  ";
                    line[4] = "  *  ";
                    line[5] = "  *  ";
                    line[6] = " *** ";
                    break;
                case 'm':
                    line[0] = "     ";
                    line[1] = "     ";
                    line[2] = "** * ";
                    line[3] = "* * *";
                    line[4] = "* * *";
                    line[5] = "*   *";
                    line[6] = "*   *";
                    break;
                case 'n':
                    line[0] = "     ";
                    line[1] = "     ";
                    line[2] = "* ** ";
                    line[3] = "**  *";
                    line[4] = "*   *";
                    line[5] = "*   *";
                    line[6] = "*   *";
                    break;
                case 'o':
                    line[0] = "     ";
                    line[1] = "     ";
                    line[2] = " *** ";
                    line[3] = "*   *";
                    line[4] = "*   *";
                    line[5] = "*   *";
                    line[6] = " *** ";
                    break;
                case 'p':
                    line[0] = "     ";
                    line[1] = "     ";
                    line[2] = "**** ";
                    line[3] = "*   *";
                    line[4] = "**** ";
                    line[5] = "*    ";
                    line[6] = "*    ";
                    break;
                case 'q':
                    line[0] = "     ";
                    line[1] = "     ";
                    line[2] = " ** *";
                    line[3] = "*  **";
                    line[4] = " ****";
                    line[5] = "    *";
                    line[6] = "    *";
                    break;
                case 'r':
                    line[0] = "     ";
                    line[1] = "     ";
                    line[2] = "* ** ";
                    line[3] = "**  *";
                    line[4] = "*    ";
                    line[5] = "*    ";
                    line[6] = "*    ";
                    break;
                case 's':
                    line[0] = "     ";
                    line[1] = "     ";
                    line[2] = " *** ";
                    line[3] = "*    ";
                    line[4] = " *** ";
                    line[5] = "    *";
                    line[6] = " ***";
                    break;
                case 't':
                    line[0] = " *   ";
                    line[1] = " *   ";
                    line[2] = "***  ";
                    line[3] = " *   ";
                    line[4] = " *   ";
                    line[5] = " *  *";
                    line[6] = "  **";
                    break;
                case 'u':
                    line[0] = "     ";
                    line[1] = "     ";
                    line[2] = "*   *";
                    line[3] = "*   *";
                    line[4] = "*   *";
                    line[5] = "*  **";
                    line[6] = " ** *";
                    break;
                case 'v':
                    line[0] = "     ";
                    line[1] = "     ";
                    line[2] = "*   *";
                    line[3] = "*   *";
                    line[4] = "*   *";
                    line[5] = " * * ";
                    line[6] = "  *  ";
                    break;
                case 'w':
                    line[0] = "     ";
                    line[1] = "     ";
                    line[2] = "*   *";
                    line[3] = "* * *";
                    line[4] = "* * *";
                    line[5] = "* * *";
                    line[6] = " * * ";
                    break;
                case 'x':
                    line[0] = "     ";
                    line[1] = "     ";
                    line[2] = "*   *";
                    line[3] = " * * ";
                    line[4] = "  *  ";
                    line[5] = " * * ";
                    line[6] = "*   *";
                    break;
                case 'y':
                    line[0] = "     ";
                    line[1] = "     ";
                    line[2] = "*   *";
                    line[3] = "*   *";
                    line[4] = " ****";
                    line[5] = "    *";
                    line[6] = " *** ";
                    break;
                case 'z':
                    line[0] = "     ";
                    line[1] = "     ";
                    line[2] = "*****";
                    line[3] = "   * ";
                    line[4] = "  *  ";
                    line[5] = " *   ";
                    line[6] = "*****";
                    break;
                case '{':
                    line[0] = "   * ";
                    line[1] = "  *  ";
                    line[2] = "  *  ";
                    line[3] = " *   ";
                    line[4] = "  *  ";
                    line[5] = "  *  ";
                    line[6] = "   *";
                    break;
                case '|':
                    line[0] = "  *  ";
                    line[1] = "  *  ";
                    line[2] = "  *  ";
                    line[3] = "  *  ";
                    line[4] = "  *  ";
                    line[5] = "  *  ";
                    line[6] = "  *  ";
                    break;
                case '}':
                    line[0] = " *   ";
                    line[1] = "  *  ";
                    line[2] = "  *  ";
                    line[3] = "   * ";
                    line[4] = "  *  ";
                    line[5] = "  *  ";
                    line[6] = " *   ";
                    break;
                case '→':
                    line[0] = "     ";
                    line[1] = "  *  ";
                    line[2] = "   * ";
                    line[3] = "*****";
                    line[4] = "   * ";
                    line[5] = "  *  ";
                    line[6] = "     ";
                    break;
                case '←':
                    line[0] = "     ";
                    line[1] = "  *  ";
                    line[2] = " *   ";
                    line[3] = "*****";
                    line[4] = " *   ";
                    line[5] = "  *  ";
                    line[6] = "   * ";
                    break;
                case '■':
                    line[0] = "*****";
                    line[1] = "*****";
                    line[2] = "*****";
                    line[3] = "*****";
                    line[4] = "*****";
                    line[5] = "*****";
                    line[6] = "*****";
                    break;
                default:
                    line[0] = "     ";
                    line[1] = "     ";
                    line[2] = "     ";
                    line[3] = "     ";
                    line[4] = "     ";
                    line[5] = "     ";
                    line[6] = "     ";
                    break;
            }

            return GetPatern(line);
        }

        private bool[][] GetPatern(string[] line)
        {
            bool[][] patern = new bool[7][];
            patern[0] = new bool[5];
            patern[1] = new bool[5];
            patern[2] = new bool[5];
            patern[3] = new bool[5];
            patern[4] = new bool[5];
            patern[5] = new bool[5];
            patern[6] = new bool[5];
            int x=0;
            int y =0;
            foreach (string s in line)
            {
                foreach (Char c in s)
                {
                    if(c == '*')
                    {
                        patern[y][x] = true;
                    }
                    else
                    {
                        patern[y][x] = false;
                    }
                    x++;
                }
                x=0;
                y++;
            }
            return patern;
        }
    }
}
