/*
==============================================================================
	katuyou.c
		1990/12/17/Mon	Yutaka MYOKI(Nagao Lab., KUEE)
==============================================================================
*/

#include "chadic.h"

ktype_t Type[TYPE_NO];
kform_t Form[TYPE_NO][FORM_NO];

#ifdef KOCHA2
char *gomatsu[] = {"첻", "Ҳ", "", NULL};
#endif

/*
------------------------------------------------------------------------------
        PROCEDURE:
        <initialize_type_form>: initialize <KTYPE:Type>, <KFORM:Form>
------------------------------------------------------------------------------
*/

static void initialize_type_form()
{
     int i, j;
     
     for (i = 0; i < TYPE_NO; i++) {
	  Type[i].name = NULL;
	  for (j = 0; j < FORM_NO; j++) {
	       Form[i][j].name = NULL;
	       Form[i][j].gobi = NULL;
	  }
     }
}

#if 0 /* not used */
/*
------------------------------------------------------------------------------
        PROCEDURE:
        <print_type_form>: print <KTYPE:Type>, <KFORM:Form> on <fp>
------------------------------------------------------------------------------
*/
static void print_type_form(fp)
    FILE *fp;
{
     int	i, j;

     for (i = 1; (Type[i].name != NULL) && i < TYPE_NO; i++) {
	  fprintf(fp, "%s\n", Type[i].name);
	  for (j = 1; (Form[i][j].name != NULL) && j < FORM_NO; j++)
	       fprintf(fp, "\t%-30s %-20s\n", 
		       Form[i][j].name, Form[i][j].gobi);
	  fputc('\n', fp);
     }
}
#endif

/*
------------------------------------------------------------------------------
        PROCEDURE:
        <read_type_form>: read-in <KTYPE:Type>, <KFORM:Form> from <fp>
------------------------------------------------------------------------------
*/
static void read_type_form(fp)
    FILE *fp;
{
    cell_t *cell1, *cell2;
    int i, j;
    char *s;

    for (i = 1; !s_feof(fp); i++) {
	cell1 = s_read(fp);
	Type[i].name = cha_strdup(s_atom(car(cell1)));
	Type[i].basic = 0;
	cell1 = car(cdr(cell1));
	for (j = 1; !nullp(cell2 = car(cell1)); cell1 = cdr(cell1), j++) {
	    /* name */
	    Form[i][j].name = cha_strdup(s_atom(car(cell2)));
	    if (!Type[i].basic &&
		strmatch2(Form[i][j].name, JSTR_BASIC_FORM, ESTR_BASIC_FORM))
	      Type[i].basic = j;
	    /* gobi */
	    if (strcmp(s = s_atom(car(cell2 = cdr(cell2))), "*") == 0)
	      Form[i][j].gobi = "";
	    else
	      Form[i][j].gobi = cha_strdup(s);
	    /* ygobi */
	    if (nullp(car(cell2 = cdr(cell2))))
	      Form[i][j].ygobi = Form[i][j].gobi;
	    else if (strcmp(s = s_atom(car(cell2)), "*") == 0)
	      Form[i][j].ygobi = "";
	    else
	      Form[i][j].ygobi = cha_strdup(s);
	}
	if (!Type[i].basic)
	  cha_exit_file(1, "no basic form");
#ifdef KOCHA_DEBUG
	printf("[type: %d,%s]\n", i, Type[i].name);
#endif
    }
#ifdef KOCHA2
    for (j = 0; gomatsu[j]; i++, j++) {
	Type[i].name = cha_strdup(gomatsu[j]);
    }
#endif
}

/***********************************************************************
 * read_katuyou - read KATUYOUFILE and set Form[][]
 *
 * inputs:
 *	dir - 0: read from current directory
 *	      1: read from grammar directory
 *	      2: read from current directory or grammar directory
 ***********************************************************************/
void read_katuyou(fp_out, dir)
    FILE *fp_out;
    int dir;
{
    FILE *fp;
    char *filename, *filepath;

#ifdef VGRAM
    fp = cha_fopen_grammar(KATUYOUFILE, "r", 1, dir, &filepath);
#else
    fp = cha_fopen_grammar2(KATUYOUFILE, JM_KATUYOUFILE, "r", 1, dir, &filepath);
#endif

    if (fp_out != NULL)
      fprintf(fp_out, "parsing %s\n", filepath);

    initialize_type_form();
    read_type_form(fp);

    fclose(fp);
}
