/*
==============================================================================
	trans.c
		1990/11/12/Mon Yutaka MYOKI(Nagao Lab., KUEE)
==============================================================================
*/

#include "chadic.h"

#define MRPH_WEIGHT_MAX USHRT_MAX /* 65535 */

/*
------------------------------------------------------------------------------
	FUNCTION:
	<compare_end_str>: if <s1> = <...s2> or <s2> = <...s1> return 0
------------------------------------------------------------------------------
*/

static int strcmp_tail(s1, s2)
    char *s1, *s2;
{
    int diff_len;

    diff_len = strlen(s1) - strlen(s2);

    if (diff_len >= 0)
      return strcmp(s1 + diff_len, s2);
    else
      return strcmp(s2 - diff_len, s1);
}

/*
------------------------------------------------------------------------------
	PROCEDURE:
	<init_mrph>:
------------------------------------------------------------------------------
*/

static void init_mrph(mrph_p)
    mrph_t *mrph_p;
{
     mrph_p->hinsi    = 0;
#ifndef VGRAM
     mrph_p->bunrui   = 0;
#endif
     mrph_p->ktype = 0;
     mrph_p->kform = 0;
     mrph_p->weight   = 0;
     mrph_p->con_tbl  = 0;
}

/*
------------------------------------------------------------------------------
	PROCEDURE:
	<print_mrph>:
------------------------------------------------------------------------------
*/

static void print_mrph(fp, mrph)
    FILE *fp;
    mrph_t *mrph;
{
#ifdef SJIS
    sjis2euc(mrph->midasi);
    sjis2euc(mrph->yomi);
    sjis2euc(mrph->imi);
#endif

#ifdef VGRAM
    fprintf(fp, "%s%c%d%c%d%c%d%c%d%c%s%c%d%c%s%c%s%c\n",
	    mrph->midasi, 0, mrph->hinsi, 0,
	    mrph->ktype, 0, mrph->kform, 0, mrph->weight, 0,
	    mrph->yomi, 0, mrph->con_tbl, 0, mrph->imi, 0, mrph->base, 0);
#else
    fprintf(fp, "%s\t%d %d %d %d %d %s %d %s\n",
	    mrph->midasi, mrph->hinsi, mrph->bunrui,
	    mrph->ktype, mrph->kform, mrph->weight,
	    mrph->yomi, mrph->con_tbl, mrph->imi);
#endif
}

static void print_mrph_loop(fp, mrph)
    FILE *fp;
    mrph_t *mrph;
{
    int i;

    for ( i=1; Form[mrph->ktype][i].name; i++ ) {
	if (Form[mrph->ktype][i].gobi[0]) {
#ifdef SJIS
	    sjis2euc(Form[mrph->ktype][i].gobi);
            sjis2euc(mrph->imi);
#endif
#ifdef VGRAM
            fprintf(fp, "%s%c%d%c%d%c%d%c%d%c%s%c%d%c%s%c%s%c\n",
                    Form[mrph->ktype][i].gobi, 0, mrph->hinsi, 0,
                    mrph->ktype, 0, i, 0, mrph->weight, 0,
                    Form[mrph->ktype][i].ygobi, 0, mrph->con_tbl + i - 1, 0,
		    mrph->imi, 0, mrph->base, 0);
#else
            fprintf(fp, "%s\t%d %d %d %d %d %s %d %s\n",
                    Form[mrph->ktype][i].gobi, mrph->hinsi, mrph->bunrui,
		    mrph->ktype, i, mrph->weight,
                    Form[mrph->ktype][i].ygobi, mrph->con_tbl + i - 1,
		    mrph->imi);
#endif
        }
    }
}

/*
------------------------------------------------------------------------------
	PROCEDURE:
	<error_in_trans>: local cha_exit processing
------------------------------------------------------------------------------
*/

static void trans_exit(status, msg, cell)
    char *msg;
    cell_t *cell;
{
    cha_exit_file(status, "`%s' %s\n", s_tostr(cell), msg);
}

/*
------------------------------------------------------------------------------
	FUNCTION:	** not used now ** 1992/9/10
	<midasi>: sub-routine of <trans>
------------------------------------------------------------------------------
*/

#if 0
static char *midasi(x)
    cell_t *x;
{
    cell_t *y;
    char *s;

    if (nullp(y = assoc(tmp_atom("Ф"), x)))
      trans_exit(1, "doesn't contain a list for midasi", x);

    s = hantozen(s_atom(car(cdr(y))));

    if (strlen(s) > MIDASI_MAX)
      cha_exit_file(1, "midashi `%s' is too long", s);

    return s;
}
#endif

/*
------------------------------------------------------------------------------
	FUNCTION:
	<midasi_list>: sub-routine of <trans>
------------------------------------------------------------------------------
*/

static cell_t *midasi_list(x)
    cell_t *x;
{
    cell_t *y;
    char *s;

    if (nullp(y = assoc(tmp_atom(JSTR_WORD), x)))
      if (nullp(y = assoc(tmp_atom(ESTR_WORD), x)))
	trans_exit(1, "doesn't contain a list for midasi", x);

    return cdr(y);
}

/*
------------------------------------------------------------------------------
	FUNCTION
	<yomi>: sub-routine of <trans>
------------------------------------------------------------------------------
*/

static char *yomi(x)
    cell_t *x;
{
    cell_t *y;
    char *s;

    if (nullp(y = assoc(tmp_atom(JSTR_READING), x)))
      if (nullp(y = assoc(tmp_atom(ESTR_READING), x)))
	return "";

    s = s_atom(car(cdr(y)));
#if 0 /* 980710 akira-k */
    s = hantozen(s_atom(car(cdr(y))));
#endif

    if (strlen(s) > YOMI_MAX)
      cha_exit_file(1, "yomi `%s' is too long", s);

    return s;
}

/*
------------------------------------------------------------------------------
	FUNCTION:
	<ktype>: sun-routine of <trans>
------------------------------------------------------------------------------
*/

static int ktype(x)
    cell_t *x;
{
    cell_t *y;
    int i;

    if (nullp(y = assoc(tmp_atom(JSTR_CTYPE), x)))
      if (nullp(y = assoc(tmp_atom(ESTR_CTYPE), x)))
	trans_exit(1, "doesn't contain a list for katsuyou", x);

    return get_type_id(s_atom(car(cdr(y))));
}

/* for EDRdic '94.Mar */
/*
------------------------------------------------------------------------------
        FUNCTION:
        <edrconnect>: sub-routine of <trans>
------------------------------------------------------------------------------
*/

static cell_t *edrconnect(x)
    cell_t *x;
{
    cell_t *y;

    y = assoc(tmp_atom(JSTR_CONN_ATTR), x);
    return car(cdr(y));
}

/*
------------------------------------------------------------------------------
	FUNCTION:
	<imi>: sub-routine of <trans>
------------------------------------------------------------------------------
*/

static char *imi(x)
    cell_t *x;
{
    cell_t *y;

    if (nullp(y = assoc(tmp_atom(JSTR_INFO), x)))
      if (nullp(y = assoc(tmp_atom(ESTR_INFO), x)))
	return "";

    /* JUMAN2.0 Ǥ cdr(y) ֤褦ˤʤäƤ */
    return s_atom(car(cdr(y)));
}

#ifdef VGRAM
static char *base(x)
    cell_t *x;
{
    cell_t *y;

    if (nullp(y = assoc(tmp_atom("base"), x)))
      return "";
    else
      return s_atom(car(cdr(y)));
}
#endif

/*
------------------------------------------------------------------------------
	PROCEDURE:
	<trim_yomi_gobi> <trim_midasi_gobi>: sub-routine of <trans>
------------------------------------------------------------------------------
*/

static void trim_yomi_gobi(mrph)
    mrph_t *mrph;
{
    mrph->yomi[strlen(mrph->yomi) -
	       strlen(Form[mrph->ktype][Type[mrph->ktype].basic].gobi)]='\0';
}

static void trim_midasi_gobi(mrph)
    mrph_t *mrph;
{
    char *gobi = Form[mrph->ktype][Type[mrph->ktype].basic].gobi;

    if (!strcmp_tail(mrph->midasi, gobi))
      mrph->midasi[strlen(mrph->midasi) - strlen(gobi)] = '\0';
    else
      cha_exit_file(1, "midashi `%s' conflicts katsuyou form", mrph->midasi);
}
/*
------------------------------------------------------------------------------
	PROCEDURE:
	<trans>: translate from <fp_in> to <fp_out>
------------------------------------------------------------------------------
*/

static void trans_main(block, mrph, def_weight, fp_out)
    cell_t *block;
    mrph_t *mrph;
    int def_weight;
    FILE *fp_out;
{
    cell_t *loop, *midasi_cell;
    char   *midasi_cp = NULL;
#ifdef KOCHA2
    char   *midasi_last;
#endif
    float  float_weight;
    int    int_weight;
    cell_t *connect_cell; /* EDRdic '94.Mar */
    int    katuyou;

    strcpy(mrph->yomi, yomi(block)); /* ɤ */
    mrph->imi = imi(block);          /* ̣ */
#ifdef VGRAM
    mrph->base = base(block);        /* base */
    katuyou = Hinsi[mrph->hinsi].kt;
#else
    katuyou = Class[mrph->hinsi][mrph->bunrui].kt;
#endif

    if (katuyou == 1) {
	mrph->ktype = ktype(block);    /* ѷ   */
	trim_yomi_gobi(mrph);
    } else
      mrph->ktype = 0;

    loop = midasi_list(block);         /* Ф */
    while (!nullp(midasi_cell = car(loop))) {
	/* (Ф ߡߡ) ξ */
	if (atomp(midasi_cell)) {
	    midasi_cp = s_atom_val(midasi_cell);
	    mrph->weight = def_weight;
	} 

	/* (Ф (ߡߡ weight)) ξ */
	else if (atomp(car(midasi_cell))) {
	    midasi_cp = s_atom_val(car(midasi_cell));

	    if (nullp(cdr(midasi_cell)))
	      mrph->weight = def_weight;
	    else if (atomp(car(cdr(midasi_cell)))) {
		if (sscanf(s_atom_val(car(cdr(midasi_cell))),"%f",
			   &float_weight) == 0)
		  trans_exit(1, "has illegal form", midasi_cell);
		int_weight = (int)(float_weight * MRPH_DEFAULT_WEIGHT);
		if (int_weight < 0 || int_weight > MRPH_WEIGHT_MAX) {
		    trans_exit(-1, ": weight must be between 0.0 and 6553.5", midasi_cell);
		    if (int_weight < 0)
		      int_weight = 0;
		    if (int_weight > MRPH_WEIGHT_MAX)
		      int_weight = MRPH_WEIGHT_MAX;
		}
		mrph->weight = (unsigned short)int_weight;
	    }
	    else 
	      trans_exit(1, "has illegal form", midasi_cell);
	} else {
	    trans_exit(1, "has illegal form", midasi_cell);
	}

#if 0 /* 980710 akira-k */
	midasi_cp = hantozen(midasi_cp);
#endif

	if (strlen(midasi_cp) > MIDASI_MAX)
	  cha_exit_file(1, "midashi `%s' is too long", midasi_cp);
	strcpy(mrph->midasi, midasi_cp);
#ifdef KOCHA2
	if (*mrph->yomi == '\0') 
	  strcpy(mrph->yomi, mrph->midasi);
	if (katuyou == 2) {
	    midasi_last = mrph->yomi + strlen(mrph->yomi) - 2;
	    if (is_moeum(midasi_last))
		mrph->ktype = get_type_id("첻");
	    else if (!strcmp(midasi_last, ""))
		mrph->ktype = get_type_id("");
	    else
		mrph->ktype = get_type_id("Ҳ");
	}
#endif
        if( nullp(connect_cell = edrconnect(block)) ){
            check_table(mrph);                            /* Ϣܾ */
        }
        else{                                         /* for EDRdic '94.Mar */
            check_edrtable(mrph, connect_cell);
        }

	if (katuyou == 1) {
	    trim_midasi_gobi(mrph);
	    if (mrph->midasi[0]) {
		print_mrph(fp_out, mrph);
	    } else {
		/* 촴̵ʤƤγѷϿ */
		print_mrph_loop(fp_out, mrph);
	    }
	} else {
	    print_mrph(fp_out, mrph);
	}
	
	loop = cdr(loop);
    }
}

void trans(fp_in, fp_out)
    FILE *fp_in, *fp_out;
{
    mrph_t mrph0, *mrph;
    cell_t *cell, *main_loop, *main_block, *sub_loop, *sub_block;
    int hinsi, weight = MRPH_WEIGHT_MAX;

    mrph = &mrph0;
    init_mrph(mrph);
    hinsi = -1;

    while (!s_feof(fp_in)) {
	cell = s_read(fp_in);
	if (atomp(cell))
	  trans_exit(1, "is not list", cell);

#ifdef VGRAM
	if (atomp(car(cell))) {
	    char *s = s_atom_val(car(cell));
	    if (strmatch2(s, JSTR_POS, ESTR_POS))
	      hinsi = get_nhinsi_id(car(cdr(cell)));
	    else if (strmatch2(s, JSTR_DEF_POS_COST, ESTR_DEF_POS_COST))
	      weight = atoi(s_atom_val(car(cdr(cell))));
	    else {
		/* upper compatible for old format */
		char *hinsi_str[256];
		char **hinsi = hinsi_str;
		for (; atomp(car(cell)); cell = car(cdr(cell)))
		  *hinsi++ = s_atom_val(car(cell));
		*hinsi = NULL;
		mrph->hinsi = get_nhinsi_str_id(hinsi_str);
		trans_main(cell, mrph, weight, fp_out);
	    }
	} else {
	    if (hinsi < 0)
	      cha_exit_file(1, "hinsi is not defined");
	    mrph->hinsi = hinsi;
	    trans_main(cell, mrph, weight, fp_out);
	}
#else
	/* ʻ */
	mrph->hinsi = get_hinsi_id(s_atom(car(cell)));
	main_loop = cdr(cell);
	while (!nullp(main_block = car(main_loop))) {
	    /* ʬब */
	    if (atomp(car(main_block))) {
		mrph->bunrui =
		  get_bunrui_id(s_atom_val(car(main_block)), mrph->hinsi);
		sub_loop = cdr(main_block);
		while (!nullp(sub_block = car(sub_loop))) {
		    trans_main(sub_block, mrph, weight, fp_out);
		    sub_loop = cdr(sub_loop);
		}
	    } 
	    /* ʬबʤ */
	    else {
		mrph->bunrui = 0;
		trans_main(main_block, mrph, weight, fp_out);
	    }
	    main_loop = cdr(main_loop);
	}
#endif
	s_free(cell);
    }
}
