#include "chadic.h"

#define PATH_NUM            1024
#define INFO_MAX            129 /* ̣ʸȤƳǼ륹åȤΥ */
#define CHA_INPUT_SIZE      8192

/* for debug */
#if 0
#define debug_print(s) {printf("[%s:%d:%s]\n",__FILE__,__LINE__,s);fflush(stdout);}
#else
#define debug_print(s)
#endif


/*
 * structures
 */

typedef struct _mrph2_t {
    char	*midasi;
    char	*yomi;
    char        *info; /* ̣ʸȤƳǼ륹å */
    short	base_length;

#ifdef VGRAM
    unsigned short hinsi;
#else
    unsigned char hinsi;
    unsigned char bunrui;
#endif
    unsigned char ktype;
    unsigned char kform;
    char	is_undef;

    unsigned char weight;
    short	length;
    short	con_tbl;
} mrph2_t;

typedef struct _path_t {
    int   mrph_p;
    short state;
    short start;
    short end;
    int   cost;
    int   *path;     /* Υѥξ */
    int   do_print;
} path_t;

/*
 * global variables
 */

extern mrph2_t *Mrph;
extern path_t *Path;
extern int Path_num;
extern int Con_cost_weight, Mrph_cost_weight, Cost_width;
extern int Undef_cost, Undef_hinsi, Undef_con_tbl, Undef_con_cost;
#ifndef VGRAM
extern int Undef_bunrui;
#endif

/*
 * functions
 */

/* init.c */
extern void eval_chasenrc_sexp();
extern void read_chasenrc_fp();
extern void chasen_init();

/* print.c */
extern char *get_cha_output();
extern void set_cha_fput();
extern void set_cha_output();
extern void print_mrph();
extern void cha_print_path();

/* parse.c */
extern char *take_data();
extern int chasen_sent();

/* chalib.c */
void cha_version();
void set_opt_form();
void set_cost_width();
int chasen_getopt_argv();
int chasen_fparse();
int chasen_sparse();
char *chasen_fparse_tostr();
char *chasen_sparse_tostr();
char *cha_fgets();
void read_patdic();


/* jfgets.c */
extern void set_jfgets_delimiter();
extern char *fget_line();
extern char *jfgets();

