/*
==============================================================================
	katuyou.c
		1990/12/17/Mon	Yutaka MYOKI(Nagao Lab., KUEE)
==============================================================================
*/

#include "chadic.h"

ktype_t Cha_type[TYPE_NUM];
kform_t Cha_form[TYPE_NUM][FORM_NUM];

#ifdef KOCHA2
char *gomatsu[] = {"첻", "Ҳ", "", NULL};
#endif

/***********************************************************************
 * read_type_form
 ***********************************************************************/
static void read_type_form(fp)
    FILE *fp;
{
    chasen_cell_t *cell1, *cell2;
    int i, j;
    char *s;

    for (i = 1; !cha_s_feof(fp); i++) {
	cell1 = cha_s_read(fp);
	Cha_type[i].name = cha_strdup(cha_s_atom(cha_car(cell1)));
	Cha_type[i].basic = 0;
	cell1 = cha_car(cha_cdr(cell1));
	for (j = 1; !nullp(cell2 = cha_car(cell1)); cell1 = cha_cdr(cell1), j++) {
	    /* name */
	    Cha_form[i][j].name = cha_strdup(cha_s_atom(cha_car(cell2)));
	    if (!Cha_type[i].basic &&
		strmatch2(Cha_form[i][j].name, JSTR_BASIC_FORM, ESTR_BASIC_FORM))
	      Cha_type[i].basic = j;
	    /* gobi */
	    if (strcmp(s = cha_s_atom(cha_car(cell2 = cha_cdr(cell2))), "*") == 0)
	      Cha_form[i][j].gobi = "";
	    else {
	        Cha_form[i][j].gobi = cha_strdup(s);
	        Cha_form[i][j].gobi_len = strlen(s);
#ifdef SJIS
	        sjis2euc(Cha_form[i][j].gobi);
#endif
	    }
	    /* ygobi */
	    if (nullp(cha_car(cell2 = cha_cdr(cell2))))
	      Cha_form[i][j].ygobi = Cha_form[i][j].gobi;
	    else if (strcmp(s = cha_s_atom(cha_car(cell2)), "*") == 0)
	      Cha_form[i][j].ygobi = "";
	    else {
		Cha_form[i][j].ygobi = cha_strdup(s);
#ifdef SJIS
		sjis2euc(Cha_form[i][j].ygobi);
#endif
	    }
	    /* pgobi */
	    if (nullp(cha_car(cell2 = cha_cdr(cell2))))
	      Cha_form[i][j].pgobi = Cha_form[i][j].ygobi;
	    else if (strcmp(s = cha_s_atom(cha_car(cell2)), "*") == 0)
	      Cha_form[i][j].pgobi = "";
	    else {
		Cha_form[i][j].pgobi = cha_strdup(s);
#ifdef SJIS
		sjis2euc(Cha_form[i][j].pgobi);
#endif
	    }
	}
	if (!Cha_type[i].basic)
	  cha_exit_file(1, "no basic form");
#ifdef KOCHA_DEBUG
	printf("[type: %d,%s]\n", i, Cha_type[i].name);
#endif
    }
#ifdef KOCHA2
    for (j = 0; gomatsu[j]; i++, j++) {
	Cha_type[i].name = cha_strdup(gomatsu[j]);
    }
#endif
}

/***********************************************************************
 * cha_read_katuyou - read CFORM_FILE and set Cha_form[][]
 *
 * inputs:
 *	dir - 0: read from current directory
 *	      1: read from grammar directory
 *	      2: read from current directory or grammar directory
 ***********************************************************************/
void cha_read_katuyou(fp_out, dir)
    FILE *fp_out;
    int dir;
{
    FILE *fp;
    char *filepath;

    fp = cha_fopen_grammar(CFORM_FILE, "r", 1, dir, &filepath);
    if (fp_out != NULL)
      fprintf(fp_out, "parsing %s\n", filepath);

    read_type_form(fp);

    fclose(fp);
}
