#include "config.h"
#if defined _WIN32 && ! defined __CYGWIN__
#include <io.h>
#include <process.h>
#else
#include <unistd.h>
#endif /* _WIN32 && ! defined __CYGWIN__ */
#include <sys/types.h>
#include <sys/stat.h>
#ifdef HAVE_MMAP
#include <sys/mman.h>
#endif
#include "chadic.h"

#if ! defined _WIN32 && ! defined __CYGWIN__
#define O_BINARY 0
#endif

off_t cha_mmap_file(char *filename, void **map)
{
    int fd;
    struct stat st;
    off_t size;

    if ((fd = open(filename, O_RDONLY)) < 0)
        cha_exit_perror(filename);
    if (fstat(fd, &st) < 0)
        cha_exit_perror(filename);
    size = st.st_size;
#ifdef HAVE_MMAP
    if ((*map = mmap((void *)0, size, PROT_READ, MAP_SHARED, fd, 0))
        == MAP_FAILED ) {
        cha_exit_perror(filename);
    }
#else
    *map = cha_malloc(size);
    if (read(fd, *map, size) < 0)
	cha_exit_perror(filename);
#endif
    close(fd);

    return size;
}

void cha_munmap_file(void *map, off_t size)
{
#ifdef HAVE_MMAP
    munmap(map, size);
#else
    cha_free(map);
#endif
}
