/*-
 * chfile.c - եγĽ                               
 * SUFARY --- Suffix Array ΤΥ饤֥  
 *
 * Copyright (c) 2000 Nara Institute of Science and Technology
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Nara Institute of 
 *      Science and Technology.
 * 4. The name Nara Institute of Science and Technology may not be used to
 *    endorse or promote products derived from this software without specific
 *    prior written permission.
 *    
 *
 * THIS SOFTWARE IS PROVIDED BY Nara Institute of Science and Technology 
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
 * PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE Nara Institute
 * of Science and Technology BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: chfile.c,v 1.7.4.1 2000/12/18 20:08:31 masayu-a Exp $
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "chadic.h"
#include "sufary.h"

/* %%%%% ؿƱΤδط %%%%%
   sa_openfiles() 
   +- sa_opentextfile()
   +- sa_openarrayfile()
   sa_cloasefiles() 
   +- sa_closetextfile()
   +- sa_closearrayfile()
   %%%%%%%%%%%%%%%%%%%%%%%% */

static void sa_opentextfile(SUFARY*, char*);
static void sa_openarrayfile(SUFARY*, char*);
static void sa_closetextfile(SUFARY*);
static void sa_closearrayfile(SUFARY*);


/**********************************************
 *        SUFARY *sa_openfiles(char *s, char *t);
 *
 * purpose
 *   ꤵ줿ƥȥե(s)arrayե(t)򳫤
 *   arrayե̾NULL˻ꤹСƥȥե̾
 *   '.ary' ղäΤarrayե̾ˤʤ롣
 *
 * parameters
 *   t : arrayե̾
 *   s : ƥȥե̾
 *
 * return value
 *   줿SUFARYѿ
 **********************************************/
SUFARY *sa_openfiles(s, t)
    char *s, *t;
{
    SUFARY *newary;
    char aryname[8192];

    newary = cha_malloc(sizeof(SUFARY));

    sa_opentextfile(newary, s);
    if (t == NULL){ 
        /*  1 : array file ꤵƤʤ */
	sprintf(aryname, "%s.ary", s); /* (Rel1.4: .pat -> .ary) */
	t = aryname;
    }
    sa_openarrayfile(newary, t);

    return newary;
}


/**********************************************
 *        void sa_opentextfile(SUFARY *ary,char *s);
 *
 * purpose
 *   ƥȥե򳫤
 *
 * parameters
 *   ary : ե(ʤ)ǼSUFARYѿ
 *   s   : ƥȥե̾
 * 
 **********************************************/
static void sa_opentextfile(ary, filename)
    SUFARY *ary;
    char *filename;
{
    off_t size;  /* ե륵 */
    void *map;
  
    /* ˥ץ󤵤ƤΤХ */
    if (ary->txtmap != NULL){
	sa_closetextfile(ary);
    }

    /* եΥץ */
    size = cha_mmap_file(filename, &map);

    ary->txtsz  = size;
    ary->txtmap = map;
}

/**********************************************
 *       void sa_openarrayfile(SUFARY *ary, char *s);
 *
 * purpose
 *   Array ե򳫤
 *
 * parameters
 *   ary : ե(ʤ)ǼSUFARYѿ
 *   s : Array ե̾
 *
 **********************************************/
static void sa_openarrayfile(ary, filename)
    SUFARY *ary;
    char *filename;
{
    off_t size;  /* ե륵 */
    void *map;

    /* ˥ץ󤵤ƤΤХ */
    if (ary->arymap != NULL){
	sa_closearrayfile(ary);
    }

    size = cha_mmap_file(filename, &map);
    ary->arysz = size;
    ary->arraysize = size / sizeof(long);
    ary->arymap = map;
    /* left, right ϸϰϤ¦ؤ  980319 */
    ary->left = 0;
    ary->right = ary->arraysize - 1;
}

/**********************************************
 *       void sa_closefiles(SUFARY *ary);
 *
 * purpose
 *   ꤵ줿եĤ
 * 
 * parameters
 *   ary : Ĥե˴ؤSUFARYѿ
 *
 * return value
 *   ʤ
 *
 * description
 *   ƥȥեarrayեƱĤ
 **********************************************/
void sa_closefiles(ary)
    SUFARY *ary;
{
    sa_closetextfile(ary);
    sa_closearrayfile(ary);
    cha_free(ary);
}

/**********************************************
 *        void sa_closetextfile(SUFARY *ary);
 *
 * purpose
 *   ꤵ줿ƥȥեĤ
 * 
 * parameters
 *   ary : Ĥե˴ؤSUFARYѿ
 *
 * return value
 *   ʤ
 **********************************************/
static void sa_closetextfile(ary)
    SUFARY *ary;
{
    if (ary->txtmap != NULL){
	/* mmap β */
	cha_munmap_file(ary->txtmap, ary->txtsz);
	ary->txtmap = NULL;
	ary->txtsz = 0;
    }
}

/**********************************************
 *        void sa_closearrayfile(void);
 *
 * purpose
 *   ꤵ줿arrayեĤ륯
 *
 * parameters
 *   ary : Ĥե˴ؤSUFARYѿ
 *
 * return value
 *   ʤ
 **********************************************/
static void sa_closearrayfile(ary)
    SUFARY *ary;
{
    /* ⡧mmap Ĥɬפ뤫 */
    if (ary->arymap != NULL){
	/* mmap β */
	cha_munmap_file(ary->arymap, ary->arysz);
	ary->arymap = NULL;
	ary->arysz = 0;
    }
    ary->arraysize = 0;
    ary->left = 0;
    ary->right = 0;
}
