/*-
 * pat.h
 *
 * Copyright (c) 1996, 1997, 2000 Nara Institute of Science and Technology
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Nara Institute of 
 *      Science and Technology.
 * 4. The name Nara Institute of Science and Technology may not be used to
 *    endorse or promote products derived from this software without specific
 *    prior written permission.
 *    
 *
 * THIS SOFTWARE IS PROVIDED BY Nara Institute of Science and Technology 
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
 * PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE Nara Institute
 * of Science and Technology BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: pat.h,v 1.9.4.1 2000/12/18 20:08:31 masayu-a Exp $
 */

#ifndef __PAT_H__
#define __PAT_H__

#include "config.h"
#include <sys/types.h>

#define SIKII_BIT 16  /* ʸʸζڤϲӥå? (8 or 16) */

/* ǥåѤΥꥹȷ */
typedef struct pat_index_list {
  struct pat_index_list *next; /* Ĥ */
  long index; /* եΥǥå */
} pat_index_list;

/* ΡɤΥǡ¤ */
typedef struct pat_node {
  pat_index_list il; /* ǥåΥꥹ */
  short checkbit; /* åӥåȤλꡣ(ܤΥӥå?) */
  struct pat_node *right; /* ؤޤޡ */
  struct pat_node *left; /* ؤޤޡ */
} pat_node;

typedef struct __pat_h {
    pat_node *root;
    void *map;
    off_t size;
} pat_t;


/**************************
 * ؿΥץȥ *
 **************************/ 
pat_t *pat_open(char*, char*);
void pat_load(pat_t*, char*);
void pat_save(pat_t*, char*);
void pat_text_reopen(pat_t*, char*);

#define pat_text_size(pat) (pat->size)
#define pat_get_text(pat, pos) ((char *)(pat->map + pos))

/* pat.c */
/* ѥȥꥷڤǸ */
pat_node *pat_search(pat_t*, char*, char**);
pat_node *pat_search_exact(pat_t*, char*, char**);
/* ѥȥꥷڤ */
void pat_insert(pat_t *, char*, long, char *);
/* ѥȥꥷڥǡ */
void pat_show_patfile(pat_t*, FILE*, char*);

/* patfile.c */
pat_node *pat_malloc_node(); /* Matomete malloc */
pat_index_list *pat_malloc_index_list(); /* Matomete malloc */

/* morph.c */
void jisyohiki(char*); /*  */
void insert_dic_data(pat_t*, char*); /* ǡ*/

/************************************************************************
* 
* pat --- ѥȥꥷڤõ
* 
* : Ĥ(tatuo-y@is.aist-nara.ac.jp)
* 
* Ū: ѥȥꥷڤõԤ
* 
* ʸ: 
*   르ꥺΤʸ[1]򻲾ȤCǤμ
*   ʸ[2]Υץ򻲹ͤˤ
* [1] R. Sedgewick  ʿ顢ƣϡĸ 
*     르ꥺ (Algorithms) 2 2 õʸ󡦷׻
*     ʳؼ,1992. (B195-2,pp.68-72)
* [2] 졢ͭ߷ʿѡ§ ԽѰ
*     르ꥺ༭ŵ
*     Ωǳ,1994. (D74,pp.624-625)
* 
* :
*   1996/04/09  ư! (ǡκĹ8bit[2])
*           10  ϥ롼Ƶ˲ɡʸǡб(Ĺ̵)
*           30  /ɵǽΡɤΥǡ¤IDֹɲ()
*         5/06  ʬڤǡϽ
*         6/11  ChaSenμѤ˲¤
*           21  ϢƳ(INDEX򥭥å夹)
*         7/01  ʣμե(ѥ)鸡Ǥ褦ˤ
* 
* : ChaSenμѤ
* 
************************************************************************/
#endif /* __PAT_H__ */
