/*
 * dartsdic.c - library for Darts.
 *
 * Copyright (C) 1996, 1997, 2000, 2001, 
 *                            Nara Institute of Science and Technology
 *                           
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Nara Institute of 
 *      Science and Technology.
 * 4. The name Nara Institute of Science and Technology may not be used to
 *    endorse or promote products derived from this software without specific
 *    prior written permission.
 *    
 *
 * THIS SOFTWARE IS PROVIDED BY Nara Institute of Science and Technology 
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
 * PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE Nara Institute
 * of Science and Technology BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: dartsdic.cpp,v 1.7 2003/02/25 01:39:33 kazuma-t Exp $
 */

#include <darts.h>
extern "C" {
#include <stdlib.h>
#include "dartsdic.h"
#include "chalib.h"
}

struct __darts_t {
    Darts::DoubleArray *da;
    cha_mmap_t *da_mmap;
    cha_mmap_t *lex_mmap;
    cha_mmap_t *dat_mmap;
};

darts_t *
da_open(char *daname, char *lexname, char *datname)
{
    darts_t *da;
    Darts::DoubleArray *darts = new Darts::DoubleArray;

    da->da_mmap = cha_mmap_file(daname);
    darts->setArray(cha_mmap_map(da->da_mmap));
    da = (darts_t*)cha_malloc(sizeof(darts_t));
    da->da = darts;
    da->lex_mmap = cha_mmap_file(lexname);
    da->dat_mmap = cha_mmap_file(datname);

    return da;
}

void
da_lookup(darts_t *da, char *key, int key_len, long *indecies)
{
    int num = da->da
	->commonPrefixSearch(key,
			     (Darts::DoubleArray::result_type*)indecies,
			     key_len);
    indecies[num] = -1;
}

#define lex_map(d) cha_mmap_map((d)->lex_mmap)
#define dat_map(d) cha_mmap_map((d)->dat_mmap)

int
da_get_lex(darts_t *da, long index, da_lex_t *lex_data, int *key_len)
{
    int num, i;

    *key_len = ((unsigned char *)lex_map(da))[index++];
    num = ((unsigned char *)lex_map(da))[index++];
    for (i = 0; i < num; i++) {
	memcpy((void*)(lex_data + i),
	       (void*)((char*)lex_map(da) + index), sizeof(da_lex_t));
	index += sizeof(da_lex_t);
    }

    return num;
}

void
da_get_data(darts_t *da, long index, char **reading, char **pron,
	    char **base, char **info, char**compound)
{
    int reading_len, pron_len, base_len, info_len;

    reading_len = ((unsigned char *)dat_map(da))[index++];
    pron_len = ((unsigned char *)dat_map(da))[index++];
    base_len = ((unsigned char *)dat_map(da))[index++];
    info_len = *((unsigned short *)((unsigned char *)dat_map(da) + index));
    index += sizeof(unsigned short);

    *reading = (char *)dat_map(da) + index;
    index += reading_len + 1;
    *pron = (char *)dat_map(da) + index;
    index += pron_len + 1;
    *base = (char *)dat_map(da) + index;
    index += base_len + 1;
    *info = (char *)dat_map(da) + index;
    index += info_len + 1;
    *compound = (char *)dat_map(da) + index;
}
