/*
 * ARM Limited (ARM) is supplying this software for use with Cortex-M
 * processor based microcontroller, but can be equally used for other
 * suitable processor architectures. This file can be freely distributed.
 * Modifications to this file shall be clearly marked.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS". NO WARRANTIES, WHETHER EXPRESS, IMPLIED
 * OR STATUTORY, INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE.
 * ARM SHALL NOT, IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, OR
 * CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
 *
 * @file     SN32F260_defines.h
 * @brief    CMSIS HeaderFile
 * @version  1.1
 * @date     04. October 2021
 * @note     Generated by SVDConv V3.3.35 on Monday, 04.10.2021 13:03:21
 *           from File 'SN32F260.svd',
 *           last modified on Tuesday, 01.09.2020 10:52:27
 */



/** @addtogroup SONiX Technology Co., Ltd.
  * @{
  */


/** @addtogroup SN32F260
  * @{
  */


#ifndef SN32F260_DEFINES_H
#define SN32F260_DEFINES_H

#ifdef __cplusplus
extern "C" {
#endif


/* =========================================================================================================================== */
/* ================                                Pos/Mask Peripheral Section                                ================ */
/* =========================================================================================================================== */


/** @addtogroup PosMask_peripherals
  * @{
  */

/* =========================================================================================================================== */
/* ================                                          SN_SYS0                                          ================ */
/* =========================================================================================================================== */

/* ========================================================  ANBCTRL  ======================================================== */
#define SN_SYS0_ANBCTRL_IHRCEN_Pos        (0UL)                     /*!< IHRCEN (Bit 0)                                        */
#define SN_SYS0_ANBCTRL_IHRCEN_Msk        (0x1UL)                   /*!< IHRCEN (Bitfield-Mask: 0x01)                          */
/* =========================================================  CSST  ========================================================== */
#define SN_SYS0_CSST_IHRCRDY_Pos          (0UL)                     /*!< IHRCRDY (Bit 0)                                       */
#define SN_SYS0_CSST_IHRCRDY_Msk          (0x1UL)                   /*!< IHRCRDY (Bitfield-Mask: 0x01)                         */
/* ========================================================  CLKCFG  ========================================================= */
#define SN_SYS0_CLKCFG_SYSCLKSEL_Pos      (0UL)                     /*!< SYSCLKSEL (Bit 0)                                     */
#define SN_SYS0_CLKCFG_SYSCLKSEL_Msk      (0x7UL)                   /*!< SYSCLKSEL (Bitfield-Mask: 0x07)                       */
#define SN_SYS0_CLKCFG_SYSCLKST_Pos       (4UL)                     /*!< SYSCLKST (Bit 4)                                      */
#define SN_SYS0_CLKCFG_SYSCLKST_Msk       (0x70UL)                  /*!< SYSCLKST (Bitfield-Mask: 0x07)                        */
/* =========================================================  AHBCP  ========================================================= */
#define SN_SYS0_AHBCP_AHBPRE_Pos          (0UL)                     /*!< AHBPRE (Bit 0)                                        */
#define SN_SYS0_AHBCP_AHBPRE_Msk          (0x7UL)                   /*!< AHBPRE (Bitfield-Mask: 0x07)                          */
/* =========================================================  RSTST  ========================================================= */
#define SN_SYS0_RSTST_SWRSTF_Pos          (0UL)                     /*!< SWRSTF (Bit 0)                                        */
#define SN_SYS0_RSTST_SWRSTF_Msk          (0x1UL)                   /*!< SWRSTF (Bitfield-Mask: 0x01)                          */
#define SN_SYS0_RSTST_WDTRSTF_Pos         (1UL)                     /*!< WDTRSTF (Bit 1)                                       */
#define SN_SYS0_RSTST_WDTRSTF_Msk         (0x2UL)                   /*!< WDTRSTF (Bitfield-Mask: 0x01)                         */
#define SN_SYS0_RSTST_LVDRSTF_Pos         (2UL)                     /*!< LVDRSTF (Bit 2)                                       */
#define SN_SYS0_RSTST_LVDRSTF_Msk         (0x4UL)                   /*!< LVDRSTF (Bitfield-Mask: 0x01)                         */
#define SN_SYS0_RSTST_EXTRSTF_Pos         (3UL)                     /*!< EXTRSTF (Bit 3)                                       */
#define SN_SYS0_RSTST_EXTRSTF_Msk         (0x8UL)                   /*!< EXTRSTF (Bitfield-Mask: 0x01)                         */
#define SN_SYS0_RSTST_PORRSTF_Pos         (4UL)                     /*!< PORRSTF (Bit 4)                                       */
#define SN_SYS0_RSTST_PORRSTF_Msk         (0x10UL)                  /*!< PORRSTF (Bitfield-Mask: 0x01)                         */
/* ========================================================  LVDCTRL  ======================================================== */
#define SN_SYS0_LVDCTRL_LVDRSTLVL_Pos     (0UL)                     /*!< LVDRSTLVL (Bit 0)                                     */
#define SN_SYS0_LVDCTRL_LVDRSTLVL_Msk     (0x7UL)                   /*!< LVDRSTLVL (Bitfield-Mask: 0x07)                       */
#define SN_SYS0_LVDCTRL_LVDINTLVL_Pos     (5UL)                     /*!< LVDINTLVL (Bit 5)                                     */
#define SN_SYS0_LVDCTRL_LVDINTLVL_Msk     (0x60UL)                  /*!< LVDINTLVL (Bitfield-Mask: 0x03)                       */
#define SN_SYS0_LVDCTRL_LVDRSTEN_Pos      (14UL)                    /*!< LVDRSTEN (Bit 14)                                     */
#define SN_SYS0_LVDCTRL_LVDRSTEN_Msk      (0x4000UL)                /*!< LVDRSTEN (Bitfield-Mask: 0x01)                        */
#define SN_SYS0_LVDCTRL_LVDEN_Pos         (15UL)                    /*!< LVDEN (Bit 15)                                        */
#define SN_SYS0_LVDCTRL_LVDEN_Msk         (0x8000UL)                /*!< LVDEN (Bitfield-Mask: 0x01)                           */
/* =======================================================  EXRSTCTRL  ======================================================= */
#define SN_SYS0_EXRSTCTRL_RESETDIS_Pos    (0UL)                     /*!< RESETDIS (Bit 0)                                      */
#define SN_SYS0_EXRSTCTRL_RESETDIS_Msk    (0x1UL)                   /*!< RESETDIS (Bitfield-Mask: 0x01)                        */
/* ========================================================  SWDCTRL  ======================================================== */
#define SN_SYS0_SWDCTRL_SWDDIS_Pos        (0UL)                     /*!< SWDDIS (Bit 0)                                        */
#define SN_SYS0_SWDCTRL_SWDDIS_Msk        (0x1UL)                   /*!< SWDDIS (Bitfield-Mask: 0x01)                          */
/* =========================================================  IVTM  ========================================================== */
#define SN_SYS0_IVTM_IVTM_Pos             (0UL)                     /*!< IVTM (Bit 0)                                          */
#define SN_SYS0_IVTM_IVTM_Msk             (0x3UL)                   /*!< IVTM (Bitfield-Mask: 0x03)                            */
#define SN_SYS0_IVTM_IVTMKEY_Pos          (16UL)                    /*!< IVTMKEY (Bit 16)                                      */
#define SN_SYS0_IVTM_IVTMKEY_Msk          (0xffff0000UL)            /*!< IVTMKEY (Bitfield-Mask: 0xffff)                       */
/* ========================================================  NDTCTRL  ======================================================== */
#define SN_SYS0_NDTCTRL_NDT5V_IE_Pos      (1UL)                     /*!< NDT5V_IE (Bit 1)                                      */
#define SN_SYS0_NDTCTRL_NDT5V_IE_Msk      (0x2UL)                   /*!< NDT5V_IE (Bitfield-Mask: 0x01)                        */
/* ========================================================  NDTSTS  ========================================================= */
#define SN_SYS0_NDTSTS_NDT5V_DET_Pos      (1UL)                     /*!< NDT5V_DET (Bit 1)                                     */
#define SN_SYS0_NDTSTS_NDT5V_DET_Msk      (0x2UL)                   /*!< NDT5V_DET (Bitfield-Mask: 0x01)                       */
/* ========================================================  ANTIEFT  ======================================================== */
#define SN_SYS0_ANTIEFT_AEFT_Pos          (0UL)                     /*!< AEFT (Bit 0)                                          */
#define SN_SYS0_ANTIEFT_AEFT_Msk          (0x7UL)                   /*!< AEFT (Bitfield-Mask: 0x07)                            */


/* =========================================================================================================================== */
/* ================                                          SN_SYS1                                          ================ */
/* =========================================================================================================================== */

/* =======================================================  AHBCLKEN  ======================================================== */
#define SN_SYS1_AHBCLKEN_P0CLKEN_Pos      (0UL)                     /*!< P0CLKEN (Bit 0)                                       */
#define SN_SYS1_AHBCLKEN_P0CLKEN_Msk      (0x1UL)                   /*!< P0CLKEN (Bitfield-Mask: 0x01)                         */
#define SN_SYS1_AHBCLKEN_P1CLKEN_Pos      (1UL)                     /*!< P1CLKEN (Bit 1)                                       */
#define SN_SYS1_AHBCLKEN_P1CLKEN_Msk      (0x2UL)                   /*!< P1CLKEN (Bitfield-Mask: 0x01)                         */
#define SN_SYS1_AHBCLKEN_P2CLKEN_Pos      (2UL)                     /*!< P2CLKEN (Bit 2)                                       */
#define SN_SYS1_AHBCLKEN_P2CLKEN_Msk      (0x4UL)                   /*!< P2CLKEN (Bitfield-Mask: 0x01)                         */
#define SN_SYS1_AHBCLKEN_P3CLKEN_Pos      (3UL)                     /*!< P3CLKEN (Bit 3)                                       */
#define SN_SYS1_AHBCLKEN_P3CLKEN_Msk      (0x8UL)                   /*!< P3CLKEN (Bitfield-Mask: 0x01)                         */
#define SN_SYS1_AHBCLKEN_USBCLKEN_Pos     (4UL)                     /*!< USBCLKEN (Bit 4)                                      */
#define SN_SYS1_AHBCLKEN_USBCLKEN_Msk     (0x10UL)                  /*!< USBCLKEN (Bitfield-Mask: 0x01)                        */
#define SN_SYS1_AHBCLKEN_CT16B0CLKEN_Pos  (6UL)                     /*!< CT16B0CLKEN (Bit 6)                                   */
#define SN_SYS1_AHBCLKEN_CT16B0CLKEN_Msk  (0x40UL)                  /*!< CT16B0CLKEN (Bitfield-Mask: 0x01)                     */
#define SN_SYS1_AHBCLKEN_CT16B1CLKEN_Pos  (7UL)                     /*!< CT16B1CLKEN (Bit 7)                                   */
#define SN_SYS1_AHBCLKEN_CT16B1CLKEN_Msk  (0x80UL)                  /*!< CT16B1CLKEN (Bitfield-Mask: 0x01)                     */
#define SN_SYS1_AHBCLKEN_SPI0CLKEN_Pos    (12UL)                    /*!< SPI0CLKEN (Bit 12)                                    */
#define SN_SYS1_AHBCLKEN_SPI0CLKEN_Msk    (0x1000UL)                /*!< SPI0CLKEN (Bitfield-Mask: 0x01)                       */
#define SN_SYS1_AHBCLKEN_I2C0CLKEN_Pos    (21UL)                    /*!< I2C0CLKEN (Bit 21)                                    */
#define SN_SYS1_AHBCLKEN_I2C0CLKEN_Msk    (0x200000UL)              /*!< I2C0CLKEN (Bitfield-Mask: 0x01)                       */
#define SN_SYS1_AHBCLKEN_WDTCLKEN_Pos     (24UL)                    /*!< WDTCLKEN (Bit 24)                                     */
#define SN_SYS1_AHBCLKEN_WDTCLKEN_Msk     (0x1000000UL)             /*!< WDTCLKEN (Bitfield-Mask: 0x01)                        */
#define SN_SYS1_AHBCLKEN_CLKOUTSEL_Pos    (28UL)                    /*!< CLKOUTSEL (Bit 28)                                    */
#define SN_SYS1_AHBCLKEN_CLKOUTSEL_Msk    (0x70000000UL)            /*!< CLKOUTSEL (Bitfield-Mask: 0x07)                       */
/* ========================================================  APBCP1  ========================================================= */
#define SN_SYS1_APBCP1_SYSTICKPRE_Pos     (16UL)                    /*!< SYSTICKPRE (Bit 16)                                   */
#define SN_SYS1_APBCP1_SYSTICKPRE_Msk     (0x30000UL)               /*!< SYSTICKPRE (Bitfield-Mask: 0x03)                      */
#define SN_SYS1_APBCP1_WDTPRE_Pos         (20UL)                    /*!< WDTPRE (Bit 20)                                       */
#define SN_SYS1_APBCP1_WDTPRE_Msk         (0x700000UL)              /*!< WDTPRE (Bitfield-Mask: 0x07)                          */
#define SN_SYS1_APBCP1_CLKOUTPRE_Pos      (28UL)                    /*!< CLKOUTPRE (Bit 28)                                    */
#define SN_SYS1_APBCP1_CLKOUTPRE_Msk      (0x70000000UL)            /*!< CLKOUTPRE (Bitfield-Mask: 0x07)                       */


/* =========================================================================================================================== */
/* ================                                          SN_USB                                           ================ */
/* =========================================================================================================================== */

/* =========================================================  INTEN  ========================================================= */
#define SN_USB_INTEN_EP1_NAK_EN_Pos       (0UL)                     /*!< EP1_NAK_EN (Bit 0)                                    */
#define SN_USB_INTEN_EP1_NAK_EN_Msk       (0x1UL)                   /*!< EP1_NAK_EN (Bitfield-Mask: 0x01)                      */
#define SN_USB_INTEN_EP2_NAK_EN_Pos       (1UL)                     /*!< EP2_NAK_EN (Bit 1)                                    */
#define SN_USB_INTEN_EP2_NAK_EN_Msk       (0x2UL)                   /*!< EP2_NAK_EN (Bitfield-Mask: 0x01)                      */
#define SN_USB_INTEN_EP3_NAK_EN_Pos       (2UL)                     /*!< EP3_NAK_EN (Bit 2)                                    */
#define SN_USB_INTEN_EP3_NAK_EN_Msk       (0x4UL)                   /*!< EP3_NAK_EN (Bitfield-Mask: 0x01)                      */
#define SN_USB_INTEN_EP4_NAK_EN_Pos       (3UL)                     /*!< EP4_NAK_EN (Bit 3)                                    */
#define SN_USB_INTEN_EP4_NAK_EN_Msk       (0x8UL)                   /*!< EP4_NAK_EN (Bitfield-Mask: 0x01)                      */
#define SN_USB_INTEN_EPN_ACK_EN_Pos       (4UL)                     /*!< EPN_ACK_EN (Bit 4)                                    */
#define SN_USB_INTEN_EPN_ACK_EN_Msk       (0x10UL)                  /*!< EPN_ACK_EN (Bitfield-Mask: 0x01)                      */
#define SN_USB_INTEN_BUSWK_IE_Pos         (28UL)                    /*!< BUSWK_IE (Bit 28)                                     */
#define SN_USB_INTEN_BUSWK_IE_Msk         (0x10000000UL)            /*!< BUSWK_IE (Bitfield-Mask: 0x01)                        */
#define SN_USB_INTEN_USB_IE_Pos           (29UL)                    /*!< USB_IE (Bit 29)                                       */
#define SN_USB_INTEN_USB_IE_Msk           (0x20000000UL)            /*!< USB_IE (Bitfield-Mask: 0x01)                          */
#define SN_USB_INTEN_USB_SOF_IE_Pos       (30UL)                    /*!< USB_SOF_IE (Bit 30)                                   */
#define SN_USB_INTEN_USB_SOF_IE_Msk       (0x40000000UL)            /*!< USB_SOF_IE (Bitfield-Mask: 0x01)                      */
#define SN_USB_INTEN_BUS_IE_Pos           (31UL)                    /*!< BUS_IE (Bit 31)                                       */
#define SN_USB_INTEN_BUS_IE_Msk           (0x80000000UL)            /*!< BUS_IE (Bitfield-Mask: 0x01)                          */
/* =========================================================  INSTS  ========================================================= */
#define SN_USB_INSTS_EP1_NAK_Pos          (0UL)                     /*!< EP1_NAK (Bit 0)                                       */
#define SN_USB_INSTS_EP1_NAK_Msk          (0x1UL)                   /*!< EP1_NAK (Bitfield-Mask: 0x01)                         */
#define SN_USB_INSTS_EP2_NAK_Pos          (1UL)                     /*!< EP2_NAK (Bit 1)                                       */
#define SN_USB_INSTS_EP2_NAK_Msk          (0x2UL)                   /*!< EP2_NAK (Bitfield-Mask: 0x01)                         */
#define SN_USB_INSTS_EP3_NAK_Pos          (2UL)                     /*!< EP3_NAK (Bit 2)                                       */
#define SN_USB_INSTS_EP3_NAK_Msk          (0x4UL)                   /*!< EP3_NAK (Bitfield-Mask: 0x01)                         */
#define SN_USB_INSTS_EP4_NAK_Pos          (3UL)                     /*!< EP4_NAK (Bit 3)                                       */
#define SN_USB_INSTS_EP4_NAK_Msk          (0x8UL)                   /*!< EP4_NAK (Bitfield-Mask: 0x01)                         */
#define SN_USB_INSTS_EP1_ACK_Pos          (8UL)                     /*!< EP1_ACK (Bit 8)                                       */
#define SN_USB_INSTS_EP1_ACK_Msk          (0x100UL)                 /*!< EP1_ACK (Bitfield-Mask: 0x01)                         */
#define SN_USB_INSTS_EP2_ACK_Pos          (9UL)                     /*!< EP2_ACK (Bit 9)                                       */
#define SN_USB_INSTS_EP2_ACK_Msk          (0x200UL)                 /*!< EP2_ACK (Bitfield-Mask: 0x01)                         */
#define SN_USB_INSTS_EP3_ACK_Pos          (10UL)                    /*!< EP3_ACK (Bit 10)                                      */
#define SN_USB_INSTS_EP3_ACK_Msk          (0x400UL)                 /*!< EP3_ACK (Bitfield-Mask: 0x01)                         */
#define SN_USB_INSTS_EP4_ACK_Pos          (11UL)                    /*!< EP4_ACK (Bit 11)                                      */
#define SN_USB_INSTS_EP4_ACK_Msk          (0x800UL)                 /*!< EP4_ACK (Bitfield-Mask: 0x01)                         */
#define SN_USB_INSTS_ERR_TIMEOUT_Pos      (17UL)                    /*!< ERR_TIMEOUT (Bit 17)                                  */
#define SN_USB_INSTS_ERR_TIMEOUT_Msk      (0x20000UL)               /*!< ERR_TIMEOUT (Bitfield-Mask: 0x01)                     */
#define SN_USB_INSTS_ERR_SETUP_Pos        (18UL)                    /*!< ERR_SETUP (Bit 18)                                    */
#define SN_USB_INSTS_ERR_SETUP_Msk        (0x40000UL)               /*!< ERR_SETUP (Bitfield-Mask: 0x01)                       */
#define SN_USB_INSTS_EP0_OUT_STALL_Pos    (19UL)                    /*!< EP0_OUT_STALL (Bit 19)                                */
#define SN_USB_INSTS_EP0_OUT_STALL_Msk    (0x80000UL)               /*!< EP0_OUT_STALL (Bitfield-Mask: 0x01)                   */
#define SN_USB_INSTS_EP0_IN_STALL_Pos     (20UL)                    /*!< EP0_IN_STALL (Bit 20)                                 */
#define SN_USB_INSTS_EP0_IN_STALL_Msk     (0x100000UL)              /*!< EP0_IN_STALL (Bitfield-Mask: 0x01)                    */
#define SN_USB_INSTS_EP0_OUT_Pos          (21UL)                    /*!< EP0_OUT (Bit 21)                                      */
#define SN_USB_INSTS_EP0_OUT_Msk          (0x200000UL)              /*!< EP0_OUT (Bitfield-Mask: 0x01)                         */
#define SN_USB_INSTS_EP0_IN_Pos           (22UL)                    /*!< EP0_IN (Bit 22)                                       */
#define SN_USB_INSTS_EP0_IN_Msk           (0x400000UL)              /*!< EP0_IN (Bitfield-Mask: 0x01)                          */
#define SN_USB_INSTS_EP0_SETUP_Pos        (23UL)                    /*!< EP0_SETUP (Bit 23)                                    */
#define SN_USB_INSTS_EP0_SETUP_Msk        (0x800000UL)              /*!< EP0_SETUP (Bitfield-Mask: 0x01)                       */
#define SN_USB_INSTS_EP0_PRESETUP_Pos     (24UL)                    /*!< EP0_PRESETUP (Bit 24)                                 */
#define SN_USB_INSTS_EP0_PRESETUP_Msk     (0x1000000UL)             /*!< EP0_PRESETUP (Bitfield-Mask: 0x01)                    */
#define SN_USB_INSTS_USB_SOF_Pos          (26UL)                    /*!< USB_SOF (Bit 26)                                      */
#define SN_USB_INSTS_USB_SOF_Msk          (0x4000000UL)             /*!< USB_SOF (Bitfield-Mask: 0x01)                         */
#define SN_USB_INSTS_BUS_RESUME_Pos       (29UL)                    /*!< BUS_RESUME (Bit 29)                                   */
#define SN_USB_INSTS_BUS_RESUME_Msk       (0x20000000UL)            /*!< BUS_RESUME (Bitfield-Mask: 0x01)                      */
#define SN_USB_INSTS_BUS_SUSPEND_Pos      (30UL)                    /*!< BUS_SUSPEND (Bit 30)                                  */
#define SN_USB_INSTS_BUS_SUSPEND_Msk      (0x40000000UL)            /*!< BUS_SUSPEND (Bitfield-Mask: 0x01)                     */
#define SN_USB_INSTS_BUS_RESET_Pos        (31UL)                    /*!< BUS_RESET (Bit 31)                                    */
#define SN_USB_INSTS_BUS_RESET_Msk        (0x80000000UL)            /*!< BUS_RESET (Bitfield-Mask: 0x01)                       */
/* ========================================================  INSTSC  ========================================================= */
#define SN_USB_INSTSC_EP1_NAKC_Pos        (0UL)                     /*!< EP1_NAKC (Bit 0)                                      */
#define SN_USB_INSTSC_EP1_NAKC_Msk        (0x1UL)                   /*!< EP1_NAKC (Bitfield-Mask: 0x01)                        */
#define SN_USB_INSTSC_EP2_NAKC_Pos        (1UL)                     /*!< EP2_NAKC (Bit 1)                                      */
#define SN_USB_INSTSC_EP2_NAKC_Msk        (0x2UL)                   /*!< EP2_NAKC (Bitfield-Mask: 0x01)                        */
#define SN_USB_INSTSC_EP3_NAKC_Pos        (2UL)                     /*!< EP3_NAKC (Bit 2)                                      */
#define SN_USB_INSTSC_EP3_NAKC_Msk        (0x4UL)                   /*!< EP3_NAKC (Bitfield-Mask: 0x01)                        */
#define SN_USB_INSTSC_EP4_NAKC_Pos        (3UL)                     /*!< EP4_NAKC (Bit 3)                                      */
#define SN_USB_INSTSC_EP4_NAKC_Msk        (0x8UL)                   /*!< EP4_NAKC (Bitfield-Mask: 0x01)                        */
#define SN_USB_INSTSC_EP1_ACKC_Pos        (8UL)                     /*!< EP1_ACKC (Bit 8)                                      */
#define SN_USB_INSTSC_EP1_ACKC_Msk        (0x100UL)                 /*!< EP1_ACKC (Bitfield-Mask: 0x01)                        */
#define SN_USB_INSTSC_EP2_ACKC_Pos        (9UL)                     /*!< EP2_ACKC (Bit 9)                                      */
#define SN_USB_INSTSC_EP2_ACKC_Msk        (0x200UL)                 /*!< EP2_ACKC (Bitfield-Mask: 0x01)                        */
#define SN_USB_INSTSC_EP3_ACKC_Pos        (10UL)                    /*!< EP3_ACKC (Bit 10)                                     */
#define SN_USB_INSTSC_EP3_ACKC_Msk        (0x400UL)                 /*!< EP3_ACKC (Bitfield-Mask: 0x01)                        */
#define SN_USB_INSTSC_EP4_ACKC_Pos        (11UL)                    /*!< EP4_ACKC (Bit 11)                                     */
#define SN_USB_INSTSC_EP4_ACKC_Msk        (0x800UL)                 /*!< EP4_ACKC (Bitfield-Mask: 0x01)                        */
#define SN_USB_INSTSC_ERR_TIMEOUTC_Pos    (17UL)                    /*!< ERR_TIMEOUTC (Bit 17)                                 */
#define SN_USB_INSTSC_ERR_TIMEOUTC_Msk    (0x20000UL)               /*!< ERR_TIMEOUTC (Bitfield-Mask: 0x01)                    */
#define SN_USB_INSTSC_ERR_SETUPC_Pos      (18UL)                    /*!< ERR_SETUPC (Bit 18)                                   */
#define SN_USB_INSTSC_ERR_SETUPC_Msk      (0x40000UL)               /*!< ERR_SETUPC (Bitfield-Mask: 0x01)                      */
#define SN_USB_INSTSC_EP0_OUT_STALLC_Pos  (19UL)                    /*!< EP0_OUT_STALLC (Bit 19)                               */
#define SN_USB_INSTSC_EP0_OUT_STALLC_Msk  (0x80000UL)               /*!< EP0_OUT_STALLC (Bitfield-Mask: 0x01)                  */
#define SN_USB_INSTSC_EP0_IN_STALLC_Pos   (20UL)                    /*!< EP0_IN_STALLC (Bit 20)                                */
#define SN_USB_INSTSC_EP0_IN_STALLC_Msk   (0x100000UL)              /*!< EP0_IN_STALLC (Bitfield-Mask: 0x01)                   */
#define SN_USB_INSTSC_EP0_OUTC_Pos        (21UL)                    /*!< EP0_OUTC (Bit 21)                                     */
#define SN_USB_INSTSC_EP0_OUTC_Msk        (0x200000UL)              /*!< EP0_OUTC (Bitfield-Mask: 0x01)                        */
#define SN_USB_INSTSC_EP0_INC_Pos         (22UL)                    /*!< EP0_INC (Bit 22)                                      */
#define SN_USB_INSTSC_EP0_INC_Msk         (0x400000UL)              /*!< EP0_INC (Bitfield-Mask: 0x01)                         */
#define SN_USB_INSTSC_EP0_SETUPC_Pos      (23UL)                    /*!< EP0_SETUPC (Bit 23)                                   */
#define SN_USB_INSTSC_EP0_SETUPC_Msk      (0x800000UL)              /*!< EP0_SETUPC (Bitfield-Mask: 0x01)                      */
#define SN_USB_INSTSC_EP0_PRESETUPC_Pos   (24UL)                    /*!< EP0_PRESETUPC (Bit 24)                                */
#define SN_USB_INSTSC_EP0_PRESETUPC_Msk   (0x1000000UL)             /*!< EP0_PRESETUPC (Bitfield-Mask: 0x01)                   */
#define SN_USB_INSTSC_BUS_WAKEUPC_Pos     (25UL)                    /*!< BUS_WAKEUPC (Bit 25)                                  */
#define SN_USB_INSTSC_BUS_WAKEUPC_Msk     (0x2000000UL)             /*!< BUS_WAKEUPC (Bitfield-Mask: 0x01)                     */
#define SN_USB_INSTSC_USB_SOFC_Pos        (26UL)                    /*!< USB_SOFC (Bit 26)                                     */
#define SN_USB_INSTSC_USB_SOFC_Msk        (0x4000000UL)             /*!< USB_SOFC (Bitfield-Mask: 0x01)                        */
#define SN_USB_INSTSC_BUS_RESUMEC_Pos     (29UL)                    /*!< BUS_RESUMEC (Bit 29)                                  */
#define SN_USB_INSTSC_BUS_RESUMEC_Msk     (0x20000000UL)            /*!< BUS_RESUMEC (Bitfield-Mask: 0x01)                     */
#define SN_USB_INSTSC_BUS_RESETC_Pos      (31UL)                    /*!< BUS_RESETC (Bit 31)                                   */
#define SN_USB_INSTSC_BUS_RESETC_Msk      (0x80000000UL)            /*!< BUS_RESETC (Bitfield-Mask: 0x01)                      */
/* =========================================================  ADDR  ========================================================== */
#define SN_USB_ADDR_UADDR_Pos             (0UL)                     /*!< UADDR (Bit 0)                                         */
#define SN_USB_ADDR_UADDR_Msk             (0x7fUL)                  /*!< UADDR (Bitfield-Mask: 0x7f)                           */
/* ==========================================================  CFG  ========================================================== */
#define SN_USB_CFG_EP1_DIR_Pos            (0UL)                     /*!< EP1_DIR (Bit 0)                                       */
#define SN_USB_CFG_EP1_DIR_Msk            (0x1UL)                   /*!< EP1_DIR (Bitfield-Mask: 0x01)                         */
#define SN_USB_CFG_EP2_DIR_Pos            (1UL)                     /*!< EP2_DIR (Bit 1)                                       */
#define SN_USB_CFG_EP2_DIR_Msk            (0x2UL)                   /*!< EP2_DIR (Bitfield-Mask: 0x01)                         */
#define SN_USB_CFG_EP3_DIR_Pos            (2UL)                     /*!< EP3_DIR (Bit 2)                                       */
#define SN_USB_CFG_EP3_DIR_Msk            (0x4UL)                   /*!< EP3_DIR (Bitfield-Mask: 0x01)                         */
#define SN_USB_CFG_EP4_DIR_Pos            (3UL)                     /*!< EP4_DIR (Bit 3)                                       */
#define SN_USB_CFG_EP4_DIR_Msk            (0x8UL)                   /*!< EP4_DIR (Bitfield-Mask: 0x01)                         */
#define SN_USB_CFG_DIS_PDEN_Pos           (26UL)                    /*!< DIS_PDEN (Bit 26)                                     */
#define SN_USB_CFG_DIS_PDEN_Msk           (0x4000000UL)             /*!< DIS_PDEN (Bitfield-Mask: 0x01)                        */
#define SN_USB_CFG_ESD_EN_Pos             (27UL)                    /*!< ESD_EN (Bit 27)                                       */
#define SN_USB_CFG_ESD_EN_Msk             (0x8000000UL)             /*!< ESD_EN (Bitfield-Mask: 0x01)                          */
#define SN_USB_CFG_SIE_EN_Pos             (28UL)                    /*!< SIE_EN (Bit 28)                                       */
#define SN_USB_CFG_SIE_EN_Msk             (0x10000000UL)            /*!< SIE_EN (Bitfield-Mask: 0x01)                          */
#define SN_USB_CFG_DPPU_EN_Pos            (29UL)                    /*!< DPPU_EN (Bit 29)                                      */
#define SN_USB_CFG_DPPU_EN_Msk            (0x20000000UL)            /*!< DPPU_EN (Bitfield-Mask: 0x01)                         */
#define SN_USB_CFG_PHY_EN_Pos             (30UL)                    /*!< PHY_EN (Bit 30)                                       */
#define SN_USB_CFG_PHY_EN_Msk             (0x40000000UL)            /*!< PHY_EN (Bitfield-Mask: 0x01)                          */
#define SN_USB_CFG_VREG33_EN_Pos          (31UL)                    /*!< VREG33_EN (Bit 31)                                    */
#define SN_USB_CFG_VREG33_EN_Msk          (0x80000000UL)            /*!< VREG33_EN (Bitfield-Mask: 0x01)                       */
/* =========================================================  SGCTL  ========================================================= */
#define SN_USB_SGCTL_BUS_DN_Pos           (0UL)                     /*!< BUS_DN (Bit 0)                                        */
#define SN_USB_SGCTL_BUS_DN_Msk           (0x1UL)                   /*!< BUS_DN (Bitfield-Mask: 0x01)                          */
#define SN_USB_SGCTL_BUS_DP_Pos           (1UL)                     /*!< BUS_DP (Bit 1)                                        */
#define SN_USB_SGCTL_BUS_DP_Msk           (0x2UL)                   /*!< BUS_DP (Bitfield-Mask: 0x01)                          */
#define SN_USB_SGCTL_BUS_DRVEN_Pos        (2UL)                     /*!< BUS_DRVEN (Bit 2)                                     */
#define SN_USB_SGCTL_BUS_DRVEN_Msk        (0x4UL)                   /*!< BUS_DRVEN (Bitfield-Mask: 0x01)                       */
/* ========================================================  EP0CTL  ========================================================= */
#define SN_USB_EP0CTL_ENDP_CNT_Pos        (0UL)                     /*!< ENDP_CNT (Bit 0)                                      */
#define SN_USB_EP0CTL_ENDP_CNT_Msk        (0x7fUL)                  /*!< ENDP_CNT (Bitfield-Mask: 0x7f)                        */
#define SN_USB_EP0CTL_OUT_STALL_EN_Pos    (27UL)                    /*!< OUT_STALL_EN (Bit 27)                                 */
#define SN_USB_EP0CTL_OUT_STALL_EN_Msk    (0x8000000UL)             /*!< OUT_STALL_EN (Bitfield-Mask: 0x01)                    */
#define SN_USB_EP0CTL_IN_STALL_EN_Pos     (28UL)                    /*!< IN_STALL_EN (Bit 28)                                  */
#define SN_USB_EP0CTL_IN_STALL_EN_Msk     (0x10000000UL)            /*!< IN_STALL_EN (Bitfield-Mask: 0x01)                     */
#define SN_USB_EP0CTL_ENDP_STATE_Pos      (29UL)                    /*!< ENDP_STATE (Bit 29)                                   */
#define SN_USB_EP0CTL_ENDP_STATE_Msk      (0x60000000UL)            /*!< ENDP_STATE (Bitfield-Mask: 0x03)                      */
#define SN_USB_EP0CTL_ENDP_EN_Pos         (31UL)                    /*!< ENDP_EN (Bit 31)                                      */
#define SN_USB_EP0CTL_ENDP_EN_Msk         (0x80000000UL)            /*!< ENDP_EN (Bitfield-Mask: 0x01)                         */
/* ========================================================  EP1CTL  ========================================================= */
#define SN_USB_EP1CTL_ENDP_CNT_Pos        (0UL)                     /*!< ENDP_CNT (Bit 0)                                      */
#define SN_USB_EP1CTL_ENDP_CNT_Msk        (0x7fUL)                  /*!< ENDP_CNT (Bitfield-Mask: 0x7f)                        */
#define SN_USB_EP1CTL_ENDP_STATE_Pos      (29UL)                    /*!< ENDP_STATE (Bit 29)                                   */
#define SN_USB_EP1CTL_ENDP_STATE_Msk      (0x60000000UL)            /*!< ENDP_STATE (Bitfield-Mask: 0x03)                      */
#define SN_USB_EP1CTL_ENDP_EN_Pos         (31UL)                    /*!< ENDP_EN (Bit 31)                                      */
#define SN_USB_EP1CTL_ENDP_EN_Msk         (0x80000000UL)            /*!< ENDP_EN (Bitfield-Mask: 0x01)                         */
/* ========================================================  EP2CTL  ========================================================= */
#define SN_USB_EP2CTL_ENDP_CNT_Pos        (0UL)                     /*!< ENDP_CNT (Bit 0)                                      */
#define SN_USB_EP2CTL_ENDP_CNT_Msk        (0x7fUL)                  /*!< ENDP_CNT (Bitfield-Mask: 0x7f)                        */
#define SN_USB_EP2CTL_ENDP_STATE_Pos      (29UL)                    /*!< ENDP_STATE (Bit 29)                                   */
#define SN_USB_EP2CTL_ENDP_STATE_Msk      (0x60000000UL)            /*!< ENDP_STATE (Bitfield-Mask: 0x03)                      */
#define SN_USB_EP2CTL_ENDP_EN_Pos         (31UL)                    /*!< ENDP_EN (Bit 31)                                      */
#define SN_USB_EP2CTL_ENDP_EN_Msk         (0x80000000UL)            /*!< ENDP_EN (Bitfield-Mask: 0x01)                         */
/* ========================================================  EP3CTL  ========================================================= */
#define SN_USB_EP3CTL_ENDP_CNT_Pos        (0UL)                     /*!< ENDP_CNT (Bit 0)                                      */
#define SN_USB_EP3CTL_ENDP_CNT_Msk        (0x7fUL)                  /*!< ENDP_CNT (Bitfield-Mask: 0x7f)                        */
#define SN_USB_EP3CTL_ENDP_STATE_Pos      (29UL)                    /*!< ENDP_STATE (Bit 29)                                   */
#define SN_USB_EP3CTL_ENDP_STATE_Msk      (0x60000000UL)            /*!< ENDP_STATE (Bitfield-Mask: 0x03)                      */
#define SN_USB_EP3CTL_ENDP_EN_Pos         (31UL)                    /*!< ENDP_EN (Bit 31)                                      */
#define SN_USB_EP3CTL_ENDP_EN_Msk         (0x80000000UL)            /*!< ENDP_EN (Bitfield-Mask: 0x01)                         */
/* ========================================================  EP4CTL  ========================================================= */
#define SN_USB_EP4CTL_ENDP_CNT_Pos        (0UL)                     /*!< ENDP_CNT (Bit 0)                                      */
#define SN_USB_EP4CTL_ENDP_CNT_Msk        (0x7fUL)                  /*!< ENDP_CNT (Bitfield-Mask: 0x7f)                        */
#define SN_USB_EP4CTL_ENDP_STATE_Pos      (29UL)                    /*!< ENDP_STATE (Bit 29)                                   */
#define SN_USB_EP4CTL_ENDP_STATE_Msk      (0x60000000UL)            /*!< ENDP_STATE (Bitfield-Mask: 0x03)                      */
#define SN_USB_EP4CTL_ENDP_EN_Pos         (31UL)                    /*!< ENDP_EN (Bit 31)                                      */
#define SN_USB_EP4CTL_ENDP_EN_Msk         (0x80000000UL)            /*!< ENDP_EN (Bitfield-Mask: 0x01)                         */
/* =======================================================  EPTOGGLE  ======================================================== */
#define SN_USB_EPTOGGLE_ENDP1_DATA01_Pos  (0UL)                     /*!< ENDP1_DATA01 (Bit 0)                                  */
#define SN_USB_EPTOGGLE_ENDP1_DATA01_Msk  (0x1UL)                   /*!< ENDP1_DATA01 (Bitfield-Mask: 0x01)                    */
#define SN_USB_EPTOGGLE_ENDP2_DATA01_Pos  (1UL)                     /*!< ENDP2_DATA01 (Bit 1)                                  */
#define SN_USB_EPTOGGLE_ENDP2_DATA01_Msk  (0x2UL)                   /*!< ENDP2_DATA01 (Bitfield-Mask: 0x01)                    */
#define SN_USB_EPTOGGLE_ENDP3_DATA01_Pos  (2UL)                     /*!< ENDP3_DATA01 (Bit 2)                                  */
#define SN_USB_EPTOGGLE_ENDP3_DATA01_Msk  (0x4UL)                   /*!< ENDP3_DATA01 (Bitfield-Mask: 0x01)                    */
#define SN_USB_EPTOGGLE_ENDP4_DATA01_Pos  (3UL)                     /*!< ENDP4_DATA01 (Bit 3)                                  */
#define SN_USB_EPTOGGLE_ENDP4_DATA01_Msk  (0x8UL)                   /*!< ENDP4_DATA01 (Bitfield-Mask: 0x01)                    */
/* =======================================================  EP1BUFOS  ======================================================== */
#define SN_USB_EP1BUFOS_OFFSET_Pos        (2UL)                     /*!< OFFSET (Bit 2)                                        */
#define SN_USB_EP1BUFOS_OFFSET_Msk        (0x1fcUL)                 /*!< OFFSET (Bitfield-Mask: 0x7f)                          */
/* =======================================================  EP2BUFOS  ======================================================== */
#define SN_USB_EP2BUFOS_OFFSET_Pos        (2UL)                     /*!< OFFSET (Bit 2)                                        */
#define SN_USB_EP2BUFOS_OFFSET_Msk        (0x1fcUL)                 /*!< OFFSET (Bitfield-Mask: 0x7f)                          */
/* =======================================================  EP3BUFOS  ======================================================== */
#define SN_USB_EP3BUFOS_OFFSET_Pos        (2UL)                     /*!< OFFSET (Bit 2)                                        */
#define SN_USB_EP3BUFOS_OFFSET_Msk        (0x1fcUL)                 /*!< OFFSET (Bitfield-Mask: 0x7f)                          */
/* =======================================================  EP4BUFOS  ======================================================== */
#define SN_USB_EP4BUFOS_OFFSET_Pos        (2UL)                     /*!< OFFSET (Bit 2)                                        */
#define SN_USB_EP4BUFOS_OFFSET_Msk        (0x1fcUL)                 /*!< OFFSET (Bitfield-Mask: 0x7f)                          */
/* =========================================================  FRMNO  ========================================================= */
#define SN_USB_FRMNO_FRAME_NO_Pos         (0UL)                     /*!< FRAME_NO (Bit 0)                                      */
#define SN_USB_FRMNO_FRAME_NO_Msk         (0x7ffUL)                 /*!< FRAME_NO (Bitfield-Mask: 0x7ff)                       */
/* ========================================================  PHYPRM  ========================================================= */
#define SN_USB_PHYPRM_PHY_PARAM_Pos       (0UL)                     /*!< PHY_PARAM (Bit 0)                                     */
#define SN_USB_PHYPRM_PHY_PARAM_Msk       (0x3fUL)                  /*!< PHY_PARAM (Bitfield-Mask: 0x3f)                       */
/* ========================================================  PHYPRM2  ======================================================== */
#define SN_USB_PHYPRM2_PHY_PS_Pos         (0UL)                     /*!< PHY_PS (Bit 0)                                        */
#define SN_USB_PHYPRM2_PHY_PS_Msk         (0x7fffUL)                /*!< PHY_PS (Bitfield-Mask: 0x7fff)                        */
/* ========================================================  PS2CTL  ========================================================= */
#define SN_USB_PS2CTL_SCKM_Pos            (0UL)                     /*!< SCKM (Bit 0)                                          */
#define SN_USB_PS2CTL_SCKM_Msk            (0x1UL)                   /*!< SCKM (Bitfield-Mask: 0x01)                            */
#define SN_USB_PS2CTL_SDAM_Pos            (1UL)                     /*!< SDAM (Bit 1)                                          */
#define SN_USB_PS2CTL_SDAM_Msk            (0x2UL)                   /*!< SDAM (Bitfield-Mask: 0x01)                            */
#define SN_USB_PS2CTL_SCK_Pos             (2UL)                     /*!< SCK (Bit 2)                                           */
#define SN_USB_PS2CTL_SCK_Msk             (0x4UL)                   /*!< SCK (Bitfield-Mask: 0x01)                             */
#define SN_USB_PS2CTL_SDA_Pos             (3UL)                     /*!< SDA (Bit 3)                                           */
#define SN_USB_PS2CTL_SDA_Msk             (0x8UL)                   /*!< SDA (Bitfield-Mask: 0x01)                             */
#define SN_USB_PS2CTL_PS2ENB_Pos          (31UL)                    /*!< PS2ENB (Bit 31)                                       */
#define SN_USB_PS2CTL_PS2ENB_Msk          (0x80000000UL)            /*!< PS2ENB (Bitfield-Mask: 0x01)                          */
/* ========================================================  RWADDR  ========================================================= */
#define SN_USB_RWADDR_RWADDR_Pos          (2UL)                     /*!< RWADDR (Bit 2)                                        */
#define SN_USB_RWADDR_RWADDR_Msk          (0xfcUL)                  /*!< RWADDR (Bitfield-Mask: 0x3f)                          */
/* ========================================================  RWDATA  ========================================================= */
#define SN_USB_RWDATA_RWDATA_Pos          (0UL)                     /*!< RWDATA (Bit 0)                                        */
#define SN_USB_RWDATA_RWDATA_Msk          (0xffffffffUL)            /*!< RWDATA (Bitfield-Mask: 0xffffffff)                    */
/* =======================================================  RWSTATUS  ======================================================== */
#define SN_USB_RWSTATUS_W_STATUS_Pos      (0UL)                     /*!< W_STATUS (Bit 0)                                      */
#define SN_USB_RWSTATUS_W_STATUS_Msk      (0x1UL)                   /*!< W_STATUS (Bitfield-Mask: 0x01)                        */
#define SN_USB_RWSTATUS_R_STATUS_Pos      (1UL)                     /*!< R_STATUS (Bit 1)                                      */
#define SN_USB_RWSTATUS_R_STATUS_Msk      (0x2UL)                   /*!< R_STATUS (Bitfield-Mask: 0x01)                        */
/* ========================================================  RWADDR2  ======================================================== */
#define SN_USB_RWADDR2_RWADDR_Pos         (2UL)                     /*!< RWADDR (Bit 2)                                        */
#define SN_USB_RWADDR2_RWADDR_Msk         (0xfcUL)                  /*!< RWADDR (Bitfield-Mask: 0x3f)                          */
/* ========================================================  RWDATA2  ======================================================== */
#define SN_USB_RWDATA2_RWDATA_Pos         (0UL)                     /*!< RWDATA (Bit 0)                                        */
#define SN_USB_RWDATA2_RWDATA_Msk         (0xffffffffUL)            /*!< RWDATA (Bitfield-Mask: 0xffffffff)                    */
/* =======================================================  RWSTATUS2  ======================================================= */
#define SN_USB_RWSTATUS2_W_STATUS_Pos     (0UL)                     /*!< W_STATUS (Bit 0)                                      */
#define SN_USB_RWSTATUS2_W_STATUS_Msk     (0x1UL)                   /*!< W_STATUS (Bitfield-Mask: 0x01)                        */
#define SN_USB_RWSTATUS2_R_STATUS_Pos     (1UL)                     /*!< R_STATUS (Bit 1)                                      */
#define SN_USB_RWSTATUS2_R_STATUS_Msk     (0x2UL)                   /*!< R_STATUS (Bitfield-Mask: 0x01)                        */


/* =========================================================================================================================== */
/* ================                                         SN_GPIO0                                          ================ */
/* =========================================================================================================================== */

/* =========================================================  DATA  ========================================================== */
#define SN_GPIO0_DATA_DATA0_Pos           (0UL)                     /*!< DATA0 (Bit 0)                                         */
#define SN_GPIO0_DATA_DATA0_Msk           (0x1UL)                   /*!< DATA0 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO0_DATA_DATA1_Pos           (1UL)                     /*!< DATA1 (Bit 1)                                         */
#define SN_GPIO0_DATA_DATA1_Msk           (0x2UL)                   /*!< DATA1 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO0_DATA_DATA2_Pos           (2UL)                     /*!< DATA2 (Bit 2)                                         */
#define SN_GPIO0_DATA_DATA2_Msk           (0x4UL)                   /*!< DATA2 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO0_DATA_DATA3_Pos           (3UL)                     /*!< DATA3 (Bit 3)                                         */
#define SN_GPIO0_DATA_DATA3_Msk           (0x8UL)                   /*!< DATA3 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO0_DATA_DATA4_Pos           (4UL)                     /*!< DATA4 (Bit 4)                                         */
#define SN_GPIO0_DATA_DATA4_Msk           (0x10UL)                  /*!< DATA4 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO0_DATA_DATA5_Pos           (5UL)                     /*!< DATA5 (Bit 5)                                         */
#define SN_GPIO0_DATA_DATA5_Msk           (0x20UL)                  /*!< DATA5 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO0_DATA_DATA6_Pos           (6UL)                     /*!< DATA6 (Bit 6)                                         */
#define SN_GPIO0_DATA_DATA6_Msk           (0x40UL)                  /*!< DATA6 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO0_DATA_DATA7_Pos           (7UL)                     /*!< DATA7 (Bit 7)                                         */
#define SN_GPIO0_DATA_DATA7_Msk           (0x80UL)                  /*!< DATA7 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO0_DATA_DATA8_Pos           (8UL)                     /*!< DATA8 (Bit 8)                                         */
#define SN_GPIO0_DATA_DATA8_Msk           (0x100UL)                 /*!< DATA8 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO0_DATA_DATA9_Pos           (9UL)                     /*!< DATA9 (Bit 9)                                         */
#define SN_GPIO0_DATA_DATA9_Msk           (0x200UL)                 /*!< DATA9 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO0_DATA_DATA10_Pos          (10UL)                    /*!< DATA10 (Bit 10)                                       */
#define SN_GPIO0_DATA_DATA10_Msk          (0x400UL)                 /*!< DATA10 (Bitfield-Mask: 0x01)                          */
#define SN_GPIO0_DATA_DATA11_Pos          (11UL)                    /*!< DATA11 (Bit 11)                                       */
#define SN_GPIO0_DATA_DATA11_Msk          (0x800UL)                 /*!< DATA11 (Bitfield-Mask: 0x01)                          */
#define SN_GPIO0_DATA_DATA12_Pos          (12UL)                    /*!< DATA12 (Bit 12)                                       */
#define SN_GPIO0_DATA_DATA12_Msk          (0x1000UL)                /*!< DATA12 (Bitfield-Mask: 0x01)                          */
#define SN_GPIO0_DATA_DATA13_Pos          (13UL)                    /*!< DATA13 (Bit 13)                                       */
#define SN_GPIO0_DATA_DATA13_Msk          (0x2000UL)                /*!< DATA13 (Bitfield-Mask: 0x01)                          */
#define SN_GPIO0_DATA_DATA14_Pos          (14UL)                    /*!< DATA14 (Bit 14)                                       */
#define SN_GPIO0_DATA_DATA14_Msk          (0x4000UL)                /*!< DATA14 (Bitfield-Mask: 0x01)                          */
#define SN_GPIO0_DATA_DATA15_Pos          (15UL)                    /*!< DATA15 (Bit 15)                                       */
#define SN_GPIO0_DATA_DATA15_Msk          (0x8000UL)                /*!< DATA15 (Bitfield-Mask: 0x01)                          */
/* =========================================================  MODE  ========================================================== */
#define SN_GPIO0_MODE_MODE0_Pos           (0UL)                     /*!< MODE0 (Bit 0)                                         */
#define SN_GPIO0_MODE_MODE0_Msk           (0x1UL)                   /*!< MODE0 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO0_MODE_MODE1_Pos           (1UL)                     /*!< MODE1 (Bit 1)                                         */
#define SN_GPIO0_MODE_MODE1_Msk           (0x2UL)                   /*!< MODE1 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO0_MODE_MODE2_Pos           (2UL)                     /*!< MODE2 (Bit 2)                                         */
#define SN_GPIO0_MODE_MODE2_Msk           (0x4UL)                   /*!< MODE2 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO0_MODE_MODE3_Pos           (3UL)                     /*!< MODE3 (Bit 3)                                         */
#define SN_GPIO0_MODE_MODE3_Msk           (0x8UL)                   /*!< MODE3 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO0_MODE_MODE4_Pos           (4UL)                     /*!< MODE4 (Bit 4)                                         */
#define SN_GPIO0_MODE_MODE4_Msk           (0x10UL)                  /*!< MODE4 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO0_MODE_MODE5_Pos           (5UL)                     /*!< MODE5 (Bit 5)                                         */
#define SN_GPIO0_MODE_MODE5_Msk           (0x20UL)                  /*!< MODE5 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO0_MODE_MODE6_Pos           (6UL)                     /*!< MODE6 (Bit 6)                                         */
#define SN_GPIO0_MODE_MODE6_Msk           (0x40UL)                  /*!< MODE6 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO0_MODE_MODE7_Pos           (7UL)                     /*!< MODE7 (Bit 7)                                         */
#define SN_GPIO0_MODE_MODE7_Msk           (0x80UL)                  /*!< MODE7 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO0_MODE_MODE8_Pos           (8UL)                     /*!< MODE8 (Bit 8)                                         */
#define SN_GPIO0_MODE_MODE8_Msk           (0x100UL)                 /*!< MODE8 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO0_MODE_MODE9_Pos           (9UL)                     /*!< MODE9 (Bit 9)                                         */
#define SN_GPIO0_MODE_MODE9_Msk           (0x200UL)                 /*!< MODE9 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO0_MODE_MODE10_Pos          (10UL)                    /*!< MODE10 (Bit 10)                                       */
#define SN_GPIO0_MODE_MODE10_Msk          (0x400UL)                 /*!< MODE10 (Bitfield-Mask: 0x01)                          */
#define SN_GPIO0_MODE_MODE11_Pos          (11UL)                    /*!< MODE11 (Bit 11)                                       */
#define SN_GPIO0_MODE_MODE11_Msk          (0x800UL)                 /*!< MODE11 (Bitfield-Mask: 0x01)                          */
#define SN_GPIO0_MODE_MODE12_Pos          (12UL)                    /*!< MODE12 (Bit 12)                                       */
#define SN_GPIO0_MODE_MODE12_Msk          (0x1000UL)                /*!< MODE12 (Bitfield-Mask: 0x01)                          */
#define SN_GPIO0_MODE_MODE13_Pos          (13UL)                    /*!< MODE13 (Bit 13)                                       */
#define SN_GPIO0_MODE_MODE13_Msk          (0x2000UL)                /*!< MODE13 (Bitfield-Mask: 0x01)                          */
#define SN_GPIO0_MODE_MODE14_Pos          (14UL)                    /*!< MODE14 (Bit 14)                                       */
#define SN_GPIO0_MODE_MODE14_Msk          (0x4000UL)                /*!< MODE14 (Bitfield-Mask: 0x01)                          */
#define SN_GPIO0_MODE_MODE15_Pos          (15UL)                    /*!< MODE15 (Bit 15)                                       */
#define SN_GPIO0_MODE_MODE15_Msk          (0x8000UL)                /*!< MODE15 (Bitfield-Mask: 0x01)                          */
/* ==========================================================  CFG  ========================================================== */
#define SN_GPIO0_CFG_CFG0_Pos             (0UL)                     /*!< CFG0 (Bit 0)                                          */
#define SN_GPIO0_CFG_CFG0_Msk             (0x3UL)                   /*!< CFG0 (Bitfield-Mask: 0x03)                            */
#define SN_GPIO0_CFG_CFG1_Pos             (2UL)                     /*!< CFG1 (Bit 2)                                          */
#define SN_GPIO0_CFG_CFG1_Msk             (0xcUL)                   /*!< CFG1 (Bitfield-Mask: 0x03)                            */
#define SN_GPIO0_CFG_CFG2_Pos             (4UL)                     /*!< CFG2 (Bit 4)                                          */
#define SN_GPIO0_CFG_CFG2_Msk             (0x30UL)                  /*!< CFG2 (Bitfield-Mask: 0x03)                            */
#define SN_GPIO0_CFG_CFG3_Pos             (6UL)                     /*!< CFG3 (Bit 6)                                          */
#define SN_GPIO0_CFG_CFG3_Msk             (0xc0UL)                  /*!< CFG3 (Bitfield-Mask: 0x03)                            */
#define SN_GPIO0_CFG_CFG4_Pos             (8UL)                     /*!< CFG4 (Bit 8)                                          */
#define SN_GPIO0_CFG_CFG4_Msk             (0x300UL)                 /*!< CFG4 (Bitfield-Mask: 0x03)                            */
#define SN_GPIO0_CFG_CFG5_Pos             (10UL)                    /*!< CFG5 (Bit 10)                                         */
#define SN_GPIO0_CFG_CFG5_Msk             (0xc00UL)                 /*!< CFG5 (Bitfield-Mask: 0x03)                            */
#define SN_GPIO0_CFG_CFG6_Pos             (12UL)                    /*!< CFG6 (Bit 12)                                         */
#define SN_GPIO0_CFG_CFG6_Msk             (0x3000UL)                /*!< CFG6 (Bitfield-Mask: 0x03)                            */
#define SN_GPIO0_CFG_CFG7_Pos             (14UL)                    /*!< CFG7 (Bit 14)                                         */
#define SN_GPIO0_CFG_CFG7_Msk             (0xc000UL)                /*!< CFG7 (Bitfield-Mask: 0x03)                            */
#define SN_GPIO0_CFG_CFG8_Pos             (16UL)                    /*!< CFG8 (Bit 16)                                         */
#define SN_GPIO0_CFG_CFG8_Msk             (0x30000UL)               /*!< CFG8 (Bitfield-Mask: 0x03)                            */
#define SN_GPIO0_CFG_CFG9_Pos             (18UL)                    /*!< CFG9 (Bit 18)                                         */
#define SN_GPIO0_CFG_CFG9_Msk             (0xc0000UL)               /*!< CFG9 (Bitfield-Mask: 0x03)                            */
#define SN_GPIO0_CFG_CFG10_Pos            (20UL)                    /*!< CFG10 (Bit 20)                                        */
#define SN_GPIO0_CFG_CFG10_Msk            (0x300000UL)              /*!< CFG10 (Bitfield-Mask: 0x03)                           */
#define SN_GPIO0_CFG_CFG11_Pos            (22UL)                    /*!< CFG11 (Bit 22)                                        */
#define SN_GPIO0_CFG_CFG11_Msk            (0xc00000UL)              /*!< CFG11 (Bitfield-Mask: 0x03)                           */
#define SN_GPIO0_CFG_CFG12_Pos            (24UL)                    /*!< CFG12 (Bit 24)                                        */
#define SN_GPIO0_CFG_CFG12_Msk            (0x3000000UL)             /*!< CFG12 (Bitfield-Mask: 0x03)                           */
#define SN_GPIO0_CFG_CFG13_Pos            (26UL)                    /*!< CFG13 (Bit 26)                                        */
#define SN_GPIO0_CFG_CFG13_Msk            (0xc000000UL)             /*!< CFG13 (Bitfield-Mask: 0x03)                           */
#define SN_GPIO0_CFG_CFG14_Pos            (28UL)                    /*!< CFG14 (Bit 28)                                        */
#define SN_GPIO0_CFG_CFG14_Msk            (0x30000000UL)            /*!< CFG14 (Bitfield-Mask: 0x03)                           */
#define SN_GPIO0_CFG_CFG15_Pos            (30UL)                    /*!< CFG15 (Bit 30)                                        */
#define SN_GPIO0_CFG_CFG15_Msk            (0xc0000000UL)            /*!< CFG15 (Bitfield-Mask: 0x03)                           */
/* ==========================================================  IS  =========================================================== */
#define SN_GPIO0_IS_IS0_Pos               (0UL)                     /*!< IS0 (Bit 0)                                           */
#define SN_GPIO0_IS_IS0_Msk               (0x1UL)                   /*!< IS0 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO0_IS_IS1_Pos               (1UL)                     /*!< IS1 (Bit 1)                                           */
#define SN_GPIO0_IS_IS1_Msk               (0x2UL)                   /*!< IS1 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO0_IS_IS2_Pos               (2UL)                     /*!< IS2 (Bit 2)                                           */
#define SN_GPIO0_IS_IS2_Msk               (0x4UL)                   /*!< IS2 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO0_IS_IS3_Pos               (3UL)                     /*!< IS3 (Bit 3)                                           */
#define SN_GPIO0_IS_IS3_Msk               (0x8UL)                   /*!< IS3 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO0_IS_IS4_Pos               (4UL)                     /*!< IS4 (Bit 4)                                           */
#define SN_GPIO0_IS_IS4_Msk               (0x10UL)                  /*!< IS4 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO0_IS_IS5_Pos               (5UL)                     /*!< IS5 (Bit 5)                                           */
#define SN_GPIO0_IS_IS5_Msk               (0x20UL)                  /*!< IS5 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO0_IS_IS6_Pos               (6UL)                     /*!< IS6 (Bit 6)                                           */
#define SN_GPIO0_IS_IS6_Msk               (0x40UL)                  /*!< IS6 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO0_IS_IS7_Pos               (7UL)                     /*!< IS7 (Bit 7)                                           */
#define SN_GPIO0_IS_IS7_Msk               (0x80UL)                  /*!< IS7 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO0_IS_IS8_Pos               (8UL)                     /*!< IS8 (Bit 8)                                           */
#define SN_GPIO0_IS_IS8_Msk               (0x100UL)                 /*!< IS8 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO0_IS_IS9_Pos               (9UL)                     /*!< IS9 (Bit 9)                                           */
#define SN_GPIO0_IS_IS9_Msk               (0x200UL)                 /*!< IS9 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO0_IS_IS10_Pos              (10UL)                    /*!< IS10 (Bit 10)                                         */
#define SN_GPIO0_IS_IS10_Msk              (0x400UL)                 /*!< IS10 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO0_IS_IS11_Pos              (11UL)                    /*!< IS11 (Bit 11)                                         */
#define SN_GPIO0_IS_IS11_Msk              (0x800UL)                 /*!< IS11 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO0_IS_IS12_Pos              (12UL)                    /*!< IS12 (Bit 12)                                         */
#define SN_GPIO0_IS_IS12_Msk              (0x1000UL)                /*!< IS12 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO0_IS_IS13_Pos              (13UL)                    /*!< IS13 (Bit 13)                                         */
#define SN_GPIO0_IS_IS13_Msk              (0x2000UL)                /*!< IS13 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO0_IS_IS14_Pos              (14UL)                    /*!< IS14 (Bit 14)                                         */
#define SN_GPIO0_IS_IS14_Msk              (0x4000UL)                /*!< IS14 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO0_IS_IS15_Pos              (15UL)                    /*!< IS15 (Bit 15)                                         */
#define SN_GPIO0_IS_IS15_Msk              (0x8000UL)                /*!< IS15 (Bitfield-Mask: 0x01)                            */
/* ==========================================================  IBS  ========================================================== */
#define SN_GPIO0_IBS_IBS0_Pos             (0UL)                     /*!< IBS0 (Bit 0)                                          */
#define SN_GPIO0_IBS_IBS0_Msk             (0x1UL)                   /*!< IBS0 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO0_IBS_IBS1_Pos             (1UL)                     /*!< IBS1 (Bit 1)                                          */
#define SN_GPIO0_IBS_IBS1_Msk             (0x2UL)                   /*!< IBS1 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO0_IBS_IBS2_Pos             (2UL)                     /*!< IBS2 (Bit 2)                                          */
#define SN_GPIO0_IBS_IBS2_Msk             (0x4UL)                   /*!< IBS2 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO0_IBS_IBS3_Pos             (3UL)                     /*!< IBS3 (Bit 3)                                          */
#define SN_GPIO0_IBS_IBS3_Msk             (0x8UL)                   /*!< IBS3 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO0_IBS_IBS4_Pos             (4UL)                     /*!< IBS4 (Bit 4)                                          */
#define SN_GPIO0_IBS_IBS4_Msk             (0x10UL)                  /*!< IBS4 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO0_IBS_IBS5_Pos             (5UL)                     /*!< IBS5 (Bit 5)                                          */
#define SN_GPIO0_IBS_IBS5_Msk             (0x20UL)                  /*!< IBS5 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO0_IBS_IBS6_Pos             (6UL)                     /*!< IBS6 (Bit 6)                                          */
#define SN_GPIO0_IBS_IBS6_Msk             (0x40UL)                  /*!< IBS6 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO0_IBS_IBS7_Pos             (7UL)                     /*!< IBS7 (Bit 7)                                          */
#define SN_GPIO0_IBS_IBS7_Msk             (0x80UL)                  /*!< IBS7 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO0_IBS_IBS8_Pos             (8UL)                     /*!< IBS8 (Bit 8)                                          */
#define SN_GPIO0_IBS_IBS8_Msk             (0x100UL)                 /*!< IBS8 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO0_IBS_IBS9_Pos             (9UL)                     /*!< IBS9 (Bit 9)                                          */
#define SN_GPIO0_IBS_IBS9_Msk             (0x200UL)                 /*!< IBS9 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO0_IBS_IBS10_Pos            (10UL)                    /*!< IBS10 (Bit 10)                                        */
#define SN_GPIO0_IBS_IBS10_Msk            (0x400UL)                 /*!< IBS10 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO0_IBS_IBS11_Pos            (11UL)                    /*!< IBS11 (Bit 11)                                        */
#define SN_GPIO0_IBS_IBS11_Msk            (0x800UL)                 /*!< IBS11 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO0_IBS_IBS12_Pos            (12UL)                    /*!< IBS12 (Bit 12)                                        */
#define SN_GPIO0_IBS_IBS12_Msk            (0x1000UL)                /*!< IBS12 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO0_IBS_IBS13_Pos            (13UL)                    /*!< IBS13 (Bit 13)                                        */
#define SN_GPIO0_IBS_IBS13_Msk            (0x2000UL)                /*!< IBS13 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO0_IBS_IBS14_Pos            (14UL)                    /*!< IBS14 (Bit 14)                                        */
#define SN_GPIO0_IBS_IBS14_Msk            (0x4000UL)                /*!< IBS14 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO0_IBS_IBS15_Pos            (15UL)                    /*!< IBS15 (Bit 15)                                        */
#define SN_GPIO0_IBS_IBS15_Msk            (0x8000UL)                /*!< IBS15 (Bitfield-Mask: 0x01)                           */
/* ==========================================================  IEV  ========================================================== */
#define SN_GPIO0_IEV_IEV0_Pos             (0UL)                     /*!< IEV0 (Bit 0)                                          */
#define SN_GPIO0_IEV_IEV0_Msk             (0x1UL)                   /*!< IEV0 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO0_IEV_IEV1_Pos             (1UL)                     /*!< IEV1 (Bit 1)                                          */
#define SN_GPIO0_IEV_IEV1_Msk             (0x2UL)                   /*!< IEV1 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO0_IEV_IEV2_Pos             (2UL)                     /*!< IEV2 (Bit 2)                                          */
#define SN_GPIO0_IEV_IEV2_Msk             (0x4UL)                   /*!< IEV2 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO0_IEV_IEV3_Pos             (3UL)                     /*!< IEV3 (Bit 3)                                          */
#define SN_GPIO0_IEV_IEV3_Msk             (0x8UL)                   /*!< IEV3 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO0_IEV_IEV4_Pos             (4UL)                     /*!< IEV4 (Bit 4)                                          */
#define SN_GPIO0_IEV_IEV4_Msk             (0x10UL)                  /*!< IEV4 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO0_IEV_IEV5_Pos             (5UL)                     /*!< IEV5 (Bit 5)                                          */
#define SN_GPIO0_IEV_IEV5_Msk             (0x20UL)                  /*!< IEV5 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO0_IEV_IEV6_Pos             (6UL)                     /*!< IEV6 (Bit 6)                                          */
#define SN_GPIO0_IEV_IEV6_Msk             (0x40UL)                  /*!< IEV6 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO0_IEV_IEV7_Pos             (7UL)                     /*!< IEV7 (Bit 7)                                          */
#define SN_GPIO0_IEV_IEV7_Msk             (0x80UL)                  /*!< IEV7 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO0_IEV_IEV8_Pos             (8UL)                     /*!< IEV8 (Bit 8)                                          */
#define SN_GPIO0_IEV_IEV8_Msk             (0x100UL)                 /*!< IEV8 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO0_IEV_IEV9_Pos             (9UL)                     /*!< IEV9 (Bit 9)                                          */
#define SN_GPIO0_IEV_IEV9_Msk             (0x200UL)                 /*!< IEV9 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO0_IEV_IEV10_Pos            (10UL)                    /*!< IEV10 (Bit 10)                                        */
#define SN_GPIO0_IEV_IEV10_Msk            (0x400UL)                 /*!< IEV10 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO0_IEV_IEV11_Pos            (11UL)                    /*!< IEV11 (Bit 11)                                        */
#define SN_GPIO0_IEV_IEV11_Msk            (0x800UL)                 /*!< IEV11 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO0_IEV_IEV12_Pos            (12UL)                    /*!< IEV12 (Bit 12)                                        */
#define SN_GPIO0_IEV_IEV12_Msk            (0x1000UL)                /*!< IEV12 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO0_IEV_IEV13_Pos            (13UL)                    /*!< IEV13 (Bit 13)                                        */
#define SN_GPIO0_IEV_IEV13_Msk            (0x2000UL)                /*!< IEV13 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO0_IEV_IEV14_Pos            (14UL)                    /*!< IEV14 (Bit 14)                                        */
#define SN_GPIO0_IEV_IEV14_Msk            (0x4000UL)                /*!< IEV14 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO0_IEV_IEV15_Pos            (15UL)                    /*!< IEV15 (Bit 15)                                        */
#define SN_GPIO0_IEV_IEV15_Msk            (0x8000UL)                /*!< IEV15 (Bitfield-Mask: 0x01)                           */
/* ==========================================================  IE  =========================================================== */
#define SN_GPIO0_IE_IE0_Pos               (0UL)                     /*!< IE0 (Bit 0)                                           */
#define SN_GPIO0_IE_IE0_Msk               (0x1UL)                   /*!< IE0 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO0_IE_IE1_Pos               (1UL)                     /*!< IE1 (Bit 1)                                           */
#define SN_GPIO0_IE_IE1_Msk               (0x2UL)                   /*!< IE1 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO0_IE_IE2_Pos               (2UL)                     /*!< IE2 (Bit 2)                                           */
#define SN_GPIO0_IE_IE2_Msk               (0x4UL)                   /*!< IE2 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO0_IE_IE3_Pos               (3UL)                     /*!< IE3 (Bit 3)                                           */
#define SN_GPIO0_IE_IE3_Msk               (0x8UL)                   /*!< IE3 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO0_IE_IE4_Pos               (4UL)                     /*!< IE4 (Bit 4)                                           */
#define SN_GPIO0_IE_IE4_Msk               (0x10UL)                  /*!< IE4 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO0_IE_IE5_Pos               (5UL)                     /*!< IE5 (Bit 5)                                           */
#define SN_GPIO0_IE_IE5_Msk               (0x20UL)                  /*!< IE5 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO0_IE_IE6_Pos               (6UL)                     /*!< IE6 (Bit 6)                                           */
#define SN_GPIO0_IE_IE6_Msk               (0x40UL)                  /*!< IE6 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO0_IE_IE7_Pos               (7UL)                     /*!< IE7 (Bit 7)                                           */
#define SN_GPIO0_IE_IE7_Msk               (0x80UL)                  /*!< IE7 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO0_IE_IE8_Pos               (8UL)                     /*!< IE8 (Bit 8)                                           */
#define SN_GPIO0_IE_IE8_Msk               (0x100UL)                 /*!< IE8 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO0_IE_IE9_Pos               (9UL)                     /*!< IE9 (Bit 9)                                           */
#define SN_GPIO0_IE_IE9_Msk               (0x200UL)                 /*!< IE9 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO0_IE_IE10_Pos              (10UL)                    /*!< IE10 (Bit 10)                                         */
#define SN_GPIO0_IE_IE10_Msk              (0x400UL)                 /*!< IE10 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO0_IE_IE11_Pos              (11UL)                    /*!< IE11 (Bit 11)                                         */
#define SN_GPIO0_IE_IE11_Msk              (0x800UL)                 /*!< IE11 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO0_IE_IE12_Pos              (12UL)                    /*!< IE12 (Bit 12)                                         */
#define SN_GPIO0_IE_IE12_Msk              (0x1000UL)                /*!< IE12 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO0_IE_IE13_Pos              (13UL)                    /*!< IE13 (Bit 13)                                         */
#define SN_GPIO0_IE_IE13_Msk              (0x2000UL)                /*!< IE13 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO0_IE_IE14_Pos              (14UL)                    /*!< IE14 (Bit 14)                                         */
#define SN_GPIO0_IE_IE14_Msk              (0x4000UL)                /*!< IE14 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO0_IE_IE15_Pos              (15UL)                    /*!< IE15 (Bit 15)                                         */
#define SN_GPIO0_IE_IE15_Msk              (0x8000UL)                /*!< IE15 (Bitfield-Mask: 0x01)                            */
/* ==========================================================  RIS  ========================================================== */
#define SN_GPIO0_RIS_IF0_Pos              (0UL)                     /*!< IF0 (Bit 0)                                           */
#define SN_GPIO0_RIS_IF0_Msk              (0x1UL)                   /*!< IF0 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO0_RIS_IF1_Pos              (1UL)                     /*!< IF1 (Bit 1)                                           */
#define SN_GPIO0_RIS_IF1_Msk              (0x2UL)                   /*!< IF1 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO0_RIS_IF2_Pos              (2UL)                     /*!< IF2 (Bit 2)                                           */
#define SN_GPIO0_RIS_IF2_Msk              (0x4UL)                   /*!< IF2 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO0_RIS_IF3_Pos              (3UL)                     /*!< IF3 (Bit 3)                                           */
#define SN_GPIO0_RIS_IF3_Msk              (0x8UL)                   /*!< IF3 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO0_RIS_IF4_Pos              (4UL)                     /*!< IF4 (Bit 4)                                           */
#define SN_GPIO0_RIS_IF4_Msk              (0x10UL)                  /*!< IF4 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO0_RIS_IF5_Pos              (5UL)                     /*!< IF5 (Bit 5)                                           */
#define SN_GPIO0_RIS_IF5_Msk              (0x20UL)                  /*!< IF5 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO0_RIS_IF6_Pos              (6UL)                     /*!< IF6 (Bit 6)                                           */
#define SN_GPIO0_RIS_IF6_Msk              (0x40UL)                  /*!< IF6 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO0_RIS_IF7_Pos              (7UL)                     /*!< IF7 (Bit 7)                                           */
#define SN_GPIO0_RIS_IF7_Msk              (0x80UL)                  /*!< IF7 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO0_RIS_IF8_Pos              (8UL)                     /*!< IF8 (Bit 8)                                           */
#define SN_GPIO0_RIS_IF8_Msk              (0x100UL)                 /*!< IF8 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO0_RIS_IF9_Pos              (9UL)                     /*!< IF9 (Bit 9)                                           */
#define SN_GPIO0_RIS_IF9_Msk              (0x200UL)                 /*!< IF9 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO0_RIS_IF10_Pos             (10UL)                    /*!< IF10 (Bit 10)                                         */
#define SN_GPIO0_RIS_IF10_Msk             (0x400UL)                 /*!< IF10 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO0_RIS_IF11_Pos             (11UL)                    /*!< IF11 (Bit 11)                                         */
#define SN_GPIO0_RIS_IF11_Msk             (0x800UL)                 /*!< IF11 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO0_RIS_IF12_Pos             (12UL)                    /*!< IF12 (Bit 12)                                         */
#define SN_GPIO0_RIS_IF12_Msk             (0x1000UL)                /*!< IF12 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO0_RIS_IF13_Pos             (13UL)                    /*!< IF13 (Bit 13)                                         */
#define SN_GPIO0_RIS_IF13_Msk             (0x2000UL)                /*!< IF13 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO0_RIS_IF14_Pos             (14UL)                    /*!< IF14 (Bit 14)                                         */
#define SN_GPIO0_RIS_IF14_Msk             (0x4000UL)                /*!< IF14 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO0_RIS_IF15_Pos             (15UL)                    /*!< IF15 (Bit 15)                                         */
#define SN_GPIO0_RIS_IF15_Msk             (0x8000UL)                /*!< IF15 (Bitfield-Mask: 0x01)                            */
/* ==========================================================  IC  =========================================================== */
#define SN_GPIO0_IC_IC0_Pos               (0UL)                     /*!< IC0 (Bit 0)                                           */
#define SN_GPIO0_IC_IC0_Msk               (0x1UL)                   /*!< IC0 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO0_IC_IC1_Pos               (1UL)                     /*!< IC1 (Bit 1)                                           */
#define SN_GPIO0_IC_IC1_Msk               (0x2UL)                   /*!< IC1 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO0_IC_IC2_Pos               (2UL)                     /*!< IC2 (Bit 2)                                           */
#define SN_GPIO0_IC_IC2_Msk               (0x4UL)                   /*!< IC2 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO0_IC_IC3_Pos               (3UL)                     /*!< IC3 (Bit 3)                                           */
#define SN_GPIO0_IC_IC3_Msk               (0x8UL)                   /*!< IC3 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO0_IC_IC4_Pos               (4UL)                     /*!< IC4 (Bit 4)                                           */
#define SN_GPIO0_IC_IC4_Msk               (0x10UL)                  /*!< IC4 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO0_IC_IC5_Pos               (5UL)                     /*!< IC5 (Bit 5)                                           */
#define SN_GPIO0_IC_IC5_Msk               (0x20UL)                  /*!< IC5 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO0_IC_IC6_Pos               (6UL)                     /*!< IC6 (Bit 6)                                           */
#define SN_GPIO0_IC_IC6_Msk               (0x40UL)                  /*!< IC6 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO0_IC_IC7_Pos               (7UL)                     /*!< IC7 (Bit 7)                                           */
#define SN_GPIO0_IC_IC7_Msk               (0x80UL)                  /*!< IC7 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO0_IC_IC8_Pos               (8UL)                     /*!< IC8 (Bit 8)                                           */
#define SN_GPIO0_IC_IC8_Msk               (0x100UL)                 /*!< IC8 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO0_IC_IC9_Pos               (9UL)                     /*!< IC9 (Bit 9)                                           */
#define SN_GPIO0_IC_IC9_Msk               (0x200UL)                 /*!< IC9 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO0_IC_IC10_Pos              (10UL)                    /*!< IC10 (Bit 10)                                         */
#define SN_GPIO0_IC_IC10_Msk              (0x400UL)                 /*!< IC10 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO0_IC_IC11_Pos              (11UL)                    /*!< IC11 (Bit 11)                                         */
#define SN_GPIO0_IC_IC11_Msk              (0x800UL)                 /*!< IC11 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO0_IC_IC12_Pos              (12UL)                    /*!< IC12 (Bit 12)                                         */
#define SN_GPIO0_IC_IC12_Msk              (0x1000UL)                /*!< IC12 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO0_IC_IC13_Pos              (13UL)                    /*!< IC13 (Bit 13)                                         */
#define SN_GPIO0_IC_IC13_Msk              (0x2000UL)                /*!< IC13 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO0_IC_IC14_Pos              (14UL)                    /*!< IC14 (Bit 14)                                         */
#define SN_GPIO0_IC_IC14_Msk              (0x4000UL)                /*!< IC14 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO0_IC_IC15_Pos              (15UL)                    /*!< IC15 (Bit 15)                                         */
#define SN_GPIO0_IC_IC15_Msk              (0x8000UL)                /*!< IC15 (Bitfield-Mask: 0x01)                            */
/* =========================================================  BSET  ========================================================== */
#define SN_GPIO0_BSET_BSET0_Pos           (0UL)                     /*!< BSET0 (Bit 0)                                         */
#define SN_GPIO0_BSET_BSET0_Msk           (0x1UL)                   /*!< BSET0 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO0_BSET_BSET1_Pos           (1UL)                     /*!< BSET1 (Bit 1)                                         */
#define SN_GPIO0_BSET_BSET1_Msk           (0x2UL)                   /*!< BSET1 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO0_BSET_BSET2_Pos           (2UL)                     /*!< BSET2 (Bit 2)                                         */
#define SN_GPIO0_BSET_BSET2_Msk           (0x4UL)                   /*!< BSET2 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO0_BSET_BSET3_Pos           (3UL)                     /*!< BSET3 (Bit 3)                                         */
#define SN_GPIO0_BSET_BSET3_Msk           (0x8UL)                   /*!< BSET3 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO0_BSET_BSET4_Pos           (4UL)                     /*!< BSET4 (Bit 4)                                         */
#define SN_GPIO0_BSET_BSET4_Msk           (0x10UL)                  /*!< BSET4 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO0_BSET_BSET5_Pos           (5UL)                     /*!< BSET5 (Bit 5)                                         */
#define SN_GPIO0_BSET_BSET5_Msk           (0x20UL)                  /*!< BSET5 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO0_BSET_BSET6_Pos           (6UL)                     /*!< BSET6 (Bit 6)                                         */
#define SN_GPIO0_BSET_BSET6_Msk           (0x40UL)                  /*!< BSET6 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO0_BSET_BSET7_Pos           (7UL)                     /*!< BSET7 (Bit 7)                                         */
#define SN_GPIO0_BSET_BSET7_Msk           (0x80UL)                  /*!< BSET7 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO0_BSET_BSET8_Pos           (8UL)                     /*!< BSET8 (Bit 8)                                         */
#define SN_GPIO0_BSET_BSET8_Msk           (0x100UL)                 /*!< BSET8 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO0_BSET_BSET9_Pos           (9UL)                     /*!< BSET9 (Bit 9)                                         */
#define SN_GPIO0_BSET_BSET9_Msk           (0x200UL)                 /*!< BSET9 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO0_BSET_BSET10_Pos          (10UL)                    /*!< BSET10 (Bit 10)                                       */
#define SN_GPIO0_BSET_BSET10_Msk          (0x400UL)                 /*!< BSET10 (Bitfield-Mask: 0x01)                          */
#define SN_GPIO0_BSET_BSET11_Pos          (11UL)                    /*!< BSET11 (Bit 11)                                       */
#define SN_GPIO0_BSET_BSET11_Msk          (0x800UL)                 /*!< BSET11 (Bitfield-Mask: 0x01)                          */
#define SN_GPIO0_BSET_BSET12_Pos          (12UL)                    /*!< BSET12 (Bit 12)                                       */
#define SN_GPIO0_BSET_BSET12_Msk          (0x1000UL)                /*!< BSET12 (Bitfield-Mask: 0x01)                          */
#define SN_GPIO0_BSET_BSET13_Pos          (13UL)                    /*!< BSET13 (Bit 13)                                       */
#define SN_GPIO0_BSET_BSET13_Msk          (0x2000UL)                /*!< BSET13 (Bitfield-Mask: 0x01)                          */
#define SN_GPIO0_BSET_BSET14_Pos          (14UL)                    /*!< BSET14 (Bit 14)                                       */
#define SN_GPIO0_BSET_BSET14_Msk          (0x4000UL)                /*!< BSET14 (Bitfield-Mask: 0x01)                          */
#define SN_GPIO0_BSET_BSET15_Pos          (15UL)                    /*!< BSET15 (Bit 15)                                       */
#define SN_GPIO0_BSET_BSET15_Msk          (0x8000UL)                /*!< BSET15 (Bitfield-Mask: 0x01)                          */
/* =========================================================  BCLR  ========================================================== */
#define SN_GPIO0_BCLR_BCLR0_Pos           (0UL)                     /*!< BCLR0 (Bit 0)                                         */
#define SN_GPIO0_BCLR_BCLR0_Msk           (0x1UL)                   /*!< BCLR0 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO0_BCLR_BCLR1_Pos           (1UL)                     /*!< BCLR1 (Bit 1)                                         */
#define SN_GPIO0_BCLR_BCLR1_Msk           (0x2UL)                   /*!< BCLR1 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO0_BCLR_BCLR2_Pos           (2UL)                     /*!< BCLR2 (Bit 2)                                         */
#define SN_GPIO0_BCLR_BCLR2_Msk           (0x4UL)                   /*!< BCLR2 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO0_BCLR_BCLR3_Pos           (3UL)                     /*!< BCLR3 (Bit 3)                                         */
#define SN_GPIO0_BCLR_BCLR3_Msk           (0x8UL)                   /*!< BCLR3 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO0_BCLR_BCLR4_Pos           (4UL)                     /*!< BCLR4 (Bit 4)                                         */
#define SN_GPIO0_BCLR_BCLR4_Msk           (0x10UL)                  /*!< BCLR4 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO0_BCLR_BCLR5_Pos           (5UL)                     /*!< BCLR5 (Bit 5)                                         */
#define SN_GPIO0_BCLR_BCLR5_Msk           (0x20UL)                  /*!< BCLR5 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO0_BCLR_BCLR6_Pos           (6UL)                     /*!< BCLR6 (Bit 6)                                         */
#define SN_GPIO0_BCLR_BCLR6_Msk           (0x40UL)                  /*!< BCLR6 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO0_BCLR_BCLR7_Pos           (7UL)                     /*!< BCLR7 (Bit 7)                                         */
#define SN_GPIO0_BCLR_BCLR7_Msk           (0x80UL)                  /*!< BCLR7 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO0_BCLR_BCLR8_Pos           (8UL)                     /*!< BCLR8 (Bit 8)                                         */
#define SN_GPIO0_BCLR_BCLR8_Msk           (0x100UL)                 /*!< BCLR8 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO0_BCLR_BCLR9_Pos           (9UL)                     /*!< BCLR9 (Bit 9)                                         */
#define SN_GPIO0_BCLR_BCLR9_Msk           (0x200UL)                 /*!< BCLR9 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO0_BCLR_BCLR10_Pos          (10UL)                    /*!< BCLR10 (Bit 10)                                       */
#define SN_GPIO0_BCLR_BCLR10_Msk          (0x400UL)                 /*!< BCLR10 (Bitfield-Mask: 0x01)                          */
#define SN_GPIO0_BCLR_BCLR11_Pos          (11UL)                    /*!< BCLR11 (Bit 11)                                       */
#define SN_GPIO0_BCLR_BCLR11_Msk          (0x800UL)                 /*!< BCLR11 (Bitfield-Mask: 0x01)                          */
#define SN_GPIO0_BCLR_BCLR12_Pos          (12UL)                    /*!< BCLR12 (Bit 12)                                       */
#define SN_GPIO0_BCLR_BCLR12_Msk          (0x1000UL)                /*!< BCLR12 (Bitfield-Mask: 0x01)                          */
#define SN_GPIO0_BCLR_BCLR13_Pos          (13UL)                    /*!< BCLR13 (Bit 13)                                       */
#define SN_GPIO0_BCLR_BCLR13_Msk          (0x2000UL)                /*!< BCLR13 (Bitfield-Mask: 0x01)                          */
#define SN_GPIO0_BCLR_BCLR14_Pos          (14UL)                    /*!< BCLR14 (Bit 14)                                       */
#define SN_GPIO0_BCLR_BCLR14_Msk          (0x4000UL)                /*!< BCLR14 (Bitfield-Mask: 0x01)                          */
#define SN_GPIO0_BCLR_BCLR15_Pos          (15UL)                    /*!< BCLR15 (Bit 15)                                       */
#define SN_GPIO0_BCLR_BCLR15_Msk          (0x8000UL)                /*!< BCLR15 (Bitfield-Mask: 0x01)                          */


/* =========================================================================================================================== */
/* ================                                         SN_GPIO1                                          ================ */
/* =========================================================================================================================== */

/* =========================================================  DATA  ========================================================== */
#define SN_GPIO1_DATA_DATA0_Pos           (0UL)                     /*!< DATA0 (Bit 0)                                         */
#define SN_GPIO1_DATA_DATA0_Msk           (0x1UL)                   /*!< DATA0 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO1_DATA_DATA1_Pos           (1UL)                     /*!< DATA1 (Bit 1)                                         */
#define SN_GPIO1_DATA_DATA1_Msk           (0x2UL)                   /*!< DATA1 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO1_DATA_DATA2_Pos           (2UL)                     /*!< DATA2 (Bit 2)                                         */
#define SN_GPIO1_DATA_DATA2_Msk           (0x4UL)                   /*!< DATA2 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO1_DATA_DATA3_Pos           (3UL)                     /*!< DATA3 (Bit 3)                                         */
#define SN_GPIO1_DATA_DATA3_Msk           (0x8UL)                   /*!< DATA3 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO1_DATA_DATA4_Pos           (4UL)                     /*!< DATA4 (Bit 4)                                         */
#define SN_GPIO1_DATA_DATA4_Msk           (0x10UL)                  /*!< DATA4 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO1_DATA_DATA5_Pos           (5UL)                     /*!< DATA5 (Bit 5)                                         */
#define SN_GPIO1_DATA_DATA5_Msk           (0x20UL)                  /*!< DATA5 (Bitfield-Mask: 0x01)                           */
/* =========================================================  MODE  ========================================================== */
#define SN_GPIO1_MODE_MODE0_Pos           (0UL)                     /*!< MODE0 (Bit 0)                                         */
#define SN_GPIO1_MODE_MODE0_Msk           (0x1UL)                   /*!< MODE0 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO1_MODE_MODE1_Pos           (1UL)                     /*!< MODE1 (Bit 1)                                         */
#define SN_GPIO1_MODE_MODE1_Msk           (0x2UL)                   /*!< MODE1 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO1_MODE_MODE2_Pos           (2UL)                     /*!< MODE2 (Bit 2)                                         */
#define SN_GPIO1_MODE_MODE2_Msk           (0x4UL)                   /*!< MODE2 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO1_MODE_MODE3_Pos           (3UL)                     /*!< MODE3 (Bit 3)                                         */
#define SN_GPIO1_MODE_MODE3_Msk           (0x8UL)                   /*!< MODE3 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO1_MODE_MODE4_Pos           (4UL)                     /*!< MODE4 (Bit 4)                                         */
#define SN_GPIO1_MODE_MODE4_Msk           (0x10UL)                  /*!< MODE4 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO1_MODE_MODE5_Pos           (5UL)                     /*!< MODE5 (Bit 5)                                         */
#define SN_GPIO1_MODE_MODE5_Msk           (0x20UL)                  /*!< MODE5 (Bitfield-Mask: 0x01)                           */
/* ==========================================================  CFG  ========================================================== */
#define SN_GPIO1_CFG_CFG0_Pos             (0UL)                     /*!< CFG0 (Bit 0)                                          */
#define SN_GPIO1_CFG_CFG0_Msk             (0x3UL)                   /*!< CFG0 (Bitfield-Mask: 0x03)                            */
#define SN_GPIO1_CFG_CFG1_Pos             (2UL)                     /*!< CFG1 (Bit 2)                                          */
#define SN_GPIO1_CFG_CFG1_Msk             (0xcUL)                   /*!< CFG1 (Bitfield-Mask: 0x03)                            */
#define SN_GPIO1_CFG_CFG2_Pos             (4UL)                     /*!< CFG2 (Bit 4)                                          */
#define SN_GPIO1_CFG_CFG2_Msk             (0x30UL)                  /*!< CFG2 (Bitfield-Mask: 0x03)                            */
#define SN_GPIO1_CFG_CFG3_Pos             (6UL)                     /*!< CFG3 (Bit 6)                                          */
#define SN_GPIO1_CFG_CFG3_Msk             (0xc0UL)                  /*!< CFG3 (Bitfield-Mask: 0x03)                            */
#define SN_GPIO1_CFG_CFG4_Pos             (8UL)                     /*!< CFG4 (Bit 8)                                          */
#define SN_GPIO1_CFG_CFG4_Msk             (0x300UL)                 /*!< CFG4 (Bitfield-Mask: 0x03)                            */
#define SN_GPIO1_CFG_CFG5_Pos             (10UL)                    /*!< CFG5 (Bit 10)                                         */
#define SN_GPIO1_CFG_CFG5_Msk             (0xc00UL)                 /*!< CFG5 (Bitfield-Mask: 0x03)                            */
/* ==========================================================  IS  =========================================================== */
#define SN_GPIO1_IS_IS0_Pos               (0UL)                     /*!< IS0 (Bit 0)                                           */
#define SN_GPIO1_IS_IS0_Msk               (0x1UL)                   /*!< IS0 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO1_IS_IS1_Pos               (1UL)                     /*!< IS1 (Bit 1)                                           */
#define SN_GPIO1_IS_IS1_Msk               (0x2UL)                   /*!< IS1 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO1_IS_IS2_Pos               (2UL)                     /*!< IS2 (Bit 2)                                           */
#define SN_GPIO1_IS_IS2_Msk               (0x4UL)                   /*!< IS2 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO1_IS_IS3_Pos               (3UL)                     /*!< IS3 (Bit 3)                                           */
#define SN_GPIO1_IS_IS3_Msk               (0x8UL)                   /*!< IS3 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO1_IS_IS4_Pos               (4UL)                     /*!< IS4 (Bit 4)                                           */
#define SN_GPIO1_IS_IS4_Msk               (0x10UL)                  /*!< IS4 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO1_IS_IS5_Pos               (5UL)                     /*!< IS5 (Bit 5)                                           */
#define SN_GPIO1_IS_IS5_Msk               (0x20UL)                  /*!< IS5 (Bitfield-Mask: 0x01)                             */
/* ==========================================================  IBS  ========================================================== */
#define SN_GPIO1_IBS_IBS0_Pos             (0UL)                     /*!< IBS0 (Bit 0)                                          */
#define SN_GPIO1_IBS_IBS0_Msk             (0x1UL)                   /*!< IBS0 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO1_IBS_IBS1_Pos             (1UL)                     /*!< IBS1 (Bit 1)                                          */
#define SN_GPIO1_IBS_IBS1_Msk             (0x2UL)                   /*!< IBS1 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO1_IBS_IBS2_Pos             (2UL)                     /*!< IBS2 (Bit 2)                                          */
#define SN_GPIO1_IBS_IBS2_Msk             (0x4UL)                   /*!< IBS2 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO1_IBS_IBS3_Pos             (3UL)                     /*!< IBS3 (Bit 3)                                          */
#define SN_GPIO1_IBS_IBS3_Msk             (0x8UL)                   /*!< IBS3 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO1_IBS_IBS4_Pos             (4UL)                     /*!< IBS4 (Bit 4)                                          */
#define SN_GPIO1_IBS_IBS4_Msk             (0x10UL)                  /*!< IBS4 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO1_IBS_IBS5_Pos             (5UL)                     /*!< IBS5 (Bit 5)                                          */
#define SN_GPIO1_IBS_IBS5_Msk             (0x20UL)                  /*!< IBS5 (Bitfield-Mask: 0x01)                            */
/* ==========================================================  IEV  ========================================================== */
#define SN_GPIO1_IEV_IEV0_Pos             (0UL)                     /*!< IEV0 (Bit 0)                                          */
#define SN_GPIO1_IEV_IEV0_Msk             (0x1UL)                   /*!< IEV0 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO1_IEV_IEV1_Pos             (1UL)                     /*!< IEV1 (Bit 1)                                          */
#define SN_GPIO1_IEV_IEV1_Msk             (0x2UL)                   /*!< IEV1 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO1_IEV_IEV2_Pos             (2UL)                     /*!< IEV2 (Bit 2)                                          */
#define SN_GPIO1_IEV_IEV2_Msk             (0x4UL)                   /*!< IEV2 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO1_IEV_IEV3_Pos             (3UL)                     /*!< IEV3 (Bit 3)                                          */
#define SN_GPIO1_IEV_IEV3_Msk             (0x8UL)                   /*!< IEV3 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO1_IEV_IEV4_Pos             (4UL)                     /*!< IEV4 (Bit 4)                                          */
#define SN_GPIO1_IEV_IEV4_Msk             (0x10UL)                  /*!< IEV4 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO1_IEV_IEV5_Pos             (5UL)                     /*!< IEV5 (Bit 5)                                          */
#define SN_GPIO1_IEV_IEV5_Msk             (0x20UL)                  /*!< IEV5 (Bitfield-Mask: 0x01)                            */
/* ==========================================================  IE  =========================================================== */
#define SN_GPIO1_IE_IE0_Pos               (0UL)                     /*!< IE0 (Bit 0)                                           */
#define SN_GPIO1_IE_IE0_Msk               (0x1UL)                   /*!< IE0 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO1_IE_IE1_Pos               (1UL)                     /*!< IE1 (Bit 1)                                           */
#define SN_GPIO1_IE_IE1_Msk               (0x2UL)                   /*!< IE1 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO1_IE_IE2_Pos               (2UL)                     /*!< IE2 (Bit 2)                                           */
#define SN_GPIO1_IE_IE2_Msk               (0x4UL)                   /*!< IE2 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO1_IE_IE3_Pos               (3UL)                     /*!< IE3 (Bit 3)                                           */
#define SN_GPIO1_IE_IE3_Msk               (0x8UL)                   /*!< IE3 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO1_IE_IE4_Pos               (4UL)                     /*!< IE4 (Bit 4)                                           */
#define SN_GPIO1_IE_IE4_Msk               (0x10UL)                  /*!< IE4 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO1_IE_IE5_Pos               (5UL)                     /*!< IE5 (Bit 5)                                           */
#define SN_GPIO1_IE_IE5_Msk               (0x20UL)                  /*!< IE5 (Bitfield-Mask: 0x01)                             */
/* ==========================================================  RIS  ========================================================== */
#define SN_GPIO1_RIS_IF0_Pos              (0UL)                     /*!< IF0 (Bit 0)                                           */
#define SN_GPIO1_RIS_IF0_Msk              (0x1UL)                   /*!< IF0 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO1_RIS_IF1_Pos              (1UL)                     /*!< IF1 (Bit 1)                                           */
#define SN_GPIO1_RIS_IF1_Msk              (0x2UL)                   /*!< IF1 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO1_RIS_IF2_Pos              (2UL)                     /*!< IF2 (Bit 2)                                           */
#define SN_GPIO1_RIS_IF2_Msk              (0x4UL)                   /*!< IF2 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO1_RIS_IF3_Pos              (3UL)                     /*!< IF3 (Bit 3)                                           */
#define SN_GPIO1_RIS_IF3_Msk              (0x8UL)                   /*!< IF3 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO1_RIS_IF4_Pos              (4UL)                     /*!< IF4 (Bit 4)                                           */
#define SN_GPIO1_RIS_IF4_Msk              (0x10UL)                  /*!< IF4 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO1_RIS_IF5_Pos              (5UL)                     /*!< IF5 (Bit 5)                                           */
#define SN_GPIO1_RIS_IF5_Msk              (0x20UL)                  /*!< IF5 (Bitfield-Mask: 0x01)                             */
/* ==========================================================  IC  =========================================================== */
#define SN_GPIO1_IC_IC0_Pos               (0UL)                     /*!< IC0 (Bit 0)                                           */
#define SN_GPIO1_IC_IC0_Msk               (0x1UL)                   /*!< IC0 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO1_IC_IC1_Pos               (1UL)                     /*!< IC1 (Bit 1)                                           */
#define SN_GPIO1_IC_IC1_Msk               (0x2UL)                   /*!< IC1 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO1_IC_IC2_Pos               (2UL)                     /*!< IC2 (Bit 2)                                           */
#define SN_GPIO1_IC_IC2_Msk               (0x4UL)                   /*!< IC2 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO1_IC_IC3_Pos               (3UL)                     /*!< IC3 (Bit 3)                                           */
#define SN_GPIO1_IC_IC3_Msk               (0x8UL)                   /*!< IC3 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO1_IC_IC4_Pos               (4UL)                     /*!< IC4 (Bit 4)                                           */
#define SN_GPIO1_IC_IC4_Msk               (0x10UL)                  /*!< IC4 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO1_IC_IC5_Pos               (5UL)                     /*!< IC5 (Bit 5)                                           */
#define SN_GPIO1_IC_IC5_Msk               (0x20UL)                  /*!< IC5 (Bitfield-Mask: 0x01)                             */
/* =========================================================  BSET  ========================================================== */
#define SN_GPIO1_BSET_BSET0_Pos           (0UL)                     /*!< BSET0 (Bit 0)                                         */
#define SN_GPIO1_BSET_BSET0_Msk           (0x1UL)                   /*!< BSET0 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO1_BSET_BSET1_Pos           (1UL)                     /*!< BSET1 (Bit 1)                                         */
#define SN_GPIO1_BSET_BSET1_Msk           (0x2UL)                   /*!< BSET1 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO1_BSET_BSET2_Pos           (2UL)                     /*!< BSET2 (Bit 2)                                         */
#define SN_GPIO1_BSET_BSET2_Msk           (0x4UL)                   /*!< BSET2 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO1_BSET_BSET3_Pos           (3UL)                     /*!< BSET3 (Bit 3)                                         */
#define SN_GPIO1_BSET_BSET3_Msk           (0x8UL)                   /*!< BSET3 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO1_BSET_BSET4_Pos           (4UL)                     /*!< BSET4 (Bit 4)                                         */
#define SN_GPIO1_BSET_BSET4_Msk           (0x10UL)                  /*!< BSET4 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO1_BSET_BSET5_Pos           (5UL)                     /*!< BSET5 (Bit 5)                                         */
#define SN_GPIO1_BSET_BSET5_Msk           (0x20UL)                  /*!< BSET5 (Bitfield-Mask: 0x01)                           */
/* =========================================================  BCLR  ========================================================== */
#define SN_GPIO1_BCLR_BCLR0_Pos           (0UL)                     /*!< BCLR0 (Bit 0)                                         */
#define SN_GPIO1_BCLR_BCLR0_Msk           (0x1UL)                   /*!< BCLR0 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO1_BCLR_BCLR1_Pos           (1UL)                     /*!< BCLR1 (Bit 1)                                         */
#define SN_GPIO1_BCLR_BCLR1_Msk           (0x2UL)                   /*!< BCLR1 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO1_BCLR_BCLR2_Pos           (2UL)                     /*!< BCLR2 (Bit 2)                                         */
#define SN_GPIO1_BCLR_BCLR2_Msk           (0x4UL)                   /*!< BCLR2 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO1_BCLR_BCLR3_Pos           (3UL)                     /*!< BCLR3 (Bit 3)                                         */
#define SN_GPIO1_BCLR_BCLR3_Msk           (0x8UL)                   /*!< BCLR3 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO1_BCLR_BCLR4_Pos           (4UL)                     /*!< BCLR4 (Bit 4)                                         */
#define SN_GPIO1_BCLR_BCLR4_Msk           (0x10UL)                  /*!< BCLR4 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO1_BCLR_BCLR5_Pos           (5UL)                     /*!< BCLR5 (Bit 5)                                         */
#define SN_GPIO1_BCLR_BCLR5_Msk           (0x20UL)                  /*!< BCLR5 (Bitfield-Mask: 0x01)                           */


/* =========================================================================================================================== */
/* ================                                         SN_GPIO2                                          ================ */
/* =========================================================================================================================== */

/* =========================================================  DATA  ========================================================== */
#define SN_GPIO2_DATA_DATA0_Pos           (0UL)                     /*!< DATA0 (Bit 0)                                         */
#define SN_GPIO2_DATA_DATA0_Msk           (0x1UL)                   /*!< DATA0 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO2_DATA_DATA1_Pos           (1UL)                     /*!< DATA1 (Bit 1)                                         */
#define SN_GPIO2_DATA_DATA1_Msk           (0x2UL)                   /*!< DATA1 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO2_DATA_DATA2_Pos           (2UL)                     /*!< DATA2 (Bit 2)                                         */
#define SN_GPIO2_DATA_DATA2_Msk           (0x4UL)                   /*!< DATA2 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO2_DATA_DATA3_Pos           (3UL)                     /*!< DATA3 (Bit 3)                                         */
#define SN_GPIO2_DATA_DATA3_Msk           (0x8UL)                   /*!< DATA3 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO2_DATA_DATA4_Pos           (4UL)                     /*!< DATA4 (Bit 4)                                         */
#define SN_GPIO2_DATA_DATA4_Msk           (0x10UL)                  /*!< DATA4 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO2_DATA_DATA5_Pos           (5UL)                     /*!< DATA5 (Bit 5)                                         */
#define SN_GPIO2_DATA_DATA5_Msk           (0x20UL)                  /*!< DATA5 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO2_DATA_DATA6_Pos           (6UL)                     /*!< DATA6 (Bit 6)                                         */
#define SN_GPIO2_DATA_DATA6_Msk           (0x40UL)                  /*!< DATA6 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO2_DATA_DATA7_Pos           (7UL)                     /*!< DATA7 (Bit 7)                                         */
#define SN_GPIO2_DATA_DATA7_Msk           (0x80UL)                  /*!< DATA7 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO2_DATA_DATA8_Pos           (8UL)                     /*!< DATA8 (Bit 8)                                         */
#define SN_GPIO2_DATA_DATA8_Msk           (0x100UL)                 /*!< DATA8 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO2_DATA_DATA9_Pos           (9UL)                     /*!< DATA9 (Bit 9)                                         */
#define SN_GPIO2_DATA_DATA9_Msk           (0x200UL)                 /*!< DATA9 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO2_DATA_DATA10_Pos          (10UL)                    /*!< DATA10 (Bit 10)                                       */
#define SN_GPIO2_DATA_DATA10_Msk          (0x400UL)                 /*!< DATA10 (Bitfield-Mask: 0x01)                          */
/* =========================================================  MODE  ========================================================== */
#define SN_GPIO2_MODE_MODE0_Pos           (0UL)                     /*!< MODE0 (Bit 0)                                         */
#define SN_GPIO2_MODE_MODE0_Msk           (0x1UL)                   /*!< MODE0 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO2_MODE_MODE1_Pos           (1UL)                     /*!< MODE1 (Bit 1)                                         */
#define SN_GPIO2_MODE_MODE1_Msk           (0x2UL)                   /*!< MODE1 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO2_MODE_MODE2_Pos           (2UL)                     /*!< MODE2 (Bit 2)                                         */
#define SN_GPIO2_MODE_MODE2_Msk           (0x4UL)                   /*!< MODE2 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO2_MODE_MODE3_Pos           (3UL)                     /*!< MODE3 (Bit 3)                                         */
#define SN_GPIO2_MODE_MODE3_Msk           (0x8UL)                   /*!< MODE3 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO2_MODE_MODE4_Pos           (4UL)                     /*!< MODE4 (Bit 4)                                         */
#define SN_GPIO2_MODE_MODE4_Msk           (0x10UL)                  /*!< MODE4 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO2_MODE_MODE5_Pos           (5UL)                     /*!< MODE5 (Bit 5)                                         */
#define SN_GPIO2_MODE_MODE5_Msk           (0x20UL)                  /*!< MODE5 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO2_MODE_MODE6_Pos           (6UL)                     /*!< MODE6 (Bit 6)                                         */
#define SN_GPIO2_MODE_MODE6_Msk           (0x40UL)                  /*!< MODE6 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO2_MODE_MODE7_Pos           (7UL)                     /*!< MODE7 (Bit 7)                                         */
#define SN_GPIO2_MODE_MODE7_Msk           (0x80UL)                  /*!< MODE7 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO2_MODE_MODE8_Pos           (8UL)                     /*!< MODE8 (Bit 8)                                         */
#define SN_GPIO2_MODE_MODE8_Msk           (0x100UL)                 /*!< MODE8 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO2_MODE_MODE9_Pos           (9UL)                     /*!< MODE9 (Bit 9)                                         */
#define SN_GPIO2_MODE_MODE9_Msk           (0x200UL)                 /*!< MODE9 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO2_MODE_MODE10_Pos          (10UL)                    /*!< MODE10 (Bit 10)                                       */
#define SN_GPIO2_MODE_MODE10_Msk          (0x400UL)                 /*!< MODE10 (Bitfield-Mask: 0x01)                          */
/* ==========================================================  CFG  ========================================================== */
#define SN_GPIO2_CFG_CFG0_Pos             (0UL)                     /*!< CFG0 (Bit 0)                                          */
#define SN_GPIO2_CFG_CFG0_Msk             (0x3UL)                   /*!< CFG0 (Bitfield-Mask: 0x03)                            */
#define SN_GPIO2_CFG_CFG1_Pos             (2UL)                     /*!< CFG1 (Bit 2)                                          */
#define SN_GPIO2_CFG_CFG1_Msk             (0xcUL)                   /*!< CFG1 (Bitfield-Mask: 0x03)                            */
#define SN_GPIO2_CFG_CFG2_Pos             (4UL)                     /*!< CFG2 (Bit 4)                                          */
#define SN_GPIO2_CFG_CFG2_Msk             (0x30UL)                  /*!< CFG2 (Bitfield-Mask: 0x03)                            */
#define SN_GPIO2_CFG_CFG3_Pos             (6UL)                     /*!< CFG3 (Bit 6)                                          */
#define SN_GPIO2_CFG_CFG3_Msk             (0xc0UL)                  /*!< CFG3 (Bitfield-Mask: 0x03)                            */
#define SN_GPIO2_CFG_CFG4_Pos             (8UL)                     /*!< CFG4 (Bit 8)                                          */
#define SN_GPIO2_CFG_CFG4_Msk             (0x300UL)                 /*!< CFG4 (Bitfield-Mask: 0x03)                            */
#define SN_GPIO2_CFG_CFG5_Pos             (10UL)                    /*!< CFG5 (Bit 10)                                         */
#define SN_GPIO2_CFG_CFG5_Msk             (0xc00UL)                 /*!< CFG5 (Bitfield-Mask: 0x03)                            */
#define SN_GPIO2_CFG_CFG6_Pos             (12UL)                    /*!< CFG6 (Bit 12)                                         */
#define SN_GPIO2_CFG_CFG6_Msk             (0x3000UL)                /*!< CFG6 (Bitfield-Mask: 0x03)                            */
#define SN_GPIO2_CFG_CFG7_Pos             (14UL)                    /*!< CFG7 (Bit 14)                                         */
#define SN_GPIO2_CFG_CFG7_Msk             (0xc000UL)                /*!< CFG7 (Bitfield-Mask: 0x03)                            */
#define SN_GPIO2_CFG_CFG8_Pos             (16UL)                    /*!< CFG8 (Bit 16)                                         */
#define SN_GPIO2_CFG_CFG8_Msk             (0x30000UL)               /*!< CFG8 (Bitfield-Mask: 0x03)                            */
#define SN_GPIO2_CFG_CFG9_Pos             (18UL)                    /*!< CFG9 (Bit 18)                                         */
#define SN_GPIO2_CFG_CFG9_Msk             (0xc0000UL)               /*!< CFG9 (Bitfield-Mask: 0x03)                            */
#define SN_GPIO2_CFG_CFG10_Pos            (20UL)                    /*!< CFG10 (Bit 20)                                        */
#define SN_GPIO2_CFG_CFG10_Msk            (0x300000UL)              /*!< CFG10 (Bitfield-Mask: 0x03)                           */
/* ==========================================================  IS  =========================================================== */
#define SN_GPIO2_IS_IS0_Pos               (0UL)                     /*!< IS0 (Bit 0)                                           */
#define SN_GPIO2_IS_IS0_Msk               (0x1UL)                   /*!< IS0 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO2_IS_IS1_Pos               (1UL)                     /*!< IS1 (Bit 1)                                           */
#define SN_GPIO2_IS_IS1_Msk               (0x2UL)                   /*!< IS1 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO2_IS_IS2_Pos               (2UL)                     /*!< IS2 (Bit 2)                                           */
#define SN_GPIO2_IS_IS2_Msk               (0x4UL)                   /*!< IS2 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO2_IS_IS3_Pos               (3UL)                     /*!< IS3 (Bit 3)                                           */
#define SN_GPIO2_IS_IS3_Msk               (0x8UL)                   /*!< IS3 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO2_IS_IS4_Pos               (4UL)                     /*!< IS4 (Bit 4)                                           */
#define SN_GPIO2_IS_IS4_Msk               (0x10UL)                  /*!< IS4 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO2_IS_IS5_Pos               (5UL)                     /*!< IS5 (Bit 5)                                           */
#define SN_GPIO2_IS_IS5_Msk               (0x20UL)                  /*!< IS5 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO2_IS_IS6_Pos               (6UL)                     /*!< IS6 (Bit 6)                                           */
#define SN_GPIO2_IS_IS6_Msk               (0x40UL)                  /*!< IS6 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO2_IS_IS7_Pos               (7UL)                     /*!< IS7 (Bit 7)                                           */
#define SN_GPIO2_IS_IS7_Msk               (0x80UL)                  /*!< IS7 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO2_IS_IS8_Pos               (8UL)                     /*!< IS8 (Bit 8)                                           */
#define SN_GPIO2_IS_IS8_Msk               (0x100UL)                 /*!< IS8 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO2_IS_IS9_Pos               (9UL)                     /*!< IS9 (Bit 9)                                           */
#define SN_GPIO2_IS_IS9_Msk               (0x200UL)                 /*!< IS9 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO2_IS_IS10_Pos              (10UL)                    /*!< IS10 (Bit 10)                                         */
#define SN_GPIO2_IS_IS10_Msk              (0x400UL)                 /*!< IS10 (Bitfield-Mask: 0x01)                            */
/* ==========================================================  IBS  ========================================================== */
#define SN_GPIO2_IBS_IBS0_Pos             (0UL)                     /*!< IBS0 (Bit 0)                                          */
#define SN_GPIO2_IBS_IBS0_Msk             (0x1UL)                   /*!< IBS0 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO2_IBS_IBS1_Pos             (1UL)                     /*!< IBS1 (Bit 1)                                          */
#define SN_GPIO2_IBS_IBS1_Msk             (0x2UL)                   /*!< IBS1 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO2_IBS_IBS2_Pos             (2UL)                     /*!< IBS2 (Bit 2)                                          */
#define SN_GPIO2_IBS_IBS2_Msk             (0x4UL)                   /*!< IBS2 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO2_IBS_IBS3_Pos             (3UL)                     /*!< IBS3 (Bit 3)                                          */
#define SN_GPIO2_IBS_IBS3_Msk             (0x8UL)                   /*!< IBS3 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO2_IBS_IBS4_Pos             (4UL)                     /*!< IBS4 (Bit 4)                                          */
#define SN_GPIO2_IBS_IBS4_Msk             (0x10UL)                  /*!< IBS4 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO2_IBS_IBS5_Pos             (5UL)                     /*!< IBS5 (Bit 5)                                          */
#define SN_GPIO2_IBS_IBS5_Msk             (0x20UL)                  /*!< IBS5 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO2_IBS_IBS6_Pos             (6UL)                     /*!< IBS6 (Bit 6)                                          */
#define SN_GPIO2_IBS_IBS6_Msk             (0x40UL)                  /*!< IBS6 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO2_IBS_IBS7_Pos             (7UL)                     /*!< IBS7 (Bit 7)                                          */
#define SN_GPIO2_IBS_IBS7_Msk             (0x80UL)                  /*!< IBS7 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO2_IBS_IBS8_Pos             (8UL)                     /*!< IBS8 (Bit 8)                                          */
#define SN_GPIO2_IBS_IBS8_Msk             (0x100UL)                 /*!< IBS8 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO2_IBS_IBS9_Pos             (9UL)                     /*!< IBS9 (Bit 9)                                          */
#define SN_GPIO2_IBS_IBS9_Msk             (0x200UL)                 /*!< IBS9 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO2_IBS_IBS10_Pos            (10UL)                    /*!< IBS10 (Bit 10)                                        */
#define SN_GPIO2_IBS_IBS10_Msk            (0x400UL)                 /*!< IBS10 (Bitfield-Mask: 0x01)                           */
/* ==========================================================  IEV  ========================================================== */
#define SN_GPIO2_IEV_IEV0_Pos             (0UL)                     /*!< IEV0 (Bit 0)                                          */
#define SN_GPIO2_IEV_IEV0_Msk             (0x1UL)                   /*!< IEV0 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO2_IEV_IEV1_Pos             (1UL)                     /*!< IEV1 (Bit 1)                                          */
#define SN_GPIO2_IEV_IEV1_Msk             (0x2UL)                   /*!< IEV1 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO2_IEV_IEV2_Pos             (2UL)                     /*!< IEV2 (Bit 2)                                          */
#define SN_GPIO2_IEV_IEV2_Msk             (0x4UL)                   /*!< IEV2 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO2_IEV_IEV3_Pos             (3UL)                     /*!< IEV3 (Bit 3)                                          */
#define SN_GPIO2_IEV_IEV3_Msk             (0x8UL)                   /*!< IEV3 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO2_IEV_IEV4_Pos             (4UL)                     /*!< IEV4 (Bit 4)                                          */
#define SN_GPIO2_IEV_IEV4_Msk             (0x10UL)                  /*!< IEV4 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO2_IEV_IEV5_Pos             (5UL)                     /*!< IEV5 (Bit 5)                                          */
#define SN_GPIO2_IEV_IEV5_Msk             (0x20UL)                  /*!< IEV5 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO2_IEV_IEV6_Pos             (6UL)                     /*!< IEV6 (Bit 6)                                          */
#define SN_GPIO2_IEV_IEV6_Msk             (0x40UL)                  /*!< IEV6 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO2_IEV_IEV7_Pos             (7UL)                     /*!< IEV7 (Bit 7)                                          */
#define SN_GPIO2_IEV_IEV7_Msk             (0x80UL)                  /*!< IEV7 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO2_IEV_IEV8_Pos             (8UL)                     /*!< IEV8 (Bit 8)                                          */
#define SN_GPIO2_IEV_IEV8_Msk             (0x100UL)                 /*!< IEV8 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO2_IEV_IEV9_Pos             (9UL)                     /*!< IEV9 (Bit 9)                                          */
#define SN_GPIO2_IEV_IEV9_Msk             (0x200UL)                 /*!< IEV9 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO2_IEV_IEV10_Pos            (10UL)                    /*!< IEV10 (Bit 10)                                        */
#define SN_GPIO2_IEV_IEV10_Msk            (0x400UL)                 /*!< IEV10 (Bitfield-Mask: 0x01)                           */
/* ==========================================================  IE  =========================================================== */
#define SN_GPIO2_IE_IE0_Pos               (0UL)                     /*!< IE0 (Bit 0)                                           */
#define SN_GPIO2_IE_IE0_Msk               (0x1UL)                   /*!< IE0 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO2_IE_IE1_Pos               (1UL)                     /*!< IE1 (Bit 1)                                           */
#define SN_GPIO2_IE_IE1_Msk               (0x2UL)                   /*!< IE1 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO2_IE_IE2_Pos               (2UL)                     /*!< IE2 (Bit 2)                                           */
#define SN_GPIO2_IE_IE2_Msk               (0x4UL)                   /*!< IE2 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO2_IE_IE3_Pos               (3UL)                     /*!< IE3 (Bit 3)                                           */
#define SN_GPIO2_IE_IE3_Msk               (0x8UL)                   /*!< IE3 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO2_IE_IE4_Pos               (4UL)                     /*!< IE4 (Bit 4)                                           */
#define SN_GPIO2_IE_IE4_Msk               (0x10UL)                  /*!< IE4 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO2_IE_IE5_Pos               (5UL)                     /*!< IE5 (Bit 5)                                           */
#define SN_GPIO2_IE_IE5_Msk               (0x20UL)                  /*!< IE5 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO2_IE_IE6_Pos               (6UL)                     /*!< IE6 (Bit 6)                                           */
#define SN_GPIO2_IE_IE6_Msk               (0x40UL)                  /*!< IE6 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO2_IE_IE7_Pos               (7UL)                     /*!< IE7 (Bit 7)                                           */
#define SN_GPIO2_IE_IE7_Msk               (0x80UL)                  /*!< IE7 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO2_IE_IE8_Pos               (8UL)                     /*!< IE8 (Bit 8)                                           */
#define SN_GPIO2_IE_IE8_Msk               (0x100UL)                 /*!< IE8 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO2_IE_IE9_Pos               (9UL)                     /*!< IE9 (Bit 9)                                           */
#define SN_GPIO2_IE_IE9_Msk               (0x200UL)                 /*!< IE9 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO2_IE_IE10_Pos              (10UL)                    /*!< IE10 (Bit 10)                                         */
#define SN_GPIO2_IE_IE10_Msk              (0x400UL)                 /*!< IE10 (Bitfield-Mask: 0x01)                            */
/* ==========================================================  RIS  ========================================================== */
#define SN_GPIO2_RIS_IF0_Pos              (0UL)                     /*!< IF0 (Bit 0)                                           */
#define SN_GPIO2_RIS_IF0_Msk              (0x1UL)                   /*!< IF0 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO2_RIS_IF1_Pos              (1UL)                     /*!< IF1 (Bit 1)                                           */
#define SN_GPIO2_RIS_IF1_Msk              (0x2UL)                   /*!< IF1 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO2_RIS_IF2_Pos              (2UL)                     /*!< IF2 (Bit 2)                                           */
#define SN_GPIO2_RIS_IF2_Msk              (0x4UL)                   /*!< IF2 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO2_RIS_IF3_Pos              (3UL)                     /*!< IF3 (Bit 3)                                           */
#define SN_GPIO2_RIS_IF3_Msk              (0x8UL)                   /*!< IF3 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO2_RIS_IF4_Pos              (4UL)                     /*!< IF4 (Bit 4)                                           */
#define SN_GPIO2_RIS_IF4_Msk              (0x10UL)                  /*!< IF4 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO2_RIS_IF5_Pos              (5UL)                     /*!< IF5 (Bit 5)                                           */
#define SN_GPIO2_RIS_IF5_Msk              (0x20UL)                  /*!< IF5 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO2_RIS_IF6_Pos              (6UL)                     /*!< IF6 (Bit 6)                                           */
#define SN_GPIO2_RIS_IF6_Msk              (0x40UL)                  /*!< IF6 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO2_RIS_IF7_Pos              (7UL)                     /*!< IF7 (Bit 7)                                           */
#define SN_GPIO2_RIS_IF7_Msk              (0x80UL)                  /*!< IF7 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO2_RIS_IF8_Pos              (8UL)                     /*!< IF8 (Bit 8)                                           */
#define SN_GPIO2_RIS_IF8_Msk              (0x100UL)                 /*!< IF8 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO2_RIS_IF9_Pos              (9UL)                     /*!< IF9 (Bit 9)                                           */
#define SN_GPIO2_RIS_IF9_Msk              (0x200UL)                 /*!< IF9 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO2_RIS_IF10_Pos             (10UL)                    /*!< IF10 (Bit 10)                                         */
#define SN_GPIO2_RIS_IF10_Msk             (0x400UL)                 /*!< IF10 (Bitfield-Mask: 0x01)                            */
/* ==========================================================  IC  =========================================================== */
#define SN_GPIO2_IC_IC0_Pos               (0UL)                     /*!< IC0 (Bit 0)                                           */
#define SN_GPIO2_IC_IC0_Msk               (0x1UL)                   /*!< IC0 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO2_IC_IC1_Pos               (1UL)                     /*!< IC1 (Bit 1)                                           */
#define SN_GPIO2_IC_IC1_Msk               (0x2UL)                   /*!< IC1 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO2_IC_IC2_Pos               (2UL)                     /*!< IC2 (Bit 2)                                           */
#define SN_GPIO2_IC_IC2_Msk               (0x4UL)                   /*!< IC2 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO2_IC_IC3_Pos               (3UL)                     /*!< IC3 (Bit 3)                                           */
#define SN_GPIO2_IC_IC3_Msk               (0x8UL)                   /*!< IC3 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO2_IC_IC4_Pos               (4UL)                     /*!< IC4 (Bit 4)                                           */
#define SN_GPIO2_IC_IC4_Msk               (0x10UL)                  /*!< IC4 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO2_IC_IC5_Pos               (5UL)                     /*!< IC5 (Bit 5)                                           */
#define SN_GPIO2_IC_IC5_Msk               (0x20UL)                  /*!< IC5 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO2_IC_IC6_Pos               (6UL)                     /*!< IC6 (Bit 6)                                           */
#define SN_GPIO2_IC_IC6_Msk               (0x40UL)                  /*!< IC6 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO2_IC_IC7_Pos               (7UL)                     /*!< IC7 (Bit 7)                                           */
#define SN_GPIO2_IC_IC7_Msk               (0x80UL)                  /*!< IC7 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO2_IC_IC8_Pos               (8UL)                     /*!< IC8 (Bit 8)                                           */
#define SN_GPIO2_IC_IC8_Msk               (0x100UL)                 /*!< IC8 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO2_IC_IC9_Pos               (9UL)                     /*!< IC9 (Bit 9)                                           */
#define SN_GPIO2_IC_IC9_Msk               (0x200UL)                 /*!< IC9 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO2_IC_IC10_Pos              (10UL)                    /*!< IC10 (Bit 10)                                         */
#define SN_GPIO2_IC_IC10_Msk              (0x400UL)                 /*!< IC10 (Bitfield-Mask: 0x01)                            */
/* =========================================================  BSET  ========================================================== */
#define SN_GPIO2_BSET_BSET0_Pos           (0UL)                     /*!< BSET0 (Bit 0)                                         */
#define SN_GPIO2_BSET_BSET0_Msk           (0x1UL)                   /*!< BSET0 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO2_BSET_BSET1_Pos           (1UL)                     /*!< BSET1 (Bit 1)                                         */
#define SN_GPIO2_BSET_BSET1_Msk           (0x2UL)                   /*!< BSET1 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO2_BSET_BSET2_Pos           (2UL)                     /*!< BSET2 (Bit 2)                                         */
#define SN_GPIO2_BSET_BSET2_Msk           (0x4UL)                   /*!< BSET2 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO2_BSET_BSET3_Pos           (3UL)                     /*!< BSET3 (Bit 3)                                         */
#define SN_GPIO2_BSET_BSET3_Msk           (0x8UL)                   /*!< BSET3 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO2_BSET_BSET4_Pos           (4UL)                     /*!< BSET4 (Bit 4)                                         */
#define SN_GPIO2_BSET_BSET4_Msk           (0x10UL)                  /*!< BSET4 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO2_BSET_BSET5_Pos           (5UL)                     /*!< BSET5 (Bit 5)                                         */
#define SN_GPIO2_BSET_BSET5_Msk           (0x20UL)                  /*!< BSET5 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO2_BSET_BSET6_Pos           (6UL)                     /*!< BSET6 (Bit 6)                                         */
#define SN_GPIO2_BSET_BSET6_Msk           (0x40UL)                  /*!< BSET6 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO2_BSET_BSET7_Pos           (7UL)                     /*!< BSET7 (Bit 7)                                         */
#define SN_GPIO2_BSET_BSET7_Msk           (0x80UL)                  /*!< BSET7 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO2_BSET_BSET8_Pos           (8UL)                     /*!< BSET8 (Bit 8)                                         */
#define SN_GPIO2_BSET_BSET8_Msk           (0x100UL)                 /*!< BSET8 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO2_BSET_BSET9_Pos           (9UL)                     /*!< BSET9 (Bit 9)                                         */
#define SN_GPIO2_BSET_BSET9_Msk           (0x200UL)                 /*!< BSET9 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO2_BSET_BSET10_Pos          (10UL)                    /*!< BSET10 (Bit 10)                                       */
#define SN_GPIO2_BSET_BSET10_Msk          (0x400UL)                 /*!< BSET10 (Bitfield-Mask: 0x01)                          */
/* =========================================================  BCLR  ========================================================== */
#define SN_GPIO2_BCLR_BCLR0_Pos           (0UL)                     /*!< BCLR0 (Bit 0)                                         */
#define SN_GPIO2_BCLR_BCLR0_Msk           (0x1UL)                   /*!< BCLR0 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO2_BCLR_BCLR1_Pos           (1UL)                     /*!< BCLR1 (Bit 1)                                         */
#define SN_GPIO2_BCLR_BCLR1_Msk           (0x2UL)                   /*!< BCLR1 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO2_BCLR_BCLR2_Pos           (2UL)                     /*!< BCLR2 (Bit 2)                                         */
#define SN_GPIO2_BCLR_BCLR2_Msk           (0x4UL)                   /*!< BCLR2 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO2_BCLR_BCLR3_Pos           (3UL)                     /*!< BCLR3 (Bit 3)                                         */
#define SN_GPIO2_BCLR_BCLR3_Msk           (0x8UL)                   /*!< BCLR3 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO2_BCLR_BCLR4_Pos           (4UL)                     /*!< BCLR4 (Bit 4)                                         */
#define SN_GPIO2_BCLR_BCLR4_Msk           (0x10UL)                  /*!< BCLR4 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO2_BCLR_BCLR5_Pos           (5UL)                     /*!< BCLR5 (Bit 5)                                         */
#define SN_GPIO2_BCLR_BCLR5_Msk           (0x20UL)                  /*!< BCLR5 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO2_BCLR_BCLR6_Pos           (6UL)                     /*!< BCLR6 (Bit 6)                                         */
#define SN_GPIO2_BCLR_BCLR6_Msk           (0x40UL)                  /*!< BCLR6 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO2_BCLR_BCLR7_Pos           (7UL)                     /*!< BCLR7 (Bit 7)                                         */
#define SN_GPIO2_BCLR_BCLR7_Msk           (0x80UL)                  /*!< BCLR7 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO2_BCLR_BCLR8_Pos           (8UL)                     /*!< BCLR8 (Bit 8)                                         */
#define SN_GPIO2_BCLR_BCLR8_Msk           (0x100UL)                 /*!< BCLR8 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO2_BCLR_BCLR9_Pos           (9UL)                     /*!< BCLR9 (Bit 9)                                         */
#define SN_GPIO2_BCLR_BCLR9_Msk           (0x200UL)                 /*!< BCLR9 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO2_BCLR_BCLR10_Pos          (10UL)                    /*!< BCLR10 (Bit 10)                                       */
#define SN_GPIO2_BCLR_BCLR10_Msk          (0x400UL)                 /*!< BCLR10 (Bitfield-Mask: 0x01)                          */


/* =========================================================================================================================== */
/* ================                                         SN_GPIO3                                          ================ */
/* =========================================================================================================================== */

/* =========================================================  DATA  ========================================================== */
#define SN_GPIO3_DATA_DATA0_Pos           (0UL)                     /*!< DATA0 (Bit 0)                                         */
#define SN_GPIO3_DATA_DATA0_Msk           (0x1UL)                   /*!< DATA0 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO3_DATA_DATA1_Pos           (1UL)                     /*!< DATA1 (Bit 1)                                         */
#define SN_GPIO3_DATA_DATA1_Msk           (0x2UL)                   /*!< DATA1 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO3_DATA_DATA2_Pos           (2UL)                     /*!< DATA2 (Bit 2)                                         */
#define SN_GPIO3_DATA_DATA2_Msk           (0x4UL)                   /*!< DATA2 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO3_DATA_DATA3_Pos           (3UL)                     /*!< DATA3 (Bit 3)                                         */
#define SN_GPIO3_DATA_DATA3_Msk           (0x8UL)                   /*!< DATA3 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO3_DATA_DATA4_Pos           (4UL)                     /*!< DATA4 (Bit 4)                                         */
#define SN_GPIO3_DATA_DATA4_Msk           (0x10UL)                  /*!< DATA4 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO3_DATA_DATA5_Pos           (5UL)                     /*!< DATA5 (Bit 5)                                         */
#define SN_GPIO3_DATA_DATA5_Msk           (0x20UL)                  /*!< DATA5 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO3_DATA_DATA6_Pos           (6UL)                     /*!< DATA6 (Bit 6)                                         */
#define SN_GPIO3_DATA_DATA6_Msk           (0x40UL)                  /*!< DATA6 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO3_DATA_DATA7_Pos           (7UL)                     /*!< DATA7 (Bit 7)                                         */
#define SN_GPIO3_DATA_DATA7_Msk           (0x80UL)                  /*!< DATA7 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO3_DATA_DATA8_Pos           (8UL)                     /*!< DATA8 (Bit 8)                                         */
#define SN_GPIO3_DATA_DATA8_Msk           (0x100UL)                 /*!< DATA8 (Bitfield-Mask: 0x01)                           */
/* =========================================================  MODE  ========================================================== */
#define SN_GPIO3_MODE_MODE0_Pos           (0UL)                     /*!< MODE0 (Bit 0)                                         */
#define SN_GPIO3_MODE_MODE0_Msk           (0x1UL)                   /*!< MODE0 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO3_MODE_MODE1_Pos           (1UL)                     /*!< MODE1 (Bit 1)                                         */
#define SN_GPIO3_MODE_MODE1_Msk           (0x2UL)                   /*!< MODE1 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO3_MODE_MODE2_Pos           (2UL)                     /*!< MODE2 (Bit 2)                                         */
#define SN_GPIO3_MODE_MODE2_Msk           (0x4UL)                   /*!< MODE2 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO3_MODE_MODE3_Pos           (3UL)                     /*!< MODE3 (Bit 3)                                         */
#define SN_GPIO3_MODE_MODE3_Msk           (0x8UL)                   /*!< MODE3 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO3_MODE_MODE4_Pos           (4UL)                     /*!< MODE4 (Bit 4)                                         */
#define SN_GPIO3_MODE_MODE4_Msk           (0x10UL)                  /*!< MODE4 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO3_MODE_MODE5_Pos           (5UL)                     /*!< MODE5 (Bit 5)                                         */
#define SN_GPIO3_MODE_MODE5_Msk           (0x20UL)                  /*!< MODE5 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO3_MODE_MODE6_Pos           (6UL)                     /*!< MODE6 (Bit 6)                                         */
#define SN_GPIO3_MODE_MODE6_Msk           (0x40UL)                  /*!< MODE6 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO3_MODE_MODE7_Pos           (7UL)                     /*!< MODE7 (Bit 7)                                         */
#define SN_GPIO3_MODE_MODE7_Msk           (0x80UL)                  /*!< MODE7 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO3_MODE_MODE8_Pos           (8UL)                     /*!< MODE8 (Bit 8)                                         */
#define SN_GPIO3_MODE_MODE8_Msk           (0x100UL)                 /*!< MODE8 (Bitfield-Mask: 0x01)                           */
/* ==========================================================  CFG  ========================================================== */
#define SN_GPIO3_CFG_CFG0_Pos             (0UL)                     /*!< CFG0 (Bit 0)                                          */
#define SN_GPIO3_CFG_CFG0_Msk             (0x3UL)                   /*!< CFG0 (Bitfield-Mask: 0x03)                            */
#define SN_GPIO3_CFG_CFG1_Pos             (2UL)                     /*!< CFG1 (Bit 2)                                          */
#define SN_GPIO3_CFG_CFG1_Msk             (0xcUL)                   /*!< CFG1 (Bitfield-Mask: 0x03)                            */
#define SN_GPIO3_CFG_CFG2_Pos             (4UL)                     /*!< CFG2 (Bit 4)                                          */
#define SN_GPIO3_CFG_CFG2_Msk             (0x30UL)                  /*!< CFG2 (Bitfield-Mask: 0x03)                            */
#define SN_GPIO3_CFG_CFG3_Pos             (6UL)                     /*!< CFG3 (Bit 6)                                          */
#define SN_GPIO3_CFG_CFG3_Msk             (0xc0UL)                  /*!< CFG3 (Bitfield-Mask: 0x03)                            */
#define SN_GPIO3_CFG_CFG4_Pos             (8UL)                     /*!< CFG4 (Bit 8)                                          */
#define SN_GPIO3_CFG_CFG4_Msk             (0x300UL)                 /*!< CFG4 (Bitfield-Mask: 0x03)                            */
#define SN_GPIO3_CFG_CFG5_Pos             (10UL)                    /*!< CFG5 (Bit 10)                                         */
#define SN_GPIO3_CFG_CFG5_Msk             (0xc00UL)                 /*!< CFG5 (Bitfield-Mask: 0x03)                            */
#define SN_GPIO3_CFG_CFG6_Pos             (12UL)                    /*!< CFG6 (Bit 12)                                         */
#define SN_GPIO3_CFG_CFG6_Msk             (0x3000UL)                /*!< CFG6 (Bitfield-Mask: 0x03)                            */
#define SN_GPIO3_CFG_CFG7_Pos             (14UL)                    /*!< CFG7 (Bit 14)                                         */
#define SN_GPIO3_CFG_CFG7_Msk             (0xc000UL)                /*!< CFG7 (Bitfield-Mask: 0x03)                            */
#define SN_GPIO3_CFG_CFG8_Pos             (16UL)                    /*!< CFG8 (Bit 16)                                         */
#define SN_GPIO3_CFG_CFG8_Msk             (0x30000UL)               /*!< CFG8 (Bitfield-Mask: 0x03)                            */
/* ==========================================================  IS  =========================================================== */
#define SN_GPIO3_IS_IS0_Pos               (0UL)                     /*!< IS0 (Bit 0)                                           */
#define SN_GPIO3_IS_IS0_Msk               (0x1UL)                   /*!< IS0 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO3_IS_IS1_Pos               (1UL)                     /*!< IS1 (Bit 1)                                           */
#define SN_GPIO3_IS_IS1_Msk               (0x2UL)                   /*!< IS1 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO3_IS_IS2_Pos               (2UL)                     /*!< IS2 (Bit 2)                                           */
#define SN_GPIO3_IS_IS2_Msk               (0x4UL)                   /*!< IS2 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO3_IS_IS3_Pos               (3UL)                     /*!< IS3 (Bit 3)                                           */
#define SN_GPIO3_IS_IS3_Msk               (0x8UL)                   /*!< IS3 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO3_IS_IS4_Pos               (4UL)                     /*!< IS4 (Bit 4)                                           */
#define SN_GPIO3_IS_IS4_Msk               (0x10UL)                  /*!< IS4 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO3_IS_IS5_Pos               (5UL)                     /*!< IS5 (Bit 5)                                           */
#define SN_GPIO3_IS_IS5_Msk               (0x20UL)                  /*!< IS5 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO3_IS_IS6_Pos               (6UL)                     /*!< IS6 (Bit 6)                                           */
#define SN_GPIO3_IS_IS6_Msk               (0x40UL)                  /*!< IS6 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO3_IS_IS7_Pos               (7UL)                     /*!< IS7 (Bit 7)                                           */
#define SN_GPIO3_IS_IS7_Msk               (0x80UL)                  /*!< IS7 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO3_IS_IS8_Pos               (8UL)                     /*!< IS8 (Bit 8)                                           */
#define SN_GPIO3_IS_IS8_Msk               (0x100UL)                 /*!< IS8 (Bitfield-Mask: 0x01)                             */
/* ==========================================================  IBS  ========================================================== */
#define SN_GPIO3_IBS_IBS0_Pos             (0UL)                     /*!< IBS0 (Bit 0)                                          */
#define SN_GPIO3_IBS_IBS0_Msk             (0x1UL)                   /*!< IBS0 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO3_IBS_IBS1_Pos             (1UL)                     /*!< IBS1 (Bit 1)                                          */
#define SN_GPIO3_IBS_IBS1_Msk             (0x2UL)                   /*!< IBS1 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO3_IBS_IBS2_Pos             (2UL)                     /*!< IBS2 (Bit 2)                                          */
#define SN_GPIO3_IBS_IBS2_Msk             (0x4UL)                   /*!< IBS2 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO3_IBS_IBS3_Pos             (3UL)                     /*!< IBS3 (Bit 3)                                          */
#define SN_GPIO3_IBS_IBS3_Msk             (0x8UL)                   /*!< IBS3 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO3_IBS_IBS4_Pos             (4UL)                     /*!< IBS4 (Bit 4)                                          */
#define SN_GPIO3_IBS_IBS4_Msk             (0x10UL)                  /*!< IBS4 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO3_IBS_IBS5_Pos             (5UL)                     /*!< IBS5 (Bit 5)                                          */
#define SN_GPIO3_IBS_IBS5_Msk             (0x20UL)                  /*!< IBS5 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO3_IBS_IBS6_Pos             (6UL)                     /*!< IBS6 (Bit 6)                                          */
#define SN_GPIO3_IBS_IBS6_Msk             (0x40UL)                  /*!< IBS6 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO3_IBS_IBS7_Pos             (7UL)                     /*!< IBS7 (Bit 7)                                          */
#define SN_GPIO3_IBS_IBS7_Msk             (0x80UL)                  /*!< IBS7 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO3_IBS_IBS8_Pos             (8UL)                     /*!< IBS8 (Bit 8)                                          */
#define SN_GPIO3_IBS_IBS8_Msk             (0x100UL)                 /*!< IBS8 (Bitfield-Mask: 0x01)                            */
/* ==========================================================  IEV  ========================================================== */
#define SN_GPIO3_IEV_IEV0_Pos             (0UL)                     /*!< IEV0 (Bit 0)                                          */
#define SN_GPIO3_IEV_IEV0_Msk             (0x1UL)                   /*!< IEV0 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO3_IEV_IEV1_Pos             (1UL)                     /*!< IEV1 (Bit 1)                                          */
#define SN_GPIO3_IEV_IEV1_Msk             (0x2UL)                   /*!< IEV1 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO3_IEV_IEV2_Pos             (2UL)                     /*!< IEV2 (Bit 2)                                          */
#define SN_GPIO3_IEV_IEV2_Msk             (0x4UL)                   /*!< IEV2 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO3_IEV_IEV3_Pos             (3UL)                     /*!< IEV3 (Bit 3)                                          */
#define SN_GPIO3_IEV_IEV3_Msk             (0x8UL)                   /*!< IEV3 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO3_IEV_IEV4_Pos             (4UL)                     /*!< IEV4 (Bit 4)                                          */
#define SN_GPIO3_IEV_IEV4_Msk             (0x10UL)                  /*!< IEV4 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO3_IEV_IEV5_Pos             (5UL)                     /*!< IEV5 (Bit 5)                                          */
#define SN_GPIO3_IEV_IEV5_Msk             (0x20UL)                  /*!< IEV5 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO3_IEV_IEV6_Pos             (6UL)                     /*!< IEV6 (Bit 6)                                          */
#define SN_GPIO3_IEV_IEV6_Msk             (0x40UL)                  /*!< IEV6 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO3_IEV_IEV7_Pos             (7UL)                     /*!< IEV7 (Bit 7)                                          */
#define SN_GPIO3_IEV_IEV7_Msk             (0x80UL)                  /*!< IEV7 (Bitfield-Mask: 0x01)                            */
#define SN_GPIO3_IEV_IEV8_Pos             (8UL)                     /*!< IEV8 (Bit 8)                                          */
#define SN_GPIO3_IEV_IEV8_Msk             (0x100UL)                 /*!< IEV8 (Bitfield-Mask: 0x01)                            */
/* ==========================================================  IE  =========================================================== */
#define SN_GPIO3_IE_IE0_Pos               (0UL)                     /*!< IE0 (Bit 0)                                           */
#define SN_GPIO3_IE_IE0_Msk               (0x1UL)                   /*!< IE0 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO3_IE_IE1_Pos               (1UL)                     /*!< IE1 (Bit 1)                                           */
#define SN_GPIO3_IE_IE1_Msk               (0x2UL)                   /*!< IE1 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO3_IE_IE2_Pos               (2UL)                     /*!< IE2 (Bit 2)                                           */
#define SN_GPIO3_IE_IE2_Msk               (0x4UL)                   /*!< IE2 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO3_IE_IE3_Pos               (3UL)                     /*!< IE3 (Bit 3)                                           */
#define SN_GPIO3_IE_IE3_Msk               (0x8UL)                   /*!< IE3 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO3_IE_IE4_Pos               (4UL)                     /*!< IE4 (Bit 4)                                           */
#define SN_GPIO3_IE_IE4_Msk               (0x10UL)                  /*!< IE4 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO3_IE_IE5_Pos               (5UL)                     /*!< IE5 (Bit 5)                                           */
#define SN_GPIO3_IE_IE5_Msk               (0x20UL)                  /*!< IE5 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO3_IE_IE6_Pos               (6UL)                     /*!< IE6 (Bit 6)                                           */
#define SN_GPIO3_IE_IE6_Msk               (0x40UL)                  /*!< IE6 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO3_IE_IE7_Pos               (7UL)                     /*!< IE7 (Bit 7)                                           */
#define SN_GPIO3_IE_IE7_Msk               (0x80UL)                  /*!< IE7 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO3_IE_IE8_Pos               (8UL)                     /*!< IE8 (Bit 8)                                           */
#define SN_GPIO3_IE_IE8_Msk               (0x100UL)                 /*!< IE8 (Bitfield-Mask: 0x01)                             */
/* ==========================================================  RIS  ========================================================== */
#define SN_GPIO3_RIS_IF0_Pos              (0UL)                     /*!< IF0 (Bit 0)                                           */
#define SN_GPIO3_RIS_IF0_Msk              (0x1UL)                   /*!< IF0 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO3_RIS_IF1_Pos              (1UL)                     /*!< IF1 (Bit 1)                                           */
#define SN_GPIO3_RIS_IF1_Msk              (0x2UL)                   /*!< IF1 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO3_RIS_IF2_Pos              (2UL)                     /*!< IF2 (Bit 2)                                           */
#define SN_GPIO3_RIS_IF2_Msk              (0x4UL)                   /*!< IF2 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO3_RIS_IF3_Pos              (3UL)                     /*!< IF3 (Bit 3)                                           */
#define SN_GPIO3_RIS_IF3_Msk              (0x8UL)                   /*!< IF3 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO3_RIS_IF4_Pos              (4UL)                     /*!< IF4 (Bit 4)                                           */
#define SN_GPIO3_RIS_IF4_Msk              (0x10UL)                  /*!< IF4 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO3_RIS_IF5_Pos              (5UL)                     /*!< IF5 (Bit 5)                                           */
#define SN_GPIO3_RIS_IF5_Msk              (0x20UL)                  /*!< IF5 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO3_RIS_IF6_Pos              (6UL)                     /*!< IF6 (Bit 6)                                           */
#define SN_GPIO3_RIS_IF6_Msk              (0x40UL)                  /*!< IF6 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO3_RIS_IF7_Pos              (7UL)                     /*!< IF7 (Bit 7)                                           */
#define SN_GPIO3_RIS_IF7_Msk              (0x80UL)                  /*!< IF7 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO3_RIS_IF8_Pos              (8UL)                     /*!< IF8 (Bit 8)                                           */
#define SN_GPIO3_RIS_IF8_Msk              (0x100UL)                 /*!< IF8 (Bitfield-Mask: 0x01)                             */
/* ==========================================================  IC  =========================================================== */
#define SN_GPIO3_IC_IC0_Pos               (0UL)                     /*!< IC0 (Bit 0)                                           */
#define SN_GPIO3_IC_IC0_Msk               (0x1UL)                   /*!< IC0 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO3_IC_IC1_Pos               (1UL)                     /*!< IC1 (Bit 1)                                           */
#define SN_GPIO3_IC_IC1_Msk               (0x2UL)                   /*!< IC1 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO3_IC_IC2_Pos               (2UL)                     /*!< IC2 (Bit 2)                                           */
#define SN_GPIO3_IC_IC2_Msk               (0x4UL)                   /*!< IC2 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO3_IC_IC3_Pos               (3UL)                     /*!< IC3 (Bit 3)                                           */
#define SN_GPIO3_IC_IC3_Msk               (0x8UL)                   /*!< IC3 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO3_IC_IC4_Pos               (4UL)                     /*!< IC4 (Bit 4)                                           */
#define SN_GPIO3_IC_IC4_Msk               (0x10UL)                  /*!< IC4 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO3_IC_IC5_Pos               (5UL)                     /*!< IC5 (Bit 5)                                           */
#define SN_GPIO3_IC_IC5_Msk               (0x20UL)                  /*!< IC5 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO3_IC_IC6_Pos               (6UL)                     /*!< IC6 (Bit 6)                                           */
#define SN_GPIO3_IC_IC6_Msk               (0x40UL)                  /*!< IC6 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO3_IC_IC7_Pos               (7UL)                     /*!< IC7 (Bit 7)                                           */
#define SN_GPIO3_IC_IC7_Msk               (0x80UL)                  /*!< IC7 (Bitfield-Mask: 0x01)                             */
#define SN_GPIO3_IC_IC8_Pos               (8UL)                     /*!< IC8 (Bit 8)                                           */
#define SN_GPIO3_IC_IC8_Msk               (0x100UL)                 /*!< IC8 (Bitfield-Mask: 0x01)                             */
/* =========================================================  BSET  ========================================================== */
#define SN_GPIO3_BSET_BSET0_Pos           (0UL)                     /*!< BSET0 (Bit 0)                                         */
#define SN_GPIO3_BSET_BSET0_Msk           (0x1UL)                   /*!< BSET0 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO3_BSET_BSET1_Pos           (1UL)                     /*!< BSET1 (Bit 1)                                         */
#define SN_GPIO3_BSET_BSET1_Msk           (0x2UL)                   /*!< BSET1 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO3_BSET_BSET2_Pos           (2UL)                     /*!< BSET2 (Bit 2)                                         */
#define SN_GPIO3_BSET_BSET2_Msk           (0x4UL)                   /*!< BSET2 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO3_BSET_BSET3_Pos           (3UL)                     /*!< BSET3 (Bit 3)                                         */
#define SN_GPIO3_BSET_BSET3_Msk           (0x8UL)                   /*!< BSET3 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO3_BSET_BSET4_Pos           (4UL)                     /*!< BSET4 (Bit 4)                                         */
#define SN_GPIO3_BSET_BSET4_Msk           (0x10UL)                  /*!< BSET4 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO3_BSET_BSET5_Pos           (5UL)                     /*!< BSET5 (Bit 5)                                         */
#define SN_GPIO3_BSET_BSET5_Msk           (0x20UL)                  /*!< BSET5 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO3_BSET_BSET6_Pos           (6UL)                     /*!< BSET6 (Bit 6)                                         */
#define SN_GPIO3_BSET_BSET6_Msk           (0x40UL)                  /*!< BSET6 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO3_BSET_BSET7_Pos           (7UL)                     /*!< BSET7 (Bit 7)                                         */
#define SN_GPIO3_BSET_BSET7_Msk           (0x80UL)                  /*!< BSET7 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO3_BSET_BSET8_Pos           (8UL)                     /*!< BSET8 (Bit 8)                                         */
#define SN_GPIO3_BSET_BSET8_Msk           (0x100UL)                 /*!< BSET8 (Bitfield-Mask: 0x01)                           */
/* =========================================================  BCLR  ========================================================== */
#define SN_GPIO3_BCLR_BCLR0_Pos           (0UL)                     /*!< BCLR0 (Bit 0)                                         */
#define SN_GPIO3_BCLR_BCLR0_Msk           (0x1UL)                   /*!< BCLR0 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO3_BCLR_BCLR1_Pos           (1UL)                     /*!< BCLR1 (Bit 1)                                         */
#define SN_GPIO3_BCLR_BCLR1_Msk           (0x2UL)                   /*!< BCLR1 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO3_BCLR_BCLR2_Pos           (2UL)                     /*!< BCLR2 (Bit 2)                                         */
#define SN_GPIO3_BCLR_BCLR2_Msk           (0x4UL)                   /*!< BCLR2 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO3_BCLR_BCLR3_Pos           (3UL)                     /*!< BCLR3 (Bit 3)                                         */
#define SN_GPIO3_BCLR_BCLR3_Msk           (0x8UL)                   /*!< BCLR3 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO3_BCLR_BCLR4_Pos           (4UL)                     /*!< BCLR4 (Bit 4)                                         */
#define SN_GPIO3_BCLR_BCLR4_Msk           (0x10UL)                  /*!< BCLR4 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO3_BCLR_BCLR5_Pos           (5UL)                     /*!< BCLR5 (Bit 5)                                         */
#define SN_GPIO3_BCLR_BCLR5_Msk           (0x20UL)                  /*!< BCLR5 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO3_BCLR_BCLR6_Pos           (6UL)                     /*!< BCLR6 (Bit 6)                                         */
#define SN_GPIO3_BCLR_BCLR6_Msk           (0x40UL)                  /*!< BCLR6 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO3_BCLR_BCLR7_Pos           (7UL)                     /*!< BCLR7 (Bit 7)                                         */
#define SN_GPIO3_BCLR_BCLR7_Msk           (0x80UL)                  /*!< BCLR7 (Bitfield-Mask: 0x01)                           */
#define SN_GPIO3_BCLR_BCLR8_Pos           (8UL)                     /*!< BCLR8 (Bit 8)                                         */
#define SN_GPIO3_BCLR_BCLR8_Msk           (0x100UL)                 /*!< BCLR8 (Bitfield-Mask: 0x01)                           */


/* =========================================================================================================================== */
/* ================                                          SN_WDT                                           ================ */
/* =========================================================================================================================== */

/* ==========================================================  CFG  ========================================================== */
#define SN_WDT_CFG_WDTEN_Pos              (0UL)                     /*!< WDTEN (Bit 0)                                         */
#define SN_WDT_CFG_WDTEN_Msk              (0x1UL)                   /*!< WDTEN (Bitfield-Mask: 0x01)                           */
#define SN_WDT_CFG_WDTIE_Pos              (1UL)                     /*!< WDTIE (Bit 1)                                         */
#define SN_WDT_CFG_WDTIE_Msk              (0x2UL)                   /*!< WDTIE (Bitfield-Mask: 0x01)                           */
#define SN_WDT_CFG_WDTINT_Pos             (2UL)                     /*!< WDTINT (Bit 2)                                        */
#define SN_WDT_CFG_WDTINT_Msk             (0x4UL)                   /*!< WDTINT (Bitfield-Mask: 0x01)                          */
#define SN_WDT_CFG_WDKEY_Pos              (16UL)                    /*!< WDKEY (Bit 16)                                        */
#define SN_WDT_CFG_WDKEY_Msk              (0xffff0000UL)            /*!< WDKEY (Bitfield-Mask: 0xffff)                         */
/* =======================================================  CLKSOURCE  ======================================================= */
#define SN_WDT_CLKSOURCE_CLKSEL_Pos       (0UL)                     /*!< CLKSEL (Bit 0)                                        */
#define SN_WDT_CLKSOURCE_CLKSEL_Msk       (0x3UL)                   /*!< CLKSEL (Bitfield-Mask: 0x03)                          */
#define SN_WDT_CLKSOURCE_WDKEY_Pos        (16UL)                    /*!< WDKEY (Bit 16)                                        */
#define SN_WDT_CLKSOURCE_WDKEY_Msk        (0xffff0000UL)            /*!< WDKEY (Bitfield-Mask: 0xffff)                         */
/* ==========================================================  TC  =========================================================== */
#define SN_WDT_TC_TC_Pos                  (0UL)                     /*!< TC (Bit 0)                                            */
#define SN_WDT_TC_TC_Msk                  (0xffUL)                  /*!< TC (Bitfield-Mask: 0xff)                              */
#define SN_WDT_TC_WDKEY_Pos               (16UL)                    /*!< WDKEY (Bit 16)                                        */
#define SN_WDT_TC_WDKEY_Msk               (0xffff0000UL)            /*!< WDKEY (Bitfield-Mask: 0xffff)                         */
/* =========================================================  FEED  ========================================================== */
#define SN_WDT_FEED_FV_Pos                (0UL)                     /*!< FV (Bit 0)                                            */
#define SN_WDT_FEED_FV_Msk                (0xffffUL)                /*!< FV (Bitfield-Mask: 0xffff)                            */
#define SN_WDT_FEED_WDKEY_Pos             (16UL)                    /*!< WDKEY (Bit 16)                                        */
#define SN_WDT_FEED_WDKEY_Msk             (0xffff0000UL)            /*!< WDKEY (Bitfield-Mask: 0xffff)                         */


/* =========================================================================================================================== */
/* ================                                         SN_CT16B0                                         ================ */
/* =========================================================================================================================== */

/* ========================================================  TMRCTRL  ======================================================== */
#define SN_CT16B0_TMRCTRL_CEN_Pos         (0UL)                     /*!< CEN (Bit 0)                                           */
#define SN_CT16B0_TMRCTRL_CEN_Msk         (0x1UL)                   /*!< CEN (Bitfield-Mask: 0x01)                             */
#define SN_CT16B0_TMRCTRL_CRST_Pos        (1UL)                     /*!< CRST (Bit 1)                                          */
#define SN_CT16B0_TMRCTRL_CRST_Msk        (0x2UL)                   /*!< CRST (Bitfield-Mask: 0x01)                            */
/* ==========================================================  TC  =========================================================== */
#define SN_CT16B0_TC_TC_Pos               (0UL)                     /*!< TC (Bit 0)                                            */
#define SN_CT16B0_TC_TC_Msk               (0xffffUL)                /*!< TC (Bitfield-Mask: 0xffff)                            */
/* ==========================================================  PRE  ========================================================== */
#define SN_CT16B0_PRE_PRE_Pos             (0UL)                     /*!< PRE (Bit 0)                                           */
#define SN_CT16B0_PRE_PRE_Msk             (0xffUL)                  /*!< PRE (Bitfield-Mask: 0xff)                             */
/* ==========================================================  PC  =========================================================== */
#define SN_CT16B0_PC_PC_Pos               (0UL)                     /*!< PC (Bit 0)                                            */
#define SN_CT16B0_PC_PC_Msk               (0xffUL)                  /*!< PC (Bitfield-Mask: 0xff)                              */
/* ========================================================  CNTCTRL  ======================================================== */
#define SN_CT16B0_CNTCTRL_CTM_Pos         (0UL)                     /*!< CTM (Bit 0)                                           */
#define SN_CT16B0_CNTCTRL_CTM_Msk         (0x3UL)                   /*!< CTM (Bitfield-Mask: 0x03)                             */
#define SN_CT16B0_CNTCTRL_CIS_Pos         (2UL)                     /*!< CIS (Bit 2)                                           */
#define SN_CT16B0_CNTCTRL_CIS_Msk         (0xcUL)                   /*!< CIS (Bitfield-Mask: 0x03)                             */
/* =========================================================  MCTRL  ========================================================= */
#define SN_CT16B0_MCTRL_MR0IE_Pos         (0UL)                     /*!< MR0IE (Bit 0)                                         */
#define SN_CT16B0_MCTRL_MR0IE_Msk         (0x1UL)                   /*!< MR0IE (Bitfield-Mask: 0x01)                           */
#define SN_CT16B0_MCTRL_MR0RST_Pos        (1UL)                     /*!< MR0RST (Bit 1)                                        */
#define SN_CT16B0_MCTRL_MR0RST_Msk        (0x2UL)                   /*!< MR0RST (Bitfield-Mask: 0x01)                          */
#define SN_CT16B0_MCTRL_MR0STOP_Pos       (2UL)                     /*!< MR0STOP (Bit 2)                                       */
#define SN_CT16B0_MCTRL_MR0STOP_Msk       (0x4UL)                   /*!< MR0STOP (Bitfield-Mask: 0x01)                         */
/* ==========================================================  MR0  ========================================================== */
/* ========================================================  CAPCTRL  ======================================================== */
#define SN_CT16B0_CAPCTRL_CAP0RE_Pos      (0UL)                     /*!< CAP0RE (Bit 0)                                        */
#define SN_CT16B0_CAPCTRL_CAP0RE_Msk      (0x1UL)                   /*!< CAP0RE (Bitfield-Mask: 0x01)                          */
#define SN_CT16B0_CAPCTRL_CAP0FE_Pos      (1UL)                     /*!< CAP0FE (Bit 1)                                        */
#define SN_CT16B0_CAPCTRL_CAP0FE_Msk      (0x2UL)                   /*!< CAP0FE (Bitfield-Mask: 0x01)                          */
#define SN_CT16B0_CAPCTRL_CAP0IE_Pos      (2UL)                     /*!< CAP0IE (Bit 2)                                        */
#define SN_CT16B0_CAPCTRL_CAP0IE_Msk      (0x4UL)                   /*!< CAP0IE (Bitfield-Mask: 0x01)                          */
#define SN_CT16B0_CAPCTRL_CAP0EN_Pos      (3UL)                     /*!< CAP0EN (Bit 3)                                        */
#define SN_CT16B0_CAPCTRL_CAP0EN_Msk      (0x8UL)                   /*!< CAP0EN (Bitfield-Mask: 0x01)                          */
/* =========================================================  CAP0  ========================================================== */
#define SN_CT16B0_CAP0_CAP0_Pos           (0UL)                     /*!< CAP0 (Bit 0)                                          */
#define SN_CT16B0_CAP0_CAP0_Msk           (0xffffUL)                /*!< CAP0 (Bitfield-Mask: 0xffff)                          */
/* ==========================================================  RIS  ========================================================== */
#define SN_CT16B0_RIS_MR0IF_Pos           (0UL)                     /*!< MR0IF (Bit 0)                                         */
#define SN_CT16B0_RIS_MR0IF_Msk           (0x1UL)                   /*!< MR0IF (Bitfield-Mask: 0x01)                           */
#define SN_CT16B0_RIS_CAP0IF_Pos          (24UL)                    /*!< CAP0IF (Bit 24)                                       */
#define SN_CT16B0_RIS_CAP0IF_Msk          (0x1000000UL)             /*!< CAP0IF (Bitfield-Mask: 0x01)                          */
/* ==========================================================  IC  =========================================================== */
#define SN_CT16B0_IC_MR0IC_Pos            (0UL)                     /*!< MR0IC (Bit 0)                                         */
#define SN_CT16B0_IC_MR0IC_Msk            (0x1UL)                   /*!< MR0IC (Bitfield-Mask: 0x01)                           */
#define SN_CT16B0_IC_CAP0IC_Pos           (24UL)                    /*!< CAP0IC (Bit 24)                                       */
#define SN_CT16B0_IC_CAP0IC_Msk           (0x1000000UL)             /*!< CAP0IC (Bitfield-Mask: 0x01)                          */


/* =========================================================================================================================== */
/* ================                                         SN_CT16B1                                         ================ */
/* =========================================================================================================================== */

/* ========================================================  TMRCTRL  ======================================================== */
#define SN_CT16B1_TMRCTRL_CEN_Pos         (0UL)                     /*!< CEN (Bit 0)                                           */
#define SN_CT16B1_TMRCTRL_CEN_Msk         (0x1UL)                   /*!< CEN (Bitfield-Mask: 0x01)                             */
#define SN_CT16B1_TMRCTRL_CRST_Pos        (1UL)                     /*!< CRST (Bit 1)                                          */
#define SN_CT16B1_TMRCTRL_CRST_Msk        (0x2UL)                   /*!< CRST (Bitfield-Mask: 0x01)                            */
/* ==========================================================  TC  =========================================================== */
#define SN_CT16B1_TC_TC_Pos               (0UL)                     /*!< TC (Bit 0)                                            */
#define SN_CT16B1_TC_TC_Msk               (0xffffUL)                /*!< TC (Bitfield-Mask: 0xffff)                            */
/* ==========================================================  PRE  ========================================================== */
#define SN_CT16B1_PRE_PRE_Pos             (0UL)                     /*!< PRE (Bit 0)                                           */
#define SN_CT16B1_PRE_PRE_Msk             (0xffUL)                  /*!< PRE (Bitfield-Mask: 0xff)                             */
/* ==========================================================  PC  =========================================================== */
#define SN_CT16B1_PC_PC_Pos               (0UL)                     /*!< PC (Bit 0)                                            */
#define SN_CT16B1_PC_PC_Msk               (0xffUL)                  /*!< PC (Bitfield-Mask: 0xff)                              */
/* =========================================================  MCTRL  ========================================================= */
#define SN_CT16B1_MCTRL_MR0IE_Pos         (0UL)                     /*!< MR0IE (Bit 0)                                         */
#define SN_CT16B1_MCTRL_MR0IE_Msk         (0x1UL)                   /*!< MR0IE (Bitfield-Mask: 0x01)                           */
#define SN_CT16B1_MCTRL_MR0RST_Pos        (1UL)                     /*!< MR0RST (Bit 1)                                        */
#define SN_CT16B1_MCTRL_MR0RST_Msk        (0x2UL)                   /*!< MR0RST (Bitfield-Mask: 0x01)                          */
#define SN_CT16B1_MCTRL_MR0STOP_Pos       (2UL)                     /*!< MR0STOP (Bit 2)                                       */
#define SN_CT16B1_MCTRL_MR0STOP_Msk       (0x4UL)                   /*!< MR0STOP (Bitfield-Mask: 0x01)                         */
#define SN_CT16B1_MCTRL_MR1IE_Pos         (3UL)                     /*!< MR1IE (Bit 3)                                         */
#define SN_CT16B1_MCTRL_MR1IE_Msk         (0x8UL)                   /*!< MR1IE (Bitfield-Mask: 0x01)                           */
#define SN_CT16B1_MCTRL_MR1RST_Pos        (4UL)                     /*!< MR1RST (Bit 4)                                        */
#define SN_CT16B1_MCTRL_MR1RST_Msk        (0x10UL)                  /*!< MR1RST (Bitfield-Mask: 0x01)                          */
#define SN_CT16B1_MCTRL_MR1STOP_Pos       (5UL)                     /*!< MR1STOP (Bit 5)                                       */
#define SN_CT16B1_MCTRL_MR1STOP_Msk       (0x20UL)                  /*!< MR1STOP (Bitfield-Mask: 0x01)                         */
#define SN_CT16B1_MCTRL_MR2IE_Pos         (6UL)                     /*!< MR2IE (Bit 6)                                         */
#define SN_CT16B1_MCTRL_MR2IE_Msk         (0x40UL)                  /*!< MR2IE (Bitfield-Mask: 0x01)                           */
#define SN_CT16B1_MCTRL_MR2RST_Pos        (7UL)                     /*!< MR2RST (Bit 7)                                        */
#define SN_CT16B1_MCTRL_MR2RST_Msk        (0x80UL)                  /*!< MR2RST (Bitfield-Mask: 0x01)                          */
#define SN_CT16B1_MCTRL_MR2STOP_Pos       (8UL)                     /*!< MR2STOP (Bit 8)                                       */
#define SN_CT16B1_MCTRL_MR2STOP_Msk       (0x100UL)                 /*!< MR2STOP (Bitfield-Mask: 0x01)                         */
#define SN_CT16B1_MCTRL_MR3IE_Pos         (9UL)                     /*!< MR3IE (Bit 9)                                         */
#define SN_CT16B1_MCTRL_MR3IE_Msk         (0x200UL)                 /*!< MR3IE (Bitfield-Mask: 0x01)                           */
#define SN_CT16B1_MCTRL_MR3RST_Pos        (10UL)                    /*!< MR3RST (Bit 10)                                       */
#define SN_CT16B1_MCTRL_MR3RST_Msk        (0x400UL)                 /*!< MR3RST (Bitfield-Mask: 0x01)                          */
#define SN_CT16B1_MCTRL_MR3STOP_Pos       (11UL)                    /*!< MR3STOP (Bit 11)                                      */
#define SN_CT16B1_MCTRL_MR3STOP_Msk       (0x800UL)                 /*!< MR3STOP (Bitfield-Mask: 0x01)                         */
#define SN_CT16B1_MCTRL_MR4IE_Pos         (12UL)                    /*!< MR4IE (Bit 12)                                        */
#define SN_CT16B1_MCTRL_MR4IE_Msk         (0x1000UL)                /*!< MR4IE (Bitfield-Mask: 0x01)                           */
#define SN_CT16B1_MCTRL_MR4RST_Pos        (13UL)                    /*!< MR4RST (Bit 13)                                       */
#define SN_CT16B1_MCTRL_MR4RST_Msk        (0x2000UL)                /*!< MR4RST (Bitfield-Mask: 0x01)                          */
#define SN_CT16B1_MCTRL_MR4STOP_Pos       (14UL)                    /*!< MR4STOP (Bit 14)                                      */
#define SN_CT16B1_MCTRL_MR4STOP_Msk       (0x4000UL)                /*!< MR4STOP (Bitfield-Mask: 0x01)                         */
#define SN_CT16B1_MCTRL_MR5IE_Pos         (15UL)                    /*!< MR5IE (Bit 15)                                        */
#define SN_CT16B1_MCTRL_MR5IE_Msk         (0x8000UL)                /*!< MR5IE (Bitfield-Mask: 0x01)                           */
#define SN_CT16B1_MCTRL_MR5RST_Pos        (16UL)                    /*!< MR5RST (Bit 16)                                       */
#define SN_CT16B1_MCTRL_MR5RST_Msk        (0x10000UL)               /*!< MR5RST (Bitfield-Mask: 0x01)                          */
#define SN_CT16B1_MCTRL_MR5STOP_Pos       (17UL)                    /*!< MR5STOP (Bit 17)                                      */
#define SN_CT16B1_MCTRL_MR5STOP_Msk       (0x20000UL)               /*!< MR5STOP (Bitfield-Mask: 0x01)                         */
#define SN_CT16B1_MCTRL_MR6IE_Pos         (18UL)                    /*!< MR6IE (Bit 18)                                        */
#define SN_CT16B1_MCTRL_MR6IE_Msk         (0x40000UL)               /*!< MR6IE (Bitfield-Mask: 0x01)                           */
#define SN_CT16B1_MCTRL_MR6RST_Pos        (19UL)                    /*!< MR6RST (Bit 19)                                       */
#define SN_CT16B1_MCTRL_MR6RST_Msk        (0x80000UL)               /*!< MR6RST (Bitfield-Mask: 0x01)                          */
#define SN_CT16B1_MCTRL_MR6STOP_Pos       (20UL)                    /*!< MR6STOP (Bit 20)                                      */
#define SN_CT16B1_MCTRL_MR6STOP_Msk       (0x100000UL)              /*!< MR6STOP (Bitfield-Mask: 0x01)                         */
#define SN_CT16B1_MCTRL_MR7IE_Pos         (21UL)                    /*!< MR7IE (Bit 21)                                        */
#define SN_CT16B1_MCTRL_MR7IE_Msk         (0x200000UL)              /*!< MR7IE (Bitfield-Mask: 0x01)                           */
#define SN_CT16B1_MCTRL_MR7RST_Pos        (22UL)                    /*!< MR7RST (Bit 22)                                       */
#define SN_CT16B1_MCTRL_MR7RST_Msk        (0x400000UL)              /*!< MR7RST (Bitfield-Mask: 0x01)                          */
#define SN_CT16B1_MCTRL_MR7STOP_Pos       (23UL)                    /*!< MR7STOP (Bit 23)                                      */
#define SN_CT16B1_MCTRL_MR7STOP_Msk       (0x800000UL)              /*!< MR7STOP (Bitfield-Mask: 0x01)                         */
#define SN_CT16B1_MCTRL_MR8IE_Pos         (24UL)                    /*!< MR8IE (Bit 24)                                        */
#define SN_CT16B1_MCTRL_MR8IE_Msk         (0x1000000UL)             /*!< MR8IE (Bitfield-Mask: 0x01)                           */
#define SN_CT16B1_MCTRL_MR8RST_Pos        (25UL)                    /*!< MR8RST (Bit 25)                                       */
#define SN_CT16B1_MCTRL_MR8RST_Msk        (0x2000000UL)             /*!< MR8RST (Bitfield-Mask: 0x01)                          */
#define SN_CT16B1_MCTRL_MR8STOP_Pos       (26UL)                    /*!< MR8STOP (Bit 26)                                      */
#define SN_CT16B1_MCTRL_MR8STOP_Msk       (0x4000000UL)             /*!< MR8STOP (Bitfield-Mask: 0x01)                         */
#define SN_CT16B1_MCTRL_MR9IE_Pos         (27UL)                    /*!< MR9IE (Bit 27)                                        */
#define SN_CT16B1_MCTRL_MR9IE_Msk         (0x8000000UL)             /*!< MR9IE (Bitfield-Mask: 0x01)                           */
#define SN_CT16B1_MCTRL_MR9RST_Pos        (28UL)                    /*!< MR9RST (Bit 28)                                       */
#define SN_CT16B1_MCTRL_MR9RST_Msk        (0x10000000UL)            /*!< MR9RST (Bitfield-Mask: 0x01)                          */
#define SN_CT16B1_MCTRL_MR9STOP_Pos       (29UL)                    /*!< MR9STOP (Bit 29)                                      */
#define SN_CT16B1_MCTRL_MR9STOP_Msk       (0x20000000UL)            /*!< MR9STOP (Bitfield-Mask: 0x01)                         */
/* ========================================================  MCTRL2  ========================================================= */
#define SN_CT16B1_MCTRL2_MR10IE_Pos       (0UL)                     /*!< MR10IE (Bit 0)                                        */
#define SN_CT16B1_MCTRL2_MR10IE_Msk       (0x1UL)                   /*!< MR10IE (Bitfield-Mask: 0x01)                          */
#define SN_CT16B1_MCTRL2_MR10RST_Pos      (1UL)                     /*!< MR10RST (Bit 1)                                       */
#define SN_CT16B1_MCTRL2_MR10RST_Msk      (0x2UL)                   /*!< MR10RST (Bitfield-Mask: 0x01)                         */
#define SN_CT16B1_MCTRL2_MR10STOP_Pos     (2UL)                     /*!< MR10STOP (Bit 2)                                      */
#define SN_CT16B1_MCTRL2_MR10STOP_Msk     (0x4UL)                   /*!< MR10STOP (Bitfield-Mask: 0x01)                        */
#define SN_CT16B1_MCTRL2_MR11IE_Pos       (3UL)                     /*!< MR11IE (Bit 3)                                        */
#define SN_CT16B1_MCTRL2_MR11IE_Msk       (0x8UL)                   /*!< MR11IE (Bitfield-Mask: 0x01)                          */
#define SN_CT16B1_MCTRL2_MR11RST_Pos      (4UL)                     /*!< MR11RST (Bit 4)                                       */
#define SN_CT16B1_MCTRL2_MR11RST_Msk      (0x10UL)                  /*!< MR11RST (Bitfield-Mask: 0x01)                         */
#define SN_CT16B1_MCTRL2_MR11STOP_Pos     (5UL)                     /*!< MR11STOP (Bit 5)                                      */
#define SN_CT16B1_MCTRL2_MR11STOP_Msk     (0x20UL)                  /*!< MR11STOP (Bitfield-Mask: 0x01)                        */
#define SN_CT16B1_MCTRL2_MR12IE_Pos       (6UL)                     /*!< MR12IE (Bit 6)                                        */
#define SN_CT16B1_MCTRL2_MR12IE_Msk       (0x40UL)                  /*!< MR12IE (Bitfield-Mask: 0x01)                          */
#define SN_CT16B1_MCTRL2_MR12RST_Pos      (7UL)                     /*!< MR12RST (Bit 7)                                       */
#define SN_CT16B1_MCTRL2_MR12RST_Msk      (0x80UL)                  /*!< MR12RST (Bitfield-Mask: 0x01)                         */
#define SN_CT16B1_MCTRL2_MR12STOP_Pos     (8UL)                     /*!< MR12STOP (Bit 8)                                      */
#define SN_CT16B1_MCTRL2_MR12STOP_Msk     (0x100UL)                 /*!< MR12STOP (Bitfield-Mask: 0x01)                        */
#define SN_CT16B1_MCTRL2_MR13IE_Pos       (9UL)                     /*!< MR13IE (Bit 9)                                        */
#define SN_CT16B1_MCTRL2_MR13IE_Msk       (0x200UL)                 /*!< MR13IE (Bitfield-Mask: 0x01)                          */
#define SN_CT16B1_MCTRL2_MR13RST_Pos      (10UL)                    /*!< MR13RST (Bit 10)                                      */
#define SN_CT16B1_MCTRL2_MR13RST_Msk      (0x400UL)                 /*!< MR13RST (Bitfield-Mask: 0x01)                         */
#define SN_CT16B1_MCTRL2_MR13STOP_Pos     (11UL)                    /*!< MR13STOP (Bit 11)                                     */
#define SN_CT16B1_MCTRL2_MR13STOP_Msk     (0x800UL)                 /*!< MR13STOP (Bitfield-Mask: 0x01)                        */
#define SN_CT16B1_MCTRL2_MR14IE_Pos       (12UL)                    /*!< MR14IE (Bit 12)                                       */
#define SN_CT16B1_MCTRL2_MR14IE_Msk       (0x1000UL)                /*!< MR14IE (Bitfield-Mask: 0x01)                          */
#define SN_CT16B1_MCTRL2_MR14RST_Pos      (13UL)                    /*!< MR14RST (Bit 13)                                      */
#define SN_CT16B1_MCTRL2_MR14RST_Msk      (0x2000UL)                /*!< MR14RST (Bitfield-Mask: 0x01)                         */
#define SN_CT16B1_MCTRL2_MR14STOP_Pos     (14UL)                    /*!< MR14STOP (Bit 14)                                     */
#define SN_CT16B1_MCTRL2_MR14STOP_Msk     (0x4000UL)                /*!< MR14STOP (Bitfield-Mask: 0x01)                        */
#define SN_CT16B1_MCTRL2_MR15IE_Pos       (15UL)                    /*!< MR15IE (Bit 15)                                       */
#define SN_CT16B1_MCTRL2_MR15IE_Msk       (0x8000UL)                /*!< MR15IE (Bitfield-Mask: 0x01)                          */
#define SN_CT16B1_MCTRL2_MR15RST_Pos      (16UL)                    /*!< MR15RST (Bit 16)                                      */
#define SN_CT16B1_MCTRL2_MR15RST_Msk      (0x10000UL)               /*!< MR15RST (Bitfield-Mask: 0x01)                         */
#define SN_CT16B1_MCTRL2_MR15STOP_Pos     (17UL)                    /*!< MR15STOP (Bit 17)                                     */
#define SN_CT16B1_MCTRL2_MR15STOP_Msk     (0x20000UL)               /*!< MR15STOP (Bitfield-Mask: 0x01)                        */
#define SN_CT16B1_MCTRL2_MR16IE_Pos       (18UL)                    /*!< MR16IE (Bit 18)                                       */
#define SN_CT16B1_MCTRL2_MR16IE_Msk       (0x40000UL)               /*!< MR16IE (Bitfield-Mask: 0x01)                          */
#define SN_CT16B1_MCTRL2_MR16RST_Pos      (19UL)                    /*!< MR16RST (Bit 19)                                      */
#define SN_CT16B1_MCTRL2_MR16RST_Msk      (0x80000UL)               /*!< MR16RST (Bitfield-Mask: 0x01)                         */
#define SN_CT16B1_MCTRL2_MR16STOP_Pos     (20UL)                    /*!< MR16STOP (Bit 20)                                     */
#define SN_CT16B1_MCTRL2_MR16STOP_Msk     (0x100000UL)              /*!< MR16STOP (Bitfield-Mask: 0x01)                        */
#define SN_CT16B1_MCTRL2_MR17IE_Pos       (21UL)                    /*!< MR17IE (Bit 21)                                       */
#define SN_CT16B1_MCTRL2_MR17IE_Msk       (0x200000UL)              /*!< MR17IE (Bitfield-Mask: 0x01)                          */
#define SN_CT16B1_MCTRL2_MR17RST_Pos      (22UL)                    /*!< MR17RST (Bit 22)                                      */
#define SN_CT16B1_MCTRL2_MR17RST_Msk      (0x400000UL)              /*!< MR17RST (Bitfield-Mask: 0x01)                         */
#define SN_CT16B1_MCTRL2_MR17STOP_Pos     (23UL)                    /*!< MR17STOP (Bit 23)                                     */
#define SN_CT16B1_MCTRL2_MR17STOP_Msk     (0x800000UL)              /*!< MR17STOP (Bitfield-Mask: 0x01)                        */
#define SN_CT16B1_MCTRL2_MR18IE_Pos       (24UL)                    /*!< MR18IE (Bit 24)                                       */
#define SN_CT16B1_MCTRL2_MR18IE_Msk       (0x1000000UL)             /*!< MR18IE (Bitfield-Mask: 0x01)                          */
#define SN_CT16B1_MCTRL2_MR18RST_Pos      (25UL)                    /*!< MR18RST (Bit 25)                                      */
#define SN_CT16B1_MCTRL2_MR18RST_Msk      (0x2000000UL)             /*!< MR18RST (Bitfield-Mask: 0x01)                         */
#define SN_CT16B1_MCTRL2_MR18STOP_Pos     (26UL)                    /*!< MR18STOP (Bit 26)                                     */
#define SN_CT16B1_MCTRL2_MR18STOP_Msk     (0x4000000UL)             /*!< MR18STOP (Bitfield-Mask: 0x01)                        */
#define SN_CT16B1_MCTRL2_MR19IE_Pos       (27UL)                    /*!< MR19IE (Bit 27)                                       */
#define SN_CT16B1_MCTRL2_MR19IE_Msk       (0x8000000UL)             /*!< MR19IE (Bitfield-Mask: 0x01)                          */
#define SN_CT16B1_MCTRL2_MR19RST_Pos      (28UL)                    /*!< MR19RST (Bit 28)                                      */
#define SN_CT16B1_MCTRL2_MR19RST_Msk      (0x10000000UL)            /*!< MR19RST (Bitfield-Mask: 0x01)                         */
#define SN_CT16B1_MCTRL2_MR19STOP_Pos     (29UL)                    /*!< MR19STOP (Bit 29)                                     */
#define SN_CT16B1_MCTRL2_MR19STOP_Msk     (0x20000000UL)            /*!< MR19STOP (Bitfield-Mask: 0x01)                        */
/* ========================================================  MCTRL3  ========================================================= */
#define SN_CT16B1_MCTRL3_MR20IE_Pos       (0UL)                     /*!< MR20IE (Bit 0)                                        */
#define SN_CT16B1_MCTRL3_MR20IE_Msk       (0x1UL)                   /*!< MR20IE (Bitfield-Mask: 0x01)                          */
#define SN_CT16B1_MCTRL3_MR20RST_Pos      (1UL)                     /*!< MR20RST (Bit 1)                                       */
#define SN_CT16B1_MCTRL3_MR20RST_Msk      (0x2UL)                   /*!< MR20RST (Bitfield-Mask: 0x01)                         */
#define SN_CT16B1_MCTRL3_MR20STOP_Pos     (2UL)                     /*!< MR20STOP (Bit 2)                                      */
#define SN_CT16B1_MCTRL3_MR20STOP_Msk     (0x4UL)                   /*!< MR20STOP (Bitfield-Mask: 0x01)                        */
#define SN_CT16B1_MCTRL3_MR21IE_Pos       (3UL)                     /*!< MR21IE (Bit 3)                                        */
#define SN_CT16B1_MCTRL3_MR21IE_Msk       (0x8UL)                   /*!< MR21IE (Bitfield-Mask: 0x01)                          */
#define SN_CT16B1_MCTRL3_MR21RST_Pos      (4UL)                     /*!< MR21RST (Bit 4)                                       */
#define SN_CT16B1_MCTRL3_MR21RST_Msk      (0x10UL)                  /*!< MR21RST (Bitfield-Mask: 0x01)                         */
#define SN_CT16B1_MCTRL3_MR21STOP_Pos     (5UL)                     /*!< MR21STOP (Bit 5)                                      */
#define SN_CT16B1_MCTRL3_MR21STOP_Msk     (0x20UL)                  /*!< MR21STOP (Bitfield-Mask: 0x01)                        */
#define SN_CT16B1_MCTRL3_MR22IE_Pos       (6UL)                     /*!< MR22IE (Bit 6)                                        */
#define SN_CT16B1_MCTRL3_MR22IE_Msk       (0x40UL)                  /*!< MR22IE (Bitfield-Mask: 0x01)                          */
#define SN_CT16B1_MCTRL3_MR22RST_Pos      (7UL)                     /*!< MR22RST (Bit 7)                                       */
#define SN_CT16B1_MCTRL3_MR22RST_Msk      (0x80UL)                  /*!< MR22RST (Bitfield-Mask: 0x01)                         */
#define SN_CT16B1_MCTRL3_MR22STOP_Pos     (8UL)                     /*!< MR22STOP (Bit 8)                                      */
#define SN_CT16B1_MCTRL3_MR22STOP_Msk     (0x100UL)                 /*!< MR22STOP (Bitfield-Mask: 0x01)                        */
#define SN_CT16B1_MCTRL3_MR23IE_Pos       (9UL)                     /*!< MR23IE (Bit 9)                                        */
#define SN_CT16B1_MCTRL3_MR23IE_Msk       (0x200UL)                 /*!< MR23IE (Bitfield-Mask: 0x01)                          */
#define SN_CT16B1_MCTRL3_MR23RST_Pos      (10UL)                    /*!< MR23RST (Bit 10)                                      */
#define SN_CT16B1_MCTRL3_MR23RST_Msk      (0x400UL)                 /*!< MR23RST (Bitfield-Mask: 0x01)                         */
#define SN_CT16B1_MCTRL3_MR23STOP_Pos     (11UL)                    /*!< MR23STOP (Bit 11)                                     */
#define SN_CT16B1_MCTRL3_MR23STOP_Msk     (0x800UL)                 /*!< MR23STOP (Bitfield-Mask: 0x01)                        */
/* ==========================================================  MR0  ========================================================== */
/* ==========================================================  MR1  ========================================================== */
/* ==========================================================  MR2  ========================================================== */
/* ==========================================================  MR3  ========================================================== */
/* ==========================================================  MR4  ========================================================== */
/* ==========================================================  MR5  ========================================================== */
/* ==========================================================  MR6  ========================================================== */
/* ==========================================================  MR7  ========================================================== */
/* ==========================================================  MR8  ========================================================== */
/* ==========================================================  MR9  ========================================================== */
/* =========================================================  MR10  ========================================================== */
/* =========================================================  MR11  ========================================================== */
/* =========================================================  MR12  ========================================================== */
/* =========================================================  MR13  ========================================================== */
/* =========================================================  MR14  ========================================================== */
/* =========================================================  MR15  ========================================================== */
/* =========================================================  MR16  ========================================================== */
/* =========================================================  MR17  ========================================================== */
/* =========================================================  MR18  ========================================================== */
/* =========================================================  MR19  ========================================================== */
/* =========================================================  MR20  ========================================================== */
/* =========================================================  MR21  ========================================================== */
/* =========================================================  MR22  ========================================================== */
/* =========================================================  MR23  ========================================================== */
/* ==========================================================  EM  =========================================================== */
#define SN_CT16B1_EM_EM0_Pos              (0UL)                     /*!< EM0 (Bit 0)                                           */
#define SN_CT16B1_EM_EM0_Msk              (0x1UL)                   /*!< EM0 (Bitfield-Mask: 0x01)                             */
#define SN_CT16B1_EM_EM1_Pos              (1UL)                     /*!< EM1 (Bit 1)                                           */
#define SN_CT16B1_EM_EM1_Msk              (0x2UL)                   /*!< EM1 (Bitfield-Mask: 0x01)                             */
#define SN_CT16B1_EM_EM2_Pos              (2UL)                     /*!< EM2 (Bit 2)                                           */
#define SN_CT16B1_EM_EM2_Msk              (0x4UL)                   /*!< EM2 (Bitfield-Mask: 0x01)                             */
#define SN_CT16B1_EM_EM3_Pos              (3UL)                     /*!< EM3 (Bit 3)                                           */
#define SN_CT16B1_EM_EM3_Msk              (0x8UL)                   /*!< EM3 (Bitfield-Mask: 0x01)                             */
#define SN_CT16B1_EM_EM4_Pos              (4UL)                     /*!< EM4 (Bit 4)                                           */
#define SN_CT16B1_EM_EM4_Msk              (0x10UL)                  /*!< EM4 (Bitfield-Mask: 0x01)                             */
#define SN_CT16B1_EM_EM5_Pos              (5UL)                     /*!< EM5 (Bit 5)                                           */
#define SN_CT16B1_EM_EM5_Msk              (0x20UL)                  /*!< EM5 (Bitfield-Mask: 0x01)                             */
#define SN_CT16B1_EM_EM6_Pos              (6UL)                     /*!< EM6 (Bit 6)                                           */
#define SN_CT16B1_EM_EM6_Msk              (0x40UL)                  /*!< EM6 (Bitfield-Mask: 0x01)                             */
#define SN_CT16B1_EM_EM7_Pos              (7UL)                     /*!< EM7 (Bit 7)                                           */
#define SN_CT16B1_EM_EM7_Msk              (0x80UL)                  /*!< EM7 (Bitfield-Mask: 0x01)                             */
#define SN_CT16B1_EM_EM8_Pos              (8UL)                     /*!< EM8 (Bit 8)                                           */
#define SN_CT16B1_EM_EM8_Msk              (0x100UL)                 /*!< EM8 (Bitfield-Mask: 0x01)                             */
#define SN_CT16B1_EM_EM9_Pos              (9UL)                     /*!< EM9 (Bit 9)                                           */
#define SN_CT16B1_EM_EM9_Msk              (0x200UL)                 /*!< EM9 (Bitfield-Mask: 0x01)                             */
#define SN_CT16B1_EM_EM10_Pos             (10UL)                    /*!< EM10 (Bit 10)                                         */
#define SN_CT16B1_EM_EM10_Msk             (0x400UL)                 /*!< EM10 (Bitfield-Mask: 0x01)                            */
#define SN_CT16B1_EM_EM11_Pos             (11UL)                    /*!< EM11 (Bit 11)                                         */
#define SN_CT16B1_EM_EM11_Msk             (0x800UL)                 /*!< EM11 (Bitfield-Mask: 0x01)                            */
#define SN_CT16B1_EM_EM12_Pos             (12UL)                    /*!< EM12 (Bit 12)                                         */
#define SN_CT16B1_EM_EM12_Msk             (0x1000UL)                /*!< EM12 (Bitfield-Mask: 0x01)                            */
#define SN_CT16B1_EM_EM13_Pos             (13UL)                    /*!< EM13 (Bit 13)                                         */
#define SN_CT16B1_EM_EM13_Msk             (0x2000UL)                /*!< EM13 (Bitfield-Mask: 0x01)                            */
#define SN_CT16B1_EM_EM14_Pos             (14UL)                    /*!< EM14 (Bit 14)                                         */
#define SN_CT16B1_EM_EM14_Msk             (0x4000UL)                /*!< EM14 (Bitfield-Mask: 0x01)                            */
#define SN_CT16B1_EM_EM15_Pos             (15UL)                    /*!< EM15 (Bit 15)                                         */
#define SN_CT16B1_EM_EM15_Msk             (0x8000UL)                /*!< EM15 (Bitfield-Mask: 0x01)                            */
#define SN_CT16B1_EM_EM16_Pos             (16UL)                    /*!< EM16 (Bit 16)                                         */
#define SN_CT16B1_EM_EM16_Msk             (0x10000UL)               /*!< EM16 (Bitfield-Mask: 0x01)                            */
#define SN_CT16B1_EM_EM17_Pos             (17UL)                    /*!< EM17 (Bit 17)                                         */
#define SN_CT16B1_EM_EM17_Msk             (0x20000UL)               /*!< EM17 (Bitfield-Mask: 0x01)                            */
#define SN_CT16B1_EM_EM18_Pos             (18UL)                    /*!< EM18 (Bit 18)                                         */
#define SN_CT16B1_EM_EM18_Msk             (0x40000UL)               /*!< EM18 (Bitfield-Mask: 0x01)                            */
#define SN_CT16B1_EM_EM19_Pos             (19UL)                    /*!< EM19 (Bit 19)                                         */
#define SN_CT16B1_EM_EM19_Msk             (0x80000UL)               /*!< EM19 (Bitfield-Mask: 0x01)                            */
#define SN_CT16B1_EM_EM20_Pos             (20UL)                    /*!< EM20 (Bit 20)                                         */
#define SN_CT16B1_EM_EM20_Msk             (0x100000UL)              /*!< EM20 (Bitfield-Mask: 0x01)                            */
#define SN_CT16B1_EM_EM21_Pos             (21UL)                    /*!< EM21 (Bit 21)                                         */
#define SN_CT16B1_EM_EM21_Msk             (0x200000UL)              /*!< EM21 (Bitfield-Mask: 0x01)                            */
#define SN_CT16B1_EM_EM22_Pos             (22UL)                    /*!< EM22 (Bit 22)                                         */
#define SN_CT16B1_EM_EM22_Msk             (0x400000UL)              /*!< EM22 (Bitfield-Mask: 0x01)                            */
/* ==========================================================  EMC  ========================================================== */
#define SN_CT16B1_EMC_EMC0_Pos            (0UL)                     /*!< EMC0 (Bit 0)                                          */
#define SN_CT16B1_EMC_EMC0_Msk            (0x3UL)                   /*!< EMC0 (Bitfield-Mask: 0x03)                            */
#define SN_CT16B1_EMC_EMC1_Pos            (2UL)                     /*!< EMC1 (Bit 2)                                          */
#define SN_CT16B1_EMC_EMC1_Msk            (0xcUL)                   /*!< EMC1 (Bitfield-Mask: 0x03)                            */
#define SN_CT16B1_EMC_EMC2_Pos            (4UL)                     /*!< EMC2 (Bit 4)                                          */
#define SN_CT16B1_EMC_EMC2_Msk            (0x30UL)                  /*!< EMC2 (Bitfield-Mask: 0x03)                            */
#define SN_CT16B1_EMC_EMC3_Pos            (6UL)                     /*!< EMC3 (Bit 6)                                          */
#define SN_CT16B1_EMC_EMC3_Msk            (0xc0UL)                  /*!< EMC3 (Bitfield-Mask: 0x03)                            */
#define SN_CT16B1_EMC_EMC4_Pos            (8UL)                     /*!< EMC4 (Bit 8)                                          */
#define SN_CT16B1_EMC_EMC4_Msk            (0x300UL)                 /*!< EMC4 (Bitfield-Mask: 0x03)                            */
#define SN_CT16B1_EMC_EMC5_Pos            (10UL)                    /*!< EMC5 (Bit 10)                                         */
#define SN_CT16B1_EMC_EMC5_Msk            (0xc00UL)                 /*!< EMC5 (Bitfield-Mask: 0x03)                            */
#define SN_CT16B1_EMC_EMC6_Pos            (12UL)                    /*!< EMC6 (Bit 12)                                         */
#define SN_CT16B1_EMC_EMC6_Msk            (0x3000UL)                /*!< EMC6 (Bitfield-Mask: 0x03)                            */
#define SN_CT16B1_EMC_EMC7_Pos            (14UL)                    /*!< EMC7 (Bit 14)                                         */
#define SN_CT16B1_EMC_EMC7_Msk            (0xc000UL)                /*!< EMC7 (Bitfield-Mask: 0x03)                            */
#define SN_CT16B1_EMC_EMC8_Pos            (16UL)                    /*!< EMC8 (Bit 16)                                         */
#define SN_CT16B1_EMC_EMC8_Msk            (0x30000UL)               /*!< EMC8 (Bitfield-Mask: 0x03)                            */
#define SN_CT16B1_EMC_EMC9_Pos            (18UL)                    /*!< EMC9 (Bit 18)                                         */
#define SN_CT16B1_EMC_EMC9_Msk            (0xc0000UL)               /*!< EMC9 (Bitfield-Mask: 0x03)                            */
#define SN_CT16B1_EMC_EMC10_Pos           (20UL)                    /*!< EMC10 (Bit 20)                                        */
#define SN_CT16B1_EMC_EMC10_Msk           (0x300000UL)              /*!< EMC10 (Bitfield-Mask: 0x03)                           */
#define SN_CT16B1_EMC_EMC11_Pos           (22UL)                    /*!< EMC11 (Bit 22)                                        */
#define SN_CT16B1_EMC_EMC11_Msk           (0xc00000UL)              /*!< EMC11 (Bitfield-Mask: 0x03)                           */
#define SN_CT16B1_EMC_EMC12_Pos           (24UL)                    /*!< EMC12 (Bit 24)                                        */
#define SN_CT16B1_EMC_EMC12_Msk           (0x3000000UL)             /*!< EMC12 (Bitfield-Mask: 0x03)                           */
#define SN_CT16B1_EMC_EMC13_Pos           (26UL)                    /*!< EMC13 (Bit 26)                                        */
#define SN_CT16B1_EMC_EMC13_Msk           (0xc000000UL)             /*!< EMC13 (Bitfield-Mask: 0x03)                           */
#define SN_CT16B1_EMC_EMC14_Pos           (28UL)                    /*!< EMC14 (Bit 28)                                        */
#define SN_CT16B1_EMC_EMC14_Msk           (0x30000000UL)            /*!< EMC14 (Bitfield-Mask: 0x03)                           */
#define SN_CT16B1_EMC_EMC15_Pos           (30UL)                    /*!< EMC15 (Bit 30)                                        */
#define SN_CT16B1_EMC_EMC15_Msk           (0xc0000000UL)            /*!< EMC15 (Bitfield-Mask: 0x03)                           */
/* =========================================================  EMC2  ========================================================== */
#define SN_CT16B1_EMC2_EMC16_Pos          (0UL)                     /*!< EMC16 (Bit 0)                                         */
#define SN_CT16B1_EMC2_EMC16_Msk          (0x3UL)                   /*!< EMC16 (Bitfield-Mask: 0x03)                           */
#define SN_CT16B1_EMC2_EMC17_Pos          (2UL)                     /*!< EMC17 (Bit 2)                                         */
#define SN_CT16B1_EMC2_EMC17_Msk          (0xcUL)                   /*!< EMC17 (Bitfield-Mask: 0x03)                           */
#define SN_CT16B1_EMC2_EMC18_Pos          (4UL)                     /*!< EMC18 (Bit 4)                                         */
#define SN_CT16B1_EMC2_EMC18_Msk          (0x30UL)                  /*!< EMC18 (Bitfield-Mask: 0x03)                           */
#define SN_CT16B1_EMC2_EMC19_Pos          (6UL)                     /*!< EMC19 (Bit 6)                                         */
#define SN_CT16B1_EMC2_EMC19_Msk          (0xc0UL)                  /*!< EMC19 (Bitfield-Mask: 0x03)                           */
#define SN_CT16B1_EMC2_EMC20_Pos          (8UL)                     /*!< EMC20 (Bit 8)                                         */
#define SN_CT16B1_EMC2_EMC20_Msk          (0x300UL)                 /*!< EMC20 (Bitfield-Mask: 0x03)                           */
#define SN_CT16B1_EMC2_EMC21_Pos          (10UL)                    /*!< EMC21 (Bit 10)                                        */
#define SN_CT16B1_EMC2_EMC21_Msk          (0xc00UL)                 /*!< EMC21 (Bitfield-Mask: 0x03)                           */
#define SN_CT16B1_EMC2_EMC22_Pos          (12UL)                    /*!< EMC22 (Bit 12)                                        */
#define SN_CT16B1_EMC2_EMC22_Msk          (0x3000UL)                /*!< EMC22 (Bitfield-Mask: 0x03)                           */
/* ========================================================  PWMCTRL  ======================================================== */
#define SN_CT16B1_PWMCTRL_PWM0MODE_Pos    (0UL)                     /*!< PWM0MODE (Bit 0)                                      */
#define SN_CT16B1_PWMCTRL_PWM0MODE_Msk    (0x3UL)                   /*!< PWM0MODE (Bitfield-Mask: 0x03)                        */
#define SN_CT16B1_PWMCTRL_PWM1MODE_Pos    (2UL)                     /*!< PWM1MODE (Bit 2)                                      */
#define SN_CT16B1_PWMCTRL_PWM1MODE_Msk    (0xcUL)                   /*!< PWM1MODE (Bitfield-Mask: 0x03)                        */
#define SN_CT16B1_PWMCTRL_PWM2MODE_Pos    (4UL)                     /*!< PWM2MODE (Bit 4)                                      */
#define SN_CT16B1_PWMCTRL_PWM2MODE_Msk    (0x30UL)                  /*!< PWM2MODE (Bitfield-Mask: 0x03)                        */
#define SN_CT16B1_PWMCTRL_PWM3MODE_Pos    (6UL)                     /*!< PWM3MODE (Bit 6)                                      */
#define SN_CT16B1_PWMCTRL_PWM3MODE_Msk    (0xc0UL)                  /*!< PWM3MODE (Bitfield-Mask: 0x03)                        */
#define SN_CT16B1_PWMCTRL_PWM4MODE_Pos    (8UL)                     /*!< PWM4MODE (Bit 8)                                      */
#define SN_CT16B1_PWMCTRL_PWM4MODE_Msk    (0x300UL)                 /*!< PWM4MODE (Bitfield-Mask: 0x03)                        */
#define SN_CT16B1_PWMCTRL_PWM5MODE_Pos    (10UL)                    /*!< PWM5MODE (Bit 10)                                     */
#define SN_CT16B1_PWMCTRL_PWM5MODE_Msk    (0xc00UL)                 /*!< PWM5MODE (Bitfield-Mask: 0x03)                        */
#define SN_CT16B1_PWMCTRL_PWM6MODE_Pos    (12UL)                    /*!< PWM6MODE (Bit 12)                                     */
#define SN_CT16B1_PWMCTRL_PWM6MODE_Msk    (0x3000UL)                /*!< PWM6MODE (Bitfield-Mask: 0x03)                        */
#define SN_CT16B1_PWMCTRL_PWM7MODE_Pos    (14UL)                    /*!< PWM7MODE (Bit 14)                                     */
#define SN_CT16B1_PWMCTRL_PWM7MODE_Msk    (0xc000UL)                /*!< PWM7MODE (Bitfield-Mask: 0x03)                        */
#define SN_CT16B1_PWMCTRL_PWM8MODE_Pos    (16UL)                    /*!< PWM8MODE (Bit 16)                                     */
#define SN_CT16B1_PWMCTRL_PWM8MODE_Msk    (0x30000UL)               /*!< PWM8MODE (Bitfield-Mask: 0x03)                        */
#define SN_CT16B1_PWMCTRL_PWM9MODE_Pos    (18UL)                    /*!< PWM9MODE (Bit 18)                                     */
#define SN_CT16B1_PWMCTRL_PWM9MODE_Msk    (0xc0000UL)               /*!< PWM9MODE (Bitfield-Mask: 0x03)                        */
#define SN_CT16B1_PWMCTRL_PWM10MODE_Pos   (20UL)                    /*!< PWM10MODE (Bit 20)                                    */
#define SN_CT16B1_PWMCTRL_PWM10MODE_Msk   (0x300000UL)              /*!< PWM10MODE (Bitfield-Mask: 0x03)                       */
#define SN_CT16B1_PWMCTRL_PWM11MODE_Pos   (22UL)                    /*!< PWM11MODE (Bit 22)                                    */
#define SN_CT16B1_PWMCTRL_PWM11MODE_Msk   (0xc00000UL)              /*!< PWM11MODE (Bitfield-Mask: 0x03)                       */
#define SN_CT16B1_PWMCTRL_PWM12MODE_Pos   (24UL)                    /*!< PWM12MODE (Bit 24)                                    */
#define SN_CT16B1_PWMCTRL_PWM12MODE_Msk   (0x3000000UL)             /*!< PWM12MODE (Bitfield-Mask: 0x03)                       */
#define SN_CT16B1_PWMCTRL_PWM13MODE_Pos   (26UL)                    /*!< PWM13MODE (Bit 26)                                    */
#define SN_CT16B1_PWMCTRL_PWM13MODE_Msk   (0xc000000UL)             /*!< PWM13MODE (Bitfield-Mask: 0x03)                       */
#define SN_CT16B1_PWMCTRL_PWM14MODE_Pos   (28UL)                    /*!< PWM14MODE (Bit 28)                                    */
#define SN_CT16B1_PWMCTRL_PWM14MODE_Msk   (0x30000000UL)            /*!< PWM14MODE (Bitfield-Mask: 0x03)                       */
#define SN_CT16B1_PWMCTRL_PWM15MODE_Pos   (30UL)                    /*!< PWM15MODE (Bit 30)                                    */
#define SN_CT16B1_PWMCTRL_PWM15MODE_Msk   (0xc0000000UL)            /*!< PWM15MODE (Bitfield-Mask: 0x03)                       */
/* =======================================================  PWMCTRL2  ======================================================== */
#define SN_CT16B1_PWMCTRL2_PWM16MODE_Pos  (0UL)                     /*!< PWM16MODE (Bit 0)                                     */
#define SN_CT16B1_PWMCTRL2_PWM16MODE_Msk  (0x3UL)                   /*!< PWM16MODE (Bitfield-Mask: 0x03)                       */
#define SN_CT16B1_PWMCTRL2_PWM17MODE_Pos  (2UL)                     /*!< PWM17MODE (Bit 2)                                     */
#define SN_CT16B1_PWMCTRL2_PWM17MODE_Msk  (0xcUL)                   /*!< PWM17MODE (Bitfield-Mask: 0x03)                       */
#define SN_CT16B1_PWMCTRL2_PWM18MODE_Pos  (4UL)                     /*!< PWM18MODE (Bit 4)                                     */
#define SN_CT16B1_PWMCTRL2_PWM18MODE_Msk  (0x30UL)                  /*!< PWM18MODE (Bitfield-Mask: 0x03)                       */
#define SN_CT16B1_PWMCTRL2_PWM19MODE_Pos  (6UL)                     /*!< PWM19MODE (Bit 6)                                     */
#define SN_CT16B1_PWMCTRL2_PWM19MODE_Msk  (0xc0UL)                  /*!< PWM19MODE (Bitfield-Mask: 0x03)                       */
#define SN_CT16B1_PWMCTRL2_PWM20MODE_Pos  (8UL)                     /*!< PWM20MODE (Bit 8)                                     */
#define SN_CT16B1_PWMCTRL2_PWM20MODE_Msk  (0x300UL)                 /*!< PWM20MODE (Bitfield-Mask: 0x03)                       */
#define SN_CT16B1_PWMCTRL2_PWM21MODE_Pos  (10UL)                    /*!< PWM21MODE (Bit 10)                                    */
#define SN_CT16B1_PWMCTRL2_PWM21MODE_Msk  (0xc00UL)                 /*!< PWM21MODE (Bitfield-Mask: 0x03)                       */
#define SN_CT16B1_PWMCTRL2_PWM22MODE_Pos  (12UL)                    /*!< PWM22MODE (Bit 12)                                    */
#define SN_CT16B1_PWMCTRL2_PWM22MODE_Msk  (0x3000UL)                /*!< PWM22MODE (Bitfield-Mask: 0x03)                       */
/* ========================================================  PWMENB  ========================================================= */
#define SN_CT16B1_PWMENB_PWM0EN_Pos       (0UL)                     /*!< PWM0EN (Bit 0)                                        */
#define SN_CT16B1_PWMENB_PWM0EN_Msk       (0x1UL)                   /*!< PWM0EN (Bitfield-Mask: 0x01)                          */
#define SN_CT16B1_PWMENB_PWM1EN_Pos       (1UL)                     /*!< PWM1EN (Bit 1)                                        */
#define SN_CT16B1_PWMENB_PWM1EN_Msk       (0x2UL)                   /*!< PWM1EN (Bitfield-Mask: 0x01)                          */
#define SN_CT16B1_PWMENB_PWM2EN_Pos       (2UL)                     /*!< PWM2EN (Bit 2)                                        */
#define SN_CT16B1_PWMENB_PWM2EN_Msk       (0x4UL)                   /*!< PWM2EN (Bitfield-Mask: 0x01)                          */
#define SN_CT16B1_PWMENB_PWM3EN_Pos       (3UL)                     /*!< PWM3EN (Bit 3)                                        */
#define SN_CT16B1_PWMENB_PWM3EN_Msk       (0x8UL)                   /*!< PWM3EN (Bitfield-Mask: 0x01)                          */
#define SN_CT16B1_PWMENB_PWM4EN_Pos       (4UL)                     /*!< PWM4EN (Bit 4)                                        */
#define SN_CT16B1_PWMENB_PWM4EN_Msk       (0x10UL)                  /*!< PWM4EN (Bitfield-Mask: 0x01)                          */
#define SN_CT16B1_PWMENB_PWM5EN_Pos       (5UL)                     /*!< PWM5EN (Bit 5)                                        */
#define SN_CT16B1_PWMENB_PWM5EN_Msk       (0x20UL)                  /*!< PWM5EN (Bitfield-Mask: 0x01)                          */
#define SN_CT16B1_PWMENB_PWM6EN_Pos       (6UL)                     /*!< PWM6EN (Bit 6)                                        */
#define SN_CT16B1_PWMENB_PWM6EN_Msk       (0x40UL)                  /*!< PWM6EN (Bitfield-Mask: 0x01)                          */
#define SN_CT16B1_PWMENB_PWM7EN_Pos       (7UL)                     /*!< PWM7EN (Bit 7)                                        */
#define SN_CT16B1_PWMENB_PWM7EN_Msk       (0x80UL)                  /*!< PWM7EN (Bitfield-Mask: 0x01)                          */
#define SN_CT16B1_PWMENB_PWM8EN_Pos       (8UL)                     /*!< PWM8EN (Bit 8)                                        */
#define SN_CT16B1_PWMENB_PWM8EN_Msk       (0x100UL)                 /*!< PWM8EN (Bitfield-Mask: 0x01)                          */
#define SN_CT16B1_PWMENB_PWM9EN_Pos       (9UL)                     /*!< PWM9EN (Bit 9)                                        */
#define SN_CT16B1_PWMENB_PWM9EN_Msk       (0x200UL)                 /*!< PWM9EN (Bitfield-Mask: 0x01)                          */
#define SN_CT16B1_PWMENB_PWM10EN_Pos      (10UL)                    /*!< PWM10EN (Bit 10)                                      */
#define SN_CT16B1_PWMENB_PWM10EN_Msk      (0x400UL)                 /*!< PWM10EN (Bitfield-Mask: 0x01)                         */
#define SN_CT16B1_PWMENB_PWM11EN_Pos      (11UL)                    /*!< PWM11EN (Bit 11)                                      */
#define SN_CT16B1_PWMENB_PWM11EN_Msk      (0x800UL)                 /*!< PWM11EN (Bitfield-Mask: 0x01)                         */
#define SN_CT16B1_PWMENB_PWM12EN_Pos      (12UL)                    /*!< PWM12EN (Bit 12)                                      */
#define SN_CT16B1_PWMENB_PWM12EN_Msk      (0x1000UL)                /*!< PWM12EN (Bitfield-Mask: 0x01)                         */
#define SN_CT16B1_PWMENB_PWM13EN_Pos      (13UL)                    /*!< PWM13EN (Bit 13)                                      */
#define SN_CT16B1_PWMENB_PWM13EN_Msk      (0x2000UL)                /*!< PWM13EN (Bitfield-Mask: 0x01)                         */
#define SN_CT16B1_PWMENB_PWM14EN_Pos      (14UL)                    /*!< PWM14EN (Bit 14)                                      */
#define SN_CT16B1_PWMENB_PWM14EN_Msk      (0x4000UL)                /*!< PWM14EN (Bitfield-Mask: 0x01)                         */
#define SN_CT16B1_PWMENB_PWM15EN_Pos      (15UL)                    /*!< PWM15EN (Bit 15)                                      */
#define SN_CT16B1_PWMENB_PWM15EN_Msk      (0x8000UL)                /*!< PWM15EN (Bitfield-Mask: 0x01)                         */
#define SN_CT16B1_PWMENB_PWM16EN_Pos      (16UL)                    /*!< PWM16EN (Bit 16)                                      */
#define SN_CT16B1_PWMENB_PWM16EN_Msk      (0x10000UL)               /*!< PWM16EN (Bitfield-Mask: 0x01)                         */
#define SN_CT16B1_PWMENB_PWM17EN_Pos      (17UL)                    /*!< PWM17EN (Bit 17)                                      */
#define SN_CT16B1_PWMENB_PWM17EN_Msk      (0x20000UL)               /*!< PWM17EN (Bitfield-Mask: 0x01)                         */
#define SN_CT16B1_PWMENB_PWM18EN_Pos      (18UL)                    /*!< PWM18EN (Bit 18)                                      */
#define SN_CT16B1_PWMENB_PWM18EN_Msk      (0x40000UL)               /*!< PWM18EN (Bitfield-Mask: 0x01)                         */
#define SN_CT16B1_PWMENB_PWM19EN_Pos      (19UL)                    /*!< PWM19EN (Bit 19)                                      */
#define SN_CT16B1_PWMENB_PWM19EN_Msk      (0x80000UL)               /*!< PWM19EN (Bitfield-Mask: 0x01)                         */
#define SN_CT16B1_PWMENB_PWM20EN_Pos      (20UL)                    /*!< PWM20EN (Bit 20)                                      */
#define SN_CT16B1_PWMENB_PWM20EN_Msk      (0x100000UL)              /*!< PWM20EN (Bitfield-Mask: 0x01)                         */
#define SN_CT16B1_PWMENB_PWM21EN_Pos      (21UL)                    /*!< PWM21EN (Bit 21)                                      */
#define SN_CT16B1_PWMENB_PWM21EN_Msk      (0x200000UL)              /*!< PWM21EN (Bitfield-Mask: 0x01)                         */
#define SN_CT16B1_PWMENB_PWM22EN_Pos      (22UL)                    /*!< PWM22EN (Bit 22)                                      */
#define SN_CT16B1_PWMENB_PWM22EN_Msk      (0x400000UL)              /*!< PWM22EN (Bitfield-Mask: 0x01)                         */
/* =======================================================  PWMIOENB  ======================================================== */
#define SN_CT16B1_PWMIOENB_PWM0IOEN_Pos   (0UL)                     /*!< PWM0IOEN (Bit 0)                                      */
#define SN_CT16B1_PWMIOENB_PWM0IOEN_Msk   (0x1UL)                   /*!< PWM0IOEN (Bitfield-Mask: 0x01)                        */
#define SN_CT16B1_PWMIOENB_PWM1IOEN_Pos   (1UL)                     /*!< PWM1IOEN (Bit 1)                                      */
#define SN_CT16B1_PWMIOENB_PWM1IOEN_Msk   (0x2UL)                   /*!< PWM1IOEN (Bitfield-Mask: 0x01)                        */
#define SN_CT16B1_PWMIOENB_PWM2IOEN_Pos   (2UL)                     /*!< PWM2IOEN (Bit 2)                                      */
#define SN_CT16B1_PWMIOENB_PWM2IOEN_Msk   (0x4UL)                   /*!< PWM2IOEN (Bitfield-Mask: 0x01)                        */
#define SN_CT16B1_PWMIOENB_PWM3IOEN_Pos   (3UL)                     /*!< PWM3IOEN (Bit 3)                                      */
#define SN_CT16B1_PWMIOENB_PWM3IOEN_Msk   (0x8UL)                   /*!< PWM3IOEN (Bitfield-Mask: 0x01)                        */
#define SN_CT16B1_PWMIOENB_PWM4IOEN_Pos   (4UL)                     /*!< PWM4IOEN (Bit 4)                                      */
#define SN_CT16B1_PWMIOENB_PWM4IOEN_Msk   (0x10UL)                  /*!< PWM4IOEN (Bitfield-Mask: 0x01)                        */
#define SN_CT16B1_PWMIOENB_PWM5IOEN_Pos   (5UL)                     /*!< PWM5IOEN (Bit 5)                                      */
#define SN_CT16B1_PWMIOENB_PWM5IOEN_Msk   (0x20UL)                  /*!< PWM5IOEN (Bitfield-Mask: 0x01)                        */
#define SN_CT16B1_PWMIOENB_PWM6IOEN_Pos   (6UL)                     /*!< PWM6IOEN (Bit 6)                                      */
#define SN_CT16B1_PWMIOENB_PWM6IOEN_Msk   (0x40UL)                  /*!< PWM6IOEN (Bitfield-Mask: 0x01)                        */
#define SN_CT16B1_PWMIOENB_PWM7IOEN_Pos   (7UL)                     /*!< PWM7IOEN (Bit 7)                                      */
#define SN_CT16B1_PWMIOENB_PWM7IOEN_Msk   (0x80UL)                  /*!< PWM7IOEN (Bitfield-Mask: 0x01)                        */
#define SN_CT16B1_PWMIOENB_PWM8IOEN_Pos   (8UL)                     /*!< PWM8IOEN (Bit 8)                                      */
#define SN_CT16B1_PWMIOENB_PWM8IOEN_Msk   (0x100UL)                 /*!< PWM8IOEN (Bitfield-Mask: 0x01)                        */
#define SN_CT16B1_PWMIOENB_PWM9IOEN_Pos   (9UL)                     /*!< PWM9IOEN (Bit 9)                                      */
#define SN_CT16B1_PWMIOENB_PWM9IOEN_Msk   (0x200UL)                 /*!< PWM9IOEN (Bitfield-Mask: 0x01)                        */
#define SN_CT16B1_PWMIOENB_PWM10IOEN_Pos  (10UL)                    /*!< PWM10IOEN (Bit 10)                                    */
#define SN_CT16B1_PWMIOENB_PWM10IOEN_Msk  (0x400UL)                 /*!< PWM10IOEN (Bitfield-Mask: 0x01)                       */
#define SN_CT16B1_PWMIOENB_PWM11IOEN_Pos  (11UL)                    /*!< PWM11IOEN (Bit 11)                                    */
#define SN_CT16B1_PWMIOENB_PWM11IOEN_Msk  (0x800UL)                 /*!< PWM11IOEN (Bitfield-Mask: 0x01)                       */
#define SN_CT16B1_PWMIOENB_PWM12IOEN_Pos  (12UL)                    /*!< PWM12IOEN (Bit 12)                                    */
#define SN_CT16B1_PWMIOENB_PWM12IOEN_Msk  (0x1000UL)                /*!< PWM12IOEN (Bitfield-Mask: 0x01)                       */
#define SN_CT16B1_PWMIOENB_PWM13IOEN_Pos  (13UL)                    /*!< PWM13IOEN (Bit 13)                                    */
#define SN_CT16B1_PWMIOENB_PWM13IOEN_Msk  (0x2000UL)                /*!< PWM13IOEN (Bitfield-Mask: 0x01)                       */
#define SN_CT16B1_PWMIOENB_PWM14IOEN_Pos  (14UL)                    /*!< PWM14IOEN (Bit 14)                                    */
#define SN_CT16B1_PWMIOENB_PWM14IOEN_Msk  (0x4000UL)                /*!< PWM14IOEN (Bitfield-Mask: 0x01)                       */
#define SN_CT16B1_PWMIOENB_PWM15IOEN_Pos  (15UL)                    /*!< PWM15IOEN (Bit 15)                                    */
#define SN_CT16B1_PWMIOENB_PWM15IOEN_Msk  (0x8000UL)                /*!< PWM15IOEN (Bitfield-Mask: 0x01)                       */
#define SN_CT16B1_PWMIOENB_PWM16IOEN_Pos  (16UL)                    /*!< PWM16IOEN (Bit 16)                                    */
#define SN_CT16B1_PWMIOENB_PWM16IOEN_Msk  (0x10000UL)               /*!< PWM16IOEN (Bitfield-Mask: 0x01)                       */
#define SN_CT16B1_PWMIOENB_PWM17IOEN_Pos  (17UL)                    /*!< PWM17IOEN (Bit 17)                                    */
#define SN_CT16B1_PWMIOENB_PWM17IOEN_Msk  (0x20000UL)               /*!< PWM17IOEN (Bitfield-Mask: 0x01)                       */
#define SN_CT16B1_PWMIOENB_PWM18IOEN_Pos  (18UL)                    /*!< PWM18IOEN (Bit 18)                                    */
#define SN_CT16B1_PWMIOENB_PWM18IOEN_Msk  (0x40000UL)               /*!< PWM18IOEN (Bitfield-Mask: 0x01)                       */
#define SN_CT16B1_PWMIOENB_PWM19IOEN_Pos  (19UL)                    /*!< PWM19IOEN (Bit 19)                                    */
#define SN_CT16B1_PWMIOENB_PWM19IOEN_Msk  (0x80000UL)               /*!< PWM19IOEN (Bitfield-Mask: 0x01)                       */
#define SN_CT16B1_PWMIOENB_PWM20IOEN_Pos  (20UL)                    /*!< PWM20IOEN (Bit 20)                                    */
#define SN_CT16B1_PWMIOENB_PWM20IOEN_Msk  (0x100000UL)              /*!< PWM20IOEN (Bitfield-Mask: 0x01)                       */
#define SN_CT16B1_PWMIOENB_PWM21IOEN_Pos  (21UL)                    /*!< PWM21IOEN (Bit 21)                                    */
#define SN_CT16B1_PWMIOENB_PWM21IOEN_Msk  (0x200000UL)              /*!< PWM21IOEN (Bitfield-Mask: 0x01)                       */
#define SN_CT16B1_PWMIOENB_PWM22IOEN_Pos  (22UL)                    /*!< PWM22IOEN (Bit 22)                                    */
#define SN_CT16B1_PWMIOENB_PWM22IOEN_Msk  (0x400000UL)              /*!< PWM22IOEN (Bitfield-Mask: 0x01)                       */
/* ==========================================================  RIS  ========================================================== */
#define SN_CT16B1_RIS_MR0IF_Pos           (0UL)                     /*!< MR0IF (Bit 0)                                         */
#define SN_CT16B1_RIS_MR0IF_Msk           (0x1UL)                   /*!< MR0IF (Bitfield-Mask: 0x01)                           */
#define SN_CT16B1_RIS_MR1IF_Pos           (1UL)                     /*!< MR1IF (Bit 1)                                         */
#define SN_CT16B1_RIS_MR1IF_Msk           (0x2UL)                   /*!< MR1IF (Bitfield-Mask: 0x01)                           */
#define SN_CT16B1_RIS_MR2IF_Pos           (2UL)                     /*!< MR2IF (Bit 2)                                         */
#define SN_CT16B1_RIS_MR2IF_Msk           (0x4UL)                   /*!< MR2IF (Bitfield-Mask: 0x01)                           */
#define SN_CT16B1_RIS_MR3IF_Pos           (3UL)                     /*!< MR3IF (Bit 3)                                         */
#define SN_CT16B1_RIS_MR3IF_Msk           (0x8UL)                   /*!< MR3IF (Bitfield-Mask: 0x01)                           */
#define SN_CT16B1_RIS_MR4IF_Pos           (4UL)                     /*!< MR4IF (Bit 4)                                         */
#define SN_CT16B1_RIS_MR4IF_Msk           (0x10UL)                  /*!< MR4IF (Bitfield-Mask: 0x01)                           */
#define SN_CT16B1_RIS_MR5IF_Pos           (5UL)                     /*!< MR5IF (Bit 5)                                         */
#define SN_CT16B1_RIS_MR5IF_Msk           (0x20UL)                  /*!< MR5IF (Bitfield-Mask: 0x01)                           */
#define SN_CT16B1_RIS_MR6IF_Pos           (6UL)                     /*!< MR6IF (Bit 6)                                         */
#define SN_CT16B1_RIS_MR6IF_Msk           (0x40UL)                  /*!< MR6IF (Bitfield-Mask: 0x01)                           */
#define SN_CT16B1_RIS_MR7IF_Pos           (7UL)                     /*!< MR7IF (Bit 7)                                         */
#define SN_CT16B1_RIS_MR7IF_Msk           (0x80UL)                  /*!< MR7IF (Bitfield-Mask: 0x01)                           */
#define SN_CT16B1_RIS_MR8IF_Pos           (8UL)                     /*!< MR8IF (Bit 8)                                         */
#define SN_CT16B1_RIS_MR8IF_Msk           (0x100UL)                 /*!< MR8IF (Bitfield-Mask: 0x01)                           */
#define SN_CT16B1_RIS_MR9IF_Pos           (9UL)                     /*!< MR9IF (Bit 9)                                         */
#define SN_CT16B1_RIS_MR9IF_Msk           (0x200UL)                 /*!< MR9IF (Bitfield-Mask: 0x01)                           */
#define SN_CT16B1_RIS_MR10IF_Pos          (10UL)                    /*!< MR10IF (Bit 10)                                       */
#define SN_CT16B1_RIS_MR10IF_Msk          (0x400UL)                 /*!< MR10IF (Bitfield-Mask: 0x01)                          */
#define SN_CT16B1_RIS_MR11IF_Pos          (11UL)                    /*!< MR11IF (Bit 11)                                       */
#define SN_CT16B1_RIS_MR11IF_Msk          (0x800UL)                 /*!< MR11IF (Bitfield-Mask: 0x01)                          */
#define SN_CT16B1_RIS_MR12IF_Pos          (12UL)                    /*!< MR12IF (Bit 12)                                       */
#define SN_CT16B1_RIS_MR12IF_Msk          (0x1000UL)                /*!< MR12IF (Bitfield-Mask: 0x01)                          */
#define SN_CT16B1_RIS_MR13IF_Pos          (13UL)                    /*!< MR13IF (Bit 13)                                       */
#define SN_CT16B1_RIS_MR13IF_Msk          (0x2000UL)                /*!< MR13IF (Bitfield-Mask: 0x01)                          */
#define SN_CT16B1_RIS_MR14IF_Pos          (14UL)                    /*!< MR14IF (Bit 14)                                       */
#define SN_CT16B1_RIS_MR14IF_Msk          (0x4000UL)                /*!< MR14IF (Bitfield-Mask: 0x01)                          */
#define SN_CT16B1_RIS_MR15IF_Pos          (15UL)                    /*!< MR15IF (Bit 15)                                       */
#define SN_CT16B1_RIS_MR15IF_Msk          (0x8000UL)                /*!< MR15IF (Bitfield-Mask: 0x01)                          */
#define SN_CT16B1_RIS_MR16IF_Pos          (16UL)                    /*!< MR16IF (Bit 16)                                       */
#define SN_CT16B1_RIS_MR16IF_Msk          (0x10000UL)               /*!< MR16IF (Bitfield-Mask: 0x01)                          */
#define SN_CT16B1_RIS_MR17IF_Pos          (17UL)                    /*!< MR17IF (Bit 17)                                       */
#define SN_CT16B1_RIS_MR17IF_Msk          (0x20000UL)               /*!< MR17IF (Bitfield-Mask: 0x01)                          */
#define SN_CT16B1_RIS_MR18IF_Pos          (18UL)                    /*!< MR18IF (Bit 18)                                       */
#define SN_CT16B1_RIS_MR18IF_Msk          (0x40000UL)               /*!< MR18IF (Bitfield-Mask: 0x01)                          */
#define SN_CT16B1_RIS_MR19IF_Pos          (19UL)                    /*!< MR19IF (Bit 19)                                       */
#define SN_CT16B1_RIS_MR19IF_Msk          (0x80000UL)               /*!< MR19IF (Bitfield-Mask: 0x01)                          */
#define SN_CT16B1_RIS_MR20IF_Pos          (20UL)                    /*!< MR20IF (Bit 20)                                       */
#define SN_CT16B1_RIS_MR20IF_Msk          (0x100000UL)              /*!< MR20IF (Bitfield-Mask: 0x01)                          */
#define SN_CT16B1_RIS_MR21IF_Pos          (21UL)                    /*!< MR21IF (Bit 21)                                       */
#define SN_CT16B1_RIS_MR21IF_Msk          (0x200000UL)              /*!< MR21IF (Bitfield-Mask: 0x01)                          */
#define SN_CT16B1_RIS_MR22IF_Pos          (22UL)                    /*!< MR22IF (Bit 22)                                       */
#define SN_CT16B1_RIS_MR22IF_Msk          (0x400000UL)              /*!< MR22IF (Bitfield-Mask: 0x01)                          */
#define SN_CT16B1_RIS_MR23IF_Pos          (23UL)                    /*!< MR23IF (Bit 23)                                       */
#define SN_CT16B1_RIS_MR23IF_Msk          (0x800000UL)              /*!< MR23IF (Bitfield-Mask: 0x01)                          */
/* ==========================================================  IC  =========================================================== */
#define SN_CT16B1_IC_MR0IC_Pos            (0UL)                     /*!< MR0IC (Bit 0)                                         */
#define SN_CT16B1_IC_MR0IC_Msk            (0x1UL)                   /*!< MR0IC (Bitfield-Mask: 0x01)                           */
#define SN_CT16B1_IC_MR1IC_Pos            (1UL)                     /*!< MR1IC (Bit 1)                                         */
#define SN_CT16B1_IC_MR1IC_Msk            (0x2UL)                   /*!< MR1IC (Bitfield-Mask: 0x01)                           */
#define SN_CT16B1_IC_MR2IC_Pos            (2UL)                     /*!< MR2IC (Bit 2)                                         */
#define SN_CT16B1_IC_MR2IC_Msk            (0x4UL)                   /*!< MR2IC (Bitfield-Mask: 0x01)                           */
#define SN_CT16B1_IC_MR3IC_Pos            (3UL)                     /*!< MR3IC (Bit 3)                                         */
#define SN_CT16B1_IC_MR3IC_Msk            (0x8UL)                   /*!< MR3IC (Bitfield-Mask: 0x01)                           */
#define SN_CT16B1_IC_MR4IC_Pos            (4UL)                     /*!< MR4IC (Bit 4)                                         */
#define SN_CT16B1_IC_MR4IC_Msk            (0x10UL)                  /*!< MR4IC (Bitfield-Mask: 0x01)                           */
#define SN_CT16B1_IC_MR5IC_Pos            (5UL)                     /*!< MR5IC (Bit 5)                                         */
#define SN_CT16B1_IC_MR5IC_Msk            (0x20UL)                  /*!< MR5IC (Bitfield-Mask: 0x01)                           */
#define SN_CT16B1_IC_MR6IC_Pos            (6UL)                     /*!< MR6IC (Bit 6)                                         */
#define SN_CT16B1_IC_MR6IC_Msk            (0x40UL)                  /*!< MR6IC (Bitfield-Mask: 0x01)                           */
#define SN_CT16B1_IC_MR7IC_Pos            (7UL)                     /*!< MR7IC (Bit 7)                                         */
#define SN_CT16B1_IC_MR7IC_Msk            (0x80UL)                  /*!< MR7IC (Bitfield-Mask: 0x01)                           */
#define SN_CT16B1_IC_MR8IC_Pos            (8UL)                     /*!< MR8IC (Bit 8)                                         */
#define SN_CT16B1_IC_MR8IC_Msk            (0x100UL)                 /*!< MR8IC (Bitfield-Mask: 0x01)                           */
#define SN_CT16B1_IC_MR9IC_Pos            (9UL)                     /*!< MR9IC (Bit 9)                                         */
#define SN_CT16B1_IC_MR9IC_Msk            (0x200UL)                 /*!< MR9IC (Bitfield-Mask: 0x01)                           */
#define SN_CT16B1_IC_MR10IC_Pos           (10UL)                    /*!< MR10IC (Bit 10)                                       */
#define SN_CT16B1_IC_MR10IC_Msk           (0x400UL)                 /*!< MR10IC (Bitfield-Mask: 0x01)                          */
#define SN_CT16B1_IC_MR11IC_Pos           (11UL)                    /*!< MR11IC (Bit 11)                                       */
#define SN_CT16B1_IC_MR11IC_Msk           (0x800UL)                 /*!< MR11IC (Bitfield-Mask: 0x01)                          */
#define SN_CT16B1_IC_MR12IC_Pos           (12UL)                    /*!< MR12IC (Bit 12)                                       */
#define SN_CT16B1_IC_MR12IC_Msk           (0x1000UL)                /*!< MR12IC (Bitfield-Mask: 0x01)                          */
#define SN_CT16B1_IC_MR13IC_Pos           (13UL)                    /*!< MR13IC (Bit 13)                                       */
#define SN_CT16B1_IC_MR13IC_Msk           (0x2000UL)                /*!< MR13IC (Bitfield-Mask: 0x01)                          */
#define SN_CT16B1_IC_MR14IC_Pos           (14UL)                    /*!< MR14IC (Bit 14)                                       */
#define SN_CT16B1_IC_MR14IC_Msk           (0x4000UL)                /*!< MR14IC (Bitfield-Mask: 0x01)                          */
#define SN_CT16B1_IC_MR15IC_Pos           (15UL)                    /*!< MR15IC (Bit 15)                                       */
#define SN_CT16B1_IC_MR15IC_Msk           (0x8000UL)                /*!< MR15IC (Bitfield-Mask: 0x01)                          */
#define SN_CT16B1_IC_MR16IC_Pos           (16UL)                    /*!< MR16IC (Bit 16)                                       */
#define SN_CT16B1_IC_MR16IC_Msk           (0x10000UL)               /*!< MR16IC (Bitfield-Mask: 0x01)                          */
#define SN_CT16B1_IC_MR17IC_Pos           (17UL)                    /*!< MR17IC (Bit 17)                                       */
#define SN_CT16B1_IC_MR17IC_Msk           (0x20000UL)               /*!< MR17IC (Bitfield-Mask: 0x01)                          */
#define SN_CT16B1_IC_MR18IC_Pos           (18UL)                    /*!< MR18IC (Bit 18)                                       */
#define SN_CT16B1_IC_MR18IC_Msk           (0x40000UL)               /*!< MR18IC (Bitfield-Mask: 0x01)                          */
#define SN_CT16B1_IC_MR19IC_Pos           (19UL)                    /*!< MR19IC (Bit 19)                                       */
#define SN_CT16B1_IC_MR19IC_Msk           (0x80000UL)               /*!< MR19IC (Bitfield-Mask: 0x01)                          */
#define SN_CT16B1_IC_MR20IC_Pos           (20UL)                    /*!< MR20IC (Bit 20)                                       */
#define SN_CT16B1_IC_MR20IC_Msk           (0x100000UL)              /*!< MR20IC (Bitfield-Mask: 0x01)                          */
#define SN_CT16B1_IC_MR21IC_Pos           (21UL)                    /*!< MR21IC (Bit 21)                                       */
#define SN_CT16B1_IC_MR21IC_Msk           (0x200000UL)              /*!< MR21IC (Bitfield-Mask: 0x01)                          */
#define SN_CT16B1_IC_MR22IC_Pos           (22UL)                    /*!< MR22IC (Bit 22)                                       */
#define SN_CT16B1_IC_MR22IC_Msk           (0x400000UL)              /*!< MR22IC (Bitfield-Mask: 0x01)                          */
#define SN_CT16B1_IC_MR23IC_Pos           (23UL)                    /*!< MR23IC (Bit 23)                                       */
#define SN_CT16B1_IC_MR23IC_Msk           (0x800000UL)              /*!< MR23IC (Bitfield-Mask: 0x01)                          */


/* =========================================================================================================================== */
/* ================                                          SN_PMU                                           ================ */
/* =========================================================================================================================== */

/* =========================================================  CTRL  ========================================================== */
#define SN_PMU_CTRL_MODE_Pos              (0UL)                     /*!< MODE (Bit 0)                                          */
#define SN_PMU_CTRL_MODE_Msk              (0x7UL)                   /*!< MODE (Bitfield-Mask: 0x07)                            */


/* =========================================================================================================================== */
/* ================                                          SN_SPI0                                          ================ */
/* =========================================================================================================================== */

/* =========================================================  CTRL0  ========================================================= */
#define SN_SPI0_CTRL0_SSPEN_Pos           (0UL)                     /*!< SSPEN (Bit 0)                                         */
#define SN_SPI0_CTRL0_SSPEN_Msk           (0x1UL)                   /*!< SSPEN (Bitfield-Mask: 0x01)                           */
#define SN_SPI0_CTRL0_LOOPBACK_Pos        (1UL)                     /*!< LOOPBACK (Bit 1)                                      */
#define SN_SPI0_CTRL0_LOOPBACK_Msk        (0x2UL)                   /*!< LOOPBACK (Bitfield-Mask: 0x01)                        */
#define SN_SPI0_CTRL0_SDODIS_Pos          (2UL)                     /*!< SDODIS (Bit 2)                                        */
#define SN_SPI0_CTRL0_SDODIS_Msk          (0x4UL)                   /*!< SDODIS (Bitfield-Mask: 0x01)                          */
#define SN_SPI0_CTRL0_MS_Pos              (3UL)                     /*!< MS (Bit 3)                                            */
#define SN_SPI0_CTRL0_MS_Msk              (0x8UL)                   /*!< MS (Bitfield-Mask: 0x01)                              */
#define SN_SPI0_CTRL0_FORMAT_Pos          (4UL)                     /*!< FORMAT (Bit 4)                                        */
#define SN_SPI0_CTRL0_FORMAT_Msk          (0x10UL)                  /*!< FORMAT (Bitfield-Mask: 0x01)                          */
#define SN_SPI0_CTRL0_FRESET_Pos          (6UL)                     /*!< FRESET (Bit 6)                                        */
#define SN_SPI0_CTRL0_FRESET_Msk          (0xc0UL)                  /*!< FRESET (Bitfield-Mask: 0x03)                          */
#define SN_SPI0_CTRL0_DL_Pos              (8UL)                     /*!< DL (Bit 8)                                            */
#define SN_SPI0_CTRL0_DL_Msk              (0xf00UL)                 /*!< DL (Bitfield-Mask: 0x0f)                              */
#define SN_SPI0_CTRL0_TXFIFOTH_Pos        (12UL)                    /*!< TXFIFOTH (Bit 12)                                     */
#define SN_SPI0_CTRL0_TXFIFOTH_Msk        (0x7000UL)                /*!< TXFIFOTH (Bitfield-Mask: 0x07)                        */
#define SN_SPI0_CTRL0_RXFIFOTH_Pos        (15UL)                    /*!< RXFIFOTH (Bit 15)                                     */
#define SN_SPI0_CTRL0_RXFIFOTH_Msk        (0x38000UL)               /*!< RXFIFOTH (Bitfield-Mask: 0x07)                        */
#define SN_SPI0_CTRL0_SELDIS_Pos          (18UL)                    /*!< SELDIS (Bit 18)                                       */
#define SN_SPI0_CTRL0_SELDIS_Msk          (0x40000UL)               /*!< SELDIS (Bitfield-Mask: 0x01)                          */
/* =========================================================  CTRL1  ========================================================= */
#define SN_SPI0_CTRL1_MLSB_Pos            (0UL)                     /*!< MLSB (Bit 0)                                          */
#define SN_SPI0_CTRL1_MLSB_Msk            (0x1UL)                   /*!< MLSB (Bitfield-Mask: 0x01)                            */
#define SN_SPI0_CTRL1_CPOL_Pos            (1UL)                     /*!< CPOL (Bit 1)                                          */
#define SN_SPI0_CTRL1_CPOL_Msk            (0x2UL)                   /*!< CPOL (Bitfield-Mask: 0x01)                            */
#define SN_SPI0_CTRL1_CPHA_Pos            (2UL)                     /*!< CPHA (Bit 2)                                          */
#define SN_SPI0_CTRL1_CPHA_Msk            (0x4UL)                   /*!< CPHA (Bitfield-Mask: 0x01)                            */
/* ========================================================  CLKDIV  ========================================================= */
#define SN_SPI0_CLKDIV_DIV_Pos            (0UL)                     /*!< DIV (Bit 0)                                           */
#define SN_SPI0_CLKDIV_DIV_Msk            (0xffUL)                  /*!< DIV (Bitfield-Mask: 0xff)                             */
/* =========================================================  STAT  ========================================================== */
#define SN_SPI0_STAT_TX_EMPTY_Pos         (0UL)                     /*!< TX_EMPTY (Bit 0)                                      */
#define SN_SPI0_STAT_TX_EMPTY_Msk         (0x1UL)                   /*!< TX_EMPTY (Bitfield-Mask: 0x01)                        */
#define SN_SPI0_STAT_TX_FULL_Pos          (1UL)                     /*!< TX_FULL (Bit 1)                                       */
#define SN_SPI0_STAT_TX_FULL_Msk          (0x2UL)                   /*!< TX_FULL (Bitfield-Mask: 0x01)                         */
#define SN_SPI0_STAT_RX_EMPTY_Pos         (2UL)                     /*!< RX_EMPTY (Bit 2)                                      */
#define SN_SPI0_STAT_RX_EMPTY_Msk         (0x4UL)                   /*!< RX_EMPTY (Bitfield-Mask: 0x01)                        */
#define SN_SPI0_STAT_RX_FULL_Pos          (3UL)                     /*!< RX_FULL (Bit 3)                                       */
#define SN_SPI0_STAT_RX_FULL_Msk          (0x8UL)                   /*!< RX_FULL (Bitfield-Mask: 0x01)                         */
#define SN_SPI0_STAT_BUSY_Pos             (4UL)                     /*!< BUSY (Bit 4)                                          */
#define SN_SPI0_STAT_BUSY_Msk             (0x10UL)                  /*!< BUSY (Bitfield-Mask: 0x01)                            */
#define SN_SPI0_STAT_TXFIFOTHF_Pos        (5UL)                     /*!< TXFIFOTHF (Bit 5)                                     */
#define SN_SPI0_STAT_TXFIFOTHF_Msk        (0x20UL)                  /*!< TXFIFOTHF (Bitfield-Mask: 0x01)                       */
#define SN_SPI0_STAT_RXFIFOTHF_Pos        (6UL)                     /*!< RXFIFOTHF (Bit 6)                                     */
#define SN_SPI0_STAT_RXFIFOTHF_Msk        (0x40UL)                  /*!< RXFIFOTHF (Bitfield-Mask: 0x01)                       */
/* ==========================================================  IE  =========================================================== */
#define SN_SPI0_IE_RXOVFIE_Pos            (0UL)                     /*!< RXOVFIE (Bit 0)                                       */
#define SN_SPI0_IE_RXOVFIE_Msk            (0x1UL)                   /*!< RXOVFIE (Bitfield-Mask: 0x01)                         */
#define SN_SPI0_IE_RXTOIE_Pos             (1UL)                     /*!< RXTOIE (Bit 1)                                        */
#define SN_SPI0_IE_RXTOIE_Msk             (0x2UL)                   /*!< RXTOIE (Bitfield-Mask: 0x01)                          */
#define SN_SPI0_IE_RXFIFOTHIE_Pos         (2UL)                     /*!< RXFIFOTHIE (Bit 2)                                    */
#define SN_SPI0_IE_RXFIFOTHIE_Msk         (0x4UL)                   /*!< RXFIFOTHIE (Bitfield-Mask: 0x01)                      */
#define SN_SPI0_IE_TXFIFOTHIE_Pos         (3UL)                     /*!< TXFIFOTHIE (Bit 3)                                    */
#define SN_SPI0_IE_TXFIFOTHIE_Msk         (0x8UL)                   /*!< TXFIFOTHIE (Bitfield-Mask: 0x01)                      */
/* ==========================================================  RIS  ========================================================== */
#define SN_SPI0_RIS_RXOVFIF_Pos           (0UL)                     /*!< RXOVFIF (Bit 0)                                       */
#define SN_SPI0_RIS_RXOVFIF_Msk           (0x1UL)                   /*!< RXOVFIF (Bitfield-Mask: 0x01)                         */
#define SN_SPI0_RIS_RXTOIF_Pos            (1UL)                     /*!< RXTOIF (Bit 1)                                        */
#define SN_SPI0_RIS_RXTOIF_Msk            (0x2UL)                   /*!< RXTOIF (Bitfield-Mask: 0x01)                          */
#define SN_SPI0_RIS_RXFIFOTHIF_Pos        (2UL)                     /*!< RXFIFOTHIF (Bit 2)                                    */
#define SN_SPI0_RIS_RXFIFOTHIF_Msk        (0x4UL)                   /*!< RXFIFOTHIF (Bitfield-Mask: 0x01)                      */
#define SN_SPI0_RIS_TXFIFOTHIF_Pos        (3UL)                     /*!< TXFIFOTHIF (Bit 3)                                    */
#define SN_SPI0_RIS_TXFIFOTHIF_Msk        (0x8UL)                   /*!< TXFIFOTHIF (Bitfield-Mask: 0x01)                      */
/* ==========================================================  IC  =========================================================== */
#define SN_SPI0_IC_RXOVFIC_Pos            (0UL)                     /*!< RXOVFIC (Bit 0)                                       */
#define SN_SPI0_IC_RXOVFIC_Msk            (0x1UL)                   /*!< RXOVFIC (Bitfield-Mask: 0x01)                         */
#define SN_SPI0_IC_RXTOIC_Pos             (1UL)                     /*!< RXTOIC (Bit 1)                                        */
#define SN_SPI0_IC_RXTOIC_Msk             (0x2UL)                   /*!< RXTOIC (Bitfield-Mask: 0x01)                          */
#define SN_SPI0_IC_RXFIFOTHIC_Pos         (2UL)                     /*!< RXFIFOTHIC (Bit 2)                                    */
#define SN_SPI0_IC_RXFIFOTHIC_Msk         (0x4UL)                   /*!< RXFIFOTHIC (Bitfield-Mask: 0x01)                      */
#define SN_SPI0_IC_TXFIFOTHIC_Pos         (3UL)                     /*!< TXFIFOTHIC (Bit 3)                                    */
#define SN_SPI0_IC_TXFIFOTHIC_Msk         (0x8UL)                   /*!< TXFIFOTHIC (Bitfield-Mask: 0x01)                      */
/* =========================================================  DATA  ========================================================== */
#define SN_SPI0_DATA_Data_Pos             (0UL)                     /*!< Data (Bit 0)                                          */
#define SN_SPI0_DATA_Data_Msk             (0xffffUL)                /*!< Data (Bitfield-Mask: 0xffff)                          */
/* ==========================================================  DF  =========================================================== */
#define SN_SPI0_DF_DF_Pos                 (0UL)                     /*!< DF (Bit 0)                                            */
#define SN_SPI0_DF_DF_Msk                 (0x1UL)                   /*!< DF (Bitfield-Mask: 0x01)                              */


/* =========================================================================================================================== */
/* ================                                          SN_I2C0                                          ================ */
/* =========================================================================================================================== */

/* =========================================================  CTRL  ========================================================== */
#define SN_I2C0_CTRL_NACK_Pos             (1UL)                     /*!< NACK (Bit 1)                                          */
#define SN_I2C0_CTRL_NACK_Msk             (0x2UL)                   /*!< NACK (Bitfield-Mask: 0x01)                            */
#define SN_I2C0_CTRL_ACK_Pos              (2UL)                     /*!< ACK (Bit 2)                                           */
#define SN_I2C0_CTRL_ACK_Msk              (0x4UL)                   /*!< ACK (Bitfield-Mask: 0x01)                             */
#define SN_I2C0_CTRL_STO_Pos              (4UL)                     /*!< STO (Bit 4)                                           */
#define SN_I2C0_CTRL_STO_Msk              (0x10UL)                  /*!< STO (Bitfield-Mask: 0x01)                             */
#define SN_I2C0_CTRL_STA_Pos              (5UL)                     /*!< STA (Bit 5)                                           */
#define SN_I2C0_CTRL_STA_Msk              (0x20UL)                  /*!< STA (Bitfield-Mask: 0x01)                             */
#define SN_I2C0_CTRL_MODE_Pos             (7UL)                     /*!< MODE (Bit 7)                                          */
#define SN_I2C0_CTRL_MODE_Msk             (0x80UL)                  /*!< MODE (Bitfield-Mask: 0x01)                            */
#define SN_I2C0_CTRL_I2CEN_Pos            (8UL)                     /*!< I2CEN (Bit 8)                                         */
#define SN_I2C0_CTRL_I2CEN_Msk            (0x100UL)                 /*!< I2CEN (Bitfield-Mask: 0x01)                           */
/* =========================================================  STAT  ========================================================== */
#define SN_I2C0_STAT_RX_DN_Pos            (0UL)                     /*!< RX_DN (Bit 0)                                         */
#define SN_I2C0_STAT_RX_DN_Msk            (0x1UL)                   /*!< RX_DN (Bitfield-Mask: 0x01)                           */
#define SN_I2C0_STAT_ACK_STAT_Pos         (1UL)                     /*!< ACK_STAT (Bit 1)                                      */
#define SN_I2C0_STAT_ACK_STAT_Msk         (0x2UL)                   /*!< ACK_STAT (Bitfield-Mask: 0x01)                        */
#define SN_I2C0_STAT_NACK_STAT_Pos        (2UL)                     /*!< NACK_STAT (Bit 2)                                     */
#define SN_I2C0_STAT_NACK_STAT_Msk        (0x4UL)                   /*!< NACK_STAT (Bitfield-Mask: 0x01)                       */
#define SN_I2C0_STAT_STOP_DN_Pos          (3UL)                     /*!< STOP_DN (Bit 3)                                       */
#define SN_I2C0_STAT_STOP_DN_Msk          (0x8UL)                   /*!< STOP_DN (Bitfield-Mask: 0x01)                         */
#define SN_I2C0_STAT_START_DN_Pos         (4UL)                     /*!< START_DN (Bit 4)                                      */
#define SN_I2C0_STAT_START_DN_Msk         (0x10UL)                  /*!< START_DN (Bitfield-Mask: 0x01)                        */
#define SN_I2C0_STAT_MST_Pos              (5UL)                     /*!< MST (Bit 5)                                           */
#define SN_I2C0_STAT_MST_Msk              (0x20UL)                  /*!< MST (Bitfield-Mask: 0x01)                             */
#define SN_I2C0_STAT_SLV_RX_HIT_Pos       (6UL)                     /*!< SLV_RX_HIT (Bit 6)                                    */
#define SN_I2C0_STAT_SLV_RX_HIT_Msk       (0x40UL)                  /*!< SLV_RX_HIT (Bitfield-Mask: 0x01)                      */
#define SN_I2C0_STAT_SLV_TX_HIT_Pos       (7UL)                     /*!< SLV_TX_HIT (Bit 7)                                    */
#define SN_I2C0_STAT_SLV_TX_HIT_Msk       (0x80UL)                  /*!< SLV_TX_HIT (Bitfield-Mask: 0x01)                      */
#define SN_I2C0_STAT_LOST_ARB_Pos         (8UL)                     /*!< LOST_ARB (Bit 8)                                      */
#define SN_I2C0_STAT_LOST_ARB_Msk         (0x100UL)                 /*!< LOST_ARB (Bitfield-Mask: 0x01)                        */
#define SN_I2C0_STAT_TIMEOUT_Pos          (9UL)                     /*!< TIMEOUT (Bit 9)                                       */
#define SN_I2C0_STAT_TIMEOUT_Msk          (0x200UL)                 /*!< TIMEOUT (Bitfield-Mask: 0x01)                         */
#define SN_I2C0_STAT_I2CIF_Pos            (15UL)                    /*!< I2CIF (Bit 15)                                        */
#define SN_I2C0_STAT_I2CIF_Msk            (0x8000UL)                /*!< I2CIF (Bitfield-Mask: 0x01)                           */
/* ========================================================  TXDATA  ========================================================= */
#define SN_I2C0_TXDATA_Data_Pos           (0UL)                     /*!< Data (Bit 0)                                          */
#define SN_I2C0_TXDATA_Data_Msk           (0xffUL)                  /*!< Data (Bitfield-Mask: 0xff)                            */
/* ========================================================  RXDATA  ========================================================= */
#define SN_I2C0_RXDATA_Data_Pos           (0UL)                     /*!< Data (Bit 0)                                          */
#define SN_I2C0_RXDATA_Data_Msk           (0xffUL)                  /*!< Data (Bitfield-Mask: 0xff)                            */
/* =======================================================  SLVADDR0  ======================================================== */
#define SN_I2C0_SLVADDR0_ADDR_Pos         (0UL)                     /*!< ADDR (Bit 0)                                          */
#define SN_I2C0_SLVADDR0_ADDR_Msk         (0x3ffUL)                 /*!< ADDR (Bitfield-Mask: 0x3ff)                           */
#define SN_I2C0_SLVADDR0_GCEN_Pos         (30UL)                    /*!< GCEN (Bit 30)                                         */
#define SN_I2C0_SLVADDR0_GCEN_Msk         (0x40000000UL)            /*!< GCEN (Bitfield-Mask: 0x01)                            */
#define SN_I2C0_SLVADDR0_ADD_MODE_Pos     (31UL)                    /*!< ADD_MODE (Bit 31)                                     */
#define SN_I2C0_SLVADDR0_ADD_MODE_Msk     (0x80000000UL)            /*!< ADD_MODE (Bitfield-Mask: 0x01)                        */
/* =======================================================  SLVADDR1  ======================================================== */
#define SN_I2C0_SLVADDR1_ADDR_Pos         (0UL)                     /*!< ADDR (Bit 0)                                          */
#define SN_I2C0_SLVADDR1_ADDR_Msk         (0x3ffUL)                 /*!< ADDR (Bitfield-Mask: 0x3ff)                           */
/* =======================================================  SLVADDR2  ======================================================== */
#define SN_I2C0_SLVADDR2_ADDR_Pos         (0UL)                     /*!< ADDR (Bit 0)                                          */
#define SN_I2C0_SLVADDR2_ADDR_Msk         (0x3ffUL)                 /*!< ADDR (Bitfield-Mask: 0x3ff)                           */
/* =======================================================  SLVADDR3  ======================================================== */
#define SN_I2C0_SLVADDR3_ADDR_Pos         (0UL)                     /*!< ADDR (Bit 0)                                          */
#define SN_I2C0_SLVADDR3_ADDR_Msk         (0x3ffUL)                 /*!< ADDR (Bitfield-Mask: 0x3ff)                           */
/* =========================================================  SCLHT  ========================================================= */
#define SN_I2C0_SCLHT_SCLH_Pos            (0UL)                     /*!< SCLH (Bit 0)                                          */
#define SN_I2C0_SCLHT_SCLH_Msk            (0xffUL)                  /*!< SCLH (Bitfield-Mask: 0xff)                            */
/* =========================================================  SCLLT  ========================================================= */
#define SN_I2C0_SCLLT_SCLL_Pos            (0UL)                     /*!< SCLL (Bit 0)                                          */
#define SN_I2C0_SCLLT_SCLL_Msk            (0xffUL)                  /*!< SCLL (Bitfield-Mask: 0xff)                            */
/* =========================================================  SCLCT  ========================================================= */
#define SN_I2C0_SCLCT_SCLCT_Pos           (0UL)                     /*!< SCLCT (Bit 0)                                         */
#define SN_I2C0_SCLCT_SCLCT_Msk           (0xfUL)                   /*!< SCLCT (Bitfield-Mask: 0x0f)                           */
/* ========================================================  TOCTRL  ========================================================= */
#define SN_I2C0_TOCTRL_TO_Pos             (0UL)                     /*!< TO (Bit 0)                                            */
#define SN_I2C0_TOCTRL_TO_Msk             (0xffffUL)                /*!< TO (Bitfield-Mask: 0xffff)                            */


/* =========================================================================================================================== */
/* ================                                         SN_FLASH                                          ================ */
/* =========================================================================================================================== */

/* ========================================================  LPCTRL  ========================================================= */
#define SN_FLASH_LPCTRL_LPMODE_Pos        (0UL)                     /*!< LPMODE (Bit 0)                                        */
#define SN_FLASH_LPCTRL_LPMODE_Msk        (0xfUL)                   /*!< LPMODE (Bitfield-Mask: 0x0f)                          */
/* ========================================================  STATUS  ========================================================= */
#define SN_FLASH_STATUS_BUSY_Pos          (0UL)                     /*!< BUSY (Bit 0)                                          */
#define SN_FLASH_STATUS_BUSY_Msk          (0x1UL)                   /*!< BUSY (Bitfield-Mask: 0x01)                            */
#define SN_FLASH_STATUS_ERR_Pos           (2UL)                     /*!< ERR (Bit 2)                                           */
#define SN_FLASH_STATUS_ERR_Msk           (0x4UL)                   /*!< ERR (Bitfield-Mask: 0x01)                             */
/* =========================================================  CTRL  ========================================================== */
#define SN_FLASH_CTRL_PG_Pos              (0UL)                     /*!< PG (Bit 0)                                            */
#define SN_FLASH_CTRL_PG_Msk              (0x1UL)                   /*!< PG (Bitfield-Mask: 0x01)                              */
#define SN_FLASH_CTRL_PER_Pos             (1UL)                     /*!< PER (Bit 1)                                           */
#define SN_FLASH_CTRL_PER_Msk             (0x2UL)                   /*!< PER (Bitfield-Mask: 0x01)                             */
#define SN_FLASH_CTRL_MER_Pos             (2UL)                     /*!< MER (Bit 2)                                           */
#define SN_FLASH_CTRL_MER_Msk             (0x4UL)                   /*!< MER (Bitfield-Mask: 0x01)                             */
#define SN_FLASH_CTRL_START_Pos           (6UL)                     /*!< START (Bit 6)                                         */
#define SN_FLASH_CTRL_START_Msk           (0x40UL)                  /*!< START (Bitfield-Mask: 0x01)                           */
#define SN_FLASH_CTRL_CHK_Pos             (7UL)                     /*!< CHK (Bit 7)                                           */
#define SN_FLASH_CTRL_CHK_Msk             (0x80UL)                  /*!< CHK (Bitfield-Mask: 0x01)                             */
/* =========================================================  DATA  ========================================================== */
/* =========================================================  ADDR  ========================================================== */
/* ========================================================  CHKSUM  ========================================================= */
#define SN_FLASH_CHKSUM_UserROM_Pos       (0UL)                     /*!< UserROM (Bit 0)                                       */
#define SN_FLASH_CHKSUM_UserROM_Msk       (0xffffUL)                /*!< UserROM (Bitfield-Mask: 0xffff)                       */
#define SN_FLASH_CHKSUM_BootROM_Pos       (16UL)                    /*!< BootROM (Bit 16)                                      */
#define SN_FLASH_CHKSUM_BootROM_Msk       (0xffff0000UL)            /*!< BootROM (Bitfield-Mask: 0xffff)                       */


/* =========================================================================================================================== */
/* ================                                           SN_UC                                           ================ */
/* =========================================================================================================================== */

/* ========================================================  L4BYTE  ========================================================= */
/* ========================================================  H4BYTE  ========================================================= */

/** @} */ /* End of group PosMask_peripherals */


#ifdef __cplusplus
}
#endif

#endif /* SN32F260_DEFINES_H */


/** @} */ /* End of group SN32F260 */

/** @} */ /* End of group SONiX Technology Co., Ltd. */
