/*
 * ARM Limited (ARM) is supplying this software for use with Cortex-M
 * processor based microcontroller, but can be equally used for other
 * suitable processor architectures. This file can be freely distributed.
 * Modifications to this file shall be clearly marked.
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS". NO WARRANTIES, WHETHER EXPRESS, IMPLIED
 * OR STATUTORY, INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE.
 * ARM SHALL NOT, IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, OR
 * CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
 *
 * @file     SN32F240.h
 * @brief    CMSIS HeaderFile
 * @version  2.0
 * @date     09. January 2022
 * @note     Generated by SVDConv V3.3.35 on Sunday, 09.01.2022 18:49:12
 *           from File 'SN32F240.svd',
 *           last modified on Tuesday, 01.09.2020 10:52:27
 */



/** @addtogroup SONiX Technology Co., Ltd.
  * @{
  */


/** @addtogroup SN32F240
  * @{
  */


#ifndef SN32F240_H
#define SN32F240_H

#ifdef __cplusplus
extern "C" {
#endif


/** @addtogroup Configuration_of_CMSIS
  * @{
  */



/* =========================================================================================================================== */
/* ================                                Interrupt Number Definition                                ================ */
/* =========================================================================================================================== */

typedef enum {
/* =======================================  ARM Cortex-M0 Specific Interrupt Numbers  ======================================== */
  Reset_IRQn                = -15,              /*!< -15  Reset Vector, invoked on Power up and warm reset                     */
  NonMaskableInt_IRQn       = -14,              /*!< -14  Non maskable Interrupt, cannot be stopped or preempted               */
  HardFault_IRQn            = -13,              /*!< -13  Hard Fault, all classes of Fault                                     */
  SVCall_IRQn               =  -5,              /*!< -5 System Service Call via SVC instruction                                */
  PendSV_IRQn               =  -2,              /*!< -2 Pendable request for system service                                    */
  SysTick_IRQn              =  -1,              /*!< -1 System Tick Timer                                                      */
/* ==========================================  SN32F240 Specific Interrupt Numbers  ========================================== */
  NDT_IRQn                  =   0,              /*!< 0  NDT                                                                    */
  USB_IRQn                  =   1,              /*!< 1  USB                                                                    */
  LCD_IRQn                  =   2,              /*!< 2  LCD                                                                    */
  I2S_IRQn                  =   3,              /*!< 3  I2S                                                                    */
  SSP0_IRQn                 =   6,              /*!< 6  SSP0                                                                   */
  SSP1_IRQn                 =   7,              /*!< 7  SSP1                                                                   */
  I2C0_IRQn                 =  10,              /*!< 10 I2C0                                                                   */
  I2C1_IRQn                 =  11,              /*!< 11 I2C1                                                                   */
  USART0_IRQn               =  13,              /*!< 13 USART0                                                                 */
  USART1_IRQn               =  14,              /*!< 14 USART1                                                                 */
  CT16B0_IRQn               =  15,              /*!< 15 CT16B0                                                                 */
  CT16B1_IRQn               =  16,              /*!< 16 CT16B1                                                                 */
  CT16B2_IRQn               =  17,              /*!< 17 CT16B2                                                                 */
  CT32B0_IRQn               =  19,              /*!< 19 CT32B0                                                                 */
  CT32B1_IRQn               =  20,              /*!< 20 CT32B1                                                                 */
  CT32B2_IRQn               =  21,              /*!< 21 CT32B2                                                                 */
  RTC_IRQn                  =  23,              /*!< 23 RTC                                                                    */
  ADC_IRQn                  =  24,              /*!< 24 ADC                                                                    */
  WDT_IRQn                  =  25,              /*!< 25 WDT                                                                    */
  LVD_IRQn                  =  26,              /*!< 26 LVD                                                                    */
  P3_IRQn                   =  28,              /*!< 28 P3                                                                     */
  P2_IRQn                   =  29,              /*!< 29 P2                                                                     */
  P1_IRQn                   =  30,              /*!< 30 P1                                                                     */
  P0_IRQn                   =  31               /*!< 31 P0                                                                     */
} IRQn_Type;



/* =========================================================================================================================== */
/* ================                           Processor and Core Peripheral Section                           ================ */
/* =========================================================================================================================== */

/* ===========================  Configuration of the ARM Cortex-M0 Processor and Core Peripherals  =========================== */
#define __CM0_REV                 0x0000U       /*!< CM0 Core Revision                                                         */
#define __NVIC_PRIO_BITS               2        /*!< Number of Bits used for Priority Levels                                   */
#define __Vendor_SysTickConfig         0        /*!< Set to 1 if different SysTick Config is used                              */
#define __MPU_PRESENT                  0        /*!< MPU present                                                               */
#define __FPU_PRESENT                  0        /*!< FPU present                                                               */


/** @} */ /* End of group Configuration_of_CMSIS */

#include "core_cm0.h"                           /*!< ARM Cortex-M0 processor and core peripherals                              */
#include "system_SN32F2xx.h"                    /*!< SN32F240 System                                                           */

#ifndef __IM                                    /*!< Fallback for older CMSIS versions                                         */
  #define __IM   __I
#endif
#ifndef __OM                                    /*!< Fallback for older CMSIS versions                                         */
  #define __OM   __O
#endif
#ifndef __IOM                                   /*!< Fallback for older CMSIS versions                                         */
  #define __IOM  __IO
#endif


/* ========================================  Start of section using anonymous unions  ======================================== */
#if defined (__CC_ARM)
  #pragma push
  #pragma anon_unions
#elif defined (__ICCARM__)
  #pragma language=extended
#elif defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
  #pragma clang diagnostic push
  #pragma clang diagnostic ignored "-Wc11-extensions"
  #pragma clang diagnostic ignored "-Wreserved-id-macro"
  #pragma clang diagnostic ignored "-Wgnu-anonymous-struct"
  #pragma clang diagnostic ignored "-Wnested-anon-types"
#elif defined (__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined (__TMS470__)
  /* anonymous unions are enabled by default */
#elif defined (__TASKING__)
  #pragma warning 586
#elif defined (__CSMC__)
  /* anonymous unions are enabled by default */
#else
  #warning Not supported compiler type
#endif


/* =========================================================================================================================== */
/* ================                            Device Specific Peripheral Section                             ================ */
/* =========================================================================================================================== */


/** @addtogroup Device_Peripheral_peripherals
  * @{
  */



/* =========================================================================================================================== */
/* ================                                          SN_SYS0                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief System Control Registers (SN_SYS0)
  */

typedef struct {                                /*!< (@ 0x40060000) SN_SYS0 Structure                                          */
  
  union {
    __IOM uint32_t ANBCTRL;                     /*!< (@ 0x00000000) Offset:0x00 Analog Block Control Register                  */
    
    struct {
      __IOM uint32_t IHRCEN     : 1;            /*!< [0..0] IHRC enable                                                        */
            uint32_t            : 1;
      __IOM uint32_t ELSEN      : 1;            /*!< [2..2] ELS XTAL enable                                                    */
            uint32_t            : 1;
      __IOM uint32_t EHSEN      : 1;            /*!< [4..4] EHS XTAL enable                                                    */
      __IOM uint32_t EHSFREQ    : 1;            /*!< [5..5] EHS XTAL frequency range                                           */
            uint32_t            : 26;
    } ANBCTRL_b;
  } ;
  
  union {
    __IOM uint32_t PLLCTRL;                     /*!< (@ 0x00000004) Offset:0x04 PLL Control Register                           */
    
    struct {
      __IOM uint32_t MSEL       : 5;            /*!< [4..0] M: 3~31                                                            */
      __IOM uint32_t PSEL       : 3;            /*!< [7..5] P=PSEL*2                                                           */
      __IOM uint32_t FSEL       : 1;            /*!< [8..8] F=POWER(2, FSEL)                                                   */
            uint32_t            : 3;
      __IOM uint32_t PLLCLKSEL  : 2;            /*!< [13..12] PLL clock source                                                 */
            uint32_t            : 1;
      __IOM uint32_t PLLEN      : 1;            /*!< [15..15] PLL enable                                                       */
            uint32_t            : 16;
    } PLLCTRL_b;
  } ;
  
  union {
    __IM  uint32_t CSST;                        /*!< (@ 0x00000008) Offset:0x08 Clock Source Status Register                   */
    
    struct {
      __IM  uint32_t IHRCRDY    : 1;            /*!< [0..0] IHRC ready flag                                                    */
            uint32_t            : 1;
      __IM  uint32_t ELSRDY     : 1;            /*!< [2..2] ELS XTAL ready flag                                                */
            uint32_t            : 1;
      __IM  uint32_t EHSRDY     : 1;            /*!< [4..4] EHS XTAL ready flag                                                */
            uint32_t            : 1;
      __IM  uint32_t PLLRDY     : 1;            /*!< [6..6] PLL ready flag                                                     */
            uint32_t            : 25;
    } CSST_b;
  } ;
  
  union {
    __IOM uint32_t CLKCFG;                      /*!< (@ 0x0000000C) Offset:0x0C System Clock Configuration Register            */
    
    struct {
      __IOM uint32_t SYSCLKSEL  : 3;            /*!< [2..0] System clock source selection                                      */
            uint32_t            : 1;
      __IM  uint32_t SYSCLKST   : 3;            /*!< [6..4] System clock switch status                                         */
            uint32_t            : 25;
    } CLKCFG_b;
  } ;
  
  union {
    __IOM uint32_t AHBCP;                       /*!< (@ 0x00000010) Offset:0x10 AHB Clock Prescale Register                    */
    
    struct {
      __IOM uint32_t AHBPRE     : 4;            /*!< [3..0] AHB clock source prescaler                                         */
            uint32_t            : 28;
    } AHBCP_b;
  } ;
  
  union {
    __IOM uint32_t RSTST;                       /*!< (@ 0x00000014) Offset:0x14 System Reset Status Register                   */
    
    struct {
      __IOM uint32_t SWRSTF     : 1;            /*!< [0..0] Software reset flag                                                */
      __IOM uint32_t WDTRSTF    : 1;            /*!< [1..1] WDT reset flag                                                     */
      __IOM uint32_t LVDRSTF    : 1;            /*!< [2..2] LVD reset flag                                                     */
      __IOM uint32_t EXTRSTF    : 1;            /*!< [3..3] External reset flag                                                */
      __IOM uint32_t PORRSTF    : 1;            /*!< [4..4] POR reset flag                                                     */
            uint32_t            : 27;
    } RSTST_b;
  } ;
  
  union {
    __IOM uint32_t LVDCTRL;                     /*!< (@ 0x00000018) Offset:0x18 LVD Control Register                           */
    
    struct {
      __IOM uint32_t LVDRSTLVL  : 3;            /*!< [2..0] LVD reset level                                                    */
            uint32_t            : 1;
      __IOM uint32_t LVDINTLVL  : 3;            /*!< [6..4] LVD interrupt level                                                */
            uint32_t            : 7;
      __IOM uint32_t LVDRSTEN   : 1;            /*!< [14..14] LVD Reset enable                                                 */
      __IOM uint32_t LVDEN      : 1;            /*!< [15..15] LVD enable                                                       */
            uint32_t            : 16;
    } LVDCTRL_b;
  } ;
  
  union {
    __IOM uint32_t EXRSTCTRL;                   /*!< (@ 0x0000001C) Offset:0x1C External Reset Pin Control Register            */
    
    struct {
      __IOM uint32_t RESETDIS   : 1;            /*!< [0..0] External reset pin disable                                         */
            uint32_t            : 31;
    } EXRSTCTRL_b;
  } ;
  
  union {
    __IOM uint32_t SWDCTRL;                     /*!< (@ 0x00000020) Offset:0x20 SWD Pin Control Register                       */
    
    struct {
      __IOM uint32_t SWDDIS     : 1;            /*!< [0..0] SWD pin disable                                                    */
            uint32_t            : 31;
    } SWDCTRL_b;
  } ;
  __IM  uint32_t  RESERVED;
  
  union {
    __IOM uint32_t NDTCTRL;                     /*!< (@ 0x00000028) Offset:0x28 Noise Detect Control Register                  */
    
    struct {
      __IOM uint32_t NDT1_IE    : 1;            /*!< [0..0] NDT for Vcore interrupt enable bit                                 */
      __IOM uint32_t NDT2_IE    : 1;            /*!< [1..1] NDT for VDD interrupt enable bit                                   */
            uint32_t            : 30;
    } NDTCTRL_b;
  } ;
  
  union {
    __IOM uint32_t NDTSTS;                      /*!< (@ 0x0000002C) Offset:0x2C Noise Detect Status Register                   */
    
    struct {
      __IOM uint32_t NDT1_DET   : 1;            /*!< [0..0] Power noise status of NDT1                                         */
      __IOM uint32_t NDT2_DET   : 1;            /*!< [1..1] Power noise status of NDT2                                         */
            uint32_t            : 30;
    } NDTSTS_b;
  } ;
  
  union {
    __IOM uint32_t ANTIEFT;                     /*!< (@ 0x00000030) Offset:0x30 Anti-EFT Ability Control Register              */
    
    struct {
      __IOM uint32_t AEFT       : 3;            /*!< [2..0] Anti-EFT ability                                                   */
            uint32_t            : 29;
    } ANTIEFT_b;
  } ;
} SN_SYS0_Type;                                 /*!< Size = 52 (0x34)                                                          */



/* =========================================================================================================================== */
/* ================                                          SN_SYS1                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief System Control Registers (SN_SYS1)
  */

typedef struct {                                /*!< (@ 0x4005E000) SN_SYS1 Structure                                          */
  
  union {
    __IOM uint32_t AHBCLKEN;                    /*!< (@ 0x00000000) Offset:0x00 AHB Clock Enable Register                      */
    
    struct {
      __IOM uint32_t GPIOCLKEN  : 1;            /*!< [0..0] Enable AHB clock for GPIO                                          */
      __IOM uint32_t USBCLKEN   : 1;            /*!< [1..1] Enable AHB clock for USB                                           */
      __IOM uint32_t LCDCLKEN   : 1;            /*!< [2..2] Enable AHB clock for LCD                                           */
            uint32_t            : 2;
      __IOM uint32_t CT16B0CLKEN : 1;           /*!< [5..5] Enable AHB clock for CT16B0                                        */
      __IOM uint32_t CT16B1CLKEN : 1;           /*!< [6..6] Enable AHB clock for CT16B1                                        */
      __IOM uint32_t CT16B2CLKEN : 1;           /*!< [7..7] Enable AHB clock for CT16B2                                        */
      __IOM uint32_t CT32B0CLKEN : 1;           /*!< [8..8] Enable AHB clock for CT32B0                                        */
      __IOM uint32_t CT32B1CLKEN : 1;           /*!< [9..9] Enable AHB clock for CT32B1                                        */
      __IOM uint32_t CT32B2CLKEN : 1;           /*!< [10..10] Enable AHB clock for CT32B2                                      */
      __IOM uint32_t ADCCLKEN   : 1;            /*!< [11..11] Enable AHB clock for ADC                                         */
      __IOM uint32_t SSP0CLKEN  : 1;            /*!< [12..12] Enable AHB clock for SSP0                                        */
      __IOM uint32_t SSP1CLKEN  : 1;            /*!< [13..13] Enable AHB clock for SSP1                                        */
            uint32_t            : 2;
      __IOM uint32_t USART0CLKEN : 1;           /*!< [16..16] Enable AHB clock for USART0                                      */
      __IOM uint32_t USART1CLKEN : 1;           /*!< [17..17] Enable AHB clock for USART1                                      */
            uint32_t            : 2;
      __IOM uint32_t I2C1CLKEN  : 1;            /*!< [20..20] Enable AHB clock for I2C1                                        */
      __IOM uint32_t I2C0CLKEN  : 1;            /*!< [21..21] Enable AHB clock for I2C0                                        */
      __IOM uint32_t I2SCLKEN   : 1;            /*!< [22..22] Enable AHB clock for I2S                                         */
      __IOM uint32_t RTCCLKEN   : 1;            /*!< [23..23] Enable AHB clock for RTC                                         */
      __IOM uint32_t WDTCLKEN   : 1;            /*!< [24..24] Enable AHB clock for WDT                                         */
            uint32_t            : 3;
      __IOM uint32_t CLKOUTSEL  : 3;            /*!< [30..28] Clock output source selection                                    */
            uint32_t            : 1;
    } AHBCLKEN_b;
  } ;
  
  union {
    __IOM uint32_t APBCP0;                      /*!< (@ 0x00000004) Offset:0x04 APB Clock Prescale Register 0                  */
    
    struct {
      __IOM uint32_t CT16B0PRE  : 3;            /*!< [2..0] CT16B0 APB clock source prescaler                                  */
            uint32_t            : 1;
      __IOM uint32_t CT16B1PRE  : 3;            /*!< [6..4] CT16B1 APB clock source prescaler                                  */
            uint32_t            : 1;
      __IOM uint32_t CT32B0PRE  : 3;            /*!< [10..8] CT32B0 APB clock source prescaler                                 */
            uint32_t            : 1;
      __IOM uint32_t CT32B1PRE  : 3;            /*!< [14..12] CT32B1 APB clock source prescaler                                */
            uint32_t            : 1;
      __IOM uint32_t ADCPRE     : 3;            /*!< [18..16] ADC APB clock source prescaler                                   */
            uint32_t            : 1;
      __IOM uint32_t SSP0PRE    : 3;            /*!< [22..20] SSP0 APB clock source prescaler                                  */
            uint32_t            : 1;
      __IOM uint32_t SSP1PRE    : 3;            /*!< [26..24] SSP1 APB clock source prescaler                                  */
            uint32_t            : 1;
      __IOM uint32_t CT32B2PRE  : 3;            /*!< [30..28] CT32B2 APB clock source prescaler                                */
            uint32_t            : 1;
    } APBCP0_b;
  } ;
  
  union {
    __IOM uint32_t APBCP1;                      /*!< (@ 0x00000008) Offset:0x08 APB Clock Prescale Register 1                  */
    
    struct {
      __IOM uint32_t USART0PRE  : 3;            /*!< [2..0] USART0 APB clock source prescaler                                  */
            uint32_t            : 1;
      __IOM uint32_t USART1PRE  : 3;            /*!< [6..4] USART1 APB clock source prescaler                                  */
            uint32_t            : 1;
      __IOM uint32_t I2C0PRE    : 3;            /*!< [10..8] I2C0 APB clock source prescaler                                   */
            uint32_t            : 1;
      __IOM uint32_t I2SPRE     : 3;            /*!< [14..12] I2S APB clock source prescaler                                   */
            uint32_t            : 1;
      __IOM uint32_t SYSTICKPRE : 2;            /*!< [17..16] SysTick APB clock source prescaler                               */
            uint32_t            : 2;
      __IOM uint32_t WDTPRE     : 3;            /*!< [22..20] WDT APB clock source prescaler                                   */
            uint32_t            : 1;
      __IOM uint32_t I2C1PRE    : 3;            /*!< [26..24] I2C1 APB clock source prescaler                                  */
            uint32_t            : 1;
      __IOM uint32_t CT16B2PRE  : 3;            /*!< [30..28] CT16B2 APB clock source prescaler                                */
            uint32_t            : 1;
    } APBCP1_b;
  } ;
  
  union {
    __IOM uint32_t APBCP2;                      /*!< (@ 0x0000000C) Offset:0x0C APB Clock Prescale Register 2                  */
    
    struct {
      __IOM uint32_t CLKOUTPRE  : 4;            /*!< [3..0] CLKOUT APB clock source prescaler                                  */
            uint32_t            : 28;
    } APBCP2_b;
  } ;
  
  union {
    __IOM uint32_t PRST;                        /*!< (@ 0x00000010) Offset:0x10 Peripheral Reset Register                      */
    
    struct {
      __IOM uint32_t GPIO0RST   : 1;            /*!< [0..0] GPIO0 Reset                                                        */
      __IOM uint32_t GPIO1RST   : 1;            /*!< [1..1] GPIO1 Reset                                                        */
      __IOM uint32_t GPIO2RST   : 1;            /*!< [2..2] GPIO2 Reset                                                        */
      __IOM uint32_t GPIO3RST   : 1;            /*!< [3..3] GPIO3 Reset                                                        */
            uint32_t            : 1;
      __IOM uint32_t CT16B0RST  : 1;            /*!< [5..5] CT16B0 Reset                                                       */
      __IOM uint32_t CT16B1RST  : 1;            /*!< [6..6] CT16B1 Reset                                                       */
      __IOM uint32_t CT16B2RST  : 1;            /*!< [7..7] CT16B2 Reset                                                       */
      __IOM uint32_t CT32B0RST  : 1;            /*!< [8..8] CT32B0 Reset                                                       */
      __IOM uint32_t CT32B1RST  : 1;            /*!< [9..9] CT32B1 Reset                                                       */
      __IOM uint32_t CT32B2RST  : 1;            /*!< [10..10] CT32B2 Reset                                                     */
      __IOM uint32_t ADCRST     : 1;            /*!< [11..11] ADC Reset                                                        */
      __IOM uint32_t SSP0RST    : 1;            /*!< [12..12] SSP0 Reset                                                       */
      __IOM uint32_t SSP1RST    : 1;            /*!< [13..13] SSP1 Reset                                                       */
            uint32_t            : 1;
      __IOM uint32_t LCDRST     : 1;            /*!< [15..15] LCD Reset                                                        */
      __IOM uint32_t USART0RST  : 1;            /*!< [16..16] USART0 Reset                                                     */
      __IOM uint32_t USART1RST  : 1;            /*!< [17..17] USART1 Reset                                                     */
            uint32_t            : 2;
      __IOM uint32_t I2C1RST    : 1;            /*!< [20..20] I2C1 Reset                                                       */
      __IOM uint32_t I2C0RST    : 1;            /*!< [21..21] I2C0 Reset                                                       */
      __IOM uint32_t I2SRST     : 1;            /*!< [22..22] I2S Reset                                                        */
      __IOM uint32_t RTCRST     : 1;            /*!< [23..23] RTC Reset                                                        */
      __IOM uint32_t WDTRST     : 1;            /*!< [24..24] WDT Reset                                                        */
      __IOM uint32_t USBRST     : 1;            /*!< [25..25] USB Reset                                                        */
            uint32_t            : 6;
    } PRST_b;
  } ;
  __IM  uint32_t  RESERVED[3];
  __IOM uint32_t  DIVIDEND;                     /*!< (@ 0x00000020) Offset:0x20 Divider Dividend Register                      */
  __IOM uint32_t  DIVISOR;                      /*!< (@ 0x00000024) Offset:0x24 Divider Dividend Register                      */
  __IM  uint32_t  QUOTIENT;                     /*!< (@ 0x00000028) Offset:0x28 Divider Quotient Register                      */
  __IM  uint32_t  REMAINDER;                    /*!< (@ 0x0000002C) Offset:0x2C Divider Remainder Register                     */
  
  union {
    __IOM uint32_t DIVCTRL;                     /*!< (@ 0x00000030) Offset:0x30 Divider Control Register                       */
    
    struct {
      __IOM uint32_t DIVS       : 1;            /*!< [0..0] Divider start control bit                                          */
            uint32_t            : 31;
    } DIVCTRL_b;
  } ;
} SN_SYS1_Type;                                 /*!< Size = 52 (0x34)                                                          */



/* =========================================================================================================================== */
/* ================                                         SN_GPIO0                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief General Purpose I/O (SN_GPIO0)
  */

typedef struct {                                /*!< (@ 0x40044000) SN_GPIO0 Structure                                         */
  
  union {
    __IOM uint32_t DATA;                        /*!< (@ 0x00000000) Offset:0x00 GPIO Port n Data Register                      */
    
    struct {
      __IOM uint32_t DATA0      : 1;            /*!< [0..0] Data of Pn.0                                                       */
      __IOM uint32_t DATA1      : 1;            /*!< [1..1] Data of Pn.1                                                       */
      __IOM uint32_t DATA2      : 1;            /*!< [2..2] Data of Pn.2                                                       */
      __IOM uint32_t DATA3      : 1;            /*!< [3..3] Data of Pn.3                                                       */
      __IOM uint32_t DATA4      : 1;            /*!< [4..4] Data of Pn.4                                                       */
      __IOM uint32_t DATA5      : 1;            /*!< [5..5] Data of Pn.5                                                       */
      __IOM uint32_t DATA6      : 1;            /*!< [6..6] Data of Pn.6                                                       */
      __IOM uint32_t DATA7      : 1;            /*!< [7..7] Data of Pn.7                                                       */
      __IOM uint32_t DATA8      : 1;            /*!< [8..8] Data of Pn.8                                                       */
      __IOM uint32_t DATA9      : 1;            /*!< [9..9] Data of Pn.9                                                       */
      __IOM uint32_t DATA10     : 1;            /*!< [10..10] Data of Pn.10                                                    */
      __IOM uint32_t DATA11     : 1;            /*!< [11..11] Data of Pn.11                                                    */
      __IOM uint32_t DATA12     : 1;            /*!< [12..12] Data of Pn.12                                                    */
      __IOM uint32_t DATA13     : 1;            /*!< [13..13] Data of Pn.13                                                    */
      __IOM uint32_t DATA14     : 1;            /*!< [14..14] Data of Pn.14                                                    */
      __IOM uint32_t DATA15     : 1;            /*!< [15..15] Data of Pn.15                                                    */
            uint32_t            : 16;
    } DATA_b;
  } ;
  
  union {
    __IOM uint32_t MODE;                        /*!< (@ 0x00000004) Offset:0x04 GPIO Port n Mode Register                      */
    
    struct {
      __IOM uint32_t MODE0      : 1;            /*!< [0..0] Mode of Pn.0                                                       */
      __IOM uint32_t MODE1      : 1;            /*!< [1..1] Mode of Pn.1                                                       */
      __IOM uint32_t MODE2      : 1;            /*!< [2..2] Mode of Pn.2                                                       */
      __IOM uint32_t MODE3      : 1;            /*!< [3..3] Mode of Pn.3                                                       */
      __IOM uint32_t MODE4      : 1;            /*!< [4..4] Mode of Pn.4                                                       */
      __IOM uint32_t MODE5      : 1;            /*!< [5..5] Mode of Pn.5                                                       */
      __IOM uint32_t MODE6      : 1;            /*!< [6..6] Mode of Pn.6                                                       */
      __IOM uint32_t MODE7      : 1;            /*!< [7..7] Mode of Pn.7                                                       */
      __IOM uint32_t MODE8      : 1;            /*!< [8..8] Mode of Pn.8                                                       */
      __IOM uint32_t MODE9      : 1;            /*!< [9..9] Mode of Pn.9                                                       */
      __IOM uint32_t MODE10     : 1;            /*!< [10..10] Mode of Pn.10                                                    */
      __IOM uint32_t MODE11     : 1;            /*!< [11..11] Mode of Pn.11                                                    */
      __IOM uint32_t MODE12     : 1;            /*!< [12..12] Mode of Pn.12                                                    */
      __IOM uint32_t MODE13     : 1;            /*!< [13..13] Mode of Pn.13                                                    */
      __IOM uint32_t MODE14     : 1;            /*!< [14..14] Mode of Pn.14                                                    */
      __IOM uint32_t MODE15     : 1;            /*!< [15..15] Mode of Pn.15                                                    */
      __IOM uint32_t CURRENT0   : 1;            /*!< [16..16] Driving/Sinking current of Pn.0                                  */
      __IOM uint32_t CURRENT1   : 1;            /*!< [17..17] Driving/Sinking current of Pn.1                                  */
      __IOM uint32_t CURRENT2   : 1;            /*!< [18..18] Driving/Sinking current of Pn.2                                  */
      __IOM uint32_t CURRENT3   : 1;            /*!< [19..19] Driving/Sinking current of Pn.3                                  */
      __IOM uint32_t CURRENT4   : 1;            /*!< [20..20] Driving/Sinking current of Pn.4                                  */
      __IOM uint32_t CURRENT5   : 1;            /*!< [21..21] Driving/Sinking current of Pn.5                                  */
      __IOM uint32_t CURRENT6   : 1;            /*!< [22..22] Driving/Sinking current of Pn.6                                  */
      __IOM uint32_t CURRENT7   : 1;            /*!< [23..23] Driving/Sinking current of Pn.7                                  */
      __IOM uint32_t CURRENT8   : 1;            /*!< [24..24] Driving/Sinking current of Pn.8                                  */
      __IOM uint32_t CURRENT9   : 1;            /*!< [25..25] Driving/Sinking current of Pn.9                                  */
      __IOM uint32_t CURRENT10  : 1;            /*!< [26..26] Driving/Sinking current of Pn.10                                 */
      __IOM uint32_t CURRENT11  : 1;            /*!< [27..27] Driving/Sinking current of Pn.11                                 */
      __IOM uint32_t CURRENT12  : 1;            /*!< [28..28] Driving/Sinking current of Pn.12                                 */
      __IOM uint32_t CURRENT13  : 1;            /*!< [29..29] Driving/Sinking current of Pn.13                                 */
      __IOM uint32_t CURRENT14  : 1;            /*!< [30..30] Driving/Sinking current of Pn.14                                 */
      __IOM uint32_t CURRENT15  : 1;            /*!< [31..31] Driving/Sinking current of Pn.15                                 */
    } MODE_b;
  } ;
  
  union {
    __IOM uint32_t CFG;                         /*!< (@ 0x00000008) Offset:0x08 GPIO Port n Configuration Register             */
    
    struct {
      __IOM uint32_t CFG0       : 2;            /*!< [1..0] Configuration of Pn.0                                              */
      __IOM uint32_t CFG1       : 2;            /*!< [3..2] Configuration of Pn.1                                              */
      __IOM uint32_t CFG2       : 2;            /*!< [5..4] Configuration of Pn.2                                              */
      __IOM uint32_t CFG3       : 2;            /*!< [7..6] Configuration of Pn.3                                              */
      __IOM uint32_t CFG4       : 2;            /*!< [9..8] Configuration of Pn.4                                              */
      __IOM uint32_t CFG5       : 2;            /*!< [11..10] Configuration of Pn.5                                            */
      __IOM uint32_t CFG6       : 2;            /*!< [13..12] Configuration of Pn.6                                            */
      __IOM uint32_t CFG7       : 2;            /*!< [15..14] Configuration of Pn.7                                            */
      __IOM uint32_t CFG8       : 2;            /*!< [17..16] Configuration of Pn.8                                            */
      __IOM uint32_t CFG9       : 2;            /*!< [19..18] Configuration of Pn.9                                            */
      __IOM uint32_t CFG10      : 2;            /*!< [21..20] Configuration of Pn.10                                           */
      __IOM uint32_t CFG11      : 2;            /*!< [23..22] Configuration of Pn.11                                           */
      __IOM uint32_t CFG12      : 2;            /*!< [25..24] Configuration of Pn.12                                           */
      __IOM uint32_t CFG13      : 2;            /*!< [27..26] Configuration of Pn.13                                           */
      __IOM uint32_t CFG14      : 2;            /*!< [29..28] Configuration of Pn.14                                           */
      __IOM uint32_t CFG15      : 2;            /*!< [31..30] Configuration of Pn.15                                           */
    } CFG_b;
  } ;
  
  union {
    __IOM uint32_t IS;                          /*!< (@ 0x0000000C) Offset:0x0C GPIO Port n Interrupt Sense Register           */
    
    struct {
      __IOM uint32_t IS0        : 1;            /*!< [0..0] Interrupt on Pn.0 is event or edge sensitive                       */
      __IOM uint32_t IS1        : 1;            /*!< [1..1] Interrupt on Pn.1 is event or edge sensitive                       */
      __IOM uint32_t IS2        : 1;            /*!< [2..2] Interrupt on Pn.2 is event or edge sensitive                       */
      __IOM uint32_t IS3        : 1;            /*!< [3..3] Interrupt on Pn.3 is event or edge sensitive                       */
      __IOM uint32_t IS4        : 1;            /*!< [4..4] Interrupt on Pn.4 is event or edge sensitive                       */
      __IOM uint32_t IS5        : 1;            /*!< [5..5] Interrupt on Pn.5 is event or edge sensitive                       */
      __IOM uint32_t IS6        : 1;            /*!< [6..6] Interrupt on Pn.6 is event or edge sensitive                       */
      __IOM uint32_t IS7        : 1;            /*!< [7..7] Interrupt on Pn.7 is event or edge sensitive                       */
      __IOM uint32_t IS8        : 1;            /*!< [8..8] Interrupt on Pn.8 is event or edge sensitive                       */
      __IOM uint32_t IS9        : 1;            /*!< [9..9] Interrupt on Pn.9 is event or edge sensitive                       */
      __IOM uint32_t IS10       : 1;            /*!< [10..10] Interrupt on Pn.10 is event or edge sensitive                    */
      __IOM uint32_t IS11       : 1;            /*!< [11..11] Interrupt on Pn.11 is event or edge sensitive                    */
      __IOM uint32_t IS12       : 1;            /*!< [12..12] Interrupt on Pn.12 is event or edge sensitive                    */
      __IOM uint32_t IS13       : 1;            /*!< [13..13] Interrupt on Pn.13 is event or edge sensitive                    */
      __IOM uint32_t IS14       : 1;            /*!< [14..14] Interrupt on Pn.14 is event or edge sensitive                    */
      __IOM uint32_t IS15       : 1;            /*!< [15..15] Interrupt on Pn.15 is event or edge sensitive                    */
            uint32_t            : 16;
    } IS_b;
  } ;
  
  union {
    __IOM uint32_t IBS;                         /*!< (@ 0x00000010) Offset:0x10 GPIO Port n Interrupt Both-edge Sense
                                                                    Register                                                   */
    
    struct {
      __IOM uint32_t IBS0       : 1;            /*!< [0..0] Interrupt on Pn.0 is triggered ob both edges                       */
      __IOM uint32_t IBS1       : 1;            /*!< [1..1] Interrupt on Pn.1 is triggered ob both edges                       */
      __IOM uint32_t IBS2       : 1;            /*!< [2..2] Interrupt on Pn.2 is triggered ob both edges                       */
      __IOM uint32_t IBS3       : 1;            /*!< [3..3] Interrupt on Pn.3 is triggered ob both edges                       */
      __IOM uint32_t IBS4       : 1;            /*!< [4..4] Interrupt on Pn.4 is triggered ob both edges                       */
      __IOM uint32_t IBS5       : 1;            /*!< [5..5] Interrupt on Pn.5 is triggered ob both edges                       */
      __IOM uint32_t IBS6       : 1;            /*!< [6..6] Interrupt on Pn.6 is triggered ob both edges                       */
      __IOM uint32_t IBS7       : 1;            /*!< [7..7] Interrupt on Pn.7 is triggered ob both edges                       */
      __IOM uint32_t IBS8       : 1;            /*!< [8..8] Interrupt on Pn.8 is triggered ob both edges                       */
      __IOM uint32_t IBS9       : 1;            /*!< [9..9] Interrupt on Pn.9 is triggered ob both edges                       */
      __IOM uint32_t IBS10      : 1;            /*!< [10..10] Interrupt on Pn.10 is triggered ob both edges                    */
      __IOM uint32_t IBS11      : 1;            /*!< [11..11] Interrupt on Pn.11 is triggered ob both edges                    */
      __IOM uint32_t IBS12      : 1;            /*!< [12..12] Interrupt on Pn.12 is triggered ob both edges                    */
      __IOM uint32_t IBS13      : 1;            /*!< [13..13] Interrupt on Pn.13 is triggered ob both edges                    */
      __IOM uint32_t IBS14      : 1;            /*!< [14..14] Interrupt on Pn.14 is triggered ob both edges                    */
      __IOM uint32_t IBS15      : 1;            /*!< [15..15] Interrupt on Pn.15 is triggered ob both edges                    */
            uint32_t            : 16;
    } IBS_b;
  } ;
  
  union {
    __IOM uint32_t IEV;                         /*!< (@ 0x00000014) Offset:0x14 GPIO Port n Interrupt Event Register           */
    
    struct {
      __IOM uint32_t IEV0       : 1;            /*!< [0..0] Interrupt trigged evnet on Pn.0                                    */
      __IOM uint32_t IEV1       : 1;            /*!< [1..1] Interrupt trigged evnet on Pn.1                                    */
      __IOM uint32_t IEV2       : 1;            /*!< [2..2] Interrupt trigged evnet on Pn.2                                    */
      __IOM uint32_t IEV3       : 1;            /*!< [3..3] Interrupt trigged evnet on Pn.3                                    */
      __IOM uint32_t IEV4       : 1;            /*!< [4..4] Interrupt trigged evnet on Pn.4                                    */
      __IOM uint32_t IEV5       : 1;            /*!< [5..5] Interrupt trigged evnet on Pn.5                                    */
      __IOM uint32_t IEV6       : 1;            /*!< [6..6] Interrupt trigged evnet on Pn.6                                    */
      __IOM uint32_t IEV7       : 1;            /*!< [7..7] Interrupt trigged evnet on Pn.7                                    */
      __IOM uint32_t IEV8       : 1;            /*!< [8..8] Interrupt trigged evnet on Pn.8                                    */
      __IOM uint32_t IEV9       : 1;            /*!< [9..9] Interrupt trigged evnet on Pn.9                                    */
      __IOM uint32_t IEV10      : 1;            /*!< [10..10] Interrupt trigged evnet on Pn.10                                 */
      __IOM uint32_t IEV11      : 1;            /*!< [11..11] Interrupt trigged evnet on Pn.11                                 */
      __IOM uint32_t IEV12      : 1;            /*!< [12..12] Interrupt trigged evnet on Pn.12                                 */
      __IOM uint32_t IEV13      : 1;            /*!< [13..13] Interrupt trigged evnet on Pn.13                                 */
      __IOM uint32_t IEV14      : 1;            /*!< [14..14] Interrupt trigged evnet on Pn.14                                 */
      __IOM uint32_t IEV15      : 1;            /*!< [15..15] Interrupt trigged evnet on Pn.15                                 */
            uint32_t            : 16;
    } IEV_b;
  } ;
  
  union {
    __IOM uint32_t IE;                          /*!< (@ 0x00000018) Offset:0x18 GPIO Port n Interrupt Enable Register          */
    
    struct {
      __IOM uint32_t IE0        : 1;            /*!< [0..0] Interrupt on Pn.0 enable                                           */
      __IOM uint32_t IE1        : 1;            /*!< [1..1] Interrupt on Pn.1 enable                                           */
      __IOM uint32_t IE2        : 1;            /*!< [2..2] Interrupt on Pn.2 enable                                           */
      __IOM uint32_t IE3        : 1;            /*!< [3..3] Interrupt on Pn.3 enable                                           */
      __IOM uint32_t IE4        : 1;            /*!< [4..4] Interrupt on Pn.4 enable                                           */
      __IOM uint32_t IE5        : 1;            /*!< [5..5] Interrupt on Pn.5 enable                                           */
      __IOM uint32_t IE6        : 1;            /*!< [6..6] Interrupt on Pn.6 enable                                           */
      __IOM uint32_t IE7        : 1;            /*!< [7..7] Interrupt on Pn.7 enable                                           */
      __IOM uint32_t IE8        : 1;            /*!< [8..8] Interrupt on Pn.8 enable                                           */
      __IOM uint32_t IE9        : 1;            /*!< [9..9] Interrupt on Pn.9 enable                                           */
      __IOM uint32_t IE10       : 1;            /*!< [10..10] Interrupt on Pn.10 enable                                        */
      __IOM uint32_t IE11       : 1;            /*!< [11..11] Interrupt on Pn.11 enable                                        */
      __IOM uint32_t IE12       : 1;            /*!< [12..12] Interrupt on Pn.11 enable                                        */
      __IOM uint32_t IE13       : 1;            /*!< [13..13] Interrupt on Pn.13 enable                                        */
      __IOM uint32_t IE14       : 1;            /*!< [14..14] Interrupt on Pn.14 enable                                        */
      __IOM uint32_t IE15       : 1;            /*!< [15..15] Interrupt on Pn.15 enable                                        */
            uint32_t            : 16;
    } IE_b;
  } ;
  
  union {
    __IM  uint32_t RIS;                         /*!< (@ 0x0000001C) Offset:0x1C GPIO Port n Raw Interrupt Status
                                                                    Register                                                   */
    
    struct {
      __IM  uint32_t IF0        : 1;            /*!< [0..0] Pn.0 raw interrupt flag                                            */
      __IM  uint32_t IF1        : 1;            /*!< [1..1] Pn.1 raw interrupt flag                                            */
      __IM  uint32_t IF2        : 1;            /*!< [2..2] Pn.2 raw interrupt flag                                            */
      __IM  uint32_t IF3        : 1;            /*!< [3..3] Pn.3 raw interrupt flag                                            */
      __IM  uint32_t IF4        : 1;            /*!< [4..4] Pn.4 raw interrupt flag                                            */
      __IM  uint32_t IF5        : 1;            /*!< [5..5] Pn.5 raw interrupt flag                                            */
      __IM  uint32_t IF6        : 1;            /*!< [6..6] Pn.6 raw interrupt flag                                            */
      __IM  uint32_t IF7        : 1;            /*!< [7..7] Pn.7 raw interrupt flag                                            */
      __IM  uint32_t IF8        : 1;            /*!< [8..8] Pn.8 raw interrupt flag                                            */
      __IM  uint32_t IF9        : 1;            /*!< [9..9] Pn.9 raw interrupt flag                                            */
      __IM  uint32_t IF10       : 1;            /*!< [10..10] Pn.10 raw interrupt flag                                         */
      __IM  uint32_t IF11       : 1;            /*!< [11..11] Pn.11 raw interrupt flag                                         */
      __IM  uint32_t IF12       : 1;            /*!< [12..12] Pn.12 raw interrupt flag                                         */
      __IM  uint32_t IF13       : 1;            /*!< [13..13] Pn.13 raw interrupt flag                                         */
      __IM  uint32_t IF14       : 1;            /*!< [14..14] Pn.14 raw interrupt flag                                         */
      __IM  uint32_t IF15       : 1;            /*!< [15..15] Pn.15 raw interrupt flag                                         */
            uint32_t            : 16;
    } RIS_b;
  } ;
  
  union {
    __OM  uint32_t IC;                          /*!< (@ 0x00000020) Offset:0x20 GPIO Port n Interrupt Clear Register           */
    
    struct {
      __OM  uint32_t IC0        : 1;            /*!< [0..0] Pn.0 interrupt flag clear                                          */
      __OM  uint32_t IC1        : 1;            /*!< [1..1] Pn.1 interrupt flag clear                                          */
      __OM  uint32_t IC2        : 1;            /*!< [2..2] Pn.2 interrupt flag clear                                          */
      __OM  uint32_t IC3        : 1;            /*!< [3..3] Pn.3 interrupt flag clear                                          */
      __OM  uint32_t IC4        : 1;            /*!< [4..4] Pn.4 interrupt flag clear                                          */
      __OM  uint32_t IC5        : 1;            /*!< [5..5] Pn.5 interrupt flag clear                                          */
      __OM  uint32_t IC6        : 1;            /*!< [6..6] Pn.6 interrupt flag clear                                          */
      __OM  uint32_t IC7        : 1;            /*!< [7..7] Pn.7 interrupt flag clear                                          */
      __OM  uint32_t IC8        : 1;            /*!< [8..8] Pn.8 interrupt flag clear                                          */
      __OM  uint32_t IC9        : 1;            /*!< [9..9] Pn.9 interrupt flag clear                                          */
      __OM  uint32_t IC10       : 1;            /*!< [10..10] Pn.10 interrupt flag clear                                       */
      __OM  uint32_t IC11       : 1;            /*!< [11..11] Pn.11 interrupt flag clear                                       */
      __OM  uint32_t IC12       : 1;            /*!< [12..12] Pn.12 interrupt flag clear                                       */
      __OM  uint32_t IC13       : 1;            /*!< [13..13] Pn.13 interrupt flag clear                                       */
      __OM  uint32_t IC14       : 1;            /*!< [14..14] Pn.14 interrupt flag clear                                       */
      __OM  uint32_t IC15       : 1;            /*!< [15..15] Pn.15 interrupt flag clear                                       */
            uint32_t            : 16;
    } IC_b;
  } ;
  
  union {
    __OM  uint32_t BSET;                        /*!< (@ 0x00000024) Offset:0x24 GPIO Port n Bits Set Operation Register        */
    
    struct {
      __OM  uint32_t BSET0      : 1;            /*!< [0..0] Set Pn.0                                                           */
      __OM  uint32_t BSET1      : 1;            /*!< [1..1] Set Pn.1                                                           */
      __OM  uint32_t BSET2      : 1;            /*!< [2..2] Set Pn.2                                                           */
      __OM  uint32_t BSET3      : 1;            /*!< [3..3] Set Pn.3                                                           */
      __OM  uint32_t BSET4      : 1;            /*!< [4..4] Set Pn.4                                                           */
      __OM  uint32_t BSET5      : 1;            /*!< [5..5] Set Pn.5                                                           */
      __OM  uint32_t BSET6      : 1;            /*!< [6..6] Set Pn.6                                                           */
      __OM  uint32_t BSET7      : 1;            /*!< [7..7] Set Pn.7                                                           */
      __OM  uint32_t BSET8      : 1;            /*!< [8..8] Set Pn.8                                                           */
      __OM  uint32_t BSET9      : 1;            /*!< [9..9] Set Pn.9                                                           */
      __OM  uint32_t BSET10     : 1;            /*!< [10..10] Set Pn.10                                                        */
      __OM  uint32_t BSET11     : 1;            /*!< [11..11] Set Pn.11                                                        */
      __OM  uint32_t BSET12     : 1;            /*!< [12..12] Set Pn.12                                                        */
      __OM  uint32_t BSET13     : 1;            /*!< [13..13] Set Pn.13                                                        */
      __OM  uint32_t BSET14     : 1;            /*!< [14..14] Set Pn.14                                                        */
      __OM  uint32_t BSET15     : 1;            /*!< [15..15] Set Pn.15                                                        */
            uint32_t            : 16;
    } BSET_b;
  } ;
  
  union {
    __OM  uint32_t BCLR;                        /*!< (@ 0x00000028) Offset:0x28 GPIO Port n Bits Clear Operation
                                                                    Register                                                   */
    
    struct {
      __OM  uint32_t BCLR0      : 1;            /*!< [0..0] Clear Pn.0                                                         */
      __OM  uint32_t BCLR1      : 1;            /*!< [1..1] Clear Pn.1                                                         */
      __OM  uint32_t BCLR2      : 1;            /*!< [2..2] Clear Pn.2                                                         */
      __OM  uint32_t BCLR3      : 1;            /*!< [3..3] Clear Pn.3                                                         */
      __OM  uint32_t BCLR4      : 1;            /*!< [4..4] Clear Pn.4                                                         */
      __OM  uint32_t BCLR5      : 1;            /*!< [5..5] Clear Pn.5                                                         */
      __OM  uint32_t BCLR6      : 1;            /*!< [6..6] Clear Pn.6                                                         */
      __OM  uint32_t BCLR7      : 1;            /*!< [7..7] Clear Pn.7                                                         */
      __OM  uint32_t BCLR8      : 1;            /*!< [8..8] Clear Pn.8                                                         */
      __OM  uint32_t BCLR9      : 1;            /*!< [9..9] Clear Pn.9                                                         */
      __OM  uint32_t BCLR10     : 1;            /*!< [10..10] Clear Pn.10                                                      */
      __OM  uint32_t BCLR11     : 1;            /*!< [11..11] Clear Pn.11                                                      */
      __OM  uint32_t BCLR12     : 1;            /*!< [12..12] Clear Pn.12                                                      */
      __OM  uint32_t BCLR13     : 1;            /*!< [13..13] Clear Pn.13                                                      */
      __OM  uint32_t BCLR14     : 1;            /*!< [14..14] Clear Pn.14                                                      */
      __OM  uint32_t BCLR15     : 1;            /*!< [15..15] Clear Pn.15                                                      */
            uint32_t            : 16;
    } BCLR_b;
  } ;
  
  union {
    __IOM uint32_t ODCTRL;                      /*!< (@ 0x0000002C) Offset:0x2C GPIO Port n Open-drain Control Register        */
    
    struct {
      __IOM uint32_t OC0        : 1;            /*!< [0..0] Pn.0 open-drain control                                            */
      __IOM uint32_t OC1        : 1;            /*!< [1..1] Pn.1 open-drain control                                            */
      __IOM uint32_t OC2        : 1;            /*!< [2..2] Pn.2 open-drain control                                            */
      __IOM uint32_t OC3        : 1;            /*!< [3..3] Pn.3 open-drain control                                            */
      __IOM uint32_t OC4        : 1;            /*!< [4..4] Pn.4 open-drain control                                            */
      __IOM uint32_t OC5        : 1;            /*!< [5..5] Pn.5 open-drain control                                            */
      __IOM uint32_t OC6        : 1;            /*!< [6..6] Pn.6 open-drain control                                            */
      __IOM uint32_t OC7        : 1;            /*!< [7..7] Pn.7 open-drain control                                            */
      __IOM uint32_t OC8        : 1;            /*!< [8..8] Pn.8 open-drain control                                            */
      __IOM uint32_t OC9        : 1;            /*!< [9..9] Pn.9 open-drain control                                            */
      __IOM uint32_t OC10       : 1;            /*!< [10..10] Pn.10 open-drain control                                         */
      __IOM uint32_t OC11       : 1;            /*!< [11..11] Pn.11 open-drain control                                         */
      __IOM uint32_t OC12       : 1;            /*!< [12..12] Pn.12 open-drain control                                         */
      __IOM uint32_t OC13       : 1;            /*!< [13..13] Pn.13 open-drain control                                         */
      __IOM uint32_t OC14       : 1;            /*!< [14..14] Pn.14 open-drain control                                         */
      __IOM uint32_t OC15       : 1;            /*!< [15..15] Pn.15 open-drain control                                         */
            uint32_t            : 16;
    } ODCTRL_b;
  } ;
} SN_GPIO0_Type;                                /*!< Size = 48 (0x30)                                                          */



/* =========================================================================================================================== */
/* ================                                         SN_GPIO2                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief General Purpose I/O (SN_GPIO2)
  */

typedef struct {                                /*!< (@ 0x40048000) SN_GPIO2 Structure                                         */
  
  union {
    __IOM uint32_t DATA;                        /*!< (@ 0x00000000) Offset:0x00 GPIO Port n Data Register                      */
    
    struct {
      __IOM uint32_t DATA0      : 1;            /*!< [0..0] Data of Pn.0                                                       */
      __IOM uint32_t DATA1      : 1;            /*!< [1..1] Data of Pn.1                                                       */
      __IOM uint32_t DATA2      : 1;            /*!< [2..2] Data of Pn.2                                                       */
      __IOM uint32_t DATA3      : 1;            /*!< [3..3] Data of Pn.3                                                       */
      __IOM uint32_t DATA4      : 1;            /*!< [4..4] Data of Pn.4                                                       */
      __IOM uint32_t DATA5      : 1;            /*!< [5..5] Data of Pn.5                                                       */
      __IOM uint32_t DATA6      : 1;            /*!< [6..6] Data of Pn.6                                                       */
      __IOM uint32_t DATA7      : 1;            /*!< [7..7] Data of Pn.7                                                       */
      __IOM uint32_t DATA8      : 1;            /*!< [8..8] Data of Pn.8                                                       */
      __IOM uint32_t DATA9      : 1;            /*!< [9..9] Data of Pn.9                                                       */
      __IOM uint32_t DATA10     : 1;            /*!< [10..10] Data of Pn.10                                                    */
      __IOM uint32_t DATA11     : 1;            /*!< [11..11] Data of Pn.11                                                    */
      __IOM uint32_t DATA12     : 1;            /*!< [12..12] Data of Pn.12                                                    */
      __IOM uint32_t DATA13     : 1;            /*!< [13..13] Data of Pn.13                                                    */
      __IOM uint32_t DATA14     : 1;            /*!< [14..14] Data of Pn.14                                                    */
      __IOM uint32_t DATA15     : 1;            /*!< [15..15] Data of Pn.15                                                    */
            uint32_t            : 16;
    } DATA_b;
  } ;
  
  union {
    __IOM uint32_t MODE;                        /*!< (@ 0x00000004) Offset:0x04 GPIO Port n Mode Register                      */
    
    struct {
      __IOM uint32_t MODE0      : 1;            /*!< [0..0] Mode of Pn.0                                                       */
      __IOM uint32_t MODE1      : 1;            /*!< [1..1] Mode of Pn.1                                                       */
      __IOM uint32_t MODE2      : 1;            /*!< [2..2] Mode of Pn.2                                                       */
      __IOM uint32_t MODE3      : 1;            /*!< [3..3] Mode of Pn.3                                                       */
      __IOM uint32_t MODE4      : 1;            /*!< [4..4] Mode of Pn.4                                                       */
      __IOM uint32_t MODE5      : 1;            /*!< [5..5] Mode of Pn.5                                                       */
      __IOM uint32_t MODE6      : 1;            /*!< [6..6] Mode of Pn.6                                                       */
      __IOM uint32_t MODE7      : 1;            /*!< [7..7] Mode of Pn.7                                                       */
      __IOM uint32_t MODE8      : 1;            /*!< [8..8] Mode of Pn.8                                                       */
      __IOM uint32_t MODE9      : 1;            /*!< [9..9] Mode of Pn.9                                                       */
      __IOM uint32_t MODE10     : 1;            /*!< [10..10] Mode of Pn.10                                                    */
      __IOM uint32_t MODE11     : 1;            /*!< [11..11] Mode of Pn.11                                                    */
      __IOM uint32_t MODE12     : 1;            /*!< [12..12] Mode of Pn.12                                                    */
      __IOM uint32_t MODE13     : 1;            /*!< [13..13] Mode of Pn.13                                                    */
      __IOM uint32_t MODE14     : 1;            /*!< [14..14] Mode of Pn.14                                                    */
      __IOM uint32_t MODE15     : 1;            /*!< [15..15] Mode of Pn.15                                                    */
      __IOM uint32_t CURRENT0   : 1;            /*!< [16..16] Driving/Sinking current of Pn.0                                  */
      __IOM uint32_t CURRENT1   : 1;            /*!< [17..17] Driving/Sinking current of Pn.1                                  */
      __IOM uint32_t CURRENT2   : 1;            /*!< [18..18] Driving/Sinking current of Pn.2                                  */
      __IOM uint32_t CURRENT3   : 1;            /*!< [19..19] Driving/Sinking current of Pn.3                                  */
      __IOM uint32_t CURRENT4   : 1;            /*!< [20..20] Driving/Sinking current of Pn.4                                  */
      __IOM uint32_t CURRENT5   : 1;            /*!< [21..21] Driving/Sinking current of Pn.5                                  */
      __IOM uint32_t CURRENT6   : 1;            /*!< [22..22] Driving/Sinking current of Pn.6                                  */
      __IOM uint32_t CURRENT7   : 1;            /*!< [23..23] Driving/Sinking current of Pn.7                                  */
      __IOM uint32_t CURRENT8   : 1;            /*!< [24..24] Driving/Sinking current of Pn.8                                  */
      __IOM uint32_t CURRENT9   : 1;            /*!< [25..25] Driving/Sinking current of Pn.9                                  */
      __IOM uint32_t CURRENT10  : 1;            /*!< [26..26] Driving/Sinking current of Pn.10                                 */
      __IOM uint32_t CURRENT11  : 1;            /*!< [27..27] Driving/Sinking current of Pn.11                                 */
      __IOM uint32_t CURRENT12  : 1;            /*!< [28..28] Driving/Sinking current of Pn.12                                 */
      __IOM uint32_t CURRENT13  : 1;            /*!< [29..29] Driving/Sinking current of Pn.13                                 */
      __IOM uint32_t CURRENT14  : 1;            /*!< [30..30] Driving/Sinking current of Pn.14                                 */
      __IOM uint32_t CURRENT15  : 1;            /*!< [31..31] Driving/Sinking current of Pn.15                                 */
    } MODE_b;
  } ;
  
  union {
    __IOM uint32_t CFG;                         /*!< (@ 0x00000008) Offset:0x08 GPIO Port n Configuration Register             */
    
    struct {
      __IOM uint32_t CFG0       : 2;            /*!< [1..0] Configuration of Pn.0                                              */
      __IOM uint32_t CFG1       : 2;            /*!< [3..2] Configuration of Pn.1                                              */
      __IOM uint32_t CFG2       : 2;            /*!< [5..4] Configuration of Pn.2                                              */
      __IOM uint32_t CFG3       : 2;            /*!< [7..6] Configuration of Pn.3                                              */
      __IOM uint32_t CFG4       : 2;            /*!< [9..8] Configuration of Pn.4                                              */
      __IOM uint32_t CFG5       : 2;            /*!< [11..10] Configuration of Pn.5                                            */
      __IOM uint32_t CFG6       : 2;            /*!< [13..12] Configuration of Pn.6                                            */
      __IOM uint32_t CFG7       : 2;            /*!< [15..14] Configuration of Pn.7                                            */
      __IOM uint32_t CFG8       : 2;            /*!< [17..16] Configuration of Pn.8                                            */
      __IOM uint32_t CFG9       : 2;            /*!< [19..18] Configuration of Pn.9                                            */
      __IOM uint32_t CFG10      : 2;            /*!< [21..20] Configuration of Pn.10                                           */
      __IOM uint32_t CFG11      : 2;            /*!< [23..22] Configuration of Pn.11                                           */
      __IOM uint32_t CFG12      : 2;            /*!< [25..24] Configuration of Pn.12                                           */
      __IOM uint32_t CFG13      : 2;            /*!< [27..26] Configuration of Pn.13                                           */
      __IOM uint32_t CFG14      : 2;            /*!< [29..28] Configuration of Pn.14                                           */
      __IOM uint32_t CFG15      : 2;            /*!< [31..30] Configuration of Pn.15                                           */
    } CFG_b;
  } ;
  
  union {
    __IOM uint32_t IS;                          /*!< (@ 0x0000000C) Offset:0x0C GPIO Port n Interrupt Sense Register           */
    
    struct {
      __IOM uint32_t IS0        : 1;            /*!< [0..0] Interrupt on Pn.0 is event or edge sensitive                       */
      __IOM uint32_t IS1        : 1;            /*!< [1..1] Interrupt on Pn.1 is event or edge sensitive                       */
      __IOM uint32_t IS2        : 1;            /*!< [2..2] Interrupt on Pn.2 is event or edge sensitive                       */
      __IOM uint32_t IS3        : 1;            /*!< [3..3] Interrupt on Pn.3 is event or edge sensitive                       */
      __IOM uint32_t IS4        : 1;            /*!< [4..4] Interrupt on Pn.4 is event or edge sensitive                       */
      __IOM uint32_t IS5        : 1;            /*!< [5..5] Interrupt on Pn.5 is event or edge sensitive                       */
      __IOM uint32_t IS6        : 1;            /*!< [6..6] Interrupt on Pn.6 is event or edge sensitive                       */
      __IOM uint32_t IS7        : 1;            /*!< [7..7] Interrupt on Pn.7 is event or edge sensitive                       */
      __IOM uint32_t IS8        : 1;            /*!< [8..8] Interrupt on Pn.8 is event or edge sensitive                       */
      __IOM uint32_t IS9        : 1;            /*!< [9..9] Interrupt on Pn.9 is event or edge sensitive                       */
      __IOM uint32_t IS10       : 1;            /*!< [10..10] Interrupt on Pn.10 is event or edge sensitive                    */
      __IOM uint32_t IS11       : 1;            /*!< [11..11] Interrupt on Pn.11 is event or edge sensitive                    */
      __IOM uint32_t IS12       : 1;            /*!< [12..12] Interrupt on Pn.12 is event or edge sensitive                    */
      __IOM uint32_t IS13       : 1;            /*!< [13..13] Interrupt on Pn.13 is event or edge sensitive                    */
      __IOM uint32_t IS14       : 1;            /*!< [14..14] Interrupt on Pn.14 is event or edge sensitive                    */
      __IOM uint32_t IS15       : 1;            /*!< [15..15] Interrupt on Pn.15 is event or edge sensitive                    */
            uint32_t            : 16;
    } IS_b;
  } ;
  
  union {
    __IOM uint32_t IBS;                         /*!< (@ 0x00000010) Offset:0x10 GPIO Port n Interrupt Both-edge Sense
                                                                    Register                                                   */
    
    struct {
      __IOM uint32_t IBS0       : 1;            /*!< [0..0] Interrupt on Pn.0 is triggered ob both edges                       */
      __IOM uint32_t IBS1       : 1;            /*!< [1..1] Interrupt on Pn.1 is triggered ob both edges                       */
      __IOM uint32_t IBS2       : 1;            /*!< [2..2] Interrupt on Pn.2 is triggered ob both edges                       */
      __IOM uint32_t IBS3       : 1;            /*!< [3..3] Interrupt on Pn.3 is triggered ob both edges                       */
      __IOM uint32_t IBS4       : 1;            /*!< [4..4] Interrupt on Pn.4 is triggered ob both edges                       */
      __IOM uint32_t IBS5       : 1;            /*!< [5..5] Interrupt on Pn.5 is triggered ob both edges                       */
      __IOM uint32_t IBS6       : 1;            /*!< [6..6] Interrupt on Pn.6 is triggered ob both edges                       */
      __IOM uint32_t IBS7       : 1;            /*!< [7..7] Interrupt on Pn.7 is triggered ob both edges                       */
      __IOM uint32_t IBS8       : 1;            /*!< [8..8] Interrupt on Pn.8 is triggered ob both edges                       */
      __IOM uint32_t IBS9       : 1;            /*!< [9..9] Interrupt on Pn.9 is triggered ob both edges                       */
      __IOM uint32_t IBS10      : 1;            /*!< [10..10] Interrupt on Pn.10 is triggered ob both edges                    */
      __IOM uint32_t IBS11      : 1;            /*!< [11..11] Interrupt on Pn.11 is triggered ob both edges                    */
      __IOM uint32_t IBS12      : 1;            /*!< [12..12] Interrupt on Pn.12 is triggered ob both edges                    */
      __IOM uint32_t IBS13      : 1;            /*!< [13..13] Interrupt on Pn.13 is triggered ob both edges                    */
      __IOM uint32_t IBS14      : 1;            /*!< [14..14] Interrupt on Pn.14 is triggered ob both edges                    */
      __IOM uint32_t IBS15      : 1;            /*!< [15..15] Interrupt on Pn.15 is triggered ob both edges                    */
            uint32_t            : 16;
    } IBS_b;
  } ;
  
  union {
    __IOM uint32_t IEV;                         /*!< (@ 0x00000014) Offset:0x14 GPIO Port n Interrupt Event Register           */
    
    struct {
      __IOM uint32_t IEV0       : 1;            /*!< [0..0] Interrupt trigged evnet on Pn.0                                    */
      __IOM uint32_t IEV1       : 1;            /*!< [1..1] Interrupt trigged evnet on Pn.1                                    */
      __IOM uint32_t IEV2       : 1;            /*!< [2..2] Interrupt trigged evnet on Pn.2                                    */
      __IOM uint32_t IEV3       : 1;            /*!< [3..3] Interrupt trigged evnet on Pn.3                                    */
      __IOM uint32_t IEV4       : 1;            /*!< [4..4] Interrupt trigged evnet on Pn.4                                    */
      __IOM uint32_t IEV5       : 1;            /*!< [5..5] Interrupt trigged evnet on Pn.5                                    */
      __IOM uint32_t IEV6       : 1;            /*!< [6..6] Interrupt trigged evnet on Pn.6                                    */
      __IOM uint32_t IEV7       : 1;            /*!< [7..7] Interrupt trigged evnet on Pn.7                                    */
      __IOM uint32_t IEV8       : 1;            /*!< [8..8] Interrupt trigged evnet on Pn.8                                    */
      __IOM uint32_t IEV9       : 1;            /*!< [9..9] Interrupt trigged evnet on Pn.9                                    */
      __IOM uint32_t IEV10      : 1;            /*!< [10..10] Interrupt trigged evnet on Pn.10                                 */
      __IOM uint32_t IEV11      : 1;            /*!< [11..11] Interrupt trigged evnet on Pn.11                                 */
      __IOM uint32_t IEV12      : 1;            /*!< [12..12] Interrupt trigged evnet on Pn.12                                 */
      __IOM uint32_t IEV13      : 1;            /*!< [13..13] Interrupt trigged evnet on Pn.13                                 */
      __IOM uint32_t IEV14      : 1;            /*!< [14..14] Interrupt trigged evnet on Pn.14                                 */
      __IOM uint32_t IEV15      : 1;            /*!< [15..15] Interrupt trigged evnet on Pn.15                                 */
            uint32_t            : 16;
    } IEV_b;
  } ;
  
  union {
    __IOM uint32_t IE;                          /*!< (@ 0x00000018) Offset:0x18 GPIO Port n Interrupt Enable Register          */
    
    struct {
      __IOM uint32_t IE0        : 1;            /*!< [0..0] Interrupt on Pn.0 enable                                           */
      __IOM uint32_t IE1        : 1;            /*!< [1..1] Interrupt on Pn.1 enable                                           */
      __IOM uint32_t IE2        : 1;            /*!< [2..2] Interrupt on Pn.2 enable                                           */
      __IOM uint32_t IE3        : 1;            /*!< [3..3] Interrupt on Pn.3 enable                                           */
      __IOM uint32_t IE4        : 1;            /*!< [4..4] Interrupt on Pn.4 enable                                           */
      __IOM uint32_t IE5        : 1;            /*!< [5..5] Interrupt on Pn.5 enable                                           */
      __IOM uint32_t IE6        : 1;            /*!< [6..6] Interrupt on Pn.6 enable                                           */
      __IOM uint32_t IE7        : 1;            /*!< [7..7] Interrupt on Pn.7 enable                                           */
      __IOM uint32_t IE8        : 1;            /*!< [8..8] Interrupt on Pn.8 enable                                           */
      __IOM uint32_t IE9        : 1;            /*!< [9..9] Interrupt on Pn.9 enable                                           */
      __IOM uint32_t IE10       : 1;            /*!< [10..10] Interrupt on Pn.10 enable                                        */
      __IOM uint32_t IE11       : 1;            /*!< [11..11] Interrupt on Pn.11 enable                                        */
      __IOM uint32_t IE12       : 1;            /*!< [12..12] Interrupt on Pn.11 enable                                        */
      __IOM uint32_t IE13       : 1;            /*!< [13..13] Interrupt on Pn.13 enable                                        */
      __IOM uint32_t IE14       : 1;            /*!< [14..14] Interrupt on Pn.14 enable                                        */
      __IOM uint32_t IE15       : 1;            /*!< [15..15] Interrupt on Pn.15 enable                                        */
            uint32_t            : 16;
    } IE_b;
  } ;
  
  union {
    __IM  uint32_t RIS;                         /*!< (@ 0x0000001C) Offset:0x1C GPIO Port n Raw Interrupt Status
                                                                    Register                                                   */
    
    struct {
      __IM  uint32_t IF0        : 1;            /*!< [0..0] Pn.0 raw interrupt flag                                            */
      __IM  uint32_t IF1        : 1;            /*!< [1..1] Pn.1 raw interrupt flag                                            */
      __IM  uint32_t IF2        : 1;            /*!< [2..2] Pn.2 raw interrupt flag                                            */
      __IM  uint32_t IF3        : 1;            /*!< [3..3] Pn.3 raw interrupt flag                                            */
      __IM  uint32_t IF4        : 1;            /*!< [4..4] Pn.4 raw interrupt flag                                            */
      __IM  uint32_t IF5        : 1;            /*!< [5..5] Pn.5 raw interrupt flag                                            */
      __IM  uint32_t IF6        : 1;            /*!< [6..6] Pn.6 raw interrupt flag                                            */
      __IM  uint32_t IF7        : 1;            /*!< [7..7] Pn.7 raw interrupt flag                                            */
      __IM  uint32_t IF8        : 1;            /*!< [8..8] Pn.8 raw interrupt flag                                            */
      __IM  uint32_t IF9        : 1;            /*!< [9..9] Pn.9 raw interrupt flag                                            */
      __IM  uint32_t IF10       : 1;            /*!< [10..10] Pn.10 raw interrupt flag                                         */
      __IM  uint32_t IF11       : 1;            /*!< [11..11] Pn.11 raw interrupt flag                                         */
      __IM  uint32_t IF12       : 1;            /*!< [12..12] Pn.12 raw interrupt flag                                         */
      __IM  uint32_t IF13       : 1;            /*!< [13..13] Pn.13 raw interrupt flag                                         */
      __IM  uint32_t IF14       : 1;            /*!< [14..14] Pn.14 raw interrupt flag                                         */
      __IM  uint32_t IF15       : 1;            /*!< [15..15] Pn.15 raw interrupt flag                                         */
            uint32_t            : 16;
    } RIS_b;
  } ;
  
  union {
    __OM  uint32_t IC;                          /*!< (@ 0x00000020) Offset:0x20 GPIO Port n Interrupt Clear Register           */
    
    struct {
      __OM  uint32_t IC0        : 1;            /*!< [0..0] Pn.0 interrupt flag clear                                          */
      __OM  uint32_t IC1        : 1;            /*!< [1..1] Pn.1 interrupt flag clear                                          */
      __OM  uint32_t IC2        : 1;            /*!< [2..2] Pn.2 interrupt flag clear                                          */
      __OM  uint32_t IC3        : 1;            /*!< [3..3] Pn.3 interrupt flag clear                                          */
      __OM  uint32_t IC4        : 1;            /*!< [4..4] Pn.4 interrupt flag clear                                          */
      __OM  uint32_t IC5        : 1;            /*!< [5..5] Pn.5 interrupt flag clear                                          */
      __OM  uint32_t IC6        : 1;            /*!< [6..6] Pn.6 interrupt flag clear                                          */
      __OM  uint32_t IC7        : 1;            /*!< [7..7] Pn.7 interrupt flag clear                                          */
      __OM  uint32_t IC8        : 1;            /*!< [8..8] Pn.8 interrupt flag clear                                          */
      __OM  uint32_t IC9        : 1;            /*!< [9..9] Pn.9 interrupt flag clear                                          */
      __OM  uint32_t IC10       : 1;            /*!< [10..10] Pn.10 interrupt flag clear                                       */
      __OM  uint32_t IC11       : 1;            /*!< [11..11] Pn.11 interrupt flag clear                                       */
      __OM  uint32_t IC12       : 1;            /*!< [12..12] Pn.12 interrupt flag clear                                       */
      __OM  uint32_t IC13       : 1;            /*!< [13..13] Pn.13 interrupt flag clear                                       */
      __OM  uint32_t IC14       : 1;            /*!< [14..14] Pn.14 interrupt flag clear                                       */
      __OM  uint32_t IC15       : 1;            /*!< [15..15] Pn.15 interrupt flag clear                                       */
            uint32_t            : 16;
    } IC_b;
  } ;
  
  union {
    __OM  uint32_t BSET;                        /*!< (@ 0x00000024) Offset:0x24 GPIO Port n Bits Set Operation Register        */
    
    struct {
      __OM  uint32_t BSET0      : 1;            /*!< [0..0] Set Pn.0                                                           */
      __OM  uint32_t BSET1      : 1;            /*!< [1..1] Set Pn.1                                                           */
      __OM  uint32_t BSET2      : 1;            /*!< [2..2] Set Pn.2                                                           */
      __OM  uint32_t BSET3      : 1;            /*!< [3..3] Set Pn.3                                                           */
      __OM  uint32_t BSET4      : 1;            /*!< [4..4] Set Pn.4                                                           */
      __OM  uint32_t BSET5      : 1;            /*!< [5..5] Set Pn.5                                                           */
      __OM  uint32_t BSET6      : 1;            /*!< [6..6] Set Pn.6                                                           */
      __OM  uint32_t BSET7      : 1;            /*!< [7..7] Set Pn.7                                                           */
      __OM  uint32_t BSET8      : 1;            /*!< [8..8] Set Pn.8                                                           */
      __OM  uint32_t BSET9      : 1;            /*!< [9..9] Set Pn.9                                                           */
      __OM  uint32_t BSET10     : 1;            /*!< [10..10] Set Pn.10                                                        */
      __OM  uint32_t BSET11     : 1;            /*!< [11..11] Set Pn.11                                                        */
      __OM  uint32_t BSET12     : 1;            /*!< [12..12] Set Pn.12                                                        */
      __OM  uint32_t BSET13     : 1;            /*!< [13..13] Set Pn.13                                                        */
      __OM  uint32_t BSET14     : 1;            /*!< [14..14] Set Pn.14                                                        */
      __OM  uint32_t BSET15     : 1;            /*!< [15..15] Set Pn.15                                                        */
            uint32_t            : 16;
    } BSET_b;
  } ;
  
  union {
    __OM  uint32_t BCLR;                        /*!< (@ 0x00000028) Offset:0x28 GPIO Port n Bits Clear Operation
                                                                    Register                                                   */
    
    struct {
      __OM  uint32_t BCLR0      : 1;            /*!< [0..0] Clear Pn.0                                                         */
      __OM  uint32_t BCLR1      : 1;            /*!< [1..1] Clear Pn.1                                                         */
      __OM  uint32_t BCLR2      : 1;            /*!< [2..2] Clear Pn.2                                                         */
      __OM  uint32_t BCLR3      : 1;            /*!< [3..3] Clear Pn.3                                                         */
      __OM  uint32_t BCLR4      : 1;            /*!< [4..4] Clear Pn.4                                                         */
      __OM  uint32_t BCLR5      : 1;            /*!< [5..5] Clear Pn.5                                                         */
      __OM  uint32_t BCLR6      : 1;            /*!< [6..6] Clear Pn.6                                                         */
      __OM  uint32_t BCLR7      : 1;            /*!< [7..7] Clear Pn.7                                                         */
      __OM  uint32_t BCLR8      : 1;            /*!< [8..8] Clear Pn.8                                                         */
      __OM  uint32_t BCLR9      : 1;            /*!< [9..9] Clear Pn.9                                                         */
      __OM  uint32_t BCLR10     : 1;            /*!< [10..10] Clear Pn.10                                                      */
      __OM  uint32_t BCLR11     : 1;            /*!< [11..11] Clear Pn.11                                                      */
      __OM  uint32_t BCLR12     : 1;            /*!< [12..12] Clear Pn.12                                                      */
      __OM  uint32_t BCLR13     : 1;            /*!< [13..13] Clear Pn.13                                                      */
      __OM  uint32_t BCLR14     : 1;            /*!< [14..14] Clear Pn.14                                                      */
      __OM  uint32_t BCLR15     : 1;            /*!< [15..15] Clear Pn.15                                                      */
            uint32_t            : 16;
    } BCLR_b;
  } ;
  
  union {
    __IOM uint32_t ODCTRL;                      /*!< (@ 0x0000002C) Offset:0x2C GPIO Port n Open-drain Control Register        */
    
    struct {
      __IOM uint32_t OC0        : 1;            /*!< [0..0] Pn.0 open-drain control                                            */
      __IOM uint32_t OC1        : 1;            /*!< [1..1] Pn.1 open-drain control                                            */
      __IOM uint32_t OC2        : 1;            /*!< [2..2] Pn.2 open-drain control                                            */
      __IOM uint32_t OC3        : 1;            /*!< [3..3] Pn.3 open-drain control                                            */
      __IOM uint32_t OC4        : 1;            /*!< [4..4] Pn.4 open-drain control                                            */
      __IOM uint32_t OC5        : 1;            /*!< [5..5] Pn.5 open-drain control                                            */
      __IOM uint32_t OC6        : 1;            /*!< [6..6] Pn.6 open-drain control                                            */
      __IOM uint32_t OC7        : 1;            /*!< [7..7] Pn.7 open-drain control                                            */
      __IOM uint32_t OC8        : 1;            /*!< [8..8] Pn.8 open-drain control                                            */
      __IOM uint32_t OC9        : 1;            /*!< [9..9] Pn.9 open-drain control                                            */
      __IOM uint32_t OC10       : 1;            /*!< [10..10] Pn.10 open-drain control                                         */
      __IOM uint32_t OC11       : 1;            /*!< [11..11] Pn.11 open-drain control                                         */
      __IOM uint32_t OC12       : 1;            /*!< [12..12] Pn.12 open-drain control                                         */
      __IOM uint32_t OC13       : 1;            /*!< [13..13] Pn.13 open-drain control                                         */
      __IOM uint32_t OC14       : 1;            /*!< [14..14] Pn.14 open-drain control                                         */
      __IOM uint32_t OC15       : 1;            /*!< [15..15] Pn.15 open-drain control                                         */
            uint32_t            : 16;
    } ODCTRL_b;
  } ;
} SN_GPIO2_Type;                                /*!< Size = 48 (0x30)                                                          */



/* =========================================================================================================================== */
/* ================                                          SN_ADC                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief ADC (SN_ADC)
  */

typedef struct {                                /*!< (@ 0x40026000) SN_ADC Structure                                           */
  
  union {
    __IOM uint32_t ADM;                         /*!< (@ 0x00000000) Offset:0x00 ADC Management Register                        */
    
    struct {
      __IOM uint32_t CHS        : 4;            /*!< [3..0] ADC input channel                                                  */
      __IOM uint32_t GCHS       : 1;            /*!< [4..4] ADC global channel enable                                          */
      __IOM uint32_t EOC        : 1;            /*!< [5..5] ADC status                                                         */
      __IOM uint32_t ADS        : 1;            /*!< [6..6] ADC start control                                                  */
      __IOM uint32_t ADLEN      : 1;            /*!< [7..7] ADC resolution                                                     */
      __IOM uint32_t ADCKS      : 3;            /*!< [10..8] ADC clock source divider                                          */
      __IOM uint32_t ADENB      : 1;            /*!< [11..11] ADC enable                                                       */
      __IOM uint32_t AVREFHSEL  : 1;            /*!< [12..12] ADC high reference voltage source                                */
            uint32_t            : 4;
      __IOM uint32_t TSENB      : 1;            /*!< [17..17] Temperature sensor enable bit                                    */
            uint32_t            : 14;
    } ADM_b;
  } ;
  __IM  uint32_t  ADB;                          /*!< (@ 0x00000004) Offset:0x04 ADC Data Register                              */
  
  union {
    __IM  uint32_t P2CON;                       /*!< (@ 0x00000008) Offset:0x08 ADC Port 2 Control Register                    */
    
    struct {
      __IM  uint32_t P2CON0     : 1;            /*!< [0..0] P2.0 Control                                                       */
      __IM  uint32_t P2CON1     : 1;            /*!< [1..1] P2.1 Control                                                       */
      __IM  uint32_t P2CON2     : 1;            /*!< [2..2] P2.2 Control                                                       */
      __IM  uint32_t P2CON3     : 1;            /*!< [3..3] P2.3 Control                                                       */
      __IM  uint32_t P2CON4     : 1;            /*!< [4..4] P2.4 Control                                                       */
      __IM  uint32_t P2CON5     : 1;            /*!< [5..5] P2.5 Control                                                       */
      __IM  uint32_t P2CON6     : 1;            /*!< [6..6] P2.6 Control                                                       */
      __IM  uint32_t P2CON7     : 1;            /*!< [7..7] P2.7 Control                                                       */
      __IM  uint32_t P2CON8     : 1;            /*!< [8..8] P2.8 Control                                                       */
      __IM  uint32_t P2CON9     : 1;            /*!< [9..9] P2.9 Control                                                       */
      __IM  uint32_t P2CON10    : 1;            /*!< [10..10] P2.10 Control                                                    */
      __IM  uint32_t P2CON11    : 1;            /*!< [11..11] P2.11 Control                                                    */
      __IM  uint32_t P2CON12    : 1;            /*!< [12..12] P2.12 Control                                                    */
      __IM  uint32_t P2CON13    : 1;            /*!< [13..13] P2.13 Control                                                    */
      __IM  uint32_t P2CON14    : 1;            /*!< [14..14] P2.14 Control                                                    */
      __IM  uint32_t P2CON15    : 1;            /*!< [15..15] P2.15 Control                                                    */
            uint32_t            : 16;
    } P2CON_b;
  } ;
  
  union {
    __IOM uint32_t IE;                          /*!< (@ 0x0000000C) Offset:0x0C ADC Interrupt Enable Register                  */
    
    struct {
      __IOM uint32_t IE0        : 1;            /*!< [0..0] AIN0 interrupt enable                                              */
      __IOM uint32_t IE1        : 1;            /*!< [1..1] AIN1 interrupt enable                                              */
      __IOM uint32_t IE2        : 1;            /*!< [2..2] AIN2 interrupt enable                                              */
      __IOM uint32_t IE3        : 1;            /*!< [3..3] AIN3 interrupt enable                                              */
      __IOM uint32_t IE4        : 1;            /*!< [4..4] AIN4 interrupt enable                                              */
      __IOM uint32_t IE5        : 1;            /*!< [5..5] AIN5 interrupt enable                                              */
      __IOM uint32_t IE6        : 1;            /*!< [6..6] AIN6 interrupt enable                                              */
      __IOM uint32_t IE7        : 1;            /*!< [7..7] AIN7 interrupt enable                                              */
      __IOM uint32_t IE8        : 1;            /*!< [8..8] AIN8 interrupt enable                                              */
      __IOM uint32_t IE9        : 1;            /*!< [9..9] AIN9 interrupt enable                                              */
      __IOM uint32_t IE10       : 1;            /*!< [10..10] AIN10 interrupt enable                                           */
      __IOM uint32_t IE11       : 1;            /*!< [11..11] AIN11 interrupt enable                                           */
      __IOM uint32_t IE12       : 1;            /*!< [12..12] AIN12 interrupt enable                                           */
      __IOM uint32_t IE13       : 1;            /*!< [13..13] AIN13 interrupt enable                                           */
      __IOM uint32_t IE14       : 1;            /*!< [14..14] AIN14 interrupt enable                                           */
            uint32_t            : 17;
    } IE_b;
  } ;
  
  union {
    __IOM uint32_t RIS;                         /*!< (@ 0x00000010) Offset:0x10 ADC Raw Interrupt Status Register              */
    
    struct {
      __IOM uint32_t IF0        : 1;            /*!< [0..0] AIN0 interrupt flag                                                */
      __IOM uint32_t IF1        : 1;            /*!< [1..1] AIN1 interrupt flag                                                */
      __IOM uint32_t IF2        : 1;            /*!< [2..2] AIN2 interrupt flag                                                */
      __IOM uint32_t IF3        : 1;            /*!< [3..3] AIN0 interrupt flag                                                */
      __IOM uint32_t IF4        : 1;            /*!< [4..4] AIN4 interrupt flag                                                */
      __IOM uint32_t IF5        : 1;            /*!< [5..5] AIN5 interrupt flag                                                */
      __IOM uint32_t IF6        : 1;            /*!< [6..6] AIN6 interrupt flag                                                */
      __IOM uint32_t IF7        : 1;            /*!< [7..7] AIN7 interrupt flag                                                */
      __IOM uint32_t IF8        : 1;            /*!< [8..8] AIN8 interrupt flag                                                */
      __IOM uint32_t IF9        : 1;            /*!< [9..9] AIN9 interrupt flag                                                */
      __IOM uint32_t IF10       : 1;            /*!< [10..10] AIN10 interrupt flag                                             */
      __IOM uint32_t IF11       : 1;            /*!< [11..11] AIN11 interrupt flag                                             */
      __IOM uint32_t IF12       : 1;            /*!< [12..12] AIN12 interrupt flag                                             */
      __IOM uint32_t IF13       : 1;            /*!< [13..13] AIN13 interrupt flag                                             */
      __IOM uint32_t IF14       : 1;            /*!< [14..14] AIN14 interrupt flag                                             */
            uint32_t            : 17;
    } RIS_b;
  } ;
} SN_ADC_Type;                                  /*!< Size = 20 (0x14)                                                          */



/* =========================================================================================================================== */
/* ================                                          SN_WDT                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief Watchdog Timer (SN_WDT)
  */

typedef struct {                                /*!< (@ 0x40010000) SN_WDT Structure                                           */
  
  union {
    __IOM uint32_t CFG;                         /*!< (@ 0x00000000) Offset:0x00 WDT Configuration Register                     */
    
    struct {
      __IOM uint32_t WDTEN      : 1;            /*!< [0..0] WDT enable                                                         */
      __IOM uint32_t WDTIE      : 1;            /*!< [1..1] WDT interrupt enable                                               */
      __IOM uint32_t WDTINT     : 1;            /*!< [2..2] WDT interrupt flag                                                 */
            uint32_t            : 13;
      __OM  uint32_t WDKEY      : 16;           /*!< [31..16] WDT register key                                                 */
    } CFG_b;
  } ;
  
  union {
    __IOM uint32_t CLKSOURCE;                   /*!< (@ 0x00000004) Offset:0x04 WDT Clock Source Register                      */
    
    struct {
      __IOM uint32_t CLKSEL     : 2;            /*!< [1..0] WDT clock source                                                   */
            uint32_t            : 14;
      __OM  uint32_t WDKEY      : 16;           /*!< [31..16] WDT register key                                                 */
    } CLKSOURCE_b;
  } ;
  
  union {
    __IOM uint32_t TC;                          /*!< (@ 0x00000008) Offset:0x08 WDT Timer Constant Register                    */
    
    struct {
      __IOM uint32_t TC         : 8;            /*!< [7..0] Watchdog timer constant reload value                               */
            uint32_t            : 8;
      __OM  uint32_t WDKEY      : 16;           /*!< [31..16] WDT register key                                                 */
    } TC_b;
  } ;
  
  union {
    __OM  uint32_t FEED;                        /*!< (@ 0x0000000C) Offset:0x0C WDT Feed Register                              */
    
    struct {
      __OM  uint32_t FV         : 16;           /*!< [15..0] Watchdog feed value                                               */
      __OM  uint32_t WDKEY      : 16;           /*!< [31..16] WDT register key                                                 */
    } FEED_b;
  } ;
} SN_WDT_Type;                                  /*!< Size = 16 (0x10)                                                          */



/* =========================================================================================================================== */
/* ================                                          SN_RTC                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief Real-time Clock (SN_RTC)
  */

typedef struct {                                /*!< (@ 0x40012000) SN_RTC Structure                                           */
  
  union {
    __IOM uint32_t CTRL;                        /*!< (@ 0x00000000) Offset:0x00 RTC Control Register                           */
    
    struct {
      __IOM uint32_t RTCEN      : 1;            /*!< [0..0] RTC enable                                                         */
            uint32_t            : 31;
    } CTRL_b;
  } ;
  
  union {
    __IOM uint32_t CLKS;                        /*!< (@ 0x00000004) Offset:0x04 RTC Clock Source Register                      */
    
    struct {
      __IOM uint32_t CLKSEL     : 2;            /*!< [1..0] RTC clock source                                                   */
            uint32_t            : 30;
    } CLKS_b;
  } ;
  
  union {
    __IOM uint32_t IE;                          /*!< (@ 0x00000008) Offset:0x08 RTC Interrupt Enable Register                  */
    
    struct {
      __IOM uint32_t SECIE      : 1;            /*!< [0..0] Second interrupt enable                                            */
      __IOM uint32_t ALMIE      : 1;            /*!< [1..1] Alarm interrupt enable                                             */
      __IOM uint32_t OVFIE      : 1;            /*!< [2..2] Overflow interrupt enable                                          */
            uint32_t            : 29;
    } IE_b;
  } ;
  
  union {
    __IM  uint32_t RIS;                         /*!< (@ 0x0000000C) Offset:0x0C RTC Raw Interrupt Status Register              */
    
    struct {
      __IM  uint32_t SECIF      : 1;            /*!< [0..0] Second interrupt flag                                              */
      __IM  uint32_t ALMIF      : 1;            /*!< [1..1] Alarm interrupt flag                                               */
      __IM  uint32_t OVFIF      : 1;            /*!< [2..2] Overflow interrupt flag                                            */
            uint32_t            : 29;
    } RIS_b;
  } ;
  
  union {
    __OM  uint32_t IC;                          /*!< (@ 0x00000010) Offset:0x10 RTC Interrupt Clear Register                   */
    
    struct {
      __OM  uint32_t SECIC      : 1;            /*!< [0..0] Second interrupt flag clear                                        */
      __OM  uint32_t ALMIC      : 1;            /*!< [1..1] Alarm interrupt flag clear                                         */
      __OM  uint32_t OVFIC      : 1;            /*!< [2..2] Overflow interrupt flag clear                                      */
            uint32_t            : 29;
    } IC_b;
  } ;
  __IOM uint32_t  SECCNTV;                      /*!< (@ 0x00000014) Offset:0x14 RTC Second Counter Reload Value Register       */
  __IM  uint32_t  SECCNT;                       /*!< (@ 0x00000018) Offset:0x18 RTC Second Counter Register                    */
  __IOM uint32_t  ALMCNTV;                      /*!< (@ 0x0000001C) Offset:0x1C RTC Alarm Counter Reload Value Register        */
  __IM  uint32_t  ALMCNT;                       /*!< (@ 0x00000020) Offset:0x20 RTC Alarm Counter Register                     */
} SN_RTC_Type;                                  /*!< Size = 36 (0x24)                                                          */



/* =========================================================================================================================== */
/* ================                                         SN_CT16B0                                         ================ */
/* =========================================================================================================================== */


/**
  * @brief 16-bit Timer 0 with Capture function (SN_CT16B0)
  */

typedef struct {                                /*!< (@ 0x40000000) SN_CT16B0 Structure                                        */
  
  union {
    __IOM uint32_t TMRCTRL;                     /*!< (@ 0x00000000) Offset:0x00 CT16Bn Timer Control Register                  */
    
    struct {
      __IOM uint32_t CEN        : 1;            /*!< [0..0] Counter enable                                                     */
      __IOM uint32_t CRST       : 1;            /*!< [1..1] Counter Reset                                                      */
            uint32_t            : 2;
      __IOM uint32_t CM         : 3;            /*!< [6..4] Counting Mode                                                      */
            uint32_t            : 25;
    } TMRCTRL_b;
  } ;
  
  union {
    __IOM uint32_t TC;                          /*!< (@ 0x00000004) Offset:0x04 CT16Bn Timer Counter Register                  */
    
    struct {
      __IOM uint32_t TC         : 16;           /*!< [15..0] Timer Counter                                                     */
            uint32_t            : 16;
    } TC_b;
  } ;
  
  union {
    __IOM uint32_t PRE;                         /*!< (@ 0x00000008) Offset:0x08 CT16Bn Prescale Register                       */
    
    struct {
      __IOM uint32_t PRE        : 16;           /*!< [15..0] Prescaler                                                         */
            uint32_t            : 16;
    } PRE_b;
  } ;
  
  union {
    __IOM uint32_t PC;                          /*!< (@ 0x0000000C) Offset:0x0C CT16Bn Prescale Counter Register               */
    
    struct {
      __IOM uint32_t PC         : 16;           /*!< [15..0] Prescaler Counter                                                 */
            uint32_t            : 16;
    } PC_b;
  } ;
  
  union {
    __IOM uint32_t CNTCTRL;                     /*!< (@ 0x00000010) Offset:0x10 CT16Bn Counter Control Register                */
    
    struct {
      __IOM uint32_t CTM        : 2;            /*!< [1..0] Counter/Timer Mode                                                 */
      __IOM uint32_t CIS        : 2;            /*!< [3..2] Counter Input Select                                               */
            uint32_t            : 28;
    } CNTCTRL_b;
  } ;
  
  union {
    __IOM uint32_t MCTRL;                       /*!< (@ 0x00000014) Offset:0x14 CT16Bn Match Control Register                  */
    
    struct {
      __IOM uint32_t MR0IE      : 1;            /*!< [0..0] Enable generating an interrupt when MR0 matches TC                 */
      __IOM uint32_t MR0RST     : 1;            /*!< [1..1] Enable reset TC when MR0 matches TC                                */
      __IOM uint32_t MR0STOP    : 1;            /*!< [2..2] Stop TC and PC and clear CEN bit when MR0 matches TC               */
      __IOM uint32_t MR1IE      : 1;            /*!< [3..3] Enable generating an interrupt when MR1 matches TC                 */
      __IOM uint32_t MR1RST     : 1;            /*!< [4..4] Enable reset TC when MR1 matches TC                                */
      __IOM uint32_t MR1STOP    : 1;            /*!< [5..5] Stop TC and PC and clear CEN bit when MR1 matches TC               */
      __IOM uint32_t MR2IE      : 1;            /*!< [6..6] Enable generating an interrupt when MR2 matches TC                 */
      __IOM uint32_t MR2RST     : 1;            /*!< [7..7] Enable reset TC when MR2 matches TC                                */
      __IOM uint32_t MR2STOP    : 1;            /*!< [8..8] Stop TC and PC and clear CEN bit when MR2 matches TC               */
      __IOM uint32_t MR3IE      : 1;            /*!< [9..9] Enable generating an interrupt when MR3 matches TC                 */
      __IOM uint32_t MR3RST     : 1;            /*!< [10..10] Enable reset TC when MR3 matches TC                              */
      __IOM uint32_t MR3STOP    : 1;            /*!< [11..11] Stop TC and PC and clear CEN bit when MR3 matches TC             */
            uint32_t            : 20;
    } MCTRL_b;
  } ;
  __IOM uint32_t  MR0;                          /*!< (@ 0x00000018) Offset:0x18 CT16Bn MR0 Register                            */
  __IOM uint32_t  MR1;                          /*!< (@ 0x0000001C) Offset:0x1C CT16Bn MR1 Register                            */
  __IOM uint32_t  MR2;                          /*!< (@ 0x00000020) Offset:0x20 CT16Bn MR2 Register                            */
  __IOM uint32_t  MR3;                          /*!< (@ 0x00000024) Offset:0x24 CT16Bn MR3 Register                            */
  
  union {
    __IOM uint32_t CAPCTRL;                     /*!< (@ 0x00000028) Offset:0x28 CT16Bn Capture Control Register                */
    
    struct {
      __IOM uint32_t CAP0RE     : 1;            /*!< [0..0] Capture on CT16Bn_CAP0 rising edge                                 */
      __IOM uint32_t CAP0FE     : 1;            /*!< [1..1] Capture on CT16Bn_CAP0 falling edge                                */
      __IOM uint32_t CAP0IE     : 1;            /*!< [2..2] Interrupt on CT16Bn_CAP0 event                                     */
      __IOM uint32_t CAP0EN     : 1;            /*!< [3..3] CAP0 function enable                                               */
            uint32_t            : 28;
    } CAPCTRL_b;
  } ;
  
  union {
    __IM  uint32_t CAP0;                        /*!< (@ 0x0000002C) Offset:0x2C CT16Bn CAP0 Register                           */
    
    struct {
      __IM  uint32_t CAP0       : 16;           /*!< [15..0] Timer counter capture value                                       */
            uint32_t            : 16;
    } CAP0_b;
  } ;
  
  union {
    __IOM uint32_t EM;                          /*!< (@ 0x00000030) Offset:0x30 CT16Bn External Match Register                 */
    
    struct {
      __IOM uint32_t EM0        : 1;            /*!< [0..0] When the TC matches MR0, this bit will act according
                                                     to EMC0[1:0], and also drive the state of CT16Bn_PWM0 output.             */
      __IOM uint32_t EM1        : 1;            /*!< [1..1] When the TC matches MR1, this bit will act according
                                                     to EMC1[1:0], and also drive the state of CT16Bn_PWM1 output.             */
      __IOM uint32_t EM2        : 1;            /*!< [2..2] When the TC matches MR2, this bit will act according
                                                     to EMC2[1:0], and also drive the state of CT16Bn_PWM2 output.             */
            uint32_t            : 1;
      __IOM uint32_t EMC0       : 2;            /*!< [5..4] CT16Bn_PWM0 functionality                                          */
      __IOM uint32_t EMC1       : 2;            /*!< [7..6] CT16Bn_PWM1 functionality                                          */
      __IOM uint32_t EMC2       : 2;            /*!< [9..8] CT16Bn_PWM2 functionality                                          */
            uint32_t            : 22;
    } EM_b;
  } ;
  
  union {
    __IOM uint32_t PWMCTRL;                     /*!< (@ 0x00000034) Offset:0x34 CT16Bn PWM Control Register                    */
    
    struct {
      __IOM uint32_t PWM0EN     : 1;            /*!< [0..0] PWM0 enable                                                        */
      __IOM uint32_t PWM1EN     : 1;            /*!< [1..1] PWM1 enable                                                        */
      __IOM uint32_t PWM2EN     : 1;            /*!< [2..2] PWM2 enable                                                        */
            uint32_t            : 1;
      __IOM uint32_t PWM0M0DE   : 2;            /*!< [5..4] PWM0 output mode                                                   */
      __IOM uint32_t PWM1M0DE   : 2;            /*!< [7..6] PWM1 output mode                                                   */
      __IOM uint32_t PWM2M0DE   : 2;            /*!< [9..8] PWM2 output mode                                                   */
            uint32_t            : 10;
      __IOM uint32_t PWM0IOEN   : 1;            /*!< [20..20] CT16Bn_PWM0/GPIO selection                                       */
      __IOM uint32_t PWM1IOEN   : 1;            /*!< [21..21] CT16Bn_PWM1/GPIO selection                                       */
      __IOM uint32_t PWM2IOEN   : 1;            /*!< [22..22] CT16Bn_PWM2/GPIO selection                                       */
            uint32_t            : 9;
    } PWMCTRL_b;
  } ;
  
  union {
    __IM  uint32_t RIS;                         /*!< (@ 0x00000038) Offset:0x38 CT16Bn Raw Interrupt Status Register           */
    
    struct {
      __IM  uint32_t MR0IF      : 1;            /*!< [0..0] Match channel 0 interrupt flag                                     */
      __IM  uint32_t MR1IF      : 1;            /*!< [1..1] Match channel 1 interrupt flag                                     */
      __IM  uint32_t MR2IF      : 1;            /*!< [2..2] Match channel 2 interrupt flag                                     */
      __IM  uint32_t MR3IF      : 1;            /*!< [3..3] Match channel 3 interrupt flag                                     */
      __IM  uint32_t CAP0IF     : 1;            /*!< [4..4] Capture channel 0 interrupt flag                                   */
            uint32_t            : 27;
    } RIS_b;
  } ;
  
  union {
    __OM  uint32_t IC;                          /*!< (@ 0x0000003C) Offset:0x3C CT16Bn Interrupt Clear Register                */
    
    struct {
      __OM  uint32_t MR0IC      : 1;            /*!< [0..0] MR0IF clear bit                                                    */
      __OM  uint32_t MR1IC      : 1;            /*!< [1..1] MR1IF clear bit                                                    */
      __OM  uint32_t MR2IC      : 1;            /*!< [2..2] MR2IF clear bit                                                    */
      __OM  uint32_t MR3IC      : 1;            /*!< [3..3] MR3IF clear bit                                                    */
      __OM  uint32_t CAP0IC     : 1;            /*!< [4..4] CAP0IF clear bit                                                   */
            uint32_t            : 27;
    } IC_b;
  } ;
} SN_CT16B0_Type;                               /*!< Size = 64 (0x40)                                                          */



/* =========================================================================================================================== */
/* ================                                         SN_CT32B0                                         ================ */
/* =========================================================================================================================== */


/**
  * @brief 32-bit Timer 0 with Capture function (SN_CT32B0)
  */

typedef struct {                                /*!< (@ 0x40006000) SN_CT32B0 Structure                                        */
  
  union {
    __IOM uint32_t TMRCTRL;                     /*!< (@ 0x00000000) Offset:0x00 CT32Bn Timer Control Register                  */
    
    struct {
      __IOM uint32_t CEN        : 1;            /*!< [0..0] Counter Enable                                                     */
      __IOM uint32_t CRST       : 1;            /*!< [1..1] Counter Reset                                                      */
            uint32_t            : 2;
      __IOM uint32_t CM         : 3;            /*!< [6..4] Counting Mode                                                      */
            uint32_t            : 25;
    } TMRCTRL_b;
  } ;
  __IOM uint32_t  TC;                           /*!< (@ 0x00000004) Offset:0x04 CT32Bn Timer Counter Register                  */
  __IOM uint32_t  PRE;                          /*!< (@ 0x00000008) Offset:0x08 CT32Bn Prescale Register                       */
  __IOM uint32_t  PC;                           /*!< (@ 0x0000000C) Offset:0x0C CT32Bn Prescale Counter Register               */
  
  union {
    __IOM uint32_t CNTCTRL;                     /*!< (@ 0x00000010) Offset:0x10 CT32Bn Counter Control Register                */
    
    struct {
      __IOM uint32_t CTM        : 2;            /*!< [1..0] Counter/Timer Mode                                                 */
      __IOM uint32_t CIS        : 2;            /*!< [3..2] Counter Input Select                                               */
            uint32_t            : 28;
    } CNTCTRL_b;
  } ;
  
  union {
    __IOM uint32_t MCTRL;                       /*!< (@ 0x00000014) Offset:0x14 CT32Bn Match Control Register                  */
    
    struct {
      __IOM uint32_t MR0IE      : 1;            /*!< [0..0] Enable generating an interrupt when MR0 matches TC                 */
      __IOM uint32_t MR0RST     : 1;            /*!< [1..1] Enable reset TC when MR0 matches TC                                */
      __IOM uint32_t MR0STOP    : 1;            /*!< [2..2] Stop TC and PC and clear CEN bit when MR0 matches TC               */
      __IOM uint32_t MR1IE      : 1;            /*!< [3..3] Enable generating an interrupt when MR1 matches TC                 */
      __IOM uint32_t MR1RST     : 1;            /*!< [4..4] Enable reset TC when MR1 matches TC                                */
      __IOM uint32_t MR1STOP    : 1;            /*!< [5..5] Stop TC and PC and clear CEN bit when MR1 matches TC               */
      __IOM uint32_t MR2IE      : 1;            /*!< [6..6] Enable generating an interrupt when MR2 matches TC                 */
      __IOM uint32_t MR2RST     : 1;            /*!< [7..7] Enable reset TC when MR2 matches TC                                */
      __IOM uint32_t MR2STOP    : 1;            /*!< [8..8] Stop TC and PC and clear CEN bit when MR2 matches TC               */
      __IOM uint32_t MR3IE      : 1;            /*!< [9..9] Enable generating an interrupt when MR3 matches TC                 */
      __IOM uint32_t MR3RST     : 1;            /*!< [10..10] Enable reset TC when MR3 matches TC                              */
      __IOM uint32_t MR3STOP    : 1;            /*!< [11..11] Stop TC and PC and clear CEN bit when MR3 matches TC             */
            uint32_t            : 20;
    } MCTRL_b;
  } ;
  __IOM uint32_t  MR0;                          /*!< (@ 0x00000018) Offset:0x18 CT32Bn MR0 Register                            */
  __IOM uint32_t  MR1;                          /*!< (@ 0x0000001C) Offset:0x1C CT32Bn MR1 Register                            */
  __IOM uint32_t  MR2;                          /*!< (@ 0x00000020) Offset:0x20 CT32Bn MR2 Register                            */
  __IOM uint32_t  MR3;                          /*!< (@ 0x00000024) Offset:0x24 CT32Bn MR3 Register                            */
  
  union {
    __IOM uint32_t CAPCTRL;                     /*!< (@ 0x00000028) Offset:0x28 CT32Bn Capture Control Register                */
    
    struct {
      __IOM uint32_t CAP0RE     : 1;            /*!< [0..0] Capture on CT32Bn_CAP0 rising edge                                 */
      __IOM uint32_t CAP0FE     : 1;            /*!< [1..1] Capture on CT32Bn_CAP0 falling edge                                */
      __IOM uint32_t CAP0IE     : 1;            /*!< [2..2] Interrupt on CT32Bn_CAP0 event                                     */
      __IOM uint32_t CAP0EN     : 1;            /*!< [3..3] CAP0 function enable                                               */
            uint32_t            : 28;
    } CAPCTRL_b;
  } ;
  __IM  uint32_t  CAP0;                         /*!< (@ 0x0000002C) Offset:0x2C CT32Bn CAP0 Register                           */
  
  union {
    __IOM uint32_t EM;                          /*!< (@ 0x00000030) Offset:0x30 CT32Bn External Match Register                 */
    
    struct {
      __IOM uint32_t EM0        : 1;            /*!< [0..0] When the TC matches MR0, this bit will act according
                                                     to EMC0[1:0], and also drive the state of CT32Bn_PWM0 output.             */
      __IOM uint32_t EM1        : 1;            /*!< [1..1] When the TC matches MR1, this bit will act according
                                                     to EMC1[1:0], and also drive the state of CT32Bn_PWM1 output.             */
      __IOM uint32_t EM2        : 1;            /*!< [2..2] When the TC matches MR2, this bit will act according
                                                     to EMC2[1:0], and also drive the state of CT32Bn_PWM2 output.             */
      __IOM uint32_t EM3        : 1;            /*!< [3..3] When the TC matches MR3, this bit will act according
                                                     to EMC3[1:0], and also drive the state of CT32Bn_PWM3 output.             */
      __IOM uint32_t EMC0       : 2;            /*!< [5..4] CT32Bn_PWM0 functionality                                          */
      __IOM uint32_t EMC1       : 2;            /*!< [7..6] CT32Bn_PWM1 functionality                                          */
      __IOM uint32_t EMC2       : 2;            /*!< [9..8] CT32Bn_PWM2 functionality                                          */
      __IOM uint32_t EMC3       : 2;            /*!< [11..10] CT32Bn_PWM3 functionality                                        */
            uint32_t            : 20;
    } EM_b;
  } ;
  
  union {
    __IOM uint32_t PWMCTRL;                     /*!< (@ 0x00000034) Offset:0x34 CT32Bn PWM Control Register                    */
    
    struct {
      __IOM uint32_t PWM0EN     : 1;            /*!< [0..0] PWM0 enable                                                        */
      __IOM uint32_t PWM1EN     : 1;            /*!< [1..1] PWM1 enable                                                        */
      __IOM uint32_t PWM2EN     : 1;            /*!< [2..2] PWM2 enable                                                        */
      __IOM uint32_t PWM3EN     : 1;            /*!< [3..3] PWM3 enable                                                        */
      __IOM uint32_t PWM0M0DE   : 2;            /*!< [5..4] PWM0 output mode                                                   */
      __IOM uint32_t PWM1M0DE   : 2;            /*!< [7..6] PWM1 output mode                                                   */
      __IOM uint32_t PWM2M0DE   : 2;            /*!< [9..8] PWM2 output mode                                                   */
      __IOM uint32_t PWM3M0DE   : 2;            /*!< [11..10] PWM3 output mode                                                 */
            uint32_t            : 8;
      __IOM uint32_t PWM0IOEN   : 1;            /*!< [20..20] CT32Bn_PWM0/GPIO selection                                       */
      __IOM uint32_t PWM1IOEN   : 1;            /*!< [21..21] CT16Bn_PWM1/GPIO selection                                       */
      __IOM uint32_t PWM2IOEN   : 1;            /*!< [22..22] CT32Bn_PWM2/GPIO selection                                       */
      __IOM uint32_t PWM3IOEN   : 1;            /*!< [23..23] CT32Bn_PWM3/GPIO selection                                       */
            uint32_t            : 8;
    } PWMCTRL_b;
  } ;
  
  union {
    __IM  uint32_t RIS;                         /*!< (@ 0x00000038) Offset:0x38 CT32Bn Raw Interrupt Status Register           */
    
    struct {
      __IM  uint32_t MR0IF      : 1;            /*!< [0..0] Match channel 0 interrupt flag                                     */
      __IM  uint32_t MR1IF      : 1;            /*!< [1..1] Match channel 1 interrupt flag                                     */
      __IM  uint32_t MR2IF      : 1;            /*!< [2..2] Match channel 2 interrupt flag                                     */
      __IM  uint32_t MR3IF      : 1;            /*!< [3..3] Match channel 3 interrupt flag                                     */
      __IM  uint32_t CAP0IF     : 1;            /*!< [4..4] Capture channel 0 interrupt flag                                   */
            uint32_t            : 27;
    } RIS_b;
  } ;
  
  union {
    __OM  uint32_t IC;                          /*!< (@ 0x0000003C) Offset:0x3C CT32Bn Interrupt Clear Register                */
    
    struct {
      __OM  uint32_t MR0IC      : 1;            /*!< [0..0] MR0IF clear bit                                                    */
      __OM  uint32_t MR1IC      : 1;            /*!< [1..1] MR1IF clear bit                                                    */
      __OM  uint32_t MR2IC      : 1;            /*!< [2..2] MR2IF clear bit                                                    */
      __OM  uint32_t MR3IC      : 1;            /*!< [3..3] MR3IF clear bit                                                    */
      __OM  uint32_t CAP0IC     : 1;            /*!< [4..4] CAP0IF clear bit                                                   */
            uint32_t            : 27;
    } IC_b;
  } ;
} SN_CT32B0_Type;                               /*!< Size = 64 (0x40)                                                          */



/* =========================================================================================================================== */
/* ================                                          SN_PMU                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief Power Management Unit (SN_PMU)
  */

typedef struct {                                /*!< (@ 0x40032000) SN_PMU Structure                                           */
  
  union {
    __IOM uint32_t BKP0;                        /*!< (@ 0x00000000) Offset:0x00 PMU Backup Register 0                          */
    
    struct {
      __IOM uint32_t BACKUPDATA : 8;            /*!< [7..0] Data retained                                                      */
            uint32_t            : 24;
    } BKP0_b;
  } ;
  
  union {
    __IOM uint32_t BKP1;                        /*!< (@ 0x00000004) Offset:0x04 PMU Backup Register 1                          */
    
    struct {
      __IOM uint32_t BACKUPDATA : 8;            /*!< [7..0] Data retained                                                      */
            uint32_t            : 24;
    } BKP1_b;
  } ;
  
  union {
    __IOM uint32_t BKP2;                        /*!< (@ 0x00000008) Offset:0x08 PMU Backup Register 2                          */
    
    struct {
      __IOM uint32_t BACKUPDATA : 8;            /*!< [7..0] Data retained                                                      */
            uint32_t            : 24;
    } BKP2_b;
  } ;
  
  union {
    __IOM uint32_t BKP3;                        /*!< (@ 0x0000000C) Offset:0x0C PMU Backup Register 3                          */
    
    struct {
      __IOM uint32_t BACKUPDATA : 8;            /*!< [7..0] Data retained                                                      */
            uint32_t            : 24;
    } BKP3_b;
  } ;
  
  union {
    __IOM uint32_t BKP4;                        /*!< (@ 0x00000010) Offset:0x10 PMU Backup Register 4                          */
    
    struct {
      __IOM uint32_t BACKUPDATA : 8;            /*!< [7..0] Data retained                                                      */
            uint32_t            : 24;
    } BKP4_b;
  } ;
  
  union {
    __IOM uint32_t BKP5;                        /*!< (@ 0x00000014) Offset:0x14 PMU Backup Register 5                          */
    
    struct {
      __IOM uint32_t BACKUPDATA : 8;            /*!< [7..0] Data retained                                                      */
            uint32_t            : 24;
    } BKP5_b;
  } ;
  
  union {
    __IOM uint32_t BKP6;                        /*!< (@ 0x00000018) Offset:0x18 PMU Backup Register 6                          */
    
    struct {
      __IOM uint32_t BACKUPDATA : 8;            /*!< [7..0] Data retained                                                      */
            uint32_t            : 24;
    } BKP6_b;
  } ;
  
  union {
    __IOM uint32_t BKP7;                        /*!< (@ 0x0000001C) Offset:0x1C PMU Backup Register 7                          */
    
    struct {
      __IOM uint32_t BACKUPDATA : 8;            /*!< [7..0] Data retained                                                      */
            uint32_t            : 24;
    } BKP7_b;
  } ;
  
  union {
    __IOM uint32_t BKP8;                        /*!< (@ 0x00000020) Offset:0x20 PMU Backup Register 8                          */
    
    struct {
      __IOM uint32_t BACKUPDATA : 8;            /*!< [7..0] Data retained                                                      */
            uint32_t            : 24;
    } BKP8_b;
  } ;
  
  union {
    __IOM uint32_t BKP9;                        /*!< (@ 0x00000024) Offset:0x24 PMU Backup Register 9                          */
    
    struct {
      __IOM uint32_t BACKUPDATA : 8;            /*!< [7..0] Data retained                                                      */
            uint32_t            : 24;
    } BKP9_b;
  } ;
  
  union {
    __IOM uint32_t BKP10;                       /*!< (@ 0x00000028) Offset:0x28 PMU Backup Register 10                         */
    
    struct {
      __IOM uint32_t BACKUPDATA : 8;            /*!< [7..0] Data retained                                                      */
            uint32_t            : 24;
    } BKP10_b;
  } ;
  
  union {
    __IOM uint32_t BKP11;                       /*!< (@ 0x0000002C) Offset:0x2C PMU Backup Register 11                         */
    
    struct {
      __IOM uint32_t BACKUPDATA : 8;            /*!< [7..0] Data retained                                                      */
            uint32_t            : 24;
    } BKP11_b;
  } ;
  
  union {
    __IOM uint32_t BKP12;                       /*!< (@ 0x00000030) Offset:0x30 PMU Backup Register 12                         */
    
    struct {
      __IOM uint32_t BACKUPDATA : 8;            /*!< [7..0] Data retained                                                      */
            uint32_t            : 24;
    } BKP12_b;
  } ;
  
  union {
    __IOM uint32_t BKP13;                       /*!< (@ 0x00000034) Offset:0x34 PMU Backup Register 13                         */
    
    struct {
      __IOM uint32_t BACKUPDATA : 8;            /*!< [7..0] Data retained                                                      */
            uint32_t            : 24;
    } BKP13_b;
  } ;
  
  union {
    __IOM uint32_t BKP14;                       /*!< (@ 0x00000038) Offset:0x38 PMU Backup Register 14                         */
    
    struct {
      __IOM uint32_t BACKUPDATA : 8;            /*!< [7..0] Data retained                                                      */
            uint32_t            : 24;
    } BKP14_b;
  } ;
  
  union {
    __IOM uint32_t BKP15;                       /*!< (@ 0x0000003C) Offset:0x3C PMU Backup Register 15                         */
    
    struct {
      __IOM uint32_t BACKUPDATA : 8;            /*!< [7..0] Data retained                                                      */
            uint32_t            : 24;
    } BKP15_b;
  } ;
  
  union {
    __IOM uint32_t CTRL;                        /*!< (@ 0x00000040) Offset:0x40 PMU Control Register                           */
    
    struct {
      __IOM uint32_t MODE       : 3;            /*!< [2..0] Low Power mode selection                                           */
            uint32_t            : 29;
    } CTRL_b;
  } ;
  
  union {
    __IOM uint32_t LATCHCTRL1;                  /*!< (@ 0x00000044) Offset:0x44 PMU Latch Control Register 1                   */
    
    struct {
      __IOM uint32_t LATCHEN    : 1;            /*!< [0..0] Latch enable bit                                                   */
            uint32_t            : 15;
      __OM  uint32_t LATCHKEY   : 16;           /*!< [31..16] Latch register key                                               */
    } LATCHCTRL1_b;
  } ;
  
  union {
    __IOM uint32_t LATCHCTRL2;                  /*!< (@ 0x00000048) Offset:0x48 PMU Latch Control Register 2                   */
    
    struct {
      __IOM uint32_t LATCHDIS   : 1;            /*!< [0..0] Latch disable bit                                                  */
            uint32_t            : 15;
      __OM  uint32_t LATCHKEY   : 16;           /*!< [31..16] Latch register key                                               */
    } LATCHCTRL2_b;
  } ;
  
  union {
    __IM  uint32_t LATCHST;                     /*!< (@ 0x0000004C) Offset:0x4C PMU Latch Status Register                      */
    
    struct {
      __IM  uint32_t LATCHST    : 1;            /*!< [0..0] Latch status                                                       */
            uint32_t            : 31;
    } LATCHST_b;
  } ;
} SN_PMU_Type;                                  /*!< Size = 80 (0x50)                                                          */



/* =========================================================================================================================== */
/* ================                                          SN_SSP0                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief SSP0 (SN_SSP0)
  */

typedef struct {                                /*!< (@ 0x4001C000) SN_SSP0 Structure                                          */
  
  union {
    __IOM uint32_t CTRL0;                       /*!< (@ 0x00000000) Offset:0x00 SSPn Control Register 0                        */
    
    struct {
      __IOM uint32_t SSPEN      : 1;            /*!< [0..0] SSP enable                                                         */
      __IOM uint32_t LOOPBACK   : 1;            /*!< [1..1] Loopback mode enable                                               */
      __IOM uint32_t SDODIS     : 1;            /*!< [2..2] Slave data out disable                                             */
      __IOM uint32_t MS         : 1;            /*!< [3..3] Master/Slave selection                                             */
      __IOM uint32_t FORMAT     : 1;            /*!< [4..4] Interface format                                                   */
            uint32_t            : 1;
      __OM  uint32_t FRESET     : 2;            /*!< [7..6] SSP FSM and FIFO Reset                                             */
      __IOM uint32_t DL         : 4;            /*!< [11..8] Data length = DL[3:0]+1                                           */
      __IOM uint32_t TXFIFOTH   : 3;            /*!< [14..12] TX FIFO Threshold level                                          */
      __IOM uint32_t RXFIFOTH   : 3;            /*!< [17..15] RX FIFO Threshold level                                          */
      __IOM uint32_t SELDIS     : 1;            /*!< [18..18] Auto-SEL disable bit                                             */
            uint32_t            : 13;
    } CTRL0_b;
  } ;
  
  union {
    __IOM uint32_t CTRL1;                       /*!< (@ 0x00000004) Offset:0x04 SSPn Control Register 1                        */
    
    struct {
      __IOM uint32_t MLSB       : 1;            /*!< [0..0] MSB/LSB seletion                                                   */
      __IOM uint32_t CPOL       : 1;            /*!< [1..1] Clock priority selection                                           */
      __IOM uint32_t CPHA       : 1;            /*!< [2..2] Clock phase of edge sampling                                       */
            uint32_t            : 29;
    } CTRL1_b;
  } ;
  
  union {
    __IOM uint32_t CLKDIV;                      /*!< (@ 0x00000008) Offset:0x08 SSPn Clock Divider Register                    */
    
    struct {
      __IOM uint32_t DIV        : 8;            /*!< [7..0] SSPn SCK=SSPn_PCLK/(2*DIV+2)                                       */
            uint32_t            : 24;
    } CLKDIV_b;
  } ;
  
  union {
    __IM  uint32_t STAT;                        /*!< (@ 0x0000000C) Offset:0x0C SSPn Status Register                           */
    
    struct {
      __IM  uint32_t TX_EMPTY   : 1;            /*!< [0..0] TX FIFO empty flag                                                 */
      __IM  uint32_t TX_FULL    : 1;            /*!< [1..1] TX FIFO full flag                                                  */
      __IM  uint32_t RX_EMPTY   : 1;            /*!< [2..2] RX FIFO empty flag                                                 */
      __IM  uint32_t RX_FULL    : 1;            /*!< [3..3] RX FIFO full flag                                                  */
      __IM  uint32_t BUSY       : 1;            /*!< [4..4] Busy flag                                                          */
      __IM  uint32_t TXFIFOTHF  : 1;            /*!< [5..5] TX FIFO threshold flag                                             */
      __IM  uint32_t RXFIFOTHF  : 1;            /*!< [6..6] RX FIFO threshold flag                                             */
            uint32_t            : 25;
    } STAT_b;
  } ;
  
  union {
    __IOM uint32_t IE;                          /*!< (@ 0x00000010) Offset:0x10 SSPn Interrupt Enable Register                 */
    
    struct {
      __IOM uint32_t RXOVFIE    : 1;            /*!< [0..0] RX FIFO overflow interrupt enable                                  */
      __IOM uint32_t RXTOIE     : 1;            /*!< [1..1] RX time-out interrupt enable                                       */
      __IOM uint32_t RXFIFOTHIE : 1;            /*!< [2..2] RX FIFO threshold interrupt enable                                 */
      __IOM uint32_t TXFIFOTHIE : 1;            /*!< [3..3] TX FIFO threshold interrupt enable                                 */
            uint32_t            : 28;
    } IE_b;
  } ;
  
  union {
    __IM  uint32_t RIS;                         /*!< (@ 0x00000014) Offset:0x14 SSPn Raw Interrupt Status Register             */
    
    struct {
      __IM  uint32_t RXOVFIF    : 1;            /*!< [0..0] RX FIFO overflow interrupt flag                                    */
      __IM  uint32_t RXTOIF     : 1;            /*!< [1..1] RX time-out interrupt flag                                         */
      __IM  uint32_t RXFIFOTHIF : 1;            /*!< [2..2] RX FIFO threshold interrupt flag                                   */
      __IM  uint32_t TXFIFOTHIF : 1;            /*!< [3..3] TX FIFO threshold interrupt flag                                   */
            uint32_t            : 28;
    } RIS_b;
  } ;
  
  union {
    __OM  uint32_t IC;                          /*!< (@ 0x00000018) Offset:0x18 SSPn Interrupt Clear Register                  */
    
    struct {
      __OM  uint32_t RXOVFIC    : 1;            /*!< [0..0] RX FIFO overflow flag clear                                        */
      __OM  uint32_t RXTOIC     : 1;            /*!< [1..1] RX time-out interrupt flag clear                                   */
      __OM  uint32_t RXFIFOTHIC : 1;            /*!< [2..2] RX Interrupt flag Clear                                            */
      __OM  uint32_t TXFIFOTHIC : 1;            /*!< [3..3] TX Interrupt flag Clear                                            */
            uint32_t            : 28;
    } IC_b;
  } ;
  
  union {
    __IOM uint32_t DATA;                        /*!< (@ 0x0000001C) Offset:0x1C SSPn Data Register                             */
    
    struct {
      __IOM uint32_t Data       : 16;           /*!< [15..0] Data                                                              */
            uint32_t            : 16;
    } DATA_b;
  } ;
  
  union {
    __IOM uint32_t DF;                          /*!< (@ 0x00000020) Offset:0x20 SSPn Data Fetch Register                       */
    
    struct {
      __IOM uint32_t DF         : 1;            /*!< [0..0] SSP data fetch control bit                                         */
            uint32_t            : 31;
    } DF_b;
  } ;
} SN_SSP0_Type;                                 /*!< Size = 36 (0x24)                                                          */



/* =========================================================================================================================== */
/* ================                                          SN_I2C0                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief I2C0 (SN_I2C0)
  */

typedef struct {                                /*!< (@ 0x40018000) SN_I2C0 Structure                                          */
  
  union {
    __IOM uint32_t CTRL;                        /*!< (@ 0x00000000) Offset:0x00 I2Cn Control Register                          */
    
    struct {
            uint32_t            : 1;
      __IOM uint32_t NACK       : 1;            /*!< [1..1] NACK assert flag                                                   */
      __IOM uint32_t ACK        : 1;            /*!< [2..2] ACK assert flag                                                    */
            uint32_t            : 1;
      __IOM uint32_t STO        : 1;            /*!< [4..4] STOP assert flag                                                   */
      __IOM uint32_t STA        : 1;            /*!< [5..5] START assert flag                                                  */
            uint32_t            : 1;
      __IOM uint32_t I2CMODE    : 1;            /*!< [7..7] I2C mode                                                           */
      __IOM uint32_t I2CEN      : 1;            /*!< [8..8] I2Cn interface enable                                              */
            uint32_t            : 23;
    } CTRL_b;
  } ;
  
  union {
    __IOM uint32_t STAT;                        /*!< (@ 0x00000004) Offset:0x04 I2Cn Status Register                           */
    
    struct {
      __IM  uint32_t RX_DN      : 1;            /*!< [0..0] RX done status                                                     */
      __IM  uint32_t ACK_STAT   : 1;            /*!< [1..1] ACK done status                                                    */
      __IM  uint32_t NACK_STAT  : 1;            /*!< [2..2] NACK done status                                                   */
      __IM  uint32_t STOP_DN    : 1;            /*!< [3..3] STOP done status                                                   */
      __IM  uint32_t START_DN   : 1;            /*!< [4..4] START done status                                                  */
      __IM  uint32_t MST        : 1;            /*!< [5..5] I2C master/slave status                                            */
      __IM  uint32_t SLV_RX_HIT : 1;            /*!< [6..6] Slave RX address hit flag                                          */
      __IM  uint32_t SLV_TX_HIT : 1;            /*!< [7..7] Slave TX address hit flag                                          */
      __IM  uint32_t LOST_ARB   : 1;            /*!< [8..8] Lost arbitration status                                            */
      __IM  uint32_t TIMEOUT    : 1;            /*!< [9..9] Time-out status                                                    */
            uint32_t            : 5;
      __IOM uint32_t I2CIF      : 1;            /*!< [15..15] I2C interrupt flag                                               */
            uint32_t            : 16;
    } STAT_b;
  } ;
  
  union {
    __IOM uint32_t TXDATA;                      /*!< (@ 0x00000008) Offset:0x08 I2Cn TX Data Register                          */
    
    struct {
      __IOM uint32_t Data       : 8;            /*!< [7..0] TX Data                                                            */
            uint32_t            : 24;
    } TXDATA_b;
  } ;
  
  union {
    __IM  uint32_t RXDATA;                      /*!< (@ 0x0000000C) Offset:0x0C I2Cn RX Data Register                          */
    
    struct {
      __IM  uint32_t Data       : 8;            /*!< [7..0] RX Data received when RX_DN=1                                      */
            uint32_t            : 24;
    } RXDATA_b;
  } ;
  
  union {
    __IOM uint32_t SLVADDR0;                    /*!< (@ 0x00000010) Offset:0x10 I2Cn Slave Address 0 Register                  */
    
    struct {
      __IOM uint32_t ADDR       : 10;           /*!< [9..0] I2Cn slave address 0                                               */
            uint32_t            : 20;
      __IOM uint32_t GCEN       : 1;            /*!< [30..30] General call address enable                                      */
      __IOM uint32_t ADD_MODE   : 1;            /*!< [31..31] Slave address mode                                               */
    } SLVADDR0_b;
  } ;
  
  union {
    __IOM uint32_t SLVADDR1;                    /*!< (@ 0x00000014) Offset:0x14 I2Cn Slave Address 1 Register                  */
    
    struct {
      __IOM uint32_t ADDR       : 10;           /*!< [9..0] I2Cn slave address 1                                               */
            uint32_t            : 22;
    } SLVADDR1_b;
  } ;
  
  union {
    __IOM uint32_t SLVADDR2;                    /*!< (@ 0x00000018) Offset:0x18 I2Cn Slave Address 2 Register                  */
    
    struct {
      __IOM uint32_t ADDR       : 10;           /*!< [9..0] I2Cn slave address 2                                               */
            uint32_t            : 22;
    } SLVADDR2_b;
  } ;
  
  union {
    __IOM uint32_t SLVADDR3;                    /*!< (@ 0x0000001C) Offset:0x1C I2Cn Slave Address 3 Register                  */
    
    struct {
      __IOM uint32_t ADDR       : 10;           /*!< [9..0] I2Cn slave address 3                                               */
            uint32_t            : 22;
    } SLVADDR3_b;
  } ;
  
  union {
    __IOM uint32_t SCLHT;                       /*!< (@ 0x00000020) Offset:0x20 I2Cn SCL High Time Register                    */
    
    struct {
      __IOM uint32_t SCLH       : 8;            /*!< [7..0] SCLn High period time=(SCLHT+1)*I2Cn_PCLK cycle                    */
            uint32_t            : 24;
    } SCLHT_b;
  } ;
  
  union {
    __IOM uint32_t SCLLT;                       /*!< (@ 0x00000024) Offset:0x24 I2Cn SCL Low Time Register                     */
    
    struct {
      __IOM uint32_t SCLL       : 8;            /*!< [7..0] SCLn Low period time=(SCLLT+1)*I2Cn_PCLK cycle                     */
            uint32_t            : 24;
    } SCLLT_b;
  } ;
  __IM  uint32_t  RESERVED;
  
  union {
    __IOM uint32_t TOCTRL;                      /*!< (@ 0x0000002C) Offset:0x2C I2Cn Timeout Control Register                  */
    
    struct {
      __IOM uint32_t TO         : 16;           /*!< [15..0] Timeout period time = TO*32*I2Cn_PCLK cycle                       */
            uint32_t            : 16;
    } TOCTRL_b;
  } ;
  
  union {
    __IOM uint32_t MMCTRL;                      /*!< (@ 0x00000030) Offset:0x30 I2Cn Monitor Mode Control Register             */
    
    struct {
      __IOM uint32_t MMEN       : 1;            /*!< [0..0] Monitor mode enable                                                */
      __IOM uint32_t SCLOEN     : 1;            /*!< [1..1] SCLn output enable                                                 */
      __IOM uint32_t MATCH_ALL  : 1;            /*!< [2..2] Match address selection                                            */
            uint32_t            : 29;
    } MMCTRL_b;
  } ;
} SN_I2C0_Type;                                 /*!< Size = 52 (0x34)                                                          */



/* =========================================================================================================================== */
/* ================                                         SN_USART0                                         ================ */
/* =========================================================================================================================== */


/**
  * @brief USART0 (SN_USART0)
  */

typedef struct {                                /*!< (@ 0x40016000) SN_USART0 Structure                                        */
  
  union {
    union {
      __IM  uint32_t RB;                        /*!< (@ 0x00000000) Offset:0x00 USARTn Receiver Buffer Register                */
      
      struct {
        __IM  uint32_t RB       : 8;            /*!< [7..0] The oldest received byte in USART RX FIFO                          */
              uint32_t          : 24;
      } RB_b;
    } ;
    
    union {
      __IOM uint32_t TH;                        /*!< (@ 0x00000000) Offset:0x00 USARTn Transmit Holding Register               */
      
      struct {
        __OM  uint32_t TH       : 8;            /*!< [7..0] The oldest byte to be transmitted in USART TX FIFO when
                                                     transmitter is available                                                  */
              uint32_t          : 24;
      } TH_b;
    } ;
    
    union {
      __IOM uint32_t DLL;                       /*!< (@ 0x00000000) Offset:0x00 USARTn Divisor Latch LSB Register              */
      
      struct {
        __IOM uint32_t DLL      : 8;            /*!< [7..0] DLL and DLM register determines the baud rate of USARTn            */
              uint32_t          : 24;
      } DLL_b;
    } ;
  };
  
  union {
    union {
      __IOM uint32_t DLM;                       /*!< (@ 0x00000004) Offset:0x04 USARTn Divisor Latch MSB Register              */
      
      struct {
        __IOM uint32_t DLM      : 8;            /*!< [7..0] DLL and DLM register determines the baud rate of USARTn            */
              uint32_t          : 24;
      } DLM_b;
    } ;
    
    union {
      __IOM uint32_t IE;                        /*!< (@ 0x00000004) Offset:0x04 USARTn Interrupt Enable Register               */
      
      struct {
        __IOM uint32_t RDAIE    : 1;            /*!< [0..0] RDA interrupt enable                                               */
        __IOM uint32_t THREIE   : 1;            /*!< [1..1] THRE interrupt enable                                              */
        __IOM uint32_t RLSIE    : 1;            /*!< [2..2] RLS interrupt enable                                               */
        __IOM uint32_t MSIE     : 1;            /*!< [3..3] MS interrupt enable                                                */
        __IOM uint32_t TEMTIE   : 1;            /*!< [4..4] TEMT interrupt enable                                              */
              uint32_t          : 3;
        __IOM uint32_t ABEOIE   : 1;            /*!< [8..8] ABE0 interrupt enable                                              */
        __IOM uint32_t ABTOIE   : 1;            /*!< [9..9] ABT0 interrupt enable                                              */
        __IOM uint32_t TXERRIE  : 1;            /*!< [10..10] TXERR interrupt enable                                           */
              uint32_t          : 21;
      } IE_b;
    } ;
  };
  
  union {
    union {
      __IM  uint32_t II;                        /*!< (@ 0x00000008) Offset:0x08 USARTn Interrupt Identification Register       */
      
      struct {
        __IM  uint32_t INTSTATUS : 1;           /*!< [0..0] Interrupt status                                                   */
        __IM  uint32_t INTID    : 3;            /*!< [3..1] Interrupt ID of RX FIFO                                            */
              uint32_t          : 2;
        __IM  uint32_t FIFOEN   : 2;            /*!< [7..6] Equal to FIFOEN bits in USARTn_FIFOCTRL register                   */
        __IM  uint32_t ABEOIF   : 1;            /*!< [8..8] ABEO interrupt flag                                                */
        __IM  uint32_t ABTOIF   : 1;            /*!< [9..9] ABTO interrupt flag                                                */
        __IM  uint32_t TXERRIF  : 1;            /*!< [10..10] TXERR interrupt flag                                             */
              uint32_t          : 21;
      } II_b;
    } ;
    
    union {
      __OM  uint32_t FIFOCTRL;                  /*!< (@ 0x00000008) Offset:0x08 USARTn FIFO Control Register                   */
      
      struct {
        __OM  uint32_t FIFOEN   : 1;            /*!< [0..0] FIFO enable                                                        */
        __OM  uint32_t RXFIFORST : 1;           /*!< [1..1] RX FIFO reset                                                      */
        __OM  uint32_t TXFIFORST : 1;           /*!< [2..2] TX FIFO reset                                                      */
              uint32_t          : 3;
        __OM  uint32_t RXTL     : 2;            /*!< [7..6] RX trigger level                                                   */
              uint32_t          : 24;
      } FIFOCTRL_b;
    } ;
  };
  
  union {
    __IOM uint32_t LC;                          /*!< (@ 0x0000000C) Offset:0x0C USARTn Line Control Register                   */
    
    struct {
      __IOM uint32_t WLS        : 2;            /*!< [1..0] Word length selection                                              */
      __IOM uint32_t SBS        : 1;            /*!< [2..2] Stop bit selection                                                 */
      __IOM uint32_t PE         : 1;            /*!< [3..3] Parity enable                                                      */
      __IOM uint32_t PS         : 2;            /*!< [5..4] Parity selection                                                   */
      __IOM uint32_t BC         : 1;            /*!< [6..6] Break control                                                      */
      __IOM uint32_t DLAB       : 1;            /*!< [7..7] Divisor Latch access                                               */
            uint32_t            : 24;
    } LC_b;
  } ;
  
  union {
    __IOM uint32_t MC;                          /*!< (@ 0x00000010) Offset:0x10 USARTn Modem Control Register                  */
    
    struct {
            uint32_t            : 1;
      __IOM uint32_t RTSCTRL    : 1;            /*!< [1..1] Source from modem output (RTS) pin                                 */
            uint32_t            : 4;
      __IOM uint32_t RTSEN      : 1;            /*!< [6..6] RTS enable                                                         */
      __IOM uint32_t CTSEN      : 1;            /*!< [7..7] CTS enable                                                         */
            uint32_t            : 24;
    } MC_b;
  } ;
  
  union {
    __IM  uint32_t LS;                          /*!< (@ 0x00000014) Offset:0x14 USARTn Line Status Register                    */
    
    struct {
      __IM  uint32_t RDR        : 1;            /*!< [0..0] Receiver data ready flag                                           */
      __IM  uint32_t OE         : 1;            /*!< [1..1] Overrun error flag                                                 */
      __IM  uint32_t PE         : 1;            /*!< [2..2] Parity error flag                                                  */
      __IM  uint32_t FE         : 1;            /*!< [3..3] Framing error flag                                                 */
      __IM  uint32_t BI         : 1;            /*!< [4..4] Break interrupt flag                                               */
      __IM  uint32_t THRE       : 1;            /*!< [5..5] THR empty flag                                                     */
      __IM  uint32_t TEMT       : 1;            /*!< [6..6] Transmitter empty flag                                             */
      __IM  uint32_t RXFE       : 1;            /*!< [7..7] Receiver FIFO error flag                                           */
      __IM  uint32_t TXERR      : 1;            /*!< [8..8] TX error flag                                                      */
            uint32_t            : 23;
    } LS_b;
  } ;
  
  union {
    __IM  uint32_t MS;                          /*!< (@ 0x00000018) Offset:0x18 USARTn Modem Status Register                   */
    
    struct {
      __IM  uint32_t DCTS       : 1;            /*!< [0..0] Delta CTS                                                          */
            uint32_t            : 3;
      __IM  uint32_t CTS        : 1;            /*!< [4..4] Complement of CTS pin input signal                                 */
            uint32_t            : 27;
    } MS_b;
  } ;
  
  union {
    __IOM uint32_t SP;                          /*!< (@ 0x0000001C) Offset:0x1C USARTn Scratch Pad Register                    */
    
    struct {
      __IOM uint32_t PAD        : 8;            /*!< [7..0] Pad informaton                                                     */
            uint32_t            : 24;
    } SP_b;
  } ;
  
  union {
    __IOM uint32_t ABCTRL;                      /*!< (@ 0x00000020) Offset:0x20 USARTn Auto-baud Control Register              */
    
    struct {
      __IOM uint32_t START      : 1;            /*!< [0..0] Auto-baud run bit                                                  */
      __IOM uint32_t MODE       : 1;            /*!< [1..1] Auto-baud mode selection                                           */
      __IOM uint32_t AUTORESTART : 1;           /*!< [2..2] Restart mode selection                                             */
            uint32_t            : 5;
      __OM  uint32_t ABEOIFC    : 1;            /*!< [8..8] Clear ABEOIF flag                                                  */
      __OM  uint32_t ABTOIFC    : 1;            /*!< [9..9] Clear ABTOIF flag                                                  */
            uint32_t            : 22;
    } ABCTRL_b;
  } ;
  __IM  uint32_t  RESERVED;
  
  union {
    __IOM uint32_t FD;                          /*!< (@ 0x00000028) Offset:0x28 USARTn Fractional Divider Register             */
    
    struct {
      __IOM uint32_t DIVADDVAL  : 4;            /*!< [3..0] Baud rate generation prescaler divisor value                       */
      __IOM uint32_t MULVAL     : 4;            /*!< [7..4] Baud rate generation prescaler multiplier value                    */
      __IOM uint32_t OVER8      : 1;            /*!< [8..8] Oversampling value                                                 */
            uint32_t            : 23;
    } FD_b;
  } ;
  __IM  uint32_t  RESERVED1;
  
  union {
    __IOM uint32_t CTRL;                        /*!< (@ 0x00000030) Offset:0x30 USARTn Control Register                        */
    
    struct {
      __IOM uint32_t USARTEN    : 1;            /*!< [0..0] USART enable                                                       */
      __IOM uint32_t MODE       : 3;            /*!< [3..1] USART mode                                                         */
            uint32_t            : 2;
      __IOM uint32_t RXEN       : 1;            /*!< [6..6] RX enable                                                          */
      __IOM uint32_t TXEN       : 1;            /*!< [7..7] TX enable                                                          */
            uint32_t            : 24;
    } CTRL_b;
  } ;
  
  union {
    __IOM uint32_t HDEN;                        /*!< (@ 0x00000034) Offset:0x34 USARTn Control Register                        */
    
    struct {
      __IOM uint32_t HDEN       : 1;            /*!< [0..0] Half-duplex mode enable                                            */
            uint32_t            : 31;
    } HDEN_b;
  } ;
  
  union {
    __IOM uint32_t SCICTRL;                     /*!< (@ 0x00000038) Offset:0x38 USARTn Smartcard Interface Control
                                                                    Register                                                   */
    
    struct {
            uint32_t            : 1;
      __IOM uint32_t NACKDIS    : 1;            /*!< [1..1] NACK response disable                                              */
      __IOM uint32_t PROTSEL    : 1;            /*!< [2..2] ISO7816-3 protocol selection                                       */
      __IOM uint32_t SCLKEN     : 1;            /*!< [3..3] SCLK enable                                                        */
            uint32_t            : 1;
      __IOM uint32_t TXRETRY    : 3;            /*!< [7..5] Maximal number of retransmissions that USART will attempt          */
      __IOM uint32_t XTRAGUARD  : 8;            /*!< [15..8] Extra guard time                                                  */
      __IOM uint32_t TC         : 8;            /*!< [23..16] Count for SCLK clock cycle                                       */
            uint32_t            : 8;
    } SCICTRL_b;
  } ;
  
  union {
    __IOM uint32_t RS485CTRL;                   /*!< (@ 0x0000003C) Offset:0x3C USARTn RS485 Control Register                  */
    
    struct {
      __IOM uint32_t NMMEN      : 1;            /*!< [0..0] RS-485 normal multidrop mode enable                                */
      __IOM uint32_t RXEN       : 1;            /*!< [1..1] RS-485 receiver enable                                             */
      __IOM uint32_t AADEN      : 1;            /*!< [2..2] Auto address detect enable                                         */
            uint32_t            : 1;
      __IOM uint32_t ADCEN      : 1;            /*!< [4..4] Auto direction control enable                                      */
      __IOM uint32_t OINV       : 1;            /*!< [5..5] Polarity control                                                   */
            uint32_t            : 26;
    } RS485CTRL_b;
  } ;
  
  union {
    __IOM uint32_t RS485ADRMATCH;               /*!< (@ 0x00000040) Offset:0x40 USARTn RS485 Address Match Register            */
    
    struct {
      __IOM uint32_t MATCH      : 8;            /*!< [7..0] RS-485 address value to be matched                                 */
            uint32_t            : 24;
    } RS485ADRMATCH_b;
  } ;
  
  union {
    __IOM uint32_t RS485DLYV;                   /*!< (@ 0x00000044) Offset:0x44 USARTn RS485 Delay Value Register              */
    
    struct {
      __IOM uint32_t DLY        : 8;            /*!< [7..0] RTS delay value                                                    */
            uint32_t            : 24;
    } RS485DLYV_b;
  } ;
  
  union {
    __IOM uint32_t SYNCCTRL;                    /*!< (@ 0x00000048) Offset:0x48 USARTn Synchronous Mode Control Register       */
    
    struct {
            uint32_t            : 1;
      __IOM uint32_t CPOL       : 1;            /*!< [1..1] Clock polarity selection                                           */
      __IOM uint32_t CPHA       : 1;            /*!< [2..2] Clock phase for edge sampling                                      */
            uint32_t            : 29;
    } SYNCCTRL_b;
  } ;
} SN_USART0_Type;                               /*!< Size = 76 (0x4c)                                                          */



/* =========================================================================================================================== */
/* ================                                          SN_I2S                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief I2S (SN_I2S)
  */

typedef struct {                                /*!< (@ 0x4001A000) SN_I2S Structure                                           */
  
  union {
    __IOM uint32_t CTRL;                        /*!< (@ 0x00000000) Offset:0x00 I2S Control Register                           */
    
    struct {
      __IOM uint32_t START      : 1;            /*!< [0..0] Start Transmit/Receive                                             */
      __IOM uint32_t MUTE       : 1;            /*!< [1..1] Mute enable                                                        */
      __IOM uint32_t MONO       : 1;            /*!< [2..2] Mono/stereo selection                                              */
      __IOM uint32_t MS         : 1;            /*!< [3..3] Master/Slave selection bit                                         */
      __IOM uint32_t FORMAT     : 2;            /*!< [5..4] I2S operation format                                               */
      __IOM uint32_t TXEN       : 1;            /*!< [6..6] Transmit enable bit                                                */
      __IOM uint32_t RXEN       : 1;            /*!< [7..7] Receiver enable bit                                                */
      __OM  uint32_t CLRTXFIFO  : 1;            /*!< [8..8] Clear I2S TX FIFO                                                  */
      __OM  uint32_t CLRRXFIFO  : 1;            /*!< [9..9] Clear I2S RX FIFO                                                  */
      __IOM uint32_t DL         : 2;            /*!< [11..10] Data length                                                      */
      __IOM uint32_t TXFIFOTH   : 3;            /*!< [14..12] TX FIFO threshold level                                          */
            uint32_t            : 1;
      __IOM uint32_t RXFIFOTH   : 3;            /*!< [18..16] RX FIFO threshold level                                          */
            uint32_t            : 1;
      __IOM uint32_t CHLENGTH   : 5;            /*!< [24..20] Bit number of single channel                                     */
            uint32_t            : 6;
      __IOM uint32_t I2SEN      : 1;            /*!< [31..31] I2S enable                                                       */
    } CTRL_b;
  } ;
  
  union {
    __IOM uint32_t CLK;                         /*!< (@ 0x00000004) Offset:0x04 I2S Clock Register                             */
    
    struct {
      __IOM uint32_t MCLKDIV    : 3;            /*!< [2..0] MCLK divider                                                       */
      __IOM uint32_t MCLKOEN    : 1;            /*!< [3..3] MLCK output enable                                                 */
      __IOM uint32_t MCLKSEL    : 1;            /*!< [4..4] MLCK source selection                                              */
            uint32_t            : 3;
      __IOM uint32_t BCLKDIV    : 8;            /*!< [15..8] BCLK divider                                                      */
      __IOM uint32_t CLKSEL     : 1;            /*!< [16..16] I2S clock source                                                 */
            uint32_t            : 15;
    } CLK_b;
  } ;
  
  union {
    __IM  uint32_t STATUS;                      /*!< (@ 0x00000008) Offset:0x08 I2S Status Register                            */
    
    struct {
      __IM  uint32_t I2SINT     : 1;            /*!< [0..0] I2S interrupt flag                                                 */
      __IM  uint32_t RIGHTCH    : 1;            /*!< [1..1] Current channel status                                             */
            uint32_t            : 4;
      __IM  uint32_t TXFIFOTHF  : 1;            /*!< [6..6] TX FIFO threshold flag                                             */
      __IM  uint32_t RXFIFOTHF  : 1;            /*!< [7..7] RX FIFO threshold flag                                             */
      __IM  uint32_t TXFIFOFULL : 1;            /*!< [8..8] TX FIFO full flag                                                  */
      __IM  uint32_t RXFIFOFULL : 1;            /*!< [9..9] RX FIFO full flag                                                  */
      __IM  uint32_t TXFIFOEMPTY : 1;           /*!< [10..10] TX FIFO empty flag                                               */
      __IM  uint32_t RXFIFOEMPTY : 1;           /*!< [11..11] RX FIFO empty flag                                               */
      __IM  uint32_t TXFIFOLV   : 4;            /*!< [15..12] TX FIFO used level                                               */
            uint32_t            : 1;
      __IM  uint32_t RXFIFOLV   : 4;            /*!< [20..17] RX FIFO used level                                               */
            uint32_t            : 11;
    } STATUS_b;
  } ;
  
  union {
    __IOM uint32_t IE;                          /*!< (@ 0x0000000C) Offset:0x0C I2S Interrupt Enable Register                  */
    
    struct {
            uint32_t            : 4;
      __IOM uint32_t TXFIFOOVFIEN : 1;          /*!< [4..4] TX FIFO overflow interrupt enable                                  */
      __IOM uint32_t RXFIFOUDFIEN : 1;          /*!< [5..5] RX FIFO underflow interrupt enable                                 */
      __IOM uint32_t TXFIFOTHIEN : 1;           /*!< [6..6] TX FIFO threshold interrupt enable                                 */
      __IOM uint32_t RXFIFOTHIEN : 1;           /*!< [7..7] RX FIFO threshold interrupt enable                                 */
            uint32_t            : 24;
    } IE_b;
  } ;
  
  union {
    __IM  uint32_t RIS;                         /*!< (@ 0x00000010) Offset:0x10 I2S Raw Interrupt Status Register              */
    
    struct {
            uint32_t            : 4;
      __IM  uint32_t TXFIFOOVIF : 1;            /*!< [4..4] TX FIFO overflow interrupt flag                                    */
      __IM  uint32_t RXFIFOUDIF : 1;            /*!< [5..5] RX FIFO underflow interrupt flag                                   */
      __IM  uint32_t TXFIFOTHIF : 1;            /*!< [6..6] TX FIFO threshold interrupt flag                                   */
      __IM  uint32_t RXFIFOTHIF : 1;            /*!< [7..7] RX FIFO threshold interrupt flag                                   */
            uint32_t            : 24;
    } RIS_b;
  } ;
  
  union {
    __OM  uint32_t IC;                          /*!< (@ 0x00000014) Offset:0x14 I2S Interrupt Clear Register                   */
    
    struct {
            uint32_t            : 4;
      __OM  uint32_t TXFIFOOVIC : 1;            /*!< [4..4] TX FIFO overflow interrupt clear                                   */
      __OM  uint32_t RXFIFOUDIC : 1;            /*!< [5..5] RX FIFO underflow interrupt clear                                  */
      __OM  uint32_t TXFIFOTHIC : 1;            /*!< [6..6] TX FIFO threshold interrupt clear                                  */
      __OM  uint32_t RXFIFOTHIC : 1;            /*!< [7..7] RX FIFO threshold interrupt clear                                  */
            uint32_t            : 24;
    } IC_b;
  } ;
  __IM  uint32_t  RXFIFO;                       /*!< (@ 0x00000018) Offset:0x18 I2S RX FIFO Register                           */
  __OM  uint32_t  TXFIFO;                       /*!< (@ 0x0000001C) Offset:0x1C I2S TX FIFO Register                           */
} SN_I2S_Type;                                  /*!< Size = 32 (0x20)                                                          */



/* =========================================================================================================================== */
/* ================                                         SN_FLASH                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief FLASH Memory Control Registers (SN_FLASH)
  */

typedef struct {                                /*!< (@ 0x40062000) SN_FLASH Structure                                         */
  
  union {
    __IOM uint32_t LPCTRL;                      /*!< (@ 0x00000000) Offset:0x00 Flash Low Power Control Register               */
    
    struct {
      __IOM uint32_t LPMODE     : 2;            /*!< [1..0] Flash Low Power mode enable bit                                    */
            uint32_t            : 30;
    } LPCTRL_b;
  } ;
  
  union {
    __IOM uint32_t STATUS;                      /*!< (@ 0x00000004) Offset:0x04 Flash Status Register                          */
    
    struct {
      __IM  uint32_t BUSY       : 1;            /*!< [0..0] Busy flag                                                          */
            uint32_t            : 1;
      __IOM uint32_t PGERR      : 1;            /*!< [2..2] Programming error flag                                             */
            uint32_t            : 29;
    } STATUS_b;
  } ;
  
  union {
    __IOM uint32_t CTRL;                        /*!< (@ 0x00000008) Offset:0x08 Flash Control Register                         */
    
    struct {
      __IOM uint32_t PG         : 1;            /*!< [0..0] Flash program enable bit                                           */
      __IOM uint32_t PER        : 1;            /*!< [1..1] Page erase enable bit                                              */
            uint32_t            : 4;
      __IOM uint32_t STARTE     : 1;            /*!< [6..6] Start erase enable bit                                             */
      __IOM uint32_t CHK        : 1;            /*!< [7..7] Checksum calculation choosen                                       */
            uint32_t            : 24;
    } CTRL_b;
  } ;
  __IOM uint32_t  DATA;                         /*!< (@ 0x0000000C) Offset:0x0C Flash Data Register                            */
  __IOM uint32_t  ADDR;                         /*!< (@ 0x00000010) Offset:0x10 Flash Address Register                         */
  __IM  uint32_t  CHKSUM;                       /*!< (@ 0x00000014) Offset:0x14 Flash Checksum Register                        */
} SN_FLASH_Type;                                /*!< Size = 24 (0x18)                                                          */



/* =========================================================================================================================== */
/* ================                                          SN_PFPA                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief Peripheral Function Pin Assignment (SN_PFPA)
  */

typedef struct {                                /*!< (@ 0x40042000) SN_PFPA Structure                                          */
  
  union {
    __IOM uint32_t UART;                        /*!< (@ 0x00000000) Offset:0x00 PFPA for UART Register                         */
    
    struct {
      __IOM uint32_t UTXD0      : 4;            /*!< [3..0] UTXD0 assigned pin                                                 */
      __IOM uint32_t URXD0      : 4;            /*!< [7..4] URXD0 assigned pin                                                 */
      __IOM uint32_t UTXD1      : 4;            /*!< [11..8] UTXD1 assigned pin                                                */
      __IOM uint32_t URXD1      : 4;            /*!< [15..12] URXD1 assigned pin                                               */
            uint32_t            : 16;
    } UART_b;
  } ;
  
  union {
    __IOM uint32_t I2C;                         /*!< (@ 0x00000004) Offset:0x04 PFPA for I2C Register                          */
    
    struct {
      __IOM uint32_t SDA0       : 4;            /*!< [3..0] SDA0 assigned pin                                                  */
      __IOM uint32_t SCL0       : 4;            /*!< [7..4] SCL0 assigned pin                                                  */
      __IOM uint32_t SDA1       : 4;            /*!< [11..8] SDA1 assigned pin                                                 */
      __IOM uint32_t SCL1       : 4;            /*!< [15..12] SCL1 assigned pin                                                */
            uint32_t            : 16;
    } I2C_b;
  } ;
  
  union {
    __IOM uint32_t SSP;                         /*!< (@ 0x00000008) Offset:0x08 PFPA for SSP Register                          */
    
    struct {
      __IOM uint32_t MISO0      : 4;            /*!< [3..0] MISO0 assigned pin                                                 */
      __IOM uint32_t MOSI0      : 4;            /*!< [7..4] MOSI0 assigned pin                                                 */
      __IOM uint32_t SCK0       : 4;            /*!< [11..8] SCK0 assigned pin                                                 */
      __IOM uint32_t SEL0       : 4;            /*!< [15..12] SEL0 assigned pin                                                */
      __IOM uint32_t MISO1      : 4;            /*!< [19..16] MISO1 assigned pin                                               */
      __IOM uint32_t MOSI1      : 4;            /*!< [23..20] MOSI1 assigned pin                                               */
      __IOM uint32_t SCK1       : 4;            /*!< [27..24] SCK1 assigned pin                                                */
      __IOM uint32_t SEL1       : 4;            /*!< [31..28] SEL1 assigned pin                                                */
    } SSP_b;
  } ;
  
  union {
    __IOM uint32_t I2S;                         /*!< (@ 0x0000000C) Offset:0x0C PFPA for I2S Register                          */
    
    struct {
      __IOM uint32_t MCLK       : 4;            /*!< [3..0] I2SMCLK assigned pin                                               */
      __IOM uint32_t BCLK       : 4;            /*!< [7..4] I2SBCLK assigned pin                                               */
      __IOM uint32_t WS         : 4;            /*!< [11..8] I2SWS assigned pin                                                */
      __IOM uint32_t DOUT       : 4;            /*!< [15..12] I2SDOUT assigned pin                                             */
      __IOM uint32_t DIN        : 4;            /*!< [19..16] I2SDIN assigned pin                                              */
            uint32_t            : 12;
    } I2S_b;
  } ;
  
  union {
    __IOM uint32_t CT16B0;                      /*!< (@ 0x00000010) Offset:0x10 PFPA for CT16B0 Register                       */
    
    struct {
      __IOM uint32_t CAP0       : 4;            /*!< [3..0] CT16B0_CAP0 assigned pin                                           */
      __IOM uint32_t PWM0       : 4;            /*!< [7..4] CT16B0_PWM0 assigned pin                                           */
      __IOM uint32_t PWM1       : 4;            /*!< [11..8] CT16B0_PWM1 assigned pin                                          */
      __IOM uint32_t PWM2       : 4;            /*!< [15..12] CT16B0_PWM2 assigned pin                                         */
            uint32_t            : 16;
    } CT16B0_b;
  } ;
  
  union {
    __IOM uint32_t CT16B1;                      /*!< (@ 0x00000014) Offset:0x14 PFPA for CT16B1 Register                       */
    
    struct {
      __IOM uint32_t CAP0       : 4;            /*!< [3..0] CT16B1_CAP0 assigned pin                                           */
      __IOM uint32_t PWM0       : 4;            /*!< [7..4] CT16B1_PWM0 assigned pin                                           */
      __IOM uint32_t PWM1       : 4;            /*!< [11..8] CT16B1_PWM1 assigned pin                                          */
      __IOM uint32_t PWM2       : 4;            /*!< [15..12] CT16B1_PWM2 assigned pin                                         */
            uint32_t            : 16;
    } CT16B1_b;
  } ;
  
  union {
    __IOM uint32_t CT16B2;                      /*!< (@ 0x00000018) Offset:0x18 PFPA for CT16B2 Register                       */
    
    struct {
      __IOM uint32_t CAP0       : 4;            /*!< [3..0] CT16B2_CAP0 assigned pin                                           */
      __IOM uint32_t PWM0       : 4;            /*!< [7..4] CT16B2_PWM0 assigned pin                                           */
      __IOM uint32_t PWM1       : 4;            /*!< [11..8] CT16B2_PWM1 assigned pin                                          */
      __IOM uint32_t PWM2       : 4;            /*!< [15..12] CT16B2_PWM2 assigned pin                                         */
            uint32_t            : 16;
    } CT16B2_b;
  } ;
  __IM  uint32_t  RESERVED;
  
  union {
    __IOM uint32_t CT32B0;                      /*!< (@ 0x00000020) Offset:0x20 PFPA for CT32B0 Register                       */
    
    struct {
      __IOM uint32_t CAP0       : 4;            /*!< [3..0] CT32B0_CAP0 assigned pin                                           */
      __IOM uint32_t PWM0       : 4;            /*!< [7..4] CT32B0_PWM0 assigned pin                                           */
      __IOM uint32_t PWM1       : 4;            /*!< [11..8] CT32B0_PWM1 assigned pin                                          */
      __IOM uint32_t PWM2       : 4;            /*!< [15..12] CT32B0_PWM2 assigned pin                                         */
      __IOM uint32_t PWM3       : 4;            /*!< [19..16] CT32B0_PWM3 assigned pin                                         */
            uint32_t            : 12;
    } CT32B0_b;
  } ;
  
  union {
    __IOM uint32_t CT32B1;                      /*!< (@ 0x00000024) Offset:0x24 PFPA for CT32B1 Register                       */
    
    struct {
      __IOM uint32_t CAP0       : 4;            /*!< [3..0] CT32B1_CAP0 assigned pin                                           */
      __IOM uint32_t PWM0       : 4;            /*!< [7..4] CT32B1_PWM0 assigned pin                                           */
      __IOM uint32_t PWM1       : 4;            /*!< [11..8] CT32B1_PWM1 assigned pin                                          */
      __IOM uint32_t PWM2       : 4;            /*!< [15..12] CT32B1_PWM2 assigned pin                                         */
      __IOM uint32_t PWM3       : 4;            /*!< [19..16] CT32B1_PWM3 assigned pin                                         */
            uint32_t            : 12;
    } CT32B1_b;
  } ;
  
  union {
    __IOM uint32_t CT32B2;                      /*!< (@ 0x00000028) Offset:0x28 PFPA for CT32B2 Register                       */
    
    struct {
      __IOM uint32_t CAP0       : 4;            /*!< [3..0] CT32B2_CAP0 assigned pin                                           */
      __IOM uint32_t PWM0       : 4;            /*!< [7..4] CT32B2_PWM0 assigned pin                                           */
      __IOM uint32_t PWM1       : 4;            /*!< [11..8] CT32B2_PWM1 assigned pin                                          */
      __IOM uint32_t PWM2       : 4;            /*!< [15..12] CT32B2_PWM2 assigned pin                                         */
      __IOM uint32_t PWM3       : 4;            /*!< [19..16] CT32B2_PWM3 assigned pin                                         */
            uint32_t            : 12;
    } CT32B2_b;
  } ;
} SN_PFPA_Type;                                 /*!< Size = 44 (0x2c)                                                          */



/* =========================================================================================================================== */
/* ================                                          SN_USB                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief Universal Serial Bus Full Speed Device Interface (USB) (SN_USB)
  */

typedef struct {                                /*!< (@ 0x4005C000) SN_USB Structure                                           */
  
  union {
    __IOM uint32_t INTEN;                       /*!< (@ 0x00000000) Offset:0x00 USB Interrupt Enable Register                  */
    
    struct {
      __IOM uint32_t EP1_NAK_EN : 1;            /*!< [0..0] EP1 NAK Interrupt Enable                                           */
      __IOM uint32_t EP2_NAK_EN : 1;            /*!< [1..1] EP2 NAK Interrupt Enable                                           */
      __IOM uint32_t EP3_NAK_EN : 1;            /*!< [2..2] EP3 NAK Interrupt Enable                                           */
      __IOM uint32_t EP4_NAK_EN : 1;            /*!< [3..3] EP4 NAK Interrupt Enable                                           */
      __IOM uint32_t EP5_NAK_EN : 1;            /*!< [4..4] EP5 NAK Interrupt Enable                                           */
      __IOM uint32_t EP6_NAK_EN : 1;            /*!< [5..5] EP6 NAK Interrupt Enable                                           */
            uint32_t            : 23;
      __IOM uint32_t USB_IE     : 1;            /*!< [29..29] USB Event Interrupt Enable                                       */
      __IOM uint32_t USB_SOF_IE : 1;            /*!< [30..30] USB SOF Interrupt Enable                                         */
      __IOM uint32_t BUS_IE     : 1;            /*!< [31..31] Bus Event Interrupt Enable                                       */
    } INTEN_b;
  } ;
  
  union {
    __IM  uint32_t INSTS;                       /*!< (@ 0x00000004) Offset:0x04 USB Interrupt Event Status Register            */
    
    struct {
      __IM  uint32_t EP1_NAK    : 1;            /*!< [0..0] Endpoint 1 NAK transaction flag                                    */
      __IM  uint32_t EP2_NAK    : 1;            /*!< [1..1] Endpoint 2 NAK transaction flag                                    */
      __IM  uint32_t EP3_NAK    : 1;            /*!< [2..2] Endpoint 3 NAK transaction flag                                    */
      __IM  uint32_t EP4_NAK    : 1;            /*!< [3..3] Endpoint 4 NAK transaction flag                                    */
      __IM  uint32_t EP5_NAK    : 1;            /*!< [4..4] Endpoint 5 NAK transaction flag                                    */
      __IM  uint32_t EP6_NAK    : 1;            /*!< [5..5] Endpoint 6 NAK transaction flag                                    */
            uint32_t            : 2;
      __IM  uint32_t EP1_ACK    : 1;            /*!< [8..8] Endpoint 1 ACK transaction flag                                    */
      __IM  uint32_t EP2_ACK    : 1;            /*!< [9..9] Endpoint 2 ACK transaction flag                                    */
      __IM  uint32_t EP3_ACK    : 1;            /*!< [10..10] Endpoint 3 ACK transaction flag                                  */
      __IM  uint32_t EP4_ACK    : 1;            /*!< [11..11] Endpoint 4 ACK transaction flag                                  */
      __IM  uint32_t EP5_ACK    : 1;            /*!< [12..12] Endpoint 5 ACK transaction flag                                  */
      __IM  uint32_t EP6_ACK    : 1;            /*!< [13..13] Endpoint 6 ACK transaction flag                                  */
            uint32_t            : 3;
      __IM  uint32_t ERR_TIMEOUT : 1;           /*!< [17..17] Timeout Status                                                   */
      __IM  uint32_t ERR_SETUP  : 1;            /*!< [18..18] Wrong Setup data received                                        */
      __IM  uint32_t EP0_OUT_STALL : 1;         /*!< [19..19] EP0 OUT STALL transaction                                        */
      __IM  uint32_t EP0_IN_STALL : 1;          /*!< [20..20] EP0 IN STALL Transaction is completed                            */
      __IM  uint32_t EP0_OUT    : 1;            /*!< [21..21] EP0 OUT ACK Transaction Flag                                     */
      __IM  uint32_t EP0_IN     : 1;            /*!< [22..22] EP0 IN ACK Transaction Flag                                      */
      __IM  uint32_t EP0_SETUP  : 1;            /*!< [23..23] EP0 Setup Transaction Flag                                       */
      __IM  uint32_t EP0_PRESETUP : 1;          /*!< [24..24] EP0 Setup Token Packet Flag                                      */
      __IM  uint32_t BUS_WAKEUP : 1;            /*!< [25..25] Bus Wakeup Flag                                                  */
      __IM  uint32_t USB_SOF    : 1;            /*!< [26..26] USB SOF packet received flag                                     */
            uint32_t            : 2;
      __IM  uint32_t BUS_RESUME : 1;            /*!< [29..29] USB Bus Resume signal flag                                       */
      __IM  uint32_t BUS_SUSPEND : 1;           /*!< [30..30] USB Bus Suspend signal flag                                      */
      __IM  uint32_t BUS_RESET  : 1;            /*!< [31..31] USB Bus Reset signal flag                                        */
    } INSTS_b;
  } ;
  
  union {
    __OM  uint32_t INSTSC;                      /*!< (@ 0x00000008) Offset:0x08 USB Interrupt Event Status Clear
                                                                    Register                                                   */
    
    struct {
      __OM  uint32_t EP1_NAKC   : 1;            /*!< [0..0] EP1 NAK clear bit                                                  */
      __OM  uint32_t EP2_NAKC   : 1;            /*!< [1..1] EP2 NAK clear bit                                                  */
      __OM  uint32_t EP3_NAKC   : 1;            /*!< [2..2] EP3 NAK clear bit                                                  */
      __OM  uint32_t EP4_NAKC   : 1;            /*!< [3..3] EP4 NAK clear bit                                                  */
      __OM  uint32_t EP5_NAKC   : 1;            /*!< [4..4] EP5 NAK clear bit                                                  */
      __OM  uint32_t EP6_NAKC   : 1;            /*!< [5..5] EP6 NAK clear bit                                                  */
            uint32_t            : 2;
      __OM  uint32_t EP1_ACKC   : 1;            /*!< [8..8] EP1 ACK clear bit                                                  */
      __OM  uint32_t EP2_ACKC   : 1;            /*!< [9..9] EP2 ACK clear bit                                                  */
      __OM  uint32_t EP3_ACKC   : 1;            /*!< [10..10] EP3 ACK clear bit                                                */
      __OM  uint32_t EP4_ACKC   : 1;            /*!< [11..11] EP4 ACK clear bit                                                */
      __OM  uint32_t EP5_ACKC   : 1;            /*!< [12..12] EP5 ACK clear bit                                                */
      __OM  uint32_t EP6_ACKC   : 1;            /*!< [13..13] EP6 ACK clear bit                                                */
            uint32_t            : 3;
      __OM  uint32_t ERR_TIMEOUTC : 1;          /*!< [17..17] Timeout Error clear bit                                          */
      __OM  uint32_t ERR_SETUPC : 1;            /*!< [18..18] Error Setup clear bit                                            */
      __OM  uint32_t EP0_OUT_STALLC : 1;        /*!< [19..19] EP0 OUT STALL clear bit                                          */
      __OM  uint32_t EP0_IN_STALLC : 1;         /*!< [20..20] EP0 IN STALL clear bit                                           */
      __OM  uint32_t EP0_OUTC   : 1;            /*!< [21..21] EP0 OUT clear bit                                                */
      __OM  uint32_t EP0_INC    : 1;            /*!< [22..22] EP0 IN clear bit                                                 */
      __OM  uint32_t EP0_SETUPC : 1;            /*!< [23..23] EP0 SETUP clear bit                                              */
      __OM  uint32_t EP0_PRESETUPC : 1;         /*!< [24..24] EP0 PRESETUP clear bit                                           */
      __OM  uint32_t BUS_WAKEUPC : 1;           /*!< [25..25] Bus Wakeup clear bit                                             */
      __OM  uint32_t USB_SOFC   : 1;            /*!< [26..26] USB SOF clear bit                                                */
            uint32_t            : 2;
      __OM  uint32_t BUS_RESUMEC : 1;           /*!< [29..29] USB Bus Resume clear bit                                         */
            uint32_t            : 1;
      __OM  uint32_t BUS_RESETC : 1;            /*!< [31..31] USB Bus Reset clear bit                                          */
    } INSTSC_b;
  } ;
  
  union {
    __IOM uint32_t ADDR;                        /*!< (@ 0x0000000C) Offset:0x0C USB Device Address Register                    */
    
    struct {
      __IOM uint32_t UADDR      : 7;            /*!< [6..0] USB device's address                                               */
            uint32_t            : 25;
    } ADDR_b;
  } ;
  
  union {
    __IOM uint32_t CFG;                         /*!< (@ 0x00000010) Offset:0x10 USB Configuration Register                     */
    
    struct {
      __IOM uint32_t EP1_DIR    : 1;            /*!< [0..0] Endpoint 1 IN/OUT direction setting                                */
      __IOM uint32_t EP2_DIR    : 1;            /*!< [1..1] Endpoint 2 IN/OUT direction setting                                */
      __IOM uint32_t EP3_DIR    : 1;            /*!< [2..2] Endpoint 3 IN/OUT direction setting                                */
      __IOM uint32_t EP4_DIR    : 1;            /*!< [3..3] Endpoint 4 IN/OUT direction setting                                */
      __IOM uint32_t EP5_DIR    : 1;            /*!< [4..4] Endpoint 5 IN/OUT direction setting                                */
      __IOM uint32_t EP6_DIR    : 1;            /*!< [5..5] Endpoint 6 IN/OUT direction setting                                */
            uint32_t            : 2;
      __IOM uint32_t EP1_ISO    : 1;            /*!< [8..8] Endpoint 1 ISO mode setting                                        */
      __IOM uint32_t EP2_ISO    : 1;            /*!< [9..9] Endpoint 2 ISO mode setting                                        */
      __IOM uint32_t EP3_ISO    : 1;            /*!< [10..10] Endpoint 3 ISO mode setting                                      */
      __IOM uint32_t EP4_ISO    : 1;            /*!< [11..11] Endpoint 4 ISO mode setting                                      */
      __IOM uint32_t EP5_ISO    : 1;            /*!< [12..12] Endpoint 5 ISO mode setting                                      */
      __IOM uint32_t EP6_ISO    : 1;            /*!< [13..13] Endpoint 6 ISO mode setting                                      */
            uint32_t            : 10;
      __IOM uint32_t VREG33DIS_EN : 1;          /*!< [24..24] Enable 400ohm discharge path of VREG33 to GND                    */
      __IOM uint32_t USBRAM_EN  : 1;            /*!< [25..25] Enable USB 512-byte RAM function                                 */
      __IOM uint32_t FLTDET_PUEN : 1;           /*!< [26..26] Enable internal D+ and D- weak pull-up resistor                  */
      __IOM uint32_t EMC_EN     : 1;            /*!< [27..27] Enable USB EMC protection                                        */
      __IOM uint32_t SIE_EN     : 1;            /*!< [28..28] USB Serial Interface Engine Enable                               */
      __IOM uint32_t DPPU_EN    : 1;            /*!< [29..29] Enable internal D+ 1.5k pull-up resistor                         */
      __IOM uint32_t PHY_EN     : 1;            /*!< [30..30] PHY Transceiver Function Enable                                  */
      __IOM uint32_t VREG33_EN  : 1;            /*!< [31..31] Enable the internal VREG33 ouput                                 */
    } CFG_b;
  } ;
  
  union {
    __IOM uint32_t SGCTL;                       /*!< (@ 0x00000014) Offset:0x14 USB Signal Control Register                    */
    
    struct {
      __IOM uint32_t BUS_DN     : 1;            /*!< [0..0] USB D- state                                                       */
      __IOM uint32_t BUS_DP     : 1;            /*!< [1..1] USB DP state                                                       */
      __IOM uint32_t BUS_DRVEN  : 1;            /*!< [2..2] Enable to drive USB bus                                            */
            uint32_t            : 29;
    } SGCTL_b;
  } ;
  
  union {
    __IOM uint32_t EP0CTL;                      /*!< (@ 0x00000018) Offset:0x18 USB Endpoint 0 Control Register                */
    
    struct {
      __IOM uint32_t ENDP_CNT   : 7;            /*!< [6..0] Endpoint byte count                                                */
            uint32_t            : 20;
      __IOM uint32_t OUT_STALL_EN : 1;          /*!< [27..27] Enable EP0 OUT STALL handshake                                   */
      __IOM uint32_t IN_STALL_EN : 1;           /*!< [28..28] Enable EP0 IN STALL handshake                                    */
      __IOM uint32_t ENDP_STATE : 2;            /*!< [30..29] Endpoint Handshake State                                         */
      __IOM uint32_t ENDP_EN    : 1;            /*!< [31..31] Enable Endpoint 0 Function                                       */
    } EP0CTL_b;
  } ;
  
  union {
    __IOM uint32_t EP1CTL;                      /*!< (@ 0x0000001C) Offset:0x1C USB Endpoint 1 Control Register                */
    
    struct {
      __IOM uint32_t ENDP_CNT   : 9;            /*!< [8..0] Endpoint byte count                                                */
            uint32_t            : 20;
      __IOM uint32_t ENDP_STATE : 2;            /*!< [30..29] Endpoint Handshake State                                         */
      __IOM uint32_t ENDP_EN    : 1;            /*!< [31..31] Endpoint 1 Function enable bit                                   */
    } EP1CTL_b;
  } ;
  
  union {
    __IOM uint32_t EP2CTL;                      /*!< (@ 0x00000020) Offset:0x20 USB Endpoint 2 Control Register                */
    
    struct {
      __IOM uint32_t ENDP_CNT   : 9;            /*!< [8..0] Endpoint byte count                                                */
            uint32_t            : 20;
      __IOM uint32_t ENDP_STATE : 2;            /*!< [30..29] Endpoint Handshake State                                         */
      __IOM uint32_t ENDP_EN    : 1;            /*!< [31..31] Endpoint 2 Function enable bit                                   */
    } EP2CTL_b;
  } ;
  
  union {
    __IOM uint32_t EP3CTL;                      /*!< (@ 0x00000024) Offset:0x24 USB Endpoint 3 Control Register                */
    
    struct {
      __IOM uint32_t ENDP_CNT   : 9;            /*!< [8..0] Endpoint byte count                                                */
            uint32_t            : 20;
      __IOM uint32_t ENDP_STATE : 2;            /*!< [30..29] Endpoint Handshake State                                         */
      __IOM uint32_t ENDP_EN    : 1;            /*!< [31..31] Endpoint 3 Function enable bit                                   */
    } EP3CTL_b;
  } ;
  
  union {
    __IOM uint32_t EP4CTL;                      /*!< (@ 0x00000028) Offset:0x28 USB Endpoint 4 Control Register                */
    
    struct {
      __IOM uint32_t ENDP_CNT   : 9;            /*!< [8..0] Endpoint byte count                                                */
            uint32_t            : 20;
      __IOM uint32_t ENDP_STATE : 2;            /*!< [30..29] Endpoint Handshake State                                         */
      __IOM uint32_t ENDP_EN    : 1;            /*!< [31..31] Endpoint 4 Function enable bit                                   */
    } EP4CTL_b;
  } ;
  
  union {
    __IOM uint32_t EP5CTL;                      /*!< (@ 0x0000002C) Offset:0x2C USB Endpoint 5 Control Register                */
    
    struct {
      __IOM uint32_t ENDP_CNT   : 9;            /*!< [8..0] Endpoint byte count                                                */
            uint32_t            : 20;
      __IOM uint32_t ENDP_STATE : 2;            /*!< [30..29] Endpoint Handshake State                                         */
      __IOM uint32_t ENDP_EN    : 1;            /*!< [31..31] Endpoint 5 Function enable bit                                   */
    } EP5CTL_b;
  } ;
  
  union {
    __IOM uint32_t EP6CTL;                      /*!< (@ 0x00000030) Offset:0x30 USB Endpoint 6 Control Register                */
    
    struct {
      __IOM uint32_t ENDP_CNT   : 9;            /*!< [8..0] Endpoint byte count                                                */
            uint32_t            : 20;
      __IOM uint32_t ENDP_STATE : 2;            /*!< [30..29] Endpoint Handshake State                                         */
      __IOM uint32_t ENDP_EN    : 1;            /*!< [31..31] Endpoint 6 Function enable bit                                   */
    } EP6CTL_b;
  } ;
  __IM  uint32_t  RESERVED[2];
  
  union {
    __IOM uint32_t EPTOGGLE;                    /*!< (@ 0x0000003C) Offset:0x3C USB Endpoint Data Toggle Register              */
    
    struct {
      __IOM uint32_t ENDP1_DATA01 : 1;          /*!< [0..0] Endpoint 1 data toggle bit                                         */
      __IOM uint32_t ENDP2_DATA01 : 1;          /*!< [1..1] Endpoint 2 data toggle bit                                         */
      __IOM uint32_t ENDP3_DATA01 : 1;          /*!< [2..2] Endpoint 3 data toggle bit                                         */
      __IOM uint32_t ENDP4_DATA01 : 1;          /*!< [3..3] Endpoint 4 data toggle bit                                         */
      __IOM uint32_t ENDP5_DATA01 : 1;          /*!< [4..4] Endpoint 5 data toggle bit                                         */
      __IOM uint32_t ENDP6_DATA01 : 1;          /*!< [5..5] Endpoint 6 data toggle bit                                         */
            uint32_t            : 26;
    } EPTOGGLE_b;
  } ;
  __IM  uint32_t  RESERVED1[2];
  
  union {
    __IOM uint32_t EP1BUFOS;                    /*!< (@ 0x00000048) Offset:0x48 USB Endpoint 1 Buffer Offset Register          */
    
    struct {
            uint32_t            : 2;
      __IOM uint32_t OFFSET     : 7;            /*!< [8..2] The offset address for endpoint data buffer                        */
            uint32_t            : 23;
    } EP1BUFOS_b;
  } ;
  
  union {
    __IOM uint32_t EP2BUFOS;                    /*!< (@ 0x0000004C) Offset:0x4C USB Endpoint 2 Buffer Offset Register          */
    
    struct {
            uint32_t            : 2;
      __IOM uint32_t OFFSET     : 7;            /*!< [8..2] The offset address for endpoint data buffer                        */
            uint32_t            : 23;
    } EP2BUFOS_b;
  } ;
  
  union {
    __IOM uint32_t EP3BUFOS;                    /*!< (@ 0x00000050) Offset:0x50 USB Endpoint 3 Buffer Offset Register          */
    
    struct {
            uint32_t            : 2;
      __IOM uint32_t OFFSET     : 7;            /*!< [8..2] The offset address for endpoint data buffer                        */
            uint32_t            : 23;
    } EP3BUFOS_b;
  } ;
  
  union {
    __IOM uint32_t EP4BUFOS;                    /*!< (@ 0x00000054) Offset:0x54 USB Endpoint 4 Buffer Offset Register          */
    
    struct {
            uint32_t            : 2;
      __IOM uint32_t OFFSET     : 7;            /*!< [8..2] The offset address for endpoint data buffer                        */
            uint32_t            : 23;
    } EP4BUFOS_b;
  } ;
  
  union {
    __IOM uint32_t EP5BUFOS;                    /*!< (@ 0x00000058) Offset:0x58 USB Endpoint 5 Buffer Offset Register          */
    
    struct {
            uint32_t            : 2;
      __IOM uint32_t OFFSET     : 7;            /*!< [8..2] The offset address for endpoint data buffer                        */
            uint32_t            : 23;
    } EP5BUFOS_b;
  } ;
  
  union {
    __IOM uint32_t EP6BUFOS;                    /*!< (@ 0x0000005C) Offset:0x5C USB Endpoint 6 Buffer Offset Register          */
    
    struct {
            uint32_t            : 2;
      __IOM uint32_t OFFSET     : 7;            /*!< [8..2] The offset address for endpoint data buffer                        */
            uint32_t            : 23;
    } EP6BUFOS_b;
  } ;
  
  union {
    __IM  uint32_t FRMNO;                       /*!< (@ 0x00000060) Offset:0x60 USB Frame Number Register                      */
    
    struct {
      __IOM uint32_t FRAME_NO   : 11;           /*!< [10..0] The 11-bit frame number of the SOF packet                         */
            uint32_t            : 21;
    } FRMNO_b;
  } ;
  
  union {
    __IOM uint32_t PHYPRM;                      /*!< (@ 0x00000064) Offset:0x64 USB PHY Parameter Register                     */
    
    struct {
            uint32_t            : 26;
      __IOM uint32_t PHY_PARAM  : 6;            /*!< [31..26] The USB PHY parameter value                                      */
    } PHYPRM_b;
  } ;
  __IM  uint32_t  RESERVED2[38];
  __IOM uint32_t  SRAM;                         /*!< (@ 0x00000100) Offset:0x100 USB SRAM starting address                     */
} SN_USB_Type;                                  /*!< Size = 260 (0x104)                                                        */



/* =========================================================================================================================== */
/* ================                                          SN_LCD                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief 4 x 32 LCD Driver (SN_LCD)
  */

typedef struct {                                /*!< (@ 0x40034000) SN_LCD Structure                                           */
  
  union {
    __IOM uint32_t CTRL;                        /*!< (@ 0x00000000) Offset:0x00 LCD Control register                           */
    
    struct {
      __IOM uint32_t LCDENB     : 1;            /*!< [0..0] LCD driver enable bit                                              */
      __IOM uint32_t ITB        : 1;            /*!< [1..1] Internal testing bit                                               */
      __IOM uint32_t LCDTYPE    : 2;            /*!< [3..2] LCD type control bit                                               */
      __IOM uint32_t BIAS       : 1;            /*!< [4..4] LCD bias selection                                                 */
      __IOM uint32_t SEGSEL1    : 1;            /*!< [5..5] SEG12~23 enable bit                                                */
      __IOM uint32_t SEGSEL2    : 1;            /*!< [6..6] SEG24~31 enable bit                                                */
            uint32_t            : 1;
      __IOM uint32_t DUTY       : 2;            /*!< [9..8] Duty selection                                                     */
      __IOM uint32_t LCDCLK     : 1;            /*!< [10..10] LCD clock source selection                                       */
      __IOM uint32_t LCDRATE    : 1;            /*!< [11..11] LCD clock rate                                                   */
            uint32_t            : 16;
      __IOM uint32_t DRIVEP     : 2;            /*!< [29..28] LCD panel driving ability                                        */
            uint32_t            : 2;
    } CTRL_b;
  } ;
  
  union {
    __IOM uint32_t CTRL1;                       /*!< (@ 0x00000004) Offset:0x04 LCD Control register 1                         */
    
    struct {
      __IOM uint32_t LCDBNK     : 1;            /*!< [0..0] LCD blank control bit                                              */
      __IOM uint32_t REF        : 2;            /*!< [2..1] Resistance selection for LCD Bias Voltage-division                 */
            uint32_t            : 25;
      __IOM uint32_t ITB        : 1;            /*!< [28..28] Internal testing bit                                             */
            uint32_t            : 3;
    } CTRL1_b;
  } ;
  
  union {
    __IOM uint32_t CCTRL1;                      /*!< (@ 0x00000008) Offset:0x08 LCD C-Type Control register 1                  */
    
    struct {
      __IOM uint32_t VCP        : 4;            /*!< [3..0] C-Type VLCD output voltage                                         */
            uint32_t            : 22;
      __IOM uint32_t IT2        : 2;            /*!< [27..26] Internal testing bits                                            */
      __IOM uint32_t IT1        : 2;            /*!< [29..28] Internal testing bits                                            */
            uint32_t            : 2;
    } CCTRL1_b;
  } ;
  
  union {
    __IOM uint32_t CCTRL2;                      /*!< (@ 0x0000000C) Offset:0x0C LCD C-Type Control register 2                  */
    
    struct {
            uint32_t            : 1;
      __IOM uint32_t IT         : 3;            /*!< [3..1] Internal testing bits                                              */
            uint32_t            : 28;
    } CCTRL2_b;
  } ;
  
  union {
    __IOM uint32_t FCC;                         /*!< (@ 0x00000010) Offset:0x10 LCD Frame Counter Control register             */
    
    struct {
      __IOM uint32_t FCENB      : 1;            /*!< [0..0] LCD frame counter enable bit                                       */
      __IOM uint32_t FCT        : 6;            /*!< [6..1] LCD frame counter threshold value                                  */
      __IOM uint32_t FCIE       : 1;            /*!< [7..7] LCD frame interrupt enable bit                                     */
            uint32_t            : 24;
    } FCC_b;
  } ;
  
  union {
    __IOM uint32_t RIS;                         /*!< (@ 0x00000014) Offset:0x14 LCD Raw Interrupt Status register              */
    
    struct {
      __IOM uint32_t FCIF       : 1;            /*!< [0..0] LCD frame interrupt flag                                           */
            uint32_t            : 31;
    } RIS_b;
  } ;
  __IM  uint32_t  RESERVED[2];
  
  union {
    __IOM uint32_t SEGM0;                       /*!< (@ 0x00000020) Offset:0x20 LCD SEG Memory register 0                      */
    
    struct {
      __IOM uint32_t SEG0       : 4;            /*!< [3..0] SEG0 data for COM0~COM3                                            */
      __IOM uint32_t SEG1       : 4;            /*!< [7..4] SEG1 data for COM0~COM3                                            */
      __IOM uint32_t SEG2       : 4;            /*!< [11..8] SEG2 data for COM0~COM3                                           */
      __IOM uint32_t SEG3       : 4;            /*!< [15..12] SEG3 data for COM0~COM3                                          */
      __IOM uint32_t SEG4       : 4;            /*!< [19..16] SEG4 data for COM0~COM3                                          */
      __IOM uint32_t SEG5       : 4;            /*!< [23..20] SEG5 data for COM0~COM3                                          */
      __IOM uint32_t SEG6       : 4;            /*!< [27..24] SEG6 data for COM0~COM3                                          */
      __IOM uint32_t SEG7       : 4;            /*!< [31..28] SEG7 data for COM0~COM3                                          */
    } SEGM0_b;
  } ;
  
  union {
    __IOM uint32_t SEGM1;                       /*!< (@ 0x00000024) Offset:0x24 LCD SEG Memory register 1                      */
    
    struct {
      __IOM uint32_t SEG8       : 4;            /*!< [3..0] SEG8 data for COM0~COM3                                            */
      __IOM uint32_t SEG9       : 4;            /*!< [7..4] SEG9 data for COM0~COM3                                            */
      __IOM uint32_t SEG10      : 4;            /*!< [11..8] SEG10 data for COM0~COM3                                          */
      __IOM uint32_t SEG11      : 4;            /*!< [15..12] SEG11 data for COM0~COM3                                         */
      __IOM uint32_t SEG12      : 4;            /*!< [19..16] SEG12 data for COM0~COM3                                         */
      __IOM uint32_t SEG13      : 4;            /*!< [23..20] SEG13 data for COM0~COM3                                         */
      __IOM uint32_t SEG14      : 4;            /*!< [27..24] SEG14 data for COM0~COM3                                         */
      __IOM uint32_t SEG15      : 4;            /*!< [31..28] SEG15 data for COM0~COM3                                         */
    } SEGM1_b;
  } ;
  
  union {
    __IOM uint32_t SEGM2;                       /*!< (@ 0x00000028) Offset:0x28 LCD SEG Memory register 2                      */
    
    struct {
      __IOM uint32_t SEG16      : 4;            /*!< [3..0] SEG16 data for COM0~COM3                                           */
      __IOM uint32_t SEG17      : 4;            /*!< [7..4] SEG17 data for COM0~COM3                                           */
      __IOM uint32_t SEG18      : 4;            /*!< [11..8] SEG18 data for COM0~COM3                                          */
      __IOM uint32_t SEG19      : 4;            /*!< [15..12] SEG19 data for COM0~COM3                                         */
      __IOM uint32_t SEG20      : 4;            /*!< [19..16] SEG20 data for COM0~COM3                                         */
      __IOM uint32_t SEG21      : 4;            /*!< [23..20] SEG21 data for COM0~COM3                                         */
      __IOM uint32_t SEG22      : 4;            /*!< [27..24] SEG22 data for COM0~COM3                                         */
      __IOM uint32_t SEG23      : 4;            /*!< [31..28] SEG23 data for COM0~COM3                                         */
    } SEGM2_b;
  } ;
  
  union {
    __IOM uint32_t SEGM3;                       /*!< (@ 0x0000002C) Offset:0x2C LCD SEG Memory register 3                      */
    
    struct {
      __IOM uint32_t SEG24      : 4;            /*!< [3..0] SEG24 data for COM0~COM3                                           */
      __IOM uint32_t SEG25      : 4;            /*!< [7..4] SEG25 data for COM0~COM3                                           */
      __IOM uint32_t SEG26      : 4;            /*!< [11..8] SEG26 data for COM0~COM3                                          */
      __IOM uint32_t SEG27      : 4;            /*!< [15..12] SEG27 data for COM0~COM3                                         */
      __IOM uint32_t SEG28      : 4;            /*!< [19..16] SEG28 data for COM0~COM3                                         */
      __IOM uint32_t SEG29      : 4;            /*!< [23..20] SEG29 data for COM0~COM3                                         */
      __IOM uint32_t SEG30      : 4;            /*!< [27..24] SEG30 data for COM0~COM3                                         */
      __IOM uint32_t SEG31      : 4;            /*!< [31..28] SEG31 data for COM0~COM3                                         */
    } SEGM3_b;
  } ;
} SN_LCD_Type;                                  /*!< Size = 48 (0x30)                                                          */



/* =========================================================================================================================== */
/* ================                                           SN_UC                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief UC Registers (SN_UC)
  */

typedef struct {                                /*!< (@ 0x1FFF2C08) SN_UC Structure                                            */
  __IM  uint32_t  L4BYTE;                       /*!< (@ 0x00000000) Offset:0x00 UC Low 4 Byte Register                         */
  __IM  uint32_t  H4BYTE;                       /*!< (@ 0x00000004) Offset:0x04 UC High 4 Byte Register                        */
} SN_UC_Type;                                   /*!< Size = 8 (0x8)                                                            */


/** @} */ /* End of group Device_Peripheral_peripherals */


/* =========================================================================================================================== */
/* ================                          Device Specific Peripheral Address Map                           ================ */
/* =========================================================================================================================== */


/** @addtogroup Device_Peripheral_peripheralAddr
  * @{
  */

#define SN_SYS0_BASE                0x40060000UL
#define SN_SYS1_BASE                0x4005E000UL
#define SN_GPIO0_BASE               0x40044000UL
#define SN_GPIO1_BASE               0x40046000UL
#define SN_GPIO3_BASE               0x4004A000UL
#define SN_GPIO2_BASE               0x40048000UL
#define SN_ADC_BASE                 0x40026000UL
#define SN_WDT_BASE                 0x40010000UL
#define SN_RTC_BASE                 0x40012000UL
#define SN_CT16B0_BASE              0x40000000UL
#define SN_CT16B1_BASE              0x40002000UL
#define SN_CT16B2_BASE              0x40004000UL
#define SN_CT32B0_BASE              0x40006000UL
#define SN_CT32B1_BASE              0x40008000UL
#define SN_CT32B2_BASE              0x4000A000UL
#define SN_PMU_BASE                 0x40032000UL
#define SN_SSP0_BASE                0x4001C000UL
#define SN_SSP1_BASE                0x40058000UL
#define SN_I2C0_BASE                0x40018000UL
#define SN_I2C1_BASE                0x4005A000UL
#define SN_USART0_BASE              0x40016000UL
#define SN_USART1_BASE              0x40056000UL
#define SN_I2S_BASE                 0x4001A000UL
#define SN_FLASH_BASE               0x40062000UL
#define SN_PFPA_BASE                0x40042000UL
#define SN_USB_BASE                 0x4005C000UL
#define SN_LCD_BASE                 0x40034000UL
#define SN_UC_BASE                  0x1FFF2C08UL

/** @} */ /* End of group Device_Peripheral_peripheralAddr */


/* =========================================================================================================================== */
/* ================                                  Peripheral declaration                                   ================ */
/* =========================================================================================================================== */


/** @addtogroup Device_Peripheral_declaration
  * @{
  */

#define SN_SYS0                     ((SN_SYS0_Type*)           SN_SYS0_BASE)
#define SN_SYS1                     ((SN_SYS1_Type*)           SN_SYS1_BASE)
#define SN_GPIO0                    ((SN_GPIO0_Type*)          SN_GPIO0_BASE)
#define SN_GPIO1                    ((SN_GPIO0_Type*)          SN_GPIO1_BASE)
#define SN_GPIO3                    ((SN_GPIO0_Type*)          SN_GPIO3_BASE)
#define SN_GPIO2                    ((SN_GPIO2_Type*)          SN_GPIO2_BASE)
#define SN_ADC                      ((SN_ADC_Type*)            SN_ADC_BASE)
#define SN_WDT                      ((SN_WDT_Type*)            SN_WDT_BASE)
#define SN_RTC                      ((SN_RTC_Type*)            SN_RTC_BASE)
#define SN_CT16B0                   ((SN_CT16B0_Type*)         SN_CT16B0_BASE)
#define SN_CT16B1                   ((SN_CT16B0_Type*)         SN_CT16B1_BASE)
#define SN_CT16B2                   ((SN_CT16B0_Type*)         SN_CT16B2_BASE)
#define SN_CT32B0                   ((SN_CT32B0_Type*)         SN_CT32B0_BASE)
#define SN_CT32B1                   ((SN_CT32B0_Type*)         SN_CT32B1_BASE)
#define SN_CT32B2                   ((SN_CT32B0_Type*)         SN_CT32B2_BASE)
#define SN_PMU                      ((SN_PMU_Type*)            SN_PMU_BASE)
#define SN_SSP0                     ((SN_SSP0_Type*)           SN_SSP0_BASE)
#define SN_SSP1                     ((SN_SSP0_Type*)           SN_SSP1_BASE)
#define SN_I2C0                     ((SN_I2C0_Type*)           SN_I2C0_BASE)
#define SN_I2C1                     ((SN_I2C0_Type*)           SN_I2C1_BASE)
#define SN_USART0                   ((SN_USART0_Type*)         SN_USART0_BASE)
#define SN_USART1                   ((SN_USART0_Type*)         SN_USART1_BASE)
#define SN_I2S                      ((SN_I2S_Type*)            SN_I2S_BASE)
#define SN_FLASH                    ((SN_FLASH_Type*)          SN_FLASH_BASE)
#define SN_PFPA                     ((SN_PFPA_Type*)           SN_PFPA_BASE)
#define SN_USB                      ((SN_USB_Type*)            SN_USB_BASE)
#define SN_LCD                      ((SN_LCD_Type*)            SN_LCD_BASE)
#define SN_UC                       ((SN_UC_Type*)             SN_UC_BASE)

/** @} */ /* End of group Device_Peripheral_declaration */


/* =========================================  End of section using anonymous unions  ========================================= */
#if defined (__CC_ARM)
  #pragma pop
#elif defined (__ICCARM__)
  /* leave anonymous unions enabled */
#elif defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
  #pragma clang diagnostic pop
#elif defined (__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined (__TMS470__)
  /* anonymous unions are enabled by default */
#elif defined (__TASKING__)
  #pragma warning restore
#elif defined (__CSMC__)
  /* anonymous unions are enabled by default */
#endif


#ifdef __cplusplus
}
#endif

#endif /* SN32F240_H */


/** @} */ /* End of group SN32F240 */

/** @} */ /* End of group SONiX Technology Co., Ltd. */
