/*
 * ARM Limited (ARM) is supplying this software for use with Cortex-M
 * processor based microcontroller, but can be equally used for other
 * suitable processor architectures. This file can be freely distributed.
 * Modifications to this file shall be clearly marked.
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS". NO WARRANTIES, WHETHER EXPRESS, IMPLIED
 * OR STATUTORY, INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE.
 * ARM SHALL NOT, IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, OR
 * CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
 *
 * @file     SN32F290.h
 * @brief    CMSIS HeaderFile
 * @version  0.65
 * @date     09. January 2022
 * @note     Generated by SVDConv V3.3.35 on Sunday, 09.01.2022 18:50:24
 *           from File 'SN32F290.svd',
 *           last modified on Tuesday, 01.09.2020 10:52:27
 */



/** @addtogroup SONiX Technology Co., Ltd.
  * @{
  */


/** @addtogroup SN32F290
  * @{
  */


#ifndef SN32F290_H
#define SN32F290_H

#ifdef __cplusplus
extern "C" {
#endif


/** @addtogroup Configuration_of_CMSIS
  * @{
  */



/* =========================================================================================================================== */
/* ================                                Interrupt Number Definition                                ================ */
/* =========================================================================================================================== */

typedef enum {
/* =======================================  ARM Cortex-M0 Specific Interrupt Numbers  ======================================== */
  Reset_IRQn                = -15,              /*!< -15  Reset Vector, invoked on Power up and warm reset                     */
  NonMaskableInt_IRQn       = -14,              /*!< -14  Non maskable Interrupt, cannot be stopped or preempted               */
  HardFault_IRQn            = -13,              /*!< -13  Hard Fault, all classes of Fault                                     */
  SVCall_IRQn               =  -5,              /*!< -5 System Service Call via SVC instruction                                */
  PendSV_IRQn               =  -2,              /*!< -2 Pendable request for system service                                    */
  SysTick_IRQn              =  -1,              /*!< -1 System Tick Timer                                                      */
/* ==========================================  SN32F290 Specific Interrupt Numbers  ========================================== */
  NDT_IRQn                  =   0,              /*!< 0  Noise Detection                                                        */
  USB_IRQn                  =   1,              /*!< 1  USB                                                                    */
  LCD_IRQn                  =   2,              /*!< 2  LCD Driver                                                             */
  I2S0_IRQn                 =   3,              /*!< 3  I2S0                                                                   */
  I2S1_IRQn                 =   4,              /*!< 4  I2S1                                                                   */
  CMP3_IRQn                 =   5,              /*!< 5  CMP3                                                                   */
  SPI0_IRQn                 =   6,              /*!< 6  SPI0                                                                   */
  SPI1_IRQn                 =   7,              /*!< 7  SPI1                                                                   */
  UART2_IRQn                =   8,              /*!< 8  UART2                                                                  */
  UART3_IRQn                =   9,              /*!< 9  UART3                                                                  */
  I2C0_IRQn                 =  10,              /*!< 10 I2C0                                                                   */
  I2C1_IRQn                 =  11,              /*!< 11 I2C1                                                                   */
  CMP2_IRQn                 =  12,              /*!< 12 CMP2                                                                   */
  UART0_IRQn                =  13,              /*!< 13 UART0                                                                  */
  UART1_IRQn                =  14,              /*!< 14 UART1                                                                  */
  CT16B0_IRQn               =  15,              /*!< 15 16-bit Timer 0                                                         */
  CT16B1_IRQn               =  16,              /*!< 16 CT16B1                                                                 */
  CT16B2_IRQn               =  17,              /*!< 17 16-bit Timer 2                                                         */
  CMP1_IRQn                 =  18,              /*!< 18 CMP1                                                                   */
  CT16B3_IRQn               =  19,              /*!< 19 16-bit Timer 3                                                         */
  CT16B4_IRQn               =  20,              /*!< 20 16-bit Timer 4                                                         */
  CT16B5_IRQn               =  21,              /*!< 21 16-bit Timer 5                                                         */
  EBI_IRQn                  =  22,              /*!< 22 External Bus Interface                                                 */
  RTC_IRQn                  =  23,              /*!< 23 Real-time Clock                                                        */
  ADC_IRQn                  =  24,              /*!< 24 ADC                                                                    */
  WDT_IRQn                  =  25,              /*!< 25 Watchdog Timer                                                         */
  LVD_IRQn                  =  26,              /*!< 26 Low Voltage Detection                                                  */
  CMP0_IRQn                 =  27,              /*!< 27 CMP0                                                                   */
  P3_IRQn                   =  28,              /*!< 28 GPIO3                                                                  */
  P2_IRQn                   =  29,              /*!< 29 GPIO2                                                                  */
  P1_IRQn                   =  30,              /*!< 30 GPIO1                                                                  */
  P0_IRQn                   =  31               /*!< 31 GPIO0                                                                  */
} IRQn_Type;



/* =========================================================================================================================== */
/* ================                           Processor and Core Peripheral Section                           ================ */
/* =========================================================================================================================== */

/* ===========================  Configuration of the ARM Cortex-M0 Processor and Core Peripherals  =========================== */
#define __CM0_REV                 0x0000U       /*!< CM0 Core Revision                                                         */
#define __NVIC_PRIO_BITS               2        /*!< Number of Bits used for Priority Levels                                   */
#define __Vendor_SysTickConfig         0        /*!< Set to 1 if different SysTick Config is used                              */
#define __MPU_PRESENT                  0        /*!< MPU present                                                               */
#define __FPU_PRESENT                  0        /*!< FPU present                                                               */


/** @} */ /* End of group Configuration_of_CMSIS */

#include "core_cm0.h"                           /*!< ARM Cortex-M0 processor and core peripherals                              */
#include "system_SN32F2xx.h"                    /*!< SN32F290 System                                                           */

#ifndef __IM                                    /*!< Fallback for older CMSIS versions                                         */
  #define __IM   __I
#endif
#ifndef __OM                                    /*!< Fallback for older CMSIS versions                                         */
  #define __OM   __O
#endif
#ifndef __IOM                                   /*!< Fallback for older CMSIS versions                                         */
  #define __IOM  __IO
#endif


/* ========================================  Start of section using anonymous unions  ======================================== */
#if defined (__CC_ARM)
  #pragma push
  #pragma anon_unions
#elif defined (__ICCARM__)
  #pragma language=extended
#elif defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
  #pragma clang diagnostic push
  #pragma clang diagnostic ignored "-Wc11-extensions"
  #pragma clang diagnostic ignored "-Wreserved-id-macro"
  #pragma clang diagnostic ignored "-Wgnu-anonymous-struct"
  #pragma clang diagnostic ignored "-Wnested-anon-types"
#elif defined (__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined (__TMS470__)
  /* anonymous unions are enabled by default */
#elif defined (__TASKING__)
  #pragma warning 586
#elif defined (__CSMC__)
  /* anonymous unions are enabled by default */
#else
  #warning Not supported compiler type
#endif


/* =========================================================================================================================== */
/* ================                            Device Specific Peripheral Section                             ================ */
/* =========================================================================================================================== */


/** @addtogroup Device_Peripheral_peripherals
  * @{
  */



/* =========================================================================================================================== */
/* ================                                          SN_SYS0                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief System Control Registers 0 (SN_SYS0)
  */

typedef struct {                                /*!< (@ 0x40060000) SN_SYS0 Structure                                          */
  
  union {
    __IOM uint32_t ANBCTRL;                     /*!< (@ 0x00000000) Offset:0x00 Analog Block Control Register                  */
    
    struct {
      __IOM uint32_t IHRCEN     : 1;            /*!< [0..0] IHRC enable                                                        */
            uint32_t            : 1;
      __IOM uint32_t ELSEN      : 1;            /*!< [2..2] ELS XTAL enable                                                    */
            uint32_t            : 1;
      __IOM uint32_t EHSEN      : 1;            /*!< [4..4] EHS XTAL enable                                                    */
      __IOM uint32_t EHSFREQ    : 1;            /*!< [5..5] EHS XTAL frequency range                                           */
            uint32_t            : 26;
    } ANBCTRL_b;
  } ;
  
  union {
    __IOM uint32_t PLLCTRL;                     /*!< (@ 0x00000004) Offset:0x04 PLL Control Register                           */
    
    struct {
      __IOM uint32_t MSEL       : 3;            /*!< [2..0] M value                                                            */
            uint32_t            : 2;
      __IOM uint32_t PSEL       : 1;            /*!< [5..5] P value                                                            */
            uint32_t            : 6;
      __IOM uint32_t PLLCLKSEL  : 1;            /*!< [12..12] PLL clock source                                                 */
            uint32_t            : 2;
      __IOM uint32_t PLLEN      : 1;            /*!< [15..15] PLL enable                                                       */
            uint32_t            : 16;
    } PLLCTRL_b;
  } ;
  
  union {
    __IM  uint32_t CSST;                        /*!< (@ 0x00000008) Offset:0x08 Clock Source Status Register                   */
    
    struct {
      __IM  uint32_t IHRCRDY    : 1;            /*!< [0..0] IHRC ready flag                                                    */
            uint32_t            : 1;
      __IM  uint32_t ELSRDY     : 1;            /*!< [2..2] ELS XTAL ready flag                                                */
            uint32_t            : 1;
      __IM  uint32_t EHSRDY     : 1;            /*!< [4..4] EHS XTAL ready flag                                                */
            uint32_t            : 1;
      __IM  uint32_t PLLRDY     : 1;            /*!< [6..6] PLL ready flag                                                     */
            uint32_t            : 25;
    } CSST_b;
  } ;
  
  union {
    __IOM uint32_t CLKCFG;                      /*!< (@ 0x0000000C) Offset:0x0C System Clock Configuration Register            */
    
    struct {
      __IOM uint32_t SYSCLKSEL  : 3;            /*!< [2..0] System clock source selection                                      */
            uint32_t            : 1;
      __IM  uint32_t SYSCLKST   : 3;            /*!< [6..4] System clock switch status                                         */
            uint32_t            : 25;
    } CLKCFG_b;
  } ;
  
  union {
    __IOM uint32_t AHBCP;                       /*!< (@ 0x00000010) Offset:0x10 AHB Clock Prescale Register                    */
    
    struct {
      __IOM uint32_t AHBPRE     : 3;            /*!< [2..0] AHB clock source prescaler                                         */
      __IOM uint32_t DIV1P5     : 1;            /*!< [3..3] SYSCLK prescaler                                                   */
            uint32_t            : 28;
    } AHBCP_b;
  } ;
  
  union {
    __IOM uint32_t RSTST;                       /*!< (@ 0x00000014) Offset:0x14 System Reset Status Register                   */
    
    struct {
      __IOM uint32_t SWRSTF     : 1;            /*!< [0..0] Software reset flag                                                */
      __IOM uint32_t WDTRSTF    : 1;            /*!< [1..1] WDT reset flag                                                     */
      __IOM uint32_t LVDRSTF    : 1;            /*!< [2..2] LVD reset flag                                                     */
      __IOM uint32_t EXTRSTF    : 1;            /*!< [3..3] External reset flag                                                */
      __IOM uint32_t PORRSTF    : 1;            /*!< [4..4] POR reset flag                                                     */
            uint32_t            : 27;
    } RSTST_b;
  } ;
  
  union {
    __IOM uint32_t LVDCTRL;                     /*!< (@ 0x00000018) Offset:0x18 LVD Control Register                           */
    
    struct {
      __IOM uint32_t LVDRSTLVL  : 3;            /*!< [2..0] LVD reset level                                                    */
            uint32_t            : 1;
      __IOM uint32_t LVDINTLVL  : 3;            /*!< [6..4] LVD interrupt level                                                */
            uint32_t            : 7;
      __IOM uint32_t LVDRSTEN   : 1;            /*!< [14..14] LVD Reset enable                                                 */
      __IOM uint32_t LVDEN      : 1;            /*!< [15..15] LVD enable                                                       */
            uint32_t            : 16;
    } LVDCTRL_b;
  } ;
  
  union {
    __IOM uint32_t EXRSTCTRL;                   /*!< (@ 0x0000001C) Offset:0x1C External Reset Pin Control Register            */
    
    struct {
      __IOM uint32_t RESETDIS   : 1;            /*!< [0..0] External reset pin disable                                         */
            uint32_t            : 31;
    } EXRSTCTRL_b;
  } ;
  
  union {
    __IOM uint32_t SWDCTRL;                     /*!< (@ 0x00000020) Offset:0x20 SWD Pin Control Register                       */
    
    struct {
      __IOM uint32_t SWDDIS     : 1;            /*!< [0..0] SWD pin disable                                                    */
            uint32_t            : 31;
    } SWDCTRL_b;
  } ;
  
  union {
    __IOM uint32_t IVTM;                        /*!< (@ 0x00000024) Offset:0x24 Interrupt Vector Table Mapping register        */
    
    struct {
      __IOM uint32_t IVTM       : 3;            /*!< [2..0] Interrupt table mapping selection                                  */
            uint32_t            : 13;
      __OM  uint32_t IVTMKEY    : 16;           /*!< [31..16] IVTM register key                                                */
    } IVTM_b;
  } ;
  
  union {
    __IOM uint32_t NDTCTRL;                     /*!< (@ 0x00000028) Offset:0x28 Noise Detect Control Register                  */
    
    struct {
            uint32_t            : 1;
      __IOM uint32_t NDT5V_IE   : 1;            /*!< [1..1] NDT for VDD 5V interrupt enable bit                                */
            uint32_t            : 30;
    } NDTCTRL_b;
  } ;
  
  union {
    __IOM uint32_t NDTSTS;                      /*!< (@ 0x0000002C) Offset:0x2C Noise Detect Status Register                   */
    
    struct {
            uint32_t            : 1;
      __IOM uint32_t NDT5V_DET  : 1;            /*!< [1..1] Power noise status of NDT5V                                        */
            uint32_t            : 30;
    } NDTSTS_b;
  } ;
  __IM  uint32_t  RESERVED;
  
  union {
    __IOM uint32_t IHRCADJ;                     /*!< (@ 0x00000034) Offset:0x34 IHRC Frequency Adjustment register             */
    
    struct {
      __IOM uint32_t ADJEN      : 1;            /*!< [0..0] IHRC frequency adjustment enable bit                               */
      __IOM uint32_t DIR        : 1;            /*!< [1..1] IHRC frequency adjusting direction bit                             */
            uint32_t            : 2;
      __IOM uint32_t ADJ        : 8;            /*!< [11..4] IHRC frequency adjusting bits                                     */
            uint32_t            : 4;
      __OM  uint32_t SYSKEY     : 16;           /*!< [31..16] System register key                                              */
    } IHRCADJ_b;
  } ;
} SN_SYS0_Type;                                 /*!< Size = 56 (0x38)                                                          */



/* =========================================================================================================================== */
/* ================                                          SN_SYS1                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief System Control Registers 1 (SN_SYS1)
  */

typedef struct {                                /*!< (@ 0x4005E000) SN_SYS1 Structure                                          */
  
  union {
    __IOM uint32_t AHBCLKEN;                    /*!< (@ 0x00000000) Offset:0x00 AHB Clock Enable Register                      */
    
    struct {
            uint32_t            : 3;
      __IOM uint32_t OPACLKEN   : 1;            /*!< [3..3] Enable AHB clock for OPA                                           */
      __IOM uint32_t USBCLKEN   : 1;            /*!< [4..4] Enable AHB clock for USB                                           */
      __IOM uint32_t CT16B0CLKEN : 1;           /*!< [5..5] Enable AHB clock for CT16B0                                        */
      __IOM uint32_t CT16B1CLKEN : 1;           /*!< [6..6] Enable AHB clock for CT16B1                                        */
      __IOM uint32_t CT16B2CLKEN : 1;           /*!< [7..7] Enable AHB clock for CT16B2                                        */
      __IOM uint32_t CT16B3CLKEN : 1;           /*!< [8..8] Enable AHB clock for CT16B3                                        */
      __IOM uint32_t CT16B4CLKEN : 1;           /*!< [9..9] Enable AHB clock for CT16B4                                        */
      __IOM uint32_t CT16B5CLKEN : 1;           /*!< [10..10] Enable AHB clock for CT16B5                                      */
      __IOM uint32_t ADCCLKEN   : 1;            /*!< [11..11] Enable AHB clock for ADC                                         */
      __IOM uint32_t SPI0CLKEN  : 1;            /*!< [12..12] Enable AHB clock for SPI0                                        */
      __IOM uint32_t SPI1CLKEN  : 1;            /*!< [13..13] Enable AHB clock for SPI1                                        */
      __IOM uint32_t CMPCLKEN   : 1;            /*!< [14..14] Enable AHB clock for CMP                                         */
      __IOM uint32_t EBICLKEN   : 1;            /*!< [15..15] Enable AHB clock for EBI                                         */
      __IOM uint32_t UART0CLKEN : 1;            /*!< [16..16] Enable AHB clock for UART0                                       */
      __IOM uint32_t UART1CLKEN : 1;            /*!< [17..17] Enable AHB clock for UART1                                       */
      __IOM uint32_t UART2CLKEN : 1;            /*!< [18..18] Enable AHB clock for UART2                                       */
      __IOM uint32_t UART3CLKEN : 1;            /*!< [19..19] Enable AHB clock for UART3                                       */
      __IOM uint32_t I2C1CLKEN  : 1;            /*!< [20..20] Enable AHB clock for I2C1                                        */
      __IOM uint32_t I2C0CLKEN  : 1;            /*!< [21..21] Enable AHB clock for I2C0                                        */
      __IOM uint32_t I2S0CLKEN  : 1;            /*!< [22..22] Enable AHB clock for I2S0                                        */
      __IOM uint32_t RTCCLKEN   : 1;            /*!< [23..23] Enable AHB clock for RTC                                         */
      __IOM uint32_t WDTCLKEN   : 1;            /*!< [24..24] Enable AHB clock for WDT                                         */
      __IOM uint32_t I2S1CLKEN  : 1;            /*!< [25..25] Enable AHB clock for I2S1                                        */
      __IOM uint32_t LCDCLKEN   : 1;            /*!< [26..26] Enable AHB clock for LCD                                         */
      __IOM uint32_t CRCCLKEN   : 1;            /*!< [27..27] Enable AHB clock for CRC                                         */
      __IOM uint32_t CLKOUTSEL  : 3;            /*!< [30..28] Clock output source selection                                    */
            uint32_t            : 1;
    } AHBCLKEN_b;
  } ;
  
  union {
    __IOM uint32_t APBCP0;                      /*!< (@ 0x00000004) Offset:0x04 APB Clock Prescale Register 0                  */
    
    struct {
            uint32_t            : 16;
      __IOM uint32_t ADCPRE     : 3;            /*!< [18..16] ADC APB clock source prescaler                                   */
            uint32_t            : 13;
    } APBCP0_b;
  } ;
  
  union {
    __IOM uint32_t APBCP1;                      /*!< (@ 0x00000008) Offset:0x08 APB Clock Prescale Register 1                  */
    
    struct {
            uint32_t            : 8;
      __OM  uint32_t I2C0PRE    : 3;            /*!< [10..8] I2C0 APB clock source prescaler                                   */
            uint32_t            : 1;
      __IOM uint32_t I2S0PRE    : 3;            /*!< [14..12] I2S0 APB clock source prescaler                                  */
      __IOM uint32_t I2S1PRE    : 3;            /*!< [17..15] I2S1 APB clock source prescaler                                  */
            uint32_t            : 2;
      __IOM uint32_t WDTPRE     : 3;            /*!< [22..20] WDT APB clock source prescaler                                   */
            uint32_t            : 1;
      __OM  uint32_t I2C1PRE    : 3;            /*!< [26..24] I2C1 APB clock source prescaler                                  */
            uint32_t            : 1;
      __IOM uint32_t CLKOUTPRE  : 3;            /*!< [30..28] CLKOUT APB clock source prescaler                                */
            uint32_t            : 1;
    } APBCP1_b;
  } ;
  __IM  uint32_t  RESERVED;
  
  union {
    __IOM uint32_t PRST;                        /*!< (@ 0x00000010) Offset:0x10 Peripheral Reset Register                      */
    
    struct {
      __IOM uint32_t GPIO0RST   : 1;            /*!< [0..0] GPIO0 Reset                                                        */
      __IOM uint32_t GPIO1RST   : 1;            /*!< [1..1] GPIO1 Reset                                                        */
      __IOM uint32_t GPIO2RST   : 1;            /*!< [2..2] GPIO2 Reset                                                        */
      __IOM uint32_t GPIO3RST   : 1;            /*!< [3..3] GPIO3 Reset                                                        */
      __IOM uint32_t EBIRST     : 1;            /*!< [4..4] EBI Reset                                                          */
      __IOM uint32_t CT16B0RST  : 1;            /*!< [5..5] CT16B0 Reset                                                       */
      __IOM uint32_t CT16B1RST  : 1;            /*!< [6..6] CT16B1 Reset                                                       */
      __IOM uint32_t CT16B2RST  : 1;            /*!< [7..7] CT16B2 Reset                                                       */
      __IOM uint32_t CT16B3RST  : 1;            /*!< [8..8] CT16B3 Reset                                                       */
      __IOM uint32_t CT16B4RST  : 1;            /*!< [9..9] CT16B4 Reset                                                       */
      __IOM uint32_t CT16B5RST  : 1;            /*!< [10..10] CT16B5 Reset                                                     */
      __IOM uint32_t ADCRST     : 1;            /*!< [11..11] ADC Reset                                                        */
      __IOM uint32_t SPI0RST    : 1;            /*!< [12..12] SPI0 Reset                                                       */
      __IOM uint32_t SPI1RST    : 1;            /*!< [13..13] SPI1 Reset                                                       */
      __IOM uint32_t CMPRST     : 1;            /*!< [14..14] CMP Reset                                                        */
      __IOM uint32_t LCDRST     : 1;            /*!< [15..15] LCD Reset                                                        */
      __IOM uint32_t UART0RST   : 1;            /*!< [16..16] UART0 Reset                                                      */
      __IOM uint32_t UART1RST   : 1;            /*!< [17..17] UART1 Reset                                                      */
      __IOM uint32_t UART2RST   : 1;            /*!< [18..18] UART2 Reset                                                      */
      __IOM uint32_t UART3RST   : 1;            /*!< [19..19] UART1 Reset                                                      */
      __IOM uint32_t I2C1RST    : 1;            /*!< [20..20] I2C1 Reset                                                       */
      __IOM uint32_t I2C0RST    : 1;            /*!< [21..21] I2C0 Reset                                                       */
      __IOM uint32_t I2S0RST    : 1;            /*!< [22..22] I2S0 Reset                                                       */
      __IOM uint32_t RTCRST     : 1;            /*!< [23..23] RTC Reset                                                        */
      __IOM uint32_t WDTRST     : 1;            /*!< [24..24] WDT Reset                                                        */
      __IOM uint32_t I2S1RST    : 1;            /*!< [25..25] I2S1 Reset                                                       */
      __IOM uint32_t CRCRST     : 1;            /*!< [26..26] CRC Reset                                                        */
      __IOM uint32_t USBRST     : 1;            /*!< [27..27] USB Reset                                                        */
      __IOM uint32_t OPARST     : 1;            /*!< [28..28] USB Reset                                                        */
            uint32_t            : 3;
    } PRST_b;
  } ;
} SN_SYS1_Type;                                 /*!< Size = 20 (0x14)                                                          */



/* =========================================================================================================================== */
/* ================                                          SN_PMU                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief Power Management Unit (SN_PMU)
  */

typedef struct {                                /*!< (@ 0x40032000) SN_PMU Structure                                           */
  __IM  uint32_t  RESERVED[16];
  
  union {
    __IOM uint32_t CTRL;                        /*!< (@ 0x00000040) Offset:0x40 PMU Control Register                           */
    
    struct {
      __IOM uint32_t MODE       : 3;            /*!< [2..0] Low Power mode selection                                           */
            uint32_t            : 29;
    } CTRL_b;
  } ;
} SN_PMU_Type;                                  /*!< Size = 68 (0x44)                                                          */



/* =========================================================================================================================== */
/* ================                                          SN_PFPA                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief Peripheral Function Pin Assignment (SN_PFPA)
  */

typedef struct {                                /*!< (@ 0x40042000) SN_PFPA Structure                                          */
  
  union {
    __IOM uint32_t CT16B0;                      /*!< (@ 0x00000000) Offset:0x00 PFPA for CT16B0 Register                       */
    
    struct {
      __IOM uint32_t PWM0       : 2;            /*!< [1..0] CT16B0_PWM0 assigned pin                                           */
      __IOM uint32_t PWM0N      : 2;            /*!< [3..2] CT16B0_PWM0N assigned pin                                          */
      __IOM uint32_t PWM1       : 2;            /*!< [5..4] CT16B0_PWM1 assigned pin                                           */
      __IOM uint32_t PWM1N      : 2;            /*!< [7..6] CT16B0_PWM1N assigned pin                                          */
      __IOM uint32_t PWM2       : 2;            /*!< [9..8] CT16B0_PWM2 assigned pin                                           */
      __IOM uint32_t PWM2N      : 2;            /*!< [11..10] CT16B0_PWM2N assigned pin                                        */
      __IOM uint32_t PWM3       : 2;            /*!< [13..12] CT16B0_PWM3 assigned pin                                         */
      __IOM uint32_t PWM3N      : 2;            /*!< [15..14] CT16B0_PWM3N assigned pin                                        */
            uint32_t            : 16;
    } CT16B0_b;
  } ;
  
  union {
    __IOM uint32_t CT16B1;                      /*!< (@ 0x00000004) Offset:0x04 PFPA for CT16B1 Register                       */
    
    struct {
      __IOM uint32_t PWM00      : 1;            /*!< [0..0] CT16B1_PWM00 assigned pin                                          */
      __IOM uint32_t PWM01      : 1;            /*!< [1..1] CT16B1_PWM01 assigned pin                                          */
      __IOM uint32_t PWM02      : 1;            /*!< [2..2] CT16B1_PWM02 assigned pin                                          */
      __IOM uint32_t PWM03      : 1;            /*!< [3..3] CT16B1_PWM03 assigned pin                                          */
      __IOM uint32_t PWM04      : 1;            /*!< [4..4] CT16B1_PWM04 assigned pin                                          */
      __IOM uint32_t PWM05      : 1;            /*!< [5..5] CT16B1_PWM05 assigned pin                                          */
      __IOM uint32_t PWM06      : 1;            /*!< [6..6] CT16B1_PWM06 assigned pin                                          */
      __IOM uint32_t PWM07      : 1;            /*!< [7..7] CT16B1_PWM07 assigned pin                                          */
      __IOM uint32_t PWM08      : 1;            /*!< [8..8] CT16B1_PWM08 assigned pin                                          */
      __IOM uint32_t PWM09      : 1;            /*!< [9..9] CT16B1_PWM09 assigned pin                                          */
      __IOM uint32_t PWM10      : 1;            /*!< [10..10] CT16B1_PWM10 assigned pin                                        */
      __IOM uint32_t PWM11      : 1;            /*!< [11..11] CT16B1_PWM11 assigned pin                                        */
            uint32_t            : 20;
    } CT16B1_b;
  } ;
  
  union {
    __IOM uint32_t UART;                        /*!< (@ 0x00000008) Offset:0x08 PFPA for UART Register                         */
    
    struct {
      __IOM uint32_t UTXD0      : 2;            /*!< [1..0] UTXD0 assigned pin                                                 */
      __IOM uint32_t URXD0      : 2;            /*!< [3..2] URXD0 assigned pin                                                 */
      __IOM uint32_t UTXD1      : 2;            /*!< [5..4] UTXD1 assigned pin                                                 */
      __IOM uint32_t URXD1      : 2;            /*!< [7..6] URXD1 assigned pin                                                 */
      __IOM uint32_t UTXD2      : 2;            /*!< [9..8] UTXD2 assigned pin                                                 */
      __IOM uint32_t URXD2      : 2;            /*!< [11..10] URXD2 assigned pin                                               */
      __IOM uint32_t UTXD3      : 2;            /*!< [13..12] UTXD3 assigned pin                                               */
      __IOM uint32_t URXD3      : 2;            /*!< [15..14] URXD3 assigned pin                                               */
            uint32_t            : 16;
    } UART_b;
  } ;
  
  union {
    __IOM uint32_t I2C;                         /*!< (@ 0x0000000C) Offset:0x0C PFPA for I2C Register                          */
    
    struct {
      __IOM uint32_t SDA0       : 2;            /*!< [1..0] SDA0 assigned pin                                                  */
      __IOM uint32_t SCL0       : 2;            /*!< [3..2] SCL0 assigned pin                                                  */
      __IOM uint32_t SDA1       : 2;            /*!< [5..4] SDA1 assigned pin                                                  */
      __IOM uint32_t SCL1       : 2;            /*!< [7..6] SCL1 assigned pin                                                  */
            uint32_t            : 24;
    } I2C_b;
  } ;
  
  union {
    __IOM uint32_t SPI;                         /*!< (@ 0x00000010) Offset:0x10 PFPA for SPI Register                          */
    
    struct {
      __IOM uint32_t MISO0      : 2;            /*!< [1..0] MISO0 assigned pin                                                 */
      __IOM uint32_t MOSI0      : 2;            /*!< [3..2] MOSI0 assigned pin                                                 */
      __IOM uint32_t SCK0       : 2;            /*!< [5..4] SCK0 assigned pin                                                  */
      __IOM uint32_t SEL0       : 2;            /*!< [7..6] SEL0 assigned pin                                                  */
      __IOM uint32_t MISO1      : 2;            /*!< [9..8] MISO1 assigned pin                                                 */
      __IOM uint32_t MOSI1      : 2;            /*!< [11..10] MOSI1 assigned pin                                               */
      __IOM uint32_t SCK1       : 2;            /*!< [13..12] SCK1 assigned pin                                                */
      __IOM uint32_t SEL1       : 2;            /*!< [15..14] SEL1 assigned pin                                                */
            uint32_t            : 16;
    } SPI_b;
  } ;
  
  union {
    __IOM uint32_t I2S;                         /*!< (@ 0x00000014) Offset:0x14 PFPA for I2S Register                          */
    
    struct {
      __IOM uint32_t MCLK0      : 2;            /*!< [1..0] MCLK0 assigned pin                                                 */
      __IOM uint32_t BCLK0      : 2;            /*!< [3..2] BCLK0 assigned pin                                                 */
      __IOM uint32_t WS0        : 2;            /*!< [5..4] WS0 assigned pin                                                   */
      __IOM uint32_t DOUT0      : 2;            /*!< [7..6] DOUT0 assigned pin                                                 */
      __IOM uint32_t DIN0       : 2;            /*!< [9..8] DIN0 assigned pin                                                  */
      __IOM uint32_t MCLK1      : 2;            /*!< [11..10] MCLK1 assigned pin                                               */
      __IOM uint32_t BCLK1      : 2;            /*!< [13..12] BCLK1 assigned pin                                               */
      __IOM uint32_t WS1        : 2;            /*!< [15..14] WS1 assigned pin                                                 */
      __IOM uint32_t DOUT1      : 2;            /*!< [17..16] DOUT1 assigned pin                                               */
      __IOM uint32_t DIN1       : 2;            /*!< [19..18] DIN1 assigned pin                                                */
            uint32_t            : 12;
    } I2S_b;
  } ;
  
  union {
    __IOM uint32_t CT16B2;                      /*!< (@ 0x00000018) Offset:0x18 PFPA for CT16B2 Register                       */
    
    struct {
      __IOM uint32_t PWM0       : 2;            /*!< [1..0] CT16B2_PWM0 assigned pin                                           */
      __IOM uint32_t PWM1       : 2;            /*!< [3..2] CT16B2_PWM1 assigned pin                                           */
      __IOM uint32_t PWM2       : 2;            /*!< [5..4] CT16B2_PWM2 assigned pin                                           */
      __IOM uint32_t PWM3       : 2;            /*!< [7..6] CT16B2_PWM3 assigned pin                                           */
            uint32_t            : 24;
    } CT16B2_b;
  } ;
  
  union {
    __IOM uint32_t CT16B3;                      /*!< (@ 0x0000001C) Offset:0x1C PFPA for CT16B3 Register                       */
    
    struct {
      __IOM uint32_t PWM0       : 2;            /*!< [1..0] CT16B3_PWM0 assigned pin                                           */
      __IOM uint32_t PWM0N      : 2;            /*!< [3..2] CT16B3_PWM0N assigned pin                                          */
      __IOM uint32_t PWM1       : 2;            /*!< [5..4] CT16B3_PWM1 assigned pin                                           */
      __IOM uint32_t PWM1N      : 2;            /*!< [7..6] CT16B0_PWM1N assigned pin                                          */
            uint32_t            : 24;
    } CT16B3_b;
  } ;
  
  union {
    __IOM uint32_t CT16B4;                      /*!< (@ 0x00000020) Offset:0x20 PFPA for CT16B4 Register                       */
    
    struct {
      __IOM uint32_t PWM0       : 2;            /*!< [1..0] CT16B4_PWM0 assigned pin                                           */
      __IOM uint32_t PWM0N      : 2;            /*!< [3..2] CT16B4_PWM0N assigned pin                                          */
      __IOM uint32_t PWM1       : 2;            /*!< [5..4] CT16B4_PWM1 assigned pin                                           */
      __IOM uint32_t PWM1N      : 2;            /*!< [7..6] CT16B4_PWM1N assigned pin                                          */
            uint32_t            : 24;
    } CT16B4_b;
  } ;
  
  union {
    __IOM uint32_t CT16B5;                      /*!< (@ 0x00000024) Offset:0x24 PFPA for CT16B5 Register                       */
    
    struct {
      __IOM uint32_t PWM0       : 2;            /*!< [1..0] CT16B5_PWM0 assigned pin                                           */
      __IOM uint32_t PWM1       : 2;            /*!< [3..2] CT16B5_PWM1 assigned pin                                           */
      __IOM uint32_t PWM2       : 2;            /*!< [5..4] CT16B5_PWM2 assigned pin                                           */
      __IOM uint32_t PWM3       : 2;            /*!< [7..6] CT16B5_PWM3 assigned pin                                           */
            uint32_t            : 24;
    } CT16B5_b;
  } ;
} SN_PFPA_Type;                                 /*!< Size = 40 (0x28)                                                          */



/* =========================================================================================================================== */
/* ================                                         SN_GPIO1                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief General Purpose I/O (SN_GPIO1)
  */

typedef struct {                                /*!< (@ 0x40046000) SN_GPIO1 Structure                                         */
  
  union {
    __IOM uint32_t DATA;                        /*!< (@ 0x00000000) Offset:0x00 GPIO Port n Data Register                      */
    
    struct {
      __IOM uint32_t DATA0      : 1;            /*!< [0..0] Data of Pn.0                                                       */
      __IOM uint32_t DATA1      : 1;            /*!< [1..1] Data of Pn.1                                                       */
      __IOM uint32_t DATA2      : 1;            /*!< [2..2] Data of Pn.2                                                       */
      __IOM uint32_t DATA3      : 1;            /*!< [3..3] Data of Pn.3                                                       */
      __IOM uint32_t DATA4      : 1;            /*!< [4..4] Data of Pn.4                                                       */
      __IOM uint32_t DATA5      : 1;            /*!< [5..5] Data of Pn.5                                                       */
      __IOM uint32_t DATA6      : 1;            /*!< [6..6] Data of Pn.6                                                       */
      __IOM uint32_t DATA7      : 1;            /*!< [7..7] Data of Pn.7                                                       */
      __IOM uint32_t DATA8      : 1;            /*!< [8..8] Data of Pn.8                                                       */
      __IOM uint32_t DATA9      : 1;            /*!< [9..9] Data of Pn.9                                                       */
      __IOM uint32_t DATA10     : 1;            /*!< [10..10] Data of Pn.10                                                    */
      __IOM uint32_t DATA11     : 1;            /*!< [11..11] Data of Pn.11                                                    */
      __IOM uint32_t DATA12     : 1;            /*!< [12..12] Data of Pn.12                                                    */
      __IOM uint32_t DATA13     : 1;            /*!< [13..13] Data of Pn.13                                                    */
      __IOM uint32_t DATA14     : 1;            /*!< [14..14] Data of Pn.14                                                    */
      __IOM uint32_t DATA15     : 1;            /*!< [15..15] Data of Pn.15                                                    */
      __IOM uint32_t DATA16     : 1;            /*!< [16..16] Data of Pn.16                                                    */
      __IOM uint32_t DATA17     : 1;            /*!< [17..17] Data of Pn.17                                                    */
      __IOM uint32_t DATA18     : 1;            /*!< [18..18] Data of Pn.18                                                    */
      __IOM uint32_t DATA19     : 1;            /*!< [19..19] Data of Pn.19                                                    */
            uint32_t            : 12;
    } DATA_b;
  } ;
  
  union {
    __IOM uint32_t MODE;                        /*!< (@ 0x00000004) Offset:0x04 GPIO Port n Mode Register                      */
    
    struct {
      __IOM uint32_t MODE0      : 1;            /*!< [0..0] Mode of Pn.0                                                       */
      __IOM uint32_t MODE1      : 1;            /*!< [1..1] Mode of Pn.1                                                       */
      __IOM uint32_t MODE2      : 1;            /*!< [2..2] Mode of Pn.2                                                       */
      __IOM uint32_t MODE3      : 1;            /*!< [3..3] Mode of Pn.3                                                       */
      __IOM uint32_t MODE4      : 1;            /*!< [4..4] Mode of Pn.4                                                       */
      __IOM uint32_t MODE5      : 1;            /*!< [5..5] Mode of Pn.5                                                       */
      __IOM uint32_t MODE6      : 1;            /*!< [6..6] Mode of Pn.6                                                       */
      __IOM uint32_t MODE7      : 1;            /*!< [7..7] Mode of Pn.7                                                       */
      __IOM uint32_t MODE8      : 1;            /*!< [8..8] Mode of Pn.8                                                       */
      __IOM uint32_t MODE9      : 1;            /*!< [9..9] Mode of Pn.9                                                       */
      __IOM uint32_t MODE10     : 1;            /*!< [10..10] Mode of Pn.10                                                    */
      __IOM uint32_t MODE11     : 1;            /*!< [11..11] Mode of Pn.11                                                    */
      __IOM uint32_t MODE12     : 1;            /*!< [12..12] Mode of Pn.12                                                    */
      __IOM uint32_t MODE13     : 1;            /*!< [13..13] Mode of Pn.13                                                    */
      __IOM uint32_t MODE14     : 1;            /*!< [14..14] Mode of Pn.14                                                    */
      __IOM uint32_t MODE15     : 1;            /*!< [15..15] Mode of Pn.15                                                    */
      __IOM uint32_t MODE16     : 1;            /*!< [16..16] Mode of Pn.16                                                    */
      __IOM uint32_t MODE17     : 1;            /*!< [17..17] Mode of Pn.17                                                    */
      __IOM uint32_t MODE18     : 1;            /*!< [18..18] Mode of Pn.18                                                    */
      __IOM uint32_t MODE19     : 1;            /*!< [19..19] Mode of Pn.19                                                    */
            uint32_t            : 12;
    } MODE_b;
  } ;
  
  union {
    __IOM uint32_t CFG;                         /*!< (@ 0x00000008) Offset:0x08 GPIO Port n Configuration Register             */
    
    struct {
      __IOM uint32_t CFG0       : 2;            /*!< [1..0] Configuration of Pn.0                                              */
      __IOM uint32_t CFG1       : 2;            /*!< [3..2] Configuration of Pn.1                                              */
      __IOM uint32_t CFG2       : 2;            /*!< [5..4] Configuration of Pn.2                                              */
      __IOM uint32_t CFG3       : 2;            /*!< [7..6] Configuration of Pn.3                                              */
      __IOM uint32_t CFG4       : 2;            /*!< [9..8] Configuration of Pn.4                                              */
      __IOM uint32_t CFG5       : 2;            /*!< [11..10] Configuration of Pn.5                                            */
      __IOM uint32_t CFG6       : 2;            /*!< [13..12] Configuration of Pn.6                                            */
      __IOM uint32_t CFG7       : 2;            /*!< [15..14] Configuration of Pn.7                                            */
      __IOM uint32_t CFG8       : 2;            /*!< [17..16] Configuration of Pn.8                                            */
      __IOM uint32_t CFG9       : 2;            /*!< [19..18] Configuration of Pn.9                                            */
      __IOM uint32_t CFG10      : 2;            /*!< [21..20] Configuration of Pn.10                                           */
      __IOM uint32_t CFG11      : 2;            /*!< [23..22] Configuration of Pn.11                                           */
      __IOM uint32_t CFG12      : 2;            /*!< [25..24] Configuration of Pn.12                                           */
      __IOM uint32_t CFG13      : 2;            /*!< [27..26] Configuration of Pn.13                                           */
      __IOM uint32_t CFG14      : 2;            /*!< [29..28] Configuration of Pn.14                                           */
      __IOM uint32_t CFG15      : 2;            /*!< [31..30] Configuration of Pn.15                                           */
    } CFG_b;
  } ;
  
  union {
    __IOM uint32_t IS;                          /*!< (@ 0x0000000C) Offset:0x0C GPIO Port n Interrupt Sense Register           */
    
    struct {
      __IOM uint32_t IS0        : 1;            /*!< [0..0] Interrupt on Pn.0 is event or edge sensitive                       */
      __IOM uint32_t IS1        : 1;            /*!< [1..1] Interrupt on Pn.1 is event or edge sensitive                       */
      __IOM uint32_t IS2        : 1;            /*!< [2..2] Interrupt on Pn.2 is event or edge sensitive                       */
      __IOM uint32_t IS3        : 1;            /*!< [3..3] Interrupt on Pn.3 is event or edge sensitive                       */
      __IOM uint32_t IS4        : 1;            /*!< [4..4] Interrupt on Pn.4 is event or edge sensitive                       */
      __IOM uint32_t IS5        : 1;            /*!< [5..5] Interrupt on Pn.5 is event or edge sensitive                       */
      __IOM uint32_t IS6        : 1;            /*!< [6..6] Interrupt on Pn.6 is event or edge sensitive                       */
      __IOM uint32_t IS7        : 1;            /*!< [7..7] Interrupt on Pn.7 is event or edge sensitive                       */
      __IOM uint32_t IS8        : 1;            /*!< [8..8] Interrupt on Pn.8 is event or edge sensitive                       */
      __IOM uint32_t IS9        : 1;            /*!< [9..9] Interrupt on Pn.9 is event or edge sensitive                       */
      __IOM uint32_t IS10       : 1;            /*!< [10..10] Interrupt on Pn.10 is event or edge sensitive                    */
      __IOM uint32_t IS11       : 1;            /*!< [11..11] Interrupt on Pn.11 is event or edge sensitive                    */
      __IOM uint32_t IS12       : 1;            /*!< [12..12] Interrupt on Pn.12 is event or edge sensitive                    */
      __IOM uint32_t IS13       : 1;            /*!< [13..13] Interrupt on Pn.13 is event or edge sensitive                    */
      __IOM uint32_t IS14       : 1;            /*!< [14..14] Interrupt on Pn.14 is event or edge sensitive                    */
      __IOM uint32_t IS15       : 1;            /*!< [15..15] Interrupt on Pn.15 is event or edge sensitive                    */
      __IOM uint32_t IS16       : 1;            /*!< [16..16] Interrupt on Pn.16 is event or edge sensitive                    */
      __IOM uint32_t IS17       : 1;            /*!< [17..17] Interrupt on Pn.17 is event or edge sensitive                    */
      __IOM uint32_t IS18       : 1;            /*!< [18..18] Interrupt on Pn.18 is event or edge sensitive                    */
      __IOM uint32_t IS19       : 1;            /*!< [19..19] Interrupt on Pn.19 is event or edge sensitive                    */
            uint32_t            : 12;
    } IS_b;
  } ;
  
  union {
    __IOM uint32_t IBS;                         /*!< (@ 0x00000010) Offset:0x10 GPIO Port n Interrupt Both-edge Sense
                                                                    Register                                                   */
    
    struct {
      __IOM uint32_t IBS0       : 1;            /*!< [0..0] Interrupt on Pn.0 is triggered ob both edges                       */
      __IOM uint32_t IBS1       : 1;            /*!< [1..1] Interrupt on Pn.1 is triggered ob both edges                       */
      __IOM uint32_t IBS2       : 1;            /*!< [2..2] Interrupt on Pn.2 is triggered ob both edges                       */
      __IOM uint32_t IBS3       : 1;            /*!< [3..3] Interrupt on Pn.3 is triggered ob both edges                       */
      __IOM uint32_t IBS4       : 1;            /*!< [4..4] Interrupt on Pn.4 is triggered ob both edges                       */
      __IOM uint32_t IBS5       : 1;            /*!< [5..5] Interrupt on Pn.5 is triggered ob both edges                       */
      __IOM uint32_t IBS6       : 1;            /*!< [6..6] Interrupt on Pn.6 is triggered ob both edges                       */
      __IOM uint32_t IBS7       : 1;            /*!< [7..7] Interrupt on Pn.7 is triggered ob both edges                       */
      __IOM uint32_t IBS8       : 1;            /*!< [8..8] Interrupt on Pn.8 is triggered ob both edges                       */
      __IOM uint32_t IBS9       : 1;            /*!< [9..9] Interrupt on Pn.9 is triggered ob both edges                       */
      __IOM uint32_t IBS10      : 1;            /*!< [10..10] Interrupt on Pn.10 is triggered ob both edges                    */
      __IOM uint32_t IBS11      : 1;            /*!< [11..11] Interrupt on Pn.11 is triggered ob both edges                    */
      __IOM uint32_t IBS12      : 1;            /*!< [12..12] Interrupt on Pn.12 is triggered ob both edges                    */
      __IOM uint32_t IBS13      : 1;            /*!< [13..13] Interrupt on Pn.13 is triggered ob both edges                    */
      __IOM uint32_t IBS14      : 1;            /*!< [14..14] Interrupt on Pn.14 is triggered ob both edges                    */
      __IOM uint32_t IBS15      : 1;            /*!< [15..15] Interrupt on Pn.15 is triggered ob both edges                    */
      __IOM uint32_t IBS16      : 1;            /*!< [16..16] Interrupt on Pn.16 is triggered ob both edges                    */
      __IOM uint32_t IBS17      : 1;            /*!< [17..17] Interrupt on Pn.17 is triggered ob both edges                    */
      __IOM uint32_t IBS18      : 1;            /*!< [18..18] Interrupt on Pn.18 is triggered ob both edges                    */
      __IOM uint32_t IBS19      : 1;            /*!< [19..19] Interrupt on Pn.19 is triggered ob both edges                    */
            uint32_t            : 12;
    } IBS_b;
  } ;
  
  union {
    __IOM uint32_t IEV;                         /*!< (@ 0x00000014) Offset:0x14 GPIO Port n Interrupt Event Register           */
    
    struct {
      __IOM uint32_t IEV0       : 1;            /*!< [0..0] Interrupt trigged evnet on Pn.0                                    */
      __IOM uint32_t IEV1       : 1;            /*!< [1..1] Interrupt trigged evnet on Pn.1                                    */
      __IOM uint32_t IEV2       : 1;            /*!< [2..2] Interrupt trigged evnet on Pn.2                                    */
      __IOM uint32_t IEV3       : 1;            /*!< [3..3] Interrupt trigged evnet on Pn.3                                    */
      __IOM uint32_t IEV4       : 1;            /*!< [4..4] Interrupt trigged evnet on Pn.4                                    */
      __IOM uint32_t IEV5       : 1;            /*!< [5..5] Interrupt trigged evnet on Pn.5                                    */
      __IOM uint32_t IEV6       : 1;            /*!< [6..6] Interrupt trigged evnet on Pn.6                                    */
      __IOM uint32_t IEV7       : 1;            /*!< [7..7] Interrupt trigged evnet on Pn.7                                    */
      __IOM uint32_t IEV8       : 1;            /*!< [8..8] Interrupt trigged evnet on Pn.8                                    */
      __IOM uint32_t IEV9       : 1;            /*!< [9..9] Interrupt trigged evnet on Pn.9                                    */
      __IOM uint32_t IEV10      : 1;            /*!< [10..10] Interrupt trigged evnet on Pn.10                                 */
      __IOM uint32_t IEV11      : 1;            /*!< [11..11] Interrupt trigged evnet on Pn.11                                 */
      __IOM uint32_t IEV12      : 1;            /*!< [12..12] Interrupt trigged evnet on Pn.12                                 */
      __IOM uint32_t IEV13      : 1;            /*!< [13..13] Interrupt trigged evnet on Pn.13                                 */
      __IOM uint32_t IEV14      : 1;            /*!< [14..14] Interrupt trigged evnet on Pn.14                                 */
      __IOM uint32_t IEV15      : 1;            /*!< [15..15] Interrupt trigged evnet on Pn.15                                 */
      __IOM uint32_t IEV16      : 1;            /*!< [16..16] Interrupt trigged evnet on Pn.16                                 */
      __IOM uint32_t IEV17      : 1;            /*!< [17..17] Interrupt trigged evnet on Pn.17                                 */
      __IOM uint32_t IEV18      : 1;            /*!< [18..18] Interrupt trigged evnet on Pn.18                                 */
      __IOM uint32_t IEV19      : 1;            /*!< [19..19] Interrupt trigged evnet on Pn.19                                 */
            uint32_t            : 12;
    } IEV_b;
  } ;
  
  union {
    __IOM uint32_t IE;                          /*!< (@ 0x00000018) Offset:0x18 GPIO Port n Interrupt Enable Register          */
    
    struct {
      __IOM uint32_t IE0        : 1;            /*!< [0..0] Interrupt on Pn.0 enable                                           */
      __IOM uint32_t IE1        : 1;            /*!< [1..1] Interrupt on Pn.1 enable                                           */
      __IOM uint32_t IE2        : 1;            /*!< [2..2] Interrupt on Pn.2 enable                                           */
      __IOM uint32_t IE3        : 1;            /*!< [3..3] Interrupt on Pn.3 enable                                           */
      __IOM uint32_t IE4        : 1;            /*!< [4..4] Interrupt on Pn.4 enable                                           */
      __IOM uint32_t IE5        : 1;            /*!< [5..5] Interrupt on Pn.5 enable                                           */
      __IOM uint32_t IE6        : 1;            /*!< [6..6] Interrupt on Pn.6 enable                                           */
      __IOM uint32_t IE7        : 1;            /*!< [7..7] Interrupt on Pn.7 enable                                           */
      __IOM uint32_t IE8        : 1;            /*!< [8..8] Interrupt on Pn.8 enable                                           */
      __IOM uint32_t IE9        : 1;            /*!< [9..9] Interrupt on Pn.9 enable                                           */
      __IOM uint32_t IE10       : 1;            /*!< [10..10] Interrupt on Pn.10 enable                                        */
      __IOM uint32_t IE11       : 1;            /*!< [11..11] Interrupt on Pn.11 enable                                        */
      __IOM uint32_t IE12       : 1;            /*!< [12..12] Interrupt on Pn.11 enable                                        */
      __IOM uint32_t IE13       : 1;            /*!< [13..13] Interrupt on Pn.13 enable                                        */
      __IOM uint32_t IE14       : 1;            /*!< [14..14] Interrupt on Pn.14 enable                                        */
      __IOM uint32_t IE15       : 1;            /*!< [15..15] Interrupt on Pn.15 enable                                        */
      __IOM uint32_t IE16       : 1;            /*!< [16..16] Interrupt on Pn.16 enable                                        */
      __IOM uint32_t IE17       : 1;            /*!< [17..17] Interrupt on Pn.17 enable                                        */
      __IOM uint32_t IE18       : 1;            /*!< [18..18] Interrupt on Pn.18 enable                                        */
      __IOM uint32_t IE19       : 1;            /*!< [19..19] Interrupt on Pn.19 enable                                        */
            uint32_t            : 12;
    } IE_b;
  } ;
  
  union {
    __IM  uint32_t RIS;                         /*!< (@ 0x0000001C) Offset:0x1C GPIO Port n Raw Interrupt Status
                                                                    Register                                                   */
    
    struct {
      __IM  uint32_t IF0        : 1;            /*!< [0..0] Pn.0 raw interrupt flag                                            */
      __IM  uint32_t IF1        : 1;            /*!< [1..1] Pn.1 raw interrupt flag                                            */
      __IM  uint32_t IF2        : 1;            /*!< [2..2] Pn.2 raw interrupt flag                                            */
      __IM  uint32_t IF3        : 1;            /*!< [3..3] Pn.3 raw interrupt flag                                            */
      __IM  uint32_t IF4        : 1;            /*!< [4..4] Pn.4 raw interrupt flag                                            */
      __IM  uint32_t IF5        : 1;            /*!< [5..5] Pn.5 raw interrupt flag                                            */
      __IM  uint32_t IF6        : 1;            /*!< [6..6] Pn.6 raw interrupt flag                                            */
      __IM  uint32_t IF7        : 1;            /*!< [7..7] Pn.7 raw interrupt flag                                            */
      __IM  uint32_t IF8        : 1;            /*!< [8..8] Pn.8 raw interrupt flag                                            */
      __IM  uint32_t IF9        : 1;            /*!< [9..9] Pn.9 raw interrupt flag                                            */
      __IM  uint32_t IF10       : 1;            /*!< [10..10] Pn.10 raw interrupt flag                                         */
      __IM  uint32_t IF11       : 1;            /*!< [11..11] Pn.11 raw interrupt flag                                         */
      __IM  uint32_t IF12       : 1;            /*!< [12..12] Pn.12 raw interrupt flag                                         */
      __IM  uint32_t IF13       : 1;            /*!< [13..13] Pn.13 raw interrupt flag                                         */
      __IM  uint32_t IF14       : 1;            /*!< [14..14] Pn.14 raw interrupt flag                                         */
      __IM  uint32_t IF15       : 1;            /*!< [15..15] Pn.15 raw interrupt flag                                         */
      __IM  uint32_t IF16       : 1;            /*!< [16..16] Pn.16 raw interrupt flag                                         */
      __IM  uint32_t IF17       : 1;            /*!< [17..17] Pn.17 raw interrupt flag                                         */
      __IM  uint32_t IF18       : 1;            /*!< [18..18] Pn.18 raw interrupt flag                                         */
      __IM  uint32_t IF19       : 1;            /*!< [19..19] Pn.19 raw interrupt flag                                         */
            uint32_t            : 12;
    } RIS_b;
  } ;
  
  union {
    __OM  uint32_t IC;                          /*!< (@ 0x00000020) Offset:0x20 GPIO Port n Interrupt Clear Register           */
    
    struct {
      __OM  uint32_t IC0        : 1;            /*!< [0..0] Pn.0 interrupt flag clear                                          */
      __OM  uint32_t IC1        : 1;            /*!< [1..1] Pn.1 interrupt flag clear                                          */
      __OM  uint32_t IC2        : 1;            /*!< [2..2] Pn.2 interrupt flag clear                                          */
      __OM  uint32_t IC3        : 1;            /*!< [3..3] Pn.3 interrupt flag clear                                          */
      __OM  uint32_t IC4        : 1;            /*!< [4..4] Pn.4 interrupt flag clear                                          */
      __OM  uint32_t IC5        : 1;            /*!< [5..5] Pn.5 interrupt flag clear                                          */
      __OM  uint32_t IC6        : 1;            /*!< [6..6] Pn.6 interrupt flag clear                                          */
      __OM  uint32_t IC7        : 1;            /*!< [7..7] Pn.7 interrupt flag clear                                          */
      __OM  uint32_t IC8        : 1;            /*!< [8..8] Pn.8 interrupt flag clear                                          */
      __OM  uint32_t IC9        : 1;            /*!< [9..9] Pn.9 interrupt flag clear                                          */
      __OM  uint32_t IC10       : 1;            /*!< [10..10] Pn.10 interrupt flag clear                                       */
      __OM  uint32_t IC11       : 1;            /*!< [11..11] Pn.11 interrupt flag clear                                       */
      __OM  uint32_t IC12       : 1;            /*!< [12..12] Pn.12 interrupt flag clear                                       */
      __OM  uint32_t IC13       : 1;            /*!< [13..13] Pn.13 interrupt flag clear                                       */
      __OM  uint32_t IC14       : 1;            /*!< [14..14] Pn.14 interrupt flag clear                                       */
      __OM  uint32_t IC15       : 1;            /*!< [15..15] Pn.15 interrupt flag clear                                       */
      __OM  uint32_t IC16       : 1;            /*!< [16..16] Pn.16 interrupt flag clear                                       */
      __OM  uint32_t IC17       : 1;            /*!< [17..17] Pn.17 interrupt flag clear                                       */
      __OM  uint32_t IC18       : 1;            /*!< [18..18] Pn.18 interrupt flag clear                                       */
      __OM  uint32_t IC19       : 1;            /*!< [19..19] Pn.19 interrupt flag clear                                       */
            uint32_t            : 12;
    } IC_b;
  } ;
  
  union {
    __OM  uint32_t BSET;                        /*!< (@ 0x00000024) Offset:0x24 GPIO Port n Bits Set Operation Register        */
    
    struct {
      __OM  uint32_t BSET0      : 1;            /*!< [0..0] Set Pn.0                                                           */
      __OM  uint32_t BSET1      : 1;            /*!< [1..1] Set Pn.1                                                           */
      __OM  uint32_t BSET2      : 1;            /*!< [2..2] Set Pn.2                                                           */
      __OM  uint32_t BSET3      : 1;            /*!< [3..3] Set Pn.3                                                           */
      __OM  uint32_t BSET4      : 1;            /*!< [4..4] Set Pn.4                                                           */
      __OM  uint32_t BSET5      : 1;            /*!< [5..5] Set Pn.5                                                           */
      __OM  uint32_t BSET6      : 1;            /*!< [6..6] Set Pn.6                                                           */
      __OM  uint32_t BSET7      : 1;            /*!< [7..7] Set Pn.7                                                           */
      __OM  uint32_t BSET8      : 1;            /*!< [8..8] Set Pn.8                                                           */
      __OM  uint32_t BSET9      : 1;            /*!< [9..9] Set Pn.9                                                           */
      __OM  uint32_t BSET10     : 1;            /*!< [10..10] Set Pn.10                                                        */
      __OM  uint32_t BSET11     : 1;            /*!< [11..11] Set Pn.11                                                        */
      __OM  uint32_t BSET12     : 1;            /*!< [12..12] Set Pn.12                                                        */
      __OM  uint32_t BSET13     : 1;            /*!< [13..13] Set Pn.13                                                        */
      __OM  uint32_t BSET14     : 1;            /*!< [14..14] Set Pn.14                                                        */
      __OM  uint32_t BSET15     : 1;            /*!< [15..15] Set Pn.15                                                        */
      __OM  uint32_t BSET16     : 1;            /*!< [16..16] Set Pn.16                                                        */
      __OM  uint32_t BSET17     : 1;            /*!< [17..17] Set Pn.17                                                        */
      __OM  uint32_t BSET18     : 1;            /*!< [18..18] Set Pn.18                                                        */
      __OM  uint32_t BSET19     : 1;            /*!< [19..19] Set Pn.19                                                        */
            uint32_t            : 12;
    } BSET_b;
  } ;
  
  union {
    __OM  uint32_t BCLR;                        /*!< (@ 0x00000028) Offset:0x28 GPIO Port n Bits Clear Operation
                                                                    Register                                                   */
    
    struct {
      __OM  uint32_t BCLR0      : 1;            /*!< [0..0] Clear Pn.0                                                         */
      __OM  uint32_t BCLR1      : 1;            /*!< [1..1] Clear Pn.1                                                         */
      __OM  uint32_t BCLR2      : 1;            /*!< [2..2] Clear Pn.2                                                         */
      __OM  uint32_t BCLR3      : 1;            /*!< [3..3] Clear Pn.3                                                         */
      __OM  uint32_t BCLR4      : 1;            /*!< [4..4] Clear Pn.4                                                         */
      __OM  uint32_t BCLR5      : 1;            /*!< [5..5] Clear Pn.5                                                         */
      __OM  uint32_t BCLR6      : 1;            /*!< [6..6] Clear Pn.6                                                         */
      __OM  uint32_t BCLR7      : 1;            /*!< [7..7] Clear Pn.7                                                         */
      __OM  uint32_t BCLR8      : 1;            /*!< [8..8] Clear Pn.8                                                         */
      __OM  uint32_t BCLR9      : 1;            /*!< [9..9] Clear Pn.9                                                         */
      __OM  uint32_t BCLR10     : 1;            /*!< [10..10] Clear Pn.10                                                      */
      __OM  uint32_t BCLR11     : 1;            /*!< [11..11] Clear Pn.11                                                      */
      __OM  uint32_t BCLR12     : 1;            /*!< [12..12] Clear Pn.12                                                      */
      __OM  uint32_t BCLR13     : 1;            /*!< [13..13] Clear Pn.13                                                      */
      __OM  uint32_t BCLR14     : 1;            /*!< [14..14] Clear Pn.14                                                      */
      __OM  uint32_t BCLR15     : 1;            /*!< [15..15] Clear Pn.15                                                      */
      __OM  uint32_t BCLR16     : 1;            /*!< [16..16] Clear Pn.16                                                      */
      __OM  uint32_t BCLR17     : 1;            /*!< [17..17] Clear Pn.17                                                      */
      __OM  uint32_t BCLR18     : 1;            /*!< [18..18] Clear Pn.18                                                      */
      __OM  uint32_t BCLR19     : 1;            /*!< [19..19] Clear Pn.19                                                      */
            uint32_t            : 12;
    } BCLR_b;
  } ;
  __IM  uint32_t  RESERVED;
  
  union {
    __IOM uint32_t CFG1;                        /*!< (@ 0x00000030) Offset:0x30 GPIO Port n Configuration Register
                                                                    1                                                          */
    
    struct {
      __IOM uint32_t CFG16      : 2;            /*!< [1..0] Configuration of Pn.16                                             */
      __IOM uint32_t CFG17      : 2;            /*!< [3..2] Configuration of Pn.17                                             */
      __IOM uint32_t CFG18      : 2;            /*!< [5..4] Configuration of Pn.18                                             */
      __IOM uint32_t CFG19      : 2;            /*!< [7..6] Configuration of Pn.19                                             */
            uint32_t            : 24;
    } CFG1_b;
  } ;
} SN_GPIO1_Type;                                /*!< Size = 52 (0x34)                                                          */



/* =========================================================================================================================== */
/* ================                                         SN_GPIO2                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief General Purpose I/O (SN_GPIO2)
  */

typedef struct {                                /*!< (@ 0x40048000) SN_GPIO2 Structure                                         */
  
  union {
    __IOM uint32_t DATA;                        /*!< (@ 0x00000000) Offset:0x00 GPIO Port n Data Register                      */
    
    struct {
      __IOM uint32_t DATA0      : 1;            /*!< [0..0] Data of Pn.0                                                       */
      __IOM uint32_t DATA1      : 1;            /*!< [1..1] Data of Pn.1                                                       */
      __IOM uint32_t DATA2      : 1;            /*!< [2..2] Data of Pn.2                                                       */
      __IOM uint32_t DATA3      : 1;            /*!< [3..3] Data of Pn.3                                                       */
      __IOM uint32_t DATA4      : 1;            /*!< [4..4] Data of Pn.4                                                       */
      __IOM uint32_t DATA5      : 1;            /*!< [5..5] Data of Pn.5                                                       */
      __IOM uint32_t DATA6      : 1;            /*!< [6..6] Data of Pn.6                                                       */
      __IOM uint32_t DATA7      : 1;            /*!< [7..7] Data of Pn.7                                                       */
      __IOM uint32_t DATA8      : 1;            /*!< [8..8] Data of Pn.8                                                       */
      __IOM uint32_t DATA9      : 1;            /*!< [9..9] Data of Pn.9                                                       */
      __IOM uint32_t DATA10     : 1;            /*!< [10..10] Data of Pn.10                                                    */
      __IOM uint32_t DATA11     : 1;            /*!< [11..11] Data of Pn.11                                                    */
      __IOM uint32_t DATA12     : 1;            /*!< [12..12] Data of Pn.12                                                    */
      __IOM uint32_t DATA13     : 1;            /*!< [13..13] Data of Pn.13                                                    */
      __IOM uint32_t DATA14     : 1;            /*!< [14..14] Data of Pn.14                                                    */
      __IOM uint32_t DATA15     : 1;            /*!< [15..15] Data of Pn.15                                                    */
            uint32_t            : 16;
    } DATA_b;
  } ;
  
  union {
    __IOM uint32_t MODE;                        /*!< (@ 0x00000004) Offset:0x04 GPIO Port n Mode Register                      */
    
    struct {
      __IOM uint32_t MODE0      : 1;            /*!< [0..0] Mode of Pn.0                                                       */
      __IOM uint32_t MODE1      : 1;            /*!< [1..1] Mode of Pn.1                                                       */
      __IOM uint32_t MODE2      : 1;            /*!< [2..2] Mode of Pn.2                                                       */
      __IOM uint32_t MODE3      : 1;            /*!< [3..3] Mode of Pn.3                                                       */
      __IOM uint32_t MODE4      : 1;            /*!< [4..4] Mode of Pn.4                                                       */
      __IOM uint32_t MODE5      : 1;            /*!< [5..5] Mode of Pn.5                                                       */
      __IOM uint32_t MODE6      : 1;            /*!< [6..6] Mode of Pn.6                                                       */
      __IOM uint32_t MODE7      : 1;            /*!< [7..7] Mode of Pn.7                                                       */
      __IOM uint32_t MODE8      : 1;            /*!< [8..8] Mode of Pn.8                                                       */
      __IOM uint32_t MODE9      : 1;            /*!< [9..9] Mode of Pn.9                                                       */
      __IOM uint32_t MODE10     : 1;            /*!< [10..10] Mode of Pn.10                                                    */
      __IOM uint32_t MODE11     : 1;            /*!< [11..11] Mode of Pn.11                                                    */
      __IOM uint32_t MODE12     : 1;            /*!< [12..12] Mode of Pn.12                                                    */
      __IOM uint32_t MODE13     : 1;            /*!< [13..13] Mode of Pn.13                                                    */
      __IOM uint32_t MODE14     : 1;            /*!< [14..14] Mode of Pn.14                                                    */
      __IOM uint32_t MODE15     : 1;            /*!< [15..15] Mode of Pn.15                                                    */
            uint32_t            : 16;
    } MODE_b;
  } ;
  
  union {
    __IOM uint32_t CFG;                         /*!< (@ 0x00000008) Offset:0x08 GPIO Port n Configuration Register             */
    
    struct {
      __IOM uint32_t CFG0       : 2;            /*!< [1..0] Configuration of Pn.0                                              */
      __IOM uint32_t CFG1       : 2;            /*!< [3..2] Configuration of Pn.1                                              */
      __IOM uint32_t CFG2       : 2;            /*!< [5..4] Configuration of Pn.2                                              */
      __IOM uint32_t CFG3       : 2;            /*!< [7..6] Configuration of Pn.3                                              */
      __IOM uint32_t CFG4       : 2;            /*!< [9..8] Configuration of Pn.4                                              */
      __IOM uint32_t CFG5       : 2;            /*!< [11..10] Configuration of Pn.5                                            */
      __IOM uint32_t CFG6       : 2;            /*!< [13..12] Configuration of Pn.6                                            */
      __IOM uint32_t CFG7       : 2;            /*!< [15..14] Configuration of Pn.7                                            */
      __IOM uint32_t CFG8       : 2;            /*!< [17..16] Configuration of Pn.8                                            */
      __IOM uint32_t CFG9       : 2;            /*!< [19..18] Configuration of Pn.9                                            */
      __IOM uint32_t CFG10      : 2;            /*!< [21..20] Configuration of Pn.10                                           */
      __IOM uint32_t CFG11      : 2;            /*!< [23..22] Configuration of Pn.11                                           */
      __IOM uint32_t CFG12      : 2;            /*!< [25..24] Configuration of Pn.12                                           */
      __IOM uint32_t CFG13      : 2;            /*!< [27..26] Configuration of Pn.13                                           */
      __IOM uint32_t CFG14      : 2;            /*!< [29..28] Configuration of Pn.14                                           */
      __IOM uint32_t CFG15      : 2;            /*!< [31..30] Configuration of Pn.15                                           */
    } CFG_b;
  } ;
  
  union {
    __IOM uint32_t IS;                          /*!< (@ 0x0000000C) Offset:0x0C GPIO Port n Interrupt Sense Register           */
    
    struct {
      __IOM uint32_t IS0        : 1;            /*!< [0..0] Interrupt on Pn.0 is event or edge sensitive                       */
      __IOM uint32_t IS1        : 1;            /*!< [1..1] Interrupt on Pn.1 is event or edge sensitive                       */
      __IOM uint32_t IS2        : 1;            /*!< [2..2] Interrupt on Pn.2 is event or edge sensitive                       */
      __IOM uint32_t IS3        : 1;            /*!< [3..3] Interrupt on Pn.3 is event or edge sensitive                       */
      __IOM uint32_t IS4        : 1;            /*!< [4..4] Interrupt on Pn.4 is event or edge sensitive                       */
      __IOM uint32_t IS5        : 1;            /*!< [5..5] Interrupt on Pn.5 is event or edge sensitive                       */
      __IOM uint32_t IS6        : 1;            /*!< [6..6] Interrupt on Pn.6 is event or edge sensitive                       */
      __IOM uint32_t IS7        : 1;            /*!< [7..7] Interrupt on Pn.7 is event or edge sensitive                       */
      __IOM uint32_t IS8        : 1;            /*!< [8..8] Interrupt on Pn.8 is event or edge sensitive                       */
      __IOM uint32_t IS9        : 1;            /*!< [9..9] Interrupt on Pn.9 is event or edge sensitive                       */
      __IOM uint32_t IS10       : 1;            /*!< [10..10] Interrupt on Pn.10 is event or edge sensitive                    */
      __IOM uint32_t IS11       : 1;            /*!< [11..11] Interrupt on Pn.11 is event or edge sensitive                    */
      __IOM uint32_t IS12       : 1;            /*!< [12..12] Interrupt on Pn.12 is event or edge sensitive                    */
      __IOM uint32_t IS13       : 1;            /*!< [13..13] Interrupt on Pn.13 is event or edge sensitive                    */
      __IOM uint32_t IS14       : 1;            /*!< [14..14] Interrupt on Pn.14 is event or edge sensitive                    */
      __IOM uint32_t IS15       : 1;            /*!< [15..15] Interrupt on Pn.15 is event or edge sensitive                    */
            uint32_t            : 16;
    } IS_b;
  } ;
  
  union {
    __IOM uint32_t IBS;                         /*!< (@ 0x00000010) Offset:0x10 GPIO Port n Interrupt Both-edge Sense
                                                                    Register                                                   */
    
    struct {
      __IOM uint32_t IBS0       : 1;            /*!< [0..0] Interrupt on Pn.0 is triggered ob both edges                       */
      __IOM uint32_t IBS1       : 1;            /*!< [1..1] Interrupt on Pn.1 is triggered ob both edges                       */
      __IOM uint32_t IBS2       : 1;            /*!< [2..2] Interrupt on Pn.2 is triggered ob both edges                       */
      __IOM uint32_t IBS3       : 1;            /*!< [3..3] Interrupt on Pn.3 is triggered ob both edges                       */
      __IOM uint32_t IBS4       : 1;            /*!< [4..4] Interrupt on Pn.4 is triggered ob both edges                       */
      __IOM uint32_t IBS5       : 1;            /*!< [5..5] Interrupt on Pn.5 is triggered ob both edges                       */
      __IOM uint32_t IBS6       : 1;            /*!< [6..6] Interrupt on Pn.6 is triggered ob both edges                       */
      __IOM uint32_t IBS7       : 1;            /*!< [7..7] Interrupt on Pn.7 is triggered ob both edges                       */
      __IOM uint32_t IBS8       : 1;            /*!< [8..8] Interrupt on Pn.8 is triggered ob both edges                       */
      __IOM uint32_t IBS9       : 1;            /*!< [9..9] Interrupt on Pn.9 is triggered ob both edges                       */
      __IOM uint32_t IBS10      : 1;            /*!< [10..10] Interrupt on Pn.10 is triggered ob both edges                    */
      __IOM uint32_t IBS11      : 1;            /*!< [11..11] Interrupt on Pn.11 is triggered ob both edges                    */
      __IOM uint32_t IBS12      : 1;            /*!< [12..12] Interrupt on Pn.12 is triggered ob both edges                    */
      __IOM uint32_t IBS13      : 1;            /*!< [13..13] Interrupt on Pn.13 is triggered ob both edges                    */
      __IOM uint32_t IBS14      : 1;            /*!< [14..14] Interrupt on Pn.14 is triggered ob both edges                    */
      __IOM uint32_t IBS15      : 1;            /*!< [15..15] Interrupt on Pn.15 is triggered ob both edges                    */
            uint32_t            : 16;
    } IBS_b;
  } ;
  
  union {
    __IOM uint32_t IEV;                         /*!< (@ 0x00000014) Offset:0x14 GPIO Port n Interrupt Event Register           */
    
    struct {
      __IOM uint32_t IEV0       : 1;            /*!< [0..0] Interrupt trigged evnet on Pn.0                                    */
      __IOM uint32_t IEV1       : 1;            /*!< [1..1] Interrupt trigged evnet on Pn.1                                    */
      __IOM uint32_t IEV2       : 1;            /*!< [2..2] Interrupt trigged evnet on Pn.2                                    */
      __IOM uint32_t IEV3       : 1;            /*!< [3..3] Interrupt trigged evnet on Pn.3                                    */
      __IOM uint32_t IEV4       : 1;            /*!< [4..4] Interrupt trigged evnet on Pn.4                                    */
      __IOM uint32_t IEV5       : 1;            /*!< [5..5] Interrupt trigged evnet on Pn.5                                    */
      __IOM uint32_t IEV6       : 1;            /*!< [6..6] Interrupt trigged evnet on Pn.6                                    */
      __IOM uint32_t IEV7       : 1;            /*!< [7..7] Interrupt trigged evnet on Pn.7                                    */
      __IOM uint32_t IEV8       : 1;            /*!< [8..8] Interrupt trigged evnet on Pn.8                                    */
      __IOM uint32_t IEV9       : 1;            /*!< [9..9] Interrupt trigged evnet on Pn.9                                    */
      __IOM uint32_t IEV10      : 1;            /*!< [10..10] Interrupt trigged evnet on Pn.10                                 */
      __IOM uint32_t IEV11      : 1;            /*!< [11..11] Interrupt trigged evnet on Pn.11                                 */
      __IOM uint32_t IEV12      : 1;            /*!< [12..12] Interrupt trigged evnet on Pn.12                                 */
      __IOM uint32_t IEV13      : 1;            /*!< [13..13] Interrupt trigged evnet on Pn.13                                 */
      __IOM uint32_t IEV14      : 1;            /*!< [14..14] Interrupt trigged evnet on Pn.14                                 */
      __IOM uint32_t IEV15      : 1;            /*!< [15..15] Interrupt trigged evnet on Pn.15                                 */
            uint32_t            : 16;
    } IEV_b;
  } ;
  
  union {
    __IOM uint32_t IE;                          /*!< (@ 0x00000018) Offset:0x18 GPIO Port n Interrupt Enable Register          */
    
    struct {
      __IOM uint32_t IE0        : 1;            /*!< [0..0] Interrupt on Pn.0 enable                                           */
      __IOM uint32_t IE1        : 1;            /*!< [1..1] Interrupt on Pn.1 enable                                           */
      __IOM uint32_t IE2        : 1;            /*!< [2..2] Interrupt on Pn.2 enable                                           */
      __IOM uint32_t IE3        : 1;            /*!< [3..3] Interrupt on Pn.3 enable                                           */
      __IOM uint32_t IE4        : 1;            /*!< [4..4] Interrupt on Pn.4 enable                                           */
      __IOM uint32_t IE5        : 1;            /*!< [5..5] Interrupt on Pn.5 enable                                           */
      __IOM uint32_t IE6        : 1;            /*!< [6..6] Interrupt on Pn.6 enable                                           */
      __IOM uint32_t IE7        : 1;            /*!< [7..7] Interrupt on Pn.7 enable                                           */
      __IOM uint32_t IE8        : 1;            /*!< [8..8] Interrupt on Pn.8 enable                                           */
      __IOM uint32_t IE9        : 1;            /*!< [9..9] Interrupt on Pn.9 enable                                           */
      __IOM uint32_t IE10       : 1;            /*!< [10..10] Interrupt on Pn.10 enable                                        */
      __IOM uint32_t IE11       : 1;            /*!< [11..11] Interrupt on Pn.11 enable                                        */
      __IOM uint32_t IE12       : 1;            /*!< [12..12] Interrupt on Pn.11 enable                                        */
      __IOM uint32_t IE13       : 1;            /*!< [13..13] Interrupt on Pn.13 enable                                        */
      __IOM uint32_t IE14       : 1;            /*!< [14..14] Interrupt on Pn.14 enable                                        */
      __IOM uint32_t IE15       : 1;            /*!< [15..15] Interrupt on Pn.15 enable                                        */
            uint32_t            : 16;
    } IE_b;
  } ;
  
  union {
    __IM  uint32_t RIS;                         /*!< (@ 0x0000001C) Offset:0x1C GPIO Port n Raw Interrupt Status
                                                                    Register                                                   */
    
    struct {
      __IM  uint32_t IF0        : 1;            /*!< [0..0] Pn.0 raw interrupt flag                                            */
      __IM  uint32_t IF1        : 1;            /*!< [1..1] Pn.1 raw interrupt flag                                            */
      __IM  uint32_t IF2        : 1;            /*!< [2..2] Pn.2 raw interrupt flag                                            */
      __IM  uint32_t IF3        : 1;            /*!< [3..3] Pn.3 raw interrupt flag                                            */
      __IM  uint32_t IF4        : 1;            /*!< [4..4] Pn.4 raw interrupt flag                                            */
      __IM  uint32_t IF5        : 1;            /*!< [5..5] Pn.5 raw interrupt flag                                            */
      __IM  uint32_t IF6        : 1;            /*!< [6..6] Pn.6 raw interrupt flag                                            */
      __IM  uint32_t IF7        : 1;            /*!< [7..7] Pn.7 raw interrupt flag                                            */
      __IM  uint32_t IF8        : 1;            /*!< [8..8] Pn.8 raw interrupt flag                                            */
      __IM  uint32_t IF9        : 1;            /*!< [9..9] Pn.9 raw interrupt flag                                            */
      __IM  uint32_t IF10       : 1;            /*!< [10..10] Pn.10 raw interrupt flag                                         */
      __IM  uint32_t IF11       : 1;            /*!< [11..11] Pn.11 raw interrupt flag                                         */
      __IM  uint32_t IF12       : 1;            /*!< [12..12] Pn.12 raw interrupt flag                                         */
      __IM  uint32_t IF13       : 1;            /*!< [13..13] Pn.13 raw interrupt flag                                         */
      __IM  uint32_t IF14       : 1;            /*!< [14..14] Pn.14 raw interrupt flag                                         */
      __IM  uint32_t IF15       : 1;            /*!< [15..15] Pn.15 raw interrupt flag                                         */
            uint32_t            : 16;
    } RIS_b;
  } ;
  
  union {
    __OM  uint32_t IC;                          /*!< (@ 0x00000020) Offset:0x20 GPIO Port n Interrupt Clear Register           */
    
    struct {
      __OM  uint32_t IC0        : 1;            /*!< [0..0] Pn.0 interrupt flag clear                                          */
      __OM  uint32_t IC1        : 1;            /*!< [1..1] Pn.1 interrupt flag clear                                          */
      __OM  uint32_t IC2        : 1;            /*!< [2..2] Pn.2 interrupt flag clear                                          */
      __OM  uint32_t IC3        : 1;            /*!< [3..3] Pn.3 interrupt flag clear                                          */
      __OM  uint32_t IC4        : 1;            /*!< [4..4] Pn.4 interrupt flag clear                                          */
      __OM  uint32_t IC5        : 1;            /*!< [5..5] Pn.5 interrupt flag clear                                          */
      __OM  uint32_t IC6        : 1;            /*!< [6..6] Pn.6 interrupt flag clear                                          */
      __OM  uint32_t IC7        : 1;            /*!< [7..7] Pn.7 interrupt flag clear                                          */
      __OM  uint32_t IC8        : 1;            /*!< [8..8] Pn.8 interrupt flag clear                                          */
      __OM  uint32_t IC9        : 1;            /*!< [9..9] Pn.9 interrupt flag clear                                          */
      __OM  uint32_t IC10       : 1;            /*!< [10..10] Pn.10 interrupt flag clear                                       */
      __OM  uint32_t IC11       : 1;            /*!< [11..11] Pn.11 interrupt flag clear                                       */
      __OM  uint32_t IC12       : 1;            /*!< [12..12] Pn.12 interrupt flag clear                                       */
      __OM  uint32_t IC13       : 1;            /*!< [13..13] Pn.13 interrupt flag clear                                       */
      __OM  uint32_t IC14       : 1;            /*!< [14..14] Pn.14 interrupt flag clear                                       */
      __OM  uint32_t IC15       : 1;            /*!< [15..15] Pn.15 interrupt flag clear                                       */
            uint32_t            : 16;
    } IC_b;
  } ;
  
  union {
    __OM  uint32_t BSET;                        /*!< (@ 0x00000024) Offset:0x24 GPIO Port n Bits Set Operation Register        */
    
    struct {
      __OM  uint32_t BSET0      : 1;            /*!< [0..0] Set Pn.0                                                           */
      __OM  uint32_t BSET1      : 1;            /*!< [1..1] Set Pn.1                                                           */
      __OM  uint32_t BSET2      : 1;            /*!< [2..2] Set Pn.2                                                           */
      __OM  uint32_t BSET3      : 1;            /*!< [3..3] Set Pn.3                                                           */
      __OM  uint32_t BSET4      : 1;            /*!< [4..4] Set Pn.4                                                           */
      __OM  uint32_t BSET5      : 1;            /*!< [5..5] Set Pn.5                                                           */
      __OM  uint32_t BSET6      : 1;            /*!< [6..6] Set Pn.6                                                           */
      __OM  uint32_t BSET7      : 1;            /*!< [7..7] Set Pn.7                                                           */
      __OM  uint32_t BSET8      : 1;            /*!< [8..8] Set Pn.8                                                           */
      __OM  uint32_t BSET9      : 1;            /*!< [9..9] Set Pn.9                                                           */
      __OM  uint32_t BSET10     : 1;            /*!< [10..10] Set Pn.10                                                        */
      __OM  uint32_t BSET11     : 1;            /*!< [11..11] Set Pn.11                                                        */
      __OM  uint32_t BSET12     : 1;            /*!< [12..12] Set Pn.12                                                        */
      __OM  uint32_t BSET13     : 1;            /*!< [13..13] Set Pn.13                                                        */
      __OM  uint32_t BSET14     : 1;            /*!< [14..14] Set Pn.14                                                        */
      __OM  uint32_t BSET15     : 1;            /*!< [15..15] Set Pn.15                                                        */
            uint32_t            : 16;
    } BSET_b;
  } ;
  
  union {
    __OM  uint32_t BCLR;                        /*!< (@ 0x00000028) Offset:0x28 GPIO Port n Bits Clear Operation
                                                                    Register                                                   */
    
    struct {
      __OM  uint32_t BCLR0      : 1;            /*!< [0..0] Clear Pn.0                                                         */
      __OM  uint32_t BCLR1      : 1;            /*!< [1..1] Clear Pn.1                                                         */
      __OM  uint32_t BCLR2      : 1;            /*!< [2..2] Clear Pn.2                                                         */
      __OM  uint32_t BCLR3      : 1;            /*!< [3..3] Clear Pn.3                                                         */
      __OM  uint32_t BCLR4      : 1;            /*!< [4..4] Clear Pn.4                                                         */
      __OM  uint32_t BCLR5      : 1;            /*!< [5..5] Clear Pn.5                                                         */
      __OM  uint32_t BCLR6      : 1;            /*!< [6..6] Clear Pn.6                                                         */
      __OM  uint32_t BCLR7      : 1;            /*!< [7..7] Clear Pn.7                                                         */
      __OM  uint32_t BCLR8      : 1;            /*!< [8..8] Clear Pn.8                                                         */
      __OM  uint32_t BCLR9      : 1;            /*!< [9..9] Clear Pn.9                                                         */
      __OM  uint32_t BCLR10     : 1;            /*!< [10..10] Clear Pn.10                                                      */
      __OM  uint32_t BCLR11     : 1;            /*!< [11..11] Clear Pn.11                                                      */
      __OM  uint32_t BCLR12     : 1;            /*!< [12..12] Clear Pn.12                                                      */
      __OM  uint32_t BCLR13     : 1;            /*!< [13..13] Clear Pn.13                                                      */
      __OM  uint32_t BCLR14     : 1;            /*!< [14..14] Clear Pn.14                                                      */
      __OM  uint32_t BCLR15     : 1;            /*!< [15..15] Clear Pn.15                                                      */
            uint32_t            : 16;
    } BCLR_b;
  } ;
} SN_GPIO2_Type;                                /*!< Size = 44 (0x2c)                                                          */



/* =========================================================================================================================== */
/* ================                                          SN_ADC                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief ADC (SN_ADC)
  */

typedef struct {                                /*!< (@ 0x40026000) SN_ADC Structure                                           */
  
  union {
    __IOM uint32_t ADM;                         /*!< (@ 0x00000000) Offset:0x00 ADC Management Register                        */
    
    struct {
      __IOM uint32_t CHS        : 5;            /*!< [4..0] ADC input channel                                                  */
      __IOM uint32_t GCHS       : 1;            /*!< [5..5] ADC global channel enable                                          */
      __IOM uint32_t EOC        : 1;            /*!< [6..6] ADC status                                                         */
      __IOM uint32_t ADS        : 1;            /*!< [7..7] ADC start control                                                  */
      __IOM uint32_t ADLEN      : 1;            /*!< [8..8] ADC resolution                                                     */
      __IOM uint32_t ADCKS      : 3;            /*!< [11..9] ADC clock source divider                                          */
      __IOM uint32_t ADENB      : 1;            /*!< [12..12] ADC enable                                                       */
      __IOM uint32_t AVREFHSEL  : 1;            /*!< [13..13] ADC high reference voltage source                                */
      __IOM uint32_t VHS        : 3;            /*!< [16..14] Internal Ref. voltage source                                     */
            uint32_t            : 15;
    } ADM_b;
  } ;
  
  union {
    __IM  uint32_t ADB;                         /*!< (@ 0x00000004) Offset:0x04 ADC Data Register                              */
    
    struct {
      __IM  uint32_t ADB        : 12;           /*!< [11..0] ADB11~ADB4 bits for 8-bit ADC, ADB11~ADB0 bits for 12-bit
                                                     ADC                                                                       */
            uint32_t            : 20;
    } ADB_b;
  } ;
  __IM  uint32_t  RESERVED;
  
  union {
    __IOM uint32_t IE;                          /*!< (@ 0x0000000C) Offset:0x0C ADC Interrupt Enable Register                  */
    
    struct {
      __IOM uint32_t IE0        : 1;            /*!< [0..0] AIN0 interrupt enable                                              */
      __IOM uint32_t IE1        : 1;            /*!< [1..1] AIN1 interrupt enable                                              */
      __IOM uint32_t IE2        : 1;            /*!< [2..2] AIN2 interrupt enable                                              */
      __IOM uint32_t IE3        : 1;            /*!< [3..3] AIN3 interrupt enable                                              */
      __IOM uint32_t IE4        : 1;            /*!< [4..4] AIN4 interrupt enable                                              */
      __IOM uint32_t IE5        : 1;            /*!< [5..5] AIN5 interrupt enable                                              */
      __IOM uint32_t IE6        : 1;            /*!< [6..6] AIN6 interrupt enable                                              */
      __IOM uint32_t IE7        : 1;            /*!< [7..7] AIN7 interrupt enable                                              */
      __IOM uint32_t IE8        : 1;            /*!< [8..8] AIN8 interrupt enable                                              */
      __IOM uint32_t IE9        : 1;            /*!< [9..9] AIN9 interrupt enable                                              */
      __IOM uint32_t IE10       : 1;            /*!< [10..10] AIN10 interrupt enable                                           */
      __IOM uint32_t IE11       : 1;            /*!< [11..11] AIN11 interrupt enable                                           */
      __IOM uint32_t IE12       : 1;            /*!< [12..12] AIN12 interrupt enable                                           */
      __IOM uint32_t IE13       : 1;            /*!< [13..13] AIN13 interrupt enable                                           */
      __IOM uint32_t IE14       : 1;            /*!< [14..14] AIN14 interrupt enable                                           */
      __IOM uint32_t IE15       : 1;            /*!< [15..15] AIN15 interrupt enable                                           */
      __IOM uint32_t IE16       : 1;            /*!< [16..16] AIN16 interrupt enable                                           */
      __IOM uint32_t IE17       : 1;            /*!< [17..17] AIN17 interrupt enable                                           */
      __IOM uint32_t IE18       : 1;            /*!< [18..18] AIN18 interrupt enable                                           */
            uint32_t            : 13;
    } IE_b;
  } ;
  
  union {
    __IOM uint32_t RIS;                         /*!< (@ 0x00000010) Offset:0x10 ADC Raw Interrupt Status Register              */
    
    struct {
      __IOM uint32_t EOCIF0     : 1;            /*!< [0..0] AIN0 interrupt flag                                                */
      __IOM uint32_t EOCIF1     : 1;            /*!< [1..1] AIN1 interrupt flag                                                */
      __IOM uint32_t EOCIF2     : 1;            /*!< [2..2] AIN2 interrupt flag                                                */
      __IOM uint32_t EOCIF3     : 1;            /*!< [3..3] AIN0 interrupt flag                                                */
      __IOM uint32_t EOCIF4     : 1;            /*!< [4..4] AIN4 interrupt flag                                                */
      __IOM uint32_t EOCIF5     : 1;            /*!< [5..5] AIN5 interrupt flag                                                */
      __IOM uint32_t EOCIF6     : 1;            /*!< [6..6] AIN6 interrupt flag                                                */
      __IOM uint32_t EOCIF7     : 1;            /*!< [7..7] AIN7 interrupt flag                                                */
      __IOM uint32_t EOCIF8     : 1;            /*!< [8..8] AIN8 interrupt flag                                                */
      __IOM uint32_t EOCIF9     : 1;            /*!< [9..9] AIN9 interrupt flag                                                */
      __IOM uint32_t EOCIF10    : 1;            /*!< [10..10] AIN10 interrupt flag                                             */
      __IOM uint32_t EOCIF11    : 1;            /*!< [11..11] AIN11 interrupt flag                                             */
      __IOM uint32_t EOCIF12    : 1;            /*!< [12..12] AIN12 interrupt flag                                             */
      __IOM uint32_t EOCIF13    : 1;            /*!< [13..13] AIN13 interrupt flag                                             */
      __IOM uint32_t EOCIF14    : 1;            /*!< [14..14] AIN14 interrupt flag                                             */
      __IOM uint32_t EOCIF15    : 1;            /*!< [15..15] AIN15 interrupt flag                                             */
      __IOM uint32_t EOCIF16    : 1;            /*!< [16..16] AIN16 interrupt flag                                             */
      __IOM uint32_t EOCIF17    : 1;            /*!< [17..17] AIN17 interrupt flag                                             */
      __IOM uint32_t EOCIF18    : 1;            /*!< [18..18] AIN18 interrupt flag                                             */
            uint32_t            : 13;
    } RIS_b;
  } ;
  __IOM uint32_t  CALI;                         /*!< (@ 0x00000014) Offset:0x14 ADC Calibration Register                       */
} SN_ADC_Type;                                  /*!< Size = 24 (0x18)                                                          */



/* =========================================================================================================================== */
/* ================                                          SN_CMP                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief Comparator (SN_CMP)
  */

typedef struct {                                /*!< (@ 0x40028000) SN_CMP Structure                                           */
  
  union {
    __IOM uint32_t CTRL;                        /*!< (@ 0x00000000) Offset:0x00 CMP Control Register                           */
    
    struct {
      __IOM uint32_t CM0EN      : 1;            /*!< [0..0] CMP0 Enable bit                                                    */
      __IOM uint32_t CM0PS      : 2;            /*!< [2..1] CMP0 Positive input selection bits                                 */
      __IOM uint32_t CM0NS      : 2;            /*!< [4..3] CMP0 Negative input pin                                            */
      __IOM uint32_t CM0RS      : 5;            /*!< [9..5] CMP0 internal reference voltage (VIREF0) selection bits            */
      __IOM uint32_t CM0OEN     : 2;            /*!< [11..10] CMP0 Output pin control bits                                     */
      __IOM uint32_t CM0G       : 1;            /*!< [12..12] CMP0 interrupt trigger direction control bit                     */
            uint32_t            : 3;
      __IOM uint32_t CM1EN      : 1;            /*!< [16..16] CMP1 Enable bit                                                  */
      __IOM uint32_t CM1PS      : 2;            /*!< [18..17] CMP1 Positive input selection bits                               */
      __IOM uint32_t CM1NS      : 2;            /*!< [20..19] CMP1 Negative input pin                                          */
      __IOM uint32_t CM1RS      : 5;            /*!< [25..21] CMP1 internal reference voltage (VIREF1) selection
                                                     bits                                                                      */
      __IOM uint32_t CM1OEN     : 2;            /*!< [27..26] CMP1 Output pin control bits                                     */
      __IOM uint32_t CM1G       : 1;            /*!< [28..28] CMP1 interrupt trigger direction control bit                     */
            uint32_t            : 3;
    } CTRL_b;
  } ;
  
  union {
    __IOM uint32_t CTRL1;                       /*!< (@ 0x00000004) Offset:0x04 CMP Control Register 1                         */
    
    struct {
      __IOM uint32_t CM2EN      : 1;            /*!< [0..0] CMP2 Enable bit                                                    */
      __IOM uint32_t CM2PS      : 2;            /*!< [2..1] CMP2 Positive input selection bits                                 */
      __IOM uint32_t CM2NS      : 2;            /*!< [4..3] CMP2 Negative input pin                                            */
      __IOM uint32_t CM2RS      : 5;            /*!< [9..5] CMP2 internal reference voltage (VIREF2) selection bits            */
      __IOM uint32_t CM2OEN     : 2;            /*!< [11..10] CMP2 Output pin control bits                                     */
      __IOM uint32_t CM2G       : 1;            /*!< [12..12] CMP2 interrupt trigger direction control bit                     */
            uint32_t            : 19;
    } CTRL1_b;
  } ;
  
  union {
    __IOM uint32_t VIREF;                       /*!< (@ 0x00000008) Offset:0x08 CMP Internal Reference Voltage register        */
    
    struct {
      __IOM uint32_t CMPIREFEN  : 1;            /*!< [0..0] CMP internal reference voltage (VIREF) enable                      */
      __IOM uint32_t CMPIREF    : 2;            /*!< [2..1] CMP internal reference voltage (VIREF) source                      */
            uint32_t            : 29;
    } VIREF_b;
  } ;
  
  union {
    __IM  uint32_t OS;                          /*!< (@ 0x0000000C) Offset:0xC CMP Output Status Register                      */
    
    struct {
      __IM  uint32_t CM0OUT     : 1;            /*!< [0..0] CMP0 Output flag bit                                               */
      __IM  uint32_t CM1OUT     : 1;            /*!< [1..1] CMP1 Output flag bit                                               */
      __IM  uint32_t CM2OUT     : 1;            /*!< [2..2] CMP2 Output flag bit                                               */
            uint32_t            : 29;
    } OS_b;
  } ;
  
  union {
    __IOM uint32_t IE;                          /*!< (@ 0x00000010) Offset:0x10 CMP Interrupt Enable Register                  */
    
    struct {
      __IOM uint32_t CM0IE      : 1;            /*!< [0..0] CMP0 interrupt enable                                              */
      __IOM uint32_t CM1IE      : 1;            /*!< [1..1] CMP1 interrupt enable                                              */
      __IOM uint32_t CM2IE      : 1;            /*!< [2..2] CMP2 interrupt enable                                              */
      __IOM uint32_t CSIE       : 1;            /*!< [3..3] Cap-sensing interrupt enable                                       */
            uint32_t            : 28;
    } IE_b;
  } ;
  
  union {
    __IM  uint32_t RIS;                         /*!< (@ 0x00000014) Offset:0x14 CMP n Raw Interrupt Status Register            */
    
    struct {
      __IM  uint32_t CM0IF      : 1;            /*!< [0..0] CMP0 raw interrupt flag                                            */
      __IM  uint32_t CM1IF      : 1;            /*!< [1..1] CMP1 raw interrupt flag                                            */
      __IM  uint32_t CM2IF      : 1;            /*!< [2..2] CMP2 raw interrupt flag                                            */
      __IM  uint32_t CSIF       : 1;            /*!< [3..3] Cap-sensing raw interrupt flag                                     */
            uint32_t            : 28;
    } RIS_b;
  } ;
  
  union {
    __OM  uint32_t IC;                          /*!< (@ 0x00000018) Offset:0x18 CMP Interrupt Clear Register                   */
    
    struct {
      __OM  uint32_t CM0IC      : 1;            /*!< [0..0] CMP0 interrupt flag clear bit                                      */
      __OM  uint32_t CM1IC      : 1;            /*!< [1..1] CMP1 interrupt flag clear bit                                      */
      __OM  uint32_t CM2IC      : 1;            /*!< [2..2] CMP2 interrupt flag clear bit                                      */
      __OM  uint32_t CSIC       : 1;            /*!< [3..3] Cap-sensing interrupt flag clear bit                               */
            uint32_t            : 28;
    } IC_b;
  } ;
  
  union {
    __IOM uint32_t DB;                          /*!< (@ 0x0000001C) Offset:0x1C CMP Interrupt Clear Register                   */
    
    struct {
      __IOM uint32_t CM0DB      : 3;            /*!< [2..0] Count for CMP0 output debounce time                                */
            uint32_t            : 1;
      __IOM uint32_t CM1DB      : 3;            /*!< [6..4] Count for CMP1 output debounce time                                */
            uint32_t            : 1;
      __IOM uint32_t CM2DB      : 3;            /*!< [10..8] Count for CMP2 output debounce time                               */
            uint32_t            : 1;
      __IOM uint32_t CSDB       : 5;            /*!< [16..12] Count for Cap-sensing output debounce time                       */
            uint32_t            : 15;
    } DB_b;
  } ;
  
  union {
    __IOM uint32_t CSCTRL;                      /*!< (@ 0x00000020) Offset:0x20 CMP Cap-sensing Control Register               */
    
    struct {
      __IOM uint32_t CSEN       : 1;            /*!< [0..0] Cap-sensing module enable bit                                      */
      __IOM uint32_t CSS        : 1;            /*!< [1..1] Cap-sensing operation start bit                                    */
      __IOM uint32_t CS1ST      : 1;            /*!< [2..2] Cap-sensing channel scan group start bit                           */
      __IOM uint32_t CSH        : 5;            /*!< [7..3] Cap-sensing channel                                                */
            uint32_t            : 3;
      __IOM uint32_t CMP        : 3;            /*!< [13..11] Comparator reference control bits                                */
      __IOM uint32_t VDSEL      : 1;            /*!< [14..14] Cap-sensing voltage detects select bit                           */
      __IOM uint32_t CHG        : 3;            /*!< [17..15] Cap-sensing charging time                                        */
      __IOM uint32_t TNON       : 2;            /*!< [19..18] Non-overlap time                                                 */
      __IOM uint32_t CCAL       : 4;            /*!< [23..20] Cap Calibration parameter                                        */
      __IOM uint32_t CCAL4      : 1;            /*!< [24..24] Cap Calibration select bit                                       */
      __IOM uint32_t CSOUTEN    : 1;            /*!< [25..25] Cap-sening output pin enable bit                                 */
      __IOM uint32_t CSDIS      : 1;            /*!< [26..26] Channel discharge signl (CK_TCH) controll bit                    */
            uint32_t            : 3;
      __IOM uint32_t CSFAPC     : 1;            /*!< [30..30] CSF active controll                                              */
      __IM  uint32_t CSRDY      : 1;            /*!< [31..31] Cap-sensing module ready flag                                    */
    } CSCTRL_b;
  } ;
  
  union {
    __IOM uint32_t CSCTRL1;                     /*!< (@ 0x00000024) Offset:0x24 CMP Cap-sensing Control Register
                                                                    1                                                          */
    
    struct {
      __IOM uint32_t SGFRQ      : 2;            /*!< [1..0] Spread Spectrum frequency                                          */
            uint32_t            : 4;
      __IOM uint32_t SGSEL      : 2;            /*!< [7..6] Cap-sensing 4MHz clock source and SSCG select bit                  */
      __IOM uint32_t OSCR       : 5;            /*!< [12..8] Ring OSC.4MHz clock range                                         */
      __IOM uint32_t CSVCOV     : 1;            /*!< [13..13] CSV 16-bit event counter overflow indicator (Clock
                                                     source is Cap-sensing 4MHz)                                               */
      __IOM uint32_t CSCOV      : 1;            /*!< [14..14] CSC 16-bit timer counter overflow indicator (Clock
                                                     source is CS_PCLK)                                                        */
            uint32_t            : 17;
    } CSCTRL1_b;
  } ;
  
  union {
    __IM  uint32_t CSCNT;                       /*!< (@ 0x00000028) Offset:0x28 CMP CapSensing Counter Register                */
    
    struct {
      __IM  uint32_t CSV        : 16;           /*!< [15..0] CSV 16-bit event counter (CSV counter clock source is
                                                     CS_4MHz)                                                                  */
      __IM  uint32_t CSC        : 16;           /*!< [31..16] CSC 16-bit timer counter (CSC counter clock source
                                                     is CS_PCLK)                                                               */
    } CSCNT_b;
  } ;
} SN_CMP_Type;                                  /*!< Size = 44 (0x2c)                                                          */



/* =========================================================================================================================== */
/* ================                                         SN_CT16B0                                         ================ */
/* =========================================================================================================================== */


/**
  * @brief 16-bit Timer 0 with Capture function (SN_CT16B0)
  */

typedef struct {                                /*!< (@ 0x40000000) SN_CT16B0 Structure                                        */
  
  union {
    __IOM uint32_t TMRCTRL;                     /*!< (@ 0x00000000) Offset:0x00 CT16Bn Timer Control Register                  */
    
    struct {
      __IOM uint32_t CEN        : 1;            /*!< [0..0] Counter enable                                                     */
      __IOM uint32_t CRST       : 1;            /*!< [1..1] Counter Reset                                                      */
      __IOM uint32_t CLKSEL     : 1;            /*!< [2..2] PCLK source                                                        */
            uint32_t            : 1;
      __IOM uint32_t CM         : 3;            /*!< [6..4] Counting mode selection                                            */
            uint32_t            : 25;
    } TMRCTRL_b;
  } ;
  
  union {
    __IOM uint32_t TC;                          /*!< (@ 0x00000004) Offset:0x04 CT16Bn Timer Counter Register                  */
    
    struct {
      __IOM uint32_t TC         : 16;           /*!< [15..0] Timer Counter                                                     */
            uint32_t            : 16;
    } TC_b;
  } ;
  
  union {
    __IOM uint32_t PRE;                         /*!< (@ 0x00000008) Offset:0x08 CT16Bn Prescale Register                       */
    
    struct {
      __IOM uint32_t PRE        : 8;            /*!< [7..0] Prescaler                                                          */
            uint32_t            : 24;
    } PRE_b;
  } ;
  
  union {
    __IOM uint32_t PC;                          /*!< (@ 0x0000000C) Offset:0x0C CT16Bn Prescale Counter Register               */
    
    struct {
      __IOM uint32_t PC         : 8;            /*!< [7..0] Prescaler Counter                                                  */
            uint32_t            : 24;
    } PC_b;
  } ;
  
  union {
    __IOM uint32_t CNTCTRL;                     /*!< (@ 0x00000010) Offset:0x10 CT16Bn Counter Control Register                */
    
    struct {
      __IOM uint32_t CTM        : 2;            /*!< [1..0] Counter/Timer Mode                                                 */
            uint32_t            : 30;
    } CNTCTRL_b;
  } ;
  
  union {
    __IOM uint32_t MCTRL;                       /*!< (@ 0x00000014) Offset:0x14 CT16Bn Match Control Register                  */
    
    struct {
      __IOM uint32_t MR0IE      : 1;            /*!< [0..0] Enable generating an interrupt when MR0 matches TC                 */
      __IOM uint32_t MR0RST     : 1;            /*!< [1..1] Enable reset TC when MR0 matches TC                                */
      __IOM uint32_t MR0STOP    : 1;            /*!< [2..2] Stop TC and PC and clear CEN bit when MR0 matches TC               */
      __IOM uint32_t MR1IE      : 1;            /*!< [3..3] Enable generating an interrupt when MR1 matches TC                 */
      __IOM uint32_t MR1RST     : 1;            /*!< [4..4] Enable reset TC when MR1 matches TC                                */
      __IOM uint32_t MR1STOP    : 1;            /*!< [5..5] Stop TC and PC and clear CEN bit when MR1 matches TC               */
      __IOM uint32_t MR2IE      : 1;            /*!< [6..6] Enable generating an interrupt when MR2 matches TC                 */
      __IOM uint32_t MR2RST     : 1;            /*!< [7..7] Enable reset TC when MR2 matches TC                                */
      __IOM uint32_t MR2STOP    : 1;            /*!< [8..8] Stop TC and PC and clear CEN bit when MR2 matches TC               */
      __IOM uint32_t MR3IE      : 1;            /*!< [9..9] Enable generating an interrupt when MR3 matches TC                 */
      __IOM uint32_t MR3RST     : 1;            /*!< [10..10] Enable reset TC when MR3 matches TC                              */
      __IOM uint32_t MR3STOP    : 1;            /*!< [11..11] Stop TC and PC and clear CEN bit when MR3 matches TC             */
            uint32_t            : 9;
      __IOM uint32_t MR9IE      : 1;            /*!< [21..21] Enable generating an interrupt based on CM[2:0] when
                                                     MR9 matches the value in the TC                                           */
      __IOM uint32_t MR9RST     : 1;            /*!< [22..22] Enable reset TC when MR9 matches TC                              */
      __IOM uint32_t MR9STOP    : 1;            /*!< [23..23] Stop TC and PC and clear CEN bit when MR9 matches TC             */
      __OM  uint32_t PWMKEY     : 8;            /*!< [31..24] PWM register key.                                                */
    } MCTRL_b;
  } ;
  __IM  uint32_t  RESERVED[2];
  
  union {
    __IOM uint32_t MR0;                         /*!< (@ 0x00000020) Offset:0x20 CT16Bn MR0 Register                            */
    
    struct {
      __IOM uint32_t MR         : 16;           /*!< [15..0] Timer counter match value                                         */
            uint32_t            : 8;
      __OM  uint32_t PWMKEY     : 8;            /*!< [31..24] PWM register key                                                 */
    } MR0_b;
  } ;
  
  union {
    __IOM uint32_t MR1;                         /*!< (@ 0x00000024) Offset:0x24 CT16Bn MR1 Register                            */
    
    struct {
      __IOM uint32_t MR         : 16;           /*!< [15..0] Timer counter match value                                         */
            uint32_t            : 8;
      __OM  uint32_t PWMKEY     : 8;            /*!< [31..24] PWM register key                                                 */
    } MR1_b;
  } ;
  
  union {
    __IOM uint32_t MR2;                         /*!< (@ 0x00000028) Offset:0x28 CT16Bn MR2 Register                            */
    
    struct {
      __IOM uint32_t MR         : 16;           /*!< [15..0] Timer counter match value                                         */
            uint32_t            : 8;
      __OM  uint32_t PWMKEY     : 8;            /*!< [31..24] PWM register key                                                 */
    } MR2_b;
  } ;
  
  union {
    __IOM uint32_t MR3;                         /*!< (@ 0x0000002C) Offset:0x2C CT16Bn MR3 Register                            */
    
    struct {
      __IOM uint32_t MR         : 16;           /*!< [15..0] Timer counter match value                                         */
            uint32_t            : 8;
      __OM  uint32_t PWMKEY     : 8;            /*!< [31..24] PWM register key                                                 */
    } MR3_b;
  } ;
  __IM  uint32_t  RESERVED1[5];
  
  union {
    __IOM uint32_t MR9;                         /*!< (@ 0x00000044) Offset:0x44 CT16Bn MR9 Register                            */
    
    struct {
      __IOM uint32_t MR         : 16;           /*!< [15..0] Timer counter match value                                         */
            uint32_t            : 8;
      __OM  uint32_t PWMKEY     : 8;            /*!< [31..24] PWM register key                                                 */
    } MR9_b;
  } ;
  __IM  uint32_t  RESERVED2[15];
  
  union {
    __IOM uint32_t CAPCTRL;                     /*!< (@ 0x00000084) Offset:0x84 CT16Bn Capture Control Register                */
    
    struct {
      __IOM uint32_t CAP0RE     : 1;            /*!< [0..0] Capture/Reset on CT16Bn_CAP0 signal rising edge                    */
      __IOM uint32_t CAP0FE     : 1;            /*!< [1..1] Capture/Reset on CT16Bn_CAP0 signal falling edge                   */
      __IOM uint32_t CAP0IE     : 1;            /*!< [2..2] Interrupt on CT16Bn_CAP0 event                                     */
      __IOM uint32_t CAP0EN     : 1;            /*!< [3..3] CAP0 function enable                                               */
            uint32_t            : 28;
    } CAPCTRL_b;
  } ;
  
  union {
    __IM  uint32_t CAP0;                        /*!< (@ 0x00000088) Offset:0x88 CT16Bn CAP0 Register                           */
    
    struct {
      __IM  uint32_t CAP0       : 16;           /*!< [15..0] Timer counter capture value                                       */
            uint32_t            : 16;
    } CAP0_b;
  } ;
  
  union {
    __IOM uint32_t EM;                          /*!< (@ 0x0000008C) Offset:0x8C CT16Bn External Match Register                 */
    
    struct {
      __IOM uint32_t EM0        : 1;            /*!< [0..0] When the TC doesn't match MR0 and EMC0 is not 0, this
                                                     bit will drive the state of CT16Bn_PWM0 output.                           */
      __IOM uint32_t EM1        : 1;            /*!< [1..1] When the TC doesn't match MR1 and EMC1 is not 0, this
                                                     bit will drive the state of CT16Bn_PWM1 output.                           */
      __IOM uint32_t EM2        : 1;            /*!< [2..2] When the TC doesn't match MR2 and EMC2 is not 0, this
                                                     bit will drive the state of CT16Bn_PWM2 output.                           */
      __IOM uint32_t EM3        : 1;            /*!< [3..3] When the TC doesn't match MR3 and EMC3 is not 0, this
                                                     bit will drive the state of CT16Bn_PWM3 output.                           */
      __IOM uint32_t EMC0       : 2;            /*!< [5..4] CT16Bn_PWM0 functionality when MR0=TC                              */
      __IOM uint32_t EMC1       : 2;            /*!< [7..6] CT16Bn_PWM1 functionality when MR1=TC                              */
      __IOM uint32_t EMC2       : 2;            /*!< [9..8] CT16Bn_PWM2 functionality when MR2=TC                              */
      __IOM uint32_t EMC3       : 2;            /*!< [11..10] CT16Bn_PWM3 functionality when MR3=TC                            */
            uint32_t            : 12;
      __OM  uint32_t PWMKEY     : 8;            /*!< [31..24] PWM register key.                                                */
    } EM_b;
  } ;
  __IM  uint32_t  RESERVED3[2];
  
  union {
    __IOM uint32_t PWMCTRL;                     /*!< (@ 0x00000098) Offset:0x98 CT16Bn PWM Control Register                    */
    
    struct {
      __IOM uint32_t PWM0EN     : 1;            /*!< [0..0] PWM0 enable                                                        */
      __IOM uint32_t PWM1EN     : 1;            /*!< [1..1] PWM1 enable                                                        */
      __IOM uint32_t PWM2EN     : 1;            /*!< [2..2] PWM2 enable                                                        */
      __IOM uint32_t PWM3EN     : 1;            /*!< [3..3] PWM2 enable                                                        */
      __IOM uint32_t PWM0MODE   : 2;            /*!< [5..4] PWM0 output mode                                                   */
      __IOM uint32_t PWM1MODE   : 2;            /*!< [7..6] PWM1 output mode                                                   */
      __IOM uint32_t PWM2MODE   : 2;            /*!< [9..8] PWM2 output mode                                                   */
      __IOM uint32_t PWM3MODE   : 2;            /*!< [11..10] PWM3 output mode                                                 */
            uint32_t            : 8;
      __IOM uint32_t PWM0IOEN   : 1;            /*!< [20..20] CT16Bn_PWM0/GPIO selection                                       */
      __IOM uint32_t PWM1IOEN   : 1;            /*!< [21..21] CT16Bn_PWM1/GPIO selection                                       */
      __IOM uint32_t PWM2IOEN   : 1;            /*!< [22..22] CT16Bn_PWM2/GPIO selection                                       */
      __IOM uint32_t PWM3IOEN   : 1;            /*!< [23..23] CT16Bn_PWM3/GPIO selection                                       */
      __OM  uint32_t PWMKEY     : 8;            /*!< [31..24] PWM register key.                                                */
    } PWMCTRL_b;
  } ;
  __IM  uint32_t  RESERVED4[3];
  
  union {
    __IM  uint32_t RIS;                         /*!< (@ 0x000000A8) Offset:0xA8 CT16Bn Raw Interrupt Status Register           */
    
    struct {
      __IM  uint32_t MR0IF      : 1;            /*!< [0..0] Match channel 0 interrupt flag                                     */
      __IM  uint32_t MR1IF      : 1;            /*!< [1..1] Match channel 1 interrupt flag                                     */
      __IM  uint32_t MR2IF      : 1;            /*!< [2..2] Match channel 2 interrupt flag                                     */
      __IM  uint32_t MR3IF      : 1;            /*!< [3..3] Match channel 3 interrupt flag                                     */
      __IM  uint32_t CAP0IF     : 1;            /*!< [4..4] Capture channel 0 interrupt flag                                   */
      __IM  uint32_t MR9IF      : 1;            /*!< [5..5] Match channel 9 interrupt flag                                     */
            uint32_t            : 26;
    } RIS_b;
  } ;
  
  union {
    __OM  uint32_t IC;                          /*!< (@ 0x000000AC) Offset:0xAC CT16Bn Interrupt Clear Register                */
    
    struct {
      __OM  uint32_t MR0IC      : 1;            /*!< [0..0] MR0IF clear bit                                                    */
      __OM  uint32_t MR1IC      : 1;            /*!< [1..1] MR1IF clear bit                                                    */
      __OM  uint32_t MR2IC      : 1;            /*!< [2..2] MR2IF clear bit                                                    */
      __OM  uint32_t MR3IC      : 1;            /*!< [3..3] MR3IF clear bit                                                    */
      __OM  uint32_t CAP0IC     : 1;            /*!< [4..4] CAP0IF clear bit                                                   */
      __OM  uint32_t MR9IC      : 1;            /*!< [5..5] MR9IF clear bit                                                    */
            uint32_t            : 26;
    } IC_b;
  } ;
  
  union {
    __IOM uint32_t PWMmNIOCTRL;                 /*!< (@ 0x000000B0) Offset:0xB0 CT16Bn PWMmN IO Control register               */
    
    struct {
      __IOM uint32_t PWM0NIOEN  : 2;            /*!< [1..0] CT16Bn_PWM0N/GPIO selection bit                                    */
      __IOM uint32_t PWM1NIOEN  : 2;            /*!< [3..2] CT16Bn_PWM0N/GPIO selection bit                                    */
      __IOM uint32_t PWM2NIOEN  : 2;            /*!< [5..4] CT16Bn_PWM0N/GPIO selection bit                                    */
      __IOM uint32_t PWM3NIOEN  : 2;            /*!< [7..6] CT16Bn_PWM3N/GPIO selection bit                                    */
            uint32_t            : 16;
      __OM  uint32_t PWMKEY     : 8;            /*!< [31..24] PWM register key.                                                */
    } PWMmNIOCTRL_b;
  } ;
  
  union {
    __IOM uint32_t PWM0NDB;                     /*!< (@ 0x000000B4) Offset:0xB4 CT16Bn PWM0N Dead-band Period Register         */
    
    struct {
      __IOM uint32_t DB         : 10;           /*!< [9..0] PWM0N output dead-band period time=DB*CT16Bn_PCLK*(PR+1)
                                                     cycle                                                                     */
            uint32_t            : 14;
      __OM  uint32_t PWMKEY     : 8;            /*!< [31..24] PWM register key.                                                */
    } PWM0NDB_b;
  } ;
  
  union {
    __IOM uint32_t PWM1NDB;                     /*!< (@ 0x000000B8) Offset:0xB8 CT16Bn PWM1N Dead-band Period Register         */
    
    struct {
      __IOM uint32_t DB         : 10;           /*!< [9..0] PWM1N output dead-band period time=DB*CT16Bn_PCLK*(PR+1)
                                                     cycle                                                                     */
            uint32_t            : 14;
      __OM  uint32_t PWMKEY     : 8;            /*!< [31..24] PWM register key.                                                */
    } PWM1NDB_b;
  } ;
  
  union {
    __IOM uint32_t PWM2NDB;                     /*!< (@ 0x000000BC) Offset:0xBC CT16Bn PWM2N Dead-band Period Register         */
    
    struct {
      __IOM uint32_t DB         : 10;           /*!< [9..0] PWM2N output dead-band period time=DB*CT16Bn_PCLK*(PR+1)
                                                     cycle                                                                     */
            uint32_t            : 14;
      __OM  uint32_t PWMKEY     : 8;            /*!< [31..24] PWM register key.                                                */
    } PWM2NDB_b;
  } ;
  
  union {
    __IOM uint32_t PWM3NDB;                     /*!< (@ 0x000000C0) Offset:0xC0 CT16Bn PWM3N Dead-band Period Register         */
    
    struct {
      __IOM uint32_t DB         : 10;           /*!< [9..0] PWM3N output dead-band period time=DB*CT16Bn_PCLK*(PR+1)
                                                     cycle                                                                     */
            uint32_t            : 14;
      __OM  uint32_t PWMKEY     : 8;            /*!< [31..24] PWM register key.                                                */
    } PWM3NDB_b;
  } ;
} SN_CT16B0_Type;                               /*!< Size = 196 (0xc4)                                                         */



/* =========================================================================================================================== */
/* ================                                         SN_CT16B1                                         ================ */
/* =========================================================================================================================== */


/**
  * @brief 16-bit Timer 1 with Capture function (SN_CT16B1)
  */

typedef struct {                                /*!< (@ 0x40002000) SN_CT16B1 Structure                                        */
  
  union {
    __IOM uint32_t TMRCTRL;                     /*!< (@ 0x00000000) Offset:0x00 CT16Bn Timer Control Register                  */
    
    struct {
      __IOM uint32_t CEN        : 1;            /*!< [0..0] Counter enable                                                     */
      __IOM uint32_t CRST       : 1;            /*!< [1..1] Counter Reset                                                      */
      __IOM uint32_t CLKSEL     : 1;            /*!< [2..2] PCLK source                                                        */
            uint32_t            : 29;
    } TMRCTRL_b;
  } ;
  
  union {
    __IOM uint32_t TC;                          /*!< (@ 0x00000004) Offset:0x04 CT16Bn Timer Counter Register                  */
    
    struct {
      __IOM uint32_t TC         : 16;           /*!< [15..0] Timer Counter                                                     */
            uint32_t            : 16;
    } TC_b;
  } ;
  
  union {
    __IOM uint32_t PRE;                         /*!< (@ 0x00000008) Offset:0x08 CT16Bn Prescale Register                       */
    
    struct {
      __IOM uint32_t PRE        : 8;            /*!< [7..0] Prescaler                                                          */
            uint32_t            : 24;
    } PRE_b;
  } ;
  
  union {
    __IOM uint32_t PC;                          /*!< (@ 0x0000000C) Offset:0x0C CT16Bn Prescale Counter Register               */
    
    struct {
      __IOM uint32_t PC         : 8;            /*!< [7..0] Prescaler Counter                                                  */
            uint32_t            : 24;
    } PC_b;
  } ;
  
  union {
    __IOM uint32_t CNTCTRL;                     /*!< (@ 0x00000010) Offset:0x10 CT16Bn Counter Control Register                */
    
    struct {
      __IOM uint32_t CTM        : 2;            /*!< [1..0] Counter/Timer Mode                                                 */
            uint32_t            : 30;
    } CNTCTRL_b;
  } ;
  
  union {
    __IOM uint32_t MCTRL;                       /*!< (@ 0x00000014) Offset:0x14 CT16Bn Match Control Register                  */
    
    struct {
      __IOM uint32_t MR0IE      : 1;            /*!< [0..0] Enable generating an interrupt when MR0 matches TC                 */
      __IOM uint32_t MR0RST     : 1;            /*!< [1..1] Enable reset TC when MR0 matches TC                                */
      __IOM uint32_t MR0STOP    : 1;            /*!< [2..2] Stop TC and PC and clear CEN bit when MR0 matches TC               */
      __IOM uint32_t MR1IE      : 1;            /*!< [3..3] Enable generating an interrupt when MR1 matches TC                 */
      __IOM uint32_t MR1RST     : 1;            /*!< [4..4] Enable reset TC when MR1 matches TC                                */
      __IOM uint32_t MR1STOP    : 1;            /*!< [5..5] Stop TC and PC and clear CEN bit when MR1 matches TC               */
      __IOM uint32_t MR2IE      : 1;            /*!< [6..6] Enable generating an interrupt when MR2 matches TC                 */
      __IOM uint32_t MR2RST     : 1;            /*!< [7..7] Enable reset TC when MR2 matches TC                                */
      __IOM uint32_t MR2STOP    : 1;            /*!< [8..8] Stop TC and PC and clear CEN bit when MR2 matches TC               */
      __IOM uint32_t MR3IE      : 1;            /*!< [9..9] Enable generating an interrupt when MR3 matches TC                 */
      __IOM uint32_t MR3RST     : 1;            /*!< [10..10] Enable reset TC when MR3 matches TC                              */
      __IOM uint32_t MR3STOP    : 1;            /*!< [11..11] Stop TC and PC and clear CEN bit when MR3 matches TC             */
      __IOM uint32_t MR4IE      : 1;            /*!< [12..12] Enable generating an interrupt when MR4 matches TC               */
      __IOM uint32_t MR4RST     : 1;            /*!< [13..13] Enable reset TC when MR4 matches TC                              */
      __IOM uint32_t MR4STOP    : 1;            /*!< [14..14] Stop TC and PC and clear CEN bit when MR4 matches TC             */
      __IOM uint32_t MR5IE      : 1;            /*!< [15..15] Enable generating an interrupt when MR5 matches TC               */
      __IOM uint32_t MR5RST     : 1;            /*!< [16..16] Enable reset TC when MR5 matches TC                              */
      __IOM uint32_t MR5STOP    : 1;            /*!< [17..17] Stop TC and PC and clear CEN bit when MR5 matches TC             */
      __IOM uint32_t MR6IE      : 1;            /*!< [18..18] Enable generating an interrupt when MR6 matches TC               */
      __IOM uint32_t MR6RST     : 1;            /*!< [19..19] Enable reset TC when MR6 matches TC                              */
      __IOM uint32_t MR6STOP    : 1;            /*!< [20..20] Stop TC and PC and clear CEN bit when MR6 matches TC             */
      __IOM uint32_t MR7IE      : 1;            /*!< [21..21] Enable generating an interrupt when MR7 matches TC               */
      __IOM uint32_t MR7RST     : 1;            /*!< [22..22] Enable reset TC when MR7 matches TC                              */
      __IOM uint32_t MR7STOP    : 1;            /*!< [23..23] Stop TC and PC and clear CEN bit when MR7 matches TC             */
      __IOM uint32_t MR8IE      : 1;            /*!< [24..24] Enable generating an interrupt when MR8 matches TC               */
      __IOM uint32_t MR8RST     : 1;            /*!< [25..25] Enable reset TC when MR8 matches TC                              */
      __IOM uint32_t MR8STOP    : 1;            /*!< [26..26] Stop TC and PC and clear CEN bit when MR8 matches TC             */
      __IOM uint32_t MR9IE      : 1;            /*!< [27..27] Enable generating an interrupt when MR9 matches TC               */
      __IOM uint32_t MR9RST     : 1;            /*!< [28..28] Enable reset TC when MR9 matches TC                              */
      __IOM uint32_t MR9STOP    : 1;            /*!< [29..29] Stop TC and PC and clear CEN bit when MR9 matches TC             */
            uint32_t            : 2;
    } MCTRL_b;
  } ;
  
  union {
    __IOM uint32_t MCTRL2;                      /*!< (@ 0x00000018) Offset:0x18 CT16Bn Match Control Register 2                */
    
    struct {
      __IOM uint32_t MR10IE     : 1;            /*!< [0..0] Enable generating an interrupt when MR10 matches TC                */
      __IOM uint32_t MR10RST    : 1;            /*!< [1..1] Enable reset TC when MR10 matches TC                               */
      __IOM uint32_t MR10STOP   : 1;            /*!< [2..2] Stop TC and PC and clear CEN bit when MR10 matches TC              */
      __IOM uint32_t MR11IE     : 1;            /*!< [3..3] Enable generating an interrupt when MR11 matches TC                */
      __IOM uint32_t MR11RST    : 1;            /*!< [4..4] Enable reset TC when MR11 matches TC                               */
      __IOM uint32_t MR11STOP   : 1;            /*!< [5..5] Stop TC and PC and clear CEN bit when MR11 matches TC              */
      __IOM uint32_t MR12IE     : 1;            /*!< [6..6] Enable generating an interrupt when MR12 matches TC                */
      __IOM uint32_t MR12RST    : 1;            /*!< [7..7] Enable reset TC when MR12 matches TC                               */
      __IOM uint32_t MR12STOP   : 1;            /*!< [8..8] Stop TC and PC and clear CEN bit when MR12 matches TC              */
            uint32_t            : 23;
    } MCTRL2_b;
  } ;
  __IM  uint32_t  RESERVED;
  __IOM uint32_t  MR0;                          /*!< (@ 0x00000020) Offset:0x20 CT16Bn MR0 Register                            */
  __IOM uint32_t  MR1;                          /*!< (@ 0x00000024) Offset:0x24 CT16Bn MR1 Register                            */
  __IOM uint32_t  MR2;                          /*!< (@ 0x00000028) Offset:0x28 CT16Bn MR2 Register                            */
  __IOM uint32_t  MR3;                          /*!< (@ 0x0000002C) Offset:0x2C CT16Bn MR3 Register                            */
  __IOM uint32_t  MR4;                          /*!< (@ 0x00000030) Offset:0x30 CT16Bn MR4 Register                            */
  __IOM uint32_t  MR5;                          /*!< (@ 0x00000034) Offset:0x34 CT16Bn MR5 Register                            */
  __IOM uint32_t  MR6;                          /*!< (@ 0x00000038) Offset:0x38 CT16Bn MR6 Register                            */
  __IOM uint32_t  MR7;                          /*!< (@ 0x0000003C) Offset:0x3C CT16Bn MR7 Register                            */
  __IOM uint32_t  MR8;                          /*!< (@ 0x00000040) Offset:0x40 CT16Bn MR8 Register                            */
  __IOM uint32_t  MR9;                          /*!< (@ 0x00000044) Offset:0x44 CT16Bn MR9 Register                            */
  __IOM uint32_t  MR10;                         /*!< (@ 0x00000048) Offset:0x48 CT16Bn MR10 Register                           */
  __IOM uint32_t  MR11;                         /*!< (@ 0x0000004C) Offset:0x4C CT16Bn MR11 Register                           */
  __IOM uint32_t  MR12;                         /*!< (@ 0x00000050) Offset:0x50 CT16Bn MR12 Register                           */
  __IM  uint32_t  RESERVED1[12];
  
  union {
    __IOM uint32_t CAPCTRL;                     /*!< (@ 0x00000084) Offset:0x84 CT16Bn Capture Control Register                */
    
    struct {
      __IOM uint32_t CAP0RE     : 1;            /*!< [0..0] Capture/Reset on CT16Bn_CAP0 signal rising edge                    */
      __IOM uint32_t CAP0FE     : 1;            /*!< [1..1] Capture/Reset on CT16Bn_CAP0 signal falling edge                   */
      __IOM uint32_t CAP0IE     : 1;            /*!< [2..2] Interrupt on CT16Bn_CAP0 event                                     */
      __IOM uint32_t CAP0EN     : 1;            /*!< [3..3] CAP0 function enable                                               */
            uint32_t            : 28;
    } CAPCTRL_b;
  } ;
  
  union {
    __IM  uint32_t CAP0;                        /*!< (@ 0x00000088) Offset:0x88 CT16Bn CAP0 Register                           */
    
    struct {
      __IM  uint32_t CAP0       : 16;           /*!< [15..0] Timer counter capture value                                       */
            uint32_t            : 16;
    } CAP0_b;
  } ;
  
  union {
    __IOM uint32_t EM;                          /*!< (@ 0x0000008C) Offset:0x8C CT16Bn External Match Register                 */
    
    struct {
      __IOM uint32_t EM0        : 1;            /*!< [0..0] When the TC matches MR0, this bit will act according
                                                     to EMC0[1:0], and also drive the state of CT16Bn_PWM0 output.             */
      __IOM uint32_t EM1        : 1;            /*!< [1..1] When the TC matches MR1, this bit will act according
                                                     to EMC1[1:0], and also drive the state of CT16Bn_PWM1 output.             */
      __IOM uint32_t EM2        : 1;            /*!< [2..2] When the TC matches MR2, this bit will act according
                                                     to EMC2[1:0], and also drive the state of CT16Bn_PWM2 output.             */
      __IOM uint32_t EM3        : 1;            /*!< [3..3] When the TC matches MR3, this bit will act according
                                                     to EMC3[1:0], and also drive the state of CT16Bn_PWM3 output.             */
      __IOM uint32_t EM4        : 1;            /*!< [4..4] When the TC matches MR4, this bit will act according
                                                     to EMC4[1:0], and also drive the state of CT16Bn_PWM0 output.             */
      __IOM uint32_t EM5        : 1;            /*!< [5..5] When the TC matches MR5, this bit will act according
                                                     to EMC5[1:0], and also drive the state of CT16Bn_PWM1 output.             */
      __IOM uint32_t EM6        : 1;            /*!< [6..6] When the TC matches MR6, this bit will act according
                                                     to EMC6[1:0], and also drive the state of CT16Bn_PWM2 output.             */
      __IOM uint32_t EM7        : 1;            /*!< [7..7] When the TC matches MR7, this bit will act according
                                                     to EMC7[1:0], and also drive the state of CT16Bn_PWM3 output.             */
      __IOM uint32_t EM8        : 1;            /*!< [8..8] When the TC matches MR8, this bit will act according
                                                     to EMC8[1:0], and also drive the state of CT16Bn_PWM0 output.             */
      __IOM uint32_t EM9        : 1;            /*!< [9..9] When the TC matches MR9, this bit will act according
                                                     to EMC9[1:0], and also drive the state of CT16Bn_PWM1 output.             */
      __IOM uint32_t EM10       : 1;            /*!< [10..10] When the TC matches MR10, this bit will act according
                                                     to EMC10[1:0], and also drive the state of CT16Bn_PWM2
                                                     output.                                                                   */
      __IOM uint32_t EM11       : 1;            /*!< [11..11] When the TC matches MR11, this bit will act according
                                                     to EMC11[1:0], and also drive the state of CT16Bn_PWM3
                                                     output.                                                                   */
            uint32_t            : 20;
    } EM_b;
  } ;
  
  union {
    __IOM uint32_t EMC;                         /*!< (@ 0x00000090) Offset:0x90 CT16Bn External Match Control register         */
    
    struct {
      __IOM uint32_t EMC0       : 2;            /*!< [1..0] CT16Bn_PWM0 functionality                                          */
      __IOM uint32_t EMC1       : 2;            /*!< [3..2] CT16Bn_PWM1 functionality                                          */
      __IOM uint32_t EMC2       : 2;            /*!< [5..4] CT16Bn_PWM2 functionality                                          */
      __IOM uint32_t EMC3       : 2;            /*!< [7..6] CT16Bn_PWM3 functionality                                          */
      __IOM uint32_t EMC4       : 2;            /*!< [9..8] CT16Bn_PWM4 functionality                                          */
      __IOM uint32_t EMC5       : 2;            /*!< [11..10] CT16Bn_PWM5 functionality                                        */
      __IOM uint32_t EMC6       : 2;            /*!< [13..12] CT16Bn_PWM6 functionality                                        */
      __IOM uint32_t EMC7       : 2;            /*!< [15..14] CT16Bn_PWM7 functionality                                        */
      __IOM uint32_t EMC8       : 2;            /*!< [17..16] CT16Bn_PWM8 functionality                                        */
      __IOM uint32_t EMC9       : 2;            /*!< [19..18] CT16Bn_PWM9 functionality                                        */
      __IOM uint32_t EMC10      : 2;            /*!< [21..20] CT16Bn_PWM10 functionality                                       */
      __IOM uint32_t EMC11      : 2;            /*!< [23..22] CT16Bn_PWM11 functionality                                       */
            uint32_t            : 8;
    } EMC_b;
  } ;
  __IM  uint32_t  RESERVED2;
  
  union {
    __IOM uint32_t PWMCTRL;                     /*!< (@ 0x00000098) Offset:0x98 CT16Bn PWM Control Register                    */
    
    struct {
      __IOM uint32_t PWM0MODE   : 2;            /*!< [1..0] PWM0 output mode                                                   */
      __IOM uint32_t PWM1MODE   : 2;            /*!< [3..2] PWM1 output mode                                                   */
      __IOM uint32_t PWM2MODE   : 2;            /*!< [5..4] PWM2 output mode                                                   */
      __IOM uint32_t PWM3MODE   : 2;            /*!< [7..6] PWM3 output mode                                                   */
      __IOM uint32_t PWM4MODE   : 2;            /*!< [9..8] PWM4 output mode                                                   */
      __IOM uint32_t PWM5MODE   : 2;            /*!< [11..10] PWM5 output mode                                                 */
      __IOM uint32_t PWM6MODE   : 2;            /*!< [13..12] PWM6 output mode                                                 */
      __IOM uint32_t PWM7MODE   : 2;            /*!< [15..14] PWM7 output mode                                                 */
      __IOM uint32_t PWM8MODE   : 2;            /*!< [17..16] PWM8 output mode                                                 */
      __IOM uint32_t PWM9MODE   : 2;            /*!< [19..18] PWM9 output mode                                                 */
      __IOM uint32_t PWM10MODE  : 2;            /*!< [21..20] PWM10 output mode                                                */
      __IOM uint32_t PWM11MODE  : 2;            /*!< [23..22] PWM11 output mode                                                */
            uint32_t            : 8;
    } PWMCTRL_b;
  } ;
  __IM  uint32_t  RESERVED3;
  
  union {
    __IOM uint32_t PWMENB;                      /*!< (@ 0x000000A0) Offset:0xA0 CT16Bn PWM Enable register                     */
    
    struct {
      __IOM uint32_t PWM0EN     : 1;            /*!< [0..0] PWM0 enable                                                        */
      __IOM uint32_t PWM1EN     : 1;            /*!< [1..1] PWM1 enable                                                        */
      __IOM uint32_t PWM2EN     : 1;            /*!< [2..2] PWM2 enable                                                        */
      __IOM uint32_t PWM3EN     : 1;            /*!< [3..3] PWM3 enable                                                        */
      __IOM uint32_t PWM4EN     : 1;            /*!< [4..4] PWM4 enable                                                        */
      __IOM uint32_t PWM5EN     : 1;            /*!< [5..5] PWM5 enable                                                        */
      __IOM uint32_t PWM6EN     : 1;            /*!< [6..6] PWM6 enable                                                        */
      __IOM uint32_t PWM7EN     : 1;            /*!< [7..7] PWM7 enable                                                        */
      __IOM uint32_t PWM8EN     : 1;            /*!< [8..8] PWM8 enable                                                        */
      __IOM uint32_t PWM9EN     : 1;            /*!< [9..9] PWM9 enable                                                        */
      __IOM uint32_t PWM10EN    : 1;            /*!< [10..10] PWM10 enable                                                     */
      __IOM uint32_t PWM11EN    : 1;            /*!< [11..11] PWM11 enable                                                     */
            uint32_t            : 20;
    } PWMENB_b;
  } ;
  
  union {
    __IOM uint32_t PWMIOENB;                    /*!< (@ 0x000000A4) Offset:0xA4 CT16Bn PWM IO Enable register                  */
    
    struct {
      __IOM uint32_t PWM0IOEN   : 1;            /*!< [0..0] CT16Bn_PWM0/GPIO selection                                         */
      __IOM uint32_t PWM1IOEN   : 1;            /*!< [1..1] CT16Bn_PWM1/GPIO selection                                         */
      __IOM uint32_t PWM2IOEN   : 1;            /*!< [2..2] CT16Bn_PWM2/GPIO selection                                         */
      __IOM uint32_t PWM3IOEN   : 1;            /*!< [3..3] CT16Bn_PWM3/GPIO selection                                         */
      __IOM uint32_t PWM4IOEN   : 1;            /*!< [4..4] CT16Bn_PWM4/GPIO selection                                         */
      __IOM uint32_t PWM5IOEN   : 1;            /*!< [5..5] CT16Bn_PWM5/GPIO selection                                         */
      __IOM uint32_t PWM6IOEN   : 1;            /*!< [6..6] CT16Bn_PWM6/GPIO selection                                         */
      __IOM uint32_t PWM7IOEN   : 1;            /*!< [7..7] CT16Bn_PWM7/GPIO selection                                         */
      __IOM uint32_t PWM8IOEN   : 1;            /*!< [8..8] CT16Bn_PWM8/GPIO selection                                         */
      __IOM uint32_t PWM9IOEN   : 1;            /*!< [9..9] CT16Bn_PWM9/GPIO selection                                         */
      __IOM uint32_t PWM10IOEN  : 1;            /*!< [10..10] CT16Bn_PWM10/GPIO selection                                      */
      __IOM uint32_t PWM11IOEN  : 1;            /*!< [11..11] CT16Bn_PWM11/GPIO selection                                      */
            uint32_t            : 20;
    } PWMIOENB_b;
  } ;
  
  union {
    __IM  uint32_t RIS;                         /*!< (@ 0x000000A8) Offset:0xA8 CT16Bn Raw Interrupt Status Register           */
    
    struct {
      __IM  uint32_t MR0IF      : 1;            /*!< [0..0] Match channel 0 interrupt flag                                     */
      __IM  uint32_t MR1IF      : 1;            /*!< [1..1] Match channel 1 interrupt flag                                     */
      __IM  uint32_t MR2IF      : 1;            /*!< [2..2] Match channel 2 interrupt flag                                     */
      __IM  uint32_t MR3IF      : 1;            /*!< [3..3] Match channel 3 interrupt flag                                     */
      __IM  uint32_t MR4IF      : 1;            /*!< [4..4] Match channel 4 interrupt flag                                     */
      __IM  uint32_t MR5IF      : 1;            /*!< [5..5] Match channel 5 interrupt flag                                     */
      __IM  uint32_t MR6IF      : 1;            /*!< [6..6] Match channel 6 interrupt flag                                     */
      __IM  uint32_t MR7IF      : 1;            /*!< [7..7] Match channel 7 interrupt flag                                     */
      __IM  uint32_t MR8IF      : 1;            /*!< [8..8] Match channel 8 interrupt flag                                     */
      __IM  uint32_t MR9IF      : 1;            /*!< [9..9] Match channel 9 interrupt flag                                     */
      __IM  uint32_t MR10IF     : 1;            /*!< [10..10] Match channel 10 interrupt flag                                  */
      __IM  uint32_t MR11IF     : 1;            /*!< [11..11] Match channel 11 interrupt flag                                  */
      __IM  uint32_t MR12IF     : 1;            /*!< [12..12] Match channel 12 interrupt flag                                  */
      __IM  uint32_t CAP0IF     : 1;            /*!< [13..13] Capture channel 0 interrupt flag                                 */
            uint32_t            : 18;
    } RIS_b;
  } ;
  
  union {
    __OM  uint32_t IC;                          /*!< (@ 0x000000AC) Offset:0xAC CT16Bn Interrupt Clear Register                */
    
    struct {
      __OM  uint32_t MR0IC      : 1;            /*!< [0..0] MR0IF clear bit                                                    */
      __OM  uint32_t MR1IC      : 1;            /*!< [1..1] MR1IF clear bit                                                    */
      __OM  uint32_t MR2IC      : 1;            /*!< [2..2] MR2IF clear bit                                                    */
      __OM  uint32_t MR3IC      : 1;            /*!< [3..3] MR3IF clear bit                                                    */
      __OM  uint32_t MR4IC      : 1;            /*!< [4..4] MR4IF clear bit                                                    */
      __OM  uint32_t MR5IC      : 1;            /*!< [5..5] MR5IF clear bit                                                    */
      __OM  uint32_t MR6IC      : 1;            /*!< [6..6] MR6IF clear bit                                                    */
      __OM  uint32_t MR7IC      : 1;            /*!< [7..7] MR7IF clear bit                                                    */
      __OM  uint32_t MR8IC      : 1;            /*!< [8..8] MR8IF clear bit                                                    */
      __OM  uint32_t MR9IC      : 1;            /*!< [9..9] MR9IF clear bit                                                    */
      __OM  uint32_t MR10IC     : 1;            /*!< [10..10] MR10IF clear bit                                                 */
      __OM  uint32_t MR11IC     : 1;            /*!< [11..11] MR11IF clear bit                                                 */
      __OM  uint32_t MR12IC     : 1;            /*!< [12..12] MR12IF clear bit                                                 */
      __OM  uint32_t CAP0IC     : 1;            /*!< [13..13] CAP0IF clear bit                                                 */
            uint32_t            : 18;
    } IC_b;
  } ;
} SN_CT16B1_Type;                               /*!< Size = 176 (0xb0)                                                         */



/* =========================================================================================================================== */
/* ================                                         SN_CT16B2                                         ================ */
/* =========================================================================================================================== */


/**
  * @brief 16-bit Timer 2 with Capture function (SN_CT16B2)
  */

typedef struct {                                /*!< (@ 0x40004000) SN_CT16B2 Structure                                        */
  
  union {
    __IOM uint32_t TMRCTRL;                     /*!< (@ 0x00000000) Offset:0x00 CT16Bn Timer Control Register                  */
    
    struct {
      __IOM uint32_t CEN        : 1;            /*!< [0..0] Counter enable                                                     */
      __IOM uint32_t CRST       : 1;            /*!< [1..1] Counter Reset                                                      */
      __IOM uint32_t CLKSEL     : 1;            /*!< [2..2] PCLK source                                                        */
            uint32_t            : 1;
      __IOM uint32_t CM         : 3;            /*!< [6..4] Counting mode selection                                            */
            uint32_t            : 25;
    } TMRCTRL_b;
  } ;
  
  union {
    __IOM uint32_t TC;                          /*!< (@ 0x00000004) Offset:0x04 CT16Bn Timer Counter Register                  */
    
    struct {
      __IOM uint32_t TC         : 16;           /*!< [15..0] Timer Counter                                                     */
            uint32_t            : 16;
    } TC_b;
  } ;
  
  union {
    __IOM uint32_t PRE;                         /*!< (@ 0x00000008) Offset:0x08 CT16Bn Prescale Register                       */
    
    struct {
      __IOM uint32_t PRE        : 8;            /*!< [7..0] Prescalzer                                                         */
            uint32_t            : 24;
    } PRE_b;
  } ;
  
  union {
    __IOM uint32_t PC;                          /*!< (@ 0x0000000C) Offset:0x0C CT16Bn Prescale Counter Register               */
    
    struct {
      __IOM uint32_t PC         : 8;            /*!< [7..0] Prescaler Counter                                                  */
            uint32_t            : 24;
    } PC_b;
  } ;
  
  union {
    __IOM uint32_t CNTCTRL;                     /*!< (@ 0x00000010) Offset:0x10 CT16Bn Counter Control Register                */
    
    struct {
      __IOM uint32_t CTM        : 2;            /*!< [1..0] Counter/Timer Mode                                                 */
            uint32_t            : 30;
    } CNTCTRL_b;
  } ;
  
  union {
    __IOM uint32_t MCTRL;                       /*!< (@ 0x00000014) Offset:0x14 CT16Bn Match Control Register                  */
    
    struct {
      __IOM uint32_t MR0IE      : 1;            /*!< [0..0] Enable generating an interrupt when MR0 matches TC                 */
      __IOM uint32_t MR0RST     : 1;            /*!< [1..1] Enable reset TC when MR0 matches TC                                */
      __IOM uint32_t MR0STOP    : 1;            /*!< [2..2] Stop TC and PC and clear CEN bit when MR0 matches TC               */
      __IOM uint32_t MR1IE      : 1;            /*!< [3..3] Enable generating an interrupt when MR1 matches TC                 */
      __IOM uint32_t MR1RST     : 1;            /*!< [4..4] Enable reset TC when MR1 matches TC                                */
      __IOM uint32_t MR1STOP    : 1;            /*!< [5..5] Stop TC and PC and clear CEN bit when MR1 matches TC               */
      __IOM uint32_t MR2IE      : 1;            /*!< [6..6] Enable generating an interrupt when MR2 matches TC                 */
      __IOM uint32_t MR2RST     : 1;            /*!< [7..7] Enable reset TC when MR2 matches TC                                */
      __IOM uint32_t MR2STOP    : 1;            /*!< [8..8] Stop TC and PC and clear CEN bit when MR2 matches TC               */
      __IOM uint32_t MR3IE      : 1;            /*!< [9..9] Enable generating an interrupt when MR3 matches TC                 */
      __IOM uint32_t MR3RST     : 1;            /*!< [10..10] Enable reset TC when MR3 matches TC                              */
      __IOM uint32_t MR3STOP    : 1;            /*!< [11..11] Stop TC and PC and clear CEN bit when MR3 matches TC             */
            uint32_t            : 9;
      __IOM uint32_t MR9IE      : 1;            /*!< [21..21] Enable generating an interrupt when MR9 matches TC               */
      __IOM uint32_t MR9RST     : 1;            /*!< [22..22] Enable reset TC when MR9 matches TC                              */
      __IOM uint32_t MR9STOP    : 1;            /*!< [23..23] Stop TC and PC and clear CEN bit when MR9 matches TC             */
      __OM  uint32_t PWMKEY     : 8;            /*!< [31..24] PWM register key.                                                */
    } MCTRL_b;
  } ;
  __IM  uint32_t  RESERVED[2];
  
  union {
    __IOM uint32_t MR0;                         /*!< (@ 0x00000020) Offset:0x20 CT16Bn MR0 Register                            */
    
    struct {
      __IOM uint32_t MR         : 16;           /*!< [15..0] Timer counter match value                                         */
            uint32_t            : 8;
      __OM  uint32_t PWMKEY     : 8;            /*!< [31..24] PWM register key.                                                */
    } MR0_b;
  } ;
  
  union {
    __IOM uint32_t MR1;                         /*!< (@ 0x00000024) Offset:0x24 CT16Bn MR1 Register                            */
    
    struct {
      __IOM uint32_t MR         : 16;           /*!< [15..0] Timer counter match value                                         */
            uint32_t            : 8;
      __OM  uint32_t PWMKEY     : 8;            /*!< [31..24] PWM register key.                                                */
    } MR1_b;
  } ;
  
  union {
    __IOM uint32_t MR2;                         /*!< (@ 0x00000028) Offset:0x28 CT16Bn MR2 Register                            */
    
    struct {
      __IOM uint32_t MR         : 16;           /*!< [15..0] Timer counter match value                                         */
            uint32_t            : 8;
      __OM  uint32_t PWMKEY     : 8;            /*!< [31..24] PWM register key.                                                */
    } MR2_b;
  } ;
  
  union {
    __IOM uint32_t MR3;                         /*!< (@ 0x0000002C) Offset:0x2C CT16Bn MR3 Register                            */
    
    struct {
      __IOM uint32_t MR         : 16;           /*!< [15..0] Timer counter match value                                         */
            uint32_t            : 8;
      __OM  uint32_t PWMKEY     : 8;            /*!< [31..24] PWM register key.                                                */
    } MR3_b;
  } ;
  __IM  uint32_t  RESERVED1[5];
  
  union {
    __IOM uint32_t MR9;                         /*!< (@ 0x00000044) Offset:0x44 CT16Bn MR9 Register                            */
    
    struct {
      __IOM uint32_t MR         : 16;           /*!< [15..0] Timer counter match value                                         */
            uint32_t            : 8;
      __OM  uint32_t PWMKEY     : 8;            /*!< [31..24] PWM register key.                                                */
    } MR9_b;
  } ;
  __IM  uint32_t  RESERVED2[15];
  
  union {
    __IOM uint32_t CAPCTRL;                     /*!< (@ 0x00000084) Offset:0x84 CT16Bn Capture Control Register                */
    
    struct {
      __IOM uint32_t CAP0RE     : 1;            /*!< [0..0] Capture/Reset on CT16Bn_CAP0 signal rising edge                    */
      __IOM uint32_t CAP0FE     : 1;            /*!< [1..1] Capture/Reset on CT16Bn_CAP0 signal falling edge                   */
      __IOM uint32_t CAP0IE     : 1;            /*!< [2..2] Interrupt on CT16Bn_CAP0 event                                     */
      __IOM uint32_t CAP0EN     : 1;            /*!< [3..3] CAP0 function enable                                               */
            uint32_t            : 28;
    } CAPCTRL_b;
  } ;
  
  union {
    __IM  uint32_t CAP0;                        /*!< (@ 0x00000088) Offset:0x88 CT16Bn CAP0 Register                           */
    
    struct {
      __IM  uint32_t CAP0       : 16;           /*!< [15..0] Timer counter capture value                                       */
            uint32_t            : 16;
    } CAP0_b;
  } ;
  
  union {
    __IOM uint32_t EM;                          /*!< (@ 0x0000008C) Offset:0x8C CT16Bn External Match Register                 */
    
    struct {
      __IOM uint32_t EM0        : 1;            /*!< [0..0] When the TC matches MR0, this bit will act according
                                                     to EMC0[1:0], and also drive the state of CT16Bn_PWM0 output.             */
      __IOM uint32_t EM1        : 1;            /*!< [1..1] When the TC matches MR1, this bit will act according
                                                     to EMC1[1:0], and also drive the state of CT16Bn_PWM1 output.             */
      __IOM uint32_t EM2        : 1;            /*!< [2..2] When the TC matches MR2, this bit will act according
                                                     to EMC2[1:0], and also drive the state of CT16Bn_PWM2 output.             */
      __IOM uint32_t EM3        : 1;            /*!< [3..3] When the TC matches MR3, this bit will act according
                                                     to EMC3[1:0], and also drive the state of CT16Bn_PWM3 output.             */
      __IOM uint32_t EMC0       : 2;            /*!< [5..4] CT16Bn_PWM0 functionality                                          */
      __IOM uint32_t EMC1       : 2;            /*!< [7..6] CT16Bn_PWM1 functionality                                          */
      __IOM uint32_t EMC2       : 2;            /*!< [9..8] CT16Bn_PWM2 functionality                                          */
      __IOM uint32_t EMC3       : 2;            /*!< [11..10] CT16Bn_PWM3 functionality                                        */
            uint32_t            : 12;
      __OM  uint32_t PWMKEY     : 8;            /*!< [31..24] PWM register key.                                                */
    } EM_b;
  } ;
  __IM  uint32_t  RESERVED3[2];
  
  union {
    __IOM uint32_t PWMCTRL;                     /*!< (@ 0x00000098) Offset:0x98 CT16Bn PWM Control Register                    */
    
    struct {
      __IOM uint32_t PWM0EN     : 1;            /*!< [0..0] PWM0 enable                                                        */
      __IOM uint32_t PWM1EN     : 1;            /*!< [1..1] PWM1 enable                                                        */
      __IOM uint32_t PWM2EN     : 1;            /*!< [2..2] PWM2 enable                                                        */
      __IOM uint32_t PWM3EN     : 1;            /*!< [3..3] PWM2 enable                                                        */
      __IOM uint32_t PWM0MODE   : 2;            /*!< [5..4] PWM0 output mode                                                   */
      __IOM uint32_t PWM1MODE   : 2;            /*!< [7..6] PWM1 output mode                                                   */
      __IOM uint32_t PWM2MODE   : 2;            /*!< [9..8] PWM2 output mode                                                   */
      __IOM uint32_t PWM3MODE   : 2;            /*!< [11..10] PWM3 output mode                                                 */
            uint32_t            : 8;
      __IOM uint32_t PWM0IOEN   : 1;            /*!< [20..20] CT16Bn_PWM0/GPIO selection                                       */
      __IOM uint32_t PWM1IOEN   : 1;            /*!< [21..21] CT16Bn_PWM1/GPIO selection                                       */
      __IOM uint32_t PWM2IOEN   : 1;            /*!< [22..22] CT16Bn_PWM2/GPIO selection                                       */
      __IOM uint32_t PWM3IOEN   : 1;            /*!< [23..23] CT16Bn_PWM3/GPIO selection                                       */
      __OM  uint32_t PWMKEY     : 8;            /*!< [31..24] PWM register key.                                                */
    } PWMCTRL_b;
  } ;
  __IM  uint32_t  RESERVED4[3];
  
  union {
    __IM  uint32_t RIS;                         /*!< (@ 0x000000A8) Offset:0xA8 CT16Bn Raw Interrupt Status Register           */
    
    struct {
      __IM  uint32_t MR0IF      : 1;            /*!< [0..0] Match channel 0 interrupt flag                                     */
      __IM  uint32_t MR1IF      : 1;            /*!< [1..1] Match channel 1 interrupt flag                                     */
      __IM  uint32_t MR2IF      : 1;            /*!< [2..2] Match channel 2 interrupt flag                                     */
      __IM  uint32_t MR3IF      : 1;            /*!< [3..3] Match channel 3 interrupt flag                                     */
      __IM  uint32_t CAP0IF     : 1;            /*!< [4..4] Capture channel 0 interrupt flag                                   */
      __IM  uint32_t MR9IF      : 1;            /*!< [5..5] Match channel 9 interrupt flag                                     */
            uint32_t            : 26;
    } RIS_b;
  } ;
  
  union {
    __OM  uint32_t IC;                          /*!< (@ 0x000000AC) Offset:0xAC CT16Bn Interrupt Clear Register                */
    
    struct {
      __OM  uint32_t MR0IC      : 1;            /*!< [0..0] MR0IF clear bit                                                    */
      __OM  uint32_t MR1IC      : 1;            /*!< [1..1] MR1IF clear bit                                                    */
      __OM  uint32_t MR2IC      : 1;            /*!< [2..2] MR2IF clear bit                                                    */
      __OM  uint32_t MR3IC      : 1;            /*!< [3..3] MR3IF clear bit                                                    */
      __OM  uint32_t CAP0IC     : 1;            /*!< [4..4] CAP0IF clear bit                                                   */
      __OM  uint32_t MR9IC      : 1;            /*!< [5..5] MR9IF clear bit                                                    */
            uint32_t            : 26;
    } IC_b;
  } ;
} SN_CT16B2_Type;                               /*!< Size = 176 (0xb0)                                                         */



/* =========================================================================================================================== */
/* ================                                         SN_CT16B3                                         ================ */
/* =========================================================================================================================== */


/**
  * @brief 16-bit Timer 3 with Capture function (SN_CT16B3)
  */

typedef struct {                                /*!< (@ 0x40006000) SN_CT16B3 Structure                                        */
  
  union {
    __IOM uint32_t TMRCTRL;                     /*!< (@ 0x00000000) Offset:0x00 CT16Bn Timer Control Register                  */
    
    struct {
      __IOM uint32_t CEN        : 1;            /*!< [0..0] Counter enable                                                     */
      __IOM uint32_t CRST       : 1;            /*!< [1..1] Counter Reset                                                      */
      __IOM uint32_t CLKSEL     : 1;            /*!< [2..2] PCLK source                                                        */
            uint32_t            : 29;
    } TMRCTRL_b;
  } ;
  
  union {
    __IOM uint32_t TC;                          /*!< (@ 0x00000004) Offset:0x04 CT16Bn Timer Counter Register                  */
    
    struct {
      __IOM uint32_t TC         : 16;           /*!< [15..0] Timer Counter                                                     */
            uint32_t            : 16;
    } TC_b;
  } ;
  
  union {
    __IOM uint32_t PRE;                         /*!< (@ 0x00000008) Offset:0x08 CT16Bn Prescale Register                       */
    
    struct {
      __IOM uint32_t PRE        : 8;            /*!< [7..0] Prescalzer                                                         */
            uint32_t            : 24;
    } PRE_b;
  } ;
  
  union {
    __IOM uint32_t PC;                          /*!< (@ 0x0000000C) Offset:0x0C CT16Bn Prescale Counter Register               */
    
    struct {
      __IOM uint32_t PC         : 8;            /*!< [7..0] Prescaler Counter                                                  */
            uint32_t            : 24;
    } PC_b;
  } ;
  
  union {
    __IOM uint32_t CNTCTRL;                     /*!< (@ 0x00000010) Offset:0x10 CT16Bn Counter Control Register                */
    
    struct {
      __IOM uint32_t CTM        : 2;            /*!< [1..0] Counter/Timer Mode                                                 */
            uint32_t            : 30;
    } CNTCTRL_b;
  } ;
  
  union {
    __IOM uint32_t MCTRL;                       /*!< (@ 0x00000014) Offset:0x14 CT16Bn Match Control Register                  */
    
    struct {
      __IOM uint32_t MR0IE      : 1;            /*!< [0..0] Enable generating an interrupt when MR0 matches TC                 */
      __IOM uint32_t MR0RST     : 1;            /*!< [1..1] Enable reset TC when MR0 matches TC                                */
      __IOM uint32_t MR0STOP    : 1;            /*!< [2..2] Stop TC and PC and clear CEN bit when MR0 matches TC               */
      __IOM uint32_t MR1IE      : 1;            /*!< [3..3] Enable generating an interrupt when MR1 matches TC                 */
      __IOM uint32_t MR1RST     : 1;            /*!< [4..4] Enable reset TC when MR1 matches TC                                */
      __IOM uint32_t MR1STOP    : 1;            /*!< [5..5] Stop TC and PC and clear CEN bit when MR1 matches TC               */
            uint32_t            : 15;
      __IOM uint32_t MR9IE      : 1;            /*!< [21..21] Enable generating an interrupt based on CM[2:0] when
                                                     MR9 matches the value in the TC                                           */
      __IOM uint32_t MR9RST     : 1;            /*!< [22..22] Enable reset TC when MR9 matches TC                              */
      __IOM uint32_t MR9STOP    : 1;            /*!< [23..23] Stop TC and PC and clear CEN bit when MR9 matches TC             */
      __OM  uint32_t PWMKEY     : 8;            /*!< [31..24] PWM register key.                                                */
    } MCTRL_b;
  } ;
  __IM  uint32_t  RESERVED[2];
  
  union {
    __IOM uint32_t MR0;                         /*!< (@ 0x00000020) Offset:0x20 CT16Bn MR0 Register                            */
    
    struct {
      __IOM uint32_t MR         : 16;           /*!< [15..0] Timer counter match value                                         */
            uint32_t            : 8;
      __OM  uint32_t PWMKEY     : 8;            /*!< [31..24] PWM register key.                                                */
    } MR0_b;
  } ;
  
  union {
    __IOM uint32_t MR1;                         /*!< (@ 0x00000024) Offset:0x24 CT16Bn MR1 Register                            */
    
    struct {
      __IOM uint32_t MR         : 16;           /*!< [15..0] Timer counter match value                                         */
            uint32_t            : 8;
      __OM  uint32_t PWMKEY     : 8;            /*!< [31..24] PWM register key.                                                */
    } MR1_b;
  } ;
  __IM  uint32_t  RESERVED1[7];
  
  union {
    __IOM uint32_t MR9;                         /*!< (@ 0x00000044) Offset:0x44 CT16Bn MR9 Register                            */
    
    struct {
      __IOM uint32_t MR         : 16;           /*!< [15..0] Timer counter match value                                         */
            uint32_t            : 8;
      __OM  uint32_t PWMKEY     : 8;            /*!< [31..24] PWM register key.                                                */
    } MR9_b;
  } ;
  __IM  uint32_t  RESERVED2[15];
  
  union {
    __IOM uint32_t CAPCTRL;                     /*!< (@ 0x00000084) Offset:0x84 CT16Bn Capture Control Register                */
    
    struct {
      __IOM uint32_t CAP0RE     : 1;            /*!< [0..0] Capture/Reset on CT16Bn_CAP0 signal rising edge                    */
      __IOM uint32_t CAP0FE     : 1;            /*!< [1..1] Capture/Reset on CT16Bn_CAP0 signal falling edge                   */
      __IOM uint32_t CAP0IE     : 1;            /*!< [2..2] Interrupt on CT16Bn_CAP0 event                                     */
      __IOM uint32_t CAP0EN     : 1;            /*!< [3..3] CAP0 function enable                                               */
            uint32_t            : 28;
    } CAPCTRL_b;
  } ;
  
  union {
    __IM  uint32_t CAP0;                        /*!< (@ 0x00000088) Offset:0x88 CT16Bn CAP0 Register                           */
    
    struct {
      __IM  uint32_t CAP0       : 16;           /*!< [15..0] Timer counter capture value                                       */
            uint32_t            : 16;
    } CAP0_b;
  } ;
  
  union {
    __IOM uint32_t EM;                          /*!< (@ 0x0000008C) Offset:0x8C CT16Bn External Match Register                 */
    
    struct {
      __IOM uint32_t EM0        : 1;            /*!< [0..0] When the TC matches MR0, this bit will act according
                                                     to EMC0[1:0], and also drive the state of CT16Bn_PWM0 output.             */
      __IOM uint32_t EM1        : 1;            /*!< [1..1] When the TC matches MR1, this bit will act according
                                                     to EMC1[1:0], and also drive the state of CT16Bn_PWM1 output.             */
            uint32_t            : 2;
      __IOM uint32_t EMC0       : 2;            /*!< [5..4] CT16Bn_PWM0 functionality                                          */
      __IOM uint32_t EMC1       : 2;            /*!< [7..6] CT16Bn_PWM1 functionality                                          */
            uint32_t            : 24;
    } EM_b;
  } ;
  __IM  uint32_t  RESERVED3[2];
  
  union {
    __IOM uint32_t PWMCTRL;                     /*!< (@ 0x00000098) Offset:0x98 CT16Bn PWM Control Register                    */
    
    struct {
      __IOM uint32_t PWM0EN     : 1;            /*!< [0..0] PWM0 enable                                                        */
      __IOM uint32_t PWM1EN     : 1;            /*!< [1..1] PWM1 enable                                                        */
            uint32_t            : 2;
      __IOM uint32_t PWM0MODE   : 2;            /*!< [5..4] PWM0 output mode                                                   */
      __IOM uint32_t PWM1MODE   : 2;            /*!< [7..6] PWM1 output mode                                                   */
            uint32_t            : 12;
      __IOM uint32_t PWM0IOEN   : 1;            /*!< [20..20] CT16Bn_PWM0/GPIO selection                                       */
      __IOM uint32_t PWM1IOEN   : 1;            /*!< [21..21] CT16Bn_PWM1/GPIO selection                                       */
            uint32_t            : 2;
      __OM  uint32_t PWMKEY     : 8;            /*!< [31..24] PWM register key.                                                */
    } PWMCTRL_b;
  } ;
  __IM  uint32_t  RESERVED4[3];
  
  union {
    __IM  uint32_t RIS;                         /*!< (@ 0x000000A8) Offset:0xA8 CT16Bn Raw Interrupt Status Register           */
    
    struct {
      __IM  uint32_t MR0IF      : 1;            /*!< [0..0] Match channel 0 interrupt flag                                     */
      __IM  uint32_t MR1IF      : 1;            /*!< [1..1] Match channel 1 interrupt flag                                     */
            uint32_t            : 2;
      __IM  uint32_t CAP0IF     : 1;            /*!< [4..4] Capture channel 0 interrupt flag                                   */
      __IM  uint32_t MR9IF      : 1;            /*!< [5..5] Match channel 9 interrupt flag                                     */
            uint32_t            : 26;
    } RIS_b;
  } ;
  
  union {
    __OM  uint32_t IC;                          /*!< (@ 0x000000AC) Offset:0xAC CT16Bn Interrupt Clear Register                */
    
    struct {
      __OM  uint32_t MR0IC      : 1;            /*!< [0..0] MR0IF clear bit                                                    */
      __OM  uint32_t MR1IC      : 1;            /*!< [1..1] MR1IF clear bit                                                    */
            uint32_t            : 2;
      __OM  uint32_t CAP0IC     : 1;            /*!< [4..4] CAP0IF clear bit                                                   */
      __OM  uint32_t MR9IC      : 1;            /*!< [5..5] MR9IF clear bit                                                    */
            uint32_t            : 26;
    } IC_b;
  } ;
  
  union {
    __IOM uint32_t PWMmNIOCTRL;                 /*!< (@ 0x000000B0) Offset:0xB0 CT16Bn PWMmN IO Control register               */
    
    struct {
      __IOM uint32_t PWM0NIOEN  : 2;            /*!< [1..0] CT16Bn_PWM0N/GPIO selection bit                                    */
      __IOM uint32_t PWM1NIOEN  : 2;            /*!< [3..2] CT16Bn_PWM0N/GPIO selection bit                                    */
            uint32_t            : 20;
      __OM  uint32_t PWMKEY     : 8;            /*!< [31..24] PWM register key.                                                */
    } PWMmNIOCTRL_b;
  } ;
  
  union {
    __IOM uint32_t PWM0NDB;                     /*!< (@ 0x000000B4) Offset:0xB4 CT16Bn PWM0N Dead-band Period Register         */
    
    struct {
      __IOM uint32_t DB         : 10;           /*!< [9..0] PWM0N output dead-band period time=DB*CT16Bn_PCLK*(PR+1)
                                                     cycle                                                                     */
            uint32_t            : 14;
      __OM  uint32_t PWMKEY     : 8;            /*!< [31..24] PWM register key.                                                */
    } PWM0NDB_b;
  } ;
  
  union {
    __IOM uint32_t PWM1NDB;                     /*!< (@ 0x000000B8) Offset:0xB8 CT16Bn PWM1N Dead-band Period Register         */
    
    struct {
      __IOM uint32_t DB         : 10;           /*!< [9..0] PWM1N output dead-band period time=DB*CT16Bn_PCLK*(PR+1)
                                                     cycle                                                                     */
            uint32_t            : 14;
      __OM  uint32_t PWMKEY     : 8;            /*!< [31..24] PWM register key.                                                */
    } PWM1NDB_b;
  } ;
} SN_CT16B3_Type;                               /*!< Size = 188 (0xbc)                                                         */



/* =========================================================================================================================== */
/* ================                                         SN_CT16B5                                         ================ */
/* =========================================================================================================================== */


/**
  * @brief 16-bit Timer 5 with Capture function (SN_CT16B5)
  */

typedef struct {                                /*!< (@ 0x4000A000) SN_CT16B5 Structure                                        */
  
  union {
    __IOM uint32_t TMRCTRL;                     /*!< (@ 0x00000000) Offset:0x00 CT16Bn Timer Control Register                  */
    
    struct {
      __IOM uint32_t CEN        : 1;            /*!< [0..0] Counter enable                                                     */
      __IOM uint32_t CRST       : 1;            /*!< [1..1] Counter Reset                                                      */
      __IOM uint32_t CLKSEL     : 2;            /*!< [3..2] PCLK source                                                        */
      __IOM uint32_t CM         : 3;            /*!< [6..4] Counting mode selection                                            */
            uint32_t            : 25;
    } TMRCTRL_b;
  } ;
  
  union {
    __IOM uint32_t TC;                          /*!< (@ 0x00000004) Offset:0x04 CT16Bn Timer Counter Register                  */
    
    struct {
      __IOM uint32_t TC         : 16;           /*!< [15..0] Timer Counter                                                     */
            uint32_t            : 16;
    } TC_b;
  } ;
  
  union {
    __IOM uint32_t PRE;                         /*!< (@ 0x00000008) Offset:0x08 CT16Bn Prescale Register                       */
    
    struct {
      __IOM uint32_t PRE        : 8;            /*!< [7..0] Prescalzer                                                         */
            uint32_t            : 24;
    } PRE_b;
  } ;
  
  union {
    __IOM uint32_t PC;                          /*!< (@ 0x0000000C) Offset:0x0C CT16Bn Prescale Counter Register               */
    
    struct {
      __IOM uint32_t PC         : 8;            /*!< [7..0] Prescaler Counter                                                  */
            uint32_t            : 24;
    } PC_b;
  } ;
  
  union {
    __IOM uint32_t CNTCTRL;                     /*!< (@ 0x00000010) Offset:0x10 CT16Bn Counter Control Register                */
    
    struct {
      __IOM uint32_t CTM        : 2;            /*!< [1..0] Counter/Timer Mode                                                 */
            uint32_t            : 30;
    } CNTCTRL_b;
  } ;
  
  union {
    __IOM uint32_t MCTRL;                       /*!< (@ 0x00000014) Offset:0x14 CT16Bn Match Control Register                  */
    
    struct {
      __IOM uint32_t MR0IE      : 1;            /*!< [0..0] Enable generating an interrupt when MR0 matches TC                 */
      __IOM uint32_t MR0RST     : 1;            /*!< [1..1] Enable reset TC when MR0 matches TC                                */
      __IOM uint32_t MR0STOP    : 1;            /*!< [2..2] Stop TC and PC and clear CEN bit when MR0 matches TC               */
      __IOM uint32_t MR1IE      : 1;            /*!< [3..3] Enable generating an interrupt when MR1 matches TC                 */
      __IOM uint32_t MR1RST     : 1;            /*!< [4..4] Enable reset TC when MR1 matches TC                                */
      __IOM uint32_t MR1STOP    : 1;            /*!< [5..5] Stop TC and PC and clear CEN bit when MR1 matches TC               */
      __IOM uint32_t MR2IE      : 1;            /*!< [6..6] Enable generating an interrupt when MR2 matches TC                 */
      __IOM uint32_t MR2RST     : 1;            /*!< [7..7] Enable reset TC when MR2 matches TC                                */
      __IOM uint32_t MR2STOP    : 1;            /*!< [8..8] Stop TC and PC and clear CEN bit when MR2 matches TC               */
      __IOM uint32_t MR3IE      : 1;            /*!< [9..9] Enable generating an interrupt when MR3 matches TC                 */
      __IOM uint32_t MR3RST     : 1;            /*!< [10..10] Enable reset TC when MR3 matches TC                              */
      __IOM uint32_t MR3STOP    : 1;            /*!< [11..11] Stop TC and PC and clear CEN bit when MR3 matches TC             */
            uint32_t            : 9;
      __IOM uint32_t MR9IE      : 1;            /*!< [21..21] Enable generating an interrupt based on CM[2:0] when
                                                     MR9 matches the value in the TC                                           */
      __IOM uint32_t MR9RST     : 1;            /*!< [22..22] Enable reset TC when MR9 matches TC                              */
      __IOM uint32_t MR9STOP    : 1;            /*!< [23..23] Stop TC and PC and clear CEN bit when MR9 matches TC             */
      __OM  uint32_t PWMKEY     : 8;            /*!< [31..24] PWM register key.                                                */
    } MCTRL_b;
  } ;
  __IM  uint32_t  RESERVED[2];
  
  union {
    __IOM uint32_t MR0;                         /*!< (@ 0x00000020) Offset:0x20 CT16Bn MR0 Register                            */
    
    struct {
      __IOM uint32_t MR         : 16;           /*!< [15..0] Timer counter match value                                         */
            uint32_t            : 8;
      __OM  uint32_t PWMKEY     : 8;            /*!< [31..24] PWM register key.                                                */
    } MR0_b;
  } ;
  
  union {
    __IOM uint32_t MR1;                         /*!< (@ 0x00000024) Offset:0x24 CT16Bn MR1 Register                            */
    
    struct {
      __IOM uint32_t MR         : 16;           /*!< [15..0] Timer counter match value                                         */
            uint32_t            : 8;
      __OM  uint32_t PWMKEY     : 8;            /*!< [31..24] PWM register key                                                 */
    } MR1_b;
  } ;
  
  union {
    __IOM uint32_t MR2;                         /*!< (@ 0x00000028) Offset:0x28 CT16Bn MR2 Register                            */
    
    struct {
      __IOM uint32_t MR         : 16;           /*!< [15..0] Timer counter match value                                         */
            uint32_t            : 8;
      __OM  uint32_t PWMKEY     : 8;            /*!< [31..24] PWM register key                                                 */
    } MR2_b;
  } ;
  
  union {
    __IOM uint32_t MR3;                         /*!< (@ 0x0000002C) Offset:0x2C CT16Bn MR3 Register                            */
    
    struct {
      __IOM uint32_t MR         : 16;           /*!< [15..0] Timer counter match value                                         */
            uint32_t            : 8;
      __OM  uint32_t PWMKEY     : 8;            /*!< [31..24] PWM register key                                                 */
    } MR3_b;
  } ;
  __IM  uint32_t  RESERVED1[5];
  
  union {
    __IOM uint32_t MR9;                         /*!< (@ 0x00000044) Offset:0x44 CT16Bn MR9 Register                            */
    
    struct {
      __IOM uint32_t MR         : 16;           /*!< [15..0] Timer counter match value                                         */
            uint32_t            : 8;
      __OM  uint32_t PWMKEY     : 8;            /*!< [31..24] PWM register key                                                 */
    } MR9_b;
  } ;
  __IM  uint32_t  RESERVED2[15];
  
  union {
    __IOM uint32_t CAPCTRL;                     /*!< (@ 0x00000084) Offset:0x84 CT16Bn Capture Control Register                */
    
    struct {
      __IOM uint32_t CAP0RE     : 1;            /*!< [0..0] Capture/Reset on CT16Bn_CAP0 signal rising edge                    */
      __IOM uint32_t CAP0FE     : 1;            /*!< [1..1] Capture/Reset on CT16Bn_CAP0 signal falling edge                   */
      __IOM uint32_t CAP0IE     : 1;            /*!< [2..2] Interrupt on CT16Bn_CAP0 event                                     */
      __IOM uint32_t CAP0EN     : 1;            /*!< [3..3] CAP0 function enable                                               */
            uint32_t            : 28;
    } CAPCTRL_b;
  } ;
  
  union {
    __IM  uint32_t CAP0;                        /*!< (@ 0x00000088) Offset:0x88 CT16Bn CAP0 Register                           */
    
    struct {
      __IM  uint32_t CAP0       : 16;           /*!< [15..0] Timer counter capture value                                       */
            uint32_t            : 16;
    } CAP0_b;
  } ;
  
  union {
    __IOM uint32_t EM;                          /*!< (@ 0x0000008C) Offset:0x8C CT16Bn External Match Register                 */
    
    struct {
      __IOM uint32_t EM0        : 1;            /*!< [0..0] When the TC matches MR0, this bit will act according
                                                     to EMC0[1:0], and also drive the state of CT16Bn_PWM0 output.             */
      __IOM uint32_t EM1        : 1;            /*!< [1..1] When the TC matches MR1, this bit will act according
                                                     to EMC1[1:0], and also drive the state of CT16Bn_PWM1 output.             */
      __IOM uint32_t EM2        : 1;            /*!< [2..2] When the TC matches MR2, this bit will act according
                                                     to EMC2[1:0], and also drive the state of CT16Bn_PWM2 output.             */
      __IOM uint32_t EM3        : 1;            /*!< [3..3] When the TC matches MR3, this bit will act according
                                                     to EMC3[1:0], and also drive the state of CT16Bn_PWM3 output.             */
      __IOM uint32_t EMC0       : 2;            /*!< [5..4] CT16Bn_PWM0 functionality                                          */
      __IOM uint32_t EMC1       : 2;            /*!< [7..6] CT16Bn_PWM1 functionality                                          */
      __IOM uint32_t EMC2       : 2;            /*!< [9..8] CT16Bn_PWM2 functionality                                          */
      __IOM uint32_t EMC3       : 2;            /*!< [11..10] CT16Bn_PWM3 functionality                                        */
            uint32_t            : 12;
      __OM  uint32_t PWMKEY     : 8;            /*!< [31..24] PWM register key.                                                */
    } EM_b;
  } ;
  __IM  uint32_t  RESERVED3[2];
  
  union {
    __IOM uint32_t PWMCTRL;                     /*!< (@ 0x00000098) Offset:0x98 CT16Bn PWM Control Register                    */
    
    struct {
      __IOM uint32_t PWM0EN     : 1;            /*!< [0..0] PWM0 enable                                                        */
      __IOM uint32_t PWM1EN     : 1;            /*!< [1..1] PWM1 enable                                                        */
      __IOM uint32_t PWM2EN     : 1;            /*!< [2..2] PWM2 enable                                                        */
      __IOM uint32_t PWM3EN     : 1;            /*!< [3..3] PWM2 enable                                                        */
      __IOM uint32_t PWM0MODE   : 2;            /*!< [5..4] PWM0 output mode                                                   */
      __IOM uint32_t PWM1MODE   : 2;            /*!< [7..6] PWM1 output mode                                                   */
      __IOM uint32_t PWM2MODE   : 2;            /*!< [9..8] PWM2 output mode                                                   */
      __IOM uint32_t PWM3MODE   : 2;            /*!< [11..10] PWM3 output mode                                                 */
            uint32_t            : 8;
      __IOM uint32_t PWM0IOEN   : 1;            /*!< [20..20] CT16Bn_PWM0/GPIO selection                                       */
      __IOM uint32_t PWM1IOEN   : 1;            /*!< [21..21] CT16Bn_PWM1/GPIO selection                                       */
      __IOM uint32_t PWM2IOEN   : 1;            /*!< [22..22] CT16Bn_PWM2/GPIO selection                                       */
      __IOM uint32_t PWM3IOEN   : 1;            /*!< [23..23] CT16Bn_PWM3/GPIO selection                                       */
      __OM  uint32_t PWMKEY     : 8;            /*!< [31..24] PWM register key.                                                */
    } PWMCTRL_b;
  } ;
  __IM  uint32_t  RESERVED4[3];
  
  union {
    __IM  uint32_t RIS;                         /*!< (@ 0x000000A8) Offset:0xA8 CT16Bn Raw Interrupt Status Register           */
    
    struct {
      __IM  uint32_t MR0IF      : 1;            /*!< [0..0] Match channel 0 interrupt flag                                     */
      __IM  uint32_t MR1IF      : 1;            /*!< [1..1] Match channel 1 interrupt flag                                     */
      __IM  uint32_t MR2IF      : 1;            /*!< [2..2] Match channel 2 interrupt flag                                     */
      __IM  uint32_t MR3IF      : 1;            /*!< [3..3] Match channel 3 interrupt flag                                     */
      __IM  uint32_t CAP0IF     : 1;            /*!< [4..4] Capture channel 0 interrupt flag                                   */
      __IM  uint32_t MR9IF      : 1;            /*!< [5..5] Match channel 9 interrupt flag                                     */
            uint32_t            : 26;
    } RIS_b;
  } ;
  
  union {
    __OM  uint32_t IC;                          /*!< (@ 0x000000AC) Offset:0xAC CT16Bn Interrupt Clear Register                */
    
    struct {
      __OM  uint32_t MR0IC      : 1;            /*!< [0..0] MR0IF clear bit                                                    */
      __OM  uint32_t MR1IC      : 1;            /*!< [1..1] MR1IF clear bit                                                    */
      __OM  uint32_t MR2IC      : 1;            /*!< [2..2] MR2IF clear bit                                                    */
      __OM  uint32_t MR3IC      : 1;            /*!< [3..3] MR3IF clear bit                                                    */
      __OM  uint32_t CAP0IC     : 1;            /*!< [4..4] CAP0IF clear bit                                                   */
      __OM  uint32_t MR9IC      : 1;            /*!< [5..5] MR9IF clear bit                                                    */
            uint32_t            : 26;
    } IC_b;
  } ;
} SN_CT16B5_Type;                               /*!< Size = 176 (0xb0)                                                         */



/* =========================================================================================================================== */
/* ================                                          SN_WDT                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief Watchdog Timer (SN_WDT)
  */

typedef struct {                                /*!< (@ 0x40010000) SN_WDT Structure                                           */
  
  union {
    __IOM uint32_t CFG;                         /*!< (@ 0x00000000) Offset:0x00 WDT Configuration Register                     */
    
    struct {
      __IOM uint32_t WDTEN      : 1;            /*!< [0..0] WDT enable                                                         */
      __IOM uint32_t WDTIE      : 1;            /*!< [1..1] WDT interrupt enable                                               */
      __IOM uint32_t WDTINT     : 1;            /*!< [2..2] WDT interrupt flag                                                 */
            uint32_t            : 13;
      __OM  uint32_t WDKEY      : 16;           /*!< [31..16] WDT register key                                                 */
    } CFG_b;
  } ;
  __IM  uint32_t  RESERVED;
  
  union {
    __IOM uint32_t TC;                          /*!< (@ 0x00000008) Offset:0x08 WDT Timer Constant Register                    */
    
    struct {
      __IOM uint32_t TC         : 8;            /*!< [7..0] Watchdog timer constant reload value                               */
            uint32_t            : 8;
      __OM  uint32_t WDKEY      : 16;           /*!< [31..16] WDT register key                                                 */
    } TC_b;
  } ;
  
  union {
    __OM  uint32_t FEED;                        /*!< (@ 0x0000000C) Offset:0x0C WDT Feed Register                              */
    
    struct {
      __OM  uint32_t FV         : 16;           /*!< [15..0] Watchdog feed value                                               */
      __OM  uint32_t WDKEY      : 16;           /*!< [31..16] WDT register key                                                 */
    } FEED_b;
  } ;
} SN_WDT_Type;                                  /*!< Size = 16 (0x10)                                                          */



/* =========================================================================================================================== */
/* ================                                          SN_RTC                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief Real-time Clock (SN_RTC)
  */

typedef struct {                                /*!< (@ 0x40012000) SN_RTC Structure                                           */
  
  union {
    __IOM uint32_t CTRL;                        /*!< (@ 0x00000000) Offset:0x00 RTC Control Register                           */
    
    struct {
      __IOM uint32_t RTCEN      : 1;            /*!< [0..0] RTC enable                                                         */
            uint32_t            : 31;
    } CTRL_b;
  } ;
  
  union {
    __IOM uint32_t CLKS;                        /*!< (@ 0x00000004) Offset:0x04 RTC Clock Source Register                      */
    
    struct {
      __IOM uint32_t CLKSEL     : 1;            /*!< [0..0] RTC clock source                                                   */
            uint32_t            : 31;
    } CLKS_b;
  } ;
  
  union {
    __IOM uint32_t IE;                          /*!< (@ 0x00000008) Offset:0x08 RTC Interrupt Enable Register                  */
    
    struct {
      __IOM uint32_t SECIE      : 1;            /*!< [0..0] Second interrupt enable                                            */
            uint32_t            : 31;
    } IE_b;
  } ;
  
  union {
    __IM  uint32_t RIS;                         /*!< (@ 0x0000000C) Offset:0x0C RTC Raw Interrupt Status Register              */
    
    struct {
      __IM  uint32_t SECIF      : 1;            /*!< [0..0] Second interrupt flag                                              */
            uint32_t            : 31;
    } RIS_b;
  } ;
  
  union {
    __OM  uint32_t IC;                          /*!< (@ 0x00000010) Offset:0x10 RTC Interrupt Clear Register                   */
    
    struct {
      __OM  uint32_t SECIC      : 1;            /*!< [0..0] Second interrupt flag clear                                        */
            uint32_t            : 31;
    } IC_b;
  } ;
  __IOM uint32_t  SECCNTV;                      /*!< (@ 0x00000014) Offset:0x14 RTC Second Counter Reload Value Register       */
  __IM  uint32_t  SECCNT;                       /*!< (@ 0x00000018) Offset:0x18 RTC Second Counter Register                    */
} SN_RTC_Type;                                  /*!< Size = 28 (0x1c)                                                          */



/* =========================================================================================================================== */
/* ================                                          SN_SPI0                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief SPI0 (SN_SPI0)
  */

typedef struct {                                /*!< (@ 0x4001C000) SN_SPI0 Structure                                          */
  
  union {
    __IOM uint32_t CTRL0;                       /*!< (@ 0x00000000) Offset:0x00 SPI0 Control Register 0                        */
    
    struct {
      __IOM uint32_t SPIEN      : 1;            /*!< [0..0] SPI enable                                                         */
      __IOM uint32_t LOOPBACK   : 1;            /*!< [1..1] Loopback mode enable                                               */
      __IOM uint32_t SDODIS     : 1;            /*!< [2..2] Slave data out disable                                             */
      __IOM uint32_t MS         : 1;            /*!< [3..3] Master/Slave selection                                             */
      __IOM uint32_t FORMAT     : 1;            /*!< [4..4] Interface format                                                   */
            uint32_t            : 1;
      __OM  uint32_t FRESET     : 2;            /*!< [7..6] SPI FSM and FIFO Reset                                             */
      __IOM uint32_t DL         : 4;            /*!< [11..8] Data length = DL[3:0]+1                                           */
      __IOM uint32_t TXFIFOTH   : 3;            /*!< [14..12] TX FIFO Threshold level                                          */
      __IOM uint32_t RXFIFOTH   : 3;            /*!< [17..15] RX FIFO Threshold level                                          */
      __IOM uint32_t SELDIS     : 1;            /*!< [18..18] Auto-SEL disable bit                                             */
            uint32_t            : 13;
    } CTRL0_b;
  } ;
  
  union {
    __IOM uint32_t CTRL1;                       /*!< (@ 0x00000004) Offset:0x04 SPI0 Control Register 1                        */
    
    struct {
      __IOM uint32_t MLSB       : 1;            /*!< [0..0] MSB/LSB seletion                                                   */
      __IOM uint32_t CPOL       : 1;            /*!< [1..1] Clock priority selection                                           */
      __IOM uint32_t CPHA       : 1;            /*!< [2..2] Clock phase of edge sampling                                       */
            uint32_t            : 29;
    } CTRL1_b;
  } ;
  
  union {
    __IOM uint32_t CLKDIV;                      /*!< (@ 0x00000008) Offset:0x08 SPI0 Clock Divider Register                    */
    
    struct {
      __IOM uint32_t DIV        : 8;            /*!< [7..0] SPI0 SCK                                                           */
            uint32_t            : 24;
    } CLKDIV_b;
  } ;
  
  union {
    __IM  uint32_t STAT;                        /*!< (@ 0x0000000C) Offset:0x0C SPI0 Status Register                           */
    
    struct {
      __IM  uint32_t TX_EMPTY   : 1;            /*!< [0..0] TX FIFO empty flag                                                 */
      __IM  uint32_t TX_FULL    : 1;            /*!< [1..1] TX FIFO full flag                                                  */
      __IM  uint32_t RX_EMPTY   : 1;            /*!< [2..2] RX FIFO empty flag                                                 */
      __IM  uint32_t RX_FULL    : 1;            /*!< [3..3] RX FIFO full flag                                                  */
      __IM  uint32_t BUSY       : 1;            /*!< [4..4] Busy flag                                                          */
      __IM  uint32_t TXFIFOTHF  : 1;            /*!< [5..5] TX FIFO threshold flag                                             */
      __IM  uint32_t RXFIFOTHF  : 1;            /*!< [6..6] RX FIFO threshold flag                                             */
            uint32_t            : 25;
    } STAT_b;
  } ;
  
  union {
    __IOM uint32_t IE;                          /*!< (@ 0x00000010) Offset:0x10 SPI0 Interrupt Enable Register                 */
    
    struct {
      __IOM uint32_t RXOVFIE    : 1;            /*!< [0..0] RX FIFO overflow interrupt enable                                  */
      __IOM uint32_t RXTOIE     : 1;            /*!< [1..1] RX time-out interrupt enable                                       */
      __IOM uint32_t RXFIFOTHIE : 1;            /*!< [2..2] RX FIFO threshold interrupt enable                                 */
      __IOM uint32_t TXFIFOTHIE : 1;            /*!< [3..3] TX FIFO threshold interrupt enable                                 */
      __IOM uint32_t DMAHTIE    : 1;            /*!< [4..4] DMA half transfer interrupt enable bit                             */
      __IOM uint32_t DMATCIE    : 1;            /*!< [5..5] DMA transfer complete interrupt enable bit                         */
            uint32_t            : 26;
    } IE_b;
  } ;
  
  union {
    __IM  uint32_t RIS;                         /*!< (@ 0x00000014) Offset:0x14 SPI0 Raw Interrupt Status Register             */
    
    struct {
      __IM  uint32_t RXOVFIF    : 1;            /*!< [0..0] RX FIFO overflow interrupt flag                                    */
      __IM  uint32_t RXTOIF     : 1;            /*!< [1..1] RX time-out interrupt flag                                         */
      __IM  uint32_t RXFIFOTHIF : 1;            /*!< [2..2] RX FIFO threshold interrupt flag                                   */
      __IM  uint32_t TXFIFOTHIF : 1;            /*!< [3..3] TX FIFO threshold interrupt flag                                   */
      __IM  uint32_t DMAHTIF    : 1;            /*!< [4..4] RX FIFO threshold interrupt flag                                   */
      __IM  uint32_t DMATCIF    : 1;            /*!< [5..5] DMA transfer complete flag                                         */
            uint32_t            : 26;
    } RIS_b;
  } ;
  
  union {
    __OM  uint32_t IC;                          /*!< (@ 0x00000018) Offset:0x18 SPI0 Interrupt Clear Register                  */
    
    struct {
      __OM  uint32_t RXOVFIC    : 1;            /*!< [0..0] RX FIFO overflow flag clear                                        */
      __OM  uint32_t RXTOIC     : 1;            /*!< [1..1] RX time-out interrupt flag clear                                   */
      __OM  uint32_t RXFIFOTHIC : 1;            /*!< [2..2] RX Interrupt flag Clear                                            */
      __OM  uint32_t TXFIFOTHIC : 1;            /*!< [3..3] TX Interrupt flag Clear                                            */
      __OM  uint32_t DMAHTIC    : 1;            /*!< [4..4] Select the DMAHTIF flag to be cleared                              */
      __OM  uint32_t DMATCIC    : 1;            /*!< [5..5] Select the DMATCIF flag to be cleared                              */
            uint32_t            : 26;
    } IC_b;
  } ;
  
  union {
    __IOM uint32_t DATA;                        /*!< (@ 0x0000001C) Offset:0x1C SPI0 Data Register                             */
    
    struct {
      __IOM uint32_t Data       : 16;           /*!< [15..0] Data                                                              */
            uint32_t            : 16;
    } DATA_b;
  } ;
  
  union {
    __IOM uint32_t DFDLY;                       /*!< (@ 0x00000020) Offset:0x20 SPI0 Data Fetch Register                       */
    
    struct {
      __IOM uint32_t DFETCH_EN  : 1;            /*!< [0..0] SPI0 data fetch control bit                                        */
            uint32_t            : 31;
    } DFDLY_b;
  } ;
  
  union {
    __IOM uint32_t DMACTRL;                     /*!< (@ 0x00000024) Offset:0x24 SPI0 DMA Control register                      */
    
    struct {
      __IOM uint32_t DMAEN      : 1;            /*!< [0..0] SPI to SPI DMA enable bit                                          */
      __IOM uint32_t DIR        : 1;            /*!< [1..1] SPI data transfer direction                                        */
            uint32_t            : 30;
    } DMACTRL_b;
  } ;
  
  union {
    __IOM uint32_t DMACNT;                      /*!< (@ 0x00000028) Offset:0x28 SPI0 DMA Control register                      */
    
    struct {
      __IOM uint32_t CNT        : 28;           /*!< [27..0] Number of data to DMA RX count transfer                           */
            uint32_t            : 4;
    } DMACNT_b;
  } ;
  
  union {
    __IOM uint32_t DMAHTCNT;                    /*!< (@ 0x0000002C) Offset:0x2C SPI0 DMA Control register                      */
    
    struct {
      __IOM uint32_t HTCNT      : 28;           /*!< [27..0] Number of data to DMA RX half count transfer                      */
            uint32_t            : 4;
    } DMAHTCNT_b;
  } ;
  
  union {
    __IM  uint32_t CURCNT;                      /*!< (@ 0x00000030) Offset:0x30 SPI0 DMA Control register                      */
    
    struct {
      __IM  uint32_t CURCNT     : 28;           /*!< [27..0] This field indicates DMA current transfer data counter
                                                     pointer.                                                                  */
            uint32_t            : 4;
    } CURCNT_b;
  } ;
} SN_SPI0_Type;                                 /*!< Size = 52 (0x34)                                                          */



/* =========================================================================================================================== */
/* ================                                          SN_SPI1                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief SPI1 (SN_SPI1)
  */

typedef struct {                                /*!< (@ 0x40058000) SN_SPI1 Structure                                          */
  
  union {
    __IOM uint32_t CTRL0;                       /*!< (@ 0x00000000) Offset:0x00 SPI1 Control Register 0                        */
    
    struct {
      __IOM uint32_t SPIEN      : 1;            /*!< [0..0] SPI enable                                                         */
      __IOM uint32_t LOOPBACK   : 1;            /*!< [1..1] Loopback mode enable                                               */
      __IOM uint32_t SDODIS     : 1;            /*!< [2..2] Slave data out disable                                             */
      __IOM uint32_t MS         : 1;            /*!< [3..3] Master/Slave selection                                             */
      __IOM uint32_t FORMAT     : 1;            /*!< [4..4] Interface format                                                   */
            uint32_t            : 1;
      __OM  uint32_t FRESET     : 2;            /*!< [7..6] SPI FSM and FIFO Reset                                             */
      __IOM uint32_t DL         : 4;            /*!< [11..8] Data length = DL[3:0]+1                                           */
      __IOM uint32_t TXFIFOTH   : 3;            /*!< [14..12] TX FIFO Threshold level                                          */
      __IOM uint32_t RXFIFOTH   : 3;            /*!< [17..15] RX FIFO Threshold level                                          */
      __IOM uint32_t SELDIS     : 1;            /*!< [18..18] Auto-SEL disable bit                                             */
            uint32_t            : 13;
    } CTRL0_b;
  } ;
  
  union {
    __IOM uint32_t CTRL1;                       /*!< (@ 0x00000004) Offset:0x04 SPI1 Control Register 1                        */
    
    struct {
      __IOM uint32_t MLSB       : 1;            /*!< [0..0] MSB/LSB seletion                                                   */
      __IOM uint32_t CPOL       : 1;            /*!< [1..1] Clock priority selection                                           */
      __IOM uint32_t CPHA       : 1;            /*!< [2..2] Clock phase of edge sampling                                       */
            uint32_t            : 29;
    } CTRL1_b;
  } ;
  
  union {
    __IOM uint32_t CLKDIV;                      /*!< (@ 0x00000008) Offset:0x08 SPI1 Clock Divider Register                    */
    
    struct {
      __IOM uint32_t DIV        : 8;            /*!< [7..0] SPI1 SCK                                                           */
            uint32_t            : 24;
    } CLKDIV_b;
  } ;
  
  union {
    __IM  uint32_t STAT;                        /*!< (@ 0x0000000C) Offset:0x0C SPI1 Status Register                           */
    
    struct {
      __IM  uint32_t TX_EMPTY   : 1;            /*!< [0..0] TX FIFO empty flag                                                 */
      __IM  uint32_t TX_FULL    : 1;            /*!< [1..1] TX FIFO full flag                                                  */
      __IM  uint32_t RX_EMPTY   : 1;            /*!< [2..2] RX FIFO empty flag                                                 */
      __IM  uint32_t RX_FULL    : 1;            /*!< [3..3] RX FIFO full flag                                                  */
      __IM  uint32_t BUSY       : 1;            /*!< [4..4] Busy flag                                                          */
      __IM  uint32_t TXFIFOTHF  : 1;            /*!< [5..5] TX FIFO threshold flag                                             */
      __IM  uint32_t RXFIFOTHF  : 1;            /*!< [6..6] RX FIFO threshold flag                                             */
            uint32_t            : 25;
    } STAT_b;
  } ;
  
  union {
    __IOM uint32_t IE;                          /*!< (@ 0x00000010) Offset:0x10 SPI1 Interrupt Enable Register                 */
    
    struct {
      __IOM uint32_t RXOVFIE    : 1;            /*!< [0..0] RX FIFO overflow interrupt enable                                  */
      __IOM uint32_t RXTOIE     : 1;            /*!< [1..1] RX time-out interrupt enable                                       */
      __IOM uint32_t RXFIFOTHIE : 1;            /*!< [2..2] RX FIFO threshold interrupt enable                                 */
      __IOM uint32_t TXFIFOTHIE : 1;            /*!< [3..3] TX FIFO threshold interrupt enable                                 */
            uint32_t            : 28;
    } IE_b;
  } ;
  
  union {
    __IM  uint32_t RIS;                         /*!< (@ 0x00000014) Offset:0x14 SPI1 Raw Interrupt Status Register             */
    
    struct {
      __IM  uint32_t RXOVFIF    : 1;            /*!< [0..0] RX FIFO overflow interrupt flag                                    */
      __IM  uint32_t RXTOIF     : 1;            /*!< [1..1] RX time-out interrupt flag                                         */
      __IM  uint32_t RXFIFOTHIF : 1;            /*!< [2..2] RX FIFO threshold interrupt flag                                   */
      __IM  uint32_t TXFIFOTHIF : 1;            /*!< [3..3] TX FIFO threshold interrupt flag                                   */
            uint32_t            : 28;
    } RIS_b;
  } ;
  
  union {
    __OM  uint32_t IC;                          /*!< (@ 0x00000018) Offset:0x18 SPI1 Interrupt Clear Register                  */
    
    struct {
      __OM  uint32_t RXOVFIC    : 1;            /*!< [0..0] RX FIFO overflow flag clear                                        */
      __OM  uint32_t RXTOIC     : 1;            /*!< [1..1] RX time-out interrupt flag clear                                   */
      __OM  uint32_t RXFIFOTHIC : 1;            /*!< [2..2] RX Interrupt flag Clear                                            */
      __OM  uint32_t TXFIFOTHIC : 1;            /*!< [3..3] TX Interrupt flag Clear                                            */
            uint32_t            : 28;
    } IC_b;
  } ;
  
  union {
    __IOM uint32_t DATA;                        /*!< (@ 0x0000001C) Offset:0x1C SPI1 Data Register                             */
    
    struct {
      __IOM uint32_t Data       : 16;           /*!< [15..0] Data                                                              */
            uint32_t            : 16;
    } DATA_b;
  } ;
  
  union {
    __IOM uint32_t DFDLY;                       /*!< (@ 0x00000020) Offset:0x20 SPI1 Data Fetch Register                       */
    
    struct {
      __IOM uint32_t DFETCH_EN  : 1;            /*!< [0..0] SPI1 data fetch control bit                                        */
            uint32_t            : 31;
    } DFDLY_b;
  } ;
} SN_SPI1_Type;                                 /*!< Size = 36 (0x24)                                                          */



/* =========================================================================================================================== */
/* ================                                          SN_I2C0                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief I2C0 (SN_I2C0)
  */

typedef struct {                                /*!< (@ 0x40018000) SN_I2C0 Structure                                          */
  
  union {
    __IOM uint32_t CTRL;                        /*!< (@ 0x00000000) Offset:0x00 I2Cn Control Register                          */
    
    struct {
            uint32_t            : 1;
      __IOM uint32_t NACK       : 1;            /*!< [1..1] NACK assert flag                                                   */
      __IOM uint32_t ACK        : 1;            /*!< [2..2] ACK assert flag                                                    */
            uint32_t            : 1;
      __IOM uint32_t STO        : 1;            /*!< [4..4] STOP assert flag                                                   */
      __IOM uint32_t STA        : 1;            /*!< [5..5] START assert flag                                                  */
            uint32_t            : 1;
      __IOM uint32_t I2CMODE    : 1;            /*!< [7..7] I2C mode                                                           */
      __IOM uint32_t I2CEN      : 1;            /*!< [8..8] I2Cn interface enable                                              */
            uint32_t            : 23;
    } CTRL_b;
  } ;
  
  union {
    __IOM uint32_t STAT;                        /*!< (@ 0x00000004) Offset:0x04 I2Cn Status Register                           */
    
    struct {
      __IM  uint32_t RX_DN      : 1;            /*!< [0..0] RX done status                                                     */
      __IM  uint32_t ACK_STAT   : 1;            /*!< [1..1] ACK done status                                                    */
      __IM  uint32_t NACK_STAT  : 1;            /*!< [2..2] NACK done status                                                   */
      __IM  uint32_t STOP_DN    : 1;            /*!< [3..3] STOP done status                                                   */
      __IM  uint32_t START_DN   : 1;            /*!< [4..4] START done status                                                  */
      __IM  uint32_t MST        : 1;            /*!< [5..5] I2C master/slave status                                            */
      __IM  uint32_t SLV_RX_HIT : 1;            /*!< [6..6] Slave RX address hit flag                                          */
      __IM  uint32_t SLV_TX_HIT : 1;            /*!< [7..7] Slave TX address hit flag                                          */
      __IM  uint32_t LOST_ARB   : 1;            /*!< [8..8] Lost arbitration status                                            */
      __IM  uint32_t TIMEOUT    : 1;            /*!< [9..9] Time-out status                                                    */
            uint32_t            : 5;
      __IOM uint32_t I2CIF      : 1;            /*!< [15..15] I2C interrupt flag                                               */
            uint32_t            : 16;
    } STAT_b;
  } ;
  
  union {
    __IOM uint32_t TXDATA;                      /*!< (@ 0x00000008) Offset:0x08 I2Cn TX Data Register                          */
    
    struct {
      __IOM uint32_t Data       : 8;            /*!< [7..0] TX Data                                                            */
            uint32_t            : 24;
    } TXDATA_b;
  } ;
  
  union {
    __IM  uint32_t RXDATA;                      /*!< (@ 0x0000000C) Offset:0x0C I2Cn RX Data Register                          */
    
    struct {
      __IM  uint32_t Data       : 8;            /*!< [7..0] RX Data received when RX_DN=1                                      */
            uint32_t            : 24;
    } RXDATA_b;
  } ;
  
  union {
    __IOM uint32_t SLVADDR0;                    /*!< (@ 0x00000010) Offset:0x10 I2Cn Slave Address 0 Register                  */
    
    struct {
      __IOM uint32_t ADDR       : 10;           /*!< [9..0] I2Cn slave address 0                                               */
            uint32_t            : 20;
      __IOM uint32_t GCEN       : 1;            /*!< [30..30] General call address enable                                      */
      __IOM uint32_t ADD_MODE   : 1;            /*!< [31..31] Slave address mode                                               */
    } SLVADDR0_b;
  } ;
  
  union {
    __IOM uint32_t SLVADDR1;                    /*!< (@ 0x00000014) Offset:0x14 I2Cn Slave Address 1 Register                  */
    
    struct {
      __IOM uint32_t ADDR       : 10;           /*!< [9..0] I2Cn slave address 1                                               */
            uint32_t            : 22;
    } SLVADDR1_b;
  } ;
  
  union {
    __IOM uint32_t SLVADDR2;                    /*!< (@ 0x00000018) Offset:0x18 I2Cn Slave Address 2 Register                  */
    
    struct {
      __IOM uint32_t ADDR       : 10;           /*!< [9..0] I2Cn slave address 2                                               */
            uint32_t            : 22;
    } SLVADDR2_b;
  } ;
  
  union {
    __IOM uint32_t SLVADDR3;                    /*!< (@ 0x0000001C) Offset:0x1C I2Cn Slave Address 3 Register                  */
    
    struct {
      __IOM uint32_t ADDR       : 10;           /*!< [9..0] I2Cn slave address 3                                               */
            uint32_t            : 22;
    } SLVADDR3_b;
  } ;
  
  union {
    __IOM uint32_t SCLHT;                       /*!< (@ 0x00000020) Offset:0x20 I2Cn SCL High Time Register                    */
    
    struct {
      __IOM uint32_t SCLH       : 8;            /*!< [7..0] SCLn High period time=(SCLHT+1)*I2Cn_PCLK cycle                    */
            uint32_t            : 24;
    } SCLHT_b;
  } ;
  
  union {
    __IOM uint32_t SCLLT;                       /*!< (@ 0x00000024) Offset:0x24 I2Cn SCL Low Time Register                     */
    
    struct {
      __IOM uint32_t SCLL       : 8;            /*!< [7..0] SCLn Low period time=(SCLLT+1)*I2Cn_PCLK cycle                     */
            uint32_t            : 24;
    } SCLLT_b;
  } ;
  __IM  uint32_t  RESERVED;
  
  union {
    __IOM uint32_t TOCTRL;                      /*!< (@ 0x0000002C) Offset:0x2C I2Cn Timeout Control Register                  */
    
    struct {
      __IOM uint32_t TO         : 16;           /*!< [15..0] Timeout period time = TO*32*I2Cn_PCLK cycle                       */
            uint32_t            : 16;
    } TOCTRL_b;
  } ;
} SN_I2C0_Type;                                 /*!< Size = 48 (0x30)                                                          */



/* =========================================================================================================================== */
/* ================                                         SN_UART0                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief UART0 (SN_UART0)
  */

typedef struct {                                /*!< (@ 0x40016000) SN_UART0 Structure                                         */
  
  union {
    union {
      __IM  uint32_t RB;                        /*!< (@ 0x00000000) Offset:0x00 UARTn Receiver Buffer Register                 */
      
      struct {
        __IM  uint32_t RB       : 8;            /*!< [7..0] The received byte in UART RX FIFO                                  */
              uint32_t          : 24;
      } RB_b;
    } ;
    
    union {
      __OM  uint32_t TH;                        /*!< (@ 0x00000000) Offset:0x00 UARTn Transmit Holding Register                */
      
      struct {
        __OM  uint32_t TH       : 8;            /*!< [7..0] The byte to be transmitted in UART TX FIFO when transmitter
                                                     is available                                                              */
              uint32_t          : 24;
      } TH_b;
    } ;
    
    union {
      __IOM uint32_t DLL;                       /*!< (@ 0x00000000) Offset:0x00 UARTn Divisor Latch LSB Register               */
      
      struct {
        __IOM uint32_t DLL      : 8;            /*!< [7..0] DLL and DLM register determines the baud rate of UARTn             */
              uint32_t          : 24;
      } DLL_b;
    } ;
  };
  
  union {
    union {
      __IOM uint32_t DLM;                       /*!< (@ 0x00000004) Offset:0x04 UARTn Divisor Latch MSB Register               */
      
      struct {
        __IOM uint32_t DLM      : 8;            /*!< [7..0] DLL and DLM register determines the baud rate of USARTn            */
              uint32_t          : 24;
      } DLM_b;
    } ;
    
    union {
      __IOM uint32_t IE;                        /*!< (@ 0x00000004) Offset:0x04 UARTn Interrupt Enable Register                */
      
      struct {
        __IOM uint32_t RDAIE    : 1;            /*!< [0..0] RDA interrupt enable                                               */
        __IOM uint32_t THREIE   : 1;            /*!< [1..1] THRE interrupt enable                                              */
        __IOM uint32_t RLSIE    : 1;            /*!< [2..2] RLS interrupt enable                                               */
              uint32_t          : 1;
        __IOM uint32_t TEMTIE   : 1;            /*!< [4..4] TEMT interrupt enable                                              */
              uint32_t          : 3;
        __IOM uint32_t ABEOIE   : 1;            /*!< [8..8] ABE0 interrupt enable                                              */
        __IOM uint32_t ABTOIE   : 1;            /*!< [9..9] ABT0 interrupt enable                                              */
              uint32_t          : 22;
      } IE_b;
    } ;
  };
  
  union {
    union {
      __IM  uint32_t II;                        /*!< (@ 0x00000008) Offset:0x08 UARTn Interrupt Identification Register        */
      
      struct {
        __IM  uint32_t INTSTATUS : 1;           /*!< [0..0] Interrupt status                                                   */
        __IM  uint32_t INTID    : 3;            /*!< [3..1] Interrupt ID of RX FIFO                                            */
              uint32_t          : 2;
        __IM  uint32_t FIFOEN   : 2;            /*!< [7..6] Equal to FIFOEN bits in USARTn_FIFOCTRL register                   */
        __IM  uint32_t ABEOIF   : 1;            /*!< [8..8] ABEO interrupt flag                                                */
        __IM  uint32_t ABTOIF   : 1;            /*!< [9..9] ABTO interrupt flag                                                */
              uint32_t          : 22;
      } II_b;
    } ;
    
    union {
      __OM  uint32_t FIFOCTRL;                  /*!< (@ 0x00000008) Offset:0x08 UARTn FIFO Control Register                    */
      
      struct {
        __OM  uint32_t FIFOEN   : 1;            /*!< [0..0] FIFO enable                                                        */
              uint32_t          : 5;
        __OM  uint32_t RXTL     : 2;            /*!< [7..6] RX trigger level                                                   */
              uint32_t          : 24;
      } FIFOCTRL_b;
    } ;
  };
  
  union {
    __IOM uint32_t LC;                          /*!< (@ 0x0000000C) Offset:0x0C UARTn Line Control Register                    */
    
    struct {
      __IOM uint32_t WLS        : 2;            /*!< [1..0] Word length selection                                              */
      __IOM uint32_t SBS        : 1;            /*!< [2..2] Stop bit selection                                                 */
      __IOM uint32_t PE         : 1;            /*!< [3..3] Parity enable                                                      */
      __IOM uint32_t PS         : 2;            /*!< [5..4] Parity selection                                                   */
      __IOM uint32_t BC         : 1;            /*!< [6..6] Break control                                                      */
      __IOM uint32_t DLAB       : 1;            /*!< [7..7] Divisor Latch access                                               */
            uint32_t            : 24;
    } LC_b;
  } ;
  __IM  uint32_t  RESERVED;
  
  union {
    __IM  uint32_t LS;                          /*!< (@ 0x00000014) Offset:0x14 UARTn Line Status Register                     */
    
    struct {
      __IM  uint32_t RDR        : 1;            /*!< [0..0] Receiver data ready flag                                           */
      __IM  uint32_t OE         : 1;            /*!< [1..1] Overrun error flag                                                 */
      __IM  uint32_t PE         : 1;            /*!< [2..2] Parity error flag                                                  */
      __IM  uint32_t FE         : 1;            /*!< [3..3] Framing error flag                                                 */
      __IM  uint32_t BI         : 1;            /*!< [4..4] Break interrupt flag                                               */
      __IM  uint32_t THRE       : 1;            /*!< [5..5] THR empty flag                                                     */
      __IM  uint32_t TEMT       : 1;            /*!< [6..6] Transmitter empty flag                                             */
      __IM  uint32_t RXFE       : 1;            /*!< [7..7] Receiver FIFO error flag                                           */
            uint32_t            : 24;
    } LS_b;
  } ;
  __IM  uint32_t  RESERVED1;
  
  union {
    __IOM uint32_t SP;                          /*!< (@ 0x0000001C) Offset:0x1C UARTn Scratch Pad Register                     */
    
    struct {
      __IOM uint32_t PAD        : 8;            /*!< [7..0] Pad informaton                                                     */
            uint32_t            : 24;
    } SP_b;
  } ;
  
  union {
    __IOM uint32_t ABCTRL;                      /*!< (@ 0x00000020) Offset:0x20 UARTn Auto-baud Control Register               */
    
    struct {
      __IOM uint32_t START      : 1;            /*!< [0..0] Auto-baud run bit                                                  */
      __IOM uint32_t MODE       : 1;            /*!< [1..1] Auto-baud mode selection                                           */
      __IOM uint32_t AUTORESTART : 1;           /*!< [2..2] Restart mode selection                                             */
            uint32_t            : 5;
      __OM  uint32_t ABEOIFC    : 1;            /*!< [8..8] Clear ABEOIF flag                                                  */
      __OM  uint32_t ABTOIFC    : 1;            /*!< [9..9] Clear ABTOIF flag                                                  */
            uint32_t            : 22;
    } ABCTRL_b;
  } ;
  __IM  uint32_t  RESERVED2;
  
  union {
    __IOM uint32_t FD;                          /*!< (@ 0x00000028) Offset:0x28 UARTn Fractional Divider Register              */
    
    struct {
      __IOM uint32_t DIVADDVAL  : 4;            /*!< [3..0] Baud rate generation prescaler divisor value                       */
      __IOM uint32_t MULVAL     : 4;            /*!< [7..4] Baud rate generation prescaler multiplier value                    */
      __IOM uint32_t OVER8      : 1;            /*!< [8..8] Oversampling value                                                 */
            uint32_t            : 23;
    } FD_b;
  } ;
  __IM  uint32_t  RESERVED3;
  
  union {
    __IOM uint32_t CTRL;                        /*!< (@ 0x00000030) Offset:0x30 UARTn Control Register                         */
    
    struct {
      __IOM uint32_t UARTEN     : 1;            /*!< [0..0] USART enable                                                       */
      __IOM uint32_t MODE       : 3;            /*!< [3..1] UART mode                                                          */
            uint32_t            : 2;
      __IOM uint32_t RXEN       : 1;            /*!< [6..6] RX enable                                                          */
      __IOM uint32_t TXEN       : 1;            /*!< [7..7] TX enable                                                          */
            uint32_t            : 24;
    } CTRL_b;
  } ;
  
  union {
    __IOM uint32_t HDEN;                        /*!< (@ 0x00000034) Offset:0x34 UARTn Control Register                         */
    
    struct {
      __IOM uint32_t HDEN       : 1;            /*!< [0..0] Half-duplex mode enable                                            */
            uint32_t            : 31;
    } HDEN_b;
  } ;
} SN_UART0_Type;                                /*!< Size = 56 (0x38)                                                          */



/* =========================================================================================================================== */
/* ================                                          SN_I2S0                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief I2S (SN_I2S0)
  */

typedef struct {                                /*!< (@ 0x4001A000) SN_I2S0 Structure                                          */
  
  union {
    __IOM uint32_t CTRL;                        /*!< (@ 0x00000000) Offset:0x00 I2Sn Control Register                          */
    
    struct {
      __IOM uint32_t START      : 1;            /*!< [0..0] Start Transmit/Receive                                             */
      __IOM uint32_t MUTE       : 1;            /*!< [1..1] Mute enable                                                        */
      __IOM uint32_t MONO       : 1;            /*!< [2..2] Mono/stereo selection                                              */
      __IOM uint32_t MS         : 1;            /*!< [3..3] Master/Slave selection bit                                         */
      __IOM uint32_t FORMAT     : 2;            /*!< [5..4] I2S operation format                                               */
      __IOM uint32_t TXEN       : 1;            /*!< [6..6] Transmit enable bit                                                */
      __IOM uint32_t RXEN       : 1;            /*!< [7..7] Receiver enable bit                                                */
      __OM  uint32_t CLRTXFIFO  : 1;            /*!< [8..8] Clear I2S TX FIFO                                                  */
      __OM  uint32_t CLRRXFIFO  : 1;            /*!< [9..9] Clear I2S RX FIFO                                                  */
      __IOM uint32_t DL         : 2;            /*!< [11..10] Data length                                                      */
      __IOM uint32_t TXFIFOTH   : 3;            /*!< [14..12] TX FIFO threshold level                                          */
            uint32_t            : 1;
      __IOM uint32_t RXFIFOTH   : 3;            /*!< [18..16] RX FIFO threshold level                                          */
            uint32_t            : 1;
      __IOM uint32_t CHLENGTH   : 5;            /*!< [24..20] Bit number of single channel                                     */
            uint32_t            : 6;
      __IOM uint32_t I2SEN      : 1;            /*!< [31..31] I2S enable                                                       */
    } CTRL_b;
  } ;
  
  union {
    __IOM uint32_t CLK;                         /*!< (@ 0x00000004) Offset:0x04 I2Sn Clock Register                            */
    
    struct {
      __IOM uint32_t MCLKDIV    : 3;            /*!< [2..0] MCLK divider                                                       */
      __IOM uint32_t MCLKOEN    : 1;            /*!< [3..3] MLCK output enable                                                 */
      __IOM uint32_t MCLKSEL    : 1;            /*!< [4..4] MLCK source selection                                              */
            uint32_t            : 3;
      __IOM uint32_t BCLKDIV    : 8;            /*!< [15..8] BCLK divider                                                      */
      __IOM uint32_t CLKSEL     : 1;            /*!< [16..16] I2S clock source                                                 */
            uint32_t            : 15;
    } CLK_b;
  } ;
  
  union {
    __IM  uint32_t STATUS;                      /*!< (@ 0x00000008) Offset:0x08 I2Sn Status Register                           */
    
    struct {
      __IM  uint32_t I2SINT     : 1;            /*!< [0..0] I2S interrupt flag                                                 */
      __IM  uint32_t RIGHTCH    : 1;            /*!< [1..1] Current channel status                                             */
            uint32_t            : 4;
      __IM  uint32_t TXFIFOTHF  : 1;            /*!< [6..6] TX FIFO threshold flag                                             */
      __IM  uint32_t RXFIFOTHF  : 1;            /*!< [7..7] RX FIFO threshold flag                                             */
      __IM  uint32_t TXFIFOFULL : 1;            /*!< [8..8] TX FIFO full flag                                                  */
      __IM  uint32_t RXFIFOFULL : 1;            /*!< [9..9] RX FIFO full flag                                                  */
      __IM  uint32_t TXFIFOEMPTY : 1;           /*!< [10..10] TX FIFO empty flag                                               */
      __IM  uint32_t RXFIFOEMPTY : 1;           /*!< [11..11] RX FIFO empty flag                                               */
      __IM  uint32_t TXFIFOLV   : 4;            /*!< [15..12] TX FIFO used level                                               */
            uint32_t            : 1;
      __IM  uint32_t RXFIFOLV   : 4;            /*!< [20..17] RX FIFO used level                                               */
            uint32_t            : 11;
    } STATUS_b;
  } ;
  
  union {
    __IOM uint32_t IE;                          /*!< (@ 0x0000000C) Offset:0x0C I2Sn Interrupt Enable Register                 */
    
    struct {
            uint32_t            : 4;
      __IOM uint32_t TXFIFOOVFIEN : 1;          /*!< [4..4] TX FIFO overflow interrupt enable                                  */
      __IOM uint32_t RXFIFOUDFIEN : 1;          /*!< [5..5] RX FIFO underflow interrupt enable                                 */
      __IOM uint32_t TXFIFOTHIEN : 1;           /*!< [6..6] TX FIFO threshold interrupt enable                                 */
      __IOM uint32_t RXFIFOTHIEN : 1;           /*!< [7..7] RX FIFO threshold interrupt enable                                 */
            uint32_t            : 24;
    } IE_b;
  } ;
  
  union {
    __IM  uint32_t RIS;                         /*!< (@ 0x00000010) Offset:0x10 I2Sn Raw Interrupt Status Register             */
    
    struct {
            uint32_t            : 4;
      __IM  uint32_t TXFIFOOVIF : 1;            /*!< [4..4] TX FIFO overflow interrupt flag                                    */
      __IM  uint32_t RXFIFOUDIF : 1;            /*!< [5..5] RX FIFO underflow interrupt flag                                   */
      __IM  uint32_t TXFIFOTHIF : 1;            /*!< [6..6] TX FIFO threshold interrupt flag                                   */
      __IM  uint32_t RXFIFOTHIF : 1;            /*!< [7..7] RX FIFO threshold interrupt flag                                   */
            uint32_t            : 24;
    } RIS_b;
  } ;
  
  union {
    __OM  uint32_t IC;                          /*!< (@ 0x00000014) Offset:0x14 I2Sn Interrupt Clear Register                  */
    
    struct {
            uint32_t            : 4;
      __OM  uint32_t TXFIFOOVIC : 1;            /*!< [4..4] TX FIFO overflow interrupt clear                                   */
      __OM  uint32_t RXFIFOUDIC : 1;            /*!< [5..5] RX FIFO underflow interrupt clear                                  */
      __OM  uint32_t TXFIFOTHIC : 1;            /*!< [6..6] TX FIFO threshold interrupt clear                                  */
      __OM  uint32_t RXFIFOTHIC : 1;            /*!< [7..7] RX FIFO threshold interrupt clear                                  */
            uint32_t            : 24;
    } IC_b;
  } ;
  __IM  uint32_t  RXFIFO;                       /*!< (@ 0x00000018) Offset:0x18 I2Sn RX FIFO Register                          */
  __OM  uint32_t  TXFIFO;                       /*!< (@ 0x0000001C) Offset:0x1C I2Sn TX FIFO Register                          */
} SN_I2S0_Type;                                 /*!< Size = 32 (0x20)                                                          */



/* =========================================================================================================================== */
/* ================                                         SN_FLASH                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief FLASH Memory Control Registers (SN_FLASH)
  */

typedef struct {                                /*!< (@ 0x40062000) SN_FLASH Structure                                         */
  
  union {
    __IOM uint32_t LPCTRL;                      /*!< (@ 0x00000000) Offset:0x00 Flash Low Power Control Register               */
    
    struct {
      __IOM uint32_t LPMODE     : 6;            /*!< [5..0] Flash Low Power mode selection bit                                 */
            uint32_t            : 10;
      __OM  uint32_t FMCKEY     : 16;           /*!< [31..16] FMC verify key                                                   */
    } LPCTRL_b;
  } ;
  
  union {
    __IOM uint32_t STATUS;                      /*!< (@ 0x00000004) Offset:0x04 Flash Status Register                          */
    
    struct {
      __IM  uint32_t BUSY       : 1;            /*!< [0..0] Busy flag                                                          */
            uint32_t            : 1;
      __IOM uint32_t ERR        : 1;            /*!< [2..2] Erase/Error flag                                                   */
            uint32_t            : 29;
    } STATUS_b;
  } ;
  
  union {
    __IOM uint32_t CTRL;                        /*!< (@ 0x00000008) Offset:0x08 Flash Control Register                         */
    
    struct {
      __IOM uint32_t PG         : 1;            /*!< [0..0] Flash program mode chosen bit                                      */
      __IOM uint32_t PER        : 1;            /*!< [1..1] Page erase mode chosen bit                                         */
      __IOM uint32_t MER        : 1;            /*!< [2..2] Mass erase mode chosen bit                                         */
            uint32_t            : 3;
      __IOM uint32_t START      : 1;            /*!< [6..6] Start erase/program operation                                      */
      __IOM uint32_t CHK        : 1;            /*!< [7..7] Checksum calculation chosen                                        */
            uint32_t            : 24;
    } CTRL_b;
  } ;
  __IOM uint32_t  DATA;                         /*!< (@ 0x0000000C) Offset:0x0C Flash Data Register                            */
  __IOM uint32_t  ADDR;                         /*!< (@ 0x00000010) Offset:0x10 Flash Address Register                         */
  
  union {
    __IM  uint32_t CHKSUM;                      /*!< (@ 0x00000014) Offset:0x14 Flash Checksum Register                        */
    
    struct {
      __IM  uint32_t UserROM    : 16;           /*!< [15..0] Checksum of User ROM                                              */
      __IM  uint32_t BootROM    : 16;           /*!< [31..16] Checksum of Boot ROM                                             */
    } CHKSUM_b;
  } ;
  
  union {
    __IM  uint32_t CHKSUM1;                     /*!< (@ 0x00000018) Offset:0x18 Flash Checksum Register 1                      */
    
    struct {
      __IM  uint32_t UserROM1   : 16;           /*!< [15..0] Checksum of User ROM 1                                            */
      __IM  uint32_t UserROM2   : 16;           /*!< [31..16] Checksum of User ROM 2                                           */
    } CHKSUM1_b;
  } ;
  
  union {
    __IM  uint32_t CHKSUM2;                     /*!< (@ 0x0000001C) Offset:0x1C Flash Checksum Register 2                      */
    
    struct {
      __IM  uint32_t UserROM3   : 16;           /*!< [15..0] Checksum of User ROM 3                                            */
      __IM  uint32_t UserROM4   : 16;           /*!< [31..16] Checksum of User ROM 4                                           */
    } CHKSUM2_b;
  } ;
} SN_FLASH_Type;                                /*!< Size = 32 (0x20)                                                          */



/* =========================================================================================================================== */
/* ================                                          SN_LCD                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief LCD Driver (SN_LCD)
  */

typedef struct {                                /*!< (@ 0x40034000) SN_LCD Structure                                           */
  
  union {
    __IOM uint32_t CTRL;                        /*!< (@ 0x00000000) Offset:0x00 LCD Control register                           */
    
    struct {
      __IOM uint32_t LCDENB     : 1;            /*!< [0..0] LCD driver enable bit                                              */
      __IOM uint32_t VLCD       : 4;            /*!< [4..1] VLCD voltage adjustment                                            */
      __IOM uint32_t LCDIDLE    : 1;            /*!< [5..5] LCD idle state enable bit                                          */
      __IOM uint32_t LCDSFM     : 1;            /*!< [6..6] LCD single frame function enable bit                               */
      __IOM uint32_t LSTC       : 1;            /*!< [7..7] LCD static mode control bit                                        */
      __IOM uint32_t LCDCOM     : 2;            /*!< [9..8] Duty selection                                                     */
      __IOM uint32_t LCDCKS     : 1;            /*!< [10..10] LCD clock source selection                                       */
      __IOM uint32_t LCDBNK     : 1;            /*!< [11..11] LCD blank control bit                                            */
      __IOM uint32_t LCDRATE    : 2;            /*!< [13..12] LCD clock rate                                                   */
      __IOM uint32_t LCDBIA     : 3;            /*!< [16..14] LCD bias resistance selection bit                                */
      __IOM uint32_t LCDOUT     : 1;            /*!< [17..17] LCD VLCD/C2/V1 debug pins output control bit                     */
            uint32_t            : 14;
    } CTRL_b;
  } ;
  
  union {
    __IOM uint32_t FCC;                         /*!< (@ 0x00000004) Offset:0x04 LCD Frame Counter Control register             */
    
    struct {
      __IOM uint32_t FCENB      : 1;            /*!< [0..0] LCD frame counter enable bit                                       */
      __IOM uint32_t FCT        : 6;            /*!< [6..1] LCD frame counter threshold value                                  */
      __IOM uint32_t FCIE       : 1;            /*!< [7..7] LCD frame interrupt enable bit                                     */
            uint32_t            : 24;
    } FCC_b;
  } ;
  
  union {
    __IOM uint32_t RIS;                         /*!< (@ 0x00000008) Offset:0x08 LCD Raw Interrupt Status register              */
    
    struct {
      __IOM uint32_t FCIF       : 1;            /*!< [0..0] LCD frame interrupt flag                                           */
            uint32_t            : 31;
    } RIS_b;
  } ;
  
  union {
    __IOM uint32_t SEGSEL1;                     /*!< (@ 0x0000000C) Offset:0x0C LCD SEG Select register 1                      */
    
    struct {
      __IOM uint32_t SEG0EN     : 1;            /*!< [0..0] SEG0 Enable bit                                                    */
      __IOM uint32_t SEG1EN     : 1;            /*!< [1..1] SEG1 Enable bit                                                    */
      __IOM uint32_t SEG2EN     : 1;            /*!< [2..2] SEG2 Enable bit                                                    */
      __IOM uint32_t SEG3EN     : 1;            /*!< [3..3] SEG3 Enable bit                                                    */
      __IOM uint32_t SEG4EN     : 1;            /*!< [4..4] SEG4 Enable bit                                                    */
      __IOM uint32_t SEG5EN     : 1;            /*!< [5..5] SEG5 Enable bit                                                    */
      __IOM uint32_t SEG6EN     : 1;            /*!< [6..6] SEG6 Enable bit                                                    */
      __IOM uint32_t SEG7EN     : 1;            /*!< [7..7] SEG7 Enable bit                                                    */
      __IOM uint32_t SEG8EN     : 1;            /*!< [8..8] SEG8 Enable bit                                                    */
      __IOM uint32_t SEG9EN     : 1;            /*!< [9..9] SEG9 Enable bit                                                    */
      __IOM uint32_t SEG10EN    : 1;            /*!< [10..10] SEG10 Enable bit                                                 */
      __IOM uint32_t SEG11EN    : 1;            /*!< [11..11] SEG11 Enable bit                                                 */
      __IOM uint32_t SEG12EN    : 1;            /*!< [12..12] SEG12 Enable bit                                                 */
      __IOM uint32_t SEG13EN    : 1;            /*!< [13..13] SEG13 Enable bit                                                 */
      __IOM uint32_t SEG14EN    : 1;            /*!< [14..14] SEG14 Enable bit                                                 */
      __IOM uint32_t SEG15EN    : 1;            /*!< [15..15] SEG15 Enable bit                                                 */
      __IOM uint32_t SEG16EN    : 1;            /*!< [16..16] SEG16 Enable bit                                                 */
      __IOM uint32_t SEG17EN    : 1;            /*!< [17..17] SEG17 Enable bit                                                 */
      __IOM uint32_t SEG18EN    : 1;            /*!< [18..18] SEG18 Enable bit                                                 */
      __IOM uint32_t SEG19EN    : 1;            /*!< [19..19] SEG19 Enable bit                                                 */
      __IOM uint32_t SEG20EN    : 1;            /*!< [20..20] SEG20 Enable bit                                                 */
      __IOM uint32_t SEG21EN    : 1;            /*!< [21..21] SEG21 Enable bit                                                 */
      __IOM uint32_t SEG22EN    : 1;            /*!< [22..22] SEG22 Enable bit                                                 */
      __IOM uint32_t SEG23EN    : 1;            /*!< [23..23] SEG23 Enable bit                                                 */
      __IOM uint32_t SEG24EN    : 1;            /*!< [24..24] SEG24 Enable bit                                                 */
      __IOM uint32_t SEG25EN    : 1;            /*!< [25..25] SEG25 Enable bit                                                 */
      __IOM uint32_t SEG26EN    : 1;            /*!< [26..26] SEG26 Enable bit                                                 */
      __IOM uint32_t SEG27EN    : 1;            /*!< [27..27] SEG27 Enable bit                                                 */
      __IOM uint32_t SEG28EN    : 1;            /*!< [28..28] SEG28 Enable bit                                                 */
      __IOM uint32_t SEG29EN    : 1;            /*!< [29..29] SEG29 Enable bit                                                 */
      __IOM uint32_t SEG30EN    : 1;            /*!< [30..30] SEG30 Enable bit                                                 */
      __IOM uint32_t SEG31EN    : 1;            /*!< [31..31] SEG31 Enable bit                                                 */
    } SEGSEL1_b;
  } ;
  
  union {
    __IOM uint32_t SEGSEL2;                     /*!< (@ 0x00000010) Offset:0x10 LCD SEG Select register 2                      */
    
    struct {
      __IOM uint32_t SEG32EN    : 1;            /*!< [0..0] SEG32 Enable bit                                                   */
      __IOM uint32_t SEG33EN    : 1;            /*!< [1..1] SEG33 Enable bit                                                   */
      __IOM uint32_t SEG34EN    : 1;            /*!< [2..2] SEG34 Enable bit                                                   */
      __IOM uint32_t SEG35EN    : 1;            /*!< [3..3] SEG35 Enable bit                                                   */
      __IOM uint32_t SEG36EN    : 1;            /*!< [4..4] SEG36 Enable bit                                                   */
      __IOM uint32_t SEG37EN    : 1;            /*!< [5..5] SEG37 Enable bit                                                   */
      __IOM uint32_t SEG38EN    : 1;            /*!< [6..6] SEG38 Enable bit                                                   */
      __IOM uint32_t SEG39EN    : 1;            /*!< [7..7] SEG39 Enable bit                                                   */
            uint32_t            : 24;
    } SEGSEL2_b;
  } ;
  
  union {
    __IOM uint32_t SEGM0;                       /*!< (@ 0x00000014) Offset:0x14 LCD SEG Memory register 0                      */
    
    struct {
      __IOM uint32_t SEG0       : 8;            /*!< [7..0] SEG0 data for COM0~COM7                                            */
      __IOM uint32_t SEG1       : 8;            /*!< [15..8] SEG1 data for COM0~COM7                                           */
      __IOM uint32_t SEG2       : 8;            /*!< [23..16] SEG2 data for COM0~COM7                                          */
      __IOM uint32_t SEG3       : 8;            /*!< [31..24] SEG3 data for COM0~COM7                                          */
    } SEGM0_b;
  } ;
  
  union {
    __IOM uint32_t SEGM1;                       /*!< (@ 0x00000018) Offset:0x18 LCD SEG Memory register 1                      */
    
    struct {
      __IOM uint32_t SEG4       : 8;            /*!< [7..0] SEG4 data for COM0~COM7                                            */
      __IOM uint32_t SEG5       : 8;            /*!< [15..8] SEG5 data for COM0~COM7                                           */
      __IOM uint32_t SEG6       : 8;            /*!< [23..16] SEG6 data for COM0~COM7                                          */
      __IOM uint32_t SEG7       : 8;            /*!< [31..24] SEG7 data for COM0~COM7                                          */
    } SEGM1_b;
  } ;
  
  union {
    __IOM uint32_t SEGM2;                       /*!< (@ 0x0000001C) Offset:0x1C LCD SEG Memory register 2                      */
    
    struct {
      __IOM uint32_t SEG8       : 8;            /*!< [7..0] SEG8 data for COM0~COM7                                            */
      __IOM uint32_t SEG9       : 8;            /*!< [15..8] SEG9 data for COM0~COM7                                           */
      __IOM uint32_t SEG10      : 8;            /*!< [23..16] SEG10 data for COM0~COM7                                         */
      __IOM uint32_t SEG11      : 8;            /*!< [31..24] SEG11 data for COM0~COM7                                         */
    } SEGM2_b;
  } ;
  
  union {
    __IOM uint32_t SEGM3;                       /*!< (@ 0x00000020) Offset:0x20 LCD SEG Memory register 3                      */
    
    struct {
      __IOM uint32_t SEG12      : 8;            /*!< [7..0] SEG12 data for COM0~COM7                                           */
      __IOM uint32_t SEG13      : 8;            /*!< [15..8] SEG13 data for COM0~COM7                                          */
      __IOM uint32_t SEG14      : 8;            /*!< [23..16] SEG14 data for COM0~COM7                                         */
      __IOM uint32_t SEG15      : 8;            /*!< [31..24] SEG15 data for COM0~COM7                                         */
    } SEGM3_b;
  } ;
  
  union {
    __IOM uint32_t SEGM4;                       /*!< (@ 0x00000024) Offset:0x24 LCD SEG Memory register 4                      */
    
    struct {
      __IOM uint32_t SEG16      : 8;            /*!< [7..0] SEG16 data for COM0~COM7                                           */
      __IOM uint32_t SEG17      : 8;            /*!< [15..8] SEG17 data for COM0~COM7                                          */
      __IOM uint32_t SEG18      : 8;            /*!< [23..16] SEG18 data for COM0~COM7                                         */
      __IOM uint32_t SEG19      : 8;            /*!< [31..24] SEG19 data for COM0~COM7                                         */
    } SEGM4_b;
  } ;
  
  union {
    __IOM uint32_t SEGM5;                       /*!< (@ 0x00000028) Offset:0x28 LCD SEG Memory register 5                      */
    
    struct {
      __IOM uint32_t SEG20      : 8;            /*!< [7..0] SEG20 data for COM0~COM7                                           */
      __IOM uint32_t SEG21      : 8;            /*!< [15..8] SEG21 data for COM0~COM7                                          */
      __IOM uint32_t SEG22      : 8;            /*!< [23..16] SEG22 data for COM0~COM7                                         */
      __IOM uint32_t SEG23      : 8;            /*!< [31..24] SEG23 data for COM0~COM7                                         */
    } SEGM5_b;
  } ;
  
  union {
    __IOM uint32_t SEGM6;                       /*!< (@ 0x0000002C) Offset:0x2C LCD SEG Memory register 6                      */
    
    struct {
      __IOM uint32_t SEG24      : 8;            /*!< [7..0] SEG24 data for COM0~COM7                                           */
      __IOM uint32_t SEG25      : 8;            /*!< [15..8] SEG25 data for COM0~COM7                                          */
      __IOM uint32_t SEG26      : 8;            /*!< [23..16] SEG26 data for COM0~COM7                                         */
      __IOM uint32_t SEG27      : 8;            /*!< [31..24] SEG27 data for COM0~COM7                                         */
    } SEGM6_b;
  } ;
  
  union {
    __IOM uint32_t SEGM7;                       /*!< (@ 0x00000030) Offset:0x30 LCD SEG Memory register 7                      */
    
    struct {
      __IOM uint32_t SEG28      : 8;            /*!< [7..0] SEG28 data for COM0~COM7                                           */
      __IOM uint32_t SEG29      : 8;            /*!< [15..8] SEG29 data for COM0~COM7                                          */
      __IOM uint32_t SEG30      : 8;            /*!< [23..16] SEG30 data for COM0~COM7                                         */
      __IOM uint32_t SEG31      : 8;            /*!< [31..24] SEG31 data for COM0~COM7                                         */
    } SEGM7_b;
  } ;
  
  union {
    __IOM uint32_t SEGM8;                       /*!< (@ 0x00000034) Offset:0x34 LCD SEG Memory register 8                      */
    
    struct {
      __IOM uint32_t SEG32      : 8;            /*!< [7..0] SEG32 data for COM0~COM7                                           */
      __IOM uint32_t SEG33      : 8;            /*!< [15..8] SEG33 data for COM0~COM7                                          */
      __IOM uint32_t SEG34      : 8;            /*!< [23..16] SEG34 data for COM0~COM7                                         */
      __IOM uint32_t SEG35      : 8;            /*!< [31..24] SEG35 data for COM0~COM7                                         */
    } SEGM8_b;
  } ;
  
  union {
    __IOM uint32_t SEGM9;                       /*!< (@ 0x00000038) Offset:0x38 LCD SEG Memory register 9                      */
    
    struct {
      __IOM uint32_t SEG36      : 8;            /*!< [7..0] SEG36 data for COM0~COM7                                           */
      __IOM uint32_t SEG37      : 8;            /*!< [15..8] SEG37 data for COM0~COM7                                          */
      __IOM uint32_t SEG38      : 8;            /*!< [23..16] SEG38 data for COM0~COM7                                         */
      __IOM uint32_t SEG39      : 8;            /*!< [31..24] SEG39 data for COM0~COM7                                         */
    } SEGM9_b;
  } ;
} SN_LCD_Type;                                  /*!< Size = 60 (0x3c)                                                          */



/* =========================================================================================================================== */
/* ================                                          SN_CRC                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief Cyclic Redundancy Check (SN_CRC)
  */

typedef struct {                                /*!< (@ 0x40038000) SN_CRC Structure                                           */
  
  union {
    __IOM uint32_t CTRL;                        /*!< (@ 0x00000000) Offset:0x0 CRC Control Register                            */
    
    struct {
      __IOM uint32_t CRC        : 2;            /*!< [1..0] CRC Polynomial                                                     */
      __IOM uint32_t RESET      : 1;            /*!< [2..2] CRC Reset bit                                                      */
      __IOM uint32_t URCRCEN    : 1;            /*!< [3..3] CRC calculation for the User ROM enable bit                        */
      __IM  uint32_t BUSY       : 1;            /*!< [4..4] CRC calculation busy flag                                          */
            uint32_t            : 27;
    } CTRL_b;
  } ;
  
  union {
    __IOM uint32_t DATA;                        /*!< (@ 0x00000004) Offset:0x4 CRC Data Register                               */
    
    struct {
      __IOM uint32_t DATA       : 32;           /*!< [31..0] CRC Data                                                          */
    } DATA_b;
  } ;
} SN_CRC_Type;                                  /*!< Size = 8 (0x8)                                                            */



/* =========================================================================================================================== */
/* ================                                          SN_OPA                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief OP Amplifier (SN_OPA)
  */

typedef struct {                                /*!< (@ 0x4002A000) SN_OPA Structure                                           */
  
  union {
    __IOM uint32_t CTRL;                        /*!< (@ 0x00000000) Offset:0x0 OPA Control Register                            */
    
    struct {
      __IOM uint32_t OP0EN      : 1;            /*!< [0..0] OP-Amp 0 enable bit                                                */
            uint32_t            : 2;
      __IOM uint32_t OP0PS      : 1;            /*!< [3..3] OP-Amp 0 Positive input selection bit                              */
      __IOM uint32_t OP0NS      : 1;            /*!< [4..4] OP-Amp 0 Negatiove input selection bit                             */
            uint32_t            : 3;
      __IOM uint32_t OP1EN      : 1;            /*!< [8..8] OP-Amp 1 enable bit                                                */
            uint32_t            : 2;
      __IOM uint32_t OP1PS      : 1;            /*!< [11..11] OP-Amp 1 Positive input selection bit                            */
      __IOM uint32_t OP1NS      : 1;            /*!< [12..12] OP-Amp 1 Negatiove input selection bit                           */
            uint32_t            : 19;
    } CTRL_b;
  } ;
} SN_OPA_Type;                                  /*!< Size = 4 (0x4)                                                            */



/* =========================================================================================================================== */
/* ================                                          SN_EBI                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief External Bus Interface (SN_EBI)
  */

typedef struct {                                /*!< (@ 0x40036000) SN_EBI Structure                                           */
  
  union {
    __IOM uint32_t CTRL;                        /*!< (@ 0x00000000) Offset:0x0 EBI Control Register                            */
    
    struct {
      __IOM uint32_t MODE0      : 2;            /*!< [1..0] EBI bank 0 access mode                                             */
      __IOM uint32_t MODE1      : 2;            /*!< [3..2] EBI bank 1 access mode                                             */
      __IOM uint32_t MODE2      : 2;            /*!< [5..4] EBI bank 2 access mode                                             */
      __IOM uint32_t MODE3      : 2;            /*!< [7..6] EBI bank 3 access mode                                             */
      __IOM uint32_t BANK0EN    : 1;            /*!< [8..8] EBI bank 0 enable bit                                              */
      __IOM uint32_t BANK1EN    : 1;            /*!< [9..9] EBI bank 1 enable bit                                              */
      __IOM uint32_t BANK2EN    : 1;            /*!< [10..10] EBI bank 2 enable bit                                            */
      __IOM uint32_t BANK3EN    : 1;            /*!< [11..11] EBI bank 3 enable bit                                            */
      __IOM uint32_t BC0EN      : 1;            /*!< [12..12] Byte control of bank 0 enable bit                                */
      __IOM uint32_t BC1EN      : 1;            /*!< [13..13] Byte control of bank 1 enable bit                                */
      __IOM uint32_t BC2EN      : 1;            /*!< [14..14] Byte control of bank 2 enable bit                                */
      __IOM uint32_t BC3EN      : 1;            /*!< [15..15] Byte control of bank 3 enable bit                                */
      __IOM uint32_t ARDY0EN    : 1;            /*!< [16..16] ARDY of bank 0 enable bit                                        */
      __IOM uint32_t ARDY1EN    : 1;            /*!< [17..17] ARDY of bank 1 enable bit                                        */
      __IOM uint32_t ARDY2EN    : 1;            /*!< [18..18] ARDY of bank 2 enable bit                                        */
      __IOM uint32_t ARDY3EN    : 1;            /*!< [19..19] ARDY of bank 3 enable bit                                        */
      __IOM uint32_t IDLETIME   : 4;            /*!< [23..20] Bus idle time                                                    */
      __IOM uint32_t BK8080MODE0 : 1;           /*!< [24..24] Bank0 8080 Mode                                                  */
      __IOM uint32_t BK8080MODE1 : 1;           /*!< [25..25] Bank1 8080 Mode                                                  */
      __IOM uint32_t BK8080MODE2 : 1;           /*!< [26..26] Bank2 8080 Mode                                                  */
      __IOM uint32_t BK8080MODE3 : 1;           /*!< [27..27] Bank3 8080 Mode                                                  */
            uint32_t            : 4;
    } CTRL_b;
  } ;
  
  union {
    __IOM uint32_t ALCTRL;                      /*!< (@ 0x00000004) Offset:0x4 EBI Address Latch Control Register              */
    
    struct {
      __IOM uint32_t AL0        : 4;            /*!< [3..0] Bank 0 address length=AL0+16                                       */
      __IOM uint32_t AL1        : 4;            /*!< [7..4] Bank 1 address length=AL1+16                                       */
      __IOM uint32_t AL2        : 4;            /*!< [11..8] Bank 2 address length=AL2+16                                      */
      __IOM uint32_t AL3        : 4;            /*!< [15..12] Bank 3 address length=AL3+16                                     */
            uint32_t            : 16;
    } ALCTRL_b;
  } ;
  
  union {
    __IOM uint32_t STATUS;                      /*!< (@ 0x00000008) Offset:0x8 EBI Status Register                             */
    
    struct {
      __IM  uint32_t EBIBUSY    : 1;            /*!< [0..0] EBI Busy                                                           */
            uint32_t            : 3;
      __IM  uint32_t EBIARDY    : 1;            /*!< [4..4] EBI Asynchronous Ready status                                      */
            uint32_t            : 3;
      __IOM uint32_t EBINSRST   : 1;            /*!< [8..8] EBI State machine reset                                            */
            uint32_t            : 23;
    } STATUS_b;
  } ;
  __IM  uint32_t  RESERVED;
  
  union {
    __IOM uint32_t TADDR0;                      /*!< (@ 0x00000010) Offset:0x10 EBI Address Timing Register 0                  */
    
    struct {
      __IOM uint32_t ADDRSETUP  : 4;            /*!< [3..0] Address Setup time                                                 */
            uint32_t            : 4;
      __IOM uint32_t ADDRHOLD   : 4;            /*!< [11..8] Address Hold time                                                 */
            uint32_t            : 20;
    } TADDR0_b;
  } ;
  
  union {
    __IOM uint32_t TADDR1;                      /*!< (@ 0x00000014) Offset:0x14 EBI Address Timing Register 1                  */
    
    struct {
      __IOM uint32_t ADDRSETUP  : 4;            /*!< [3..0] Address Setup time                                                 */
            uint32_t            : 4;
      __IOM uint32_t ADDRHOLD   : 4;            /*!< [11..8] Address Hold time                                                 */
            uint32_t            : 20;
    } TADDR1_b;
  } ;
  
  union {
    __IOM uint32_t TADDR2;                      /*!< (@ 0x00000018) Offset:0x18 EBI Address Timing Register 2                  */
    
    struct {
      __IOM uint32_t ADDRSETUP  : 4;            /*!< [3..0] Address Setup time                                                 */
            uint32_t            : 4;
      __IOM uint32_t ADDRHOLD   : 4;            /*!< [11..8] Address Hold time                                                 */
            uint32_t            : 20;
    } TADDR2_b;
  } ;
  
  union {
    __IOM uint32_t TADDR3;                      /*!< (@ 0x0000001C) Offset:0x1C EBI Address Timing Register 3                  */
    
    struct {
      __IOM uint32_t ADDRSETUP  : 4;            /*!< [3..0] Address Setup time                                                 */
            uint32_t            : 4;
      __IOM uint32_t ADDRHOLD   : 4;            /*!< [11..8] Address Hold time                                                 */
            uint32_t            : 20;
    } TADDR3_b;
  } ;
  
  union {
    __IOM uint32_t TREAD0;                      /*!< (@ 0x00000020) Offset:0x20 EBI Read Timing Register 0                     */
    
    struct {
      __IOM uint32_t RDSETUP    : 4;            /*!< [3..0] Read Setup time                                                    */
            uint32_t            : 4;
      __IOM uint32_t RDSTRB     : 6;            /*!< [13..8] Read Strobe time                                                  */
            uint32_t            : 2;
      __IOM uint32_t RDHOLD     : 4;            /*!< [19..16] Read Hold time                                                   */
            uint32_t            : 12;
    } TREAD0_b;
  } ;
  
  union {
    __IOM uint32_t TREAD1;                      /*!< (@ 0x00000024) Offset:0x24 EBI Read Timing Register 1                     */
    
    struct {
      __IOM uint32_t RDSETUP    : 4;            /*!< [3..0] Read Setup time                                                    */
            uint32_t            : 4;
      __IOM uint32_t RDSTRB     : 6;            /*!< [13..8] Read Strobe time                                                  */
            uint32_t            : 2;
      __IOM uint32_t RDHOLD     : 4;            /*!< [19..16] Read Hold time                                                   */
            uint32_t            : 12;
    } TREAD1_b;
  } ;
  
  union {
    __IOM uint32_t TREAD2;                      /*!< (@ 0x00000028) Offset:0x28 EBI Read Timing Register 2                     */
    
    struct {
      __IOM uint32_t RDSETUP    : 4;            /*!< [3..0] Read Setup time                                                    */
            uint32_t            : 4;
      __IOM uint32_t RDSTRB     : 6;            /*!< [13..8] Read Strobe time                                                  */
            uint32_t            : 2;
      __IOM uint32_t RDHOLD     : 4;            /*!< [19..16] Read Hold time                                                   */
            uint32_t            : 12;
    } TREAD2_b;
  } ;
  
  union {
    __IOM uint32_t TREAD3;                      /*!< (@ 0x0000002C) Offset:0x2C EBI Read Timing Register 3                     */
    
    struct {
      __IOM uint32_t RDSETUP    : 4;            /*!< [3..0] Read Setup time                                                    */
            uint32_t            : 4;
      __IOM uint32_t RDSTRB     : 6;            /*!< [13..8] Read Strobe time                                                  */
            uint32_t            : 2;
      __IOM uint32_t RDHOLD     : 4;            /*!< [19..16] Read Hold time                                                   */
            uint32_t            : 12;
    } TREAD3_b;
  } ;
  
  union {
    __IOM uint32_t TWRITE0;                     /*!< (@ 0x00000030) Offset:0x30 EBI Write Timing Register 0                    */
    
    struct {
      __IOM uint32_t WESETUP    : 4;            /*!< [3..0] Write Setup time                                                   */
            uint32_t            : 4;
      __IOM uint32_t WESTRB     : 6;            /*!< [13..8] Write Strobe time                                                 */
            uint32_t            : 2;
      __IOM uint32_t WEHOLD     : 4;            /*!< [19..16] Write Hold time                                                  */
            uint32_t            : 12;
    } TWRITE0_b;
  } ;
  
  union {
    __IOM uint32_t TWRITE1;                     /*!< (@ 0x00000034) Offset:0x34 EBI Write Timing Register 1                    */
    
    struct {
      __IOM uint32_t WESETUP    : 4;            /*!< [3..0] Write Setup time                                                   */
            uint32_t            : 4;
      __IOM uint32_t WESTRB     : 6;            /*!< [13..8] Write Strobe time                                                 */
            uint32_t            : 2;
      __IOM uint32_t WEHOLD     : 4;            /*!< [19..16] Write Hold time                                                  */
            uint32_t            : 12;
    } TWRITE1_b;
  } ;
  
  union {
    __IOM uint32_t TWRITE2;                     /*!< (@ 0x00000038) Offset:0x38 EBI Write Timing Register 2                    */
    
    struct {
      __IOM uint32_t WESETUP    : 4;            /*!< [3..0] Write Setup time                                                   */
            uint32_t            : 4;
      __IOM uint32_t WESTRB     : 6;            /*!< [13..8] Write Strobe time                                                 */
            uint32_t            : 2;
      __IOM uint32_t WEHOLD     : 4;            /*!< [19..16] Write Hold time                                                  */
            uint32_t            : 12;
    } TWRITE2_b;
  } ;
  
  union {
    __IOM uint32_t TWRITE3;                     /*!< (@ 0x0000003C) Offset:0x3C EBI Write Timing Register 3                    */
    
    struct {
      __IOM uint32_t WESETUP    : 4;            /*!< [3..0] Write Setup time                                                   */
            uint32_t            : 4;
      __IOM uint32_t WESTRB     : 6;            /*!< [13..8] Write Strobe time                                                 */
            uint32_t            : 2;
      __IOM uint32_t WEHOLD     : 4;            /*!< [19..16] Write Hold time                                                  */
            uint32_t            : 12;
    } TWRITE3_b;
  } ;
  
  union {
    __IOM uint32_t PR0;                         /*!< (@ 0x00000040) Offset:0x40 EBI Polarity Register 0                        */
    
    struct {
      __IM  uint32_t CSPOL      : 1;            /*!< [0..0] Chip Select polarity                                               */
      __IM  uint32_t OEPOL      : 1;            /*!< [1..1] Output Enable polarity                                             */
      __IM  uint32_t WEPOL      : 1;            /*!< [2..2] Write Enable polarity                                              */
      __IM  uint32_t ALEPOL     : 1;            /*!< [3..3] Address Latch polarity                                             */
      __IOM uint32_t ARDYPOL    : 1;            /*!< [4..4] Asynchronous Ready polarity                                        */
      __IM  uint32_t UBLBPOL    : 1;            /*!< [5..5] Upper Byte and Lower Byte polarity                                 */
            uint32_t            : 26;
    } PR0_b;
  } ;
  
  union {
    __IOM uint32_t PR1;                         /*!< (@ 0x00000044) Offset:0x44 EBI Polarity Register 1                        */
    
    struct {
      __IM  uint32_t CSPOL      : 1;            /*!< [0..0] Chip Select polarity                                               */
      __IM  uint32_t OEPOL      : 1;            /*!< [1..1] Output Enable polarity                                             */
      __IM  uint32_t WEPOL      : 1;            /*!< [2..2] Write Enable polarity                                              */
      __IM  uint32_t ALEPOL     : 1;            /*!< [3..3] Address Latch polarity                                             */
      __IOM uint32_t ARDYPOL    : 1;            /*!< [4..4] Asynchronous Ready polarity                                        */
      __IM  uint32_t UBLBPOL    : 1;            /*!< [5..5] Upper Byte and Lower Byte polarity                                 */
            uint32_t            : 26;
    } PR1_b;
  } ;
  
  union {
    __IOM uint32_t PR2;                         /*!< (@ 0x00000048) Offset:0x48 EBI Polarity Register 2                        */
    
    struct {
      __IM  uint32_t CSPOL      : 1;            /*!< [0..0] Chip Select polarity                                               */
      __IM  uint32_t OEPOL      : 1;            /*!< [1..1] Output Enable polarity                                             */
      __IM  uint32_t WEPOL      : 1;            /*!< [2..2] Write Enable polarity                                              */
      __IM  uint32_t ALEPOL     : 1;            /*!< [3..3] Address Latch polarity                                             */
      __IOM uint32_t ARDYPOL    : 1;            /*!< [4..4] Asynchronous Ready polarity                                        */
      __IM  uint32_t UBLBPOL    : 1;            /*!< [5..5] Upper Byte and Lower Byte polarity                                 */
            uint32_t            : 26;
    } PR2_b;
  } ;
  
  union {
    __IOM uint32_t PR3;                         /*!< (@ 0x0000004C) Offset:0x4C EBI Polarity Register 3                        */
    
    struct {
      __IM  uint32_t CSPOL      : 1;            /*!< [0..0] Chip Select polarity                                               */
      __IM  uint32_t OEPOL      : 1;            /*!< [1..1] Output Enable polarity                                             */
      __IM  uint32_t WEPOL      : 1;            /*!< [2..2] Write Enable polarity                                              */
      __IM  uint32_t ALEPOL     : 1;            /*!< [3..3] Address Latch polarity                                             */
      __IOM uint32_t ARDYPOL    : 1;            /*!< [4..4] Asynchronous Ready polarity                                        */
      __IM  uint32_t UBLBPOL    : 1;            /*!< [5..5] Upper Byte and Lower Byte polarity                                 */
            uint32_t            : 26;
    } PR3_b;
  } ;
  
  union {
    __IOM uint32_t IE;                          /*!< (@ 0x00000050) Offset:0x50 EBI Interrupt Enable Register                  */
    
    struct {
      __IOM uint32_t ARDYTOEN   : 1;            /*!< [0..0] EBI asynchronous ready time-out interrupt enable bit               */
      __IOM uint32_t ACCDISEN   : 1;            /*!< [1..1] Interrupt for accessing the disabled bank enable bit               */
      __IOM uint32_t SMRSTEN    : 1;            /*!< [2..2] Interrupt for issuing a transaction during EBI state
                                                     machine reset period enable bit                                           */
      __IOM uint32_t RWERREN    : 1;            /*!< [3..3] Interrupt for read/writer error enable bit                         */
      __IOM uint32_t DMAHTIE    : 1;            /*!< [4..4] DMA half-transfer interrupt enable bit                             */
      __IOM uint32_t DMATCIE    : 1;            /*!< [5..5] DMA transfer complete interrupt enable bit                         */
            uint32_t            : 26;
    } IE_b;
  } ;
  
  union {
    __IM  uint32_t RIS;                         /*!< (@ 0x00000054) Offset:0x54 EBI Interrupt Flag Register                    */
    
    struct {
      __IM  uint32_t ARDYTOIF   : 1;            /*!< [0..0] EBI asynchronous ready time-out flag                               */
      __IM  uint32_t ACCDISIF   : 1;            /*!< [1..1] EBI accessing the disabled bank flag                               */
      __IM  uint32_t SMRSTIF    : 1;            /*!< [2..2] EBI state machine reset flag                                       */
      __IM  uint32_t RWERRIF    : 1;            /*!< [3..3] EBI read/write error flag                                          */
      __IM  uint32_t DMAHTIF    : 1;            /*!< [4..4] DMA half-transfer flag                                             */
      __IM  uint32_t DMATCIF    : 1;            /*!< [5..5] DMA transfer complete flag                                         */
            uint32_t            : 26;
    } RIS_b;
  } ;
  
  union {
    __OM  uint32_t IC;                          /*!< (@ 0x00000058) Offset:0x58 EBI Interrupt Clear Register                   */
    
    struct {
      __OM  uint32_t ARDYTOIC   : 1;            /*!< [0..0] Select ARDYTOIF flag to be cleared                                 */
      __OM  uint32_t ACCDISIC   : 1;            /*!< [1..1] Select ACCDISIF flag to be cleared                                 */
      __OM  uint32_t SMRSTIC    : 1;            /*!< [2..2] Select SMRSTIF flag to be cleared                                  */
      __OM  uint32_t RWERRIC    : 1;            /*!< [3..3] Select RWERRIF flag to be cleared                                  */
      __OM  uint32_t DMAHTIC    : 1;            /*!< [4..4] Select DMA half-transfer flag to be cleared                        */
      __OM  uint32_t DMATCIC    : 1;            /*!< [5..5] Select DMA transfer complete flag to be cleared                    */
            uint32_t            : 26;
    } IC_b;
  } ;
  
  union {
    __IOM uint32_t DMACTRL;                     /*!< (@ 0x0000005C) Offset:0x5C EBI DMA Control Register                       */
    
    struct {
      __IOM uint32_t DMAEN      : 1;            /*!< [0..0] EBI DMA enable bit                                                 */
      __IOM uint32_t SPISELECT  : 1;            /*!< [1..1] SPIn select bit                                                    */
      __IOM uint32_t BANKSELECT : 2;            /*!< [3..2] EBI Bank n select bits                                             */
            uint32_t            : 28;
    } DMACTRL_b;
  } ;
  __IM  uint32_t  RESERVED1;
  
  union {
    __IOM uint32_t DMACNT;                      /*!< (@ 0x00000064) Offset:0x64 DMA Number of data transfer register           */
    
    struct {
      __IOM uint32_t CNT        : 28;           /*!< [27..0] Number of data to DMA RX count transfer                           */
            uint32_t            : 4;
    } DMACNT_b;
  } ;
  
  union {
    __IOM uint32_t DMAHTCNT;                    /*!< (@ 0x00000068) Offset:0x68 EBI DMA Half-transfer Register                 */
    
    struct {
      __IOM uint32_t HTCNT      : 28;           /*!< [27..0] Number of data to DMA RX half count transfer                      */
            uint32_t            : 4;
    } DMAHTCNT_b;
  } ;
  
  union {
    __IM  uint32_t CURCNT;                      /*!< (@ 0x0000006C) Offset:0x6C EBI DMA Current Transfer Data Counter
                                                                    Register                                                   */
    
    struct {
      __IM  uint32_t CURCNT     : 28;           /*!< [27..0] Number of data to DMA RX half count transfer                      */
            uint32_t            : 4;
    } CURCNT_b;
  } ;
} SN_EBI_Type;                                  /*!< Size = 112 (0x70)                                                         */



/* =========================================================================================================================== */
/* ================                                          SN_USB                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief Universal Serial Bus Full Speed Device Interface (USB) (SN_USB)
  */

typedef struct {                                /*!< (@ 0x4005C000) SN_USB Structure                                           */
  
  union {
    __IOM uint32_t INTEN;                       /*!< (@ 0x00000000) Offset:0x00 USB Interrupt Enable Register                  */
    
    struct {
      __IOM uint32_t EP1_NAK_EN : 1;            /*!< [0..0] EP1 NAK Interrupt Enable                                           */
      __IOM uint32_t EP2_NAK_EN : 1;            /*!< [1..1] EP2 NAK Interrupt Enable                                           */
      __IOM uint32_t EP3_NAK_EN : 1;            /*!< [2..2] EP3 NAK Interrupt Enable                                           */
      __IOM uint32_t EP4_NAK_EN : 1;            /*!< [3..3] EP4 NAK Interrupt Enable                                           */
      __IOM uint32_t EP5_NAK_EN : 1;            /*!< [4..4] EP5 NAK Interrupt Enable                                           */
      __IOM uint32_t EP6_NAK_EN : 1;            /*!< [5..5] EP6 NAK Interrupt Enable                                           */
      __IOM uint32_t EPN_ACK_EN : 1;            /*!< [6..6] EPN ACK Interrupt Enable                                           */
            uint32_t            : 21;
      __IOM uint32_t BUSWK_IE   : 1;            /*!< [28..28] USB Bus Wake Up Interrupt Enable                                 */
      __IOM uint32_t USB_IE     : 1;            /*!< [29..29] USB Event Interrupt Enable                                       */
      __IOM uint32_t USB_SOF_IE : 1;            /*!< [30..30] USB SOF Interrupt Enable                                         */
      __IOM uint32_t BUS_IE     : 1;            /*!< [31..31] Bus Event Interrupt Enable                                       */
    } INTEN_b;
  } ;
  
  union {
    __IM  uint32_t INSTS;                       /*!< (@ 0x00000004) Offset:0x04 USB Interrupt Event Status Register            */
    
    struct {
      __IM  uint32_t EP1_NAK    : 1;            /*!< [0..0] Endpoint 1 NAK transaction flag                                    */
      __IM  uint32_t EP2_NAK    : 1;            /*!< [1..1] Endpoint 2 NAK transaction flag                                    */
      __IM  uint32_t EP3_NAK    : 1;            /*!< [2..2] Endpoint 3 NAK transaction flag                                    */
      __IM  uint32_t EP4_NAK    : 1;            /*!< [3..3] Endpoint 4 NAK transaction flag                                    */
      __IM  uint32_t EP5_NAK    : 1;            /*!< [4..4] Endpoint 5 NAK transaction flag                                    */
      __IM  uint32_t EP6_NAK    : 1;            /*!< [5..5] Endpoint 6 NAK transaction flag                                    */
            uint32_t            : 2;
      __IM  uint32_t EP1_ACK    : 1;            /*!< [8..8] Endpoint 1 ACK transaction flag                                    */
      __IM  uint32_t EP2_ACK    : 1;            /*!< [9..9] Endpoint 2 ACK transaction flag                                    */
      __IM  uint32_t EP3_ACK    : 1;            /*!< [10..10] Endpoint 3 ACK transaction flag                                  */
      __IM  uint32_t EP4_ACK    : 1;            /*!< [11..11] Endpoint 4 ACK transaction flag                                  */
      __IM  uint32_t EP5_ACK    : 1;            /*!< [12..12] Endpoint 5 ACK transaction flag                                  */
      __IM  uint32_t EP6_ACK    : 1;            /*!< [13..13] Endpoint 6 ACK transaction flag                                  */
            uint32_t            : 3;
      __IM  uint32_t ERR_TIMEOUT : 1;           /*!< [17..17] Timeout Status                                                   */
      __IM  uint32_t ERR_SETUP  : 1;            /*!< [18..18] Wrong Setup data received                                        */
      __IM  uint32_t EP0_OUT_STALL : 1;         /*!< [19..19] EP0 OUT STALL transaction                                        */
      __IM  uint32_t EP0_IN_STALL : 1;          /*!< [20..20] EP0 IN STALL Transaction is completed                            */
      __IM  uint32_t EP0_OUT    : 1;            /*!< [21..21] EP0 OUT ACK Transaction Flag                                     */
      __IM  uint32_t EP0_IN     : 1;            /*!< [22..22] EP0 IN ACK Transaction Flag                                      */
      __IM  uint32_t EP0_SETUP  : 1;            /*!< [23..23] EP0 Setup Transaction Flag                                       */
      __IM  uint32_t EP0_PRESETUP : 1;          /*!< [24..24] EP0 Setup Token Packet Flag                                      */
      __IM  uint32_t BUS_WAKEUP : 1;            /*!< [25..25] Bus Wakeup Flag                                                  */
      __IM  uint32_t USB_SOF    : 1;            /*!< [26..26] USB SOF packet received flag                                     */
            uint32_t            : 2;
      __IM  uint32_t BUS_RESUME : 1;            /*!< [29..29] USB Bus Resume signal flag                                       */
      __IM  uint32_t BUS_SUSPEND : 1;           /*!< [30..30] USB Bus Suspend signal flag                                      */
      __IM  uint32_t BUS_RESET  : 1;            /*!< [31..31] USB Bus Reset signal flag                                        */
    } INSTS_b;
  } ;
  
  union {
    __OM  uint32_t INSTSC;                      /*!< (@ 0x00000008) Offset:0x08 USB Interrupt Event Status Clear
                                                                    Register                                                   */
    
    struct {
      __OM  uint32_t EP1_NAKC   : 1;            /*!< [0..0] EP1 NAK clear bit                                                  */
      __OM  uint32_t EP2_NAKC   : 1;            /*!< [1..1] EP2 NAK clear bit                                                  */
      __OM  uint32_t EP3_NAKC   : 1;            /*!< [2..2] EP3 NAK clear bit                                                  */
      __OM  uint32_t EP4_NAKC   : 1;            /*!< [3..3] EP4 NAK clear bit                                                  */
      __OM  uint32_t EP5_NAKC   : 1;            /*!< [4..4] EP5 NAK clear bit                                                  */
      __OM  uint32_t EP6_NAKC   : 1;            /*!< [5..5] EP6 NAK clear bit                                                  */
            uint32_t            : 2;
      __OM  uint32_t EP1_ACKC   : 1;            /*!< [8..8] EP1 ACK clear bit                                                  */
      __OM  uint32_t EP2_ACKC   : 1;            /*!< [9..9] EP2 ACK clear bit                                                  */
      __OM  uint32_t EP3_ACKC   : 1;            /*!< [10..10] EP3 ACK clear bit                                                */
      __OM  uint32_t EP4_ACKC   : 1;            /*!< [11..11] EP4 ACK clear bit                                                */
      __OM  uint32_t EP5_ACKC   : 1;            /*!< [12..12] EP5 ACK clear bit                                                */
      __OM  uint32_t EP6_ACKC   : 1;            /*!< [13..13] EP6 ACK clear bit                                                */
            uint32_t            : 3;
      __OM  uint32_t ERR_TIMEOUTC : 1;          /*!< [17..17] Timeout Error clear bit                                          */
      __OM  uint32_t ERR_SETUPC : 1;            /*!< [18..18] Error Setup clear bit                                            */
      __OM  uint32_t EP0_OUT_STALLC : 1;        /*!< [19..19] EP0 OUT STALL clear bit                                          */
      __OM  uint32_t EP0_IN_STALLC : 1;         /*!< [20..20] EP0 IN STALL clear bit                                           */
      __OM  uint32_t EP0_OUTC   : 1;            /*!< [21..21] EP0 OUT clear bit                                                */
      __OM  uint32_t EP0_INC    : 1;            /*!< [22..22] EP0 IN clear bit                                                 */
      __OM  uint32_t EP0_SETUPC : 1;            /*!< [23..23] EP0 SETUP clear bit                                              */
      __OM  uint32_t EP0_PRESETUPC : 1;         /*!< [24..24] EP0 PRESETUP clear bit                                           */
      __OM  uint32_t BUS_WAKEUPC : 1;           /*!< [25..25] Bus Wakeup clear bit                                             */
      __OM  uint32_t USB_SOFC   : 1;            /*!< [26..26] USB SOF clear bit                                                */
            uint32_t            : 2;
      __OM  uint32_t BUS_RESUMEC : 1;           /*!< [29..29] USB Bus Resume clear bit                                         */
            uint32_t            : 1;
      __OM  uint32_t BUS_RESETC : 1;            /*!< [31..31] USB Bus Reset clear bit                                          */
    } INSTSC_b;
  } ;
  
  union {
    __IOM uint32_t ADDR;                        /*!< (@ 0x0000000C) Offset:0x0C USB Device Address Register                    */
    
    struct {
      __IOM uint32_t UADDR      : 7;            /*!< [6..0] USB device's address                                               */
            uint32_t            : 25;
    } ADDR_b;
  } ;
  
  union {
    __IOM uint32_t CFG;                         /*!< (@ 0x00000010) Offset:0x10 USB Configuration Register                     */
    
    struct {
      __IOM uint32_t EP1_DIR    : 1;            /*!< [0..0] Endpoint 1 IN/OUT direction setting                                */
      __IOM uint32_t EP2_DIR    : 1;            /*!< [1..1] Endpoint 2 IN/OUT direction setting                                */
      __IOM uint32_t EP3_DIR    : 1;            /*!< [2..2] Endpoint 3 IN/OUT direction setting                                */
      __IOM uint32_t EP4_DIR    : 1;            /*!< [3..3] Endpoint 4 IN/OUT direction setting                                */
      __IOM uint32_t EP5_DIR    : 1;            /*!< [4..4] Endpoint 5 IN/OUT direction setting                                */
      __IOM uint32_t EP6_DIR    : 1;            /*!< [5..5] Endpoint 6 IN/OUT direction setting                                */
            uint32_t            : 20;
      __IOM uint32_t DIS_PDEN   : 1;            /*!< [26..26] Enable internal D+ and D- 175k pull-down resistor                */
      __IOM uint32_t ESD_EN     : 1;            /*!< [27..27] Enable USB anti-ESD protection                                   */
      __IOM uint32_t SIE_EN     : 1;            /*!< [28..28] USB Serial Interface Engine Enable                               */
      __IOM uint32_t DPPU_EN    : 1;            /*!< [29..29] Enable internal D+ 1.5k pull-up resistor                         */
      __IOM uint32_t PHY_EN     : 1;            /*!< [30..30] PHY Transceiver Function Enable                                  */
      __IOM uint32_t VREG33_EN  : 1;            /*!< [31..31] Enable the internal VREG33 ouput                                 */
    } CFG_b;
  } ;
  
  union {
    __IOM uint32_t SGCTL;                       /*!< (@ 0x00000014) Offset:0x14 USB Signal Control Register                    */
    
    struct {
      __IOM uint32_t BUS_DN     : 1;            /*!< [0..0] USB D- state                                                       */
      __IOM uint32_t BUS_DP     : 1;            /*!< [1..1] USB DP state                                                       */
      __IOM uint32_t BUS_DRVEN  : 1;            /*!< [2..2] Enable to drive USB bus                                            */
            uint32_t            : 29;
    } SGCTL_b;
  } ;
  
  union {
    __IOM uint32_t EP0CTL;                      /*!< (@ 0x00000018) Offset:0x18 USB Endpoint 0 Control Register                */
    
    struct {
      __IOM uint32_t ENDP_CNT   : 7;            /*!< [6..0] Endpoint byte count                                                */
            uint32_t            : 20;
      __IOM uint32_t OUT_STALL_EN : 1;          /*!< [27..27] Enable EP0 OUT STALL handshake                                   */
      __IOM uint32_t IN_STALL_EN : 1;           /*!< [28..28] Enable EP0 IN STALL handshake                                    */
      __IOM uint32_t ENDP_STATE : 2;            /*!< [30..29] Endpoint Handshake State                                         */
      __IOM uint32_t ENDP_EN    : 1;            /*!< [31..31] Enable Endpoint 0 Function                                       */
    } EP0CTL_b;
  } ;
  
  union {
    __IOM uint32_t EP1CTL;                      /*!< (@ 0x0000001C) Offset:0x1C USB Endpoint 1 Control Register                */
    
    struct {
      __IOM uint32_t ENDP_CNT   : 7;            /*!< [6..0] Endpoint byte count                                                */
            uint32_t            : 22;
      __IOM uint32_t ENDP_STATE : 2;            /*!< [30..29] Endpoint Handshake State                                         */
      __IOM uint32_t ENDP_EN    : 1;            /*!< [31..31] Endpoint 1 Function enable bit                                   */
    } EP1CTL_b;
  } ;
  
  union {
    __IOM uint32_t EP2CTL;                      /*!< (@ 0x00000020) Offset:0x20 USB Endpoint 2 Control Register                */
    
    struct {
      __IOM uint32_t ENDP_CNT   : 7;            /*!< [6..0] Endpoint byte count                                                */
            uint32_t            : 22;
      __IOM uint32_t ENDP_STATE : 2;            /*!< [30..29] Endpoint Handshake State                                         */
      __IOM uint32_t ENDP_EN    : 1;            /*!< [31..31] Endpoint 2 Function enable bit                                   */
    } EP2CTL_b;
  } ;
  
  union {
    __IOM uint32_t EP3CTL;                      /*!< (@ 0x00000024) Offset:0x24 USB Endpoint 3 Control Register                */
    
    struct {
      __IOM uint32_t ENDP_CNT   : 7;            /*!< [6..0] Endpoint byte count                                                */
            uint32_t            : 22;
      __IOM uint32_t ENDP_STATE : 2;            /*!< [30..29] Endpoint Handshake State                                         */
      __IOM uint32_t ENDP_EN    : 1;            /*!< [31..31] Endpoint 3 Function enable bit                                   */
    } EP3CTL_b;
  } ;
  
  union {
    __IOM uint32_t EP4CTL;                      /*!< (@ 0x00000028) Offset:0x28 USB Endpoint 4 Control Register                */
    
    struct {
      __IOM uint32_t ENDP_CNT   : 7;            /*!< [6..0] Endpoint byte count                                                */
            uint32_t            : 22;
      __IOM uint32_t ENDP_STATE : 2;            /*!< [30..29] Endpoint Handshake State                                         */
      __IOM uint32_t ENDP_EN    : 1;            /*!< [31..31] Endpoint 4 Function enable bit                                   */
    } EP4CTL_b;
  } ;
  
  union {
    __IOM uint32_t EP5CTL;                      /*!< (@ 0x0000002C) Offset:0x2C USB Endpoint 5 Control Register                */
    
    struct {
      __IOM uint32_t ENDP_CNT   : 7;            /*!< [6..0] Endpoint byte count                                                */
            uint32_t            : 22;
      __IOM uint32_t ENDP_STATE : 2;            /*!< [30..29] Endpoint Handshake State                                         */
      __IOM uint32_t ENDP_EN    : 1;            /*!< [31..31] Endpoint 5 Function enable bit                                   */
    } EP5CTL_b;
  } ;
  
  union {
    __IOM uint32_t EP6CTL;                      /*!< (@ 0x00000030) Offset:0x30 USB Endpoint 6 Control Register                */
    
    struct {
      __IOM uint32_t ENDP_CNT   : 7;            /*!< [6..0] Endpoint byte count                                                */
            uint32_t            : 22;
      __IOM uint32_t ENDP_STATE : 2;            /*!< [30..29] Endpoint Handshake State                                         */
      __IOM uint32_t ENDP_EN    : 1;            /*!< [31..31] Endpoint 6 Function enable bit                                   */
    } EP6CTL_b;
  } ;
  __IM  uint32_t  RESERVED[2];
  
  union {
    __IOM uint32_t EPTOGGLE;                    /*!< (@ 0x0000003C) Offset:0x3C USB Endpoint Data Toggle Register              */
    
    struct {
      __IOM uint32_t ENDP1_DATA01 : 1;          /*!< [0..0] Endpoint 1 data toggle bit                                         */
      __IOM uint32_t ENDP2_DATA01 : 1;          /*!< [1..1] Endpoint 2 data toggle bit                                         */
      __IOM uint32_t ENDP3_DATA01 : 1;          /*!< [2..2] Endpoint 3 data toggle bit                                         */
      __IOM uint32_t ENDP4_DATA01 : 1;          /*!< [3..3] Endpoint 4 data toggle bit                                         */
      __IOM uint32_t ENDP5_DATA01 : 1;          /*!< [4..4] Endpoint 5 data toggle bit                                         */
      __IOM uint32_t ENDP6_DATA01 : 1;          /*!< [5..5] Endpoint 6 data toggle bit                                         */
            uint32_t            : 26;
    } EPTOGGLE_b;
  } ;
  __IM  uint32_t  RESERVED1[2];
  
  union {
    __IOM uint32_t EP1BUFOS;                    /*!< (@ 0x00000048) Offset:0x48 USB Endpoint 1 Buffer Offset Register          */
    
    struct {
            uint32_t            : 2;
      __IOM uint32_t OFFSET     : 7;            /*!< [8..2] The offset address for endpoint data buffer                        */
            uint32_t            : 23;
    } EP1BUFOS_b;
  } ;
  
  union {
    __IOM uint32_t EP2BUFOS;                    /*!< (@ 0x0000004C) Offset:0x4C USB Endpoint 2 Buffer Offset Register          */
    
    struct {
            uint32_t            : 2;
      __IOM uint32_t OFFSET     : 7;            /*!< [8..2] The offset address for endpoint data buffer                        */
            uint32_t            : 23;
    } EP2BUFOS_b;
  } ;
  
  union {
    __IOM uint32_t EP3BUFOS;                    /*!< (@ 0x00000050) Offset:0x50 USB Endpoint 3 Buffer Offset Register          */
    
    struct {
            uint32_t            : 2;
      __IOM uint32_t OFFSET     : 7;            /*!< [8..2] The offset address for endpoint data buffer                        */
            uint32_t            : 23;
    } EP3BUFOS_b;
  } ;
  
  union {
    __IOM uint32_t EP4BUFOS;                    /*!< (@ 0x00000054) Offset:0x54 USB Endpoint 4 Buffer Offset Register          */
    
    struct {
            uint32_t            : 2;
      __IOM uint32_t OFFSET     : 7;            /*!< [8..2] The offset address for endpoint data buffer                        */
            uint32_t            : 23;
    } EP4BUFOS_b;
  } ;
  
  union {
    __IOM uint32_t EP5BUFOS;                    /*!< (@ 0x00000058) Offset:0x58 USB Endpoint 5 Buffer Offset Register          */
    
    struct {
            uint32_t            : 2;
      __IOM uint32_t OFFSET     : 7;            /*!< [8..2] The offset address for endpoint data buffer                        */
            uint32_t            : 23;
    } EP5BUFOS_b;
  } ;
  
  union {
    __IOM uint32_t EP6BUFOS;                    /*!< (@ 0x0000005C) Offset:0x5C USB Endpoint 6 Buffer Offset Register          */
    
    struct {
            uint32_t            : 2;
      __IOM uint32_t OFFSET     : 7;            /*!< [8..2] The offset address for endpoint data buffer                        */
            uint32_t            : 23;
    } EP6BUFOS_b;
  } ;
  
  union {
    __IM  uint32_t FRMNO;                       /*!< (@ 0x00000060) Offset:0x60 USB Frame Number Register                      */
    
    struct {
      __IM  uint32_t FRAME_NO   : 11;           /*!< [10..0] The 11-bit frame number of the SOF packet                         */
            uint32_t            : 21;
    } FRMNO_b;
  } ;
  
  union {
    __IOM uint32_t PHYPRM;                      /*!< (@ 0x00000064) Offset:0x64 USB PHY Parameter Register                     */
    
    struct {
      __IOM uint32_t PHY_PARAM  : 6;            /*!< [5..0] USB PHY parameter                                                  */
            uint32_t            : 26;
    } PHYPRM_b;
  } ;
  __IM  uint32_t  RESERVED2;
  
  union {
    __IOM uint32_t PHYPRM2;                     /*!< (@ 0x0000006C) Offset:0x6C USB PHY Parameter Register 2                   */
    
    struct {
      __IOM uint32_t PHY_PS     : 15;           /*!< [14..0] USB PHY parameter 2                                               */
            uint32_t            : 17;
    } PHYPRM2_b;
  } ;
  
  union {
    __IOM uint32_t PS2CTL;                      /*!< (@ 0x00000070) Offset:0x70 PS/2 Control Register                          */
    
    struct {
      __IOM uint32_t SCKM       : 1;            /*!< [0..0] PS/2 SCK mode control bit                                          */
      __IOM uint32_t SDAM       : 1;            /*!< [1..1] PS/2 SDA mode control bit                                          */
      __IOM uint32_t SCK        : 1;            /*!< [2..2] PS/2 SCK data buffer                                               */
      __IOM uint32_t SDA        : 1;            /*!< [3..3] PS/2 SDA data buffer                                               */
            uint32_t            : 27;
      __IOM uint32_t PS2ENB     : 1;            /*!< [31..31] PS/2 internal 5k ohm pull-up resistor control bit                */
    } PS2CTL_b;
  } ;
  __IM  uint32_t  RESERVED3;
  
  union {
    __IOM uint32_t RWADDR;                      /*!< (@ 0x00000078) Offset:0x78 USB Read/Write Address Register                */
    
    struct {
            uint32_t            : 2;
      __IOM uint32_t RWADDR     : 6;            /*!< [7..2] USB FIFO address to be read or written from/to USB FIFO            */
            uint32_t            : 24;
    } RWADDR_b;
  } ;
  
  union {
    __IOM uint32_t RWDATA;                      /*!< (@ 0x0000007C) Offset:0x7C USB Read/Write Data Register                   */
    
    struct {
      __IOM uint32_t RWDATA     : 32;           /*!< [31..0] Data to be read or written from/to USB FIFO                       */
    } RWDATA_b;
  } ;
  
  union {
    __IOM uint32_t RWSTATUS;                    /*!< (@ 0x00000080) Offset:0x80 USB Read/Write Status Register                 */
    
    struct {
      __IOM uint32_t W_STATUS   : 1;            /*!< [0..0] Write status of USB FIFO                                           */
      __IOM uint32_t R_STATUS   : 1;            /*!< [1..1] WRead status of USB FIFO                                           */
            uint32_t            : 30;
    } RWSTATUS_b;
  } ;
  
  union {
    __IOM uint32_t RWADDR2;                     /*!< (@ 0x00000084) Offset:0x84 USB Read/Write Address Register 2              */
    
    struct {
            uint32_t            : 2;
      __IOM uint32_t RWADDR     : 6;            /*!< [7..2] USB FIFO address to be read or written from/to USB FIFO            */
            uint32_t            : 24;
    } RWADDR2_b;
  } ;
  
  union {
    __IOM uint32_t RWDATA2;                     /*!< (@ 0x00000088) Offset:0x88 USB Read/Write Data Register 2                 */
    
    struct {
      __IOM uint32_t RWDATA     : 32;           /*!< [31..0] Data to be read or written from/to USB FIFO                       */
    } RWDATA2_b;
  } ;
  
  union {
    __IOM uint32_t RWSTATUS2;                   /*!< (@ 0x0000008C) Offset:0x8C USB Read/Write Status Register 2               */
    
    struct {
      __IOM uint32_t W_STATUS   : 1;            /*!< [0..0] Write status of USB FIFO                                           */
      __IOM uint32_t R_STATUS   : 1;            /*!< [1..1] WRead status of USB FIFO                                           */
            uint32_t            : 30;
    } RWSTATUS2_b;
  } ;
} SN_USB_Type;                                  /*!< Size = 144 (0x90)                                                         */



/* =========================================================================================================================== */
/* ================                                           SN_UC                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief UC Registers (SN_UC)
  */

typedef struct {                                /*!< (@ 0x1FFF2450) SN_UC Structure                                            */
  __IM  uint32_t  L4BYTE;                       /*!< (@ 0x00000000) Offset:0x00 UC Low 4 Byte Register                         */
  __IM  uint32_t  RESERVED;
  __IM  uint32_t  H4BYTE;                       /*!< (@ 0x00000008) Offset:0x08 UC High 4 Byte Register                        */
} SN_UC_Type;                                   /*!< Size = 12 (0xc)                                                           */


/** @} */ /* End of group Device_Peripheral_peripherals */


/* =========================================================================================================================== */
/* ================                          Device Specific Peripheral Address Map                           ================ */
/* =========================================================================================================================== */


/** @addtogroup Device_Peripheral_peripheralAddr
  * @{
  */

#define SN_SYS0_BASE                0x40060000UL
#define SN_SYS1_BASE                0x4005E000UL
#define SN_PMU_BASE                 0x40032000UL
#define SN_PFPA_BASE                0x40042000UL
#define SN_GPIO1_BASE               0x40046000UL
#define SN_GPIO2_BASE               0x40048000UL
#define SN_GPIO3_BASE               0x4004A000UL
#define SN_GPIO0_BASE               0x40044000UL
#define SN_ADC_BASE                 0x40026000UL
#define SN_CMP_BASE                 0x40028000UL
#define SN_CT16B0_BASE              0x40000000UL
#define SN_CT16B1_BASE              0x40002000UL
#define SN_CT16B2_BASE              0x40004000UL
#define SN_CT16B3_BASE              0x40006000UL
#define SN_CT16B4_BASE              0x40008000UL
#define SN_CT16B5_BASE              0x4000A000UL
#define SN_WDT_BASE                 0x40010000UL
#define SN_RTC_BASE                 0x40012000UL
#define SN_SPI0_BASE                0x4001C000UL
#define SN_SPI1_BASE                0x40058000UL
#define SN_I2C0_BASE                0x40018000UL
#define SN_I2C1_BASE                0x4005A000UL
#define SN_UART0_BASE               0x40016000UL
#define SN_UART1_BASE               0x40056000UL
#define SN_UART2_BASE               0x40054000UL
#define SN_UART3_BASE               0x40052000UL
#define SN_I2S0_BASE                0x4001A000UL
#define SN_I2S1_BASE                0x40014000UL
#define SN_FLASH_BASE               0x40062000UL
#define SN_LCD_BASE                 0x40034000UL
#define SN_CRC_BASE                 0x40038000UL
#define SN_OPA_BASE                 0x4002A000UL
#define SN_EBI_BASE                 0x40036000UL
#define SN_USB_BASE                 0x4005C000UL
#define SN_UC_BASE                  0x1FFF2450UL

/** @} */ /* End of group Device_Peripheral_peripheralAddr */


/* =========================================================================================================================== */
/* ================                                  Peripheral declaration                                   ================ */
/* =========================================================================================================================== */


/** @addtogroup Device_Peripheral_declaration
  * @{
  */

#define SN_SYS0                     ((SN_SYS0_Type*)           SN_SYS0_BASE)
#define SN_SYS1                     ((SN_SYS1_Type*)           SN_SYS1_BASE)
#define SN_PMU                      ((SN_PMU_Type*)            SN_PMU_BASE)
#define SN_PFPA                     ((SN_PFPA_Type*)           SN_PFPA_BASE)
#define SN_GPIO1                    ((SN_GPIO1_Type*)          SN_GPIO1_BASE)
#define SN_GPIO2                    ((SN_GPIO2_Type*)          SN_GPIO2_BASE)
#define SN_GPIO3                    ((SN_GPIO1_Type*)          SN_GPIO3_BASE)
#define SN_GPIO0                    ((SN_GPIO1_Type*)          SN_GPIO0_BASE)
#define SN_ADC                      ((SN_ADC_Type*)            SN_ADC_BASE)
#define SN_CMP                      ((SN_CMP_Type*)            SN_CMP_BASE)
#define SN_CT16B0                   ((SN_CT16B0_Type*)         SN_CT16B0_BASE)
#define SN_CT16B1                   ((SN_CT16B1_Type*)         SN_CT16B1_BASE)
#define SN_CT16B2                   ((SN_CT16B2_Type*)         SN_CT16B2_BASE)
#define SN_CT16B3                   ((SN_CT16B3_Type*)         SN_CT16B3_BASE)
#define SN_CT16B4                   ((SN_CT16B3_Type*)         SN_CT16B4_BASE)
#define SN_CT16B5                   ((SN_CT16B5_Type*)         SN_CT16B5_BASE)
#define SN_WDT                      ((SN_WDT_Type*)            SN_WDT_BASE)
#define SN_RTC                      ((SN_RTC_Type*)            SN_RTC_BASE)
#define SN_SPI0                     ((SN_SPI0_Type*)           SN_SPI0_BASE)
#define SN_SPI1                     ((SN_SPI1_Type*)           SN_SPI1_BASE)
#define SN_I2C0                     ((SN_I2C0_Type*)           SN_I2C0_BASE)
#define SN_I2C1                     ((SN_I2C0_Type*)           SN_I2C1_BASE)
#define SN_UART0                    ((SN_UART0_Type*)          SN_UART0_BASE)
#define SN_UART1                    ((SN_UART0_Type*)          SN_UART1_BASE)
#define SN_UART2                    ((SN_UART0_Type*)          SN_UART2_BASE)
#define SN_UART3                    ((SN_UART0_Type*)          SN_UART3_BASE)
#define SN_I2S0                     ((SN_I2S0_Type*)           SN_I2S0_BASE)
#define SN_I2S1                     ((SN_I2S0_Type*)           SN_I2S1_BASE)
#define SN_FLASH                    ((SN_FLASH_Type*)          SN_FLASH_BASE)
#define SN_LCD                      ((SN_LCD_Type*)            SN_LCD_BASE)
#define SN_CRC                      ((SN_CRC_Type*)            SN_CRC_BASE)
#define SN_OPA                      ((SN_OPA_Type*)            SN_OPA_BASE)
#define SN_EBI                      ((SN_EBI_Type*)            SN_EBI_BASE)
#define SN_USB                      ((SN_USB_Type*)            SN_USB_BASE)
#define SN_UC                       ((SN_UC_Type*)             SN_UC_BASE)

/** @} */ /* End of group Device_Peripheral_declaration */


/* =========================================  End of section using anonymous unions  ========================================= */
#if defined (__CC_ARM)
  #pragma pop
#elif defined (__ICCARM__)
  /* leave anonymous unions enabled */
#elif defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
  #pragma clang diagnostic pop
#elif defined (__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined (__TMS470__)
  /* anonymous unions are enabled by default */
#elif defined (__TASKING__)
  #pragma warning restore
#elif defined (__CSMC__)
  /* anonymous unions are enabled by default */
#endif


#ifdef __cplusplus
}
#endif

#endif /* SN32F290_H */


/** @} */ /* End of group SN32F290 */

/** @} */ /* End of group SONiX Technology Co., Ltd. */
