/**
  ******************************************************************************
  * @file    stm32mp153fxx_cm4.h
  * @author  MCD Application Team
  * @brief   CMSIS stm32mp153fxx_cm4 Device Peripheral Access Layer Header File.
  *
  *          This file contains:
  *           - Data structures and the address mapping for all peripherals
  *           - Peripheral's registers declarations and bits definition
  *           - Macros to access peripherals registers hardware
  *
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2019 STMicroelectronics.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by ST under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  */

/** @addtogroup CMSIS_Device
  * @{
  */

/** @addtogroup stm32mp153fxx_cm4
  * @{
  */

#ifndef __STM32MP153Fxx_CM4_H
#define __STM32MP153Fxx_CM4_H

#ifdef __cplusplus
 extern "C" {
#endif /* __cplusplus */

/**
  * @brief Bit position definition inside a 32 bits registers
  */
#define  B(x) \
        ((uint32_t) 1 << x)
/**
  * @}
  */

/** @addtogroup Peripheral_interrupt_number_definition
  * @{
  */

/**
 * @brief STM32MP1XX Interrupt Number Definition, according to the selected device
 *        in @ref Library_configuration_section
 */
 typedef enum IRQn
 {
 /******  Cortex-M Processor Exceptions Numbers *******************************************************************/
   NonMaskableInt_IRQn         = -14,   /*!< 2 Non Maskable Interrupt                                             */
   HardFault_IRQn              = -13,   /*!< 4 Cortex-M Memory Management Interrupt                               */
   MemoryManagement_IRQn       = -12,   /*!< 4 Cortex-M Memory Management Interrupt                               */
   BusFault_IRQn               = -11,   /*!< 5 Cortex-M Bus Fault Interrupt                                       */
   UsageFault_IRQn             = -10,   /*!< 6 Cortex-M Usage Fault Interrupt                                     */
   SVCall_IRQn                 = -5,    /*!< 11 Cortex-M SV Call Interrupt                                        */
   DebugMonitor_IRQn           = -4,    /*!< 12 Cortex-M Debug Monitor Interrupt                                  */
   PendSV_IRQn                 = -2,    /*!< 14 Cortex-M Pend SV Interrupt                                        */
   SysTick_IRQn                = -1,    /*!< 15 Cortex-M System Tick Interrupt                                    */
 /******  STM32 specific Interrupt Numbers ************************************************************************/
   WWDG1_IRQn                  = 0,     /*!< Window WatchDog Interrupt                                            */
   PVD_AVD_IRQn                = 1,     /*!< PVD & AVD detector through EXTI                                      */
   TAMP_IRQn                   = 2,     /*!< Tamper interrupts through the EXTI line                              */
   RTC_WKUP_ALARM_IRQn         = 3,     /*!< RTC Wakeup and Alarm (A & B) interrupt through the EXTI line         */
   RESERVED_4                  = 4,     /*!< RESERVED interrupt                                                   */
   RCC_IRQn                    = 5,     /*!< RCC global Interrupt                                                 */
   EXTI0_IRQn                  = 6,     /*!< EXTI Line0 Interrupt                                                 */
   EXTI1_IRQn                  = 7,     /*!< EXTI Line1 Interrupt                                                 */
   EXTI2_IRQn                  = 8,     /*!< EXTI Line2 Interrupt                                                 */
   EXTI3_IRQn                  = 9,     /*!< EXTI Line3 Interrupt                                                 */
   EXTI4_IRQn                  = 10,    /*!< EXTI Line4 Interrupt                                                 */
   DMA1_Stream0_IRQn           = 11,    /*!< DMA1 Stream 0 global Interrupt                                       */
   DMA1_Stream1_IRQn           = 12,    /*!< DMA1 Stream 1 global Interrupt                                       */
   DMA1_Stream2_IRQn           = 13,    /*!< DMA1 Stream 2 global Interrupt                                       */
   DMA1_Stream3_IRQn           = 14,    /*!< DMA1 Stream 3 global Interrupt                                       */
   DMA1_Stream4_IRQn           = 15,    /*!< DMA1 Stream 4 global Interrupt                                       */
   DMA1_Stream5_IRQn           = 16,    /*!< DMA1 Stream 5 global Interrupt                                       */
   DMA1_Stream6_IRQn           = 17,    /*!< DMA1 Stream 6 global Interrupt                                       */
   ADC1_IRQn                   = 18,    /*!< ADC1 global Interrupts                                               */
   FDCAN1_IT0_IRQn             = 19,    /*!< FDCAN1 Interrupt line 0                                              */
   FDCAN2_IT0_IRQn             = 20,    /*!< FDCAN2 Interrupt line 0                                              */
   FDCAN1_IT1_IRQn             = 21,    /*!< FDCAN1 Interrupt line 1                                              */
   FDCAN2_IT1_IRQn             = 22,    /*!< FDCAN2 Interrupt line 1                                              */
   EXTI5_IRQn                  = 23,    /*!< External Line[9:5] Interrupts                                        */
   TIM1_BRK_IRQn               = 24,    /*!< TIM1 Break interrupt                                                 */
   TIM1_UP_IRQn                = 25,    /*!< TIM1 Update Interrupt                                                */
   TIM1_TRG_COM_IRQn           = 26,    /*!< TIM1 Trigger and Commutation Interrupt                               */
   TIM1_CC_IRQn                = 27,    /*!< TIM1 Capture Compare Interrupt                                       */
   TIM2_IRQn                   = 28,    /*!< TIM2 global Interrupt                                                */
   TIM3_IRQn                   = 29,    /*!< TIM3 global Interrupt                                                */
   TIM4_IRQn                   = 30,    /*!< TIM4 global Interrupt                                                */
   I2C1_EV_IRQn                = 31,    /*!< I2C1 Event Interrupt                                                 */
   I2C1_ER_IRQn                = 32,    /*!< I2C1 Error Interrupt                                                 */
   I2C2_EV_IRQn                = 33,    /*!< I2C2 Event Interrupt                                                 */
   I2C2_ER_IRQn                = 34,    /*!< I2C2 Error Interrupt                                                 */
   SPI1_IRQn                   = 35,    /*!< SPI1 global Interrupt                                                */
   SPI2_IRQn                   = 36,    /*!< SPI2 global Interrupt                                                */
   USART1_IRQn                 = 37,    /*!< USART1 global Interrupt                                              */
   USART2_IRQn                 = 38,    /*!< USART2 global Interrupt                                              */
   USART3_IRQn                 = 39,    /*!< USART3 global Interrupt                                              */
   EXTI10_IRQn                 = 40,    /*!< EXTI Line 10 Interrupts                                              */
   RTC_TIMESTAMP_IRQn          = 41,    /*!< RTC TimeStamp through EXTI Line Interrupt                            */
   EXTI11_IRQn                 = 42,    /*!< EXTI Line 11 Interrupts                                              */
   TIM8_BRK_IRQn               = 43,    /*!< TIM8 Break Interrupt                                                 */
   TIM8_UP_IRQn                = 44,    /*!< TIM8 Update Interrupt                                                */
   TIM8_TRG_COM_IRQn           = 45,    /*!< TIM8 Trigger and Commutation Interrupt                               */
   TIM8_CC_IRQn                = 46,    /*!< TIM8 Capture Compare Interrupt                                       */
   DMA1_Stream7_IRQn           = 47,    /*!< DMA1 Stream7 Interrupt                                               */
   FMC_IRQn                    = 48,    /*!< FMC global Interrupt                                                 */
   SDMMC1_IRQn                 = 49,    /*!< SDMMC1 global Interrupt                                              */
   TIM5_IRQn                   = 50,    /*!< TIM5 global Interrupt                                                */
   SPI3_IRQn                   = 51,    /*!< SPI3 global Interrupt                                                */
   UART4_IRQn                  = 52,    /*!< UART4 global Interrupt                                               */
   UART5_IRQn                  = 53,    /*!< UART5 global Interrupt                                               */
   TIM6_IRQn                   = 54,    /*!< TIM6 global                                                          */
   TIM7_IRQn                   = 55,    /*!< TIM7 global interrupt                                                */
   DMA2_Stream0_IRQn           = 56,    /*!< DMA2 Stream 0 global Interrupt                                       */
   DMA2_Stream1_IRQn           = 57,    /*!< DMA2 Stream 1 global Interrupt                                       */
   DMA2_Stream2_IRQn           = 58,    /*!< DMA2 Stream 2 global Interrupt                                       */
   DMA2_Stream3_IRQn           = 59,    /*!< GPDMA2 Stream 3 global Interrupt                                     */
   DMA2_Stream4_IRQn           = 60,    /*!< GPDMA2 Stream 4 global Interrupt                                     */
   ETH1_IRQn                   = 61,    /*!< Ethernet global Interrupt                                            */
   ETH1_WKUP_IRQn              = 62,    /*!< Ethernet Wakeup through EXTI line Interrupt                          */
   FDCAN_CAL_IRQn              = 63,    /*!< CAN calibration unit interrupt                                       */
   EXTI6_IRQn                  = 64,    /*!< EXTI Line 6 Interrupts                                               */
   EXTI7_IRQn                  = 65,    /*!< EXTI Line 7 Interrupts                                               */
   EXTI8_IRQn                  = 66,    /*!< EXTI Line 8 Interrupts                                               */
   EXTI9_IRQn                  = 67,    /*!< EXTI Line 9 Interrupts                                               */
   DMA2_Stream5_IRQn           = 68,    /*!< DMA2 Stream 5 global interrupt                                       */
   DMA2_Stream6_IRQn           = 69,    /*!< DMA2 Stream 6 global interrupt                                       */
   DMA2_Stream7_IRQn           = 70,    /*!< DMA2 Stream 7 global interrupt                                       */
   USART6_IRQn                 = 71,    /*!< USART6 global interrupt                                              */
   I2C3_EV_IRQn                = 72,    /*!< I2C3 event interrupt                                                 */
   I2C3_ER_IRQn                = 73,    /*!< I2C3 error interrupt                                                 */
   USBH_OHCI_IRQn              = 74,    /*!< USB OHCI global interrupt                                            */
   USBH_EHCI_IRQn              = 75,    /*!< USB EHCI global interrupt                                            */
   EXTI12_IRQn                 = 76,    /*!< EXTI Line 76 Interrupts                                              */
   EXTI13_IRQn                 = 77,    /*!< EXTI Line 77 Interrupts                                              */
   DCMI_IRQn                   = 78,    /*!< DCMI global interrupt                                                */
   CRYP1_IRQn                  = 79,    /*!< CRYP crypto global interrupt                                         */
   HASH1_IRQn                  = 80,    /*!< Hash global interrupt                                                */
   FPU_IRQn                    = 81,    /*!< FPU global interrupt                                                 */
   UART7_IRQn                  = 82,    /*!< UART7 global interrupt                                               */
   UART8_IRQn                  = 83,    /*!< UART8 global interrupt                                               */
   SPI4_IRQn                   = 84,    /*!< SPI4 global Interrupt                                                */
   SPI5_IRQn                   = 85,    /*!< SPI5 global Interrupt                                                */
   SPI6_IRQn                   = 86,    /*!< SPI6 global Interrupt                                                */
   SAI1_IRQn                   = 87,    /*!< SAI1 global Interrupt                                                */
   LTDC_IRQn                   = 88,    /*!< LTDC global Interrupt                                                */
   LTDC_ER_IRQn                = 89,    /*!< LTDC Error global Interrupt                                          */
   ADC2_IRQn                   = 90,    /*!< ADC2 global Interrupts                                               */
   SAI2_IRQn                   = 91,    /*!< SAI2 global Interrupt                                                */
   QUADSPI_IRQn                = 92,    /*!< Quad SPI global interrupt                                            */
   LPTIM1_IRQn                 = 93,    /*!< LP TIM1 interrupt                                                    */
   CEC_IRQn                    = 94,    /*!< HDMI-CEC global Interrupt                                            */
   I2C4_EV_IRQn                = 95,    /*!< I2C4 Event Interrupt                                                 */
   I2C4_ER_IRQn                = 96,    /*!< I2C4 Error Interrupt                                                 */
   SPDIF_RX_IRQn               = 97,    /*!< SPDIF-RX global Interrupt                                            */
   OTG_IRQn                   = 98,    /*!< USB On The Go global interrupt                                       */
   RESERVED_99                 = 99,    /*!< RESERVED interrupt                                                   */
   IPCC_RX0_IRQn               = 100,   /*!< IPCC RX0 Occupied interrupt (interrupt going to AIEC input as well)  */
   IPCC_TX0_IRQn               = 101,   /*!< IPCC TX0 Free interrupt (interrupt going to AIEC input as well)      */
   DMAMUX1_OVR_IRQn            = 102,   /*!< DMAMUX1 Overrun interrupt                                            */
   IPCC_RX1_IRQn               = 103,   /*!< IPCC RX1 Occupied interrupt (interrupt going to AIEC input as well)  */
   IPCC_TX1_IRQn               = 104,   /*!< IPCC TX1 Free interrupt (interrupt going to AIEC input as well)      */
   CRYP2_IRQn                  = 105,   /*!< CRYP2 crypto global interrupt                                        */
   HASH2_IRQn                  = 106,   /*!< Crypto Hash2 interrupt                                               */
   I2C5_EV_IRQn                = 107,   /*!< I2C5 Event Interrupt                                                 */
   I2C5_ER_IRQn                = 108,   /*!< I2C5 Error Interrupt                                                 */
   RESERVED_109                = 109,   /*!< RESERVED interrupt                                                   */
   DFSDM1_FLT0_IRQn            = 110,   /*!< DFSDM Filter1 Interrupt                                              */
   DFSDM1_FLT1_IRQn            = 111,   /*!< DFSDM Filter2 Interrupt                                              */
   DFSDM1_FLT2_IRQn            = 112,   /*!< DFSDM Filter3 Interrupt                                              */
   DFSDM1_FLT3_IRQn            = 113,   /*!< DFSDM Filter4 Interrupt                                              */
   SAI3_IRQn                   = 114,   /*!< SAI3 global Interrupt                                                */
   DFSDM1_FLT4_IRQn            = 115,   /*!< DFSDM Filter5 Interrupt                                              */
   TIM15_IRQn                  = 116,   /*!< TIM15 global Interrupt                                               */
   TIM16_IRQn                  = 117,   /*!< TIM16 global Interrupt                                               */
   TIM17_IRQn                  = 118,   /*!< TIM17 global Interrupt                                               */
   TIM12_IRQn                  = 119,   /*!< TIM12 global Interrupt                                               */
   MDIOS_IRQn                  = 120,   /*!< MDIOS global Interrupt                                               */
   EXTI14_IRQn                 = 121,   /*!< EXTI Line 14 Interrupts                                              */
   MDMA_IRQn                   = 122,   /*!< MDMA global Interrupt                                                */
   RESERVED_123                = 123,   /*!< RESERVED interrupt                                                   */
   SDMMC2_IRQn                 = 124,   /*!< SDMMC2 global Interrupt                                              */
   HSEM_IT2_IRQn               = 125,   /*!< HSEM Semaphore Interrupt 2                                           */
   DFSDM1_FLT5_IRQn            = 126,   /*!< DFSDM Filter6 Interrupt                                              */
   EXTI15_IRQn                 = 127,   /*!< EXTI Line 15 Interrupts                                              */
   nCTIIRQ1_IRQn               = 128,   /*!< Cortex-M4 CTI interrupt 1                                            */
   nCTIIRQ2_IRQn               = 129,   /*!< Cortex-M4 CTI interrupt 2                                            */
   TIM13_IRQn                  = 130,   /*!< TIM13 global interrupt                                               */
   TIM14_IRQn                  = 131,   /*!< TIM14 global interrupt                                               */
   DAC_IRQn                    = 132,   /*!< DAC1 and DAC2 underrun error interrupts                              */
   RNG1_IRQn                   = 133,   /*!< RNG1 interrupt                                                       */
   RNG2_IRQn                   = 134,   /*!< RNG2 interrupt                                                       */
   I2C6_EV_IRQn                = 135,   /*!< I2C6 Event Interrupt                                                 */
   I2C6_ER_IRQn                = 136,   /*!< I2C6 Error Interrupt                                                 */
   SDMMC3_IRQn                 = 137,   /*!< SDMMC3 global Interrupt                                              */
   LPTIM2_IRQn                 = 138,   /*!< LP TIM2 global interrupt                                             */
   LPTIM3_IRQn                 = 139,   /*!< LP TIM3 global interrupt                                             */
   LPTIM4_IRQn                 = 140,   /*!< LP TIM4 global interrupt                                             */
   LPTIM5_IRQn                 = 141,   /*!< LP TIM5 global interrupt                                             */
   ETH1_LPI_IRQn               = 142,   /*!< ETH1_LPI interrupt (LPI: lpi_intr_o)                                 */
   RESERVED_143                = 143,   /*!< RESERVED interrupt                                                   */
   MPU_SEV_IRQn                = 144,   /*!< MPU Send Event  interrupt                                            */
   RCC_WAKEUP_IRQn             = 145,   /*!< RCC Wake up interrupt                                                */
   SAI4_IRQn                   = 146,   /*!< SAI4 global interrupt                                                */
   DTS_IRQn                    = 147,   /*!< Temperature sensor Global Interrupt                                  */
   RESERVED_148                = 148,   /*!< RESERVED interrupt                                                   */
   WAKEUP_PIN_IRQn             = 149,   /*!< Interrupt for all 6 wake-up pins                                     */
   MAX_IRQ_n
 } IRQn_Type;

/** @addtogroup Configuration_section_for_CMSIS
  * @{
  */

#define SDC        /*!< Step Down Converter feature */

/**
  * @brief Configuration of the Cortex-M4/ Cortex-M7 Processor and Core Peripherals
   */
#define __CM4_REV                 0x0001  /*!< Cortex-M4 revision r0p1                       */
#define __MPU_PRESENT             1       /*!< CM4 provides an MPU                           */
#define __NVIC_PRIO_BITS          4       /*!< CM4 uses 4 Bits for the Priority Levels       */
#define __Vendor_SysTickConfig    0       /*!< Set to 1 if different SysTick Config is used  */
#define __FPU_PRESENT             1       /*!< FPU present                                   */

#include "core_cm4.h"                     /*!< Cortex-M4 processor and core peripherals      */
#include "system_stm32mp1xx.h"


#include <stdint.h>

/** @addtogroup Peripheral_registers_structures
  * @{
  */

/**
  * @brief Analog to Digital Converter
  */

typedef struct
{
  __IO uint32_t ISR;              /*!< ADC Interrupt and Status Register,                 Address offset: 0x00 */
  __IO uint32_t IER;              /*!< ADC Interrupt Enable Register,                     Address offset: 0x04 */
  __IO uint32_t CR;               /*!< ADC control register,                              Address offset: 0x08 */
  __IO uint32_t CFGR;             /*!< ADC Configuration register,                        Address offset: 0x0C */
  __IO uint32_t CFGR2;            /*!< ADC Configuration register 2,                      Address offset: 0x10 */
  __IO uint32_t SMPR1;            /*!< ADC sample time register 1,                        Address offset: 0x14 */
  __IO uint32_t SMPR2;            /*!< ADC sample time register 2,                        Address offset: 0x18 */
  __IO uint32_t PCSEL;            /*!< ADC pre-channel selection,                         Address offset: 0x1C */
  __IO uint32_t LTR1;             /*!< ADC watchdog Lower threshold register 1,           Address offset: 0x20 */
  __IO uint32_t HTR1;             /*!< ADC watchdog higher threshold register 1,          Address offset: 0x24 */
  uint32_t      RESERVED1;        /*!< Reserved, 0x028                                                         */
  uint32_t      RESERVED2;        /*!< Reserved, 0x02C                                                         */
  __IO uint32_t SQR1;             /*!< ADC regular sequence register 1,                   Address offset: 0x30 */
  __IO uint32_t SQR2;             /*!< ADC regular sequence register 2,                   Address offset: 0x34 */
  __IO uint32_t SQR3;             /*!< ADC regular sequence register 3,                   Address offset: 0x38 */
  __IO uint32_t SQR4;             /*!< ADC regular sequence register 4,                   Address offset: 0x3C */
  __IO uint32_t DR;               /*!< ADC regular data register,                         Address offset: 0x40 */
  uint32_t      RESERVED3;        /*!< Reserved, 0x044                                                         */
  uint32_t      RESERVED4;        /*!< Reserved, 0x048                                                         */
  __IO uint32_t JSQR;             /*!< ADC injected sequence register,                    Address offset: 0x4C */
  uint32_t      RESERVED5[4];     /*!< Reserved, 0x050 - 0x05C                                                 */
  __IO uint32_t OFR1;             /*!< ADC offset register 1,                             Address offset: 0x60 */
  __IO uint32_t OFR2;             /*!< ADC offset register 2,                             Address offset: 0x64 */
  __IO uint32_t OFR3;             /*!< ADC offset register 3,                             Address offset: 0x68 */
  __IO uint32_t OFR4;             /*!< ADC offset register 4,                             Address offset: 0x6C */
  uint32_t      RESERVED6[4];     /*!< Reserved, 0x070 - 0x07C                                                 */
  __IO uint32_t JDR1;             /*!< ADC injected data register 1,                      Address offset: 0x80 */
  __IO uint32_t JDR2;             /*!< ADC injected data register 2,                      Address offset: 0x84 */
  __IO uint32_t JDR3;             /*!< ADC injected data register 3,                      Address offset: 0x88 */
  __IO uint32_t JDR4;             /*!< ADC injected data register 4,                      Address offset: 0x8C */
  uint32_t      RESERVED7[4];     /*!< Reserved, 0x090 - 0x09C                                                 */
  __IO uint32_t AWD2CR;           /*!< ADC  Analog Watchdog 2 Configuration Register,     Address offset: 0xA0 */
  __IO uint32_t AWD3CR;           /*!< ADC  Analog Watchdog 3 Configuration Register,     Address offset: 0xA4 */
  uint32_t      RESERVED8;        /*!< Reserved, 0x0A8                                                         */
  uint32_t      RESERVED9;        /*!< Reserved, 0x0AC                                                         */
  __IO uint32_t LTR2;             /*!< ADC watchdog Lower threshold register 2,           Address offset: 0xB0 */
  __IO uint32_t HTR2;             /*!< ADC watchdog Higher threshold register 2,          Address offset: 0xB4 */
  __IO uint32_t LTR3;             /*!< ADC watchdog Lower threshold register 3,           Address offset: 0xB8 */
  __IO uint32_t HTR3;             /*!< ADC watchdog Higher threshold register 3,          Address offset: 0xBC */
  __IO uint32_t DIFSEL;           /*!< ADC  Differential Mode Selection Register,         Address offset: 0xC0 */
  __IO uint32_t CALFACT;          /*!< ADC  Calibration Factors,                          Address offset: 0xC4 */
  __IO uint32_t CALFACT2;         /*!< ADC  Linearity Calibration Factors,                Address offset: 0xC8 */
  uint32_t      RESERVED10;       /*!< Reserved,                                                         0x0CC */
  __IO uint32_t OR;               /*!< ADC  Option Register,                             Address offset: 0x0D0 */
  uint32_t  RESERVED11[200];       /*!< Reserved,                                                0x0D4 - 0x3F0 */
  __IO uint32_t VERR;             /*!< ADC version register,                             Address offset: 0x3F4 */
  __IO uint32_t IPIDR;            /*!< ADC ID register,                                  Address offset: 0x3F8 */
  __IO uint32_t SIDR;             /*!< ADC Size ID register,                             Address offset: 0x3FC */
} ADC_TypeDef;


typedef struct
{
  __IO uint32_t CSR; /*!< ADC Common status register, Address offset: ADC1/3 base address + 0x300 */
  uint32_t RESERVED; /*!< Reserved, ADC1/3 base address + 0x304 */
  __IO uint32_t CCR; /*!< ADC common control register, Address offset: ADC1/3 base address + 0x308 */
  __IO uint32_t CDR; /*!< ADC common regular data register for dual Address offset: ADC1/3 base address + 0x30C */
  __IO uint32_t CDR2; /*!< ADC common regular data register for 32-bit dual mode Address offset: ADC1/3 base address + 0x310 */
} ADC_Common_TypeDef;

/**
  * @brief FD Controller Area Network
  */

typedef struct
{
  __IO uint32_t CREL;         /*!< FDCAN Core Release register,                                     Address offset: 0x000 */
  __IO uint32_t ENDN;         /*!< FDCAN Endian register,                                           Address offset: 0x004 */
  __IO uint32_t RESERVED1;    /*!< Reserved,                                                                        0x008 */
  __IO uint32_t DBTP;         /*!< FDCAN Data Bit Timing & Prescaler register,                      Address offset: 0x00C */
  __IO uint32_t TEST;         /*!< FDCAN Test register,                                             Address offset: 0x010 */
  __IO uint32_t RWD;          /*!< FDCAN RAM Watchdog register,                                     Address offset: 0x014 */
  __IO uint32_t CCCR;         /*!< FDCAN CC Control register,                                       Address offset: 0x018 */
  __IO uint32_t NBTP;         /*!< FDCAN Nominal Bit Timing & Prescaler register,                   Address offset: 0x01C */
  __IO uint32_t TSCC;         /*!< FDCAN Timestamp Counter Configuration register,                  Address offset: 0x020 */
  __IO uint32_t TSCV;         /*!< FDCAN Timestamp Counter Value register,                          Address offset: 0x024 */
  __IO uint32_t TOCC;         /*!< FDCAN Timeout Counter Configuration register,                    Address offset: 0x028 */
  __IO uint32_t TOCV;         /*!< FDCAN Timeout Counter Value register,                            Address offset: 0x02C */
  __IO uint32_t RESERVED2[4]; /*!< Reserved,                                                                0x030 - 0x03C */
  __IO uint32_t ECR;          /*!< FDCAN Error Counter register,                                    Address offset: 0x040 */
  __IO uint32_t PSR;          /*!< FDCAN Protocol Status register,                                  Address offset: 0x044 */
  __IO uint32_t TDCR;         /*!< FDCAN Transmitter Delay Compensation register,                   Address offset: 0x048 */
  __IO uint32_t RESERVED3;    /*!< Reserved,                                                                        0x04C */
  __IO uint32_t IR;           /*!< FDCAN Interrupt register,                                        Address offset: 0x050 */
  __IO uint32_t IE;           /*!< FDCAN Interrupt Enable register,                                 Address offset: 0x054 */
  __IO uint32_t ILS;          /*!< FDCAN Interrupt Line Select register,                            Address offset: 0x058 */
  __IO uint32_t ILE;          /*!< FDCAN Interrupt Line Enable register,                            Address offset: 0x05C */
  __IO uint32_t RESERVED4[8]; /*!< Reserved,                                                                0x060 - 0x07C */
  __IO uint32_t GFC;          /*!< FDCAN Global Filter Configuration register,                      Address offset: 0x080 */
  __IO uint32_t SIDFC;        /*!< FDCAN Standard ID Filter Configuration register,                 Address offset: 0x084 */
  __IO uint32_t XIDFC;        /*!< FDCAN Extended ID Filter Configuration register,                 Address offset: 0x088 */
  __IO uint32_t RESERVED5;    /*!< Reserved,                                                                        0x08C */
  __IO uint32_t XIDAM;        /*!< FDCAN Extended ID AND Mask register,                             Address offset: 0x090 */
  __IO uint32_t HPMS;         /*!< FDCAN High Priority Message Status register,                     Address offset: 0x094 */
  __IO uint32_t NDAT1;        /*!< FDCAN New Data 1 register,                                       Address offset: 0x098 */
  __IO uint32_t NDAT2;        /*!< FDCAN New Data 2 register,                                       Address offset: 0x09C */
  __IO uint32_t RXF0C;        /*!< FDCAN Rx FIFO 0 Configuration register,                          Address offset: 0x0A0 */
  __IO uint32_t RXF0S;        /*!< FDCAN Rx FIFO 0 Status register,                                 Address offset: 0x0A4 */
  __IO uint32_t RXF0A;        /*!< FDCAN Rx FIFO 0 Acknowledge register,                            Address offset: 0x0A8 */
  __IO uint32_t RXBC;         /*!< FDCAN Rx Buffer Configuration register,                          Address offset: 0x0AC */
  __IO uint32_t RXF1C;        /*!< FDCAN Rx FIFO 1 Configuration register,                          Address offset: 0x0B0 */
  __IO uint32_t RXF1S;        /*!< FDCAN Rx FIFO 1 Status register,                                 Address offset: 0x0B4 */
  __IO uint32_t RXF1A;        /*!< FDCAN Rx FIFO 1 Acknowledge register,                            Address offset: 0x0B8 */
  __IO uint32_t RXESC;        /*!< FDCAN Rx Buffer/FIFO Element Size Configuration register,        Address offset: 0x0BC */
  __IO uint32_t TXBC;         /*!< FDCAN Tx Buffer Configuration register,                          Address offset: 0x0C0 */
  __IO uint32_t TXFQS;        /*!< FDCAN Tx FIFO/Queue Status register,                             Address offset: 0x0C4 */
  __IO uint32_t TXESC;        /*!< FDCAN Tx Buffer Element Size Configuration register,             Address offset: 0x0C8 */
  __IO uint32_t TXBRP;        /*!< FDCAN Tx Buffer Request Pending register,                        Address offset: 0x0CC */
  __IO uint32_t TXBAR;        /*!< FDCAN Tx Buffer Add Request register,                            Address offset: 0x0D0 */
  __IO uint32_t TXBCR;        /*!< FDCAN Tx Buffer Cancellation Request register,                   Address offset: 0x0D4 */
  __IO uint32_t TXBTO;        /*!< FDCAN Tx Buffer Transmission Occurred register,                  Address offset: 0x0D8 */
  __IO uint32_t TXBCF;        /*!< FDCAN Tx Buffer Cancellation Finished register,                  Address offset: 0x0DC */
  __IO uint32_t TXBTIE;       /*!< FDCAN Tx Buffer Transmission Interrupt Enable register,          Address offset: 0x0E0 */
  __IO uint32_t TXBCIE;       /*!< FDCAN Tx Buffer Cancellation Finished Interrupt Enable register, Address offset: 0x0E4 */
  __IO uint32_t RESERVED6[2]; /*!< Reserved,                                                                0x0E8 - 0x0EC */
  __IO uint32_t TXEFC;        /*!< FDCAN Tx Event FIFO Configuration register,                      Address offset: 0x0F0 */
  __IO uint32_t TXEFS;        /*!< FDCAN Tx Event FIFO Status register,                             Address offset: 0x0F4 */
  __IO uint32_t TXEFA;        /*!< FDCAN Tx Event FIFO Acknowledge register,                        Address offset: 0x0F8 */
  __IO uint32_t RESERVED7;    /*!< Reserved,                                                                        0x0FC */
} FDCAN_GlobalTypeDef;

/**
  * @brief TTFD Controller Area Network
  */

typedef struct
{
  __IO uint32_t TTTMC;          /*!< TT Trigger Memory Configuration register,    Address offset: 0x100 */
  __IO uint32_t TTRMC;          /*!< TT Reference Message Configuration register, Address offset: 0x104 */
  __IO uint32_t TTOCF;          /*!< TT Operation Configuration register,         Address offset: 0x108 */
  __IO uint32_t TTMLM;          /*!< TT Matrix Limits register,                   Address offset: 0x10C */
  __IO uint32_t TURCF;          /*!< TUR Configuration register,                  Address offset: 0x110 */
  __IO uint32_t TTOCN;          /*!< TT Operation Control register,               Address offset: 0x114 */
  __IO uint32_t TTGTP;          /*!< TT Global Time Preset register,              Address offset: 0x118 */
  __IO uint32_t TTTMK;          /*!< TT Time Mark register,                       Address offset: 0x11C */
  __IO uint32_t TTIR;           /*!< TT Interrupt register,                       Address offset: 0x120 */
  __IO uint32_t TTIE;           /*!< TT Interrupt Enable register,                Address offset: 0x124 */
  __IO uint32_t TTILS;          /*!< TT Interrupt Line Select register,           Address offset: 0x128 */
  __IO uint32_t TTOST;          /*!< TT Operation Status register,                Address offset: 0x12C */
  __IO uint32_t TURNA;          /*!< TT TUR Numerator Actual register,            Address offset: 0x130 */
  __IO uint32_t TTLGT;          /*!< TT Local and Global Time register,           Address offset: 0x134 */
  __IO uint32_t TTCTC;          /*!< TT Cycle Time and Count register,            Address offset: 0x138 */
  __IO uint32_t TTCPT;          /*!< TT Capture Time register,                    Address offset: 0x13C */
  __IO uint32_t TTCSM;          /*!< TT Cycle Sync Mark register,                 Address offset: 0x140 */
  __IO uint32_t RESERVED1[111]; /*!< Reserved,                                            0x144 - 0x2FC */
  __IO uint32_t TTTS;           /*!< TT Trigger Select register,                  Address offset: 0x300 */
} TTCAN_TypeDef;

/**
  * @brief FD Controller Area Network
  */

typedef struct
{
  __IO uint32_t CREL;  /*!< Clock Calibration Unit Core Release register, Address offset: 0x00 */
  __IO uint32_t CCFG;  /*!< Calibration Configuration register,           Address offset: 0x04 */
  __IO uint32_t CSTAT; /*!< Calibration Status register,                  Address offset: 0x08 */
  __IO uint32_t CWD;   /*!< Calibration Watchdog register,                Address offset: 0x0C */
  __IO uint32_t IR;    /*!< CCU Interrupt register,                       Address offset: 0x10 */
  __IO uint32_t IE;    /*!< CCU Interrupt Enable register,                Address offset: 0x14 */
} FDCAN_ClockCalibrationUnit_TypeDef;

/**
  * @brief Consumer Electronics Control
  */

typedef struct
{
  __IO uint32_t CR;           /*!< CEC control register,               Address offset: 0x000 */
  __IO uint32_t CFGR;         /*!< CEC configuration register,         Address offset: 0x004 */
  __IO uint32_t TXDR;         /*!< CEC Tx data register ,              Address offset: 0x008 */
  __IO uint32_t RXDR;         /*!< CEC Rx Data Register,               Address offset: 0x00C */
  __IO uint32_t ISR;          /*!< CEC Interrupt and Status Register,  Address offset: 0x010 */
  __IO uint32_t IER;          /*!< CEC interrupt enable register,      Address offset: 0x014 */
  uint32_t  RESERVED3[247];   /*!< Reserved,                                   0x018 - 0x3F0 */
  __IO uint32_t VERR;         /*!< CEC version register,               Address offset: 0x3F4 */
  __IO uint32_t IPIDR;        /*!< CEC ID register,                    Address offset: 0x3F8 */
  __IO uint32_t SIDR;         /*!< CEC Size ID register,               Address offset: 0x3FC */
}CEC_TypeDef;

/**
  * @brief CRC calculation unit
  */

typedef struct
{
  __IO uint32_t DR;          /*!< CRC Data register,                           Address offset: 0x000 */
  __IO uint32_t IDR;         /*!< CRC Independent data register,               Address offset: 0x004 */
  __IO uint32_t CR;          /*!< CRC Control register,                        Address offset: 0x008 */
  uint32_t      RESERVED2;   /*!< Reserved,                                                    0x00C */
  __IO uint32_t INIT;        /*!< Initial CRC value register,                  Address offset: 0x010 */
  __IO uint32_t POL;         /*!< CRC polynomial register,                     Address offset: 0x014 */
  uint32_t      RESERVED3[247];   /*!< Reserved,                                       0x018 - 0x3F0 */
  __IO uint32_t VERR;        /*!< CRC version register,                        Address offset: 0x3F4 */
  __IO uint32_t IPIDR;       /*!< CRC ID register,                             Address offset: 0x3F8 */
  __IO uint32_t SIDR;        /*!< CRC Size ID register,                        Address offset: 0x3FC */
} CRC_TypeDef;


/**
  * @brief Clock Recovery System
  */
typedef struct
{
  __IO uint32_t CR;            /*!< CRS ccontrol register,              Address offset: 0x00 */
  __IO uint32_t CFGR;          /*!< CRS configuration register,         Address offset: 0x04 */
  __IO uint32_t ISR;           /*!< CRS interrupt and status register,  Address offset: 0x08 */
  __IO uint32_t ICR;           /*!< CRS interrupt flag clear register,  Address offset: 0x0C */
} CRS_TypeDef;


/**
  * @brief Digital to Analog Converter
  */

typedef struct
{
  __IO uint32_t CR;       /*!< DAC control register,                                    Address offset: 0x00 */
  __IO uint32_t SWTRIGR;  /*!< DAC software trigger register,                           Address offset: 0x04 */
  __IO uint32_t DHR12R1;  /*!< DAC channel1 12-bit right-aligned data holding register, Address offset: 0x08 */
  __IO uint32_t DHR12L1;  /*!< DAC channel1 12-bit left aligned data holding register,  Address offset: 0x0C */
  __IO uint32_t DHR8R1;   /*!< DAC channel1 8-bit right aligned data holding register,  Address offset: 0x10 */
  __IO uint32_t DHR12R2;  /*!< DAC channel2 12-bit right aligned data holding register, Address offset: 0x14 */
  __IO uint32_t DHR12L2;  /*!< DAC channel2 12-bit left aligned data holding register,  Address offset: 0x18 */
  __IO uint32_t DHR8R2;   /*!< DAC channel2 8-bit right-aligned data holding register,  Address offset: 0x1C */
  __IO uint32_t DHR12RD;  /*!< Dual DAC 12-bit right-aligned data holding register,     Address offset: 0x20 */
  __IO uint32_t DHR12LD;  /*!< DUAL DAC 12-bit left aligned data holding register,      Address offset: 0x24 */
  __IO uint32_t DHR8RD;   /*!< DUAL DAC 8-bit right aligned data holding register,      Address offset: 0x28 */
  __IO uint32_t DOR1;     /*!< DAC channel1 data output register,                       Address offset: 0x2C */
  __IO uint32_t DOR2;     /*!< DAC channel2 data output register,                       Address offset: 0x30 */
  __IO uint32_t SR;       /*!< DAC status register,                                     Address offset: 0x34 */
  __IO uint32_t CCR;      /*!< DAC calibration control register,                        Address offset: 0x38 */
  __IO uint32_t MCR;      /*!< DAC mode control register,                               Address offset: 0x3C */
  __IO uint32_t SHSR1;    /*!< DAC Sample and Hold sample time register 1,              Address offset: 0x40 */
  __IO uint32_t SHSR2;    /*!< DAC Sample and Hold sample time register 2,              Address offset: 0x44 */
  __IO uint32_t SHHR;     /*!< DAC Sample and Hold hold time register,                  Address offset: 0x48 */
  __IO uint32_t SHRR;     /*!< DAC Sample and Hold refresh time register,               Address offset: 0x4C */
  uint32_t    RESERVED0[232];  /*!< Reserved,                                           Address offset: 0x50 - 0x3EC */
  __IO uint32_t HWCFGR0;  /*!< DAC x IP hardware configuration register,                Address offset: 0x3F0 */
  __IO uint32_t VERR;      /*!< DAC version register,                                    Address offset: 0x3F4 */
  __IO uint32_t IPIDR;       /*!< DAC ID register,                                      Address offset: 0x3F8 */
  __IO uint32_t SIDR;        /*!< DAC magic ID register,                                Address offset: 0x3FC */
} DAC_TypeDef;

/*
 * @brief DDRCTRL block description (DDRCTRL)
 */
typedef struct
{
  __IO uint32_t MSTR;            /*!< DDRCTRL master register 0                            Address offset: 0x000 */
  __IO uint32_t STAT;            /*!< DDRCTRL operating mode status register               Address offset: 0x004 */
       uint32_t RESERVED0[2];    /*!< Reserved                                             Address offset: 0x008-0x00C */
  __IO uint32_t MRCTRL0;         /*!< DDRCTRL mode register read/write control register 0  Address offset: 0x010 */
  __IO uint32_t MRCTRL1;         /*!< DDRCTRL mode register read/write control register 1  Address offset: 0x014 */
  __IO uint32_t MRSTAT;          /*!< DDRCTRL mode register read/write status register     Address offset: 0x018 */
       uint32_t RESERVED1;       /*!< Reserved                                             Address offset: 0x01C */
  __IO uint32_t DERATEEN;        /*!< DDRCTRL temperature derate enable register           Address offset: 0x020 */
  __IO uint32_t DERATEINT;       /*!< DDRCTRL temperature derate interval register         Address offset: 0x024 */
       uint32_t RESERVED2[2];    /*!< Reserved                                             Address offset: 0x028-0x02C */
  __IO uint32_t PWRCTL;          /*!< DDRCTRL low power control register                   Address offset: 0x030 */
  __IO uint32_t PWRTMG;          /*!< DDRCTRL low power timing register                    Address offset: 0x034 */
  __IO uint32_t HWLPCTL;         /*!< DDRCTRL hardware low power control register          Address offset: 0x038 */
       uint32_t RESERVED3[5];    /*!< Reserved                                             Address offset: 0x03C-0x04C */
  __IO uint32_t RFSHCTL0;        /*!< DDRCTRL refresh control register 0                   Address offset: 0x050 */
       uint32_t RESERVED4[3];    /*!< Reserved                                             Address offset: 0x054-0x05C */
  __IO uint32_t RFSHCTL3;        /*!< DDRCTRL refresh control register 3                   Address offset: 0x060 */
  __IO uint32_t RFSHTMG;         /*!< DDRCTRL refresh timing register                      Address offset: 0x064 */
       uint32_t RESERVED5[22];   /*!< Reserved                                             Address offset: 0x068-0x0BC */
  __IO uint32_t CRCPARCTL0;      /*!< DDRCTRL CRC parity control register 0                Address offset: 0x0C0 */
       uint32_t RESERVED6[2];    /*!< Reserved                                             Address offset: 0x0C4-0x0C8 */
  __IO uint32_t CRCPARSTAT;      /*!< DDRCTRL CRC parity status register                   Address offset: 0x0CC */
  __IO uint32_t INIT0;           /*!< DDRCTRL SDRAM initialization register 0              Address offset: 0x0D0 */
  __IO uint32_t INIT1;           /*!< DDRCTRL SDRAM initialization register 1              Address offset: 0x0D4 */
  __IO uint32_t INIT2;           /*!< DDRCTRL SDRAM initialization register 2              Address offset: 0x0D8 */
  __IO uint32_t INIT3;           /*!< DDRCTRL SDRAM initialization register 3              Address offset: 0x0DC */
  __IO uint32_t INIT4;           /*!< DDRCTRL SDRAM initialization register 4              Address offset: 0x0E0 */
  __IO uint32_t INIT5;           /*!< DDRCTRL SDRAM initialization register 5              Address offset: 0x0E4 */
       uint32_t RESERVED7[2];    /*!< Reserved                                             Address offset: 0x0E8-0x0EC */
  __IO uint32_t DIMMCTL;         /*!< DDRCTRL DIMM control register                        Address offset: 0x0F0 */
       uint32_t RESERVED8[3];    /*!< Reserved                                             Address offset: 0x0F4-0x0FC */
  __IO uint32_t DRAMTMG0;        /*!< DDRCTRL SDRAM timing register 0                      Address offset: 0x100 */
  __IO uint32_t DRAMTMG1;        /*!< DDRCTRL SDRAM timing register 1                      Address offset: 0x104 */
  __IO uint32_t DRAMTMG2;        /*!< DDRCTRL SDRAM timing register 2                      Address offset: 0x108 */
  __IO uint32_t DRAMTMG3;        /*!< DDRCTRL SDRAM timing register 3                      Address offset: 0x10C */
  __IO uint32_t DRAMTMG4;        /*!< DDRCTRL SDRAM timing register 4                      Address offset: 0x110 */
  __IO uint32_t DRAMTMG5;        /*!< DDRCTRL SDRAM timing register 5                      Address offset: 0x114 */
  __IO uint32_t DRAMTMG6;        /*!< DDRCTRL SDRAM timing register 6                      Address offset: 0x118 */
  __IO uint32_t DRAMTMG7;        /*!< DDRCTRL SDRAM timing register 7                      Address offset: 0x11C */
  __IO uint32_t DRAMTMG8;        /*!< DDRCTRL SDRAM timing register 8                      Address offset: 0x120 */
       uint32_t RESERVED9[5];    /*!< Reserved                                             Address offset: 0x124-0x134 */
  __IO uint32_t DRAMTMG14;       /*!< DDRCTRL SDRAM timing register 14                     Address offset: 0x138 */
  __IO uint32_t DRAMTMG15;       /*!< DDRCTRL SDRAM timing register 15                     Address offset: 0x13C */
       uint32_t RESERVED10[16];  /*!< Reserved                                             Address offset: 0x140-0x17C */
  __IO uint32_t ZQCTL0;          /*!< DDRCTRL ZQ control register 0                        Address offset: 0x180 */
  __IO uint32_t ZQCTL1;          /*!< DDRCTRL ZQ control register 1                        Address offset: 0x184 */
  __IO uint32_t ZQCTL2;          /*!< DDRCTRL ZQ control register 2                        Address offset: 0x188 */
  __IO uint32_t ZQSTAT;          /*!< DDRCTRL ZQ status register                           Address offset: 0x18C */
  __IO uint32_t DFITMG0;         /*!< DDRCTRL DFI timing register 0                        Address offset: 0x190 */
  __IO uint32_t DFITMG1;         /*!< DDRCTRL DFI timing register 1                        Address offset: 0x194 */
  __IO uint32_t DFILPCFG0;       /*!< DDRCTRL low power configuration register 0           Address offset: 0x198 */
       uint32_t RESERVED11;      /*!< Reserved                                             Address offset: 0x19C */
  __IO uint32_t DFIUPD0;         /*!< DDRCTRL DFI update register 0                        Address offset: 0x1A0 */
  __IO uint32_t DFIUPD1;         /*!< DDRCTRL DFI update register 1                        Address offset: 0x1A4 */
  __IO uint32_t DFIUPD2;         /*!< DDRCTRL DFI update register 2                        Address offset: 0x1A8 */
       uint32_t RESERVED12;      /*!< Reserved                                             Address offset: 0x1AC */
  __IO uint32_t DFIMISC;         /*!< DDRCTRL DFI miscellaneous control register           Address offset: 0x1B0 */
       uint32_t RESERVED13[2];   /*!< Reserved                                             Address offset: 0x1B4-0x1B8 */
  __IO uint32_t DFISTAT;         /*!< DDRCTRL DFI status register                          Address offset: 0x1BC */
       uint32_t RESERVED14;      /*!< Reserved                                             Address offset: 0x1C0 */
  __IO uint32_t DFIPHYMSTR;      /*!< DDRCTRL DFI PHY master register                      Address offset: 0x1C4 */
       uint32_t RESERVED15[15];  /*!< Reserved                                             Address offset: 0x1C8-0x200 */
  __IO uint32_t ADDRMAP1;        /*!< DDRCTRL address map register 1                       Address offset: 0x204 */
  __IO uint32_t ADDRMAP2;        /*!< DDRCTRL address map register 2                       Address offset: 0x208 */
  __IO uint32_t ADDRMAP3;        /*!< DDRCTRL address map register 3                       Address offset: 0x20C */
  __IO uint32_t ADDRMAP4;        /*!< DDRCTRL address map register 4                       Address offset: 0x210 */
  __IO uint32_t ADDRMAP5;        /*!< DDRCTRL address map register 5                       Address offset: 0x214 */
  __IO uint32_t ADDRMAP6;        /*!< DDRCTRL address register 6                           Address offset: 0x218 */
       uint32_t RESERVED16[2];   /*!< Reserved                                             Address offset: 0x21C-0x220 */
  __IO uint32_t ADDRMAP9;        /*!< DDRCTRL address map register 9                       Address offset: 0x224 */
  __IO uint32_t ADDRMAP10;       /*!< DDRCTRL address map register 10                      Address offset: 0x228 */
  __IO uint32_t ADDRMAP11;       /*!< DDRCTRL address map register 11                      Address offset: 0x22C */
       uint32_t RESERVED17[4];   /*!< Reserved                                             Address offset: 0x230-0x23C */
  __IO uint32_t ODTCFG;          /*!< DDRCTRL ODT configuration register                   Address offset: 0x240 */
  __IO uint32_t ODTMAP;          /*!< DDRCTRL ODT/Rank map register                        Address offset: 0x244 */
       uint32_t RESERVED18[2];   /*!< Reserved                                             Address offset: 0x248-0x24C */
  __IO uint32_t SCHED;           /*!< DDRCTRL scheduler control register                   Address offset: 0x250 */
  __IO uint32_t SCHED1;          /*!< DDRCTRL scheduler control register 1                 Address offset: 0x254 */
       uint32_t RESERVED19;      /*!< Reserved                                             Address offset: 0x258 */
  __IO uint32_t PERFHPR1;        /*!< DDRCTRL high priority read CAM register 1            Address offset: 0x25C */
       uint32_t RESERVED20;      /*!< Reserved                                             Address offset: 0x260 */
  __IO uint32_t PERFLPR1;        /*!< DDRCTRL low priority read CAM register 1             Address offset: 0x264 */
       uint32_t RESERVED21;      /*!< Reserved                                             Address offset: 0x268 */
  __IO uint32_t PERFWR1;         /*!< DDRCTRL write CAM register 1                         Address offset: 0x26C */
       uint32_t RESERVED22[36];  /*!< Reserved                                             Address offset: 0x270-0x2FC */
  __IO uint32_t DBG0;            /*!< DDRCTRL debug register 0                             Address offset: 0x300 */
  __IO uint32_t DBG1;            /*!< DDRCTRL debug register 1                             Address offset: 0x304 */
  __IO uint32_t DBGCAM;          /*!< DDRCTRL CAM debug register                           Address offset: 0x308 */
  __IO uint32_t DBGCMD;          /*!< DDRCTRL command debug register                       Address offset: 0x30C */
  __IO uint32_t DBGSTAT;         /*!< DDRCTRL status debug register                        Address offset: 0x310 */
       uint32_t RESERVED23[3];   /*!< Reserved                                             Address offset: 0x314-0x31C */
  __IO uint32_t SWCTL;           /*!< DDRCTRL software register programming control enable Address offset: 0x320 */
  __IO uint32_t SWSTAT;          /*!< DDRCTRL software register programming control status Address offset: 0x324 */
       uint32_t RESERVED24[17];  /*!< Reserved                                             Address offset: 0x328-0x368 */
  __IO uint32_t POISONCFG;       /*!< DDRCTRL AXI Poison configuration register            Address offset: 0x36C */
  __IO uint32_t POISONSTAT;      /*!< DDRCTRL AXI Poison status register                   Address offset: 0x370 */
       uint32_t RESERVED25[34];  /*!< Reserved                                             Address offset: 0x374-0x3F8 */
  __IO uint32_t PSTAT;           /*!< DDRCTRL port status register                         Address offset: 0x3FC */
  __IO uint32_t PCCFG;           /*!< DDRCTRL port common configuration register           Address offset: 0x400 */
  __IO uint32_t PCFGR_0;         /*!< DDRCTRL port 0 configuration read register           Address offset: 0x404 */
  __IO uint32_t PCFGW_0;         /*!< DDRCTRL port 0 configuration write register          Address offset: 0x408 */
       uint32_t RESERVED26[33];  /*!< Reserved                                             Address offset: 0x40C-0x48C */
  __IO uint32_t PCTRL_0;         /*!< DDRCTRL port 0 control register                      Address offset: 0x490 */
  __IO uint32_t PCFGQOS0_0;      /*!< DDRCTRL port 0 read Q0S configuration register 0     Address offset: 0x494 */
  __IO uint32_t PCFGQOS1_0;      /*!< DDRCTRL port 0 read Q0S configuration register 1     Address offset: 0x498 */
  __IO uint32_t PCFGWQOS0_0;     /*!< DDRCTRL port 0 write Q0S configuration register 0    Address offset: 0x49C */
  __IO uint32_t PCFGWQOS1_0;     /*!< DDRCTRL port 0 write Q0S configuration register 1    Address offset: 0x4A0 */
       uint32_t RESERVED27[4];   /*!< Reserved                                             Address offset: 0x4A4-0x4B0 */
  __IO uint32_t PCFGR_1;         /*!< DDRCTRL port 1 configuration read register           Address offset: 0x4B4 */
  __IO uint32_t PCFGW_1;         /*!< DDRCTRL port 1 configuration write register          Address offset: 0x4B8 */
       uint32_t RESERVED28[33];  /*!< Reserved                                             Address offset: 0x4BC-0x53C */
  __IO uint32_t PCTRL_1;         /*!< DDRCTRL port 1 control register                      Address offset: 0x540 */
  __IO uint32_t PCFGQOS0_1;      /*!< DDRCTRL port 1 read Q0S configuration register 0     Address offset: 0x544 */
  __IO uint32_t PCFGQOS1_1;      /*!< DDRCTRL port 1 read Q0S configuration register 1     Address offset: 0x548 */
  __IO uint32_t PCFGWQOS0_1;     /*!< DDRCTRL port 1 write Q0S configuration register 0    Address offset: 0x54C */
  __IO uint32_t PCFGWQOS1_1;     /*!< DDRCTRL port 1 write Q0S configuration register 1    Address offset: 0x550 */
} DDRCTRL_TypeDef;

/*
 * @brief DDRPERFM block description (DDRPERFM)
 */
typedef struct
{
  __IO uint32_t CTL;             /*!< DDRPERFM control register                Address offset: 0x000 */
  __IO uint32_t CFG;             /*!< DDRPERFM configurationl register         Address offset: 0x004 */
  __IO uint32_t STATUS;          /*!< DDRPERFM status register                 Address offset: 0x008 */
  __IO uint32_t CCR;             /*!< DDRPERFM counter clear register          Address offset: 0x00C */
  __IO uint32_t IER;             /*!< DDRPERFM interrupt enable register       Address offset: 0x010 */
  __IO uint32_t ISR;             /*!< DDRPERFM interrupt status register       Address offset: 0x014 */
  __IO uint32_t ICR;             /*!< DDRPERFM interrupt clear register        Address offset: 0x018 */
       uint32_t RESERVED0;       /*!< Reserved                                 Address offset: 0x01C */
  __IO uint32_t TCNT;            /*!< DDRPERFM time counter register           Address offset: 0x020 */
       uint32_t RESERVED1[3];    /*!< Reserved                                 Address offset: 0x024-0x02C */
  __IO uint32_t CNT0;            /*!< DDRPERFM event counter 0 register        Address offset: 0x030 */
       uint32_t RESERVED2;       /*!< Reserved                                 Address offset: 0x034 */
  __IO uint32_t CNT1;            /*!< DDRPERFM event counter 1 register        Address offset: 0x038 */
       uint32_t RESERVED3;       /*!< Reserved                                 Address offset: 0x03C */
  __IO uint32_t CNT2;            /*!< DDRPERFM event counter 2 register        Address offset: 0x040 */
       uint32_t RESERVED4;       /*!< Reserved                                 Address offset: 0x044 */
  __IO uint32_t CNT3;            /*!< DDRPERFM event counter 3 register        Address offset: 0x048 */
       uint32_t RESERVED5[233];  /*!< Reserved                                 Address offset: 0x04C-0x3EC */
  __IO uint32_t HWCFG;           /*!< DDRPERFM hardware configuration register Address offset: 0x3F0 */
  __IO uint32_t VER;             /*!< DDRPERFM version register                Address offset: 0x3F4 */
  __IO uint32_t ID;              /*!< DDRPERFM ID register                     Address offset: 0x3F8 */
  __IO uint32_t SID;             /*!< DDRPERFM magic ID register               Address offset: 0x3FC */
} DDRPERFM_TypeDef;

/*
 * @brief DDRPHYC block description (DDRPHYC)
 */
typedef struct
{
  __IO uint32_t RIDR;           /*!< DDRPHYC revision ID register         Address offset: 0x000 */
  __IO uint32_t PIR;            /*!< DDRPHYC PHY initialization register  Address offset: 0x004 */
  __IO uint32_t PGCR;           /*!< DDRPHYC PHY global control register  Address offset: 0x008 */
  __IO uint32_t PGSR;           /*!< DDRPHYC PHY global status register   Address offset: 0x00C */
  __IO uint32_t DLLGCR;         /*!< DDRPHYC DDR global control register  Address offset: 0x010 */
  __IO uint32_t ACDLLCR;        /*!< DDRPHYC AC DLL control register      Address offset: 0x014 */
  __IO uint32_t PTR0;           /*!< DDRPHYC PT register 0                Address offset: 0x018 */
  __IO uint32_t PTR1;           /*!< DDRPHYC PT register 1                Address offset: 0x01C */
  __IO uint32_t PTR2;           /*!< DDRPHYC PT register 2                Address offset: 0x020 */
  __IO uint32_t ACIOCR;         /*!< DDRPHYC ACIOC register               Address offset: 0x024 */
  __IO uint32_t DXCCR;          /*!< DDRPHYC DXCC register                Address offset: 0x028 */
  __IO uint32_t DSGCR;          /*!< DDRPHYC DSGC register                Address offset: 0x02C */
  __IO uint32_t DCR;            /*!< DDRPHYC DC register                  Address offset: 0x030 */
  __IO uint32_t DTPR0;          /*!< DDRPHYC DTP register 0               Address offset: 0x034 */
  __IO uint32_t DTPR1;          /*!< DDRPHYC DTP register 1               Address offset: 0x038 */
  __IO uint32_t DTPR2;          /*!< DDRPHYC DTP register 2               Address offset: 0x03C */
  __IO uint32_t DDR3_MR0;       /*!< DDRPHYC MR0 register for DDR3        Address offset: 0x040 */
  __IO uint32_t DDR3_MR1;       /*!< DDRPHYC MR1 register for DDR3        Address offset: 0x044 */
  __IO uint32_t DDR3_MR2;       /*!< DDRPHYC MR2 register for DDR3        Address offset: 0x048 */
  __IO uint32_t DDR3_MR3;       /*!< DDRPHYC MR3 register for DDR3        Address offset: 0x04C */
  __IO uint32_t ODTCR;          /*!< DDRPHYC ODTC register                Address offset: 0x050 */
  __IO uint32_t DTAR;           /*!< DDRPHYC DTA register                 Address offset: 0x054 */
  __IO uint32_t DTDR0;          /*!< DDRPHYC DTD register 0               Address offset: 0x058 */
  __IO uint32_t DTDR1;          /*!< DDRPHYC DTD register 1               Address offset: 0x05C */
       uint32_t RESERVED0[70];  /*!< Reserved                             Address offset: 0x060-0x174 */
  __IO uint32_t GPR0;           /*!< DDRPHYC general purpose register 0   Address offset: 0x178 */
  __IO uint32_t GPR1;           /*!< DDRPHYC general purpose register 1   Address offset: 0x17C */
  __IO uint32_t ZQ0CR0;         /*!< DDRPHYC ZQ0C register 0              Address offset: 0x180 */
  __IO uint32_t ZQ0CR1;         /*!< DDRPHYC ZQ0CR1 register              Address offset: 0x184 */
  __IO uint32_t ZQ0SR0;         /*!< DDRPHYC ZQ0S register 0              Address offset: 0x188 */
  __IO uint32_t ZQ0SR1;         /*!< DDRPHYC ZQ0S register 1              Address offset: 0x18C */
       uint32_t RESERVED1[12];  /*!< Reserved                             Address offset: 0x190-0x1BC */
  __IO uint32_t DX0GCR;         /*!< DDRPHYC byte lane 0 GC register      Address offset: 0x1C0 */
  __IO uint32_t DX0GSR0;        /*!< DDRPHYC byte lane 0 GS register 0    Address offset: 0x1C4 */
  __IO uint32_t DX0GSR1;        /*!< DDRPHYC byte lane 0 GS register 1    Address offset: 0x1C8 */
  __IO uint32_t DX0DLLCR;       /*!< DDRPHYC byte lane 0 DLLC register    Address offset: 0x1CC */
  __IO uint32_t DX0DQTR;        /*!< DDRPHYC byte lane 0 DQT register     Address offset: 0x1D0 */
  __IO uint32_t DX0DQSTR;       /*!< DDRPHYC byte lane 0 DQST register    Address offset: 0x1D4 */
       uint32_t RESERVED2[10];  /*!< Reserved                             Address offset: 0x1D8-0x1FC */
  __IO uint32_t DX1GCR;         /*!< DDRPHYC byte lane 1 GC register      Address offset: 0x200 */
  __IO uint32_t DX1GSR0;        /*!< DDRPHYC byte lane 1 GS register 0    Address offset: 0x204 */
  __IO uint32_t DX1GSR1;        /*!< DDRPHYC byte lane 1 GS register 1    Address offset: 0x208 */
  __IO uint32_t DX1DLLCR;       /*!< DDRPHYC byte lane 1 DLLC register    Address offset: 0x20C */
  __IO uint32_t DX1DQTR;        /*!< DDRPHYC byte lane 1 DQT register     Address offset: 0x210 */
  __IO uint32_t DX1DQSTR;       /*!< DDRPHYC byte lane 1 DQST register    Address offset: 0x214 */
       uint32_t RESERVED3[10];  /*!< Reserved                             Address offset: 0x218-0x23C */
  __IO uint32_t DX2GCR;         /*!< DDRPHYC byte lane 2 GC register      Address offset: 0x240 */
  __IO uint32_t DX2GSR0;        /*!< DDRPHYC byte lane 2 GS register 0    Address offset: 0x244 */
  __IO uint32_t DX2GSR1;        /*!< DDRPHYC byte lane 2 GS register 1    Address offset: 0x248 */
  __IO uint32_t DX2DLLCR;       /*!< DDRPHYC byte lane 2 DLLC register    Address offset: 0x24C */
  __IO uint32_t DX2DQTR;        /*!< DDRPHYC byte lane 2 DQT register     Address offset: 0x250 */
  __IO uint32_t DX2DQSTR;       /*!< DDRPHYC byte lane 2 DQST register    Address offset: 0x254 */
       uint32_t RESERVED4[10];  /*!< Reserved                             Address offset: 0x258-0x27C */
  __IO uint32_t DX3GCR;         /*!< DDRPHYC byte lane 3 GC register      Address offset: 0x280 */
  __IO uint32_t DX3GSR0;        /*!< DDRPHYC byte lane 3 GS register 0    Address offset: 0x284 */
  __IO uint32_t DX3GSR1;        /*!< DDRPHYC byte lane 3 GS register 1    Address offset: 0x288 */
  __IO uint32_t DX3DLLCR;       /*!< DDRPHYC byte lane 3 DLLC register    Address offset: 0x28C */
  __IO uint32_t DX3DQTR;        /*!< DDRPHYC byte lane 3 DQT register     Address offset: 0x290 */
  __IO uint32_t DX3DQSTR;       /*!< DDRPHYC byte lane 3 DQST register    Address offset: 0x294 */
} DDRPHYC_TypeDef;

/**
  * @brief DFSDM module registers
  */
typedef struct
{
  __IO uint32_t FLTCR1;      /*!< DFSDM control register1,                          Address offset: 0x100 */
  __IO uint32_t FLTCR2;      /*!< DFSDM control register2,                          Address offset: 0x104 */
  __IO uint32_t FLTISR;      /*!< DFSDM interrupt and status register,              Address offset: 0x108 */
  __IO uint32_t FLTICR;      /*!< DFSDM interrupt flag clear register,              Address offset: 0x10C */
  __IO uint32_t FLTJCHGR;    /*!< DFSDM injected channel group selection register,  Address offset: 0x110 */
  __IO uint32_t FLTFCR;      /*!< DFSDM filter control register,                    Address offset: 0x114 */
  __IO uint32_t FLTJDATAR;   /*!< DFSDM data register for injected group,           Address offset: 0x118 */
  __IO uint32_t FLTRDATAR;   /*!< DFSDM data register for regular group,            Address offset: 0x11C */
  __IO uint32_t FLTAWHTR;    /*!< DFSDM analog watchdog high threshold register,    Address offset: 0x120 */
  __IO uint32_t FLTAWLTR;    /*!< DFSDM analog watchdog low threshold register,     Address offset: 0x124 */
  __IO uint32_t FLTAWSR;     /*!< DFSDM analog watchdog status register             Address offset: 0x128 */
  __IO uint32_t FLTAWCFR;    /*!< DFSDM analog watchdog clear flag register         Address offset: 0x12C */
  __IO uint32_t FLTEXMAX;    /*!< DFSDM extreme detector maximum register,          Address offset: 0x130 */
  __IO uint32_t FLTEXMIN;    /*!< DFSDM extreme detector minimum register           Address offset: 0x134 */
  __IO uint32_t FLTCNVTIMR;  /*!< DFSDM conversion timer,                           Address offset: 0x138 */
} DFSDM_Filter_TypeDef;

/**
  * @brief DFSDM channel configuration registers
  */
typedef struct
{
  __IO uint32_t CHCFGR1;     /*!< DFSDM channel configuration register1,            Address offset: 0x00 */
  __IO uint32_t CHCFGR2;     /*!< DFSDM channel configuration register2,            Address offset: 0x04 */
  __IO uint32_t CHAWSCDR;    /*!< DFSDM channel analog watchdog and
                                  short circuit detector register,                  Address offset: 0x08 */
  __IO uint32_t CHWDATAR;    /*!< DFSDM channel watchdog filter data register,      Address offset: 0x0C */
  __IO uint32_t CHDATINR;    /*!< DFSDM channel data input register,                Address offset: 0x10 */
  __IO uint32_t CHDLYR;      /*!< DFSDM channel delay register,                     Address offset: 0x14 */
} DFSDM_Channel_TypeDef;


/**
  * @brief DFSDM registers
  */
typedef struct
{
  uint32_t RESERVED[508];/*!< Reserved,                                       0x000 - 0x7F0 */
  __IO uint32_t HWCFGR;  /*!< DFSDM HW Configuration register ,       Address offset: 0x7F0 */
  __IO uint32_t VERR;    /*!< DFSDM Version register,                 Address offset: 0x7F4 */
  __IO uint32_t IPDR;    /*!< DFSDM Identification register,          Address offset: 0x7F8 */
  __IO uint32_t SIDR;    /*!< DFSDM Size Identification register,     Address offset: 0x7FC */
} DFSDM_TypeDef;


/**
  * @brief Debug MCU
  */

typedef struct
{
  __IO uint32_t IDCODE;        /*!< MCU device ID code,                         Address offset: 0x00 */
  __IO uint32_t CR;            /*!< Debug MCU configuration register,           Address offset: 0x04 */
  __IO uint32_t RESERVED4[9];  /*!< Reserved,                                   Address offset: 0x08 */
  __IO uint32_t APB4FZ1;       /*!< Debug MCU APB4FZ1 freeze register CPU1,     Address offset: 0x2C */
  __IO uint32_t APB4FZ2;       /*!< Debug MCU APB4FZ2 freeze register CPU2,     Address offset: 0x30 */
  __IO uint32_t APB1FZ1;       /*!< Debug MCU APB1FZ1 freeze register CPU1,     Address offset: 0x34 */
  __IO uint32_t APB1FZ2;       /*!< Debug MCU APB1FZ2 freeze register CPU2,     Address offset: 0x38 */
  __IO uint32_t APB2FZ1;       /*!< Debug MCU APB2FZ1 freeze register CPU1,     Address offset: 0x3C */
  __IO uint32_t APB2FZ2;       /*!< Debug MCU APB2FZ2 freeze register CPU2,     Address offset: 0x40 */
  __IO uint32_t APB3FZ1;       /*!< Debug MCU APB3FZ1 freeze register CPU1,     Address offset: 0x44 */
  __IO uint32_t APB3FZ2;       /*!< Debug MCU APB3FZ2 freeze register CPU2,     Address offset: 0x48 */
  __IO uint32_t APB5FZ1;       /*!< Debug MCU APB5FZ1 freeze register CPU1,     Address offset: 0x4C */
  __IO uint32_t APB5FZ2;       /*!< Debug MCU APB5FZ2 freeze register CPU2,     Address offset: 0x50 */
}DBGMCU_TypeDef;

/**
  * @brief DCMI
  */

typedef struct
{
  __IO uint32_t CR;       /*!< DCMI control register 1,                       Address offset: 0x000 */
  __IO uint32_t SR;       /*!< DCMI status register,                          Address offset: 0x004 */
  __IO uint32_t RISR;     /*!< DCMI raw interrupt status register,            Address offset: 0x008 */
  __IO uint32_t IER;      /*!< DCMI interrupt enable register,                Address offset: 0x00C */
  __IO uint32_t MISR;     /*!< DCMI masked interrupt status register,         Address offset: 0x010 */
  __IO uint32_t ICR;      /*!< DCMI interrupt clear register,                 Address offset: 0x014 */
  __IO uint32_t ESCR;     /*!< DCMI embedded synchronization code register,   Address offset: 0x018 */
  __IO uint32_t ESUR;     /*!< DCMI embedded synchronization unmask register, Address offset: 0x01C */
  __IO uint32_t CWSTRTR;  /*!< DCMI crop window start,                        Address offset: 0x020 */
  __IO uint32_t CWSIZER;  /*!< DCMI crop window size,                         Address offset: 0x024 */
  __IO uint32_t DR;       /*!< DCMI data register,                            Address offset: 0x028 */
  uint32_t RESERVED[242]; /*!< Reserved,                                              0x02C - 0x3F0 */
  __IO uint32_t VERR;     /*!< DCMI Version register,                         Address offset: 0x3F4 */
  __IO uint32_t IPDR;     /*!< DCMI Identification register,                  Address offset: 0x3F8 */
  __IO uint32_t SIDR;     /*!< DCMI Size Identification register,             Address offset: 0x3FC */
} DCMI_TypeDef;

/**
  * @brief DMA Controller
  */

typedef struct
{
  __IO uint32_t CR;     /*!< DMA stream x configuration register      */
  __IO uint32_t NDTR;   /*!< DMA stream x number of data register     */
  __IO uint32_t PAR;    /*!< DMA stream x peripheral address register */
  __IO uint32_t M0AR;   /*!< DMA stream x memory 0 address register   */
  __IO uint32_t M1AR;   /*!< DMA stream x memory 1 address register   */
  __IO uint32_t FCR;    /*!< DMA stream x FIFO control register       */
} DMA_Stream_TypeDef;

typedef struct
{
  __IO uint32_t LISR;   /*!< DMA low interrupt status register,      Address offset: 0x00 */
  __IO uint32_t HISR;   /*!< DMA high interrupt status register,     Address offset: 0x04 */
  __IO uint32_t LIFCR;  /*!< DMA low interrupt flag clear register,  Address offset: 0x08 */
  __IO uint32_t HIFCR;  /*!< DMA high interrupt flag clear register, Address offset: 0x0C */
  __IO uint32_t RESERVED[247];  /*!< Reserved,               Address offset: 0x10 - 0x3E8 */
  __IO uint32_t HWCFGR2; /*!< DMA HW Configuration register 2,      Address offset: 0x3EC */
  __IO uint32_t HWCFGR1; /*!< DMA HW Configuration register 1,      Address offset: 0x3F0 */
  __IO uint32_t VERR;    /*!< DMA Version register,                 Address offset: 0x3F4 */
  __IO uint32_t IPDR;    /*!< DMA Identification register,          Address offset: 0x3F8 */
  __IO uint32_t SIDR;    /*!< DMA Size Identification register,     Address offset: 0x3FC */
} DMA_TypeDef;

typedef struct
{
  __IO uint32_t  CCR;        /*!< DMA Multiplexer Channel x Control Register   */
}DMAMUX_Channel_TypeDef;

typedef struct
{
  __IO uint32_t  CSR;      /*!< DMA Channel Status Register     */
  __IO uint32_t  CFR;      /*!< DMA Channel Clear Flag Register */
}DMAMUX_ChannelStatus_TypeDef;

typedef struct
{
  __IO uint32_t  RGCR;        /*!< DMA Request Generator x Control Register   */
}DMAMUX_RequestGen_TypeDef;

typedef struct
{
  __IO uint32_t  RGSR;            /*!< DMAMUX Request Generator Status Register,           Address offset: 0x140 */
  __IO uint32_t  RGCFR;           /*!< DMAMUX Request Generator Clear Flag Register,       Address offset: 0x144 */
  uint32_t       RESERVED0[169];  /*!< Reserved, 0x144 -> 0x144                                                  */
  __IO uint32_t  HWCFGR2;         /*!< DMAMUX Configuration register 2,                    Address offset: 0x3EC */
  __IO uint32_t  HWCFGR1;         /*!< DMAMUX Configuration register 1,                    Address offset: 0x3F0 */
  __IO uint32_t  VERR;            /*!< DMAMUX Verion Register,                             Address offset: 0x3F4 */
  __IO uint32_t  IPDR;            /*!< DMAMUX Identification register,                     Address offset: 0x3F8 */
  __IO uint32_t  SIDR;            /*!< DMAMUX Size Identification register,                Address offset: 0x3FC */

}DMAMUX_RequestGenStatus_TypeDef;

/**
  * @brief MDMA Controller
  */
typedef struct
{
  __IO uint32_t  GISR0;   /*!< MDMA Global Interrupt/Status Register 0,          Address offset: 0x000 */
  uint32_t RESERVED1;      /*!< Reserved,                                                         0x004 */
//  __IO uint32_t  GISR1;   /*!< MDMA Global Interrupt/Status Register 1,          Address offset: 0x004 */
  __IO uint32_t  SGISR0;  /*!< MDMA Secure Global Interrupt/Status Register 0,   Address offset: 0x008 */
//  __IO uint32_t  SGISR1;  /*!< MDMA Secure Global Interrupt/Status Register 1,   Address offset: 0x00C */
  uint32_t RESERVED2[250]; /*!< Reserved,                                                  0x10 - 0x3F0 */
  __IO uint32_t  VERR;    /*!< MDMA Verion Register,                             Address offset: 0x3F4 */
  __IO uint32_t  IPDR;    /*!< MDMA Identification register,                     Address offset: 0x3F8 */
  __IO uint32_t  SIDR;    /*!< MDMA Size Identification register,                Address offset: 0x3FC */
}MDMA_TypeDef;

typedef struct
{
  __IO uint32_t  CISR;      /*!< MDMA channel x interrupt/status register,             Address offset: 0x40 */
  __IO uint32_t  CIFCR;     /*!< MDMA channel x interrupt flag clear register,         Address offset: 0x44 */
  __IO uint32_t  CESR;      /*!< MDMA Channel x error status register,                 Address offset: 0x48 */
  __IO uint32_t  CCR;       /*!< MDMA channel x control register,                      Address offset: 0x4C */
  __IO uint32_t  CTCR;      /*!< MDMA channel x Transfer Configuration register,       Address offset: 0x50 */
  __IO uint32_t  CBNDTR;    /*!< MDMA Channel x block number of data register,         Address offset: 0x54 */
  __IO uint32_t  CSAR;      /*!< MDMA channel x source address register,               Address offset: 0x58 */
  __IO uint32_t  CDAR;      /*!< MDMA channel x destination address register,          Address offset: 0x5C */
  __IO uint32_t  CBRUR;     /*!< MDMA channel x Block Repeat address Update register,  Address offset: 0x60 */
  __IO uint32_t  CLAR;      /*!< MDMA channel x Link Address register,                 Address offset: 0x64 */
  __IO uint32_t  CTBR;      /*!< MDMA channel x Trigger and Bus selection Register,    Address offset: 0x68 */
  uint32_t       RESERVED0; /*!< Reserved, 0x68                                                             */
 __IO uint32_t    CMAR;      /*!< MDMA channel x Mask address register,                Address offset: 0x70 */
 __IO uint32_t   CMDR;       /*!< MDMA channel x Mask Data register,                   Address offset: 0x74 */
}MDMA_Channel_TypeDef;


/**
  * @brief Ethernet MAC
  */
typedef struct
{
  __IO uint32_t MACCR;            /*!< Operating mode configuration register                      Address offset: 0x0000 */
  __IO uint32_t MACECR;           /*!< Extended operating mode configuration register             Address offset: 0x0004 */
  __IO uint32_t MACPFR;           /*!< Packet filtering control register                          Address offset: 0x0008 */
  __IO uint32_t MACWTR;           /*!< Watchdog timeout register                                  Address offset: 0x000C */
  __IO uint32_t MACHT0R;          /*!< Hash Table 0 register                                      Address offset: 0x0010 */
  __IO uint32_t MACHT1R;          /*!< Hash Table 1 register                                      Address offset: 0x0014 */
       uint32_t RESERVED0[14];    /*!< Reserved                                                   Address offset: 0x0018-0x004C */
  __IO uint32_t MACVTR;           /*!< VLAN tag register                                          Address offset: 0x0050 */
       uint32_t RESERVED1;        /*!< Reserved                                                   Address offset: 0x0054 */
  __IO uint32_t MACVHTR;          /*!< VLAN Hash table register                                   Address offset: 0x0058 */
       uint32_t RESERVED2;        /*!< Reserved                                                   Address offset: 0x005C */
  __IO uint32_t MACVIR;           /*!< VLAN inclusion register                                    Address offset: 0x0060 */
  __IO uint32_t MACIVIR;          /*!< Inner VLAN inclusion register                              Address offset: 0x0064 */
       uint32_t RESERVED3[2];     /*!< Reserved                                                   Address offset: 0x0068-0x006C */
  __IO uint32_t MACQ0TXFCR;       /*!< Tx Queue 0 flow control register                           Address offset: 0x0070 */
       uint32_t RESERVED4[7];     /*!< Reserved                                                   Address offset: 0x0074-0x008C */
  __IO uint32_t MACRXFCR;         /*!< Rx flow control register                                   Address offset: 0x0090 */
       uint32_t RESERVED5;        /*!< Reserved                                                   Address offset: 0x0094 */
  __IO uint32_t MACTXQPMR;        /*!< Tx queue priority mapping 0 register                       Address offset: 0x0098 */
       uint32_t RESERVED6;        /*!< Reserved                                                   Address offset: 0x009C */
  __IO uint32_t MACRXQC0R;        /*!< Rx queue control 0 register                                Address offset: 0x00A0 */
  __IO uint32_t MACRXQC1R;        /*!< Rx queue control 1 register                                Address offset: 0x00A4 */
  __IO uint32_t MACRXQC2R;        /*!< Rx queue control 2 register                                Address offset: 0x00A8 */
       uint32_t RESERVED7;        /*!< Reserved                                                   Address offset: 0x00AC */
  __IO uint32_t MACISR;           /*!< Interrupt status register                                  Address offset: 0x00B0 */
  __IO uint32_t MACIER;           /*!< Interrupt enable register                                  Address offset: 0x00B4 */
  __IO uint32_t MACRXTXSR;        /*!< Rx Tx status register                                      Address offset: 0x00B8 */
       uint32_t RESERVED8;        /*!< Reserved                                                   Address offset: 0x00BC */
  __IO uint32_t MACPCSR;          /*!< PMT control status register                                Address offset: 0x00C0 */
  __IO uint32_t MACRWKPFR;        /*!< Remote wakeup packet filter register                       Address offset: 0x00C4 */
       uint32_t RESERVED9[2];     /*!< Reserved                                                   Address offset: 0x00C8-0x00CC */
  __IO uint32_t MACLCSR;          /*!< LPI control status register                                Address offset: 0x00D0 */
  __IO uint32_t MACLTCR;          /*!< LPI timers control register                                Address offset: 0x00D4 */
  __IO uint32_t MACLETR;          /*!< LPI entry timer register                                   Address offset: 0x00D8 */
  __IO uint32_t MAC1USTCR;        /*!< microsecond-tick counter register                          Address offset: 0x00DC */
       uint32_t RESERVED10[6];    /*!< Reserved                                                   Address offset: 0x00E0-0x00F4 */
  __IO uint32_t MACPHYCSR;        /*!< PHYIF control status register                              Address offset: 0x00F8 */
       uint32_t RESERVED11[5];    /*!< Reserved                                                   Address offset: 0x00FC-0x010C */
  __IO uint32_t MACVR;            /*!< Version register                                           Address offset: 0x0110 */
  __IO uint32_t MACDR;            /*!< Debug register                                             Address offset: 0x0114 */
       uint32_t RESERVED12[2];    /*!< Reserved                                                   Address offset: 0x0118-0x011C */
  __IO uint32_t MACHWF1R;         /*!< HW feature 1 register                                      Address offset: 0x0120 */
  __IO uint32_t MACHWF2R;         /*!< HW feature 2 register                                      Address offset: 0x0124 */
       uint32_t RESERVED13[54];   /*!< Reserved                                                   Address offset: 0x0128-0x01FC */
  __IO uint32_t MACMDIOAR;        /*!< MDIO address register                                      Address offset: 0x0200 */
  __IO uint32_t MACMDIODR;        /*!< MDIO data register                                         Address offset: 0x0204 */
       uint32_t RESERVED14[62];   /*!< Reserved                                                   Address offset: 0x0208-0x02FC */
  __IO uint32_t MACA0HR;          /*!< Address 0 high register                                    Address offset: 0x0300 */
  __IO uint32_t MACA0LR;          /*!< Address 0 low register                                     Address offset: 0x0304 */
  __IO uint32_t MACA1HR;          /*!< Address 1 high register                                    Address offset: 0x0308 */
  __IO uint32_t MACA1LR;          /*!< Address 1 low register                                     Address offset: 0x030C */
  __IO uint32_t MACA2HR;          /*!< Address 2 high register                                    Address offset: 0x0310 */
  __IO uint32_t MACA2LR;          /*!< Address 2 low register                                     Address offset: 0x0314 */
  __IO uint32_t MACA3HR;          /*!< Address 3 high register                                    Address offset: 0x0318 */
  __IO uint32_t MACA3LR;          /*!< Address 3 low register                                     Address offset: 0x031C */
       uint32_t RESERVED15[248];  /*!< Reserved                                                   Address offset: 0x0320-0x06FC */
  __IO uint32_t MMCCR;            /*!< MMC control register                                       Address offset: 0x0700 */
  __IO uint32_t MMCRXIR;          /*!< MMC Rx interrupt register                                  Address offset: 0x704 */
  __IO uint32_t MMCTXIR;          /*!< MMC Tx interrupt register                                  Address offset: 0x708 */
  __IO uint32_t MMCRXIMR;         /*!< MMC Rx interrupt mask register                             Address offset: 0x70C */
  __IO uint32_t MMCTXIMR;         /*!< MMC Tx interrupt mask register                      Address offset: 0x710 */
       uint32_t RESERVED16[14];   /*!< Reserved                                                    Address offset: 0x0714-0x0748 */
  __IO uint32_t MMCTXSCGPR;       /*!< Tx single collision good packets register      Address offset: 0x74C */
  __IO uint32_t MMCTXMCGPR;       /*!< Tx multiple collision good packets register  Address offset: 0x750 */
       uint32_t RESERVED16_1[5];  /*!< Reserved                                                   Address offset: 0x0754-0x0764 */
  __IO uint32_t MMCTXPCGR;        /*!< Tx packet count good register                     Address offset: 0x768 */
       uint32_t RESERVED16_2[10]; /*!< Reserved                                                  Address offset: 0x076C-0x0790 */
  __IO uint32_t MMCRXCRCEPR;      /*!< Rx CRC error packets register                   Address offset: 0x794 */
  __IO uint32_t MMCRXAEPR;        /*!< Rx alignment error packets register         Address offset: 0x798 */
       uint32_t RESERVED16_3[10]; /*!< Reserved                                                  Address offset: 0x079C-0x07C0 */
  __IO uint32_t MMCRXUPGR;        /*!< Rx unicast packets good register               Address offset: 0x7C4 */
       uint32_t RESERVED16_4[9];  /*!< Reserved                                                   Address offset: 0x07C8-0x07E8 */
  __IO uint32_t MMCTXLPIMSTR;     /*!< Tx LPI microsecond timer register                     Address offset: 0x7EC */
  __IO uint32_t MMCTXLPITCR;      /*!< Tx LPI transition counter register                    Address offset: 0x7F0 */
  __IO uint32_t MMCRXLPIMSTR;     /*!< Rx LPI microsecond counter register                   Address offset: 0x7F4 */
  __IO uint32_t MMCRXLPITCR;  /*!< Rx LPI transition counter register                    Address offset: 0x7F8 */
       uint32_t RESERVED16_5[65];  /*!< Reserved                                                  Address offset: 0x07FC-0x08FC */
  __IO uint32_t MACL3L4C0R;       /*!< L3 and L4 control 0 register                               Address offset: 0x0900 */
  __IO uint32_t MACL4A0R;         /*!< Layer4 address filter 0 register                           Address offset: 0x0904 */
       uint32_t RESERVED17[2];    /*!< Reserved                                                   Address offset: 0x0908-0x090C */
  __IO uint32_t MACL3A00R;        /*!< Layer 3 Address 0 filter 0 register                        Address offset: 0x0910 */
  __IO uint32_t MACL3A10R;        /*!< Layer3 address 1 filter 0 register                         Address offset: 0x0914 */
  __IO uint32_t MACL3A20;         /*!< Layer3 Address 2 filter 0 register                         Address offset: 0x0918 */
  __IO uint32_t MACL3A30;         /*!< Layer3 Address 3 filter 0 register                         Address offset: 0x091C */
       uint32_t RESERVED18[4];    /*!< Reserved                                                   Address offset: 0x0920-0x092C */
  __IO uint32_t MACL3L4C1R;       /*!< L3 and L4 control 1 register                               Address offset: 0x0930 */
  __IO uint32_t MACL4A1R;         /*!< Layer 4 address filter 1 register                          Address offset: 0x0934 */
       uint32_t RESERVED19[2];    /*!< Reserved                                                   Address offset: 0x0938-0x093C */
  __IO uint32_t MACL3A01R;        /*!< Layer3 address 0 filter 1 Register                         Address offset: 0x0940 */
  __IO uint32_t MACL3A11R;        /*!< Layer3 address 1 filter 1 register                         Address offset: 0x0944 */
  __IO uint32_t MACL3A21R;        /*!< Layer3 address 2 filter 1 Register                         Address offset: 0x0948 */
  __IO uint32_t MACL3A31R;        /*!< Layer3 address 3 filter 1 register                         Address offset: 0x094C */
       uint32_t RESERVED20[100];  /*!< Reserved                                                   Address offset: 0x0950-0x0ADC */
  __IO uint32_t MACARPAR;         /*!< ARP address register                                       Address offset: 0x0AE0 */
       uint32_t RESERVED21[7];    /*!< Reserved                                                   Address offset: 0x0AE4-0x0AFC */
  __IO uint32_t MACTSCR;          /*!< Timestamp control Register                                 Address offset: 0x0B00 */
  __IO uint32_t MACSSIR;          /*!< Sub-second increment register                              Address offset: 0x0B04 */
  __IO uint32_t MACSTSR;          /*!< System time seconds register                               Address offset: 0x0B08 */
  __IO uint32_t MACSTNR;          /*!< System time nanoseconds register                           Address offset: 0x0B0C */
  __IO uint32_t MACSTSUR;         /*!< System time seconds update register                        Address offset: 0x0B10 */
  __IO uint32_t MACSTNUR;         /*!< System time nanoseconds update register                    Address offset: 0x0B14 */
  __IO uint32_t MACTSAR;          /*!< Timestamp addend register                                  Address offset: 0x0B18 */
       uint32_t RESERVED22;       /*!< Reserved                                                   Address offset: 0x0B1C */
  __IO uint32_t MACTSSR;          /*!< Timestamp status register                                  Address offset: 0x0B20 */
       uint32_t RESERVED23[3];    /*!< Reserved                                                   Address offset: 0x0B24-0x0B2C */
  __IO uint32_t MACTXTSSNR;       /*!< Tx timestamp status nanoseconds register                   Address offset: 0x0B30 */
  __IO uint32_t MACTXTSSSR;       /*!< Tx timestamp status seconds register                       Address offset: 0x0B34 */
       uint32_t RESERVED24[2];    /*!< Reserved                                                   Address offset: 0x0B38-0x0B3C */
  __IO uint32_t MACACR;           /*!< Auxiliary control register                                 Address offset: 0x0B40 */
       uint32_t RESERVED25;       /*!< Reserved                                                   Address offset: 0x0B44 */
  __IO uint32_t MACATSNR;         /*!< Auxiliary timestamp nanoseconds register                   Address offset: 0x0B48 */
  __IO uint32_t MACATSSR;         /*!< Auxiliary timestamp seconds register                       Address offset: 0x0B4C */
  __IO uint32_t MACTSIACR;        /*!< Timestamp Ingress asymmetric correction register           Address offset: 0x0B50 */
  __IO uint32_t MACTSEACR;        /*!< Timestamp Egress asymmetric correction register            Address offset: 0x0B54 */
  __IO uint32_t MACTSICNR;        /*!< Timestamp Ingress correction nanosecond register           Address offset: 0x0B58 */
  __IO uint32_t MACTSECNR;        /*!< Timestamp Egress correction nanosecond register            Address offset: 0x0B5C */
       uint32_t RESERVED26[4];    /*!< Reserved                                                   Address offset: 0x0B60-0x0B6C */
  __IO uint32_t MACPPSCR;         /*!< PPS control register [alternate]                           Address offset: 0x0B70 */
       uint32_t RESERVED27[3];    /*!< Reserved                                                   Address offset: 0x0B74-0x0B7C */
  __IO uint32_t MACPPSTTSR;       /*!< PPS target time seconds register                           Address offset: 0x0B80 */
  __IO uint32_t MACPPSTTNR;       /*!< PPS target time nanoseconds register                       Address offset: 0x0B84 */
  __IO uint32_t MACPPSIR;         /*!< PPS interval register                                      Address offset: 0x0B88 */
  __IO uint32_t MACPPSWR;         /*!< PPS width register                                         Address offset: 0x0B8C */
       uint32_t RESERVED28[12];   /*!< Reserved                                                   Address offset: 0x0B90-0x0BBC */
  __IO uint32_t MACPOCR;          /*!< PTP Offload control register                               Address offset: 0x0BC0 */
  __IO uint32_t MACSPI0R;         /*!< PTP Source Port Identity 0 Register                        Address offset: 0x0BC4 */
  __IO uint32_t MACSPI1R;         /*!< PTP Source port identity 1 register                        Address offset: 0x0BC8 */
  __IO uint32_t MACSPI2R;         /*!< PTP Source port identity 2 register                        Address offset: 0x0BCC */
  __IO uint32_t MACLMIR;          /*!< Log message interval register                              Address offset: 0x0BD0 */
       uint32_t RESERVED29[11];   /*!< Reserved                                                   Address offset: 0x0BD4-0x0BFC */
  __IO uint32_t MTLOMR;           /*!< Operating mode Register                                    Address offset: 0x0C00 */
       uint32_t RESERVED30[7];    /*!< Reserved                                                   Address offset: 0x0C04-0x0C1C */
  __IO uint32_t MTLISR;           /*!< Interrupt status Register                                  Address offset: 0x0C20 */
       uint32_t RESERVED31[55];   /*!< Reserved                                                   Address offset: 0x0C24-0x0CFC */
  __IO uint32_t MTLTXQ0OMR;       /*!< Tx queue 0 operating mode Register                         Address offset: 0x0D00 */
  __IO uint32_t MTLTXQ0UR;        /*!< Tx queue 0 underflow register                              Address offset: 0x0D04 */
  __IO uint32_t MTLTXQ0DR;        /*!< Tx queue 0 debug Register                                  Address offset: 0x0D08 */
       uint32_t RESERVED32[2];    /*!< Reserved                                                   Address offset: 0x0D0C-0x0D10 */
  __IO uint32_t MTLTXQ0ESR;       /*!< Tx queue x ETS status Register                             Address offset: 0x0D14 */
       uint32_t RESERVED33[5];    /*!< Reserved                                                   Address offset: 0x0D18-0x0D28 */
  __IO uint32_t MTLQ0ICSR;        /*!< Queue 0 interrupt control status Register                  Address offset: 0x0D2C */
  __IO uint32_t MTLRXQ0OMR;       /*!< Rx queue 0 operating mode register                         Address offset: 0x0D30 */
  __IO uint32_t MTLRXQ0MPOCR;     /*!< Rx queue 0 missed packet and overflow counter register     Address offset: 0x0D34 */
  __IO uint32_t MTLRXQ0DR;        /*!< Rx queue 0 debug register                                  Address offset: 0x0D38 */
  __IO uint32_t MTLRXQ0CR;        /*!< Rx queue 0 control register                                Address offset: 0x0D3C */
  __IO uint32_t MTLTXQ1OMR;       /*!< Tx queue 1 operating mode Register                         Address offset: 0x0D40 */
  __IO uint32_t MTLTXQ1UR;        /*!< Tx queue 1 underflow register                              Address offset: 0x0D44 */
  __IO uint32_t MTLTXQ1DR;        /*!< Tx queue 1 debug Register                                  Address offset: 0x0D48 */
       uint32_t RESERVED34;       /*!< Reserved                                                   Address offset: 0x0D4C */
  __IO uint32_t MTLTXQ1ECR;       /*!< Tx queue 1 ETS control Register                            Address offset: 0x0D50 */
  __IO uint32_t MTLTXQ1ESR;       /*!< Tx queue x ETS status Register                             Address offset: 0x0D54 */
  __IO uint32_t MTLTXQ1QWR;       /*!< Tx queue 1 quantum weight register                         Address offset: 0x0D58 */
  __IO uint32_t MTLTXQ1SSCR;      /*!< Tx queue 1 send slope credit Register                      Address offset: 0x0D5C */
  __IO uint32_t MTLTXQ1HCR;       /*!< Tx Queue 1 hiCredit register                               Address offset: 0x0D60 */
  __IO uint32_t MTLTXQ1LCR;       /*!< Tx queue 1 loCredit register                               Address offset: 0x0D64 */
       uint32_t RESERVED35;       /*!< Reserved                                                   Address offset: 0x0D68 */
  __IO uint32_t MTLQ1ICSR;        /*!< Queue 1 interrupt control status Register                  Address offset: 0x0D6C */
  __IO uint32_t MTLRXQ1OMR;       /*!< Rx queue 1 operating mode register                         Address offset: 0x0D70 */
  __IO uint32_t MTLRXQ1MPOCR;     /*!< Rx queue 1 missed packet and overflow counter register     Address offset: 0x0D74 */
  __IO uint32_t MTLRXQ1DR;        /*!< Rx queue 1 debug register                                  Address offset: 0x0D78 */
  __IO uint32_t MTLRXQ1CR;        /*!< Rx queue 1 control register                                Address offset: 0x0D7C */
       uint32_t RESERVED36[160];  /*!< Reserved                                                   Address offset: 0x0D80-0x0FFC */
  __IO uint32_t DMAMR;            /*!< DMA mode register                                          Address offset: 0x1000 */
  __IO uint32_t DMASBMR;          /*!< System bus mode register                                   Address offset: 0x1004 */
  __IO uint32_t DMAISR;           /*!< Interrupt status register                                  Address offset: 0x1008 */
  __IO uint32_t DMADSR;           /*!< Debug status register                                      Address offset: 0x100C */
       uint32_t RESERVED37[4];    /*!< Reserved                                                   Address offset: 0x1010-0x101C */
  __IO uint32_t DMAA4TXACR;       /*!< AXI4 transmit channel ACE control register                 Address offset: 0x1020 */
  __IO uint32_t DMAA4RXACR;       /*!< AXI4 receive channel ACE control register                  Address offset: 0x1024 */
  __IO uint32_t DMAA4DACR;        /*!< AXI4 descriptor ACE control register                       Address offset: 0x1028 */
       uint32_t RESERVED38[53];   /*!< Reserved                                                   Address offset: 0x102C-0x10FC */
  __IO uint32_t DMAC0CR;          /*!< Channel 0 control register                                 Address offset: 0x1100 */
  __IO uint32_t DMAC0TXCR;        /*!< Channel 0 transmit control register                        Address offset: 0x1104 */
  __IO uint32_t DMAC0RXCR;        /*!< Channel 0 receive control register                         Address offset: 0x1108 */
       uint32_t RESERVED39[2];    /*!< Reserved                                                   Address offset: 0x110C-0x1110 */
  __IO uint32_t DMAC0TXDLAR;      /*!< Channel 0 Tx descriptor list address register              Address offset: 0x1114 */
       uint32_t RESERVED40;       /*!< Reserved                                                   Address offset: 0x1118 */
  __IO uint32_t DMAC0RXDLAR;      /*!< Channel 0 Rx descriptor list address register              Address offset: 0x111C */
  __IO uint32_t DMAC0TXDTPR;      /*!< Channel 0 Tx descriptor tail pointer register              Address offset: 0x1120 */
       uint32_t RESERVED41;       /*!< Reserved                                                   Address offset: 0x1124 */
  __IO uint32_t DMAC0RXDTPR;      /*!< Channel 0 Rx descriptor tail pointer register              Address offset: 0x1128 */
  __IO uint32_t DMAC0TXRLR;       /*!< Channel 0 Tx descriptor ring length register               Address offset: 0x112C */
  __IO uint32_t DMAC0RXRLR;       /*!< Channel 0 Rx descriptor ring length register               Address offset: 0x1130 */
  __IO uint32_t DMAC0IER;         /*!< Channel 0 interrupt enable register                        Address offset: 0x1134 */
  __IO uint32_t DMAC0RXIWTR;      /*!< Channel 0 Rx interrupt watchdog timer register             Address offset: 0x1138 */
  __IO uint32_t DMAC0SFCSR;       /*!< Channel 0 slot function control status register            Address offset: 0x113C */
       uint32_t RESERVED42;       /*!< Reserved                                                   Address offset: 0x1140 */
  __IO uint32_t DMAC0CATXDR;      /*!< Channel 0 current application transmit descriptor register Address offset: 0x1144 */
       uint32_t RESERVED43;       /*!< Reserved                                                   Address offset: 0x1148 */
  __IO uint32_t DMAC0CARXDR;      /*!< Channel 0 current application receive descriptor register  Address offset: 0x114C */
       uint32_t RESERVED44;       /*!< Reserved                                                   Address offset: 0x1150 */
  __IO uint32_t DMAC0CATXBR;      /*!< Channel 0 current application transmit buffer register     Address offset: 0x1154 */
       uint32_t RESERVED45;       /*!< Reserved                                                   Address offset: 0x1158 */
  __IO uint32_t DMAC0CARXBR;      /*!< Channel 0 current application receive buffer register      Address offset: 0x115C */
  __IO uint32_t DMAC0SR;          /*!< Channel 0 status register                                  Address offset: 0x1160 */
       uint32_t RESERVED46[2];    /*!< Reserved                                                   Address offset: 0x1164-0x1168 */
  __IO uint32_t DMAC0MFCR;        /*!< Channel 0 missed frame count register                      Address offset: 0x116C */
       uint32_t RESERVED47[4];    /*!< Reserved                                                   Address offset: 0x1170-0x117C */
  __IO uint32_t DMAC1CR;          /*!< Channel 1 control register                                 Address offset: 0x1180 */
  __IO uint32_t DMAC1TXCR;        /*!< Channel 1 transmit control register                        Address offset: 0x1184 */
       uint32_t RESERVED48[3];    /*!< Reserved                                                   Address offset: 0x1188-0x1190 */
  __IO uint32_t DMAC1TXDLAR;      /*!< Channel 1 Tx descriptor list address register              Address offset: 0x1194 */
       uint32_t RESERVED49[2];    /*!< Reserved                                                   Address offset: 0x1198-0x119C */
  __IO uint32_t DMAC1TXDTPR;      /*!< Channel 1 Tx descriptor tail pointer register              Address offset: 0x11A0 */
       uint32_t RESERVED50[2];    /*!< Reserved                                                   Address offset: 0x11A4-0x11A8 */
  __IO uint32_t DMAC1TXRLR;       /*!< Channel 1 Tx descriptor ring length register               Address offset: 0x11AC */
       uint32_t RESERVED51;       /*!< Reserved                                                   Address offset: 0x11B0 */
  __IO uint32_t DMAC1IER;         /*!< Channel 1 interrupt enable register                        Address offset: 0x11B4 */
       uint32_t RESERVED52;       /*!< Reserved                                                   Address offset: 0x11B8 */
  __IO uint32_t DMAC1SFCSR;       /*!< Channel 1 slot function control status register            Address offset: 0x11BC */
       uint32_t RESERVED53;       /*!< Reserved                                                   Address offset: 0x11C0 */
  __IO uint32_t DMAC1CATXDR;      /*!< Channel 1 current application transmit descriptor register Address offset: 0x11C4 */
       uint32_t RESERVED54[3];    /*!< Reserved                                                   Address offset: 0x11C8-0x11D0 */
  __IO uint32_t DMAC1CATXBR;      /*!< Channel 1 current application transmit buffer register     Address offset: 0x11D4 */
       uint32_t RESERVED55[2];    /*!< Reserved                                                   Address offset: 0x11D8-0x11DC */
  __IO uint32_t DMAC1SR;          /*!< Channel 1 status register                                  Address offset: 0x11E0 */
       uint32_t RESERVED56[2];    /*!< Reserved                                                   Address offset: 0x11E4-0x11E8 */
  __IO uint32_t DMAC1MFCR;        /*!< Channel 1 missed frame count register                      Address offset: 0x11EC */
} ETH_TypeDef;

/**
  * @brief External Interrupt/Event Controller
  */

typedef struct
{
  __IO uint32_t RTSR1;               /*!< EXTI Rising trigger selection register,                   Address offset: 0x00 */
  __IO uint32_t FTSR1;               /*!< EXTI Falling trigger selection register,                  Address offset: 0x04 */
  __IO uint32_t SWIER1;              /*!< EXTI Software interrupt event register,                   Address offset: 0x08 */
  __IO uint32_t RPR1;                /*!< EXTI Rising Edge Pending mask register,                   Address offset: 0x0C */
  __IO uint32_t FPR1;                /*!< EXTI Falling Edge Pending mask register,                  Address offset: 0x10 */
  __IO uint32_t TZENR1;              /*!< EXTI Trust Zone enable register,                          Address offset: 0x14 */
  uint32_t      RESERVED1[2];        /*!< Reserved, offset 0x18 -> 0x20                                                  */
  __IO uint32_t RTSR2;               /*!< EXTI Rising trigger selection register,                   Address offset: 0x20 */
  __IO uint32_t FTSR2;               /*!< EXTI Falling trigger selection register,                  Address offset: 0x24 */
  __IO uint32_t SWIER2;              /*!< EXTI Software interrupt event register,                   Address offset: 0x28 */
  __IO uint32_t RPR2;                /*!< EXTI Rising Edge Pending mask register,                   Address offset: 0x2C */
  __IO uint32_t FPR2;                /*!< EXTI Falling Edge Pending mask register,                  Address offset: 0x30 */
  __IO uint32_t TZENR2;              /*!< EXTI Trust Zone enable register,                          Address offset: 0x34 */
  uint32_t      RESERVED2[2];        /*!< Reserved, offset 0x38 -> 0x40                                                  */
  __IO uint32_t RTSR3;               /*!< EXTI Rising trigger selection register,                   Address offset: 0x40 */
  __IO uint32_t FTSR3;               /*!< EXTI Falling trigger selection register,                  Address offset: 0x44 */
  __IO uint32_t SWIER3;              /*!< EXTI Software interrupt event register,                   Address offset: 0x48 */
  __IO uint32_t RPR3;                /*!< EXTI Rising Edge Pending mask register,                   Address offset: 0x4C */
  __IO uint32_t FPR3;                /*!< EXTI Falling Edge Pending mask register,                  Address offset: 0x50 */
  __IO uint32_t TZENR3;              /*!< EXTI Trust Zone enable register,                          Address offset: 0x54 */
  uint32_t      RESERVED3[2];        /*!< Reserved, offset 0x58 -> 0x5C                                                  */
  __IO uint32_t EXTICR[4];           /*!< EXTI Configuration Register mask register,                Address offset: 0x60 */
  uint32_t      RESERVED4[4];        /*!< Reserved, offset 0x70 -> 0x7C                                                  */
  __IO uint32_t C1IMR1;              /*!< EXTI wakeup with interrupt mask register for cpu1 [31:0], Address offset: 0x80 */
  __IO uint32_t RESERVED5[3];        /*!< Reserved,                                                 Address offset: 0x84 - 0x8C */
  __IO uint32_t C1IMR2;              /*!< EXTI wakeup with interrupt mask register for cpu1 [31:0], Address offset: 0x90 */
  __IO uint32_t RESERVED6[3];        /*!< Reserved,                                                 Address offset: 0x94 - 0x9C */
  __IO uint32_t C1IMR3;              /*!< EXTI wakeup with interrupt mask register for cpu1 [31:0], Address offset: 0xA0 */
  __IO uint32_t RESERVED7[7];        /*!< Reserved,                                                 Address offset: 0xA4 - 0xBC */
  __IO uint32_t C2IMR1;              /*!< EXTI wakeup with interrupt mask register for cpu2 [31:0], Address offset: 0xC0 */
  __IO uint32_t C2EMR1;              /*!< EXTI wakeup with event mask register for cpu2 [31:0],     Address offset: 0xC4 */
  __IO uint32_t RESERVED8[2];        /*!< Reserved,                                                 Address offset: 0xC8 - 0xCC */
  __IO uint32_t C2IMR2;              /*!< EXTI wakeup with interrupt mask register for cpu2 [31:0], Address offset: 0xD0 */
  __IO uint32_t C2EMR2;              /*!< EXTI wakeup with event mask register for cpu2 [31:0],     Address offset: 0xD4 */
  __IO uint32_t RESERVED9[2];        /*!< Reserved,                                                 Address offset: 0xD8 - 0xDC */
  __IO uint32_t C2IMR3;              /*!< EXTI wakeup with interrupt mask register for cpu2 [31:0], Address offset: 0xE0 */
  __IO uint32_t C2EMR3;              /*!< EXTI wakeup with event mask register for cpu2 [31:0],     Address offset: 0xE4 */
  uint32_t      RESERVED10[182];     /*!< Reserved, offset 0xE8 -> 0x3BC                                                 */
  __IO uint32_t HWCFGR13;            /*!< EXTI HW Configuration Register 13,                        Address offset: 0x3C0 */
  __IO uint32_t HWCFGR12;            /*!< EXTI HW Configuration Register 12,                        Address offset: 0x3C4 */
  __IO uint32_t HWCFGR11;            /*!< EXTI HW Configuration Register 11,                        Address offset: 0x3C8 */
  __IO uint32_t HWCFGR10;            /*!< EXTI HW Configuration Register 10,                        Address offset: 0x3CC */
  __IO uint32_t HWCFGR9;             /*!< EXTI HW Configuration Register 9,                         Address offset: 0x3D0 */
  __IO uint32_t HWCFGR8;             /*!< EXTI HW Configuration Register 8,                         Address offset: 0x3D4 */
  __IO uint32_t HWCFGR7;             /*!< EXTI HW Configuration Register 7,                         Address offset: 0x3D8 */
  __IO uint32_t HWCFGR6;             /*!< EXTI HW Configuration Register 6,                         Address offset: 0x3DC */
  __IO uint32_t HWCFGR5;             /*!< EXTI HW Configuration Register 5,                         Address offset: 0x3E0 */
  __IO uint32_t HWCFGR4;             /*!< EXTI HW Configuration Register 4,                         Address offset: 0x3E4 */
  __IO uint32_t HWCFGR3;             /*!< EXTI HW Configuration Register 3,                         Address offset: 0x3E8 */
  __IO uint32_t HWCFGR2;             /*!< EXTI HW Configuration Register 2,                         Address offset: 0x3EC */
  __IO uint32_t HWCFGR1;             /*!< EXTI HW Configuration Register 1,                         Address offset: 0x3F0 */
  __IO uint32_t VERR;                /*!< EXTI Version Register ,                                   Address offset: 0x3F4 */
  __IO uint32_t IPIDR;               /*!< EXTI Identification Register ,                            Address offset: 0x3F8 */
  __IO uint32_t SIDR;                /*!< EXTI Size ID Register ,                                   Address offset: 0x3FC */

}EXTI_TypeDef;

typedef struct
{
  __IO uint32_t IMR1;                /*!< EXTI Interrupt mask register,                Address offset: 0x00 */
  __IO uint32_t EMR1;                /*!< EXTI Event mask register,                    Address offset: 0x04 */
  uint32_t      RESERVED1[2];        /*!< Reserved, offset 0x08 -> 0x10                                     */
  __IO uint32_t IMR2;                /*!< EXTI Interrupt mask register,                Address offset: 0x10 */
  __IO uint32_t EMR2;                /*!< EXTI Event mask register,                    Address offset: 0x14 */
  uint32_t      RESERVED2[2];        /*!< Reserved, offset 0x18 -> 0x20                                     */
  __IO uint32_t IMR3;                /*!< EXTI Interrupt mask register,                Address offset: 0x20 */
  __IO uint32_t EMR3;                /*!< EXTI Event mask register,                    Address offset: 0x24 */
  uint32_t      RESERVED3[6];        /*!< Reserved, offset 0x28 -> 0x40                                     */
}EXTI_Core_TypeDef;


/**
  * @brief Flexible Memory Controller
  */

typedef struct
{
  __IO uint32_t BTCR[8];    /*!< NOR/PSRAM chip-select control register(BCR) and chip-select timing register(BTR), Address offset: 0x00-1C */
  __IO uint32_t PCSCNTR;    /*!< PSRAM chip-select counter register(PCSCNTR),                                      Address offset: 0x20 */
} FMC_Bank1_TypeDef;

/**
  * @brief Flexible Memory Controller Bank1E
  */

typedef struct
{
  __IO uint32_t BWTR[7];    /*!< NOR/PSRAM write timing registers, Address offset: 0x104-0x11C */
} FMC_Bank1E_TypeDef;

/**
  * @brief Flexible Memory Controller Bank3
  */

typedef struct
{
  __IO uint32_t PCR;         /*!< NAND Flash control register 3,                       Address offset: 0x80 */
  __IO uint32_t SR;          /*!< NAND Flash FIFO status and interrupt register 3,     Address offset: 0x84 */
  __IO uint32_t PMEM;        /*!< NAND Flash Common memory space timing register 3,    Address offset: 0x88 */
  __IO uint32_t PATT;        /*!< NAND Flash Attribute memory space timing register 3, Address offset: 0x8C */
  __IO uint32_t HPR;         /*!< NAND Flash Hamming Parity result registers 3,        Address offset: 0x90 */
  __IO uint32_t HECCR;       /*!< NAND Flash Hamming ECC result registers 3,           Address offset: 0x94 */
  uint32_t RESERVED[110];    /*!< Reserved, 0x94->0x250 */
  __IO uint32_t BCHIER;      /*!< BCH Interrupt Enable Register,                       Address offset: 0x250 */
  __IO uint32_t BCHISR;      /*!< BCH Interrupt Status Register,                       Address offset: 0x254 */
  __IO uint32_t BCHICR;      /*!< BCH Interrupt Clear Register,                        Address offset: 0x258 */
  uint32_t RESERVED1;        /*!< Reserved, 0x25C */
  __IO uint32_t BCHPBR1;     /*!< BCH Parity Bits Register 1,                          Address offset: 0x260 */
  __IO uint32_t BCHPBR2;     /*!< BCH Parity Bits Register 2,                          Address offset: 0x264 */
  __IO uint32_t BCHPBR3;     /*!< BCH Parity Bits Register 3,                          Address offset: 0x268 */
  __IO uint32_t BCHPBR4;     /*!< BCH Parity Bits Register 4,                          Address offset: 0x26C */
  uint32_t RESERVED2[3];        /*!< Reserved, 0x25C */
  __IO uint32_t BCHDSR0;     /*!< BCH Decoder Status Register 0,                       Address offset: 0x27C */
  __IO uint32_t BCHDSR1;     /*!< BCH Decoder Status Register 1,                       Address offset: 0x280 */
  __IO uint32_t BCHDSR2;     /*!< BCH Decoder Status Register 2,                       Address offset: 0x284 */
  __IO uint32_t BCHDSR3;     /*!< BCH Decoder Status Register 3,                       Address offset: 0x288 */
  __IO uint32_t BCHDSR4;     /*!< BCH Decoder Status Register 4,                       Address offset: 0x28C */
  uint32_t RESERVED3[87];    /*!< Reserved, 0x28C->0x3EC */
  __IO uint32_t HWCFGR2;     /*!< FMC HW Configuration register 2,                     Address offset: 0x3EC */
  __IO uint32_t HWCFGR1;     /*!< FMC HW Configuration register 1,                     Address offset: 0x3F0 */
  __IO uint32_t VERR;        /*!< FMC Version register ,                               Address offset: 0x3F4 */
  __IO uint32_t IDR;         /*!< FMC Identification register ,                        Address offset: 0x3F8 */
  __IO uint32_t SIDR;        /*!< FMC Size ID register ,                               Address offset: 0x3FC */
} FMC_Bank3_TypeDef;


/**
  * @brief General Purpose I/O
  */

typedef struct
{
  __IO uint32_t MODER;           /*!< GPIO port mode register,                      Address offset: 0x000 */
  __IO uint32_t OTYPER;          /*!< GPIO port output type register,               Address offset: 0x004 */
  __IO uint32_t OSPEEDR;         /*!< GPIO port output speed register,              Address offset: 0x008 */
  __IO uint32_t PUPDR;           /*!< GPIO port pull-up/pull-down register,         Address offset: 0x00C */
  __IO uint32_t IDR;             /*!< GPIO port input data register,                Address offset: 0x010 */
  __IO uint32_t ODR;             /*!< GPIO port output data register,               Address offset: 0x014 */
  __IO uint32_t BSRR;            /*!< GPIO port bit set/reset register,             Address offset: 0x018 */
  __IO uint32_t LCKR;            /*!< GPIO port configuration lock register,        Address offset: 0x01C */
  __IO uint32_t AFR[2];          /*!< GPIO alternate function registers,            Address offset: 0x020-0x024 */
  __IO uint32_t BRR;             /*!< GPIO port bit reset register,                 Address offset: 0x028 */
       uint32_t RESERVED0;       /*!< Reserved,                                     Address offset: 0x02C */
  __IO uint32_t SECCFGR;         /*!< GPIO secure configuration register for GPIOZ, Address offset: 0x030 */
       uint32_t RESERVED1[229];  /*!< Reserved,                                     Address offset: 0x034-0x3C4 */
  __IO uint32_t HWCFGR10;        /*!< GPIO hardware configuration register 10,      Address offset: 0x3C8 */
  __IO uint32_t HWCFGR9;         /*!< GPIO hardware configuration register 9,       Address offset: 0x3CC */
  __IO uint32_t HWCFGR8;         /*!< GPIO hardware configuration register 8,       Address offset: 0x3D0 */
  __IO uint32_t HWCFGR7;         /*!< GPIO hardware configuration register 7,       Address offset: 0x3D4 */
  __IO uint32_t HWCFGR6;         /*!< GPIO hardware configuration register 6,       Address offset: 0x3D8 */
  __IO uint32_t HWCFGR5;         /*!< GPIO hardware configuration register 5,       Address offset: 0x3DC */
  __IO uint32_t HWCFGR4;         /*!< GPIO hardware configuration register 4,       Address offset: 0x3E0 */
  __IO uint32_t HWCFGR3;         /*!< GPIO hardware configuration register 3,       Address offset: 0x3E4 */
  __IO uint32_t HWCFGR2;         /*!< GPIO hardware configuration register 2,       Address offset: 0x3E8 */
  __IO uint32_t HWCFGR1;         /*!< GPIO hardware configuration register 1,       Address offset: 0x3EC */
  __IO uint32_t HWCFGR0;         /*!< GPIO hardware configuration register 0,       Address offset: 0x3F0 */
  __IO uint32_t VERR;            /*!< GPIO version register,                        Address offset: 0x3F4 */
  __IO uint32_t IPIDR;           /*!< GPIO identification register,                 Address offset: 0x3F8 */
  __IO uint32_t SIDR;            /*!< GPIO size identification register,            Address offset: 0x3FC */
} GPIO_TypeDef;


/**
  * @brief System configuration controller
  */

typedef struct
{
  __IO uint32_t BOOTR;          /*!< SYSCFG Boot pin control register,                                Address offset: 0x00        */
  __IO uint32_t PMCSETR;        /*!< SYSCFG Peripheral Mode configuration set register,               Address offset: 0x04        */
       uint32_t RESERVED1[4];   /*!< Reserved,                                                        Address offset: 0x08-0x14   */
  __IO uint32_t IOCTRLSETR;     /*!< SYSCFG ioctl set register,                                       Address offset: 0x18        */
  __IO uint32_t ICNR;           /*!< SYSCFG interconnect control register,                            Address offset: 0x1C        */
  __IO uint32_t CMPCR;          /*!< SYSCFG compensation cell control register,                       Address offset: 0x20        */
  __IO uint32_t CMPENSETR;      /*!< SYSCFG compensation cell enable set register,                    Address offset: 0x24        */
  __IO uint32_t CMPENCLRR;      /*!< SYSCFG compensation cell enable clear register,                  Address offset: 0x28        */
  __IO uint32_t CBR;            /*!< SYSCFG control timer break register,                             Address offset: 0x2C        */
       uint32_t RESERVED2[5];   /*!< Reserved,                                                        Address offset: 0x30-0x40   */
  __IO uint32_t PMCCLRR;        /*!< SYSCFG Peripheral Mode configuration clear register,             Address offset: 0x44        */
       uint32_t RESERVED3[4];   /*!< Reserved,                                                        Address offset: 0x48-0x54   */
  __IO uint32_t IOCTRLCLRR;     /*!< SYSCFG ioctl clear register,                                     Address offset: 0x58        */
       uint32_t RESERVED4[230]; /*!< Reserved,                                                        Address offset: 0x5C-0x3F0  */
  __IO uint32_t VERR;           /*!< SYSCFG version register,                                         Address offset: 0x3F4       */
  __IO uint32_t IPIDR;          /*!< SYSCFG ID register,                                              Address offset: 0x3F8       */
  __IO uint32_t SIDR;           /*!< SYSCFG magic ID register,                                        Address offset: 0x3FC       */
} SYSCFG_TypeDef;


/**
  * @briefVoltage reference buffer
  */
typedef struct
{
  __IO uint32_t CSR;                /*VREF control and status register                      Address offset: 0x00      */
  __IO uint32_t CCR;                /*VREF control and status register                      Address offset: 0x04      */
} VREF_TypeDef;


/**
  * @brief Inter-integrated Circuit Interface
  */

typedef struct
{
  __IO uint32_t CR1;      /*!< I2C Control register 1,            Address offset: 0x00 */
  __IO uint32_t CR2;      /*!< I2C Control register 2,            Address offset: 0x04 */
  __IO uint32_t OAR1;     /*!< I2C Own address 1 register,        Address offset: 0x08 */
  __IO uint32_t OAR2;     /*!< I2C Own address 2 register,        Address offset: 0x0C */
  __IO uint32_t TIMINGR;  /*!< I2C Timing register,               Address offset: 0x10 */
  __IO uint32_t TIMEOUTR; /*!< I2C Timeout register,              Address offset: 0x14 */
  __IO uint32_t ISR;      /*!< I2C Interrupt and status register, Address offset: 0x18 */
  __IO uint32_t ICR;      /*!< I2C Interrupt clear register,      Address offset: 0x1C */
  __IO uint32_t PECR;     /*!< I2C PEC register,                  Address offset: 0x20 */
  __IO uint32_t RXDR;     /*!< I2C Receive data register,         Address offset: 0x24 */
  __IO uint32_t TXDR;     /*!< I2C Transmit data register,        Address offset: 0x28 */
  uint32_t RESERVED[241]; /*!< Reserved, 0x2C->0x3F0 */
  __IO uint32_t HWCFGR;   /*!< I2C hardware configuration register,  Address offset: 0x3F0 */
  __IO uint32_t VERR;     /*!< I2C version register,                 Address offset: 0x3F4 */
  __IO uint32_t IPIDR;    /*!< I2C identification register,          Address offset: 0x3F8 */
  __IO uint32_t SIDR;     /*!< I2C size identification register,     Address offset: 0x3FC */
} I2C_TypeDef;

/**
  * @brief Independent WATCHDOG
  */

typedef struct
{
  __IO uint32_t KR;   /*!< IWDG Key register,                          Address offset: 0x00 */
  __IO uint32_t PR;   /*!< IWDG Prescaler register,                    Address offset: 0x04 */
  __IO uint32_t RLR;  /*!< IWDG Reload register,                       Address offset: 0x08 */
  __IO uint32_t SR;   /*!< IWDG Status register,                       Address offset: 0x0C */
  __IO uint32_t WINR; /*!< IWDG Window register,                       Address offset: 0x10 */
  __IO uint32_t EWCR; /*!< IWDG Window register,                       Address offset: 0x14 */
  uint32_t RESERVED[246]; /*!< Reserved,                                        0x18->0x3EC */
  __IO uint32_t HWCFGR;   /*!< IWDG hardware configuration register,  Address offset: 0x3F0 */
  __IO uint32_t VERR;     /*!< IWDG version register,                 Address offset: 0x3F4 */
  __IO uint32_t IDR;    /*!< IWDG identification register,            Address offset: 0x3F8 */
  __IO uint32_t SIDR;     /*!< IWDG size identification register,     Address offset: 0x3FC */
} IWDG_TypeDef;


/**
  * @brief JPEG Codec
  */
typedef struct
{
  __IO uint32_t CONFR0;          /*!< JPEG Codec Control Register (JPEG_CONFR0),        Address offset: 00h       */
  __IO uint32_t CONFR1;          /*!< JPEG Codec Control Register (JPEG_CONFR1),        Address offset: 04h       */
  __IO uint32_t CONFR2;          /*!< JPEG Codec Control Register (JPEG_CONFR2),        Address offset: 08h       */
  __IO uint32_t CONFR3;          /*!< JPEG Codec Control Register (JPEG_CONFR3),        Address offset: 0Ch       */
  __IO uint32_t CONFR4;          /*!< JPEG Codec Control Register (JPEG_CONFR4),        Address offset: 10h       */
  __IO uint32_t CONFR5;          /*!< JPEG Codec Control Register (JPEG_CONFR5),        Address offset: 14h       */
  __IO uint32_t CONFR6;          /*!< JPEG Codec Control Register (JPEG_CONFR6),        Address offset: 18h       */
  __IO uint32_t CONFR7;          /*!< JPEG Codec Control Register (JPEG_CONFR7),        Address offset: 1Ch       */
  uint32_t  Reserved20[4];       /* Reserved                                            Address offset: 20h-2Ch   */
  __IO uint32_t CR;              /*!< JPEG Control Register (JPEG_CR),                  Address offset: 30h       */
  __IO uint32_t SR;              /*!< JPEG Status Register (JPEG_SR),                   Address offset: 34h       */
  __IO uint32_t CFR;             /*!< JPEG Clear Flag Register (JPEG_CFR),              Address offset: 38h       */
  uint32_t  Reserved3c;          /* Reserved                                            Address offset: 3Ch       */
  __IO uint32_t DIR;             /*!< JPEG Data Input Register (JPEG_DIR),              Address offset: 40h       */
  __IO uint32_t DOR;             /*!< JPEG Data Output Register (JPEG_DOR),             Address offset: 44h       */
  uint32_t  Reserved48[2];       /* Reserved                                            Address offset: 48h-4Ch   */
  __IO uint32_t QMEM0[16];       /*!< JPEG quantization tables 0,                       Address offset: 50h-8Ch   */
  __IO uint32_t QMEM1[16];       /*!< JPEG quantization tables 1,                       Address offset: 90h-CCh   */
  __IO uint32_t QMEM2[16];       /*!< JPEG quantization tables 2,                       Address offset: D0h-10Ch  */
  __IO uint32_t QMEM3[16];       /*!< JPEG quantization tables 3,                       Address offset: 110h-14Ch */
  __IO uint32_t HUFFMIN[16];     /*!< JPEG HuffMin tables,                              Address offset: 150h-18Ch */
  __IO uint32_t HUFFBASE[32];    /*!< JPEG HuffSymb tables,                             Address offset: 190h-20Ch */
  __IO uint32_t HUFFSYMB[84];    /*!< JPEG HUFFSYMB tables,                             Address offset: 210h-35Ch */
  __IO uint32_t DHTMEM[103];     /*!< JPEG DHTMem tables,                               Address offset: 360h-4F8h */
  uint32_t  Reserved4FC;         /* Reserved                                            Address offset: 4FCh      */
  __IO uint32_t HUFFENC_AC0[88]; /*!< JPEG encodor, AC Huffman table 0,                 Address offset: 500h-65Ch */
  __IO uint32_t HUFFENC_AC1[88]; /*!< JPEG encodor, AC Huffman table 1,                 Address offset: 660h-7BCh */
  __IO uint32_t HUFFENC_DC0[8];  /*!< JPEG encodor, DC Huffman table 0,                 Address offset: 7C0h-7DCh */
  __IO uint32_t HUFFENC_DC1[8];  /*!< JPEG encodor, DC Huffman table 1,                 Address offset: 7E0h-7FCh */

} JPEG_TypeDef;


/**
  * @brief LCD
  */

typedef struct
{
  __IO uint32_t CR;        /*!< LCD control register,              Address offset: 0x00 */
  __IO uint32_t FCR;       /*!< LCD frame control register,        Address offset: 0x04 */
  __IO uint32_t SR;        /*!< LCD status register,               Address offset: 0x08 */
  __IO uint32_t CLR;       /*!< LCD clear register,                Address offset: 0x0C */
  uint32_t RESERVED;       /*!< Reserved,                          Address offset: 0x10 */
  __IO uint32_t RAM[16];   /*!< LCD display memory,           Address offset: 0x14-0x50 */
} LCD_TypeDef;

/**
  * @brief LCD-TFT Display Controller
  */

typedef struct
{
  uint32_t      RESERVED0[2];  /*!< Reserved, 0x00-0x04 */
  __IO uint32_t SSCR;          /*!< LTDC Synchronization Size Configuration Register,    Address offset: 0x08 */
  __IO uint32_t BPCR;          /*!< LTDC Back Porch Configuration Register,              Address offset: 0x0C */
  __IO uint32_t AWCR;          /*!< LTDC Active Width Configuration Register,            Address offset: 0x10 */
  __IO uint32_t TWCR;          /*!< LTDC Total Width Configuration Register,             Address offset: 0x14 */
  __IO uint32_t GCR;           /*!< LTDC Global Control Register,                        Address offset: 0x18 */
  uint32_t      RESERVED1[2];  /*!< Reserved, 0x1C-0x20 */
  __IO uint32_t SRCR;          /*!< LTDC Shadow Reload Configuration Register,           Address offset: 0x24 */
  uint32_t      RESERVED2[1];  /*!< Reserved, 0x28 */
  __IO uint32_t BCCR;          /*!< LTDC Background Color Configuration Register,        Address offset: 0x2C */
  uint32_t      RESERVED3[1];  /*!< Reserved, 0x30 */
  __IO uint32_t IER;           /*!< LTDC Interrupt Enable Register,                      Address offset: 0x34 */
  __IO uint32_t ISR;           /*!< LTDC Interrupt Status Register,                      Address offset: 0x38 */
  __IO uint32_t ICR;           /*!< LTDC Interrupt Clear Register,                       Address offset: 0x3C */
  __IO uint32_t LIPCR;         /*!< LTDC Line Interrupt Position Configuration Register, Address offset: 0x40 */
  __IO uint32_t CPSR;          /*!< LTDC Current Position Status Register,               Address offset: 0x44 */
  __IO uint32_t CDSR;         /*!< LTDC Current Display Status Register,                       Address offset: 0x48 */
} LTDC_TypeDef;

/**
  * @brief LCD-TFT Display layer x Controller
  */

typedef struct
{
  __IO uint32_t CR;            /*!< LTDC Layerx Control Register                                  Address offset: 0x84 */
  __IO uint32_t WHPCR;         /*!< LTDC Layerx Window Horizontal Position Configuration Register Address offset: 0x88 */
  __IO uint32_t WVPCR;         /*!< LTDC Layerx Window Vertical Position Configuration Register   Address offset: 0x8C */
  __IO uint32_t CKCR;          /*!< LTDC Layerx Color Keying Configuration Register               Address offset: 0x90 */
  __IO uint32_t PFCR;          /*!< LTDC Layerx Pixel Format Configuration Register               Address offset: 0x94 */
  __IO uint32_t CACR;          /*!< LTDC Layerx Constant Alpha Configuration Register             Address offset: 0x98 */
  __IO uint32_t DCCR;          /*!< LTDC Layerx Default Color Configuration Register              Address offset: 0x9C */
  __IO uint32_t BFCR;          /*!< LTDC Layerx Blending Factors Configuration Register           Address offset: 0xA0 */
  uint32_t      RESERVED0[2];  /*!< Reserved */
  __IO uint32_t CFBAR;         /*!< LTDC Layerx Color Frame Buffer Address Register               Address offset: 0xAC */
  __IO uint32_t CFBLR;         /*!< LTDC Layerx Color Frame Buffer Length Register                Address offset: 0xB0 */
  __IO uint32_t CFBLNR;        /*!< LTDC Layerx ColorFrame Buffer Line Number Register            Address offset: 0xB4 */
  uint32_t      RESERVED1[3];  /*!< Reserved */
  __IO uint32_t CLUTWR;         /*!< LTDC Layerx CLUT Write Register                               Address offset: 0x144 */

} LTDC_Layer_TypeDef;


/**
  * @brief USBPHYC  USB HS PHY Control
  */
typedef struct
{
  __IO uint32_t PLL;                       /*!< USBPHYC PLL control register,               Address offset: 0x000 */
  uint32_t RESERVED0;                      /*! Reserved                                     Address offset: 0x004 */
  __IO uint32_t MISC;                      /*!< USBPHYC Misc Control register,              Address offset: 0x008 */
  uint32_t RESERVED1[250] ;                /*! Reserved                              Address offset: 0x00C - 0x3F0*/
  __IO uint32_t VERR;                      /*!< USBPHYC Version register,                   Address offset: 0x3F4 */
  __IO uint32_t IPIDR;                     /*!< USBPHYC Identification register,            Address offset: 0x3F8 */
  __IO uint32_t SIDR;                      /*!< USBPHYC Size ID register,                   Address offset: 0x3FC */
}USBPHYC_GlobalTypeDef;


/**
  * @brief USBPHYC  USB HS PHY Control PHYx
  */
typedef struct
{
  uint32_t RESERVED0[3];                   /*! Reserved                              Address offset: 0x000 - 0x008 */
  __IO uint32_t TUNE;                     /*!< USBPHYC x TUNE register  ter,                Address offset: 0x00C */
}USBPHYC_InstanceTypeDef;


/**
  * @brief TZC TrustZone Address Space Controller for DDR
  */
typedef struct
{
  __IO uint32_t BUILD_CONFIG;       /*!< Build config register,               Address offset: 0x00 */
  __IO uint32_t ACTION;             /*!< Action register,                     Address offset: 0x04 */
  __IO uint32_t GATE_KEEPER;        /*!< Gate keeper register,                Address offset: 0x08 */
  __IO uint32_t SPECULATION_CTRL;   /*!< Speculation control register,        Address offset: 0x0C */
  uint8_t RESERVED0[0x100 - 0x10];
  __IO uint32_t REG_BASE_LOWO;      /*!< Region 0 base address low register,  Address offset: 0x100 */
  __IO uint32_t REG_BASE_HIGHO;     /*!< Region 0 base address high register, Address offset: 0x104 */
  __IO uint32_t REG_TOP_LOWO;       /*!< Region 0 top address low register,   Address offset: 0x108 */
  __IO uint32_t REG_TOP_HIGHO;      /*!< Region 0 top address high register,  Address offset: 0x10C */
  __IO uint32_t REG_ATTRIBUTESO;    /*!< Region 0 attribute register,         Address offset: 0x110 */
  __IO uint32_t REG_ID_ACCESSO;     /*!< Region 0 ID access register,         Address offset: 0x114 */
  /* @TODO : TypeDef to be compleated if needed*/
}TZC_TypeDef;



/**
  * @brief TZPC TrustZone Protection Controller
  */
typedef struct
{
  __IO uint32_t   TZMA0_SIZE;         /*!<TZPC ROM Secure Size Definition register,             Address offset: 0x00 */
  __IO uint32_t   TZMA1_SIZE;         /*!<TZPC SYSRAM Secure Size Definition register,          Address offset: 0x04 */
  uint32_t        RESERVED0[2];       /*!< Reserved */
  __IO uint32_t   DECPROT0;           /*!<TZPC Securable peripheral definition register 0,      Address offset: 0x10 */
  __IO uint32_t   DECPROT1;           /*!<TZPC Securable peripheral definition register 1,      Address offset: 0x14 */
  __IO uint32_t   DECPROT2;           /*!<TZPC Securable peripheral definition register 2,      Address offset: 0x18 */
  __IO uint32_t   DECPROT3;           /*!<TZPC Securable peripheral definition register 3,      Address offset: 0x1C */
  __IO uint32_t   DECPROT4;           /*!<TZPC Securable peripheral definition register 4,      Address offset: 0x20 */
  __IO uint32_t   DECPROT5;           /*!<TZPC Securable peripheral definition register 5,      Address offset: 0x24 */
  uint32_t        RESERVED1[2];       /*!< Reserved */
  __IO uint32_t   DECPROT_LOCK0;      /*!<TZPC Securable lock of security register 0,           Address offset: 0x30 */
  __IO uint32_t   DECPROT_LOCK1;      /*!<TZPC Securable lock of security register 1,           Address offset: 0x34 */
  __IO uint32_t   DECPROT_LOCK2;      /*!<TZPC Securable lock of security register 2,           Address offset: 0x38 */
  uint32_t        RESERVED2[237];     /*!< Reserved */
  __IO uint32_t   HWCFGR;             /*!< TZPC IP HW configuration register                    Address offset:0x3F0  */
  __IO uint32_t   IP_VER;             /*!< TZPC IP version register                             Address offset:0x3F4  */
  __IO uint32_t   ID;                 /*!< TZPC IP version register                             Address offset:0x3F8  */
  __IO uint32_t   SID;                /*!< TZPC IP version register                             Address offset:0x3FC  */
}TZPC_TypeDef;



/**
  * @brief STGENC System Generic Counter Control
  */
typedef struct
{
  __IO uint32_t CNTCR;          /*!< STGENC Counter Control Register,              Address offset: 0x000 */
       uint32_t CNTSR;          /*!< STGENC Counter Status Register,               Address offset: 0x004 */
  __IO uint32_t CNTCVL;         /*!< STGENC Current Counter Value Lower Register,  Address offset: 0x008 */
  __IO uint32_t CNTCVU;         /*!< STGENC Current Counter Value Upper Register,  Address offset: 0x00C */
       uint32_t RESERVED1[4];                         /*!< Reserved, Address offsets: 0x010-0x01C */
  __IO uint32_t CNTFID0;        /*!< STGENC Base Frequency ID Register,            Address offset: 0x020 */
       uint32_t RESERVED2[1003];                      /*!< Reserved, Address offsets: 0x024-0xFCC */
  __IO uint32_t PIDR4;          /*!< STGENC Peripheral ID4 Register,               Address offset: 0xFD0 */
  __IO uint32_t RESERVED3[3];                         /*!< Reserved, Address offsets: 0xFD4-0xFDC */
  __IO uint32_t PIDR[4];        /*!< STGENC Peripheral ID0-ID3 Registers,          Address offset: 0xFE0 */
  __IO uint32_t CIDR[4];        /*!< STGENC Component ID0-ID3 Registers,           Address offset: 0xFF0 */
}STGENC_TypeDef;

/**
  * @brief STGENR System Timestamp Generator Read
  */
typedef struct
{
  __IO uint32_t CNTCVL;  /*!< STGENR Current Counter Value Lower Register,  Address offset: 0x000 */
  __IO uint32_t CNTCVU;  /*!< STGENR Current Counter Value Upper Register,  Address offset: 0x004 */
       uint32_t RESERVED1[1010];                      /*!< Reserved, Address offsets: 0x008-0xFCC */
  __IO uint32_t PIDR4;   /*!< STGENR Peripheral ID4 Register,               Address offset: 0xFD0 */
  __IO uint32_t RESERVED2[3];                         /*!< Reserved, Address offsets: 0xFD4-0xFDC */
  __IO uint32_t PIDR[4]; /*!< STGENR Peripheral ID0-ID3 Registers,          Address offset: 0xFE0 */
  __IO uint32_t CIDR[4]; /*!< STGENR Component ID0-ID3 Registers,           Address offset: 0xFF0 */
} STGENR_TypeDef;
 
 
/**
  * @brief Firewall
  */

typedef struct
{
  __IO uint32_t CSSA;     /*!< Code Segment Start Address register,              Address offset: 0x00 */
  __IO uint32_t CSL;      /*!< Code Segment Length register,                      Address offset: 0x04 */
  __IO uint32_t NVDSSA;   /*!< NON volatile data Segment Start Address register,  Address offset: 0x08 */
  __IO uint32_t NVDSL;    /*!< NON volatile data Segment Length register,         Address offset: 0x0C */
  __IO uint32_t VDSSA ;   /*!< Volatile data Segment Start Address register,      Address offset: 0x10 */
  __IO uint32_t VDSL ;    /*!< Volatile data Segment Length register,             Address offset: 0x14 */
  __IO uint32_t CR ;      /*!< Configuration  register,                           Address offset: 0x20 */

} FIREWALL_TypeDef;

/**
  * @brief Power Control
  */

typedef struct
{
  __IO uint32_t CR1;              /*!< PWR control register 1,                   Address offset: 0x00 */
  __IO uint32_t CSR1;             /*!< PWR control status register 1,            Address offset: 0x04 */
  __IO uint32_t CR2;              /*!< PWR control register 2,                   Address offset: 0x08 */
  __IO uint32_t CR3;              /*!< PWR control register 3,                   Address offset: 0x0C */
  __IO uint32_t MPUCR;            /*!< PWR MPU control register,                 Address offset: 0x10 */
  __IO uint32_t MCUCR;            /*!< PWR MCU control register,                 Address offset: 0x14 */
       uint32_t RESERVED0[2];     /*!< Reserved, 0x18-0x1C                       Address offset: 0x18 */
  __IO uint32_t WKUPCR;           /*!< PWR wakeup clear register,                Address offset: 0x20 */
  __IO uint32_t WKUPFR;           /*!< PWR wakeup flag register,                 Address offset: 0x24 */
  __IO uint32_t MPUWKUPENR;       /*!< PWR wakeup enable and polarity register,  Address offset: 0x28 */
  __IO uint32_t MCUWKUPENR;       /*!< PWR wakeup enable and polarity register,  Address offset: 0x2C */
       uint32_t RESERVED1[241];   /*!< Reserved, 0x30-0x3F0                      Address offset: 0x30 */
  __IO uint32_t VER;              /*!< PWR IP version register,                  Address offset: 0x3F4 */
  __IO uint32_t ID;               /*!< PWR IP identification register,           Address offset: 0x3F8 */
  __IO uint32_t SID;              /*!< PWR size ID register,                     Address offset: 0x3FC */
} PWR_TypeDef;


/**
  * @brief Reset and Clock Control
  */

typedef struct
{
  __IO uint32_t TZCR;                      /*!< RCC TrustZone Control Register                       Address offset: 0x00 */
       uint32_t RESERVED0[2];              /*!< Reserved, 0x04-0x08                                  Address offset: 0x04 */
  __IO uint32_t OCENSETR;                  /*!< RCC Oscillator Clock Enable Set Register             Address offset: 0x0C */
  __IO uint32_t OCENCLRR;                  /*!< RCC Oscillator Enable Control Clear Register         Address offset: 0x10 */
       uint32_t RESERVED1;                 /*!< Reserved,                                            Address offset: 0x14 */
  __IO uint32_t HSICFGR;                   /*!< RCC HSI Configuration Register                       Address offset: 0x18 */
  __IO uint32_t CSICFGR;                   /*!< RCC CSI Configuration Register                       Address offset: 0x1C */
  __IO uint32_t MPCKSELR;                  /*!< RCC MPU Clock Selection Register                     Address offset: 0x20 */
  __IO uint32_t ASSCKSELR;                 /*!< RCC AXI Sub-System Clock Selection Register          Address offset: 0x24 */
  __IO uint32_t RCK12SELR;                 /*!< RCC PLL 1 and 2 Ref. Clock Selection Register        Address offset: 0x28 */
  __IO uint32_t MPCKDIVR;                  /*!< RCC MPU Clock Divider Register                       Address offset: 0x2C */
  __IO uint32_t AXIDIVR;                   /*!< RCC AXI Clock Divider Register                       Address offset: 0x30 */
       uint32_t RESERVED2[2];              /*!< Reserved, 0x34-0x38                                  Address offset: 0x34 */
  __IO uint32_t APB4DIVR;                  /*!< RCC APB4 Clock Divider Register                      Address offset: 0x3C */
  __IO uint32_t APB5DIVR;                  /*!< RCC APB5 Clock Divider Register                      Address offset: 0x40 */
  __IO uint32_t RTCDIVR;                   /*!< RCC RTC Clock Division Register                      Address offset: 0x44 */
  __IO uint32_t MSSCKSELR;                 /*!< RCC MCU Sub-System Clock Selection Register          Address offset: 0x48 */
       uint32_t RESERVED3[13];             /*!< Reserved, 0x4C-0x7C                                  Address offset: 0x4C */
  __IO uint32_t PLL1CR;                    /*!< RCC PLL1 Control Register                            Address offset: 0x80 */
  __IO uint32_t PLL1CFGR1;                 /*!< RCC PLL1 Configuration Register 1                    Address offset: 0x84 */
  __IO uint32_t PLL1CFGR2;                 /*!< RCC PLL1 Configuration Register 2                    Address offset: 0x88 */
  __IO uint32_t PLL1FRACR;                 /*!< RCC PLL1 Fractional Register                         Address offset: 0x8C */
  __IO uint32_t PLL1CSGR;                  /*!< RCC PLL1 Clock Spreading Generator Register          Address offset: 0x90 */
  __IO uint32_t PLL2CR;                    /*!< RCC PLL2 Control Register                            Address offset: 0x94 */
  __IO uint32_t PLL2CFGR1;                 /*!< RCC PLL2 Configuration Register 1                    Address offset: 0x98 */
  __IO uint32_t PLL2CFGR2;                 /*!< RCC PLL2 Configuration Register 2                    Address offset: 0x9C */
  __IO uint32_t PLL2FRACR;                 /*!< RCC PLL2 Fractional Register                         Address offset: 0xA0 */
  __IO uint32_t PLL2CSGR;                  /*!< RCC PLL2 Clock Spreading Generator Register          Address offset: 0xA4 */
       uint32_t RESERVED4[6];              /*!< Reserved, 0xA8-0xBC                                  Address offset: 0xA8 */
  __IO uint32_t I2C46CKSELR;               /*!< RCC I2C46 Kernel Clock Selection Register            Address offset: 0xC0 */
  __IO uint32_t SPI6CKSELR;                /*!< RCC SPI6 Kernel Clock Selection Register             Address offset: 0xC4 */
  __IO uint32_t UART1CKSELR;               /*!< RCC USART1 Kernel Clock Selection Register           Address offset: 0xC8 */
  __IO uint32_t RNG1CKSELR;                /*!< RCC RNG1 Kernel Clock Selection Register             Address offset: 0xCC */
  __IO uint32_t CPERCKSELR;                /*!< RCC Common Peripheral Clock Selection Register       Address offset: 0xD0 */
  __IO uint32_t STGENCKSELR;               /*!< RCC STGEN Clock Selection Register                   Address offset: 0xD4 */
  __IO uint32_t DDRITFCR;                  /*!< RCC control DDR interface, DDRC and DDRPHYC Register Address offset: 0xD8 */
       uint32_t RESERVED5;                 /*!< Reserved,                                            Address offset: 0xDC */
       uint32_t RESERVED6[8];              /*!< Reserved, 0xE0-0xFC                                  Address offset: 0xE0 */
  __IO uint32_t MP_BOOTCR;                 /*!< RCC Hold Boot Control Register                       Address offset: 0x100 */
  __IO uint32_t MP_SREQSETR;               /*!< RCC Stop Request Set Register                        Address offset: 0x104 */
  __IO uint32_t MP_SREQCLRR;               /*!< RCC Stop Request Clear Register                      Address offset: 0x108 */
  __IO uint32_t MP_GCR;                    /*!< RCC Global Control Register                          Address offset: 0x10C */
  __IO uint32_t MP_APRSTCR;                /*!< RCC Application Reset Control Register               Address offset: 0x110 */
  __IO uint32_t MP_APRSTSR;                /*!< RCC Application Reset Status Register                Address offset: 0x114 */
       uint32_t RESERVED7[10];             /*!< Reserved, 0x118-0x13C                                Address offset: 0x118 */
  __IO uint32_t BDCR;                      /*!< RCC Backup Domain Control Register                   Address offset: 0x140 */
  __IO uint32_t RDLSICR;                   /*!< RCC Reset Duration and LSI Control Register          Address offset: 0x144 */
       uint32_t RESERVED8[14];             /*!< Reserved, 0x148-0x17C                                Address offset: 0x148 */
  __IO uint32_t APB4RSTSETR;               /*!< RCC APB4 Peripheral Reset Set Register               Address offset: 0x180 */
  __IO uint32_t APB4RSTCLRR;               /*!< RCC APB4 Peripheral Reset Clear Register             Address offset: 0x184 */
  __IO uint32_t APB5RSTSETR;               /*!< RCC APB5 Peripheral Reset Set Register               Address offset: 0x188 */
  __IO uint32_t APB5RSTCLRR;               /*!< RCC APB5 Peripheral Reset Clear Register             Address offset: 0x18C */
  __IO uint32_t AHB5RSTSETR;               /*!< RCC AHB5 Peripheral Reset Set Register               Address offset: 0x190 */
  __IO uint32_t AHB5RSTCLRR;               /*!< RCC AHB5 Peripheral Reset Clear Register             Address offset: 0x194 */
  __IO uint32_t AHB6RSTSETR;               /*!< RCC AHB6 Peripheral Reset Set Register               Address offset: 0x198 */
  __IO uint32_t AHB6RSTCLRR;               /*!< RCC AHB6 Peripheral Reset Clear Register             Address offset: 0x19C */
  __IO uint32_t TZAHB6RSTSETR;             /*!< RCC AHB6 Peripheral Reset Set Register               Address offset: 0x1A0 */
  __IO uint32_t TZAHB6RSTCLRR;             /*!< RCC AHB6 Peripheral Reset Clear Register             Address offset: 0x1A4 */
       uint32_t RESERVED9[22];             /*!< Reserved, 0x1A8-0x1FC                                Address offset: 0x1A8 */
  __IO uint32_t MP_APB4ENSETR;             /*!< RCC APB4 Periph. Enable For MPU Set Register         Address offset: 0x200 */
  __IO uint32_t MP_APB4ENCLRR;             /*!< RCC APB4 Periph. Enable For MPU Clear Register       Address offset: 0x204 */
  __IO uint32_t MP_APB5ENSETR;             /*!< RCC APB5 Periph. Enable For MPU Set Register         Address offset: 0x208 */
  __IO uint32_t MP_APB5ENCLRR;             /*!< RCC APB5 Periph. Enable For MPU Clear Register       Address offset: 0x20C */
  __IO uint32_t MP_AHB5ENSETR;             /*!< RCC AHB5 Periph. Enable For MPU Set Register         Address offset: 0x210 */
  __IO uint32_t MP_AHB5ENCLRR;             /*!< RCC AHB5 Periph. Enable For MPU Clear Register       Address offset: 0x214 */
  __IO uint32_t MP_AHB6ENSETR;             /*!< RCC AHB6 Periph. Enable For MPU Set Register         Address offset: 0x218 */
  __IO uint32_t MP_AHB6ENCLRR;             /*!< RCC AHB6 Periph. Enable For MPU Clear Register       Address offset: 0x21C */
       uint32_t RESERVED10[24];             /*!< Reserved, 0x220-0x27C                                Address offset: 0x220 */
  __IO uint32_t MC_APB4ENSETR;             /*!< RCC APB4 Periph. Enable For MCU Set Register         Address offset: 0x280 */
  __IO uint32_t MC_APB4ENCLRR;             /*!< RCC APB4 Periph. Enable For MCU Clear Register       Address offset: 0x284 */
  __IO uint32_t MC_APB5ENSETR;             /*!< RCC APB5 Periph. Enable For MCU Set Register         Address offset: 0x288 */
  __IO uint32_t MC_APB5ENCLRR;             /*!< RCC APB5 Periph. Enable For MCU Clear Register       Address offset: 0x28C */
  __IO uint32_t MC_AHB5ENSETR;             /*!< RCC AHB5 Periph. Enable For MCU Set Register         Address offset: 0x290 */
  __IO uint32_t MC_AHB5ENCLRR;             /*!< RCC AHB5 Periph. Enable For MCU Clear Register       Address offset: 0x294 */
  __IO uint32_t MC_AHB6ENSETR;             /*!< RCC AHB6 Periph. Enable For MCU Set Register         Address offset: 0x298 */
  __IO uint32_t MC_AHB6ENCLRR;             /*!< RCC AHB6 Periph. Enable For MCU Clear Register       Address offset: 0x29C */
       uint32_t RESERVED11[24];            /*!< Reserved, 0x2A0-0x2FC                                Address offset: 0x2A0 */
  __IO uint32_t MP_APB4LPENSETR;           /*!< RCC APB4 Sleep Clock Ena. For MPU Set Register       Address offset: 0x300 */
  __IO uint32_t MP_APB4LPENCLRR;           /*!< RCC APB4 Sleep Clock Ena. For MPU Clear Register     Address offset: 0x304 */
  __IO uint32_t MP_APB5LPENSETR;           /*!< RCC APB5 Sleep Clock Ena. For MPU Set Register       Address offset: 0x308 */
  __IO uint32_t MP_APB5LPENCLRR;           /*!< RCC APB5 Sleep Clock Ena. For MPU Clear Register     Address offset: 0x30C */
  __IO uint32_t MP_AHB5LPENSETR;           /*!< RCC AHB5 Sleep Clock Ena. For MPU Set Register       Address offset: 0x310 */
  __IO uint32_t MP_AHB5LPENCLRR;           /*!< RCC AHB5 Sleep Clock Ena. For MPU Clear Register     Address offset: 0x314 */
  __IO uint32_t MP_AHB6LPENSETR;           /*!< RCC AHB6 Sleep Clock Ena. For MPU Set Register       Address offset: 0x318 */
  __IO uint32_t MP_AHB6LPENCLRR;           /*!< RCC AHB6 Sleep Clock Ena. For MPU Clear Register     Address offset: 0x31C */
       uint32_t RESERVED12[24];            /*!< Reserved, 0x320-0x30C                                Address offset: 0x320 */
  __IO uint32_t MC_APB4LPENSETR;           /*!< RCC APB4 Sleep Clock Ena. For MCU Set Register       Address offset: 0x380 */
  __IO uint32_t MC_APB4LPENCLRR;           /*!< RCC APB4 Sleep Clock Ena. For MCU Clear Register     Address offset: 0x384 */
  __IO uint32_t MC_APB5LPENSETR;           /*!< RCC APB5 Sleep Clock Ena. For MCU Set Register       Address offset: 0x388 */
  __IO uint32_t MC_APB5LPENCLRR;           /*!< RCC APB5 Sleep Clock Ena. For MCU Clear Register     Address offset: 0x38C */
  __IO uint32_t MC_AHB5LPENSETR;           /*!< RCC AHB5 Sleep Clock Ena. For MCU Set Register       Address offset: 0x390 */
  __IO uint32_t MC_AHB5LPENCLRR;           /*!< RCC AHB5 Sleep Clock Ena. For MCU Clear Register     Address offset: 0x394 */
  __IO uint32_t MC_AHB6LPENSETR;           /*!< RCC AHB6 Sleep Clock Ena. For MCU Set Register       Address offset: 0x398 */
  __IO uint32_t MC_AHB6LPENCLRR;           /*!< RCC AHB6 Sleep Clock Ena. For MCU Clear Register     Address offset: 0x39C */
       uint32_t RESERVED13[24];            /*!< Reserved, 0x3A0-0x3FC                                Address offset: 0x3A0 */
  __IO uint32_t BR_RSTSCLRR;               /*!< RCC BootRom Reset Status Clear Register              Address offset: 0x400 */
  __IO uint32_t MP_GRSTCSETR;              /*!< RCC Global Reset Control Set Register                Address offset: 0x404 */
  __IO uint32_t MP_RSTSCLRR;               /*!< RCC MPU Reset Status Clear Register                  Address offset: 0x408 */
  __IO uint32_t MP_IWDGFZSETR;             /*!< RCC IWDG Clock Freeze Set Register                   Address offset: 0x40C */
  __IO uint32_t MP_IWDGFZCLRR;             /*!< RCC IWDG Clock Freeze Clear Register                 Address offset: 0x410 */
  __IO uint32_t MP_CIER;                   /*!< RCC Clock Source Interrupt Enable Register           Address offset: 0x414 */
  __IO uint32_t MP_CIFR;                   /*!< RCC Clock Source Interrupt Flag Register             Address offset: 0x418 */
  __IO uint32_t PWRLPDLYCR;                /*!< RCC PWR_LP Delay Control Register                    Address offset: 0x41C */
  __IO uint32_t MP_RSTSSETR;               /*!< RCC MPU Reset Status Set Register                    Address offset: 0x420 */
       uint32_t RESERVED14[247];           /*!< Reserved, 0x424-0x7FC                                Address offset: 0x424 */
  __IO uint32_t MCO1CFGR;                  /*!< RCC MCO1 Configuration Register                      Address offset: 0x800 */
  __IO uint32_t MCO2CFGR;                  /*!< RCC MCO2 Configuration Register                      Address offset: 0x804 */
  __IO uint32_t OCRDYR;                    /*!< RCC Oscillator Clock Ready Register                  Address offset: 0x808 */
  __IO uint32_t DBGCFGR;                   /*!< Debug Configuration Register                         Address offset: 0x80C */
       uint32_t RESERVED15[4];             /*!< Reserved, 0x810-0x81C                                Address offset: 0x810 */
  __IO uint32_t RCK3SELR;                  /*!< RCC PLL 3 Ref. Clock Selection Register              Address offset: 0x820 */
  __IO uint32_t RCK4SELR;                  /*!< RCC PLL4 Ref. Clock Selection Register               Address offset: 0x824 */
  __IO uint32_t TIMG1PRER;                 /*!< RCC TIM Group 1 Prescaler Register                   Address offset: 0x828 */
  __IO uint32_t TIMG2PRER;                 /*!< RCC TIM Group 2 Prescaler Register                   Address offset: 0x82C */
  __IO uint32_t MCUDIVR;                   /*!< RCC MCU Clock Prescaler Register                     Address offset: 0x830 */
  __IO uint32_t APB1DIVR;                  /*!< RCC APB1 Clock Prescaler Register                    Address offset: 0x834 */
  __IO uint32_t APB2DIVR;                  /*!< RCC APB2 Clock Prescaler Register                    Address offset: 0x838 */
  __IO uint32_t APB3DIVR;                  /*!< RCC APB3 Clock Prescaler Register                    Address offset: 0x83C */
       uint32_t RESERVED16[16];            /*!< Reserved, 0x840-0x87C                                Address offset: 0x840 */
  __IO uint32_t PLL3CR;                    /*!< RCC PLL3 Control Register                            Address offset: 0x880 */
  __IO uint32_t PLL3CFGR1;                 /*!< RCC PLL3 Configuration Register 1                    Address offset: 0x884 */
  __IO uint32_t PLL3CFGR2;                 /*!< RCC PLL3 Configuration Register 2                    Address offset: 0x888 */
  __IO uint32_t PLL3FRACR;                 /*!< RCC PLL3 Fractional Register                         Address offset: 0x88C */
  __IO uint32_t PLL3CSGR;                  /*!< RCC PLL3 Clock Spreading Generator Register          Address offset: 0x890 */
  __IO uint32_t PLL4CR;                    /*!< RCC PLL4 Control Register                            Address offset: 0x894 */
  __IO uint32_t PLL4CFGR1;                 /*!< RCC PLL4 Configuration Register 1                    Address offset: 0x898 */
  __IO uint32_t PLL4CFGR2;                 /*!< RCC PLL4 Configuration Register 2                    Address offset: 0x89C */
  __IO uint32_t PLL4FRACR;                 /*!< RCC PLL4 Fractional Register                         Address offset: 0x8A0 */
  __IO uint32_t PLL4CSGR;                  /*!< RCC PLL4 Clock Spreading Generator Register          Address offset: 0x8A4 */
       uint32_t RESERVED17[6];             /*!< Reserved, 0x8A8-0x8BC                                Address offset: 0x8A8 */
  __IO uint32_t I2C12CKSELR;               /*!< RCC I2C1,2 Kernel Clock Selection Register           Address offset: 0x8C0 */
  __IO uint32_t I2C35CKSELR;               /*!< RCC I2C3,5 Kernel Clock Selection Register           Address offset: 0x8C4 */
  __IO uint32_t SAI1CKSELR;                /*!< RCC SAI1 Kernel Clock Selection Register             Address offset: 0x8C8 */
  __IO uint32_t SAI2CKSELR;                /*!< RCC SAI2 Kernel Clock Selection Register             Address offset: 0x8CC */
  __IO uint32_t SAI3CKSELR;                /*!< RCC SAI3 Kernel Clock Selection Register             Address offset: 0x8D0 */
  __IO uint32_t SAI4CKSELR;                /*!< RCC SAI4 Kernel Clock Selection Register             Address offset: 0x8D4 */
  __IO uint32_t SPI2S1CKSELR;              /*!< RCC SPI/I2S1 Kernel Clock Selection Register         Address offset: 0x8D8 */
  __IO uint32_t SPI2S23CKSELR;             /*!< RCC SPI/I2S2,3 Kernel Clock Selection Register       Address offset: 0x8DC */
  __IO uint32_t SPI45CKSELR;               /*!< RCC SPI4,5 Kernel Clock Selection Register           Address offset: 0x8E0 */
  __IO uint32_t UART6CKSELR;               /*!< RCC USART6 Kernel Clock Selection Register           Address offset: 0x8E4 */
  __IO uint32_t UART24CKSELR;              /*!< RCC UART2,4 Kernel Clock Selection Register          Address offset: 0x8E8 */
  __IO uint32_t UART35CKSELR;              /*!< RCC UART3,5 Kernel Clock Selection Register          Address offset: 0x8EC */
  __IO uint32_t UART78CKSELR;              /*!< RCC UART7,8 Kernel Clock Selection Register          Address offset: 0x8F0 */
  __IO uint32_t SDMMC12CKSELR;             /*!< RCC SDMMC1&2 Kernel Clock Selection Register         Address offset: 0x8F4 */
  __IO uint32_t SDMMC3CKSELR;              /*!< RCC SDMMC3 Kernel Clock Selection Register           Address offset: 0x8F8 */
  __IO uint32_t ETHCKSELR;                 /*!< RCC Ethernet Kernel Clock Selection Register         Address offset: 0x8FC */
  __IO uint32_t QSPICKSELR;                /*!< RCC QUADSPI Kernel Clock Selection Register          Address offset: 0x900 */
  __IO uint32_t FMCCKSELR;                 /*!< RCC FMC Kernel Clock Selection Register              Address offset: 0x904 */
       uint32_t RESERVED18;                /*!< Reserved,                                            Address offset: 0x908 */
  __IO uint32_t FDCANCKSELR;               /*!< RCC FDCAN Kernel Clock Selection Register            Address offset: 0x90C */
       uint32_t RESERVED19;                /*!< Reserved,                                            Address offset: 0x910 */
  __IO uint32_t SPDIFCKSELR;               /*!< RCC SPDIF Kernel Clock Selection Register            Address offset: 0x914 */
  __IO uint32_t CECCKSELR;                 /*!< RCC CEC Kernel Clock Selection Register              Address offset: 0x918 */
  __IO uint32_t USBCKSELR;                 /*!< RCC USB Kernel Clock Selection Register              Address offset: 0x91C */
  __IO uint32_t RNG2CKSELR;                /*!< RCC RNG2 Kernel Clock Selection Register             Address offset: 0x920 */
       uint32_t RESERVED31;                /*!< Reserved,                                            Address offset: 0x924 */
  __IO uint32_t ADCCKSELR;                 /*!< RCC ADC Kernel Clock Selection Register              Address offset: 0x928 */
  __IO uint32_t LPTIM45CKSELR;             /*!< RCC LPTIM4&5 Kernel Clock Selection Register         Address offset: 0x92C */
  __IO uint32_t LPTIM23CKSELR;             /*!< RCC LPTIM2&3 Kernel Clock Selection Register         Address offset: 0x930 */
  __IO uint32_t LPTIM1CKSELR;              /*!< RCC LPTIM1 Kernel Clock Selection Register           Address offset: 0x934 */
       uint32_t RESERVED20[18];            /*!< Reserved, 0x938-0x97C                                Address offset: 0x938 */
  __IO uint32_t APB1RSTSETR;               /*!< RCC APB1 Peripheral Reset Set Register               Address offset: 0x980 */
  __IO uint32_t APB1RSTCLRR;               /*!< RCC APB1 Peripheral Reset Clear Register             Address offset: 0x984 */
  __IO uint32_t APB2RSTSETR;               /*!< RCC APB2 Peripheral Reset Set Register               Address offset: 0x988 */
  __IO uint32_t APB2RSTCLRR;               /*!< RCC APB2 Peripheral Reset Clear Register             Address offset: 0x98C */
  __IO uint32_t APB3RSTSETR;               /*!< RCC APB3 Peripheral Reset Set Register               Address offset: 0x990 */
  __IO uint32_t APB3RSTCLRR;               /*!< RCC APB3 Peripheral Reset Clear Register             Address offset: 0x994 */
  __IO uint32_t AHB2RSTSETR;               /*!< RCC AHB2 Peripheral Reset Set Register               Address offset: 0x998 */
  __IO uint32_t AHB2RSTCLRR;               /*!< RCC AHB2 Peripheral Reset Clear Register             Address offset: 0x99C */
  __IO uint32_t AHB3RSTSETR;               /*!< RCC AHB3 Peripheral Reset Set Register               Address offset: 0x9A0 */
  __IO uint32_t AHB3RSTCLRR;               /*!< RCC AHB3 Peripheral Reset Clear Register             Address offset: 0x9A4 */
  __IO uint32_t AHB4RSTSETR;               /*!< RCC AHB4 Peripheral Reset Set Register               Address offset: 0x9A8 */
  __IO uint32_t AHB4RSTCLRR;               /*!< RCC AHB4 Peripheral Reset Clear Register             Address offset: 0x9AC */
       uint32_t RESERVED21[20];            /*!< Reserved, 0x9B0-0x9FC                                Address offset: 0x9B0 */
  __IO uint32_t MP_APB1ENSETR;             /*!< RCC APB1 Peripheral Enable For MPU Set Register      Address offset: 0xA00 */
  __IO uint32_t MP_APB1ENCLRR;             /*!< RCC APB1 Peripheral Enable For MPU Clear Register    Address offset: 0xA04 */
  __IO uint32_t MP_APB2ENSETR;             /*!< RCC APB2 Peripheral Enable For MPU Set Register      Address offset: 0xA08 */
  __IO uint32_t MP_APB2ENCLRR;             /*!< RCC APB2 Peripheral Enable For MPU Clear Register    Address offset: 0xA0C */
  __IO uint32_t MP_APB3ENSETR;             /*!< RCC APB3 Peripheral Enable For MPU Set Register      Address offset: 0xA10 */
  __IO uint32_t MP_APB3ENCLRR;             /*!< RCC APB3 Peripheral Enable For MPU Clear Register    Address offset: 0xA14 */
  __IO uint32_t MP_AHB2ENSETR;             /*!< RCC AHB2 Peripheral Enable For MPU Set Register      Address offset: 0xA18 */
  __IO uint32_t MP_AHB2ENCLRR;             /*!< RCC AHB2 Peripheral Enable For MPU Clear Register    Address offset: 0xA1C */
  __IO uint32_t MP_AHB3ENSETR;             /*!< RCC AHB3 Peripheral Enable For MPU Set Register      Address offset: 0xA20 */
  __IO uint32_t MP_AHB3ENCLRR;             /*!< RCC AHB3 Peripheral Enable For MPU Clear Register    Address offset: 0xA24 */
  __IO uint32_t MP_AHB4ENSETR;             /*!< RCC AHB4 Peripheral Enable For MPU Set Register      Address offset: 0xA28 */
  __IO uint32_t MP_AHB4ENCLRR;             /*!< RCC AHB4 Peripheral Enable For MPU Clear Register    Address offset: 0xA2C */
       uint32_t RESERVED22[2];             /*!< Reserved, 0xA30-0xA34                                Address offset: 0xA30 */
  __IO uint32_t MP_MLAHBENSETR;            /*!< RCC MLAHB Periph. Enable For MPU Set Register        Address offset: 0xA38 */
  __IO uint32_t MP_MLAHBENCLRR;            /*!< RCC MLAHB Periph. Enable For MPU Clear Register      Address offset: 0xA3C */
       uint32_t RESERVED23[16];            /*!< Reserved, 0x940-0xA7C                                Address offset: 0x940 */
  __IO uint32_t MC_APB1ENSETR;             /*!< RCC APB1 Peripheral Enable For MCU Set Register      Address offset: 0xA80 */
  __IO uint32_t MC_APB1ENCLRR;             /*!< RCC APB1 Peripheral Enable For MCU Clear Register    Address offset: 0xA84 */
  __IO uint32_t MC_APB2ENSETR;             /*!< RCC APB2 Peripheral Enable For MCU Set Register      Address offset: 0xA88 */
  __IO uint32_t MC_APB2ENCLRR;             /*!< RCC APB2 Peripheral Enable For MCU Clear Register    Address offset: 0xA8C */
  __IO uint32_t MC_APB3ENSETR;             /*!< RCC APB3 Peripheral Enable For MCU Set Register      Address offset: 0xA90 */
  __IO uint32_t MC_APB3ENCLRR;             /*!< RCC APB3 Peripheral Enable For MCU Clear Register    Address offset: 0xA94 */
  __IO uint32_t MC_AHB2ENSETR;             /*!< RCC AHB2 Peripheral Enable For MCU Set Register      Address offset: 0xA98 */
  __IO uint32_t MC_AHB2ENCLRR;             /*!< RCC AHB2 Peripheral Enable For MCU Clear Register    Address offset: 0xA9C */
  __IO uint32_t MC_AHB3ENSETR;             /*!< RCC AHB3 Peripheral Enable For MCU Set Register      Address offset: 0xAA0 */
  __IO uint32_t MC_AHB3ENCLRR;             /*!< RCC AHB3 Peripheral Enable For MCU Clear Register    Address offset: 0xAA4 */
  __IO uint32_t MC_AHB4ENSETR;             /*!< RCC AHB4 Peripheral Enable For MCU Set Register      Address offset: 0xAA8 */
  __IO uint32_t MC_AHB4ENCLRR;             /*!< RCC AHB4 Peripheral Enable For MCU Clear Register    Address offset: 0xAAC */
  __IO uint32_t MC_AXIMENSETR;             /*!< RCC AXI Periph. Enable For MCU Set Register          Address offset: 0xAB0 */
  __IO uint32_t MC_AXIMENCLRR;             /*!< RCC AXI Periph. Enable For MCU Clear Register        Address offset: 0xAB4 */
  __IO uint32_t MC_MLAHBENSETR;            /*!< RCC MLAHB Periph. Enable For MCU Set Register        Address offset: 0xAB8 */
  __IO uint32_t MC_MLAHBENCLRR;            /*!< RCC MLAHB Periph. Enable For MCU Clear Register      Address offset: 0xABC */
       uint32_t RESERVED24[16];            /*!< Reserved, 0xAC0-0xAFC                                Address offset: 0xAC0 */
  __IO uint32_t MP_APB1LPENSETR;           /*!< RCC APB1 Sleep Clock Ena. For MPU Set Register       Address offset: 0xB00 */
  __IO uint32_t MP_APB1LPENCLRR;           /*!< RCC APB1 Sleep Clock Ena. For MPU Clear Register     Address offset: 0xB04 */
  __IO uint32_t MP_APB2LPENSETR;           /*!< RCC APB2 Sleep Clock Ena. For MPU Set Register       Address offset: 0xB08 */
  __IO uint32_t MP_APB2LPENCLRR;           /*!< RCC APB2 Sleep Clock Ena. For MPU Clear Register     Address offset: 0xB0C */
  __IO uint32_t MP_APB3LPENSETR;           /*!< RCC APB3 Sleep Clock Ena. For MPU Set Register       Address offset: 0xB10 */
  __IO uint32_t MP_APB3LPENCLRR;           /*!< RCC APB3 Sleep Clock Ena. For MPU Clear Register     Address offset: 0xB14 */
  __IO uint32_t MP_AHB2LPENSETR;           /*!< RCC AHB2 Sleep Clock Ena. For MPU Set Register       Address offset: 0xB18 */
  __IO uint32_t MP_AHB2LPENCLRR;           /*!< RCC AHB2 Sleep Clock Ena. For MPU Clear Register     Address offset: 0xB1C */
  __IO uint32_t MP_AHB3LPENSETR;           /*!< RCC AHB3 Sleep Clock Ena. For MPU Set Register       Address offset: 0xB20 */
  __IO uint32_t MP_AHB3LPENCLRR;           /*!< RCC AHB3 Sleep Clock Ena. For MPU Clear Register     Address offset: 0xB24 */
  __IO uint32_t MP_AHB4LPENSETR;           /*!< RCC AHB4 Sleep Clock Ena. For MPU Set Register       Address offset: 0xB28 */
  __IO uint32_t MP_AHB4LPENCLRR;           /*!< RCC AHB4 Sleep Clock Ena. For MPU Clear Register     Address offset: 0xB2C */
  __IO uint32_t MP_AXIMLPENSETR;           /*!< RCC AXI Sleep Clock Ena. For MPU Set Register        Address offset: 0xB30 */
  __IO uint32_t MP_AXIMLPENCLRR;           /*!< RCC AXI Sleep Clock Ena. For MPU Clear Register      Address offset: 0xB34 */
  __IO uint32_t MP_MLAHBLPENSETR;          /*!< RCC MLAHB Sleep Clock Ena. For MPU Set Register      Address offset: 0xB38 */
  __IO uint32_t MP_MLAHBLPENCLRR;          /*!< RCC MLAHB Sleep Clock Ena. For MPU Clear Register    Address offset: 0xB3C */
       uint32_t RESERVED25[16];            /*!< Reserved, 0xB40-0xB7C                                Address offset: 0xB40 */
  __IO uint32_t MC_APB1LPENSETR;           /*!< RCC APB1 Sleep Clock Ena. For MCU Set Register       Address offset: 0xB80 */
  __IO uint32_t MC_APB1LPENCLRR;           /*!< RCC APB1 Sleep Clock Ena. For MCU Clear Register     Address offset: 0xB84 */
  __IO uint32_t MC_APB2LPENSETR;           /*!< RCC APB2 Sleep Clock Ena. For MCU Set Register       Address offset: 0xB88 */
  __IO uint32_t MC_APB2LPENCLRR;           /*!< RCC APB2 Sleep Clock Ena. For MCU Clear Register     Address offset: 0xB8C */
  __IO uint32_t MC_APB3LPENSETR;           /*!< RCC APB3 Sleep Clock Ena. For MCU Set Register       Address offset: 0xB90 */
  __IO uint32_t MC_APB3LPENCLRR;           /*!< RCC APB3 Sleep Clock Ena. For MCU Clear Register     Address offset: 0xB94 */
  __IO uint32_t MC_AHB2LPENSETR;           /*!< RCC AHB2 Sleep Clock Ena. For MCU Set Register       Address offset: 0xB98 */
  __IO uint32_t MC_AHB2LPENCLRR;           /*!< RCC AHB2 Sleep Clock Ena. For MCU Clear Register     Address offset: 0xB9C */
  __IO uint32_t MC_AHB3LPENSETR;           /*!< RCC AHB3 Sleep Clock Ena. For MCU Set Register       Address offset: 0xBA0 */
  __IO uint32_t MC_AHB3LPENCLRR;           /*!< RCC AHB3 Sleep Clock Ena. For MCU Clear Register     Address offset: 0xBA4 */
  __IO uint32_t MC_AHB4LPENSETR;           /*!< RCC AHB4 Sleep Clock Ena. For MCU Set Register       Address offset: 0xBA8 */
  __IO uint32_t MC_AHB4LPENCLRR;           /*!< RCC AHB4 Sleep Clock Ena. For MCU Clear Register     Address offset: 0xBAC */
  __IO uint32_t MC_AXIMLPENSETR;           /*!< RCC AXI Sleep Clock Ena. For MCU Set Register        Address offset: 0xBB0 */
  __IO uint32_t MC_AXIMLPENCLRR;           /*!< RCC AXI Sleep Clock Ena. For MCU Clear Register      Address offset: 0xBB4 */
  __IO uint32_t MC_MLAHBLPENSETR;          /*!< RCC MLAHB Sleep Clock Ena. For MCU Set Register      Address offset: 0xBB8 */
  __IO uint32_t MC_MLAHBLPENCLRR;          /*!< RCC MLAHB Sleep Clock Ena. For MCU Clear Register    Address offset: 0xBBC */
       uint32_t RESERVED26[16];            /*!< Reserved, 0xBC0-0xBFC                                Address offset: 0xBC0 */
  __IO uint32_t MC_RSTSCLRR;               /*!< RCC MCU Reset Status Clear Register                  Address offset: 0xC00 */
       uint32_t RESERVED27[4];             /*!< Reserved, 0xC04-0xC10                                Address offset: 0xC04 */
  __IO uint32_t MC_CIER;                   /*!< RCC Clock Source Interrupt Enable Register           Address offset: 0xC14 */
  __IO uint32_t MC_CIFR;                   /*!< RCC Clock Source Interrupt Flag Register             Address offset: 0xC18 */
       uint32_t RESERVED28[246];           /*!< Reserved, 0xC1C-0xFF0                                Address offset: 0xC1C */
  __IO uint32_t VERR;                      /*!< RCC Version register                                 Address offset: 0xFF4 */
  __IO uint32_t IPIDR;                     /*!< RCC ID register                                      Address offset: 0xFF8 */
  __IO uint32_t SIDR;                      /*!< Size ID register                                     Address offset: 0xFFC */
} RCC_TypeDef;

/**
  * @brief Hardware Debug Port
  */

typedef struct
{
  __IO uint32_t HDP_CTRL;                  /*!< HDP Control Register,                                Address offset: 0x00 */
  __IO uint32_t HDP_MUX;                   /*!< HDP Multiplexers Control Register,                   Address offset: 0x04 */
       uint32_t RESERVED0[2];              /*!< Reserved, 0x08-0x0C                                  Address offset: 0x08 */
  __IO uint32_t HDP_VAL;                   /*!< HDP Read Back Value Register,                        Address offset: 0x10 */
  __IO uint32_t HDP_GPOSET;                /*!< HDP General Purpose Output Set Register,             Address offset: 0x14 */
  __IO uint32_t HDP_GPOCLR;                /*!< HDP General Purpose Output Clear Register,           Address offset: 0x18 */
  __IO uint32_t HDP_GPOVAL;                /*!< HDP General Purpose Output Value Register,           Address offset: 0x1C */
       uint32_t RESERVED1[245];            /*!< Reserved, 0x20-0x3F4                                 Address offset: 0x20 */
  __IO uint32_t VERR;                  /*!< HDP Version Register,                                Address offset: 0x3F4 */
  __IO uint32_t IPIDR;                 /*!< HDP IP Identification Register,                      Address offset: 0x3F8 */
  __IO uint32_t SIDR;                  /*!< HDP Size Identification register,                    Address offset: 0x3FC */
} HDP_TypeDef;


/**
  * @brief Boot and Security and OTP Control
  */

typedef struct
{
  __IO uint32_t BSEC_OTP_CONFIG;           /*!< BSEC OTP Configuration,                              Address offset: 0x00 */
  __IO uint32_t BSEC_OTP_CONTROL;          /*!< BSEC OTP Control,                                    Address offset: 0x04 */
  __IO uint32_t BSEC_OTP_WRDATA;           /*!< BSEC OTP Write Data,                                 Address offset: 0x08 */
  __IO uint32_t BSEC_OTP_STATUS;           /*!< BSEC OTP Status,                                     Address offset: 0x0C */
  __IO uint32_t BSEC_OTP_LOCK;             /*!< BSEC OTP Configuration,                              Address offset: 0x10 */
  __IO uint32_t BSEC_DENABLE;              /*!< BSEC Debug Configuration,                            Address offset: 0x14 */
  __IO uint32_t RESERVED0x18;              /*!< Reserved,                                            Address offset: 0x18 */
  __IO uint32_t BSEC_OTP_DISTURBED0;       /*!< BSEC OTP Disturbed Status,                           Address offset: 0x1C */
  __IO uint32_t BSEC_OTP_DISTURBED1;       /*!< BSEC OTP Disturbed Status,                           Address offset: 0x20 */
  __IO uint32_t BSEC_OTP_DISTURBED2;       /*!< BSEC OTP Disturbed Status,                           Address offset: 0x24 */
       uint32_t RESERVED0x28;              /*!< Reserved,                                            Address offset: 0x28 */
       uint32_t RESERVED0x2C;              /*!< Reserved,                                            Address offset: 0x2C */
       uint32_t RESERVED0x30;              /*!< Reserved,                                            Address offset: 0x30 */
  __IO uint32_t BSEC_OTP_ERROR0;           /*!< BSEC OTP Error Status,                               Address offset: 0x34 */
  __IO uint32_t BSEC_OTP_ERROR1;           /*!< BSEC OTP Error Status,                               Address offset: 0x38 */
  __IO uint32_t BSEC_OTP_ERROR2;           /*!< BSEC OTP Error Status,                               Address offset: 0x3C */
       uint32_t RESERVED0x40;              /*!< Reserved,                                            Address offset: 0x40 */
       uint32_t RESERVED0x44;              /*!< Reserved,                                            Address offset: 0x44 */
       uint32_t RESERVED0x48;              /*!< Reserved,                                            Address offset: 0x48 */
  __IO uint32_t BSEC_OTP_WRLOCK0;          /*!< BSEC OTP Lock status,                                Address offset: 0x4C */
  __IO uint32_t BSEC_OTP_WRLOCK1;          /*!< BSEC OTP Lock status,                                Address offset: 0x50 */
  __IO uint32_t BSEC_OTP_WRLOCK2;          /*!< BSEC OTP Lock status,                                Address offset: 0x54 */
       uint32_t RESERVED0x58;              /*!< Reserved,                                            Address offset: 0x58 */
       uint32_t RESERVED0x5C;              /*!< Reserved,                                            Address offset: 0x5C */
       uint32_t RESERVED0x60;              /*!< Reserved,                                            Address offset: 0x60 */
  __IO uint32_t BSEC_OTP_SPLOCK0;          /*!< BSEC OTP prg lock under ctrl by stick bits,          Address offset: 0x64 */
  __IO uint32_t BSEC_OTP_SPLOCK1;          /*!< BSEC OTP prg lock under ctrl by stick bits,          Address offset: 0x68 */
  __IO uint32_t BSEC_OTP_SPLOCK2;          /*!< BSEC OTP prg lock under ctrl by stick bits,          Address offset: 0x6C */
       uint32_t RESERVED0x70;              /*!< Reserved,                                            Address offset: 0x70 */
       uint32_t RESERVED0x74;              /*!< Reserved,                                            Address offset: 0x74 */
       uint32_t RESERVED0x78;              /*!< Reserved,                                            Address offset: 0x78 */
  __IO uint32_t BSEC_OTP_SWLOCK0;          /*!< BSEC OTP Shadow Write Lck under ctrl by sticky bits, Address offset: 0x7C */
  __IO uint32_t BSEC_OTP_SWLOCK1;          /*!< BSEC OTP Shadow Write Lck under ctrl by sticky bits, Address offset: 0x80 */
  __IO uint32_t BSEC_OTP_SWLOCK2;          /*!< BSEC OTP Shadow Write Lck under ctrl by sticky bits, Address offset: 0x84 */
       uint32_t RESERVED0x88;              /*!< Reserved,                                            Address offset: 0x88 */
       uint32_t RESERVED0x8C;              /*!< Reserved,                                            Address offset: 0x8C */
       uint32_t RESERVED0x90;              /*!< Reserved,                                            Address offset: 0x90 */
  __IO uint32_t BSEC_OTP_SRLOCK0;          /*!< BSEC OTP Shadow read lock under ctrl by sticky bits, Address offset: 0x94 */
  __IO uint32_t BSEC_OTP_SRLOCK1;          /*!< BSEC OTP Shadow read lock under ctrl by sticky bits, Address offset: 0x98 */
  __IO uint32_t BSEC_OTP_SRLOCK2;          /*!< BSEC OTP Shadow read lock under ctrl by sticky bits, Address offset: 0x9C */
       uint32_t RESERVED0xA0;              /*!< Reserved,                                            Address offset: 0xA0 */
       uint32_t RESERVED0xA4;              /*!< Reserved,                                            Address offset: 0xA4 */
       uint32_t RESERVED0xA8;              /*!< Reserved,                                            Address offset: 0xA8 */
  __IO uint32_t BSEC_JTAGIN;               /*!< BSEC JTAG Input,                                     Address offset: 0xAC */
  __IO uint32_t BSEC_JTAGOUT;              /*!< BSEC JTAG Output,                                    Address offset: 0xB0 */
  __IO uint32_t BSEC_SCRATCH;              /*!< BSEC SCRATCH,                                        Address offset: 0xB4 */
       uint32_t RESERVED0xB8[82];          /*!< Reserved, 0x0B8-0x200                                Address offset: 0xB8 */
  __IO uint32_t BSEC_OTP_DATA[96];         /*!< BSEC Shadow Registers,                               Address offset: 0x200 */
       uint32_t RESERVED0x380[796];        /*!< Reserved, 0x0380-0xFF0                               Address offset: 0x380 */
  __IO uint32_t HWCFGR;                    /*!< BSEC IP HW Configuration Register,                   Address offset: 0xFF0 */
  __IO uint32_t VERR;                      /*!< BSEC IP version Register,                            Address offset: 0xFF4 */
  __IO uint32_t IPIDR;                     /*!< BSEC ID Register,                                    Address offset: 0xFF8 */
  __IO uint32_t SIDR;                      /*!< BSEC SID Register,                                   Address offset: 0xFFC */
} BSEC_TypeDef;


/**
  * @brief RTC Specific device feature definitions
  */
#define RTC_BACKUP_NB       32u /* Backup registers implemented */
#define RTC_TAMP_NB         3u  /* External tamper events (input pins) supported */

/**
  * @brief Real-Time Clock
  */

typedef struct
{
  __IO uint32_t TR;             /*!< RTC time register,                                         Address offset: 0x00 */
  __IO uint32_t DR;             /*!< RTC date register,                                         Address offset: 0x04 */
  __IO uint32_t SSR;            /*!< RTC sub-second register,                                   Address offset: 0x08 */
  __IO uint32_t ICSR;           /*!< RTC initialization control and status register,            Address offset: 0x0C */
  __IO uint32_t PRER;           /*!< RTC prescaler register,                                    Address offset: 0x10 */
  __IO uint32_t WUTR;           /*!< RTC wakeup timer register,                                 Address offset: 0x14 */
  __IO uint32_t CR;             /*!< RTC control register,                                      Address offset: 0x18 */
       uint32_t RESERVED;       /*!< Reserved                                                                        */
  __IO uint32_t SMCR;           /*!< RTC secure mode control register,                          Address offset: 0x20 */
  __IO uint32_t WPR;            /*!< RTC write protection register,                             Address offset: 0x24 */
  __IO uint32_t CALR;           /*!< RTC calibration register,                                  Address offset: 0x28 */
  __IO uint32_t SHIFTR;         /*!< RTC shift control register,                                Address offset: 0x2C */
  __IO uint32_t TSTR;           /*!< RTC time stamp time register,                              Address offset: 0x30 */
  __IO uint32_t TSDR;           /*!< RTC time stamp date register,                              Address offset: 0x34 */
  __IO uint32_t TSSSR;           /*!< RTC time stamp sub second register,                        Address offset: 0x38 */
       uint32_t RESERVED1;      /*!< Reserved                                                                        */
  __IO uint32_t ALRMAR;         /*!< RTC alarm A register,                                      Address offset: 0x40 */
  __IO uint32_t ALRMASSR;       /*!< RTC alarm A sub second register,                           Address offset: 0x44 */
  __IO uint32_t ALRMBR;         /*!< RTC alarm B register,                                      Address offset: 0x48 */
  __IO uint32_t ALRMBSSR;       /*!< RTC alarm B sub second register,                           Address offset: 0x4C */
  __IO uint32_t SR;             /*!< RTC status register,                                       Address offset: 0x50 */
  __IO uint32_t MISR;           /*!< RTC masked interrupt status register,                      Address offset: 0x54 */
  __IO uint32_t SMISR;          /*!< RTC secure masked interrupt status register,               Address offset: 0x58 */
  __IO uint32_t SCR;            /*!< RTC status clear register,                                 Address offset: 0x5C */
  __IO uint32_t CFGR;           /*!< RTC Configuration register,                               Address offset: 0x60 */
       uint32_t RESERVED2[227]; /*!< Reserved                                                                        */
  __IO uint32_t HWCFGR;         /*!< RTC hardware configuration register,                       Address offset: 0x3F0 */
  __IO uint32_t VERR;            /*!< RTC version register,                                     Address offset: 0x3F4 */
  __IO uint32_t IPIDR;          /*!< RTC identification register,                               Address offset: 0x3F8 */
  __IO uint32_t SIDR;           /*!< RTC size identification register,                          Address offset: 0x3FC */
} RTC_TypeDef;


/**
  * @brief Tamper and Backup registers
  */
typedef struct
{
  __IO uint32_t CR1;           /*!< TAMP tamper control register 1,                         Address offset: 0x00 */
  __IO uint32_t CR2;           /*!< TAMP tamper control register 2,                         Address offset: 0x04 */
       uint32_t RESERVED;      /*!< Reserved                                                                     */
  __IO uint32_t FLTCR;         /*!< TAMP filter control register,                           Address offset: 0x0C */
  __IO uint32_t ATCR1;          /*!< TAMP active tamper control register,                   Address offset: 0x10 */
  __IO uint32_t ATSEEDR;       /*!< TAMP active tamper seed register,                       Address offset: 0x14 */
  __IO uint32_t ATOR;          /*!< TAMP active tamper output register,                     Address offset: 0x18 */
       uint32_t RESERVED1;     /*!< Reserved                                                                     */
  __IO uint32_t SMCR;          /*!< TAMP secure mode control register,                      Address offset: 0x20 */
       uint32_t RESERVED2[2];  /*!< Reserved, 0x024 - 0x028                                                      */
  __IO uint32_t IER;           /*!< TAMP interrupt enable register,                         Address offset: 0x2C */
  __IO uint32_t SR;            /*!< TAMP status register,                                   Address offset: 0x30 */
  __IO uint32_t MISR;          /*!< TAMP masked interrupt status register,                  Address offset: 0x34 */
  __IO uint32_t SMISR;         /*!< TAMP secure masked interrupt status register,           Address offset: 0x38 */
  __IO uint32_t SCR;           /*!< TAMP status clear register,                             Address offset: 0x3C */
  __IO uint32_t COUNTR;        /*!< TAMP monotonic counter register,                        Address offset: 0x40 */
  uint32_t RESERVED3[3];       /*!< Reserved, 0x044 - 0x04C                                                      */
  __IO uint32_t CFGR;          /*!< TAMP Configuration register,                            Address offset: 0x50 */
  uint32_t RESERVED4[43];      /*!< Reserved, 0x054 - 0x0FC                                                      */
  __IO uint32_t BKP0R;         /*!< TAMP backup register 0,                                 Address offset: 0x100 */
  __IO uint32_t BKP1R;         /*!< TAMP backup register 1,                                 Address offset: 0x104 */
  __IO uint32_t BKP2R;         /*!< TAMP backup register 2,                                 Address offset: 0x108 */
  __IO uint32_t BKP3R;         /*!< TAMP backup register 3,                                 Address offset: 0x10C */
  __IO uint32_t BKP4R;         /*!< TAMP backup register 4,                                 Address offset: 0x110 */
  __IO uint32_t BKP5R;         /*!< TAMP backup register 5,                                 Address offset: 0x114 */
  __IO uint32_t BKP6R;         /*!< TAMP backup register 6,                                 Address offset: 0x118 */
  __IO uint32_t BKP7R;         /*!< TAMP backup register 7,                                 Address offset: 0x11C */
  __IO uint32_t BKP8R;         /*!< TAMP backup register 8,                                 Address offset: 0x120 */
  __IO uint32_t BKP9R;         /*!< TAMP backup register 9,                                 Address offset: 0x124 */
  __IO uint32_t BKP10R;        /*!< TAMP backup register 10,                                Address offset: 0x128 */
  __IO uint32_t BKP11R;        /*!< TAMP backup register 11,                                Address offset: 0x12C */
  __IO uint32_t BKP12R;        /*!< TAMP backup register 12,                                Address offset: 0x130 */
  __IO uint32_t BKP13R;        /*!< TAMP backup register 13,                                Address offset: 0x134 */
  __IO uint32_t BKP14R;        /*!< TAMP backup register 14,                                Address offset: 0x138 */
  __IO uint32_t BKP15R;        /*!< TAMP backup register 15,                                Address offset: 0x13C */
  __IO uint32_t BKP16R;        /*!< TAMP backup register 16,                                Address offset: 0x140 */
  __IO uint32_t BKP17R;        /*!< TAMP backup register 17,                                Address offset: 0x144 */
  __IO uint32_t BKP18R;        /*!< TAMP backup register 18,                                Address offset: 0x148 */
  __IO uint32_t BKP19R;        /*!< TAMP backup register 19,                                Address offset: 0x14C */
  __IO uint32_t BKP20R;        /*!< TAMP backup register 20,                                Address offset: 0x150 */
  __IO uint32_t BKP21R;        /*!< TAMP backup register 21,                                Address offset: 0x154 */
  __IO uint32_t BKP22R;        /*!< TAMP backup register 22,                                Address offset: 0x158 */
  __IO uint32_t BKP23R;        /*!< TAMP backup register 23,                                Address offset: 0x15C */
  __IO uint32_t BKP24R;        /*!< TAMP backup register 24,                                Address offset: 0x160 */
  __IO uint32_t BKP25R;        /*!< TAMP backup register 25,                                Address offset: 0x164 */
  __IO uint32_t BKP26R;        /*!< TAMP backup register 26,                                Address offset: 0x168 */
  __IO uint32_t BKP27R;        /*!< TAMP backup register 27,                                Address offset: 0x16C */
  __IO uint32_t BKP28R;        /*!< TAMP backup register 28,                                Address offset: 0x170 */
  __IO uint32_t BKP29R;        /*!< TAMP backup register 29,                                Address offset: 0x174 */
  __IO uint32_t BKP30R;        /*!< TAMP backup register 30,                                Address offset: 0x178 */
  __IO uint32_t BKP31R;        /*!< TAMP backup register 31,                                Address offset: 0x17C */
       uint32_t RESERVED5[155]; /*!< Reserved, 0x180 - 0x3E8                                                      */
  __IO uint32_t HWCFGR2;        /*!< TAMP hardware configuration register,                  Address offset: 0x3EC */
  __IO uint32_t HWCFGR1;        /*!< TAMP hardware configuration register,                  Address offset: 0x3F0 */
  __IO uint32_t VERR;           /*!< TAMP version register,                                 Address offset: 0x3F4 */
  __IO uint32_t IPIDR;          /*!< TAMP identification register,                          Address offset: 0x3F8 */
  __IO uint32_t SIDR;           /*!< TAMP size identification register,                     Address offset: 0x3FC */
} TAMP_TypeDef;


/**
  * @brief Serial Audio Interface
  */

typedef struct
{
  __IO uint32_t GCR;           /*!< SAI global configuration register, Address offset: 0x00  */
  uint32_t      RESERVED0[16]; /*!< Reserved, 0x04 - 0x43                                    */
  __IO uint32_t PDMCR;         /*!< SAI PDM control register,          Address offset: 0x44  */
  __IO uint32_t PDMDLY;        /*!< SAI PDM delay register,            Address offset: 0x48  */
  uint32_t      RESERVED1[233]; /*!< Reserved, 0x4C - 0x3EC                                  */
  __IO uint32_t HWCFGR;        /*!< SAI HW Configuration register,     Address offset: 0x3F0 */
  __IO uint32_t VERR;          /*!< SAI PVersion register,             Address offset: 0x3F4 */
  __IO uint32_t IPIDR;           /*!< SAI Identification register,       Address offset: 0x3F8 */
  __IO uint32_t SIDR;          /*!< SAI Size Identification register,  Address offset: 0x3FC */
} SAI_TypeDef;

typedef struct
{
  __IO uint32_t CR1;      /*!< SAI block x configuration register 1,     Address offset: 0x04 */
  __IO uint32_t CR2;      /*!< SAI block x configuration register 2,     Address offset: 0x08 */
  __IO uint32_t FRCR;     /*!< SAI block x frame configuration register, Address offset: 0x0C */
  __IO uint32_t SLOTR;    /*!< SAI block x slot register,                Address offset: 0x10 */
  __IO uint32_t IMR;      /*!< SAI block x interrupt mask register,       Address offset: 0x14 */
  __IO uint32_t SR;       /*!< SAI block x status register,              Address offset: 0x18 */
  __IO uint32_t CLRFR;    /*!< SAI block x clear flag register,          Address offset: 0x1C */
  __IO uint32_t DR;       /*!< SAI block x data register,                Address offset: 0x20 */
} SAI_Block_TypeDef;



/**
  * @brief  Process Monitor Block
  */

typedef struct
{
  uint32_t Reserved;            /*!< Reserved, Address offset: 0x00 */
  __IO uint32_t SENS_CTRL;      /*!< PMB Sensor control,         Address offset: 0x04 */
  __IO uint32_t REF_COUNTER;    /*!< PMB Reference counter,      Address offset: 0x08 */
  __IO uint32_t SENSOR_STATUS;  /*!< PMB Sensor Status,          Address offset: 0x0C */
}PMB_TypeDef;


/**
  * @brief SPDIF-RX Interface
  */

typedef struct
{
  __IO uint32_t   CR;           /*!< Control register,                      Address offset: 0x00 */
  __IO uint32_t   IMR;          /*!< Interrupt mask register,               Address offset: 0x04 */
  __IO uint32_t   SR;           /*!< Status register,                       Address offset: 0x08 */
  __IO uint32_t   IFCR;         /*!< Interrupt Flag Clear register,         Address offset: 0x0C */
  __IO uint32_t   DR;           /*!< Data input register,                   Address offset: 0x10 */
  __IO uint32_t   CSR;          /*!< Channel Status register,               Address offset: 0x14 */
  __IO uint32_t   DIR;          /*!< Debug Information register,            Address offset: 0x18 */
  uint32_t        RESERVED2[246];   /*!< Reserved,                                0x1C   - 0x3F0 */
  __IO uint32_t   VERR;         /*!< SPDIFRX version register,             Address offset: 0x3F4 */
  __IO uint32_t   IPIDR;          /*!< SPDIFRX Identificationn register,     Address offset: 0x3F8 */
  __IO uint32_t   SIDR;         /*!< SPDIFRX Size Identification register, Address offset: 0x3FC */
} SPDIFRX_TypeDef;


/**
  * @brief Secure digital input/output Interface
  */

typedef struct
{
  __IO uint32_t POWER;          /*!< SDMMC power control register,             Address offset: 0x00 */
  __IO uint32_t CLKCR;          /*!< SDMMC clock control register,             Address offset: 0x04 */
  __IO uint32_t ARG;            /*!< SDMMC argument register,                  Address offset: 0x08 */
  __IO uint32_t CMD;            /*!< SDMMC command register,                   Address offset: 0x0C */
  __I uint32_t  RESPCMD;        /*!< SDMMC command response register,          Address offset: 0x10 */
  __I uint32_t  RESP1;          /*!< SDMMC response 1 register,                Address offset: 0x14 */
  __I uint32_t  RESP2;          /*!< SDMMC response 2 register,                Address offset: 0x18 */
  __I uint32_t  RESP3;          /*!< SDMMC response 3 register,                Address offset: 0x1C */
  __I uint32_t  RESP4;          /*!< SDMMC response 4 register,                Address offset: 0x20 */
  __IO uint32_t DTIMER;         /*!< SDMMC data timer register,                Address offset: 0x24 */
  __IO uint32_t DLEN;           /*!< SDMMC data length register,               Address offset: 0x28 */
  __IO uint32_t DCTRL;          /*!< SDMMC data control register,              Address offset: 0x2C */
  __I uint32_t  DCOUNT;         /*!< SDMMC data counter register,              Address offset: 0x30 */
  __I uint32_t  STA;            /*!< SDMMC status register,                    Address offset: 0x34 */
  __IO uint32_t ICR;            /*!< SDMMC interrupt clear register,           Address offset: 0x38 */
  __IO uint32_t MASK;           /*!< SDMMC mask register,                      Address offset: 0x3C */
  __IO uint32_t ACKTIME;        /*!< SDMMC Acknowledgement timer register,     Address offset: 0x40 */
  uint32_t      RESERVED0[3];   /*!< Reserved, 0x44 - 0x4C - 0x4C                                   */
  __IO uint32_t IDMACTRL;       /*!< SDMMC DMA control register,               Address offset: 0x50 */
  __IO uint32_t IDMABSIZE;      /*!< SDMMC DMA buffer size register,           Address offset: 0x54 */
  __IO uint32_t IDMABASE0;      /*!< SDMMC DMA buffer 0 base address register, Address offset: 0x58 */
  __IO uint32_t IDMABASE1;      /*!< SDMMC DMA buffer 1 base address register, Address offset: 0x5C */
  uint32_t      RESERVED1[1];   /*!< Reserved, 0x60                                            */
  __IO uint32_t IDMALAR;        /*!< SDMMC DMA linked list address register,   Address offset: 0x64 */
  __IO uint32_t IDMABAR;        /*!< SDMMC DMA linked list memory base register, Address offset: 0x68 */
  uint32_t      RESERVED2[5];   /*!< Reserved, 0x6C-0x7C                                            */
  __IO uint32_t FIFO;           /*!< SDMMC data FIFO register,                Address offset: 0x80 - 0xBC */
  uint32_t      RESERVED3[220]; /*!< Reserved, 0xBC-0x3F4                                           */
  __IO uint32_t VERR;           /*!< SDMMC version register,                  Address offset: 0x3F4 */
  __IO uint32_t IPIDR;           /*!< SDMMC identification register,          Address offset: 0x3F8 */
  __IO uint32_t SIDR;           /*!< SDMMCsize ID register,                   Address offset: 0x3FC */
} SDMMC_TypeDef;


/**
  * @brief Delay Block DLYB
  */

typedef struct
{
  __IO uint32_t CR;          /*!< DELAY BLOCK control register,          Address offset: 0x00 */
  __IO uint32_t CFGR;        /*!< DELAY BLOCK configuration register,    Address offset: 0x04 */
  uint32_t  Reserved[249];   /* Reserved                         Address offset: 0x08 - 0x3F0 */
  __IO uint32_t VERR;        /*!< DELAY BLOCK Version register,         Address offset: 0x3F4 */
  __IO uint32_t IPIDR;       /*!< DELAY BLOCK Identification register,  Address offset: 0x3F8 */
  __IO uint32_t SIDR;        /*!< DELAY BLOCK Size ID register,         Address offset: 0x3FC */
} DLYB_TypeDef;

/**
  * @brief HW Semaphore HSEM
  */

typedef struct
{
  __IO uint32_t R[32];      /*!< 2-step write lock and read back registers,     Address offset: 00h-7Ch  */
  __IO uint32_t RLR[32];    /*!< 1-step read lock registers,                    Address offset: 80h-FCh  */
  __IO uint32_t C1IER;      /*!< HSEM Interrupt 0 enable register ,             Address offset: 100h     */
  __IO uint32_t C1ICR;      /*!< HSEM Interrupt 0 clear register ,              Address offset: 104h     */
  __IO uint32_t C1ISR;      /*!< HSEM Interrupt 0 Status register ,             Address offset: 108h     */
  __IO uint32_t C1MISR;     /*!< HSEM Interrupt 0 Masked Status register ,      Address offset: 10Ch     */
  __IO uint32_t C2IER;      /*!< HSEM Interrupt 1 enable register ,             Address offset: 110h     */
  __IO uint32_t C2ICR;      /*!< HSEM Interrupt 1 clear register ,              Address offset: 114h     */
  __IO uint32_t C2ISR;      /*!< HSEM Interrupt 1 Status register ,             Address offset: 118h     */
  __IO uint32_t C2MISR;     /*!< HSEM Interrupt 1 Masked Status register ,      Address offset: 11Ch     */
   uint32_t  Reserved[8];        /* Reserved                                         Address offset: 120h-13Ch*/
  __IO uint32_t CR;         /*!< HSEM Semaphore clear register ,                Address offset: 140h      */
  __IO uint32_t KEYR;       /*!< HSEM Semaphore clear key register ,            Address offset: 144h      */
  uint32_t  Reserved1[169];      /* Reserved                                         Address offset: 148h-3E8h */
  __IO uint32_t HWCFGR2;    /*!< HSEM Hardware Configuration Register 2 ,       Address offset: 3ECh      */
  __IO uint32_t HWCFGR1;    /*!< HSEM Hardware Configuration Register 1 ,       Address offset: 3F0h      */
  __IO uint32_t VERR;       /*!< HSEM IP Version Register ,                     Address offset: 3F4h      */
  __IO uint32_t IPIDR;      /*!< HSEM IP Identification Register ,              Address offset: 3F8h      */
  __IO uint32_t SIDR;      /*!< HSEM Size Identification Register ,             Address offset: 3FCh      */
} HSEM_TypeDef;

typedef struct
{
  __IO uint32_t IER;        /*!< HSEM interrupt enable register ,                Address offset:   0h     */
  __IO uint32_t ICR;        /*!< HSEM interrupt clear register ,                 Address offset:   4h     */
  __IO uint32_t ISR;        /*!< HSEM interrupt status register ,                Address offset:   8h     */
  __IO uint32_t MISR;       /*!< HSEM masked interrupt status register ,         Address offset:   Ch     */
} HSEM_Common_TypeDef;

/**
  * @brief Serial Peripheral Interface
  */

typedef struct
{
  __IO uint32_t CR1;          /*!< SPI Control register 1,                             Address offset: 0x00 */
  __IO uint32_t CR2;          /*!< SPI Control register 2,                             Address offset: 0x04 */
  __IO uint32_t CFG1;         /*!< SPI Status register,                                Address offset: 0x08 */
  __IO uint32_t CFG2;         /*!< SPI Status register,                                Address offset: 0x0C */
  __IO uint32_t IER;          /*!< SPI data register,                                  Address offset: 0x10 */
  __IO uint32_t SR;           /*!< SPI data register,                                  Address offset: 0x14 */
  __IO uint32_t IFCR;         /*!< SPI data register,                                  Address offset: 0x18 */
  uint32_t      RESERVED0;    /*!< SPI data register,                                  Address offset: 0x1C */
  __IO uint32_t TXDR;         /*!< SPI data register,                                  Address offset: 0x20 */
  uint32_t      RESERVED1[3]; /*!< Reserved, 0x24-0x2C                                                      */
  __IO uint32_t RXDR;         /*!< SPI data register,                                  Address offset: 0x30 */
  uint32_t      RESERVED2[3]; /*!< Reserved, 0x34-0x3C                                                      */
  __IO uint32_t CRCPOLY;     /*!< SPI data register,                                   Address offset: 0x40 */
  __IO uint32_t TXCRC;       /*!< SPI data register,                                   Address offset: 0x44 */
  __IO uint32_t RXCRC;       /*!< SPI data register,                                   Address offset: 0x48 */
  __IO uint32_t UDRDR;       /*!< SPI data register,                                   Address offset: 0x4C */
  __IO uint32_t I2SCFGR;     /*!< SPI data register,                                   Address offset: 0x50 */
  uint32_t      RESERVED3[231]; /*!< Reserved, 0x54-0x3EC                                                   */
  __IO uint32_t HWCFGR;       /*!< SPI HW Configuration register,                     Address offset: 0x3F0 */
  __IO uint32_t VERR;         /*!< SPI Version register,                              Address offset: 0x3F4 */
  __IO uint32_t IPIDR;        /*!< SPI identification register,                       Address offset: 0x3F8 */
  __IO uint32_t SIDR;         /*!< SPI Size Identification register,                  Address offset: 0x3FC */
} SPI_TypeDef;

/**
  * @brief QUAD Serial Peripheral Interface
  */

typedef struct
{
  __IO uint32_t CR;       /*!< QUADSPI Control register,                           Address offset: 0x00 */
  __IO uint32_t DCR;      /*!< QUADSPI Device Configuration register,              Address offset: 0x04 */
  __IO uint32_t SR;       /*!< QUADSPI Status register,                            Address offset: 0x08 */
  __IO uint32_t FCR;      /*!< QUADSPI Flag Clear register,                        Address offset: 0x0C */
  __IO uint32_t DLR;      /*!< QUADSPI Data Length register,                       Address offset: 0x10 */
  __IO uint32_t CCR;      /*!< QUADSPI Communication Configuration register,       Address offset: 0x14 */
  __IO uint32_t AR;       /*!< QUADSPI Address register,                           Address offset: 0x18 */
  __IO uint32_t ABR;      /*!< QUADSPI Alternate Bytes register,                   Address offset: 0x1C */
  __IO uint32_t DR;       /*!< QUADSPI Data register,                              Address offset: 0x20 */
  __IO uint32_t PSMKR;    /*!< QUADSPI Polling Status Mask register,               Address offset: 0x24 */
  __IO uint32_t PSMAR;    /*!< QUADSPI Polling Status Match register,              Address offset: 0x28 */
  __IO uint32_t PIR;      /*!< QUADSPI Polling Interval register,                  Address offset: 0x2C */
  __IO uint32_t LPTR;     /*!< QUADSPI Low Power Timeout register,                 Address offset: 0x30 */
  uint32_t      RESERVED[239]; /*!< Reserved, 0x34-0x3EC                                                */
  __IO uint32_t HWCFGR;   /*!< QUADSPI HW configuration register,                  Address offset: 0x3F0*/
  __IO uint32_t VERR;     /*!< QUADSPI version register,                           Address offset: 0x3F4*/
  __IO uint32_t IPIDR;    /*!< QUADSPI dentification register,                     Address offset: 0x3F8*/
  __IO uint32_t SIDR;    /*!< QUADSPI size identification register,                Address offset: 0x3FC*/
} QUADSPI_TypeDef;

/**
  * @brief Temperature Sensor
  */
/* TMPSENS has been renamed in DTS*/
typedef struct
{
  __IO uint32_t CFGR1;    /*!< Temperature Sensor Configuration Register 1,         Address offset: 0x00 */
  uint32_t RESERVED0;     /*!< Reserved,                                            Address offset: 0x04 */
  __IO uint32_t T0VALR1;  /*!< Temperature sensor T0 Value Register 1,              Address offset: 0x08 */
  uint32_t RESERVED1;     /*!< Reserved,                                            Address offset: 0x0C */
  __IO uint32_t RAMPVALR; /*!< Temperature sensor Ramp Value Register,              Address offset: 0x10 */
  __IO uint32_t ITR1;     /*!< Temperature sensor Interrupt Threshold Register 1,   Address offset: 0x14 */
  uint32_t RESERVED2;     /*!< Reserved,                                            Address offset: 0x18 */
  __IO uint32_t DR;       /*!< Temperature sensor Data Register,                    Address offset: 0x1C */
  __IO uint32_t SR;       /*!< Temperature sensor Status Register,                  Address offset: 0x20 */
  __IO uint32_t ITENR;    /*!< Temperature sensor Interrupt Enable Register,        Address offset: 0x24 */
  __IO uint32_t ICIFR;    /*!< Temperature sensor clear interrupt flag register,    Address offset: 0x28 */
  __IO uint32_t OR;       /*!< Temperature sensor option register,                  Address offset: 0x2C */
}DTS_TypeDef;

/**
  * @brief TIM
  */

typedef struct
{
  __IO uint32_t CR1;         /*!< TIM control register 1,                   Address offset: 0x00 */
  __IO uint32_t CR2;         /*!< TIM control register 2,                   Address offset: 0x04 */
  __IO uint32_t SMCR;        /*!< TIM slave mode control register,          Address offset: 0x08 */
  __IO uint32_t DIER;        /*!< TIM DMA/interrupt enable register,        Address offset: 0x0C */
  __IO uint32_t SR;          /*!< TIM status register,                      Address offset: 0x10 */
  __IO uint32_t EGR;         /*!< TIM event generation register,            Address offset: 0x14 */
  __IO uint32_t CCMR1;       /*!< TIM capture/compare mode register 1,      Address offset: 0x18 */
  __IO uint32_t CCMR2;       /*!< TIM capture/compare mode register 2,      Address offset: 0x1C */
  __IO uint32_t CCER;        /*!< TIM capture/compare enable register,      Address offset: 0x20 */
  __IO uint32_t CNT;         /*!< TIM counter register,                     Address offset: 0x24 */
  __IO uint32_t PSC;         /*!< TIM prescaler,                            Address offset: 0x28 */
  __IO uint32_t ARR;         /*!< TIM auto-reload register,                 Address offset: 0x2C */
  __IO uint32_t RCR;         /*!< TIM repetition counter register,          Address offset: 0x30 */
  __IO uint32_t CCR1;        /*!< TIM capture/compare register 1,           Address offset: 0x34 */
  __IO uint32_t CCR2;        /*!< TIM capture/compare register 2,           Address offset: 0x38 */
  __IO uint32_t CCR3;        /*!< TIM capture/compare register 3,           Address offset: 0x3C */
  __IO uint32_t CCR4;        /*!< TIM capture/compare register 4,           Address offset: 0x40 */
  __IO uint32_t BDTR;        /*!< TIM break and dead-time register,         Address offset: 0x44 */
  __IO uint32_t DCR;         /*!< TIM DMA control register,                 Address offset: 0x48 */
  __IO uint32_t DMAR;        /*!< TIM DMA address for full transfer,        Address offset: 0x4C */
  uint32_t      RESERVED0;   /*!< Reserved,                                 Address offset: 0x50 */
  __IO uint32_t CCMR3;       /*!< TIM capture/compare mode register 3,      Address offset: 0x54 */
  __IO uint32_t CCR5;        /*!< TIM capture/compare register5,            Address offset: 0x58 */
  __IO uint32_t CCR6;        /*!< TIM capture/compare register6,            Address offset: 0x5C */
  __IO uint32_t AF1;         /*!< TIM alternate function option register 1, Address offset: 0x60 */
  __IO uint32_t AF2;         /*!< TIM alternate function option register 2, Address offset: 0x64 */
  __IO uint32_t TISEL;       /*!< TIM Input Selection register,             Address offset: 0x68 */
  uint32_t  RESERVED1[226];  /*!< Reserved,                                 Address offset: 0x6C-0x3F0 */
  __IO uint32_t VERR;        /*!< TIM version register,                     Address offset: 0x3F4 */
  __IO uint32_t IPIDR;       /*!< TIM Identification register,              Address offset: 0x3F8 */
  __IO uint32_t SIDR;        /*!< TIM Size Identification register,         Address offset: 0x3FC */
} TIM_TypeDef;

/**
  * @brief LPTIMIMER
  */
typedef struct
{
  __IO uint32_t ISR;      /*!< LPTIM Interrupt and Status register,                Address offset: 0x00 */
  __IO uint32_t ICR;      /*!< LPTIM Interrupt Clear register,                     Address offset: 0x04 */
  __IO uint32_t IER;      /*!< LPTIM Interrupt Enable register,                    Address offset: 0x08 */
  __IO uint32_t CFGR;     /*!< LPTIM Configuration register,                       Address offset: 0x0C */
  __IO uint32_t CR;       /*!< LPTIM Control register,                             Address offset: 0x10 */
  __IO uint32_t CMP;      /*!< LPTIM Compare register,                             Address offset: 0x14 */
  __IO uint32_t ARR;      /*!< LPTIM Autoreload register,                          Address offset: 0x18 */
  __IO uint32_t CNT;      /*!< LPTIM Counter register,                             Address offset: 0x1C */
  uint16_t  RESERVED1;    /*!< Reserved, 0x20                                                 */
  __IO uint32_t CFGR2;    /*!< LPTIM Option register,                              Address offset: 0x24 */
  uint32_t  RESERVED2[242];    /*!< Reserved, 0x28-0x3EC                                                */
  __IO uint32_t HWCFGR;   /*!< LPTIM HW configuration register,                    Address offset: 0x3F0 */
  __IO uint32_t VERR;     /*!< LPTIM version register,                             Address offset: 0x3F4 */
  __IO uint32_t PIDR;     /*!< LPTIM Identification register,                      Address offset: 0x3F8 */
  __IO uint32_t SIDR;     /*!< LPTIM Size Identification register,                 Address offset: 0x3FC */
} LPTIM_TypeDef;

/**
  * @brief Comparator
  */
typedef struct
{
  __IO uint32_t SR;        /*!< Comparator status register,                    Address offset: 0x00 */
  __IO uint32_t ICFR;      /*!< Comparator interrupt clear flag register,      Address offset: 0x04 */
  __IO uint32_t OR;        /*!< Comparator option register,                    Address offset: 0x08 */
} COMPOPT_TypeDef;

typedef struct
{
  __IO uint32_t CFGR;      /*!< Comparator configuration register  ,           Address offset: 0x00 */
} COMP_TypeDef;

typedef struct
{
  __IO uint32_t CFGR;       /*!< COMP control and status register, used for bits common to several COMP instances, Address offset: 0x00 */
} COMP_Common_TypeDef;
/**
  * @brief Universal Synchronous Asynchronous Receiver Transmitter
  */

typedef struct
{
  __IO uint32_t CR1;    /*!< USART Control register 1,                 Address offset: 0x00 */
  __IO uint32_t CR2;    /*!< USART Control register 2,                 Address offset: 0x04 */
  __IO uint32_t CR3;    /*!< USART Control register 3,                 Address offset: 0x08 */
  __IO uint32_t BRR;    /*!< USART Baud rate register,                 Address offset: 0x0C */
  __IO uint16_t GTPR;   /*!< USART Guard time and prescaler register,  Address offset: 0x10 */
  uint16_t  RESERVED2;  /*!< Reserved, 0x12                                                 */
  __IO uint32_t RTOR;   /*!< USART Receiver Time Out register,         Address offset: 0x14 */
  __IO uint16_t RQR;    /*!< USART Request register,                   Address offset: 0x18 */
  uint16_t  RESERVED3;  /*!< Reserved, 0x1A                                                 */
  __IO uint32_t ISR;    /*!< USART Interrupt and status register,      Address offset: 0x1C */
  __IO uint32_t ICR;    /*!< USART Interrupt flag Clear register,      Address offset: 0x20 */
  __IO uint16_t RDR;    /*!< USART Receive Data register,              Address offset: 0x24 */
  uint16_t  RESERVED4;  /*!< Reserved, 0x26                                                 */
  __IO uint16_t TDR;    /*!< USART Transmit Data register,             Address offset: 0x28 */
  uint16_t  RESERVED5;  /*!< Reserved, 0x2A                                                 */
  __IO uint32_t PRESC;  /*!< USART clock Prescaler register,           Address offset: 0x2C */
  uint32_t  RESERVED6[239];  /*!< Reserved,                                    0x30 - 0x3E8 */
  __IO uint32_t HWCFGR2;  /*!< USART Configuration2 register,          Address offset: 0x3EC */
  __IO uint32_t HWCFGR1;  /*!< USART Configuration1 register,          Address offset: 0x3F0 */
  __IO uint32_t VERR;   /*!< USART Version register,                   Address offset: 0x3F4 */
  __IO uint32_t IPIDR;  /*!< USART Identification register,            Address offset: 0x3F8 */
  __IO uint32_t SIDR;   /*!< USART clock Size Identification register, Address offset: 0x3FC */

} USART_TypeDef;

/**
  * @brief Single Wire Protocol Master Interface SPWMI
  */
typedef struct
{
  __IO uint32_t CR;          /*!< SWPMI Configuration/Control register,     Address offset: 0x00 */
  __IO uint32_t BRR;         /*!< SWPMI bitrate register,                   Address offset: 0x04 */
    uint32_t  RESERVED1;     /*!< Reserved, 0x08                                                 */
  __IO uint32_t ISR;         /*!< SWPMI Interrupt and Status register,      Address offset: 0x0C */
  __IO uint32_t ICR;         /*!< SWPMI Interrupt Flag Clear register,      Address offset: 0x10 */
  __IO uint32_t IER;         /*!< SWPMI Interrupt Enable register,          Address offset: 0x14 */
  __IO uint32_t RFL;         /*!< SWPMI Receive Frame Length register,      Address offset: 0x18 */
  __IO uint32_t TDR;         /*!< SWPMI Transmit data register,             Address offset: 0x1C */
  __IO uint32_t RDR;         /*!< SWPMI Receive data register,              Address offset: 0x20 */
  __IO uint32_t OR;          /*!< SWPMI Option register,                    Address offset: 0x24 */
} SWPMI_TypeDef;

/**
  * @brief Window WATCHDOG
  */

typedef struct
{
  __IO uint32_t CR;      /*!< WWDG Control register,        Address offset:  0x00 */
  __IO uint32_t CFR;     /*!< WWDG Configuration register,  Address offset:  0x04 */
  __IO uint32_t SR;      /*!< WWDG Status register,         Address offset:  0x08 */
  uint32_t  RESERVED1[249];   /*!< Reserved,                         0x0C - 0x3EC */
  __IO uint32_t HWCFGR;  /*!< WWDG HW Config register,      Address offset: 0x3F0 */
  __IO uint32_t VERR;    /*!< WWDG Version register,        Address offset: 0x3F4 */
  __IO uint32_t IPIDR;   /*!< WWDG Identification register, Address offset: 0x3F8 */
  __IO uint32_t SIDR;    /*!< WWDG Size ID register,        Address offset: 0x3FC */

} WWDG_TypeDef;
/**
  * @brief Crypto Processor
  */

typedef struct
{
  __IO uint32_t CR;         /*!< CRYP control register,                                    Address offset: 0x00 */
  __IO uint32_t SR;         /*!< CRYP status register,                                     Address offset: 0x04 */
  __IO uint32_t DIN;        /*!< CRYP data input register,                                 Address offset: 0x08 */
  __IO uint32_t DOUT;       /*!< CRYP data output register,                                Address offset: 0x0C */
  __IO uint32_t DMACR;      /*!< CRYP DMA control register,                                Address offset: 0x10 */
  __IO uint32_t IMSCR;      /*!< CRYP interrupt mask set/clear register,                   Address offset: 0x14 */
  __IO uint32_t RISR;       /*!< CRYP raw interrupt status register,                       Address offset: 0x18 */
  __IO uint32_t MISR;       /*!< CRYP masked interrupt status register,                    Address offset: 0x1C */
  __IO uint32_t K0LR;       /*!< CRYP key left  register 0,                                Address offset: 0x20 */
  __IO uint32_t K0RR;       /*!< CRYP key right register 0,                                Address offset: 0x24 */
  __IO uint32_t K1LR;       /*!< CRYP key left  register 1,                                Address offset: 0x28 */
  __IO uint32_t K1RR;       /*!< CRYP key right register 1,                                Address offset: 0x2C */
  __IO uint32_t K2LR;       /*!< CRYP key left  register 2,                                Address offset: 0x30 */
  __IO uint32_t K2RR;       /*!< CRYP key right register 2,                                Address offset: 0x34 */
  __IO uint32_t K3LR;       /*!< CRYP key left  register 3,                                Address offset: 0x38 */
  __IO uint32_t K3RR;       /*!< CRYP key right register 3,                                Address offset: 0x3C */
  __IO uint32_t IV0LR;      /*!< CRYP initialization vector left-word  register 0,         Address offset: 0x40 */
  __IO uint32_t IV0RR;      /*!< CRYP initialization vector right-word register 0,         Address offset: 0x44 */
  __IO uint32_t IV1LR;      /*!< CRYP initialization vector left-word  register 1,         Address offset: 0x48 */
  __IO uint32_t IV1RR;      /*!< CRYP initialization vector right-word register 1,         Address offset: 0x4C */
  __IO uint32_t CSGCMCCM0R; /*!< CRYP GCM/GMAC or CCM/CMAC context swap register 0,        Address offset: 0x50 */
  __IO uint32_t CSGCMCCM1R; /*!< CRYP GCM/GMAC or CCM/CMAC context swap register 1,        Address offset: 0x54 */
  __IO uint32_t CSGCMCCM2R; /*!< CRYP GCM/GMAC or CCM/CMAC context swap register 2,        Address offset: 0x58 */
  __IO uint32_t CSGCMCCM3R; /*!< CRYP GCM/GMAC or CCM/CMAC context swap register 3,        Address offset: 0x5C */
  __IO uint32_t CSGCMCCM4R; /*!< CRYP GCM/GMAC or CCM/CMAC context swap register 4,        Address offset: 0x60 */
  __IO uint32_t CSGCMCCM5R; /*!< CRYP GCM/GMAC or CCM/CMAC context swap register 5,        Address offset: 0x64 */
  __IO uint32_t CSGCMCCM6R; /*!< CRYP GCM/GMAC or CCM/CMAC context swap register 6,        Address offset: 0x68 */
  __IO uint32_t CSGCMCCM7R; /*!< CRYP GCM/GMAC or CCM/CMAC context swap register 7,        Address offset: 0x6C */
  __IO uint32_t CSGCM0R;    /*!< CRYP GCM/GMAC context swap register 0,                    Address offset: 0x70 */
  __IO uint32_t CSGCM1R;    /*!< CRYP GCM/GMAC context swap register 1,                    Address offset: 0x74 */
  __IO uint32_t CSGCM2R;    /*!< CRYP GCM/GMAC context swap register 2,                    Address offset: 0x78 */
  __IO uint32_t CSGCM3R;    /*!< CRYP GCM/GMAC context swap register 3,                    Address offset: 0x7C */
  __IO uint32_t CSGCM4R;    /*!< CRYP GCM/GMAC context swap register 4,                    Address offset: 0x80 */
  __IO uint32_t CSGCM5R;    /*!< CRYP GCM/GMAC context swap register 5,                    Address offset: 0x84 */
  __IO uint32_t CSGCM6R;    /*!< CRYP GCM/GMAC context swap register 6,                    Address offset: 0x88 */
  __IO uint32_t CSGCM7R;    /*!< CRYP GCM/GMAC context swap register 7,                    Address offset: 0x8C */
  uint32_t RESERVED[216];
  __IO uint32_t HWCFGR;     /*!< CRYP HW Configuration,                                    Address offset: 0x3F0 */
  __IO uint32_t VERR;       /*!< CRYP version register ,                                   Address offset: 0x3F4 */
  __IO uint32_t IPIDR;      /*!< CRYP Identification register,                             Address offset: 0x3F8 */
  __IO uint32_t MID;        /*!< CRYP HW Magic ID register,                                Address offset: 0x3FC */
} CRYP_TypeDef;
/**
  * @brief HASH
  */

typedef struct
{
  __IO uint32_t CR;               /*!< HASH control register,          Address offset: 0x00        */
  __IO uint32_t DIN;              /*!< HASH data input register,       Address offset: 0x04        */
  __IO uint32_t STR;              /*!< HASH start register,            Address offset: 0x08        */
  __IO uint32_t HR[5];            /*!< HASH digest registers,          Address offset: 0x0C-0x1C   */
  __IO uint32_t IMR;              /*!< HASH interrupt enable register, Address offset: 0x20        */
  __IO uint32_t SR;               /*!< HASH status register,           Address offset: 0x24        */
       uint32_t RESERVED[52];     /*!< Reserved, 0x28-0xF4                                         */
  __IO uint32_t CSR[54];          /*!< HASH context swap registers,    Address offset: 0x0F8-0x1CC */
       uint32_t RESERVED2[80];
  __IO uint32_t HR2[8];
       uint32_t RESERVED3[48];
  __IO uint32_t HWCFGR;           /*!< HASH Hardware configuration register, Address offset: 0x3F0 */
  __IO uint32_t VERR;           /*!< HASH Version register,                   Address offset: 0x3F4 */
  __IO uint32_t IPIDR;           /*!< HASH identification register,             Address offset: 0x3F8 */
  __IO uint32_t MID;           /*!< HASH Hardware Magic ID register,         Address offset: 0x3FC */
} HASH_TypeDef;

/**
  * @brief HASH_DIGEST
  */

typedef struct
{
  __IO uint32_t HR[8];     /*!< HASH digest registers,          Address offset: 0x310-0x32C */
} HASH_DIGEST_TypeDef;


/**
  * @brief RNG
  */
typedef struct
{
  __IO uint32_t CR;              /*!< RNG control register,             Address offset: 0x00  */
  __IO uint32_t SR;              /*!< RNG status register,              Address offset: 0x04  */
  __IO uint32_t DR;              /*!< RNG data register,                Address offset: 0x08  */
  __IO uint32_t RESERVED1[249];  /*!< Reserved                          Address offset: 0x0C - 0x3EC */
  __IO uint32_t HWCFGR;          /*!< RNG HW Configuration register,    Address offset: 0x3F0 */
  __IO uint32_t VERR;            /*!< RNG Version register,             Address offset: 0x3F4 */
  __IO uint32_t IPIDR;           /*!< RNG identification register,      Address offset: 0x3F8 */
  __IO uint32_t SIDR;            /*!< RNG HW magic ID,                  Address offset: 0x3FC */
} RNG_TypeDef;

/**
  * @brief Inter-Processor Communication
  */
typedef struct
{
  __IO uint32_t C1CR;             /*!< Inter-Processor Communication: C1 control register,                  Address offset: 0x000 */
  __IO uint32_t C1MR ;            /*!< Inter-Processor Communication: C1 mask register,                     Address offset: 0x004 */
  __IO uint32_t C1SCR;            /*!< Inter-Processor Communication: C1 status set clear register,         Address offset: 0x008 */
  __IO uint32_t C1TOC2SR;         /*!< Inter-Processor Communication: C1 to processor M4  status register,  Address offset: 0x00C */
  __IO uint32_t C2CR;             /*!< Inter-Processor Communication: C2 control register,                  Address offset: 0x010 */
  __IO uint32_t C2MR ;            /*!< Inter-Processor Communication: C2 mask register,                     Address offset: 0x014 */
  __IO uint32_t C2SCR;            /*!< Inter-Processor Communication: C2 status set clear register,         Address offset: 0x018 */
  __IO uint32_t C2TOC1SR;         /*!< Inter-Processor Communication: C2 to processor M4 status register,   Address offset: 0x01C */
  __IO uint32_t RESERVED1[244];   /*!< Reserved                                                                                   */
  __IO uint32_t HWCFGR;           /*!< Inter-Processor Communication hardware configuration register,       Address offset: 0x3F0 */
  __IO uint32_t VER;             /*!< Inter-Processor Communication version register,                      Address offset: 0x3F4 */
  __IO uint32_t ID;            /*!< Inter-Processor Communication identification register,               Address offset: 0x3F8 */
  __IO uint32_t SID;             /*!< Inter-Processor Communication size identification register,          Address offset: 0x3FC */
} IPCC_TypeDef;

typedef struct
{
  __IO uint32_t CR;               /*!< Control register,                                                    Address offset: 0x000 */
  __IO uint32_t MR;               /*!< Mask register,                                                       Address offset: 0x004 */
  __IO uint32_t SCR;              /*!< Status set clear register,                                           Address offset: 0x008 */
  __IO uint32_t SR;               /*!< Status register,                                                     Address offset: 0x00C */
} IPCC_CommonTypeDef;

/**
  * @brief MDIOS
  */

typedef struct
{
  __IO uint32_t CR;               /*!< Control register,                                                    Address offset: 0x000 */
  __IO uint32_t WRFR;             /*!< Write Flag register,                                                 Address offset: 0x004 */
  __IO uint32_t CWRFR;            /*!< Clear Write Flag register,                                           Address offset: 0x008 */
  __IO uint32_t RDFR;             /*!< Read Flag register,                                                  Address offset: 0x00C */
  __IO uint32_t CRDFR;            /*!< Clear Read Flag register,                                            Address offset: 0x010 */
  __IO uint32_t SR;               /*!< Status register,                                                     Address offset: 0x014 */
  __IO uint32_t CLRFR;            /*!< Clear Flag register,                                                 Address offset: 0x018 */
  uint32_t RESERVED[57];          /*!< Reserved,                                                    Address offset: 0x01C - 0x0FC */
  __IO uint32_t DINR0;            /*!< Input Data register 0                                                Address offset: 0x100 */
  __IO uint32_t DINR1;            /*!< Input Data register 1                                                Address offset: 0x104 */
  __IO uint32_t DINR2;            /*!< Input Data register 2                                                Address offset: 0x108 */
  __IO uint32_t DINR3;            /*!< Input Data register 3                                                Address offset: 0x10C */
  __IO uint32_t DINR4;            /*!< Input Data register 4                                                Address offset: 0x110 */
  __IO uint32_t DINR5;            /*!< Input Data register 5                                                Address offset: 0x114 */
  __IO uint32_t DINR6;            /*!< Input Data register 6                                                Address offset: 0x118 */
  __IO uint32_t DINR7;            /*!< Input Data register 7                                                Address offset: 0x11C */
  __IO uint32_t DINR8;            /*!< Input Data register 8                                                Address offset: 0x120 */
  __IO uint32_t DINR9;            /*!< Input Data register 9                                                Address offset: 0x124 */
  __IO uint32_t DINR10;           /*!< Input Data register 10                                               Address offset: 0x128 */
  __IO uint32_t DINR11;           /*!< Input Data register 11                                               Address offset: 0x12C */
  __IO uint32_t DINR12;           /*!< Input Data register 12                                               Address offset: 0x130 */
  __IO uint32_t DINR13;           /*!< Input Data register 13                                               Address offset: 0x134 */
  __IO uint32_t DINR14;           /*!< Input Data register 14                                               Address offset: 0x138 */
  __IO uint32_t DINR15;           /*!< Input Data register 15                                               Address offset: 0x13C */
  __IO uint32_t DINR16;           /*!< Input Data register 16                                               Address offset: 0x140 */
  __IO uint32_t DINR17;           /*!< Input Data register 17                                               Address offset: 0x144 */
  __IO uint32_t DINR18;           /*!< Input Data register 18                                               Address offset: 0x148 */
  __IO uint32_t DINR19;           /*!< Input Data register 19                                               Address offset: 0x14C */
  __IO uint32_t DINR20;           /*!< Input Data register 20                                               Address offset: 0x150 */
  __IO uint32_t DINR21;           /*!< Input Data register 21                                               Address offset: 0x154 */
  __IO uint32_t DINR22;           /*!< Input Data register 22                                               Address offset: 0x158 */
  __IO uint32_t DINR23;           /*!< Input Data register 23                                               Address offset: 0x15C */
  __IO uint32_t DINR24;           /*!< Input Data register 24                                               Address offset: 0x160 */
  __IO uint32_t DINR25;           /*!< Input Data register 25                                               Address offset: 0x164 */
  __IO uint32_t DINR26;           /*!< Input Data register 26                                               Address offset: 0x168 */
  __IO uint32_t DINR27;           /*!< Input Data register 27                                               Address offset: 0x16C */
  __IO uint32_t DINR28;           /*!< Input Data register 28                                               Address offset: 0x170 */
  __IO uint32_t DINR29;           /*!< Input Data register 29                                               Address offset: 0x174 */
  __IO uint32_t DINR30;           /*!< Input Data register 30                                               Address offset: 0x178 */
  __IO uint32_t DINR31;           /*!< Input Data register 31                                               Address offset: 0x17C */
  __IO uint32_t DOUTR0;           /*!< Output Data register 0                                               Address offset: 0x180 */
  __IO uint32_t DOUTR1;           /*!< Output Data register 1                                               Address offset: 0x184 */
  __IO uint32_t DOUTR2;           /*!< Output Data register 2                                               Address offset: 0x188 */
  __IO uint32_t DOUTR3;           /*!< Output Data register 3                                               Address offset: 0x18C */
  __IO uint32_t DOUTR4;           /*!< Output Data register 4                                               Address offset: 0x190 */
  __IO uint32_t DOUTR5;           /*!< Output Data register 5                                               Address offset: 0x194 */
  __IO uint32_t DOUTR6;           /*!< Output Data register 6                                               Address offset: 0x198 */
  __IO uint32_t DOUTR7;           /*!< Output Data register 7                                               Address offset: 0x19C */
  __IO uint32_t DOUTR8;           /*!< Output Data register 8                                               Address offset: 0x1A0 */
  __IO uint32_t DOUTR9;           /*!< Output Data register 9                                               Address offset: 0x1A4 */
  __IO uint32_t DOUTR10;          /*!< Output Data register 10                                              Address offset: 0x1A8 */
  __IO uint32_t DOUTR11;          /*!< Output Data register 11                                              Address offset: 0x1AC */
  __IO uint32_t DOUTR12;          /*!< Output Data register 12                                              Address offset: 0x1B0 */
  __IO uint32_t DOUTR13;          /*!< Output Data register 13                                              Address offset: 0x1B4 */
  __IO uint32_t DOUTR14;          /*!< Output Data register 14                                              Address offset: 0x1B8 */
  __IO uint32_t DOUTR15;          /*!< Output Data register 15                                              Address offset: 0x1BC */
  __IO uint32_t DOUTR16;          /*!< Output Data register 16                                              Address offset: 0x1C0 */
  __IO uint32_t DOUTR17;          /*!< Output Data register 17                                              Address offset: 0x1C4 */
  __IO uint32_t DOUTR18;          /*!< Output Data register 18                                              Address offset: 0x1C8 */
  __IO uint32_t DOUTR19;          /*!< Output Data register 19                                              Address offset: 0x1CC */
  __IO uint32_t DOUTR20;          /*!< Output Data register 20                                              Address offset: 0x1D0 */
  __IO uint32_t DOUTR21;          /*!< Output Data register 21                                              Address offset: 0x1D4 */
  __IO uint32_t DOUTR22;          /*!< Output Data register 22                                              Address offset: 0x1D8 */
  __IO uint32_t DOUTR23;          /*!< Output Data register 23                                              Address offset: 0x1DC */
  __IO uint32_t DOUTR24;          /*!< Output Data register 24                                              Address offset: 0x1E0 */
  __IO uint32_t DOUTR25;          /*!< Output Data register 25                                              Address offset: 0x1E4 */
  __IO uint32_t DOUTR26;          /*!< Output Data register 26                                              Address offset: 0x1E8 */
  __IO uint32_t DOUTR27;          /*!< Output Data register 27                                              Address offset: 0x1EC */
  __IO uint32_t DOUTR28;          /*!< Output Data register 28                                              Address offset: 0x1F0 */
  __IO uint32_t DOUTR29;          /*!< Output Data register 29                                              Address offset: 0x1F4 */
  __IO uint32_t DOUTR30;          /*!< Output Data register 30                                              Address offset: 0x1F8 */
  __IO uint32_t DOUTR31;          /*!< Output Data register 31                                              Address offset: 0x1FC */
  uint32_t RESERVED1[124]; /*!< Reserved                                     0x200 - 0x3EC */
  __IO uint32_t HWCFGR;    /*!< MDIOS HW Configuration register,     Address offset: 0x3F0 */
  __IO uint32_t VERR;      /*!< MDIOS Version register,              Address offset: 0x3F4 */
  __IO uint32_t IPIDR;     /*!< MDIOS identification register,       Address offset: 0x3F8 */
  __IO uint32_t SIDR;      /*!< MDIOS Size ID register,              Address offset: 0x3FC */
} MDIOS_TypeDef;


/**
  * @brief USB_OTG_Core_Registers
  */
typedef struct
{
 __IO uint32_t GOTGCTL;               /*!< USB_OTG Control and Status Register          000h */
  __IO uint32_t GOTGINT;              /*!< USB_OTG Interrupt Register                   004h */
  __IO uint32_t GAHBCFG;              /*!< Core AHB Configuration Register              008h */
  __IO uint32_t GUSBCFG;              /*!< Core USB Configuration Register              00Ch */
  __IO uint32_t GRSTCTL;              /*!< Core Reset Register                          010h */
  __IO uint32_t GINTSTS;              /*!< Core Interrupt Register                      014h */
  __IO uint32_t GINTMSK;              /*!< Core Interrupt Mask Register                 018h */
  __IO uint32_t GRXSTSR;              /*!< Receive Sts Q Read Register                  01Ch */
  __IO uint32_t GRXSTSP;              /*!< Receive Sts Q Read & POP Register            020h */
  __IO uint32_t GRXFSIZ;              /*!< Receive FIFO Size Register                   024h */
  __IO uint32_t DIEPTXF0_HNPTXFSIZ;   /*!< EP0 / Non Periodic Tx FIFO Size Register     028h */
  __IO uint32_t HNPTXSTS;             /*!< Non Periodic Tx FIFO/Queue Sts reg           02Ch */
  __IO uint32_t GI2CCTL;              /*!< I2C Access Register                          030h */
  uint32_t Reserved30;                /*!< Reserved                                     034h */
  __IO uint32_t GCCFG;                /*!< General Purpose IO Register                  038h */
  __IO uint32_t CID;                  /*!< User ID Register                             03Ch */
  uint32_t  Reserved5[4];             /*!< Reserved                                040h-048h */
  uint32_t  Reserved6;                /*!< Reserved                                     050h */
  __IO uint32_t GLPMCFG;              /*!< LPM Register                                 054h */
  uint32_t  Reserved43[42];         /*!< Reserved                                  058h-0FFh */
  __IO uint32_t HPTXFSIZ;             /*!< Host Periodic Tx FIFO Size Reg               100h */
  __IO uint32_t DIEPTXF[0x0F];        /*!< dev Periodic Transmit FIFO */
} USB_OTG_GlobalTypeDef;


/**
  * @brief USB_OTG_device_Registers
  */
typedef struct
{
  __IO uint32_t DCFG;            /*!< dev Configuration Register   800h */
  __IO uint32_t DCTL;            /*!< dev Control Register         804h */
  __IO uint32_t DSTS;            /*!< dev Status Register (RO)     808h */
  uint32_t Reserved0C;           /*!< Reserved                     80Ch */
  __IO uint32_t DIEPMSK;         /*!< dev IN Endpoint Mask         810h */
  __IO uint32_t DOEPMSK;         /*!< dev OUT Endpoint Mask        814h */
  __IO uint32_t DAINT;           /*!< dev All Endpoints Itr Reg    818h */
  __IO uint32_t DAINTMSK;        /*!< dev All Endpoints Itr Mask   81Ch */
  uint32_t  Reserved20;          /*!< Reserved                     820h */
  uint32_t Reserved9;            /*!< Reserved                     824h */
  __IO uint32_t DVBUSDIS;        /*!< dev VBUS discharge Register  828h */
  __IO uint32_t DVBUSPULSE;      /*!< dev VBUS Pulse Register      82Ch */
  __IO uint32_t DTHRCTL;         /*!< dev threshold                830h */
  __IO uint32_t DIEPEMPMSK;      /*!< dev empty msk                834h */
  __IO uint32_t DEACHINT;        /*!< dedicated EP interrupt       838h */
  __IO uint32_t DEACHMSK;        /*!< dedicated EP msk             83Ch */
  uint32_t Reserved40;           /*!< dedicated EP mask            840h */
  __IO uint32_t DINEP1MSK;       /*!< dedicated EP mask            844h */
  uint32_t  Reserved44[15];      /*!< Reserved                 844-87Ch */
  __IO uint32_t DOUTEP1MSK;      /*!< dedicated EP msk             884h */
} USB_OTG_DeviceTypeDef;


/**
  * @brief USB_OTG_IN_Endpoint-Specific_Register
  */
typedef struct
{
  __IO uint32_t DIEPCTL;           /*!< dev IN Endpoint Control Reg    900h + (ep_num * 20h) + 00h */
  uint32_t Reserved04;             /*!< Reserved                       900h + (ep_num * 20h) + 04h */
  __IO uint32_t DIEPINT;           /*!< dev IN Endpoint Itr Reg        900h + (ep_num * 20h) + 08h */
  uint32_t Reserved0C;             /*!< Reserved                       900h + (ep_num * 20h) + 0Ch */
  __IO uint32_t DIEPTSIZ;          /*!< IN Endpoint Txfer Size         900h + (ep_num * 20h) + 10h */
  __IO uint32_t DIEPDMA;           /*!< IN Endpoint DMA Address Reg    900h + (ep_num * 20h) + 14h */
  __IO uint32_t DTXFSTS;           /*!< IN Endpoint Tx FIFO Status Reg 900h + (ep_num * 20h) + 18h */
  uint32_t Reserved18;             /*!< Reserved  900h+(ep_num*20h)+1Ch-900h+ (ep_num * 20h) + 1Ch */
} USB_OTG_INEndpointTypeDef;


/**
  * @brief USB_OTG_OUT_Endpoint-Specific_Registers
  */
typedef struct
{
  __IO uint32_t DOEPCTL;       /*!< dev OUT Endpoint Control Reg           B00h + (ep_num * 20h) + 00h */
  uint32_t Reserved04;         /*!< Reserved                               B00h + (ep_num * 20h) + 04h */
  __IO uint32_t DOEPINT;       /*!< dev OUT Endpoint Itr Reg               B00h + (ep_num * 20h) + 08h */
  uint32_t Reserved0C;         /*!< Reserved                               B00h + (ep_num * 20h) + 0Ch */
  __IO uint32_t DOEPTSIZ;      /*!< dev OUT Endpoint Txfer Size            B00h + (ep_num * 20h) + 10h */
  __IO uint32_t DOEPDMA;       /*!< dev OUT Endpoint DMA Address           B00h + (ep_num * 20h) + 14h */
  uint32_t Reserved18[2];      /*!< Reserved B00h + (ep_num * 20h) + 18h - B00h + (ep_num * 20h) + 1Ch */
} USB_OTG_OUTEndpointTypeDef;


/**
  * @brief USB_OTG_Host_Mode_Register_Structures
  */
typedef struct
{
  __IO uint32_t HCFG;             /*!< Host Configuration Register           400h */
  __IO uint32_t HFIR;             /*!< Host Frame Interval Register          404h */
  __IO uint32_t HFNUM;            /*!< Host Frame Nbr/Frame Remaining        408h */
  uint32_t Reserved40C;           /*!< Reserved                              40Ch */
  __IO uint32_t HPTXSTS;          /*!< Host Periodic Tx FIFO/ Queue Status   410h */
  __IO uint32_t HAINT;            /*!< Host All Channels Interrupt Register  414h */
  __IO uint32_t HAINTMSK;         /*!< Host All Channels Interrupt Mask      418h */
  __IO uint32_t HFLBADDR;         /*!< Host frame list base address register 41Ch */
  uint32_t Reserved420[8];        /*!< Reserved                              420h */
  __IO uint32_t HPRT;             /*!< Host port control and status register 440h */
} USB_OTG_HostTypeDef;

/**
  * @brief USB_OTG_Host_Channel_Specific_Registers
  */
typedef struct
{
  __IO uint32_t HCCHAR;           /*!< Host Channel Characteristics Register    500h */
  __IO uint32_t HCSPLT;           /*!< Host Channel Split Control Register      504h */
  __IO uint32_t HCINT;            /*!< Host Channel Interrupt Register          508h */
  __IO uint32_t HCINTMSK;         /*!< Host Channel Interrupt Mask Register     50Ch */
  __IO uint32_t HCTSIZ;           /*!< Host Channel Transfer Size Register      510h */
  __IO uint32_t HCDMA;            /*!< Host Channel DMA Address Register        514h */
  uint32_t Reserved0;             /*!< Reserved                                 518h */
  __IO uint32_t HCDMAB;           /*!< Host Channel DMA Address Buffer Register 51Ch */
  uint32_t Reserved[2];           /*!< Reserved                                      */
} USB_OTG_HostChannelTypeDef;
/**
  * @}
  */

/**
  * @brief USB_EHCI Capability Registers
  */
typedef struct
{
  __IO uint32_t HCCAPBASE;        /*!< Capability Register register,              Address offset: 0x00 */
  __IO uint32_t HCSPARAMS;        /*!< Structural Parameter register              Address offset: 0x04 */
  __IO uint32_t HCCPARAMS;        /*!< Capability Parameter register,             Address offset: 0x08 */
       uint32_t RESERVED;         /*!< USB Command register,                      Address offset: 0x0C */
  __IO uint32_t USBCMD;           /*!< USB Command register,                      Address offset: 0x10 */
  __IO uint32_t USBSTS;           /*!< USB Status register,                       Address offset: 0x14 */
  __IO uint32_t USBINTR;          /*!< USB Interrupt Enable register,             Address offset: 0x18 */
  __IO uint32_t FRINDEX;          /*!< USB Frame Index register ,                 Address offset: 0x1C */
  __IO uint32_t CTRLDSSEGMENT;    /*!< 4G Segment Selector register,              Address offset: 0x20 */
  __IO uint32_t PERIODICLISTBASE; /*!< Periodic Frame List Base Address register, Address offset: 0x24 */
  __IO uint32_t ASYNCLISTADDR;    /*!< Asynchronous List Address register,        Address offset: 0x28 */
} USB_EHCI_CapabilityTypeDef;
/**
  * @}
  */



/** @addtogroup Peripheral_memory_map
  * @{
  */
#define AHB_SRAM            ((uint32_t)0x10000000) /*!< Base address of : (up to 288KB) system data RAM accessible over over AHB             */
#define AHB_RETRAM          ((uint32_t)0x00000000) /*!< Base address of : (up to 64KB) Retention RAM accessible over over AHB                */

#define SYSRAM_BASE             ((uint32_t)0x2FFC0000) /*!< Base address of : (up to 256KB) System RAM accessible over over AXI                  */
#define RETRAM_BASE             MCU_AHB_RETRAM
#define SRAM_BASE               AHB_SRAM
#define PERIPH_BASE             ((uint32_t)0x40000000) /*!< Base address of : AHB/ABP Peripherals                                                */
#define AXI_BUS_MEMORY_BASE     ((uint32_t)0x60000000) /*!< Base address of : AXI Bus                                                            */

#define FMC_NOR_MEM_BASE        (AXI_BUS_MEMORY_BASE)              /*!< Base address of : FMC NOR memories  accessible over AXI              */
#define QSPI_MEM_BASE           (AXI_BUS_MEMORY_BASE + 0x10000000) /*!< Base address of : QSPI memories  accessible over AXI                 */
#define FMC_NAND_MEM_BASE       (AXI_BUS_MEMORY_BASE + 0x20000000) /*!< Base address of : FMC NAND memories  accessible over AXI             */
#define STM_DATA_BASE           (AXI_BUS_MEMORY_BASE + 0x30000000) /*!< Base address of : STM Data accessible over AXI                       */
#define DRAM_MEM_BASE           (AXI_BUS_MEMORY_BASE + 0x60000000) /*!< Base address of : DRAM (DDR) over AXI                                */

/*!< Device electronic signature memory map */
#define UID_BASE                  (0x5C005234L)            /*!< Unique Device ID register base address */
#define PACKAGE_BASE              (0x5C005240L)            /*!< Package Data register base address */
#define RPN_BASE                  (0x5C005204L)            /*!< Device Part Number register base address */
#define DV_BASE                   (0x50081000L)            /*!< Device Version register base address */

/*!< Peripheral memory map */
#define APB1_PERIPH_BASE          (PERIPH_BASE + 0x00000000)
#define APB2_PERIPH_BASE          (PERIPH_BASE + 0x04000000)
#define AHB2_PERIPH_BASE          (PERIPH_BASE + 0x08000000)
#define AHB3_PERIPH_BASE          (PERIPH_BASE + 0x0C000000)
#define AHB4_PERIPH_BASE          (PERIPH_BASE + 0x10000000)
#define APB3_PERIPH_BASE          (PERIPH_BASE + 0x10020000)
#define APB_DEBUG_PERIPH_BASE     (PERIPH_BASE + 0x10080000)
#define AHB5_PERIPH_BASE          (PERIPH_BASE + 0x14000000)
#define GPV_PERIPH_BASE           (PERIPH_BASE + 0x17000000)
#define AHB6_PERIPH_BASE          (PERIPH_BASE + 0x18000000)
#define APB4_PERIPH_BASE          (PERIPH_BASE + 0x1A000000)
#define APB5_PERIPH_BASE          (PERIPH_BASE + 0x1C000000)


#define MCU_AHB_SRAM              AHB_SRAM
#define MCU_AHB_RETRAM            AHB_RETRAM
#define MPU_AXI_BUS_MEMORY_BASE   AXI_BUS_MEMORY_BASE
#define MCU_APB1_PERIPH_BASE      APB1_PERIPH_BASE
#define MCU_APB2_PERIPH_BASE      APB2_PERIPH_BASE
#define MCU_AHB2_PERIPH_BASE      AHB2_PERIPH_BASE
#define MCU_AHB3_PERIPH_BASE      AHB3_PERIPH_BASE
#define MCU_AHB4_PERIPH_BASE      AHB4_PERIPH_BASE
#define MCU_APB3_PERIPH_BASE      APB3_PERIPH_BASE
#define MPU_AHB5_PERIPH_BASE      AHB5_PERIPH_BASE
#define MPU_AHB6_PERIPH_BASE      AHB6_PERIPH_BASE
#define MPU_APB4_PERIPH_BASE      APB4_PERIPH_BASE
#define MPU_APB5_PERIPH_BASE      APB5_PERIPH_BASE

/*!< APB1 */
#define TIM2_BASE             (APB1_PERIPH_BASE + 0x0000)
#define TIM3_BASE             (APB1_PERIPH_BASE + 0x1000)
#define TIM4_BASE             (APB1_PERIPH_BASE + 0x2000)
#define TIM5_BASE             (APB1_PERIPH_BASE + 0x3000)
#define TIM6_BASE             (APB1_PERIPH_BASE + 0x4000)
#define TIM7_BASE             (APB1_PERIPH_BASE + 0x5000)
#define TIM12_BASE            (APB1_PERIPH_BASE + 0x6000)
#define TIM13_BASE            (APB1_PERIPH_BASE + 0x7000)
#define TIM14_BASE            (APB1_PERIPH_BASE + 0x8000)
#define LPTIM1_BASE           (APB1_PERIPH_BASE + 0x9000)
#define WWDG1_BASE            (APB1_PERIPH_BASE + 0xA000)
#define SPI2_BASE             (APB1_PERIPH_BASE + 0xB000)
#define SPI3_BASE             (APB1_PERIPH_BASE + 0xC000)
#define SPDIFRX_BASE          (APB1_PERIPH_BASE + 0xD000)
#define USART2_BASE           (APB1_PERIPH_BASE + 0xE000)
#define USART3_BASE           (APB1_PERIPH_BASE + 0xF000)
#define UART4_BASE            (APB1_PERIPH_BASE + 0x10000)
#define UART5_BASE            (APB1_PERIPH_BASE + 0x11000)
#define I2C1_BASE             (APB1_PERIPH_BASE + 0x12000)
#define I2C2_BASE             (APB1_PERIPH_BASE + 0x13000)
#define I2C3_BASE             (APB1_PERIPH_BASE + 0x14000)
#define I2C5_BASE             (APB1_PERIPH_BASE + 0x15000)
#define CEC_BASE              (APB1_PERIPH_BASE + 0x16000)
#define DAC1_BASE             (APB1_PERIPH_BASE + 0x17000)
#define UART7_BASE            (APB1_PERIPH_BASE + 0x18000)
#define UART8_BASE            (APB1_PERIPH_BASE + 0x19000)
#define MDIOS_BASE            (APB1_PERIPH_BASE + 0x1C000)

/*!< APB2 */
#define TIM1_BASE             (APB2_PERIPH_BASE + 0x0000)
#define TIM8_BASE             (APB2_PERIPH_BASE + 0x1000)
#define USART6_BASE           (APB2_PERIPH_BASE + 0x3000)
#define SPI1_BASE             (APB2_PERIPH_BASE + 0x4000)
#define SPI4_BASE             (APB2_PERIPH_BASE + 0x5000)
#define TIM15_BASE            (APB2_PERIPH_BASE + 0x6000)
#define TIM16_BASE            (APB2_PERIPH_BASE + 0x7000)
#define TIM17_BASE            (APB2_PERIPH_BASE + 0x8000)
#define SPI5_BASE             (APB2_PERIPH_BASE + 0x9000)
#define SAI1_BASE             (APB2_PERIPH_BASE + 0xA000)
#define SAI1_Block_A_BASE     (SAI1_BASE + 0x004)
#define SAI1_Block_B_BASE     (SAI1_BASE + 0x024)
#define SAI2_BASE             (APB2_PERIPH_BASE + 0xB000)
#define SAI2_Block_A_BASE     (SAI2_BASE + 0x004)
#define SAI2_Block_B_BASE     (SAI2_BASE + 0x024)
#define SAI3_BASE             (APB2_PERIPH_BASE + 0xC000)
#define SAI3_Block_A_BASE     (SAI3_BASE + 0x004)
#define SAI3_Block_B_BASE     (SAI3_BASE + 0x024)
#define DFSDM1_BASE           (APB2_PERIPH_BASE + 0xD000)
#define DFSDM1_Channel0_BASE  (DFSDM1_BASE + 0x00)
#define DFSDM1_Channel1_BASE  (DFSDM1_BASE + 0x20)
#define DFSDM1_Channel2_BASE  (DFSDM1_BASE + 0x40)
#define DFSDM1_Channel3_BASE  (DFSDM1_BASE + 0x60)
#define DFSDM1_Channel4_BASE  (DFSDM1_BASE + 0x80)
#define DFSDM1_Channel5_BASE  (DFSDM1_BASE + 0xA0)
#define DFSDM1_Channel6_BASE  (DFSDM1_BASE + 0xC0)
#define DFSDM1_Channel7_BASE  (DFSDM1_BASE + 0xE0)
#define DFSDM1_Filter0_BASE   (DFSDM1_BASE + 0x100)
#define DFSDM1_Filter1_BASE   (DFSDM1_BASE + 0x180)
#define DFSDM1_Filter2_BASE   (DFSDM1_BASE + 0x200)
#define DFSDM1_Filter3_BASE   (DFSDM1_BASE + 0x280)
#define DFSDM1_Filter4_BASE   (DFSDM1_BASE + 0x300)
#define DFSDM1_Filter5_BASE   (DFSDM1_BASE + 0x380)
#define FDCAN1_BASE           (APB2_PERIPH_BASE + 0xE000)
#define FDCAN2_BASE           (APB2_PERIPH_BASE + 0xF000)
#define TTFDCAN1_BASE         (APB2_PERIPH_BASE + 0xE100)
#define FDCAN_CCU_BASE        (APB2_PERIPH_BASE + 0x10000)
#define SRAMCAN_BASE          (APB2_PERIPH_BASE + 0x11000)

/*!< AHB2 */
#define DMA1_BASE             (AHB2_PERIPH_BASE + 0x0000)
#define DMA2_BASE             (AHB2_PERIPH_BASE + 0x1000)
#define DMAMUX1_BASE          (AHB2_PERIPH_BASE + 0x2000)
#define ADC1_BASE             (AHB2_PERIPH_BASE + 0x3000)
#define ADC2_BASE             (AHB2_PERIPH_BASE + 0x3100)
#define ADC12_COMMON_BASE     (AHB2_PERIPH_BASE + 0x3300)
#define SDMMC3_BASE           (AHB2_PERIPH_BASE + 0x4000)
#define DLYB_SDMMC3_BASE      (AHB2_PERIPH_BASE + 0x5000)
#define USBOTG_BASE           (AHB2_PERIPH_BASE + 0x1000000)


/*!< AHB3 */
#define HSEM_BASE             (AHB3_PERIPH_BASE + 0x0000)
#define IPCC_BASE             (AHB3_PERIPH_BASE + 0x1000)
#define HASH2_BASE            (AHB3_PERIPH_BASE + 0x2000)
#define HASH2_DIGEST_BASE     (AHB3_PERIPH_BASE + 0x2310)
#define RNG2_BASE             (AHB3_PERIPH_BASE + 0x3000)
#define CRC2_BASE             (AHB3_PERIPH_BASE + 0x4000)
#define CRYP2_BASE            (AHB3_PERIPH_BASE + 0x5000)
#define DCMI_BASE             (AHB3_PERIPH_BASE + 0x6000)

/*!< AHB4 */
#define RCC_BASE              (AHB4_PERIPH_BASE + 0x0000)
#define PWR_BASE              (AHB4_PERIPH_BASE + 0x1000)
#define GPIOA_BASE            (AHB4_PERIPH_BASE + 0x2000)
#define GPIOB_BASE            (AHB4_PERIPH_BASE + 0x3000)
#define GPIOC_BASE            (AHB4_PERIPH_BASE + 0x4000)
#define GPIOD_BASE            (AHB4_PERIPH_BASE + 0x5000)
#define GPIOE_BASE            (AHB4_PERIPH_BASE + 0x6000)
#define GPIOF_BASE            (AHB4_PERIPH_BASE + 0x7000)
#define GPIOG_BASE            (AHB4_PERIPH_BASE + 0x8000)
#define GPIOH_BASE            (AHB4_PERIPH_BASE + 0x9000)
#define GPIOI_BASE            (AHB4_PERIPH_BASE + 0xA000)
#define GPIOJ_BASE            (AHB4_PERIPH_BASE + 0xB000)
#define GPIOK_BASE            (AHB4_PERIPH_BASE + 0xC000)
#define AIEC_BASE             (AHB4_PERIPH_BASE + 0xD000)
#define AIEC_C1_BASE          (AIEC_BASE + 0x0080)
#define AIEC_C2_BASE          (AIEC_BASE + 0x00C0)
/* Alias EXTI_BASE defined because HAL code not yet reworked with new name AIEC*/
#define EXTI_BASE             AIEC_BASE
#define EXTI_C1_BASE          AIEC_C1_BASE
#define EXTI_C2_BASE          AIEC_C2_BASE


/*!< APB3 */
#define SYSCFG_BASE           (APB3_PERIPH_BASE + 0x0000)
#define LPTIM2_BASE           (APB3_PERIPH_BASE + 0x1000)
#define LPTIM3_BASE           (APB3_PERIPH_BASE + 0x2000)
#define LPTIM4_BASE           (APB3_PERIPH_BASE + 0x3000)
#define LPTIM5_BASE           (APB3_PERIPH_BASE + 0x4000)
#define VREFBUF_BASE          (APB3_PERIPH_BASE + 0x5000)
#define SAI4_BASE             (APB3_PERIPH_BASE + 0x7000)
#define SAI4_Block_A_BASE     (SAI4_BASE + 0x004)
#define SAI4_Block_B_BASE     (SAI4_BASE + 0x024)
#define DTS_BASE              (APB3_PERIPH_BASE + 0x8000)
#define PMB_BASE              (APB3_PERIPH_BASE + 0x9000)
#define HDP_BASE              (APB3_PERIPH_BASE + 0xA000)

/*!< AHB4 _APB_Debug */
#define DBGMCU_BASE           ((uint32_t )0x50081000)

/*!< AHB5 */
#define BKPSRAM_BASE          (AHB5_PERIPH_BASE + 0x0000)
#define CRYP1_BASE            (AHB5_PERIPH_BASE + 0x1000)
#define HASH1_BASE            (AHB5_PERIPH_BASE + 0x2000)
#define HASH1_DIGEST_BASE     (AHB5_PERIPH_BASE + 0x2310)
#define RNG1_BASE             (AHB5_PERIPH_BASE + 0x3000)
#define GPIOZ_BASE            (AHB5_PERIPH_BASE + 0x4000)

/*!< GPV */

/*!< MPU_AHB6 */
#define MDMA_BASE               (AHB6_PERIPH_BASE + 0x0000)
#define FMC_R_BASE              (AHB6_PERIPH_BASE + 0x2000)
#define QSPI_R_BASE             (AHB6_PERIPH_BASE + 0x3000)
#define DLYB_QSPI_BASE          (AHB6_PERIPH_BASE + 0x4000)
#define SDMMC1_BASE             (AHB6_PERIPH_BASE + 0x5000)
#define DLYB_SDMMC1_BASE        (AHB6_PERIPH_BASE + 0x6000)
#define SDMMC2_BASE             (AHB6_PERIPH_BASE + 0x7000)
#define DLYB_SDMMC2_BASE        (AHB6_PERIPH_BASE + 0x8000)
#define CRC1_BASE               (AHB6_PERIPH_BASE + 0x9000)
#define ETH_BASE                (AHB6_PERIPH_BASE + 0xA000)
#define ETH_MAC_BASE            (ETH_BASE)
#define USB1HSFSP2_BASE         (AHB6_PERIPH_BASE + 0xC000)
#define USB1HSFSP1_BASE         (AHB6_PERIPH_BASE + 0xD000)

/*!< MPU_APB4 */
#define LTDC_BASE             (APB4_PERIPH_BASE + 0x1000)
#define LTDC_Layer1_BASE      (LTDC_BASE + 0x84)
#define LTDC_Layer2_BASE      (LTDC_BASE + 0x104)
#define IWDG2_BASE            (APB4_PERIPH_BASE + 0x2000)
#define DDRCTRL_BASE          (APB4_PERIPH_BASE + 0x3000)
#define DDRPHYC_BASE          (APB4_PERIPH_BASE + 0x4000)
#define STGENR_BASE           (APB4_PERIPH_BASE + 0x5000)
#define USBPHYC_BASE          (APB4_PERIPH_BASE + 0x6000)
#define DDRPERFM_BASE         (APB4_PERIPH_BASE + 0x7000)
#define USBPHYC_PHY1_BASE     (USBPHYC_BASE + 0x100)
#define USBPHYC_PHY2_BASE     (USBPHYC_BASE + 0x200)

/*!< MPU_APB5 */
#define USART1_BASE           (APB5_PERIPH_BASE + 0x0000)
#define SPI6_BASE             (APB5_PERIPH_BASE + 0x1000)
#define I2C4_BASE             (APB5_PERIPH_BASE + 0x2000)
#define IWDG1_BASE            (APB5_PERIPH_BASE + 0x3000)
#define RTC_BASE              (APB5_PERIPH_BASE + 0x4000)
#define BSEC_BASE             (APB5_PERIPH_BASE + 0x5000)
#define TZC_BASE              (APB5_PERIPH_BASE + 0x6000)
#define TZPC_BASE             (APB5_PERIPH_BASE + 0x7000)
#define STGENC_BASE           (APB5_PERIPH_BASE + 0x8000)
#define I2C6_BASE             (APB5_PERIPH_BASE + 0x9000)
#define TAMP_BASE             (APB5_PERIPH_BASE + 0xA000)



/*!< USB registers base address */
#define USB_OTG_GLOBAL_BASE                  ((uint32_t )0x000)
#define USB_OTG_DEVICE_BASE                  ((uint32_t )0x800)
#define USB_OTG_IN_ENDPOINT_BASE             ((uint32_t )0x900)
#define USB_OTG_OUT_ENDPOINT_BASE            ((uint32_t )0xB00)
#define USB_OTG_EP_REG_SIZE                  ((uint32_t )0x20)
#define USB_OTG_HOST_BASE                    ((uint32_t )0x400)
#define USB_OTG_HOST_PORT_BASE               ((uint32_t )0x440)
#define USB_OTG_HOST_CHANNEL_BASE            ((uint32_t )0x500)
#define USB_OTG_HOST_CHANNEL_SIZE            ((uint32_t )0x20)
#define USB_OTG_PCGCCTL_BASE                 ((uint32_t )0xE00)
#define USB_OTG_FIFO_BASE                    ((uint32_t )0x1000)
#define USB_OTG_FIFO_SIZE                    ((uint32_t )0x1000)



#define DMA1_Stream0_BASE     (DMA1_BASE + 0x010)
#define DMA1_Stream1_BASE     (DMA1_BASE + 0x028)
#define DMA1_Stream2_BASE     (DMA1_BASE + 0x040)
#define DMA1_Stream3_BASE     (DMA1_BASE + 0x058)
#define DMA1_Stream4_BASE     (DMA1_BASE + 0x070)
#define DMA1_Stream5_BASE     (DMA1_BASE + 0x088)
#define DMA1_Stream6_BASE     (DMA1_BASE + 0x0A0)
#define DMA1_Stream7_BASE     (DMA1_BASE + 0x0B8)

#define DMA2_Stream0_BASE     (DMA2_BASE + 0x010)
#define DMA2_Stream1_BASE     (DMA2_BASE + 0x028)
#define DMA2_Stream2_BASE     (DMA2_BASE + 0x040)
#define DMA2_Stream3_BASE     (DMA2_BASE + 0x058)
#define DMA2_Stream4_BASE     (DMA2_BASE + 0x070)
#define DMA2_Stream5_BASE     (DMA2_BASE + 0x088)
#define DMA2_Stream6_BASE     (DMA2_BASE + 0x0A0)
#define DMA2_Stream7_BASE     (DMA2_BASE + 0x0B8)


#define DMAMUX1_Channel0_BASE    (DMAMUX1_BASE)
#define DMAMUX1_Channel1_BASE    (DMAMUX1_BASE + 0x0004)
#define DMAMUX1_Channel2_BASE    (DMAMUX1_BASE + 0x0008)
#define DMAMUX1_Channel3_BASE    (DMAMUX1_BASE + 0x000C)
#define DMAMUX1_Channel4_BASE    (DMAMUX1_BASE + 0x0010)
#define DMAMUX1_Channel5_BASE    (DMAMUX1_BASE + 0x0014)
#define DMAMUX1_Channel6_BASE    (DMAMUX1_BASE + 0x0018)
#define DMAMUX1_Channel7_BASE    (DMAMUX1_BASE + 0x001C)
#define DMAMUX1_Channel8_BASE    (DMAMUX1_BASE + 0x0020)
#define DMAMUX1_Channel9_BASE    (DMAMUX1_BASE + 0x0024)
#define DMAMUX1_Channel10_BASE   (DMAMUX1_BASE + 0x0028)
#define DMAMUX1_Channel11_BASE   (DMAMUX1_BASE + 0x002C)
#define DMAMUX1_Channel12_BASE   (DMAMUX1_BASE + 0x0030)
#define DMAMUX1_Channel13_BASE   (DMAMUX1_BASE + 0x0034)
#define DMAMUX1_Channel14_BASE   (DMAMUX1_BASE + 0x0038)
#define DMAMUX1_Channel15_BASE   (DMAMUX1_BASE + 0x003C)

#define DMAMUX1_RequestGenerator0_BASE  (DMAMUX1_BASE + 0x0100)
#define DMAMUX1_RequestGenerator1_BASE  (DMAMUX1_BASE + 0x0104)
#define DMAMUX1_RequestGenerator2_BASE  (DMAMUX1_BASE + 0x0108)
#define DMAMUX1_RequestGenerator3_BASE  (DMAMUX1_BASE + 0x010C)

#define DMAMUX1_ChannelStatus_BASE      (DMAMUX1_BASE + 0x0080)
#define DMAMUX1_RequestGenStatus_BASE   (DMAMUX1_BASE + 0x0140)


/*!< FMC Banks registers base  address */
#define FMC_Bank1_R_BASE      (FMC_R_BASE + 0x0000)
#define FMC_Bank1E_R_BASE     (FMC_R_BASE + 0x0104)
#define FMC_Bank2_R_BASE      (FMC_R_BASE + 0x0060)
#define FMC_Bank3_R_BASE      (FMC_R_BASE + 0x0080)
#define FMC_Bank5_6_R_BASE    (FMC_R_BASE + 0x0140)

#define MDMA_NB_CHANNELS        32
#define MDMA_Channel0_BASE    (MDMA_BASE + 0x00000040)
#define MDMA_Channel1_BASE    (MDMA_BASE + 0x00000080)
#define MDMA_Channel2_BASE    (MDMA_BASE + 0x000000C0)
#define MDMA_Channel3_BASE    (MDMA_BASE + 0x00000100)
#define MDMA_Channel4_BASE    (MDMA_BASE + 0x00000140)
#define MDMA_Channel5_BASE    (MDMA_BASE + 0x00000180)
#define MDMA_Channel6_BASE    (MDMA_BASE + 0x000001C0)
#define MDMA_Channel7_BASE    (MDMA_BASE + 0x00000200)
#define MDMA_Channel8_BASE    (MDMA_BASE + 0x00000240)
#define MDMA_Channel9_BASE    (MDMA_BASE + 0x00000280)
#define MDMA_Channel10_BASE   (MDMA_BASE + 0x000002C0)
#define MDMA_Channel11_BASE   (MDMA_BASE + 0x00000300)
#define MDMA_Channel12_BASE   (MDMA_BASE + 0x00000340)
#define MDMA_Channel13_BASE   (MDMA_BASE + 0x00000380)
#define MDMA_Channel14_BASE   (MDMA_BASE + 0x000003C0)
#define MDMA_Channel15_BASE   (MDMA_BASE + 0x00000400)
#define MDMA_Channel16_BASE   (MDMA_BASE + 0x00000440)
#define MDMA_Channel17_BASE   (MDMA_BASE + 0x00000480)
#define MDMA_Channel18_BASE   (MDMA_BASE + 0x000004C0)
#define MDMA_Channel19_BASE   (MDMA_BASE + 0x00000500)
#define MDMA_Channel20_BASE   (MDMA_BASE + 0x00000540)
#define MDMA_Channel21_BASE   (MDMA_BASE + 0x00000580)
#define MDMA_Channel22_BASE   (MDMA_BASE + 0x000005C0)
#define MDMA_Channel23_BASE   (MDMA_BASE + 0x00000600)
#define MDMA_Channel24_BASE   (MDMA_BASE + 0x00000640)
#define MDMA_Channel25_BASE   (MDMA_BASE + 0x00000680)
#define MDMA_Channel26_BASE   (MDMA_BASE + 0x000006C0)
#define MDMA_Channel27_BASE   (MDMA_BASE + 0x00000700)
#define MDMA_Channel28_BASE   (MDMA_BASE + 0x00000740)
#define MDMA_Channel29_BASE   (MDMA_BASE + 0x00000780)
#define MDMA_Channel30_BASE   (MDMA_BASE + 0x000007C0)
#define MDMA_Channel31_BASE   (MDMA_BASE + 0x00000800)

/**
  * @}
  */

/** @addtogroup Peripheral_declaration
  * @{
  */
#define TIM2                ((TIM_TypeDef *) TIM2_BASE)
#define TIM3                ((TIM_TypeDef *) TIM3_BASE)
#define TIM4                ((TIM_TypeDef *) TIM4_BASE)
#define TIM5                ((TIM_TypeDef *) TIM5_BASE)
#define TIM6                ((TIM_TypeDef *) TIM6_BASE)
#define TIM7                ((TIM_TypeDef *) TIM7_BASE)
#define TIM12               ((TIM_TypeDef *) TIM12_BASE)
#define TIM13               ((TIM_TypeDef *) TIM13_BASE)
#define TIM14               ((TIM_TypeDef *) TIM14_BASE)
#define LCD                 ((LCD_TypeDef *) LCD_BASE)
#define RTC                 ((RTC_TypeDef *) RTC_BASE)
#define TAMP                 ((TAMP_TypeDef *) TAMP_BASE)
#define WWDG1               ((WWDG_TypeDef *) WWDG1_BASE)
#define IWDG1               ((IWDG_TypeDef *) IWDG1_BASE)
#define IWDG2               ((IWDG_TypeDef *) IWDG2_BASE)
#define SPI2                ((SPI_TypeDef *) SPI2_BASE)
#define SPI3                ((SPI_TypeDef *) SPI3_BASE)
#define SPI4                ((SPI_TypeDef *) SPI4_BASE)
#define SPI5                ((SPI_TypeDef *) SPI5_BASE)
#define SPI6                ((SPI_TypeDef *) SPI6_BASE)
#define USART2              ((USART_TypeDef *) USART2_BASE)
#define USART3              ((USART_TypeDef *) USART3_BASE)
#define USART6              ((USART_TypeDef *) USART6_BASE)
#define UART7               ((USART_TypeDef *) UART7_BASE)
#define UART8               ((USART_TypeDef *) UART8_BASE)
#define UART4               ((USART_TypeDef *) UART4_BASE)
#define UART5               ((USART_TypeDef *) UART5_BASE)
#define I2C1                ((I2C_TypeDef *) I2C1_BASE)
#define I2C2                ((I2C_TypeDef *) I2C2_BASE)
#define I2C3                ((I2C_TypeDef *) I2C3_BASE)
#define I2C4                ((I2C_TypeDef *) I2C4_BASE)
#define I2C5                ((I2C_TypeDef *) I2C5_BASE)
#define I2C6                ((I2C_TypeDef *) I2C6_BASE)
#define FDCAN1              ((FDCAN_GlobalTypeDef *) FDCAN1_BASE)
#define FDCAN2              ((FDCAN_GlobalTypeDef *) FDCAN2_BASE)
#define TTFDCAN1            ((TTCAN_TypeDef *) TTFDCAN1_BASE)
#define FDCAN_CCU           ((FDCAN_ClockCalibrationUnit_TypeDef *) FDCAN_CCU_BASE)
#define CEC                 ((CEC_TypeDef *) CEC_BASE)
#define LPTIM1              ((LPTIM_TypeDef *) LPTIM1_BASE)
#define PWR                 ((PWR_TypeDef *) PWR_BASE)
#define DAC1                ((DAC_TypeDef *) DAC1_BASE)
#define LPTIM2              ((LPTIM_TypeDef *) LPTIM2_BASE)
#define LPTIM3              ((LPTIM_TypeDef *) LPTIM3_BASE)
#define LPTIM4              ((LPTIM_TypeDef *) LPTIM4_BASE)
#define LPTIM5              ((LPTIM_TypeDef *) LPTIM5_BASE)
#define SYSCFG              ((SYSCFG_TypeDef *) SYSCFG_BASE)
#define VREFBUF             ((VREF_TypeDef *) VREFBUF_BASE)



#define EXTI                ((EXTI_TypeDef *) EXTI_BASE)
#define EXTI_C1             ((EXTI_Core_TypeDef *) EXTI_C1_BASE)
#define EXTI_C2             ((EXTI_Core_TypeDef *) EXTI_C2_BASE)
#define TIM1                ((TIM_TypeDef *) TIM1_BASE)
#define SPI1                ((SPI_TypeDef *) SPI1_BASE)
#define TIM8                ((TIM_TypeDef *) TIM8_BASE)
#define USART1              ((USART_TypeDef *) USART1_BASE)
#define TIM15               ((TIM_TypeDef *) TIM15_BASE)
#define TIM16               ((TIM_TypeDef *) TIM16_BASE)
#define TIM17               ((TIM_TypeDef *) TIM17_BASE)
#define SAI1                ((SAI_TypeDef *) SAI1_BASE)
#define SAI1_Block_A        ((SAI_Block_TypeDef *)SAI1_Block_A_BASE)
#define SAI1_Block_B        ((SAI_Block_TypeDef *)SAI1_Block_B_BASE)
#define SAI2                ((SAI_TypeDef *) SAI2_BASE)
#define SAI2_Block_A        ((SAI_Block_TypeDef *)SAI2_Block_A_BASE)
#define SAI2_Block_B        ((SAI_Block_TypeDef *)SAI2_Block_B_BASE)
#define SAI3                ((SAI_TypeDef *) SAI3_BASE)
#define SAI3_Block_A        ((SAI_Block_TypeDef *)SAI3_Block_A_BASE)
#define SAI3_Block_B        ((SAI_Block_TypeDef *)SAI3_Block_B_BASE)
#define SAI4                ((SAI_TypeDef *) SAI4_BASE)
#define SAI4_Block_A        ((SAI_Block_TypeDef *)SAI4_Block_A_BASE)
#define SAI4_Block_B        ((SAI_Block_TypeDef *)SAI4_Block_B_BASE)
#define DTS1                ((DTS_TypeDef *) DTS_BASE)
#define PMB                 ((PMB_TypeDef *) PMB_BASE)
#define SPDIFRX             ((SPDIFRX_TypeDef *) SPDIFRX_BASE)
#define DFSDM1              ((DFSDM_TypeDef *) DFSDM1_BASE)
#define DFSDM1_Channel0     ((DFSDM_Channel_TypeDef *) DFSDM1_Channel0_BASE)
#define DFSDM1_Channel1     ((DFSDM_Channel_TypeDef *) DFSDM1_Channel1_BASE)
#define DFSDM1_Channel2     ((DFSDM_Channel_TypeDef *) DFSDM1_Channel2_BASE)
#define DFSDM1_Channel3     ((DFSDM_Channel_TypeDef *) DFSDM1_Channel3_BASE)
#define DFSDM1_Channel4     ((DFSDM_Channel_TypeDef *) DFSDM1_Channel4_BASE)
#define DFSDM1_Channel5     ((DFSDM_Channel_TypeDef *) DFSDM1_Channel5_BASE)
#define DFSDM1_Channel6     ((DFSDM_Channel_TypeDef *) DFSDM1_Channel6_BASE)
#define DFSDM1_Channel7     ((DFSDM_Channel_TypeDef *) DFSDM1_Channel7_BASE)
#define DFSDM1_Filter0      ((DFSDM_Filter_TypeDef *) DFSDM1_Filter0_BASE)
#define DFSDM1_Filter1      ((DFSDM_Filter_TypeDef *) DFSDM1_Filter1_BASE)
#define DFSDM1_Filter2      ((DFSDM_Filter_TypeDef *) DFSDM1_Filter2_BASE)
#define DFSDM1_Filter3      ((DFSDM_Filter_TypeDef *) DFSDM1_Filter3_BASE)
#define DFSDM1_Filter4      ((DFSDM_Filter_TypeDef *) DFSDM1_Filter4_BASE)
#define DFSDM1_Filter5      ((DFSDM_Filter_TypeDef *) DFSDM1_Filter5_BASE)
#define DCMI                ((DCMI_TypeDef *) DCMI_BASE)

#define RCC                 ((RCC_TypeDef *) RCC_BASE)

#define HDP                 ((HDP_TypeDef *) HDP_BASE)

#define BSEC                ((BSEC_TypeDef *) BSEC_BASE)


#define CRC2                 ((CRC_TypeDef *) CRC2_BASE)
#define CRC1                     ((CRC_TypeDef *) CRC1_BASE)

#define GPIOA               ((GPIO_TypeDef *) GPIOA_BASE)
#define GPIOB               ((GPIO_TypeDef *) GPIOB_BASE)
#define GPIOC               ((GPIO_TypeDef *) GPIOC_BASE)
#define GPIOD               ((GPIO_TypeDef *) GPIOD_BASE)
#define GPIOE               ((GPIO_TypeDef *) GPIOE_BASE)
#define GPIOF               ((GPIO_TypeDef *) GPIOF_BASE)
#define GPIOG               ((GPIO_TypeDef *) GPIOG_BASE)
#define GPIOH               ((GPIO_TypeDef *) GPIOH_BASE)
#define GPIOI               ((GPIO_TypeDef *) GPIOI_BASE)
#define GPIOJ               ((GPIO_TypeDef *) GPIOJ_BASE)
#define GPIOK               ((GPIO_TypeDef *) GPIOK_BASE)
#define ADC1                ((ADC_TypeDef *) ADC1_BASE)
#define ADC2                ((ADC_TypeDef *) ADC2_BASE)
#define ADC12_COMMON        ((ADC_Common_TypeDef *) ADC12_COMMON_BASE)

#define IPCC                ((IPCC_TypeDef *) IPCC_BASE)
#define IPCC_C1             ((IPCC_CommonTypeDef *) IPCC_BASE)
#define IPCC_C2             ((IPCC_CommonTypeDef *) (IPCC_BASE + 0x10U))
#define CRYP2               ((CRYP_TypeDef *) CRYP2_BASE)
#define CRYP1               ((CRYP_TypeDef *) CRYP1_BASE)
#define HASH2               ((HASH_TypeDef *) HASH2_BASE)
#define HASH1               ((HASH_TypeDef *) HASH1_BASE)
#define HASH2_DIGEST        ((HASH_DIGEST_TypeDef *) HASH2_DIGEST_BASE)
#define HASH1_DIGEST        ((HASH_DIGEST_TypeDef *) HASH1_DIGEST_BASE)
#define HASH                ((HASH_TypeDef *) HASH2)
#define HASH_DIGEST         ((HASH_DIGEST_TypeDef *) HASH2_DIGEST)
#define RNG2                ((RNG_TypeDef *) RNG2_BASE)
#define RNG1                ((RNG_TypeDef *) RNG1_BASE)
#define GPIOZ               ((GPIO_TypeDef *) GPIOZ_BASE)
#define SDMMC2              ((SDMMC_TypeDef *) SDMMC2_BASE)

#define DLYB_SDMMC1         ((DLYB_TypeDef *) DLYB_SDMMC1_BASE)
#define DLYB_SDMMC2         ((DLYB_TypeDef *) DLYB_SDMMC2_BASE)
#define DLYB_SDMMC3         ((DLYB_TypeDef *) DLYB_SDMMC3_BASE)


#define DMA2                ((DMA_TypeDef *) DMA2_BASE)
#define DMA2_Stream0        ((DMA_Stream_TypeDef *) DMA2_Stream0_BASE)
#define DMA2_Stream1        ((DMA_Stream_TypeDef *) DMA2_Stream1_BASE)
#define DMA2_Stream2        ((DMA_Stream_TypeDef *) DMA2_Stream2_BASE)
#define DMA2_Stream3        ((DMA_Stream_TypeDef *) DMA2_Stream3_BASE)
#define DMA2_Stream4        ((DMA_Stream_TypeDef *) DMA2_Stream4_BASE)
#define DMA2_Stream5        ((DMA_Stream_TypeDef *) DMA2_Stream5_BASE)
#define DMA2_Stream6        ((DMA_Stream_TypeDef *) DMA2_Stream6_BASE)
#define DMA2_Stream7        ((DMA_Stream_TypeDef *) DMA2_Stream7_BASE)

#define DMA1                ((DMA_TypeDef *) DMA1_BASE)
#define DMA1_Stream0        ((DMA_Stream_TypeDef *) DMA1_Stream0_BASE)
#define DMA1_Stream1        ((DMA_Stream_TypeDef *) DMA1_Stream1_BASE)
#define DMA1_Stream2        ((DMA_Stream_TypeDef *) DMA1_Stream2_BASE)
#define DMA1_Stream3        ((DMA_Stream_TypeDef *) DMA1_Stream3_BASE)
#define DMA1_Stream4        ((DMA_Stream_TypeDef *) DMA1_Stream4_BASE)
#define DMA1_Stream5        ((DMA_Stream_TypeDef *) DMA1_Stream5_BASE)
#define DMA1_Stream6        ((DMA_Stream_TypeDef *) DMA1_Stream6_BASE)
#define DMA1_Stream7        ((DMA_Stream_TypeDef *) DMA1_Stream7_BASE)

#define DMAMUX1              ((DMAMUX_Channel_TypeDef *) DMAMUX1_BASE)
#define DMAMUX1_Channel0     ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel0_BASE)
#define DMAMUX1_Channel1     ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel1_BASE)
#define DMAMUX1_Channel2     ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel2_BASE)
#define DMAMUX1_Channel3     ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel3_BASE)
#define DMAMUX1_Channel4     ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel4_BASE)
#define DMAMUX1_Channel5     ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel5_BASE)
#define DMAMUX1_Channel6     ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel6_BASE)
#define DMAMUX1_Channel7     ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel7_BASE)
#define DMAMUX1_Channel8     ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel8_BASE)
#define DMAMUX1_Channel9     ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel9_BASE)
#define DMAMUX1_Channel10    ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel10_BASE)
#define DMAMUX1_Channel11    ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel11_BASE)
#define DMAMUX1_Channel12    ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel12_BASE)
#define DMAMUX1_Channel13    ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel13_BASE)
#define DMAMUX1_Channel14    ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel14_BASE)
#define DMAMUX1_Channel15    ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel15_BASE)

#define DMAMUX1_RequestGenerator0  ((DMAMUX_RequestGen_TypeDef *) DMAMUX1_RequestGenerator0_BASE)
#define DMAMUX1_RequestGenerator1  ((DMAMUX_RequestGen_TypeDef *) DMAMUX1_RequestGenerator1_BASE)
#define DMAMUX1_RequestGenerator2  ((DMAMUX_RequestGen_TypeDef *) DMAMUX1_RequestGenerator2_BASE)
#define DMAMUX1_RequestGenerator3  ((DMAMUX_RequestGen_TypeDef *) DMAMUX1_RequestGenerator3_BASE)

#define DMAMUX1_ChannelStatus      ((DMAMUX_ChannelStatus_TypeDef *)    DMAMUX1_ChannelStatus_BASE)
#define DMAMUX1_RequestGenStatus   ((DMAMUX_RequestGenStatus_TypeDef *) DMAMUX1_RequestGenStatus_BASE)


#define FMC_Bank1_R         ((FMC_Bank1_TypeDef *) FMC_Bank1_R_BASE)
#define FMC_Bank1E_R        ((FMC_Bank1E_TypeDef *) FMC_Bank1E_R_BASE)
#define FMC_Bank3_R         ((FMC_Bank3_TypeDef *) FMC_Bank3_R_BASE)

#define QUADSPI               ((QUADSPI_TypeDef *) QSPI_R_BASE)
#define DLYB_QUADSPI          ((DLYB_TypeDef *) DLYB_QSPI_BASE)

#define SDMMC1                ((SDMMC_TypeDef *) SDMMC1_BASE)
#define SDMMC3                ((SDMMC_TypeDef *) SDMMC3_BASE)

#define DBGMCU              ((DBGMCU_TypeDef *) DBGMCU_BASE)

#define JPEG                ((JPEG_TypeDef *) JPGDEC_BASE)
#define HSEM                ((HSEM_TypeDef *) HSEM_BASE)
#define HSEM_COMMON         ((HSEM_Common_TypeDef *) (HSEM_BASE + 0x110U))


#define USBPHYC             ((USBPHYC_GlobalTypeDef *)USBPHYC_BASE)
#define USBPHYC_PHY1        ((USBPHYC_InstanceTypeDef *)USBPHYC_PHY1_BASE)
#define USBPHYC_PHY2        ((USBPHYC_InstanceTypeDef *)USBPHYC_PHY2_BASE)

#define DDRCTRL             ((DDRCTRL_TypeDef *)DDRCTRL_BASE)
#define DDRPERFM            ((DDRPERFM_TypeDef *)DDRPERFM_BASE)
#define DDRPHYC             ((DDRPHYC_TypeDef *)DDRPHYC_BASE)
#define LTDC                ((LTDC_TypeDef *)LTDC_BASE)
#define LTDC_Layer1         ((LTDC_Layer_TypeDef *)LTDC_Layer1_BASE)
#define LTDC_Layer2         ((LTDC_Layer_TypeDef *)LTDC_Layer2_BASE)

#define TZC                 ((TZC_TypeDef *)TZC_BASE)
#define TZPC                ((TZPC_TypeDef *)TZPC_BASE)
#define STGENC              ((STGENC_TypeDef *)STGENC_BASE)
#define STGENR              ((STGENR_TypeDef *)STGENR_BASE)

#define MDIOS               ((MDIOS_TypeDef *) MDIOS_BASE)

#define ETH                 ((ETH_TypeDef *) ETH_BASE)
#define MDMA                ((MDMA_TypeDef *) MDMA_BASE)
#define MDMA_Channel0       ((MDMA_Channel_TypeDef *)MDMA_Channel0_BASE)
#define MDMA_Channel1       ((MDMA_Channel_TypeDef *)MDMA_Channel1_BASE)
#define MDMA_Channel2       ((MDMA_Channel_TypeDef *)MDMA_Channel2_BASE)
#define MDMA_Channel3       ((MDMA_Channel_TypeDef *)MDMA_Channel3_BASE)
#define MDMA_Channel4       ((MDMA_Channel_TypeDef *)MDMA_Channel4_BASE)
#define MDMA_Channel5       ((MDMA_Channel_TypeDef *)MDMA_Channel5_BASE)
#define MDMA_Channel6       ((MDMA_Channel_TypeDef *)MDMA_Channel6_BASE)
#define MDMA_Channel7       ((MDMA_Channel_TypeDef *)MDMA_Channel7_BASE)
#define MDMA_Channel8       ((MDMA_Channel_TypeDef *)MDMA_Channel8_BASE)
#define MDMA_Channel9       ((MDMA_Channel_TypeDef *)MDMA_Channel9_BASE)
#define MDMA_Channel10      ((MDMA_Channel_TypeDef *)MDMA_Channel10_BASE)
#define MDMA_Channel11      ((MDMA_Channel_TypeDef *)MDMA_Channel11_BASE)
#define MDMA_Channel12      ((MDMA_Channel_TypeDef *)MDMA_Channel12_BASE)
#define MDMA_Channel13      ((MDMA_Channel_TypeDef *)MDMA_Channel13_BASE)
#define MDMA_Channel14      ((MDMA_Channel_TypeDef *)MDMA_Channel14_BASE)
#define MDMA_Channel15      ((MDMA_Channel_TypeDef *)MDMA_Channel15_BASE)
#define MDMA_Channel16      ((MDMA_Channel_TypeDef *)MDMA_Channel16_BASE)
#define MDMA_Channel17      ((MDMA_Channel_TypeDef *)MDMA_Channel17_BASE)
#define MDMA_Channel18      ((MDMA_Channel_TypeDef *)MDMA_Channel18_BASE)
#define MDMA_Channel19      ((MDMA_Channel_TypeDef *)MDMA_Channel19_BASE)
#define MDMA_Channel20      ((MDMA_Channel_TypeDef *)MDMA_Channel20_BASE)
#define MDMA_Channel21      ((MDMA_Channel_TypeDef *)MDMA_Channel21_BASE)
#define MDMA_Channel22      ((MDMA_Channel_TypeDef *)MDMA_Channel22_BASE)
#define MDMA_Channel23      ((MDMA_Channel_TypeDef *)MDMA_Channel23_BASE)
#define MDMA_Channel24      ((MDMA_Channel_TypeDef *)MDMA_Channel24_BASE)
#define MDMA_Channel25      ((MDMA_Channel_TypeDef *)MDMA_Channel25_BASE)
#define MDMA_Channel26      ((MDMA_Channel_TypeDef *)MDMA_Channel26_BASE)
#define MDMA_Channel27      ((MDMA_Channel_TypeDef *)MDMA_Channel27_BASE)
#define MDMA_Channel28      ((MDMA_Channel_TypeDef *)MDMA_Channel28_BASE)
#define MDMA_Channel29      ((MDMA_Channel_TypeDef *)MDMA_Channel29_BASE)
#define MDMA_Channel30      ((MDMA_Channel_TypeDef *)MDMA_Channel30_BASE)
#define MDMA_Channel31      ((MDMA_Channel_TypeDef *)MDMA_Channel31_BASE)

#define USB_OTG_HS            ((USB_OTG_GlobalTypeDef *) USBOTG_BASE)
/* backward compatibility */
#define USB1_OTG_HS           USB_OTG_HS
#define USB2_OTG_FS           ((USB_OTG_GlobalTypeDef *) 0x00000000)
#define USB_OTG_FS            USB2_OTG_FS

#define USB1_EHCI             ((USB_EHCI_CapabilityTypeDef *) USB1HSFSP1_BASE)




/**
  * @}
  */

/** @addtogroup Exported_constants
  * @{
  */

  /** @addtogroup Peripheral_Registers_Bits_Definition
  * @{
  */

/******************************************************************************/
/*                         Peripheral Registers_Bits_Definition               */
/******************************************************************************/

/******************************************************************************/
/*                                                                            */
/*                        Device Electronic Signature                         */
/*                                                                            */
/******************************************************************************/
#define PKG_ID_Pos              (27U)
#define PKG_ID_Msk              (0x7U << PKG_ID_Pos)        /*!< 0x38000000 */
#define PKG_ID                  PKG_ID_Msk                  /*!< Package Type */

#define RPN_ID_Pos              (0U)
#define RPN_ID_Msk              (0xFFU << RPN_ID_Pos)       /*!< 0x000000FF */
#define RPN_ID                  RPN_ID_Msk                  /*!< Device Part Number */

#define DV_DEV_ID_Pos           (0U)
#define DV_DEV_ID_Msk           (0xFFFU << DV_DEV_ID_Pos)   /*!< 0x00000FFF */
#define DV_DEV_ID               DV_DEV_ID_Msk               /*!< Device ID */
#define DV_REV_ID_Pos           (16U)
#define DV_REV_ID_Msk           (0xFFFFU << DV_REV_ID_Pos)  /*!< 0xFFFF0000 */
#define DV_REV_ID               DV_REV_ID_Msk               /*!< Device Rev ID */

/******************************************************************************/
/*                                                                            */
/*                        Analog to Digital Converter                         */
/*                                                                            */
/******************************************************************************/
/*
* @brief Specific device feature definitions
*/
#define ADC_MULTIMODE_SUPPORT                          /*!< ADC feature available only on specific devices: multimode available on devices with several ADC instances */

/********************  Bit definition for ADC_ISR register  ********************/
#define ADC_ISR_ADRDY_Pos                  (0U)
#define ADC_ISR_ADRDY_Msk                  (0x1U << ADC_ISR_ADRDY_Pos)           /*!< 0x00000001 */
#define ADC_ISR_ADRDY                      ADC_ISR_ADRDY_Msk                     /*!< ADC Ready (ADRDY) flag  */
#define ADC_ISR_EOSMP_Pos                 (1U)
#define ADC_ISR_EOSMP_Msk                 (0x1U << ADC_ISR_EOSMP_Pos)          /*!< 0x00000002 */
#define ADC_ISR_EOSMP                     ADC_ISR_EOSMP_Msk                    /*!< ADC End of Sampling flag */
#define ADC_ISR_EOC_Pos                   (2U)
#define ADC_ISR_EOC_Msk                   (0x1U << ADC_ISR_EOC_Pos)            /*!< 0x00000004 */
#define ADC_ISR_EOC                       ADC_ISR_EOC_Msk                      /*!< ADC End of Regular Conversion flag */
#define ADC_ISR_EOS_Pos                   (3U)
#define ADC_ISR_EOS_Msk                   (0x1U << ADC_ISR_EOS_Pos)            /*!< 0x00000008 */
#define ADC_ISR_EOS                       ADC_ISR_EOS_Msk                      /*!< ADC End of Regular sequence of Conversions flag */
#define ADC_ISR_OVR_Pos                   (4U)
#define ADC_ISR_OVR_Msk                   (0x1U << ADC_ISR_OVR_Pos)            /*!< 0x00000010 */
#define ADC_ISR_OVR                       ADC_ISR_OVR_Msk                      /*!< ADC overrun flag */
#define ADC_ISR_JEOC_Pos                  (5U)
#define ADC_ISR_JEOC_Msk                  (0x1U << ADC_ISR_JEOC_Pos)           /*!< 0x00000020 */
#define ADC_ISR_JEOC                      ADC_ISR_JEOC_Msk                     /*!< ADC End of Injected Conversion flag */
#define ADC_ISR_JEOS_Pos                  (6U)
#define ADC_ISR_JEOS_Msk                  (0x1U << ADC_ISR_JEOS_Pos)           /*!< 0x00000040 */
#define ADC_ISR_JEOS                      ADC_ISR_JEOS_Msk                     /*!< ADC End of Injected sequence of Conversions flag */
#define ADC_ISR_AWD1_Pos                  (7U)
#define ADC_ISR_AWD1_Msk                  (0x1U << ADC_ISR_AWD1_Pos)           /*!< 0x00000080 */
#define ADC_ISR_AWD1                      ADC_ISR_AWD1_Msk                     /*!< ADC Analog watchdog 1 flag */
#define ADC_ISR_AWD2_Pos                  (8U)
#define ADC_ISR_AWD2_Msk                  (0x1U << ADC_ISR_AWD2_Pos)           /*!< 0x00000100 */
#define ADC_ISR_AWD2                      ADC_ISR_AWD2_Msk                     /*!< ADC Analog watchdog 2 flag */
#define ADC_ISR_AWD3_Pos                  (9U)
#define ADC_ISR_AWD3_Msk                  (0x1U << ADC_ISR_AWD3_Pos)           /*!< 0x00000200 */
#define ADC_ISR_AWD3                      ADC_ISR_AWD3_Msk                     /*!< ADC Analog watchdog 3 flag */
#define ADC_ISR_JQOVF_Pos                 (10U)
#define ADC_ISR_JQOVF_Msk                 (0x1U << ADC_ISR_JQOVF_Pos)          /*!< 0x00000400 */
#define ADC_ISR_JQOVF                     ADC_ISR_JQOVF_Msk                    /*!< ADC Injected Context Queue Overflow flag */

/********************  Bit definition for ADC_IER register  ********************/
#define ADC_IER_ADRDYIE_Pos               (0U)
#define ADC_IER_ADRDYIE_Msk               (0x1U << ADC_IER_ADRDYIE_Pos)            /*!< 0x00000001 */
#define ADC_IER_ADRDYIE                   ADC_IER_ADRDYIE_Msk                      /*!< ADC Ready (ADRDY) interrupt source */
#define ADC_IER_EOSMPIE_Pos               (1U)
#define ADC_IER_EOSMPIE_Msk               (0x1U << ADC_IER_EOSMPIE_Pos)          /*!< 0x00000002 */
#define ADC_IER_EOSMPIE                   ADC_IER_EOSMPIE_Msk                    /*!< ADC End of Sampling interrupt source */
#define ADC_IER_EOCIE_Pos                 (2U)
#define ADC_IER_EOCIE_Msk                 (0x1U << ADC_IER_EOCIE_Pos)            /*!< 0x00000004 */
#define ADC_IER_EOCIE                     ADC_IER_EOCIE_Msk                      /*!< ADC End of Regular Conversion interrupt source */
#define ADC_IER_EOSIE_Pos                 (3U)
#define ADC_IER_EOSIE_Msk                 (0x1U << ADC_IER_EOSIE_Pos)            /*!< 0x00000008 */
#define ADC_IER_EOSIE                     ADC_IER_EOSIE_Msk                      /*!< ADC End of Regular sequence of Conversions interrupt source */
#define ADC_IER_OVRIE_Pos                 (4U)
#define ADC_IER_OVRIE_Msk                 (0x1U << ADC_IER_OVRIE_Pos)            /*!< 0x00000010 */
#define ADC_IER_OVRIE                     ADC_IER_OVRIE_Msk                      /*!< ADC overrun interrupt source */
#define ADC_IER_JEOCIE_Pos                (5U)
#define ADC_IER_JEOCIE_Msk                (0x1U << ADC_IER_JEOCIE_Pos)           /*!< 0x00000020 */
#define ADC_IER_JEOCIE                    ADC_IER_JEOCIE_Msk                     /*!< ADC End of Injected Conversion interrupt source */
#define ADC_IER_JEOSIE_Pos                (6U)
#define ADC_IER_JEOSIE_Msk                (0x1U << ADC_IER_JEOSIE_Pos)           /*!< 0x00000040 */
#define ADC_IER_JEOSIE                    ADC_IER_JEOSIE_Msk                     /*!< ADC End of Injected sequence of Conversions interrupt source */
#define ADC_IER_AWD1IE_Pos                (7U)
#define ADC_IER_AWD1IE_Msk                (0x1U << ADC_IER_AWD1IE_Pos)           /*!< 0x00000080 */
#define ADC_IER_AWD1IE                    ADC_IER_AWD1IE_Msk                     /*!< ADC Analog watchdog 1 interrupt source */
#define ADC_IER_AWD2IE_Pos                (8U)
#define ADC_IER_AWD2IE_Msk                (0x1U << ADC_IER_AWD2IE_Pos)           /*!< 0x00000100 */
#define ADC_IER_AWD2IE                    ADC_IER_AWD2IE_Msk                     /*!< ADC Analog watchdog 2 interrupt source */
#define ADC_IER_AWD3IE_Pos                (9U)
#define ADC_IER_AWD3IE_Msk                (0x1U << ADC_IER_AWD3IE_Pos)           /*!< 0x00000200 */
#define ADC_IER_AWD3IE                    ADC_IER_AWD3IE_Msk                     /*!< ADC Analog watchdog 3 interrupt source */
#define ADC_IER_JQOVFIE_Pos               (10U)
#define ADC_IER_JQOVFIE_Msk               (0x1U << ADC_IER_JQOVFIE_Pos)          /*!< 0x00000400 */
#define ADC_IER_JQOVFIE                   ADC_IER_JQOVFIE_Msk                    /*!< ADC Injected Context Queue Overflow interrupt source */

/********************  Bit definition for ADC_CR register  ********************/
#define ADC_CR_ADEN_Pos                   (0U)
#define ADC_CR_ADEN_Msk                   (0x1U << ADC_CR_ADEN_Pos)            /*!< 0x00000001 */
#define ADC_CR_ADEN                       ADC_CR_ADEN_Msk                      /*!< ADC Enable control */
#define ADC_CR_ADDIS_Pos                  (1U)
#define ADC_CR_ADDIS_Msk                  (0x1U << ADC_CR_ADDIS_Pos)           /*!< 0x00000002 */
#define ADC_CR_ADDIS                      ADC_CR_ADDIS_Msk                     /*!< ADC Disable command */
#define ADC_CR_ADSTART_Pos                (2U)
#define ADC_CR_ADSTART_Msk                (0x1U << ADC_CR_ADSTART_Pos)         /*!< 0x00000004 */
#define ADC_CR_ADSTART                    ADC_CR_ADSTART_Msk                   /*!< ADC Start of Regular conversion */
#define ADC_CR_JADSTART_Pos               (3U)
#define ADC_CR_JADSTART_Msk               (0x1U << ADC_CR_JADSTART_Pos)        /*!< 0x00000008 */
#define ADC_CR_JADSTART                   ADC_CR_JADSTART_Msk                  /*!< ADC Start of injected conversion */
#define ADC_CR_ADSTP_Pos                  (4U)
#define ADC_CR_ADSTP_Msk                  (0x1U << ADC_CR_ADSTP_Pos)           /*!< 0x00000010 */
#define ADC_CR_ADSTP                      ADC_CR_ADSTP_Msk                     /*!< ADC Stop of Regular conversion */
#define ADC_CR_JADSTP_Pos                 (5U)
#define ADC_CR_JADSTP_Msk                 (0x1U << ADC_CR_JADSTP_Pos)          /*!< 0x00000020 */
#define ADC_CR_JADSTP                     ADC_CR_JADSTP_Msk                    /*!< ADC Stop of injected conversion */
#define ADC_CR_BOOST_Pos                  (8U)
#define ADC_CR_BOOST_Msk                  (0x1U << ADC_CR_BOOST_Pos)           /*!< 0x00000100 */
#define ADC_CR_BOOST                      ADC_CR_BOOST_Msk                     /*!< ADC Boost Mode */
#define ADC_CR_ADCALLIN_Pos               (16U)
#define ADC_CR_ADCALLIN_Msk               (0x1U << ADC_CR_ADCALLIN_Pos)        /*!< 0x00010000 */
#define ADC_CR_ADCALLIN                   ADC_CR_ADCALLIN_Msk                  /*!< ADC Linearity calibration */
#define ADC_CR_LINCALRDYW1_Pos            (22U)
#define ADC_CR_LINCALRDYW1_Msk            (0x1U << ADC_CR_LINCALRDYW1_Pos)     /*!< 0x00400000 */
#define ADC_CR_LINCALRDYW1                ADC_CR_LINCALRDYW1_Msk               /*!< ADC Linearity calibration ready Word 1 */
#define ADC_CR_LINCALRDYW2_Pos            (23U)
#define ADC_CR_LINCALRDYW2_Msk            (0x1U << ADC_CR_LINCALRDYW2_Pos)     /*!< 0x00800000 */
#define ADC_CR_LINCALRDYW2                ADC_CR_LINCALRDYW2_Msk               /*!< ADC Linearity calibration ready Word 2 */
#define ADC_CR_LINCALRDYW3_Pos            (24U)
#define ADC_CR_LINCALRDYW3_Msk            (0x1U << ADC_CR_LINCALRDYW3_Pos)     /*!< 0x01000000 */
#define ADC_CR_LINCALRDYW3                ADC_CR_LINCALRDYW3_Msk               /*!< ADC Linearity calibration ready Word 3 */
#define ADC_CR_LINCALRDYW4_Pos            (25U)
#define ADC_CR_LINCALRDYW4_Msk            (0x1U << ADC_CR_LINCALRDYW4_Pos)     /*!< 0x02000000 */
#define ADC_CR_LINCALRDYW4                ADC_CR_LINCALRDYW4_Msk               /*!< ADC Linearity calibration ready Word 4 */
#define ADC_CR_LINCALRDYW5_Pos            (26U)
#define ADC_CR_LINCALRDYW5_Msk            (0x1U << ADC_CR_LINCALRDYW5_Pos)     /*!< 0x04000000 */
#define ADC_CR_LINCALRDYW5                ADC_CR_LINCALRDYW5_Msk               /*!< ADC Linearity calibration ready Word 5 */
#define ADC_CR_LINCALRDYW6_Pos            (27U)
#define ADC_CR_LINCALRDYW6_Msk            (0x1U << ADC_CR_LINCALRDYW6_Pos)     /*!< 0x08000000 */
#define ADC_CR_LINCALRDYW6                ADC_CR_LINCALRDYW6_Msk               /*!< ADC Linearity calibration ready Word 6 */
#define ADC_CR_ADVREGEN_Pos               (28U)
#define ADC_CR_ADVREGEN_Msk               (0x1U << ADC_CR_ADVREGEN_Pos)        /*!< 0x10000000 */
#define ADC_CR_ADVREGEN                   ADC_CR_ADVREGEN_Msk                  /*!< ADC Voltage regulator Enable */
#define ADC_CR_DEEPPWD_Pos                (29U)
#define ADC_CR_DEEPPWD_Msk                (0x1U << ADC_CR_DEEPPWD_Pos)         /*!< 0x20000000 */
#define ADC_CR_DEEPPWD                    ADC_CR_DEEPPWD_Msk                   /*!< ADC Deep power down Enable */
#define ADC_CR_ADCALDIF_Pos               (30U)
#define ADC_CR_ADCALDIF_Msk               (0x1U << ADC_CR_ADCALDIF_Pos)        /*!< 0x40000000 */
#define ADC_CR_ADCALDIF                   ADC_CR_ADCALDIF_Msk                  /*!< ADC Differential Mode for calibration */
#define ADC_CR_ADCAL_Pos                  (31U)
#define ADC_CR_ADCAL_Msk                  (0x1U << ADC_CR_ADCAL_Pos)           /*!< 0x80000000 */
#define ADC_CR_ADCAL                      ADC_CR_ADCAL_Msk                     /*!< ADC Calibration */

/********************  Bit definition for ADC_CFGR register  ********************/
#define ADC_CFGR_DMNGT_Pos                (0U)
#define ADC_CFGR_DMNGT_Msk                (0x3U << ADC_CFGR_DMNGT_Pos)         /*!< 0x00000003 */
#define ADC_CFGR_DMNGT                    ADC_CFGR_DMNGT_Msk                   /*!< ADC Data Management configuration */
#define ADC_CFGR_DMNGT_0                  (0x1U << ADC_CFGR_DMNGT_Pos)         /*!< 0x00000001 */
#define ADC_CFGR_DMNGT_1                  (0x2U << ADC_CFGR_DMNGT_Pos)         /*!< 0x00000002 */

#define ADC_CFGR_RES_Pos                  (2U)
#define ADC_CFGR_RES_Msk                  (0x7U << ADC_CFGR_RES_Pos)           /*!< 0x0000001C */
#define ADC_CFGR_RES                      ADC_CFGR_RES_Msk                     /*!< ADC Data resolution */
#define ADC_CFGR_RES_0                    (0x1U << ADC_CFGR_RES_Pos)           /*!< 0x00000004 */
#define ADC_CFGR_RES_1                    (0x2U << ADC_CFGR_RES_Pos)           /*!< 0x00000008 */
#define ADC_CFGR_RES_2                    (0x4U << ADC_CFGR_RES_Pos)           /*!< 0x00000010 */

#define ADC_CFGR_EXTSEL_Pos               (5U)
#define ADC_CFGR_EXTSEL_Msk               (0x1FU << ADC_CFGR_EXTSEL_Pos)       /*!< 0x000003E0 */
#define ADC_CFGR_EXTSEL                   ADC_CFGR_EXTSEL_Msk                  /*!< ADC External trigger selection for regular group */
#define ADC_CFGR_EXTSEL_0                 (0x01U << ADC_CFGR_EXTSEL_Pos)       /*!< 0x00000020 */
#define ADC_CFGR_EXTSEL_1                 (0x02U << ADC_CFGR_EXTSEL_Pos)       /*!< 0x00000040 */
#define ADC_CFGR_EXTSEL_2                 (0x04U << ADC_CFGR_EXTSEL_Pos)       /*!< 0x00000080 */
#define ADC_CFGR_EXTSEL_3                 (0x08U << ADC_CFGR_EXTSEL_Pos)       /*!< 0x00000100 */
#define ADC_CFGR_EXTSEL_4                 (0x10U << ADC_CFGR_EXTSEL_Pos)       /*!< 0x00000200 */

#define ADC_CFGR_EXTEN_Pos                (10U)
#define ADC_CFGR_EXTEN_Msk                (0x3U << ADC_CFGR_EXTEN_Pos)         /*!< 0x00000C00 */
#define ADC_CFGR_EXTEN                    ADC_CFGR_EXTEN_Msk                   /*!< ADC External trigger enable and polarity selection for regular channels */
#define ADC_CFGR_EXTEN_0                  (0x1U << ADC_CFGR_EXTEN_Pos)         /*!< 0x00000400 */
#define ADC_CFGR_EXTEN_1                  (0x2U << ADC_CFGR_EXTEN_Pos)         /*!< 0x00000800 */

#define ADC_CFGR_OVRMOD_Pos               (12U)
#define ADC_CFGR_OVRMOD_Msk               (0x1U << ADC_CFGR_OVRMOD_Pos)        /*!< 0x00001000 */
#define ADC_CFGR_OVRMOD                   ADC_CFGR_OVRMOD_Msk                  /*!< ADC overrun mode */
#define ADC_CFGR_CONT_Pos                 (13U)
#define ADC_CFGR_CONT_Msk                 (0x1U << ADC_CFGR_CONT_Pos)          /*!< 0x00002000 */
#define ADC_CFGR_CONT                     ADC_CFGR_CONT_Msk                    /*!< ADC Single/continuous conversion mode for regular conversion */
#define ADC_CFGR_AUTDLY_Pos               (14U)
#define ADC_CFGR_AUTDLY_Msk               (0x1U << ADC_CFGR_AUTDLY_Pos)        /*!< 0x00004000 */
#define ADC_CFGR_AUTDLY                   ADC_CFGR_AUTDLY_Msk                  /*!< ADC Delayed conversion mode */

#define ADC_CFGR_DISCEN_Pos               (16U)
#define ADC_CFGR_DISCEN_Msk               (0x1U << ADC_CFGR_DISCEN_Pos)        /*!< 0x00010000 */
#define ADC_CFGR_DISCEN                   ADC_CFGR_DISCEN_Msk                  /*!< ADC Discontinuous mode for regular channels */

#define ADC_CFGR_DISCNUM_Pos              (17U)
#define ADC_CFGR_DISCNUM_Msk              (0x7U << ADC_CFGR_DISCNUM_Pos)       /*!< 0x000E0000 */
#define ADC_CFGR_DISCNUM                  ADC_CFGR_DISCNUM_Msk                 /*!< ADC Discontinuous mode channel count */
#define ADC_CFGR_DISCNUM_0                (0x1U << ADC_CFGR_DISCNUM_Pos)       /*!< 0x00020000 */
#define ADC_CFGR_DISCNUM_1                (0x2U << ADC_CFGR_DISCNUM_Pos)       /*!< 0x00040000 */
#define ADC_CFGR_DISCNUM_2                (0x4U << ADC_CFGR_DISCNUM_Pos)       /*!< 0x00080000 */

#define ADC_CFGR_JDISCEN_Pos              (20U)
#define ADC_CFGR_JDISCEN_Msk              (0x1U << ADC_CFGR_JDISCEN_Pos)       /*!< 0x00100000 */
#define ADC_CFGR_JDISCEN                  ADC_CFGR_JDISCEN_Msk                 /*!< ADC Discontinuous mode on injected channels */
#define ADC_CFGR_JQM_Pos                  (21U)
#define ADC_CFGR_JQM_Msk                  (0x1U << ADC_CFGR_JQM_Pos)           /*!< 0x00200000 */
#define ADC_CFGR_JQM                      ADC_CFGR_JQM_Msk                     /*!< ADC JSQR Queue mode */
#define ADC_CFGR_AWD1SGL_Pos              (22U)
#define ADC_CFGR_AWD1SGL_Msk              (0x1U << ADC_CFGR_AWD1SGL_Pos)       /*!< 0x00400000 */
#define ADC_CFGR_AWD1SGL                  ADC_CFGR_AWD1SGL_Msk                 /*!< Enable the watchdog 1 on a single channel or on all channels */
#define ADC_CFGR_AWD1EN_Pos               (23U)
#define ADC_CFGR_AWD1EN_Msk               (0x1U << ADC_CFGR_AWD1EN_Pos)        /*!< 0x00800000 */
#define ADC_CFGR_AWD1EN                   ADC_CFGR_AWD1EN_Msk                  /*!< ADC Analog watchdog 1 enable on regular Channels */
#define ADC_CFGR_JAWD1EN_Pos              (24U)
#define ADC_CFGR_JAWD1EN_Msk              (0x1U << ADC_CFGR_JAWD1EN_Pos)       /*!< 0x01000000 */
#define ADC_CFGR_JAWD1EN                  ADC_CFGR_JAWD1EN_Msk                 /*!< ADC Analog watchdog 1 enable on injected Channels */
#define ADC_CFGR_JAUTO_Pos                (25U)
#define ADC_CFGR_JAUTO_Msk                (0x1U << ADC_CFGR_JAUTO_Pos)         /*!< 0x02000000 */
#define ADC_CFGR_JAUTO                    ADC_CFGR_JAUTO_Msk                   /*!< ADC Automatic injected group conversion */

#define ADC_CFGR_AWD1CH_Pos               (26U)
#define ADC_CFGR_AWD1CH_Msk               (0x1FU << ADC_CFGR_AWD1CH_Pos)       /*!< 0x7C000000 */
#define ADC_CFGR_AWD1CH                   ADC_CFGR_AWD1CH_Msk                  /*!< ADC Analog watchdog 1 Channel selection */
#define ADC_CFGR_AWD1CH_0                 (0x01U << ADC_CFGR_AWD1CH_Pos)       /*!< 0x04000000 */
#define ADC_CFGR_AWD1CH_1                 (0x02U << ADC_CFGR_AWD1CH_Pos)       /*!< 0x08000000 */
#define ADC_CFGR_AWD1CH_2                 (0x04U << ADC_CFGR_AWD1CH_Pos)       /*!< 0x10000000 */
#define ADC_CFGR_AWD1CH_3                 (0x08U << ADC_CFGR_AWD1CH_Pos)       /*!< 0x20000000 */
#define ADC_CFGR_AWD1CH_4                 (0x10U << ADC_CFGR_AWD1CH_Pos)       /*!< 0x40000000 */

#define ADC_CFGR_JQDIS_Pos                (31U)
#define ADC_CFGR_JQDIS_Msk                (0x1U << ADC_CFGR_JQDIS_Pos)         /*!< 0x80000000 */
#define ADC_CFGR_JQDIS                    ADC_CFGR_JQDIS_Msk                   /*!< ADC Injected queue disable */

/********************  Bit definition for ADC_CFGR2 register  ********************/
#define ADC_CFGR2_ROVSE_Pos               (0U)
#define ADC_CFGR2_ROVSE_Msk               (0x1U << ADC_CFGR2_ROVSE_Pos)        /*!< 0x00000001 */
#define ADC_CFGR2_ROVSE                   ADC_CFGR2_ROVSE_Msk                  /*!< ADC Regular group oversampler enable */
#define ADC_CFGR2_JOVSE_Pos               (1U)
#define ADC_CFGR2_JOVSE_Msk               (0x1U << ADC_CFGR2_JOVSE_Pos)        /*!< 0x00000002 */
#define ADC_CFGR2_JOVSE                   ADC_CFGR2_JOVSE_Msk                  /*!< ADC Injected group oversampler enable */

#define ADC_CFGR2_OVSR_Pos                (2U)
#define ADC_CFGR2_OVSR_Msk                (0x7U << ADC_CFGR2_OVSR_Pos)         /*!< 0x0000001C */
#define ADC_CFGR2_OVSR                    ADC_CFGR2_OVSR_Msk                   /*!< ADC Regular group oversampler enable TO Be removed after ADC driver update*/
#define ADC_CFGR2_OVSR_0                  (0x1U << ADC_CFGR2_OVSR_Pos)         /*!< 0x00000004 */
#define ADC_CFGR2_OVSR_1                  (0x2U << ADC_CFGR2_OVSR_Pos)         /*!< 0x00000008 */
#define ADC_CFGR2_OVSR_2                  (0x4U << ADC_CFGR2_OVSR_Pos)         /*!< 0x00000010 */

#define ADC_CFGR2_OVSS_Pos                (5U)
#define ADC_CFGR2_OVSS_Msk                (0xFU << ADC_CFGR2_OVSS_Pos)         /*!< 0x000001E0 */
#define ADC_CFGR2_OVSS                    ADC_CFGR2_OVSS_Msk                   /*!< ADC Regular Oversampling shift */
#define ADC_CFGR2_OVSS_0                  (0x1U << ADC_CFGR2_OVSS_Pos)         /*!< 0x00000020 */
#define ADC_CFGR2_OVSS_1                  (0x2U << ADC_CFGR2_OVSS_Pos)         /*!< 0x00000040 */
#define ADC_CFGR2_OVSS_2                  (0x4U << ADC_CFGR2_OVSS_Pos)         /*!< 0x00000080 */
#define ADC_CFGR2_OVSS_3                  (0x8U << ADC_CFGR2_OVSS_Pos)         /*!< 0x00000100 */

#define ADC_CFGR2_TROVS_Pos               (9U)
#define ADC_CFGR2_TROVS_Msk               (0x1U << ADC_CFGR2_TROVS_Pos)        /*!< 0x00000200 */
#define ADC_CFGR2_TROVS                   ADC_CFGR2_TROVS_Msk                  /*!< ADC Triggered regular Oversampling */
#define ADC_CFGR2_ROVSM_Pos               (10U)
#define ADC_CFGR2_ROVSM_Msk               (0x1U << ADC_CFGR2_ROVSM_Pos)        /*!< 0x00000400 */
#define ADC_CFGR2_ROVSM                   ADC_CFGR2_ROVSM_Msk                  /*!< ADC Regular oversampling mode */

#define ADC_CFGR2_RSHIFT1_Pos             (11U)
#define ADC_CFGR2_RSHIFT1_Msk             (0x1U << ADC_CFGR2_RSHIFT1_Pos)      /*!< 0x00000800 */
#define ADC_CFGR2_RSHIFT1                 ADC_CFGR2_RSHIFT1_Msk                /*!< ADC Right-shift data after Offset 1 correction */
#define ADC_CFGR2_RSHIFT2_Pos             (12U)
#define ADC_CFGR2_RSHIFT2_Msk             (0x1U << ADC_CFGR2_RSHIFT2_Pos)      /*!< 0x00001000 */
#define ADC_CFGR2_RSHIFT2                 ADC_CFGR2_RSHIFT2_Msk                /*!< ADC Right-shift data after Offset 2 correction */
#define ADC_CFGR2_RSHIFT3_Pos             (13U)
#define ADC_CFGR2_RSHIFT3_Msk             (0x1U << ADC_CFGR2_RSHIFT3_Pos)      /*!< 0x00002000 */
#define ADC_CFGR2_RSHIFT3                 ADC_CFGR2_RSHIFT3_Msk                /*!< ADC Right-shift data after Offset 3 correction */
#define ADC_CFGR2_RSHIFT4_Pos             (14U)
#define ADC_CFGR2_RSHIFT4_Msk             (0x1U << ADC_CFGR2_RSHIFT4_Pos)      /*!< 0x00004000 */
#define ADC_CFGR2_RSHIFT4                 ADC_CFGR2_RSHIFT4_Msk                /*!< ADC Right-shift data after Offset 4 correction */

#define ADC_CFGR2_OSR_Pos                 (16U)
#define ADC_CFGR2_OSR_Msk                 (0x3FFU << ADC_CFGR2_OSR_Pos)        /*!< 0x03FF0000 */
#define ADC_CFGR2_OSR                     ADC_CFGR2_OSR_Msk                    /*!< ADC oversampling Ratio */
#define ADC_CFGR2_OSR_0                   (0x001U << ADC_CFGR2_OSR_Pos)        /*!< 0x00010000 */
#define ADC_CFGR2_OSR_1                   (0x002U << ADC_CFGR2_OSR_Pos)        /*!< 0x00020000 */
#define ADC_CFGR2_OSR_2                   (0x004U << ADC_CFGR2_OSR_Pos)        /*!< 0x00040000 */
#define ADC_CFGR2_OSR_3                   (0x008U << ADC_CFGR2_OSR_Pos)        /*!< 0x00080000 */
#define ADC_CFGR2_OSR_4                   (0x010U << ADC_CFGR2_OSR_Pos)        /*!< 0x00100000 */
#define ADC_CFGR2_OSR_5                   (0x020U << ADC_CFGR2_OSR_Pos)        /*!< 0x00200000 */
#define ADC_CFGR2_OSR_6                   (0x040U << ADC_CFGR2_OSR_Pos)        /*!< 0x00400000 */
#define ADC_CFGR2_OSR_7                   (0x080U << ADC_CFGR2_OSR_Pos)        /*!< 0x00800000 */
#define ADC_CFGR2_OSR_8                   (0x100U << ADC_CFGR2_OSR_Pos)        /*!< 0x01000000 */
#define ADC_CFGR2_OSR_9                   (0x200U << ADC_CFGR2_OSR_Pos)        /*!< 0x02000000 */

#define ADC_CFGR2_LSHIFT_Pos              (28U)
#define ADC_CFGR2_LSHIFT_Msk              (0xFU << ADC_CFGR2_LSHIFT_Pos)       /*!< 0xF0000000 */
#define ADC_CFGR2_LSHIFT                  ADC_CFGR2_LSHIFT_Msk                 /*!< ADC Left shift factor */
#define ADC_CFGR2_LSHIFT_0                (0x1U << ADC_CFGR2_LSHIFT_Pos)       /*!< 0x10000000 */
#define ADC_CFGR2_LSHIFT_1                (0x2U << ADC_CFGR2_LSHIFT_Pos)       /*!< 0x20000000 */
#define ADC_CFGR2_LSHIFT_2                (0x4U << ADC_CFGR2_LSHIFT_Pos)       /*!< 0x40000000 */
#define ADC_CFGR2_LSHIFT_3                (0x8U << ADC_CFGR2_LSHIFT_Pos)       /*!< 0x80000000 */
/********************  Bit definition for ADC_SMPR1 register  ********************/
#define ADC_SMPR1_SMP0_Pos                (0U)
#define ADC_SMPR1_SMP0_Msk                (0x7U << ADC_SMPR1_SMP0_Pos)         /*!< 0x00000007 */
#define ADC_SMPR1_SMP0                    ADC_SMPR1_SMP0_Msk                   /*!< ADC Channel 0 Sampling time selection  */
#define ADC_SMPR1_SMP0_0                  (0x1U << ADC_SMPR1_SMP0_Pos)         /*!< 0x00000001 */
#define ADC_SMPR1_SMP0_1                  (0x2U << ADC_SMPR1_SMP0_Pos)         /*!< 0x00000002 */
#define ADC_SMPR1_SMP0_2                  (0x4U << ADC_SMPR1_SMP0_Pos)         /*!< 0x00000004 */

#define ADC_SMPR1_SMP1_Pos                (3U)
#define ADC_SMPR1_SMP1_Msk                (0x7U << ADC_SMPR1_SMP1_Pos)         /*!< 0x00000038 */
#define ADC_SMPR1_SMP1                    ADC_SMPR1_SMP1_Msk                   /*!< ADC Channel 1 Sampling time selection  */
#define ADC_SMPR1_SMP1_0                  (0x1U << ADC_SMPR1_SMP1_Pos)         /*!< 0x00000008 */
#define ADC_SMPR1_SMP1_1                  (0x2U << ADC_SMPR1_SMP1_Pos)         /*!< 0x00000010 */
#define ADC_SMPR1_SMP1_2                  (0x4U << ADC_SMPR1_SMP1_Pos)         /*!< 0x00000020 */

#define ADC_SMPR1_SMP2_Pos                (6U)
#define ADC_SMPR1_SMP2_Msk                (0x7U << ADC_SMPR1_SMP2_Pos)         /*!< 0x000001C0 */
#define ADC_SMPR1_SMP2                    ADC_SMPR1_SMP2_Msk                   /*!< ADC Channel 2 Sampling time selection  */
#define ADC_SMPR1_SMP2_0                  (0x1U << ADC_SMPR1_SMP2_Pos)         /*!< 0x00000040 */
#define ADC_SMPR1_SMP2_1                  (0x2U << ADC_SMPR1_SMP2_Pos)         /*!< 0x00000080 */
#define ADC_SMPR1_SMP2_2                  (0x4U << ADC_SMPR1_SMP2_Pos)         /*!< 0x00000100 */

#define ADC_SMPR1_SMP3_Pos                (9U)
#define ADC_SMPR1_SMP3_Msk                (0x7U << ADC_SMPR1_SMP3_Pos)         /*!< 0x00000E00 */
#define ADC_SMPR1_SMP3                    ADC_SMPR1_SMP3_Msk                   /*!< ADC Channel 3 Sampling time selection  */
#define ADC_SMPR1_SMP3_0                  (0x1U << ADC_SMPR1_SMP3_Pos)         /*!< 0x00000200 */
#define ADC_SMPR1_SMP3_1                  (0x2U << ADC_SMPR1_SMP3_Pos)         /*!< 0x00000400 */
#define ADC_SMPR1_SMP3_2                  (0x4U << ADC_SMPR1_SMP3_Pos)         /*!< 0x00000800 */

#define ADC_SMPR1_SMP4_Pos                (12U)
#define ADC_SMPR1_SMP4_Msk                (0x7U << ADC_SMPR1_SMP4_Pos)         /*!< 0x00007000 */
#define ADC_SMPR1_SMP4                    ADC_SMPR1_SMP4_Msk                   /*!< ADC Channel 4 Sampling time selection  */
#define ADC_SMPR1_SMP4_0                  (0x1U << ADC_SMPR1_SMP4_Pos)         /*!< 0x00001000 */
#define ADC_SMPR1_SMP4_1                  (0x2U << ADC_SMPR1_SMP4_Pos)         /*!< 0x00002000 */
#define ADC_SMPR1_SMP4_2                  (0x4U << ADC_SMPR1_SMP4_Pos)         /*!< 0x00004000 */

#define ADC_SMPR1_SMP5_Pos                (15U)
#define ADC_SMPR1_SMP5_Msk                (0x7U << ADC_SMPR1_SMP5_Pos)         /*!< 0x00038000 */
#define ADC_SMPR1_SMP5                    ADC_SMPR1_SMP5_Msk                   /*!< ADC Channel 5 Sampling time selection  */
#define ADC_SMPR1_SMP5_0                  (0x1U << ADC_SMPR1_SMP5_Pos)         /*!< 0x00008000 */
#define ADC_SMPR1_SMP5_1                  (0x2U << ADC_SMPR1_SMP5_Pos)         /*!< 0x00010000 */
#define ADC_SMPR1_SMP5_2                  (0x4U << ADC_SMPR1_SMP5_Pos)         /*!< 0x00020000 */

#define ADC_SMPR1_SMP6_Pos                (18U)
#define ADC_SMPR1_SMP6_Msk                (0x7U << ADC_SMPR1_SMP6_Pos)         /*!< 0x001C0000 */
#define ADC_SMPR1_SMP6                    ADC_SMPR1_SMP6_Msk                   /*!< ADC Channel 6 Sampling time selection  */
#define ADC_SMPR1_SMP6_0                  (0x1U << ADC_SMPR1_SMP6_Pos)         /*!< 0x00040000 */
#define ADC_SMPR1_SMP6_1                  (0x2U << ADC_SMPR1_SMP6_Pos)         /*!< 0x00080000 */
#define ADC_SMPR1_SMP6_2                  (0x4U << ADC_SMPR1_SMP6_Pos)         /*!< 0x00100000 */

#define ADC_SMPR1_SMP7_Pos                (21U)
#define ADC_SMPR1_SMP7_Msk                (0x7U << ADC_SMPR1_SMP7_Pos)         /*!< 0x00E00000 */
#define ADC_SMPR1_SMP7                    ADC_SMPR1_SMP7_Msk                   /*!< ADC Channel 7 Sampling time selection  */
#define ADC_SMPR1_SMP7_0                  (0x1U << ADC_SMPR1_SMP7_Pos)         /*!< 0x00200000 */
#define ADC_SMPR1_SMP7_1                  (0x2U << ADC_SMPR1_SMP7_Pos)         /*!< 0x00400000 */
#define ADC_SMPR1_SMP7_2                  (0x4U << ADC_SMPR1_SMP7_Pos)         /*!< 0x00800000 */

#define ADC_SMPR1_SMP8_Pos                (24U)
#define ADC_SMPR1_SMP8_Msk                (0x7U << ADC_SMPR1_SMP8_Pos)         /*!< 0x07000000 */
#define ADC_SMPR1_SMP8                    ADC_SMPR1_SMP8_Msk                   /*!< ADC Channel 8 Sampling time selection  */
#define ADC_SMPR1_SMP8_0                  (0x1U << ADC_SMPR1_SMP8_Pos)         /*!< 0x01000000 */
#define ADC_SMPR1_SMP8_1                  (0x2U << ADC_SMPR1_SMP8_Pos)         /*!< 0x02000000 */
#define ADC_SMPR1_SMP8_2                  (0x4U << ADC_SMPR1_SMP8_Pos)         /*!< 0x04000000 */

#define ADC_SMPR1_SMP9_Pos                (27U)
#define ADC_SMPR1_SMP9_Msk                (0x7U << ADC_SMPR1_SMP9_Pos)         /*!< 0x38000000 */
#define ADC_SMPR1_SMP9                    ADC_SMPR1_SMP9_Msk                   /*!< ADC Channel 9 Sampling time selection  */
#define ADC_SMPR1_SMP9_0                  (0x1U << ADC_SMPR1_SMP9_Pos)         /*!< 0x08000000 */
#define ADC_SMPR1_SMP9_1                  (0x2U << ADC_SMPR1_SMP9_Pos)         /*!< 0x10000000 */
#define ADC_SMPR1_SMP9_2                  (0x4U << ADC_SMPR1_SMP9_Pos)         /*!< 0x20000000 */

/********************  Bit definition for ADC_SMPR2 register  ********************/
#define ADC_SMPR2_SMP10_Pos               (0U)
#define ADC_SMPR2_SMP10_Msk               (0x7U << ADC_SMPR2_SMP10_Pos)        /*!< 0x00000007 */
#define ADC_SMPR2_SMP10                   ADC_SMPR2_SMP10_Msk                  /*!< ADC Channel 10 Sampling time selection  */
#define ADC_SMPR2_SMP10_0                 (0x1U << ADC_SMPR2_SMP10_Pos)        /*!< 0x00000001 */
#define ADC_SMPR2_SMP10_1                 (0x2U << ADC_SMPR2_SMP10_Pos)        /*!< 0x00000002 */
#define ADC_SMPR2_SMP10_2                 (0x4U << ADC_SMPR2_SMP10_Pos)        /*!< 0x00000004 */

#define ADC_SMPR2_SMP11_Pos               (3U)
#define ADC_SMPR2_SMP11_Msk               (0x7U << ADC_SMPR2_SMP11_Pos)        /*!< 0x00000038 */
#define ADC_SMPR2_SMP11                   ADC_SMPR2_SMP11_Msk                  /*!< ADC Channel 11 Sampling time selection  */
#define ADC_SMPR2_SMP11_0                 (0x1U << ADC_SMPR2_SMP11_Pos)        /*!< 0x00000008 */
#define ADC_SMPR2_SMP11_1                 (0x2U << ADC_SMPR2_SMP11_Pos)        /*!< 0x00000010 */
#define ADC_SMPR2_SMP11_2                 (0x4U << ADC_SMPR2_SMP11_Pos)        /*!< 0x00000020 */

#define ADC_SMPR2_SMP12_Pos               (6U)
#define ADC_SMPR2_SMP12_Msk               (0x7U << ADC_SMPR2_SMP12_Pos)        /*!< 0x000001C0 */
#define ADC_SMPR2_SMP12                   ADC_SMPR2_SMP12_Msk                  /*!< ADC Channel 12 Sampling time selection  */
#define ADC_SMPR2_SMP12_0                 (0x1U << ADC_SMPR2_SMP12_Pos)        /*!< 0x00000040 */
#define ADC_SMPR2_SMP12_1                 (0x2U << ADC_SMPR2_SMP12_Pos)        /*!< 0x00000080 */
#define ADC_SMPR2_SMP12_2                 (0x4U << ADC_SMPR2_SMP12_Pos)        /*!< 0x00000100 */

#define ADC_SMPR2_SMP13_Pos               (9U)
#define ADC_SMPR2_SMP13_Msk               (0x7U << ADC_SMPR2_SMP13_Pos)        /*!< 0x00000E00 */
#define ADC_SMPR2_SMP13                   ADC_SMPR2_SMP13_Msk                  /*!< ADC Channel 13 Sampling time selection  */
#define ADC_SMPR2_SMP13_0                 (0x1U << ADC_SMPR2_SMP13_Pos)        /*!< 0x00000200 */
#define ADC_SMPR2_SMP13_1                 (0x2U << ADC_SMPR2_SMP13_Pos)        /*!< 0x00000400 */
#define ADC_SMPR2_SMP13_2                 (0x4U << ADC_SMPR2_SMP13_Pos)        /*!< 0x00000800 */

#define ADC_SMPR2_SMP14_Pos               (12U)
#define ADC_SMPR2_SMP14_Msk               (0x7U << ADC_SMPR2_SMP14_Pos)        /*!< 0x00007000 */
#define ADC_SMPR2_SMP14                   ADC_SMPR2_SMP14_Msk                  /*!< ADC Channel 14 Sampling time selection  */
#define ADC_SMPR2_SMP14_0                 (0x1U << ADC_SMPR2_SMP14_Pos)        /*!< 0x00001000 */
#define ADC_SMPR2_SMP14_1                 (0x2U << ADC_SMPR2_SMP14_Pos)        /*!< 0x00002000 */
#define ADC_SMPR2_SMP14_2                 (0x4U << ADC_SMPR2_SMP14_Pos)        /*!< 0x00004000 */

#define ADC_SMPR2_SMP15_Pos               (15U)
#define ADC_SMPR2_SMP15_Msk               (0x7U << ADC_SMPR2_SMP15_Pos)        /*!< 0x00038000 */
#define ADC_SMPR2_SMP15                   ADC_SMPR2_SMP15_Msk                  /*!< ADC Channel 15 Sampling time selection  */
#define ADC_SMPR2_SMP15_0                 (0x1U << ADC_SMPR2_SMP15_Pos)        /*!< 0x00008000 */
#define ADC_SMPR2_SMP15_1                 (0x2U << ADC_SMPR2_SMP15_Pos)        /*!< 0x00010000 */
#define ADC_SMPR2_SMP15_2                 (0x4U << ADC_SMPR2_SMP15_Pos)        /*!< 0x00020000 */

#define ADC_SMPR2_SMP16_Pos               (18U)
#define ADC_SMPR2_SMP16_Msk               (0x7U << ADC_SMPR2_SMP16_Pos)        /*!< 0x001C0000 */
#define ADC_SMPR2_SMP16                   ADC_SMPR2_SMP16_Msk                  /*!< ADC Channel 16 Sampling time selection  */
#define ADC_SMPR2_SMP16_0                 (0x1U << ADC_SMPR2_SMP16_Pos)        /*!< 0x00040000 */
#define ADC_SMPR2_SMP16_1                 (0x2U << ADC_SMPR2_SMP16_Pos)        /*!< 0x00080000 */
#define ADC_SMPR2_SMP16_2                 (0x4U << ADC_SMPR2_SMP16_Pos)        /*!< 0x00100000 */

#define ADC_SMPR2_SMP17_Pos               (21U)
#define ADC_SMPR2_SMP17_Msk               (0x7U << ADC_SMPR2_SMP17_Pos)        /*!< 0x00E00000 */
#define ADC_SMPR2_SMP17                   ADC_SMPR2_SMP17_Msk                  /*!< ADC Channel 17 Sampling time selection  */
#define ADC_SMPR2_SMP17_0                 (0x1U << ADC_SMPR2_SMP17_Pos)        /*!< 0x00200000 */
#define ADC_SMPR2_SMP17_1                 (0x2U << ADC_SMPR2_SMP17_Pos)        /*!< 0x00400000 */
#define ADC_SMPR2_SMP17_2                 (0x4U << ADC_SMPR2_SMP17_Pos)        /*!< 0x00800000 */

#define ADC_SMPR2_SMP18_Pos               (24U)
#define ADC_SMPR2_SMP18_Msk               (0x7U << ADC_SMPR2_SMP18_Pos)        /*!< 0x07000000 */
#define ADC_SMPR2_SMP18                   ADC_SMPR2_SMP18_Msk                  /*!< ADC Channel 18 Sampling time selection  */
#define ADC_SMPR2_SMP18_0                 (0x1U << ADC_SMPR2_SMP18_Pos)        /*!< 0x01000000 */
#define ADC_SMPR2_SMP18_1                 (0x2U << ADC_SMPR2_SMP18_Pos)        /*!< 0x02000000 */
#define ADC_SMPR2_SMP18_2                 (0x4U << ADC_SMPR2_SMP18_Pos)        /*!< 0x04000000 */

#define ADC_SMPR2_SMP19_Pos               (27U)
#define ADC_SMPR2_SMP19_Msk               (0x7U << ADC_SMPR2_SMP19_Pos)        /*!< 0x38000000 */
#define ADC_SMPR2_SMP19                   ADC_SMPR2_SMP19_Msk                  /*!< ADC Channel 19 Sampling time selection  */
#define ADC_SMPR2_SMP19_0                 (0x1U << ADC_SMPR2_SMP19_Pos)        /*!< 0x08000000 */
#define ADC_SMPR2_SMP19_1                 (0x2U << ADC_SMPR2_SMP19_Pos)        /*!< 0x10000000 */
#define ADC_SMPR2_SMP19_2                 (0x4U << ADC_SMPR2_SMP19_Pos)        /*!< 0x20000000 */

/********************  Bit definition for ADC_PCSEL register  ********************/
#define ADC_PCSEL_PCSEL_Pos               (0U)
#define ADC_PCSEL_PCSEL_Msk               (0xFFFFFU << ADC_PCSEL_PCSEL_Pos)    /*!< 0x000FFFFF */
#define ADC_PCSEL_PCSEL                   ADC_PCSEL_PCSEL_Msk                  /*!< ADC pre channel selection */
#define ADC_PCSEL_PCSEL_0                 (0x00001U << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000001 */
#define ADC_PCSEL_PCSEL_1                 (0x00002U << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000002 */
#define ADC_PCSEL_PCSEL_2                 (0x00004U << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000004 */
#define ADC_PCSEL_PCSEL_3                 (0x00008U << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000008 */
#define ADC_PCSEL_PCSEL_4                 (0x00010U << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000010 */
#define ADC_PCSEL_PCSEL_5                 (0x00020U << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000020 */
#define ADC_PCSEL_PCSEL_6                 (0x00040U << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000040 */
#define ADC_PCSEL_PCSEL_7                 (0x00080U << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000080 */
#define ADC_PCSEL_PCSEL_8                 (0x00100U << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000100 */
#define ADC_PCSEL_PCSEL_9                 (0x00200U << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000200 */
#define ADC_PCSEL_PCSEL_10                (0x00400U << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000400 */
#define ADC_PCSEL_PCSEL_11                (0x00800U << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000800 */
#define ADC_PCSEL_PCSEL_12                (0x01000U << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00001000 */
#define ADC_PCSEL_PCSEL_13                (0x02000U << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00002000 */
#define ADC_PCSEL_PCSEL_14                (0x04000U << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00004000 */
#define ADC_PCSEL_PCSEL_15                (0x08000U << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00008000 */
#define ADC_PCSEL_PCSEL_16                (0x10000U << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00010000 */
#define ADC_PCSEL_PCSEL_17                (0x20000U << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00020000 */
#define ADC_PCSEL_PCSEL_18                (0x40000U << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00040000 */
#define ADC_PCSEL_PCSEL_19                (0x80000U << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00080000 */

/********************  Bit definition for ADC_LTR1 register  ********************/
#define ADC_LTR1_LT1_Pos                  (0U)
#define ADC_LTR1_LT1_Msk                  (0x3FFFFFFU << ADC_LTR1_LT1_Pos)     /*!< 0x03FFFFFF */
#define ADC_LTR1_LT1                      ADC_LTR1_LT1_Msk                     /*!< ADC Analog watchdog 1 lower threshold */
#define ADC_LTR1_LT1_0                    (0x0000001U << ADC_LTR1_LT1_Pos)     /*!< 0x00000001 */
#define ADC_LTR1_LT1_1                    (0x0000002U << ADC_LTR1_LT1_Pos)     /*!< 0x00000002 */
#define ADC_LTR1_LT1_2                    (0x0000004U << ADC_LTR1_LT1_Pos)     /*!< 0x00000004 */
#define ADC_LTR1_LT1_3                    (0x0000008U << ADC_LTR1_LT1_Pos)     /*!< 0x00000008 */
#define ADC_LTR1_LT1_4                    (0x0000010U << ADC_LTR1_LT1_Pos)     /*!< 0x00000010 */
#define ADC_LTR1_LT1_5                    (0x0000020U << ADC_LTR1_LT1_Pos)     /*!< 0x00000020 */
#define ADC_LTR1_LT1_6                    (0x0000040U << ADC_LTR1_LT1_Pos)     /*!< 0x00000040 */
#define ADC_LTR1_LT1_7                    (0x0000080U << ADC_LTR1_LT1_Pos)     /*!< 0x00000080 */
#define ADC_LTR1_LT1_8                    (0x0000100U << ADC_LTR1_LT1_Pos)     /*!< 0x00000100 */
#define ADC_LTR1_LT1_9                    (0x0000200U << ADC_LTR1_LT1_Pos)     /*!< 0x00000200 */
#define ADC_LTR1_LT1_10                   (0x0000400U << ADC_LTR1_LT1_Pos)     /*!< 0x00000400 */
#define ADC_LTR1_LT1_11                   (0x0000800U << ADC_LTR1_LT1_Pos)     /*!< 0x00000800 */
#define ADC_LTR1_LT1_12                   (0x0001000U << ADC_LTR1_LT1_Pos)     /*!< 0x00001000 */
#define ADC_LTR1_LT1_13                   (0x0002000U << ADC_LTR1_LT1_Pos)     /*!< 0x00002000 */
#define ADC_LTR1_LT1_14                   (0x0004000U << ADC_LTR1_LT1_Pos)     /*!< 0x00004000 */
#define ADC_LTR1_LT1_15                   (0x0008000U << ADC_LTR1_LT1_Pos)     /*!< 0x00008000 */
#define ADC_LTR1_LT1_16                   (0x0010000U << ADC_LTR1_LT1_Pos)     /*!< 0x00010000 */
#define ADC_LTR1_LT1_17                   (0x0020000U << ADC_LTR1_LT1_Pos)     /*!< 0x00020000 */
#define ADC_LTR1_LT1_18                   (0x0040000U << ADC_LTR1_LT1_Pos)     /*!< 0x00040000 */
#define ADC_LTR1_LT1_19                   (0x0080000U << ADC_LTR1_LT1_Pos)     /*!< 0x00080000 */
#define ADC_LTR1_LT1_20                   (0x0100000U << ADC_LTR1_LT1_Pos)     /*!< 0x00100000 */
#define ADC_LTR1_LT1_21                   (0x0200000U << ADC_LTR1_LT1_Pos)     /*!< 0x00200000 */
#define ADC_LTR1_LT1_22                   (0x0400000U << ADC_LTR1_LT1_Pos)     /*!< 0x00400000 */
#define ADC_LTR1_LT1_23                   (0x0800000U << ADC_LTR1_LT1_Pos)     /*!< 0x00800000 */
#define ADC_LTR1_LT1_24                   (0x1000000U << ADC_LTR1_LT1_Pos)     /*!< 0x01000000 */
#define ADC_LTR1_LT1_25                   (0x2000000U << ADC_LTR1_LT1_Pos)     /*!< 0x02000000 */

/********************  Bit definition for ADC_HTR1 register  ********************/
#define ADC_HTR1_HT1         ((uint32_t) 0x03FFFFFF) /*!< ADC Analog watchdog 1 higher threshold */
#define ADC_HTR1_HT1_0                    ((uint32_t)0x00000001)               /*!< ADC HT1 bit 0 */
#define ADC_HTR1_HT1_1                    ((uint32_t)0x00000002)               /*!< ADC HT1 bit 1 */
#define ADC_HTR1_HT1_2                    ((uint32_t)0x00000004)               /*!< ADC HT1 bit 2 */
#define ADC_HTR1_HT1_3                    ((uint32_t)0x00000008)               /*!< ADC HT1 bit 3 */
#define ADC_HTR1_HT1_4                    ((uint32_t)0x00000010)               /*!< ADC HT1 bit 4 */
#define ADC_HTR1_HT1_5                    ((uint32_t)0x00000020)               /*!< ADC HT1 bit 5 */
#define ADC_HTR1_HT1_6                    ((uint32_t)0x00000040)               /*!< ADC HT1 bit 6 */
#define ADC_HTR1_HT1_7                    ((uint32_t)0x00000080)               /*!< ADC HT1 bit 7 */
#define ADC_HTR1_HT1_8                    ((uint32_t)0x00000100)               /*!< ADC HT1 bit 8 */
#define ADC_HTR1_HT1_9                    ((uint32_t)0x00000200)               /*!< ADC HT1 bit 9 */
#define ADC_HTR1_HT1_10                   ((uint32_t)0x00000400)               /*!< ADC HT1 bit 10 */
#define ADC_HTR1_HT1_11                   ((uint32_t)0x00000800)               /*!< ADC HT1 bit 11 */
#define ADC_HTR1_HT1_12                   ((uint32_t)0x00001000)               /*!< ADC HT1 bit 12 */
#define ADC_HTR1_HT1_13                   ((uint32_t)0x00002000)               /*!< ADC HT1 bit 13 */
#define ADC_HTR1_HT1_14                   ((uint32_t)0x00004000)               /*!< ADC HT1 bit 14 */
#define ADC_HTR1_HT1_15                   ((uint32_t)0x00008000)               /*!< ADC HT1 bit 15 */
#define ADC_HTR1_HT1_16                   ((uint32_t)0x00010000)               /*!< ADC HT1 bit 16 */
#define ADC_HTR1_HT1_17                   ((uint32_t)0x00020000)               /*!< ADC HT1 bit 17 */
#define ADC_HTR1_HT1_18                   ((uint32_t)0x00040000)               /*!< ADC HT1 bit 18 */
#define ADC_HTR1_HT1_19                   ((uint32_t)0x00080000)               /*!< ADC HT1 bit 19 */
#define ADC_HTR1_HT1_20                   ((uint32_t)0x00100000)               /*!< ADC HT1 bit 20 */
#define ADC_HTR1_HT1_21                   ((uint32_t)0x00200000)               /*!< ADC HT1 bit 21 */
#define ADC_HTR1_HT1_22                   ((uint32_t)0x00400000)               /*!< ADC HT1 bit 22 */
#define ADC_HTR1_HT1_23                   ((uint32_t)0x00800000)               /*!< ADC HT1 bit 23 */
#define ADC_HTR1_HT1_24                   ((uint32_t)0x01000000)               /*!< ADC HT1 bit 24 */
#define ADC_HTR1_HT1_25                   ((uint32_t)0x02000000)               /*!< ADC HT1 bit 25 */


/********************  Bit definition for ADC_LTR2 register  ********************/
#define ADC_LTR2_LT2         ((uint32_t) 0x03FFFFFF) /*!< ADC Analog watchdog 2 lower threshold */
#define ADC_LTR2_LT2_0                    ((uint32_t)0x00000001)               /*!< ADC LT2 bit 0 */
#define ADC_LTR2_LT2_1                    ((uint32_t)0x00000002)               /*!< ADC LT2 bit 1 */
#define ADC_LTR2_LT2_2                    ((uint32_t)0x00000004)               /*!< ADC LT2 bit 2 */
#define ADC_LTR2_LT2_3                    ((uint32_t)0x00000008)               /*!< ADC LT2 bit 3 */
#define ADC_LTR2_LT2_4                    ((uint32_t)0x00000010)               /*!< ADC LT2 bit 4 */
#define ADC_LTR2_LT2_5                    ((uint32_t)0x00000020)               /*!< ADC LT2 bit 5 */
#define ADC_LTR2_LT2_6                    ((uint32_t)0x00000040)               /*!< ADC LT2 bit 6 */
#define ADC_LTR2_LT2_7                    ((uint32_t)0x00000080)               /*!< ADC LT2 bit 7 */
#define ADC_LTR2_LT2_8                    ((uint32_t)0x00000100)               /*!< ADC LT2 bit 8 */
#define ADC_LTR2_LT2_9                    ((uint32_t)0x00000200)               /*!< ADC LT2 bit 9 */
#define ADC_LTR2_LT2_10                   ((uint32_t)0x00000400)               /*!< ADC LT2 bit 10 */
#define ADC_LTR2_LT2_11                   ((uint32_t)0x00000800)               /*!< ADC LT2 bit 11 */
#define ADC_LTR2_LT2_12                   ((uint32_t)0x00001000)               /*!< ADC LT2 bit 12 */
#define ADC_LTR2_LT2_13                   ((uint32_t)0x00002000)               /*!< ADC LT2 bit 13 */
#define ADC_LTR2_LT2_14                   ((uint32_t)0x00004000)               /*!< ADC LT2 bit 14 */
#define ADC_LTR2_LT2_15                   ((uint32_t)0x00008000)               /*!< ADC LT2 bit 15 */
#define ADC_LTR2_LT2_16                   ((uint32_t)0x00010000)               /*!< ADC LT2 bit 16 */
#define ADC_LTR2_LT2_17                   ((uint32_t)0x00020000)               /*!< ADC LT2 bit 17 */
#define ADC_LTR2_LT2_18                   ((uint32_t)0x00040000)               /*!< ADC LT2 bit 18 */
#define ADC_LTR2_LT2_19                   ((uint32_t)0x00080000)               /*!< ADC LT2 bit 19 */
#define ADC_LTR2_LT2_20                   ((uint32_t)0x00100000)               /*!< ADC LT2 bit 20 */
#define ADC_LTR2_LT2_21                   ((uint32_t)0x00200000)               /*!< ADC LT2 bit 21 */
#define ADC_LTR2_LT2_22                   ((uint32_t)0x00400000)               /*!< ADC LT2 bit 22 */
#define ADC_LTR2_LT2_23                   ((uint32_t)0x00800000)               /*!< ADC LT2 bit 23 */
#define ADC_LTR2_LT2_24                   ((uint32_t)0x01000000)               /*!< ADC LT2 bit 24 */
#define ADC_LTR2_LT2_25                   ((uint32_t)0x02000000)               /*!< ADC LT2 bit 25 */

/********************  Bit definition for ADC_HTR2 register  ********************/
#define ADC_HTR2_HT2         ((uint32_t) 0x03FFFFFF) /*!< ADC Analog watchdog 2 higher threshold */
#define ADC_HTR2_HT2_0                    ((uint32_t)0x00000001)               /*!< ADC HT2 bit 0 */
#define ADC_HTR2_HT2_1                    ((uint32_t)0x00000002)               /*!< ADC HT2 bit 1 */
#define ADC_HTR2_HT2_2                    ((uint32_t)0x00000004)               /*!< ADC HT2 bit 2 */
#define ADC_HTR2_HT2_3                    ((uint32_t)0x00000008)               /*!< ADC HT2 bit 3 */
#define ADC_HTR2_HT2_4                    ((uint32_t)0x00000010)               /*!< ADC HT2 bit 4 */
#define ADC_HTR2_HT2_5                    ((uint32_t)0x00000020)               /*!< ADC HT2 bit 5 */
#define ADC_HTR2_HT2_6                    ((uint32_t)0x00000040)               /*!< ADC HT2 bit 6 */
#define ADC_HTR2_HT2_7                    ((uint32_t)0x00000080)               /*!< ADC HT2 bit 7 */
#define ADC_HTR2_HT2_8                    ((uint32_t)0x00000100)               /*!< ADC HT2 bit 8 */
#define ADC_HTR2_HT2_9                    ((uint32_t)0x00000200)               /*!< ADC HT2 bit 9 */
#define ADC_HTR2_HT2_10                   ((uint32_t)0x00000400)               /*!< ADC HT2 bit 10 */
#define ADC_HTR2_HT2_11                   ((uint32_t)0x00000800)               /*!< ADC HT2 bit 11 */
#define ADC_HTR2_HT2_12                   ((uint32_t)0x00001000)               /*!< ADC HT2 bit 12 */
#define ADC_HTR2_HT2_13                   ((uint32_t)0x00002000)               /*!< ADC HT2 bit 13 */
#define ADC_HTR2_HT2_14                   ((uint32_t)0x00004000)               /*!< ADC HT2 bit 14 */
#define ADC_HTR2_HT2_15                   ((uint32_t)0x00008000)               /*!< ADC HT2 bit 15 */
#define ADC_HTR2_HT2_16                   ((uint32_t)0x00010000)               /*!< ADC HT2 bit 16 */
#define ADC_HTR2_HT2_17                   ((uint32_t)0x00020000)               /*!< ADC HT2 bit 17 */
#define ADC_HTR2_HT2_18                   ((uint32_t)0x00040000)               /*!< ADC HT2 bit 18 */
#define ADC_HTR2_HT2_19                   ((uint32_t)0x00080000)               /*!< ADC HT2 bit 19 */
#define ADC_HTR2_HT2_20                   ((uint32_t)0x00100000)               /*!< ADC HT2 bit 20 */
#define ADC_HTR2_HT2_21                   ((uint32_t)0x00200000)               /*!< ADC HT2 bit 21 */
#define ADC_HTR2_HT2_22                   ((uint32_t)0x00400000)               /*!< ADC HT2 bit 22 */
#define ADC_HTR2_HT2_23                   ((uint32_t)0x00800000)               /*!< ADC HT2 bit 23 */
#define ADC_HTR2_HT2_24                   ((uint32_t)0x01000000)               /*!< ADC HT2 bit 24 */
#define ADC_HTR2_HT2_25      ((uint32_t)0x020000000) /*!< ADC HT2 bit 25 */

/********************  Bit definition for ADC_LTR3 register  ********************/
#define ADC_LTR3_LT3         ((uint32_t) 0x03FFFFFF) /*!< ADC Analog watchdog 3 lower threshold */
#define ADC_LTR3_LT3_0                    ((uint32_t)0x00000001)               /*!< ADC LT3 bit 0 */
#define ADC_LTR3_LT3_1                    ((uint32_t)0x00000002)               /*!< ADC LT3 bit 1 */
#define ADC_LTR3_LT3_2                    ((uint32_t)0x00000004)               /*!< ADC LT3 bit 2 */
#define ADC_LTR3_LT3_3                    ((uint32_t)0x00000008)               /*!< ADC LT3 bit 3 */
#define ADC_LTR3_LT3_4                    ((uint32_t)0x00000010)               /*!< ADC LT3 bit 4 */
#define ADC_LTR3_LT3_5                    ((uint32_t)0x00000020)               /*!< ADC LT3 bit 5 */
#define ADC_LTR3_LT3_6                    ((uint32_t)0x00000040)               /*!< ADC LT3 bit 6 */
#define ADC_LTR3_LT3_7                    ((uint32_t)0x00000080)               /*!< ADC LT3 bit 7 */
#define ADC_LTR3_LT3_8                    ((uint32_t)0x00000100)               /*!< ADC LT3 bit 8 */
#define ADC_LTR3_LT3_9                    ((uint32_t)0x00000200)               /*!< ADC LT3 bit 9 */
#define ADC_LTR3_LT3_10                   ((uint32_t)0x00000400)               /*!< ADC LT3 bit 10 */
#define ADC_LTR3_LT3_11                   ((uint32_t)0x00000800)               /*!< ADC LT3 bit 11 */
#define ADC_LTR3_LT3_12                   ((uint32_t)0x00001000)               /*!< ADC LT3 bit 12 */
#define ADC_LTR3_LT3_13                   ((uint32_t)0x00002000)               /*!< ADC LT3 bit 13 */
#define ADC_LTR3_LT3_14                   ((uint32_t)0x00004000)               /*!< ADC LT3 bit 14 */
#define ADC_LTR3_LT3_15                   ((uint32_t)0x00008000)               /*!< ADC LT3 bit 15 */
#define ADC_LTR3_LT3_16                   ((uint32_t)0x00010000)               /*!< ADC LT3 bit 16 */
#define ADC_LTR3_LT3_17                   ((uint32_t)0x00020000)               /*!< ADC LT3 bit 17 */
#define ADC_LTR3_LT3_18                   ((uint32_t)0x00040000)               /*!< ADC LT3 bit 18 */
#define ADC_LTR3_LT3_19                   ((uint32_t)0x00080000)               /*!< ADC LT3 bit 19 */
#define ADC_LTR3_LT3_20                   ((uint32_t)0x00100000)               /*!< ADC LT3 bit 20 */
#define ADC_LTR3_LT3_21                   ((uint32_t)0x00200000)               /*!< ADC LT3 bit 21 */
#define ADC_LTR3_LT3_22                   ((uint32_t)0x00400000)               /*!< ADC LT3 bit 22 */
#define ADC_LTR3_LT3_23                   ((uint32_t)0x00800000)               /*!< ADC LT3 bit 23 */
#define ADC_LTR3_LT3_24                   ((uint32_t)0x01000000)               /*!< ADC LT3 bit 24*/
#define ADC_LTR3_LT3_25                   ((uint32_t)0x02000000)               /*!< ADC LT3 bit 25 */

/********************  Bit definition for ADC_HTR3 register  ********************/
#define ADC_HTR3_HT3         ((uint32_t) 0x03FFFFFF) /*!< ADC Analog watchdog 3 higher threshold */
#define ADC_HTR3_HT3_0                    ((uint32_t)0x00000001)               /*!< ADC HT3 bit 0 */
#define ADC_HTR3_HT3_1                    ((uint32_t)0x00000002)               /*!< ADC HT3 bit 1 */
#define ADC_HTR3_HT3_2                    ((uint32_t)0x00000004)               /*!< ADC HT3 bit 2 */
#define ADC_HTR3_HT3_3                    ((uint32_t)0x00000008)               /*!< ADC HT3 bit 3 */
#define ADC_HTR3_HT3_4                    ((uint32_t)0x00000010)               /*!< ADC HT3 bit 4 */
#define ADC_HTR3_HT3_5                    ((uint32_t)0x00000020)               /*!< ADC HT3 bit 5 */
#define ADC_HTR3_HT3_6                    ((uint32_t)0x00000040)               /*!< ADC HT3 bit 6 */
#define ADC_HTR3_HT3_7                    ((uint32_t)0x00000080)               /*!< ADC HT3 bit 7 */
#define ADC_HTR3_HT3_8                    ((uint32_t)0x00000100)               /*!< ADC HT3 bit 8 */
#define ADC_HTR3_HT3_9                    ((uint32_t)0x00000200)               /*!< ADC HT3 bit 9 */
#define ADC_HTR3_HT3_10                   ((uint32_t)0x00000400)               /*!< ADC HT3 bit 10 */
#define ADC_HTR3_HT3_11                   ((uint32_t)0x00000800)               /*!< ADC HT3 bit 11 */
#define ADC_HTR3_HT3_12                   ((uint32_t)0x00001000)               /*!< ADC HT3 bit 12 */
#define ADC_HTR3_HT3_13                   ((uint32_t)0x00002000)               /*!< ADC HT3 bit 13 */
#define ADC_HTR3_HT3_14                   ((uint32_t)0x00004000)               /*!< ADC HT3 bit 14 */
#define ADC_HTR3_HT3_15                   ((uint32_t)0x00008000)               /*!< ADC HT3 bit 15 */
#define ADC_HTR3_HT3_16                   ((uint32_t)0x00010000)               /*!< ADC HT3 bit 16 */
#define ADC_HTR3_HT3_17                   ((uint32_t)0x00020000)               /*!< ADC HT3 bit 17 */
#define ADC_HTR3_HT3_18                   ((uint32_t)0x00040000)               /*!< ADC HT3 bit 18 */
#define ADC_HTR3_HT3_19                   ((uint32_t)0x00080000)               /*!< ADC HT3 bit 19 */
#define ADC_HTR3_HT3_20                   ((uint32_t)0x00100000)               /*!< ADC HT3 bit 20 */
#define ADC_HTR3_HT3_21                   ((uint32_t)0x00200000)               /*!< ADC HT3 bit 21 */
#define ADC_HTR3_HT3_22                   ((uint32_t)0x00400000)               /*!< ADC HT3 bit 22 */
#define ADC_HTR3_HT3_23                   ((uint32_t)0x00800000)               /*!< ADC HT3 bit 23 */
#define ADC_HTR3_HT3_24                   ((uint32_t)0x01000000)               /*!< ADC HT3 bit 24 */
#define ADC_HTR3_HT3_25                   ((uint32_t)0x02000000)               /*!< ADC HT3 bit 25 */

/********************  Bit definition for ADC_SQR1 register  ********************/
#define ADC_SQR1_L_Pos                    (0U)
#define ADC_SQR1_L_Msk                    (0xFU << ADC_SQR1_L_Pos)             /*!< 0x0000000F */
#define ADC_SQR1_L                        ADC_SQR1_L_Msk                       /*!< ADC regular channel sequence lenght */
#define ADC_SQR1_L_0                      (0x1U << ADC_SQR1_L_Pos)             /*!< 0x00000001 */
#define ADC_SQR1_L_1                      (0x2U << ADC_SQR1_L_Pos)             /*!< 0x00000002 */
#define ADC_SQR1_L_2                      (0x4U << ADC_SQR1_L_Pos)             /*!< 0x00000004 */
#define ADC_SQR1_L_3                      (0x8U << ADC_SQR1_L_Pos)             /*!< 0x00000008 */

#define ADC_SQR1_SQ1_Pos                  (6U)
#define ADC_SQR1_SQ1_Msk                  (0x1FU << ADC_SQR1_SQ1_Pos)          /*!< 0x000007C0 */
#define ADC_SQR1_SQ1                      ADC_SQR1_SQ1_Msk                     /*!< ADC 1st conversion in regular sequence */
#define ADC_SQR1_SQ1_0                    (0x01U << ADC_SQR1_SQ1_Pos)          /*!< 0x00000040 */
#define ADC_SQR1_SQ1_1                    (0x02U << ADC_SQR1_SQ1_Pos)          /*!< 0x00000080 */
#define ADC_SQR1_SQ1_2                    (0x04U << ADC_SQR1_SQ1_Pos)          /*!< 0x00000100 */
#define ADC_SQR1_SQ1_3                    (0x08U << ADC_SQR1_SQ1_Pos)          /*!< 0x00000200 */
#define ADC_SQR1_SQ1_4                    (0x10U << ADC_SQR1_SQ1_Pos)          /*!< 0x00000400 */

#define ADC_SQR1_SQ2_Pos                  (12U)
#define ADC_SQR1_SQ2_Msk                  (0x1FU << ADC_SQR1_SQ2_Pos)          /*!< 0x0001F000 */
#define ADC_SQR1_SQ2                      ADC_SQR1_SQ2_Msk                     /*!< ADC 2nd conversion in regular sequence */
#define ADC_SQR1_SQ2_0                    (0x01U << ADC_SQR1_SQ2_Pos)          /*!< 0x00001000 */
#define ADC_SQR1_SQ2_1                    (0x02U << ADC_SQR1_SQ2_Pos)          /*!< 0x00002000 */
#define ADC_SQR1_SQ2_2                    (0x04U << ADC_SQR1_SQ2_Pos)          /*!< 0x00004000 */
#define ADC_SQR1_SQ2_3                    (0x08U << ADC_SQR1_SQ2_Pos)          /*!< 0x00008000 */
#define ADC_SQR1_SQ2_4                    (0x10U << ADC_SQR1_SQ2_Pos)          /*!< 0x00010000 */

#define ADC_SQR1_SQ3_Pos                  (18U)
#define ADC_SQR1_SQ3_Msk                  (0x1FU << ADC_SQR1_SQ3_Pos)          /*!< 0x007C0000 */
#define ADC_SQR1_SQ3                      ADC_SQR1_SQ3_Msk                     /*!< ADC 3rd conversion in regular sequence */
#define ADC_SQR1_SQ3_0                    (0x01U << ADC_SQR1_SQ3_Pos)          /*!< 0x00040000 */
#define ADC_SQR1_SQ3_1                    (0x02U << ADC_SQR1_SQ3_Pos)          /*!< 0x00080000 */
#define ADC_SQR1_SQ3_2                    (0x04U << ADC_SQR1_SQ3_Pos)          /*!< 0x00100000 */
#define ADC_SQR1_SQ3_3                    (0x08U << ADC_SQR1_SQ3_Pos)          /*!< 0x00200000 */
#define ADC_SQR1_SQ3_4                    (0x10U << ADC_SQR1_SQ3_Pos)          /*!< 0x00400000 */

#define ADC_SQR1_SQ4_Pos                  (24U)
#define ADC_SQR1_SQ4_Msk                  (0x1FU << ADC_SQR1_SQ4_Pos)          /*!< 0x1F000000 */
#define ADC_SQR1_SQ4                      ADC_SQR1_SQ4_Msk                     /*!< ADC 4th conversion in regular sequence */
#define ADC_SQR1_SQ4_0                    (0x01U << ADC_SQR1_SQ4_Pos)          /*!< 0x01000000 */
#define ADC_SQR1_SQ4_1                    (0x02U << ADC_SQR1_SQ4_Pos)          /*!< 0x02000000 */
#define ADC_SQR1_SQ4_2                    (0x04U << ADC_SQR1_SQ4_Pos)          /*!< 0x04000000 */
#define ADC_SQR1_SQ4_3                    (0x08U << ADC_SQR1_SQ4_Pos)          /*!< 0x08000000 */
#define ADC_SQR1_SQ4_4                    (0x10U << ADC_SQR1_SQ4_Pos)          /*!< 0x10000000 */

/********************  Bit definition for ADC_SQR2 register  ********************/
#define ADC_SQR2_SQ5_Pos                  (0U)
#define ADC_SQR2_SQ5_Msk                  (0x1FU << ADC_SQR2_SQ5_Pos)          /*!< 0x0000001F */
#define ADC_SQR2_SQ5                      ADC_SQR2_SQ5_Msk                     /*!< ADC 5th conversion in regular sequence */
#define ADC_SQR2_SQ5_0                    (0x01U << ADC_SQR2_SQ5_Pos)          /*!< 0x00000001 */
#define ADC_SQR2_SQ5_1                    (0x02U << ADC_SQR2_SQ5_Pos)          /*!< 0x00000002 */
#define ADC_SQR2_SQ5_2                    (0x04U << ADC_SQR2_SQ5_Pos)          /*!< 0x00000004 */
#define ADC_SQR2_SQ5_3                    (0x08U << ADC_SQR2_SQ5_Pos)          /*!< 0x00000008 */
#define ADC_SQR2_SQ5_4                    (0x10U << ADC_SQR2_SQ5_Pos)          /*!< 0x00000010 */

#define ADC_SQR2_SQ6_Pos                  (6U)
#define ADC_SQR2_SQ6_Msk                  (0x1FU << ADC_SQR2_SQ6_Pos)          /*!< 0x000007C0 */
#define ADC_SQR2_SQ6                      ADC_SQR2_SQ6_Msk                     /*!< ADC 6th conversion in regular sequence */
#define ADC_SQR2_SQ6_0                    (0x01U << ADC_SQR2_SQ6_Pos)          /*!< 0x00000040 */
#define ADC_SQR2_SQ6_1                    (0x02U << ADC_SQR2_SQ6_Pos)          /*!< 0x00000080 */
#define ADC_SQR2_SQ6_2                    (0x04U << ADC_SQR2_SQ6_Pos)          /*!< 0x00000100 */
#define ADC_SQR2_SQ6_3                    (0x08U << ADC_SQR2_SQ6_Pos)          /*!< 0x00000200 */
#define ADC_SQR2_SQ6_4                    (0x10U << ADC_SQR2_SQ6_Pos)          /*!< 0x00000400 */

#define ADC_SQR2_SQ7_Pos                  (12U)
#define ADC_SQR2_SQ7_Msk                  (0x1FU << ADC_SQR2_SQ7_Pos)          /*!< 0x0001F000 */
#define ADC_SQR2_SQ7                      ADC_SQR2_SQ7_Msk                     /*!< ADC 7th conversion in regular sequence */
#define ADC_SQR2_SQ7_0                    (0x01U << ADC_SQR2_SQ7_Pos)          /*!< 0x00001000 */
#define ADC_SQR2_SQ7_1                    (0x02U << ADC_SQR2_SQ7_Pos)          /*!< 0x00002000 */
#define ADC_SQR2_SQ7_2                    (0x04U << ADC_SQR2_SQ7_Pos)          /*!< 0x00004000 */
#define ADC_SQR2_SQ7_3                    (0x08U << ADC_SQR2_SQ7_Pos)          /*!< 0x00008000 */
#define ADC_SQR2_SQ7_4                    (0x10U << ADC_SQR2_SQ7_Pos)          /*!< 0x00010000 */

#define ADC_SQR2_SQ8_Pos                  (18U)
#define ADC_SQR2_SQ8_Msk                  (0x1FU << ADC_SQR2_SQ8_Pos)          /*!< 0x007C0000 */
#define ADC_SQR2_SQ8                      ADC_SQR2_SQ8_Msk                     /*!< ADC 8th conversion in regular sequence */
#define ADC_SQR2_SQ8_0                    (0x01U << ADC_SQR2_SQ8_Pos)          /*!< 0x00040000 */
#define ADC_SQR2_SQ8_1                    (0x02U << ADC_SQR2_SQ8_Pos)          /*!< 0x00080000 */
#define ADC_SQR2_SQ8_2                    (0x04U << ADC_SQR2_SQ8_Pos)          /*!< 0x00100000 */
#define ADC_SQR2_SQ8_3                    (0x08U << ADC_SQR2_SQ8_Pos)          /*!< 0x00200000 */
#define ADC_SQR2_SQ8_4                    (0x10U << ADC_SQR2_SQ8_Pos)          /*!< 0x00400000 */

#define ADC_SQR2_SQ9_Pos                  (24U)
#define ADC_SQR2_SQ9_Msk                  (0x1FU << ADC_SQR2_SQ9_Pos)          /*!< 0x1F000000 */
#define ADC_SQR2_SQ9                      ADC_SQR2_SQ9_Msk                     /*!< ADC 9th conversion in regular sequence */
#define ADC_SQR2_SQ9_0                    (0x01U << ADC_SQR2_SQ9_Pos)          /*!< 0x01000000 */
#define ADC_SQR2_SQ9_1                    (0x02U << ADC_SQR2_SQ9_Pos)          /*!< 0x02000000 */
#define ADC_SQR2_SQ9_2                    (0x04U << ADC_SQR2_SQ9_Pos)          /*!< 0x04000000 */
#define ADC_SQR2_SQ9_3                    (0x08U << ADC_SQR2_SQ9_Pos)          /*!< 0x08000000 */
#define ADC_SQR2_SQ9_4                    (0x10U << ADC_SQR2_SQ9_Pos)          /*!< 0x10000000 */

/********************  Bit definition for ADC_SQR3 register  ********************/
#define ADC_SQR3_SQ10_Pos                 (0U)
#define ADC_SQR3_SQ10_Msk                 (0x1FU << ADC_SQR3_SQ10_Pos)         /*!< 0x0000001F */
#define ADC_SQR3_SQ10                     ADC_SQR3_SQ10_Msk                    /*!< ADC 10th conversion in regular sequence */
#define ADC_SQR3_SQ10_0                   (0x01U << ADC_SQR3_SQ10_Pos)         /*!< 0x00000001 */
#define ADC_SQR3_SQ10_1                   (0x02U << ADC_SQR3_SQ10_Pos)         /*!< 0x00000002 */
#define ADC_SQR3_SQ10_2                   (0x04U << ADC_SQR3_SQ10_Pos)         /*!< 0x00000004 */
#define ADC_SQR3_SQ10_3                   (0x08U << ADC_SQR3_SQ10_Pos)         /*!< 0x00000008 */
#define ADC_SQR3_SQ10_4                   (0x10U << ADC_SQR3_SQ10_Pos)         /*!< 0x00000010 */

#define ADC_SQR3_SQ11_Pos                 (6U)
#define ADC_SQR3_SQ11_Msk                 (0x1FU << ADC_SQR3_SQ11_Pos)         /*!< 0x000007C0 */
#define ADC_SQR3_SQ11                     ADC_SQR3_SQ11_Msk                    /*!< ADC 11th conversion in regular sequence */
#define ADC_SQR3_SQ11_0                   (0x01U << ADC_SQR3_SQ11_Pos)         /*!< 0x00000040 */
#define ADC_SQR3_SQ11_1                   (0x02U << ADC_SQR3_SQ11_Pos)         /*!< 0x00000080 */
#define ADC_SQR3_SQ11_2                   (0x04U << ADC_SQR3_SQ11_Pos)         /*!< 0x00000100 */
#define ADC_SQR3_SQ11_3                   (0x08U << ADC_SQR3_SQ11_Pos)         /*!< 0x00000200 */
#define ADC_SQR3_SQ11_4                   (0x10U << ADC_SQR3_SQ11_Pos)         /*!< 0x00000400 */

#define ADC_SQR3_SQ12_Pos                 (12U)
#define ADC_SQR3_SQ12_Msk                 (0x1FU << ADC_SQR3_SQ12_Pos)         /*!< 0x0001F000 */
#define ADC_SQR3_SQ12                     ADC_SQR3_SQ12_Msk                    /*!< ADC 12th conversion in regular sequence */
#define ADC_SQR3_SQ12_0                   (0x01U << ADC_SQR3_SQ12_Pos)         /*!< 0x00001000 */
#define ADC_SQR3_SQ12_1                   (0x02U << ADC_SQR3_SQ12_Pos)         /*!< 0x00002000 */
#define ADC_SQR3_SQ12_2                   (0x04U << ADC_SQR3_SQ12_Pos)         /*!< 0x00004000 */
#define ADC_SQR3_SQ12_3                   (0x08U << ADC_SQR3_SQ12_Pos)         /*!< 0x00008000 */
#define ADC_SQR3_SQ12_4                   (0x10U << ADC_SQR3_SQ12_Pos)         /*!< 0x00010000 */

#define ADC_SQR3_SQ13_Pos                 (18U)
#define ADC_SQR3_SQ13_Msk                 (0x1FU << ADC_SQR3_SQ13_Pos)         /*!< 0x007C0000 */
#define ADC_SQR3_SQ13                     ADC_SQR3_SQ13_Msk                    /*!< ADC 13th conversion in regular sequence */
#define ADC_SQR3_SQ13_0                   (0x01U << ADC_SQR3_SQ13_Pos)         /*!< 0x00040000 */
#define ADC_SQR3_SQ13_1                   (0x02U << ADC_SQR3_SQ13_Pos)         /*!< 0x00080000 */
#define ADC_SQR3_SQ13_2                   (0x04U << ADC_SQR3_SQ13_Pos)         /*!< 0x00100000 */
#define ADC_SQR3_SQ13_3                   (0x08U << ADC_SQR3_SQ13_Pos)         /*!< 0x00200000 */
#define ADC_SQR3_SQ13_4                   (0x10U << ADC_SQR3_SQ13_Pos)         /*!< 0x00400000 */

#define ADC_SQR3_SQ14_Pos                 (24U)
#define ADC_SQR3_SQ14_Msk                 (0x1FU << ADC_SQR3_SQ14_Pos)         /*!< 0x1F000000 */
#define ADC_SQR3_SQ14                     ADC_SQR3_SQ14_Msk                    /*!< ADC 14th conversion in regular sequence */
#define ADC_SQR3_SQ14_0                   (0x01U << ADC_SQR3_SQ14_Pos)         /*!< 0x01000000 */
#define ADC_SQR3_SQ14_1                   (0x02U << ADC_SQR3_SQ14_Pos)         /*!< 0x02000000 */
#define ADC_SQR3_SQ14_2                   (0x04U << ADC_SQR3_SQ14_Pos)         /*!< 0x04000000 */
#define ADC_SQR3_SQ14_3                   (0x08U << ADC_SQR3_SQ14_Pos)         /*!< 0x08000000 */
#define ADC_SQR3_SQ14_4                   (0x10U << ADC_SQR3_SQ14_Pos)         /*!< 0x10000000 */

/********************  Bit definition for ADC_SQR4 register  ********************/
#define ADC_SQR4_SQ15_Pos                 (0U)
#define ADC_SQR4_SQ15_Msk                 (0x1FU << ADC_SQR4_SQ15_Pos)         /*!< 0x0000001F */
#define ADC_SQR4_SQ15                     ADC_SQR4_SQ15_Msk                    /*!< ADC 15th conversion in regular sequence */
#define ADC_SQR4_SQ15_0                   (0x01U << ADC_SQR4_SQ15_Pos)         /*!< 0x00000001 */
#define ADC_SQR4_SQ15_1                   (0x02U << ADC_SQR4_SQ15_Pos)         /*!< 0x00000002 */
#define ADC_SQR4_SQ15_2                   (0x04U << ADC_SQR4_SQ15_Pos)         /*!< 0x00000004 */
#define ADC_SQR4_SQ15_3                   (0x08U << ADC_SQR4_SQ15_Pos)         /*!< 0x00000008 */
#define ADC_SQR4_SQ15_4                   (0x10U << ADC_SQR4_SQ15_Pos)         /*!< 0x00000010 */

#define ADC_SQR4_SQ16_Pos                 (6U)
#define ADC_SQR4_SQ16_Msk                 (0x1FU << ADC_SQR4_SQ16_Pos)         /*!< 0x000007C0 */
#define ADC_SQR4_SQ16                     ADC_SQR4_SQ16_Msk                    /*!< ADC 16th conversion in regular sequence */
#define ADC_SQR4_SQ16_0                   (0x01U << ADC_SQR4_SQ16_Pos)         /*!< 0x00000040 */
#define ADC_SQR4_SQ16_1                   (0x02U << ADC_SQR4_SQ16_Pos)         /*!< 0x00000080 */
#define ADC_SQR4_SQ16_2                   (0x04U << ADC_SQR4_SQ16_Pos)         /*!< 0x00000100 */
#define ADC_SQR4_SQ16_3                   (0x08U << ADC_SQR4_SQ16_Pos)         /*!< 0x00000200 */
#define ADC_SQR4_SQ16_4                   (0x10U << ADC_SQR4_SQ16_Pos)         /*!< 0x00000400 */
/********************  Bit definition for ADC_DR register  ********************/
#define ADC_DR_RDATA_Pos                  (0U)
#define ADC_DR_RDATA_Msk                  (0xFFFFFFFFU << ADC_DR_RDATA_Pos)    /*!< 0xFFFFFFFF */
#define ADC_DR_RDATA                      ADC_DR_RDATA_Msk                     /*!< ADC regular Data converted */
#define ADC_DR_RDATA_0                    (0x0001U << ADC_DR_RDATA_Pos)        /*!< 0x00000001 */
#define ADC_DR_RDATA_1                    (0x0002U << ADC_DR_RDATA_Pos)        /*!< 0x00000002 */
#define ADC_DR_RDATA_2                    (0x0004U << ADC_DR_RDATA_Pos)        /*!< 0x00000004 */
#define ADC_DR_RDATA_3                    (0x0008U << ADC_DR_RDATA_Pos)        /*!< 0x00000008 */
#define ADC_DR_RDATA_4                    (0x0010U << ADC_DR_RDATA_Pos)        /*!< 0x00000010 */
#define ADC_DR_RDATA_5                    (0x0020U << ADC_DR_RDATA_Pos)        /*!< 0x00000020 */
#define ADC_DR_RDATA_6                    (0x0040U << ADC_DR_RDATA_Pos)        /*!< 0x00000040 */
#define ADC_DR_RDATA_7                    (0x0080U << ADC_DR_RDATA_Pos)        /*!< 0x00000080 */
#define ADC_DR_RDATA_8                    (0x0100U << ADC_DR_RDATA_Pos)        /*!< 0x00000100 */
#define ADC_DR_RDATA_9                    (0x0200U << ADC_DR_RDATA_Pos)        /*!< 0x00000200 */
#define ADC_DR_RDATA_10                   (0x0400U << ADC_DR_RDATA_Pos)        /*!< 0x00000400 */
#define ADC_DR_RDATA_11                   (0x0800U << ADC_DR_RDATA_Pos)        /*!< 0x00000800 */
#define ADC_DR_RDATA_12                   (0x1000U << ADC_DR_RDATA_Pos)        /*!< 0x00001000 */
#define ADC_DR_RDATA_13                   (0x2000U << ADC_DR_RDATA_Pos)        /*!< 0x00002000 */
#define ADC_DR_RDATA_14                   (0x4000U << ADC_DR_RDATA_Pos)        /*!< 0x00004000 */
#define ADC_DR_RDATA_15                   (0x8000U << ADC_DR_RDATA_Pos)        /*!< 0x00008000 */
#define ADC_DR_RDATA_16                   (0x10000U << ADC_DR_RDATA_Pos)       /*!< 0x00010000 */
#define ADC_DR_RDATA_17                   (0x20000U << ADC_DR_RDATA_Pos)       /*!< 0x00020000 */
#define ADC_DR_RDATA_18                   (0x40000U << ADC_DR_RDATA_Pos)       /*!< 0x00040000 */
#define ADC_DR_RDATA_19                   (0x80000U << ADC_DR_RDATA_Pos)       /*!< 0x00080000 */
#define ADC_DR_RDATA_20                   (0x100000U << ADC_DR_RDATA_Pos)      /*!< 0x00100000 */
#define ADC_DR_RDATA_21                   (0x200000U << ADC_DR_RDATA_Pos)      /*!< 0x00200000 */
#define ADC_DR_RDATA_22                   (0x400000U << ADC_DR_RDATA_Pos)      /*!< 0x00400000 */
#define ADC_DR_RDATA_23                   (0x800000U << ADC_DR_RDATA_Pos)      /*!< 0x00800000 */
#define ADC_DR_RDATA_24                   (0x1000000U << ADC_DR_RDATA_Pos)     /*!< 0x01000000 */
#define ADC_DR_RDATA_25                   (0x2000000U << ADC_DR_RDATA_Pos)     /*!< 0x02000000 */
#define ADC_DR_RDATA_26                   (0x4000000U << ADC_DR_RDATA_Pos)     /*!< 0x04000000 */
#define ADC_DR_RDATA_27                   (0x8000000U << ADC_DR_RDATA_Pos)     /*!< 0x08000000 */
#define ADC_DR_RDATA_28                   (0x10000000U << ADC_DR_RDATA_Pos)    /*!< 0x10000000 */
#define ADC_DR_RDATA_29                   (0x20000000U << ADC_DR_RDATA_Pos)    /*!< 0x20000000 */
#define ADC_DR_RDATA_30                   (0x40000000U << ADC_DR_RDATA_Pos)    /*!< 0x40000000 */
#define ADC_DR_RDATA_31                   (0x80000000U << ADC_DR_RDATA_Pos)    /*!< 0x80000000 */

/********************  Bit definition for ADC_JSQR register  ********************/
#define ADC_JSQR_JL_Pos                   (0U)
#define ADC_JSQR_JL_Msk                   (0x3U << ADC_JSQR_JL_Pos)            /*!< 0x00000003 */
#define ADC_JSQR_JL                       ADC_JSQR_JL_Msk                      /*!< ADC injected channel sequence length */
#define ADC_JSQR_JL_0                     (0x1U << ADC_JSQR_JL_Pos)            /*!< 0x00000001 */
#define ADC_JSQR_JL_1                     (0x2U << ADC_JSQR_JL_Pos)            /*!< 0x00000002 */

#define ADC_JSQR_JEXTSEL_Pos              (2U)
#define ADC_JSQR_JEXTSEL_Msk              (0x1FU << ADC_JSQR_JEXTSEL_Pos)      /*!< 0x0000007C */
#define ADC_JSQR_JEXTSEL                  ADC_JSQR_JEXTSEL_Msk                 /*!< ADC external trigger selection for injected group */
#define ADC_JSQR_JEXTSEL_0                (0x01U << ADC_JSQR_JEXTSEL_Pos)      /*!< 0x00000004 */
#define ADC_JSQR_JEXTSEL_1                (0x02U << ADC_JSQR_JEXTSEL_Pos)      /*!< 0x00000008 */
#define ADC_JSQR_JEXTSEL_2                (0x04U << ADC_JSQR_JEXTSEL_Pos)      /*!< 0x00000010 */
#define ADC_JSQR_JEXTSEL_3                (0x08U << ADC_JSQR_JEXTSEL_Pos)      /*!< 0x00000020 */
#define ADC_JSQR_JEXTSEL_4                (0x10U << ADC_JSQR_JEXTSEL_Pos)      /*!< 0x00000040 */

#define ADC_JSQR_JEXTEN_Pos               (7U)
#define ADC_JSQR_JEXTEN_Msk               (0x3U << ADC_JSQR_JEXTEN_Pos)        /*!< 0x00000180 */
#define ADC_JSQR_JEXTEN                   ADC_JSQR_JEXTEN_Msk                  /*!< ADC external trigger enable and polarity selection for injected channels */
#define ADC_JSQR_JEXTEN_0                 (0x1U << ADC_JSQR_JEXTEN_Pos)        /*!< 0x00000080 */
#define ADC_JSQR_JEXTEN_1                 (0x2U << ADC_JSQR_JEXTEN_Pos)        /*!< 0x00000100 */

#define ADC_JSQR_JSQ1_Pos                 (9U)
#define ADC_JSQR_JSQ1_Msk                 (0x1FU << ADC_JSQR_JSQ1_Pos)         /*!< 0x00003E00 */
#define ADC_JSQR_JSQ1                     ADC_JSQR_JSQ1_Msk                    /*!< ADC 1st conversion in injected sequence */
#define ADC_JSQR_JSQ1_0                   (0x01U << ADC_JSQR_JSQ1_Pos)         /*!< 0x00000200 */
#define ADC_JSQR_JSQ1_1                   (0x02U << ADC_JSQR_JSQ1_Pos)         /*!< 0x00000400 */
#define ADC_JSQR_JSQ1_2                   (0x04U << ADC_JSQR_JSQ1_Pos)         /*!< 0x00000800 */
#define ADC_JSQR_JSQ1_3                   (0x08U << ADC_JSQR_JSQ1_Pos)         /*!< 0x00001000 */
#define ADC_JSQR_JSQ1_4                   (0x10U << ADC_JSQR_JSQ1_Pos)         /*!< 0x00002000 */

#define ADC_JSQR_JSQ2_Pos                 (15U)
#define ADC_JSQR_JSQ2_Msk                 (0x1FU << ADC_JSQR_JSQ2_Pos)         /*!< 0x000F8000 */
#define ADC_JSQR_JSQ2                     ADC_JSQR_JSQ2_Msk                    /*!< ADC 2nd conversion in injected sequence */
#define ADC_JSQR_JSQ2_0                   (0x01U << ADC_JSQR_JSQ2_Pos)         /*!< 0x00008000 */
#define ADC_JSQR_JSQ2_1                   (0x02U << ADC_JSQR_JSQ2_Pos)         /*!< 0x00010000 */
#define ADC_JSQR_JSQ2_2                   (0x04U << ADC_JSQR_JSQ2_Pos)         /*!< 0x00020000 */
#define ADC_JSQR_JSQ2_3                   (0x08U << ADC_JSQR_JSQ2_Pos)         /*!< 0x00040000 */
#define ADC_JSQR_JSQ2_4                   (0x10U << ADC_JSQR_JSQ2_Pos)         /*!< 0x00080000 */

#define ADC_JSQR_JSQ3_Pos                 (21U)
#define ADC_JSQR_JSQ3_Msk                 (0x1FU << ADC_JSQR_JSQ3_Pos)         /*!< 0x03E00000 */
#define ADC_JSQR_JSQ3                     ADC_JSQR_JSQ3_Msk                    /*!< ADC 3rd conversion in injected sequence */
#define ADC_JSQR_JSQ3_0                   (0x01U << ADC_JSQR_JSQ3_Pos)         /*!< 0x00200000 */
#define ADC_JSQR_JSQ3_1                   (0x02U << ADC_JSQR_JSQ3_Pos)         /*!< 0x00400000 */
#define ADC_JSQR_JSQ3_2                   (0x04U << ADC_JSQR_JSQ3_Pos)         /*!< 0x00800000 */
#define ADC_JSQR_JSQ3_3                   (0x08U << ADC_JSQR_JSQ3_Pos)         /*!< 0x01000000 */
#define ADC_JSQR_JSQ3_4                   (0x10U << ADC_JSQR_JSQ3_Pos)         /*!< 0x02000000 */

#define ADC_JSQR_JSQ4_Pos                 (27U)
#define ADC_JSQR_JSQ4_Msk                 (0x1FU << ADC_JSQR_JSQ4_Pos)         /*!< 0xF8000000 */
#define ADC_JSQR_JSQ4                     ADC_JSQR_JSQ4_Msk                    /*!< ADC 4th conversion in injected sequence */
#define ADC_JSQR_JSQ4_0                   (0x01U << ADC_JSQR_JSQ4_Pos)         /*!< 0x08000000 */
#define ADC_JSQR_JSQ4_1                   (0x02U << ADC_JSQR_JSQ4_Pos)         /*!< 0x10000000 */
#define ADC_JSQR_JSQ4_2                   (0x04U << ADC_JSQR_JSQ4_Pos)         /*!< 0x20000000 */
#define ADC_JSQR_JSQ4_3                   (0x08U << ADC_JSQR_JSQ4_Pos)         /*!< 0x40000000 */
#define ADC_JSQR_JSQ4_4                   (0x10U << ADC_JSQR_JSQ4_Pos)         /*!< 0x80000000 */

/********************  Bit definition for ADC_OFR1 register  ********************/
#define ADC_OFR1_OFFSET1_Pos              (0U)
#define ADC_OFR1_OFFSET1_Msk              (0x3FFFFFFU << ADC_OFR1_OFFSET1_Pos) /*!< 0x03FFFFFF */
#define ADC_OFR1_OFFSET1                  ADC_OFR1_OFFSET1_Msk                 /*!< ADC data offset 1 for channel programmed into bits OFFSET1_CH[4:0] */
#define ADC_OFR1_OFFSET1_0                (0x0000001U << ADC_OFR1_OFFSET1_Pos) /*!< 0x00000001 */
#define ADC_OFR1_OFFSET1_1                (0x0000002U << ADC_OFR1_OFFSET1_Pos) /*!< 0x00000002 */
#define ADC_OFR1_OFFSET1_2                (0x0000004U << ADC_OFR1_OFFSET1_Pos) /*!< 0x00000004 */
#define ADC_OFR1_OFFSET1_3                (0x0000008U << ADC_OFR1_OFFSET1_Pos) /*!< 0x00000008 */
#define ADC_OFR1_OFFSET1_4                (0x0000010U << ADC_OFR1_OFFSET1_Pos) /*!< 0x00000010 */
#define ADC_OFR1_OFFSET1_5                (0x0000020U << ADC_OFR1_OFFSET1_Pos) /*!< 0x00000020 */
#define ADC_OFR1_OFFSET1_6                (0x0000040U << ADC_OFR1_OFFSET1_Pos) /*!< 0x00000040 */
#define ADC_OFR1_OFFSET1_7                (0x0000080U << ADC_OFR1_OFFSET1_Pos) /*!< 0x00000080 */
#define ADC_OFR1_OFFSET1_8                (0x0000100U << ADC_OFR1_OFFSET1_Pos) /*!< 0x00000100 */
#define ADC_OFR1_OFFSET1_9                (0x0000200U << ADC_OFR1_OFFSET1_Pos) /*!< 0x00000200 */
#define ADC_OFR1_OFFSET1_10               (0x0000400U << ADC_OFR1_OFFSET1_Pos) /*!< 0x00000400 */
#define ADC_OFR1_OFFSET1_11               (0x0000800U << ADC_OFR1_OFFSET1_Pos) /*!< 0x00000800 */
#define ADC_OFR1_OFFSET1_12               (0x0001000U << ADC_OFR1_OFFSET1_Pos) /*!< 0x00001000 */
#define ADC_OFR1_OFFSET1_13               (0x0002000U << ADC_OFR1_OFFSET1_Pos) /*!< 0x00002000 */
#define ADC_OFR1_OFFSET1_14               (0x0004000U << ADC_OFR1_OFFSET1_Pos) /*!< 0x00004000 */
#define ADC_OFR1_OFFSET1_15               (0x0008000U << ADC_OFR1_OFFSET1_Pos) /*!< 0x00008000 */
#define ADC_OFR1_OFFSET1_16               (0x0010000U << ADC_OFR1_OFFSET1_Pos) /*!< 0x00010000 */
#define ADC_OFR1_OFFSET1_17               (0x0020000U << ADC_OFR1_OFFSET1_Pos) /*!< 0x00020000 */
#define ADC_OFR1_OFFSET1_18               (0x0040000U << ADC_OFR1_OFFSET1_Pos) /*!< 0x00040000 */
#define ADC_OFR1_OFFSET1_19               (0x0080000U << ADC_OFR1_OFFSET1_Pos) /*!< 0x00080000 */
#define ADC_OFR1_OFFSET1_20               (0x0100000U << ADC_OFR1_OFFSET1_Pos) /*!< 0x00100000 */
#define ADC_OFR1_OFFSET1_21               (0x0200000U << ADC_OFR1_OFFSET1_Pos) /*!< 0x00200000 */
#define ADC_OFR1_OFFSET1_22               (0x0400000U << ADC_OFR1_OFFSET1_Pos) /*!< 0x00400000 */
#define ADC_OFR1_OFFSET1_23               (0x0800000U << ADC_OFR1_OFFSET1_Pos) /*!< 0x00800000 */
#define ADC_OFR1_OFFSET1_24               (0x1000000U << ADC_OFR1_OFFSET1_Pos) /*!< 0x01000000 */
#define ADC_OFR1_OFFSET1_25               (0x2000000U << ADC_OFR1_OFFSET1_Pos) /*!< 0x02000000 */

#define ADC_OFR1_OFFSET1_CH_Pos           (26U)
#define ADC_OFR1_OFFSET1_CH_Msk           (0x1FU << ADC_OFR1_OFFSET1_CH_Pos)   /*!< 0x7C000000 */
#define ADC_OFR1_OFFSET1_CH               ADC_OFR1_OFFSET1_CH_Msk              /*!< ADC Channel selection for the data offset 1 */
#define ADC_OFR1_OFFSET1_CH_0             (0x01U << ADC_OFR1_OFFSET1_CH_Pos)   /*!< 0x04000000 */
#define ADC_OFR1_OFFSET1_CH_1             (0x02U << ADC_OFR1_OFFSET1_CH_Pos)   /*!< 0x08000000 */
#define ADC_OFR1_OFFSET1_CH_2             (0x04U << ADC_OFR1_OFFSET1_CH_Pos)   /*!< 0x10000000 */
#define ADC_OFR1_OFFSET1_CH_3             (0x08U << ADC_OFR1_OFFSET1_CH_Pos)   /*!< 0x20000000 */
#define ADC_OFR1_OFFSET1_CH_4             (0x10U << ADC_OFR1_OFFSET1_CH_Pos)   /*!< 0x40000000 */

#define ADC_OFR1_SSATE_Pos                (31U)
#define ADC_OFR1_SSATE_Msk                (0x1U << ADC_OFR1_SSATE_Pos)         /*!< 0x80000000 */
#define ADC_OFR1_SSATE                    ADC_OFR1_SSATE_Msk                   /*!< ADC Signed saturation Enable */

/********************  Bit definition for ADC_OFR2 register  ********************/
#define ADC_OFR2_OFFSET2_Pos              (0U)
#define ADC_OFR2_OFFSET2_Msk              (0x3FFFFFFU << ADC_OFR2_OFFSET2_Pos) /*!< 0x03FFFFFF */
#define ADC_OFR2_OFFSET2                  ADC_OFR2_OFFSET2_Msk                 /*!< ADC data offset 2 for channel programmed into bits OFFSET2_CH[4:0] */
#define ADC_OFR2_OFFSET2_0                (0x0000001U << ADC_OFR2_OFFSET2_Pos) /*!< 0x00000001 */
#define ADC_OFR2_OFFSET2_1                (0x0000002U << ADC_OFR2_OFFSET2_Pos) /*!< 0x00000002 */
#define ADC_OFR2_OFFSET2_2                (0x0000004U << ADC_OFR2_OFFSET2_Pos) /*!< 0x00000004 */
#define ADC_OFR2_OFFSET2_3                (0x0000008U << ADC_OFR2_OFFSET2_Pos) /*!< 0x00000008 */
#define ADC_OFR2_OFFSET2_4                (0x0000010U << ADC_OFR2_OFFSET2_Pos) /*!< 0x00000010 */
#define ADC_OFR2_OFFSET2_5                (0x0000020U << ADC_OFR2_OFFSET2_Pos) /*!< 0x00000020 */
#define ADC_OFR2_OFFSET2_6                (0x0000040U << ADC_OFR2_OFFSET2_Pos) /*!< 0x00000040 */
#define ADC_OFR2_OFFSET2_7                (0x0000080U << ADC_OFR2_OFFSET2_Pos) /*!< 0x00000080 */
#define ADC_OFR2_OFFSET2_8                (0x0000100U << ADC_OFR2_OFFSET2_Pos) /*!< 0x00000100 */
#define ADC_OFR2_OFFSET2_9                (0x0000200U << ADC_OFR2_OFFSET2_Pos) /*!< 0x00000200 */
#define ADC_OFR2_OFFSET2_10               (0x0000400U << ADC_OFR2_OFFSET2_Pos) /*!< 0x00000400 */
#define ADC_OFR2_OFFSET2_11               (0x0000800U << ADC_OFR2_OFFSET2_Pos) /*!< 0x00000800 */
#define ADC_OFR2_OFFSET2_12               (0x0001000U << ADC_OFR2_OFFSET2_Pos) /*!< 0x00001000 */
#define ADC_OFR2_OFFSET2_13               (0x0002000U << ADC_OFR2_OFFSET2_Pos) /*!< 0x00002000 */
#define ADC_OFR2_OFFSET2_14               (0x0004000U << ADC_OFR2_OFFSET2_Pos) /*!< 0x00004000 */
#define ADC_OFR2_OFFSET2_15               (0x0008000U << ADC_OFR2_OFFSET2_Pos) /*!< 0x00008000 */
#define ADC_OFR2_OFFSET2_16               (0x0010000U << ADC_OFR2_OFFSET2_Pos) /*!< 0x00010000 */
#define ADC_OFR2_OFFSET2_17               (0x0020000U << ADC_OFR2_OFFSET2_Pos) /*!< 0x00020000 */
#define ADC_OFR2_OFFSET2_18               (0x0040000U << ADC_OFR2_OFFSET2_Pos) /*!< 0x00040000 */
#define ADC_OFR2_OFFSET2_19               (0x0080000U << ADC_OFR2_OFFSET2_Pos) /*!< 0x00080000 */
#define ADC_OFR2_OFFSET2_20               (0x0100000U << ADC_OFR2_OFFSET2_Pos) /*!< 0x00100000 */
#define ADC_OFR2_OFFSET2_21               (0x0200000U << ADC_OFR2_OFFSET2_Pos) /*!< 0x00200000 */
#define ADC_OFR2_OFFSET2_22               (0x0400000U << ADC_OFR2_OFFSET2_Pos) /*!< 0x00400000 */
#define ADC_OFR2_OFFSET2_23               (0x0800000U << ADC_OFR2_OFFSET2_Pos) /*!< 0x00800000 */
#define ADC_OFR2_OFFSET2_24               (0x1000000U << ADC_OFR2_OFFSET2_Pos) /*!< 0x01000000 */
#define ADC_OFR2_OFFSET2_25               (0x2000000U << ADC_OFR2_OFFSET2_Pos) /*!< 0x02000000 */

#define ADC_OFR2_OFFSET2_CH_Pos           (26U)
#define ADC_OFR2_OFFSET2_CH_Msk           (0x1FU << ADC_OFR2_OFFSET2_CH_Pos)   /*!< 0x7C000000 */
#define ADC_OFR2_OFFSET2_CH               ADC_OFR2_OFFSET2_CH_Msk              /*!< ADC Channel selection for the data offset 2 */
#define ADC_OFR2_OFFSET2_CH_0             (0x01U << ADC_OFR2_OFFSET2_CH_Pos)   /*!< 0x04000000 */
#define ADC_OFR2_OFFSET2_CH_1             (0x02U << ADC_OFR2_OFFSET2_CH_Pos)   /*!< 0x08000000 */
#define ADC_OFR2_OFFSET2_CH_2             (0x04U << ADC_OFR2_OFFSET2_CH_Pos)   /*!< 0x10000000 */
#define ADC_OFR2_OFFSET2_CH_3             (0x08U << ADC_OFR2_OFFSET2_CH_Pos)   /*!< 0x20000000 */
#define ADC_OFR2_OFFSET2_CH_4             (0x10U << ADC_OFR2_OFFSET2_CH_Pos)   /*!< 0x40000000 */

#define ADC_OFR2_SSATE_Pos                (31U)
#define ADC_OFR2_SSATE_Msk                (0x1U << ADC_OFR2_SSATE_Pos)         /*!< 0x80000000 */
#define ADC_OFR2_SSATE                    ADC_OFR2_SSATE_Msk                   /*!< ADC Signed saturation Enable */

/********************  Bit definition for ADC_OFR3 register  ********************/
#define ADC_OFR3_OFFSET3_Pos              (0U)
#define ADC_OFR3_OFFSET3_Msk              (0x3FFFFFFU << ADC_OFR3_OFFSET3_Pos) /*!< 0x03FFFFFF */
#define ADC_OFR3_OFFSET3                  ADC_OFR3_OFFSET3_Msk                 /*!< ADC data offset 3 for channel programmed into bits OFFSET3_CH[4:0] */
#define ADC_OFR3_OFFSET3_0                (0x0000001U << ADC_OFR3_OFFSET3_Pos) /*!< 0x00000001 */
#define ADC_OFR3_OFFSET3_1                (0x0000002U << ADC_OFR3_OFFSET3_Pos) /*!< 0x00000002 */
#define ADC_OFR3_OFFSET3_2                (0x0000004U << ADC_OFR3_OFFSET3_Pos) /*!< 0x00000004 */
#define ADC_OFR3_OFFSET3_3                (0x0000008U << ADC_OFR3_OFFSET3_Pos) /*!< 0x00000008 */
#define ADC_OFR3_OFFSET3_4                (0x0000010U << ADC_OFR3_OFFSET3_Pos) /*!< 0x00000010 */
#define ADC_OFR3_OFFSET3_5                (0x0000020U << ADC_OFR3_OFFSET3_Pos) /*!< 0x00000020 */
#define ADC_OFR3_OFFSET3_6                (0x0000040U << ADC_OFR3_OFFSET3_Pos) /*!< 0x00000040 */
#define ADC_OFR3_OFFSET3_7                (0x0000080U << ADC_OFR3_OFFSET3_Pos) /*!< 0x00000080 */
#define ADC_OFR3_OFFSET3_8                (0x0000100U << ADC_OFR3_OFFSET3_Pos) /*!< 0x00000100 */
#define ADC_OFR3_OFFSET3_9                (0x0000200U << ADC_OFR3_OFFSET3_Pos) /*!< 0x00000200 */
#define ADC_OFR3_OFFSET3_10               (0x0000400U << ADC_OFR3_OFFSET3_Pos) /*!< 0x00000400 */
#define ADC_OFR3_OFFSET3_11               (0x0000800U << ADC_OFR3_OFFSET3_Pos) /*!< 0x00000800 */
#define ADC_OFR3_OFFSET3_12               (0x0001000U << ADC_OFR3_OFFSET3_Pos) /*!< 0x00001000 */
#define ADC_OFR3_OFFSET3_13               (0x0002000U << ADC_OFR3_OFFSET3_Pos) /*!< 0x00002000 */
#define ADC_OFR3_OFFSET3_14               (0x0004000U << ADC_OFR3_OFFSET3_Pos) /*!< 0x00004000 */
#define ADC_OFR3_OFFSET3_15               (0x0008000U << ADC_OFR3_OFFSET3_Pos) /*!< 0x00008000 */
#define ADC_OFR3_OFFSET3_16               (0x0010000U << ADC_OFR3_OFFSET3_Pos) /*!< 0x00010000 */
#define ADC_OFR3_OFFSET3_17               (0x0020000U << ADC_OFR3_OFFSET3_Pos) /*!< 0x00020000 */
#define ADC_OFR3_OFFSET3_18               (0x0040000U << ADC_OFR3_OFFSET3_Pos) /*!< 0x00040000 */
#define ADC_OFR3_OFFSET3_19               (0x0080000U << ADC_OFR3_OFFSET3_Pos) /*!< 0x00080000 */
#define ADC_OFR3_OFFSET3_20               (0x0100000U << ADC_OFR3_OFFSET3_Pos) /*!< 0x00100000 */
#define ADC_OFR3_OFFSET3_21               (0x0200000U << ADC_OFR3_OFFSET3_Pos) /*!< 0x00200000 */
#define ADC_OFR3_OFFSET3_22               (0x0400000U << ADC_OFR3_OFFSET3_Pos) /*!< 0x00400000 */
#define ADC_OFR3_OFFSET3_23               (0x0800000U << ADC_OFR3_OFFSET3_Pos) /*!< 0x00800000 */
#define ADC_OFR3_OFFSET3_24               (0x1000000U << ADC_OFR3_OFFSET3_Pos) /*!< 0x01000000 */
#define ADC_OFR3_OFFSET3_25               (0x2000000U << ADC_OFR3_OFFSET3_Pos) /*!< 0x02000000 */

#define ADC_OFR3_OFFSET3_CH_Pos           (26U)
#define ADC_OFR3_OFFSET3_CH_Msk           (0x1FU << ADC_OFR3_OFFSET3_CH_Pos)   /*!< 0x7C000000 */
#define ADC_OFR3_OFFSET3_CH               ADC_OFR3_OFFSET3_CH_Msk              /*!< ADC Channel selection for the data offset 3 */
#define ADC_OFR3_OFFSET3_CH_0             (0x01U << ADC_OFR3_OFFSET3_CH_Pos)   /*!< 0x04000000 */
#define ADC_OFR3_OFFSET3_CH_1             (0x02U << ADC_OFR3_OFFSET3_CH_Pos)   /*!< 0x08000000 */
#define ADC_OFR3_OFFSET3_CH_2             (0x04U << ADC_OFR3_OFFSET3_CH_Pos)   /*!< 0x10000000 */
#define ADC_OFR3_OFFSET3_CH_3             (0x08U << ADC_OFR3_OFFSET3_CH_Pos)   /*!< 0x20000000 */
#define ADC_OFR3_OFFSET3_CH_4             (0x10U << ADC_OFR3_OFFSET3_CH_Pos)   /*!< 0x40000000 */

#define ADC_OFR3_SSATE_Pos                (31U)
#define ADC_OFR3_SSATE_Msk                (0x1U << ADC_OFR3_SSATE_Pos)         /*!< 0x80000000 */
#define ADC_OFR3_SSATE                    ADC_OFR3_SSATE_Msk                   /*!< ADC Signed saturation Enable */

/********************  Bit definition for ADC_OFR4 register  ********************/
#define ADC_OFR4_OFFSET4_Pos              (0U)
#define ADC_OFR4_OFFSET4_Msk              (0x3FFFFFFU << ADC_OFR4_OFFSET4_Pos) /*!< 0x03FFFFFF */
#define ADC_OFR4_OFFSET4                  ADC_OFR4_OFFSET4_Msk                 /*!< ADC data offset 4 for channel programmed into bits OFFSET4_CH[4:0] */
#define ADC_OFR4_OFFSET4_0                (0x0000001U << ADC_OFR4_OFFSET4_Pos) /*!< 0x00000001 */
#define ADC_OFR4_OFFSET4_1                (0x0000002U << ADC_OFR4_OFFSET4_Pos) /*!< 0x00000002 */
#define ADC_OFR4_OFFSET4_2                (0x0000004U << ADC_OFR4_OFFSET4_Pos) /*!< 0x00000004 */
#define ADC_OFR4_OFFSET4_3                (0x0000008U << ADC_OFR4_OFFSET4_Pos) /*!< 0x00000008 */
#define ADC_OFR4_OFFSET4_4                (0x0000010U << ADC_OFR4_OFFSET4_Pos) /*!< 0x00000010 */
#define ADC_OFR4_OFFSET4_5                (0x0000020U << ADC_OFR4_OFFSET4_Pos) /*!< 0x00000020 */
#define ADC_OFR4_OFFSET4_6                (0x0000040U << ADC_OFR4_OFFSET4_Pos) /*!< 0x00000040 */
#define ADC_OFR4_OFFSET4_7                (0x0000080U << ADC_OFR4_OFFSET4_Pos) /*!< 0x00000080 */
#define ADC_OFR4_OFFSET4_8                (0x0000100U << ADC_OFR4_OFFSET4_Pos) /*!< 0x00000100 */
#define ADC_OFR4_OFFSET4_9                (0x0000200U << ADC_OFR4_OFFSET4_Pos) /*!< 0x00000200 */
#define ADC_OFR4_OFFSET4_10               (0x0000400U << ADC_OFR4_OFFSET4_Pos) /*!< 0x00000400 */
#define ADC_OFR4_OFFSET4_11               (0x0000800U << ADC_OFR4_OFFSET4_Pos) /*!< 0x00000800 */
#define ADC_OFR4_OFFSET4_12               (0x0001000U << ADC_OFR4_OFFSET4_Pos) /*!< 0x00001000 */
#define ADC_OFR4_OFFSET4_13               (0x0002000U << ADC_OFR4_OFFSET4_Pos) /*!< 0x00002000 */
#define ADC_OFR4_OFFSET4_14               (0x0004000U << ADC_OFR4_OFFSET4_Pos) /*!< 0x00004000 */
#define ADC_OFR4_OFFSET4_15               (0x0008000U << ADC_OFR4_OFFSET4_Pos) /*!< 0x00008000 */
#define ADC_OFR4_OFFSET4_16               (0x0010000U << ADC_OFR4_OFFSET4_Pos) /*!< 0x00010000 */
#define ADC_OFR4_OFFSET4_17               (0x0020000U << ADC_OFR4_OFFSET4_Pos) /*!< 0x00020000 */
#define ADC_OFR4_OFFSET4_18               (0x0040000U << ADC_OFR4_OFFSET4_Pos) /*!< 0x00040000 */
#define ADC_OFR4_OFFSET4_19               (0x0080000U << ADC_OFR4_OFFSET4_Pos) /*!< 0x00080000 */
#define ADC_OFR4_OFFSET4_20               (0x0100000U << ADC_OFR4_OFFSET4_Pos) /*!< 0x00100000 */
#define ADC_OFR4_OFFSET4_21               (0x0200000U << ADC_OFR4_OFFSET4_Pos) /*!< 0x00200000 */
#define ADC_OFR4_OFFSET4_22               (0x0400000U << ADC_OFR4_OFFSET4_Pos) /*!< 0x00400000 */
#define ADC_OFR4_OFFSET4_23               (0x0800000U << ADC_OFR4_OFFSET4_Pos) /*!< 0x00800000 */
#define ADC_OFR4_OFFSET4_24               (0x1000000U << ADC_OFR4_OFFSET4_Pos) /*!< 0x01000000 */
#define ADC_OFR4_OFFSET4_25               (0x2000000U << ADC_OFR4_OFFSET4_Pos) /*!< 0x02000000 */

#define ADC_OFR4_OFFSET4_CH_Pos           (26U)
#define ADC_OFR4_OFFSET4_CH_Msk           (0x1FU << ADC_OFR4_OFFSET4_CH_Pos)   /*!< 0x7C000000 */
#define ADC_OFR4_OFFSET4_CH               ADC_OFR4_OFFSET4_CH_Msk              /*!< ADC Channel selection for the data offset 4 */
#define ADC_OFR4_OFFSET4_CH_0             (0x01U << ADC_OFR4_OFFSET4_CH_Pos)   /*!< 0x04000000 */
#define ADC_OFR4_OFFSET4_CH_1             (0x02U << ADC_OFR4_OFFSET4_CH_Pos)   /*!< 0x08000000 */
#define ADC_OFR4_OFFSET4_CH_2             (0x04U << ADC_OFR4_OFFSET4_CH_Pos)   /*!< 0x10000000 */
#define ADC_OFR4_OFFSET4_CH_3             (0x08U << ADC_OFR4_OFFSET4_CH_Pos)   /*!< 0x20000000 */
#define ADC_OFR4_OFFSET4_CH_4             (0x10U << ADC_OFR4_OFFSET4_CH_Pos)   /*!< 0x40000000 */

#define ADC_OFR4_SSATE_Pos                (31U)
#define ADC_OFR4_SSATE_Msk                (0x1U << ADC_OFR4_SSATE_Pos)         /*!< 0x80000000 */
#define ADC_OFR4_SSATE                    ADC_OFR4_SSATE_Msk                   /*!< ADC Signed saturation Enable */

/********************  Bit definition for ADC_JDR1 register  ********************/
#define ADC_JDR1_JDATA_Pos                (0U)
#define ADC_JDR1_JDATA_Msk                (0xFFFFFFFFU << ADC_JDR1_JDATA_Pos)  /*!< 0xFFFFFFFF */
#define ADC_JDR1_JDATA                    ADC_JDR1_JDATA_Msk                   /*!< ADC Injected DATA */
#define ADC_JDR1_JDATA_0                  (0x0001U << ADC_JDR1_JDATA_Pos)      /*!< 0x00000001 */
#define ADC_JDR1_JDATA_1                  (0x0002U << ADC_JDR1_JDATA_Pos)      /*!< 0x00000002 */
#define ADC_JDR1_JDATA_2                  (0x0004U << ADC_JDR1_JDATA_Pos)      /*!< 0x00000004 */
#define ADC_JDR1_JDATA_3                  (0x0008U << ADC_JDR1_JDATA_Pos)      /*!< 0x00000008 */
#define ADC_JDR1_JDATA_4                  (0x0010U << ADC_JDR1_JDATA_Pos)      /*!< 0x00000010 */
#define ADC_JDR1_JDATA_5                  (0x0020U << ADC_JDR1_JDATA_Pos)      /*!< 0x00000020 */
#define ADC_JDR1_JDATA_6                  (0x0040U << ADC_JDR1_JDATA_Pos)      /*!< 0x00000040 */
#define ADC_JDR1_JDATA_7                  (0x0080U << ADC_JDR1_JDATA_Pos)      /*!< 0x00000080 */
#define ADC_JDR1_JDATA_8                  (0x0100U << ADC_JDR1_JDATA_Pos)      /*!< 0x00000100 */
#define ADC_JDR1_JDATA_9                  (0x0200U << ADC_JDR1_JDATA_Pos)      /*!< 0x00000200 */
#define ADC_JDR1_JDATA_10                 (0x0400U << ADC_JDR1_JDATA_Pos)      /*!< 0x00000400 */
#define ADC_JDR1_JDATA_11                 (0x0800U << ADC_JDR1_JDATA_Pos)      /*!< 0x00000800 */
#define ADC_JDR1_JDATA_12                 (0x1000U << ADC_JDR1_JDATA_Pos)      /*!< 0x00001000 */
#define ADC_JDR1_JDATA_13                 (0x2000U << ADC_JDR1_JDATA_Pos)      /*!< 0x00002000 */
#define ADC_JDR1_JDATA_14                 (0x4000U << ADC_JDR1_JDATA_Pos)      /*!< 0x00004000 */
#define ADC_JDR1_JDATA_15                 (0x8000U << ADC_JDR1_JDATA_Pos)      /*!< 0x00008000 */
#define ADC_JDR1_JDATA_16                 (0x10000U << ADC_JDR1_JDATA_Pos)     /*!< 0x00010000 */
#define ADC_JDR1_JDATA_17                 (0x20000U << ADC_JDR1_JDATA_Pos)     /*!< 0x00020000 */
#define ADC_JDR1_JDATA_18                 (0x40000U << ADC_JDR1_JDATA_Pos)     /*!< 0x00040000 */
#define ADC_JDR1_JDATA_19                 (0x80000U << ADC_JDR1_JDATA_Pos)     /*!< 0x00080000 */
#define ADC_JDR1_JDATA_20                 (0x100000U << ADC_JDR1_JDATA_Pos)    /*!< 0x00100000 */
#define ADC_JDR1_JDATA_21                 (0x200000U << ADC_JDR1_JDATA_Pos)    /*!< 0x00200000 */
#define ADC_JDR1_JDATA_22                 (0x400000U << ADC_JDR1_JDATA_Pos)    /*!< 0x00400000 */
#define ADC_JDR1_JDATA_23                 (0x800000U << ADC_JDR1_JDATA_Pos)    /*!< 0x00800000 */
#define ADC_JDR1_JDATA_24                 (0x1000000U << ADC_JDR1_JDATA_Pos)   /*!< 0x01000000 */
#define ADC_JDR1_JDATA_25                 (0x2000000U << ADC_JDR1_JDATA_Pos)   /*!< 0x02000000 */
#define ADC_JDR1_JDATA_26                 (0x4000000U << ADC_JDR1_JDATA_Pos)   /*!< 0x04000000 */
#define ADC_JDR1_JDATA_27                 (0x8000000U << ADC_JDR1_JDATA_Pos)   /*!< 0x08000000 */
#define ADC_JDR1_JDATA_28                 (0x10000000U << ADC_JDR1_JDATA_Pos)  /*!< 0x10000000 */
#define ADC_JDR1_JDATA_29                 (0x20000000U << ADC_JDR1_JDATA_Pos)  /*!< 0x20000000 */
#define ADC_JDR1_JDATA_30                 (0x40000000U << ADC_JDR1_JDATA_Pos)  /*!< 0x40000000 */
#define ADC_JDR1_JDATA_31                 (0x80000000U << ADC_JDR1_JDATA_Pos)  /*!< 0x80000000 */

/********************  Bit definition for ADC_JDR2 register  ********************/
#define ADC_JDR2_JDATA_Pos                (0U)
#define ADC_JDR2_JDATA_Msk                (0xFFFFFFFFU << ADC_JDR2_JDATA_Pos)  /*!< 0xFFFFFFFF */
#define ADC_JDR2_JDATA                    ADC_JDR2_JDATA_Msk                   /*!< ADC Injected DATA */
#define ADC_JDR2_JDATA_0                  (0x0001U << ADC_JDR2_JDATA_Pos)      /*!< 0x00000001 */
#define ADC_JDR2_JDATA_1                  (0x0002U << ADC_JDR2_JDATA_Pos)      /*!< 0x00000002 */
#define ADC_JDR2_JDATA_2                  (0x0004U << ADC_JDR2_JDATA_Pos)      /*!< 0x00000004 */
#define ADC_JDR2_JDATA_3                  (0x0008U << ADC_JDR2_JDATA_Pos)      /*!< 0x00000008 */
#define ADC_JDR2_JDATA_4                  (0x0010U << ADC_JDR2_JDATA_Pos)      /*!< 0x00000010 */
#define ADC_JDR2_JDATA_5                  (0x0020U << ADC_JDR2_JDATA_Pos)      /*!< 0x00000020 */
#define ADC_JDR2_JDATA_6                  (0x0040U << ADC_JDR2_JDATA_Pos)      /*!< 0x00000040 */
#define ADC_JDR2_JDATA_7                  (0x0080U << ADC_JDR2_JDATA_Pos)      /*!< 0x00000080 */
#define ADC_JDR2_JDATA_8                  (0x0100U << ADC_JDR2_JDATA_Pos)      /*!< 0x00000100 */
#define ADC_JDR2_JDATA_9                  (0x0200U << ADC_JDR2_JDATA_Pos)      /*!< 0x00000200 */
#define ADC_JDR2_JDATA_10                 (0x0400U << ADC_JDR2_JDATA_Pos)      /*!< 0x00000400 */
#define ADC_JDR2_JDATA_11                 (0x0800U << ADC_JDR2_JDATA_Pos)      /*!< 0x00000800 */
#define ADC_JDR2_JDATA_12                 (0x1000U << ADC_JDR2_JDATA_Pos)      /*!< 0x00001000 */
#define ADC_JDR2_JDATA_13                 (0x2000U << ADC_JDR2_JDATA_Pos)      /*!< 0x00002000 */
#define ADC_JDR2_JDATA_14                 (0x4000U << ADC_JDR2_JDATA_Pos)      /*!< 0x00004000 */
#define ADC_JDR2_JDATA_15                 (0x8000U << ADC_JDR2_JDATA_Pos)      /*!< 0x00008000 */
#define ADC_JDR2_JDATA_16                 (0x10000U << ADC_JDR2_JDATA_Pos)     /*!< 0x00010000 */
#define ADC_JDR2_JDATA_17                 (0x20000U << ADC_JDR2_JDATA_Pos)     /*!< 0x00020000 */
#define ADC_JDR2_JDATA_18                 (0x40000U << ADC_JDR2_JDATA_Pos)     /*!< 0x00040000 */
#define ADC_JDR2_JDATA_19                 (0x80000U << ADC_JDR2_JDATA_Pos)     /*!< 0x00080000 */
#define ADC_JDR2_JDATA_20                 (0x100000U << ADC_JDR2_JDATA_Pos)    /*!< 0x00100000 */
#define ADC_JDR2_JDATA_21                 (0x200000U << ADC_JDR2_JDATA_Pos)    /*!< 0x00200000 */
#define ADC_JDR2_JDATA_22                 (0x400000U << ADC_JDR2_JDATA_Pos)    /*!< 0x00400000 */
#define ADC_JDR2_JDATA_23                 (0x800000U << ADC_JDR2_JDATA_Pos)    /*!< 0x00800000 */
#define ADC_JDR2_JDATA_24                 (0x1000000U << ADC_JDR2_JDATA_Pos)   /*!< 0x01000000 */
#define ADC_JDR2_JDATA_25                 (0x2000000U << ADC_JDR2_JDATA_Pos)   /*!< 0x02000000 */
#define ADC_JDR2_JDATA_26                 (0x4000000U << ADC_JDR2_JDATA_Pos)   /*!< 0x04000000 */
#define ADC_JDR2_JDATA_27                 (0x8000000U << ADC_JDR2_JDATA_Pos)   /*!< 0x08000000 */
#define ADC_JDR2_JDATA_28                 (0x10000000U << ADC_JDR2_JDATA_Pos)  /*!< 0x10000000 */
#define ADC_JDR2_JDATA_29                 (0x20000000U << ADC_JDR2_JDATA_Pos)  /*!< 0x20000000 */
#define ADC_JDR2_JDATA_30                 (0x40000000U << ADC_JDR2_JDATA_Pos)  /*!< 0x40000000 */
#define ADC_JDR2_JDATA_31                 (0x80000000U << ADC_JDR2_JDATA_Pos)  /*!< 0x80000000 */

/********************  Bit definition for ADC_JDR3 register  ********************/
#define ADC_JDR3_JDATA_Pos                (0U)
#define ADC_JDR3_JDATA_Msk                (0xFFFFFFFFU << ADC_JDR3_JDATA_Pos)  /*!< 0xFFFFFFFF */
#define ADC_JDR3_JDATA                    ADC_JDR3_JDATA_Msk                   /*!< ADC Injected DATA */
#define ADC_JDR3_JDATA_0                  (0x0001U << ADC_JDR3_JDATA_Pos)      /*!< 0x00000001 */
#define ADC_JDR3_JDATA_1                  (0x0002U << ADC_JDR3_JDATA_Pos)      /*!< 0x00000002 */
#define ADC_JDR3_JDATA_2                  (0x0004U << ADC_JDR3_JDATA_Pos)      /*!< 0x00000004 */
#define ADC_JDR3_JDATA_3                  (0x0008U << ADC_JDR3_JDATA_Pos)      /*!< 0x00000008 */
#define ADC_JDR3_JDATA_4                  (0x0010U << ADC_JDR3_JDATA_Pos)      /*!< 0x00000010 */
#define ADC_JDR3_JDATA_5                  (0x0020U << ADC_JDR3_JDATA_Pos)      /*!< 0x00000020 */
#define ADC_JDR3_JDATA_6                  (0x0040U << ADC_JDR3_JDATA_Pos)      /*!< 0x00000040 */
#define ADC_JDR3_JDATA_7                  (0x0080U << ADC_JDR3_JDATA_Pos)      /*!< 0x00000080 */
#define ADC_JDR3_JDATA_8                  (0x0100U << ADC_JDR3_JDATA_Pos)      /*!< 0x00000100 */
#define ADC_JDR3_JDATA_9                  (0x0200U << ADC_JDR3_JDATA_Pos)      /*!< 0x00000200 */
#define ADC_JDR3_JDATA_10                 (0x0400U << ADC_JDR3_JDATA_Pos)      /*!< 0x00000400 */
#define ADC_JDR3_JDATA_11                 (0x0800U << ADC_JDR3_JDATA_Pos)      /*!< 0x00000800 */
#define ADC_JDR3_JDATA_12                 (0x1000U << ADC_JDR3_JDATA_Pos)      /*!< 0x00001000 */
#define ADC_JDR3_JDATA_13                 (0x2000U << ADC_JDR3_JDATA_Pos)      /*!< 0x00002000 */
#define ADC_JDR3_JDATA_14                 (0x4000U << ADC_JDR3_JDATA_Pos)      /*!< 0x00004000 */
#define ADC_JDR3_JDATA_15                 (0x8000U << ADC_JDR3_JDATA_Pos)      /*!< 0x00008000 */
#define ADC_JDR3_JDATA_16                 (0x10000U << ADC_JDR3_JDATA_Pos)     /*!< 0x00010000 */
#define ADC_JDR3_JDATA_17                 (0x20000U << ADC_JDR3_JDATA_Pos)     /*!< 0x00020000 */
#define ADC_JDR3_JDATA_18                 (0x40000U << ADC_JDR3_JDATA_Pos)     /*!< 0x00040000 */
#define ADC_JDR3_JDATA_19                 (0x80000U << ADC_JDR3_JDATA_Pos)     /*!< 0x00080000 */
#define ADC_JDR3_JDATA_20                 (0x100000U << ADC_JDR3_JDATA_Pos)    /*!< 0x00100000 */
#define ADC_JDR3_JDATA_21                 (0x200000U << ADC_JDR3_JDATA_Pos)    /*!< 0x00200000 */
#define ADC_JDR3_JDATA_22                 (0x400000U << ADC_JDR3_JDATA_Pos)    /*!< 0x00400000 */
#define ADC_JDR3_JDATA_23                 (0x800000U << ADC_JDR3_JDATA_Pos)    /*!< 0x00800000 */
#define ADC_JDR3_JDATA_24                 (0x1000000U << ADC_JDR3_JDATA_Pos)   /*!< 0x01000000 */
#define ADC_JDR3_JDATA_25                 (0x2000000U << ADC_JDR3_JDATA_Pos)   /*!< 0x02000000 */
#define ADC_JDR3_JDATA_26                 (0x4000000U << ADC_JDR3_JDATA_Pos)   /*!< 0x04000000 */
#define ADC_JDR3_JDATA_27                 (0x8000000U << ADC_JDR3_JDATA_Pos)   /*!< 0x08000000 */
#define ADC_JDR3_JDATA_28                 (0x10000000U << ADC_JDR3_JDATA_Pos)  /*!< 0x10000000 */
#define ADC_JDR3_JDATA_29                 (0x20000000U << ADC_JDR3_JDATA_Pos)  /*!< 0x20000000 */
#define ADC_JDR3_JDATA_30                 (0x40000000U << ADC_JDR3_JDATA_Pos)  /*!< 0x40000000 */
#define ADC_JDR3_JDATA_31                 (0x80000000U << ADC_JDR3_JDATA_Pos)  /*!< 0x80000000 */

/********************  Bit definition for ADC_JDR4 register  ********************/
#define ADC_JDR4_JDATA_Pos                (0U)
#define ADC_JDR4_JDATA_Msk                (0xFFFFFFFFU << ADC_JDR4_JDATA_Pos)  /*!< 0xFFFFFFFF */
#define ADC_JDR4_JDATA                    ADC_JDR4_JDATA_Msk                   /*!< ADC Injected DATA */
#define ADC_JDR4_JDATA_0                  (0x0001U << ADC_JDR4_JDATA_Pos)      /*!< 0x00000001 */
#define ADC_JDR4_JDATA_1                  (0x0002U << ADC_JDR4_JDATA_Pos)      /*!< 0x00000002 */
#define ADC_JDR4_JDATA_2                  (0x0004U << ADC_JDR4_JDATA_Pos)      /*!< 0x00000004 */
#define ADC_JDR4_JDATA_3                  (0x0008U << ADC_JDR4_JDATA_Pos)      /*!< 0x00000008 */
#define ADC_JDR4_JDATA_4                  (0x0010U << ADC_JDR4_JDATA_Pos)      /*!< 0x00000010 */
#define ADC_JDR4_JDATA_5                  (0x0020U << ADC_JDR4_JDATA_Pos)      /*!< 0x00000020 */
#define ADC_JDR4_JDATA_6                  (0x0040U << ADC_JDR4_JDATA_Pos)      /*!< 0x00000040 */
#define ADC_JDR4_JDATA_7                  (0x0080U << ADC_JDR4_JDATA_Pos)      /*!< 0x00000080 */
#define ADC_JDR4_JDATA_8                  (0x0100U << ADC_JDR4_JDATA_Pos)      /*!< 0x00000100 */
#define ADC_JDR4_JDATA_9                  (0x0200U << ADC_JDR4_JDATA_Pos)      /*!< 0x00000200 */
#define ADC_JDR4_JDATA_10                 (0x0400U << ADC_JDR4_JDATA_Pos)      /*!< 0x00000400 */
#define ADC_JDR4_JDATA_11                 (0x0800U << ADC_JDR4_JDATA_Pos)      /*!< 0x00000800 */
#define ADC_JDR4_JDATA_12                 (0x1000U << ADC_JDR4_JDATA_Pos)      /*!< 0x00001000 */
#define ADC_JDR4_JDATA_13                 (0x2000U << ADC_JDR4_JDATA_Pos)      /*!< 0x00002000 */
#define ADC_JDR4_JDATA_14                 (0x4000U << ADC_JDR4_JDATA_Pos)      /*!< 0x00004000 */
#define ADC_JDR4_JDATA_15                 (0x8000U << ADC_JDR4_JDATA_Pos)      /*!< 0x00008000 */
#define ADC_JDR4_JDATA_16                 (0x10000U << ADC_JDR4_JDATA_Pos)     /*!< 0x00010000 */
#define ADC_JDR4_JDATA_17                 (0x20000U << ADC_JDR4_JDATA_Pos)     /*!< 0x00020000 */
#define ADC_JDR4_JDATA_18                 (0x40000U << ADC_JDR4_JDATA_Pos)     /*!< 0x00040000 */
#define ADC_JDR4_JDATA_19                 (0x80000U << ADC_JDR4_JDATA_Pos)     /*!< 0x00080000 */
#define ADC_JDR4_JDATA_20                 (0x100000U << ADC_JDR4_JDATA_Pos)    /*!< 0x00100000 */
#define ADC_JDR4_JDATA_21                 (0x200000U << ADC_JDR4_JDATA_Pos)    /*!< 0x00200000 */
#define ADC_JDR4_JDATA_22                 (0x400000U << ADC_JDR4_JDATA_Pos)    /*!< 0x00400000 */
#define ADC_JDR4_JDATA_23                 (0x800000U << ADC_JDR4_JDATA_Pos)    /*!< 0x00800000 */
#define ADC_JDR4_JDATA_24                 (0x1000000U << ADC_JDR4_JDATA_Pos)   /*!< 0x01000000 */
#define ADC_JDR4_JDATA_25                 (0x2000000U << ADC_JDR4_JDATA_Pos)   /*!< 0x02000000 */
#define ADC_JDR4_JDATA_26                 (0x4000000U << ADC_JDR4_JDATA_Pos)   /*!< 0x04000000 */
#define ADC_JDR4_JDATA_27                 (0x8000000U << ADC_JDR4_JDATA_Pos)   /*!< 0x08000000 */
#define ADC_JDR4_JDATA_28                 (0x10000000U << ADC_JDR4_JDATA_Pos)  /*!< 0x10000000 */
#define ADC_JDR4_JDATA_29                 (0x20000000U << ADC_JDR4_JDATA_Pos)  /*!< 0x20000000 */
#define ADC_JDR4_JDATA_30                 (0x40000000U << ADC_JDR4_JDATA_Pos)  /*!< 0x40000000 */
#define ADC_JDR4_JDATA_31                 (0x80000000U << ADC_JDR4_JDATA_Pos)  /*!< 0x80000000 */

/********************  Bit definition for ADC_AWD2CR register  ********************/
#define ADC_AWD2CR_AWD2CH_Pos             (0U)
#define ADC_AWD2CR_AWD2CH_Msk             (0xFFFFFU << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x000FFFFF */
#define ADC_AWD2CR_AWD2CH                 ADC_AWD2CR_AWD2CH_Msk                /*!< ADC Analog watchdog 2 channel selection */
#define ADC_AWD2CR_AWD2CH_0               (0x00001U << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00000001 */
#define ADC_AWD2CR_AWD2CH_1               (0x00002U << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00000002 */
#define ADC_AWD2CR_AWD2CH_2               (0x00004U << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00000004 */
#define ADC_AWD2CR_AWD2CH_3               (0x00008U << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00000008 */
#define ADC_AWD2CR_AWD2CH_4               (0x00010U << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00000010 */
#define ADC_AWD2CR_AWD2CH_5               (0x00020U << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00000020 */
#define ADC_AWD2CR_AWD2CH_6               (0x00040U << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00000040 */
#define ADC_AWD2CR_AWD2CH_7               (0x00080U << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00000080 */
#define ADC_AWD2CR_AWD2CH_8               (0x00100U << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00000100 */
#define ADC_AWD2CR_AWD2CH_9               (0x00200U << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00000200 */
#define ADC_AWD2CR_AWD2CH_10              (0x00400U << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00000400 */
#define ADC_AWD2CR_AWD2CH_11              (0x00800U << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00000800 */
#define ADC_AWD2CR_AWD2CH_12              (0x01000U << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00001000 */
#define ADC_AWD2CR_AWD2CH_13              (0x02000U << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00002000 */
#define ADC_AWD2CR_AWD2CH_14              (0x04000U << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00004000 */
#define ADC_AWD2CR_AWD2CH_15              (0x08000U << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00008000 */
#define ADC_AWD2CR_AWD2CH_16              (0x10000U << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00010000 */
#define ADC_AWD2CR_AWD2CH_17              (0x20000U << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00020000 */
#define ADC_AWD2CR_AWD2CH_18              (0x40000U << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00040000 */
#define ADC_AWD2CR_AWD2CH_19              (0x80000U << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00080000 */

/********************  Bit definition for ADC_AWD3CR register  ********************/
#define ADC_AWD3CR_AWD3CH_Pos             (0U)
#define ADC_AWD3CR_AWD3CH_Msk             (0xFFFFFU << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x000FFFFF */
#define ADC_AWD3CR_AWD3CH                 ADC_AWD3CR_AWD3CH_Msk                /*!< ADC Analog watchdog 3 channel selection */
#define ADC_AWD3CR_AWD3CH_0               (0x00001U << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00000001 */
#define ADC_AWD3CR_AWD3CH_1               (0x00002U << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00000002 */
#define ADC_AWD3CR_AWD3CH_2               (0x00004U << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00000004 */
#define ADC_AWD3CR_AWD3CH_3               (0x00008U << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00000008 */
#define ADC_AWD3CR_AWD3CH_4               (0x00010U << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00000010 */
#define ADC_AWD3CR_AWD3CH_5               (0x00020U << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00000020 */
#define ADC_AWD3CR_AWD3CH_6               (0x00040U << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00000040 */
#define ADC_AWD3CR_AWD3CH_7               (0x00080U << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00000080 */
#define ADC_AWD3CR_AWD3CH_8               (0x00100U << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00000100 */
#define ADC_AWD3CR_AWD3CH_9               (0x00200U << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00000200 */
#define ADC_AWD3CR_AWD3CH_10              (0x00400U << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00000400 */
#define ADC_AWD3CR_AWD3CH_11              (0x00800U << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00000800 */
#define ADC_AWD3CR_AWD3CH_12              (0x01000U << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00001000 */
#define ADC_AWD3CR_AWD3CH_13              (0x02000U << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00002000 */
#define ADC_AWD3CR_AWD3CH_14              (0x04000U << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00004000 */
#define ADC_AWD3CR_AWD3CH_15              (0x08000U << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00008000 */
#define ADC_AWD3CR_AWD3CH_16              (0x10000U << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00010000 */
#define ADC_AWD3CR_AWD3CH_17              (0x20000U << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00020000 */
#define ADC_AWD3CR_AWD3CH_18              (0x40000U << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00040000 */
#define ADC_AWD3CR_AWD3CH_19              (0x80000U << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00080000 */

/********************  Bit definition for ADC_DIFSEL register  ********************/
#define ADC_DIFSEL_DIFSEL_Pos             (0U)
#define ADC_DIFSEL_DIFSEL_Msk             (0xFFFFFU << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x000FFFFF */
#define ADC_DIFSEL_DIFSEL                 ADC_DIFSEL_DIFSEL_Msk                /*!< ADC differential modes for channels 1 to 18 */
#define ADC_DIFSEL_DIFSEL_0               (0x00001U << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00000001 */
#define ADC_DIFSEL_DIFSEL_1               (0x00002U << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00000002 */
#define ADC_DIFSEL_DIFSEL_2               (0x00004U << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00000004 */
#define ADC_DIFSEL_DIFSEL_3               (0x00008U << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00000008 */
#define ADC_DIFSEL_DIFSEL_4               (0x00010U << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00000010 */
#define ADC_DIFSEL_DIFSEL_5               (0x00020U << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00000020 */
#define ADC_DIFSEL_DIFSEL_6               (0x00040U << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00000040 */
#define ADC_DIFSEL_DIFSEL_7               (0x00080U << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00000080 */
#define ADC_DIFSEL_DIFSEL_8               (0x00100U << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00000100 */
#define ADC_DIFSEL_DIFSEL_9               (0x00200U << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00000200 */
#define ADC_DIFSEL_DIFSEL_10              (0x00400U << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00000400 */
#define ADC_DIFSEL_DIFSEL_11              (0x00800U << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00000800 */
#define ADC_DIFSEL_DIFSEL_12              (0x01000U << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00001000 */
#define ADC_DIFSEL_DIFSEL_13              (0x02000U << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00002000 */
#define ADC_DIFSEL_DIFSEL_14              (0x04000U << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00004000 */
#define ADC_DIFSEL_DIFSEL_15              (0x08000U << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00008000 */
#define ADC_DIFSEL_DIFSEL_16              (0x10000U << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00010000 */
#define ADC_DIFSEL_DIFSEL_17              (0x20000U << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00020000 */
#define ADC_DIFSEL_DIFSEL_18              (0x40000U << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00040000 */
#define ADC_DIFSEL_DIFSEL_19              (0x80000U << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00080000 */

/********************  Bit definition for ADC_CALFACT register  ********************/
#define ADC_CALFACT_CALFACT_S_Pos         (0U)
#define ADC_CALFACT_CALFACT_S_Msk         (0x7FFU << ADC_CALFACT_CALFACT_S_Pos) /*!< 0x000007FF */
#define ADC_CALFACT_CALFACT_S             ADC_CALFACT_CALFACT_S_Msk            /*!< ADC calibration factors in single-ended mode */
#define ADC_CALFACT_CALFACT_S_0           (0x001U << ADC_CALFACT_CALFACT_S_Pos) /*!< 0x00000001 */
#define ADC_CALFACT_CALFACT_S_1           (0x002U << ADC_CALFACT_CALFACT_S_Pos) /*!< 0x00000002 */
#define ADC_CALFACT_CALFACT_S_2           (0x004U << ADC_CALFACT_CALFACT_S_Pos) /*!< 0x00000004 */
#define ADC_CALFACT_CALFACT_S_3           (0x008U << ADC_CALFACT_CALFACT_S_Pos) /*!< 0x00000008 */
#define ADC_CALFACT_CALFACT_S_4           (0x010U << ADC_CALFACT_CALFACT_S_Pos) /*!< 0x00000010 */
#define ADC_CALFACT_CALFACT_S_5           (0x020U << ADC_CALFACT_CALFACT_S_Pos) /*!< 0x00000020 */
#define ADC_CALFACT_CALFACT_S_6           (0x040U << ADC_CALFACT_CALFACT_S_Pos) /*!< 0x00000040 */
#define ADC_CALFACT_CALFACT_S_7           (0x080U << ADC_CALFACT_CALFACT_S_Pos) /*!< 0x00000080 */
#define ADC_CALFACT_CALFACT_S_8           (0x100U << ADC_CALFACT_CALFACT_S_Pos) /*!< 0x00000100 */
#define ADC_CALFACT_CALFACT_S_9           (0x200U << ADC_CALFACT_CALFACT_S_Pos) /*!< 0x00000200 */
#define ADC_CALFACT_CALFACT_S_10          (0x400U << ADC_CALFACT_CALFACT_S_Pos) /*!< 0x00000400 */
#define ADC_CALFACT_CALFACT_D_Pos         (16U)
#define ADC_CALFACT_CALFACT_D_Msk         (0x7FFU << ADC_CALFACT_CALFACT_D_Pos) /*!< 0x07FF0000 */
#define ADC_CALFACT_CALFACT_D             ADC_CALFACT_CALFACT_D_Msk            /*!< ADC calibration factors in differential mode */
#define ADC_CALFACT_CALFACT_D_0           (0x001U << ADC_CALFACT_CALFACT_D_Pos) /*!< 0x00010000 */
#define ADC_CALFACT_CALFACT_D_1           (0x002U << ADC_CALFACT_CALFACT_D_Pos) /*!< 0x00020000 */
#define ADC_CALFACT_CALFACT_D_2           (0x004U << ADC_CALFACT_CALFACT_D_Pos) /*!< 0x00040000 */
#define ADC_CALFACT_CALFACT_D_3           (0x008U << ADC_CALFACT_CALFACT_D_Pos) /*!< 0x00080000 */
#define ADC_CALFACT_CALFACT_D_4           (0x010U << ADC_CALFACT_CALFACT_D_Pos) /*!< 0x00100000 */
#define ADC_CALFACT_CALFACT_D_5           (0x020U << ADC_CALFACT_CALFACT_D_Pos) /*!< 0x00200000 */
#define ADC_CALFACT_CALFACT_D_6           (0x040U << ADC_CALFACT_CALFACT_D_Pos) /*!< 0x00400000 */
#define ADC_CALFACT_CALFACT_D_7           (0x080U << ADC_CALFACT_CALFACT_D_Pos) /*!< 0x00800000 */
#define ADC_CALFACT_CALFACT_D_8           (0x100U << ADC_CALFACT_CALFACT_D_Pos) /*!< 0x01000000 */
#define ADC_CALFACT_CALFACT_D_9           (0x200U << ADC_CALFACT_CALFACT_D_Pos) /*!< 0x02000000 */
#define ADC_CALFACT_CALFACT_D_10          (0x400U << ADC_CALFACT_CALFACT_D_Pos) /*!< 0x04000000 */

/********************  Bit definition for ADC_CALFACT2 register  ********************/
#define ADC_CALFACT2_LINCALFACT_Pos       (0U)
#define ADC_CALFACT2_LINCALFACT_Msk       (0x3FFFFFFFU << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x3FFFFFFF */
#define ADC_CALFACT2_LINCALFACT           ADC_CALFACT2_LINCALFACT_Msk          /*!< ADC Linearity calibration factors */
#define ADC_CALFACT2_LINCALFACT_0         (0x00000001U << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00000001 */
#define ADC_CALFACT2_LINCALFACT_1         (0x00000002U << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00000002 */
#define ADC_CALFACT2_LINCALFACT_2         (0x00000004U << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00000004 */
#define ADC_CALFACT2_LINCALFACT_3         (0x00000008U << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00000008 */
#define ADC_CALFACT2_LINCALFACT_4         (0x00000010U << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00000010 */
#define ADC_CALFACT2_LINCALFACT_5         (0x00000020U << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00000020 */
#define ADC_CALFACT2_LINCALFACT_6         (0x00000040U << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00000040 */
#define ADC_CALFACT2_LINCALFACT_7         (0x00000080U << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00000080 */
#define ADC_CALFACT2_LINCALFACT_8         (0x00000100U << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00000100 */
#define ADC_CALFACT2_LINCALFACT_9         (0x00000200U << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00000200 */
#define ADC_CALFACT2_LINCALFACT_10        (0x00000400U << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00000400 */
#define ADC_CALFACT2_LINCALFACT_11        (0x00000800U << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00000800 */
#define ADC_CALFACT2_LINCALFACT_12        (0x00001000U << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00001000 */
#define ADC_CALFACT2_LINCALFACT_13        (0x00002000U << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00002000 */
#define ADC_CALFACT2_LINCALFACT_14        (0x00004000U << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00004000 */
#define ADC_CALFACT2_LINCALFACT_15        (0x00008000U << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00008000 */
#define ADC_CALFACT2_LINCALFACT_16        (0x00010000U << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00010000 */
#define ADC_CALFACT2_LINCALFACT_17        (0x00020000U << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00020000 */
#define ADC_CALFACT2_LINCALFACT_18        (0x00040000U << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00040000 */
#define ADC_CALFACT2_LINCALFACT_19        (0x00080000U << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00080000 */
#define ADC_CALFACT2_LINCALFACT_20        (0x00100000U << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00100000 */
#define ADC_CALFACT2_LINCALFACT_21        (0x00200000U << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00200000 */
#define ADC_CALFACT2_LINCALFACT_22        (0x00400000U << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00400000 */
#define ADC_CALFACT2_LINCALFACT_23        (0x00800000U << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00800000 */
#define ADC_CALFACT2_LINCALFACT_24        (0x01000000U << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x01000000 */
#define ADC_CALFACT2_LINCALFACT_25        (0x02000000U << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x02000000 */
#define ADC_CALFACT2_LINCALFACT_26        (0x04000000U << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x04000000 */
#define ADC_CALFACT2_LINCALFACT_27        (0x08000001U << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x08000001 */
#define ADC_CALFACT2_LINCALFACT_28        (0x10000000U << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x10000000 */
#define ADC_CALFACT2_LINCALFACT_29        (0x20000000U << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x20000000 */

/********************  Bit definition for ADC2_OR - Option Register  ********************/
#define ADC2_OR_VDDCOREEN_Pos            (0U)
#define ADC2_OR_VDDCOREEN_Msk            (0x1U << ADC2_OR_VDDCOREEN_Pos) /*!< 0x00000001 */
#define ADC2_OR_VDDCOREEN                ADC2_OR_VDDCOREEN_Msk          /*!< ADC2 Option Register  - VDDCORE enable bit */

/*************************  ADC Common registers  *****************************/
/********************  Bit definition for ADC_CSR register  ********************/
#define ADC_CSR_ADRDY_MST_Pos          (0U)
#define ADC_CSR_ADRDY_MST_Msk          (0x1U << ADC_CSR_ADRDY_MST_Pos)   /*!< 0x00000001 */
#define ADC_CSR_ADRDY_MST              ADC_CSR_ADRDY_MST_Msk             /*!< Master ADC ready */
#define ADC_CSR_EOSMP_MST_Pos          (1U)
#define ADC_CSR_EOSMP_MST_Msk          (0x1U << ADC_CSR_EOSMP_MST_Pos) /*!< 0x00000002 */
#define ADC_CSR_EOSMP_MST              ADC_CSR_EOSMP_MST_Msk       /*!< End of sampling phase flag of the master ADC */
#define ADC_CSR_EOC_MST_Pos      (2U)
#define ADC_CSR_EOC_MST_Msk      (0x1U << ADC_CSR_EOC_MST_Pos) /*!< 0x00000004 */
#define ADC_CSR_EOC_MST          ADC_CSR_EOC_MST_Msk         /*!< End of regular conversion of the master ADC */
#define ADC_CSR_EOS_MST_Pos      (3U)
#define ADC_CSR_EOS_MST_Msk      (0x1U << ADC_CSR_EOS_MST_Pos) /*!< 0x00000008 */
#define ADC_CSR_EOS_MST          ADC_CSR_EOS_MST_Msk         /*!< End of regular sequence flag of the master ADC */
#define ADC_CSR_OVR_MST_Pos      (4U)
#define ADC_CSR_OVR_MST_Msk      (0x1U << ADC_CSR_OVR_MST_Pos) /*!< 0x00000010 */
#define ADC_CSR_OVR_MST          ADC_CSR_OVR_MST_Msk         /*!< Overrun flag of the master ADC */
#define ADC_CSR_JEOC_MST_Pos     (5U)
#define ADC_CSR_JEOC_MST_Msk     (0x1U << ADC_CSR_JEOC_MST_Pos) /*!< 0x00000020 */
#define ADC_CSR_JEOC_MST         ADC_CSR_JEOC_MST_Msk        /*!< End of injected conversion of the master ADC */
#define ADC_CSR_JEOS_MST_Pos     (6U)
#define ADC_CSR_JEOS_MST_Msk     (0x1U << ADC_CSR_JEOS_MST_Pos) /*!< 0x00000040 */
#define ADC_CSR_JEOS_MST         ADC_CSR_JEOS_MST_Msk        /*!< End of injected sequence flag of the master ADC */
#define ADC_CSR_AWD1_MST_Pos           (7U)
#define ADC_CSR_AWD1_MST_Msk           (0x1U << ADC_CSR_AWD1_MST_Pos)    /*!< 0x00000080 */
#define ADC_CSR_AWD1_MST               ADC_CSR_AWD1_MST_Msk              /*!< Analog watchdog 1 flag of the master ADC */
#define ADC_CSR_AWD2_MST_Pos           (8U)
#define ADC_CSR_AWD2_MST_Msk           (0x1U << ADC_CSR_AWD2_MST_Pos)    /*!< 0x00000100 */
#define ADC_CSR_AWD2_MST               ADC_CSR_AWD2_MST_Msk              /*!< Analog watchdog 2 flag of the master ADC */
#define ADC_CSR_AWD3_MST_Pos           (9U)
#define ADC_CSR_AWD3_MST_Msk           (0x1U << ADC_CSR_AWD3_MST_Pos)    /*!< 0x00000200 */
#define ADC_CSR_AWD3_MST               ADC_CSR_AWD3_MST_Msk              /*!< Analog watchdog 3 flag of the master ADC */
#define ADC_CSR_JQOVF_MST_Pos          (10U)
#define ADC_CSR_JQOVF_MST_Msk          (0x1U << ADC_CSR_JQOVF_MST_Pos)   /*!< 0x00000400 */
#define ADC_CSR_JQOVF_MST              ADC_CSR_JQOVF_MST_Msk             /*!< Injected context queue overflow flag of the master ADC */
#define ADC_CSR_ADRDY_SLV_Pos          (16U)
#define ADC_CSR_ADRDY_SLV_Msk          (0x1U << ADC_CSR_ADRDY_SLV_Pos)   /*!< 0x00010000 */
#define ADC_CSR_ADRDY_SLV              ADC_CSR_ADRDY_SLV_Msk             /*!< Slave ADC ready */
#define ADC_CSR_EOSMP_SLV_Pos    (17U)
#define ADC_CSR_EOSMP_SLV_Msk    (0x1U << ADC_CSR_EOSMP_SLV_Pos) /*!< 0x00020000 */
#define ADC_CSR_EOSMP_SLV        ADC_CSR_EOSMP_SLV_Msk       /*!< End of sampling phase flag of the slave ADC */
#define ADC_CSR_EOC_SLV_Pos      (18U)
#define ADC_CSR_EOC_SLV_Msk      (0x1U << ADC_CSR_EOC_SLV_Pos) /*!< 0x00040000 */
#define ADC_CSR_EOC_SLV          ADC_CSR_EOC_SLV_Msk         /*!< End of regular conversion of the slave ADC */
#define ADC_CSR_EOS_SLV_Pos      (19U)
#define ADC_CSR_EOS_SLV_Msk      (0x1U << ADC_CSR_EOS_SLV_Pos) /*!< 0x00080000 */
#define ADC_CSR_EOS_SLV          ADC_CSR_EOS_SLV_Msk         /*!< End of regular sequence flag of the slave ADC */
#define ADC_CSR_OVR_SLV_Pos      (20U)
#define ADC_CSR_OVR_SLV_Msk      (0x1U << ADC_CSR_OVR_SLV_Pos) /*!< 0x00100000 */
#define ADC_CSR_OVR_SLV          ADC_CSR_OVR_SLV_Msk         /*!< Overrun flag of the slave ADC */
#define ADC_CSR_JEOC_SLV_Pos     (21U)
#define ADC_CSR_JEOC_SLV_Msk     (0x1U << ADC_CSR_JEOC_SLV_Pos) /*!< 0x00200000 */
#define ADC_CSR_JEOC_SLV         ADC_CSR_JEOC_SLV_Msk        /*!< End of injected conversion of the slave ADC */
#define ADC_CSR_JEOS_SLV_Pos     (22U)
#define ADC_CSR_JEOS_SLV_Msk     (0x1U << ADC_CSR_JEOS_SLV_Pos) /*!< 0x00400000 */
#define ADC_CSR_JEOS_SLV         ADC_CSR_JEOS_SLV_Msk        /*!< End of injected sequence flag of the slave ADC */
#define ADC_CSR_AWD1_SLV_Pos           (23U)
#define ADC_CSR_AWD1_SLV_Msk           (0x1U << ADC_CSR_AWD1_SLV_Pos)    /*!< 0x00800000 */
#define ADC_CSR_AWD1_SLV               ADC_CSR_AWD1_SLV_Msk              /*!< Analog watchdog 1 flag of the slave ADC */
#define ADC_CSR_AWD2_SLV_Pos           (24U)
#define ADC_CSR_AWD2_SLV_Msk           (0x1U << ADC_CSR_AWD2_SLV_Pos)    /*!< 0x01000000 */
#define ADC_CSR_AWD2_SLV               ADC_CSR_AWD2_SLV_Msk              /*!< Analog watchdog 2 flag of the slave ADC */
#define ADC_CSR_AWD3_SLV_Pos           (25U)
#define ADC_CSR_AWD3_SLV_Msk           (0x1U << ADC_CSR_AWD3_SLV_Pos)    /*!< 0x02000000 */
#define ADC_CSR_AWD3_SLV               ADC_CSR_AWD3_SLV_Msk              /*!< Analog watchdog 3 flag of the slave ADC */
#define ADC_CSR_JQOVF_SLV_Pos          (26U)
#define ADC_CSR_JQOVF_SLV_Msk          (0x1U << ADC_CSR_JQOVF_SLV_Pos)   /*!< 0x04000000 */
#define ADC_CSR_JQOVF_SLV              ADC_CSR_JQOVF_SLV_Msk             /*!< Injected context queue overflow flag of the slave ADC */

/********************  Bit definition for ADC_CCR register  ********************/
#define ADC_CCR_DUAL_Pos                  (0U)
#define ADC_CCR_DUAL_Msk                  (0x1FU << ADC_CCR_DUAL_Pos)          /*!< 0x0000001F */
#define ADC_CCR_DUAL                      ADC_CCR_DUAL_Msk                     /*!< Dual ADC mode selection */
#define ADC_CCR_DUAL_0                    (0x01U << ADC_CCR_DUAL_Pos)          /*!< 0x00000001 */
#define ADC_CCR_DUAL_1                    (0x02U << ADC_CCR_DUAL_Pos)          /*!< 0x00000002 */
#define ADC_CCR_DUAL_2                    (0x04U << ADC_CCR_DUAL_Pos)          /*!< 0x00000004 */
#define ADC_CCR_DUAL_3                    (0x08U << ADC_CCR_DUAL_Pos)          /*!< 0x00000008 */
#define ADC_CCR_DUAL_4                    (0x10U << ADC_CCR_DUAL_Pos)          /*!< 0x00000010 */

#define ADC_CCR_DELAY_Pos                 (8U)
#define ADC_CCR_DELAY_Msk                 (0xFU << ADC_CCR_DELAY_Pos)          /*!< 0x00000F00 */
#define ADC_CCR_DELAY                     ADC_CCR_DELAY_Msk                    /*!< Delay between 2 sampling phases */
#define ADC_CCR_DELAY_0                   (0x1U << ADC_CCR_DELAY_Pos)          /*!< 0x00000100 */
#define ADC_CCR_DELAY_1                   (0x2U << ADC_CCR_DELAY_Pos)          /*!< 0x00000200 */
#define ADC_CCR_DELAY_2                   (0x4U << ADC_CCR_DELAY_Pos)          /*!< 0x00000400 */
#define ADC_CCR_DELAY_3                   (0x8U << ADC_CCR_DELAY_Pos)          /*!< 0x00000800 */

#define ADC_CCR_DAMDF_Pos                 (14U)
#define ADC_CCR_DAMDF_Msk                 (0x3U << ADC_CCR_DAMDF_Pos)          /*!< 0x0000C000 */
#define ADC_CCR_DAMDF                     ADC_CCR_DAMDF_Msk                    /*!< Dual ADC mode Data format */
#define ADC_CCR_DAMDF_0                   (0x1U << ADC_CCR_DAMDF_Pos)          /*!< 0x00004000 */
#define ADC_CCR_DAMDF_1                   (0x2U << ADC_CCR_DAMDF_Pos)          /*!< 0x00008000 */

#define ADC_CCR_CKMODE_Pos                (16U)
#define ADC_CCR_CKMODE_Msk                (0x3U << ADC_CCR_CKMODE_Pos)         /*!< 0x00030000 */
#define ADC_CCR_CKMODE                    ADC_CCR_CKMODE_Msk                   /*!< ADC clock mode */
#define ADC_CCR_CKMODE_0                  (0x1U << ADC_CCR_CKMODE_Pos)         /*!< 0x00010000 */
#define ADC_CCR_CKMODE_1                  (0x2U << ADC_CCR_CKMODE_Pos)         /*!< 0x00020000 */

#define ADC_CCR_PRESC_Pos                 (18U)
#define ADC_CCR_PRESC_Msk                 (0xFU << ADC_CCR_PRESC_Pos)          /*!< 0x003C0000 */
#define ADC_CCR_PRESC                     ADC_CCR_PRESC_Msk                    /*!< ADC prescaler */
#define ADC_CCR_PRESC_0                   (0x1U << ADC_CCR_PRESC_Pos)          /*!< 0x00040000 */
#define ADC_CCR_PRESC_1                   (0x2U << ADC_CCR_PRESC_Pos)          /*!< 0x00080000 */
#define ADC_CCR_PRESC_2                   (0x4U << ADC_CCR_PRESC_Pos)          /*!< 0x00100000 */
#define ADC_CCR_PRESC_3                   (0x8U << ADC_CCR_PRESC_Pos)          /*!< 0x00200000 */

#define ADC_CCR_VREFEN_Pos                (22U)
#define ADC_CCR_VREFEN_Msk                (0x1U << ADC_CCR_VREFEN_Pos)         /*!< 0x00400000 */
#define ADC_CCR_VREFEN                    ADC_CCR_VREFEN_Msk                   /*!< VREFINT enable */
#define ADC_CCR_VSENSEEN_Pos              (23U)
#define ADC_CCR_VSENSEEN_Msk              (0x1U << ADC_CCR_VSENSEEN_Pos)      /*!< 0x00800000 */
#define ADC_CCR_VSENSEEN                  ADC_CCR_VSENSEEN_Msk                /*!< Temperature sensor enable */
#define ADC_CCR_VBATEN_Pos                (24U)
#define ADC_CCR_VBATEN_Msk                (0x1U << ADC_CCR_VBATEN_Pos)         /*!< 0x01000000 */
#define ADC_CCR_VBATEN                    ADC_CCR_VBATEN_Msk                   /*!< VBAT enable */

/********************  Bit definition for ADC_CDR register  ********************/
#define ADC_CDR_RDATA_MST_Pos          (0U)
#define ADC_CDR_RDATA_MST_Msk          (0xFFFFU << ADC_CDR_RDATA_MST_Pos) /*!< 0x0000FFFF */
#define ADC_CDR_RDATA_MST              ADC_CDR_RDATA_MST_Msk             /*!< Regular Data of the master ADC */
#define ADC_CDR_RDATA_MST_0            (0x0001U << ADC_CDR_RDATA_MST_Pos) /*!< 0x00000001 */
#define ADC_CDR_RDATA_MST_1            (0x0002U << ADC_CDR_RDATA_MST_Pos) /*!< 0x00000002 */
#define ADC_CDR_RDATA_MST_2            (0x0004U << ADC_CDR_RDATA_MST_Pos) /*!< 0x00000004 */
#define ADC_CDR_RDATA_MST_3            (0x0008U << ADC_CDR_RDATA_MST_Pos) /*!< 0x00000008 */
#define ADC_CDR_RDATA_MST_4            (0x0010U << ADC_CDR_RDATA_MST_Pos) /*!< 0x00000010 */
#define ADC_CDR_RDATA_MST_5            (0x0020U << ADC_CDR_RDATA_MST_Pos) /*!< 0x00000020 */
#define ADC_CDR_RDATA_MST_6            (0x0040U << ADC_CDR_RDATA_MST_Pos) /*!< 0x00000040 */
#define ADC_CDR_RDATA_MST_7            (0x0080U << ADC_CDR_RDATA_MST_Pos) /*!< 0x00000080 */
#define ADC_CDR_RDATA_MST_8            (0x0100U << ADC_CDR_RDATA_MST_Pos) /*!< 0x00000100 */
#define ADC_CDR_RDATA_MST_9            (0x0200U << ADC_CDR_RDATA_MST_Pos) /*!< 0x00000200 */
#define ADC_CDR_RDATA_MST_10           (0x0400U << ADC_CDR_RDATA_MST_Pos) /*!< 0x00000400 */
#define ADC_CDR_RDATA_MST_11           (0x0800U << ADC_CDR_RDATA_MST_Pos) /*!< 0x00000800 */
#define ADC_CDR_RDATA_MST_12           (0x1000U << ADC_CDR_RDATA_MST_Pos) /*!< 0x00001000 */
#define ADC_CDR_RDATA_MST_13           (0x2000U << ADC_CDR_RDATA_MST_Pos) /*!< 0x00002000 */
#define ADC_CDR_RDATA_MST_14           (0x4000U << ADC_CDR_RDATA_MST_Pos) /*!< 0x00004000 */
#define ADC_CDR_RDATA_MST_15           (0x8000U << ADC_CDR_RDATA_MST_Pos) /*!< 0x00008000 */

#define ADC_CDR_RDATA_SLV_Pos          (16U)
#define ADC_CDR_RDATA_SLV_Msk          (0xFFFFU << ADC_CDR_RDATA_SLV_Pos) /*!< 0xFFFF0000 */
#define ADC_CDR_RDATA_SLV              ADC_CDR_RDATA_SLV_Msk             /*!< Regular Data of the master ADC */
#define ADC_CDR_RDATA_SLV_0            (0x0001U << ADC_CDR_RDATA_SLV_Pos) /*!< 0x00010000 */
#define ADC_CDR_RDATA_SLV_1            (0x0002U << ADC_CDR_RDATA_SLV_Pos) /*!< 0x00020000 */
#define ADC_CDR_RDATA_SLV_2            (0x0004U << ADC_CDR_RDATA_SLV_Pos) /*!< 0x00040000 */
#define ADC_CDR_RDATA_SLV_3            (0x0008U << ADC_CDR_RDATA_SLV_Pos) /*!< 0x00080000 */
#define ADC_CDR_RDATA_SLV_4            (0x0010U << ADC_CDR_RDATA_SLV_Pos) /*!< 0x00100000 */
#define ADC_CDR_RDATA_SLV_5            (0x0020U << ADC_CDR_RDATA_SLV_Pos) /*!< 0x00200000 */
#define ADC_CDR_RDATA_SLV_6            (0x0040U << ADC_CDR_RDATA_SLV_Pos) /*!< 0x00400000 */
#define ADC_CDR_RDATA_SLV_7            (0x0080U << ADC_CDR_RDATA_SLV_Pos) /*!< 0x00800000 */
#define ADC_CDR_RDATA_SLV_8            (0x0100U << ADC_CDR_RDATA_SLV_Pos) /*!< 0x01000000 */
#define ADC_CDR_RDATA_SLV_9            (0x0200U << ADC_CDR_RDATA_SLV_Pos) /*!< 0x02000000 */
#define ADC_CDR_RDATA_SLV_10           (0x0400U << ADC_CDR_RDATA_SLV_Pos) /*!< 0x04000000 */
#define ADC_CDR_RDATA_SLV_11           (0x0800U << ADC_CDR_RDATA_SLV_Pos) /*!< 0x08000000 */
#define ADC_CDR_RDATA_SLV_12           (0x1000U << ADC_CDR_RDATA_SLV_Pos) /*!< 0x10000000 */
#define ADC_CDR_RDATA_SLV_13           (0x2000U << ADC_CDR_RDATA_SLV_Pos) /*!< 0x20000000 */
#define ADC_CDR_RDATA_SLV_14           (0x4000U << ADC_CDR_RDATA_SLV_Pos) /*!< 0x40000000 */
#define ADC_CDR_RDATA_SLV_15           (0x8000U << ADC_CDR_RDATA_SLV_Pos) /*!< 0x80000000 */

/********************  Bit definition for ADC_CDR2 register  ********************/
#define ADC_CDR2_RDATA_ALT_Pos         (0U)
#define ADC_CDR2_RDATA_ALT_Msk         (0xFFFFFFFFU << ADC_CDR2_RDATA_ALT_Pos) /*!< 0xFFFFFFFF */
#define ADC_CDR2_RDATA_ALT             ADC_CDR2_RDATA_ALT_Msk            /*!< Regular Data for dual Mode */
#define ADC_CDR2_RDATA_ALT_0           (0x00000001U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x00000001 */
#define ADC_CDR2_RDATA_ALT_1           (0x00000002U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x00000002 */
#define ADC_CDR2_RDATA_ALT_2           (0x00000004U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x00000004 */
#define ADC_CDR2_RDATA_ALT_3           (0x00000008U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x00000008 */
#define ADC_CDR2_RDATA_ALT_4           (0x00000010U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x00000010 */
#define ADC_CDR2_RDATA_ALT_5           (0x00000020U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x00000020 */
#define ADC_CDR2_RDATA_ALT_6           (0x00000040U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x00000040 */
#define ADC_CDR2_RDATA_ALT_7           (0x00000080U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x00000080 */
#define ADC_CDR2_RDATA_ALT_8           (0x00000100U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x00000100 */
#define ADC_CDR2_RDATA_ALT_9           (0x00000200U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x00000200 */
#define ADC_CDR2_RDATA_ALT_10          (0x00000400U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x00000400 */
#define ADC_CDR2_RDATA_ALT_11          (0x00000800U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x00000800 */
#define ADC_CDR2_RDATA_ALT_12          (0x00001000U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x00001000 */
#define ADC_CDR2_RDATA_ALT_13          (0x00002000U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x00002000 */
#define ADC_CDR2_RDATA_ALT_14          (0x00004000U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x00004000 */
#define ADC_CDR2_RDATA_ALT_15          (0x00008000U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x00008000 */
#define ADC_CDR2_RDATA_ALT_16          (0x00010000U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x00010000 */
#define ADC_CDR2_RDATA_ALT_17          (0x00020000U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x00020000 */
#define ADC_CDR2_RDATA_ALT_18          (0x00040000U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x00040000 */
#define ADC_CDR2_RDATA_ALT_19          (0x00080000U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x00080000 */
#define ADC_CDR2_RDATA_ALT_20          (0x00100000U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x00100000 */
#define ADC_CDR2_RDATA_ALT_21          (0x00200000U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x00200000 */
#define ADC_CDR2_RDATA_ALT_22          (0x00400000U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x00400000 */
#define ADC_CDR2_RDATA_ALT_23          (0x00800000U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x00800000 */
#define ADC_CDR2_RDATA_ALT_24          (0x01000000U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x01000000 */
#define ADC_CDR2_RDATA_ALT_25          (0x02000000U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x02000000 */
#define ADC_CDR2_RDATA_ALT_26          (0x04000000U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x04000000 */
#define ADC_CDR2_RDATA_ALT_27          (0x08000000U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x08000000 */
#define ADC_CDR2_RDATA_ALT_28          (0x10000000U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x10000000 */
#define ADC_CDR2_RDATA_ALT_29          (0x20000000U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x20000000 */
#define ADC_CDR2_RDATA_ALT_30          (0x40000000U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x40000000 */
#define ADC_CDR2_RDATA_ALT_31          (0x80000000U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x80000000 */


/*****************  Bit definition for ADC_VERR register  ******************/
#define ADC_VERR_MINREV_Pos               (0U)
#define ADC_VERR_MINREV_Msk               (0xFU << ADC_VERR_MINREV_Pos)        /*!< 0x0000000F */
#define ADC_VERR_MINREV                   ADC_VERR_MINREV_Msk                  /*!< Minor revision */
#define ADC_VERR_MINREV_0                 (0x1U << ADC_VERR_MINREV_Pos)        /*!< 0x00000001 */
#define ADC_VERR_MINREV_1                 (0x2U << ADC_VERR_MINREV_Pos)        /*!< 0x00000002 */
#define ADC_VERR_MINREV_2                 (0x4U << ADC_VERR_MINREV_Pos)        /*!< 0x00000004 */
#define ADC_VERR_MINREV_3                 (0x8U << ADC_VERR_MINREV_Pos)        /*!< 0x00000008 */
#define ADC_VERR_MAJREV_Pos               (4U)
#define ADC_VERR_MAJREV_Msk               (0xFU << ADC_VERR_MAJREV_Pos)        /*!< 0x000000F0 */
#define ADC_VERR_MAJREV                   ADC_VERR_MAJREV_Msk                  /*!< Major revision */
#define ADC_VERR_MAJREV_0                 (0x1U << ADC_VERR_MAJREV_Pos)        /*!< 0x00000010 */
#define ADC_VERR_MAJREV_1                 (0x2U << ADC_VERR_MAJREV_Pos)        /*!< 0x00000020 */
#define ADC_VERR_MAJREV_2                 (0x4U << ADC_VERR_MAJREV_Pos)        /*!< 0x00000040 */
#define ADC_VERR_MAJREV_3                 (0x8U << ADC_VERR_MAJREV_Pos)        /*!< 0x00000080 */

/*****************  Bit definition for ADC_IPDR register  ******************/
#define ADC_IPDR_ID_Pos                   (0U)
#define ADC_IPDR_ID_Msk                   (0xFFFFFFFFU << ADC_IPDR_ID_Pos)     /*!< 0xFFFFFFFF */
#define ADC_IPDR_ID                       ADC_IPDR_ID_Msk                      /*!< Peripheral identifier */
#define ADC_IPDR_ID_0                     (0x1U << ADC_IPDR_ID_Pos)            /*!< 0x00000001 */
#define ADC_IPDR_ID_1                     (0x2U << ADC_IPDR_ID_Pos)            /*!< 0x00000002 */
#define ADC_IPDR_ID_2                     (0x4U << ADC_IPDR_ID_Pos)            /*!< 0x00000004 */
#define ADC_IPDR_ID_3                     (0x8U << ADC_IPDR_ID_Pos)            /*!< 0x00000008 */
#define ADC_IPDR_ID_4                     (0x10U << ADC_IPDR_ID_Pos)           /*!< 0x00000010 */
#define ADC_IPDR_ID_5                     (0x20U << ADC_IPDR_ID_Pos)           /*!< 0x00000020 */
#define ADC_IPDR_ID_6                     (0x40U << ADC_IPDR_ID_Pos)           /*!< 0x00000040 */
#define ADC_IPDR_ID_7                     (0x80U << ADC_IPDR_ID_Pos)           /*!< 0x00000080 */
#define ADC_IPDR_ID_8                     (0x100U << ADC_IPDR_ID_Pos)          /*!< 0x00000100 */
#define ADC_IPDR_ID_9                     (0x200U << ADC_IPDR_ID_Pos)          /*!< 0x00000200 */
#define ADC_IPDR_ID_10                    (0x400U << ADC_IPDR_ID_Pos)          /*!< 0x00000400 */
#define ADC_IPDR_ID_11                    (0x800U << ADC_IPDR_ID_Pos)          /*!< 0x00000800 */
#define ADC_IPDR_ID_12                    (0x1000U << ADC_IPDR_ID_Pos)         /*!< 0x00001000 */
#define ADC_IPDR_ID_13                    (0x2000U << ADC_IPDR_ID_Pos)         /*!< 0x00002000 */
#define ADC_IPDR_ID_14                    (0x4000U << ADC_IPDR_ID_Pos)         /*!< 0x00004000 */
#define ADC_IPDR_ID_15                    (0x8000U << ADC_IPDR_ID_Pos)         /*!< 0x00008000 */
#define ADC_IPDR_ID_16                    (0x10000U << ADC_IPDR_ID_Pos)        /*!< 0x00010000 */
#define ADC_IPDR_ID_17                    (0x20000U << ADC_IPDR_ID_Pos)        /*!< 0x00020000 */
#define ADC_IPDR_ID_18                    (0x40000U << ADC_IPDR_ID_Pos)        /*!< 0x00040000 */
#define ADC_IPDR_ID_19                    (0x80000U << ADC_IPDR_ID_Pos)        /*!< 0x00080000 */
#define ADC_IPDR_ID_20                    (0x100000U << ADC_IPDR_ID_Pos)       /*!< 0x00100000 */
#define ADC_IPDR_ID_21                    (0x200000U << ADC_IPDR_ID_Pos)       /*!< 0x00200000 */
#define ADC_IPDR_ID_22                    (0x400000U << ADC_IPDR_ID_Pos)       /*!< 0x00400000 */
#define ADC_IPDR_ID_23                    (0x800000U << ADC_IPDR_ID_Pos)       /*!< 0x00800000 */
#define ADC_IPDR_ID_24                    (0x1000000U << ADC_IPDR_ID_Pos)      /*!< 0x01000000 */
#define ADC_IPDR_ID_25                    (0x2000000U << ADC_IPDR_ID_Pos)      /*!< 0x02000000 */
#define ADC_IPDR_ID_26                    (0x4000000U << ADC_IPDR_ID_Pos)      /*!< 0x04000000 */
#define ADC_IPDR_ID_27                    (0x8000000U << ADC_IPDR_ID_Pos)      /*!< 0x08000000 */
#define ADC_IPDR_ID_28                    (0x10000000U << ADC_IPDR_ID_Pos)     /*!< 0x10000000 */
#define ADC_IPDR_ID_29                    (0x20000000U << ADC_IPDR_ID_Pos)     /*!< 0x20000000 */
#define ADC_IPDR_ID_30                    (0x40000000U << ADC_IPDR_ID_Pos)     /*!< 0x40000000 */
#define ADC_IPDR_ID_31                    (0x80000000U << ADC_IPDR_ID_Pos)     /*!< 0x80000000 */

/*****************  Bit definition for ADC_SIDR register  ******************/
#define ADC_SIDR_SID_Pos                  (0U)
#define ADC_SIDR_SID_Msk                  (0xFFFFFFFFU << ADC_SIDR_SID_Pos)    /*!< 0xFFFFFFFF */
#define ADC_SIDR_SID                      ADC_SIDR_SID_Msk                     /*!< Size Identification */
#define ADC_SIDR_SID_0                    (0x1U << ADC_SIDR_SID_Pos)           /*!< 0x00000001 */
#define ADC_SIDR_SID_1                    (0x2U << ADC_SIDR_SID_Pos)           /*!< 0x00000002 */
#define ADC_SIDR_SID_2                    (0x4U << ADC_SIDR_SID_Pos)           /*!< 0x00000004 */
#define ADC_SIDR_SID_3                    (0x8U << ADC_SIDR_SID_Pos)           /*!< 0x00000008 */
#define ADC_SIDR_SID_4                    (0x10U << ADC_SIDR_SID_Pos)          /*!< 0x00000010 */
#define ADC_SIDR_SID_5                    (0x20U << ADC_SIDR_SID_Pos)          /*!< 0x00000020 */
#define ADC_SIDR_SID_6                    (0x40U << ADC_SIDR_SID_Pos)          /*!< 0x00000040 */
#define ADC_SIDR_SID_7                    (0x80U << ADC_SIDR_SID_Pos)          /*!< 0x00000080 */
#define ADC_SIDR_SID_8                    (0x100U << ADC_SIDR_SID_Pos)         /*!< 0x00000100 */
#define ADC_SIDR_SID_9                    (0x200U << ADC_SIDR_SID_Pos)         /*!< 0x00000200 */
#define ADC_SIDR_SID_10                   (0x400U << ADC_SIDR_SID_Pos)         /*!< 0x00000400 */
#define ADC_SIDR_SID_11                   (0x800U << ADC_SIDR_SID_Pos)         /*!< 0x00000800 */
#define ADC_SIDR_SID_12                   (0x1000U << ADC_SIDR_SID_Pos)        /*!< 0x00001000 */
#define ADC_SIDR_SID_13                   (0x2000U << ADC_SIDR_SID_Pos)        /*!< 0x00002000 */
#define ADC_SIDR_SID_14                   (0x4000U << ADC_SIDR_SID_Pos)        /*!< 0x00004000 */
#define ADC_SIDR_SID_15                   (0x8000U << ADC_SIDR_SID_Pos)        /*!< 0x00008000 */
#define ADC_SIDR_SID_16                   (0x10000U << ADC_SIDR_SID_Pos)       /*!< 0x00010000 */
#define ADC_SIDR_SID_17                   (0x20000U << ADC_SIDR_SID_Pos)       /*!< 0x00020000 */
#define ADC_SIDR_SID_18                   (0x40000U << ADC_SIDR_SID_Pos)       /*!< 0x00040000 */
#define ADC_SIDR_SID_19                   (0x80000U << ADC_SIDR_SID_Pos)       /*!< 0x00080000 */
#define ADC_SIDR_SID_20                   (0x100000U << ADC_SIDR_SID_Pos)      /*!< 0x00100000 */
#define ADC_SIDR_SID_21                   (0x200000U << ADC_SIDR_SID_Pos)      /*!< 0x00200000 */
#define ADC_SIDR_SID_22                   (0x400000U << ADC_SIDR_SID_Pos)      /*!< 0x00400000 */
#define ADC_SIDR_SID_23                   (0x800000U << ADC_SIDR_SID_Pos)      /*!< 0x00800000 */
#define ADC_SIDR_SID_24                   (0x1000000U << ADC_SIDR_SID_Pos)     /*!< 0x01000000 */
#define ADC_SIDR_SID_25                   (0x2000000U << ADC_SIDR_SID_Pos)     /*!< 0x02000000 */
#define ADC_SIDR_SID_26                   (0x4000000U << ADC_SIDR_SID_Pos)     /*!< 0x04000000 */
#define ADC_SIDR_SID_27                   (0x8000000U << ADC_SIDR_SID_Pos)     /*!< 0x08000000 */
#define ADC_SIDR_SID_28                   (0x10000000U << ADC_SIDR_SID_Pos)    /*!< 0x10000000 */
#define ADC_SIDR_SID_29                   (0x20000000U << ADC_SIDR_SID_Pos)    /*!< 0x20000000 */
#define ADC_SIDR_SID_30                   (0x40000000U << ADC_SIDR_SID_Pos)    /*!< 0x40000000 */
#define ADC_SIDR_SID_31                   (0x80000000U << ADC_SIDR_SID_Pos)    /*!< 0x80000000 */

/******************************************************************************/
/*                                                                            */
/*                                   VREFBUF                                  */
/*                                                                            */
/******************************************************************************/
/*******************  Bit definition for VREFBUF_CSR register  ****************/
#define VREFBUF_CSR_ENVR_Pos        (0U)
#define VREFBUF_CSR_ENVR_Msk        (0x1U << VREFBUF_CSR_ENVR_Pos)             /*!< 0x00000001 */
#define VREFBUF_CSR_ENVR            VREFBUF_CSR_ENVR_Msk                       /*!<Voltage reference buffer enable */
#define VREFBUF_CSR_HIZ_Pos         (1U)
#define VREFBUF_CSR_HIZ_Msk         (0x1U << VREFBUF_CSR_HIZ_Pos)              /*!< 0x00000002 */
#define VREFBUF_CSR_HIZ             VREFBUF_CSR_HIZ_Msk                        /*!<High impedance mode             */
#define VREFBUF_CSR_VRR_Pos         (3U)
#define VREFBUF_CSR_VRR_Msk         (0x1U << VREFBUF_CSR_VRR_Pos)              /*!< 0x00000008 */
#define VREFBUF_CSR_VRR             VREFBUF_CSR_VRR_Msk                        /*!<Voltage reference buffer ready  */
#define VREFBUF_CSR_VRS_Pos         (4U)
#define VREFBUF_CSR_VRS_Msk         (0x7U << VREFBUF_CSR_VRS_Pos)              /*!< 0x00000070 */
#define VREFBUF_CSR_VRS             VREFBUF_CSR_VRS_Msk                        /*!<Voltage reference scale         */

#define VREFBUF_CSR_VRS_OUT1        ((uint32_t)0x00000000)                     /*!<Voltage reference VREF_OUT1     */
#define VREFBUF_CSR_VRS_OUT2_Pos    (4U)
#define VREFBUF_CSR_VRS_OUT2_Msk    (0x1U << VREFBUF_CSR_VRS_OUT2_Pos)         /*!< 0x00000010 */
#define VREFBUF_CSR_VRS_OUT2        VREFBUF_CSR_VRS_OUT2_Msk                   /*!<Voltage reference VREF_OUT2     */
#define VREFBUF_CSR_VRS_OUT3_Pos    (5U)
#define VREFBUF_CSR_VRS_OUT3_Msk    (0x1U << VREFBUF_CSR_VRS_OUT3_Pos)         /*!< 0x00000020 */
#define VREFBUF_CSR_VRS_OUT3        VREFBUF_CSR_VRS_OUT3_Msk                   /*!<Voltage reference VREF_OUT3     */
#define VREFBUF_CSR_VRS_OUT4_Pos    (4U)
#define VREFBUF_CSR_VRS_OUT4_Msk    (0x3U << VREFBUF_CSR_VRS_OUT4_Pos)         /*!< 0x00000030 */
#define VREFBUF_CSR_VRS_OUT4        VREFBUF_CSR_VRS_OUT4_Msk                   /*!<Voltage reference VREF_OUT4     */

/*******************  Bit definition for VREFBUF_CCR register  ****************/
#define VREFBUF_CCR_TRIM_Pos        (0U)
#define VREFBUF_CCR_TRIM_Msk        (0x3FU << VREFBUF_CCR_TRIM_Pos)            /*!< 0x0000003F */
#define VREFBUF_CCR_TRIM            VREFBUF_CCR_TRIM_Msk                       /*!<TRIM[5:0] bits (Trimming code)  */

/******************************************************************************/
/*                                                                            */
/*                 Flexible Datarate Controller Area Network                  */
/*                                                                            */
/******************************************************************************/
/*!<FDCAN control and status registers */
/*****************  Bit definition for FDCAN_CREL register  *******************/
#define FDCAN_CREL_DAY_Pos        (0U)
#define FDCAN_CREL_DAY_Msk        (0xFFU << FDCAN_CREL_DAY_Pos)                /*!< 0x000000FF */
#define FDCAN_CREL_DAY            FDCAN_CREL_DAY_Msk                           /*!<Timestamp Day                           */
#define FDCAN_CREL_MON_Pos        (8U)
#define FDCAN_CREL_MON_Msk        (0xFFU << FDCAN_CREL_MON_Pos)                /*!< 0x0000FF00 */
#define FDCAN_CREL_MON            FDCAN_CREL_MON_Msk                           /*!<Timestamp Month                         */
#define FDCAN_CREL_YEAR_Pos       (16U)
#define FDCAN_CREL_YEAR_Msk       (0xFU << FDCAN_CREL_YEAR_Pos)                /*!< 0x000F0000 */
#define FDCAN_CREL_YEAR           FDCAN_CREL_YEAR_Msk                          /*!<Timestamp Year                          */
#define FDCAN_CREL_SUBSTEP_Pos    (20U)
#define FDCAN_CREL_SUBSTEP_Msk    (0xFU << FDCAN_CREL_SUBSTEP_Pos)             /*!< 0x00F00000 */
#define FDCAN_CREL_SUBSTEP        FDCAN_CREL_SUBSTEP_Msk                       /*!<Sub-step of Core release                */
#define FDCAN_CREL_STEP_Pos       (24U)
#define FDCAN_CREL_STEP_Msk       (0xFU << FDCAN_CREL_STEP_Pos)                /*!< 0x0F000000 */
#define FDCAN_CREL_STEP           FDCAN_CREL_STEP_Msk                          /*!<Step of Core release                    */
#define FDCAN_CREL_REL_Pos        (28U)
#define FDCAN_CREL_REL_Msk        (0xFU << FDCAN_CREL_REL_Pos)                 /*!< 0xF0000000 */
#define FDCAN_CREL_REL            FDCAN_CREL_REL_Msk                           /*!<Core release                            */

/*****************  Bit definition for FDCAN_ENDN register  *******************/
#define FDCAN_ENDN_ETV_Pos        (0U)
#define FDCAN_ENDN_ETV_Msk        (0xFFFFFFFFU << FDCAN_ENDN_ETV_Pos)          /*!< 0xFFFFFFFF */
#define FDCAN_ENDN_ETV            FDCAN_ENDN_ETV_Msk                           /*!<TEndiannes Test Value                   */

/*****************  Bit definition for FDCAN_DBTP register  *******************/
#define FDCAN_DBTP_DSJW_Pos       (0U)
#define FDCAN_DBTP_DSJW_Msk       (0xFU << FDCAN_DBTP_DSJW_Pos)                /*!< 0x0000000F */
#define FDCAN_DBTP_DSJW           FDCAN_DBTP_DSJW_Msk                          /*!<Synchronization Jump Width              */
#define FDCAN_DBTP_DTSEG2_Pos     (4U)
#define FDCAN_DBTP_DTSEG2_Msk     (0xFU << FDCAN_DBTP_DTSEG2_Pos)              /*!< 0x000000F0 */
#define FDCAN_DBTP_DTSEG2         FDCAN_DBTP_DTSEG2_Msk                        /*!<Data time segment after sample point    */
#define FDCAN_DBTP_DTSEG1_Pos     (8U)
#define FDCAN_DBTP_DTSEG1_Msk     (0x1FU << FDCAN_DBTP_DTSEG1_Pos)              /*!< 0x00001F00 */
#define FDCAN_DBTP_DTSEG1         FDCAN_DBTP_DTSEG1_Msk                        /*!<Data time segment before sample point   */
#define FDCAN_DBTP_DBRP_Pos       (16U)
#define FDCAN_DBTP_DBRP_Msk       (0x1FU << FDCAN_DBTP_DBRP_Pos)               /*!< 0x001F0000 */
#define FDCAN_DBTP_DBRP           FDCAN_DBTP_DBRP_Msk                          /*!<Data BIt Rate Prescaler                 */
#define FDCAN_DBTP_TDC_Pos        (23U)
#define FDCAN_DBTP_TDC_Msk        (0x1U << FDCAN_DBTP_TDC_Pos)                 /*!< 0x00800000 */
#define FDCAN_DBTP_TDC            FDCAN_DBTP_TDC_Msk                           /*!<Transceiver Delay Compensation          */

/*****************  Bit definition for FDCAN_TEST register  *******************/
#define FDCAN_TEST_LBCK_Pos       (4U)
#define FDCAN_TEST_LBCK_Msk       (0x1U << FDCAN_TEST_LBCK_Pos)                /*!< 0x00000010 */
#define FDCAN_TEST_LBCK           FDCAN_TEST_LBCK_Msk                          /*!<Loop Back mode                           */
#define FDCAN_TEST_TX_Pos         (5U)
#define FDCAN_TEST_TX_Msk         (0x3U << FDCAN_TEST_TX_Pos)                  /*!< 0x00000060 */
#define FDCAN_TEST_TX             FDCAN_TEST_TX_Msk                            /*!<Control of Transmit Pin                  */
#define FDCAN_TEST_RX_Pos         (7U)
#define FDCAN_TEST_RX_Msk         (0x1U << FDCAN_TEST_RX_Pos)                  /*!< 0x00000080 */
#define FDCAN_TEST_RX             FDCAN_TEST_RX_Msk                            /*!<Receive Pin                              */

/*****************  Bit definition for FDCAN_RWD register  ********************/
#define FDCAN_RWD_WDC_Pos         (0U)
#define FDCAN_RWD_WDC_Msk         (0xFFU << FDCAN_RWD_WDC_Pos)                  /*!< 0x000000FF */
#define FDCAN_RWD_WDC             FDCAN_RWD_WDC_Msk                            /*!<Watchdog configuration                   */
#define FDCAN_RWD_WDV_Pos         (8U)
#define FDCAN_RWD_WDV_Msk         (0xFFU << FDCAN_RWD_WDV_Pos)                  /*!< 0x0000FF00 */
#define FDCAN_RWD_WDV             FDCAN_RWD_WDV_Msk                            /*!<Watchdog value                           */

/*****************  Bit definition for FDCAN_CCCR register  ********************/
#define FDCAN_CCCR_INIT_Pos       (0U)
#define FDCAN_CCCR_INIT_Msk       (0x1U << FDCAN_CCCR_INIT_Pos)                /*!< 0x00000001 */
#define FDCAN_CCCR_INIT           FDCAN_CCCR_INIT_Msk                          /*!<Initialization                           */
#define FDCAN_CCCR_CCE_Pos        (1U)
#define FDCAN_CCCR_CCE_Msk        (0x1U << FDCAN_CCCR_CCE_Pos)                 /*!< 0x00000002 */
#define FDCAN_CCCR_CCE            FDCAN_CCCR_CCE_Msk                           /*!<Configuration Change Enable              */
#define FDCAN_CCCR_ASM_Pos        (2U)
#define FDCAN_CCCR_ASM_Msk        (0x1U << FDCAN_CCCR_ASM_Pos)                 /*!< 0x00000004 */
#define FDCAN_CCCR_ASM            FDCAN_CCCR_ASM_Msk                           /*!<ASM Restricted Operation Mode            */
#define FDCAN_CCCR_CSA_Pos        (3U)
#define FDCAN_CCCR_CSA_Msk        (0x1U << FDCAN_CCCR_CSA_Pos)                 /*!< 0x00000008 */
#define FDCAN_CCCR_CSA            FDCAN_CCCR_CSA_Msk                           /*!<Clock Stop Acknowledge                   */
#define FDCAN_CCCR_CSR_Pos        (4U)
#define FDCAN_CCCR_CSR_Msk        (0x1U << FDCAN_CCCR_CSR_Pos)                 /*!< 0x00000010 */
#define FDCAN_CCCR_CSR            FDCAN_CCCR_CSR_Msk                           /*!<Clock Stop Request                       */
#define FDCAN_CCCR_MON_Pos        (5U)
#define FDCAN_CCCR_MON_Msk        (0x1U << FDCAN_CCCR_MON_Pos)                 /*!< 0x00000020 */
#define FDCAN_CCCR_MON            FDCAN_CCCR_MON_Msk                           /*!<Bus Monitoring Mode                      */
#define FDCAN_CCCR_DAR_Pos        (6U)
#define FDCAN_CCCR_DAR_Msk        (0x1U << FDCAN_CCCR_DAR_Pos)                 /*!< 0x00000040 */
#define FDCAN_CCCR_DAR            FDCAN_CCCR_DAR_Msk                           /*!<Disable Automatic Retransmission         */
#define FDCAN_CCCR_TEST_Pos       (7U)
#define FDCAN_CCCR_TEST_Msk       (0x1U << FDCAN_CCCR_TEST_Pos)                /*!< 0x00000080 */
#define FDCAN_CCCR_TEST           FDCAN_CCCR_TEST_Msk                          /*!<Test Mode Enable                         */
#define FDCAN_CCCR_FDOE_Pos       (8U)
#define FDCAN_CCCR_FDOE_Msk       (0x1U << FDCAN_CCCR_FDOE_Pos)                /*!< 0x00000100 */
#define FDCAN_CCCR_FDOE           FDCAN_CCCR_FDOE_Msk                          /*!<FD Operation Enable                      */
#define FDCAN_CCCR_BRSE_Pos       (9U)
#define FDCAN_CCCR_BRSE_Msk       (0x1U << FDCAN_CCCR_BRSE_Pos)                /*!< 0x00000200 */
#define FDCAN_CCCR_BRSE           FDCAN_CCCR_BRSE_Msk                          /*!<FDCAN Bit Rate Switching                 */
#define FDCAN_CCCR_PXHD_Pos       (12U)
#define FDCAN_CCCR_PXHD_Msk       (0x1U << FDCAN_CCCR_PXHD_Pos)                /*!< 0x00001000 */
#define FDCAN_CCCR_PXHD           FDCAN_CCCR_PXHD_Msk                          /*!<Protocol Exception Handling Disable      */
#define FDCAN_CCCR_EFBI_Pos       (13U)
#define FDCAN_CCCR_EFBI_Msk       (0x1U << FDCAN_CCCR_EFBI_Pos)                /*!< 0x00002000 */
#define FDCAN_CCCR_EFBI           FDCAN_CCCR_EFBI_Msk                          /*!<Edge Filtering during Bus Integration    */
#define FDCAN_CCCR_TXP_Pos        (14U)
#define FDCAN_CCCR_TXP_Msk        (0x1U << FDCAN_CCCR_TXP_Pos)                 /*!< 0x00004000 */
#define FDCAN_CCCR_TXP            FDCAN_CCCR_TXP_Msk                           /*!<Two CAN bit times Pause                  */
#define FDCAN_CCCR_NISO_Pos       (15U)
#define FDCAN_CCCR_NISO_Msk       (0x1U << FDCAN_CCCR_NISO_Pos)                /*!< 0x00008000 */
#define FDCAN_CCCR_NISO           FDCAN_CCCR_NISO_Msk                          /*!<Non ISO Operation                        */

/*****************  Bit definition for FDCAN_NBTP register  ********************/
#define FDCAN_NBTP_NTSEG2_Pos     (0U)
#define FDCAN_NBTP_NTSEG2_Msk     (0x7FU << FDCAN_NBTP_NTSEG2_Pos)             /*!< 0x0000007F */
#define FDCAN_NBTP_NTSEG2         FDCAN_NBTP_NTSEG2_Msk                        /*!<Nominal Time segment after sample point  */
#define FDCAN_NBTP_NTSEG1_Pos     (8U)
#define FDCAN_NBTP_NTSEG1_Msk     (0xFFU << FDCAN_NBTP_NTSEG1_Pos)             /*!< 0x0000FF00 */
#define FDCAN_NBTP_NTSEG1         FDCAN_NBTP_NTSEG1_Msk                        /*!<Nominal Time segment before sample point */
#define FDCAN_NBTP_NBRP_Pos       (16U)
#define FDCAN_NBTP_NBRP_Msk       (0x1FFU << FDCAN_NBTP_NBRP_Pos)              /*!< 0x01FF0000 */
#define FDCAN_NBTP_NBRP           FDCAN_NBTP_NBRP_Msk                          /*!<Bit Rate Prescaler                       */
#define FDCAN_NBTP_NSJW_Pos       (25U)
#define FDCAN_NBTP_NSJW_Msk       (0x7FU << FDCAN_NBTP_NSJW_Pos)               /*!< 0xFE000000 */
#define FDCAN_NBTP_NSJW           FDCAN_NBTP_NSJW_Msk                          /*!<Nominal (Re)Synchronization Jump Width   */

/*****************  Bit definition for FDCAN_TSCC register  ********************/
#define FDCAN_TSCC_TSS_Pos        (0U)
#define FDCAN_TSCC_TSS_Msk        (0x3U << FDCAN_TSCC_TSS_Pos)                 /*!< 0x00000003 */
#define FDCAN_TSCC_TSS            FDCAN_TSCC_TSS_Msk                           /*!<Timestamp Select                         */
#define FDCAN_TSCC_TCP_Pos        (16U)
#define FDCAN_TSCC_TCP_Msk        (0xFU << FDCAN_TSCC_TCP_Pos)                 /*!< 0x000F0000 */
#define FDCAN_TSCC_TCP            FDCAN_TSCC_TCP_Msk                           /*!<Timestamp Counter Prescaler              */

/*****************  Bit definition for FDCAN_TSCV register  ********************/
#define FDCAN_TSCV_TSC_Pos        (0U)
#define FDCAN_TSCV_TSC_Msk        (0xFFFFU << FDCAN_TSCV_TSC_Pos)              /*!< 0x0000FFFF */
#define FDCAN_TSCV_TSC            FDCAN_TSCV_TSC_Msk                           /*!<Timestamp Counter                        */

/*****************  Bit definition for FDCAN_TOCC register  ********************/
#define FDCAN_TOCC_ETOC_Pos       (0U)
#define FDCAN_TOCC_ETOC_Msk       (0x1U << FDCAN_TOCC_ETOC_Pos)                /*!< 0x00000001 */
#define FDCAN_TOCC_ETOC           FDCAN_TOCC_ETOC_Msk                          /*!<Enable Timeout Counter                   */
#define FDCAN_TOCC_TOS_Pos        (1U)
#define FDCAN_TOCC_TOS_Msk        (0x3U << FDCAN_TOCC_TOS_Pos)                 /*!< 0x00000006 */
#define FDCAN_TOCC_TOS            FDCAN_TOCC_TOS_Msk                           /*!<Timeout Select                           */
#define FDCAN_TOCC_TOP_Pos        (16U)
#define FDCAN_TOCC_TOP_Msk        (0xFFFFU << FDCAN_TOCC_TOP_Pos)              /*!< 0xFFFF0000 */
#define FDCAN_TOCC_TOP            FDCAN_TOCC_TOP_Msk                           /*!<Timeout Period                           */

/*****************  Bit definition for FDCAN_TOCV register  ********************/
#define FDCAN_TOCV_TOC_Pos        (0U)
#define FDCAN_TOCV_TOC_Msk        (0xFFFFU << FDCAN_TOCV_TOC_Pos)              /*!< 0x0000FFFF */
#define FDCAN_TOCV_TOC            FDCAN_TOCV_TOC_Msk                           /*!<Timeout Counter                          */

/*****************  Bit definition for FDCAN_ECR register  *********************/
#define FDCAN_ECR_TEC_Pos         (0U)
#define FDCAN_ECR_TEC_Msk         (0xFFU << FDCAN_ECR_TEC_Pos)                 /*!< 0x0000000F */
#define FDCAN_ECR_TEC             FDCAN_ECR_TEC_Msk                            /*!<Transmit Error Counter                   */
#define FDCAN_ECR_REC_Pos         (8U)
#define FDCAN_ECR_REC_Msk         (0x7FU << FDCAN_ECR_REC_Pos)                 /*!< 0x00007F00 */
#define FDCAN_ECR_REC             FDCAN_ECR_REC_Msk                            /*!<Receive Error Counter                    */
#define FDCAN_ECR_RP_Pos          (15U)
#define FDCAN_ECR_RP_Msk          (0x1U << FDCAN_ECR_RP_Pos)                   /*!< 0x00008000 */
#define FDCAN_ECR_RP              FDCAN_ECR_RP_Msk                             /*!<Receive Error Passive                    */
#define FDCAN_ECR_CEL_Pos         (16U)
#define FDCAN_ECR_CEL_Msk         (0xFFU << FDCAN_ECR_CEL_Pos)                 /*!< 0x00FF0000 */
#define FDCAN_ECR_CEL             FDCAN_ECR_CEL_Msk                            /*!<CAN Error Logging                        */

/*****************  Bit definition for FDCAN_PSR register  *********************/
#define FDCAN_PSR_LEC_Pos         (0U)
#define FDCAN_PSR_LEC_Msk         (0x7U << FDCAN_PSR_LEC_Pos)                  /*!< 0x00000007 */
#define FDCAN_PSR_LEC             FDCAN_PSR_LEC_Msk                            /*!<Last Error Code                          */
#define FDCAN_PSR_ACT_Pos         (3U)
#define FDCAN_PSR_ACT_Msk         (0x3U << FDCAN_PSR_ACT_Pos)                  /*!< 0x00000018 */
#define FDCAN_PSR_ACT             FDCAN_PSR_ACT_Msk                            /*!<Activity                                 */
#define FDCAN_PSR_EP_Pos          (5U)
#define FDCAN_PSR_EP_Msk          (0x1U << FDCAN_PSR_EP_Pos)                   /*!< 0x00000020 */
#define FDCAN_PSR_EP              FDCAN_PSR_EP_Msk                             /*!<Error Passive                            */
#define FDCAN_PSR_EW_Pos          (6U)
#define FDCAN_PSR_EW_Msk          (0x1U << FDCAN_PSR_EW_Pos)                   /*!< 0x00000040 */
#define FDCAN_PSR_EW              FDCAN_PSR_EW_Msk                             /*!<Warning Status                           */
#define FDCAN_PSR_BO_Pos          (7U)
#define FDCAN_PSR_BO_Msk          (0x1U << FDCAN_PSR_BO_Pos)                   /*!< 0x00000080 */
#define FDCAN_PSR_BO              FDCAN_PSR_BO_Msk                             /*!<Bus_Off Status                           */
#define FDCAN_PSR_DLEC_Pos        (8U)
#define FDCAN_PSR_DLEC_Msk        (0x7U << FDCAN_PSR_DLEC_Pos)                 /*!< 0x00000700 */
#define FDCAN_PSR_DLEC            FDCAN_PSR_DLEC_Msk                           /*!<Data Last Error Code                     */
#define FDCAN_PSR_RESI_Pos        (11U)
#define FDCAN_PSR_RESI_Msk        (0x1U << FDCAN_PSR_RESI_Pos)                 /*!< 0x00000800 */
#define FDCAN_PSR_RESI            FDCAN_PSR_RESI_Msk                           /*!<ESI flag of last received FDCAN Message  */
#define FDCAN_PSR_RBRS_Pos        (12U)
#define FDCAN_PSR_RBRS_Msk        (0x1U << FDCAN_PSR_RBRS_Pos)                 /*!< 0x00001000 */
#define FDCAN_PSR_RBRS            FDCAN_PSR_RBRS_Msk                           /*!<BRS flag of last received FDCAN Message  */
#define FDCAN_PSR_REDL_Pos        (13U)
#define FDCAN_PSR_REDL_Msk        (0x1U << FDCAN_PSR_REDL_Pos)                 /*!< 0x00002000 */
#define FDCAN_PSR_REDL            FDCAN_PSR_REDL_Msk                           /*!<Received FDCAN Message                   */
#define FDCAN_PSR_PXE_Pos         (14U)
#define FDCAN_PSR_PXE_Msk         (0x1U << FDCAN_PSR_PXE_Pos)                  /*!< 0x00004000 */
#define FDCAN_PSR_PXE             FDCAN_PSR_PXE_Msk                            /*!<Protocol Exception Event                 */
#define FDCAN_PSR_TDCV_Pos        (16U)
#define FDCAN_PSR_TDCV_Msk        (0x7FU << FDCAN_PSR_TDCV_Pos)                /*!< 0x007F0000 */
#define FDCAN_PSR_TDCV            FDCAN_PSR_TDCV_Msk                           /*!<Transmitter Delay Compensation Value     */

/*****************  Bit definition for FDCAN_TDCR register  ********************/
#define FDCAN_TDCR_TDCF_Pos       (0U)
#define FDCAN_TDCR_TDCF_Msk       (0x7FU << FDCAN_TDCR_TDCF_Pos)               /*!< 0x0000007F */
#define FDCAN_TDCR_TDCF           FDCAN_TDCR_TDCF_Msk                          /*!<Transmitter Delay Compensation Filter    */
#define FDCAN_TDCR_TDCO_Pos       (8U)
#define FDCAN_TDCR_TDCO_Msk       (0x7FU << FDCAN_TDCR_TDCO_Pos)               /*!< 0x00007F00 */
#define FDCAN_TDCR_TDCO           FDCAN_TDCR_TDCO_Msk                          /*!<Transmitter Delay Compensation Offset    */

/*****************  Bit definition for FDCAN_IR register  **********************/
#define FDCAN_IR_RF0N_Pos         (0U)
#define FDCAN_IR_RF0N_Msk         (0x1U << FDCAN_IR_RF0N_Pos)                  /*!< 0x00000001 */
#define FDCAN_IR_RF0N             FDCAN_IR_RF0N_Msk                            /*!<Rx FIFO 0 New Message                    */
#define FDCAN_IR_RF0W_Pos         (1U)
#define FDCAN_IR_RF0W_Msk         (0x1U << FDCAN_IR_RF0W_Pos)                  /*!< 0x00000002 */
#define FDCAN_IR_RF0W             FDCAN_IR_RF0W_Msk                            /*!<Rx FIFO 0 Watermark Reached              */
#define FDCAN_IR_RF0F_Pos         (2U)
#define FDCAN_IR_RF0F_Msk         (0x1U << FDCAN_IR_RF0F_Pos)                  /*!< 0x00000004 */
#define FDCAN_IR_RF0F             FDCAN_IR_RF0F_Msk                            /*!<Rx FIFO 0 Full                           */
#define FDCAN_IR_RF0L_Pos         (3U)
#define FDCAN_IR_RF0L_Msk         (0x1U << FDCAN_IR_RF0L_Pos)                  /*!< 0x00000008 */
#define FDCAN_IR_RF0L             FDCAN_IR_RF0L_Msk                            /*!<Rx FIFO 0 Message Lost                   */
#define FDCAN_IR_RF1N_Pos         (4U)
#define FDCAN_IR_RF1N_Msk         (0x1U << FDCAN_IR_RF1N_Pos)                  /*!< 0x00000010 */
#define FDCAN_IR_RF1N             FDCAN_IR_RF1N_Msk                            /*!<Rx FIFO 1 New Message                    */
#define FDCAN_IR_RF1W_Pos         (5U)
#define FDCAN_IR_RF1W_Msk         (0x1U << FDCAN_IR_RF1W_Pos)                  /*!< 0x00000020 */
#define FDCAN_IR_RF1W             FDCAN_IR_RF1W_Msk                            /*!<Rx FIFO 1 Watermark Reached              */
#define FDCAN_IR_RF1F_Pos         (6U)
#define FDCAN_IR_RF1F_Msk         (0x1U << FDCAN_IR_RF1F_Pos)                  /*!< 0x00000040 */
#define FDCAN_IR_RF1F             FDCAN_IR_RF1F_Msk                            /*!<Rx FIFO 1 Full                           */
#define FDCAN_IR_RF1L_Pos         (7U)
#define FDCAN_IR_RF1L_Msk         (0x1U << FDCAN_IR_RF1L_Pos)                  /*!< 0x00000080 */
#define FDCAN_IR_RF1L             FDCAN_IR_RF1L_Msk                            /*!<Rx FIFO 1 Message Lost                   */
#define FDCAN_IR_HPM_Pos          (8U)
#define FDCAN_IR_HPM_Msk          (0x1U << FDCAN_IR_HPM_Pos)                   /*!< 0x00000100 */
#define FDCAN_IR_HPM              FDCAN_IR_HPM_Msk                             /*!<High Priority Message                    */
#define FDCAN_IR_TC_Pos           (9U)
#define FDCAN_IR_TC_Msk           (0x1U << FDCAN_IR_TC_Pos)                    /*!< 0x00000200 */
#define FDCAN_IR_TC               FDCAN_IR_TC_Msk                              /*!<Transmission Completed                   */
#define FDCAN_IR_TCF_Pos          (10U)
#define FDCAN_IR_TCF_Msk          (0x1U << FDCAN_IR_TCF_Pos)                   /*!< 0x00000400 */
#define FDCAN_IR_TCF              FDCAN_IR_TCF_Msk                             /*!<Transmission Cancellation Finished       */
#define FDCAN_IR_TFE_Pos          (11U)
#define FDCAN_IR_TFE_Msk          (0x1U << FDCAN_IR_TFE_Pos)                   /*!< 0x00000800 */
#define FDCAN_IR_TFE              FDCAN_IR_TFE_Msk                             /*!<Tx FIFO Empty                            */
#define FDCAN_IR_TEFN_Pos         (12U)
#define FDCAN_IR_TEFN_Msk         (0x1U << FDCAN_IR_TEFN_Pos)                  /*!< 0x00001000 */
#define FDCAN_IR_TEFN             FDCAN_IR_TEFN_Msk                            /*!<Tx Event FIFO New Entry                  */
#define FDCAN_IR_TEFW_Pos         (13U)
#define FDCAN_IR_TEFW_Msk         (0x1U << FDCAN_IR_TEFW_Pos)                  /*!< 0x00002000 */
#define FDCAN_IR_TEFW             FDCAN_IR_TEFW_Msk                            /*!<Tx Event FIFO Watermark Reached          */
#define FDCAN_IR_TEFF_Pos         (14U)
#define FDCAN_IR_TEFF_Msk         (0x1U << FDCAN_IR_TEFF_Pos)                  /*!< 0x00004000 */
#define FDCAN_IR_TEFF             FDCAN_IR_TEFF_Msk                            /*!<Tx Event FIFO Full                       */
#define FDCAN_IR_TEFL_Pos         (15U)
#define FDCAN_IR_TEFL_Msk         (0x1U << FDCAN_IR_TEFL_Pos)                  /*!< 0x00008000 */
#define FDCAN_IR_TEFL             FDCAN_IR_TEFL_Msk                            /*!<Tx Event FIFO Element Lost               */
#define FDCAN_IR_TSW_Pos          (16U)
#define FDCAN_IR_TSW_Msk          (0x1U << FDCAN_IR_TSW_Pos)                   /*!< 0x00010000 */
#define FDCAN_IR_TSW              FDCAN_IR_TSW_Msk                             /*!<Timestamp Wraparound                     */
#define FDCAN_IR_MRAF_Pos         (17U)
#define FDCAN_IR_MRAF_Msk         (0x1U << FDCAN_IR_MRAF_Pos)                  /*!< 0x00020000 */
#define FDCAN_IR_MRAF             FDCAN_IR_MRAF_Msk                            /*!<Message RAM Access Failure               */
#define FDCAN_IR_TOO_Pos          (18U)
#define FDCAN_IR_TOO_Msk          (0x1U << FDCAN_IR_TOO_Pos)                   /*!< 0x00040000 */
#define FDCAN_IR_TOO              FDCAN_IR_TOO_Msk                             /*!<Timeout Occurred                         */
#define FDCAN_IR_DRX_Pos          (19U)
#define FDCAN_IR_DRX_Msk          (0x1U << FDCAN_IR_DRX_Pos)                   /*!< 0x00080000 */
#define FDCAN_IR_DRX              FDCAN_IR_DRX_Msk                             /*!<Message stored to Dedicated Rx Buffer    */
#define FDCAN_IR_ELO_Pos          (22U)
#define FDCAN_IR_ELO_Msk          (0x1U << FDCAN_IR_ELO_Pos)                   /*!< 0x00400000 */
#define FDCAN_IR_ELO              FDCAN_IR_ELO_Msk                             /*!<Error Logging Overflow                   */
#define FDCAN_IR_EP_Pos           (23U)
#define FDCAN_IR_EP_Msk           (0x1U << FDCAN_IR_EP_Pos)                    /*!< 0x00800000 */
#define FDCAN_IR_EP               FDCAN_IR_EP_Msk                              /*!<Error Passive                            */
#define FDCAN_IR_EW_Pos           (24U)
#define FDCAN_IR_EW_Msk           (0x1U << FDCAN_IR_EW_Pos)                    /*!< 0x01000000 */
#define FDCAN_IR_EW               FDCAN_IR_EW_Msk                              /*!<Warning Status                           */
#define FDCAN_IR_BO_Pos           (25U)
#define FDCAN_IR_BO_Msk           (0x1U << FDCAN_IR_BO_Pos)                    /*!< 0x02000000 */
#define FDCAN_IR_BO               FDCAN_IR_BO_Msk                              /*!<Bus_Off Status                           */
#define FDCAN_IR_WDI_Pos          (26U)
#define FDCAN_IR_WDI_Msk          (0x1U << FDCAN_IR_WDI_Pos)                   /*!< 0x04000000 */
#define FDCAN_IR_WDI              FDCAN_IR_WDI_Msk                             /*!<Watchdog Interrupt                       */
#define FDCAN_IR_PEA_Pos          (27U)
#define FDCAN_IR_PEA_Msk          (0x1U << FDCAN_IR_PEA_Pos)                   /*!< 0x08000000 */
#define FDCAN_IR_PEA              FDCAN_IR_PEA_Msk                             /*!<Protocol Error in Arbitration Phase      */
#define FDCAN_IR_PED_Pos          (28U)
#define FDCAN_IR_PED_Msk          (0x1U << FDCAN_IR_PED_Pos)                   /*!< 0x10000000 */
#define FDCAN_IR_PED              FDCAN_IR_PED_Msk                             /*!<Protocol Error in Data Phase             */
#define FDCAN_IR_ARA_Pos          (29U)
#define FDCAN_IR_ARA_Msk          (0x1U << FDCAN_IR_ARA_Pos)                   /*!< 0x20000000 */
#define FDCAN_IR_ARA              FDCAN_IR_ARA_Msk                             /*!<Access to Reserved Address               */

/*****************  Bit definition for FDCAN_IE register  **********************/
#define FDCAN_IE_RF0NE_Pos        (0U)
#define FDCAN_IE_RF0NE_Msk        (0x1U << FDCAN_IE_RF0NE_Pos)                 /*!< 0x00000001 */
#define FDCAN_IE_RF0NE            FDCAN_IE_RF0NE_Msk                           /*!<Rx FIFO 0 New Message Enable                 */
#define FDCAN_IE_RF0WE_Pos        (1U)
#define FDCAN_IE_RF0WE_Msk        (0x1U << FDCAN_IE_RF0WE_Pos)                 /*!< 0x00000002 */
#define FDCAN_IE_RF0WE            FDCAN_IE_RF0WE_Msk                           /*!<Rx FIFO 0 Watermark Reached Enable           */
#define FDCAN_IE_RF0FE_Pos        (2U)
#define FDCAN_IE_RF0FE_Msk        (0x1U << FDCAN_IE_RF0FE_Pos)                 /*!< 0x00000004 */
#define FDCAN_IE_RF0FE            FDCAN_IE_RF0FE_Msk                           /*!<Rx FIFO 0 Full Enable                        */
#define FDCAN_IE_RF0LE_Pos        (3U)
#define FDCAN_IE_RF0LE_Msk        (0x1U << FDCAN_IE_RF0LE_Pos)                 /*!< 0x00000008 */
#define FDCAN_IE_RF0LE            FDCAN_IE_RF0LE_Msk                           /*!<Rx FIFO 0 Message Lost Enable                */
#define FDCAN_IE_RF1NE_Pos        (4U)
#define FDCAN_IE_RF1NE_Msk        (0x1U << FDCAN_IE_RF1NE_Pos)                 /*!< 0x00000010 */
#define FDCAN_IE_RF1NE            FDCAN_IE_RF1NE_Msk                           /*!<Rx FIFO 1 New Message Enable                 */
#define FDCAN_IE_RF1WE_Pos        (5U)
#define FDCAN_IE_RF1WE_Msk        (0x1U << FDCAN_IE_RF1WE_Pos)                 /*!< 0x00000020 */
#define FDCAN_IE_RF1WE            FDCAN_IE_RF1WE_Msk                           /*!<Rx FIFO 1 Watermark Reached Enable           */
#define FDCAN_IE_RF1FE_Pos        (6U)
#define FDCAN_IE_RF1FE_Msk        (0x1U << FDCAN_IE_RF1FE_Pos)                 /*!< 0x00000040 */
#define FDCAN_IE_RF1FE            FDCAN_IE_RF1FE_Msk                           /*!<Rx FIFO 1 Full Enable                        */
#define FDCAN_IE_RF1LE_Pos        (7U)
#define FDCAN_IE_RF1LE_Msk        (0x1U << FDCAN_IE_RF1LE_Pos)                 /*!< 0x00000080 */
#define FDCAN_IE_RF1LE            FDCAN_IE_RF1LE_Msk                           /*!<Rx FIFO 1 Message Lost Enable                */
#define FDCAN_IE_HPME_Pos         (8U)
#define FDCAN_IE_HPME_Msk         (0x1U << FDCAN_IE_HPME_Pos)                  /*!< 0x00000100 */
#define FDCAN_IE_HPME             FDCAN_IE_HPME_Msk                            /*!<High Priority Message Enable                 */
#define FDCAN_IE_TCE_Pos          (9U)
#define FDCAN_IE_TCE_Msk          (0x1U << FDCAN_IE_TCE_Pos)                   /*!< 0x00000200 */
#define FDCAN_IE_TCE              FDCAN_IE_TCE_Msk                             /*!<Transmission Completed Enable                */
#define FDCAN_IE_TCFE_Pos         (10U)
#define FDCAN_IE_TCFE_Msk         (0x1U << FDCAN_IE_TCFE_Pos)                  /*!< 0x00000400 */
#define FDCAN_IE_TCFE             FDCAN_IE_TCFE_Msk                            /*!<Transmission Cancellation Finished Enable    */
#define FDCAN_IE_TFEE_Pos         (11U)
#define FDCAN_IE_TFEE_Msk         (0x1U << FDCAN_IE_TFEE_Pos)                  /*!< 0x00000800 */
#define FDCAN_IE_TFEE             FDCAN_IE_TFEE_Msk                            /*!<Tx FIFO Empty Enable                         */
#define FDCAN_IE_TEFNE_Pos        (12U)
#define FDCAN_IE_TEFNE_Msk        (0x1U << FDCAN_IE_TEFNE_Pos)                 /*!< 0x00001000 */
#define FDCAN_IE_TEFNE            FDCAN_IE_TEFNE_Msk                           /*!<Tx Event FIFO New Entry Enable               */
#define FDCAN_IE_TEFWE_Pos        (13U)
#define FDCAN_IE_TEFWE_Msk        (0x1U << FDCAN_IE_TEFWE_Pos)                 /*!< 0x00002000 */
#define FDCAN_IE_TEFWE            FDCAN_IE_TEFWE_Msk                           /*!<Tx Event FIFO Watermark Reached Enable       */
#define FDCAN_IE_TEFFE_Pos        (14U)
#define FDCAN_IE_TEFFE_Msk        (0x1U << FDCAN_IE_TEFFE_Pos)                 /*!< 0x00004000 */
#define FDCAN_IE_TEFFE            FDCAN_IE_TEFFE_Msk                           /*!<Tx Event FIFO Full Enable                    */
#define FDCAN_IE_TEFLE_Pos        (15U)
#define FDCAN_IE_TEFLE_Msk        (0x1U << FDCAN_IE_TEFLE_Pos)                 /*!< 0x00008000 */
#define FDCAN_IE_TEFLE            FDCAN_IE_TEFLE_Msk                           /*!<Tx Event FIFO Element Lost Enable            */
#define FDCAN_IE_TSWE_Pos         (16U)
#define FDCAN_IE_TSWE_Msk         (0x1U << FDCAN_IE_TSWE_Pos)                  /*!< 0x00010000 */
#define FDCAN_IE_TSWE             FDCAN_IE_TSWE_Msk                            /*!<Timestamp Wraparound Enable                  */
#define FDCAN_IE_MRAFE_Pos        (17U)
#define FDCAN_IE_MRAFE_Msk        (0x1U << FDCAN_IE_MRAFE_Pos)                 /*!< 0x00020000 */
#define FDCAN_IE_MRAFE            FDCAN_IE_MRAFE_Msk                           /*!<Message RAM Access Failure Enable            */
#define FDCAN_IE_TOOE_Pos         (18U)
#define FDCAN_IE_TOOE_Msk         (0x1U << FDCAN_IE_TOOE_Pos)                  /*!< 0x00040000 */
#define FDCAN_IE_TOOE             FDCAN_IE_TOOE_Msk                            /*!<Timeout Occurred Enable                      */
#define FDCAN_IE_DRXE_Pos         (19U)
#define FDCAN_IE_DRXE_Msk         (0x1U << FDCAN_IE_DRXE_Pos)                  /*!< 0x00080000 */
#define FDCAN_IE_DRXE             FDCAN_IE_DRXE_Msk                            /*!<Message stored to Dedicated Rx Buffer Enable */
#define FDCAN_IE_ELOE_Pos         (22U)
#define FDCAN_IE_ELOE_Msk         (0x1U << FDCAN_IE_ELOE_Pos)                  /*!< 0x00400000 */
#define FDCAN_IE_ELOE             FDCAN_IE_ELOE_Msk                            /*!<Error Logging Overflow Enable                */
#define FDCAN_IE_EPE_Pos          (23U)
#define FDCAN_IE_EPE_Msk          (0x1U << FDCAN_IE_EPE_Pos)                   /*!< 0x00800000 */
#define FDCAN_IE_EPE              FDCAN_IE_EPE_Msk                             /*!<Error Passive Enable                         */
#define FDCAN_IE_EWE_Pos          (24U)
#define FDCAN_IE_EWE_Msk          (0x1U << FDCAN_IE_EWE_Pos)                   /*!< 0x01000000 */
#define FDCAN_IE_EWE              FDCAN_IE_EWE_Msk                             /*!<Warning Status Enable                        */
#define FDCAN_IE_BOE_Pos          (25U)
#define FDCAN_IE_BOE_Msk          (0x1U << FDCAN_IE_BOE_Pos)                   /*!< 0x02000000 */
#define FDCAN_IE_BOE              FDCAN_IE_BOE_Msk                             /*!<Bus_Off Status Enable                        */
#define FDCAN_IE_WDIE_Pos         (26U)
#define FDCAN_IE_WDIE_Msk         (0x1U << FDCAN_IE_WDIE_Pos)                  /*!< 0x04000000 */
#define FDCAN_IE_WDIE             FDCAN_IE_WDIE_Msk                            /*!<Watchdog Interrupt Enable                    */
#define FDCAN_IE_PEAE_Pos         (27U)
#define FDCAN_IE_PEAE_Msk         (0x1U << FDCAN_IE_PEAE_Pos)                  /*!< 0x08000000 */
#define FDCAN_IE_PEAE             FDCAN_IE_PEAE_Msk                            /*!<Protocol Error in Arbitration Phase Enable   */
#define FDCAN_IE_PEDE_Pos         (28U)
#define FDCAN_IE_PEDE_Msk         (0x1U << FDCAN_IE_PEDE_Pos)                  /*!< 0x10000000 */
#define FDCAN_IE_PEDE             FDCAN_IE_PEDE_Msk                            /*!<Protocol Error in Data Phase Enable          */
#define FDCAN_IE_ARAE_Pos         (29U)
#define FDCAN_IE_ARAE_Msk         (0x1U << FDCAN_IE_ARAE_Pos)                  /*!< 0x20000000 */
#define FDCAN_IE_ARAE             FDCAN_IE_ARAE_Msk                            /*!<Access to Reserved Address Enable            */

/*****************  Bit definition for FDCAN_ILS register  **********************/
#define FDCAN_ILS_RF0NL_Pos       (0U)
#define FDCAN_ILS_RF0NL_Msk       (0x1U << FDCAN_ILS_RF0NL_Pos)                /*!< 0x00000001 */
#define FDCAN_ILS_RF0NL           FDCAN_ILS_RF0NL_Msk                          /*!<Rx FIFO 0 New Message Line                  */
#define FDCAN_ILS_RF0WL_Pos       (1U)
#define FDCAN_ILS_RF0WL_Msk       (0x1U << FDCAN_ILS_RF0WL_Pos)                /*!< 0x00000002 */
#define FDCAN_ILS_RF0WL           FDCAN_ILS_RF0WL_Msk                          /*!<Rx FIFO 0 Watermark Reached Line            */
#define FDCAN_ILS_RF0FL_Pos       (2U)
#define FDCAN_ILS_RF0FL_Msk       (0x1U << FDCAN_ILS_RF0FL_Pos)                /*!< 0x00000004 */
#define FDCAN_ILS_RF0FL           FDCAN_ILS_RF0FL_Msk                          /*!<Rx FIFO 0 Full Line                         */
#define FDCAN_ILS_RF0LL_Pos       (3U)
#define FDCAN_ILS_RF0LL_Msk       (0x1U << FDCAN_ILS_RF0LL_Pos)                /*!< 0x00000008 */
#define FDCAN_ILS_RF0LL           FDCAN_ILS_RF0LL_Msk                          /*!<Rx FIFO 0 Message Lost Line                 */
#define FDCAN_ILS_RF1NL_Pos       (4U)
#define FDCAN_ILS_RF1NL_Msk       (0x1U << FDCAN_ILS_RF1NL_Pos)                /*!< 0x00000010 */
#define FDCAN_ILS_RF1NL           FDCAN_ILS_RF1NL_Msk                          /*!<Rx FIFO 1 New Message Line                  */
#define FDCAN_ILS_RF1WL_Pos       (5U)
#define FDCAN_ILS_RF1WL_Msk       (0x1U << FDCAN_ILS_RF1WL_Pos)                /*!< 0x00000020 */
#define FDCAN_ILS_RF1WL           FDCAN_ILS_RF1WL_Msk                          /*!<Rx FIFO 1 Watermark Reached Line            */
#define FDCAN_ILS_RF1FL_Pos       (6U)
#define FDCAN_ILS_RF1FL_Msk       (0x1U << FDCAN_ILS_RF1FL_Pos)                /*!< 0x00000040 */
#define FDCAN_ILS_RF1FL           FDCAN_ILS_RF1FL_Msk                          /*!<Rx FIFO 1 Full Line                         */
#define FDCAN_ILS_RF1LL_Pos       (7U)
#define FDCAN_ILS_RF1LL_Msk       (0x1U << FDCAN_ILS_RF1LL_Pos)                /*!< 0x00000080 */
#define FDCAN_ILS_RF1LL           FDCAN_ILS_RF1LL_Msk                          /*!<Rx FIFO 1 Message Lost Line                 */
#define FDCAN_ILS_HPML_Pos        (8U)
#define FDCAN_ILS_HPML_Msk        (0x1U << FDCAN_ILS_HPML_Pos)                 /*!< 0x00000100 */
#define FDCAN_ILS_HPML            FDCAN_ILS_HPML_Msk                           /*!<High Priority Message Line                  */
#define FDCAN_ILS_TCL_Pos         (9U)
#define FDCAN_ILS_TCL_Msk         (0x1U << FDCAN_ILS_TCL_Pos)                  /*!< 0x00000200 */
#define FDCAN_ILS_TCL             FDCAN_ILS_TCL_Msk                            /*!<Transmission Completed Line                 */
#define FDCAN_ILS_TCFL_Pos        (10U)
#define FDCAN_ILS_TCFL_Msk        (0x1U << FDCAN_ILS_TCFL_Pos)                 /*!< 0x00000400 */
#define FDCAN_ILS_TCFL            FDCAN_ILS_TCFL_Msk                           /*!<Transmission Cancellation Finished Line     */
#define FDCAN_ILS_TFEL_Pos        (11U)
#define FDCAN_ILS_TFEL_Msk        (0x1U << FDCAN_ILS_TFEL_Pos)                 /*!< 0x00000800 */
#define FDCAN_ILS_TFEL            FDCAN_ILS_TFEL_Msk                           /*!<Tx FIFO Empty Line                          */
#define FDCAN_ILS_TEFNL_Pos       (12U)
#define FDCAN_ILS_TEFNL_Msk       (0x1U << FDCAN_ILS_TEFNL_Pos)                /*!< 0x00001000 */
#define FDCAN_ILS_TEFNL           FDCAN_ILS_TEFNL_Msk                          /*!<Tx Event FIFO New Entry Line                */
#define FDCAN_ILS_TEFWL_Pos       (13U)
#define FDCAN_ILS_TEFWL_Msk       (0x1U << FDCAN_ILS_TEFWL_Pos)                /*!< 0x00002000 */
#define FDCAN_ILS_TEFWL           FDCAN_ILS_TEFWL_Msk                          /*!<Tx Event FIFO Watermark Reached Line        */
#define FDCAN_ILS_TEFFL_Pos       (14U)
#define FDCAN_ILS_TEFFL_Msk       (0x1U << FDCAN_ILS_TEFFL_Pos)                /*!< 0x00004000 */
#define FDCAN_ILS_TEFFL           FDCAN_ILS_TEFFL_Msk                          /*!<Tx Event FIFO Full Line                     */
#define FDCAN_ILS_TEFLL_Pos       (15U)
#define FDCAN_ILS_TEFLL_Msk       (0x1U << FDCAN_ILS_TEFLL_Pos)                /*!< 0x00008000 */
#define FDCAN_ILS_TEFLL           FDCAN_ILS_TEFLL_Msk                          /*!<Tx Event FIFO Element Lost Line             */
#define FDCAN_ILS_TSWL_Pos        (16U)
#define FDCAN_ILS_TSWL_Msk        (0x1U << FDCAN_ILS_TSWL_Pos)                 /*!< 0x00010000 */
#define FDCAN_ILS_TSWL            FDCAN_ILS_TSWL_Msk                           /*!<Timestamp Wraparound Line                   */
#define FDCAN_ILS_MRAFL_Pos       (17U)
#define FDCAN_ILS_MRAFL_Msk       (0x1U << FDCAN_ILS_MRAFL_Pos)                /*!< 0x00020000 */
#define FDCAN_ILS_MRAFL           FDCAN_ILS_MRAFL_Msk                          /*!<Message RAM Access Failure Line             */
#define FDCAN_ILS_TOOL_Pos        (18U)
#define FDCAN_ILS_TOOL_Msk        (0x1U << FDCAN_ILS_TOOL_Pos)                 /*!< 0x00040000 */
#define FDCAN_ILS_TOOL            FDCAN_ILS_TOOL_Msk                           /*!<Timeout Occurred Line                       */
#define FDCAN_ILS_DRXL_Pos        (19U)
#define FDCAN_ILS_DRXL_Msk        (0x1U << FDCAN_ILS_DRXL_Pos)                 /*!< 0x00080000 */
#define FDCAN_ILS_DRXL            FDCAN_ILS_DRXL_Msk                           /*!<Message stored to Dedicated Rx Buffer Line  */
#define FDCAN_ILS_ELOL_Pos        (22U)
#define FDCAN_ILS_ELOL_Msk        (0x1U << FDCAN_ILS_ELOL_Pos)                 /*!< 0x00400000 */
#define FDCAN_ILS_ELOL            FDCAN_ILS_ELOL_Msk                           /*!<Error Logging Overflow Line                 */
#define FDCAN_ILS_EPL_Pos         (23U)
#define FDCAN_ILS_EPL_Msk         (0x1U << FDCAN_ILS_EPL_Pos)                  /*!< 0x00800000 */
#define FDCAN_ILS_EPL             FDCAN_ILS_EPL_Msk                            /*!<Error Passive Line                          */
#define FDCAN_ILS_EWL_Pos         (24U)
#define FDCAN_ILS_EWL_Msk         (0x1U << FDCAN_ILS_EWL_Pos)                  /*!< 0x01000000 */
#define FDCAN_ILS_EWL             FDCAN_ILS_EWL_Msk                            /*!<Warning Status Line                         */
#define FDCAN_ILS_BOL_Pos         (25U)
#define FDCAN_ILS_BOL_Msk         (0x1U << FDCAN_ILS_BOL_Pos)                  /*!< 0x02000000 */
#define FDCAN_ILS_BOL             FDCAN_ILS_BOL_Msk                            /*!<Bus_Off Status Line                         */
#define FDCAN_ILS_WDIL_Pos        (26U)
#define FDCAN_ILS_WDIL_Msk        (0x1U << FDCAN_ILS_WDIL_Pos)                 /*!< 0x04000000 */
#define FDCAN_ILS_WDIL            FDCAN_ILS_WDIL_Msk                           /*!<Watchdog Interrupt Line                     */
#define FDCAN_ILS_PEAL_Pos        (27U)
#define FDCAN_ILS_PEAL_Msk        (0x1U << FDCAN_ILS_PEAL_Pos)                 /*!< 0x08000000 */
#define FDCAN_ILS_PEAL            FDCAN_ILS_PEAL_Msk                           /*!<Protocol Error in Arbitration Phase Line    */
#define FDCAN_ILS_PEDL_Pos        (28U)
#define FDCAN_ILS_PEDL_Msk        (0x1U << FDCAN_ILS_PEDL_Pos)                 /*!< 0x10000000 */
#define FDCAN_ILS_PEDL            FDCAN_ILS_PEDL_Msk                           /*!<Protocol Error in Data Phase Line           */
#define FDCAN_ILS_ARAL_Pos        (29U)
#define FDCAN_ILS_ARAL_Msk        (0x1U << FDCAN_ILS_ARAL_Pos)                 /*!< 0x20000000 */
#define FDCAN_ILS_ARAL            FDCAN_ILS_ARAL_Msk                           /*!<Access to Reserved Address Line             */

/** @defgroup FDCAN_Interrupt_Group FDCAN interrupt group
  * @{
  */
#define FDCAN_IT_GROUP_RX_FIFO0          FDCAN_ILS_RF0NL|FDCAN_ILS_RF0FL|FDCAN_ILS_RF0LL|FDCAN_ILS_RF0WL
															/*!< RX FIFO 0 Interrupts Group:
                                                                  RF0LL: Rx FIFO 0 Message Lost
                                                                  RF0FL: Rx FIFO 0 is Full
                                                                  RF0NL: Rx FIFO 0 Has New Message            */
#define FDCAN_IT_GROUP_RX_FIFO1          FDCAN_ILS_RF1NL|FDCAN_ILS_RF1FL|FDCAN_ILS_RF1LL|FDCAN_ILS_RF1WL
															/*!< RX FIFO 1 Interrupts Group:
                                                                  RF1LL: Rx FIFO 1 Message Lost
                                                                  RF1FL: Rx FIFO 1 is Full
                                                                  RF1NL: Rx FIFO 1 Has New Message            */
#define FDCAN_IT_GROUP_SMSG              FDCAN_ILS_HPML|FDCAN_ILS_TCL|FDCAN_ILS_TCFL
															/*!< Status Message Interrupts Group:
                                                                  TCFL: Transmission Cancellation Finished
                                                                  TCL: Transmission Completed
                                                                  HPML: High Priority Message                 */
#define FDCAN_IT_GROUP_TX_FIFO_ERROR     FDCAN_ILS_TFEL|FDCAN_ILS_TEFNL|FDCAN_ILS_TEFWL|FDCAN_ILS_TEFLL
															/*!< TX FIFO Error Interrupts Group:
                                                                  TEFLL: Tx Event FIFO Element Lost
                                                                  TEFFL: Tx Event FIFO Full
                                                                  TEFNL: Tx Event FIFO New Entry
                                                                  TFEL: Tx FIFO Empty Interrupt Line          */
#define FDCAN_IT_GROUP_MISC              FDCAN_ILS_TSWL|FDCAN_ILS_MRAFL|FDCAN_ILS_TOOL|FDCAN_ILS_DRXL
															/*!< Misc. Interrupts Group:
                                                                  TOOL: Timeout Occurred
                                                                  MRAFL: Message RAM Access Failure
                                                                  TSWL: Timestamp Wraparound                  */
#define FDCAN_IT_GROUP_BIT_LINE_ERROR    FDCAN_ILS_ELOL|FDCAN_ILS_EPL
															/*!< Bit and Line Error Interrupts Group:
                                                                  EPL: Error Passive
                                                                  ELOL: Error Logging Overflow                */
#define FDCAN_IT_GROUP_PROTOCOL_ERROR    FDCAN_ILS_EWL|FDCAN_ILS_BOL|FDCAN_ILS_WDIL|FDCAN_ILS_PEAL|FDCAN_ILS_PEDL|FDCAN_ILS_ARAL
															/*!< Protocol Error Group:
                                                                  ARAL: Access to Reserved Address Line
                                                                  PEDL: Protocol Error in Data Phase Line
                                                                  PEAL: Protocol Error in Arbitration Phase Line
                                                                  WDIL: Watchdog Interrupt Line
                                                                  BOL: Bus_Off Status
                                                                  EWL: Warning Status                         */
/**
  * @}
  */

/*****************  Bit definition for FDCAN_ILE register  **********************/
#define FDCAN_ILE_EINT0_Pos       (0U)
#define FDCAN_ILE_EINT0_Msk       (0x1U << FDCAN_ILE_EINT0_Pos)                /*!< 0x00000001 */
#define FDCAN_ILE_EINT0           FDCAN_ILE_EINT0_Msk                          /*!<Enable Interrupt Line 0                   */
#define FDCAN_ILE_EINT1_Pos       (1U)
#define FDCAN_ILE_EINT1_Msk       (0x1U << FDCAN_ILE_EINT1_Pos)                /*!< 0x00000002 */
#define FDCAN_ILE_EINT1           FDCAN_ILE_EINT1_Msk                          /*!<Enable Interrupt Line 1                   */

/*****************  Bit definition for FDCAN_GFC register  **********************/
#define FDCAN_GFC_RRFE_Pos        (0U)
#define FDCAN_GFC_RRFE_Msk        (0x1U << FDCAN_GFC_RRFE_Pos)                 /*!< 0x00000001 */
#define FDCAN_GFC_RRFE            FDCAN_GFC_RRFE_Msk                           /*!<Reject Remote Frames Extended             */
#define FDCAN_GFC_RRFS_Pos        (1U)
#define FDCAN_GFC_RRFS_Msk        (0x1U << FDCAN_GFC_RRFS_Pos)                 /*!< 0x00000002 */
#define FDCAN_GFC_RRFS            FDCAN_GFC_RRFS_Msk                           /*!<Reject Remote Frames Standard             */
#define FDCAN_GFC_ANFE_Pos        (2U)
#define FDCAN_GFC_ANFE_Msk        (0x3U << FDCAN_GFC_ANFE_Pos)                 /*!< 0x0000000C */
#define FDCAN_GFC_ANFE            FDCAN_GFC_ANFE_Msk                           /*!<Accept Non-matching Frames Extended       */
#define FDCAN_GFC_ANFS_Pos        (4U)
#define FDCAN_GFC_ANFS_Msk        (0x3U << FDCAN_GFC_ANFS_Pos)                 /*!< 0x00000030 */
#define FDCAN_GFC_ANFS            FDCAN_GFC_ANFS_Msk                           /*!<Accept Non-matching Frames Standard       */

/*****************  Bit definition for FDCAN_SIDFC register  ********************/
#define FDCAN_SIDFC_FLSSA_Pos     (2U)
#define FDCAN_SIDFC_FLSSA_Msk     (0x3FFFU << FDCAN_SIDFC_FLSSA_Pos)           /*!< 0x0000FFFC */
#define FDCAN_SIDFC_FLSSA         FDCAN_SIDFC_FLSSA_Msk                        /*!<Filter List Standard Start Address        */
#define FDCAN_SIDFC_LSS_Pos       (16U)
#define FDCAN_SIDFC_LSS_Msk       (0xFFU << FDCAN_SIDFC_LSS_Pos)               /*!< 0x00FF0000 */
#define FDCAN_SIDFC_LSS           FDCAN_SIDFC_LSS_Msk                          /*!<List Size Standard                        */

/*****************  Bit definition for FDCAN_XIDFC register  ********************/
#define FDCAN_XIDFC_FLESA_Pos     (2U)
#define FDCAN_XIDFC_FLESA_Msk     (0x3FFFU << FDCAN_XIDFC_FLESA_Pos)           /*!< 0x0000FFFC */
#define FDCAN_XIDFC_FLESA         FDCAN_XIDFC_FLESA_Msk                        /*!<Filter List Standard Start Address        */
#define FDCAN_XIDFC_LSE_Pos       (16U)
#define FDCAN_XIDFC_LSE_Msk       (0xFFU << FDCAN_XIDFC_LSE_Pos)               /*!< 0x00FF0000 */
#define FDCAN_XIDFC_LSE           FDCAN_XIDFC_LSE_Msk                          /*!<List Size Extended                        */

/*****************  Bit definition for FDCAN_XIDAM register  ********************/
#define FDCAN_XIDAM_EIDM_Pos      (0U)
#define FDCAN_XIDAM_EIDM_Msk      (0x1FFFFFFFU << FDCAN_XIDAM_EIDM_Pos)        /*!< 0x1FFFFFFF */
#define FDCAN_XIDAM_EIDM          FDCAN_XIDAM_EIDM_Msk                         /*!<Extended ID Mask                          */

/*****************  Bit definition for FDCAN_HPMS register  *********************/
#define FDCAN_HPMS_BIDX_Pos       (0U)
#define FDCAN_HPMS_BIDX_Msk       (0x3FU << FDCAN_HPMS_BIDX_Pos)               /*!< 0x0000003F */
#define FDCAN_HPMS_BIDX           FDCAN_HPMS_BIDX_Msk                          /*!<Buffer Index                              */
#define FDCAN_HPMS_MSI_Pos        (6U)
#define FDCAN_HPMS_MSI_Msk        (0x3U << FDCAN_HPMS_MSI_Pos)                 /*!< 0x000000C0 */
#define FDCAN_HPMS_MSI            FDCAN_HPMS_MSI_Msk                           /*!<Message Storage Indicator                 */
#define FDCAN_HPMS_FIDX_Pos       (8U)
#define FDCAN_HPMS_FIDX_Msk       (0x7FU << FDCAN_HPMS_FIDX_Pos)               /*!< 0x00007F00 */
#define FDCAN_HPMS_FIDX           FDCAN_HPMS_FIDX_Msk                          /*!<Filter Index                              */
#define FDCAN_HPMS_FLST_Pos       (15U)
#define FDCAN_HPMS_FLST_Msk       (0x1U << FDCAN_HPMS_FLST_Pos)                /*!< 0x00008000 */
#define FDCAN_HPMS_FLST           FDCAN_HPMS_FLST_Msk                          /*!<Filter List                               */

/*****************  Bit definition for FDCAN_NDAT1 register  ********************/
#define FDCAN_NDAT1_ND0_Pos       (0U)
#define FDCAN_NDAT1_ND0_Msk       (0x1U << FDCAN_NDAT1_ND0_Pos)                /*!< 0x00000001 */
#define FDCAN_NDAT1_ND0           FDCAN_NDAT1_ND0_Msk                          /*!<New Data flag of Rx Buffer 0              */
#define FDCAN_NDAT1_ND1_Pos       (1U)
#define FDCAN_NDAT1_ND1_Msk       (0x1U << FDCAN_NDAT1_ND1_Pos)                /*!< 0x00000002 */
#define FDCAN_NDAT1_ND1           FDCAN_NDAT1_ND1_Msk                          /*!<New Data flag of Rx Buffer 1              */
#define FDCAN_NDAT1_ND2_Pos       (2U)
#define FDCAN_NDAT1_ND2_Msk       (0x1U << FDCAN_NDAT1_ND2_Pos)                /*!< 0x00000004 */
#define FDCAN_NDAT1_ND2           FDCAN_NDAT1_ND2_Msk                          /*!<New Data flag of Rx Buffer 2              */
#define FDCAN_NDAT1_ND3_Pos       (3U)
#define FDCAN_NDAT1_ND3_Msk       (0x1U << FDCAN_NDAT1_ND3_Pos)                /*!< 0x00000008 */
#define FDCAN_NDAT1_ND3           FDCAN_NDAT1_ND3_Msk                          /*!<New Data flag of Rx Buffer 3              */
#define FDCAN_NDAT1_ND4_Pos       (4U)
#define FDCAN_NDAT1_ND4_Msk       (0x1U << FDCAN_NDAT1_ND4_Pos)                /*!< 0x00000010 */
#define FDCAN_NDAT1_ND4           FDCAN_NDAT1_ND4_Msk                          /*!<New Data flag of Rx Buffer 4              */
#define FDCAN_NDAT1_ND5_Pos       (5U)
#define FDCAN_NDAT1_ND5_Msk       (0x1U << FDCAN_NDAT1_ND5_Pos)                /*!< 0x00000020 */
#define FDCAN_NDAT1_ND5           FDCAN_NDAT1_ND5_Msk                          /*!<New Data flag of Rx Buffer 5              */
#define FDCAN_NDAT1_ND6_Pos       (6U)
#define FDCAN_NDAT1_ND6_Msk       (0x1U << FDCAN_NDAT1_ND6_Pos)                /*!< 0x00000040 */
#define FDCAN_NDAT1_ND6           FDCAN_NDAT1_ND6_Msk                          /*!<New Data flag of Rx Buffer 6              */
#define FDCAN_NDAT1_ND7_Pos       (7U)
#define FDCAN_NDAT1_ND7_Msk       (0x1U << FDCAN_NDAT1_ND7_Pos)                /*!< 0x00000080 */
#define FDCAN_NDAT1_ND7           FDCAN_NDAT1_ND7_Msk                          /*!<New Data flag of Rx Buffer 7              */
#define FDCAN_NDAT1_ND8_Pos       (8U)
#define FDCAN_NDAT1_ND8_Msk       (0x1U << FDCAN_NDAT1_ND8_Pos)                /*!< 0x00000100 */
#define FDCAN_NDAT1_ND8           FDCAN_NDAT1_ND8_Msk                          /*!<New Data flag of Rx Buffer 8              */
#define FDCAN_NDAT1_ND9_Pos       (9U)
#define FDCAN_NDAT1_ND9_Msk       (0x1U << FDCAN_NDAT1_ND9_Pos)                /*!< 0x00000200 */
#define FDCAN_NDAT1_ND9           FDCAN_NDAT1_ND9_Msk                          /*!<New Data flag of Rx Buffer 9              */
#define FDCAN_NDAT1_ND10_Pos      (10U)
#define FDCAN_NDAT1_ND10_Msk      (0x1U << FDCAN_NDAT1_ND10_Pos)               /*!< 0x00000400 */
#define FDCAN_NDAT1_ND10          FDCAN_NDAT1_ND10_Msk                         /*!<New Data flag of Rx Buffer 10             */
#define FDCAN_NDAT1_ND11_Pos      (11U)
#define FDCAN_NDAT1_ND11_Msk      (0x1U << FDCAN_NDAT1_ND11_Pos)               /*!< 0x00000800 */
#define FDCAN_NDAT1_ND11          FDCAN_NDAT1_ND11_Msk                         /*!<New Data flag of Rx Buffer 11             */
#define FDCAN_NDAT1_ND12_Pos      (12U)
#define FDCAN_NDAT1_ND12_Msk      (0x1U << FDCAN_NDAT1_ND12_Pos)               /*!< 0x00001000 */
#define FDCAN_NDAT1_ND12          FDCAN_NDAT1_ND12_Msk                         /*!<New Data flag of Rx Buffer 12             */
#define FDCAN_NDAT1_ND13_Pos      (13U)
#define FDCAN_NDAT1_ND13_Msk      (0x1U << FDCAN_NDAT1_ND13_Pos)               /*!< 0x00002000 */
#define FDCAN_NDAT1_ND13          FDCAN_NDAT1_ND13_Msk                         /*!<New Data flag of Rx Buffer 13             */
#define FDCAN_NDAT1_ND14_Pos      (14U)
#define FDCAN_NDAT1_ND14_Msk      (0x1U << FDCAN_NDAT1_ND14_Pos)               /*!< 0x00004000 */
#define FDCAN_NDAT1_ND14          FDCAN_NDAT1_ND14_Msk                         /*!<New Data flag of Rx Buffer 14             */
#define FDCAN_NDAT1_ND15_Pos      (15U)
#define FDCAN_NDAT1_ND15_Msk      (0x1U << FDCAN_NDAT1_ND15_Pos)               /*!< 0x00008000 */
#define FDCAN_NDAT1_ND15          FDCAN_NDAT1_ND15_Msk                         /*!<New Data flag of Rx Buffer 15             */
#define FDCAN_NDAT1_ND16_Pos      (16U)
#define FDCAN_NDAT1_ND16_Msk      (0x1U << FDCAN_NDAT1_ND16_Pos)               /*!< 0x00010000 */
#define FDCAN_NDAT1_ND16          FDCAN_NDAT1_ND16_Msk                         /*!<New Data flag of Rx Buffer 16             */
#define FDCAN_NDAT1_ND17_Pos      (17U)
#define FDCAN_NDAT1_ND17_Msk      (0x1U << FDCAN_NDAT1_ND17_Pos)               /*!< 0x00020000 */
#define FDCAN_NDAT1_ND17          FDCAN_NDAT1_ND17_Msk                         /*!<New Data flag of Rx Buffer 17             */
#define FDCAN_NDAT1_ND18_Pos      (18U)
#define FDCAN_NDAT1_ND18_Msk      (0x1U << FDCAN_NDAT1_ND18_Pos)               /*!< 0x00040000 */
#define FDCAN_NDAT1_ND18          FDCAN_NDAT1_ND18_Msk                         /*!<New Data flag of Rx Buffer 18             */
#define FDCAN_NDAT1_ND19_Pos      (19U)
#define FDCAN_NDAT1_ND19_Msk      (0x1U << FDCAN_NDAT1_ND19_Pos)               /*!< 0x00080000 */
#define FDCAN_NDAT1_ND19          FDCAN_NDAT1_ND19_Msk                         /*!<New Data flag of Rx Buffer 19             */
#define FDCAN_NDAT1_ND20_Pos      (20U)
#define FDCAN_NDAT1_ND20_Msk      (0x1U << FDCAN_NDAT1_ND20_Pos)               /*!< 0x00100000 */
#define FDCAN_NDAT1_ND20          FDCAN_NDAT1_ND20_Msk                         /*!<New Data flag of Rx Buffer 20             */
#define FDCAN_NDAT1_ND21_Pos      (21U)
#define FDCAN_NDAT1_ND21_Msk      (0x1U << FDCAN_NDAT1_ND21_Pos)               /*!< 0x00200000 */
#define FDCAN_NDAT1_ND21          FDCAN_NDAT1_ND21_Msk                         /*!<New Data flag of Rx Buffer 21             */
#define FDCAN_NDAT1_ND22_Pos      (22U)
#define FDCAN_NDAT1_ND22_Msk      (0x1U << FDCAN_NDAT1_ND22_Pos)               /*!< 0x00400000 */
#define FDCAN_NDAT1_ND22          FDCAN_NDAT1_ND22_Msk                         /*!<New Data flag of Rx Buffer 22             */
#define FDCAN_NDAT1_ND23_Pos      (23U)
#define FDCAN_NDAT1_ND23_Msk      (0x1U << FDCAN_NDAT1_ND23_Pos)               /*!< 0x00800000 */
#define FDCAN_NDAT1_ND23          FDCAN_NDAT1_ND23_Msk                         /*!<New Data flag of Rx Buffer 23             */
#define FDCAN_NDAT1_ND24_Pos      (24U)
#define FDCAN_NDAT1_ND24_Msk      (0x1U << FDCAN_NDAT1_ND24_Pos)               /*!< 0x01000000 */
#define FDCAN_NDAT1_ND24          FDCAN_NDAT1_ND24_Msk                         /*!<New Data flag of Rx Buffer 24             */
#define FDCAN_NDAT1_ND25_Pos      (25U)
#define FDCAN_NDAT1_ND25_Msk      (0x1U << FDCAN_NDAT1_ND25_Pos)               /*!< 0x02000000 */
#define FDCAN_NDAT1_ND25          FDCAN_NDAT1_ND25_Msk                         /*!<New Data flag of Rx Buffer 25             */
#define FDCAN_NDAT1_ND26_Pos      (26U)
#define FDCAN_NDAT1_ND26_Msk      (0x1U << FDCAN_NDAT1_ND26_Pos)               /*!< 0x04000000 */
#define FDCAN_NDAT1_ND26          FDCAN_NDAT1_ND26_Msk                         /*!<New Data flag of Rx Buffer 26             */
#define FDCAN_NDAT1_ND27_Pos      (27U)
#define FDCAN_NDAT1_ND27_Msk      (0x1U << FDCAN_NDAT1_ND27_Pos)               /*!< 0x08000000 */
#define FDCAN_NDAT1_ND27          FDCAN_NDAT1_ND27_Msk                         /*!<New Data flag of Rx Buffer 27             */
#define FDCAN_NDAT1_ND28_Pos      (28U)
#define FDCAN_NDAT1_ND28_Msk      (0x1U << FDCAN_NDAT1_ND28_Pos)               /*!< 0x10000000 */
#define FDCAN_NDAT1_ND28          FDCAN_NDAT1_ND28_Msk                         /*!<New Data flag of Rx Buffer 28             */
#define FDCAN_NDAT1_ND29_Pos      (29U)
#define FDCAN_NDAT1_ND29_Msk      (0x1U << FDCAN_NDAT1_ND29_Pos)               /*!< 0x20000000 */
#define FDCAN_NDAT1_ND29          FDCAN_NDAT1_ND29_Msk                         /*!<New Data flag of Rx Buffer 29             */
#define FDCAN_NDAT1_ND30_Pos      (30U)
#define FDCAN_NDAT1_ND30_Msk      (0x1U << FDCAN_NDAT1_ND30_Pos)               /*!< 0x40000000 */
#define FDCAN_NDAT1_ND30          FDCAN_NDAT1_ND30_Msk                         /*!<New Data flag of Rx Buffer 30             */
#define FDCAN_NDAT1_ND31_Pos      (31U)
#define FDCAN_NDAT1_ND31_Msk      (0x1U << FDCAN_NDAT1_ND31_Pos)               /*!< 0x80000000 */
#define FDCAN_NDAT1_ND31          FDCAN_NDAT1_ND31_Msk                         /*!<New Data flag of Rx Buffer 31             */

/*****************  Bit definition for FDCAN_NDAT2 register  ********************/
#define FDCAN_NDAT2_ND32_Pos      (0U)
#define FDCAN_NDAT2_ND32_Msk      (0x1U << FDCAN_NDAT2_ND32_Pos)               /*!< 0x00000001 */
#define FDCAN_NDAT2_ND32          FDCAN_NDAT2_ND32_Msk                         /*!<New Data flag of Rx Buffer 32             */
#define FDCAN_NDAT2_ND33_Pos      (1U)
#define FDCAN_NDAT2_ND33_Msk      (0x1U << FDCAN_NDAT2_ND33_Pos)               /*!< 0x00000002 */
#define FDCAN_NDAT2_ND33          FDCAN_NDAT2_ND33_Msk                         /*!<New Data flag of Rx Buffer 33             */
#define FDCAN_NDAT2_ND34_Pos      (2U)
#define FDCAN_NDAT2_ND34_Msk      (0x1U << FDCAN_NDAT2_ND34_Pos)               /*!< 0x00000004 */
#define FDCAN_NDAT2_ND34          FDCAN_NDAT2_ND34_Msk                         /*!<New Data flag of Rx Buffer 34             */
#define FDCAN_NDAT2_ND35_Pos      (3U)
#define FDCAN_NDAT2_ND35_Msk      (0x1U << FDCAN_NDAT2_ND35_Pos)               /*!< 0x00000008 */
#define FDCAN_NDAT2_ND35          FDCAN_NDAT2_ND35_Msk                         /*!<New Data flag of Rx Buffer 35             */
#define FDCAN_NDAT2_ND36_Pos      (4U)
#define FDCAN_NDAT2_ND36_Msk      (0x1U << FDCAN_NDAT2_ND36_Pos)               /*!< 0x00000010 */
#define FDCAN_NDAT2_ND36          FDCAN_NDAT2_ND36_Msk                         /*!<New Data flag of Rx Buffer 36             */
#define FDCAN_NDAT2_ND37_Pos      (5U)
#define FDCAN_NDAT2_ND37_Msk      (0x1U << FDCAN_NDAT2_ND37_Pos)               /*!< 0x00000020 */
#define FDCAN_NDAT2_ND37          FDCAN_NDAT2_ND37_Msk                         /*!<New Data flag of Rx Buffer 37             */
#define FDCAN_NDAT2_ND38_Pos      (6U)
#define FDCAN_NDAT2_ND38_Msk      (0x1U << FDCAN_NDAT2_ND38_Pos)               /*!< 0x00000040 */
#define FDCAN_NDAT2_ND38          FDCAN_NDAT2_ND38_Msk                         /*!<New Data flag of Rx Buffer 38             */
#define FDCAN_NDAT2_ND39_Pos      (7U)
#define FDCAN_NDAT2_ND39_Msk      (0x1U << FDCAN_NDAT2_ND39_Pos)               /*!< 0x00000080 */
#define FDCAN_NDAT2_ND39          FDCAN_NDAT2_ND39_Msk                         /*!<New Data flag of Rx Buffer 39             */
#define FDCAN_NDAT2_ND40_Pos      (8U)
#define FDCAN_NDAT2_ND40_Msk      (0x1U << FDCAN_NDAT2_ND40_Pos)               /*!< 0x00000100 */
#define FDCAN_NDAT2_ND40          FDCAN_NDAT2_ND40_Msk                         /*!<New Data flag of Rx Buffer 40             */
#define FDCAN_NDAT2_ND41_Pos      (9U)
#define FDCAN_NDAT2_ND41_Msk      (0x1U << FDCAN_NDAT2_ND41_Pos)               /*!< 0x00000200 */
#define FDCAN_NDAT2_ND41          FDCAN_NDAT2_ND41_Msk                         /*!<New Data flag of Rx Buffer 41             */
#define FDCAN_NDAT2_ND42_Pos      (10U)
#define FDCAN_NDAT2_ND42_Msk      (0x1U << FDCAN_NDAT2_ND42_Pos)               /*!< 0x00000400 */
#define FDCAN_NDAT2_ND42          FDCAN_NDAT2_ND42_Msk                         /*!<New Data flag of Rx Buffer 42             */
#define FDCAN_NDAT2_ND43_Pos      (11U)
#define FDCAN_NDAT2_ND43_Msk      (0x1U << FDCAN_NDAT2_ND43_Pos)               /*!< 0x00000800 */
#define FDCAN_NDAT2_ND43          FDCAN_NDAT2_ND43_Msk                         /*!<New Data flag of Rx Buffer 43             */
#define FDCAN_NDAT2_ND44_Pos      (12U)
#define FDCAN_NDAT2_ND44_Msk      (0x1U << FDCAN_NDAT2_ND44_Pos)               /*!< 0x00001000 */
#define FDCAN_NDAT2_ND44          FDCAN_NDAT2_ND44_Msk                         /*!<New Data flag of Rx Buffer 44             */
#define FDCAN_NDAT2_ND45_Pos      (13U)
#define FDCAN_NDAT2_ND45_Msk      (0x1U << FDCAN_NDAT2_ND45_Pos)               /*!< 0x00002000 */
#define FDCAN_NDAT2_ND45          FDCAN_NDAT2_ND45_Msk                         /*!<New Data flag of Rx Buffer 45             */
#define FDCAN_NDAT2_ND46_Pos      (14U)
#define FDCAN_NDAT2_ND46_Msk      (0x1U << FDCAN_NDAT2_ND46_Pos)               /*!< 0x00004000 */
#define FDCAN_NDAT2_ND46          FDCAN_NDAT2_ND46_Msk                         /*!<New Data flag of Rx Buffer 46             */
#define FDCAN_NDAT2_ND47_Pos      (15U)
#define FDCAN_NDAT2_ND47_Msk      (0x1U << FDCAN_NDAT2_ND47_Pos)               /*!< 0x00008000 */
#define FDCAN_NDAT2_ND47          FDCAN_NDAT2_ND47_Msk                         /*!<New Data flag of Rx Buffer 47             */
#define FDCAN_NDAT2_ND48_Pos      (16U)
#define FDCAN_NDAT2_ND48_Msk      (0x1U << FDCAN_NDAT2_ND48_Pos)               /*!< 0x00010000 */
#define FDCAN_NDAT2_ND48          FDCAN_NDAT2_ND48_Msk                         /*!<New Data flag of Rx Buffer 48             */
#define FDCAN_NDAT2_ND49_Pos      (17U)
#define FDCAN_NDAT2_ND49_Msk      (0x1U << FDCAN_NDAT2_ND49_Pos)               /*!< 0x00020000 */
#define FDCAN_NDAT2_ND49          FDCAN_NDAT2_ND49_Msk                         /*!<New Data flag of Rx Buffer 49             */
#define FDCAN_NDAT2_ND50_Pos      (18U)
#define FDCAN_NDAT2_ND50_Msk      (0x1U << FDCAN_NDAT2_ND50_Pos)               /*!< 0x00040000 */
#define FDCAN_NDAT2_ND50          FDCAN_NDAT2_ND50_Msk                         /*!<New Data flag of Rx Buffer 50             */
#define FDCAN_NDAT2_ND51_Pos      (19U)
#define FDCAN_NDAT2_ND51_Msk      (0x1U << FDCAN_NDAT2_ND51_Pos)               /*!< 0x00080000 */
#define FDCAN_NDAT2_ND51          FDCAN_NDAT2_ND51_Msk                         /*!<New Data flag of Rx Buffer 51             */
#define FDCAN_NDAT2_ND52_Pos      (20U)
#define FDCAN_NDAT2_ND52_Msk      (0x1U << FDCAN_NDAT2_ND52_Pos)               /*!< 0x00100000 */
#define FDCAN_NDAT2_ND52          FDCAN_NDAT2_ND52_Msk                         /*!<New Data flag of Rx Buffer 52             */
#define FDCAN_NDAT2_ND53_Pos      (21U)
#define FDCAN_NDAT2_ND53_Msk      (0x1U << FDCAN_NDAT2_ND53_Pos)               /*!< 0x00200000 */
#define FDCAN_NDAT2_ND53          FDCAN_NDAT2_ND53_Msk                         /*!<New Data flag of Rx Buffer 53             */
#define FDCAN_NDAT2_ND54_Pos      (22U)
#define FDCAN_NDAT2_ND54_Msk      (0x1U << FDCAN_NDAT2_ND54_Pos)               /*!< 0x00400000 */
#define FDCAN_NDAT2_ND54          FDCAN_NDAT2_ND54_Msk                         /*!<New Data flag of Rx Buffer 54             */
#define FDCAN_NDAT2_ND55_Pos      (23U)
#define FDCAN_NDAT2_ND55_Msk      (0x1U << FDCAN_NDAT2_ND55_Pos)               /*!< 0x00800000 */
#define FDCAN_NDAT2_ND55          FDCAN_NDAT2_ND55_Msk                         /*!<New Data flag of Rx Buffer 55             */
#define FDCAN_NDAT2_ND56_Pos      (24U)
#define FDCAN_NDAT2_ND56_Msk      (0x1U << FDCAN_NDAT2_ND56_Pos)               /*!< 0x01000000 */
#define FDCAN_NDAT2_ND56          FDCAN_NDAT2_ND56_Msk                         /*!<New Data flag of Rx Buffer 56             */
#define FDCAN_NDAT2_ND57_Pos      (25U)
#define FDCAN_NDAT2_ND57_Msk      (0x1U << FDCAN_NDAT2_ND57_Pos)               /*!< 0x02000000 */
#define FDCAN_NDAT2_ND57          FDCAN_NDAT2_ND57_Msk                         /*!<New Data flag of Rx Buffer 57             */
#define FDCAN_NDAT2_ND58_Pos      (26U)
#define FDCAN_NDAT2_ND58_Msk      (0x1U << FDCAN_NDAT2_ND58_Pos)               /*!< 0x04000000 */
#define FDCAN_NDAT2_ND58          FDCAN_NDAT2_ND58_Msk                         /*!<New Data flag of Rx Buffer 58             */
#define FDCAN_NDAT2_ND59_Pos      (27U)
#define FDCAN_NDAT2_ND59_Msk      (0x1U << FDCAN_NDAT2_ND59_Pos)               /*!< 0x08000000 */
#define FDCAN_NDAT2_ND59          FDCAN_NDAT2_ND59_Msk                         /*!<New Data flag of Rx Buffer 59             */
#define FDCAN_NDAT2_ND60_Pos      (28U)
#define FDCAN_NDAT2_ND60_Msk      (0x1U << FDCAN_NDAT2_ND60_Pos)               /*!< 0x10000000 */
#define FDCAN_NDAT2_ND60          FDCAN_NDAT2_ND60_Msk                         /*!<New Data flag of Rx Buffer 60             */
#define FDCAN_NDAT2_ND61_Pos      (29U)
#define FDCAN_NDAT2_ND61_Msk      (0x1U << FDCAN_NDAT2_ND61_Pos)               /*!< 0x20000000 */
#define FDCAN_NDAT2_ND61          FDCAN_NDAT2_ND61_Msk                         /*!<New Data flag of Rx Buffer 61             */
#define FDCAN_NDAT2_ND62_Pos      (30U)
#define FDCAN_NDAT2_ND62_Msk      (0x1U << FDCAN_NDAT2_ND62_Pos)               /*!< 0x40000000 */
#define FDCAN_NDAT2_ND62          FDCAN_NDAT2_ND62_Msk                         /*!<New Data flag of Rx Buffer 62             */
#define FDCAN_NDAT2_ND63_Pos      (31U)
#define FDCAN_NDAT2_ND63_Msk      (0x1U << FDCAN_NDAT2_ND63_Pos)               /*!< 0x80000000 */
#define FDCAN_NDAT2_ND63          FDCAN_NDAT2_ND63_Msk                         /*!<New Data flag of Rx Buffer 63             */

/*****************  Bit definition for FDCAN_RXF0C register  ********************/
#define FDCAN_RXF0C_F0SA_Pos      (2U)
#define FDCAN_RXF0C_F0SA_Msk      (0x3FFFU << FDCAN_RXF0C_F0SA_Pos)            /*!< 0x0000FFFC */
#define FDCAN_RXF0C_F0SA          FDCAN_RXF0C_F0SA_Msk                         /*!<Rx FIFO 0 Start Address                   */
#define FDCAN_RXF0C_F0S_Pos       (16U)
#define FDCAN_RXF0C_F0S_Msk       (0x7FU << FDCAN_RXF0C_F0S_Pos)               /*!< 0x007F0000 */
#define FDCAN_RXF0C_F0S           FDCAN_RXF0C_F0S_Msk                          /*!<Number of Rx FIFO 0 elements              */
#define FDCAN_RXF0C_F0WM_Pos      (24U)
#define FDCAN_RXF0C_F0WM_Msk      (0x7FU << FDCAN_RXF0C_F0WM_Pos)              /*!< 0x7F000000 */
#define FDCAN_RXF0C_F0WM          FDCAN_RXF0C_F0WM_Msk                         /*!<FIFO 0 Watermark                          */
#define FDCAN_RXF0C_F0OM_Pos      (31U)
#define FDCAN_RXF0C_F0OM_Msk      (0x1U << FDCAN_RXF0C_F0OM_Pos)               /*!< 0x80000000 */
#define FDCAN_RXF0C_F0OM          FDCAN_RXF0C_F0OM_Msk                         /*!<FIFO 0 Operation Mode                     */

/*****************  Bit definition for FDCAN_RXF0S register  ********************/
#define FDCAN_RXF0S_F0FL_Pos      (0U)
#define FDCAN_RXF0S_F0FL_Msk      (0x7FU << FDCAN_RXF0S_F0FL_Pos)              /*!< 0x0000007F */
#define FDCAN_RXF0S_F0FL          FDCAN_RXF0S_F0FL_Msk                         /*!<Rx FIFO 0 Fill Level                      */
#define FDCAN_RXF0S_F0GI_Pos      (8U)
#define FDCAN_RXF0S_F0GI_Msk      (0x3FU << FDCAN_RXF0S_F0GI_Pos)              /*!< 0x00003F00 */
#define FDCAN_RXF0S_F0GI          FDCAN_RXF0S_F0GI_Msk                         /*!<Rx FIFO 0 Get Index                       */
#define FDCAN_RXF0S_F0PI_Pos      (16U)
#define FDCAN_RXF0S_F0PI_Msk      (0x3FU << FDCAN_RXF0S_F0PI_Pos)              /*!< 0x003F0000 */
#define FDCAN_RXF0S_F0PI          FDCAN_RXF0S_F0PI_Msk                         /*!<Rx FIFO 0 Put Index                       */
#define FDCAN_RXF0S_F0F_Pos       (24U)
#define FDCAN_RXF0S_F0F_Msk       (0x1U << FDCAN_RXF0S_F0F_Pos)                /*!< 0x01000000 */
#define FDCAN_RXF0S_F0F           FDCAN_RXF0S_F0F_Msk                          /*!<Rx FIFO 0 Full                            */
#define FDCAN_RXF0S_RF0L_Pos      (25U)
#define FDCAN_RXF0S_RF0L_Msk      (0x1U << FDCAN_RXF0S_RF0L_Pos)               /*!< 0x02000000 */
#define FDCAN_RXF0S_RF0L          FDCAN_RXF0S_RF0L_Msk                         /*!<Rx FIFO 0 Message Lost                    */

/*****************  Bit definition for FDCAN_RXF0A register  ********************/
#define FDCAN_RXF0A_F0AI_Pos      (0U)
#define FDCAN_RXF0A_F0AI_Msk      (0x3FU << FDCAN_RXF0A_F0AI_Pos)              /*!< 0x0000003F */
#define FDCAN_RXF0A_F0AI          FDCAN_RXF0A_F0AI_Msk                         /*!<Rx FIFO 0 Acknowledge Index               */

/*****************  Bit definition for FDCAN_RXBC register  ********************/
#define FDCAN_RXBC_RBSA_Pos       (2U)
#define FDCAN_RXBC_RBSA_Msk       (0x3FFFU << FDCAN_RXBC_RBSA_Pos)             /*!< 0x0000FFFC */
#define FDCAN_RXBC_RBSA           FDCAN_RXBC_RBSA_Msk                          /*!<Rx Buffer Start Address                   */

/*****************  Bit definition for FDCAN_RXF1C register  ********************/
#define FDCAN_RXF1C_F1SA_Pos      (2U)
#define FDCAN_RXF1C_F1SA_Msk      (0x3FFFU << FDCAN_RXF1C_F1SA_Pos)            /*!< 0x0000FFFC */
#define FDCAN_RXF1C_F1SA          FDCAN_RXF1C_F1SA_Msk                         /*!<Rx FIFO 1 Start Address                   */
#define FDCAN_RXF1C_F1S_Pos       (16U)
#define FDCAN_RXF1C_F1S_Msk       (0x7FU << FDCAN_RXF1C_F1S_Pos)               /*!< 0x007F0000 */
#define FDCAN_RXF1C_F1S           FDCAN_RXF1C_F1S_Msk                          /*!<Number of Rx FIFO 1 elements              */
#define FDCAN_RXF1C_F1WM_Pos      (24U)
#define FDCAN_RXF1C_F1WM_Msk      (0x7FU << FDCAN_RXF1C_F1WM_Pos)              /*!< 0x7F000000 */
#define FDCAN_RXF1C_F1WM          FDCAN_RXF1C_F1WM_Msk                         /*!<Rx FIFO 1 Watermark                       */
#define FDCAN_RXF1C_F1OM_Pos      (31U)
#define FDCAN_RXF1C_F1OM_Msk      (0x1U << FDCAN_RXF1C_F1OM_Pos)               /*!< 0x80000000 */
#define FDCAN_RXF1C_F1OM          FDCAN_RXF1C_F1OM_Msk                         /*!<FIFO 1 Operation Mode                     */

/*****************  Bit definition for FDCAN_RXF1S register  ********************/
#define FDCAN_RXF1S_F1FL_Pos      (0U)
#define FDCAN_RXF1S_F1FL_Msk      (0x7FU << FDCAN_RXF1S_F1FL_Pos)              /*!< 0x0000007F */
#define FDCAN_RXF1S_F1FL          FDCAN_RXF1S_F1FL_Msk                         /*!<Rx FIFO 1 Fill Level                      */
#define FDCAN_RXF1S_F1GI_Pos      (8U)
#define FDCAN_RXF1S_F1GI_Msk      (0x3FU << FDCAN_RXF1S_F1GI_Pos)              /*!< 0x00003F00 */
#define FDCAN_RXF1S_F1GI          FDCAN_RXF1S_F1GI_Msk                         /*!<Rx FIFO 1 Get Index                       */
#define FDCAN_RXF1S_F1PI_Pos      (16U)
#define FDCAN_RXF1S_F1PI_Msk      (0x3FU << FDCAN_RXF1S_F1PI_Pos)              /*!< 0x003F0000 */
#define FDCAN_RXF1S_F1PI          FDCAN_RXF1S_F1PI_Msk                         /*!<Rx FIFO 1 Put Index                       */
#define FDCAN_RXF1S_F1F_Pos       (24U)
#define FDCAN_RXF1S_F1F_Msk       (0x1U << FDCAN_RXF1S_F1F_Pos)                /*!< 0x01000000 */
#define FDCAN_RXF1S_F1F           FDCAN_RXF1S_F1F_Msk                          /*!<Rx FIFO 1 Full                            */
#define FDCAN_RXF1S_RF1L_Pos      (25U)
#define FDCAN_RXF1S_RF1L_Msk      (0x1U << FDCAN_RXF1S_RF1L_Pos)               /*!< 0x02000000 */
#define FDCAN_RXF1S_RF1L          FDCAN_RXF1S_RF1L_Msk                         /*!<Rx FIFO 1 Message Lost                    */
#define FDCAN_RXF1S_DMS_Pos       (30U)
#define FDCAN_RXF1S_DMS_Msk       (0x3U << FDCAN_RXF1S_DMS_Pos)                /*!< 0xC0000000 */
#define FDCAN_RXF1S_DMS           FDCAN_RXF1S_DMS_Msk                          /*!<Debug Message Status                      */

/*****************  Bit definition for FDCAN_RXF1A register  ********************/
#define FDCAN_RXF1A_F1AI_Pos      (0U)
#define FDCAN_RXF1A_F1AI_Msk      (0x3FU << FDCAN_RXF1A_F1AI_Pos)              /*!< 0x0000003F */
#define FDCAN_RXF1A_F1AI          FDCAN_RXF1A_F1AI_Msk                         /*!<Rx FIFO 1 Acknowledge Index               */

/*****************  Bit definition for FDCAN_RXESC register  ********************/
#define FDCAN_RXESC_F0DS_Pos      (0U)
#define FDCAN_RXESC_F0DS_Msk      (0x7U << FDCAN_RXESC_F0DS_Pos)               /*!< 0x00000007 */
#define FDCAN_RXESC_F0DS          FDCAN_RXESC_F0DS_Msk                         /*!<Rx FIFO 1 Data Field Size                 */
#define FDCAN_RXESC_F1DS_Pos      (4U)
#define FDCAN_RXESC_F1DS_Msk      (0x7U << FDCAN_RXESC_F1DS_Pos)               /*!< 0x00000070 */
#define FDCAN_RXESC_F1DS          FDCAN_RXESC_F1DS_Msk                         /*!<Rx FIFO 0 Data Field Size                 */
#define FDCAN_RXESC_RBDS_Pos      (8U)
#define FDCAN_RXESC_RBDS_Msk      (0x7U << FDCAN_RXESC_RBDS_Pos)               /*!< 0x00000700 */
#define FDCAN_RXESC_RBDS          FDCAN_RXESC_RBDS_Msk                         /*!<Rx Buffer Data Field Size                 */

/*****************  Bit definition for FDCAN_TXBC register  *********************/
#define FDCAN_TXBC_TBSA_Pos       (2U)
#define FDCAN_TXBC_TBSA_Msk       (0x3FFFU << FDCAN_TXBC_TBSA_Pos)             /*!< 0x000000FC */
#define FDCAN_TXBC_TBSA           FDCAN_TXBC_TBSA_Msk                          /*!<Tx Buffers Start Address                  */
#define FDCAN_TXBC_NDTB_Pos       (16U)
#define FDCAN_TXBC_NDTB_Msk       (0x3FU << FDCAN_TXBC_NDTB_Pos)               /*!< 0x003F0000 */
#define FDCAN_TXBC_NDTB           FDCAN_TXBC_NDTB_Msk                          /*!<Number of Dedicated Transmit Buffers      */
#define FDCAN_TXBC_TFQS_Pos       (24U)
#define FDCAN_TXBC_TFQS_Msk       (0x3FU << FDCAN_TXBC_TFQS_Pos)               /*!< 0x3F000000 */
#define FDCAN_TXBC_TFQS           FDCAN_TXBC_TFQS_Msk                          /*!<Transmit FIFO/Queue Size                  */
#define FDCAN_TXBC_TFQM_Pos       (30U)
#define FDCAN_TXBC_TFQM_Msk       (0x1U << FDCAN_TXBC_TFQM_Pos)                /*!< 0x40000000 */
#define FDCAN_TXBC_TFQM           FDCAN_TXBC_TFQM_Msk                          /*!<Tx FIFO/Queue Mode                        */

/*****************  Bit definition for FDCAN_TXFQS register  *********************/
#define FDCAN_TXFQS_TFFL_Pos      (0U)
#define FDCAN_TXFQS_TFFL_Msk      (0x3FU << FDCAN_TXFQS_TFFL_Pos)              /*!< 0x0000003F */
#define FDCAN_TXFQS_TFFL          FDCAN_TXFQS_TFFL_Msk                         /*!<Tx FIFO Free Level                        */
#define FDCAN_TXFQS_TFGI_Pos      (8U)
#define FDCAN_TXFQS_TFGI_Msk      (0x1FU << FDCAN_TXFQS_TFGI_Pos)              /*!< 0x00001F00 */
#define FDCAN_TXFQS_TFGI          FDCAN_TXFQS_TFGI_Msk                         /*!<Tx FIFO Get Index                         */
#define FDCAN_TXFQS_TFQPI_Pos     (16U)
#define FDCAN_TXFQS_TFQPI_Msk     (0x1FU << FDCAN_TXFQS_TFQPI_Pos)             /*!< 0x001F0000 */
#define FDCAN_TXFQS_TFQPI         FDCAN_TXFQS_TFQPI_Msk                        /*!<Tx FIFO/Queue Put Index                   */
#define FDCAN_TXFQS_TFQF_Pos      (21U)
#define FDCAN_TXFQS_TFQF_Msk      (0x1U << FDCAN_TXFQS_TFQF_Pos)               /*!< 0x00200000 */
#define FDCAN_TXFQS_TFQF          FDCAN_TXFQS_TFQF_Msk                         /*!<Tx FIFO/Queue Full                        */

/*****************  Bit definition for FDCAN_TXESC register  *********************/
#define FDCAN_TXESC_TBDS_Pos      (0U)
#define FDCAN_TXESC_TBDS_Msk      (0x7U << FDCAN_TXESC_TBDS_Pos)               /*!< 0x00000007 */
#define FDCAN_TXESC_TBDS          FDCAN_TXESC_TBDS_Msk                         /*!<Tx Buffer Data Field Size                 */

/*****************  Bit definition for FDCAN_TXBRP register  *********************/
#define FDCAN_TXBRP_TRP_Pos       (0U)
#define FDCAN_TXBRP_TRP_Msk       (0xFFFFFFFFU << FDCAN_TXBRP_TRP_Pos)         /*!< 0xFFFFFFFF */
#define FDCAN_TXBRP_TRP           FDCAN_TXBRP_TRP_Msk                          /*!<Transmission Request Pending              */

/*****************  Bit definition for FDCAN_TXBAR register  *********************/
#define FDCAN_TXBAR_AR_Pos        (0U)
#define FDCAN_TXBAR_AR_Msk        (0xFFFFFFFFU << FDCAN_TXBAR_AR_Pos)          /*!< 0xFFFFFFFF */
#define FDCAN_TXBAR_AR            FDCAN_TXBAR_AR_Msk                           /*!<Add Request                               */

/*****************  Bit definition for FDCAN_TXBCR register  *********************/
#define FDCAN_TXBCR_CR_Pos        (0U)
#define FDCAN_TXBCR_CR_Msk        (0xFFFFFFFFU << FDCAN_TXBCR_CR_Pos)          /*!< 0xFFFFFFFF */
#define FDCAN_TXBCR_CR            FDCAN_TXBCR_CR_Msk                           /*!<Cancellation Request                      */

/*****************  Bit definition for FDCAN_TXBTO register  *********************/
#define FDCAN_TXBTO_TO_Pos        (0U)
#define FDCAN_TXBTO_TO_Msk        (0xFFFFFFFFU << FDCAN_TXBTO_TO_Pos)          /*!< 0xFFFFFFFF */
#define FDCAN_TXBTO_TO            FDCAN_TXBTO_TO_Msk                           /*!<Transmission Occurred                     */

/*****************  Bit definition for FDCAN_TXBCF register  *********************/
#define FDCAN_TXBCF_CF_Pos        (0U)
#define FDCAN_TXBCF_CF_Msk        (0xFFFFFFFFU << FDCAN_TXBCF_CF_Pos)          /*!< 0xFFFFFFFF */
#define FDCAN_TXBCF_CF            FDCAN_TXBCF_CF_Msk                           /*!<Cancellation Finished                     */

/*****************  Bit definition for FDCAN_TXBTIE register  ********************/
#define FDCAN_TXBTIE_TIE_Pos      (0U)
#define FDCAN_TXBTIE_TIE_Msk      (0xFFFFFFFFU << FDCAN_TXBTIE_TIE_Pos)        /*!< 0xFFFFFFFF */
#define FDCAN_TXBTIE_TIE          FDCAN_TXBTIE_TIE_Msk                         /*!<Transmission Interrupt Enable             */

/*****************  Bit definition for FDCAN_ TXBCIE register  *******************/
#define FDCAN_TXBCIE_CF_Pos       (0U)
#define FDCAN_TXBCIE_CF_Msk       (0xFFFFFFFFU << FDCAN_TXBCIE_CF_Pos)         /*!< 0xFFFFFFFF */
#define FDCAN_TXBCIE_CF           FDCAN_TXBCIE_CF_Msk                          /*!<Cancellation Finished Interrupt Enable    */

/*****************  Bit definition for FDCAN_TXEFC register  *********************/
#define FDCAN_TXEFC_EFSA_Pos      (2U)
#define FDCAN_TXEFC_EFSA_Msk      (0x3FFFU << FDCAN_TXEFC_EFSA_Pos)            /*!< 0x0000FFFC */
#define FDCAN_TXEFC_EFSA          FDCAN_TXEFC_EFSA_Msk                         /*!<Event FIFO Start Address                  */
#define FDCAN_TXEFC_EFS_Pos       (16U)
#define FDCAN_TXEFC_EFS_Msk       (0x3FU << FDCAN_TXEFC_EFS_Pos)               /*!< 0x003F0000 */
#define FDCAN_TXEFC_EFS           FDCAN_TXEFC_EFS_Msk                          /*!<Event FIFO Size                           */
#define FDCAN_TXEFC_EFWM_Pos      (24U)
#define FDCAN_TXEFC_EFWM_Msk      (0x3FU << FDCAN_TXEFC_EFWM_Pos)              /*!< 0x3F000000 */
#define FDCAN_TXEFC_EFWM          FDCAN_TXEFC_EFWM_Msk                         /*!<Event FIFO Watermark                      */

/*****************  Bit definition for FDCAN_TXEFS register  *********************/
#define FDCAN_TXEFS_EFFL_Pos      (0U)
#define FDCAN_TXEFS_EFFL_Msk      (0x3FU << FDCAN_TXEFS_EFFL_Pos)              /*!< 0x0000003F */
#define FDCAN_TXEFS_EFFL          FDCAN_TXEFS_EFFL_Msk                         /*!<Event FIFO Fill Level                     */
#define FDCAN_TXEFS_EFGI_Pos      (8U)
#define FDCAN_TXEFS_EFGI_Msk      (0x1FU << FDCAN_TXEFS_EFGI_Pos)              /*!< 0x00001F00 */
#define FDCAN_TXEFS_EFGI          FDCAN_TXEFS_EFGI_Msk                         /*!<Event FIFO Get Index                      */
#define FDCAN_TXEFS_EFPI_Pos      (16U)
#define FDCAN_TXEFS_EFPI_Msk      (0x1FU << FDCAN_TXEFS_EFPI_Pos)              /*!< 0x001F0000 */
#define FDCAN_TXEFS_EFPI          FDCAN_TXEFS_EFPI_Msk                         /*!<Event FIFO Put Index                      */
#define FDCAN_TXEFS_EFF_Pos       (24U)
#define FDCAN_TXEFS_EFF_Msk       (0x1U << FDCAN_TXEFS_EFF_Pos)                /*!< 0x01000000 */
#define FDCAN_TXEFS_EFF           FDCAN_TXEFS_EFF_Msk                          /*!<Event FIFO Full                           */
#define FDCAN_TXEFS_TEFL_Pos      (25U)
#define FDCAN_TXEFS_TEFL_Msk      (0x1U << FDCAN_TXEFS_TEFL_Pos)               /*!< 0x02000000 */
#define FDCAN_TXEFS_TEFL          FDCAN_TXEFS_TEFL_Msk                         /*!<Tx Event FIFO Element Lost                */

/*****************  Bit definition for FDCAN_TXEFA register  *********************/
#define FDCAN_TXEFA_EFAI_Pos      (0U)
#define FDCAN_TXEFA_EFAI_Msk      (0x1FU << FDCAN_TXEFA_EFAI_Pos)              /*!< 0x0000001F */
#define FDCAN_TXEFA_EFAI          FDCAN_TXEFA_EFAI_Msk                         /*!<Event FIFO Acknowledge Index              */

/*****************  Bit definition for FDCAN_TTTMC register  *********************/
#define FDCAN_TTTMC_TMSA_Pos      (2U)
#define FDCAN_TTTMC_TMSA_Msk      (0x3FFFU << FDCAN_TTTMC_TMSA_Pos)            /*!< 0x0000FFFC */
#define FDCAN_TTTMC_TMSA          FDCAN_TTTMC_TMSA_Msk                         /*!<Trigger Memory Start Address              */
#define FDCAN_TTTMC_TME_Pos       (16U)
#define FDCAN_TTTMC_TME_Msk       (0x7FU << FDCAN_TTTMC_TME_Pos)               /*!< 0x007F0000 */
#define FDCAN_TTTMC_TME           FDCAN_TTTMC_TME_Msk                          /*!<Trigger Memory Elements                   */

/*****************  Bit definition for FDCAN_TTRMC register  *********************/
#define FDCAN_TTRMC_RID_Pos       (0U)
#define FDCAN_TTRMC_RID_Msk       (0x1FFFFFFFU << FDCAN_TTRMC_RID_Pos)         /*!< 0x1FFFFFFF */
#define FDCAN_TTRMC_RID           FDCAN_TTRMC_RID_Msk                          /*!<Reference Identifier                      */
#define FDCAN_TTRMC_XTD_Pos       (30U)
#define FDCAN_TTRMC_XTD_Msk       (0x1U << FDCAN_TTRMC_XTD_Pos)                /*!< 0x40000000 */
#define FDCAN_TTRMC_XTD           FDCAN_TTRMC_XTD_Msk                          /*!< Extended Identifier                      */
#define FDCAN_TTRMC_RMPS_Pos      (31U)
#define FDCAN_TTRMC_RMPS_Msk      (0x1U << FDCAN_TTRMC_RMPS_Pos)               /*!< 0x80000000 */
#define FDCAN_TTRMC_RMPS          FDCAN_TTRMC_RMPS_Msk                         /*!<Reference Message Payload Select          */

/*****************  Bit definition for FDCAN_TTOCF register  *********************/
#define FDCAN_TTOCF_OM_Pos        (0U)
#define FDCAN_TTOCF_OM_Msk        (0x3U << FDCAN_TTOCF_OM_Pos)                 /*!< 0x00000003 */
#define FDCAN_TTOCF_OM            FDCAN_TTOCF_OM_Msk                           /*!<Operation Mode                            */
#define FDCAN_TTOCF_GEN_Pos       (3U)
#define FDCAN_TTOCF_GEN_Msk       (0x1U << FDCAN_TTOCF_GEN_Pos)                /*!< 0x00000008 */
#define FDCAN_TTOCF_GEN           FDCAN_TTOCF_GEN_Msk                          /*!<Gap Enable                                */
#define FDCAN_TTOCF_TM_Pos        (4U)
#define FDCAN_TTOCF_TM_Msk        (0x1U << FDCAN_TTOCF_TM_Pos)                 /*!< 0x00000010 */
#define FDCAN_TTOCF_TM            FDCAN_TTOCF_TM_Msk                           /*!<Time Master                               */
#define FDCAN_TTOCF_LDSDL_Pos     (5U)
#define FDCAN_TTOCF_LDSDL_Msk     (0x7U << FDCAN_TTOCF_LDSDL_Pos)              /*!< 0x000000E0 */
#define FDCAN_TTOCF_LDSDL         FDCAN_TTOCF_LDSDL_Msk                        /*!<LD of Synchronization Deviation Limit     */
#define FDCAN_TTOCF_IRTO_Pos      (8U)
#define FDCAN_TTOCF_IRTO_Msk      (0x7FU << FDCAN_TTOCF_IRTO_Pos)              /*!< 0x00007F00 */
#define FDCAN_TTOCF_IRTO          FDCAN_TTOCF_IRTO_Msk                         /*!<Initial Reference Trigger Offset          */
#define FDCAN_TTOCF_EECS_Pos      (15U)
#define FDCAN_TTOCF_EECS_Msk      (0x1U << FDCAN_TTOCF_EECS_Pos)               /*!< 0x00008000 */
#define FDCAN_TTOCF_EECS          FDCAN_TTOCF_EECS_Msk                         /*!<Enable External Clock Synchronization     */
#define FDCAN_TTOCF_AWL_Pos       (16U)
#define FDCAN_TTOCF_AWL_Msk       (0xFFU << FDCAN_TTOCF_AWL_Pos)               /*!< 0x00FF0000 */
#define FDCAN_TTOCF_AWL           FDCAN_TTOCF_AWL_Msk                          /*!<Application Watchdog Limit                */
#define FDCAN_TTOCF_EGTF_Pos      (24U)
#define FDCAN_TTOCF_EGTF_Msk      (0x1U << FDCAN_TTOCF_EGTF_Pos)               /*!< 0x01000000 */
#define FDCAN_TTOCF_EGTF          FDCAN_TTOCF_EGTF_Msk                         /*!<Enable Global Time Filtering              */
#define FDCAN_TTOCF_ECC_Pos       (25U)
#define FDCAN_TTOCF_ECC_Msk       (0x1U << FDCAN_TTOCF_ECC_Pos)                /*!< 0x02000000 */
#define FDCAN_TTOCF_ECC           FDCAN_TTOCF_ECC_Msk                          /*!<Enable Clock Calibration                  */
#define FDCAN_TTOCF_EVTP_Pos      (26U)
#define FDCAN_TTOCF_EVTP_Msk      (0x1U << FDCAN_TTOCF_EVTP_Pos)               /*!< 0x04000000 */
#define FDCAN_TTOCF_EVTP          FDCAN_TTOCF_EVTP_Msk                         /*!<Event Trigger Polarity                    */

/*****************  Bit definition for FDCAN_TTMLM register  *********************/
#define FDCAN_TTMLM_CCM_Pos       (0U)
#define FDCAN_TTMLM_CCM_Msk       (0x3FU << FDCAN_TTMLM_CCM_Pos)               /*!< 0x0000003F */
#define FDCAN_TTMLM_CCM           FDCAN_TTMLM_CCM_Msk                          /*!<Cycle Count Max                           */
#define FDCAN_TTMLM_CSS_Pos       (6U)
#define FDCAN_TTMLM_CSS_Msk       (0x3U << FDCAN_TTMLM_CSS_Pos)                /*!< 0x000000C0 */
#define FDCAN_TTMLM_CSS           FDCAN_TTMLM_CSS_Msk                          /*!<Cycle Start Synchronization               */
#define FDCAN_TTMLM_TXEW_Pos      (8U)
#define FDCAN_TTMLM_TXEW_Msk      (0xFU << FDCAN_TTMLM_TXEW_Pos)               /*!< 0x00000F00 */
#define FDCAN_TTMLM_TXEW          FDCAN_TTMLM_TXEW_Msk                         /*!<Tx Enable Window                          */
#define FDCAN_TTMLM_ENTT_Pos      (16U)
#define FDCAN_TTMLM_ENTT_Msk      (0xFFFU << FDCAN_TTMLM_ENTT_Pos)             /*!< 0x0FFF0000 */
#define FDCAN_TTMLM_ENTT          FDCAN_TTMLM_ENTT_Msk                         /*!<Expected Number of Tx Triggers            */

/*****************  Bit definition for FDCAN_TURCF register  *********************/
#define FDCAN_TURCF_NCL_Pos       (0U)
#define FDCAN_TURCF_NCL_Msk       (0xFFFFU << FDCAN_TURCF_NCL_Pos)             /*!< 0x0000FFFF */
#define FDCAN_TURCF_NCL           FDCAN_TURCF_NCL_Msk                          /*!<Numerator Configuration Low               */
#define FDCAN_TURCF_DC_Pos        (16U)
#define FDCAN_TURCF_DC_Msk        (0x3FFFU << FDCAN_TURCF_DC_Pos)              /*!< 0x3FFF0000 */
#define FDCAN_TURCF_DC            FDCAN_TURCF_DC_Msk                           /*!<Denominator Configuration                 */
#define FDCAN_TURCF_ELT_Pos       (31U)
#define FDCAN_TURCF_ELT_Msk       (0x1U << FDCAN_TURCF_ELT_Pos)                /*!< 0x80000000 */
#define FDCAN_TURCF_ELT           FDCAN_TURCF_ELT_Msk                          /*!<Enable Local Time                         */

/*****************  Bit definition for FDCAN_TTOCN register  ********************/
#define FDCAN_TTOCN_SGT_Pos       (0U)
#define FDCAN_TTOCN_SGT_Msk       (0x1U << FDCAN_TTOCN_SGT_Pos)                /*!< 0x00000001 */
#define FDCAN_TTOCN_SGT           FDCAN_TTOCN_SGT_Msk                          /*!<Set Global time                           */
#define FDCAN_TTOCN_ECS_Pos       (1U)
#define FDCAN_TTOCN_ECS_Msk       (0x1U << FDCAN_TTOCN_ECS_Pos)                /*!< 0x00000002 */
#define FDCAN_TTOCN_ECS           FDCAN_TTOCN_ECS_Msk                          /*!<External Clock Synchronization            */
#define FDCAN_TTOCN_SWP_Pos       (2U)
#define FDCAN_TTOCN_SWP_Msk       (0x1U << FDCAN_TTOCN_SWP_Pos)                /*!< 0x00000004 */
#define FDCAN_TTOCN_SWP           FDCAN_TTOCN_SWP_Msk                          /*!<Stop Watch Polarity                       */
#define FDCAN_TTOCN_SWS_Pos       (3U)
#define FDCAN_TTOCN_SWS_Msk       (0x3U << FDCAN_TTOCN_SWS_Pos)                /*!< 0x00000018 */
#define FDCAN_TTOCN_SWS           FDCAN_TTOCN_SWS_Msk                          /*!<Stop Watch Source                         */
#define FDCAN_TTOCN_RTIE_Pos      (5U)
#define FDCAN_TTOCN_RTIE_Msk      (0x1U << FDCAN_TTOCN_RTIE_Pos)               /*!< 0x00000020 */
#define FDCAN_TTOCN_RTIE          FDCAN_TTOCN_RTIE_Msk                         /*!<Register Time Mark Interrupt Pulse Enable */
#define FDCAN_TTOCN_TMC_Pos       (6U)
#define FDCAN_TTOCN_TMC_Msk       (0x3U << FDCAN_TTOCN_TMC_Pos)                /*!< 0x000000C0 */
#define FDCAN_TTOCN_TMC           FDCAN_TTOCN_TMC_Msk                          /*!<Register Time Mark Compare                */
#define FDCAN_TTOCN_TTIE_Pos      (8U)
#define FDCAN_TTOCN_TTIE_Msk      (0x1U << FDCAN_TTOCN_TTIE_Pos)               /*!< 0x00000100 */
#define FDCAN_TTOCN_TTIE          FDCAN_TTOCN_TTIE_Msk                         /*!<Trigger Time Mark Interrupt Pulse Enable  */
#define FDCAN_TTOCN_GCS_Pos       (9U)
#define FDCAN_TTOCN_GCS_Msk       (0x1U << FDCAN_TTOCN_GCS_Pos)                /*!< 0x00000200 */
#define FDCAN_TTOCN_GCS           FDCAN_TTOCN_GCS_Msk                          /*!<Gap Control Select                        */
#define FDCAN_TTOCN_FGP_Pos       (10U)
#define FDCAN_TTOCN_FGP_Msk       (0x1U << FDCAN_TTOCN_FGP_Pos)                /*!< 0x00000400 */
#define FDCAN_TTOCN_FGP           FDCAN_TTOCN_FGP_Msk                          /*!<Finish Gap                                */
#define FDCAN_TTOCN_TMG_Pos       (11U)
#define FDCAN_TTOCN_TMG_Msk       (0x1U << FDCAN_TTOCN_TMG_Pos)                /*!< 0x00000800 */
#define FDCAN_TTOCN_TMG           FDCAN_TTOCN_TMG_Msk                          /*!<Time Mark Gap                             */
#define FDCAN_TTOCN_NIG_Pos       (12U)
#define FDCAN_TTOCN_NIG_Msk       (0x1U << FDCAN_TTOCN_NIG_Pos)                /*!< 0x00001000 */
#define FDCAN_TTOCN_NIG           FDCAN_TTOCN_NIG_Msk                          /*!<Next is Gap                               */
#define FDCAN_TTOCN_ESCN_Pos      (13U)
#define FDCAN_TTOCN_ESCN_Msk      (0x1U << FDCAN_TTOCN_ESCN_Pos)               /*!< 0x00002000 */
#define FDCAN_TTOCN_ESCN          FDCAN_TTOCN_ESCN_Msk                         /*!<External Synchronization Control          */
#define FDCAN_TTOCN_LCKC_Pos      (15U)
#define FDCAN_TTOCN_LCKC_Msk      (0x1U << FDCAN_TTOCN_LCKC_Pos)               /*!< 0x00008000 */
#define FDCAN_TTOCN_LCKC          FDCAN_TTOCN_LCKC_Msk                         /*!<TT Operation Control Register Locked      */

/*****************  Bit definition for FDCAN_TTGTP register  ********************/
#define FDCAN_TTGTP_TP_Pos        (0U)
#define FDCAN_TTGTP_TP_Msk        (0xFFFFU << FDCAN_TTGTP_TP_Pos)              /*!< 0x0000FFFF */
#define FDCAN_TTGTP_TP            FDCAN_TTGTP_TP_Msk                           /*!<Time Preset                               */
#define FDCAN_TTGTP_CTP_Pos       (16U)
#define FDCAN_TTGTP_CTP_Msk       (0xFFFFU << FDCAN_TTGTP_CTP_Pos)             /*!< 0xFFFF0000 */
#define FDCAN_TTGTP_CTP           FDCAN_TTGTP_CTP_Msk                          /*!<Cycle Time Target Phase                   */

/*****************  Bit definition for FDCAN_TTTMK register  ********************/
#define FDCAN_TTTMK_TM_Pos        (0U)
#define FDCAN_TTTMK_TM_Msk        (0xFFFFU << FDCAN_TTTMK_TM_Pos)              /*!< 0x0000FFFF */
#define FDCAN_TTTMK_TM            FDCAN_TTTMK_TM_Msk                           /*!<Time Mark                                 */
#define FDCAN_TTTMK_TICC_Pos      (16U)
#define FDCAN_TTTMK_TICC_Msk      (0x7FU << FDCAN_TTTMK_TICC_Pos)              /*!< 0x007F0000 */
#define FDCAN_TTTMK_TICC          FDCAN_TTTMK_TICC_Msk                         /*!<Time Mark Cycle Code                      */
#define FDCAN_TTTMK_LCKM_Pos      (31U)
#define FDCAN_TTTMK_LCKM_Msk      (0x1U << FDCAN_TTTMK_LCKM_Pos)               /*!< 0x80000000 */
#define FDCAN_TTTMK_LCKM          FDCAN_TTTMK_LCKM_Msk                         /*!<TT Time Mark Register Locked              */

/*****************  Bit definition for FDCAN_TTIR register  ********************/
#define FDCAN_TTIR_SBC_Pos        (0U)
#define FDCAN_TTIR_SBC_Msk        (0x1U << FDCAN_TTIR_SBC_Pos)                 /*!< 0x00000001 */
#define FDCAN_TTIR_SBC            FDCAN_TTIR_SBC_Msk                           /*!<Start of Basic Cycle                      */
#define FDCAN_TTIR_SMC_Pos        (1U)
#define FDCAN_TTIR_SMC_Msk        (0x1U << FDCAN_TTIR_SMC_Pos)                 /*!< 0x00000002 */
#define FDCAN_TTIR_SMC            FDCAN_TTIR_SMC_Msk                           /*!<Start of Matrix Cycle                     */
#define FDCAN_TTIR_CSM_Pos        (2U)
#define FDCAN_TTIR_CSM_Msk        (0x1U << FDCAN_TTIR_CSM_Pos)                 /*!< 0x00000004 */
#define FDCAN_TTIR_CSM            FDCAN_TTIR_CSM_Msk                           /*!<Change of Synchronization Mode            */
#define FDCAN_TTIR_SOG_Pos        (3U)
#define FDCAN_TTIR_SOG_Msk        (0x1U << FDCAN_TTIR_SOG_Pos)                 /*!< 0x00000008 */
#define FDCAN_TTIR_SOG            FDCAN_TTIR_SOG_Msk                           /*!<Start of Gap                              */
#define FDCAN_TTIR_RTMI_Pos       (4U)
#define FDCAN_TTIR_RTMI_Msk       (0x1U << FDCAN_TTIR_RTMI_Pos)                /*!< 0x00000010 */
#define FDCAN_TTIR_RTMI           FDCAN_TTIR_RTMI_Msk                          /*!<Register Time Mark Interrupt              */
#define FDCAN_TTIR_TTMI_Pos       (5U)
#define FDCAN_TTIR_TTMI_Msk       (0x1U << FDCAN_TTIR_TTMI_Pos)                /*!< 0x00000020 */
#define FDCAN_TTIR_TTMI           FDCAN_TTIR_TTMI_Msk                          /*!<Trigger Time Mark Event Internal          */
#define FDCAN_TTIR_SWE_Pos        (6U)
#define FDCAN_TTIR_SWE_Msk        (0x1U << FDCAN_TTIR_SWE_Pos)                 /*!< 0x00000040 */
#define FDCAN_TTIR_SWE            FDCAN_TTIR_SWE_Msk                           /*!<Stop Watch Event                          */
#define FDCAN_TTIR_GTW_Pos        (7U)
#define FDCAN_TTIR_GTW_Msk        (0x1U << FDCAN_TTIR_GTW_Pos)                 /*!< 0x00000080 */
#define FDCAN_TTIR_GTW            FDCAN_TTIR_GTW_Msk                           /*!<Global Time Wrap                          */
#define FDCAN_TTIR_GTD_Pos        (8U)
#define FDCAN_TTIR_GTD_Msk        (0x1U << FDCAN_TTIR_GTD_Pos)                 /*!< 0x00000100 */
#define FDCAN_TTIR_GTD            FDCAN_TTIR_GTD_Msk                           /*!<Global Time Discontinuity                 */
#define FDCAN_TTIR_GTE_Pos        (9U)
#define FDCAN_TTIR_GTE_Msk        (0x1U << FDCAN_TTIR_GTE_Pos)                 /*!< 0x00000200 */
#define FDCAN_TTIR_GTE            FDCAN_TTIR_GTE_Msk                           /*!<Global Time Error                         */
#define FDCAN_TTIR_TXU_Pos        (10U)
#define FDCAN_TTIR_TXU_Msk        (0x1U << FDCAN_TTIR_TXU_Pos)                 /*!< 0x00000400 */
#define FDCAN_TTIR_TXU            FDCAN_TTIR_TXU_Msk                           /*!<Tx Count Underflow                        */
#define FDCAN_TTIR_TXO_Pos        (11U)
#define FDCAN_TTIR_TXO_Msk        (0x1U << FDCAN_TTIR_TXO_Pos)                 /*!< 0x00000800 */
#define FDCAN_TTIR_TXO            FDCAN_TTIR_TXO_Msk                           /*!<Tx Count Overflow                         */
#define FDCAN_TTIR_SE1_Pos        (12U)
#define FDCAN_TTIR_SE1_Msk        (0x1U << FDCAN_TTIR_SE1_Pos)                 /*!< 0x00001000 */
#define FDCAN_TTIR_SE1            FDCAN_TTIR_SE1_Msk                           /*!<Scheduling Error 1                        */
#define FDCAN_TTIR_SE2_Pos        (13U)
#define FDCAN_TTIR_SE2_Msk        (0x1U << FDCAN_TTIR_SE2_Pos)                 /*!< 0x00002000 */
#define FDCAN_TTIR_SE2            FDCAN_TTIR_SE2_Msk                           /*!<Scheduling Error 2                        */
#define FDCAN_TTIR_ELC_Pos        (14U)
#define FDCAN_TTIR_ELC_Msk        (0x1U << FDCAN_TTIR_ELC_Pos)                 /*!< 0x00004000 */
#define FDCAN_TTIR_ELC            FDCAN_TTIR_ELC_Msk                           /*!<Error Level Changed                       */
#define FDCAN_TTIR_IWT_Pos        (15U)
#define FDCAN_TTIR_IWT_Msk        (0x1U << FDCAN_TTIR_IWT_Pos)                 /*!< 0x00008000 */
#define FDCAN_TTIR_IWT            FDCAN_TTIR_IWT_Msk                           /*!<Initialization Watch Trigger              */
#define FDCAN_TTIR_WT_Pos         (16U)
#define FDCAN_TTIR_WT_Msk         (0x1U << FDCAN_TTIR_WT_Pos)                  /*!< 0x00010000 */
#define FDCAN_TTIR_WT             FDCAN_TTIR_WT_Msk                            /*!<Watch Trigger                             */
#define FDCAN_TTIR_AW_Pos         (17U)
#define FDCAN_TTIR_AW_Msk         (0x1U << FDCAN_TTIR_AW_Pos)                  /*!< 0x00020000 */
#define FDCAN_TTIR_AW             FDCAN_TTIR_AW_Msk                            /*!<Application Watchdog                      */
#define FDCAN_TTIR_CER_Pos        (18U)
#define FDCAN_TTIR_CER_Msk        (0x1U << FDCAN_TTIR_CER_Pos)                 /*!< 0x00040000 */
#define FDCAN_TTIR_CER            FDCAN_TTIR_CER_Msk                           /*!<Configuration Error                       */

/*****************  Bit definition for FDCAN_TTIE register  ********************/
#define FDCAN_TTIE_SBCE_Pos       (0U)
#define FDCAN_TTIE_SBCE_Msk       (0x1U << FDCAN_TTIE_SBCE_Pos)                /*!< 0x00000001 */
#define FDCAN_TTIE_SBCE           FDCAN_TTIE_SBCE_Msk                          /*!<Start of Basic Cycle Interrupt Enable             */
#define FDCAN_TTIE_SMCE_Pos       (1U)
#define FDCAN_TTIE_SMCE_Msk       (0x1U << FDCAN_TTIE_SMCE_Pos)                /*!< 0x00000002 */
#define FDCAN_TTIE_SMCE           FDCAN_TTIE_SMCE_Msk                          /*!<Start of Matrix Cycle Interrupt Enable            */
#define FDCAN_TTIE_CSME_Pos       (2U)
#define FDCAN_TTIE_CSME_Msk       (0x1U << FDCAN_TTIE_CSME_Pos)                /*!< 0x00000004 */
#define FDCAN_TTIE_CSME           FDCAN_TTIE_CSME_Msk                          /*!<Change of Synchronization Mode Interrupt Enable   */
#define FDCAN_TTIE_SOGE_Pos       (3U)
#define FDCAN_TTIE_SOGE_Msk       (0x1U << FDCAN_TTIE_SOGE_Pos)                /*!< 0x00000008 */
#define FDCAN_TTIE_SOGE           FDCAN_TTIE_SOGE_Msk                          /*!<Start of Gap Interrupt Enable                     */
#define FDCAN_TTIE_RTMIE_Pos      (4U)
#define FDCAN_TTIE_RTMIE_Msk      (0x1U << FDCAN_TTIE_RTMIE_Pos)               /*!< 0x00000010 */
#define FDCAN_TTIE_RTMIE          FDCAN_TTIE_RTMIE_Msk                         /*!<Register Time Mark Interrupt Interrupt Enable     */
#define FDCAN_TTIE_TTMIE_Pos      (5U)
#define FDCAN_TTIE_TTMIE_Msk      (0x1U << FDCAN_TTIE_TTMIE_Pos)               /*!< 0x00000020 */
#define FDCAN_TTIE_TTMIE          FDCAN_TTIE_TTMIE_Msk                         /*!<Trigger Time Mark Event Internal Interrupt Enable */
#define FDCAN_TTIE_SWEE_Pos       (6U)
#define FDCAN_TTIE_SWEE_Msk       (0x1U << FDCAN_TTIE_SWEE_Pos)                /*!< 0x00000040 */
#define FDCAN_TTIE_SWEE           FDCAN_TTIE_SWEE_Msk                          /*!<Stop Watch Event Interrupt Enable                 */
#define FDCAN_TTIE_GTWE_Pos       (7U)
#define FDCAN_TTIE_GTWE_Msk       (0x1U << FDCAN_TTIE_GTWE_Pos)                /*!< 0x00000080 */
#define FDCAN_TTIE_GTWE           FDCAN_TTIE_GTWE_Msk                          /*!<Global Time Wrap Interrupt Enable                 */
#define FDCAN_TTIE_GTDE_Pos       (8U)
#define FDCAN_TTIE_GTDE_Msk       (0x1U << FDCAN_TTIE_GTDE_Pos)                /*!< 0x00000100 */
#define FDCAN_TTIE_GTDE           FDCAN_TTIE_GTDE_Msk                          /*!<Global Time Discontinuity Interrupt Enable        */
#define FDCAN_TTIE_GTEE_Pos       (9U)
#define FDCAN_TTIE_GTEE_Msk       (0x1U << FDCAN_TTIE_GTEE_Pos)                /*!< 0x00000200 */
#define FDCAN_TTIE_GTEE           FDCAN_TTIE_GTEE_Msk                          /*!<Global Time Error Interrupt Enable                */
#define FDCAN_TTIE_TXUE_Pos       (10U)
#define FDCAN_TTIE_TXUE_Msk       (0x1U << FDCAN_TTIE_TXUE_Pos)                /*!< 0x00000400 */
#define FDCAN_TTIE_TXUE           FDCAN_TTIE_TXUE_Msk                          /*!<Tx Count Underflow Interrupt Enable               */
#define FDCAN_TTIE_TXOE_Pos       (11U)
#define FDCAN_TTIE_TXOE_Msk       (0x1U << FDCAN_TTIE_TXOE_Pos)                /*!< 0x00000800 */
#define FDCAN_TTIE_TXOE           FDCAN_TTIE_TXOE_Msk                          /*!<Tx Count Overflow Interrupt Enable                */
#define FDCAN_TTIE_SE1E_Pos       (12U)
#define FDCAN_TTIE_SE1E_Msk       (0x1U << FDCAN_TTIE_SE1E_Pos)                /*!< 0x00001000 */
#define FDCAN_TTIE_SE1E           FDCAN_TTIE_SE1E_Msk                          /*!<Scheduling Error 1 Interrupt Enable               */
#define FDCAN_TTIE_SE2E_Pos       (13U)
#define FDCAN_TTIE_SE2E_Msk       (0x1U << FDCAN_TTIE_SE2E_Pos)                /*!< 0x00002000 */
#define FDCAN_TTIE_SE2E           FDCAN_TTIE_SE2E_Msk                          /*!<Scheduling Error 2 Interrupt Enable               */
#define FDCAN_TTIE_ELCE_Pos       (14U)
#define FDCAN_TTIE_ELCE_Msk       (0x1U << FDCAN_TTIE_ELCE_Pos)                /*!< 0x00004000 */
#define FDCAN_TTIE_ELCE           FDCAN_TTIE_ELCE_Msk                          /*!<Error Level Changed Interrupt Enable              */
#define FDCAN_TTIE_IWTE_Pos       (15U)
#define FDCAN_TTIE_IWTE_Msk       (0x1U << FDCAN_TTIE_IWTE_Pos)                /*!< 0x00008000 */
#define FDCAN_TTIE_IWTE           FDCAN_TTIE_IWTE_Msk                          /*!<Initialization Watch Trigger Interrupt Enable     */
#define FDCAN_TTIE_WTE_Pos        (16U)
#define FDCAN_TTIE_WTE_Msk        (0x1U << FDCAN_TTIE_WTE_Pos)                 /*!< 0x00010000 */
#define FDCAN_TTIE_WTE            FDCAN_TTIE_WTE_Msk                           /*!<Watch Trigger Interrupt Enable                    */
#define FDCAN_TTIE_AWE_Pos        (17U)
#define FDCAN_TTIE_AWE_Msk        (0x1U << FDCAN_TTIE_AWE_Pos)                 /*!< 0x00020000 */
#define FDCAN_TTIE_AWE            FDCAN_TTIE_AWE_Msk                           /*!<Application Watchdog Interrupt Enable             */
#define FDCAN_TTIE_CERE_Pos       (18U)
#define FDCAN_TTIE_CERE_Msk       (0x1U << FDCAN_TTIE_CERE_Pos)                /*!< 0x00040000 */
#define FDCAN_TTIE_CERE           FDCAN_TTIE_CERE_Msk                          /*!<Configuration Error Interrupt Enable              */

/*****************  Bit definition for FDCAN_TTILS register  ********************/
#define FDCAN_TTILS_SBCS_Pos      (0U)
#define FDCAN_TTILS_SBCS_Msk      (0x1U << FDCAN_TTILS_SBCS_Pos)               /*!< 0x00000001 */
#define FDCAN_TTILS_SBCS          FDCAN_TTILS_SBCS_Msk                         /*!<Start of Basic Cycle Interrupt Line               */
#define FDCAN_TTILS_SMCS_Pos      (1U)
#define FDCAN_TTILS_SMCS_Msk      (0x1U << FDCAN_TTILS_SMCS_Pos)               /*!< 0x00000002 */
#define FDCAN_TTILS_SMCS          FDCAN_TTILS_SMCS_Msk                         /*!<Start of Matrix Cycle Interrupt Line              */
#define FDCAN_TTILS_CSMS_Pos      (2U)
#define FDCAN_TTILS_CSMS_Msk      (0x1U << FDCAN_TTILS_CSMS_Pos)               /*!< 0x00000004 */
#define FDCAN_TTILS_CSMS          FDCAN_TTILS_CSMS_Msk                         /*!<Change of Synchronization Mode Interrupt Line     */
#define FDCAN_TTILS_SOGS_Pos      (3U)
#define FDCAN_TTILS_SOGS_Msk      (0x1U << FDCAN_TTILS_SOGS_Pos)               /*!< 0x00000008 */
#define FDCAN_TTILS_SOGS          FDCAN_TTILS_SOGS_Msk                         /*!<Start of Gap Interrupt Line                       */
#define FDCAN_TTILS_RTMIS_Pos     (4U)
#define FDCAN_TTILS_RTMIS_Msk     (0x1U << FDCAN_TTILS_RTMIS_Pos)              /*!< 0x00000010 */
#define FDCAN_TTILS_RTMIS         FDCAN_TTILS_RTMIS_Msk                        /*!<Register Time Mark Interrupt Interrupt Line       */
#define FDCAN_TTILS_TTMIS_Pos     (5U)
#define FDCAN_TTILS_TTMIS_Msk     (0x1U << FDCAN_TTILS_TTMIS_Pos)              /*!< 0x00000020 */
#define FDCAN_TTILS_TTMIS         FDCAN_TTILS_TTMIS_Msk                        /*!<Trigger Time Mark Event Internal Interrupt Line   */
#define FDCAN_TTILS_SWES_Pos      (6U)
#define FDCAN_TTILS_SWES_Msk      (0x1U << FDCAN_TTILS_SWES_Pos)               /*!< 0x00000040 */
#define FDCAN_TTILS_SWES          FDCAN_TTILS_SWES_Msk                         /*!<Stop Watch Event Interrupt Line                   */
#define FDCAN_TTILS_GTWS_Pos      (7U)
#define FDCAN_TTILS_GTWS_Msk      (0x1U << FDCAN_TTILS_GTWS_Pos)               /*!< 0x00000080 */
#define FDCAN_TTILS_GTWS          FDCAN_TTILS_GTWS_Msk                         /*!<Global Time Wrap Interrupt Line                   */
#define FDCAN_TTILS_GTDS_Pos      (8U)
#define FDCAN_TTILS_GTDS_Msk      (0x1U << FDCAN_TTILS_GTDS_Pos)               /*!< 0x00000100 */
#define FDCAN_TTILS_GTDS          FDCAN_TTILS_GTDS_Msk                         /*!<Global Time Discontinuity Interrupt Line          */
#define FDCAN_TTILS_GTES_Pos      (9U)
#define FDCAN_TTILS_GTES_Msk      (0x1U << FDCAN_TTILS_GTES_Pos)               /*!< 0x00000200 */
#define FDCAN_TTILS_GTES          FDCAN_TTILS_GTES_Msk                         /*!<Global Time Error Interrupt Line                  */
#define FDCAN_TTILS_TXUS_Pos      (10U)
#define FDCAN_TTILS_TXUS_Msk      (0x1U << FDCAN_TTILS_TXUS_Pos)               /*!< 0x00000400 */
#define FDCAN_TTILS_TXUS          FDCAN_TTILS_TXUS_Msk                         /*!<Tx Count Underflow Interrupt Line                 */
#define FDCAN_TTILS_TXOS_Pos      (11U)
#define FDCAN_TTILS_TXOS_Msk      (0x1U << FDCAN_TTILS_TXOS_Pos)               /*!< 0x00000800 */
#define FDCAN_TTILS_TXOS          FDCAN_TTILS_TXOS_Msk                         /*!<Tx Count Overflow Interrupt Line                  */
#define FDCAN_TTILS_SE1S_Pos      (12U)
#define FDCAN_TTILS_SE1S_Msk      (0x1U << FDCAN_TTILS_SE1S_Pos)               /*!< 0x00001000 */
#define FDCAN_TTILS_SE1S          FDCAN_TTILS_SE1S_Msk                         /*!<Scheduling Error 1 Interrupt Line                 */
#define FDCAN_TTILS_SE2S_Pos      (13U)
#define FDCAN_TTILS_SE2S_Msk      (0x1U << FDCAN_TTILS_SE2S_Pos)               /*!< 0x00002000 */
#define FDCAN_TTILS_SE2S          FDCAN_TTILS_SE2S_Msk                         /*!<Scheduling Error 2 Interrupt Line                 */
#define FDCAN_TTILS_ELCS_Pos      (14U)
#define FDCAN_TTILS_ELCS_Msk      (0x1U << FDCAN_TTILS_ELCS_Pos)               /*!< 0x00004000 */
#define FDCAN_TTILS_ELCS          FDCAN_TTILS_ELCS_Msk                         /*!<Error Level Changed Interrupt Line                */
#define FDCAN_TTILS_IWTS_Pos      (15U)
#define FDCAN_TTILS_IWTS_Msk      (0x1U << FDCAN_TTILS_IWTS_Pos)               /*!< 0x00008000 */
#define FDCAN_TTILS_IWTS          FDCAN_TTILS_IWTS_Msk                         /*!<Initialization Watch Trigger Interrupt Line       */
#define FDCAN_TTILS_WTS_Pos       (16U)
#define FDCAN_TTILS_WTS_Msk       (0x1U << FDCAN_TTILS_WTS_Pos)                /*!< 0x00010000 */
#define FDCAN_TTILS_WTS           FDCAN_TTILS_WTS_Msk                          /*!<Watch Trigger Interrupt Line                      */
#define FDCAN_TTILS_AWS_Pos       (17U)
#define FDCAN_TTILS_AWS_Msk       (0x1U << FDCAN_TTILS_AWS_Pos)                /*!< 0x00020000 */
#define FDCAN_TTILS_AWS           FDCAN_TTILS_AWS_Msk                          /*!<Application Watchdog Interrupt Line               */
#define FDCAN_TTILS_CERS_Pos      (18U)
#define FDCAN_TTILS_CERS_Msk      (0x1U << FDCAN_TTILS_CERS_Pos)               /*!< 0x00040000 */
#define FDCAN_TTILS_CERS          FDCAN_TTILS_CERS_Msk                         /*!<Configuration Error Interrupt Line                */

/*****************  Bit definition for FDCAN_TTOST register  ********************/
#define FDCAN_TTOST_EL_Pos        (0U)
#define FDCAN_TTOST_EL_Msk        (0x3U << FDCAN_TTOST_EL_Pos)                 /*!< 0x00000003 */
#define FDCAN_TTOST_EL            FDCAN_TTOST_EL_Msk                           /*!<Error Level                              */
#define FDCAN_TTOST_MS_Pos        (2U)
#define FDCAN_TTOST_MS_Msk        (0x3U << FDCAN_TTOST_MS_Pos)                 /*!< 0x0000000C */
#define FDCAN_TTOST_MS            FDCAN_TTOST_MS_Msk                           /*!<Master State                             */
#define FDCAN_TTOST_SYS_Pos       (4U)
#define FDCAN_TTOST_SYS_Msk       (0x3U << FDCAN_TTOST_SYS_Pos)                /*!< 0x00000030 */
#define FDCAN_TTOST_SYS           FDCAN_TTOST_SYS_Msk                          /*!<Synchronization State                    */
#define FDCAN_TTOST_QGTP_Pos      (6U)
#define FDCAN_TTOST_QGTP_Msk      (0x1U << FDCAN_TTOST_QGTP_Pos)               /*!< 0x00000040 */
#define FDCAN_TTOST_QGTP          FDCAN_TTOST_QGTP_Msk                         /*!<Quality of Global Time Phase             */
#define FDCAN_TTOST_QCS_Pos       (7U)
#define FDCAN_TTOST_QCS_Msk       (0x1U << FDCAN_TTOST_QCS_Pos)                /*!< 0x00000080 */
#define FDCAN_TTOST_QCS           FDCAN_TTOST_QCS_Msk                          /*!<Quality of Clock Speed                   */
#define FDCAN_TTOST_RTO_Pos       (8U)
#define FDCAN_TTOST_RTO_Msk       (0xFFU << FDCAN_TTOST_RTO_Pos)               /*!< 0x0000FF00 */
#define FDCAN_TTOST_RTO           FDCAN_TTOST_RTO_Msk                          /*!<Reference Trigger Offset                 */
#define FDCAN_TTOST_WGTD_Pos      (22U)
#define FDCAN_TTOST_WGTD_Msk      (0x1U << FDCAN_TTOST_WGTD_Pos)               /*!< 0x00400000 */
#define FDCAN_TTOST_WGTD          FDCAN_TTOST_WGTD_Msk                         /*!<Wait for Global Time Discontinuity       */
#define FDCAN_TTOST_GFI_Pos       (23U)
#define FDCAN_TTOST_GFI_Msk       (0x1U << FDCAN_TTOST_GFI_Pos)                /*!< 0x00800000 */
#define FDCAN_TTOST_GFI           FDCAN_TTOST_GFI_Msk                          /*!<Gap Finished Indicator                   */
#define FDCAN_TTOST_TMP_Pos       (24U)
#define FDCAN_TTOST_TMP_Msk       (0x7U << FDCAN_TTOST_TMP_Pos)                /*!< 0x07000000 */
#define FDCAN_TTOST_TMP           FDCAN_TTOST_TMP_Msk                          /*!<Time Master Priority                     */
#define FDCAN_TTOST_GSI_Pos       (27U)
#define FDCAN_TTOST_GSI_Msk       (0x1U << FDCAN_TTOST_GSI_Pos)                /*!< 0x08000000 */
#define FDCAN_TTOST_GSI           FDCAN_TTOST_GSI_Msk                          /*!<Gap Started Indicator                    */
#define FDCAN_TTOST_WFE_Pos       (28U)
#define FDCAN_TTOST_WFE_Msk       (0x1U << FDCAN_TTOST_WFE_Pos)                /*!< 0x10000000 */
#define FDCAN_TTOST_WFE           FDCAN_TTOST_WFE_Msk                          /*!<Wait for Event                           */
#define FDCAN_TTOST_AWE_Pos       (29U)
#define FDCAN_TTOST_AWE_Msk       (0x1U << FDCAN_TTOST_AWE_Pos)                /*!< 0x20000000 */
#define FDCAN_TTOST_AWE           FDCAN_TTOST_AWE_Msk                          /*!<Application Watchdog Event               */
#define FDCAN_TTOST_WECS_Pos      (30U)
#define FDCAN_TTOST_WECS_Msk      (0x1U << FDCAN_TTOST_WECS_Pos)               /*!< 0x40000000 */
#define FDCAN_TTOST_WECS          FDCAN_TTOST_WECS_Msk                         /*!<Wait for External Clock Synchronization  */
#define FDCAN_TTOST_SPL_Pos       (31U)
#define FDCAN_TTOST_SPL_Msk       (0x1U << FDCAN_TTOST_SPL_Pos)                /*!< 0x80000000 */
#define FDCAN_TTOST_SPL           FDCAN_TTOST_SPL_Msk                          /*!<Schedule Phase Lock                      */

/*****************  Bit definition for FDCAN_TURNA register  ********************/
#define FDCAN_TURNA_NAV_Pos       (0U)
#define FDCAN_TURNA_NAV_Msk       (0x3FFFFU << FDCAN_TURNA_NAV_Pos)            /*!< 0x0003FFFF */
#define FDCAN_TURNA_NAV           FDCAN_TURNA_NAV_Msk                          /*!<Numerator Actual Value                   */

/*****************  Bit definition for FDCAN_TTLGT register  ********************/
#define FDCAN_TTLGT_LT_Pos        (0U)
#define FDCAN_TTLGT_LT_Msk        (0xFFFFU << FDCAN_TTLGT_LT_Pos)              /*!< 0x0000FFFF */
#define FDCAN_TTLGT_LT            FDCAN_TTLGT_LT_Msk                           /*!<Local Time                               */
#define FDCAN_TTLGT_GT_Pos        (16U)
#define FDCAN_TTLGT_GT_Msk        (0xFFFFU << FDCAN_TTLGT_GT_Pos)              /*!< 0xFFFF0000 */
#define FDCAN_TTLGT_GT            FDCAN_TTLGT_GT_Msk                           /*!<Global Time                              */

/*****************  Bit definition for FDCAN_TTCTC register  ********************/
#define FDCAN_TTCTC_CT_Pos        (0U)
#define FDCAN_TTCTC_CT_Msk        (0xFFFFU << FDCAN_TTCTC_CT_Pos)              /*!< 0x0000FFFF */
#define FDCAN_TTCTC_CT            FDCAN_TTCTC_CT_Msk                           /*!<Cycle Time                               */
#define FDCAN_TTCTC_CC_Pos        (16U)
#define FDCAN_TTCTC_CC_Msk        (0x3FU << FDCAN_TTCTC_CC_Pos)                /*!< 0x003F0000 */
#define FDCAN_TTCTC_CC            FDCAN_TTCTC_CC_Msk                           /*!<Cycle Count                              */

/*****************  Bit definition for FDCAN_TTCPT register  ********************/
#define FDCAN_TTCPT_CCV_Pos       (0U)
#define FDCAN_TTCPT_CCV_Msk       (0x3FU << FDCAN_TTCPT_CCV_Pos)               /*!< 0x0000003F */
#define FDCAN_TTCPT_CCV           FDCAN_TTCPT_CCV_Msk                          /*!<Cycle Count Value                        */
#define FDCAN_TTCPT_SWV_Pos       (16U)
#define FDCAN_TTCPT_SWV_Msk       (0xFFFFU << FDCAN_TTCPT_SWV_Pos)             /*!< 0xFFFF0000 */
#define FDCAN_TTCPT_SWV           FDCAN_TTCPT_SWV_Msk                          /*!<Stop Watch Value                         */

/*****************  Bit definition for FDCAN_TTCSM register  ********************/
#define FDCAN_TTCSM_CSM_Pos       (0U)
#define FDCAN_TTCSM_CSM_Msk       (0xFFFFU << FDCAN_TTCSM_CSM_Pos)             /*!< 0x0000FFFF */
#define FDCAN_TTCSM_CSM           FDCAN_TTCSM_CSM_Msk                          /*!<Cycle Sync Mark                          */

/*****************  Bit definition for FDCAN_TTTS register  *********************/
#define FDCAN_TTTS_SWTSEL_Pos     (0U)
#define FDCAN_TTTS_SWTSEL_Msk     (0x3U << FDCAN_TTTS_SWTSEL_Pos)              /*!< 0x00000003 */
#define FDCAN_TTTS_SWTSEL         FDCAN_TTTS_SWTSEL_Msk                        /*!<Stop watch trigger input selection       */
#define FDCAN_TTTS_EVTSEL_Pos     (4U)
#define FDCAN_TTTS_EVTSEL_Msk     (0x3U << FDCAN_TTTS_EVTSEL_Pos)              /*!< 0x00000030 */
#define FDCAN_TTTS_EVTSEL         FDCAN_TTTS_EVTSEL_Msk                        /*!<Event trigger input selection            */

/********************************************************************************/
/*                                                                              */
/*                      FDCANCCU (Clock Calibration unit)                       */
/*                                                                              */
/********************************************************************************/

/*****************  Bit definition for FDCANCCU_CREL register  ******************/
#define FDCANCCU_CREL_DAY_Pos        (0U)
#define FDCANCCU_CREL_DAY_Msk        (0xFFU << FDCANCCU_CREL_DAY_Pos)          /*!< 0x000000FF */
#define FDCANCCU_CREL_DAY            FDCANCCU_CREL_DAY_Msk                     /*!<Timestamp Day                           */
#define FDCANCCU_CREL_MON_Pos        (8U)
#define FDCANCCU_CREL_MON_Msk        (0xFFU << FDCANCCU_CREL_MON_Pos)          /*!< 0x0000FF00 */
#define FDCANCCU_CREL_MON            FDCANCCU_CREL_MON_Msk                     /*!<Timestamp Month                         */
#define FDCANCCU_CREL_YEAR_Pos       (16U)
#define FDCANCCU_CREL_YEAR_Msk       (0xFU << FDCANCCU_CREL_YEAR_Pos)          /*!< 0x000F0000 */
#define FDCANCCU_CREL_YEAR           FDCANCCU_CREL_YEAR_Msk                    /*!<Timestamp Year                          */
#define FDCANCCU_CREL_SUBSTEP_Pos    (20U)
#define FDCANCCU_CREL_SUBSTEP_Msk    (0xFU << FDCANCCU_CREL_SUBSTEP_Pos)       /*!< 0x00F00000 */
#define FDCANCCU_CREL_SUBSTEP        FDCANCCU_CREL_SUBSTEP_Msk                 /*!<Sub-step of Core release                */
#define FDCANCCU_CREL_STEP_Pos       (24U)
#define FDCANCCU_CREL_STEP_Msk       (0xFU << FDCANCCU_CREL_STEP_Pos)          /*!< 0x0F000000 */
#define FDCANCCU_CREL_STEP           FDCANCCU_CREL_STEP_Msk                    /*!<Step of Core release                    */
#define FDCANCCU_CREL_REL_Pos        (28U)
#define FDCANCCU_CREL_REL_Msk        (0xFU << FDCANCCU_CREL_REL_Pos)           /*!< 0xF0000000 */
#define FDCANCCU_CREL_REL            FDCANCCU_CREL_REL_Msk                     /*!<Core release                            */

/*****************  Bit definition for FDCANCCU_CCFG register  ******************/
#define FDCANCCU_CCFG_TQBT_Pos       (0U)
#define FDCANCCU_CCFG_TQBT_Msk       (0x1FU << FDCANCCU_CCFG_TQBT_Pos)         /*!< 0x0000001F */
#define FDCANCCU_CCFG_TQBT           FDCANCCU_CCFG_TQBT_Msk                    /*!<Time Quanta per Bit Time                */
#define FDCANCCU_CCFG_BCC_Pos        (6U)
#define FDCANCCU_CCFG_BCC_Msk        (0x1U << FDCANCCU_CCFG_BCC_Pos)           /*!< 0x00000040 */
#define FDCANCCU_CCFG_BCC            FDCANCCU_CCFG_BCC_Msk                     /*!<Bypass Clock Calibration                */
#define FDCANCCU_CCFG_CFL_Pos        (7U)
#define FDCANCCU_CCFG_CFL_Msk        (0x1U << FDCANCCU_CCFG_CFL_Pos)           /*!< 0x00000080 */
#define FDCANCCU_CCFG_CFL            FDCANCCU_CCFG_CFL_Msk                     /*!<Calibration Field Length                */
#define FDCANCCU_CCFG_OCPM_Pos       (8U)
#define FDCANCCU_CCFG_OCPM_Msk       (0xFFU << FDCANCCU_CCFG_OCPM_Pos)         /*!< 0x0000FF00 */
#define FDCANCCU_CCFG_OCPM           FDCANCCU_CCFG_OCPM_Msk                    /*!<Oscillator Clock Periods Minimum        */
#define FDCANCCU_CCFG_CDIV_Pos       (16U)
#define FDCANCCU_CCFG_CDIV_Msk       (0xFU << FDCANCCU_CCFG_CDIV_Pos)          /*!< 0x000F0000 */
#define FDCANCCU_CCFG_CDIV           FDCANCCU_CCFG_CDIV_Msk                    /*!<Clock Divider                           */
#define FDCANCCU_CCFG_SWR_Pos        (31U)
#define FDCANCCU_CCFG_SWR_Msk        (0x1U << FDCANCCU_CCFG_SWR_Pos)           /*!< 0x80000000 */
#define FDCANCCU_CCFG_SWR            FDCANCCU_CCFG_SWR_Msk                     /*!<Software Reset                          */

/*****************  Bit definition for FDCANCCU_CSTAT register  *****************/
#define FDCANCCU_CSTAT_OCPC_Pos      (0U)
#define FDCANCCU_CSTAT_OCPC_Msk      (0x3FFFFU << FDCANCCU_CSTAT_OCPC_Pos)     /*!< 0x0003FFFF */
#define FDCANCCU_CSTAT_OCPC          FDCANCCU_CSTAT_OCPC_Msk                   /*!<Oscillator Clock Period Counter        */
#define FDCANCCU_CSTAT_TQC_Pos       (18U)
#define FDCANCCU_CSTAT_TQC_Msk       (0x7FFU << FDCANCCU_CSTAT_TQC_Pos)        /*!< 0x1FFC0000 */
#define FDCANCCU_CSTAT_TQC           FDCANCCU_CSTAT_TQC_Msk                    /*!<Time Quanta Counter                    */
#define FDCANCCU_CSTAT_CALS_Pos      (30U)
#define FDCANCCU_CSTAT_CALS_Msk      (0x3U << FDCANCCU_CSTAT_CALS_Pos)         /*!< 0xC0000000 */
#define FDCANCCU_CSTAT_CALS          FDCANCCU_CSTAT_CALS_Msk                   /*!<Calibration State                      */

/******************  Bit definition for FDCANCCU_CWD register  ******************/
#define FDCANCCU_CWD_WDC_Pos         (0U)
#define FDCANCCU_CWD_WDC_Msk         (0xFFFFU << FDCANCCU_CWD_WDC_Pos)         /*!< 0x0000FFFF */
#define FDCANCCU_CWD_WDC             FDCANCCU_CWD_WDC_Msk                      /*!<Watchdog Configuration                 */
#define FDCANCCU_CWD_WDV_Pos         (16U)
#define FDCANCCU_CWD_WDV_Msk         (0xFFFFU << FDCANCCU_CWD_WDV_Pos)         /*!< 0xFFFF0000 */
#define FDCANCCU_CWD_WDV             FDCANCCU_CWD_WDV_Msk                      /*!<Watchdog Value                         */

/******************  Bit definition for FDCANCCU_IR register  *******************/
#define FDCANCCU_IR_CWE_Pos          (0U)
#define FDCANCCU_IR_CWE_Msk          (0x1U << FDCANCCU_IR_CWE_Pos)             /*!< 0x00000001 */
#define FDCANCCU_IR_CWE              FDCANCCU_IR_CWE_Msk                       /*!<Calibration Watchdog Event             */
#define FDCANCCU_IR_CSC_Pos          (1U)
#define FDCANCCU_IR_CSC_Msk          (0x1U << FDCANCCU_IR_CSC_Pos)             /*!< 0x00000002 */
#define FDCANCCU_IR_CSC              FDCANCCU_IR_CSC_Msk                       /*!<Calibration State Changed              */

/******************  Bit definition for FDCANCCU_IE register  *******************/
#define FDCANCCU_IE_CWEE_Pos         (0U)
#define FDCANCCU_IE_CWEE_Msk         (0x1U << FDCANCCU_IE_CWEE_Pos)            /*!< 0x00000001 */
#define FDCANCCU_IE_CWEE             FDCANCCU_IE_CWEE_Msk                      /*!<Calibration Watchdog Event Enable      */
#define FDCANCCU_IE_CSCE_Pos         (1U)
#define FDCANCCU_IE_CSCE_Msk         (0x1U << FDCANCCU_IE_CSCE_Pos)            /*!< 0x00000002 */
#define FDCANCCU_IE_CSCE             FDCANCCU_IE_CSCE_Msk                      /*!<Calibration State Changed Enable       */

/******************************************************************************/
/*                                                                            */
/*                          HDMI-CEC (CEC)                                    */
/*                                                                            */
/******************************************************************************/

/*******************  Bit definition for CEC_CR register  *********************/
#define CEC_CR_CECEN_Pos         (0U)
#define CEC_CR_CECEN_Msk         (0x1U << CEC_CR_CECEN_Pos)                    /*!< 0x00000001 */
#define CEC_CR_CECEN             CEC_CR_CECEN_Msk                              /*!< CEC Enable                                */
#define CEC_CR_TXSOM_Pos         (1U)
#define CEC_CR_TXSOM_Msk         (0x1U << CEC_CR_TXSOM_Pos)                    /*!< 0x00000002 */
#define CEC_CR_TXSOM             CEC_CR_TXSOM_Msk                              /*!< CEC Tx Start Of Message                   */
#define CEC_CR_TXEOM_Pos         (2U)
#define CEC_CR_TXEOM_Msk         (0x1U << CEC_CR_TXEOM_Pos)                    /*!< 0x00000004 */
#define CEC_CR_TXEOM             CEC_CR_TXEOM_Msk                              /*!< CEC Tx End Of Message                     */

/*******************  Bit definition for CEC_CFGR register  *******************/
#define CEC_CFGR_SFT_Pos         (0U)
#define CEC_CFGR_SFT_Msk         (0x7U << CEC_CFGR_SFT_Pos)                    /*!< 0x00000007 */
#define CEC_CFGR_SFT             CEC_CFGR_SFT_Msk                              /*!< CEC Signal Free Time                      */
#define CEC_CFGR_RXTOL_Pos       (3U)
#define CEC_CFGR_RXTOL_Msk       (0x1U << CEC_CFGR_RXTOL_Pos)                  /*!< 0x00000008 */
#define CEC_CFGR_RXTOL           CEC_CFGR_RXTOL_Msk                            /*!< CEC Tolerance                             */
#define CEC_CFGR_BRESTP_Pos      (4U)
#define CEC_CFGR_BRESTP_Msk      (0x1U << CEC_CFGR_BRESTP_Pos)                 /*!< 0x00000010 */
#define CEC_CFGR_BRESTP          CEC_CFGR_BRESTP_Msk                           /*!< CEC Rx Stop                               */
#define CEC_CFGR_BREGEN_Pos      (5U)
#define CEC_CFGR_BREGEN_Msk      (0x1U << CEC_CFGR_BREGEN_Pos)                 /*!< 0x00000020 */
#define CEC_CFGR_BREGEN          CEC_CFGR_BREGEN_Msk                           /*!< CEC Bit Rising Error generation           */
#define CEC_CFGR_LBPEGEN_Pos     (6U)
#define CEC_CFGR_LBPEGEN_Msk     (0x1U << CEC_CFGR_LBPEGEN_Pos)                /*!< 0x00000040 */
#define CEC_CFGR_LBPEGEN         CEC_CFGR_LBPEGEN_Msk                          /*!< CEC Long Bit Period Error generation      */
#define CEC_CFGR_SFTOPT_Pos      (8U)
#define CEC_CFGR_SFTOPT_Msk      (0x1U << CEC_CFGR_SFTOPT_Pos)                 /*!< 0x00000100 */
#define CEC_CFGR_SFTOPT          CEC_CFGR_SFTOPT_Msk                           /*!< CEC Signal Free Time optional             */
#define CEC_CFGR_BRDNOGEN_Pos    (7U)
#define CEC_CFGR_BRDNOGEN_Msk    (0x1U << CEC_CFGR_BRDNOGEN_Pos)               /*!< 0x00000080 */
#define CEC_CFGR_BRDNOGEN        CEC_CFGR_BRDNOGEN_Msk                         /*!< CEC Broadcast No error generation         */
#define CEC_CFGR_OAR_Pos         (16U)
#define CEC_CFGR_OAR_Msk         (0x7FFFU << CEC_CFGR_OAR_Pos)                 /*!< 0x7FFF0000 */
#define CEC_CFGR_OAR             CEC_CFGR_OAR_Msk                              /*!< CEC Own Address                           */
#define CEC_CFGR_LSTN_Pos        (31U)
#define CEC_CFGR_LSTN_Msk        (0x1U << CEC_CFGR_LSTN_Pos)                   /*!< 0x80000000 */
#define CEC_CFGR_LSTN            CEC_CFGR_LSTN_Msk                             /*!< CEC Listen mode                           */

/*******************  Bit definition for CEC_TXDR register  *******************/
#define CEC_TXDR_TXD_Pos         (0U)
#define CEC_TXDR_TXD_Msk         (0xFFU << CEC_TXDR_TXD_Pos)                   /*!< 0x000000FF */
#define CEC_TXDR_TXD             CEC_TXDR_TXD_Msk                              /*!< CEC Tx Data                               */

/*******************  Bit definition for CEC_RXDR register  *******************/
#define CEC_TXDR_RXD_Pos         (0U)
#define CEC_TXDR_RXD_Msk         (0xFFU << CEC_TXDR_RXD_Pos)                   /*!< 0x000000FF */
#define CEC_TXDR_RXD             CEC_TXDR_RXD_Msk                              /*!< CEC Rx Data                               */

/*******************  Bit definition for CEC_ISR register  ********************/
#define CEC_ISR_RXBR_Pos         (0U)
#define CEC_ISR_RXBR_Msk         (0x1U << CEC_ISR_RXBR_Pos)                    /*!< 0x00000001 */
#define CEC_ISR_RXBR             CEC_ISR_RXBR_Msk                              /*!< CEC Rx-Byte Received                      */
#define CEC_ISR_RXEND_Pos        (1U)
#define CEC_ISR_RXEND_Msk        (0x1U << CEC_ISR_RXEND_Pos)                   /*!< 0x00000002 */
#define CEC_ISR_RXEND            CEC_ISR_RXEND_Msk                             /*!< CEC End Of Reception                      */
#define CEC_ISR_RXOVR_Pos        (2U)
#define CEC_ISR_RXOVR_Msk        (0x1U << CEC_ISR_RXOVR_Pos)                   /*!< 0x00000004 */
#define CEC_ISR_RXOVR            CEC_ISR_RXOVR_Msk                             /*!< CEC Rx-Overrun                            */
#define CEC_ISR_BRE_Pos          (3U)
#define CEC_ISR_BRE_Msk          (0x1U << CEC_ISR_BRE_Pos)                     /*!< 0x00000008 */
#define CEC_ISR_BRE              CEC_ISR_BRE_Msk                               /*!< CEC Rx Bit Rising Error                   */
#define CEC_ISR_SBPE_Pos         (4U)
#define CEC_ISR_SBPE_Msk         (0x1U << CEC_ISR_SBPE_Pos)                    /*!< 0x00000010 */
#define CEC_ISR_SBPE             CEC_ISR_SBPE_Msk                              /*!< CEC Rx Short Bit period Error             */
#define CEC_ISR_LBPE_Pos         (5U)
#define CEC_ISR_LBPE_Msk         (0x1U << CEC_ISR_LBPE_Pos)                    /*!< 0x00000020 */
#define CEC_ISR_LBPE             CEC_ISR_LBPE_Msk                              /*!< CEC Rx Long Bit period Error              */
#define CEC_ISR_RXACKE_Pos       (6U)
#define CEC_ISR_RXACKE_Msk       (0x1U << CEC_ISR_RXACKE_Pos)                  /*!< 0x00000040 */
#define CEC_ISR_RXACKE           CEC_ISR_RXACKE_Msk                            /*!< CEC Rx Missing Acknowledge                */
#define CEC_ISR_ARBLST_Pos       (7U)
#define CEC_ISR_ARBLST_Msk       (0x1U << CEC_ISR_ARBLST_Pos)                  /*!< 0x00000080 */
#define CEC_ISR_ARBLST           CEC_ISR_ARBLST_Msk                            /*!< CEC Arbitration Lost                      */
#define CEC_ISR_TXBR_Pos         (8U)
#define CEC_ISR_TXBR_Msk         (0x1U << CEC_ISR_TXBR_Pos)                    /*!< 0x00000100 */
#define CEC_ISR_TXBR             CEC_ISR_TXBR_Msk                              /*!< CEC Tx Byte Request                       */
#define CEC_ISR_TXEND_Pos        (9U)
#define CEC_ISR_TXEND_Msk        (0x1U << CEC_ISR_TXEND_Pos)                   /*!< 0x00000200 */
#define CEC_ISR_TXEND            CEC_ISR_TXEND_Msk                             /*!< CEC End of Transmission                   */
#define CEC_ISR_TXUDR_Pos        (10U)
#define CEC_ISR_TXUDR_Msk        (0x1U << CEC_ISR_TXUDR_Pos)                   /*!< 0x00000400 */
#define CEC_ISR_TXUDR            CEC_ISR_TXUDR_Msk                             /*!< CEC Tx-Buffer Underrun                    */
#define CEC_ISR_TXERR_Pos        (11U)
#define CEC_ISR_TXERR_Msk        (0x1U << CEC_ISR_TXERR_Pos)                   /*!< 0x00000800 */
#define CEC_ISR_TXERR            CEC_ISR_TXERR_Msk                             /*!< CEC Tx-Error                              */
#define CEC_ISR_TXACKE_Pos       (12U)
#define CEC_ISR_TXACKE_Msk       (0x1U << CEC_ISR_TXACKE_Pos)                  /*!< 0x00001000 */
#define CEC_ISR_TXACKE           CEC_ISR_TXACKE_Msk                            /*!< CEC Tx Missing Acknowledge                */

/*******************  Bit definition for CEC_IER register  ********************/
#define CEC_IER_RXBRIE_Pos       (0U)
#define CEC_IER_RXBRIE_Msk       (0x1U << CEC_IER_RXBRIE_Pos)                  /*!< 0x00000001 */
#define CEC_IER_RXBRIE           CEC_IER_RXBRIE_Msk                            /*!< CEC Rx-Byte Received IT Enable            */
#define CEC_IER_RXENDIE_Pos      (1U)
#define CEC_IER_RXENDIE_Msk      (0x1U << CEC_IER_RXENDIE_Pos)                 /*!< 0x00000002 */
#define CEC_IER_RXENDIE          CEC_IER_RXENDIE_Msk                           /*!< CEC End Of Reception IT Enable            */
#define CEC_IER_RXOVRIE_Pos      (2U)
#define CEC_IER_RXOVRIE_Msk      (0x1U << CEC_IER_RXOVRIE_Pos)                 /*!< 0x00000004 */
#define CEC_IER_RXOVRIE          CEC_IER_RXOVRIE_Msk                           /*!< CEC Rx-Overrun IT Enable                  */
#define CEC_IER_BREIE_Pos        (3U)
#define CEC_IER_BREIE_Msk        (0x1U << CEC_IER_BREIE_Pos)                   /*!< 0x00000008 */
#define CEC_IER_BREIE            CEC_IER_BREIE_Msk                             /*!< CEC Rx Bit Rising Error IT Enable         */
#define CEC_IER_SBPEIE_Pos       (4U)
#define CEC_IER_SBPEIE_Msk       (0x1U << CEC_IER_SBPEIE_Pos)                  /*!< 0x00000010 */
#define CEC_IER_SBPEIE           CEC_IER_SBPEIE_Msk                            /*!< CEC Rx Short Bit period Error IT Enable   */
#define CEC_IER_LBPEIE_Pos       (5U)
#define CEC_IER_LBPEIE_Msk       (0x1U << CEC_IER_LBPEIE_Pos)                  /*!< 0x00000020 */
#define CEC_IER_LBPEIE           CEC_IER_LBPEIE_Msk                            /*!< CEC Rx Long Bit period Error IT Enable    */
#define CEC_IER_RXACKEIE_Pos     (6U)
#define CEC_IER_RXACKEIE_Msk     (0x1U << CEC_IER_RXACKEIE_Pos)                /*!< 0x00000040 */
#define CEC_IER_RXACKEIE         CEC_IER_RXACKEIE_Msk                          /*!< CEC Rx Missing Acknowledge IT Enable      */
#define CEC_IER_ARBLSTIE_Pos     (7U)
#define CEC_IER_ARBLSTIE_Msk     (0x1U << CEC_IER_ARBLSTIE_Pos)                /*!< 0x00000080 */
#define CEC_IER_ARBLSTIE         CEC_IER_ARBLSTIE_Msk                          /*!< CEC Arbitration Lost IT Enable            */
#define CEC_IER_TXBRIE_Pos       (8U)
#define CEC_IER_TXBRIE_Msk       (0x1U << CEC_IER_TXBRIE_Pos)                  /*!< 0x00000100 */
#define CEC_IER_TXBRIE           CEC_IER_TXBRIE_Msk                            /*!< CEC Tx Byte Request  IT Enable            */
#define CEC_IER_TXENDIE_Pos      (9U)
#define CEC_IER_TXENDIE_Msk      (0x1U << CEC_IER_TXENDIE_Pos)                 /*!< 0x00000200 */
#define CEC_IER_TXENDIE          CEC_IER_TXENDIE_Msk                           /*!< CEC End of Transmission IT Enable         */
#define CEC_IER_TXUDRIE_Pos      (10U)
#define CEC_IER_TXUDRIE_Msk      (0x1U << CEC_IER_TXUDRIE_Pos)                 /*!< 0x00000400 */
#define CEC_IER_TXUDRIE          CEC_IER_TXUDRIE_Msk                           /*!< CEC Tx-Buffer Underrun IT Enable          */
#define CEC_IER_TXERRIE_Pos      (11U)
#define CEC_IER_TXERRIE_Msk      (0x1U << CEC_IER_TXERRIE_Pos)                 /*!< 0x00000800 */
#define CEC_IER_TXERRIE          CEC_IER_TXERRIE_Msk                           /*!< CEC Tx-Error IT Enable                    */
#define CEC_IER_TXACKEIE_Pos     (12U)
#define CEC_IER_TXACKEIE_Msk     (0x1U << CEC_IER_TXACKEIE_Pos)                /*!< 0x00001000 */
#define CEC_IER_TXACKEIE         CEC_IER_TXACKEIE_Msk                          /*!< CEC Tx Missing Acknowledge IT Enable      */

/******************************************************************************/
/*                                                                            */
/*                          CRC calculation unit                              */
/*                                                                            */
/******************************************************************************/
/*******************  Bit definition for CRC_DR register  *********************/
#define CRC_DR_DR_Pos            (0U)
#define CRC_DR_DR_Msk            (0xFFFFFFFFU << CRC_DR_DR_Pos)                /*!< 0xFFFFFFFF */
#define CRC_DR_DR                CRC_DR_DR_Msk                                 /*!< Data register bits */

/*******************  Bit definition for CRC_IDR register  ********************/
#define CRC_IDR_IDR_Pos          (0U)
#define CRC_IDR_IDR_Msk          (0xFFFFFFFFU << CRC_IDR_IDR_Pos)              /*!< 0xFFFFFFFF */
#define CRC_IDR_IDR              CRC_IDR_IDR_Msk                               /*!< General-purpose 32-bit data register bits */

/********************  Bit definition for CRC_CR register  ********************/
#define CRC_CR_RESET_Pos         (0U)
#define CRC_CR_RESET_Msk         (0x1U << CRC_CR_RESET_Pos)                    /*!< 0x00000001 */
#define CRC_CR_RESET             CRC_CR_RESET_Msk                              /*!< RESET the CRC computation unit bit */
#define CRC_CR_POLYSIZE_Pos      (3U)
#define CRC_CR_POLYSIZE_Msk      (0x3U << CRC_CR_POLYSIZE_Pos)                 /*!< 0x00000018 */
#define CRC_CR_POLYSIZE          CRC_CR_POLYSIZE_Msk                           /*!< Polynomial size bits */
#define CRC_CR_POLYSIZE_0        (0x1U << CRC_CR_POLYSIZE_Pos)                 /*!< 0x00000008 */
#define CRC_CR_POLYSIZE_1        (0x2U << CRC_CR_POLYSIZE_Pos)                 /*!< 0x00000010 */
#define CRC_CR_REV_IN_Pos        (5U)
#define CRC_CR_REV_IN_Msk        (0x3U << CRC_CR_REV_IN_Pos)                   /*!< 0x00000060 */
#define CRC_CR_REV_IN            CRC_CR_REV_IN_Msk                             /*!< REV_IN Reverse Input Data bits */
#define CRC_CR_REV_IN_0          (0x1U << CRC_CR_REV_IN_Pos)                   /*!< 0x00000020 */
#define CRC_CR_REV_IN_1          (0x2U << CRC_CR_REV_IN_Pos)                   /*!< 0x00000040 */
#define CRC_CR_REV_OUT_Pos       (7U)
#define CRC_CR_REV_OUT_Msk       (0x1U << CRC_CR_REV_OUT_Pos)                  /*!< 0x00000080 */
#define CRC_CR_REV_OUT           CRC_CR_REV_OUT_Msk                            /*!< REV_OUT Reverse Output Data bits */

/*******************  Bit definition for CRC_INIT register  *******************/
#define CRC_INIT_INIT_Pos        (0U)
#define CRC_INIT_INIT_Msk        (0xFFFFFFFFU << CRC_INIT_INIT_Pos)            /*!< 0xFFFFFFFF */
#define CRC_INIT_INIT            CRC_INIT_INIT_Msk                             /*!< Initial CRC value bits */

/*******************  Bit definition for CRC_POL register  ********************/
#define CRC_POL_POL_Pos          (0U)
#define CRC_POL_POL_Msk          (0xFFFFFFFFU << CRC_POL_POL_Pos)              /*!< 0xFFFFFFFF */
#define CRC_POL_POL              CRC_POL_POL_Msk                               /*!< Coefficients of the polynomial */

/******************************************************************************/
/*                                                                            */
/*                          CRS Clock Recovery System                         */
/******************************************************************************/

/*******************  Bit definition for CRS_CR register  *********************/
#define CRS_CR_SYNCOKIE_Pos       (0U)
#define CRS_CR_SYNCOKIE_Msk       (0x1U << CRS_CR_SYNCOKIE_Pos)                /*!< 0x00000001 */
#define CRS_CR_SYNCOKIE           CRS_CR_SYNCOKIE_Msk                          /*!< SYNC event OK interrupt enable */
#define CRS_CR_SYNCWARNIE_Pos     (1U)
#define CRS_CR_SYNCWARNIE_Msk     (0x1U << CRS_CR_SYNCWARNIE_Pos)              /*!< 0x00000002 */
#define CRS_CR_SYNCWARNIE         CRS_CR_SYNCWARNIE_Msk                        /*!< SYNC warning interrupt enable */
#define CRS_CR_ERRIE_Pos          (2U)
#define CRS_CR_ERRIE_Msk          (0x1U << CRS_CR_ERRIE_Pos)                   /*!< 0x00000004 */
#define CRS_CR_ERRIE              CRS_CR_ERRIE_Msk                             /*!< SYNC error or trimming error interrupt enable */
#define CRS_CR_ESYNCIE_Pos        (3U)
#define CRS_CR_ESYNCIE_Msk        (0x1U << CRS_CR_ESYNCIE_Pos)                 /*!< 0x00000008 */
#define CRS_CR_ESYNCIE            CRS_CR_ESYNCIE_Msk                           /*!< Expected SYNC interrupt enable */
#define CRS_CR_CEN_Pos            (5U)
#define CRS_CR_CEN_Msk            (0x1U << CRS_CR_CEN_Pos)                     /*!< 0x00000020 */
#define CRS_CR_CEN                CRS_CR_CEN_Msk                               /*!< Frequency error counter enable */
#define CRS_CR_AUTOTRIMEN_Pos     (6U)
#define CRS_CR_AUTOTRIMEN_Msk     (0x1U << CRS_CR_AUTOTRIMEN_Pos)              /*!< 0x00000040 */
#define CRS_CR_AUTOTRIMEN         CRS_CR_AUTOTRIMEN_Msk                        /*!< Automatic trimming enable */
#define CRS_CR_SWSYNC_Pos         (7U)
#define CRS_CR_SWSYNC_Msk         (0x1U << CRS_CR_SWSYNC_Pos)                  /*!< 0x00000080 */
#define CRS_CR_SWSYNC             CRS_CR_SWSYNC_Msk                            /*!< Generate software SYNC event */
#define CRS_CR_TRIM_Pos           (8U)
#define CRS_CR_TRIM_Msk           (0x3FU << CRS_CR_TRIM_Pos)                   /*!< 0x00003F00 */
#define CRS_CR_TRIM               CRS_CR_TRIM_Msk                              /*!< HSI48 oscillator smooth trimming */

/*******************  Bit definition for CRS_CFGR register  *********************/
#define CRS_CFGR_RELOAD_Pos       (0U)
#define CRS_CFGR_RELOAD_Msk       (0xFFFFU << CRS_CFGR_RELOAD_Pos)             /*!< 0x0000FFFF */
#define CRS_CFGR_RELOAD           CRS_CFGR_RELOAD_Msk                          /*!< Counter reload value */
#define CRS_CFGR_FELIM_Pos        (16U)
#define CRS_CFGR_FELIM_Msk        (0xFFU << CRS_CFGR_FELIM_Pos)                /*!< 0x00FF0000 */
#define CRS_CFGR_FELIM            CRS_CFGR_FELIM_Msk                           /*!< Frequency error limit */

#define CRS_CFGR_SYNCDIV_Pos      (24U)
#define CRS_CFGR_SYNCDIV_Msk      (0x7U << CRS_CFGR_SYNCDIV_Pos)               /*!< 0x07000000 */
#define CRS_CFGR_SYNCDIV          CRS_CFGR_SYNCDIV_Msk                         /*!< SYNC divider */
#define CRS_CFGR_SYNCDIV_0        (0x1U << CRS_CFGR_SYNCDIV_Pos)               /*!< 0x01000000 */
#define CRS_CFGR_SYNCDIV_1        (0x2U << CRS_CFGR_SYNCDIV_Pos)               /*!< 0x02000000 */
#define CRS_CFGR_SYNCDIV_2        (0x4U << CRS_CFGR_SYNCDIV_Pos)               /*!< 0x04000000 */

#define CRS_CFGR_SYNCSRC_Pos      (28U)
#define CRS_CFGR_SYNCSRC_Msk      (0x3U << CRS_CFGR_SYNCSRC_Pos)               /*!< 0x30000000 */
#define CRS_CFGR_SYNCSRC          CRS_CFGR_SYNCSRC_Msk                         /*!< SYNC signal source selection */
#define CRS_CFGR_SYNCSRC_0        (0x1U << CRS_CFGR_SYNCSRC_Pos)               /*!< 0x10000000 */
#define CRS_CFGR_SYNCSRC_1        (0x2U << CRS_CFGR_SYNCSRC_Pos)               /*!< 0x20000000 */

#define CRS_CFGR_SYNCPOL_Pos      (31U)
#define CRS_CFGR_SYNCPOL_Msk      (0x1U << CRS_CFGR_SYNCPOL_Pos)               /*!< 0x80000000 */
#define CRS_CFGR_SYNCPOL          CRS_CFGR_SYNCPOL_Msk                         /*!< SYNC polarity selection */

/*******************  Bit definition for CRS_ISR register  *********************/
#define CRS_ISR_SYNCOKF_Pos       (0U)
#define CRS_ISR_SYNCOKF_Msk       (0x1U << CRS_ISR_SYNCOKF_Pos)                /*!< 0x00000001 */
#define CRS_ISR_SYNCOKF           CRS_ISR_SYNCOKF_Msk                          /*!< SYNC event OK flag */
#define CRS_ISR_SYNCWARNF_Pos     (1U)
#define CRS_ISR_SYNCWARNF_Msk     (0x1U << CRS_ISR_SYNCWARNF_Pos)              /*!< 0x00000002 */
#define CRS_ISR_SYNCWARNF         CRS_ISR_SYNCWARNF_Msk                        /*!< SYNC warning flag */
#define CRS_ISR_ERRF_Pos          (2U)
#define CRS_ISR_ERRF_Msk          (0x1U << CRS_ISR_ERRF_Pos)                   /*!< 0x00000004 */
#define CRS_ISR_ERRF              CRS_ISR_ERRF_Msk                             /*!< Error flag */
#define CRS_ISR_ESYNCF_Pos        (3U)
#define CRS_ISR_ESYNCF_Msk        (0x1U << CRS_ISR_ESYNCF_Pos)                 /*!< 0x00000008 */
#define CRS_ISR_ESYNCF            CRS_ISR_ESYNCF_Msk                           /*!< Expected SYNC flag */
#define CRS_ISR_SYNCERR_Pos       (8U)
#define CRS_ISR_SYNCERR_Msk       (0x1U << CRS_ISR_SYNCERR_Pos)                /*!< 0x00000100 */
#define CRS_ISR_SYNCERR           CRS_ISR_SYNCERR_Msk                          /*!< SYNC error */
#define CRS_ISR_SYNCMISS_Pos      (9U)
#define CRS_ISR_SYNCMISS_Msk      (0x1U << CRS_ISR_SYNCMISS_Pos)               /*!< 0x00000200 */
#define CRS_ISR_SYNCMISS          CRS_ISR_SYNCMISS_Msk                         /*!< SYNC missed */
#define CRS_ISR_TRIMOVF_Pos       (10U)
#define CRS_ISR_TRIMOVF_Msk       (0x1U << CRS_ISR_TRIMOVF_Pos)                /*!< 0x00000400 */
#define CRS_ISR_TRIMOVF           CRS_ISR_TRIMOVF_Msk                          /*!< Trimming overflow or underflow */
#define CRS_ISR_FEDIR_Pos         (15U)
#define CRS_ISR_FEDIR_Msk         (0x1U << CRS_ISR_FEDIR_Pos)                  /*!< 0x00008000 */
#define CRS_ISR_FEDIR             CRS_ISR_FEDIR_Msk                            /*!< Frequency error direction */
#define CRS_ISR_FECAP_Pos         (16U)
#define CRS_ISR_FECAP_Msk         (0xFFFFU << CRS_ISR_FECAP_Pos)               /*!< 0xFFFF0000 */
#define CRS_ISR_FECAP             CRS_ISR_FECAP_Msk                            /*!< Frequency error capture */

/*******************  Bit definition for CRS_ICR register  *********************/
#define CRS_ICR_SYNCOKC_Pos       (0U)
#define CRS_ICR_SYNCOKC_Msk       (0x1U << CRS_ICR_SYNCOKC_Pos)                /*!< 0x00000001 */
#define CRS_ICR_SYNCOKC           CRS_ICR_SYNCOKC_Msk                          /*!< SYNC event OK clear flag */
#define CRS_ICR_SYNCWARNC_Pos     (1U)
#define CRS_ICR_SYNCWARNC_Msk     (0x1U << CRS_ICR_SYNCWARNC_Pos)              /*!< 0x00000002 */
#define CRS_ICR_SYNCWARNC         CRS_ICR_SYNCWARNC_Msk                        /*!< SYNC warning clear flag */
#define CRS_ICR_ERRC_Pos          (2U)
#define CRS_ICR_ERRC_Msk          (0x1U << CRS_ICR_ERRC_Pos)                   /*!< 0x00000004 */
#define CRS_ICR_ERRC              CRS_ICR_ERRC_Msk                             /*!< Error clear flag */
#define CRS_ICR_ESYNCC_Pos        (3U)
#define CRS_ICR_ESYNCC_Msk        (0x1U << CRS_ICR_ESYNCC_Pos)                 /*!< 0x00000008 */
#define CRS_ICR_ESYNCC            CRS_ICR_ESYNCC_Msk                           /*!< Expected SYNC clear flag */

/******************************************************************************/
/*                                                                            */
/*                            Crypto Processor                                */
/*                                                                            */
/******************************************************************************/
/******************* Bits definition for CRYP_CR register  ********************/
#define CRYP_CR_ALGODIR_Pos              (2U)
#define CRYP_CR_ALGODIR_Msk              (0x1U << CRYP_CR_ALGODIR_Pos)         /*!< 0x00000004 */
#define CRYP_CR_ALGODIR                  CRYP_CR_ALGODIR_Msk

#define CRYP_CR_ALGOMODE_Pos             (3U)
#define CRYP_CR_ALGOMODE_Msk             (0x10007U << CRYP_CR_ALGOMODE_Pos)    /*!< 0x00080038 */
#define CRYP_CR_ALGOMODE                 CRYP_CR_ALGOMODE_Msk
#define CRYP_CR_ALGOMODE_0               (0x00001U << CRYP_CR_ALGOMODE_Pos)    /*!< 0x00000008 */
#define CRYP_CR_ALGOMODE_1               (0x00002U << CRYP_CR_ALGOMODE_Pos)    /*!< 0x00000010 */
#define CRYP_CR_ALGOMODE_2               (0x00004U << CRYP_CR_ALGOMODE_Pos)    /*!< 0x00000020 */
#define CRYP_CR_ALGOMODE_TDES_ECB        ((uint32_t)0x00000000)
#define CRYP_CR_ALGOMODE_TDES_CBC_Pos    (3U)
#define CRYP_CR_ALGOMODE_TDES_CBC_Msk    (0x1U << CRYP_CR_ALGOMODE_TDES_CBC_Pos) /*!< 0x00000008 */
#define CRYP_CR_ALGOMODE_TDES_CBC        CRYP_CR_ALGOMODE_TDES_CBC_Msk
#define CRYP_CR_ALGOMODE_DES_ECB_Pos     (4U)
#define CRYP_CR_ALGOMODE_DES_ECB_Msk     (0x1U << CRYP_CR_ALGOMODE_DES_ECB_Pos) /*!< 0x00000010 */
#define CRYP_CR_ALGOMODE_DES_ECB         CRYP_CR_ALGOMODE_DES_ECB_Msk
#define CRYP_CR_ALGOMODE_DES_CBC_Pos     (3U)
#define CRYP_CR_ALGOMODE_DES_CBC_Msk     (0x3U << CRYP_CR_ALGOMODE_DES_CBC_Pos) /*!< 0x00000018 */
#define CRYP_CR_ALGOMODE_DES_CBC         CRYP_CR_ALGOMODE_DES_CBC_Msk
#define CRYP_CR_ALGOMODE_AES_ECB_Pos     (5U)
#define CRYP_CR_ALGOMODE_AES_ECB_Msk     (0x1U << CRYP_CR_ALGOMODE_AES_ECB_Pos) /*!< 0x00000020 */
#define CRYP_CR_ALGOMODE_AES_ECB         CRYP_CR_ALGOMODE_AES_ECB_Msk
#define CRYP_CR_ALGOMODE_AES_CBC_Pos     (3U)
#define CRYP_CR_ALGOMODE_AES_CBC_Msk     (0x5U << CRYP_CR_ALGOMODE_AES_CBC_Pos) /*!< 0x00000028 */
#define CRYP_CR_ALGOMODE_AES_CBC         CRYP_CR_ALGOMODE_AES_CBC_Msk
#define CRYP_CR_ALGOMODE_AES_CTR_Pos     (4U)
#define CRYP_CR_ALGOMODE_AES_CTR_Msk     (0x3U << CRYP_CR_ALGOMODE_AES_CTR_Pos) /*!< 0x00000030 */
#define CRYP_CR_ALGOMODE_AES_CTR         CRYP_CR_ALGOMODE_AES_CTR_Msk
#define CRYP_CR_ALGOMODE_AES_GCM_Pos     (19U)
#define CRYP_CR_ALGOMODE_AES_GCM_Msk     (0x1U << CRYP_CR_ALGOMODE_AES_GCM_Pos) /*!< 0x00080000 */
#define CRYP_CR_ALGOMODE_AES_GCM         CRYP_CR_ALGOMODE_AES_GCM_Msk
#define CRYP_CR_ALGOMODE_AES_CCM_Pos     (3U)
#define CRYP_CR_ALGOMODE_AES_CCM_Msk     (0x10001U << CRYP_CR_ALGOMODE_AES_CCM_Pos) /*!< 0x00080008 */
#define CRYP_CR_ALGOMODE_AES_CCM         CRYP_CR_ALGOMODE_AES_CCM_Msk
#define CRYP_CR_ALGOMODE_AES_KEY_Pos     (3U)
#define CRYP_CR_ALGOMODE_AES_KEY_Msk     (0x7U << CRYP_CR_ALGOMODE_AES_KEY_Pos) /*!< 0x00000038 */
#define CRYP_CR_ALGOMODE_AES_KEY         CRYP_CR_ALGOMODE_AES_KEY_Msk

#define CRYP_CR_DATATYPE_Pos             (6U)
#define CRYP_CR_DATATYPE_Msk             (0x3U << CRYP_CR_DATATYPE_Pos)        /*!< 0x000000C0 */
#define CRYP_CR_DATATYPE                 CRYP_CR_DATATYPE_Msk
#define CRYP_CR_DATATYPE_0               (0x1U << CRYP_CR_DATATYPE_Pos)        /*!< 0x00000040 */
#define CRYP_CR_DATATYPE_1               (0x2U << CRYP_CR_DATATYPE_Pos)        /*!< 0x00000080 */
#define CRYP_CR_KEYSIZE_Pos              (8U)
#define CRYP_CR_KEYSIZE_Msk              (0x3U << CRYP_CR_KEYSIZE_Pos)         /*!< 0x00000300 */
#define CRYP_CR_KEYSIZE                  CRYP_CR_KEYSIZE_Msk
#define CRYP_CR_KEYSIZE_0                (0x1U << CRYP_CR_KEYSIZE_Pos)         /*!< 0x00000100 */
#define CRYP_CR_KEYSIZE_1                (0x2U << CRYP_CR_KEYSIZE_Pos)         /*!< 0x00000200 */
#define CRYP_CR_FFLUSH_Pos               (14U)
#define CRYP_CR_FFLUSH_Msk               (0x1U << CRYP_CR_FFLUSH_Pos)          /*!< 0x00004000 */
#define CRYP_CR_FFLUSH                   CRYP_CR_FFLUSH_Msk
#define CRYP_CR_CRYPEN_Pos               (15U)
#define CRYP_CR_CRYPEN_Msk               (0x1U << CRYP_CR_CRYPEN_Pos)          /*!< 0x00008000 */
#define CRYP_CR_CRYPEN                   CRYP_CR_CRYPEN_Msk

#define CRYP_CR_GCM_CCMPH_Pos            (16U)
#define CRYP_CR_GCM_CCMPH_Msk            (0x3U << CRYP_CR_GCM_CCMPH_Pos)       /*!< 0x00030000 */
#define CRYP_CR_GCM_CCMPH                CRYP_CR_GCM_CCMPH_Msk
#define CRYP_CR_GCM_CCMPH_0              (0x1U << CRYP_CR_GCM_CCMPH_Pos)       /*!< 0x00010000 */
#define CRYP_CR_GCM_CCMPH_1              (0x2U << CRYP_CR_GCM_CCMPH_Pos)       /*!< 0x00020000 */
#define CRYP_CR_ALGOMODE_3               ((uint32_t)0x00080000)
#define CRYP_CR_NPBLB_Pos                (20U)
#define CRYP_CR_NPBLB_Msk                (0xFU << CRYP_CR_NPBLB_Pos)		   /*!< 0x00F00000 */
#define CRYP_CR_NPBLB                    CRYP_CR_NPBLB_Msk

/****************** Bits definition for CRYP_SR register  *********************/
#define CRYP_SR_IFEM_Pos                 (0U)
#define CRYP_SR_IFEM_Msk                 (0x1U << CRYP_SR_IFEM_Pos)            /*!< 0x00000001 */
#define CRYP_SR_IFEM                     CRYP_SR_IFEM_Msk
#define CRYP_SR_IFNF_Pos                 (1U)
#define CRYP_SR_IFNF_Msk                 (0x1U << CRYP_SR_IFNF_Pos)            /*!< 0x00000002 */
#define CRYP_SR_IFNF                     CRYP_SR_IFNF_Msk
#define CRYP_SR_OFNE_Pos                 (2U)
#define CRYP_SR_OFNE_Msk                 (0x1U << CRYP_SR_OFNE_Pos)            /*!< 0x00000004 */
#define CRYP_SR_OFNE                     CRYP_SR_OFNE_Msk
#define CRYP_SR_OFFU_Pos                 (3U)
#define CRYP_SR_OFFU_Msk                 (0x1U << CRYP_SR_OFFU_Pos)            /*!< 0x00000008 */
#define CRYP_SR_OFFU                     CRYP_SR_OFFU_Msk
#define CRYP_SR_BUSY_Pos                 (4U)
#define CRYP_SR_BUSY_Msk                 (0x1U << CRYP_SR_BUSY_Pos)            /*!< 0x00000010 */
#define CRYP_SR_BUSY                     CRYP_SR_BUSY_Msk
/****************** Bits definition for CRYP_DMACR register  ******************/
#define CRYP_DMACR_DIEN_Pos              (0U)
#define CRYP_DMACR_DIEN_Msk              (0x1U << CRYP_DMACR_DIEN_Pos)         /*!< 0x00000001 */
#define CRYP_DMACR_DIEN                  CRYP_DMACR_DIEN_Msk
#define CRYP_DMACR_DOEN_Pos              (1U)
#define CRYP_DMACR_DOEN_Msk              (0x1U << CRYP_DMACR_DOEN_Pos)         /*!< 0x00000002 */
#define CRYP_DMACR_DOEN                  CRYP_DMACR_DOEN_Msk
/*****************  Bits definition for CRYP_IMSCR register  ******************/
#define CRYP_IMSCR_INIM_Pos              (0U)
#define CRYP_IMSCR_INIM_Msk              (0x1U << CRYP_IMSCR_INIM_Pos)         /*!< 0x00000001 */
#define CRYP_IMSCR_INIM                  CRYP_IMSCR_INIM_Msk
#define CRYP_IMSCR_OUTIM_Pos             (1U)
#define CRYP_IMSCR_OUTIM_Msk             (0x1U << CRYP_IMSCR_OUTIM_Pos)        /*!< 0x00000002 */
#define CRYP_IMSCR_OUTIM                 CRYP_IMSCR_OUTIM_Msk
/****************** Bits definition for CRYP_RISR register  *******************/
#define CRYP_RISR_OUTRIS_Pos             (0U)
#define CRYP_RISR_OUTRIS_Msk             (0x1U << CRYP_RISR_OUTRIS_Pos)        /*!< 0x00000001 */
#define CRYP_RISR_OUTRIS                 CRYP_RISR_OUTRIS_Msk
#define CRYP_RISR_INRIS_Pos              (1U)
#define CRYP_RISR_INRIS_Msk              (0x1U << CRYP_RISR_INRIS_Pos)         /*!< 0x00000002 */
#define CRYP_RISR_INRIS                  CRYP_RISR_INRIS_Msk
/****************** Bits definition for CRYP_MISR register  *******************/
#define CRYP_MISR_INMIS_Pos              (0U)
#define CRYP_MISR_INMIS_Msk              (0x1U << CRYP_MISR_INMIS_Pos)         /*!< 0x00000001 */
#define CRYP_MISR_INMIS                  CRYP_MISR_INMIS_Msk
#define CRYP_MISR_OUTMIS_Pos             (1U)
#define CRYP_MISR_OUTMIS_Msk             (0x1U << CRYP_MISR_OUTMIS_Pos)        /*!< 0x00000002 */
#define CRYP_MISR_OUTMIS                 CRYP_MISR_OUTMIS_Msk

/**********************  Bit definition for CRYP_HWCFGR register  ***************/
#define CRYP_HWCFGR_CFG1_Pos  (0U)
#define CRYP_HWCFGR_CFG1_Msk  (0xFU << CRYP_HWCFGR_CFG1_Pos)          /*!< 0x0000000F */
#define CRYP_HWCFGR_CFG1      CRYP_HWCFGR_CFG1_Msk                    /*!< HW Generic 1 */
#define CRYP_HWCFGR_CFG2_Pos  (4U)
#define CRYP_HWCFGR_CFG2_Msk  (0xFU << CRYP_HWCFGR_CFG2_Pos)          /*!< 0x000000F0 */
#define CRYP_HWCFGR_CFG2      CRYP_HWCFGR_CFG2_Msk                    /*!< HW Generic 2 */
#define CRYP_HWCFGR_CFG3_Pos  (8U)
#define CRYP_HWCFGR_CFG3_Msk  (0xFU << CRYP_HWCFGR_CFG3_Pos)          /*!< 0x00000F00 */
#define CRYP_HWCFGR_CFG3      CRYP_HWCFGR_CFG3_Msk                    /*!< HW Generic 3 */
#define CRYP_HWCFGR_CFG4_Pos  (12U)
#define CRYP_HWCFGR_CFG4_Msk  (0xFU << CRYP_HWCFGR_CFG4_Pos)          /*!< 0x0000F000 */
#define CRYP_HWCFGR_CFG4      CRYP_HWCFGR_CFG4_Msk                    /*!< HW Generic 4 */

/**********************  Bit definition for CRYP_VERR register  *****************/
#define CRYP_VERR_VER_Pos      (0U)
#define CRYP_VERR_VER_Msk      (0xFFU << CRYP_VERR_VER_Pos)               /*!< 0x000000FF */
#define CRYP_VERR_VER          CRYP_VERR_VER_Msk                         /*!< Revision number */

/**********************  Bit definition for CRYP_IPIDR register  ****************/
#define CRYP_IPIDR_IPID_Pos       (0U)
#define CRYP_IPIDR_IPID_Msk       (0xFFFFFFFFU << CRYP_IPIDR_IPID_Pos)         /*!< 0xFFFFFFFF */
#define CRYP_IPIDR_IPID           CRYP_IPIDR_IPID_Msk                          /*!< IP Identification */

/**********************  Bit definition for CRYP_SIDR register  *****************/
#define CRYP_MID_MID_Pos         (0U)
#define CRYP_MID_MID_Msk         (0xFFFFFFFFU << CRYP_MID_MID_Pos)           /*!< 0xFFFFFFFF */
#define CRYP_MID_MID             CRYP_MID_MID_Msk                            /*!< IP size identification */

/******************************************************************************/
/*                                                                            */
/*                      Digital to Analog Converter                           */
/*                                                                            */
/******************************************************************************/
/********************  Bit definition for DAC_CR register  ********************/
#define DAC_CR_EN1_Pos              (0U)
#define DAC_CR_EN1_Msk              (0x1U << DAC_CR_EN1_Pos)                   /*!< 0x00000001 */
#define DAC_CR_EN1                  DAC_CR_EN1_Msk                             /*!<DAC channel1 enable */
#define DAC_CR_TEN1_Pos             (1U)
#define DAC_CR_TEN1_Msk             (0x1U << DAC_CR_TEN1_Pos)                  /*!< 0x00000002 */
#define DAC_CR_TEN1                 DAC_CR_TEN1_Msk                            /*!<DAC channel1 Trigger enable */

#define DAC_CR_TSEL1_Pos            (2U)
#define DAC_CR_TSEL1_Msk            (0xFU << DAC_CR_TSEL1_Pos)                 /*!< 0x0000003C */
#define DAC_CR_TSEL1                DAC_CR_TSEL1_Msk                           /*!<TSEL1[2:0] (DAC channel1 Trigger selection) */
#define DAC_CR_TSEL1_0              (0x1U << DAC_CR_TSEL1_Pos)                 /*!< 0x00000004 */
#define DAC_CR_TSEL1_1              (0x2U << DAC_CR_TSEL1_Pos)                 /*!< 0x00000008 */
#define DAC_CR_TSEL1_2              (0x4U << DAC_CR_TSEL1_Pos)                 /*!< 0x00000010 */
#define DAC_CR_TSEL1_3              (0x8U << DAC_CR_TSEL1_Pos)                 /*!< 0x00000020 */


#define DAC_CR_WAVE1_Pos            (6U)
#define DAC_CR_WAVE1_Msk            (0x3U << DAC_CR_WAVE1_Pos)                 /*!< 0x000000C0 */
#define DAC_CR_WAVE1                DAC_CR_WAVE1_Msk                           /*!<WAVE1[1:0] (DAC channel1 noise/triangle wave generation enable) */
#define DAC_CR_WAVE1_0              (0x1U << DAC_CR_WAVE1_Pos)                 /*!< 0x00000040 */
#define DAC_CR_WAVE1_1              (0x2U << DAC_CR_WAVE1_Pos)                 /*!< 0x00000080 */

#define DAC_CR_MAMP1_Pos            (8U)
#define DAC_CR_MAMP1_Msk            (0xFU << DAC_CR_MAMP1_Pos)                 /*!< 0x00000F00 */
#define DAC_CR_MAMP1                DAC_CR_MAMP1_Msk                           /*!<MAMP1[3:0] (DAC channel1 Mask/Amplitude selector) */
#define DAC_CR_MAMP1_0              (0x1U << DAC_CR_MAMP1_Pos)                 /*!< 0x00000100 */
#define DAC_CR_MAMP1_1              (0x2U << DAC_CR_MAMP1_Pos)                 /*!< 0x00000200 */
#define DAC_CR_MAMP1_2              (0x4U << DAC_CR_MAMP1_Pos)                 /*!< 0x00000400 */
#define DAC_CR_MAMP1_3              (0x8U << DAC_CR_MAMP1_Pos)                 /*!< 0x00000800 */

#define DAC_CR_DMAEN1_Pos           (12U)
#define DAC_CR_DMAEN1_Msk           (0x1U << DAC_CR_DMAEN1_Pos)                /*!< 0x00001000 */
#define DAC_CR_DMAEN1               DAC_CR_DMAEN1_Msk                          /*!<DAC channel1 DMA enable */
#define DAC_CR_DMAUDRIE1_Pos        (13U)
#define DAC_CR_DMAUDRIE1_Msk        (0x1U << DAC_CR_DMAUDRIE1_Pos)             /*!< 0x00002000 */
#define DAC_CR_DMAUDRIE1            DAC_CR_DMAUDRIE1_Msk                       /*!<DAC channel 1 DMA underrun interrupt enable  >*/
#define DAC_CR_CEN1_Pos             (14U)
#define DAC_CR_CEN1_Msk             (0x1U << DAC_CR_CEN1_Pos)                  /*!< 0x00004000 */
#define DAC_CR_CEN1                 DAC_CR_CEN1_Msk                            /*!<DAC channel 1 calibration enable >*/
#define DAC_CR_HFSEL_Pos            (15U)
#define DAC_CR_HFSEL_Msk            (0x1U << DAC_CR_HFSEL_Pos)                  /*!< 0x00008000 */
#define DAC_CR_HFSEL                DAC_CR_HFSEL_Msk                            /*!<High frequency interface mode enable >*/

#define DAC_CR_EN2_Pos              (16U)
#define DAC_CR_EN2_Msk              (0x1U << DAC_CR_EN2_Pos)                   /*!< 0x00010000 */
#define DAC_CR_EN2                  DAC_CR_EN2_Msk                             /*!<DAC channel2 enable */
#define DAC_CR_TEN2_Pos             (17U)
#define DAC_CR_TEN2_Msk             (0x1U << DAC_CR_TEN2_Pos)                  /*!< 0x00020000 */
#define DAC_CR_TEN2                 DAC_CR_TEN2_Msk                            /*!<DAC channel2 Trigger enable */

#define DAC_CR_TSEL2_Pos            (18U)
#define DAC_CR_TSEL2_Msk            (0xFU << DAC_CR_TSEL2_Pos)                 /*!< 0x003C0000 */
#define DAC_CR_TSEL2                DAC_CR_TSEL2_Msk                           /*!<TSEL2[2:0] (DAC channel2 Trigger selection) */
#define DAC_CR_TSEL2_0              (0x1U << DAC_CR_TSEL2_Pos)                 /*!< 0x00040000 */
#define DAC_CR_TSEL2_1              (0x2U << DAC_CR_TSEL2_Pos)                 /*!< 0x00080000 */
#define DAC_CR_TSEL2_2              (0x4U << DAC_CR_TSEL2_Pos)                 /*!< 0x00100000 */
#define DAC_CR_TSEL2_3              (0x8U << DAC_CR_TSEL2_Pos)                 /*!< 0x00200000 */


#define DAC_CR_WAVE2_Pos            (22U)
#define DAC_CR_WAVE2_Msk            (0x3U << DAC_CR_WAVE2_Pos)                 /*!< 0x00C00000 */
#define DAC_CR_WAVE2                DAC_CR_WAVE2_Msk                           /*!<WAVE2[1:0] (DAC channel2 noise/triangle wave generation enable) */
#define DAC_CR_WAVE2_0              (0x1U << DAC_CR_WAVE2_Pos)                 /*!< 0x00400000 */
#define DAC_CR_WAVE2_1              (0x2U << DAC_CR_WAVE2_Pos)                 /*!< 0x00800000 */

#define DAC_CR_MAMP2_Pos            (24U)
#define DAC_CR_MAMP2_Msk            (0xFU << DAC_CR_MAMP2_Pos)                 /*!< 0x0F000000 */
#define DAC_CR_MAMP2                DAC_CR_MAMP2_Msk                           /*!<MAMP2[3:0] (DAC channel2 Mask/Amplitude selector) */
#define DAC_CR_MAMP2_0              (0x1U << DAC_CR_MAMP2_Pos)                 /*!< 0x01000000 */
#define DAC_CR_MAMP2_1              (0x2U << DAC_CR_MAMP2_Pos)                 /*!< 0x02000000 */
#define DAC_CR_MAMP2_2              (0x4U << DAC_CR_MAMP2_Pos)                 /*!< 0x04000000 */
#define DAC_CR_MAMP2_3              (0x8U << DAC_CR_MAMP2_Pos)                 /*!< 0x08000000 */

#define DAC_CR_DMAEN2_Pos           (28U)
#define DAC_CR_DMAEN2_Msk           (0x1U << DAC_CR_DMAEN2_Pos)                /*!< 0x10000000 */
#define DAC_CR_DMAEN2               DAC_CR_DMAEN2_Msk                          /*!<DAC channel2 DMA enabled */
#define DAC_CR_DMAUDRIE2_Pos        (29U)
#define DAC_CR_DMAUDRIE2_Msk        (0x1U << DAC_CR_DMAUDRIE2_Pos)             /*!< 0x20000000 */
#define DAC_CR_DMAUDRIE2            DAC_CR_DMAUDRIE2_Msk                       /*!<DAC channel2 DMA underrun interrupt enable  >*/
#define DAC_CR_CEN2_Pos             (30U)
#define DAC_CR_CEN2_Msk             (0x1U << DAC_CR_CEN2_Pos)                  /*!< 0x40000000 */
#define DAC_CR_CEN2                 DAC_CR_CEN2_Msk                            /*!<DAC channel2 calibration enable >*/

/*****************  Bit definition for DAC_SWTRIGR register  ******************/
#define DAC_SWTRIGR_SWTRIG1         ((uint8_t)0x01)                            /*!<DAC channel1 software trigger */
#define DAC_SWTRIGR_SWTRIG2         ((uint8_t)0x02)                            /*!<DAC channel2 software trigger */

/*****************  Bit definition for DAC_DHR12R1 register  ******************/
#define DAC_DHR12R1_DACC1DHR        ((uint16_t)0x0FFF)                         /*!<DAC channel1 12-bit Right aligned data */

/*****************  Bit definition for DAC_DHR12L1 register  ******************/
#define DAC_DHR12L1_DACC1DHR        ((uint16_t)0xFFF0)                         /*!<DAC channel1 12-bit Left aligned data */

/******************  Bit definition for DAC_DHR8R1 register  ******************/
#define DAC_DHR8R1_DACC1DHR         ((uint8_t)0xFF)                            /*!<DAC channel1 8-bit Right aligned data */

/*****************  Bit definition for DAC_DHR12R2 register  ******************/
#define DAC_DHR12R2_DACC2DHR        ((uint16_t)0x0FFF)                         /*!<DAC channel2 12-bit Right aligned data */

/*****************  Bit definition for DAC_DHR12L2 register  ******************/
#define DAC_DHR12L2_DACC2DHR        ((uint16_t)0xFFF0)                         /*!<DAC channel2 12-bit Left aligned data */

/******************  Bit definition for DAC_DHR8R2 register  ******************/
#define DAC_DHR8R2_DACC2DHR         ((uint8_t)0xFF)                            /*!<DAC channel2 8-bit Right aligned data */

/*****************  Bit definition for DAC_DHR12RD register  ******************/
#define DAC_DHR12RD_DACC1DHR_Pos    (0U)
#define DAC_DHR12RD_DACC1DHR_Msk    (0xFFFU << DAC_DHR12RD_DACC1DHR_Pos)       /*!< 0x00000FFF */
#define DAC_DHR12RD_DACC1DHR        DAC_DHR12RD_DACC1DHR_Msk                   /*!<DAC channel1 12-bit Right aligned data */
#define DAC_DHR12RD_DACC2DHR_Pos    (16U)
#define DAC_DHR12RD_DACC2DHR_Msk    (0xFFFU << DAC_DHR12RD_DACC2DHR_Pos)       /*!< 0x0FFF0000 */
#define DAC_DHR12RD_DACC2DHR        DAC_DHR12RD_DACC2DHR_Msk                   /*!<DAC channel2 12-bit Right aligned data */

/*****************  Bit definition for DAC_DHR12LD register  ******************/
#define DAC_DHR12LD_DACC1DHR_Pos    (4U)
#define DAC_DHR12LD_DACC1DHR_Msk    (0xFFFU << DAC_DHR12LD_DACC1DHR_Pos)       /*!< 0x0000FFF0 */
#define DAC_DHR12LD_DACC1DHR        DAC_DHR12LD_DACC1DHR_Msk                   /*!<DAC channel1 12-bit Left aligned data */
#define DAC_DHR12LD_DACC2DHR_Pos    (20U)
#define DAC_DHR12LD_DACC2DHR_Msk    (0xFFFU << DAC_DHR12LD_DACC2DHR_Pos)       /*!< 0xFFF00000 */
#define DAC_DHR12LD_DACC2DHR        DAC_DHR12LD_DACC2DHR_Msk                   /*!<DAC channel2 12-bit Left aligned data */

/******************  Bit definition for DAC_DHR8RD register  ******************/
#define DAC_DHR8RD_DACC1DHR_Pos     (0U)
#define DAC_DHR8RD_DACC1DHR_Msk     (0xFFU << DAC_DHR8RD_DACC1DHR_Pos)         /*!< 0x000000FF */
#define DAC_DHR8RD_DACC1DHR         DAC_DHR8RD_DACC1DHR_Msk                    /*!<DAC channel1 8-bit Right aligned data */
#define DAC_DHR8RD_DACC2DHR_Pos     (0U)
#define DAC_DHR8RD_DACC2DHR_Msk     (0xFFU << DAC_DHR8RD_DACC2DHR_Pos)         /*!< 0x000000FF */
#define DAC_DHR8RD_DACC2DHR         DAC_DHR8RD_DACC2DHR_Msk                    /*!<DAC channel2 8-bit Right aligned data */

/*******************  Bit definition for DAC_DOR1 register  *******************/
#define DAC_DOR1_DACC1DOR           ((uint16_t)0x0FFF)                         /*!<DAC channel1 data output */

/*******************  Bit definition for DAC_DOR2 register  *******************/
#define DAC_DOR2_DACC2DOR           ((uint16_t)0x0FFF)                         /*!<DAC channel2 data output */

/********************  Bit definition for DAC_SR register  ********************/
#define DAC_SR_DMAUDR1_Pos          (13U)
#define DAC_SR_DMAUDR1_Msk          (0x1U << DAC_SR_DMAUDR1_Pos)               /*!< 0x00002000 */
#define DAC_SR_DMAUDR1              DAC_SR_DMAUDR1_Msk                         /*!<DAC channel1 DMA underrun flag */
#define DAC_SR_CAL_FLAG1_Pos        (14U)
#define DAC_SR_CAL_FLAG1_Msk        (0x1U << DAC_SR_CAL_FLAG1_Pos)             /*!< 0x00004000 */
#define DAC_SR_CAL_FLAG1            DAC_SR_CAL_FLAG1_Msk                       /*!<DAC channel1 calibration offset status */
#define DAC_SR_BWST1_Pos            (15U)
#define DAC_SR_BWST1_Msk            (0x4001U << DAC_SR_BWST1_Pos)              /*!< 0x20008000 */
#define DAC_SR_BWST1                DAC_SR_BWST1_Msk                           /*!<DAC channel1 busy writing sample time flag */

#define DAC_SR_DMAUDR2_Pos          (29U)
#define DAC_SR_DMAUDR2_Msk          (0x1U << DAC_SR_DMAUDR2_Pos)               /*!< 0x20000000 */
#define DAC_SR_DMAUDR2              DAC_SR_DMAUDR2_Msk                         /*!<DAC channel2 DMA underrun flag */
#define DAC_SR_CAL_FLAG2_Pos        (30U)
#define DAC_SR_CAL_FLAG2_Msk        (0x1U << DAC_SR_CAL_FLAG2_Pos)             /*!< 0x40000000 */
#define DAC_SR_CAL_FLAG2            DAC_SR_CAL_FLAG2_Msk                       /*!<DAC channel2 calibration offset status */
#define DAC_SR_BWST2_Pos            (31U)
#define DAC_SR_BWST2_Msk            (0x1U << DAC_SR_BWST2_Pos)                 /*!< 0x80000000 */
#define DAC_SR_BWST2                DAC_SR_BWST2_Msk                           /*!<DAC channel2 busy writing sample time flag */

/*******************  Bit definition for DAC_CCR register  ********************/
#define DAC_CCR_OTRIM1_Pos          (0U)
#define DAC_CCR_OTRIM1_Msk          (0x1FU << DAC_CCR_OTRIM1_Pos)              /*!< 0x0000001F */
#define DAC_CCR_OTRIM1              DAC_CCR_OTRIM1_Msk                         /*!<DAC channel1 offset trimming value */
#define DAC_CCR_OTRIM2_Pos          (16U)
#define DAC_CCR_OTRIM2_Msk          (0x1FU << DAC_CCR_OTRIM2_Pos)              /*!< 0x001F0000 */
#define DAC_CCR_OTRIM2              DAC_CCR_OTRIM2_Msk                         /*!<DAC channel2 offset trimming value */

/*******************  Bit definition for DAC_MCR register  *******************/
#define DAC_MCR_MODE1_Pos           (0U)
#define DAC_MCR_MODE1_Msk           (0x7U << DAC_MCR_MODE1_Pos)                /*!< 0x00000007 */
#define DAC_MCR_MODE1               DAC_MCR_MODE1_Msk                          /*!<MODE1[2:0] (DAC channel1 mode) */
#define DAC_MCR_MODE1_0             (0x1U << DAC_MCR_MODE1_Pos)                /*!< 0x00000001 */
#define DAC_MCR_MODE1_1             (0x2U << DAC_MCR_MODE1_Pos)                /*!< 0x00000002 */
#define DAC_MCR_MODE1_2             (0x4U << DAC_MCR_MODE1_Pos)                /*!< 0x00000004 */

#define DAC_MCR_MODE2_Pos           (16U)
#define DAC_MCR_MODE2_Msk           (0x7U << DAC_MCR_MODE2_Pos)                /*!< 0x00070000 */
#define DAC_MCR_MODE2               DAC_MCR_MODE2_Msk                          /*!<MODE2[2:0] (DAC channel2 mode) */
#define DAC_MCR_MODE2_0             (0x1U << DAC_MCR_MODE2_Pos)                /*!< 0x00010000 */
#define DAC_MCR_MODE2_1             (0x2U << DAC_MCR_MODE2_Pos)                /*!< 0x00020000 */
#define DAC_MCR_MODE2_2             (0x4U << DAC_MCR_MODE2_Pos)                /*!< 0x00040000 */

/******************  Bit definition for DAC_SHSR1 register  ******************/
#define DAC_SHSR1_TSAMPLE1_Pos      (0U)
#define DAC_SHSR1_TSAMPLE1_Msk      (0x3FFU << DAC_SHSR1_TSAMPLE1_Pos)         /*!< 0x000003FF */
#define DAC_SHSR1_TSAMPLE1          DAC_SHSR1_TSAMPLE1_Msk                     /*!<DAC channel1 sample time */

/******************  Bit definition for DAC_SHSR2 register  ******************/
#define DAC_SHSR1_TSAMPLE2_Pos      (0U)
#define DAC_SHSR1_TSAMPLE2_Msk      (0x3FFU << DAC_SHSR1_TSAMPLE2_Pos)         /*!< 0x000003FF */
#define DAC_SHSR1_TSAMPLE2          DAC_SHSR1_TSAMPLE2_Msk                     /*!<DAC channel2 sample time */

/******************  Bit definition for DAC_SHHR register  ******************/
#define DAC_SHHR_THOLD1_Pos         (0U)
#define DAC_SHHR_THOLD1_Msk         (0x3FFU << DAC_SHHR_THOLD1_Pos)            /*!< 0x000003FF */
#define DAC_SHHR_THOLD1             DAC_SHHR_THOLD1_Msk                        /*!<DAC channel1 hold time */
#define DAC_SHHR_THOLD2_Pos         (16U)
#define DAC_SHHR_THOLD2_Msk         (0x3FFU << DAC_SHHR_THOLD2_Pos)            /*!< 0x03FF0000 */
#define DAC_SHHR_THOLD2             DAC_SHHR_THOLD2_Msk                        /*!<DAC channel2 hold time */

/******************  Bit definition for DAC_SHRR register  ******************/
#define DAC_SHRR_TREFRESH1_Pos      (0U)
#define DAC_SHRR_TREFRESH1_Msk      (0xFFU << DAC_SHRR_TREFRESH1_Pos)          /*!< 0x000000FF */
#define DAC_SHRR_TREFRESH1          DAC_SHRR_TREFRESH1_Msk                     /*!<DAC channel1 refresh time */
#define DAC_SHRR_TREFRESH2_Pos      (16U)
#define DAC_SHRR_TREFRESH2_Msk      (0xFFU << DAC_SHRR_TREFRESH2_Pos)          /*!< 0x00FF0000 */
#define DAC_SHRR_TREFRESH2          DAC_SHRR_TREFRESH2_Msk                     /*!<DAC channel2 refresh time */

/**********************  Bit definition for DAC_HWCFGR0 register  ***************/
#define DAC_HWCFGR0_DUAL_Pos      (0U)
#define DAC_HWCFGR0_DUAL_Msk      (0xFF << DAC_HWCFGR0_DUAL_Pos)               /*!< 0x0000000F */
#define DAC_HWCFGR0_DUAL          DAC_HWCFGR0_DUAL_Msk                         /*!< Dual DAC capability */
#define DAC_HWCFGR0_LFSR_Pos      (4U)
#define DAC_HWCFGR0_LFSR_Msk      (0xFU << DAC_HWCFGR0_LFSR_Pos)               /*!< 0x000000F0 */
#define DAC_HWCFGR0_LFSR          DAC_HWCFGR0_LFSR_Msk                         /*!< Pseudonoise wave generation capability */
#define DAC_HWCFGR0_TRIANGLE_Pos  (8U)
#define DAC_HWCFGR0_TRIANGLE_Msk  (0xFU << DAC_HWCFGR0_TRIANGLE_Pos)           /*!< 0x00000F00 */
#define DAC_HWCFGR0_TRIANGLE      DAC_HWCFGR0_TRIANGLE_Msk                     /*!< Triangle wave generation capability */
#define DAC_HWCFGR0_SAMPLE_Pos    (12U)
#define DAC_HWCFGR0_SAMPLE_Msk    (0xFU << DAC_HWCFGR0_SAMPLE_Pos)             /*!< 0x0000F000 */
#define DAC_HWCFGR0_SAMPLE        DAC_HWCFGR0_SAMPLE_Msk                       /*!< Sample and Hold mode capability */
#define DAC_HWCFGR0_OR_CFG_Pos    (16U)
#define DAC_HWCFGR0_OR_CFG_Msk    (0xFFU << DAC_HWCFGR0_OR_CFG_Pos)            /*!< 0x00FF0000 */
#define DAC_HWCFGR0_OR_CFG        DAC_HWCFGR0_OR_CFG_Msk                       /*!< option register bit width */

/********************  Bit definition for DAC_VERR register********************/
#define DAC_VERR_MINREV_Pos        (0U)
#define DAC_VERR_MINREV_Msk        (0xFU << DAC_VERR_MINREV_Pos)           /*!< 0x0000000F */
#define DAC_VERR_MINREV            DAC_VERR_MINREV_Msk                     /*!< MAJREV[3:0] bits (Minor revision) */
#define DAC_VERR_MAJREV_Pos        (4U)
#define DAC_VERR_MAJREV_Msk        (0xFU << DAC_VERR_MAJREV_Pos)           /*!< 0x000000F0 */
#define DAC_VERR_MAJREV            DAC_VERR_MAJREV_Msk                     /*!< MINREV[3:0] bits (Major revision) */

/**********************  Bit definition for DAC_IPIDR register  ****************/
#define DAC_IPIDR_IPID_Pos       (0U)
#define DAC_IPIDR_IPID_Msk       (0xFFFFFFFFU << DAC_IPIDR_IPID_Pos)         /*!< 0xFFFFFFFF */
#define DAC_IPIDR_IPID           DAC_IPIDR_IPID_Msk                          /*!< IP Identification */

/**********************  Bit definition for DAC_SIDR register  *****************/
#define DAC_SIDR_SID_Pos         (0U)
#define DAC_SIDR_SID_Msk         (0xFFFFFFFFU << DAC_SIDR_SID_Pos)           /*!< 0xFFFFFFFF */
#define DAC_SIDR_SID             DAC_SIDR_SID_Msk                            /*!< IP size identification */

/******************************************************************************/
/*                                                                            */
/*                                DBG                                         */
/*                                                                            */
/******************************************************************************/

/********************  Bit definition for DBGMCU_IDCODE register  *************/
#define DBGMCU_IDCODE_DEV_ID_Pos              (0U)
#define DBGMCU_IDCODE_DEV_ID_Msk              (0xFFFU << DBGMCU_IDCODE_DEV_ID_Pos) /*!< 0x00000FFF */
#define DBGMCU_IDCODE_DEV_ID                  DBGMCU_IDCODE_DEV_ID_Msk
#define DBGMCU_IDCODE_REV_ID_Pos              (16U)
#define DBGMCU_IDCODE_REV_ID_Msk              (0xFFFFU << DBGMCU_IDCODE_REV_ID_Pos) /*!< 0xFFFF0000 */
#define DBGMCU_IDCODE_REV_ID                  DBGMCU_IDCODE_REV_ID_Msk

/********************  Bit definition for DBGMCU_CR register  *****************/
#define DBGMCU_CR_DBG_SLEEP_Pos               (0U)
#define DBGMCU_CR_DBG_SLEEP_Msk               (0x1U << DBGMCU_CR_DBG_SLEEP_Pos) /*!< 0x00000001 */
#define DBGMCU_CR_DBG_SLEEP                   DBGMCU_CR_DBG_SLEEP_Msk
#define DBGMCU_CR_DBG_STOP_Pos                (1U)
#define DBGMCU_CR_DBG_STOP_Msk                (0x1U << DBGMCU_CR_DBG_STOP_Pos) /*!< 0x00000002 */
#define DBGMCU_CR_DBG_STOP                    DBGMCU_CR_DBG_STOP_Msk
#define DBGMCU_CR_DBG_STANDBY_Pos             (2U)
#define DBGMCU_CR_DBG_STANDBY_Msk             (0x1U << DBGMCU_CR_DBG_STANDBY_Pos) /*!< 0x00000004 */
#define DBGMCU_CR_DBG_STANDBY                 DBGMCU_CR_DBG_STANDBY_Msk
#define DBGMCU_CR_DBG_WDFZCTL_Pos             (24U)
#define DBGMCU_CR_DBG_WDFZCTL_Msk             (0x1U << DBGMCU_CR_DBG_WDFZCTL_Pos) /*!< 0x01000000 */
#define DBGMCU_CR_DBG_WDFZCTL                 DBGMCU_CR_DBG_WDFZCTL_Msk
#define DBGMCU_CR_DBG_TRGOEN_Pos              (28U)
#define DBGMCU_CR_DBG_TRGOEN_Msk              (0x1U << DBGMCU_CR_DBG_TRGOEN_Pos) /*!< 0x10000000 */
#define DBGMCU_CR_DBG_TRGOEN                  DBGMCU_CR_DBG_TRGOEN_Msk

/********************  Bit definition for APB4FZ register  ************/
#define DBGMCU_APB4_FZ_DBG_IWDG2_STOP_Pos     (2U)
#define DBGMCU_APB4_FZ_DBG_IWDG2_STOP_Msk     (0x1U << DBGMCU_APB4_FZ_DBG_IWDG2_STOP_Pos) /*!< 0x00000004 */
#define DBGMCU_APB4_FZ_DBG_IWDG2_STOP         DBGMCU_APB4_FZ_DBG_IWDG2_STOP_Msk

/********************  Bit definition for APB1FZ register  ************/
#define DBGMCU_APB1_FZ_DBG_TIM2_STOP_Pos      (0U)
#define DBGMCU_APB1_FZ_DBG_TIM2_STOP_Msk      (0x1U << DBGMCU_APB1_FZ_DBG_TIM2_STOP_Pos) /*!< 0x00000001 */
#define DBGMCU_APB1_FZ_DBG_TIM2_STOP          DBGMCU_APB1_FZ_DBG_TIM2_STOP_Msk
#define DBGMCU_APB1_FZ_DBG_TIM3_STOP_Pos      (1U)
#define DBGMCU_APB1_FZ_DBG_TIM3_STOP_Msk      (0x1U << DBGMCU_APB1_FZ_DBG_TIM3_STOP_Pos) /*!< 0x00000002 */
#define DBGMCU_APB1_FZ_DBG_TIM3_STOP          DBGMCU_APB1_FZ_DBG_TIM3_STOP_Msk
#define DBGMCU_APB1_FZ_DBG_TIM4_STOP_Pos      (2U)
#define DBGMCU_APB1_FZ_DBG_TIM4_STOP_Msk      (0x1U << DBGMCU_APB1_FZ_DBG_TIM4_STOP_Pos) /*!< 0x00000004 */
#define DBGMCU_APB1_FZ_DBG_TIM4_STOP          DBGMCU_APB1_FZ_DBG_TIM4_STOP_Msk
#define DBGMCU_APB1_FZ_DBG_TIM5_STOP_Pos      (3U)
#define DBGMCU_APB1_FZ_DBG_TIM5_STOP_Msk      (0x1U << DBGMCU_APB1_FZ_DBG_TIM5_STOP_Pos) /*!< 0x00000008 */
#define DBGMCU_APB1_FZ_DBG_TIM5_STOP          DBGMCU_APB1_FZ_DBG_TIM5_STOP_Msk
#define DBGMCU_APB1_FZ_DBG_TIM6_STOP_Pos      (4U)
#define DBGMCU_APB1_FZ_DBG_TIM6_STOP_Msk      (0x1U << DBGMCU_APB1_FZ_DBG_TIM6_STOP_Pos) /*!< 0x00000010 */
#define DBGMCU_APB1_FZ_DBG_TIM6_STOP          DBGMCU_APB1_FZ_DBG_TIM6_STOP_Msk
#define DBGMCU_APB1_FZ_DBG_TIM7_STOP_Pos      (5U)
#define DBGMCU_APB1_FZ_DBG_TIM7_STOP_Msk      (0x1U << DBGMCU_APB1_FZ_DBG_TIM7_STOP_Pos) /*!< 0x00000020 */
#define DBGMCU_APB1_FZ_DBG_TIM7_STOP          DBGMCU_APB1_FZ_DBG_TIM7_STOP_Msk
#define DBGMCU_APB1_FZ_DBG_TIM12_STOP_Pos     (6U)
#define DBGMCU_APB1_FZ_DBG_TIM12_STOP_Msk     (0x1U << DBGMCU_APB1_FZ_DBG_TIM12_STOP_Pos) /*!< 0x00000040 */
#define DBGMCU_APB1_FZ_DBG_TIM12_STOP         DBGMCU_APB1_FZ_DBG_TIM12_STOP_Msk
#define DBGMCU_APB1_FZ_DBG_TIM13_STOP_Pos     (7U)
#define DBGMCU_APB1_FZ_DBG_TIM13_STOP_Msk     (0x1U << DBGMCU_APB1_FZ_DBG_TIM13_STOP_Pos) /*!< 0x00000080 */
#define DBGMCU_APB1_FZ_DBG_TIM13_STOP         DBGMCU_APB1_FZ_DBG_TIM13_STOP_Msk
#define DBGMCU_APB1_FZ_DBG_TIM14_STOP_Pos     (8U)
#define DBGMCU_APB1_FZ_DBG_TIM14_STOP_Msk     (0x1U << DBGMCU_APB1_FZ_DBG_TIM14_STOP_Pos) /*!< 0x00000100 */
#define DBGMCU_APB1_FZ_DBG_TIM14_STOP         DBGMCU_APB1_FZ_DBG_TIM14_STOP_Msk
#define DBGMCU_APB1_FZ_DBG_LPTIM1_STOP_Pos    (9U)
#define DBGMCU_APB1_FZ_DBG_LPTIM1_STOP_Msk    (0x1U << DBGMCU_APB1_FZ_DBG_LPTIM1_STOP_Pos) /*!< 0x00000200 */
#define DBGMCU_APB1_FZ_DBG_LPTIM1_STOP        DBGMCU_APB1_FZ_DBG_LPTIM1_STOP_Msk
#define DBGMCU_APB1_FZ_DBG_WWDG1_STOP_Pos     (10U)
#define DBGMCU_APB1_FZ_DBG_WWDG1_STOP_Msk     (0x1U << DBGMCU_APB1_FZ_DBG_WWDG1_STOP_Pos) /*!< 0x00000400 */
#define DBGMCU_APB1_FZ_DBG_WWDG1_STOP         DBGMCU_APB1_FZ_DBG_WWDG1_STOP_Msk
#define DBGMCU_APB1_FZ_DBG_I2C1_STOP_Pos      (18U)
#define DBGMCU_APB1_FZ_DBG_I2C1_STOP_Msk      (0x1U << DBGMCU_APB1_FZ_DBG_I2C1_STOP_Pos) /*!< 0x00040000 */
#define DBGMCU_APB1_FZ_DBG_I2C1_STOP          DBGMCU_APB1_FZ_DBG_I2C1_STOP_Msk
#define DBGMCU_APB1_FZ_DBG_I2C2_STOP_Pos      (19U)
#define DBGMCU_APB1_FZ_DBG_I2C2_STOP_Msk      (0x1U << DBGMCU_APB1_FZ_DBG_I2C2_STOP_Pos) /*!< 0x00080000 */
#define DBGMCU_APB1_FZ_DBG_I2C2_STOP          DBGMCU_APB1_FZ_DBG_I2C2_STOP_Msk
#define DBGMCU_APB1_FZ_DBG_I2C3_STOP_Pos      (20U)
#define DBGMCU_APB1_FZ_DBG_I2C3_STOP_Msk      (0x1U << DBGMCU_APB1_FZ_DBG_I2C3_STOP_Pos) /*!< 0x00100000 */
#define DBGMCU_APB1_FZ_DBG_I2C3_STOP          DBGMCU_APB1_FZ_DBG_I2C3_STOP_Msk
#define DBGMCU_APB1_FZ_DBG_I2C5_STOP_Pos      (21U)
#define DBGMCU_APB1_FZ_DBG_I2C5_STOP_Msk      (0x1U << DBGMCU_APB1_FZ_DBG_I2C5_STOP_Pos) /*!< 0x00200000 */
#define DBGMCU_APB1_FZ_DBG_I2C5_STOP          DBGMCU_APB1_FZ_DBG_I2C5_STOP_Msk

/********************  Bit definition for APB2FZ register  ************/
#define DBGMCU_APB2_FZ_DBG_TIM1_STOP_Pos      (0U)
#define DBGMCU_APB2_FZ_DBG_TIM1_STOP_Msk      (0x1U << DBGMCU_APB2_FZ_DBG_TIM1_STOP_Pos) /*!< 0x00000001 */
#define DBGMCU_APB2_FZ_DBG_TIM1_STOP          DBGMCU_APB2_FZ_DBG_TIM1_STOP_Msk
#define DBGMCU_APB2_FZ_DBG_TIM8_STOP_Pos      (1U)
#define DBGMCU_APB2_FZ_DBG_TIM8_STOP_Msk      (0x1U << DBGMCU_APB2_FZ_DBG_TIM8_STOP_Pos) /*!< 0x00000002 */
#define DBGMCU_APB2_FZ_DBG_TIM8_STOP          DBGMCU_APB2_FZ_DBG_TIM8_STOP_Msk
#define DBGMCU_APB2_FZ_DBG_TIM15_STOP_Pos     (6U)
#define DBGMCU_APB2_FZ_DBG_TIM15_STOP_Msk     (0x1U << DBGMCU_APB2_FZ_DBG_TIM15_STOP_Pos) /*!< 0x00000040 */
#define DBGMCU_APB2_FZ_DBG_TIM15_STOP         DBGMCU_APB2_FZ_DBG_TIM15_STOP_Msk
#define DBGMCU_APB2_FZ_DBG_TIM16_STOP_Pos     (7U)
#define DBGMCU_APB2_FZ_DBG_TIM16_STOP_Msk     (0x1U << DBGMCU_APB2_FZ_DBG_TIM16_STOP_Pos) /*!< 0x00000080 */
#define DBGMCU_APB2_FZ_DBG_TIM16_STOP         DBGMCU_APB2_FZ_DBG_TIM16_STOP_Msk
#define DBGMCU_APB2_FZ_DBG_TIM17_STOP_Pos     (8U)
#define DBGMCU_APB2_FZ_DBG_TIM17_STOP_Msk     (0x1U << DBGMCU_APB2_FZ_DBG_TIM17_STOP_Pos) /*!< 0x00000100 */
#define DBGMCU_APB2_FZ_DBG_TIM17_STOP         DBGMCU_APB2_FZ_DBG_TIM17_STOP_Msk
#define DBGMCU_APB2_FZ_DBG_FDCAN_STOP_Pos     (15U)
#define DBGMCU_APB2_FZ_DBG_FDCAN_STOP_Msk     (0x1U << DBGMCU_APB2_FZ_DBG_FDCAN_STOP_Pos) /*!< 0x00008000 */
#define DBGMCU_APB2_FZ_DBG_FDCAN_STOP         DBGMCU_APB2_FZ_DBG_FDCAN_STOP_Msk

/********************  Bit definition for APB3FZ register  ************/
#define DBGMCU_APB3_FZ_DBG_LPTIM2_STOP_Pos    (1U)
#define DBGMCU_APB3_FZ_DBG_LPTIM2_STOP_Msk    (0x1U << DBGMCU_APB3_FZ_DBG_LPTIM2_STOP_Pos) /*!< 0x00000002 */
#define DBGMCU_APB3_FZ_DBG_LPTIM2_STOP        DBGMCU_APB3_FZ_DBG_LPTIM2_STOP_Msk
#define DBGMCU_APB3_FZ_DBG_LPTIM3_STOP_Pos    (2U)
#define DBGMCU_APB3_FZ_DBG_LPTIM3_STOP_Msk    (0x1U << DBGMCU_APB3_FZ_DBG_LPTIM3_STOP_Pos) /*!< 0x00000004 */
#define DBGMCU_APB3_FZ_DBG_LPTIM3_STOP        DBGMCU_APB3_FZ_DBG_LPTIM3_STOP_Msk
#define DBGMCU_APB3_FZ_DBG_LPTIM4_STOP_Pos    (3U)
#define DBGMCU_APB3_FZ_DBG_LPTIM4_STOP_Msk    (0x1U << DBGMCU_APB3_FZ_DBG_LPTIM4_STOP_Pos) /*!< 0x00000008 */
#define DBGMCU_APB3_FZ_DBG_LPTIM4_STOP        DBGMCU_APB3_FZ_DBG_LPTIM4_STOP_Msk
#define DBGMCU_APB3_FZ_DBG_LPTIM5_STOP_Pos    (4U)
#define DBGMCU_APB3_FZ_DBG_LPTIM5_STOP_Msk    (0x1U << DBGMCU_APB3_FZ_DBG_LPTIM5_STOP_Pos) /*!< 0x00000010 */
#define DBGMCU_APB3_FZ_DBG_LPTIM5_STOP        DBGMCU_APB3_FZ_DBG_LPTIM5_STOP_Msk

/********************  Bit definition for APB5FZ register  ************/
#define DBGMCU_APB5_FZ_DBG_I2C4_STOP_Pos      (2U)
#define DBGMCU_APB5_FZ_DBG_I2C4_STOP_Msk      (0x1U << DBGMCU_APB5_FZ_DBG_I2C4_STOP_Pos) /*!< 0x00000004 */
#define DBGMCU_APB5_FZ_DBG_I2C4_STOP          DBGMCU_APB5_FZ_DBG_I2C4_STOP_Msk
#define DBGMCU_APB5_FZ_DBG_IWDG1_STOP_Pos     (3U)
#define DBGMCU_APB5_FZ_DBG_IWDG1_STOP_Msk     (0x1U << DBGMCU_APB5_FZ_DBG_IWDG1_STOP_Pos) /*!< 0x00000008 */
#define DBGMCU_APB5_FZ_DBG_IWDG1_STOP         DBGMCU_APB5_FZ_DBG_IWDG1_STOP_Msk
#define DBGMCU_APB5_FZ_DBG_RTC_STOP_Pos       (4U)
#define DBGMCU_APB5_FZ_DBG_RTC_STOP_Msk       (0x1U << DBGMCU_APB5_FZ_DBG_RTC_STOP_Pos) /*!< 0x00000010 */
#define DBGMCU_APB5_FZ_DBG_RTC_STOP           DBGMCU_APB5_FZ_DBG_RTC_STOP_Msk
#define DBGMCU_APB5_FZ_DBG_I2C6_STOP_Pos      (9U)
#define DBGMCU_APB5_FZ_DBG_I2C6_STOP_Msk      (0x1U << DBGMCU_APB5_FZ_DBG_I2C6_STOP_Pos) /*!< 0x00000200 */
#define DBGMCU_APB5_FZ_DBG_I2C6_STOP          DBGMCU_APB5_FZ_DBG_I2C6_STOP_Msk

/******************************************************************************/
/*                                                                            */
/*                                    DCMI                                    */
/*                                                                            */
/******************************************************************************/
/********************  Bits definition for DCMI_CR register  ******************/
#define DCMI_CR_CAPTURE_Pos        (0U)
#define DCMI_CR_CAPTURE_Msk        (0x1UL << DCMI_CR_CAPTURE_Pos)              /*!< 0x00000001 */
#define DCMI_CR_CAPTURE            DCMI_CR_CAPTURE_Msk
#define DCMI_CR_CM_Pos             (1U)
#define DCMI_CR_CM_Msk             (0x1UL << DCMI_CR_CM_Pos)                   /*!< 0x00000002 */
#define DCMI_CR_CM                 DCMI_CR_CM_Msk
#define DCMI_CR_CROP_Pos           (2U)
#define DCMI_CR_CROP_Msk           (0x1UL << DCMI_CR_CROP_Pos)                 /*!< 0x00000004 */
#define DCMI_CR_CROP               DCMI_CR_CROP_Msk
#define DCMI_CR_JPEG_Pos           (3U)
#define DCMI_CR_JPEG_Msk           (0x1UL << DCMI_CR_JPEG_Pos)                 /*!< 0x00000008 */
#define DCMI_CR_JPEG               DCMI_CR_JPEG_Msk
#define DCMI_CR_ESS_Pos            (4U)
#define DCMI_CR_ESS_Msk            (0x1UL << DCMI_CR_ESS_Pos)                  /*!< 0x00000010 */
#define DCMI_CR_ESS                DCMI_CR_ESS_Msk
#define DCMI_CR_PCKPOL_Pos         (5U)
#define DCMI_CR_PCKPOL_Msk         (0x1UL << DCMI_CR_PCKPOL_Pos)               /*!< 0x00000020 */
#define DCMI_CR_PCKPOL             DCMI_CR_PCKPOL_Msk
#define DCMI_CR_HSPOL_Pos          (6U)
#define DCMI_CR_HSPOL_Msk          (0x1UL << DCMI_CR_HSPOL_Pos)                /*!< 0x00000040 */
#define DCMI_CR_HSPOL              DCMI_CR_HSPOL_Msk
#define DCMI_CR_VSPOL_Pos          (7U)
#define DCMI_CR_VSPOL_Msk          (0x1UL << DCMI_CR_VSPOL_Pos)                /*!< 0x00000080 */
#define DCMI_CR_VSPOL              DCMI_CR_VSPOL_Msk
#define DCMI_CR_FCRC_0             ((uint32_t)0x00000100U)
#define DCMI_CR_FCRC_1             ((uint32_t)0x00000200U)
#define DCMI_CR_EDM_0              ((uint32_t)0x00000400U)
#define DCMI_CR_EDM_1              ((uint32_t)0x00000800U)
#define DCMI_CR_CRE_Pos            (12U)
#define DCMI_CR_CRE_Msk            (0x1UL << DCMI_CR_CRE_Pos)                  /*!< 0x00001000 */
#define DCMI_CR_CRE                DCMI_CR_CRE_Msk
#define DCMI_CR_ENABLE_Pos         (14U)
#define DCMI_CR_ENABLE_Msk         (0x1UL << DCMI_CR_ENABLE_Pos)               /*!< 0x00004000 */
#define DCMI_CR_ENABLE             DCMI_CR_ENABLE_Msk
#define DCMI_CR_BSM_Pos            (16U)
#define DCMI_CR_BSM_Msk            (0x3UL << DCMI_CR_BSM_Pos)                  /*!< 0x00030000 */
#define DCMI_CR_BSM                DCMI_CR_BSM_Msk
#define DCMI_CR_BSM_0              (0x1U << DCMI_CR_BSM_Pos)                   /*!< 0x00010000 */
#define DCMI_CR_BSM_1              (0x2U << DCMI_CR_BSM_Pos)                   /*!< 0x00020000 */
#define DCMI_CR_OEBS_Pos           (18U)
#define DCMI_CR_OEBS_Msk           (0x1UL << DCMI_CR_OEBS_Pos)                 /*!< 0x00040000 */
#define DCMI_CR_OEBS               DCMI_CR_OEBS_Msk
#define DCMI_CR_LSM_Pos            (19U)
#define DCMI_CR_LSM_Msk            (0x1UL << DCMI_CR_LSM_Pos)                  /*!< 0x00080000 */
#define DCMI_CR_LSM                DCMI_CR_LSM_Msk
#define DCMI_CR_OELS_Pos           (20U)
#define DCMI_CR_OELS_Msk           (0x1UL << DCMI_CR_OELS_Pos)                 /*!< 0x00100000 */
#define DCMI_CR_OELS               DCMI_CR_OELS_Msk

/********************  Bits definition for DCMI_SR register  ******************/
#define DCMI_SR_HSYNC_Pos          (0U)
#define DCMI_SR_HSYNC_Msk          (0x1UL << DCMI_SR_HSYNC_Pos)                /*!< 0x00000001 */
#define DCMI_SR_HSYNC              DCMI_SR_HSYNC_Msk
#define DCMI_SR_VSYNC_Pos          (1U)
#define DCMI_SR_VSYNC_Msk          (0x1UL << DCMI_SR_VSYNC_Pos)                /*!< 0x00000002 */
#define DCMI_SR_VSYNC              DCMI_SR_VSYNC_Msk
#define DCMI_SR_FNE_Pos            (2U)
#define DCMI_SR_FNE_Msk            (0x1UL << DCMI_SR_FNE_Pos)                  /*!< 0x00000004 */
#define DCMI_SR_FNE                DCMI_SR_FNE_Msk

/********************  Bits definition for DCMI_RIS register   ****************/
#define DCMI_RIS_FRAME_RIS_Pos     (0U)
#define DCMI_RIS_FRAME_RIS_Msk     (0x1UL << DCMI_RIS_FRAME_RIS_Pos)           /*!< 0x00000001 */
#define DCMI_RIS_FRAME_RIS         DCMI_RIS_FRAME_RIS_Msk
#define DCMI_RIS_OVR_RIS_Pos       (1U)
#define DCMI_RIS_OVR_RIS_Msk       (0x1UL << DCMI_RIS_OVR_RIS_Pos)             /*!< 0x00000002 */
#define DCMI_RIS_OVR_RIS           DCMI_RIS_OVR_RIS_Msk
#define DCMI_RIS_ERR_RIS_Pos       (2U)
#define DCMI_RIS_ERR_RIS_Msk       (0x1UL << DCMI_RIS_ERR_RIS_Pos)             /*!< 0x00000004 */
#define DCMI_RIS_ERR_RIS           DCMI_RIS_ERR_RIS_Msk
#define DCMI_RIS_VSYNC_RIS_Pos     (3U)
#define DCMI_RIS_VSYNC_RIS_Msk     (0x1UL << DCMI_RIS_VSYNC_RIS_Pos)           /*!< 0x00000008 */
#define DCMI_RIS_VSYNC_RIS         DCMI_RIS_VSYNC_RIS_Msk
#define DCMI_RIS_LINE_RIS_Pos      (4U)
#define DCMI_RIS_LINE_RIS_Msk      (0x1UL << DCMI_RIS_LINE_RIS_Pos)            /*!< 0x00000010 */
#define DCMI_RIS_LINE_RIS          DCMI_RIS_LINE_RIS_Msk

/********************  Bits definition for DCMI_IER register  *****************/
#define DCMI_IER_FRAME_IE_Pos      (0U)
#define DCMI_IER_FRAME_IE_Msk      (0x1UL << DCMI_IER_FRAME_IE_Pos)            /*!< 0x00000001 */
#define DCMI_IER_FRAME_IE          DCMI_IER_FRAME_IE_Msk
#define DCMI_IER_OVR_IE_Pos        (1U)
#define DCMI_IER_OVR_IE_Msk        (0x1UL << DCMI_IER_OVR_IE_Pos)              /*!< 0x00000002 */
#define DCMI_IER_OVR_IE            DCMI_IER_OVR_IE_Msk
#define DCMI_IER_ERR_IE_Pos        (2U)
#define DCMI_IER_ERR_IE_Msk        (0x1UL << DCMI_IER_ERR_IE_Pos)              /*!< 0x00000004 */
#define DCMI_IER_ERR_IE            DCMI_IER_ERR_IE_Msk
#define DCMI_IER_VSYNC_IE_Pos      (3U)
#define DCMI_IER_VSYNC_IE_Msk      (0x1UL << DCMI_IER_VSYNC_IE_Pos)            /*!< 0x00000008 */
#define DCMI_IER_VSYNC_IE          DCMI_IER_VSYNC_IE_Msk
#define DCMI_IER_LINE_IE_Pos       (4U)
#define DCMI_IER_LINE_IE_Msk       (0x1UL << DCMI_IER_LINE_IE_Pos)             /*!< 0x00000010 */
#define DCMI_IER_LINE_IE           DCMI_IER_LINE_IE_Msk


/********************  Bits definition for DCMI_MIS register  *****************/
#define DCMI_MIS_FRAME_MIS_Pos     (0U)
#define DCMI_MIS_FRAME_MIS_Msk     (0x1UL << DCMI_MIS_FRAME_MIS_Pos)           /*!< 0x00000001 */
#define DCMI_MIS_FRAME_MIS         DCMI_MIS_FRAME_MIS_Msk
#define DCMI_MIS_OVR_MIS_Pos       (1U)
#define DCMI_MIS_OVR_MIS_Msk       (0x1UL << DCMI_MIS_OVR_MIS_Pos)             /*!< 0x00000002 */
#define DCMI_MIS_OVR_MIS           DCMI_MIS_OVR_MIS_Msk
#define DCMI_MIS_ERR_MIS_Pos       (2U)
#define DCMI_MIS_ERR_MIS_Msk       (0x1UL << DCMI_MIS_ERR_MIS_Pos)             /*!< 0x00000004 */
#define DCMI_MIS_ERR_MIS           DCMI_MIS_ERR_MIS_Msk
#define DCMI_MIS_VSYNC_MIS_Pos     (3U)
#define DCMI_MIS_VSYNC_MIS_Msk     (0x1UL << DCMI_MIS_VSYNC_MIS_Pos)           /*!< 0x00000008 */
#define DCMI_MIS_VSYNC_MIS         DCMI_MIS_VSYNC_MIS_Msk
#define DCMI_MIS_LINE_MIS_Pos      (4U)
#define DCMI_MIS_LINE_MIS_Msk      (0x1UL << DCMI_MIS_LINE_MIS_Pos)            /*!< 0x00000010 */
#define DCMI_MIS_LINE_MIS          DCMI_MIS_LINE_MIS_Msk


/********************  Bits definition for DCMI_ICR register  *****************/
#define DCMI_ICR_FRAME_ISC_Pos     (0U)
#define DCMI_ICR_FRAME_ISC_Msk     (0x1UL << DCMI_ICR_FRAME_ISC_Pos)           /*!< 0x00000001 */
#define DCMI_ICR_FRAME_ISC         DCMI_ICR_FRAME_ISC_Msk
#define DCMI_ICR_OVR_ISC_Pos       (1U)
#define DCMI_ICR_OVR_ISC_Msk       (0x1UL << DCMI_ICR_OVR_ISC_Pos)             /*!< 0x00000002 */
#define DCMI_ICR_OVR_ISC           DCMI_ICR_OVR_ISC_Msk
#define DCMI_ICR_ERR_ISC_Pos       (2U)
#define DCMI_ICR_ERR_ISC_Msk       (0x1UL << DCMI_ICR_ERR_ISC_Pos)             /*!< 0x00000004 */
#define DCMI_ICR_ERR_ISC           DCMI_ICR_ERR_ISC_Msk
#define DCMI_ICR_VSYNC_ISC_Pos     (3U)
#define DCMI_ICR_VSYNC_ISC_Msk     (0x1UL << DCMI_ICR_VSYNC_ISC_Pos)           /*!< 0x00000008 */
#define DCMI_ICR_VSYNC_ISC         DCMI_ICR_VSYNC_ISC_Msk
#define DCMI_ICR_LINE_ISC_Pos      (4U)
#define DCMI_ICR_LINE_ISC_Msk      (0x1UL << DCMI_ICR_LINE_ISC_Pos)            /*!< 0x00000010 */
#define DCMI_ICR_LINE_ISC          DCMI_ICR_LINE_ISC_Msk


/********************  Bits definition for DCMI_ESCR register  ******************/
#define DCMI_ESCR_FSC_Pos          (0U)
#define DCMI_ESCR_FSC_Msk          (0xFFUL << DCMI_ESCR_FSC_Pos)               /*!< 0x000000FF */
#define DCMI_ESCR_FSC              DCMI_ESCR_FSC_Msk
#define DCMI_ESCR_LSC_Pos          (8U)
#define DCMI_ESCR_LSC_Msk          (0xFFUL << DCMI_ESCR_LSC_Pos)               /*!< 0x0000FF00 */
#define DCMI_ESCR_LSC              DCMI_ESCR_LSC_Msk
#define DCMI_ESCR_LEC_Pos          (16U)
#define DCMI_ESCR_LEC_Msk          (0xFFUL << DCMI_ESCR_LEC_Pos)               /*!< 0x00FF0000 */
#define DCMI_ESCR_LEC              DCMI_ESCR_LEC_Msk
#define DCMI_ESCR_FEC_Pos          (24U)
#define DCMI_ESCR_FEC_Msk          (0xFFUL << DCMI_ESCR_FEC_Pos)               /*!< 0xFF000000 */
#define DCMI_ESCR_FEC              DCMI_ESCR_FEC_Msk

/********************  Bits definition for DCMI_ESUR register  ******************/
#define DCMI_ESUR_FSU_Pos          (0U)
#define DCMI_ESUR_FSU_Msk          (0xFFUL << DCMI_ESUR_FSU_Pos)               /*!< 0x000000FF */
#define DCMI_ESUR_FSU              DCMI_ESUR_FSU_Msk
#define DCMI_ESUR_LSU_Pos          (8U)
#define DCMI_ESUR_LSU_Msk          (0xFFUL << DCMI_ESUR_LSU_Pos)               /*!< 0x0000FF00 */
#define DCMI_ESUR_LSU              DCMI_ESUR_LSU_Msk
#define DCMI_ESUR_LEU_Pos          (16U)
#define DCMI_ESUR_LEU_Msk          (0xFFUL << DCMI_ESUR_LEU_Pos)               /*!< 0x00FF0000 */
#define DCMI_ESUR_LEU              DCMI_ESUR_LEU_Msk
#define DCMI_ESUR_FEU_Pos          (24U)
#define DCMI_ESUR_FEU_Msk          (0xFFUL << DCMI_ESUR_FEU_Pos)               /*!< 0xFF000000 */
#define DCMI_ESUR_FEU              DCMI_ESUR_FEU_Msk

/********************  Bits definition for DCMI_CWSTRT register  ******************/
#define DCMI_CWSTRT_HOFFCNT_Pos    (0U)
#define DCMI_CWSTRT_HOFFCNT_Msk    (0x3FFFUL << DCMI_CWSTRT_HOFFCNT_Pos)       /*!< 0x00003FFF */
#define DCMI_CWSTRT_HOFFCNT        DCMI_CWSTRT_HOFFCNT_Msk
#define DCMI_CWSTRT_VST_Pos        (16U)
#define DCMI_CWSTRT_VST_Msk        (0x1FFFUL << DCMI_CWSTRT_VST_Pos)           /*!< 0x1FFF0000 */
#define DCMI_CWSTRT_VST            DCMI_CWSTRT_VST_Msk

/********************  Bits definition for DCMI_CWSIZE register  ******************/
#define DCMI_CWSIZE_CAPCNT_Pos     (0U)
#define DCMI_CWSIZE_CAPCNT_Msk     (0x3FFFUL << DCMI_CWSIZE_CAPCNT_Pos)        /*!< 0x00003FFF */
#define DCMI_CWSIZE_CAPCNT         DCMI_CWSIZE_CAPCNT_Msk
#define DCMI_CWSIZE_VLINE_Pos      (16U)
#define DCMI_CWSIZE_VLINE_Msk      (0x3FFFUL << DCMI_CWSIZE_VLINE_Pos)         /*!< 0x3FFF0000 */
#define DCMI_CWSIZE_VLINE          DCMI_CWSIZE_VLINE_Msk

/********************  Bits definition for DCMI_DR register  ******************/
#define DCMI_DR_BYTE0_Pos          (0U)
#define DCMI_DR_BYTE0_Msk          (0xFFUL << DCMI_DR_BYTE0_Pos)               /*!< 0x000000FF */
#define DCMI_DR_BYTE0              DCMI_DR_BYTE0_Msk
#define DCMI_DR_BYTE1_Pos          (8U)
#define DCMI_DR_BYTE1_Msk          (0xFFUL << DCMI_DR_BYTE1_Pos)               /*!< 0x0000FF00 */
#define DCMI_DR_BYTE1              DCMI_DR_BYTE1_Msk
#define DCMI_DR_BYTE2_Pos          (16U)
#define DCMI_DR_BYTE2_Msk          (0xFFUL << DCMI_DR_BYTE2_Pos)               /*!< 0x00FF0000 */
#define DCMI_DR_BYTE2              DCMI_DR_BYTE2_Msk
#define DCMI_DR_BYTE3_Pos          (24U)
#define DCMI_DR_BYTE3_Msk          (0xFFUL << DCMI_DR_BYTE3_Pos)               /*!< 0xFF000000 */
#define DCMI_DR_BYTE3              DCMI_DR_BYTE3_Msk

/******************************************************************************/
/*                                                                            */
/*                    DDRCTRL block description (DDRCTRL)                     */
/*                                                                            */
/******************************************************************************/

/*****************  Bit definition for DDRCTRL_MSTR register  *****************/
#define DDRCTRL_MSTR_DDR3_Pos              (0U)
#define DDRCTRL_MSTR_DDR3_Msk              (0x1U << DDRCTRL_MSTR_DDR3_Pos)              /*!< 0x00000001 */
#define DDRCTRL_MSTR_DDR3                  DDRCTRL_MSTR_DDR3_Msk                        /*!< Selects DDR3 SDRAM */
#define DDRCTRL_MSTR_LPDDR2_Pos            (2U)
#define DDRCTRL_MSTR_LPDDR2_Msk            (0x1U << DDRCTRL_MSTR_LPDDR2_Pos)            /*!< 0x00000004 */
#define DDRCTRL_MSTR_LPDDR2                DDRCTRL_MSTR_LPDDR2_Msk                      /*!< Selects LPDDR2 SDRAM */
#define DDRCTRL_MSTR_LPDDR3_Pos            (3U)
#define DDRCTRL_MSTR_LPDDR3_Msk            (0x1U << DDRCTRL_MSTR_LPDDR3_Pos)            /*!< 0x00000008 */
#define DDRCTRL_MSTR_LPDDR3                DDRCTRL_MSTR_LPDDR3_Msk                      /*!< Selects LPDDR3 SDRAM */
#define DDRCTRL_MSTR_BURSTCHOP_Pos         (9U)
#define DDRCTRL_MSTR_BURSTCHOP_Msk         (0x1U << DDRCTRL_MSTR_BURSTCHOP_Pos)         /*!< 0x00000200 */
#define DDRCTRL_MSTR_BURSTCHOP             DDRCTRL_MSTR_BURSTCHOP_Msk                   /*!< When set, enable burst-chop (BC4 or 8 on-the-fly) in DDR3/DDR4. the burst-chop for Reads is exercised only in HIF configurations (UMCTL2_INCL_ARB not set) and if in full bus width mode (MSTR.data_bus_width = 00) and if MEMC_BURST_LENGTH=8 or 16. The burst-chop for writes is exercised only if partial writes enabled (UMCTL2_PARTIAL_WR=1) and if CRC is disabled (CRCPARCTL1.crc_enable = 0). */
#define DDRCTRL_MSTR_EN_2T_TIMING_MODE_Pos (10U)
#define DDRCTRL_MSTR_EN_2T_TIMING_MODE_Msk (0x1U << DDRCTRL_MSTR_EN_2T_TIMING_MODE_Pos) /*!< 0x00000400 */
#define DDRCTRL_MSTR_EN_2T_TIMING_MODE     DDRCTRL_MSTR_EN_2T_TIMING_MODE_Msk           /*!< If 1, then the DDRCTRL uses 2T timing. Otherwise, uses 1T timing. In 2T timing, all command signals (except chip select) are held for 2 clocks on the SDRAM bus. The chip select is asserted on the second cycle of the command */
#define DDRCTRL_MSTR_DATA_BUS_WIDTH_Pos    (12U)
#define DDRCTRL_MSTR_DATA_BUS_WIDTH_Msk    (0x3U << DDRCTRL_MSTR_DATA_BUS_WIDTH_Pos)    /*!< 0x00003000 */
#define DDRCTRL_MSTR_DATA_BUS_WIDTH        DDRCTRL_MSTR_DATA_BUS_WIDTH_Msk              /*!< Selects proportion of DQ bus width that is used by the SDRAM */
#define DDRCTRL_MSTR_DATA_BUS_WIDTH_0      (0x1U << DDRCTRL_MSTR_DATA_BUS_WIDTH_Pos)    /*!< 0x00001000 */
#define DDRCTRL_MSTR_DATA_BUS_WIDTH_1      (0x2U << DDRCTRL_MSTR_DATA_BUS_WIDTH_Pos)    /*!< 0x00002000 */
#define DDRCTRL_MSTR_DLL_OFF_MODE_Pos      (15U)
#define DDRCTRL_MSTR_DLL_OFF_MODE_Msk      (0x1U << DDRCTRL_MSTR_DLL_OFF_MODE_Pos)      /*!< 0x00008000 */
#define DDRCTRL_MSTR_DLL_OFF_MODE          DDRCTRL_MSTR_DLL_OFF_MODE_Msk                /*!< Set to 1 when the DDRCTRL and DRAM has to be put in DLL-off mode for low frequency operation. */
#define DDRCTRL_MSTR_BURST_RDWR_Pos        (16U)
#define DDRCTRL_MSTR_BURST_RDWR_Msk        (0xFU << DDRCTRL_MSTR_BURST_RDWR_Pos)        /*!< 0x000F0000 */
#define DDRCTRL_MSTR_BURST_RDWR            DDRCTRL_MSTR_BURST_RDWR_Msk                  /*!< SDRAM burst length used: */
#define DDRCTRL_MSTR_BURST_RDWR_0          (0x1U << DDRCTRL_MSTR_BURST_RDWR_Pos)        /*!< 0x00010000 */
#define DDRCTRL_MSTR_BURST_RDWR_1          (0x2U << DDRCTRL_MSTR_BURST_RDWR_Pos)        /*!< 0x00020000 */
#define DDRCTRL_MSTR_BURST_RDWR_2          (0x4U << DDRCTRL_MSTR_BURST_RDWR_Pos)        /*!< 0x00040000 */
#define DDRCTRL_MSTR_BURST_RDWR_3          (0x8U << DDRCTRL_MSTR_BURST_RDWR_Pos)        /*!< 0x00080000 */

/*****************  Bit definition for DDRCTRL_STAT register  *****************/
#define DDRCTRL_STAT_OPERATING_MODE_Pos        (0U)
#define DDRCTRL_STAT_OPERATING_MODE_Msk        (0x7U << DDRCTRL_STAT_OPERATING_MODE_Pos)        /*!< 0x00000007 */
#define DDRCTRL_STAT_OPERATING_MODE            DDRCTRL_STAT_OPERATING_MODE_Msk                  /*!< Operating mode. This is 3-bits wide in configurations with mDDR/LPDDR2/LPDDR3/LPDDR4/DDR4 support and 2-bits in all other configurations. */
#define DDRCTRL_STAT_OPERATING_MODE_0          (0x1U << DDRCTRL_STAT_OPERATING_MODE_Pos)        /*!< 0x00000001 */
#define DDRCTRL_STAT_OPERATING_MODE_1          (0x2U << DDRCTRL_STAT_OPERATING_MODE_Pos)        /*!< 0x00000002 */
#define DDRCTRL_STAT_OPERATING_MODE_2          (0x4U << DDRCTRL_STAT_OPERATING_MODE_Pos)        /*!< 0x00000004 */
#define DDRCTRL_STAT_SELFREF_TYPE_Pos          (4U)
#define DDRCTRL_STAT_SELFREF_TYPE_Msk          (0x3U << DDRCTRL_STAT_SELFREF_TYPE_Pos)          /*!< 0x00000030 */
#define DDRCTRL_STAT_SELFREF_TYPE              DDRCTRL_STAT_SELFREF_TYPE_Msk                    /*!< Flags if Self Refresh (except LPDDR4) or SR-Powerdown (LPDDR4) is entered and if it was under Automatic Self Refresh control only or not. */
#define DDRCTRL_STAT_SELFREF_TYPE_0            (0x1U << DDRCTRL_STAT_SELFREF_TYPE_Pos)          /*!< 0x00000010 */
#define DDRCTRL_STAT_SELFREF_TYPE_1            (0x2U << DDRCTRL_STAT_SELFREF_TYPE_Pos)          /*!< 0x00000020 */
#define DDRCTRL_STAT_SELFREF_CAM_NOT_EMPTY_Pos (12U)
#define DDRCTRL_STAT_SELFREF_CAM_NOT_EMPTY_Msk (0x1U << DDRCTRL_STAT_SELFREF_CAM_NOT_EMPTY_Pos) /*!< 0x00001000 */
#define DDRCTRL_STAT_SELFREF_CAM_NOT_EMPTY     DDRCTRL_STAT_SELFREF_CAM_NOT_EMPTY_Msk           /*!< Self refresh with CAMs not empty. Set to 1 when Self Refresh is entered but CAMs are not drained. Cleared after exiting Self Refresh. */

/***************  Bit definition for DDRCTRL_MRCTRL0 register  ****************/
#define DDRCTRL_MRCTRL0_MR_TYPE_Pos (0U)
#define DDRCTRL_MRCTRL0_MR_TYPE_Msk (0x1U << DDRCTRL_MRCTRL0_MR_TYPE_Pos) /*!< 0x00000001 */
#define DDRCTRL_MRCTRL0_MR_TYPE     DDRCTRL_MRCTRL0_MR_TYPE_Msk           /*!< Indicates whether the mode register operation is read or write. Only used for LPDDR2/LPDDR3/LPDDR4/DDR4. */
#define DDRCTRL_MRCTRL0_MR_RANK_Pos (4U)
#define DDRCTRL_MRCTRL0_MR_RANK_Msk (0x1U << DDRCTRL_MRCTRL0_MR_RANK_Pos) /*!< 0x00000010 */
#define DDRCTRL_MRCTRL0_MR_RANK     DDRCTRL_MRCTRL0_MR_RANK_Msk           /*!< Controls which rank is accessed by MRCTRL0.mr_wr. Normally, it is desired to access all ranks, so all bits should be set to 1. However, for multi-rank UDIMMs/RDIMMs/LRDIMMs which implement address mirroring, it may be necessary to access ranks individually. */
#define DDRCTRL_MRCTRL0_MR_ADDR_Pos (12U)
#define DDRCTRL_MRCTRL0_MR_ADDR_Msk (0xFU << DDRCTRL_MRCTRL0_MR_ADDR_Pos) /*!< 0x0000F000 */
#define DDRCTRL_MRCTRL0_MR_ADDR     DDRCTRL_MRCTRL0_MR_ADDR_Msk           /*!< Address of the mode register that is to be written to. */
#define DDRCTRL_MRCTRL0_MR_ADDR_0   (0x1U << DDRCTRL_MRCTRL0_MR_ADDR_Pos) /*!< 0x00001000 */
#define DDRCTRL_MRCTRL0_MR_ADDR_1   (0x2U << DDRCTRL_MRCTRL0_MR_ADDR_Pos) /*!< 0x00002000 */
#define DDRCTRL_MRCTRL0_MR_ADDR_2   (0x4U << DDRCTRL_MRCTRL0_MR_ADDR_Pos) /*!< 0x00004000 */
#define DDRCTRL_MRCTRL0_MR_ADDR_3   (0x8U << DDRCTRL_MRCTRL0_MR_ADDR_Pos) /*!< 0x00008000 */
#define DDRCTRL_MRCTRL0_MR_WR_Pos   (31U)
#define DDRCTRL_MRCTRL0_MR_WR_Msk   (0x1U << DDRCTRL_MRCTRL0_MR_WR_Pos)   /*!< 0x80000000 */
#define DDRCTRL_MRCTRL0_MR_WR       DDRCTRL_MRCTRL0_MR_WR_Msk             /*!< Setting this register bit to 1 triggers a mode register read or write operation. When the MR operation is complete, the DDRCTRL automatically clears this bit. The other register fields of this register must be written in a separate APB transaction, before setting this mr_wr bit. It is recommended NOT to set this signal if in Init, Deep power-down or MPSM operating modes. */

/***************  Bit definition for DDRCTRL_MRCTRL1 register  ****************/
#define DDRCTRL_MRCTRL1_MR_DATA_Pos (0U)
#define DDRCTRL_MRCTRL1_MR_DATA_Msk (0xFFFFU << DDRCTRL_MRCTRL1_MR_DATA_Pos) /*!< 0x0000FFFF */
#define DDRCTRL_MRCTRL1_MR_DATA     DDRCTRL_MRCTRL1_MR_DATA_Msk              /*!< Mode register write data for all non-LPDDR2/non-LPDDR3/non-LPDDR4 modes. */
#define DDRCTRL_MRCTRL1_MR_DATA_0   (0x1U << DDRCTRL_MRCTRL1_MR_DATA_Pos)    /*!< 0x00000001 */
#define DDRCTRL_MRCTRL1_MR_DATA_1   (0x2U << DDRCTRL_MRCTRL1_MR_DATA_Pos)    /*!< 0x00000002 */
#define DDRCTRL_MRCTRL1_MR_DATA_2   (0x4U << DDRCTRL_MRCTRL1_MR_DATA_Pos)    /*!< 0x00000004 */
#define DDRCTRL_MRCTRL1_MR_DATA_3   (0x8U << DDRCTRL_MRCTRL1_MR_DATA_Pos)    /*!< 0x00000008 */
#define DDRCTRL_MRCTRL1_MR_DATA_4   (0x10U << DDRCTRL_MRCTRL1_MR_DATA_Pos)   /*!< 0x00000010 */
#define DDRCTRL_MRCTRL1_MR_DATA_5   (0x20U << DDRCTRL_MRCTRL1_MR_DATA_Pos)   /*!< 0x00000020 */
#define DDRCTRL_MRCTRL1_MR_DATA_6   (0x40U << DDRCTRL_MRCTRL1_MR_DATA_Pos)   /*!< 0x00000040 */
#define DDRCTRL_MRCTRL1_MR_DATA_7   (0x80U << DDRCTRL_MRCTRL1_MR_DATA_Pos)   /*!< 0x00000080 */
#define DDRCTRL_MRCTRL1_MR_DATA_8   (0x100U << DDRCTRL_MRCTRL1_MR_DATA_Pos)  /*!< 0x00000100 */
#define DDRCTRL_MRCTRL1_MR_DATA_9   (0x200U << DDRCTRL_MRCTRL1_MR_DATA_Pos)  /*!< 0x00000200 */
#define DDRCTRL_MRCTRL1_MR_DATA_10  (0x400U << DDRCTRL_MRCTRL1_MR_DATA_Pos)  /*!< 0x00000400 */
#define DDRCTRL_MRCTRL1_MR_DATA_11  (0x800U << DDRCTRL_MRCTRL1_MR_DATA_Pos)  /*!< 0x00000800 */
#define DDRCTRL_MRCTRL1_MR_DATA_12  (0x1000U << DDRCTRL_MRCTRL1_MR_DATA_Pos) /*!< 0x00001000 */
#define DDRCTRL_MRCTRL1_MR_DATA_13  (0x2000U << DDRCTRL_MRCTRL1_MR_DATA_Pos) /*!< 0x00002000 */
#define DDRCTRL_MRCTRL1_MR_DATA_14  (0x4000U << DDRCTRL_MRCTRL1_MR_DATA_Pos) /*!< 0x00004000 */
#define DDRCTRL_MRCTRL1_MR_DATA_15  (0x8000U << DDRCTRL_MRCTRL1_MR_DATA_Pos) /*!< 0x00008000 */

/****************  Bit definition for DDRCTRL_MRSTAT register  ****************/
#define DDRCTRL_MRSTAT_MR_WR_BUSY_Pos (0U)
#define DDRCTRL_MRSTAT_MR_WR_BUSY_Msk (0x1U << DDRCTRL_MRSTAT_MR_WR_BUSY_Pos) /*!< 0x00000001 */
#define DDRCTRL_MRSTAT_MR_WR_BUSY     DDRCTRL_MRSTAT_MR_WR_BUSY_Msk           /*!< The SoC core may initiate a MR write operation only if this signal is low. This signal goes high in the clock after the DDRCTRL accepts the MRW/MRR request. It goes low when the MRW/MRR command is issued to the SDRAM. It is recommended not to perform MRW/MRR commands when \qMRSTAT.mr_wr_busy\q is high. */

/***************  Bit definition for DDRCTRL_DERATEEN register  ***************/
#define DDRCTRL_DERATEEN_DERATE_ENABLE_Pos (0U)
#define DDRCTRL_DERATEEN_DERATE_ENABLE_Msk (0x1U << DDRCTRL_DERATEEN_DERATE_ENABLE_Pos) /*!< 0x00000001 */
#define DDRCTRL_DERATEEN_DERATE_ENABLE     DDRCTRL_DERATEEN_DERATE_ENABLE_Msk           /*!< Enables derating */
#define DDRCTRL_DERATEEN_DERATE_VALUE_Pos  (1U)
#define DDRCTRL_DERATEEN_DERATE_VALUE_Msk  (0x3U << DDRCTRL_DERATEEN_DERATE_VALUE_Pos)  /*!< 0x00000006 */
#define DDRCTRL_DERATEEN_DERATE_VALUE      DDRCTRL_DERATEEN_DERATE_VALUE_Msk            /*!< Derate value */
#define DDRCTRL_DERATEEN_DERATE_VALUE_0    (0x1U << DDRCTRL_DERATEEN_DERATE_VALUE_Pos)  /*!< 0x00000002 */
#define DDRCTRL_DERATEEN_DERATE_VALUE_1    (0x2U << DDRCTRL_DERATEEN_DERATE_VALUE_Pos)  /*!< 0x00000004 */
#define DDRCTRL_DERATEEN_DERATE_BYTE_Pos   (4U)
#define DDRCTRL_DERATEEN_DERATE_BYTE_Msk   (0xFU << DDRCTRL_DERATEEN_DERATE_BYTE_Pos)   /*!< 0x000000F0 */
#define DDRCTRL_DERATEEN_DERATE_BYTE       DDRCTRL_DERATEEN_DERATE_BYTE_Msk             /*!< Derate byte */
#define DDRCTRL_DERATEEN_DERATE_BYTE_0     (0x1U << DDRCTRL_DERATEEN_DERATE_BYTE_Pos)   /*!< 0x00000010 */
#define DDRCTRL_DERATEEN_DERATE_BYTE_1     (0x2U << DDRCTRL_DERATEEN_DERATE_BYTE_Pos)   /*!< 0x00000020 */
#define DDRCTRL_DERATEEN_DERATE_BYTE_2     (0x4U << DDRCTRL_DERATEEN_DERATE_BYTE_Pos)   /*!< 0x00000040 */
#define DDRCTRL_DERATEEN_DERATE_BYTE_3     (0x8U << DDRCTRL_DERATEEN_DERATE_BYTE_Pos)   /*!< 0x00000080 */

/**************  Bit definition for DDRCTRL_DERATEINT register  ***************/
#define DDRCTRL_DERATEINT_MR4_READ_INTERVAL_Pos (0U)
#define DDRCTRL_DERATEINT_MR4_READ_INTERVAL_Msk (0xFFFFFFFFU << DDRCTRL_DERATEINT_MR4_READ_INTERVAL_Pos) /*!< 0xFFFFFFFF */
#define DDRCTRL_DERATEINT_MR4_READ_INTERVAL     DDRCTRL_DERATEINT_MR4_READ_INTERVAL_Msk                  /*!< Interval between two MR4 reads, used to derate the timing parameters. */
#define DDRCTRL_DERATEINT_MR4_READ_INTERVAL_0   (0x1U << DDRCTRL_DERATEINT_MR4_READ_INTERVAL_Pos)        /*!< 0x00000001 */
#define DDRCTRL_DERATEINT_MR4_READ_INTERVAL_1   (0x2U << DDRCTRL_DERATEINT_MR4_READ_INTERVAL_Pos)        /*!< 0x00000002 */
#define DDRCTRL_DERATEINT_MR4_READ_INTERVAL_2   (0x4U << DDRCTRL_DERATEINT_MR4_READ_INTERVAL_Pos)        /*!< 0x00000004 */
#define DDRCTRL_DERATEINT_MR4_READ_INTERVAL_3   (0x8U << DDRCTRL_DERATEINT_MR4_READ_INTERVAL_Pos)        /*!< 0x00000008 */
#define DDRCTRL_DERATEINT_MR4_READ_INTERVAL_4   (0x10U << DDRCTRL_DERATEINT_MR4_READ_INTERVAL_Pos)       /*!< 0x00000010 */
#define DDRCTRL_DERATEINT_MR4_READ_INTERVAL_5   (0x20U << DDRCTRL_DERATEINT_MR4_READ_INTERVAL_Pos)       /*!< 0x00000020 */
#define DDRCTRL_DERATEINT_MR4_READ_INTERVAL_6   (0x40U << DDRCTRL_DERATEINT_MR4_READ_INTERVAL_Pos)       /*!< 0x00000040 */
#define DDRCTRL_DERATEINT_MR4_READ_INTERVAL_7   (0x80U << DDRCTRL_DERATEINT_MR4_READ_INTERVAL_Pos)       /*!< 0x00000080 */
#define DDRCTRL_DERATEINT_MR4_READ_INTERVAL_8   (0x100U << DDRCTRL_DERATEINT_MR4_READ_INTERVAL_Pos)      /*!< 0x00000100 */
#define DDRCTRL_DERATEINT_MR4_READ_INTERVAL_9   (0x200U << DDRCTRL_DERATEINT_MR4_READ_INTERVAL_Pos)      /*!< 0x00000200 */
#define DDRCTRL_DERATEINT_MR4_READ_INTERVAL_10  (0x400U << DDRCTRL_DERATEINT_MR4_READ_INTERVAL_Pos)      /*!< 0x00000400 */
#define DDRCTRL_DERATEINT_MR4_READ_INTERVAL_11  (0x800U << DDRCTRL_DERATEINT_MR4_READ_INTERVAL_Pos)      /*!< 0x00000800 */
#define DDRCTRL_DERATEINT_MR4_READ_INTERVAL_12  (0x1000U << DDRCTRL_DERATEINT_MR4_READ_INTERVAL_Pos)     /*!< 0x00001000 */
#define DDRCTRL_DERATEINT_MR4_READ_INTERVAL_13  (0x2000U << DDRCTRL_DERATEINT_MR4_READ_INTERVAL_Pos)     /*!< 0x00002000 */
#define DDRCTRL_DERATEINT_MR4_READ_INTERVAL_14  (0x4000U << DDRCTRL_DERATEINT_MR4_READ_INTERVAL_Pos)     /*!< 0x00004000 */
#define DDRCTRL_DERATEINT_MR4_READ_INTERVAL_15  (0x8000U << DDRCTRL_DERATEINT_MR4_READ_INTERVAL_Pos)     /*!< 0x00008000 */
#define DDRCTRL_DERATEINT_MR4_READ_INTERVAL_16  (0x10000U << DDRCTRL_DERATEINT_MR4_READ_INTERVAL_Pos)    /*!< 0x00010000 */
#define DDRCTRL_DERATEINT_MR4_READ_INTERVAL_17  (0x20000U << DDRCTRL_DERATEINT_MR4_READ_INTERVAL_Pos)    /*!< 0x00020000 */
#define DDRCTRL_DERATEINT_MR4_READ_INTERVAL_18  (0x40000U << DDRCTRL_DERATEINT_MR4_READ_INTERVAL_Pos)    /*!< 0x00040000 */
#define DDRCTRL_DERATEINT_MR4_READ_INTERVAL_19  (0x80000U << DDRCTRL_DERATEINT_MR4_READ_INTERVAL_Pos)    /*!< 0x00080000 */
#define DDRCTRL_DERATEINT_MR4_READ_INTERVAL_20  (0x100000U << DDRCTRL_DERATEINT_MR4_READ_INTERVAL_Pos)   /*!< 0x00100000 */
#define DDRCTRL_DERATEINT_MR4_READ_INTERVAL_21  (0x200000U << DDRCTRL_DERATEINT_MR4_READ_INTERVAL_Pos)   /*!< 0x00200000 */
#define DDRCTRL_DERATEINT_MR4_READ_INTERVAL_22  (0x400000U << DDRCTRL_DERATEINT_MR4_READ_INTERVAL_Pos)   /*!< 0x00400000 */
#define DDRCTRL_DERATEINT_MR4_READ_INTERVAL_23  (0x800000U << DDRCTRL_DERATEINT_MR4_READ_INTERVAL_Pos)   /*!< 0x00800000 */
#define DDRCTRL_DERATEINT_MR4_READ_INTERVAL_24  (0x1000000U << DDRCTRL_DERATEINT_MR4_READ_INTERVAL_Pos)  /*!< 0x01000000 */
#define DDRCTRL_DERATEINT_MR4_READ_INTERVAL_25  (0x2000000U << DDRCTRL_DERATEINT_MR4_READ_INTERVAL_Pos)  /*!< 0x02000000 */
#define DDRCTRL_DERATEINT_MR4_READ_INTERVAL_26  (0x4000000U << DDRCTRL_DERATEINT_MR4_READ_INTERVAL_Pos)  /*!< 0x04000000 */
#define DDRCTRL_DERATEINT_MR4_READ_INTERVAL_27  (0x8000000U << DDRCTRL_DERATEINT_MR4_READ_INTERVAL_Pos)  /*!< 0x08000000 */
#define DDRCTRL_DERATEINT_MR4_READ_INTERVAL_28  (0x10000000U << DDRCTRL_DERATEINT_MR4_READ_INTERVAL_Pos) /*!< 0x10000000 */
#define DDRCTRL_DERATEINT_MR4_READ_INTERVAL_29  (0x20000000U << DDRCTRL_DERATEINT_MR4_READ_INTERVAL_Pos) /*!< 0x20000000 */
#define DDRCTRL_DERATEINT_MR4_READ_INTERVAL_30  (0x40000000U << DDRCTRL_DERATEINT_MR4_READ_INTERVAL_Pos) /*!< 0x40000000 */
#define DDRCTRL_DERATEINT_MR4_READ_INTERVAL_31  (0x80000000U << DDRCTRL_DERATEINT_MR4_READ_INTERVAL_Pos) /*!< 0x80000000 */

/****************  Bit definition for DDRCTRL_PWRCTL register  ****************/
#define DDRCTRL_PWRCTL_SELFREF_EN_Pos              (0U)
#define DDRCTRL_PWRCTL_SELFREF_EN_Msk              (0x1U << DDRCTRL_PWRCTL_SELFREF_EN_Pos)              /*!< 0x00000001 */
#define DDRCTRL_PWRCTL_SELFREF_EN                  DDRCTRL_PWRCTL_SELFREF_EN_Msk                        /*!< If true then the DDRCTRL puts the SDRAM into Self Refresh after a programmable number of cycles "maximum idle clocks before Self Refresh (PWRTMG.selfref_to_x32)". This register bit may be re-programmed during the course of normal operation. */
#define DDRCTRL_PWRCTL_POWERDOWN_EN_Pos            (1U)
#define DDRCTRL_PWRCTL_POWERDOWN_EN_Msk            (0x1U << DDRCTRL_PWRCTL_POWERDOWN_EN_Pos)            /*!< 0x00000002 */
#define DDRCTRL_PWRCTL_POWERDOWN_EN                DDRCTRL_PWRCTL_POWERDOWN_EN_Msk                      /*!< If true then the DDRCTRL goes into power-down after a programmable number of cycles "maximum idle clocks before power down" (PWRTMG.powerdown_to_x32). */
#define DDRCTRL_PWRCTL_DEEPPOWERDOWN_EN_Pos        (2U)
#define DDRCTRL_PWRCTL_DEEPPOWERDOWN_EN_Msk        (0x1U << DDRCTRL_PWRCTL_DEEPPOWERDOWN_EN_Pos)        /*!< 0x00000004 */
#define DDRCTRL_PWRCTL_DEEPPOWERDOWN_EN            DDRCTRL_PWRCTL_DEEPPOWERDOWN_EN_Msk                  /*!< When this is 1, DDRCTRL puts the SDRAM into deep power-down mode when the transaction store is empty. */
#define DDRCTRL_PWRCTL_EN_DFI_DRAM_CLK_DISABLE_Pos (3U)
#define DDRCTRL_PWRCTL_EN_DFI_DRAM_CLK_DISABLE_Msk (0x1U << DDRCTRL_PWRCTL_EN_DFI_DRAM_CLK_DISABLE_Pos) /*!< 0x00000008 */
#define DDRCTRL_PWRCTL_EN_DFI_DRAM_CLK_DISABLE     DDRCTRL_PWRCTL_EN_DFI_DRAM_CLK_DISABLE_Msk           /*!< Enable the assertion of dfi_dram_clk_disable whenever a clock is not required by the SDRAM. */
#define DDRCTRL_PWRCTL_SELFREF_SW_Pos              (5U)
#define DDRCTRL_PWRCTL_SELFREF_SW_Msk              (0x1U << DDRCTRL_PWRCTL_SELFREF_SW_Pos)              /*!< 0x00000020 */
#define DDRCTRL_PWRCTL_SELFREF_SW                  DDRCTRL_PWRCTL_SELFREF_SW_Msk                        /*!< A value of 1 to this register causes system to move to Self Refresh state immediately, as long as it is not in INIT or DPD/MPSM operating_mode. This is referred to as Software Entry/Exit to Self Refresh. */
#define DDRCTRL_PWRCTL_DIS_CAM_DRAIN_SELFREF_Pos   (7U)
#define DDRCTRL_PWRCTL_DIS_CAM_DRAIN_SELFREF_Msk   (0x1U << DDRCTRL_PWRCTL_DIS_CAM_DRAIN_SELFREF_Pos)   /*!< 0x00000080 */
#define DDRCTRL_PWRCTL_DIS_CAM_DRAIN_SELFREF       DDRCTRL_PWRCTL_DIS_CAM_DRAIN_SELFREF_Msk             /*!< Indicates whether skipping CAM draining is allowed when entering Self-Refresh. */

/****************  Bit definition for DDRCTRL_PWRTMG register  ****************/
#define DDRCTRL_PWRTMG_POWERDOWN_TO_X32_Pos (0U)
#define DDRCTRL_PWRTMG_POWERDOWN_TO_X32_Msk (0x1FU << DDRCTRL_PWRTMG_POWERDOWN_TO_X32_Pos) /*!< 0x0000001F */
#define DDRCTRL_PWRTMG_POWERDOWN_TO_X32     DDRCTRL_PWRTMG_POWERDOWN_TO_X32_Msk            /*!< After this many clocks of the DDRC command channel being idle the DDRCTRL automatically puts the SDRAM into power-down. The DDRC command channel is considered idle when there are no HIF commands outstanding. This must be enabled in the PWRCTL.powerdown_en. */
#define DDRCTRL_PWRTMG_POWERDOWN_TO_X32_0   (0x1U << DDRCTRL_PWRTMG_POWERDOWN_TO_X32_Pos)  /*!< 0x00000001 */
#define DDRCTRL_PWRTMG_POWERDOWN_TO_X32_1   (0x2U << DDRCTRL_PWRTMG_POWERDOWN_TO_X32_Pos)  /*!< 0x00000002 */
#define DDRCTRL_PWRTMG_POWERDOWN_TO_X32_2   (0x4U << DDRCTRL_PWRTMG_POWERDOWN_TO_X32_Pos)  /*!< 0x00000004 */
#define DDRCTRL_PWRTMG_POWERDOWN_TO_X32_3   (0x8U << DDRCTRL_PWRTMG_POWERDOWN_TO_X32_Pos)  /*!< 0x00000008 */
#define DDRCTRL_PWRTMG_POWERDOWN_TO_X32_4   (0x10U << DDRCTRL_PWRTMG_POWERDOWN_TO_X32_Pos) /*!< 0x00000010 */
#define DDRCTRL_PWRTMG_T_DPD_X4096_Pos      (8U)
#define DDRCTRL_PWRTMG_T_DPD_X4096_Msk      (0xFFU << DDRCTRL_PWRTMG_T_DPD_X4096_Pos)      /*!< 0x0000FF00 */
#define DDRCTRL_PWRTMG_T_DPD_X4096          DDRCTRL_PWRTMG_T_DPD_X4096_Msk                 /*!< Minimum deep power-down time. */
#define DDRCTRL_PWRTMG_T_DPD_X4096_0        (0x1U << DDRCTRL_PWRTMG_T_DPD_X4096_Pos)       /*!< 0x00000100 */
#define DDRCTRL_PWRTMG_T_DPD_X4096_1        (0x2U << DDRCTRL_PWRTMG_T_DPD_X4096_Pos)       /*!< 0x00000200 */
#define DDRCTRL_PWRTMG_T_DPD_X4096_2        (0x4U << DDRCTRL_PWRTMG_T_DPD_X4096_Pos)       /*!< 0x00000400 */
#define DDRCTRL_PWRTMG_T_DPD_X4096_3        (0x8U << DDRCTRL_PWRTMG_T_DPD_X4096_Pos)       /*!< 0x00000800 */
#define DDRCTRL_PWRTMG_T_DPD_X4096_4        (0x10U << DDRCTRL_PWRTMG_T_DPD_X4096_Pos)      /*!< 0x00001000 */
#define DDRCTRL_PWRTMG_T_DPD_X4096_5        (0x20U << DDRCTRL_PWRTMG_T_DPD_X4096_Pos)      /*!< 0x00002000 */
#define DDRCTRL_PWRTMG_T_DPD_X4096_6        (0x40U << DDRCTRL_PWRTMG_T_DPD_X4096_Pos)      /*!< 0x00004000 */
#define DDRCTRL_PWRTMG_T_DPD_X4096_7        (0x80U << DDRCTRL_PWRTMG_T_DPD_X4096_Pos)      /*!< 0x00008000 */
#define DDRCTRL_PWRTMG_SELFREF_TO_X32_Pos   (16U)
#define DDRCTRL_PWRTMG_SELFREF_TO_X32_Msk   (0xFFU << DDRCTRL_PWRTMG_SELFREF_TO_X32_Pos)   /*!< 0x00FF0000 */
#define DDRCTRL_PWRTMG_SELFREF_TO_X32       DDRCTRL_PWRTMG_SELFREF_TO_X32_Msk              /*!< After this many clocks of the DDRC command channel being idle the DDRCTRL automatically puts the SDRAM into Self Refresh. The DDRC command channel is considered idle when there are no HIF commands outstanding. This must be enabled in the PWRCTL.selfref_en. */
#define DDRCTRL_PWRTMG_SELFREF_TO_X32_0     (0x1U << DDRCTRL_PWRTMG_SELFREF_TO_X32_Pos)    /*!< 0x00010000 */
#define DDRCTRL_PWRTMG_SELFREF_TO_X32_1     (0x2U << DDRCTRL_PWRTMG_SELFREF_TO_X32_Pos)    /*!< 0x00020000 */
#define DDRCTRL_PWRTMG_SELFREF_TO_X32_2     (0x4U << DDRCTRL_PWRTMG_SELFREF_TO_X32_Pos)    /*!< 0x00040000 */
#define DDRCTRL_PWRTMG_SELFREF_TO_X32_3     (0x8U << DDRCTRL_PWRTMG_SELFREF_TO_X32_Pos)    /*!< 0x00080000 */
#define DDRCTRL_PWRTMG_SELFREF_TO_X32_4     (0x10U << DDRCTRL_PWRTMG_SELFREF_TO_X32_Pos)   /*!< 0x00100000 */
#define DDRCTRL_PWRTMG_SELFREF_TO_X32_5     (0x20U << DDRCTRL_PWRTMG_SELFREF_TO_X32_Pos)   /*!< 0x00200000 */
#define DDRCTRL_PWRTMG_SELFREF_TO_X32_6     (0x40U << DDRCTRL_PWRTMG_SELFREF_TO_X32_Pos)   /*!< 0x00400000 */
#define DDRCTRL_PWRTMG_SELFREF_TO_X32_7     (0x80U << DDRCTRL_PWRTMG_SELFREF_TO_X32_Pos)   /*!< 0x00800000 */

/***************  Bit definition for DDRCTRL_HWLPCTL register  ****************/
#define DDRCTRL_HWLPCTL_HW_LP_EN_Pos           (0U)
#define DDRCTRL_HWLPCTL_HW_LP_EN_Msk           (0x1U << DDRCTRL_HWLPCTL_HW_LP_EN_Pos)           /*!< 0x00000001 */
#define DDRCTRL_HWLPCTL_HW_LP_EN               DDRCTRL_HWLPCTL_HW_LP_EN_Msk                     /*!< Enable for hardware low power interface. */
#define DDRCTRL_HWLPCTL_HW_LP_EXIT_IDLE_EN_Pos (1U)
#define DDRCTRL_HWLPCTL_HW_LP_EXIT_IDLE_EN_Msk (0x1U << DDRCTRL_HWLPCTL_HW_LP_EXIT_IDLE_EN_Pos) /*!< 0x00000002 */
#define DDRCTRL_HWLPCTL_HW_LP_EXIT_IDLE_EN     DDRCTRL_HWLPCTL_HW_LP_EXIT_IDLE_EN_Msk           /*!< When this bit is programmed to 1 the cactive_in_ddrc pin of the DDRC can be used to exit from the automatic clock stop, automatic power down or automatic self-refresh modes. Note, it does not cause exit of Self-Refresh that is caused by Hardware Low power interface and/or software (PWRCTL.selfref_sw). */
#define DDRCTRL_HWLPCTL_HW_LP_IDLE_X32_Pos     (16U)
#define DDRCTRL_HWLPCTL_HW_LP_IDLE_X32_Msk     (0xFFFU << DDRCTRL_HWLPCTL_HW_LP_IDLE_X32_Pos)   /*!< 0x0FFF0000 */
#define DDRCTRL_HWLPCTL_HW_LP_IDLE_X32         DDRCTRL_HWLPCTL_HW_LP_IDLE_X32_Msk               /*!< Hardware idle period. The cactive_ddrc output is driven low if the DDRC command channel is idle for hw_lp_idle * 32 cycles if not in INIT or DPD/MPSM operating_mode. The DDRC command channel is considered idle when there are no HIF commands outstanding. The hardware idle function is disabled when hw_lp_idle_x32=0. */
#define DDRCTRL_HWLPCTL_HW_LP_IDLE_X32_0       (0x1U << DDRCTRL_HWLPCTL_HW_LP_IDLE_X32_Pos)     /*!< 0x00010000 */
#define DDRCTRL_HWLPCTL_HW_LP_IDLE_X32_1       (0x2U << DDRCTRL_HWLPCTL_HW_LP_IDLE_X32_Pos)     /*!< 0x00020000 */
#define DDRCTRL_HWLPCTL_HW_LP_IDLE_X32_2       (0x4U << DDRCTRL_HWLPCTL_HW_LP_IDLE_X32_Pos)     /*!< 0x00040000 */
#define DDRCTRL_HWLPCTL_HW_LP_IDLE_X32_3       (0x8U << DDRCTRL_HWLPCTL_HW_LP_IDLE_X32_Pos)     /*!< 0x00080000 */
#define DDRCTRL_HWLPCTL_HW_LP_IDLE_X32_4       (0x10U << DDRCTRL_HWLPCTL_HW_LP_IDLE_X32_Pos)    /*!< 0x00100000 */
#define DDRCTRL_HWLPCTL_HW_LP_IDLE_X32_5       (0x20U << DDRCTRL_HWLPCTL_HW_LP_IDLE_X32_Pos)    /*!< 0x00200000 */
#define DDRCTRL_HWLPCTL_HW_LP_IDLE_X32_6       (0x40U << DDRCTRL_HWLPCTL_HW_LP_IDLE_X32_Pos)    /*!< 0x00400000 */
#define DDRCTRL_HWLPCTL_HW_LP_IDLE_X32_7       (0x80U << DDRCTRL_HWLPCTL_HW_LP_IDLE_X32_Pos)    /*!< 0x00800000 */
#define DDRCTRL_HWLPCTL_HW_LP_IDLE_X32_8       (0x100U << DDRCTRL_HWLPCTL_HW_LP_IDLE_X32_Pos)   /*!< 0x01000000 */
#define DDRCTRL_HWLPCTL_HW_LP_IDLE_X32_9       (0x200U << DDRCTRL_HWLPCTL_HW_LP_IDLE_X32_Pos)   /*!< 0x02000000 */
#define DDRCTRL_HWLPCTL_HW_LP_IDLE_X32_10      (0x400U << DDRCTRL_HWLPCTL_HW_LP_IDLE_X32_Pos)   /*!< 0x04000000 */
#define DDRCTRL_HWLPCTL_HW_LP_IDLE_X32_11      (0x800U << DDRCTRL_HWLPCTL_HW_LP_IDLE_X32_Pos)   /*!< 0x08000000 */

/***************  Bit definition for DDRCTRL_RFSHCTL0 register  ***************/
#define DDRCTRL_RFSHCTL0_PER_BANK_REFRESH_Pos (2U)
#define DDRCTRL_RFSHCTL0_PER_BANK_REFRESH_Msk (0x1U << DDRCTRL_RFSHCTL0_PER_BANK_REFRESH_Pos) /*!< 0x00000004 */
#define DDRCTRL_RFSHCTL0_PER_BANK_REFRESH     DDRCTRL_RFSHCTL0_PER_BANK_REFRESH_Msk           /*!< - 1 - Per bank refresh; */
#define DDRCTRL_RFSHCTL0_REFRESH_BURST_Pos    (4U)
#define DDRCTRL_RFSHCTL0_REFRESH_BURST_Msk    (0x1FU << DDRCTRL_RFSHCTL0_REFRESH_BURST_Pos)   /*!< 0x000001F0 */
#define DDRCTRL_RFSHCTL0_REFRESH_BURST        DDRCTRL_RFSHCTL0_REFRESH_BURST_Msk              /*!< The programmed value + 1 is the number of refresh timeouts that is allowed to accumulate before traffic is blocked and the refreshes are forced to execute. Closing pages to perform a refresh is a one-time penalty that must be paid for each group of refreshes. Therefore, performing refreshes in a burst reduces the per-refresh penalty of these page closings. Higher numbers for RFSHCTL.refresh_burst slightly increases utilization; lower numbers decreases the worst-case latency associated with refreshes. */
#define DDRCTRL_RFSHCTL0_REFRESH_BURST_0      (0x1U << DDRCTRL_RFSHCTL0_REFRESH_BURST_Pos)    /*!< 0x00000010 */
#define DDRCTRL_RFSHCTL0_REFRESH_BURST_1      (0x2U << DDRCTRL_RFSHCTL0_REFRESH_BURST_Pos)    /*!< 0x00000020 */
#define DDRCTRL_RFSHCTL0_REFRESH_BURST_2      (0x4U << DDRCTRL_RFSHCTL0_REFRESH_BURST_Pos)    /*!< 0x00000040 */
#define DDRCTRL_RFSHCTL0_REFRESH_BURST_3      (0x8U << DDRCTRL_RFSHCTL0_REFRESH_BURST_Pos)    /*!< 0x00000080 */
#define DDRCTRL_RFSHCTL0_REFRESH_BURST_4      (0x10U << DDRCTRL_RFSHCTL0_REFRESH_BURST_Pos)   /*!< 0x00000100 */
#define DDRCTRL_RFSHCTL0_REFRESH_TO_X32_Pos   (12U)
#define DDRCTRL_RFSHCTL0_REFRESH_TO_X32_Msk   (0x1FU << DDRCTRL_RFSHCTL0_REFRESH_TO_X32_Pos)  /*!< 0x0001F000 */
#define DDRCTRL_RFSHCTL0_REFRESH_TO_X32       DDRCTRL_RFSHCTL0_REFRESH_TO_X32_Msk             /*!< If the refresh timer (tRFCnom, also known as tREFI) has expired at least once, but it has not expired (RFSHCTL0.refresh_burst+1) times yet, then a speculative refresh may be performed. A speculative refresh is a refresh performed at a time when refresh would be useful, but before it is absolutely required. When the SDRAM bus is idle for a period of time determined by this RFSHCTL0.refresh_to_x32 and the refresh timer has expired at least once since the last refresh, then a speculative refresh is performed. Speculative refreshes continues successively until there are no refreshes pending or until new reads or writes are issued to the DDRCTRL. */
#define DDRCTRL_RFSHCTL0_REFRESH_TO_X32_0     (0x1U << DDRCTRL_RFSHCTL0_REFRESH_TO_X32_Pos)   /*!< 0x00001000 */
#define DDRCTRL_RFSHCTL0_REFRESH_TO_X32_1     (0x2U << DDRCTRL_RFSHCTL0_REFRESH_TO_X32_Pos)   /*!< 0x00002000 */
#define DDRCTRL_RFSHCTL0_REFRESH_TO_X32_2     (0x4U << DDRCTRL_RFSHCTL0_REFRESH_TO_X32_Pos)   /*!< 0x00004000 */
#define DDRCTRL_RFSHCTL0_REFRESH_TO_X32_3     (0x8U << DDRCTRL_RFSHCTL0_REFRESH_TO_X32_Pos)   /*!< 0x00008000 */
#define DDRCTRL_RFSHCTL0_REFRESH_TO_X32_4     (0x10U << DDRCTRL_RFSHCTL0_REFRESH_TO_X32_Pos)  /*!< 0x00010000 */
#define DDRCTRL_RFSHCTL0_REFRESH_MARGIN_Pos   (20U)
#define DDRCTRL_RFSHCTL0_REFRESH_MARGIN_Msk   (0xFU << DDRCTRL_RFSHCTL0_REFRESH_MARGIN_Pos)   /*!< 0x00F00000 */
#define DDRCTRL_RFSHCTL0_REFRESH_MARGIN       DDRCTRL_RFSHCTL0_REFRESH_MARGIN_Msk             /*!< Threshold value in number of DFI clock cycles before the critical refresh or page timer expires. A critical refresh is to be issued before this threshold is reached. It is recommended that this not be changed from the default value, currently shown as 0x2. It must always be less than internally used t_rfc_nom/32. Note that internally used t_rfc_nom is equal to RFSHTMG.t_rfc_nom_x1_x32 * 32 if RFSHTMG.t_rfc_nom_x1_sel=0. If RFSHTMG.t_rfc_nom_x1_sel=1 (for LPDDR2/LPDDR3/LPDDR4 per-bank refresh only), internally used t_rfc_nom is equal to RFSHTMG.t_rfc_nom_x1_x32. Note that, in LPDDR2/LPDDR3/LPDDR4, internally used t_rfc_nom may be divided by four if derating is enabled (DERATEEN.derate_enable=1). */
#define DDRCTRL_RFSHCTL0_REFRESH_MARGIN_0     (0x1U << DDRCTRL_RFSHCTL0_REFRESH_MARGIN_Pos)   /*!< 0x00100000 */
#define DDRCTRL_RFSHCTL0_REFRESH_MARGIN_1     (0x2U << DDRCTRL_RFSHCTL0_REFRESH_MARGIN_Pos)   /*!< 0x00200000 */
#define DDRCTRL_RFSHCTL0_REFRESH_MARGIN_2     (0x4U << DDRCTRL_RFSHCTL0_REFRESH_MARGIN_Pos)   /*!< 0x00400000 */
#define DDRCTRL_RFSHCTL0_REFRESH_MARGIN_3     (0x8U << DDRCTRL_RFSHCTL0_REFRESH_MARGIN_Pos)   /*!< 0x00800000 */

/***************  Bit definition for DDRCTRL_RFSHCTL3 register  ***************/
#define DDRCTRL_RFSHCTL3_DIS_AUTO_REFRESH_Pos     (0U)
#define DDRCTRL_RFSHCTL3_DIS_AUTO_REFRESH_Msk     (0x1U << DDRCTRL_RFSHCTL3_DIS_AUTO_REFRESH_Pos)     /*!< 0x00000001 */
#define DDRCTRL_RFSHCTL3_DIS_AUTO_REFRESH         DDRCTRL_RFSHCTL3_DIS_AUTO_REFRESH_Msk               /*!< When \q1\q, disable auto-refresh generated by the DDRCTRL. When auto-refresh is disabled, the SoC core must generate refreshes using the registers DBGCMD.rankn_refresh. */
#define DDRCTRL_RFSHCTL3_REFRESH_UPDATE_LEVEL_Pos (1U)
#define DDRCTRL_RFSHCTL3_REFRESH_UPDATE_LEVEL_Msk (0x1U << DDRCTRL_RFSHCTL3_REFRESH_UPDATE_LEVEL_Pos) /*!< 0x00000002 */
#define DDRCTRL_RFSHCTL3_REFRESH_UPDATE_LEVEL     DDRCTRL_RFSHCTL3_REFRESH_UPDATE_LEVEL_Msk           /*!< Toggles this signal (either from 0 to 1 or from 1 to 0) to indicate that the refresh register(s) have been updated. */

/***************  Bit definition for DDRCTRL_RFSHTMG register  ****************/
#define DDRCTRL_RFSHTMG_T_RFC_MIN_Pos        (0U)
#define DDRCTRL_RFSHTMG_T_RFC_MIN_Msk        (0x3FFU << DDRCTRL_RFSHTMG_T_RFC_MIN_Pos)        /*!< 0x000003FF */
#define DDRCTRL_RFSHTMG_T_RFC_MIN            DDRCTRL_RFSHTMG_T_RFC_MIN_Msk                    /*!< tRFC (min): Minimum time from refresh to refresh or activate. */
#define DDRCTRL_RFSHTMG_T_RFC_MIN_0          (0x1U << DDRCTRL_RFSHTMG_T_RFC_MIN_Pos)          /*!< 0x00000001 */
#define DDRCTRL_RFSHTMG_T_RFC_MIN_1          (0x2U << DDRCTRL_RFSHTMG_T_RFC_MIN_Pos)          /*!< 0x00000002 */
#define DDRCTRL_RFSHTMG_T_RFC_MIN_2          (0x4U << DDRCTRL_RFSHTMG_T_RFC_MIN_Pos)          /*!< 0x00000004 */
#define DDRCTRL_RFSHTMG_T_RFC_MIN_3          (0x8U << DDRCTRL_RFSHTMG_T_RFC_MIN_Pos)          /*!< 0x00000008 */
#define DDRCTRL_RFSHTMG_T_RFC_MIN_4          (0x10U << DDRCTRL_RFSHTMG_T_RFC_MIN_Pos)         /*!< 0x00000010 */
#define DDRCTRL_RFSHTMG_T_RFC_MIN_5          (0x20U << DDRCTRL_RFSHTMG_T_RFC_MIN_Pos)         /*!< 0x00000020 */
#define DDRCTRL_RFSHTMG_T_RFC_MIN_6          (0x40U << DDRCTRL_RFSHTMG_T_RFC_MIN_Pos)         /*!< 0x00000040 */
#define DDRCTRL_RFSHTMG_T_RFC_MIN_7          (0x80U << DDRCTRL_RFSHTMG_T_RFC_MIN_Pos)         /*!< 0x00000080 */
#define DDRCTRL_RFSHTMG_T_RFC_MIN_8          (0x100U << DDRCTRL_RFSHTMG_T_RFC_MIN_Pos)        /*!< 0x00000100 */
#define DDRCTRL_RFSHTMG_T_RFC_MIN_9          (0x200U << DDRCTRL_RFSHTMG_T_RFC_MIN_Pos)        /*!< 0x00000200 */
#define DDRCTRL_RFSHTMG_LPDDR3_TREFBW_EN_Pos (15U)
#define DDRCTRL_RFSHTMG_LPDDR3_TREFBW_EN_Msk (0x1U << DDRCTRL_RFSHTMG_LPDDR3_TREFBW_EN_Pos)   /*!< 0x00008000 */
#define DDRCTRL_RFSHTMG_LPDDR3_TREFBW_EN     DDRCTRL_RFSHTMG_LPDDR3_TREFBW_EN_Msk             /*!< Used only when LPDDR3 memory type is connected. Should only be changed when DDRCTRL is in reset. Specifies whether to use the tREFBW parameter (required by some LPDDR3 devices which comply with earlier versions of the LPDDR3 JEDEC specification) or not: */
#define DDRCTRL_RFSHTMG_T_RFC_NOM_X1_X32_Pos (16U)
#define DDRCTRL_RFSHTMG_T_RFC_NOM_X1_X32_Msk (0xFFFU << DDRCTRL_RFSHTMG_T_RFC_NOM_X1_X32_Pos) /*!< 0x0FFF0000 */
#define DDRCTRL_RFSHTMG_T_RFC_NOM_X1_X32     DDRCTRL_RFSHTMG_T_RFC_NOM_X1_X32_Msk             /*!< tREFI: Average time interval between refreshes per rank (Specification: 7.8us for DDR2, DDR3 and DDR4. See JEDEC specification for mDDR, LPDDR2, LPDDR3 and LPDDR4). */
#define DDRCTRL_RFSHTMG_T_RFC_NOM_X1_X32_0   (0x1U << DDRCTRL_RFSHTMG_T_RFC_NOM_X1_X32_Pos)   /*!< 0x00010000 */
#define DDRCTRL_RFSHTMG_T_RFC_NOM_X1_X32_1   (0x2U << DDRCTRL_RFSHTMG_T_RFC_NOM_X1_X32_Pos)   /*!< 0x00020000 */
#define DDRCTRL_RFSHTMG_T_RFC_NOM_X1_X32_2   (0x4U << DDRCTRL_RFSHTMG_T_RFC_NOM_X1_X32_Pos)   /*!< 0x00040000 */
#define DDRCTRL_RFSHTMG_T_RFC_NOM_X1_X32_3   (0x8U << DDRCTRL_RFSHTMG_T_RFC_NOM_X1_X32_Pos)   /*!< 0x00080000 */
#define DDRCTRL_RFSHTMG_T_RFC_NOM_X1_X32_4   (0x10U << DDRCTRL_RFSHTMG_T_RFC_NOM_X1_X32_Pos)  /*!< 0x00100000 */
#define DDRCTRL_RFSHTMG_T_RFC_NOM_X1_X32_5   (0x20U << DDRCTRL_RFSHTMG_T_RFC_NOM_X1_X32_Pos)  /*!< 0x00200000 */
#define DDRCTRL_RFSHTMG_T_RFC_NOM_X1_X32_6   (0x40U << DDRCTRL_RFSHTMG_T_RFC_NOM_X1_X32_Pos)  /*!< 0x00400000 */
#define DDRCTRL_RFSHTMG_T_RFC_NOM_X1_X32_7   (0x80U << DDRCTRL_RFSHTMG_T_RFC_NOM_X1_X32_Pos)  /*!< 0x00800000 */
#define DDRCTRL_RFSHTMG_T_RFC_NOM_X1_X32_8   (0x100U << DDRCTRL_RFSHTMG_T_RFC_NOM_X1_X32_Pos) /*!< 0x01000000 */
#define DDRCTRL_RFSHTMG_T_RFC_NOM_X1_X32_9   (0x200U << DDRCTRL_RFSHTMG_T_RFC_NOM_X1_X32_Pos) /*!< 0x02000000 */
#define DDRCTRL_RFSHTMG_T_RFC_NOM_X1_X32_10  (0x400U << DDRCTRL_RFSHTMG_T_RFC_NOM_X1_X32_Pos) /*!< 0x04000000 */
#define DDRCTRL_RFSHTMG_T_RFC_NOM_X1_X32_11  (0x800U << DDRCTRL_RFSHTMG_T_RFC_NOM_X1_X32_Pos) /*!< 0x08000000 */
#define DDRCTRL_RFSHTMG_T_RFC_NOM_X1_SEL_Pos (31U)
#define DDRCTRL_RFSHTMG_T_RFC_NOM_X1_SEL_Msk (0x1U << DDRCTRL_RFSHTMG_T_RFC_NOM_X1_SEL_Pos)  /*!< 0x80000000 */
#define DDRCTRL_RFSHTMG_T_RFC_NOM_X1_SEL     DDRCTRL_RFSHTMG_T_RFC_NOM_X1_SEL_Msk         /*!< Specifies whether the t_rfc_nom_x1_x32 register value is x1 or x32. */

/**************  Bit definition for DDRCTRL_CRCPARCTL0 register  **************/
#define DDRCTRL_CRCPARCTL0_DFI_ALERT_ERR_INT_EN_Pos  (0U)
#define DDRCTRL_CRCPARCTL0_DFI_ALERT_ERR_INT_EN_Msk  (0x1U << DDRCTRL_CRCPARCTL0_DFI_ALERT_ERR_INT_EN_Pos)  /*!< 0x00000001 */
#define DDRCTRL_CRCPARCTL0_DFI_ALERT_ERR_INT_EN      DDRCTRL_CRCPARCTL0_DFI_ALERT_ERR_INT_EN_Msk            /*!< Interrupt enable bit for DFI alert error. If this bit is set, any parity/CRC error detected on the dfi_alert_n input results in an interrupt being set on CRCPARSTAT.dfi_alert_err_int. */
#define DDRCTRL_CRCPARCTL0_DFI_ALERT_ERR_INT_CLR_Pos (1U)
#define DDRCTRL_CRCPARCTL0_DFI_ALERT_ERR_INT_CLR_Msk (0x1U << DDRCTRL_CRCPARCTL0_DFI_ALERT_ERR_INT_CLR_Pos) /*!< 0x00000002 */
#define DDRCTRL_CRCPARCTL0_DFI_ALERT_ERR_INT_CLR     DDRCTRL_CRCPARCTL0_DFI_ALERT_ERR_INT_CLR_Msk           /*!< Interrupt clear bit for DFI alert error. If this bit is set, the alert error interrupt on CRCPARSTAT.dfi_alert_err_int is cleared. When the clear operation is complete, the DDRCTRL automatically clears this bit. */
#define DDRCTRL_CRCPARCTL0_DFI_ALERT_ERR_CNT_CLR_Pos (2U)
#define DDRCTRL_CRCPARCTL0_DFI_ALERT_ERR_CNT_CLR_Msk (0x1U << DDRCTRL_CRCPARCTL0_DFI_ALERT_ERR_CNT_CLR_Pos) /*!< 0x00000004 */
#define DDRCTRL_CRCPARCTL0_DFI_ALERT_ERR_CNT_CLR     DDRCTRL_CRCPARCTL0_DFI_ALERT_ERR_CNT_CLR_Msk           /*!< DFI alert error count clear. Clear bit for DFI alert error counter. Asserting this bit, clears the DFI alert error counter, CRCPARSTAT.dfi_alert_err_cnt. When the clear operation is complete, the DDRCTRL automatically clears this bit. */

/**************  Bit definition for DDRCTRL_CRCPARSTAT register  **************/
#define DDRCTRL_CRCPARSTAT_DFI_ALERT_ERR_CNT_Pos (0U)
#define DDRCTRL_CRCPARSTAT_DFI_ALERT_ERR_CNT_Msk (0xFFFFU << DDRCTRL_CRCPARSTAT_DFI_ALERT_ERR_CNT_Pos) /*!< 0x0000FFFF */
#define DDRCTRL_CRCPARSTAT_DFI_ALERT_ERR_CNT     DDRCTRL_CRCPARSTAT_DFI_ALERT_ERR_CNT_Msk              /*!< DFI alert error count. */
#define DDRCTRL_CRCPARSTAT_DFI_ALERT_ERR_CNT_0   (0x1U << DDRCTRL_CRCPARSTAT_DFI_ALERT_ERR_CNT_Pos)    /*!< 0x00000001 */
#define DDRCTRL_CRCPARSTAT_DFI_ALERT_ERR_CNT_1   (0x2U << DDRCTRL_CRCPARSTAT_DFI_ALERT_ERR_CNT_Pos)    /*!< 0x00000002 */
#define DDRCTRL_CRCPARSTAT_DFI_ALERT_ERR_CNT_2   (0x4U << DDRCTRL_CRCPARSTAT_DFI_ALERT_ERR_CNT_Pos)    /*!< 0x00000004 */
#define DDRCTRL_CRCPARSTAT_DFI_ALERT_ERR_CNT_3   (0x8U << DDRCTRL_CRCPARSTAT_DFI_ALERT_ERR_CNT_Pos)    /*!< 0x00000008 */
#define DDRCTRL_CRCPARSTAT_DFI_ALERT_ERR_CNT_4   (0x10U << DDRCTRL_CRCPARSTAT_DFI_ALERT_ERR_CNT_Pos)   /*!< 0x00000010 */
#define DDRCTRL_CRCPARSTAT_DFI_ALERT_ERR_CNT_5   (0x20U << DDRCTRL_CRCPARSTAT_DFI_ALERT_ERR_CNT_Pos)   /*!< 0x00000020 */
#define DDRCTRL_CRCPARSTAT_DFI_ALERT_ERR_CNT_6   (0x40U << DDRCTRL_CRCPARSTAT_DFI_ALERT_ERR_CNT_Pos)   /*!< 0x00000040 */
#define DDRCTRL_CRCPARSTAT_DFI_ALERT_ERR_CNT_7   (0x80U << DDRCTRL_CRCPARSTAT_DFI_ALERT_ERR_CNT_Pos)   /*!< 0x00000080 */
#define DDRCTRL_CRCPARSTAT_DFI_ALERT_ERR_CNT_8   (0x100U << DDRCTRL_CRCPARSTAT_DFI_ALERT_ERR_CNT_Pos)  /*!< 0x00000100 */
#define DDRCTRL_CRCPARSTAT_DFI_ALERT_ERR_CNT_9   (0x200U << DDRCTRL_CRCPARSTAT_DFI_ALERT_ERR_CNT_Pos)  /*!< 0x00000200 */
#define DDRCTRL_CRCPARSTAT_DFI_ALERT_ERR_CNT_10  (0x400U << DDRCTRL_CRCPARSTAT_DFI_ALERT_ERR_CNT_Pos)  /*!< 0x00000400 */
#define DDRCTRL_CRCPARSTAT_DFI_ALERT_ERR_CNT_11  (0x800U << DDRCTRL_CRCPARSTAT_DFI_ALERT_ERR_CNT_Pos)  /*!< 0x00000800 */
#define DDRCTRL_CRCPARSTAT_DFI_ALERT_ERR_CNT_12  (0x1000U << DDRCTRL_CRCPARSTAT_DFI_ALERT_ERR_CNT_Pos) /*!< 0x00001000 */
#define DDRCTRL_CRCPARSTAT_DFI_ALERT_ERR_CNT_13  (0x2000U << DDRCTRL_CRCPARSTAT_DFI_ALERT_ERR_CNT_Pos) /*!< 0x00002000 */
#define DDRCTRL_CRCPARSTAT_DFI_ALERT_ERR_CNT_14  (0x4000U << DDRCTRL_CRCPARSTAT_DFI_ALERT_ERR_CNT_Pos) /*!< 0x00004000 */
#define DDRCTRL_CRCPARSTAT_DFI_ALERT_ERR_CNT_15  (0x8000U << DDRCTRL_CRCPARSTAT_DFI_ALERT_ERR_CNT_Pos) /*!< 0x00008000 */
#define DDRCTRL_CRCPARSTAT_DFI_ALERT_ERR_INT_Pos (16U)
#define DDRCTRL_CRCPARSTAT_DFI_ALERT_ERR_INT_Msk (0x1U << DDRCTRL_CRCPARSTAT_DFI_ALERT_ERR_INT_Pos)    /*!< 0x00010000 */
#define DDRCTRL_CRCPARSTAT_DFI_ALERT_ERR_INT     DDRCTRL_CRCPARSTAT_DFI_ALERT_ERR_INT_Msk              /*!< DFI alert error interrupt. */

/****************  Bit definition for DDRCTRL_INIT0 register  *****************/
#define DDRCTRL_INIT0_PRE_CKE_X1024_Pos  (0U)
#define DDRCTRL_INIT0_PRE_CKE_X1024_Msk  (0xFFFU << DDRCTRL_INIT0_PRE_CKE_X1024_Pos)  /*!< 0x00000FFF */
#define DDRCTRL_INIT0_PRE_CKE_X1024      DDRCTRL_INIT0_PRE_CKE_X1024_Msk              /*!< Cycles to wait after reset before driving CKE high to start the SDRAM initialization sequence. */
#define DDRCTRL_INIT0_PRE_CKE_X1024_0    (0x1U << DDRCTRL_INIT0_PRE_CKE_X1024_Pos)    /*!< 0x00000001 */
#define DDRCTRL_INIT0_PRE_CKE_X1024_1    (0x2U << DDRCTRL_INIT0_PRE_CKE_X1024_Pos)    /*!< 0x00000002 */
#define DDRCTRL_INIT0_PRE_CKE_X1024_2    (0x4U << DDRCTRL_INIT0_PRE_CKE_X1024_Pos)    /*!< 0x00000004 */
#define DDRCTRL_INIT0_PRE_CKE_X1024_3    (0x8U << DDRCTRL_INIT0_PRE_CKE_X1024_Pos)    /*!< 0x00000008 */
#define DDRCTRL_INIT0_PRE_CKE_X1024_4    (0x10U << DDRCTRL_INIT0_PRE_CKE_X1024_Pos)   /*!< 0x00000010 */
#define DDRCTRL_INIT0_PRE_CKE_X1024_5    (0x20U << DDRCTRL_INIT0_PRE_CKE_X1024_Pos)   /*!< 0x00000020 */
#define DDRCTRL_INIT0_PRE_CKE_X1024_6    (0x40U << DDRCTRL_INIT0_PRE_CKE_X1024_Pos)   /*!< 0x00000040 */
#define DDRCTRL_INIT0_PRE_CKE_X1024_7    (0x80U << DDRCTRL_INIT0_PRE_CKE_X1024_Pos)   /*!< 0x00000080 */
#define DDRCTRL_INIT0_PRE_CKE_X1024_8    (0x100U << DDRCTRL_INIT0_PRE_CKE_X1024_Pos)  /*!< 0x00000100 */
#define DDRCTRL_INIT0_PRE_CKE_X1024_9    (0x200U << DDRCTRL_INIT0_PRE_CKE_X1024_Pos)  /*!< 0x00000200 */
#define DDRCTRL_INIT0_PRE_CKE_X1024_10   (0x400U << DDRCTRL_INIT0_PRE_CKE_X1024_Pos)  /*!< 0x00000400 */
#define DDRCTRL_INIT0_PRE_CKE_X1024_11   (0x800U << DDRCTRL_INIT0_PRE_CKE_X1024_Pos)  /*!< 0x00000800 */
#define DDRCTRL_INIT0_POST_CKE_X1024_Pos (16U)
#define DDRCTRL_INIT0_POST_CKE_X1024_Msk (0x3FFU << DDRCTRL_INIT0_POST_CKE_X1024_Pos) /*!< 0x03FF0000 */
#define DDRCTRL_INIT0_POST_CKE_X1024     DDRCTRL_INIT0_POST_CKE_X1024_Msk             /*!< Cycles to wait after driving CKE high to start the SDRAM initialization sequence. */
#define DDRCTRL_INIT0_POST_CKE_X1024_0   (0x1U << DDRCTRL_INIT0_POST_CKE_X1024_Pos)   /*!< 0x00010000 */
#define DDRCTRL_INIT0_POST_CKE_X1024_1   (0x2U << DDRCTRL_INIT0_POST_CKE_X1024_Pos)   /*!< 0x00020000 */
#define DDRCTRL_INIT0_POST_CKE_X1024_2   (0x4U << DDRCTRL_INIT0_POST_CKE_X1024_Pos)   /*!< 0x00040000 */
#define DDRCTRL_INIT0_POST_CKE_X1024_3   (0x8U << DDRCTRL_INIT0_POST_CKE_X1024_Pos)   /*!< 0x00080000 */
#define DDRCTRL_INIT0_POST_CKE_X1024_4   (0x10U << DDRCTRL_INIT0_POST_CKE_X1024_Pos)  /*!< 0x00100000 */
#define DDRCTRL_INIT0_POST_CKE_X1024_5   (0x20U << DDRCTRL_INIT0_POST_CKE_X1024_Pos)  /*!< 0x00200000 */
#define DDRCTRL_INIT0_POST_CKE_X1024_6   (0x40U << DDRCTRL_INIT0_POST_CKE_X1024_Pos)  /*!< 0x00400000 */
#define DDRCTRL_INIT0_POST_CKE_X1024_7   (0x80U << DDRCTRL_INIT0_POST_CKE_X1024_Pos)  /*!< 0x00800000 */
#define DDRCTRL_INIT0_POST_CKE_X1024_8   (0x100U << DDRCTRL_INIT0_POST_CKE_X1024_Pos) /*!< 0x01000000 */
#define DDRCTRL_INIT0_POST_CKE_X1024_9   (0x200U << DDRCTRL_INIT0_POST_CKE_X1024_Pos) /*!< 0x02000000 */
#define DDRCTRL_INIT0_SKIP_DRAM_INIT_Pos (30U)
#define DDRCTRL_INIT0_SKIP_DRAM_INIT_Msk (0x3U << DDRCTRL_INIT0_SKIP_DRAM_INIT_Pos)   /*!< 0xC0000000 */
#define DDRCTRL_INIT0_SKIP_DRAM_INIT     DDRCTRL_INIT0_SKIP_DRAM_INIT_Msk             /*!< If lower bit is enabled the SDRAM initialization routine is skipped. The upper bit decides what state the controller starts up in when reset is removed */
#define DDRCTRL_INIT0_SKIP_DRAM_INIT_0   (0x1U << DDRCTRL_INIT0_SKIP_DRAM_INIT_Pos)   /*!< 0x40000000 */
#define DDRCTRL_INIT0_SKIP_DRAM_INIT_1   (0x2U << DDRCTRL_INIT0_SKIP_DRAM_INIT_Pos)   /*!< 0x80000000 */

/****************  Bit definition for DDRCTRL_INIT1 register  *****************/
#define DDRCTRL_INIT1_PRE_OCD_X32_Pos     (0U)
#define DDRCTRL_INIT1_PRE_OCD_X32_Msk     (0xFU << DDRCTRL_INIT1_PRE_OCD_X32_Pos)       /*!< 0x0000000F */
#define DDRCTRL_INIT1_PRE_OCD_X32         DDRCTRL_INIT1_PRE_OCD_X32_Msk                 /*!< Wait period before driving the OCD complete command to SDRAM. */
#define DDRCTRL_INIT1_PRE_OCD_X32_0       (0x1U << DDRCTRL_INIT1_PRE_OCD_X32_Pos)       /*!< 0x00000001 */
#define DDRCTRL_INIT1_PRE_OCD_X32_1       (0x2U << DDRCTRL_INIT1_PRE_OCD_X32_Pos)       /*!< 0x00000002 */
#define DDRCTRL_INIT1_PRE_OCD_X32_2       (0x4U << DDRCTRL_INIT1_PRE_OCD_X32_Pos)       /*!< 0x00000004 */
#define DDRCTRL_INIT1_PRE_OCD_X32_3       (0x8U << DDRCTRL_INIT1_PRE_OCD_X32_Pos)       /*!< 0x00000008 */
#define DDRCTRL_INIT1_DRAM_RSTN_X1024_Pos (16U)
#define DDRCTRL_INIT1_DRAM_RSTN_X1024_Msk (0x1FFU << DDRCTRL_INIT1_DRAM_RSTN_X1024_Pos) /*!< 0x01FF0000 */
#define DDRCTRL_INIT1_DRAM_RSTN_X1024     DDRCTRL_INIT1_DRAM_RSTN_X1024_Msk             /*!< Number of cycles to assert SDRAM reset signal during init sequence. */
#define DDRCTRL_INIT1_DRAM_RSTN_X1024_0   (0x1U << DDRCTRL_INIT1_DRAM_RSTN_X1024_Pos)   /*!< 0x00010000 */
#define DDRCTRL_INIT1_DRAM_RSTN_X1024_1   (0x2U << DDRCTRL_INIT1_DRAM_RSTN_X1024_Pos)   /*!< 0x00020000 */
#define DDRCTRL_INIT1_DRAM_RSTN_X1024_2   (0x4U << DDRCTRL_INIT1_DRAM_RSTN_X1024_Pos)   /*!< 0x00040000 */
#define DDRCTRL_INIT1_DRAM_RSTN_X1024_3   (0x8U << DDRCTRL_INIT1_DRAM_RSTN_X1024_Pos)   /*!< 0x00080000 */
#define DDRCTRL_INIT1_DRAM_RSTN_X1024_4   (0x10U << DDRCTRL_INIT1_DRAM_RSTN_X1024_Pos)  /*!< 0x00100000 */
#define DDRCTRL_INIT1_DRAM_RSTN_X1024_5   (0x20U << DDRCTRL_INIT1_DRAM_RSTN_X1024_Pos)  /*!< 0x00200000 */
#define DDRCTRL_INIT1_DRAM_RSTN_X1024_6   (0x40U << DDRCTRL_INIT1_DRAM_RSTN_X1024_Pos)  /*!< 0x00400000 */
#define DDRCTRL_INIT1_DRAM_RSTN_X1024_7   (0x80U << DDRCTRL_INIT1_DRAM_RSTN_X1024_Pos)  /*!< 0x00800000 */
#define DDRCTRL_INIT1_DRAM_RSTN_X1024_8   (0x100U << DDRCTRL_INIT1_DRAM_RSTN_X1024_Pos) /*!< 0x01000000 */

/****************  Bit definition for DDRCTRL_INIT2 register  *****************/
#define DDRCTRL_INIT2_MIN_STABLE_CLOCK_X1_Pos  (0U)
#define DDRCTRL_INIT2_MIN_STABLE_CLOCK_X1_Msk  (0xFU << DDRCTRL_INIT2_MIN_STABLE_CLOCK_X1_Pos)   /*!< 0x0000000F */
#define DDRCTRL_INIT2_MIN_STABLE_CLOCK_X1      DDRCTRL_INIT2_MIN_STABLE_CLOCK_X1_Msk             /*!< Time to wait after the first CKE high, tINIT2. Present only in designs configured to support LPDDR2/LPDDR3. */
#define DDRCTRL_INIT2_MIN_STABLE_CLOCK_X1_0    (0x1U << DDRCTRL_INIT2_MIN_STABLE_CLOCK_X1_Pos)   /*!< 0x00000001 */
#define DDRCTRL_INIT2_MIN_STABLE_CLOCK_X1_1    (0x2U << DDRCTRL_INIT2_MIN_STABLE_CLOCK_X1_Pos)   /*!< 0x00000002 */
#define DDRCTRL_INIT2_MIN_STABLE_CLOCK_X1_2    (0x4U << DDRCTRL_INIT2_MIN_STABLE_CLOCK_X1_Pos)   /*!< 0x00000004 */
#define DDRCTRL_INIT2_MIN_STABLE_CLOCK_X1_3    (0x8U << DDRCTRL_INIT2_MIN_STABLE_CLOCK_X1_Pos)   /*!< 0x00000008 */
#define DDRCTRL_INIT2_IDLE_AFTER_RESET_X32_Pos (8U)
#define DDRCTRL_INIT2_IDLE_AFTER_RESET_X32_Msk (0xFFU << DDRCTRL_INIT2_IDLE_AFTER_RESET_X32_Pos) /*!< 0x0000FF00 */
#define DDRCTRL_INIT2_IDLE_AFTER_RESET_X32     DDRCTRL_INIT2_IDLE_AFTER_RESET_X32_Msk            /*!< Idle time after the reset command, tINIT4. Present only in designs configured to support LPDDR2. */
#define DDRCTRL_INIT2_IDLE_AFTER_RESET_X32_0   (0x1U << DDRCTRL_INIT2_IDLE_AFTER_RESET_X32_Pos)  /*!< 0x00000100 */
#define DDRCTRL_INIT2_IDLE_AFTER_RESET_X32_1   (0x2U << DDRCTRL_INIT2_IDLE_AFTER_RESET_X32_Pos)  /*!< 0x00000200 */
#define DDRCTRL_INIT2_IDLE_AFTER_RESET_X32_2   (0x4U << DDRCTRL_INIT2_IDLE_AFTER_RESET_X32_Pos)  /*!< 0x00000400 */
#define DDRCTRL_INIT2_IDLE_AFTER_RESET_X32_3   (0x8U << DDRCTRL_INIT2_IDLE_AFTER_RESET_X32_Pos)  /*!< 0x00000800 */
#define DDRCTRL_INIT2_IDLE_AFTER_RESET_X32_4   (0x10U << DDRCTRL_INIT2_IDLE_AFTER_RESET_X32_Pos) /*!< 0x00001000 */
#define DDRCTRL_INIT2_IDLE_AFTER_RESET_X32_5   (0x20U << DDRCTRL_INIT2_IDLE_AFTER_RESET_X32_Pos) /*!< 0x00002000 */
#define DDRCTRL_INIT2_IDLE_AFTER_RESET_X32_6   (0x40U << DDRCTRL_INIT2_IDLE_AFTER_RESET_X32_Pos) /*!< 0x00004000 */
#define DDRCTRL_INIT2_IDLE_AFTER_RESET_X32_7   (0x80U << DDRCTRL_INIT2_IDLE_AFTER_RESET_X32_Pos) /*!< 0x00008000 */

/****************  Bit definition for DDRCTRL_INIT3 register  *****************/
#define DDRCTRL_INIT3_EMR_Pos (0U)
#define DDRCTRL_INIT3_EMR_Msk (0xFFFFU << DDRCTRL_INIT3_EMR_Pos) /*!< 0x0000FFFF */
#define DDRCTRL_INIT3_EMR     DDRCTRL_INIT3_EMR_Msk              /*!< DDR2: Value to write to EMR register. Bits 9:7 are for OCD and the setting in this register is ignored. The DDRCTRL sets those bits appropriately. */
#define DDRCTRL_INIT3_EMR_0   (0x1U << DDRCTRL_INIT3_EMR_Pos)    /*!< 0x00000001 */
#define DDRCTRL_INIT3_EMR_1   (0x2U << DDRCTRL_INIT3_EMR_Pos)    /*!< 0x00000002 */
#define DDRCTRL_INIT3_EMR_2   (0x4U << DDRCTRL_INIT3_EMR_Pos)    /*!< 0x00000004 */
#define DDRCTRL_INIT3_EMR_3   (0x8U << DDRCTRL_INIT3_EMR_Pos)    /*!< 0x00000008 */
#define DDRCTRL_INIT3_EMR_4   (0x10U << DDRCTRL_INIT3_EMR_Pos)   /*!< 0x00000010 */
#define DDRCTRL_INIT3_EMR_5   (0x20U << DDRCTRL_INIT3_EMR_Pos)   /*!< 0x00000020 */
#define DDRCTRL_INIT3_EMR_6   (0x40U << DDRCTRL_INIT3_EMR_Pos)   /*!< 0x00000040 */
#define DDRCTRL_INIT3_EMR_7   (0x80U << DDRCTRL_INIT3_EMR_Pos)   /*!< 0x00000080 */
#define DDRCTRL_INIT3_EMR_8   (0x100U << DDRCTRL_INIT3_EMR_Pos)  /*!< 0x00000100 */
#define DDRCTRL_INIT3_EMR_9   (0x200U << DDRCTRL_INIT3_EMR_Pos)  /*!< 0x00000200 */
#define DDRCTRL_INIT3_EMR_10  (0x400U << DDRCTRL_INIT3_EMR_Pos)  /*!< 0x00000400 */
#define DDRCTRL_INIT3_EMR_11  (0x800U << DDRCTRL_INIT3_EMR_Pos)  /*!< 0x00000800 */
#define DDRCTRL_INIT3_EMR_12  (0x1000U << DDRCTRL_INIT3_EMR_Pos) /*!< 0x00001000 */
#define DDRCTRL_INIT3_EMR_13  (0x2000U << DDRCTRL_INIT3_EMR_Pos) /*!< 0x00002000 */
#define DDRCTRL_INIT3_EMR_14  (0x4000U << DDRCTRL_INIT3_EMR_Pos) /*!< 0x00004000 */
#define DDRCTRL_INIT3_EMR_15  (0x8000U << DDRCTRL_INIT3_EMR_Pos) /*!< 0x00008000 */
#define DDRCTRL_INIT3_MR_Pos  (16U)
#define DDRCTRL_INIT3_MR_Msk  (0xFFFFU << DDRCTRL_INIT3_MR_Pos)  /*!< 0xFFFF0000 */
#define DDRCTRL_INIT3_MR      DDRCTRL_INIT3_MR_Msk               /*!< DDR2: Value to write to MR register. Bit 8 is for DLL and the setting here is ignored. The DDRCTRL sets this bit appropriately. */
#define DDRCTRL_INIT3_MR_0    (0x1U << DDRCTRL_INIT3_MR_Pos)     /*!< 0x00010000 */
#define DDRCTRL_INIT3_MR_1    (0x2U << DDRCTRL_INIT3_MR_Pos)     /*!< 0x00020000 */
#define DDRCTRL_INIT3_MR_2    (0x4U << DDRCTRL_INIT3_MR_Pos)     /*!< 0x00040000 */
#define DDRCTRL_INIT3_MR_3    (0x8U << DDRCTRL_INIT3_MR_Pos)     /*!< 0x00080000 */
#define DDRCTRL_INIT3_MR_4    (0x10U << DDRCTRL_INIT3_MR_Pos)    /*!< 0x00100000 */
#define DDRCTRL_INIT3_MR_5    (0x20U << DDRCTRL_INIT3_MR_Pos)    /*!< 0x00200000 */
#define DDRCTRL_INIT3_MR_6    (0x40U << DDRCTRL_INIT3_MR_Pos)    /*!< 0x00400000 */
#define DDRCTRL_INIT3_MR_7    (0x80U << DDRCTRL_INIT3_MR_Pos)    /*!< 0x00800000 */
#define DDRCTRL_INIT3_MR_8    (0x100U << DDRCTRL_INIT3_MR_Pos)   /*!< 0x01000000 */
#define DDRCTRL_INIT3_MR_9    (0x200U << DDRCTRL_INIT3_MR_Pos)   /*!< 0x02000000 */
#define DDRCTRL_INIT3_MR_10   (0x400U << DDRCTRL_INIT3_MR_Pos)   /*!< 0x04000000 */
#define DDRCTRL_INIT3_MR_11   (0x800U << DDRCTRL_INIT3_MR_Pos)   /*!< 0x08000000 */
#define DDRCTRL_INIT3_MR_12   (0x1000U << DDRCTRL_INIT3_MR_Pos)  /*!< 0x10000000 */
#define DDRCTRL_INIT3_MR_13   (0x2000U << DDRCTRL_INIT3_MR_Pos)  /*!< 0x20000000 */
#define DDRCTRL_INIT3_MR_14   (0x4000U << DDRCTRL_INIT3_MR_Pos)  /*!< 0x40000000 */
#define DDRCTRL_INIT3_MR_15   (0x8000U << DDRCTRL_INIT3_MR_Pos)  /*!< 0x80000000 */

/****************  Bit definition for DDRCTRL_INIT4 register  *****************/
#define DDRCTRL_INIT4_EMR3_Pos (0U)
#define DDRCTRL_INIT4_EMR3_Msk (0xFFFFU << DDRCTRL_INIT4_EMR3_Pos) /*!< 0x0000FFFF */
#define DDRCTRL_INIT4_EMR3     DDRCTRL_INIT4_EMR3_Msk              /*!< DDR2: Value to write to EMR3 register. */
#define DDRCTRL_INIT4_EMR3_0   (0x1U << DDRCTRL_INIT4_EMR3_Pos)    /*!< 0x00000001 */
#define DDRCTRL_INIT4_EMR3_1   (0x2U << DDRCTRL_INIT4_EMR3_Pos)    /*!< 0x00000002 */
#define DDRCTRL_INIT4_EMR3_2   (0x4U << DDRCTRL_INIT4_EMR3_Pos)    /*!< 0x00000004 */
#define DDRCTRL_INIT4_EMR3_3   (0x8U << DDRCTRL_INIT4_EMR3_Pos)    /*!< 0x00000008 */
#define DDRCTRL_INIT4_EMR3_4   (0x10U << DDRCTRL_INIT4_EMR3_Pos)   /*!< 0x00000010 */
#define DDRCTRL_INIT4_EMR3_5   (0x20U << DDRCTRL_INIT4_EMR3_Pos)   /*!< 0x00000020 */
#define DDRCTRL_INIT4_EMR3_6   (0x40U << DDRCTRL_INIT4_EMR3_Pos)   /*!< 0x00000040 */
#define DDRCTRL_INIT4_EMR3_7   (0x80U << DDRCTRL_INIT4_EMR3_Pos)   /*!< 0x00000080 */
#define DDRCTRL_INIT4_EMR3_8   (0x100U << DDRCTRL_INIT4_EMR3_Pos)  /*!< 0x00000100 */
#define DDRCTRL_INIT4_EMR3_9   (0x200U << DDRCTRL_INIT4_EMR3_Pos)  /*!< 0x00000200 */
#define DDRCTRL_INIT4_EMR3_10  (0x400U << DDRCTRL_INIT4_EMR3_Pos)  /*!< 0x00000400 */
#define DDRCTRL_INIT4_EMR3_11  (0x800U << DDRCTRL_INIT4_EMR3_Pos)  /*!< 0x00000800 */
#define DDRCTRL_INIT4_EMR3_12  (0x1000U << DDRCTRL_INIT4_EMR3_Pos) /*!< 0x00001000 */
#define DDRCTRL_INIT4_EMR3_13  (0x2000U << DDRCTRL_INIT4_EMR3_Pos) /*!< 0x00002000 */
#define DDRCTRL_INIT4_EMR3_14  (0x4000U << DDRCTRL_INIT4_EMR3_Pos) /*!< 0x00004000 */
#define DDRCTRL_INIT4_EMR3_15  (0x8000U << DDRCTRL_INIT4_EMR3_Pos) /*!< 0x00008000 */
#define DDRCTRL_INIT4_EMR2_Pos (16U)
#define DDRCTRL_INIT4_EMR2_Msk (0xFFFFU << DDRCTRL_INIT4_EMR2_Pos) /*!< 0xFFFF0000 */
#define DDRCTRL_INIT4_EMR2     DDRCTRL_INIT4_EMR2_Msk              /*!< DDR2: Value to write to EMR2 register. */
#define DDRCTRL_INIT4_EMR2_0   (0x1U << DDRCTRL_INIT4_EMR2_Pos)    /*!< 0x00010000 */
#define DDRCTRL_INIT4_EMR2_1   (0x2U << DDRCTRL_INIT4_EMR2_Pos)    /*!< 0x00020000 */
#define DDRCTRL_INIT4_EMR2_2   (0x4U << DDRCTRL_INIT4_EMR2_Pos)    /*!< 0x00040000 */
#define DDRCTRL_INIT4_EMR2_3   (0x8U << DDRCTRL_INIT4_EMR2_Pos)    /*!< 0x00080000 */
#define DDRCTRL_INIT4_EMR2_4   (0x10U << DDRCTRL_INIT4_EMR2_Pos)   /*!< 0x00100000 */
#define DDRCTRL_INIT4_EMR2_5   (0x20U << DDRCTRL_INIT4_EMR2_Pos)   /*!< 0x00200000 */
#define DDRCTRL_INIT4_EMR2_6   (0x40U << DDRCTRL_INIT4_EMR2_Pos)   /*!< 0x00400000 */
#define DDRCTRL_INIT4_EMR2_7   (0x80U << DDRCTRL_INIT4_EMR2_Pos)   /*!< 0x00800000 */
#define DDRCTRL_INIT4_EMR2_8   (0x100U << DDRCTRL_INIT4_EMR2_Pos)  /*!< 0x01000000 */
#define DDRCTRL_INIT4_EMR2_9   (0x200U << DDRCTRL_INIT4_EMR2_Pos)  /*!< 0x02000000 */
#define DDRCTRL_INIT4_EMR2_10  (0x400U << DDRCTRL_INIT4_EMR2_Pos)  /*!< 0x04000000 */
#define DDRCTRL_INIT4_EMR2_11  (0x800U << DDRCTRL_INIT4_EMR2_Pos)  /*!< 0x08000000 */
#define DDRCTRL_INIT4_EMR2_12  (0x1000U << DDRCTRL_INIT4_EMR2_Pos) /*!< 0x10000000 */
#define DDRCTRL_INIT4_EMR2_13  (0x2000U << DDRCTRL_INIT4_EMR2_Pos) /*!< 0x20000000 */
#define DDRCTRL_INIT4_EMR2_14  (0x4000U << DDRCTRL_INIT4_EMR2_Pos) /*!< 0x40000000 */
#define DDRCTRL_INIT4_EMR2_15  (0x8000U << DDRCTRL_INIT4_EMR2_Pos) /*!< 0x80000000 */

/****************  Bit definition for DDRCTRL_INIT5 register  *****************/
#define DDRCTRL_INIT5_MAX_AUTO_INIT_X1024_Pos (0U)
#define DDRCTRL_INIT5_MAX_AUTO_INIT_X1024_Msk (0x3FFU << DDRCTRL_INIT5_MAX_AUTO_INIT_X1024_Pos) /*!< 0x000003FF */
#define DDRCTRL_INIT5_MAX_AUTO_INIT_X1024     DDRCTRL_INIT5_MAX_AUTO_INIT_X1024_Msk             /*!< Maximum duration of the auto initialization, tINIT5. Present only in designs configured to support LPDDR2/LPDDR3. */
#define DDRCTRL_INIT5_MAX_AUTO_INIT_X1024_0   (0x1U << DDRCTRL_INIT5_MAX_AUTO_INIT_X1024_Pos)   /*!< 0x00000001 */
#define DDRCTRL_INIT5_MAX_AUTO_INIT_X1024_1   (0x2U << DDRCTRL_INIT5_MAX_AUTO_INIT_X1024_Pos)   /*!< 0x00000002 */
#define DDRCTRL_INIT5_MAX_AUTO_INIT_X1024_2   (0x4U << DDRCTRL_INIT5_MAX_AUTO_INIT_X1024_Pos)   /*!< 0x00000004 */
#define DDRCTRL_INIT5_MAX_AUTO_INIT_X1024_3   (0x8U << DDRCTRL_INIT5_MAX_AUTO_INIT_X1024_Pos)   /*!< 0x00000008 */
#define DDRCTRL_INIT5_MAX_AUTO_INIT_X1024_4   (0x10U << DDRCTRL_INIT5_MAX_AUTO_INIT_X1024_Pos)  /*!< 0x00000010 */
#define DDRCTRL_INIT5_MAX_AUTO_INIT_X1024_5   (0x20U << DDRCTRL_INIT5_MAX_AUTO_INIT_X1024_Pos)  /*!< 0x00000020 */
#define DDRCTRL_INIT5_MAX_AUTO_INIT_X1024_6   (0x40U << DDRCTRL_INIT5_MAX_AUTO_INIT_X1024_Pos)  /*!< 0x00000040 */
#define DDRCTRL_INIT5_MAX_AUTO_INIT_X1024_7   (0x80U << DDRCTRL_INIT5_MAX_AUTO_INIT_X1024_Pos)  /*!< 0x00000080 */
#define DDRCTRL_INIT5_MAX_AUTO_INIT_X1024_8   (0x100U << DDRCTRL_INIT5_MAX_AUTO_INIT_X1024_Pos) /*!< 0x00000100 */
#define DDRCTRL_INIT5_MAX_AUTO_INIT_X1024_9   (0x200U << DDRCTRL_INIT5_MAX_AUTO_INIT_X1024_Pos) /*!< 0x00000200 */
#define DDRCTRL_INIT5_DEV_ZQINIT_X32_Pos      (16U)
#define DDRCTRL_INIT5_DEV_ZQINIT_X32_Msk      (0xFFU << DDRCTRL_INIT5_DEV_ZQINIT_X32_Pos)       /*!< 0x00FF0000 */
#define DDRCTRL_INIT5_DEV_ZQINIT_X32          DDRCTRL_INIT5_DEV_ZQINIT_X32_Msk                  /*!< ZQ initial calibration, tZQINIT. Present only in designs configured to support DDR3 or DDR4 or LPDDR2/LPDDR3. */
#define DDRCTRL_INIT5_DEV_ZQINIT_X32_0        (0x1U << DDRCTRL_INIT5_DEV_ZQINIT_X32_Pos)        /*!< 0x00010000 */
#define DDRCTRL_INIT5_DEV_ZQINIT_X32_1        (0x2U << DDRCTRL_INIT5_DEV_ZQINIT_X32_Pos)        /*!< 0x00020000 */
#define DDRCTRL_INIT5_DEV_ZQINIT_X32_2        (0x4U << DDRCTRL_INIT5_DEV_ZQINIT_X32_Pos)        /*!< 0x00040000 */
#define DDRCTRL_INIT5_DEV_ZQINIT_X32_3        (0x8U << DDRCTRL_INIT5_DEV_ZQINIT_X32_Pos)        /*!< 0x00080000 */
#define DDRCTRL_INIT5_DEV_ZQINIT_X32_4        (0x10U << DDRCTRL_INIT5_DEV_ZQINIT_X32_Pos)       /*!< 0x00100000 */
#define DDRCTRL_INIT5_DEV_ZQINIT_X32_5        (0x20U << DDRCTRL_INIT5_DEV_ZQINIT_X32_Pos)       /*!< 0x00200000 */
#define DDRCTRL_INIT5_DEV_ZQINIT_X32_6        (0x40U << DDRCTRL_INIT5_DEV_ZQINIT_X32_Pos)       /*!< 0x00400000 */
#define DDRCTRL_INIT5_DEV_ZQINIT_X32_7        (0x80U << DDRCTRL_INIT5_DEV_ZQINIT_X32_Pos)       /*!< 0x00800000 */

/***************  Bit definition for DDRCTRL_DIMMCTL register  ****************/
#define DDRCTRL_DIMMCTL_DIMM_STAGGER_CS_EN_Pos (0U)
#define DDRCTRL_DIMMCTL_DIMM_STAGGER_CS_EN_Msk (0x1U << DDRCTRL_DIMMCTL_DIMM_STAGGER_CS_EN_Pos) /*!< 0x00000001 */
#define DDRCTRL_DIMMCTL_DIMM_STAGGER_CS_EN     DDRCTRL_DIMMCTL_DIMM_STAGGER_CS_EN_Msk           /*!< Staggering enable for multi-rank accesses (for multi-rank UDIMM, RDIMM and LRDIMM implementations only). This is not supported for mDDR, LPDDR2, LPDDR3 or LPDDR4 SDRAMs. */
#define DDRCTRL_DIMMCTL_DIMM_ADDR_MIRR_EN_Pos  (1U)
#define DDRCTRL_DIMMCTL_DIMM_ADDR_MIRR_EN_Msk  (0x1U << DDRCTRL_DIMMCTL_DIMM_ADDR_MIRR_EN_Pos)  /*!< 0x00000002 */
#define DDRCTRL_DIMMCTL_DIMM_ADDR_MIRR_EN      DDRCTRL_DIMMCTL_DIMM_ADDR_MIRR_EN_Msk            /*!< Address Mirroring Enable (for multi-rank UDIMM implementations and multi-rank DDR4 RDIMM/LRDIMM implementations). */

/***************  Bit definition for DDRCTRL_DRAMTMG0 register  ***************/
#define DDRCTRL_DRAMTMG0_T_RAS_MIN_Pos (0U)
#define DDRCTRL_DRAMTMG0_T_RAS_MIN_Msk (0x3FU << DDRCTRL_DRAMTMG0_T_RAS_MIN_Pos) /*!< 0x0000003F */
#define DDRCTRL_DRAMTMG0_T_RAS_MIN     DDRCTRL_DRAMTMG0_T_RAS_MIN_Msk            /*!< tRAS(min): Minimum time between activate and precharge to the same bank. */
#define DDRCTRL_DRAMTMG0_T_RAS_MIN_0   (0x1U << DDRCTRL_DRAMTMG0_T_RAS_MIN_Pos)  /*!< 0x00000001 */
#define DDRCTRL_DRAMTMG0_T_RAS_MIN_1   (0x2U << DDRCTRL_DRAMTMG0_T_RAS_MIN_Pos)  /*!< 0x00000002 */
#define DDRCTRL_DRAMTMG0_T_RAS_MIN_2   (0x4U << DDRCTRL_DRAMTMG0_T_RAS_MIN_Pos)  /*!< 0x00000004 */
#define DDRCTRL_DRAMTMG0_T_RAS_MIN_3   (0x8U << DDRCTRL_DRAMTMG0_T_RAS_MIN_Pos)  /*!< 0x00000008 */
#define DDRCTRL_DRAMTMG0_T_RAS_MIN_4   (0x10U << DDRCTRL_DRAMTMG0_T_RAS_MIN_Pos) /*!< 0x00000010 */
#define DDRCTRL_DRAMTMG0_T_RAS_MIN_5   (0x20U << DDRCTRL_DRAMTMG0_T_RAS_MIN_Pos) /*!< 0x00000020 */
#define DDRCTRL_DRAMTMG0_T_RAS_MAX_Pos (8U)
#define DDRCTRL_DRAMTMG0_T_RAS_MAX_Msk (0x7FU << DDRCTRL_DRAMTMG0_T_RAS_MAX_Pos) /*!< 0x00007F00 */
#define DDRCTRL_DRAMTMG0_T_RAS_MAX     DDRCTRL_DRAMTMG0_T_RAS_MAX_Msk            /*!< tRAS(max): Maximum time between activate and precharge to same bank. This is the maximum time that a page can be kept open */
#define DDRCTRL_DRAMTMG0_T_RAS_MAX_0   (0x1U << DDRCTRL_DRAMTMG0_T_RAS_MAX_Pos)  /*!< 0x00000100 */
#define DDRCTRL_DRAMTMG0_T_RAS_MAX_1   (0x2U << DDRCTRL_DRAMTMG0_T_RAS_MAX_Pos)  /*!< 0x00000200 */
#define DDRCTRL_DRAMTMG0_T_RAS_MAX_2   (0x4U << DDRCTRL_DRAMTMG0_T_RAS_MAX_Pos)  /*!< 0x00000400 */
#define DDRCTRL_DRAMTMG0_T_RAS_MAX_3   (0x8U << DDRCTRL_DRAMTMG0_T_RAS_MAX_Pos)  /*!< 0x00000800 */
#define DDRCTRL_DRAMTMG0_T_RAS_MAX_4   (0x10U << DDRCTRL_DRAMTMG0_T_RAS_MAX_Pos) /*!< 0x00001000 */
#define DDRCTRL_DRAMTMG0_T_RAS_MAX_5   (0x20U << DDRCTRL_DRAMTMG0_T_RAS_MAX_Pos) /*!< 0x00002000 */
#define DDRCTRL_DRAMTMG0_T_RAS_MAX_6   (0x40U << DDRCTRL_DRAMTMG0_T_RAS_MAX_Pos) /*!< 0x00004000 */
#define DDRCTRL_DRAMTMG0_T_FAW_Pos     (16U)
#define DDRCTRL_DRAMTMG0_T_FAW_Msk     (0x3FU << DDRCTRL_DRAMTMG0_T_FAW_Pos)     /*!< 0x003F0000 */
#define DDRCTRL_DRAMTMG0_T_FAW         DDRCTRL_DRAMTMG0_T_FAW_Msk                /*!< tFAW Valid only when 8 or more banks(or banks x bank groups) are present. */
#define DDRCTRL_DRAMTMG0_T_FAW_0       (0x1U << DDRCTRL_DRAMTMG0_T_FAW_Pos)      /*!< 0x00010000 */
#define DDRCTRL_DRAMTMG0_T_FAW_1       (0x2U << DDRCTRL_DRAMTMG0_T_FAW_Pos)      /*!< 0x00020000 */
#define DDRCTRL_DRAMTMG0_T_FAW_2       (0x4U << DDRCTRL_DRAMTMG0_T_FAW_Pos)      /*!< 0x00040000 */
#define DDRCTRL_DRAMTMG0_T_FAW_3       (0x8U << DDRCTRL_DRAMTMG0_T_FAW_Pos)      /*!< 0x00080000 */
#define DDRCTRL_DRAMTMG0_T_FAW_4       (0x10U << DDRCTRL_DRAMTMG0_T_FAW_Pos)     /*!< 0x00100000 */
#define DDRCTRL_DRAMTMG0_T_FAW_5       (0x20U << DDRCTRL_DRAMTMG0_T_FAW_Pos)     /*!< 0x00200000 */
#define DDRCTRL_DRAMTMG0_WR2PRE_Pos    (24U)
#define DDRCTRL_DRAMTMG0_WR2PRE_Msk    (0x7FU << DDRCTRL_DRAMTMG0_WR2PRE_Pos)    /*!< 0x7F000000 */
#define DDRCTRL_DRAMTMG0_WR2PRE        DDRCTRL_DRAMTMG0_WR2PRE_Msk               /*!< Minimum time between write and precharge to same bank. */
#define DDRCTRL_DRAMTMG0_WR2PRE_0      (0x1U << DDRCTRL_DRAMTMG0_WR2PRE_Pos)     /*!< 0x01000000 */
#define DDRCTRL_DRAMTMG0_WR2PRE_1      (0x2U << DDRCTRL_DRAMTMG0_WR2PRE_Pos)     /*!< 0x02000000 */
#define DDRCTRL_DRAMTMG0_WR2PRE_2      (0x4U << DDRCTRL_DRAMTMG0_WR2PRE_Pos)     /*!< 0x04000000 */
#define DDRCTRL_DRAMTMG0_WR2PRE_3      (0x8U << DDRCTRL_DRAMTMG0_WR2PRE_Pos)     /*!< 0x08000000 */
#define DDRCTRL_DRAMTMG0_WR2PRE_4      (0x10U << DDRCTRL_DRAMTMG0_WR2PRE_Pos)    /*!< 0x10000000 */
#define DDRCTRL_DRAMTMG0_WR2PRE_5      (0x20U << DDRCTRL_DRAMTMG0_WR2PRE_Pos)    /*!< 0x20000000 */
#define DDRCTRL_DRAMTMG0_WR2PRE_6      (0x40U << DDRCTRL_DRAMTMG0_WR2PRE_Pos)    /*!< 0x40000000 */

/***************  Bit definition for DDRCTRL_DRAMTMG1 register  ***************/
#define DDRCTRL_DRAMTMG1_T_RC_Pos   (0U)
#define DDRCTRL_DRAMTMG1_T_RC_Msk   (0x7FU << DDRCTRL_DRAMTMG1_T_RC_Pos)   /*!< 0x0000007F */
#define DDRCTRL_DRAMTMG1_T_RC       DDRCTRL_DRAMTMG1_T_RC_Msk              /*!< tRC: Minimum time between activates to same bank. */
#define DDRCTRL_DRAMTMG1_T_RC_0     (0x1U << DDRCTRL_DRAMTMG1_T_RC_Pos)    /*!< 0x00000001 */
#define DDRCTRL_DRAMTMG1_T_RC_1     (0x2U << DDRCTRL_DRAMTMG1_T_RC_Pos)    /*!< 0x00000002 */
#define DDRCTRL_DRAMTMG1_T_RC_2     (0x4U << DDRCTRL_DRAMTMG1_T_RC_Pos)    /*!< 0x00000004 */
#define DDRCTRL_DRAMTMG1_T_RC_3     (0x8U << DDRCTRL_DRAMTMG1_T_RC_Pos)    /*!< 0x00000008 */
#define DDRCTRL_DRAMTMG1_T_RC_4     (0x10U << DDRCTRL_DRAMTMG1_T_RC_Pos)   /*!< 0x00000010 */
#define DDRCTRL_DRAMTMG1_T_RC_5     (0x20U << DDRCTRL_DRAMTMG1_T_RC_Pos)   /*!< 0x00000020 */
#define DDRCTRL_DRAMTMG1_T_RC_6     (0x40U << DDRCTRL_DRAMTMG1_T_RC_Pos)   /*!< 0x00000040 */
#define DDRCTRL_DRAMTMG1_RD2PRE_Pos (8U)
#define DDRCTRL_DRAMTMG1_RD2PRE_Msk (0x3FU << DDRCTRL_DRAMTMG1_RD2PRE_Pos) /*!< 0x00003F00 */
#define DDRCTRL_DRAMTMG1_RD2PRE     DDRCTRL_DRAMTMG1_RD2PRE_Msk            /*!< tRTP: Minimum time from read to precharge of same bank. */
#define DDRCTRL_DRAMTMG1_RD2PRE_0   (0x1U << DDRCTRL_DRAMTMG1_RD2PRE_Pos)  /*!< 0x00000100 */
#define DDRCTRL_DRAMTMG1_RD2PRE_1   (0x2U << DDRCTRL_DRAMTMG1_RD2PRE_Pos)  /*!< 0x00000200 */
#define DDRCTRL_DRAMTMG1_RD2PRE_2   (0x4U << DDRCTRL_DRAMTMG1_RD2PRE_Pos)  /*!< 0x00000400 */
#define DDRCTRL_DRAMTMG1_RD2PRE_3   (0x8U << DDRCTRL_DRAMTMG1_RD2PRE_Pos)  /*!< 0x00000800 */
#define DDRCTRL_DRAMTMG1_RD2PRE_4   (0x10U << DDRCTRL_DRAMTMG1_RD2PRE_Pos) /*!< 0x00001000 */
#define DDRCTRL_DRAMTMG1_RD2PRE_5   (0x20U << DDRCTRL_DRAMTMG1_RD2PRE_Pos) /*!< 0x00002000 */
#define DDRCTRL_DRAMTMG1_T_XP_Pos   (16U)
#define DDRCTRL_DRAMTMG1_T_XP_Msk   (0x1FU << DDRCTRL_DRAMTMG1_T_XP_Pos)   /*!< 0x001F0000 */
#define DDRCTRL_DRAMTMG1_T_XP       DDRCTRL_DRAMTMG1_T_XP_Msk              /*!< tXP: Minimum time after power-down exit to any operation. For DDR3, this should be programmed to tXPDLL if slow powerdown exit is selected in MR0[12]. */
#define DDRCTRL_DRAMTMG1_T_XP_0     (0x1U << DDRCTRL_DRAMTMG1_T_XP_Pos)    /*!< 0x00010000 */
#define DDRCTRL_DRAMTMG1_T_XP_1     (0x2U << DDRCTRL_DRAMTMG1_T_XP_Pos)    /*!< 0x00020000 */
#define DDRCTRL_DRAMTMG1_T_XP_2     (0x4U << DDRCTRL_DRAMTMG1_T_XP_Pos)    /*!< 0x00040000 */
#define DDRCTRL_DRAMTMG1_T_XP_3     (0x8U << DDRCTRL_DRAMTMG1_T_XP_Pos)    /*!< 0x00080000 */
#define DDRCTRL_DRAMTMG1_T_XP_4     (0x10U << DDRCTRL_DRAMTMG1_T_XP_Pos)   /*!< 0x00100000 */

/***************  Bit definition for DDRCTRL_DRAMTMG2 register  ***************/
#define DDRCTRL_DRAMTMG2_WR2RD_Pos         (0U)
#define DDRCTRL_DRAMTMG2_WR2RD_Msk         (0x3FU << DDRCTRL_DRAMTMG2_WR2RD_Pos)         /*!< 0x0000003F */
#define DDRCTRL_DRAMTMG2_WR2RD             DDRCTRL_DRAMTMG2_WR2RD_Msk                    /*!< DDR4: CWL + PL + BL/2 + tWTR_L */
#define DDRCTRL_DRAMTMG2_WR2RD_0           (0x1U << DDRCTRL_DRAMTMG2_WR2RD_Pos)          /*!< 0x00000001 */
#define DDRCTRL_DRAMTMG2_WR2RD_1           (0x2U << DDRCTRL_DRAMTMG2_WR2RD_Pos)          /*!< 0x00000002 */
#define DDRCTRL_DRAMTMG2_WR2RD_2           (0x4U << DDRCTRL_DRAMTMG2_WR2RD_Pos)          /*!< 0x00000004 */
#define DDRCTRL_DRAMTMG2_WR2RD_3           (0x8U << DDRCTRL_DRAMTMG2_WR2RD_Pos)          /*!< 0x00000008 */
#define DDRCTRL_DRAMTMG2_WR2RD_4           (0x10U << DDRCTRL_DRAMTMG2_WR2RD_Pos)         /*!< 0x00000010 */
#define DDRCTRL_DRAMTMG2_WR2RD_5           (0x20U << DDRCTRL_DRAMTMG2_WR2RD_Pos)         /*!< 0x00000020 */
#define DDRCTRL_DRAMTMG2_RD2WR_Pos         (8U)
#define DDRCTRL_DRAMTMG2_RD2WR_Msk         (0x3FU << DDRCTRL_DRAMTMG2_RD2WR_Pos)         /*!< 0x00003F00 */
#define DDRCTRL_DRAMTMG2_RD2WR             DDRCTRL_DRAMTMG2_RD2WR_Msk                    /*!< DDR2/3/mDDR: RL + BL/2 + 2 - WL */
#define DDRCTRL_DRAMTMG2_RD2WR_0           (0x1U << DDRCTRL_DRAMTMG2_RD2WR_Pos)          /*!< 0x00000100 */
#define DDRCTRL_DRAMTMG2_RD2WR_1           (0x2U << DDRCTRL_DRAMTMG2_RD2WR_Pos)          /*!< 0x00000200 */
#define DDRCTRL_DRAMTMG2_RD2WR_2           (0x4U << DDRCTRL_DRAMTMG2_RD2WR_Pos)          /*!< 0x00000400 */
#define DDRCTRL_DRAMTMG2_RD2WR_3           (0x8U << DDRCTRL_DRAMTMG2_RD2WR_Pos)          /*!< 0x00000800 */
#define DDRCTRL_DRAMTMG2_RD2WR_4           (0x10U << DDRCTRL_DRAMTMG2_RD2WR_Pos)         /*!< 0x00001000 */
#define DDRCTRL_DRAMTMG2_RD2WR_5           (0x20U << DDRCTRL_DRAMTMG2_RD2WR_Pos)         /*!< 0x00002000 */
#define DDRCTRL_DRAMTMG2_READ_LATENCY_Pos  (16U)
#define DDRCTRL_DRAMTMG2_READ_LATENCY_Msk  (0x3FU << DDRCTRL_DRAMTMG2_READ_LATENCY_Pos)  /*!< 0x003F0000 */
#define DDRCTRL_DRAMTMG2_READ_LATENCY      DDRCTRL_DRAMTMG2_READ_LATENCY_Msk             /*!< Set to RL */
#define DDRCTRL_DRAMTMG2_READ_LATENCY_0    (0x1U << DDRCTRL_DRAMTMG2_READ_LATENCY_Pos)   /*!< 0x00010000 */
#define DDRCTRL_DRAMTMG2_READ_LATENCY_1    (0x2U << DDRCTRL_DRAMTMG2_READ_LATENCY_Pos)   /*!< 0x00020000 */
#define DDRCTRL_DRAMTMG2_READ_LATENCY_2    (0x4U << DDRCTRL_DRAMTMG2_READ_LATENCY_Pos)   /*!< 0x00040000 */
#define DDRCTRL_DRAMTMG2_READ_LATENCY_3    (0x8U << DDRCTRL_DRAMTMG2_READ_LATENCY_Pos)   /*!< 0x00080000 */
#define DDRCTRL_DRAMTMG2_READ_LATENCY_4    (0x10U << DDRCTRL_DRAMTMG2_READ_LATENCY_Pos)  /*!< 0x00100000 */
#define DDRCTRL_DRAMTMG2_READ_LATENCY_5    (0x20U << DDRCTRL_DRAMTMG2_READ_LATENCY_Pos)  /*!< 0x00200000 */
#define DDRCTRL_DRAMTMG2_WRITE_LATENCY_Pos (24U)
#define DDRCTRL_DRAMTMG2_WRITE_LATENCY_Msk (0x3FU << DDRCTRL_DRAMTMG2_WRITE_LATENCY_Pos) /*!< 0x3F000000 */
#define DDRCTRL_DRAMTMG2_WRITE_LATENCY     DDRCTRL_DRAMTMG2_WRITE_LATENCY_Msk            /*!< Set to WL */
#define DDRCTRL_DRAMTMG2_WRITE_LATENCY_0   (0x1U << DDRCTRL_DRAMTMG2_WRITE_LATENCY_Pos)  /*!< 0x01000000 */
#define DDRCTRL_DRAMTMG2_WRITE_LATENCY_1   (0x2U << DDRCTRL_DRAMTMG2_WRITE_LATENCY_Pos)  /*!< 0x02000000 */
#define DDRCTRL_DRAMTMG2_WRITE_LATENCY_2   (0x4U << DDRCTRL_DRAMTMG2_WRITE_LATENCY_Pos)  /*!< 0x04000000 */
#define DDRCTRL_DRAMTMG2_WRITE_LATENCY_3   (0x8U << DDRCTRL_DRAMTMG2_WRITE_LATENCY_Pos)  /*!< 0x08000000 */
#define DDRCTRL_DRAMTMG2_WRITE_LATENCY_4   (0x10U << DDRCTRL_DRAMTMG2_WRITE_LATENCY_Pos) /*!< 0x10000000 */
#define DDRCTRL_DRAMTMG2_WRITE_LATENCY_5   (0x20U << DDRCTRL_DRAMTMG2_WRITE_LATENCY_Pos) /*!< 0x20000000 */

/***************  Bit definition for DDRCTRL_DRAMTMG3 register  ***************/
#define DDRCTRL_DRAMTMG3_T_MOD_Pos (0U)
#define DDRCTRL_DRAMTMG3_T_MOD_Msk (0x3FFU << DDRCTRL_DRAMTMG3_T_MOD_Pos) /*!< 0x000003FF */
#define DDRCTRL_DRAMTMG3_T_MOD     DDRCTRL_DRAMTMG3_T_MOD_Msk             /*!< tMOD: Parameter used only in DDR3 and DDR4. Cycles between load mode command and following non-load mode command. */
#define DDRCTRL_DRAMTMG3_T_MOD_0   (0x1U << DDRCTRL_DRAMTMG3_T_MOD_Pos)   /*!< 0x00000001 */
#define DDRCTRL_DRAMTMG3_T_MOD_1   (0x2U << DDRCTRL_DRAMTMG3_T_MOD_Pos)   /*!< 0x00000002 */
#define DDRCTRL_DRAMTMG3_T_MOD_2   (0x4U << DDRCTRL_DRAMTMG3_T_MOD_Pos)   /*!< 0x00000004 */
#define DDRCTRL_DRAMTMG3_T_MOD_3   (0x8U << DDRCTRL_DRAMTMG3_T_MOD_Pos)   /*!< 0x00000008 */
#define DDRCTRL_DRAMTMG3_T_MOD_4   (0x10U << DDRCTRL_DRAMTMG3_T_MOD_Pos)  /*!< 0x00000010 */
#define DDRCTRL_DRAMTMG3_T_MOD_5   (0x20U << DDRCTRL_DRAMTMG3_T_MOD_Pos)  /*!< 0x00000020 */
#define DDRCTRL_DRAMTMG3_T_MOD_6   (0x40U << DDRCTRL_DRAMTMG3_T_MOD_Pos)  /*!< 0x00000040 */
#define DDRCTRL_DRAMTMG3_T_MOD_7   (0x80U << DDRCTRL_DRAMTMG3_T_MOD_Pos)  /*!< 0x00000080 */
#define DDRCTRL_DRAMTMG3_T_MOD_8   (0x100U << DDRCTRL_DRAMTMG3_T_MOD_Pos) /*!< 0x00000100 */
#define DDRCTRL_DRAMTMG3_T_MOD_9   (0x200U << DDRCTRL_DRAMTMG3_T_MOD_Pos) /*!< 0x00000200 */
#define DDRCTRL_DRAMTMG3_T_MRD_Pos (12U)
#define DDRCTRL_DRAMTMG3_T_MRD_Msk (0x3FU << DDRCTRL_DRAMTMG3_T_MRD_Pos)  /*!< 0x0003F000 */
#define DDRCTRL_DRAMTMG3_T_MRD     DDRCTRL_DRAMTMG3_T_MRD_Msk             /*!< tMRD: Cycles to wait after a mode register write or read. Depending on the connected SDRAM, tMRD represents: */
#define DDRCTRL_DRAMTMG3_T_MRD_0   (0x1U << DDRCTRL_DRAMTMG3_T_MRD_Pos)   /*!< 0x00001000 */
#define DDRCTRL_DRAMTMG3_T_MRD_1   (0x2U << DDRCTRL_DRAMTMG3_T_MRD_Pos)   /*!< 0x00002000 */
#define DDRCTRL_DRAMTMG3_T_MRD_2   (0x4U << DDRCTRL_DRAMTMG3_T_MRD_Pos)   /*!< 0x00004000 */
#define DDRCTRL_DRAMTMG3_T_MRD_3   (0x8U << DDRCTRL_DRAMTMG3_T_MRD_Pos)   /*!< 0x00008000 */
#define DDRCTRL_DRAMTMG3_T_MRD_4   (0x10U << DDRCTRL_DRAMTMG3_T_MRD_Pos)  /*!< 0x00010000 */
#define DDRCTRL_DRAMTMG3_T_MRD_5   (0x20U << DDRCTRL_DRAMTMG3_T_MRD_Pos)  /*!< 0x00020000 */
#define DDRCTRL_DRAMTMG3_T_MRW_Pos (20U)
#define DDRCTRL_DRAMTMG3_T_MRW_Msk (0x3FFU << DDRCTRL_DRAMTMG3_T_MRW_Pos) /*!< 0x3FF00000 */
#define DDRCTRL_DRAMTMG3_T_MRW     DDRCTRL_DRAMTMG3_T_MRW_Msk             /*!< Time to wait after a mode register write or read (MRW or MRR). */
#define DDRCTRL_DRAMTMG3_T_MRW_0   (0x1U << DDRCTRL_DRAMTMG3_T_MRW_Pos)   /*!< 0x00100000 */
#define DDRCTRL_DRAMTMG3_T_MRW_1   (0x2U << DDRCTRL_DRAMTMG3_T_MRW_Pos)   /*!< 0x00200000 */
#define DDRCTRL_DRAMTMG3_T_MRW_2   (0x4U << DDRCTRL_DRAMTMG3_T_MRW_Pos)   /*!< 0x00400000 */
#define DDRCTRL_DRAMTMG3_T_MRW_3   (0x8U << DDRCTRL_DRAMTMG3_T_MRW_Pos)   /*!< 0x00800000 */
#define DDRCTRL_DRAMTMG3_T_MRW_4   (0x10U << DDRCTRL_DRAMTMG3_T_MRW_Pos)  /*!< 0x01000000 */
#define DDRCTRL_DRAMTMG3_T_MRW_5   (0x20U << DDRCTRL_DRAMTMG3_T_MRW_Pos)  /*!< 0x02000000 */
#define DDRCTRL_DRAMTMG3_T_MRW_6   (0x40U << DDRCTRL_DRAMTMG3_T_MRW_Pos)  /*!< 0x04000000 */
#define DDRCTRL_DRAMTMG3_T_MRW_7   (0x80U << DDRCTRL_DRAMTMG3_T_MRW_Pos)  /*!< 0x08000000 */
#define DDRCTRL_DRAMTMG3_T_MRW_8   (0x100U << DDRCTRL_DRAMTMG3_T_MRW_Pos) /*!< 0x10000000 */
#define DDRCTRL_DRAMTMG3_T_MRW_9   (0x200U << DDRCTRL_DRAMTMG3_T_MRW_Pos) /*!< 0x20000000 */

/***************  Bit definition for DDRCTRL_DRAMTMG4 register  ***************/
#define DDRCTRL_DRAMTMG4_T_RP_Pos  (0U)
#define DDRCTRL_DRAMTMG4_T_RP_Msk  (0x1FU << DDRCTRL_DRAMTMG4_T_RP_Pos)  /*!< 0x0000001F */
#define DDRCTRL_DRAMTMG4_T_RP      DDRCTRL_DRAMTMG4_T_RP_Msk             /*!< tRP: Minimum time from precharge to activate of same bank. */
#define DDRCTRL_DRAMTMG4_T_RP_0    (0x1U << DDRCTRL_DRAMTMG4_T_RP_Pos)   /*!< 0x00000001 */
#define DDRCTRL_DRAMTMG4_T_RP_1    (0x2U << DDRCTRL_DRAMTMG4_T_RP_Pos)   /*!< 0x00000002 */
#define DDRCTRL_DRAMTMG4_T_RP_2    (0x4U << DDRCTRL_DRAMTMG4_T_RP_Pos)   /*!< 0x00000004 */
#define DDRCTRL_DRAMTMG4_T_RP_3    (0x8U << DDRCTRL_DRAMTMG4_T_RP_Pos)   /*!< 0x00000008 */
#define DDRCTRL_DRAMTMG4_T_RP_4    (0x10U << DDRCTRL_DRAMTMG4_T_RP_Pos)  /*!< 0x00000010 */
#define DDRCTRL_DRAMTMG4_T_RRD_Pos (8U)
#define DDRCTRL_DRAMTMG4_T_RRD_Msk (0xFU << DDRCTRL_DRAMTMG4_T_RRD_Pos)  /*!< 0x00000F00 */
#define DDRCTRL_DRAMTMG4_T_RRD     DDRCTRL_DRAMTMG4_T_RRD_Msk            /*!< DDR4: tRRD_L: Minimum time between activates from bank "a" to bank "b" for same bank group. */
#define DDRCTRL_DRAMTMG4_T_RRD_0   (0x1U << DDRCTRL_DRAMTMG4_T_RRD_Pos)  /*!< 0x00000100 */
#define DDRCTRL_DRAMTMG4_T_RRD_1   (0x2U << DDRCTRL_DRAMTMG4_T_RRD_Pos)  /*!< 0x00000200 */
#define DDRCTRL_DRAMTMG4_T_RRD_2   (0x4U << DDRCTRL_DRAMTMG4_T_RRD_Pos)  /*!< 0x00000400 */
#define DDRCTRL_DRAMTMG4_T_RRD_3   (0x8U << DDRCTRL_DRAMTMG4_T_RRD_Pos)  /*!< 0x00000800 */
#define DDRCTRL_DRAMTMG4_T_CCD_Pos (16U)
#define DDRCTRL_DRAMTMG4_T_CCD_Msk (0xFU << DDRCTRL_DRAMTMG4_T_CCD_Pos)  /*!< 0x000F0000 */
#define DDRCTRL_DRAMTMG4_T_CCD     DDRCTRL_DRAMTMG4_T_CCD_Msk            /*!< DDR4: tCCD_L: This is the minimum time between two reads or two writes for same bank group. */
#define DDRCTRL_DRAMTMG4_T_CCD_0   (0x1U << DDRCTRL_DRAMTMG4_T_CCD_Pos)  /*!< 0x00010000 */
#define DDRCTRL_DRAMTMG4_T_CCD_1   (0x2U << DDRCTRL_DRAMTMG4_T_CCD_Pos)  /*!< 0x00020000 */
#define DDRCTRL_DRAMTMG4_T_CCD_2   (0x4U << DDRCTRL_DRAMTMG4_T_CCD_Pos)  /*!< 0x00040000 */
#define DDRCTRL_DRAMTMG4_T_CCD_3   (0x8U << DDRCTRL_DRAMTMG4_T_CCD_Pos)  /*!< 0x00080000 */
#define DDRCTRL_DRAMTMG4_T_RCD_Pos (24U)
#define DDRCTRL_DRAMTMG4_T_RCD_Msk (0x1FU << DDRCTRL_DRAMTMG4_T_RCD_Pos) /*!< 0x1F000000 */
#define DDRCTRL_DRAMTMG4_T_RCD     DDRCTRL_DRAMTMG4_T_RCD_Msk            /*!< tRCD - tAL: Minimum time from activate to read or write command to same bank. */
#define DDRCTRL_DRAMTMG4_T_RCD_0   (0x1U << DDRCTRL_DRAMTMG4_T_RCD_Pos)  /*!< 0x01000000 */
#define DDRCTRL_DRAMTMG4_T_RCD_1   (0x2U << DDRCTRL_DRAMTMG4_T_RCD_Pos)  /*!< 0x02000000 */
#define DDRCTRL_DRAMTMG4_T_RCD_2   (0x4U << DDRCTRL_DRAMTMG4_T_RCD_Pos)  /*!< 0x04000000 */
#define DDRCTRL_DRAMTMG4_T_RCD_3   (0x8U << DDRCTRL_DRAMTMG4_T_RCD_Pos)  /*!< 0x08000000 */
#define DDRCTRL_DRAMTMG4_T_RCD_4   (0x10U << DDRCTRL_DRAMTMG4_T_RCD_Pos) /*!< 0x10000000 */

/***************  Bit definition for DDRCTRL_DRAMTMG5 register  ***************/
#define DDRCTRL_DRAMTMG5_T_CKE_Pos   (0U)
#define DDRCTRL_DRAMTMG5_T_CKE_Msk   (0x1FU << DDRCTRL_DRAMTMG5_T_CKE_Pos)   /*!< 0x0000001F */
#define DDRCTRL_DRAMTMG5_T_CKE       DDRCTRL_DRAMTMG5_T_CKE_Msk              /*!< Minimum number of cycles of CKE HIGH/LOW during power-down and self refresh. */
#define DDRCTRL_DRAMTMG5_T_CKE_0     (0x1U << DDRCTRL_DRAMTMG5_T_CKE_Pos)    /*!< 0x00000001 */
#define DDRCTRL_DRAMTMG5_T_CKE_1     (0x2U << DDRCTRL_DRAMTMG5_T_CKE_Pos)    /*!< 0x00000002 */
#define DDRCTRL_DRAMTMG5_T_CKE_2     (0x4U << DDRCTRL_DRAMTMG5_T_CKE_Pos)    /*!< 0x00000004 */
#define DDRCTRL_DRAMTMG5_T_CKE_3     (0x8U << DDRCTRL_DRAMTMG5_T_CKE_Pos)    /*!< 0x00000008 */
#define DDRCTRL_DRAMTMG5_T_CKE_4     (0x10U << DDRCTRL_DRAMTMG5_T_CKE_Pos)   /*!< 0x00000010 */
#define DDRCTRL_DRAMTMG5_T_CKESR_Pos (8U)
#define DDRCTRL_DRAMTMG5_T_CKESR_Msk (0x3FU << DDRCTRL_DRAMTMG5_T_CKESR_Pos) /*!< 0x00003F00 */
#define DDRCTRL_DRAMTMG5_T_CKESR     DDRCTRL_DRAMTMG5_T_CKESR_Msk            /*!< Minimum CKE low width for Self refresh or Self refresh power down entry to exit timing in memory clock cycles. */
#define DDRCTRL_DRAMTMG5_T_CKESR_0   (0x1U << DDRCTRL_DRAMTMG5_T_CKESR_Pos)  /*!< 0x00000100 */
#define DDRCTRL_DRAMTMG5_T_CKESR_1   (0x2U << DDRCTRL_DRAMTMG5_T_CKESR_Pos)  /*!< 0x00000200 */
#define DDRCTRL_DRAMTMG5_T_CKESR_2   (0x4U << DDRCTRL_DRAMTMG5_T_CKESR_Pos)  /*!< 0x00000400 */
#define DDRCTRL_DRAMTMG5_T_CKESR_3   (0x8U << DDRCTRL_DRAMTMG5_T_CKESR_Pos)  /*!< 0x00000800 */
#define DDRCTRL_DRAMTMG5_T_CKESR_4   (0x10U << DDRCTRL_DRAMTMG5_T_CKESR_Pos) /*!< 0x00001000 */
#define DDRCTRL_DRAMTMG5_T_CKESR_5   (0x20U << DDRCTRL_DRAMTMG5_T_CKESR_Pos) /*!< 0x00002000 */
#define DDRCTRL_DRAMTMG5_T_CKSRE_Pos (16U)
#define DDRCTRL_DRAMTMG5_T_CKSRE_Msk (0xFU << DDRCTRL_DRAMTMG5_T_CKSRE_Pos)  /*!< 0x000F0000 */
#define DDRCTRL_DRAMTMG5_T_CKSRE     DDRCTRL_DRAMTMG5_T_CKSRE_Msk            /*!< This is the time after Self Refresh Down Entry that CK is maintained as a valid clock. Specifies the clock disable delay after SRE. */
#define DDRCTRL_DRAMTMG5_T_CKSRE_0   (0x1U << DDRCTRL_DRAMTMG5_T_CKSRE_Pos)  /*!< 0x00010000 */
#define DDRCTRL_DRAMTMG5_T_CKSRE_1   (0x2U << DDRCTRL_DRAMTMG5_T_CKSRE_Pos)  /*!< 0x00020000 */
#define DDRCTRL_DRAMTMG5_T_CKSRE_2   (0x4U << DDRCTRL_DRAMTMG5_T_CKSRE_Pos)  /*!< 0x00040000 */
#define DDRCTRL_DRAMTMG5_T_CKSRE_3   (0x8U << DDRCTRL_DRAMTMG5_T_CKSRE_Pos)  /*!< 0x00080000 */
#define DDRCTRL_DRAMTMG5_T_CKSRX_Pos (24U)
#define DDRCTRL_DRAMTMG5_T_CKSRX_Msk (0xFU << DDRCTRL_DRAMTMG5_T_CKSRX_Pos)       /*!< 0x0F000000 */
#define DDRCTRL_DRAMTMG5_T_CKSRX     DDRCTRL_DRAMTMG5_T_CKSRX_Msk            /*!< This is the time before Self Refresh Exit that CK is maintained as a valid clock before issuing SRX. Specifies the clock stable time before SRX. */
#define DDRCTRL_DRAMTMG5_T_CKSRX_0   (0x1U << DDRCTRL_DRAMTMG5_T_CKSRX_Pos)  /*!< 0x01000000 */
#define DDRCTRL_DRAMTMG5_T_CKSRX_1   (0x2U << DDRCTRL_DRAMTMG5_T_CKSRX_Pos)  /*!< 0x02000000 */
#define DDRCTRL_DRAMTMG5_T_CKSRX_2   (0x4U << DDRCTRL_DRAMTMG5_T_CKSRX_Pos)  /*!< 0x04000000 */
#define DDRCTRL_DRAMTMG5_T_CKSRX_3   (0x8U << DDRCTRL_DRAMTMG5_T_CKSRX_Pos)  /*!< 0x08000000 */

/***************  Bit definition for DDRCTRL_DRAMTMG6 register  ***************/
#define DDRCTRL_DRAMTMG6_T_CKCSX_Pos  (0U)
#define DDRCTRL_DRAMTMG6_T_CKCSX_Msk  (0xFU << DDRCTRL_DRAMTMG6_T_CKCSX_Pos)  /*!< 0x0000000F */
#define DDRCTRL_DRAMTMG6_T_CKCSX      DDRCTRL_DRAMTMG6_T_CKCSX_Msk            /*!< This is the time before Clock Stop Exit that CK is maintained as a valid clock before issuing Clock Stop Exit. Specifies the clock stable time before next command after Clock Stop Exit. */
#define DDRCTRL_DRAMTMG6_T_CKCSX_0    (0x1U << DDRCTRL_DRAMTMG6_T_CKCSX_Pos)  /*!< 0x00000001 */
#define DDRCTRL_DRAMTMG6_T_CKCSX_1    (0x2U << DDRCTRL_DRAMTMG6_T_CKCSX_Pos)  /*!< 0x00000002 */
#define DDRCTRL_DRAMTMG6_T_CKCSX_2    (0x4U << DDRCTRL_DRAMTMG6_T_CKCSX_Pos)  /*!< 0x00000004 */
#define DDRCTRL_DRAMTMG6_T_CKCSX_3    (0x8U << DDRCTRL_DRAMTMG6_T_CKCSX_Pos)  /*!< 0x00000008 */
#define DDRCTRL_DRAMTMG6_T_CKDPDX_Pos (16U)
#define DDRCTRL_DRAMTMG6_T_CKDPDX_Msk (0xFU << DDRCTRL_DRAMTMG6_T_CKDPDX_Pos) /*!< 0x000F0000 */
#define DDRCTRL_DRAMTMG6_T_CKDPDX     DDRCTRL_DRAMTMG6_T_CKDPDX_Msk           /*!< This is the time before Deep Power Down Exit that CK is maintained as a valid clock before issuing DPDX. Specifies the clock stable time before DPDX. */
#define DDRCTRL_DRAMTMG6_T_CKDPDX_0   (0x1U << DDRCTRL_DRAMTMG6_T_CKDPDX_Pos) /*!< 0x00010000 */
#define DDRCTRL_DRAMTMG6_T_CKDPDX_1   (0x2U << DDRCTRL_DRAMTMG6_T_CKDPDX_Pos) /*!< 0x00020000 */
#define DDRCTRL_DRAMTMG6_T_CKDPDX_2   (0x4U << DDRCTRL_DRAMTMG6_T_CKDPDX_Pos) /*!< 0x00040000 */
#define DDRCTRL_DRAMTMG6_T_CKDPDX_3   (0x8U << DDRCTRL_DRAMTMG6_T_CKDPDX_Pos) /*!< 0x00080000 */
#define DDRCTRL_DRAMTMG6_T_CKDPDE_Pos (24U)
#define DDRCTRL_DRAMTMG6_T_CKDPDE_Msk (0xFU << DDRCTRL_DRAMTMG6_T_CKDPDE_Pos) /*!< 0x0F000000 */
#define DDRCTRL_DRAMTMG6_T_CKDPDE     DDRCTRL_DRAMTMG6_T_CKDPDE_Msk           /*!< This is the time after Deep Power Down Entry that CK is maintained as a valid clock. Specifies the clock disable delay after DPDE. */
#define DDRCTRL_DRAMTMG6_T_CKDPDE_0   (0x1U << DDRCTRL_DRAMTMG6_T_CKDPDE_Pos) /*!< 0x01000000 */
#define DDRCTRL_DRAMTMG6_T_CKDPDE_1   (0x2U << DDRCTRL_DRAMTMG6_T_CKDPDE_Pos) /*!< 0x02000000 */
#define DDRCTRL_DRAMTMG6_T_CKDPDE_2   (0x4U << DDRCTRL_DRAMTMG6_T_CKDPDE_Pos) /*!< 0x04000000 */
#define DDRCTRL_DRAMTMG6_T_CKDPDE_3   (0x8U << DDRCTRL_DRAMTMG6_T_CKDPDE_Pos) /*!< 0x08000000 */

/***************  Bit definition for DDRCTRL_DRAMTMG7 register  ***************/
#define DDRCTRL_DRAMTMG7_T_CKPDX_Pos (0U)
#define DDRCTRL_DRAMTMG7_T_CKPDX_Msk (0xFU << DDRCTRL_DRAMTMG7_T_CKPDX_Pos) /*!< 0x0000000F */
#define DDRCTRL_DRAMTMG7_T_CKPDX     DDRCTRL_DRAMTMG7_T_CKPDX_Msk           /*!< This is the time before Power Down Exit that CK is maintained as a valid clock before issuing PDX. Specifies the clock stable time before PDX. */
#define DDRCTRL_DRAMTMG7_T_CKPDX_0   (0x1U << DDRCTRL_DRAMTMG7_T_CKPDX_Pos) /*!< 0x00000001 */
#define DDRCTRL_DRAMTMG7_T_CKPDX_1   (0x2U << DDRCTRL_DRAMTMG7_T_CKPDX_Pos) /*!< 0x00000002 */
#define DDRCTRL_DRAMTMG7_T_CKPDX_2   (0x4U << DDRCTRL_DRAMTMG7_T_CKPDX_Pos) /*!< 0x00000004 */
#define DDRCTRL_DRAMTMG7_T_CKPDX_3   (0x8U << DDRCTRL_DRAMTMG7_T_CKPDX_Pos) /*!< 0x00000008 */
#define DDRCTRL_DRAMTMG7_T_CKPDE_Pos (8U)
#define DDRCTRL_DRAMTMG7_T_CKPDE_Msk (0xFU << DDRCTRL_DRAMTMG7_T_CKPDE_Pos) /*!< 0x00000F00 */
#define DDRCTRL_DRAMTMG7_T_CKPDE     DDRCTRL_DRAMTMG7_T_CKPDE_Msk           /*!< This is the time after Power Down Entry that CK is maintained as a valid clock. Specifies the clock disable delay after PDE. */
#define DDRCTRL_DRAMTMG7_T_CKPDE_0   (0x1U << DDRCTRL_DRAMTMG7_T_CKPDE_Pos) /*!< 0x00000100 */
#define DDRCTRL_DRAMTMG7_T_CKPDE_1   (0x2U << DDRCTRL_DRAMTMG7_T_CKPDE_Pos) /*!< 0x00000200 */
#define DDRCTRL_DRAMTMG7_T_CKPDE_2   (0x4U << DDRCTRL_DRAMTMG7_T_CKPDE_Pos) /*!< 0x00000400 */
#define DDRCTRL_DRAMTMG7_T_CKPDE_3   (0x8U << DDRCTRL_DRAMTMG7_T_CKPDE_Pos) /*!< 0x00000800 */

/***************  Bit definition for DDRCTRL_DRAMTMG8 register  ***************/
#define DDRCTRL_DRAMTMG8_T_XS_X32_Pos     (0U)
#define DDRCTRL_DRAMTMG8_T_XS_X32_Msk     (0x7FU << DDRCTRL_DRAMTMG8_T_XS_X32_Pos)     /*!< 0x0000007F */
#define DDRCTRL_DRAMTMG8_T_XS_X32         DDRCTRL_DRAMTMG8_T_XS_X32_Msk                /*!< tXS: Exit Self Refresh to commands not requiring a locked DLL. */
#define DDRCTRL_DRAMTMG8_T_XS_X32_0       (0x1U << DDRCTRL_DRAMTMG8_T_XS_X32_Pos)      /*!< 0x00000001 */
#define DDRCTRL_DRAMTMG8_T_XS_X32_1       (0x2U << DDRCTRL_DRAMTMG8_T_XS_X32_Pos)      /*!< 0x00000002 */
#define DDRCTRL_DRAMTMG8_T_XS_X32_2       (0x4U << DDRCTRL_DRAMTMG8_T_XS_X32_Pos)      /*!< 0x00000004 */
#define DDRCTRL_DRAMTMG8_T_XS_X32_3       (0x8U << DDRCTRL_DRAMTMG8_T_XS_X32_Pos)      /*!< 0x00000008 */
#define DDRCTRL_DRAMTMG8_T_XS_X32_4       (0x10U << DDRCTRL_DRAMTMG8_T_XS_X32_Pos)     /*!< 0x00000010 */
#define DDRCTRL_DRAMTMG8_T_XS_X32_5       (0x20U << DDRCTRL_DRAMTMG8_T_XS_X32_Pos)     /*!< 0x00000020 */
#define DDRCTRL_DRAMTMG8_T_XS_X32_6       (0x40U << DDRCTRL_DRAMTMG8_T_XS_X32_Pos)     /*!< 0x00000040 */
#define DDRCTRL_DRAMTMG8_T_XS_DLL_X32_Pos (8U)
#define DDRCTRL_DRAMTMG8_T_XS_DLL_X32_Msk (0x7FU << DDRCTRL_DRAMTMG8_T_XS_DLL_X32_Pos) /*!< 0x00007F00 */
#define DDRCTRL_DRAMTMG8_T_XS_DLL_X32     DDRCTRL_DRAMTMG8_T_XS_DLL_X32_Msk            /*!< tXSDLL: Exit Self Refresh to the commands requiring a locked DLL. */
#define DDRCTRL_DRAMTMG8_T_XS_DLL_X32_0   (0x1U << DDRCTRL_DRAMTMG8_T_XS_DLL_X32_Pos)  /*!< 0x00000100 */
#define DDRCTRL_DRAMTMG8_T_XS_DLL_X32_1   (0x2U << DDRCTRL_DRAMTMG8_T_XS_DLL_X32_Pos)  /*!< 0x00000200 */
#define DDRCTRL_DRAMTMG8_T_XS_DLL_X32_2   (0x4U << DDRCTRL_DRAMTMG8_T_XS_DLL_X32_Pos)  /*!< 0x00000400 */
#define DDRCTRL_DRAMTMG8_T_XS_DLL_X32_3   (0x8U << DDRCTRL_DRAMTMG8_T_XS_DLL_X32_Pos)  /*!< 0x00000800 */
#define DDRCTRL_DRAMTMG8_T_XS_DLL_X32_4   (0x10U << DDRCTRL_DRAMTMG8_T_XS_DLL_X32_Pos) /*!< 0x00001000 */
#define DDRCTRL_DRAMTMG8_T_XS_DLL_X32_5   (0x20U << DDRCTRL_DRAMTMG8_T_XS_DLL_X32_Pos) /*!< 0x00002000 */
#define DDRCTRL_DRAMTMG8_T_XS_DLL_X32_6   (0x40U << DDRCTRL_DRAMTMG8_T_XS_DLL_X32_Pos) /*!< 0x00004000 */

/**************  Bit definition for DDRCTRL_DRAMTMG14 register  ***************/
#define DDRCTRL_DRAMTMG14_T_XSR_Pos (0U)
#define DDRCTRL_DRAMTMG14_T_XSR_Msk (0xFFFU << DDRCTRL_DRAMTMG14_T_XSR_Pos) /*!< 0x00000FFF */
#define DDRCTRL_DRAMTMG14_T_XSR     DDRCTRL_DRAMTMG14_T_XSR_Msk             /*!< tXSR: Exit Self Refresh to any command. */
#define DDRCTRL_DRAMTMG14_T_XSR_0   (0x1U << DDRCTRL_DRAMTMG14_T_XSR_Pos)   /*!< 0x00000001 */
#define DDRCTRL_DRAMTMG14_T_XSR_1   (0x2U << DDRCTRL_DRAMTMG14_T_XSR_Pos)   /*!< 0x00000002 */
#define DDRCTRL_DRAMTMG14_T_XSR_2   (0x4U << DDRCTRL_DRAMTMG14_T_XSR_Pos)   /*!< 0x00000004 */
#define DDRCTRL_DRAMTMG14_T_XSR_3   (0x8U << DDRCTRL_DRAMTMG14_T_XSR_Pos)   /*!< 0x00000008 */
#define DDRCTRL_DRAMTMG14_T_XSR_4   (0x10U << DDRCTRL_DRAMTMG14_T_XSR_Pos)  /*!< 0x00000010 */
#define DDRCTRL_DRAMTMG14_T_XSR_5   (0x20U << DDRCTRL_DRAMTMG14_T_XSR_Pos)  /*!< 0x00000020 */
#define DDRCTRL_DRAMTMG14_T_XSR_6   (0x40U << DDRCTRL_DRAMTMG14_T_XSR_Pos)  /*!< 0x00000040 */
#define DDRCTRL_DRAMTMG14_T_XSR_7   (0x80U << DDRCTRL_DRAMTMG14_T_XSR_Pos)  /*!< 0x00000080 */
#define DDRCTRL_DRAMTMG14_T_XSR_8   (0x100U << DDRCTRL_DRAMTMG14_T_XSR_Pos) /*!< 0x00000100 */
#define DDRCTRL_DRAMTMG14_T_XSR_9   (0x200U << DDRCTRL_DRAMTMG14_T_XSR_Pos) /*!< 0x00000200 */
#define DDRCTRL_DRAMTMG14_T_XSR_10  (0x400U << DDRCTRL_DRAMTMG14_T_XSR_Pos) /*!< 0x00000400 */
#define DDRCTRL_DRAMTMG14_T_XSR_11  (0x800U << DDRCTRL_DRAMTMG14_T_XSR_Pos) /*!< 0x00000800 */

/**************  Bit definition for DDRCTRL_DRAMTMG15 register  ***************/
#define DDRCTRL_DRAMTMG15_T_STAB_X32_Pos       (0U)
#define DDRCTRL_DRAMTMG15_T_STAB_X32_Msk       (0xFFU << DDRCTRL_DRAMTMG15_T_STAB_X32_Pos)      /*!< 0x000000FF */
#define DDRCTRL_DRAMTMG15_T_STAB_X32           DDRCTRL_DRAMTMG15_T_STAB_X32_Msk                 /*!< tSTAB: Stabilization time. */
#define DDRCTRL_DRAMTMG15_T_STAB_X32_0         (0x1U << DDRCTRL_DRAMTMG15_T_STAB_X32_Pos)       /*!< 0x00000001 */
#define DDRCTRL_DRAMTMG15_T_STAB_X32_1         (0x2U << DDRCTRL_DRAMTMG15_T_STAB_X32_Pos)       /*!< 0x00000002 */
#define DDRCTRL_DRAMTMG15_T_STAB_X32_2         (0x4U << DDRCTRL_DRAMTMG15_T_STAB_X32_Pos)       /*!< 0x00000004 */
#define DDRCTRL_DRAMTMG15_T_STAB_X32_3         (0x8U << DDRCTRL_DRAMTMG15_T_STAB_X32_Pos)       /*!< 0x00000008 */
#define DDRCTRL_DRAMTMG15_T_STAB_X32_4         (0x10U << DDRCTRL_DRAMTMG15_T_STAB_X32_Pos)      /*!< 0x00000010 */
#define DDRCTRL_DRAMTMG15_T_STAB_X32_5         (0x20U << DDRCTRL_DRAMTMG15_T_STAB_X32_Pos)      /*!< 0x00000020 */
#define DDRCTRL_DRAMTMG15_T_STAB_X32_6         (0x40U << DDRCTRL_DRAMTMG15_T_STAB_X32_Pos)      /*!< 0x00000040 */
#define DDRCTRL_DRAMTMG15_T_STAB_X32_7         (0x80U << DDRCTRL_DRAMTMG15_T_STAB_X32_Pos)      /*!< 0x00000080 */
#define DDRCTRL_DRAMTMG15_EN_DFI_LP_T_STAB_Pos (31U)
#define DDRCTRL_DRAMTMG15_EN_DFI_LP_T_STAB_Msk (0x1U << DDRCTRL_DRAMTMG15_EN_DFI_LP_T_STAB_Pos) /*!< 0x80000000 */
#define DDRCTRL_DRAMTMG15_EN_DFI_LP_T_STAB     DDRCTRL_DRAMTMG15_EN_DFI_LP_T_STAB_Msk           /*!< - 1 - Enable using tSTAB when exiting DFI LP. Needs to be set when the PHY is stopping the clock during DFI LP to save maximum power. */

/****************  Bit definition for DDRCTRL_ZQCTL0 register  ****************/
#define DDRCTRL_ZQCTL0_T_ZQ_SHORT_NOP_Pos     (0U)
#define DDRCTRL_ZQCTL0_T_ZQ_SHORT_NOP_Msk     (0x3FFU << DDRCTRL_ZQCTL0_T_ZQ_SHORT_NOP_Pos)   /*!< 0x000003FF */
#define DDRCTRL_ZQCTL0_T_ZQ_SHORT_NOP         DDRCTRL_ZQCTL0_T_ZQ_SHORT_NOP_Msk               /*!< tZQCS for DDR3/DD4/LPDDR2/LPDDR3, tZQLAT for LPDDR4: Number of DFI clock cycles of NOP required after a ZQCS (ZQ calibration short)/MPC(ZQ Latch) command is issued to SDRAM. */
#define DDRCTRL_ZQCTL0_T_ZQ_SHORT_NOP_0       (0x1U << DDRCTRL_ZQCTL0_T_ZQ_SHORT_NOP_Pos)     /*!< 0x00000001 */
#define DDRCTRL_ZQCTL0_T_ZQ_SHORT_NOP_1       (0x2U << DDRCTRL_ZQCTL0_T_ZQ_SHORT_NOP_Pos)     /*!< 0x00000002 */
#define DDRCTRL_ZQCTL0_T_ZQ_SHORT_NOP_2       (0x4U << DDRCTRL_ZQCTL0_T_ZQ_SHORT_NOP_Pos)     /*!< 0x00000004 */
#define DDRCTRL_ZQCTL0_T_ZQ_SHORT_NOP_3       (0x8U << DDRCTRL_ZQCTL0_T_ZQ_SHORT_NOP_Pos)     /*!< 0x00000008 */
#define DDRCTRL_ZQCTL0_T_ZQ_SHORT_NOP_4       (0x10U << DDRCTRL_ZQCTL0_T_ZQ_SHORT_NOP_Pos)    /*!< 0x00000010 */
#define DDRCTRL_ZQCTL0_T_ZQ_SHORT_NOP_5       (0x20U << DDRCTRL_ZQCTL0_T_ZQ_SHORT_NOP_Pos)    /*!< 0x00000020 */
#define DDRCTRL_ZQCTL0_T_ZQ_SHORT_NOP_6       (0x40U << DDRCTRL_ZQCTL0_T_ZQ_SHORT_NOP_Pos)    /*!< 0x00000040 */
#define DDRCTRL_ZQCTL0_T_ZQ_SHORT_NOP_7       (0x80U << DDRCTRL_ZQCTL0_T_ZQ_SHORT_NOP_Pos)    /*!< 0x00000080 */
#define DDRCTRL_ZQCTL0_T_ZQ_SHORT_NOP_8       (0x100U << DDRCTRL_ZQCTL0_T_ZQ_SHORT_NOP_Pos)   /*!< 0x00000100 */
#define DDRCTRL_ZQCTL0_T_ZQ_SHORT_NOP_9       (0x200U << DDRCTRL_ZQCTL0_T_ZQ_SHORT_NOP_Pos)   /*!< 0x00000200 */
#define DDRCTRL_ZQCTL0_T_ZQ_LONG_NOP_Pos      (16U)
#define DDRCTRL_ZQCTL0_T_ZQ_LONG_NOP_Msk      (0x7FFU << DDRCTRL_ZQCTL0_T_ZQ_LONG_NOP_Pos)    /*!< 0x07FF0000 */
#define DDRCTRL_ZQCTL0_T_ZQ_LONG_NOP          DDRCTRL_ZQCTL0_T_ZQ_LONG_NOP_Msk                /*!< tZQoper for DDR3/DDR4, tZQCL for LPDDR2/LPDDR3, tZQCAL for LPDDR4: Number of DFI clock cycles of NOP required after a ZQCL (ZQ calibration long)/MPC(ZQ Start) command is issued to SDRAM. */
#define DDRCTRL_ZQCTL0_T_ZQ_LONG_NOP_0        (0x1U << DDRCTRL_ZQCTL0_T_ZQ_LONG_NOP_Pos)      /*!< 0x00010000 */
#define DDRCTRL_ZQCTL0_T_ZQ_LONG_NOP_1        (0x2U << DDRCTRL_ZQCTL0_T_ZQ_LONG_NOP_Pos)      /*!< 0x00020000 */
#define DDRCTRL_ZQCTL0_T_ZQ_LONG_NOP_2        (0x4U << DDRCTRL_ZQCTL0_T_ZQ_LONG_NOP_Pos)      /*!< 0x00040000 */
#define DDRCTRL_ZQCTL0_T_ZQ_LONG_NOP_3        (0x8U << DDRCTRL_ZQCTL0_T_ZQ_LONG_NOP_Pos)      /*!< 0x00080000 */
#define DDRCTRL_ZQCTL0_T_ZQ_LONG_NOP_4        (0x10U << DDRCTRL_ZQCTL0_T_ZQ_LONG_NOP_Pos)     /*!< 0x00100000 */
#define DDRCTRL_ZQCTL0_T_ZQ_LONG_NOP_5        (0x20U << DDRCTRL_ZQCTL0_T_ZQ_LONG_NOP_Pos)     /*!< 0x00200000 */
#define DDRCTRL_ZQCTL0_T_ZQ_LONG_NOP_6        (0x40U << DDRCTRL_ZQCTL0_T_ZQ_LONG_NOP_Pos)     /*!< 0x00400000 */
#define DDRCTRL_ZQCTL0_T_ZQ_LONG_NOP_7        (0x80U << DDRCTRL_ZQCTL0_T_ZQ_LONG_NOP_Pos)     /*!< 0x00800000 */
#define DDRCTRL_ZQCTL0_T_ZQ_LONG_NOP_8        (0x100U << DDRCTRL_ZQCTL0_T_ZQ_LONG_NOP_Pos)    /*!< 0x01000000 */
#define DDRCTRL_ZQCTL0_T_ZQ_LONG_NOP_9        (0x200U << DDRCTRL_ZQCTL0_T_ZQ_LONG_NOP_Pos)    /*!< 0x02000000 */
#define DDRCTRL_ZQCTL0_T_ZQ_LONG_NOP_10       (0x400U << DDRCTRL_ZQCTL0_T_ZQ_LONG_NOP_Pos)    /*!< 0x04000000 */
#define DDRCTRL_ZQCTL0_ZQ_RESISTOR_SHARED_Pos (29U)
#define DDRCTRL_ZQCTL0_ZQ_RESISTOR_SHARED_Msk (0x1U << DDRCTRL_ZQCTL0_ZQ_RESISTOR_SHARED_Pos) /*!< 0x20000000 */
#define DDRCTRL_ZQCTL0_ZQ_RESISTOR_SHARED     DDRCTRL_ZQCTL0_ZQ_RESISTOR_SHARED_Msk           /*!< - 1 - Denotes that ZQ resistor is shared between ranks. Means ZQinit/ZQCL/ZQCS/MPC(ZQ calibration) commands are sent to one rank at a time with tZQinit/tZQCL/tZQCS/tZQCAL/tZQLAT timing met between commands so that commands to different ranks do not overlap. */
#define DDRCTRL_ZQCTL0_DIS_SRX_ZQCL_Pos       (30U)
#define DDRCTRL_ZQCTL0_DIS_SRX_ZQCL_Msk       (0x1U << DDRCTRL_ZQCTL0_DIS_SRX_ZQCL_Pos)       /*!< 0x40000000 */
#define DDRCTRL_ZQCTL0_DIS_SRX_ZQCL           DDRCTRL_ZQCTL0_DIS_SRX_ZQCL_Msk                 /*!< - 1 - Disable issuing of ZQCL/MPC(ZQ calibration) command at Self-Refresh/SR-Powerdown exit. Only applicable when run in DDR3 or DDR4 or LPDDR2 or LPDDR3 or LPDDR4 mode. */
#define DDRCTRL_ZQCTL0_DIS_AUTO_ZQ_Pos        (31U)
#define DDRCTRL_ZQCTL0_DIS_AUTO_ZQ_Msk        (0x1U << DDRCTRL_ZQCTL0_DIS_AUTO_ZQ_Pos)        /*!< 0x80000000 */
#define DDRCTRL_ZQCTL0_DIS_AUTO_ZQ            DDRCTRL_ZQCTL0_DIS_AUTO_ZQ_Msk                  /*!< - 1 - Disable DDRCTRL generation of ZQCS/MPC(ZQ calibration) command. Register DBGCMD.zq_calib_short can be used instead to issue ZQ calibration request from APB module. */

/****************  Bit definition for DDRCTRL_ZQCTL1 register  ****************/
#define DDRCTRL_ZQCTL1_T_ZQ_SHORT_INTERVAL_X1024_Pos (0U)
#define DDRCTRL_ZQCTL1_T_ZQ_SHORT_INTERVAL_X1024_Msk (0xFFFFFU << DDRCTRL_ZQCTL1_T_ZQ_SHORT_INTERVAL_X1024_Pos) /*!< 0x000FFFFF */
#define DDRCTRL_ZQCTL1_T_ZQ_SHORT_INTERVAL_X1024     DDRCTRL_ZQCTL1_T_ZQ_SHORT_INTERVAL_X1024_Msk               /*!< Average interval to wait between automatically issuing ZQCS (ZQ calibration short)/MPC(ZQ calibration) commands to DDR3/DDR4/LPDDR2/LPDDR3/LPDDR4 devices. */
#define DDRCTRL_ZQCTL1_T_ZQ_SHORT_INTERVAL_X1024_0   (0x1U << DDRCTRL_ZQCTL1_T_ZQ_SHORT_INTERVAL_X1024_Pos)     /*!< 0x00000001 */
#define DDRCTRL_ZQCTL1_T_ZQ_SHORT_INTERVAL_X1024_1   (0x2U << DDRCTRL_ZQCTL1_T_ZQ_SHORT_INTERVAL_X1024_Pos)     /*!< 0x00000002 */
#define DDRCTRL_ZQCTL1_T_ZQ_SHORT_INTERVAL_X1024_2   (0x4U << DDRCTRL_ZQCTL1_T_ZQ_SHORT_INTERVAL_X1024_Pos)     /*!< 0x00000004 */
#define DDRCTRL_ZQCTL1_T_ZQ_SHORT_INTERVAL_X1024_3   (0x8U << DDRCTRL_ZQCTL1_T_ZQ_SHORT_INTERVAL_X1024_Pos)     /*!< 0x00000008 */
#define DDRCTRL_ZQCTL1_T_ZQ_SHORT_INTERVAL_X1024_4   (0x10U << DDRCTRL_ZQCTL1_T_ZQ_SHORT_INTERVAL_X1024_Pos)    /*!< 0x00000010 */
#define DDRCTRL_ZQCTL1_T_ZQ_SHORT_INTERVAL_X1024_5   (0x20U << DDRCTRL_ZQCTL1_T_ZQ_SHORT_INTERVAL_X1024_Pos)    /*!< 0x00000020 */
#define DDRCTRL_ZQCTL1_T_ZQ_SHORT_INTERVAL_X1024_6   (0x40U << DDRCTRL_ZQCTL1_T_ZQ_SHORT_INTERVAL_X1024_Pos)    /*!< 0x00000040 */
#define DDRCTRL_ZQCTL1_T_ZQ_SHORT_INTERVAL_X1024_7   (0x80U << DDRCTRL_ZQCTL1_T_ZQ_SHORT_INTERVAL_X1024_Pos)    /*!< 0x00000080 */
#define DDRCTRL_ZQCTL1_T_ZQ_SHORT_INTERVAL_X1024_8   (0x100U << DDRCTRL_ZQCTL1_T_ZQ_SHORT_INTERVAL_X1024_Pos)   /*!< 0x00000100 */
#define DDRCTRL_ZQCTL1_T_ZQ_SHORT_INTERVAL_X1024_9   (0x200U << DDRCTRL_ZQCTL1_T_ZQ_SHORT_INTERVAL_X1024_Pos)   /*!< 0x00000200 */
#define DDRCTRL_ZQCTL1_T_ZQ_SHORT_INTERVAL_X1024_10  (0x400U << DDRCTRL_ZQCTL1_T_ZQ_SHORT_INTERVAL_X1024_Pos)   /*!< 0x00000400 */
#define DDRCTRL_ZQCTL1_T_ZQ_SHORT_INTERVAL_X1024_11  (0x800U << DDRCTRL_ZQCTL1_T_ZQ_SHORT_INTERVAL_X1024_Pos)   /*!< 0x00000800 */
#define DDRCTRL_ZQCTL1_T_ZQ_SHORT_INTERVAL_X1024_12  (0x1000U << DDRCTRL_ZQCTL1_T_ZQ_SHORT_INTERVAL_X1024_Pos)  /*!< 0x00001000 */
#define DDRCTRL_ZQCTL1_T_ZQ_SHORT_INTERVAL_X1024_13  (0x2000U << DDRCTRL_ZQCTL1_T_ZQ_SHORT_INTERVAL_X1024_Pos)  /*!< 0x00002000 */
#define DDRCTRL_ZQCTL1_T_ZQ_SHORT_INTERVAL_X1024_14  (0x4000U << DDRCTRL_ZQCTL1_T_ZQ_SHORT_INTERVAL_X1024_Pos)  /*!< 0x00004000 */
#define DDRCTRL_ZQCTL1_T_ZQ_SHORT_INTERVAL_X1024_15  (0x8000U << DDRCTRL_ZQCTL1_T_ZQ_SHORT_INTERVAL_X1024_Pos)  /*!< 0x00008000 */
#define DDRCTRL_ZQCTL1_T_ZQ_SHORT_INTERVAL_X1024_16  (0x10000U << DDRCTRL_ZQCTL1_T_ZQ_SHORT_INTERVAL_X1024_Pos) /*!< 0x00010000 */
#define DDRCTRL_ZQCTL1_T_ZQ_SHORT_INTERVAL_X1024_17  (0x20000U << DDRCTRL_ZQCTL1_T_ZQ_SHORT_INTERVAL_X1024_Pos) /*!< 0x00020000 */
#define DDRCTRL_ZQCTL1_T_ZQ_SHORT_INTERVAL_X1024_18  (0x40000U << DDRCTRL_ZQCTL1_T_ZQ_SHORT_INTERVAL_X1024_Pos) /*!< 0x00040000 */
#define DDRCTRL_ZQCTL1_T_ZQ_SHORT_INTERVAL_X1024_19  (0x80000U << DDRCTRL_ZQCTL1_T_ZQ_SHORT_INTERVAL_X1024_Pos) /*!< 0x00080000 */
#define DDRCTRL_ZQCTL1_T_ZQ_RESET_NOP_Pos            (20U)
#define DDRCTRL_ZQCTL1_T_ZQ_RESET_NOP_Msk            (0x3FFU << DDRCTRL_ZQCTL1_T_ZQ_RESET_NOP_Pos)              /*!< 0x3FF00000 */
#define DDRCTRL_ZQCTL1_T_ZQ_RESET_NOP                DDRCTRL_ZQCTL1_T_ZQ_RESET_NOP_Msk                          /*!< tZQReset: Number of DFI clock cycles of NOP required after a ZQReset (ZQ calibration Reset) command is issued to SDRAM. */
#define DDRCTRL_ZQCTL1_T_ZQ_RESET_NOP_0              (0x1U << DDRCTRL_ZQCTL1_T_ZQ_RESET_NOP_Pos)                /*!< 0x00100000 */
#define DDRCTRL_ZQCTL1_T_ZQ_RESET_NOP_1              (0x2U << DDRCTRL_ZQCTL1_T_ZQ_RESET_NOP_Pos)                /*!< 0x00200000 */
#define DDRCTRL_ZQCTL1_T_ZQ_RESET_NOP_2              (0x4U << DDRCTRL_ZQCTL1_T_ZQ_RESET_NOP_Pos)                /*!< 0x00400000 */
#define DDRCTRL_ZQCTL1_T_ZQ_RESET_NOP_3              (0x8U << DDRCTRL_ZQCTL1_T_ZQ_RESET_NOP_Pos)                /*!< 0x00800000 */
#define DDRCTRL_ZQCTL1_T_ZQ_RESET_NOP_4              (0x10U << DDRCTRL_ZQCTL1_T_ZQ_RESET_NOP_Pos)               /*!< 0x01000000 */
#define DDRCTRL_ZQCTL1_T_ZQ_RESET_NOP_5              (0x20U << DDRCTRL_ZQCTL1_T_ZQ_RESET_NOP_Pos)               /*!< 0x02000000 */
#define DDRCTRL_ZQCTL1_T_ZQ_RESET_NOP_6              (0x40U << DDRCTRL_ZQCTL1_T_ZQ_RESET_NOP_Pos)               /*!< 0x04000000 */
#define DDRCTRL_ZQCTL1_T_ZQ_RESET_NOP_7              (0x80U << DDRCTRL_ZQCTL1_T_ZQ_RESET_NOP_Pos)               /*!< 0x08000000 */
#define DDRCTRL_ZQCTL1_T_ZQ_RESET_NOP_8              (0x100U << DDRCTRL_ZQCTL1_T_ZQ_RESET_NOP_Pos)              /*!< 0x10000000 */
#define DDRCTRL_ZQCTL1_T_ZQ_RESET_NOP_9              (0x200U << DDRCTRL_ZQCTL1_T_ZQ_RESET_NOP_Pos)              /*!< 0x20000000 */

/****************  Bit definition for DDRCTRL_ZQCTL2 register  ****************/
#define DDRCTRL_ZQCTL2_ZQ_RESET_Pos (0U)
#define DDRCTRL_ZQCTL2_ZQ_RESET_Msk (0x1U << DDRCTRL_ZQCTL2_ZQ_RESET_Pos) /*!< 0x00000001 */
#define DDRCTRL_ZQCTL2_ZQ_RESET     DDRCTRL_ZQCTL2_ZQ_RESET_Msk           /*!< Setting this register bit to 1 triggers a ZQ Reset operation. When the ZQ Reset operation is complete, the DDRCTRL automatically clears this bit. It is recommended NOT to set this register bit if in Init, in Self-Refresh(except LPDDR4) or SR-Powerdown(LPDDR4) or Deep power-down operating modes. */

/****************  Bit definition for DDRCTRL_ZQSTAT register  ****************/
#define DDRCTRL_ZQSTAT_ZQ_RESET_BUSY_Pos (0U)
#define DDRCTRL_ZQSTAT_ZQ_RESET_BUSY_Msk (0x1U << DDRCTRL_ZQSTAT_ZQ_RESET_BUSY_Pos) /*!< 0x00000001 */
#define DDRCTRL_ZQSTAT_ZQ_RESET_BUSY     DDRCTRL_ZQSTAT_ZQ_RESET_BUSY_Msk           /*!< SoC core may initiate a ZQ Reset operation only if this signal is low. This signal goes high in the clock after the DDRCTRL accepts the ZQ Reset request. It goes low when the ZQ Reset command is issued to the SDRAM and the associated NOP period is over. It is recommended not to perform ZQ Reset commands when this signal is high. */

/***************  Bit definition for DDRCTRL_DFITMG0 register  ****************/
#define DDRCTRL_DFITMG0_DFI_TPHY_WRLAT_Pos   (0U)
#define DDRCTRL_DFITMG0_DFI_TPHY_WRLAT_Msk   (0x3FU << DDRCTRL_DFITMG0_DFI_TPHY_WRLAT_Pos)   /*!< 0x0000003F */
#define DDRCTRL_DFITMG0_DFI_TPHY_WRLAT       DDRCTRL_DFITMG0_DFI_TPHY_WRLAT_Msk              /*!< Write latency */
#define DDRCTRL_DFITMG0_DFI_TPHY_WRLAT_0     (0x1U << DDRCTRL_DFITMG0_DFI_TPHY_WRLAT_Pos)    /*!< 0x00000001 */
#define DDRCTRL_DFITMG0_DFI_TPHY_WRLAT_1     (0x2U << DDRCTRL_DFITMG0_DFI_TPHY_WRLAT_Pos)    /*!< 0x00000002 */
#define DDRCTRL_DFITMG0_DFI_TPHY_WRLAT_2     (0x4U << DDRCTRL_DFITMG0_DFI_TPHY_WRLAT_Pos)    /*!< 0x00000004 */
#define DDRCTRL_DFITMG0_DFI_TPHY_WRLAT_3     (0x8U << DDRCTRL_DFITMG0_DFI_TPHY_WRLAT_Pos)    /*!< 0x00000008 */
#define DDRCTRL_DFITMG0_DFI_TPHY_WRLAT_4     (0x10U << DDRCTRL_DFITMG0_DFI_TPHY_WRLAT_Pos)   /*!< 0x00000010 */
#define DDRCTRL_DFITMG0_DFI_TPHY_WRLAT_5     (0x20U << DDRCTRL_DFITMG0_DFI_TPHY_WRLAT_Pos)   /*!< 0x00000020 */
#define DDRCTRL_DFITMG0_DFI_TPHY_WRDATA_Pos  (8U)
#define DDRCTRL_DFITMG0_DFI_TPHY_WRDATA_Msk  (0x3FU << DDRCTRL_DFITMG0_DFI_TPHY_WRDATA_Pos)  /*!< 0x00003F00 */
#define DDRCTRL_DFITMG0_DFI_TPHY_WRDATA      DDRCTRL_DFITMG0_DFI_TPHY_WRDATA_Msk             /*!< Specifies the number of clock cycles between when dfi_wrdata_en is asserted to when the associated write data is driven on the dfi_wrdata signal. This corresponds to the DFI timing parameter tphy_wrdata. Refer to PHY specification for correct value. Note, max supported value is 8. */
#define DDRCTRL_DFITMG0_DFI_TPHY_WRDATA_0    (0x1U << DDRCTRL_DFITMG0_DFI_TPHY_WRDATA_Pos)   /*!< 0x00000100 */
#define DDRCTRL_DFITMG0_DFI_TPHY_WRDATA_1    (0x2U << DDRCTRL_DFITMG0_DFI_TPHY_WRDATA_Pos)   /*!< 0x00000200 */
#define DDRCTRL_DFITMG0_DFI_TPHY_WRDATA_2    (0x4U << DDRCTRL_DFITMG0_DFI_TPHY_WRDATA_Pos)   /*!< 0x00000400 */
#define DDRCTRL_DFITMG0_DFI_TPHY_WRDATA_3    (0x8U << DDRCTRL_DFITMG0_DFI_TPHY_WRDATA_Pos)   /*!< 0x00000800 */
#define DDRCTRL_DFITMG0_DFI_TPHY_WRDATA_4    (0x10U << DDRCTRL_DFITMG0_DFI_TPHY_WRDATA_Pos)  /*!< 0x00001000 */
#define DDRCTRL_DFITMG0_DFI_TPHY_WRDATA_5    (0x20U << DDRCTRL_DFITMG0_DFI_TPHY_WRDATA_Pos)  /*!< 0x00002000 */
#define DDRCTRL_DFITMG0_DFI_T_RDDATA_EN_Pos  (16U)
#define DDRCTRL_DFITMG0_DFI_T_RDDATA_EN_Msk  (0x7FU << DDRCTRL_DFITMG0_DFI_T_RDDATA_EN_Pos)  /*!< 0x007F0000 */
#define DDRCTRL_DFITMG0_DFI_T_RDDATA_EN      DDRCTRL_DFITMG0_DFI_T_RDDATA_EN_Msk             /*!< Time from the assertion of a read command on the DFI interface to the assertion of the dfi_rddata_en signal. */
#define DDRCTRL_DFITMG0_DFI_T_RDDATA_EN_0    (0x1U << DDRCTRL_DFITMG0_DFI_T_RDDATA_EN_Pos)   /*!< 0x00010000 */
#define DDRCTRL_DFITMG0_DFI_T_RDDATA_EN_1    (0x2U << DDRCTRL_DFITMG0_DFI_T_RDDATA_EN_Pos)   /*!< 0x00020000 */
#define DDRCTRL_DFITMG0_DFI_T_RDDATA_EN_2    (0x4U << DDRCTRL_DFITMG0_DFI_T_RDDATA_EN_Pos)   /*!< 0x00040000 */
#define DDRCTRL_DFITMG0_DFI_T_RDDATA_EN_3    (0x8U << DDRCTRL_DFITMG0_DFI_T_RDDATA_EN_Pos)   /*!< 0x00080000 */
#define DDRCTRL_DFITMG0_DFI_T_RDDATA_EN_4    (0x10U << DDRCTRL_DFITMG0_DFI_T_RDDATA_EN_Pos)  /*!< 0x00100000 */
#define DDRCTRL_DFITMG0_DFI_T_RDDATA_EN_5    (0x20U << DDRCTRL_DFITMG0_DFI_T_RDDATA_EN_Pos)  /*!< 0x00200000 */
#define DDRCTRL_DFITMG0_DFI_T_RDDATA_EN_6    (0x40U << DDRCTRL_DFITMG0_DFI_T_RDDATA_EN_Pos)  /*!< 0x00400000 */
#define DDRCTRL_DFITMG0_DFI_T_CTRL_DELAY_Pos (24U)
#define DDRCTRL_DFITMG0_DFI_T_CTRL_DELAY_Msk (0x1FU << DDRCTRL_DFITMG0_DFI_T_CTRL_DELAY_Pos) /*!< 0x1F000000 */
#define DDRCTRL_DFITMG0_DFI_T_CTRL_DELAY     DDRCTRL_DFITMG0_DFI_T_CTRL_DELAY_Msk            /*!< Specifies the number of DFI clock cycles after an assertion or de-assertion of the DFI control signals that the control signals at the PHY-DRAM interface reflect the assertion or de-assertion. If the DFI clock and the memory clock are not phase-aligned, this timing parameter should be rounded up to the next integer value. Note that if using RDIMM/LRDIMM, it is necessary to increment this parameter by RDIMM\qs/LRDIMM\qs extra cycle of latency in terms of DFI clock. */
#define DDRCTRL_DFITMG0_DFI_T_CTRL_DELAY_0   (0x1U << DDRCTRL_DFITMG0_DFI_T_CTRL_DELAY_Pos)  /*!< 0x01000000 */
#define DDRCTRL_DFITMG0_DFI_T_CTRL_DELAY_1   (0x2U << DDRCTRL_DFITMG0_DFI_T_CTRL_DELAY_Pos)  /*!< 0x02000000 */
#define DDRCTRL_DFITMG0_DFI_T_CTRL_DELAY_2   (0x4U << DDRCTRL_DFITMG0_DFI_T_CTRL_DELAY_Pos)  /*!< 0x04000000 */
#define DDRCTRL_DFITMG0_DFI_T_CTRL_DELAY_3   (0x8U << DDRCTRL_DFITMG0_DFI_T_CTRL_DELAY_Pos)  /*!< 0x08000000 */
#define DDRCTRL_DFITMG0_DFI_T_CTRL_DELAY_4   (0x10U << DDRCTRL_DFITMG0_DFI_T_CTRL_DELAY_Pos) /*!< 0x10000000 */

/***************  Bit definition for DDRCTRL_DFITMG1 register  ****************/
#define DDRCTRL_DFITMG1_DFI_T_DRAM_CLK_ENABLE_Pos  (0U)
#define DDRCTRL_DFITMG1_DFI_T_DRAM_CLK_ENABLE_Msk  (0x1FU << DDRCTRL_DFITMG1_DFI_T_DRAM_CLK_ENABLE_Pos)  /*!< 0x0000001F */
#define DDRCTRL_DFITMG1_DFI_T_DRAM_CLK_ENABLE      DDRCTRL_DFITMG1_DFI_T_DRAM_CLK_ENABLE_Msk             /*!< Specifies the number of DFI clock cycles from the de-assertion of the dfi_dram_clk_disable signal on the DFI until the first valid rising edge of the clock to the DRAM memory devices, at the PHY-DRAM boundary. If the DFI clock and the memory clock are not phase aligned, this timing parameter should be rounded up to the next integer value. */
#define DDRCTRL_DFITMG1_DFI_T_DRAM_CLK_ENABLE_0    (0x1U << DDRCTRL_DFITMG1_DFI_T_DRAM_CLK_ENABLE_Pos)   /*!< 0x00000001 */
#define DDRCTRL_DFITMG1_DFI_T_DRAM_CLK_ENABLE_1    (0x2U << DDRCTRL_DFITMG1_DFI_T_DRAM_CLK_ENABLE_Pos)   /*!< 0x00000002 */
#define DDRCTRL_DFITMG1_DFI_T_DRAM_CLK_ENABLE_2    (0x4U << DDRCTRL_DFITMG1_DFI_T_DRAM_CLK_ENABLE_Pos)   /*!< 0x00000004 */
#define DDRCTRL_DFITMG1_DFI_T_DRAM_CLK_ENABLE_3    (0x8U << DDRCTRL_DFITMG1_DFI_T_DRAM_CLK_ENABLE_Pos)   /*!< 0x00000008 */
#define DDRCTRL_DFITMG1_DFI_T_DRAM_CLK_ENABLE_4    (0x10U << DDRCTRL_DFITMG1_DFI_T_DRAM_CLK_ENABLE_Pos)  /*!< 0x00000010 */
#define DDRCTRL_DFITMG1_DFI_T_DRAM_CLK_DISABLE_Pos (8U)
#define DDRCTRL_DFITMG1_DFI_T_DRAM_CLK_DISABLE_Msk (0x1FU << DDRCTRL_DFITMG1_DFI_T_DRAM_CLK_DISABLE_Pos) /*!< 0x00001F00 */
#define DDRCTRL_DFITMG1_DFI_T_DRAM_CLK_DISABLE     DDRCTRL_DFITMG1_DFI_T_DRAM_CLK_DISABLE_Msk            /*!< Specifies the number of DFI clock cycles from the assertion of the dfi_dram_clk_disable signal on the DFI until the clock to the DRAM memory devices, at the PHY-DRAM boundary, maintains a low value. If the DFI clock and the memory clock are not phase aligned, this timing parameter should be rounded up to the next integer value. */
#define DDRCTRL_DFITMG1_DFI_T_DRAM_CLK_DISABLE_0   (0x1U << DDRCTRL_DFITMG1_DFI_T_DRAM_CLK_DISABLE_Pos)  /*!< 0x00000100 */
#define DDRCTRL_DFITMG1_DFI_T_DRAM_CLK_DISABLE_1   (0x2U << DDRCTRL_DFITMG1_DFI_T_DRAM_CLK_DISABLE_Pos)  /*!< 0x00000200 */
#define DDRCTRL_DFITMG1_DFI_T_DRAM_CLK_DISABLE_2   (0x4U << DDRCTRL_DFITMG1_DFI_T_DRAM_CLK_DISABLE_Pos)  /*!< 0x00000400 */
#define DDRCTRL_DFITMG1_DFI_T_DRAM_CLK_DISABLE_3   (0x8U << DDRCTRL_DFITMG1_DFI_T_DRAM_CLK_DISABLE_Pos)  /*!< 0x00000800 */
#define DDRCTRL_DFITMG1_DFI_T_DRAM_CLK_DISABLE_4   (0x10U << DDRCTRL_DFITMG1_DFI_T_DRAM_CLK_DISABLE_Pos) /*!< 0x00001000 */
#define DDRCTRL_DFITMG1_DFI_T_WRDATA_DELAY_Pos     (16U)
#define DDRCTRL_DFITMG1_DFI_T_WRDATA_DELAY_Msk     (0x1FU << DDRCTRL_DFITMG1_DFI_T_WRDATA_DELAY_Pos)     /*!< 0x001F0000 */
#define DDRCTRL_DFITMG1_DFI_T_WRDATA_DELAY         DDRCTRL_DFITMG1_DFI_T_WRDATA_DELAY_Msk                /*!< Specifies the number of DFI clock cycles between when the dfi_wrdata_en */
#define DDRCTRL_DFITMG1_DFI_T_WRDATA_DELAY_0       (0x1U << DDRCTRL_DFITMG1_DFI_T_WRDATA_DELAY_Pos)      /*!< 0x00010000 */
#define DDRCTRL_DFITMG1_DFI_T_WRDATA_DELAY_1       (0x2U << DDRCTRL_DFITMG1_DFI_T_WRDATA_DELAY_Pos)      /*!< 0x00020000 */
#define DDRCTRL_DFITMG1_DFI_T_WRDATA_DELAY_2       (0x4U << DDRCTRL_DFITMG1_DFI_T_WRDATA_DELAY_Pos)      /*!< 0x00040000 */
#define DDRCTRL_DFITMG1_DFI_T_WRDATA_DELAY_3       (0x8U << DDRCTRL_DFITMG1_DFI_T_WRDATA_DELAY_Pos)      /*!< 0x00080000 */
#define DDRCTRL_DFITMG1_DFI_T_WRDATA_DELAY_4       (0x10U << DDRCTRL_DFITMG1_DFI_T_WRDATA_DELAY_Pos)     /*!< 0x00100000 */

/**************  Bit definition for DDRCTRL_DFILPCFG0 register  ***************/
#define DDRCTRL_DFILPCFG0_DFI_LP_EN_PD_Pos      (0U)
#define DDRCTRL_DFILPCFG0_DFI_LP_EN_PD_Msk      (0x1U << DDRCTRL_DFILPCFG0_DFI_LP_EN_PD_Pos)      /*!< 0x00000001 */
#define DDRCTRL_DFILPCFG0_DFI_LP_EN_PD          DDRCTRL_DFILPCFG0_DFI_LP_EN_PD_Msk                /*!< Enables DFI Low Power interface handshaking during Power Down Entry/Exit. */
#define DDRCTRL_DFILPCFG0_DFI_LP_WAKEUP_PD_Pos  (4U)
#define DDRCTRL_DFILPCFG0_DFI_LP_WAKEUP_PD_Msk  (0xFU << DDRCTRL_DFILPCFG0_DFI_LP_WAKEUP_PD_Pos)  /*!< 0x000000F0 */
#define DDRCTRL_DFILPCFG0_DFI_LP_WAKEUP_PD      DDRCTRL_DFILPCFG0_DFI_LP_WAKEUP_PD_Msk            /*!< Value in DFI clock cycles to drive on dfi_lp_wakeup signal when Power Down mode is entered. */
#define DDRCTRL_DFILPCFG0_DFI_LP_WAKEUP_PD_0    (0x1U << DDRCTRL_DFILPCFG0_DFI_LP_WAKEUP_PD_Pos)  /*!< 0x00000010 */
#define DDRCTRL_DFILPCFG0_DFI_LP_WAKEUP_PD_1    (0x2U << DDRCTRL_DFILPCFG0_DFI_LP_WAKEUP_PD_Pos)  /*!< 0x00000020 */
#define DDRCTRL_DFILPCFG0_DFI_LP_WAKEUP_PD_2    (0x4U << DDRCTRL_DFILPCFG0_DFI_LP_WAKEUP_PD_Pos)  /*!< 0x00000040 */
#define DDRCTRL_DFILPCFG0_DFI_LP_WAKEUP_PD_3    (0x8U << DDRCTRL_DFILPCFG0_DFI_LP_WAKEUP_PD_Pos)  /*!< 0x00000080 */
#define DDRCTRL_DFILPCFG0_DFI_LP_EN_SR_Pos      (8U)
#define DDRCTRL_DFILPCFG0_DFI_LP_EN_SR_Msk      (0x1U << DDRCTRL_DFILPCFG0_DFI_LP_EN_SR_Pos)      /*!< 0x00000100 */
#define DDRCTRL_DFILPCFG0_DFI_LP_EN_SR          DDRCTRL_DFILPCFG0_DFI_LP_EN_SR_Msk                /*!< Enables DFI Low Power interface handshaking during Self Refresh Entry/Exit. */
#define DDRCTRL_DFILPCFG0_DFI_LP_WAKEUP_SR_Pos  (12U)
#define DDRCTRL_DFILPCFG0_DFI_LP_WAKEUP_SR_Msk  (0xFU << DDRCTRL_DFILPCFG0_DFI_LP_WAKEUP_SR_Pos)  /*!< 0x0000F000 */
#define DDRCTRL_DFILPCFG0_DFI_LP_WAKEUP_SR      DDRCTRL_DFILPCFG0_DFI_LP_WAKEUP_SR_Msk            /*!< Value in DFI clpck cycles to drive on dfi_lp_wakeup signal when Self Refresh mode is entered. */
#define DDRCTRL_DFILPCFG0_DFI_LP_WAKEUP_SR_0    (0x1U << DDRCTRL_DFILPCFG0_DFI_LP_WAKEUP_SR_Pos)  /*!< 0x00001000 */
#define DDRCTRL_DFILPCFG0_DFI_LP_WAKEUP_SR_1    (0x2U << DDRCTRL_DFILPCFG0_DFI_LP_WAKEUP_SR_Pos)  /*!< 0x00002000 */
#define DDRCTRL_DFILPCFG0_DFI_LP_WAKEUP_SR_2    (0x4U << DDRCTRL_DFILPCFG0_DFI_LP_WAKEUP_SR_Pos)  /*!< 0x00004000 */
#define DDRCTRL_DFILPCFG0_DFI_LP_WAKEUP_SR_3    (0x8U << DDRCTRL_DFILPCFG0_DFI_LP_WAKEUP_SR_Pos)  /*!< 0x00008000 */
#define DDRCTRL_DFILPCFG0_DFI_LP_EN_DPD_Pos     (16U)
#define DDRCTRL_DFILPCFG0_DFI_LP_EN_DPD_Msk     (0x1U << DDRCTRL_DFILPCFG0_DFI_LP_EN_DPD_Pos)     /*!< 0x00010000 */
#define DDRCTRL_DFILPCFG0_DFI_LP_EN_DPD         DDRCTRL_DFILPCFG0_DFI_LP_EN_DPD_Msk               /*!< Enables DFI Low-power interface handshaking during Deep Power Down Entry/Exit. */
#define DDRCTRL_DFILPCFG0_DFI_LP_WAKEUP_DPD_Pos (20U)
#define DDRCTRL_DFILPCFG0_DFI_LP_WAKEUP_DPD_Msk (0xFU << DDRCTRL_DFILPCFG0_DFI_LP_WAKEUP_DPD_Pos) /*!< 0x00F00000 */
#define DDRCTRL_DFILPCFG0_DFI_LP_WAKEUP_DPD     DDRCTRL_DFILPCFG0_DFI_LP_WAKEUP_DPD_Msk           /*!< Value in DFI clock cycles to drive on dfi_lp_wakeup signal when Deep Power Down mode is entered. */
#define DDRCTRL_DFILPCFG0_DFI_LP_WAKEUP_DPD_0   (0x1U << DDRCTRL_DFILPCFG0_DFI_LP_WAKEUP_DPD_Pos) /*!< 0x00100000 */
#define DDRCTRL_DFILPCFG0_DFI_LP_WAKEUP_DPD_1   (0x2U << DDRCTRL_DFILPCFG0_DFI_LP_WAKEUP_DPD_Pos) /*!< 0x00200000 */
#define DDRCTRL_DFILPCFG0_DFI_LP_WAKEUP_DPD_2   (0x4U << DDRCTRL_DFILPCFG0_DFI_LP_WAKEUP_DPD_Pos) /*!< 0x00400000 */
#define DDRCTRL_DFILPCFG0_DFI_LP_WAKEUP_DPD_3   (0x8U << DDRCTRL_DFILPCFG0_DFI_LP_WAKEUP_DPD_Pos) /*!< 0x00800000 */
#define DDRCTRL_DFILPCFG0_DFI_TLP_RESP_Pos      (24U)
#define DDRCTRL_DFILPCFG0_DFI_TLP_RESP_Msk      (0x1FU << DDRCTRL_DFILPCFG0_DFI_TLP_RESP_Pos)     /*!< 0x1F000000 */
#define DDRCTRL_DFILPCFG0_DFI_TLP_RESP          DDRCTRL_DFILPCFG0_DFI_TLP_RESP_Msk                /*!< Setting in DFI clock cycles for DFI\qs tlp_resp time. */
#define DDRCTRL_DFILPCFG0_DFI_TLP_RESP_0        (0x1U << DDRCTRL_DFILPCFG0_DFI_TLP_RESP_Pos)      /*!< 0x01000000 */
#define DDRCTRL_DFILPCFG0_DFI_TLP_RESP_1        (0x2U << DDRCTRL_DFILPCFG0_DFI_TLP_RESP_Pos)      /*!< 0x02000000 */
#define DDRCTRL_DFILPCFG0_DFI_TLP_RESP_2        (0x4U << DDRCTRL_DFILPCFG0_DFI_TLP_RESP_Pos)      /*!< 0x04000000 */
#define DDRCTRL_DFILPCFG0_DFI_TLP_RESP_3        (0x8U << DDRCTRL_DFILPCFG0_DFI_TLP_RESP_Pos)      /*!< 0x08000000 */
#define DDRCTRL_DFILPCFG0_DFI_TLP_RESP_4        (0x10U << DDRCTRL_DFILPCFG0_DFI_TLP_RESP_Pos)     /*!< 0x10000000 */

/***************  Bit definition for DDRCTRL_DFIUPD0 register  ****************/
#define DDRCTRL_DFIUPD0_DFI_T_CTRLUP_MIN_Pos     (0U)
#define DDRCTRL_DFIUPD0_DFI_T_CTRLUP_MIN_Msk     (0x3FFU << DDRCTRL_DFIUPD0_DFI_T_CTRLUP_MIN_Pos)   /*!< 0x000003FF */
#define DDRCTRL_DFIUPD0_DFI_T_CTRLUP_MIN         DDRCTRL_DFIUPD0_DFI_T_CTRLUP_MIN_Msk               /*!< Specifies the minimum number of DFI clock cycles that the dfi_ctrlupd_req signal must be asserted. The DDRCTRL expects the PHY to respond within this time. If the PHY does not respond, the DDRCTRL de-asserts dfi_ctrlupd_req after dfi_t_ctrlup_min + 2 cycles. Lowest value to assign to this variable is 0x3. */
#define DDRCTRL_DFIUPD0_DFI_T_CTRLUP_MIN_0       (0x1U << DDRCTRL_DFIUPD0_DFI_T_CTRLUP_MIN_Pos)     /*!< 0x00000001 */
#define DDRCTRL_DFIUPD0_DFI_T_CTRLUP_MIN_1       (0x2U << DDRCTRL_DFIUPD0_DFI_T_CTRLUP_MIN_Pos)     /*!< 0x00000002 */
#define DDRCTRL_DFIUPD0_DFI_T_CTRLUP_MIN_2       (0x4U << DDRCTRL_DFIUPD0_DFI_T_CTRLUP_MIN_Pos)     /*!< 0x00000004 */
#define DDRCTRL_DFIUPD0_DFI_T_CTRLUP_MIN_3       (0x8U << DDRCTRL_DFIUPD0_DFI_T_CTRLUP_MIN_Pos)     /*!< 0x00000008 */
#define DDRCTRL_DFIUPD0_DFI_T_CTRLUP_MIN_4       (0x10U << DDRCTRL_DFIUPD0_DFI_T_CTRLUP_MIN_Pos)    /*!< 0x00000010 */
#define DDRCTRL_DFIUPD0_DFI_T_CTRLUP_MIN_5       (0x20U << DDRCTRL_DFIUPD0_DFI_T_CTRLUP_MIN_Pos)    /*!< 0x00000020 */
#define DDRCTRL_DFIUPD0_DFI_T_CTRLUP_MIN_6       (0x40U << DDRCTRL_DFIUPD0_DFI_T_CTRLUP_MIN_Pos)    /*!< 0x00000040 */
#define DDRCTRL_DFIUPD0_DFI_T_CTRLUP_MIN_7       (0x80U << DDRCTRL_DFIUPD0_DFI_T_CTRLUP_MIN_Pos)    /*!< 0x00000080 */
#define DDRCTRL_DFIUPD0_DFI_T_CTRLUP_MIN_8       (0x100U << DDRCTRL_DFIUPD0_DFI_T_CTRLUP_MIN_Pos)   /*!< 0x00000100 */
#define DDRCTRL_DFIUPD0_DFI_T_CTRLUP_MIN_9       (0x200U << DDRCTRL_DFIUPD0_DFI_T_CTRLUP_MIN_Pos)   /*!< 0x00000200 */
#define DDRCTRL_DFIUPD0_DFI_T_CTRLUP_MAX_Pos     (16U)
#define DDRCTRL_DFIUPD0_DFI_T_CTRLUP_MAX_Msk     (0x3FFU << DDRCTRL_DFIUPD0_DFI_T_CTRLUP_MAX_Pos)   /*!< 0x03FF0000 */
#define DDRCTRL_DFIUPD0_DFI_T_CTRLUP_MAX         DDRCTRL_DFIUPD0_DFI_T_CTRLUP_MAX_Msk               /*!< Specifies the maximum number of DFI clock cycles that the dfi_ctrlupd_req signal can assert. Lowest value to assign to this variable is 0x40. */
#define DDRCTRL_DFIUPD0_DFI_T_CTRLUP_MAX_0       (0x1U << DDRCTRL_DFIUPD0_DFI_T_CTRLUP_MAX_Pos)     /*!< 0x00010000 */
#define DDRCTRL_DFIUPD0_DFI_T_CTRLUP_MAX_1       (0x2U << DDRCTRL_DFIUPD0_DFI_T_CTRLUP_MAX_Pos)     /*!< 0x00020000 */
#define DDRCTRL_DFIUPD0_DFI_T_CTRLUP_MAX_2       (0x4U << DDRCTRL_DFIUPD0_DFI_T_CTRLUP_MAX_Pos)     /*!< 0x00040000 */
#define DDRCTRL_DFIUPD0_DFI_T_CTRLUP_MAX_3       (0x8U << DDRCTRL_DFIUPD0_DFI_T_CTRLUP_MAX_Pos)     /*!< 0x00080000 */
#define DDRCTRL_DFIUPD0_DFI_T_CTRLUP_MAX_4       (0x10U << DDRCTRL_DFIUPD0_DFI_T_CTRLUP_MAX_Pos)    /*!< 0x00100000 */
#define DDRCTRL_DFIUPD0_DFI_T_CTRLUP_MAX_5       (0x20U << DDRCTRL_DFIUPD0_DFI_T_CTRLUP_MAX_Pos)    /*!< 0x00200000 */
#define DDRCTRL_DFIUPD0_DFI_T_CTRLUP_MAX_6       (0x40U << DDRCTRL_DFIUPD0_DFI_T_CTRLUP_MAX_Pos)    /*!< 0x00400000 */
#define DDRCTRL_DFIUPD0_DFI_T_CTRLUP_MAX_7       (0x80U << DDRCTRL_DFIUPD0_DFI_T_CTRLUP_MAX_Pos)    /*!< 0x00800000 */
#define DDRCTRL_DFIUPD0_DFI_T_CTRLUP_MAX_8       (0x100U << DDRCTRL_DFIUPD0_DFI_T_CTRLUP_MAX_Pos)   /*!< 0x01000000 */
#define DDRCTRL_DFIUPD0_DFI_T_CTRLUP_MAX_9       (0x200U << DDRCTRL_DFIUPD0_DFI_T_CTRLUP_MAX_Pos)   /*!< 0x02000000 */
#define DDRCTRL_DFIUPD0_CTRLUPD_PRE_SRX_Pos      (29U)
#define DDRCTRL_DFIUPD0_CTRLUPD_PRE_SRX_Msk      (0x1U << DDRCTRL_DFIUPD0_CTRLUPD_PRE_SRX_Pos)      /*!< 0x20000000 */
#define DDRCTRL_DFIUPD0_CTRLUPD_PRE_SRX          DDRCTRL_DFIUPD0_CTRLUPD_PRE_SRX_Msk                /*!< Selects dfi_ctrlupd_req requirements at SRX: */
#define DDRCTRL_DFIUPD0_DIS_AUTO_CTRLUPD_SRX_Pos (30U)
#define DDRCTRL_DFIUPD0_DIS_AUTO_CTRLUPD_SRX_Msk (0x1U << DDRCTRL_DFIUPD0_DIS_AUTO_CTRLUPD_SRX_Pos) /*!< 0x40000000 */
#define DDRCTRL_DFIUPD0_DIS_AUTO_CTRLUPD_SRX     DDRCTRL_DFIUPD0_DIS_AUTO_CTRLUPD_SRX_Msk           /*!< When \q1\q, disable the automatic dfi_ctrlupd_req generation by the DDRCTRL at self-refresh exit. */
#define DDRCTRL_DFIUPD0_DIS_AUTO_CTRLUPD_Pos     (31U)
#define DDRCTRL_DFIUPD0_DIS_AUTO_CTRLUPD_Msk     (0x1U << DDRCTRL_DFIUPD0_DIS_AUTO_CTRLUPD_Pos)     /*!< 0x80000000 */
#define DDRCTRL_DFIUPD0_DIS_AUTO_CTRLUPD         DDRCTRL_DFIUPD0_DIS_AUTO_CTRLUPD_Msk               /*!< When \q1\q, disable the automatic dfi_ctrlupd_req generation by the DDRCTRL. The core must issue the dfi_ctrlupd_req signal using register DBGCMD.ctrlupd. */

/***************  Bit definition for DDRCTRL_DFIUPD1 register  ****************/
#define DDRCTRL_DFIUPD1_DFI_T_CTRLUPD_INTERVAL_MAX_X1024_Pos (0U)
#define DDRCTRL_DFIUPD1_DFI_T_CTRLUPD_INTERVAL_MAX_X1024_Msk (0xFFU << DDRCTRL_DFIUPD1_DFI_T_CTRLUPD_INTERVAL_MAX_X1024_Pos) /*!< 0x000000FF */
#define DDRCTRL_DFIUPD1_DFI_T_CTRLUPD_INTERVAL_MAX_X1024     DDRCTRL_DFIUPD1_DFI_T_CTRLUPD_INTERVAL_MAX_X1024_Msk            /*!< This is the maximum amount of time between DDRCTRL initiated DFI update requests. This timer resets with each update request; when the timer expires dfi_ctrlupd_req is sent and traffic is blocked until the dfi_ctrlupd_ackx is received. PHY can use this idle time to recalibrate the delay lines to the DLLs. The DFI controller update is also used to reset PHY FIFO pointers in case of data capture errors. Updates are required to maintain calibration over PVT, but frequent updates may impact performance. Minimum allowed value for this field is 1. */
#define DDRCTRL_DFIUPD1_DFI_T_CTRLUPD_INTERVAL_MAX_X1024_0   (0x1U << DDRCTRL_DFIUPD1_DFI_T_CTRLUPD_INTERVAL_MAX_X1024_Pos)  /*!< 0x00000001 */
#define DDRCTRL_DFIUPD1_DFI_T_CTRLUPD_INTERVAL_MAX_X1024_1   (0x2U << DDRCTRL_DFIUPD1_DFI_T_CTRLUPD_INTERVAL_MAX_X1024_Pos)  /*!< 0x00000002 */
#define DDRCTRL_DFIUPD1_DFI_T_CTRLUPD_INTERVAL_MAX_X1024_2   (0x4U << DDRCTRL_DFIUPD1_DFI_T_CTRLUPD_INTERVAL_MAX_X1024_Pos)  /*!< 0x00000004 */
#define DDRCTRL_DFIUPD1_DFI_T_CTRLUPD_INTERVAL_MAX_X1024_3   (0x8U << DDRCTRL_DFIUPD1_DFI_T_CTRLUPD_INTERVAL_MAX_X1024_Pos)  /*!< 0x00000008 */
#define DDRCTRL_DFIUPD1_DFI_T_CTRLUPD_INTERVAL_MAX_X1024_4   (0x10U << DDRCTRL_DFIUPD1_DFI_T_CTRLUPD_INTERVAL_MAX_X1024_Pos) /*!< 0x00000010 */
#define DDRCTRL_DFIUPD1_DFI_T_CTRLUPD_INTERVAL_MAX_X1024_5   (0x20U << DDRCTRL_DFIUPD1_DFI_T_CTRLUPD_INTERVAL_MAX_X1024_Pos) /*!< 0x00000020 */
#define DDRCTRL_DFIUPD1_DFI_T_CTRLUPD_INTERVAL_MAX_X1024_6   (0x40U << DDRCTRL_DFIUPD1_DFI_T_CTRLUPD_INTERVAL_MAX_X1024_Pos) /*!< 0x00000040 */
#define DDRCTRL_DFIUPD1_DFI_T_CTRLUPD_INTERVAL_MAX_X1024_7   (0x80U << DDRCTRL_DFIUPD1_DFI_T_CTRLUPD_INTERVAL_MAX_X1024_Pos) /*!< 0x00000080 */
#define DDRCTRL_DFIUPD1_DFI_T_CTRLUPD_INTERVAL_MIN_X1024_Pos (16U)
#define DDRCTRL_DFIUPD1_DFI_T_CTRLUPD_INTERVAL_MIN_X1024_Msk (0xFFU << DDRCTRL_DFIUPD1_DFI_T_CTRLUPD_INTERVAL_MIN_X1024_Pos) /*!< 0x00FF0000 */
#define DDRCTRL_DFIUPD1_DFI_T_CTRLUPD_INTERVAL_MIN_X1024     DDRCTRL_DFIUPD1_DFI_T_CTRLUPD_INTERVAL_MIN_X1024_Msk            /*!< This is the minimum amount of time between DDRCTRL initiated DFI update requests (which is executed whenever the DDRCTRL is idle). Set this number higher to reduce the frequency of update requests, which can have a small impact on the latency of the first read request when the DDRCTRL is idle. Minimum allowed value for this field is 1. */
#define DDRCTRL_DFIUPD1_DFI_T_CTRLUPD_INTERVAL_MIN_X1024_0   (0x1U << DDRCTRL_DFIUPD1_DFI_T_CTRLUPD_INTERVAL_MIN_X1024_Pos)  /*!< 0x00010000 */
#define DDRCTRL_DFIUPD1_DFI_T_CTRLUPD_INTERVAL_MIN_X1024_1   (0x2U << DDRCTRL_DFIUPD1_DFI_T_CTRLUPD_INTERVAL_MIN_X1024_Pos)  /*!< 0x00020000 */
#define DDRCTRL_DFIUPD1_DFI_T_CTRLUPD_INTERVAL_MIN_X1024_2   (0x4U << DDRCTRL_DFIUPD1_DFI_T_CTRLUPD_INTERVAL_MIN_X1024_Pos)  /*!< 0x00040000 */
#define DDRCTRL_DFIUPD1_DFI_T_CTRLUPD_INTERVAL_MIN_X1024_3   (0x8U << DDRCTRL_DFIUPD1_DFI_T_CTRLUPD_INTERVAL_MIN_X1024_Pos)  /*!< 0x00080000 */
#define DDRCTRL_DFIUPD1_DFI_T_CTRLUPD_INTERVAL_MIN_X1024_4   (0x10U << DDRCTRL_DFIUPD1_DFI_T_CTRLUPD_INTERVAL_MIN_X1024_Pos) /*!< 0x00100000 */
#define DDRCTRL_DFIUPD1_DFI_T_CTRLUPD_INTERVAL_MIN_X1024_5   (0x20U << DDRCTRL_DFIUPD1_DFI_T_CTRLUPD_INTERVAL_MIN_X1024_Pos) /*!< 0x00200000 */
#define DDRCTRL_DFIUPD1_DFI_T_CTRLUPD_INTERVAL_MIN_X1024_6   (0x40U << DDRCTRL_DFIUPD1_DFI_T_CTRLUPD_INTERVAL_MIN_X1024_Pos) /*!< 0x00400000 */
#define DDRCTRL_DFIUPD1_DFI_T_CTRLUPD_INTERVAL_MIN_X1024_7   (0x80U << DDRCTRL_DFIUPD1_DFI_T_CTRLUPD_INTERVAL_MIN_X1024_Pos) /*!< 0x00800000 */

/***************  Bit definition for DDRCTRL_DFIUPD2 register  ****************/
#define DDRCTRL_DFIUPD2_DFI_PHYUPD_EN_Pos (31U)
#define DDRCTRL_DFIUPD2_DFI_PHYUPD_EN_Msk (0x1U << DDRCTRL_DFIUPD2_DFI_PHYUPD_EN_Pos) /*!< 0x80000000 */
#define DDRCTRL_DFIUPD2_DFI_PHYUPD_EN     DDRCTRL_DFIUPD2_DFI_PHYUPD_EN_Msk           /*!< Enables the support for acknowledging PHY-initiated updates: */

/***************  Bit definition for DDRCTRL_DFIMISC register  ****************/
#define DDRCTRL_DFIMISC_DFI_INIT_COMPLETE_EN_Pos (0U)
#define DDRCTRL_DFIMISC_DFI_INIT_COMPLETE_EN_Msk (0x1U << DDRCTRL_DFIMISC_DFI_INIT_COMPLETE_EN_Pos) /*!< 0x00000001 */
#define DDRCTRL_DFIMISC_DFI_INIT_COMPLETE_EN     DDRCTRL_DFIMISC_DFI_INIT_COMPLETE_EN_Msk           /*!< PHY initialization complete enable signal. */
#define DDRCTRL_DFIMISC_CTL_IDLE_EN_Pos          (4U)
#define DDRCTRL_DFIMISC_CTL_IDLE_EN_Msk          (0x1U << DDRCTRL_DFIMISC_CTL_IDLE_EN_Pos)          /*!< 0x00000010 */
#define DDRCTRL_DFIMISC_CTL_IDLE_EN              DDRCTRL_DFIMISC_CTL_IDLE_EN_Msk                    /*!< Enables support of ctl_idle signal */
#define DDRCTRL_DFIMISC_DFI_INIT_START_Pos       (5U)
#define DDRCTRL_DFIMISC_DFI_INIT_START_Msk       (0x1U << DDRCTRL_DFIMISC_DFI_INIT_START_Pos)       /*!< 0x00000020 */
#define DDRCTRL_DFIMISC_DFI_INIT_START           DDRCTRL_DFIMISC_DFI_INIT_START_Msk                 /*!< PHY init start request signal.When asserted it triggers the PHY init start request */
#define DDRCTRL_DFIMISC_DFI_FREQUENCY_Pos        (8U)
#define DDRCTRL_DFIMISC_DFI_FREQUENCY_Msk        (0x1FU << DDRCTRL_DFIMISC_DFI_FREQUENCY_Pos)       /*!< 0x00001F00 */
#define DDRCTRL_DFIMISC_DFI_FREQUENCY            DDRCTRL_DFIMISC_DFI_FREQUENCY_Msk                  /*!< Indicates the operating frequency of the system. The number of supported frequencies and the mapping of signal values to clock frequencies are defined by the PHY. */
#define DDRCTRL_DFIMISC_DFI_FREQUENCY_0          (0x1U << DDRCTRL_DFIMISC_DFI_FREQUENCY_Pos)        /*!< 0x00000100 */
#define DDRCTRL_DFIMISC_DFI_FREQUENCY_1          (0x2U << DDRCTRL_DFIMISC_DFI_FREQUENCY_Pos)        /*!< 0x00000200 */
#define DDRCTRL_DFIMISC_DFI_FREQUENCY_2          (0x4U << DDRCTRL_DFIMISC_DFI_FREQUENCY_Pos)        /*!< 0x00000400 */
#define DDRCTRL_DFIMISC_DFI_FREQUENCY_3          (0x8U << DDRCTRL_DFIMISC_DFI_FREQUENCY_Pos)        /*!< 0x00000800 */
#define DDRCTRL_DFIMISC_DFI_FREQUENCY_4          (0x10U << DDRCTRL_DFIMISC_DFI_FREQUENCY_Pos)       /*!< 0x00001000 */

/***************  Bit definition for DDRCTRL_DFISTAT register  ****************/
#define DDRCTRL_DFISTAT_DFI_INIT_COMPLETE_Pos (0U)
#define DDRCTRL_DFISTAT_DFI_INIT_COMPLETE_Msk (0x1U << DDRCTRL_DFISTAT_DFI_INIT_COMPLETE_Pos) /*!< 0x00000001 */
#define DDRCTRL_DFISTAT_DFI_INIT_COMPLETE     DDRCTRL_DFISTAT_DFI_INIT_COMPLETE_Msk           /*!< The status flag register which announces when the DFI initialization has been completed. The DFI INIT triggered by dfi_init_start signal and then the dfi_init_complete flag is polled to know when the initialization is done. */
#define DDRCTRL_DFISTAT_DFI_LP_ACK_Pos        (1U)
#define DDRCTRL_DFISTAT_DFI_LP_ACK_Msk        (0x1U << DDRCTRL_DFISTAT_DFI_LP_ACK_Pos)        /*!< 0x00000002 */
#define DDRCTRL_DFISTAT_DFI_LP_ACK            DDRCTRL_DFISTAT_DFI_LP_ACK_Msk                  /*!< Stores the value of the dfi_lp_ack input to the controller. */

/**************  Bit definition for DDRCTRL_DFIPHYMSTR register  **************/
#define DDRCTRL_DFIPHYMSTR_DFI_PHYMSTR_EN_Pos (0U)
#define DDRCTRL_DFIPHYMSTR_DFI_PHYMSTR_EN_Msk (0x1U << DDRCTRL_DFIPHYMSTR_DFI_PHYMSTR_EN_Pos) /*!< 0x00000001 */
#define DDRCTRL_DFIPHYMSTR_DFI_PHYMSTR_EN     DDRCTRL_DFIPHYMSTR_DFI_PHYMSTR_EN_Msk           /*!< Enables the PHY Master Interface: */

/***************  Bit definition for DDRCTRL_ADDRMAP1 register  ***************/
#define DDRCTRL_ADDRMAP1_ADDRMAP_BANK_B0_Pos (0U)
#define DDRCTRL_ADDRMAP1_ADDRMAP_BANK_B0_Msk (0x3FU << DDRCTRL_ADDRMAP1_ADDRMAP_BANK_B0_Pos) /*!< 0x0000003F */
#define DDRCTRL_ADDRMAP1_ADDRMAP_BANK_B0     DDRCTRL_ADDRMAP1_ADDRMAP_BANK_B0_Msk            /*!< Selects the HIF address bits used as bank address bit 0. */
#define DDRCTRL_ADDRMAP1_ADDRMAP_BANK_B0_0   (0x1U << DDRCTRL_ADDRMAP1_ADDRMAP_BANK_B0_Pos)  /*!< 0x00000001 */
#define DDRCTRL_ADDRMAP1_ADDRMAP_BANK_B0_1   (0x2U << DDRCTRL_ADDRMAP1_ADDRMAP_BANK_B0_Pos)  /*!< 0x00000002 */
#define DDRCTRL_ADDRMAP1_ADDRMAP_BANK_B0_2   (0x4U << DDRCTRL_ADDRMAP1_ADDRMAP_BANK_B0_Pos)  /*!< 0x00000004 */
#define DDRCTRL_ADDRMAP1_ADDRMAP_BANK_B0_3   (0x8U << DDRCTRL_ADDRMAP1_ADDRMAP_BANK_B0_Pos)  /*!< 0x00000008 */
#define DDRCTRL_ADDRMAP1_ADDRMAP_BANK_B0_4   (0x10U << DDRCTRL_ADDRMAP1_ADDRMAP_BANK_B0_Pos) /*!< 0x00000010 */
#define DDRCTRL_ADDRMAP1_ADDRMAP_BANK_B0_5   (0x20U << DDRCTRL_ADDRMAP1_ADDRMAP_BANK_B0_Pos) /*!< 0x00000020 */
#define DDRCTRL_ADDRMAP1_ADDRMAP_BANK_B1_Pos (8U)
#define DDRCTRL_ADDRMAP1_ADDRMAP_BANK_B1_Msk (0x3FU << DDRCTRL_ADDRMAP1_ADDRMAP_BANK_B1_Pos) /*!< 0x00003F00 */
#define DDRCTRL_ADDRMAP1_ADDRMAP_BANK_B1     DDRCTRL_ADDRMAP1_ADDRMAP_BANK_B1_Msk            /*!< Selects the HIF address bits used as bank address bit 1. */
#define DDRCTRL_ADDRMAP1_ADDRMAP_BANK_B1_0   (0x1U << DDRCTRL_ADDRMAP1_ADDRMAP_BANK_B1_Pos)  /*!< 0x00000100 */
#define DDRCTRL_ADDRMAP1_ADDRMAP_BANK_B1_1   (0x2U << DDRCTRL_ADDRMAP1_ADDRMAP_BANK_B1_Pos)  /*!< 0x00000200 */
#define DDRCTRL_ADDRMAP1_ADDRMAP_BANK_B1_2   (0x4U << DDRCTRL_ADDRMAP1_ADDRMAP_BANK_B1_Pos)  /*!< 0x00000400 */
#define DDRCTRL_ADDRMAP1_ADDRMAP_BANK_B1_3   (0x8U << DDRCTRL_ADDRMAP1_ADDRMAP_BANK_B1_Pos)  /*!< 0x00000800 */
#define DDRCTRL_ADDRMAP1_ADDRMAP_BANK_B1_4   (0x10U << DDRCTRL_ADDRMAP1_ADDRMAP_BANK_B1_Pos) /*!< 0x00001000 */
#define DDRCTRL_ADDRMAP1_ADDRMAP_BANK_B1_5   (0x20U << DDRCTRL_ADDRMAP1_ADDRMAP_BANK_B1_Pos) /*!< 0x00002000 */
#define DDRCTRL_ADDRMAP1_ADDRMAP_BANK_B2_Pos (16U)
#define DDRCTRL_ADDRMAP1_ADDRMAP_BANK_B2_Msk (0x3FU << DDRCTRL_ADDRMAP1_ADDRMAP_BANK_B2_Pos) /*!< 0x003F0000 */
#define DDRCTRL_ADDRMAP1_ADDRMAP_BANK_B2     DDRCTRL_ADDRMAP1_ADDRMAP_BANK_B2_Msk            /*!< Selects the HIF address bit used as bank address bit 2. */
#define DDRCTRL_ADDRMAP1_ADDRMAP_BANK_B2_0   (0x1U << DDRCTRL_ADDRMAP1_ADDRMAP_BANK_B2_Pos)  /*!< 0x00010000 */
#define DDRCTRL_ADDRMAP1_ADDRMAP_BANK_B2_1   (0x2U << DDRCTRL_ADDRMAP1_ADDRMAP_BANK_B2_Pos)  /*!< 0x00020000 */
#define DDRCTRL_ADDRMAP1_ADDRMAP_BANK_B2_2   (0x4U << DDRCTRL_ADDRMAP1_ADDRMAP_BANK_B2_Pos)  /*!< 0x00040000 */
#define DDRCTRL_ADDRMAP1_ADDRMAP_BANK_B2_3   (0x8U << DDRCTRL_ADDRMAP1_ADDRMAP_BANK_B2_Pos)  /*!< 0x00080000 */
#define DDRCTRL_ADDRMAP1_ADDRMAP_BANK_B2_4   (0x10U << DDRCTRL_ADDRMAP1_ADDRMAP_BANK_B2_Pos) /*!< 0x00100000 */
#define DDRCTRL_ADDRMAP1_ADDRMAP_BANK_B2_5   (0x20U << DDRCTRL_ADDRMAP1_ADDRMAP_BANK_B2_Pos) /*!< 0x00200000 */

/***************  Bit definition for DDRCTRL_ADDRMAP2 register  ***************/
#define DDRCTRL_ADDRMAP2_ADDRMAP_COL_B2_Pos (0U)
#define DDRCTRL_ADDRMAP2_ADDRMAP_COL_B2_Msk (0xFU << DDRCTRL_ADDRMAP2_ADDRMAP_COL_B2_Pos) /*!< 0x0000000F */
#define DDRCTRL_ADDRMAP2_ADDRMAP_COL_B2     DDRCTRL_ADDRMAP2_ADDRMAP_COL_B2_Msk           /*!< - Full bus width mode: Selects the HIF address bit used as column address bit 2. */
#define DDRCTRL_ADDRMAP2_ADDRMAP_COL_B2_0   (0x1U << DDRCTRL_ADDRMAP2_ADDRMAP_COL_B2_Pos) /*!< 0x00000001 */
#define DDRCTRL_ADDRMAP2_ADDRMAP_COL_B2_1   (0x2U << DDRCTRL_ADDRMAP2_ADDRMAP_COL_B2_Pos) /*!< 0x00000002 */
#define DDRCTRL_ADDRMAP2_ADDRMAP_COL_B2_2   (0x4U << DDRCTRL_ADDRMAP2_ADDRMAP_COL_B2_Pos) /*!< 0x00000004 */
#define DDRCTRL_ADDRMAP2_ADDRMAP_COL_B2_3   (0x8U << DDRCTRL_ADDRMAP2_ADDRMAP_COL_B2_Pos) /*!< 0x00000008 */
#define DDRCTRL_ADDRMAP2_ADDRMAP_COL_B3_Pos (8U)
#define DDRCTRL_ADDRMAP2_ADDRMAP_COL_B3_Msk (0xFU << DDRCTRL_ADDRMAP2_ADDRMAP_COL_B3_Pos) /*!< 0x00000F00 */
#define DDRCTRL_ADDRMAP2_ADDRMAP_COL_B3     DDRCTRL_ADDRMAP2_ADDRMAP_COL_B3_Msk           /*!< - Full bus width mode: Selects the HIF address bit used as column address bit 3. */
#define DDRCTRL_ADDRMAP2_ADDRMAP_COL_B3_0   (0x1U << DDRCTRL_ADDRMAP2_ADDRMAP_COL_B3_Pos) /*!< 0x00000100 */
#define DDRCTRL_ADDRMAP2_ADDRMAP_COL_B3_1   (0x2U << DDRCTRL_ADDRMAP2_ADDRMAP_COL_B3_Pos) /*!< 0x00000200 */
#define DDRCTRL_ADDRMAP2_ADDRMAP_COL_B3_2   (0x4U << DDRCTRL_ADDRMAP2_ADDRMAP_COL_B3_Pos) /*!< 0x00000400 */
#define DDRCTRL_ADDRMAP2_ADDRMAP_COL_B3_3   (0x8U << DDRCTRL_ADDRMAP2_ADDRMAP_COL_B3_Pos) /*!< 0x00000800 */
#define DDRCTRL_ADDRMAP2_ADDRMAP_COL_B4_Pos (16U)
#define DDRCTRL_ADDRMAP2_ADDRMAP_COL_B4_Msk (0xFU << DDRCTRL_ADDRMAP2_ADDRMAP_COL_B4_Pos) /*!< 0x000F0000 */
#define DDRCTRL_ADDRMAP2_ADDRMAP_COL_B4     DDRCTRL_ADDRMAP2_ADDRMAP_COL_B4_Msk           /*!< - Full bus width mode: Selects the HIF address bit used as column address bit 4. */
#define DDRCTRL_ADDRMAP2_ADDRMAP_COL_B4_0   (0x1U << DDRCTRL_ADDRMAP2_ADDRMAP_COL_B4_Pos) /*!< 0x00010000 */
#define DDRCTRL_ADDRMAP2_ADDRMAP_COL_B4_1   (0x2U << DDRCTRL_ADDRMAP2_ADDRMAP_COL_B4_Pos) /*!< 0x00020000 */
#define DDRCTRL_ADDRMAP2_ADDRMAP_COL_B4_2   (0x4U << DDRCTRL_ADDRMAP2_ADDRMAP_COL_B4_Pos) /*!< 0x00040000 */
#define DDRCTRL_ADDRMAP2_ADDRMAP_COL_B4_3   (0x8U << DDRCTRL_ADDRMAP2_ADDRMAP_COL_B4_Pos) /*!< 0x00080000 */
#define DDRCTRL_ADDRMAP2_ADDRMAP_COL_B5_Pos (24U)
#define DDRCTRL_ADDRMAP2_ADDRMAP_COL_B5_Msk (0xFU << DDRCTRL_ADDRMAP2_ADDRMAP_COL_B5_Pos) /*!< 0x0F000000 */
#define DDRCTRL_ADDRMAP2_ADDRMAP_COL_B5     DDRCTRL_ADDRMAP2_ADDRMAP_COL_B5_Msk           /*!< - Full bus width mode: Selects the HIF address bit used as column address bit 5. */
#define DDRCTRL_ADDRMAP2_ADDRMAP_COL_B5_0   (0x1U << DDRCTRL_ADDRMAP2_ADDRMAP_COL_B5_Pos) /*!< 0x01000000 */
#define DDRCTRL_ADDRMAP2_ADDRMAP_COL_B5_1   (0x2U << DDRCTRL_ADDRMAP2_ADDRMAP_COL_B5_Pos) /*!< 0x02000000 */
#define DDRCTRL_ADDRMAP2_ADDRMAP_COL_B5_2   (0x4U << DDRCTRL_ADDRMAP2_ADDRMAP_COL_B5_Pos) /*!< 0x04000000 */
#define DDRCTRL_ADDRMAP2_ADDRMAP_COL_B5_3   (0x8U << DDRCTRL_ADDRMAP2_ADDRMAP_COL_B5_Pos) /*!< 0x08000000 */

/***************  Bit definition for DDRCTRL_ADDRMAP3 register  ***************/
#define DDRCTRL_ADDRMAP3_ADDRMAP_COL_B6_Pos (0U)
#define DDRCTRL_ADDRMAP3_ADDRMAP_COL_B6_Msk (0xFU << DDRCTRL_ADDRMAP3_ADDRMAP_COL_B6_Pos)  /*!< 0x0000000F */
#define DDRCTRL_ADDRMAP3_ADDRMAP_COL_B6     DDRCTRL_ADDRMAP3_ADDRMAP_COL_B6_Msk            /*!< - Full bus width mode: Selects the HIF address bit used as column address bit 6. */
#define DDRCTRL_ADDRMAP3_ADDRMAP_COL_B6_0   (0x1U << DDRCTRL_ADDRMAP3_ADDRMAP_COL_B6_Pos)  /*!< 0x00000001 */
#define DDRCTRL_ADDRMAP3_ADDRMAP_COL_B6_1   (0x2U << DDRCTRL_ADDRMAP3_ADDRMAP_COL_B6_Pos)  /*!< 0x00000002 */
#define DDRCTRL_ADDRMAP3_ADDRMAP_COL_B6_2   (0x4U << DDRCTRL_ADDRMAP3_ADDRMAP_COL_B6_Pos)  /*!< 0x00000004 */
#define DDRCTRL_ADDRMAP3_ADDRMAP_COL_B6_3   (0x8U << DDRCTRL_ADDRMAP3_ADDRMAP_COL_B6_Pos)  /*!< 0x00000008 */
#define DDRCTRL_ADDRMAP3_ADDRMAP_COL_B7_Pos (8U)
#define DDRCTRL_ADDRMAP3_ADDRMAP_COL_B7_Msk (0x1FU << DDRCTRL_ADDRMAP3_ADDRMAP_COL_B7_Pos) /*!< 0x00001F00 */
#define DDRCTRL_ADDRMAP3_ADDRMAP_COL_B7     DDRCTRL_ADDRMAP3_ADDRMAP_COL_B7_Msk            /*!< - Full bus width mode: Selects the HIF address bit used as column address bit 7. */
#define DDRCTRL_ADDRMAP3_ADDRMAP_COL_B7_0   (0x1U << DDRCTRL_ADDRMAP3_ADDRMAP_COL_B7_Pos)  /*!< 0x00000100 */
#define DDRCTRL_ADDRMAP3_ADDRMAP_COL_B7_1   (0x2U << DDRCTRL_ADDRMAP3_ADDRMAP_COL_B7_Pos)  /*!< 0x00000200 */
#define DDRCTRL_ADDRMAP3_ADDRMAP_COL_B7_2   (0x4U << DDRCTRL_ADDRMAP3_ADDRMAP_COL_B7_Pos)  /*!< 0x00000400 */
#define DDRCTRL_ADDRMAP3_ADDRMAP_COL_B7_3   (0x8U << DDRCTRL_ADDRMAP3_ADDRMAP_COL_B7_Pos)  /*!< 0x00000800 */
#define DDRCTRL_ADDRMAP3_ADDRMAP_COL_B7_4   (0x10U << DDRCTRL_ADDRMAP3_ADDRMAP_COL_B7_Pos) /*!< 0x00001000 */
#define DDRCTRL_ADDRMAP3_ADDRMAP_COL_B8_Pos (16U)
#define DDRCTRL_ADDRMAP3_ADDRMAP_COL_B8_Msk (0x1FU << DDRCTRL_ADDRMAP3_ADDRMAP_COL_B8_Pos) /*!< 0x001F0000 */
#define DDRCTRL_ADDRMAP3_ADDRMAP_COL_B8     DDRCTRL_ADDRMAP3_ADDRMAP_COL_B8_Msk            /*!< - Full bus width mode: Selects the HIF address bit used as column address bit 8. */
#define DDRCTRL_ADDRMAP3_ADDRMAP_COL_B8_0   (0x1U << DDRCTRL_ADDRMAP3_ADDRMAP_COL_B8_Pos)  /*!< 0x00010000 */
#define DDRCTRL_ADDRMAP3_ADDRMAP_COL_B8_1   (0x2U << DDRCTRL_ADDRMAP3_ADDRMAP_COL_B8_Pos)  /*!< 0x00020000 */
#define DDRCTRL_ADDRMAP3_ADDRMAP_COL_B8_2   (0x4U << DDRCTRL_ADDRMAP3_ADDRMAP_COL_B8_Pos)  /*!< 0x00040000 */
#define DDRCTRL_ADDRMAP3_ADDRMAP_COL_B8_3   (0x8U << DDRCTRL_ADDRMAP3_ADDRMAP_COL_B8_Pos)  /*!< 0x00080000 */
#define DDRCTRL_ADDRMAP3_ADDRMAP_COL_B8_4   (0x10U << DDRCTRL_ADDRMAP3_ADDRMAP_COL_B8_Pos) /*!< 0x00100000 */
#define DDRCTRL_ADDRMAP3_ADDRMAP_COL_B9_Pos (24U)
#define DDRCTRL_ADDRMAP3_ADDRMAP_COL_B9_Msk (0x1FU << DDRCTRL_ADDRMAP3_ADDRMAP_COL_B9_Pos) /*!< 0x1F000000 */
#define DDRCTRL_ADDRMAP3_ADDRMAP_COL_B9     DDRCTRL_ADDRMAP3_ADDRMAP_COL_B9_Msk            /*!< - Full bus width mode: Selects the HIF address bit used as column address bit 9. */
#define DDRCTRL_ADDRMAP3_ADDRMAP_COL_B9_0   (0x1U << DDRCTRL_ADDRMAP3_ADDRMAP_COL_B9_Pos)  /*!< 0x01000000 */
#define DDRCTRL_ADDRMAP3_ADDRMAP_COL_B9_1   (0x2U << DDRCTRL_ADDRMAP3_ADDRMAP_COL_B9_Pos)  /*!< 0x02000000 */
#define DDRCTRL_ADDRMAP3_ADDRMAP_COL_B9_2   (0x4U << DDRCTRL_ADDRMAP3_ADDRMAP_COL_B9_Pos)  /*!< 0x04000000 */
#define DDRCTRL_ADDRMAP3_ADDRMAP_COL_B9_3   (0x8U << DDRCTRL_ADDRMAP3_ADDRMAP_COL_B9_Pos)  /*!< 0x08000000 */
#define DDRCTRL_ADDRMAP3_ADDRMAP_COL_B9_4   (0x10U << DDRCTRL_ADDRMAP3_ADDRMAP_COL_B9_Pos) /*!< 0x10000000 */

/***************  Bit definition for DDRCTRL_ADDRMAP4 register  ***************/
#define DDRCTRL_ADDRMAP4_ADDRMAP_COL_B10_Pos (0U)
#define DDRCTRL_ADDRMAP4_ADDRMAP_COL_B10_Msk (0x1FU << DDRCTRL_ADDRMAP4_ADDRMAP_COL_B10_Pos) /*!< 0x0000001F */
#define DDRCTRL_ADDRMAP4_ADDRMAP_COL_B10     DDRCTRL_ADDRMAP4_ADDRMAP_COL_B10_Msk            /*!< - Full bus width mode: Selects the HIF address bit used as column address bit 11 (10 in LPDDR2/LPDDR3 mode). */
#define DDRCTRL_ADDRMAP4_ADDRMAP_COL_B10_0   (0x1U << DDRCTRL_ADDRMAP4_ADDRMAP_COL_B10_Pos)  /*!< 0x00000001 */
#define DDRCTRL_ADDRMAP4_ADDRMAP_COL_B10_1   (0x2U << DDRCTRL_ADDRMAP4_ADDRMAP_COL_B10_Pos)  /*!< 0x00000002 */
#define DDRCTRL_ADDRMAP4_ADDRMAP_COL_B10_2   (0x4U << DDRCTRL_ADDRMAP4_ADDRMAP_COL_B10_Pos)  /*!< 0x00000004 */
#define DDRCTRL_ADDRMAP4_ADDRMAP_COL_B10_3   (0x8U << DDRCTRL_ADDRMAP4_ADDRMAP_COL_B10_Pos)  /*!< 0x00000008 */
#define DDRCTRL_ADDRMAP4_ADDRMAP_COL_B10_4   (0x10U << DDRCTRL_ADDRMAP4_ADDRMAP_COL_B10_Pos) /*!< 0x00000010 */
#define DDRCTRL_ADDRMAP4_ADDRMAP_COL_B11_Pos (8U)
#define DDRCTRL_ADDRMAP4_ADDRMAP_COL_B11_Msk (0x1FU << DDRCTRL_ADDRMAP4_ADDRMAP_COL_B11_Pos) /*!< 0x00001F00 */
#define DDRCTRL_ADDRMAP4_ADDRMAP_COL_B11     DDRCTRL_ADDRMAP4_ADDRMAP_COL_B11_Msk            /*!< - Full bus width mode: Selects the HIF address bit used as column address bit 13 (11 in LPDDR2/LPDDR3 mode). */
#define DDRCTRL_ADDRMAP4_ADDRMAP_COL_B11_0   (0x1U << DDRCTRL_ADDRMAP4_ADDRMAP_COL_B11_Pos)  /*!< 0x00000100 */
#define DDRCTRL_ADDRMAP4_ADDRMAP_COL_B11_1   (0x2U << DDRCTRL_ADDRMAP4_ADDRMAP_COL_B11_Pos)  /*!< 0x00000200 */
#define DDRCTRL_ADDRMAP4_ADDRMAP_COL_B11_2   (0x4U << DDRCTRL_ADDRMAP4_ADDRMAP_COL_B11_Pos)  /*!< 0x00000400 */
#define DDRCTRL_ADDRMAP4_ADDRMAP_COL_B11_3   (0x8U << DDRCTRL_ADDRMAP4_ADDRMAP_COL_B11_Pos)  /*!< 0x00000800 */
#define DDRCTRL_ADDRMAP4_ADDRMAP_COL_B11_4   (0x10U << DDRCTRL_ADDRMAP4_ADDRMAP_COL_B11_Pos) /*!< 0x00001000 */

/***************  Bit definition for DDRCTRL_ADDRMAP5 register  ***************/
#define DDRCTRL_ADDRMAP5_ADDRMAP_ROW_B0_Pos    (0U)
#define DDRCTRL_ADDRMAP5_ADDRMAP_ROW_B0_Msk    (0xFU << DDRCTRL_ADDRMAP5_ADDRMAP_ROW_B0_Pos)    /*!< 0x0000000F */
#define DDRCTRL_ADDRMAP5_ADDRMAP_ROW_B0        DDRCTRL_ADDRMAP5_ADDRMAP_ROW_B0_Msk              /*!< Selects the HIF address bits used as row address bit 0. */
#define DDRCTRL_ADDRMAP5_ADDRMAP_ROW_B0_0      (0x1U << DDRCTRL_ADDRMAP5_ADDRMAP_ROW_B0_Pos)    /*!< 0x00000001 */
#define DDRCTRL_ADDRMAP5_ADDRMAP_ROW_B0_1      (0x2U << DDRCTRL_ADDRMAP5_ADDRMAP_ROW_B0_Pos)    /*!< 0x00000002 */
#define DDRCTRL_ADDRMAP5_ADDRMAP_ROW_B0_2      (0x4U << DDRCTRL_ADDRMAP5_ADDRMAP_ROW_B0_Pos)    /*!< 0x00000004 */
#define DDRCTRL_ADDRMAP5_ADDRMAP_ROW_B0_3      (0x8U << DDRCTRL_ADDRMAP5_ADDRMAP_ROW_B0_Pos)    /*!< 0x00000008 */
#define DDRCTRL_ADDRMAP5_ADDRMAP_ROW_B1_Pos    (8U)
#define DDRCTRL_ADDRMAP5_ADDRMAP_ROW_B1_Msk    (0xFU << DDRCTRL_ADDRMAP5_ADDRMAP_ROW_B1_Pos)    /*!< 0x00000F00 */
#define DDRCTRL_ADDRMAP5_ADDRMAP_ROW_B1        DDRCTRL_ADDRMAP5_ADDRMAP_ROW_B1_Msk              /*!< Selects the HIF address bits used as row address bit 1. */
#define DDRCTRL_ADDRMAP5_ADDRMAP_ROW_B1_0      (0x1U << DDRCTRL_ADDRMAP5_ADDRMAP_ROW_B1_Pos)    /*!< 0x00000100 */
#define DDRCTRL_ADDRMAP5_ADDRMAP_ROW_B1_1      (0x2U << DDRCTRL_ADDRMAP5_ADDRMAP_ROW_B1_Pos)    /*!< 0x00000200 */
#define DDRCTRL_ADDRMAP5_ADDRMAP_ROW_B1_2      (0x4U << DDRCTRL_ADDRMAP5_ADDRMAP_ROW_B1_Pos)    /*!< 0x00000400 */
#define DDRCTRL_ADDRMAP5_ADDRMAP_ROW_B1_3      (0x8U << DDRCTRL_ADDRMAP5_ADDRMAP_ROW_B1_Pos)    /*!< 0x00000800 */
#define DDRCTRL_ADDRMAP5_ADDRMAP_ROW_B2_10_Pos (16U)
#define DDRCTRL_ADDRMAP5_ADDRMAP_ROW_B2_10_Msk (0xFU << DDRCTRL_ADDRMAP5_ADDRMAP_ROW_B2_10_Pos) /*!< 0x000F0000 */
#define DDRCTRL_ADDRMAP5_ADDRMAP_ROW_B2_10     DDRCTRL_ADDRMAP5_ADDRMAP_ROW_B2_10_Msk           /*!< Selects the HIF address bits used as row address bits 2 to 10. */
#define DDRCTRL_ADDRMAP5_ADDRMAP_ROW_B2_10_0   (0x1U << DDRCTRL_ADDRMAP5_ADDRMAP_ROW_B2_10_Pos) /*!< 0x00010000 */
#define DDRCTRL_ADDRMAP5_ADDRMAP_ROW_B2_10_1   (0x2U << DDRCTRL_ADDRMAP5_ADDRMAP_ROW_B2_10_Pos) /*!< 0x00020000 */
#define DDRCTRL_ADDRMAP5_ADDRMAP_ROW_B2_10_2   (0x4U << DDRCTRL_ADDRMAP5_ADDRMAP_ROW_B2_10_Pos) /*!< 0x00040000 */
#define DDRCTRL_ADDRMAP5_ADDRMAP_ROW_B2_10_3   (0x8U << DDRCTRL_ADDRMAP5_ADDRMAP_ROW_B2_10_Pos) /*!< 0x00080000 */
#define DDRCTRL_ADDRMAP5_ADDRMAP_ROW_B11_Pos   (24U)
#define DDRCTRL_ADDRMAP5_ADDRMAP_ROW_B11_Msk   (0xFU << DDRCTRL_ADDRMAP5_ADDRMAP_ROW_B11_Pos)   /*!< 0x0F000000 */
#define DDRCTRL_ADDRMAP5_ADDRMAP_ROW_B11       DDRCTRL_ADDRMAP5_ADDRMAP_ROW_B11_Msk             /*!< Selects the HIF address bit used as row address bit 11. */
#define DDRCTRL_ADDRMAP5_ADDRMAP_ROW_B11_0     (0x1U << DDRCTRL_ADDRMAP5_ADDRMAP_ROW_B11_Pos)   /*!< 0x01000000 */
#define DDRCTRL_ADDRMAP5_ADDRMAP_ROW_B11_1     (0x2U << DDRCTRL_ADDRMAP5_ADDRMAP_ROW_B11_Pos)   /*!< 0x02000000 */
#define DDRCTRL_ADDRMAP5_ADDRMAP_ROW_B11_2     (0x4U << DDRCTRL_ADDRMAP5_ADDRMAP_ROW_B11_Pos)   /*!< 0x04000000 */
#define DDRCTRL_ADDRMAP5_ADDRMAP_ROW_B11_3     (0x8U << DDRCTRL_ADDRMAP5_ADDRMAP_ROW_B11_Pos)   /*!< 0x08000000 */

/***************  Bit definition for DDRCTRL_ADDRMAP6 register  ***************/
#define DDRCTRL_ADDRMAP6_ADDRMAP_ROW_B12_Pos (0U)
#define DDRCTRL_ADDRMAP6_ADDRMAP_ROW_B12_Msk (0xFU << DDRCTRL_ADDRMAP6_ADDRMAP_ROW_B12_Pos) /*!< 0x0000000F */
#define DDRCTRL_ADDRMAP6_ADDRMAP_ROW_B12     DDRCTRL_ADDRMAP6_ADDRMAP_ROW_B12_Msk           /*!< Selects the HIF address bit used as row address bit 12. */
#define DDRCTRL_ADDRMAP6_ADDRMAP_ROW_B12_0   (0x1U << DDRCTRL_ADDRMAP6_ADDRMAP_ROW_B12_Pos) /*!< 0x00000001 */
#define DDRCTRL_ADDRMAP6_ADDRMAP_ROW_B12_1   (0x2U << DDRCTRL_ADDRMAP6_ADDRMAP_ROW_B12_Pos) /*!< 0x00000002 */
#define DDRCTRL_ADDRMAP6_ADDRMAP_ROW_B12_2   (0x4U << DDRCTRL_ADDRMAP6_ADDRMAP_ROW_B12_Pos) /*!< 0x00000004 */
#define DDRCTRL_ADDRMAP6_ADDRMAP_ROW_B12_3   (0x8U << DDRCTRL_ADDRMAP6_ADDRMAP_ROW_B12_Pos) /*!< 0x00000008 */
#define DDRCTRL_ADDRMAP6_ADDRMAP_ROW_B13_Pos (8U)
#define DDRCTRL_ADDRMAP6_ADDRMAP_ROW_B13_Msk (0xFU << DDRCTRL_ADDRMAP6_ADDRMAP_ROW_B13_Pos) /*!< 0x00000F00 */
#define DDRCTRL_ADDRMAP6_ADDRMAP_ROW_B13     DDRCTRL_ADDRMAP6_ADDRMAP_ROW_B13_Msk           /*!< Selects the HIF address bit used as row address bit 13. */
#define DDRCTRL_ADDRMAP6_ADDRMAP_ROW_B13_0   (0x1U << DDRCTRL_ADDRMAP6_ADDRMAP_ROW_B13_Pos) /*!< 0x00000100 */
#define DDRCTRL_ADDRMAP6_ADDRMAP_ROW_B13_1   (0x2U << DDRCTRL_ADDRMAP6_ADDRMAP_ROW_B13_Pos) /*!< 0x00000200 */
#define DDRCTRL_ADDRMAP6_ADDRMAP_ROW_B13_2   (0x4U << DDRCTRL_ADDRMAP6_ADDRMAP_ROW_B13_Pos) /*!< 0x00000400 */
#define DDRCTRL_ADDRMAP6_ADDRMAP_ROW_B13_3   (0x8U << DDRCTRL_ADDRMAP6_ADDRMAP_ROW_B13_Pos) /*!< 0x00000800 */
#define DDRCTRL_ADDRMAP6_ADDRMAP_ROW_B14_Pos (16U)
#define DDRCTRL_ADDRMAP6_ADDRMAP_ROW_B14_Msk (0xFU << DDRCTRL_ADDRMAP6_ADDRMAP_ROW_B14_Pos) /*!< 0x000F0000 */
#define DDRCTRL_ADDRMAP6_ADDRMAP_ROW_B14     DDRCTRL_ADDRMAP6_ADDRMAP_ROW_B14_Msk           /*!< Selects the HIF address bit used as row address bit 14. */
#define DDRCTRL_ADDRMAP6_ADDRMAP_ROW_B14_0   (0x1U << DDRCTRL_ADDRMAP6_ADDRMAP_ROW_B14_Pos) /*!< 0x00010000 */
#define DDRCTRL_ADDRMAP6_ADDRMAP_ROW_B14_1   (0x2U << DDRCTRL_ADDRMAP6_ADDRMAP_ROW_B14_Pos) /*!< 0x00020000 */
#define DDRCTRL_ADDRMAP6_ADDRMAP_ROW_B14_2   (0x4U << DDRCTRL_ADDRMAP6_ADDRMAP_ROW_B14_Pos) /*!< 0x00040000 */
#define DDRCTRL_ADDRMAP6_ADDRMAP_ROW_B14_3   (0x8U << DDRCTRL_ADDRMAP6_ADDRMAP_ROW_B14_Pos) /*!< 0x00080000 */
#define DDRCTRL_ADDRMAP6_ADDRMAP_ROW_B15_Pos (24U)
#define DDRCTRL_ADDRMAP6_ADDRMAP_ROW_B15_Msk (0xFU << DDRCTRL_ADDRMAP6_ADDRMAP_ROW_B15_Pos) /*!< 0x0F000000 */
#define DDRCTRL_ADDRMAP6_ADDRMAP_ROW_B15     DDRCTRL_ADDRMAP6_ADDRMAP_ROW_B15_Msk           /*!< Selects the HIF address bit used as row address bit 15. */
#define DDRCTRL_ADDRMAP6_ADDRMAP_ROW_B15_0   (0x1U << DDRCTRL_ADDRMAP6_ADDRMAP_ROW_B15_Pos) /*!< 0x01000000 */
#define DDRCTRL_ADDRMAP6_ADDRMAP_ROW_B15_1   (0x2U << DDRCTRL_ADDRMAP6_ADDRMAP_ROW_B15_Pos) /*!< 0x02000000 */
#define DDRCTRL_ADDRMAP6_ADDRMAP_ROW_B15_2   (0x4U << DDRCTRL_ADDRMAP6_ADDRMAP_ROW_B15_Pos) /*!< 0x04000000 */
#define DDRCTRL_ADDRMAP6_ADDRMAP_ROW_B15_3   (0x8U << DDRCTRL_ADDRMAP6_ADDRMAP_ROW_B15_Pos) /*!< 0x08000000 */
#define DDRCTRL_ADDRMAP6_LPDDR3_6GB_12GB_Pos (31U)
#define DDRCTRL_ADDRMAP6_LPDDR3_6GB_12GB_Msk (0x1U << DDRCTRL_ADDRMAP6_LPDDR3_6GB_12GB_Pos) /*!< 0x80000000 */
#define DDRCTRL_ADDRMAP6_LPDDR3_6GB_12GB     DDRCTRL_ADDRMAP6_LPDDR3_6GB_12GB_Msk           /*!< Set this to 1 if there is an LPDDR3 SDRAM 6Gb or 12Gb device in use. */

/***************  Bit definition for DDRCTRL_ADDRMAP9 register  ***************/
#define DDRCTRL_ADDRMAP9_ADDRMAP_ROW_B2_Pos (0U)
#define DDRCTRL_ADDRMAP9_ADDRMAP_ROW_B2_Msk (0xFU << DDRCTRL_ADDRMAP9_ADDRMAP_ROW_B2_Pos) /*!< 0x0000000F */
#define DDRCTRL_ADDRMAP9_ADDRMAP_ROW_B2     DDRCTRL_ADDRMAP9_ADDRMAP_ROW_B2_Msk           /*!< Selects the HIF address bits used as row address bit 2. */
#define DDRCTRL_ADDRMAP9_ADDRMAP_ROW_B2_0   (0x1U << DDRCTRL_ADDRMAP9_ADDRMAP_ROW_B2_Pos) /*!< 0x00000001 */
#define DDRCTRL_ADDRMAP9_ADDRMAP_ROW_B2_1   (0x2U << DDRCTRL_ADDRMAP9_ADDRMAP_ROW_B2_Pos) /*!< 0x00000002 */
#define DDRCTRL_ADDRMAP9_ADDRMAP_ROW_B2_2   (0x4U << DDRCTRL_ADDRMAP9_ADDRMAP_ROW_B2_Pos) /*!< 0x00000004 */
#define DDRCTRL_ADDRMAP9_ADDRMAP_ROW_B2_3   (0x8U << DDRCTRL_ADDRMAP9_ADDRMAP_ROW_B2_Pos) /*!< 0x00000008 */
#define DDRCTRL_ADDRMAP9_ADDRMAP_ROW_B3_Pos (8U)
#define DDRCTRL_ADDRMAP9_ADDRMAP_ROW_B3_Msk (0xFU << DDRCTRL_ADDRMAP9_ADDRMAP_ROW_B3_Pos) /*!< 0x00000F00 */
#define DDRCTRL_ADDRMAP9_ADDRMAP_ROW_B3     DDRCTRL_ADDRMAP9_ADDRMAP_ROW_B3_Msk           /*!< Selects the HIF address bits used as row address bit 3. */
#define DDRCTRL_ADDRMAP9_ADDRMAP_ROW_B3_0   (0x1U << DDRCTRL_ADDRMAP9_ADDRMAP_ROW_B3_Pos) /*!< 0x00000100 */
#define DDRCTRL_ADDRMAP9_ADDRMAP_ROW_B3_1   (0x2U << DDRCTRL_ADDRMAP9_ADDRMAP_ROW_B3_Pos) /*!< 0x00000200 */
#define DDRCTRL_ADDRMAP9_ADDRMAP_ROW_B3_2   (0x4U << DDRCTRL_ADDRMAP9_ADDRMAP_ROW_B3_Pos) /*!< 0x00000400 */
#define DDRCTRL_ADDRMAP9_ADDRMAP_ROW_B3_3   (0x8U << DDRCTRL_ADDRMAP9_ADDRMAP_ROW_B3_Pos) /*!< 0x00000800 */
#define DDRCTRL_ADDRMAP9_ADDRMAP_ROW_B4_Pos (16U)
#define DDRCTRL_ADDRMAP9_ADDRMAP_ROW_B4_Msk (0xFU << DDRCTRL_ADDRMAP9_ADDRMAP_ROW_B4_Pos) /*!< 0x000F0000 */
#define DDRCTRL_ADDRMAP9_ADDRMAP_ROW_B4     DDRCTRL_ADDRMAP9_ADDRMAP_ROW_B4_Msk           /*!< Selects the HIF address bits used as row address bit 4. */
#define DDRCTRL_ADDRMAP9_ADDRMAP_ROW_B4_0   (0x1U << DDRCTRL_ADDRMAP9_ADDRMAP_ROW_B4_Pos) /*!< 0x00010000 */
#define DDRCTRL_ADDRMAP9_ADDRMAP_ROW_B4_1   (0x2U << DDRCTRL_ADDRMAP9_ADDRMAP_ROW_B4_Pos) /*!< 0x00020000 */
#define DDRCTRL_ADDRMAP9_ADDRMAP_ROW_B4_2   (0x4U << DDRCTRL_ADDRMAP9_ADDRMAP_ROW_B4_Pos) /*!< 0x00040000 */
#define DDRCTRL_ADDRMAP9_ADDRMAP_ROW_B4_3   (0x8U << DDRCTRL_ADDRMAP9_ADDRMAP_ROW_B4_Pos) /*!< 0x00080000 */
#define DDRCTRL_ADDRMAP9_ADDRMAP_ROW_B5_Pos (24U)
#define DDRCTRL_ADDRMAP9_ADDRMAP_ROW_B5_Msk (0xFU << DDRCTRL_ADDRMAP9_ADDRMAP_ROW_B5_Pos) /*!< 0x0F000000 */
#define DDRCTRL_ADDRMAP9_ADDRMAP_ROW_B5     DDRCTRL_ADDRMAP9_ADDRMAP_ROW_B5_Msk           /*!< Selects the HIF address bits used as row address bit 5. */
#define DDRCTRL_ADDRMAP9_ADDRMAP_ROW_B5_0   (0x1U << DDRCTRL_ADDRMAP9_ADDRMAP_ROW_B5_Pos) /*!< 0x01000000 */
#define DDRCTRL_ADDRMAP9_ADDRMAP_ROW_B5_1   (0x2U << DDRCTRL_ADDRMAP9_ADDRMAP_ROW_B5_Pos) /*!< 0x02000000 */
#define DDRCTRL_ADDRMAP9_ADDRMAP_ROW_B5_2   (0x4U << DDRCTRL_ADDRMAP9_ADDRMAP_ROW_B5_Pos) /*!< 0x04000000 */
#define DDRCTRL_ADDRMAP9_ADDRMAP_ROW_B5_3   (0x8U << DDRCTRL_ADDRMAP9_ADDRMAP_ROW_B5_Pos) /*!< 0x08000000 */

/**************  Bit definition for DDRCTRL_ADDRMAP10 register  ***************/
#define DDRCTRL_ADDRMAP10_ADDRMAP_ROW_B6_Pos (0U)
#define DDRCTRL_ADDRMAP10_ADDRMAP_ROW_B6_Msk (0xFU << DDRCTRL_ADDRMAP10_ADDRMAP_ROW_B6_Pos) /*!< 0x0000000F */
#define DDRCTRL_ADDRMAP10_ADDRMAP_ROW_B6     DDRCTRL_ADDRMAP10_ADDRMAP_ROW_B6_Msk           /*!< Selects the HIF address bits used as row address bit 6. */
#define DDRCTRL_ADDRMAP10_ADDRMAP_ROW_B6_0   (0x1U << DDRCTRL_ADDRMAP10_ADDRMAP_ROW_B6_Pos) /*!< 0x00000001 */
#define DDRCTRL_ADDRMAP10_ADDRMAP_ROW_B6_1   (0x2U << DDRCTRL_ADDRMAP10_ADDRMAP_ROW_B6_Pos) /*!< 0x00000002 */
#define DDRCTRL_ADDRMAP10_ADDRMAP_ROW_B6_2   (0x4U << DDRCTRL_ADDRMAP10_ADDRMAP_ROW_B6_Pos) /*!< 0x00000004 */
#define DDRCTRL_ADDRMAP10_ADDRMAP_ROW_B6_3   (0x8U << DDRCTRL_ADDRMAP10_ADDRMAP_ROW_B6_Pos) /*!< 0x00000008 */
#define DDRCTRL_ADDRMAP10_ADDRMAP_ROW_B7_Pos (8U)
#define DDRCTRL_ADDRMAP10_ADDRMAP_ROW_B7_Msk (0xFU << DDRCTRL_ADDRMAP10_ADDRMAP_ROW_B7_Pos) /*!< 0x00000F00 */
#define DDRCTRL_ADDRMAP10_ADDRMAP_ROW_B7     DDRCTRL_ADDRMAP10_ADDRMAP_ROW_B7_Msk           /*!< Selects the HIF address bits used as row address bit 7. */
#define DDRCTRL_ADDRMAP10_ADDRMAP_ROW_B7_0   (0x1U << DDRCTRL_ADDRMAP10_ADDRMAP_ROW_B7_Pos) /*!< 0x00000100 */
#define DDRCTRL_ADDRMAP10_ADDRMAP_ROW_B7_1   (0x2U << DDRCTRL_ADDRMAP10_ADDRMAP_ROW_B7_Pos) /*!< 0x00000200 */
#define DDRCTRL_ADDRMAP10_ADDRMAP_ROW_B7_2   (0x4U << DDRCTRL_ADDRMAP10_ADDRMAP_ROW_B7_Pos) /*!< 0x00000400 */
#define DDRCTRL_ADDRMAP10_ADDRMAP_ROW_B7_3   (0x8U << DDRCTRL_ADDRMAP10_ADDRMAP_ROW_B7_Pos) /*!< 0x00000800 */
#define DDRCTRL_ADDRMAP10_ADDRMAP_ROW_B8_Pos (16U)
#define DDRCTRL_ADDRMAP10_ADDRMAP_ROW_B8_Msk (0xFU << DDRCTRL_ADDRMAP10_ADDRMAP_ROW_B8_Pos) /*!< 0x000F0000 */
#define DDRCTRL_ADDRMAP10_ADDRMAP_ROW_B8     DDRCTRL_ADDRMAP10_ADDRMAP_ROW_B8_Msk           /*!< Selects the HIF address bits used as row address bit 8. */
#define DDRCTRL_ADDRMAP10_ADDRMAP_ROW_B8_0   (0x1U << DDRCTRL_ADDRMAP10_ADDRMAP_ROW_B8_Pos) /*!< 0x00010000 */
#define DDRCTRL_ADDRMAP10_ADDRMAP_ROW_B8_1   (0x2U << DDRCTRL_ADDRMAP10_ADDRMAP_ROW_B8_Pos) /*!< 0x00020000 */
#define DDRCTRL_ADDRMAP10_ADDRMAP_ROW_B8_2   (0x4U << DDRCTRL_ADDRMAP10_ADDRMAP_ROW_B8_Pos) /*!< 0x00040000 */
#define DDRCTRL_ADDRMAP10_ADDRMAP_ROW_B8_3   (0x8U << DDRCTRL_ADDRMAP10_ADDRMAP_ROW_B8_Pos) /*!< 0x00080000 */
#define DDRCTRL_ADDRMAP10_ADDRMAP_ROW_B9_Pos (24U)
#define DDRCTRL_ADDRMAP10_ADDRMAP_ROW_B9_Msk (0xFU << DDRCTRL_ADDRMAP10_ADDRMAP_ROW_B9_Pos) /*!< 0x0F000000 */
#define DDRCTRL_ADDRMAP10_ADDRMAP_ROW_B9     DDRCTRL_ADDRMAP10_ADDRMAP_ROW_B9_Msk           /*!< Selects the HIF address bits used as row address bit 9. */
#define DDRCTRL_ADDRMAP10_ADDRMAP_ROW_B9_0   (0x1U << DDRCTRL_ADDRMAP10_ADDRMAP_ROW_B9_Pos) /*!< 0x01000000 */
#define DDRCTRL_ADDRMAP10_ADDRMAP_ROW_B9_1   (0x2U << DDRCTRL_ADDRMAP10_ADDRMAP_ROW_B9_Pos) /*!< 0x02000000 */
#define DDRCTRL_ADDRMAP10_ADDRMAP_ROW_B9_2   (0x4U << DDRCTRL_ADDRMAP10_ADDRMAP_ROW_B9_Pos) /*!< 0x04000000 */
#define DDRCTRL_ADDRMAP10_ADDRMAP_ROW_B9_3   (0x8U << DDRCTRL_ADDRMAP10_ADDRMAP_ROW_B9_Pos) /*!< 0x08000000 */

/**************  Bit definition for DDRCTRL_ADDRMAP11 register  ***************/
#define DDRCTRL_ADDRMAP11_ADDRMAP_ROW_B10_Pos (0U)
#define DDRCTRL_ADDRMAP11_ADDRMAP_ROW_B10_Msk (0xFU << DDRCTRL_ADDRMAP11_ADDRMAP_ROW_B10_Pos) /*!< 0x0000000F */
#define DDRCTRL_ADDRMAP11_ADDRMAP_ROW_B10     DDRCTRL_ADDRMAP11_ADDRMAP_ROW_B10_Msk           /*!< Selects the HIF address bits used as row address bit 10. */
#define DDRCTRL_ADDRMAP11_ADDRMAP_ROW_B10_0   (0x1U << DDRCTRL_ADDRMAP11_ADDRMAP_ROW_B10_Pos) /*!< 0x00000001 */
#define DDRCTRL_ADDRMAP11_ADDRMAP_ROW_B10_1   (0x2U << DDRCTRL_ADDRMAP11_ADDRMAP_ROW_B10_Pos) /*!< 0x00000002 */
#define DDRCTRL_ADDRMAP11_ADDRMAP_ROW_B10_2   (0x4U << DDRCTRL_ADDRMAP11_ADDRMAP_ROW_B10_Pos) /*!< 0x00000004 */
#define DDRCTRL_ADDRMAP11_ADDRMAP_ROW_B10_3   (0x8U << DDRCTRL_ADDRMAP11_ADDRMAP_ROW_B10_Pos) /*!< 0x00000008 */

/****************  Bit definition for DDRCTRL_ODTCFG register  ****************/
#define DDRCTRL_ODTCFG_RD_ODT_DELAY_Pos (2U)
#define DDRCTRL_ODTCFG_RD_ODT_DELAY_Msk (0x1FU << DDRCTRL_ODTCFG_RD_ODT_DELAY_Pos) /*!< 0x0000007C */
#define DDRCTRL_ODTCFG_RD_ODT_DELAY     DDRCTRL_ODTCFG_RD_ODT_DELAY_Msk            /*!< The delay, in DFI PHY clock cycles, from issuing a read command to setting ODT values associated with that command. ODT setting must remain constant for the entire time that DQS is driven by the DDRCTRL. */
#define DDRCTRL_ODTCFG_RD_ODT_DELAY_0   (0x1U << DDRCTRL_ODTCFG_RD_ODT_DELAY_Pos)  /*!< 0x00000004 */
#define DDRCTRL_ODTCFG_RD_ODT_DELAY_1   (0x2U << DDRCTRL_ODTCFG_RD_ODT_DELAY_Pos)  /*!< 0x00000008 */
#define DDRCTRL_ODTCFG_RD_ODT_DELAY_2   (0x4U << DDRCTRL_ODTCFG_RD_ODT_DELAY_Pos)  /*!< 0x00000010 */
#define DDRCTRL_ODTCFG_RD_ODT_DELAY_3   (0x8U << DDRCTRL_ODTCFG_RD_ODT_DELAY_Pos)  /*!< 0x00000020 */
#define DDRCTRL_ODTCFG_RD_ODT_DELAY_4   (0x10U << DDRCTRL_ODTCFG_RD_ODT_DELAY_Pos) /*!< 0x00000040 */
#define DDRCTRL_ODTCFG_RD_ODT_HOLD_Pos  (8U)
#define DDRCTRL_ODTCFG_RD_ODT_HOLD_Msk  (0xFU << DDRCTRL_ODTCFG_RD_ODT_HOLD_Pos)   /*!< 0x00000F00 */
#define DDRCTRL_ODTCFG_RD_ODT_HOLD      DDRCTRL_ODTCFG_RD_ODT_HOLD_Msk             /*!< DFI PHY clock cycles to hold ODT for a read command. The minimum supported value is 2. */
#define DDRCTRL_ODTCFG_RD_ODT_HOLD_0    (0x1U << DDRCTRL_ODTCFG_RD_ODT_HOLD_Pos)   /*!< 0x00000100 */
#define DDRCTRL_ODTCFG_RD_ODT_HOLD_1    (0x2U << DDRCTRL_ODTCFG_RD_ODT_HOLD_Pos)   /*!< 0x00000200 */
#define DDRCTRL_ODTCFG_RD_ODT_HOLD_2    (0x4U << DDRCTRL_ODTCFG_RD_ODT_HOLD_Pos)   /*!< 0x00000400 */
#define DDRCTRL_ODTCFG_RD_ODT_HOLD_3    (0x8U << DDRCTRL_ODTCFG_RD_ODT_HOLD_Pos)   /*!< 0x00000800 */
#define DDRCTRL_ODTCFG_WR_ODT_DELAY_Pos (16U)
#define DDRCTRL_ODTCFG_WR_ODT_DELAY_Msk (0x1FU << DDRCTRL_ODTCFG_WR_ODT_DELAY_Pos) /*!< 0x001F0000 */
#define DDRCTRL_ODTCFG_WR_ODT_DELAY     DDRCTRL_ODTCFG_WR_ODT_DELAY_Msk            /*!< The delay, in DFI PHY clock cycles, from issuing a write command to setting ODT values associated with that command. ODT setting must remain constant for the entire time that DQS is driven by the DDRCTRL. */
#define DDRCTRL_ODTCFG_WR_ODT_DELAY_0   (0x1U << DDRCTRL_ODTCFG_WR_ODT_DELAY_Pos)  /*!< 0x00010000 */
#define DDRCTRL_ODTCFG_WR_ODT_DELAY_1   (0x2U << DDRCTRL_ODTCFG_WR_ODT_DELAY_Pos)  /*!< 0x00020000 */
#define DDRCTRL_ODTCFG_WR_ODT_DELAY_2   (0x4U << DDRCTRL_ODTCFG_WR_ODT_DELAY_Pos)  /*!< 0x00040000 */
#define DDRCTRL_ODTCFG_WR_ODT_DELAY_3   (0x8U << DDRCTRL_ODTCFG_WR_ODT_DELAY_Pos)  /*!< 0x00080000 */
#define DDRCTRL_ODTCFG_WR_ODT_DELAY_4   (0x10U << DDRCTRL_ODTCFG_WR_ODT_DELAY_Pos) /*!< 0x00100000 */
#define DDRCTRL_ODTCFG_WR_ODT_HOLD_Pos  (24U)
#define DDRCTRL_ODTCFG_WR_ODT_HOLD_Msk  (0xFU << DDRCTRL_ODTCFG_WR_ODT_HOLD_Pos)   /*!< 0x0F000000 */
#define DDRCTRL_ODTCFG_WR_ODT_HOLD      DDRCTRL_ODTCFG_WR_ODT_HOLD_Msk             /*!< DFI PHY clock cycles to hold ODT for a write command. The minimum supported value is 2. */
#define DDRCTRL_ODTCFG_WR_ODT_HOLD_0    (0x1U << DDRCTRL_ODTCFG_WR_ODT_HOLD_Pos)   /*!< 0x01000000 */
#define DDRCTRL_ODTCFG_WR_ODT_HOLD_1    (0x2U << DDRCTRL_ODTCFG_WR_ODT_HOLD_Pos)   /*!< 0x02000000 */
#define DDRCTRL_ODTCFG_WR_ODT_HOLD_2    (0x4U << DDRCTRL_ODTCFG_WR_ODT_HOLD_Pos)   /*!< 0x04000000 */
#define DDRCTRL_ODTCFG_WR_ODT_HOLD_3    (0x8U << DDRCTRL_ODTCFG_WR_ODT_HOLD_Pos)   /*!< 0x08000000 */

/****************  Bit definition for DDRCTRL_ODTMAP register  ****************/
#define DDRCTRL_ODTMAP_RANK0_WR_ODT_Pos (0U)
#define DDRCTRL_ODTMAP_RANK0_WR_ODT_Msk (0x1U << DDRCTRL_ODTMAP_RANK0_WR_ODT_Pos) /*!< 0x00000001 */
#define DDRCTRL_ODTMAP_RANK0_WR_ODT     DDRCTRL_ODTMAP_RANK0_WR_ODT_Msk           /*!< Indicates which remote ODTs must be turned on during a write to rank 0. */
#define DDRCTRL_ODTMAP_RANK0_RD_ODT_Pos (4U)
#define DDRCTRL_ODTMAP_RANK0_RD_ODT_Msk (0x1U << DDRCTRL_ODTMAP_RANK0_RD_ODT_Pos) /*!< 0x00000010 */
#define DDRCTRL_ODTMAP_RANK0_RD_ODT     DDRCTRL_ODTMAP_RANK0_RD_ODT_Msk           /*!< Indicates which remote ODTs must be turned on during a read from rank 0. */

/****************  Bit definition for DDRCTRL_SCHED register  *****************/
#define DDRCTRL_SCHED_FORCE_LOW_PRI_N_Pos        (0U)
#define DDRCTRL_SCHED_FORCE_LOW_PRI_N_Msk        (0x1U << DDRCTRL_SCHED_FORCE_LOW_PRI_N_Pos)         /*!< 0x00000001 */
#define DDRCTRL_SCHED_FORCE_LOW_PRI_N            DDRCTRL_SCHED_FORCE_LOW_PRI_N_Msk                   /*!< Active low signal. When asserted (\q0\q), all incoming transactions are forced to low priority. This implies that all high priority read (HPR) and variable priority read commands (VPR) are treated as low priority read (LPR) commands. On the write side, all variable priority write (VPW) commands are treated as normal priority write (NPW) commands. Forcing the incoming transactions to low priority implicitly turns off bypass path for read commands. */
#define DDRCTRL_SCHED_PREFER_WRITE_Pos           (1U)
#define DDRCTRL_SCHED_PREFER_WRITE_Msk           (0x1U << DDRCTRL_SCHED_PREFER_WRITE_Pos)            /*!< 0x00000002 */
#define DDRCTRL_SCHED_PREFER_WRITE               DDRCTRL_SCHED_PREFER_WRITE_Msk                      /*!< If set then the bank selector prefers writes over reads. */
#define DDRCTRL_SCHED_PAGECLOSE_Pos              (2U)
#define DDRCTRL_SCHED_PAGECLOSE_Msk              (0x1U << DDRCTRL_SCHED_PAGECLOSE_Pos)               /*!< 0x00000004 */
#define DDRCTRL_SCHED_PAGECLOSE                  DDRCTRL_SCHED_PAGECLOSE_Msk                         /*!< If true, bank is kept open only while there are page hit transactions available in the CAM to that bank. The last read or write command in the CAM with a bank and page hit is executed with auto-precharge if SCHED1.pageclose_timer=0. Even if this register set to 1 and SCHED1.pageclose_timer is set to 0, explicit precharge (and not auto-precharge) may be issued in some cases where there is a mode switch between write and read or between LPR and HPR. The Read and Write commands that are executed as part of the ECC scrub requests are also executed without auto-precharge. */
#define DDRCTRL_SCHED_LPR_NUM_ENTRIES_Pos        (8U)
#define DDRCTRL_SCHED_LPR_NUM_ENTRIES_Msk        (0xFU << DDRCTRL_SCHED_LPR_NUM_ENTRIES_Pos)         /*!< 0x00000F00 */
#define DDRCTRL_SCHED_LPR_NUM_ENTRIES            DDRCTRL_SCHED_LPR_NUM_ENTRIES_Msk                   /*!< Number of entries in the low priority transaction store is this value + 1. */
#define DDRCTRL_SCHED_LPR_NUM_ENTRIES_0          (0x1U << DDRCTRL_SCHED_LPR_NUM_ENTRIES_Pos)         /*!< 0x00000100 */
#define DDRCTRL_SCHED_LPR_NUM_ENTRIES_1          (0x2U << DDRCTRL_SCHED_LPR_NUM_ENTRIES_Pos)         /*!< 0x00000200 */
#define DDRCTRL_SCHED_LPR_NUM_ENTRIES_2          (0x4U << DDRCTRL_SCHED_LPR_NUM_ENTRIES_Pos)         /*!< 0x00000400 */
#define DDRCTRL_SCHED_LPR_NUM_ENTRIES_3          (0x8U << DDRCTRL_SCHED_LPR_NUM_ENTRIES_Pos)         /*!< 0x00000800 */
#define DDRCTRL_SCHED_GO2CRITICAL_HYSTERESIS_Pos (16U)
#define DDRCTRL_SCHED_GO2CRITICAL_HYSTERESIS_Msk (0xFFU << DDRCTRL_SCHED_GO2CRITICAL_HYSTERESIS_Pos) /*!< 0x00FF0000 */
#define DDRCTRL_SCHED_GO2CRITICAL_HYSTERESIS     DDRCTRL_SCHED_GO2CRITICAL_HYSTERESIS_Msk            /*!< UNUSED */
#define DDRCTRL_SCHED_GO2CRITICAL_HYSTERESIS_0   (0x1U << DDRCTRL_SCHED_GO2CRITICAL_HYSTERESIS_Pos)  /*!< 0x00010000 */
#define DDRCTRL_SCHED_GO2CRITICAL_HYSTERESIS_1   (0x2U << DDRCTRL_SCHED_GO2CRITICAL_HYSTERESIS_Pos)  /*!< 0x00020000 */
#define DDRCTRL_SCHED_GO2CRITICAL_HYSTERESIS_2   (0x4U << DDRCTRL_SCHED_GO2CRITICAL_HYSTERESIS_Pos)  /*!< 0x00040000 */
#define DDRCTRL_SCHED_GO2CRITICAL_HYSTERESIS_3   (0x8U << DDRCTRL_SCHED_GO2CRITICAL_HYSTERESIS_Pos)  /*!< 0x00080000 */
#define DDRCTRL_SCHED_GO2CRITICAL_HYSTERESIS_4   (0x10U << DDRCTRL_SCHED_GO2CRITICAL_HYSTERESIS_Pos) /*!< 0x00100000 */
#define DDRCTRL_SCHED_GO2CRITICAL_HYSTERESIS_5   (0x20U << DDRCTRL_SCHED_GO2CRITICAL_HYSTERESIS_Pos) /*!< 0x00200000 */
#define DDRCTRL_SCHED_GO2CRITICAL_HYSTERESIS_6   (0x40U << DDRCTRL_SCHED_GO2CRITICAL_HYSTERESIS_Pos) /*!< 0x00400000 */
#define DDRCTRL_SCHED_GO2CRITICAL_HYSTERESIS_7   (0x80U << DDRCTRL_SCHED_GO2CRITICAL_HYSTERESIS_Pos) /*!< 0x00800000 */
#define DDRCTRL_SCHED_RDWR_IDLE_GAP_Pos          (24U)
#define DDRCTRL_SCHED_RDWR_IDLE_GAP_Msk          (0x7FU << DDRCTRL_SCHED_RDWR_IDLE_GAP_Pos)          /*!< 0x7F000000 */
#define DDRCTRL_SCHED_RDWR_IDLE_GAP              DDRCTRL_SCHED_RDWR_IDLE_GAP_Msk                     /*!< When the preferred transaction store is empty for these many clock cycles, switch to the alternate transaction store if it is non-empty. */
#define DDRCTRL_SCHED_RDWR_IDLE_GAP_0            (0x1U << DDRCTRL_SCHED_RDWR_IDLE_GAP_Pos)           /*!< 0x01000000 */
#define DDRCTRL_SCHED_RDWR_IDLE_GAP_1            (0x2U << DDRCTRL_SCHED_RDWR_IDLE_GAP_Pos)           /*!< 0x02000000 */
#define DDRCTRL_SCHED_RDWR_IDLE_GAP_2            (0x4U << DDRCTRL_SCHED_RDWR_IDLE_GAP_Pos)           /*!< 0x04000000 */
#define DDRCTRL_SCHED_RDWR_IDLE_GAP_3            (0x8U << DDRCTRL_SCHED_RDWR_IDLE_GAP_Pos)           /*!< 0x08000000 */
#define DDRCTRL_SCHED_RDWR_IDLE_GAP_4            (0x10U << DDRCTRL_SCHED_RDWR_IDLE_GAP_Pos)          /*!< 0x10000000 */
#define DDRCTRL_SCHED_RDWR_IDLE_GAP_5            (0x20U << DDRCTRL_SCHED_RDWR_IDLE_GAP_Pos)          /*!< 0x20000000 */
#define DDRCTRL_SCHED_RDWR_IDLE_GAP_6            (0x40U << DDRCTRL_SCHED_RDWR_IDLE_GAP_Pos)          /*!< 0x40000000 */

/****************  Bit definition for DDRCTRL_SCHED1 register  ****************/
#define DDRCTRL_SCHED1_PAGECLOSE_TIMER_Pos (0U)
#define DDRCTRL_SCHED1_PAGECLOSE_TIMER_Msk (0xFFU << DDRCTRL_SCHED1_PAGECLOSE_TIMER_Pos) /*!< 0x000000FF */
#define DDRCTRL_SCHED1_PAGECLOSE_TIMER     DDRCTRL_SCHED1_PAGECLOSE_TIMER_Msk            /*!< This field works in conjunction with SCHED.pageclose. */
#define DDRCTRL_SCHED1_PAGECLOSE_TIMER_0   (0x1U << DDRCTRL_SCHED1_PAGECLOSE_TIMER_Pos)  /*!< 0x00000001 */
#define DDRCTRL_SCHED1_PAGECLOSE_TIMER_1   (0x2U << DDRCTRL_SCHED1_PAGECLOSE_TIMER_Pos)  /*!< 0x00000002 */
#define DDRCTRL_SCHED1_PAGECLOSE_TIMER_2   (0x4U << DDRCTRL_SCHED1_PAGECLOSE_TIMER_Pos)  /*!< 0x00000004 */
#define DDRCTRL_SCHED1_PAGECLOSE_TIMER_3   (0x8U << DDRCTRL_SCHED1_PAGECLOSE_TIMER_Pos)  /*!< 0x00000008 */
#define DDRCTRL_SCHED1_PAGECLOSE_TIMER_4   (0x10U << DDRCTRL_SCHED1_PAGECLOSE_TIMER_Pos) /*!< 0x00000010 */
#define DDRCTRL_SCHED1_PAGECLOSE_TIMER_5   (0x20U << DDRCTRL_SCHED1_PAGECLOSE_TIMER_Pos) /*!< 0x00000020 */
#define DDRCTRL_SCHED1_PAGECLOSE_TIMER_6   (0x40U << DDRCTRL_SCHED1_PAGECLOSE_TIMER_Pos) /*!< 0x00000040 */
#define DDRCTRL_SCHED1_PAGECLOSE_TIMER_7   (0x80U << DDRCTRL_SCHED1_PAGECLOSE_TIMER_Pos) /*!< 0x00000080 */

/***************  Bit definition for DDRCTRL_PERFHPR1 register  ***************/
#define DDRCTRL_PERFHPR1_HPR_MAX_STARVE_Pos      (0U)
#define DDRCTRL_PERFHPR1_HPR_MAX_STARVE_Msk      (0xFFFFU << DDRCTRL_PERFHPR1_HPR_MAX_STARVE_Pos)    /*!< 0x0000FFFF */
#define DDRCTRL_PERFHPR1_HPR_MAX_STARVE          DDRCTRL_PERFHPR1_HPR_MAX_STARVE_Msk                 /*!< Number of DFI clocks that the HPR queue can be starved before it goes critical. The minimum valid functional value for this register is 0x1. Programming it to 0x0 disables the starvation functionality; during normal operation, this function must not be disabled as it causes excessive latencies. */
#define DDRCTRL_PERFHPR1_HPR_MAX_STARVE_0        (0x1U << DDRCTRL_PERFHPR1_HPR_MAX_STARVE_Pos)       /*!< 0x00000001 */
#define DDRCTRL_PERFHPR1_HPR_MAX_STARVE_1        (0x2U << DDRCTRL_PERFHPR1_HPR_MAX_STARVE_Pos)       /*!< 0x00000002 */
#define DDRCTRL_PERFHPR1_HPR_MAX_STARVE_2        (0x4U << DDRCTRL_PERFHPR1_HPR_MAX_STARVE_Pos)       /*!< 0x00000004 */
#define DDRCTRL_PERFHPR1_HPR_MAX_STARVE_3        (0x8U << DDRCTRL_PERFHPR1_HPR_MAX_STARVE_Pos)       /*!< 0x00000008 */
#define DDRCTRL_PERFHPR1_HPR_MAX_STARVE_4        (0x10U << DDRCTRL_PERFHPR1_HPR_MAX_STARVE_Pos)      /*!< 0x00000010 */
#define DDRCTRL_PERFHPR1_HPR_MAX_STARVE_5        (0x20U << DDRCTRL_PERFHPR1_HPR_MAX_STARVE_Pos)      /*!< 0x00000020 */
#define DDRCTRL_PERFHPR1_HPR_MAX_STARVE_6        (0x40U << DDRCTRL_PERFHPR1_HPR_MAX_STARVE_Pos)      /*!< 0x00000040 */
#define DDRCTRL_PERFHPR1_HPR_MAX_STARVE_7        (0x80U << DDRCTRL_PERFHPR1_HPR_MAX_STARVE_Pos)      /*!< 0x00000080 */
#define DDRCTRL_PERFHPR1_HPR_MAX_STARVE_8        (0x100U << DDRCTRL_PERFHPR1_HPR_MAX_STARVE_Pos)     /*!< 0x00000100 */
#define DDRCTRL_PERFHPR1_HPR_MAX_STARVE_9        (0x200U << DDRCTRL_PERFHPR1_HPR_MAX_STARVE_Pos)     /*!< 0x00000200 */
#define DDRCTRL_PERFHPR1_HPR_MAX_STARVE_10       (0x400U << DDRCTRL_PERFHPR1_HPR_MAX_STARVE_Pos)     /*!< 0x00000400 */
#define DDRCTRL_PERFHPR1_HPR_MAX_STARVE_11       (0x800U << DDRCTRL_PERFHPR1_HPR_MAX_STARVE_Pos)     /*!< 0x00000800 */
#define DDRCTRL_PERFHPR1_HPR_MAX_STARVE_12       (0x1000U << DDRCTRL_PERFHPR1_HPR_MAX_STARVE_Pos)    /*!< 0x00001000 */
#define DDRCTRL_PERFHPR1_HPR_MAX_STARVE_13       (0x2000U << DDRCTRL_PERFHPR1_HPR_MAX_STARVE_Pos)    /*!< 0x00002000 */
#define DDRCTRL_PERFHPR1_HPR_MAX_STARVE_14       (0x4000U << DDRCTRL_PERFHPR1_HPR_MAX_STARVE_Pos)    /*!< 0x00004000 */
#define DDRCTRL_PERFHPR1_HPR_MAX_STARVE_15       (0x8000U << DDRCTRL_PERFHPR1_HPR_MAX_STARVE_Pos)    /*!< 0x00008000 */
#define DDRCTRL_PERFHPR1_HPR_XACT_RUN_LENGTH_Pos (24U)
#define DDRCTRL_PERFHPR1_HPR_XACT_RUN_LENGTH_Msk (0xFFU << DDRCTRL_PERFHPR1_HPR_XACT_RUN_LENGTH_Pos) /*!< 0xFF000000 */
#define DDRCTRL_PERFHPR1_HPR_XACT_RUN_LENGTH      DDRCTRL_PERFHPR1_HPR_XACT_RUN_LENGTH_Msk           /*!< Number of transactions that are serviced once the HPR queue goes critical is the smaller of: */
#define DDRCTRL_PERFHPR1_HPR_XACT_RUN_LENGTH_0   (0x1U << DDRCTRL_PERFHPR1_HPR_XACT_RUN_LENGTH_Pos)  /*!< 0x01000000 */
#define DDRCTRL_PERFHPR1_HPR_XACT_RUN_LENGTH_1   (0x2U << DDRCTRL_PERFHPR1_HPR_XACT_RUN_LENGTH_Pos)  /*!< 0x02000000 */
#define DDRCTRL_PERFHPR1_HPR_XACT_RUN_LENGTH_2   (0x4U << DDRCTRL_PERFHPR1_HPR_XACT_RUN_LENGTH_Pos)  /*!< 0x04000000 */
#define DDRCTRL_PERFHPR1_HPR_XACT_RUN_LENGTH_3   (0x8U << DDRCTRL_PERFHPR1_HPR_XACT_RUN_LENGTH_Pos)  /*!< 0x08000000 */
#define DDRCTRL_PERFHPR1_HPR_XACT_RUN_LENGTH_4   (0x10U << DDRCTRL_PERFHPR1_HPR_XACT_RUN_LENGTH_Pos) /*!< 0x10000000 */
#define DDRCTRL_PERFHPR1_HPR_XACT_RUN_LENGTH_5   (0x20U << DDRCTRL_PERFHPR1_HPR_XACT_RUN_LENGTH_Pos) /*!< 0x20000000 */
#define DDRCTRL_PERFHPR1_HPR_XACT_RUN_LENGTH_6   (0x40U << DDRCTRL_PERFHPR1_HPR_XACT_RUN_LENGTH_Pos) /*!< 0x40000000 */
#define DDRCTRL_PERFHPR1_HPR_XACT_RUN_LENGTH_7   (0x80U << DDRCTRL_PERFHPR1_HPR_XACT_RUN_LENGTH_Pos) /*!< 0x80000000 */

/***************  Bit definition for DDRCTRL_PERFLPR1 register  ***************/
#define DDRCTRL_PERFLPR1_LPR_MAX_STARVE_Pos      (0U)
#define DDRCTRL_PERFLPR1_LPR_MAX_STARVE_Msk      (0xFFFFU << DDRCTRL_PERFLPR1_LPR_MAX_STARVE_Pos)    /*!< 0x0000FFFF */
#define DDRCTRL_PERFLPR1_LPR_MAX_STARVE          DDRCTRL_PERFLPR1_LPR_MAX_STARVE_Msk                 /*!< Number of DFI clocks that the LPR queue can be starved before it goes critical. The minimum valid functional value for this register is 0x1. Programming it to 0x0 disables the starvation functionality; during normal operation, this function must be disabled as it causes excessive latencies. */
#define DDRCTRL_PERFLPR1_LPR_MAX_STARVE_0        (0x1U << DDRCTRL_PERFLPR1_LPR_MAX_STARVE_Pos)       /*!< 0x00000001 */
#define DDRCTRL_PERFLPR1_LPR_MAX_STARVE_1        (0x2U << DDRCTRL_PERFLPR1_LPR_MAX_STARVE_Pos)       /*!< 0x00000002 */
#define DDRCTRL_PERFLPR1_LPR_MAX_STARVE_2        (0x4U << DDRCTRL_PERFLPR1_LPR_MAX_STARVE_Pos)       /*!< 0x00000004 */
#define DDRCTRL_PERFLPR1_LPR_MAX_STARVE_3        (0x8U << DDRCTRL_PERFLPR1_LPR_MAX_STARVE_Pos)       /*!< 0x00000008 */
#define DDRCTRL_PERFLPR1_LPR_MAX_STARVE_4        (0x10U << DDRCTRL_PERFLPR1_LPR_MAX_STARVE_Pos)      /*!< 0x00000010 */
#define DDRCTRL_PERFLPR1_LPR_MAX_STARVE_5        (0x20U << DDRCTRL_PERFLPR1_LPR_MAX_STARVE_Pos)      /*!< 0x00000020 */
#define DDRCTRL_PERFLPR1_LPR_MAX_STARVE_6        (0x40U << DDRCTRL_PERFLPR1_LPR_MAX_STARVE_Pos)      /*!< 0x00000040 */
#define DDRCTRL_PERFLPR1_LPR_MAX_STARVE_7        (0x80U << DDRCTRL_PERFLPR1_LPR_MAX_STARVE_Pos)      /*!< 0x00000080 */
#define DDRCTRL_PERFLPR1_LPR_MAX_STARVE_8        (0x100U << DDRCTRL_PERFLPR1_LPR_MAX_STARVE_Pos)     /*!< 0x00000100 */
#define DDRCTRL_PERFLPR1_LPR_MAX_STARVE_9        (0x200U << DDRCTRL_PERFLPR1_LPR_MAX_STARVE_Pos)     /*!< 0x00000200 */
#define DDRCTRL_PERFLPR1_LPR_MAX_STARVE_10       (0x400U << DDRCTRL_PERFLPR1_LPR_MAX_STARVE_Pos)     /*!< 0x00000400 */
#define DDRCTRL_PERFLPR1_LPR_MAX_STARVE_11       (0x800U << DDRCTRL_PERFLPR1_LPR_MAX_STARVE_Pos)     /*!< 0x00000800 */
#define DDRCTRL_PERFLPR1_LPR_MAX_STARVE_12       (0x1000U << DDRCTRL_PERFLPR1_LPR_MAX_STARVE_Pos)    /*!< 0x00001000 */
#define DDRCTRL_PERFLPR1_LPR_MAX_STARVE_13       (0x2000U << DDRCTRL_PERFLPR1_LPR_MAX_STARVE_Pos)    /*!< 0x00002000 */
#define DDRCTRL_PERFLPR1_LPR_MAX_STARVE_14       (0x4000U << DDRCTRL_PERFLPR1_LPR_MAX_STARVE_Pos)    /*!< 0x00004000 */
#define DDRCTRL_PERFLPR1_LPR_MAX_STARVE_15       (0x8000U << DDRCTRL_PERFLPR1_LPR_MAX_STARVE_Pos)    /*!< 0x00008000 */
#define DDRCTRL_PERFLPR1_LPR_XACT_RUN_LENGTH_Pos (24U)
#define DDRCTRL_PERFLPR1_LPR_XACT_RUN_LENGTH_Msk (0xFFU << DDRCTRL_PERFLPR1_LPR_XACT_RUN_LENGTH_Pos) /*!< 0xFF000000 */
#define DDRCTRL_PERFLPR1_LPR_XACT_RUN_LENGTH     DDRCTRL_PERFLPR1_LPR_XACT_RUN_LENGTH_Msk            /*!< Number of transactions that are serviced once the LPR queue goes critical is the smaller of: */
#define DDRCTRL_PERFLPR1_LPR_XACT_RUN_LENGTH_0   (0x1U << DDRCTRL_PERFLPR1_LPR_XACT_RUN_LENGTH_Pos)  /*!< 0x01000000 */
#define DDRCTRL_PERFLPR1_LPR_XACT_RUN_LENGTH_1   (0x2U << DDRCTRL_PERFLPR1_LPR_XACT_RUN_LENGTH_Pos)  /*!< 0x02000000 */
#define DDRCTRL_PERFLPR1_LPR_XACT_RUN_LENGTH_2   (0x4U << DDRCTRL_PERFLPR1_LPR_XACT_RUN_LENGTH_Pos)  /*!< 0x04000000 */
#define DDRCTRL_PERFLPR1_LPR_XACT_RUN_LENGTH_3   (0x8U << DDRCTRL_PERFLPR1_LPR_XACT_RUN_LENGTH_Pos)  /*!< 0x08000000 */
#define DDRCTRL_PERFLPR1_LPR_XACT_RUN_LENGTH_4   (0x10U << DDRCTRL_PERFLPR1_LPR_XACT_RUN_LENGTH_Pos) /*!< 0x10000000 */
#define DDRCTRL_PERFLPR1_LPR_XACT_RUN_LENGTH_5   (0x20U << DDRCTRL_PERFLPR1_LPR_XACT_RUN_LENGTH_Pos) /*!< 0x20000000 */
#define DDRCTRL_PERFLPR1_LPR_XACT_RUN_LENGTH_6   (0x40U << DDRCTRL_PERFLPR1_LPR_XACT_RUN_LENGTH_Pos) /*!< 0x40000000 */
#define DDRCTRL_PERFLPR1_LPR_XACT_RUN_LENGTH_7   (0x80U << DDRCTRL_PERFLPR1_LPR_XACT_RUN_LENGTH_Pos) /*!< 0x80000000 */

/***************  Bit definition for DDRCTRL_PERFWR1 register  ****************/
#define DDRCTRL_PERFWR1_W_MAX_STARVE_Pos      (0U)
#define DDRCTRL_PERFWR1_W_MAX_STARVE_Msk      (0xFFFFU << DDRCTRL_PERFWR1_W_MAX_STARVE_Pos)    /*!< 0x0000FFFF */
#define DDRCTRL_PERFWR1_W_MAX_STARVE          DDRCTRL_PERFWR1_W_MAX_STARVE_Msk                 /*!< Number of DFI clocks that the WR queue can be starved before it goes critical. The minimum valid functional value for this register is 0x1. Programming it to 0x0 disables the starvation functionality; during normal operation, this function must not be disabled as it causes excessive latencies. */
#define DDRCTRL_PERFWR1_W_MAX_STARVE_0        (0x1U << DDRCTRL_PERFWR1_W_MAX_STARVE_Pos)       /*!< 0x00000001 */
#define DDRCTRL_PERFWR1_W_MAX_STARVE_1        (0x2U << DDRCTRL_PERFWR1_W_MAX_STARVE_Pos)       /*!< 0x00000002 */
#define DDRCTRL_PERFWR1_W_MAX_STARVE_2        (0x4U << DDRCTRL_PERFWR1_W_MAX_STARVE_Pos)       /*!< 0x00000004 */
#define DDRCTRL_PERFWR1_W_MAX_STARVE_3        (0x8U << DDRCTRL_PERFWR1_W_MAX_STARVE_Pos)       /*!< 0x00000008 */
#define DDRCTRL_PERFWR1_W_MAX_STARVE_4        (0x10U << DDRCTRL_PERFWR1_W_MAX_STARVE_Pos)      /*!< 0x00000010 */
#define DDRCTRL_PERFWR1_W_MAX_STARVE_5        (0x20U << DDRCTRL_PERFWR1_W_MAX_STARVE_Pos)      /*!< 0x00000020 */
#define DDRCTRL_PERFWR1_W_MAX_STARVE_6        (0x40U << DDRCTRL_PERFWR1_W_MAX_STARVE_Pos)      /*!< 0x00000040 */
#define DDRCTRL_PERFWR1_W_MAX_STARVE_7        (0x80U << DDRCTRL_PERFWR1_W_MAX_STARVE_Pos)      /*!< 0x00000080 */
#define DDRCTRL_PERFWR1_W_MAX_STARVE_8        (0x100U << DDRCTRL_PERFWR1_W_MAX_STARVE_Pos)     /*!< 0x00000100 */
#define DDRCTRL_PERFWR1_W_MAX_STARVE_9        (0x200U << DDRCTRL_PERFWR1_W_MAX_STARVE_Pos)     /*!< 0x00000200 */
#define DDRCTRL_PERFWR1_W_MAX_STARVE_10       (0x400U << DDRCTRL_PERFWR1_W_MAX_STARVE_Pos)     /*!< 0x00000400 */
#define DDRCTRL_PERFWR1_W_MAX_STARVE_11       (0x800U << DDRCTRL_PERFWR1_W_MAX_STARVE_Pos)     /*!< 0x00000800 */
#define DDRCTRL_PERFWR1_W_MAX_STARVE_12       (0x1000U << DDRCTRL_PERFWR1_W_MAX_STARVE_Pos)    /*!< 0x00001000 */
#define DDRCTRL_PERFWR1_W_MAX_STARVE_13       (0x2000U << DDRCTRL_PERFWR1_W_MAX_STARVE_Pos)    /*!< 0x00002000 */
#define DDRCTRL_PERFWR1_W_MAX_STARVE_14       (0x4000U << DDRCTRL_PERFWR1_W_MAX_STARVE_Pos)    /*!< 0x00004000 */
#define DDRCTRL_PERFWR1_W_MAX_STARVE_15       (0x8000U << DDRCTRL_PERFWR1_W_MAX_STARVE_Pos)    /*!< 0x00008000 */
#define DDRCTRL_PERFWR1_W_XACT_RUN_LENGTH_Pos (24U)
#define DDRCTRL_PERFWR1_W_XACT_RUN_LENGTH_Msk (0xFFU << DDRCTRL_PERFWR1_W_XACT_RUN_LENGTH_Pos) /*!< 0xFF000000 */
#define DDRCTRL_PERFWR1_W_XACT_RUN_LENGTH     DDRCTRL_PERFWR1_W_XACT_RUN_LENGTH_Msk            /*!< Number of transactions that are serviced once the WR queue goes critical is the smaller of: */
#define DDRCTRL_PERFWR1_W_XACT_RUN_LENGTH_0   (0x1U << DDRCTRL_PERFWR1_W_XACT_RUN_LENGTH_Pos)  /*!< 0x01000000 */
#define DDRCTRL_PERFWR1_W_XACT_RUN_LENGTH_1   (0x2U << DDRCTRL_PERFWR1_W_XACT_RUN_LENGTH_Pos)  /*!< 0x02000000 */
#define DDRCTRL_PERFWR1_W_XACT_RUN_LENGTH_2   (0x4U << DDRCTRL_PERFWR1_W_XACT_RUN_LENGTH_Pos)  /*!< 0x04000000 */
#define DDRCTRL_PERFWR1_W_XACT_RUN_LENGTH_3   (0x8U << DDRCTRL_PERFWR1_W_XACT_RUN_LENGTH_Pos)  /*!< 0x08000000 */
#define DDRCTRL_PERFWR1_W_XACT_RUN_LENGTH_4   (0x10U << DDRCTRL_PERFWR1_W_XACT_RUN_LENGTH_Pos) /*!< 0x10000000 */
#define DDRCTRL_PERFWR1_W_XACT_RUN_LENGTH_5   (0x20U << DDRCTRL_PERFWR1_W_XACT_RUN_LENGTH_Pos) /*!< 0x20000000 */
#define DDRCTRL_PERFWR1_W_XACT_RUN_LENGTH_6   (0x40U << DDRCTRL_PERFWR1_W_XACT_RUN_LENGTH_Pos) /*!< 0x40000000 */
#define DDRCTRL_PERFWR1_W_XACT_RUN_LENGTH_7   (0x80U << DDRCTRL_PERFWR1_W_XACT_RUN_LENGTH_Pos) /*!< 0x80000000 */

/*****************  Bit definition for DDRCTRL_DBG0 register  *****************/
#define DDRCTRL_DBG0_DIS_WC_Pos                 (0U)
#define DDRCTRL_DBG0_DIS_WC_Msk                 (0x1U << DDRCTRL_DBG0_DIS_WC_Pos)                 /*!< 0x00000001 */
#define DDRCTRL_DBG0_DIS_WC                     DDRCTRL_DBG0_DIS_WC_Msk                           /*!< When 1, disable write combine. */
#define DDRCTRL_DBG0_DIS_COLLISION_PAGE_OPT_Pos (4U)
#define DDRCTRL_DBG0_DIS_COLLISION_PAGE_OPT_Msk (0x1U << DDRCTRL_DBG0_DIS_COLLISION_PAGE_OPT_Pos) /*!< 0x00000010 */
#define DDRCTRL_DBG0_DIS_COLLISION_PAGE_OPT     DDRCTRL_DBG0_DIS_COLLISION_PAGE_OPT_Msk           /*!< When this is set to \q0\q, auto-precharge is disabled for the flushed command in a collision case. Collision cases are write followed by read to same address, read followed by write to same address, or write followed by write to same address with DBG0.dis_wc bit = 1 (where same address comparisons exclude the two address bits representing critical word). */

/*****************  Bit definition for DDRCTRL_DBG1 register  *****************/
#define DDRCTRL_DBG1_DIS_DQ_Pos  (0U)
#define DDRCTRL_DBG1_DIS_DQ_Msk  (0x1U << DDRCTRL_DBG1_DIS_DQ_Pos)  /*!< 0x00000001 */
#define DDRCTRL_DBG1_DIS_DQ      DDRCTRL_DBG1_DIS_DQ_Msk            /*!< When 1, DDRCTRL does not de-queue any transactions from the CAM. Bypass is also disabled. All transactions are queued in the CAM. No reads or writes are issued to SDRAM as long as this is asserted. */
#define DDRCTRL_DBG1_DIS_HIF_Pos (1U)
#define DDRCTRL_DBG1_DIS_HIF_Msk (0x1U << DDRCTRL_DBG1_DIS_HIF_Pos) /*!< 0x00000002 */
#define DDRCTRL_DBG1_DIS_HIF     DDRCTRL_DBG1_DIS_HIF_Msk           /*!< When 1, DDRCTRL asserts the HIF command signal hif_cmd_stall. DDRCTRL ignores the hif_cmd_valid and all other associated request signals. */

/****************  Bit definition for DDRCTRL_DBGCAM register  ****************/
#define DDRCTRL_DBGCAM_DBG_HPR_Q_DEPTH_Pos        (0U)
#define DDRCTRL_DBGCAM_DBG_HPR_Q_DEPTH_Msk        (0x1FU << DDRCTRL_DBGCAM_DBG_HPR_Q_DEPTH_Pos)       /*!< 0x0000001F */
#define DDRCTRL_DBGCAM_DBG_HPR_Q_DEPTH            DDRCTRL_DBGCAM_DBG_HPR_Q_DEPTH_Msk                  /*!< High priority read queue depth */
#define DDRCTRL_DBGCAM_DBG_HPR_Q_DEPTH_0          (0x1U << DDRCTRL_DBGCAM_DBG_HPR_Q_DEPTH_Pos)        /*!< 0x00000001 */
#define DDRCTRL_DBGCAM_DBG_HPR_Q_DEPTH_1          (0x2U << DDRCTRL_DBGCAM_DBG_HPR_Q_DEPTH_Pos)        /*!< 0x00000002 */
#define DDRCTRL_DBGCAM_DBG_HPR_Q_DEPTH_2          (0x4U << DDRCTRL_DBGCAM_DBG_HPR_Q_DEPTH_Pos)        /*!< 0x00000004 */
#define DDRCTRL_DBGCAM_DBG_HPR_Q_DEPTH_3          (0x8U << DDRCTRL_DBGCAM_DBG_HPR_Q_DEPTH_Pos)        /*!< 0x00000008 */
#define DDRCTRL_DBGCAM_DBG_HPR_Q_DEPTH_4          (0x10U << DDRCTRL_DBGCAM_DBG_HPR_Q_DEPTH_Pos)       /*!< 0x00000010 */
#define DDRCTRL_DBGCAM_DBG_LPR_Q_DEPTH_Pos        (8U)
#define DDRCTRL_DBGCAM_DBG_LPR_Q_DEPTH_Msk        (0x1FU << DDRCTRL_DBGCAM_DBG_LPR_Q_DEPTH_Pos)       /*!< 0x00001F00 */
#define DDRCTRL_DBGCAM_DBG_LPR_Q_DEPTH            DDRCTRL_DBGCAM_DBG_LPR_Q_DEPTH_Msk                  /*!< Low priority read queue depth */
#define DDRCTRL_DBGCAM_DBG_LPR_Q_DEPTH_0          (0x1U << DDRCTRL_DBGCAM_DBG_LPR_Q_DEPTH_Pos)        /*!< 0x00000100 */
#define DDRCTRL_DBGCAM_DBG_LPR_Q_DEPTH_1          (0x2U << DDRCTRL_DBGCAM_DBG_LPR_Q_DEPTH_Pos)        /*!< 0x00000200 */
#define DDRCTRL_DBGCAM_DBG_LPR_Q_DEPTH_2          (0x4U << DDRCTRL_DBGCAM_DBG_LPR_Q_DEPTH_Pos)        /*!< 0x00000400 */
#define DDRCTRL_DBGCAM_DBG_LPR_Q_DEPTH_3          (0x8U << DDRCTRL_DBGCAM_DBG_LPR_Q_DEPTH_Pos)        /*!< 0x00000800 */
#define DDRCTRL_DBGCAM_DBG_LPR_Q_DEPTH_4          (0x10U << DDRCTRL_DBGCAM_DBG_LPR_Q_DEPTH_Pos)       /*!< 0x00001000 */
#define DDRCTRL_DBGCAM_DBG_W_Q_DEPTH_Pos          (16U)
#define DDRCTRL_DBGCAM_DBG_W_Q_DEPTH_Msk          (0x1FU << DDRCTRL_DBGCAM_DBG_W_Q_DEPTH_Pos)         /*!< 0x001F0000 */
#define DDRCTRL_DBGCAM_DBG_W_Q_DEPTH              DDRCTRL_DBGCAM_DBG_W_Q_DEPTH_Msk                    /*!< Write queue depth */
#define DDRCTRL_DBGCAM_DBG_W_Q_DEPTH_0            (0x1U << DDRCTRL_DBGCAM_DBG_W_Q_DEPTH_Pos)          /*!< 0x00010000 */
#define DDRCTRL_DBGCAM_DBG_W_Q_DEPTH_1            (0x2U << DDRCTRL_DBGCAM_DBG_W_Q_DEPTH_Pos)          /*!< 0x00020000 */
#define DDRCTRL_DBGCAM_DBG_W_Q_DEPTH_2            (0x4U << DDRCTRL_DBGCAM_DBG_W_Q_DEPTH_Pos)          /*!< 0x00040000 */
#define DDRCTRL_DBGCAM_DBG_W_Q_DEPTH_3            (0x8U << DDRCTRL_DBGCAM_DBG_W_Q_DEPTH_Pos)          /*!< 0x00080000 */
#define DDRCTRL_DBGCAM_DBG_W_Q_DEPTH_4            (0x10U << DDRCTRL_DBGCAM_DBG_W_Q_DEPTH_Pos)         /*!< 0x00100000 */
#define DDRCTRL_DBGCAM_DBG_STALL_Pos              (24U)
#define DDRCTRL_DBGCAM_DBG_STALL_Msk              (0x1U << DDRCTRL_DBGCAM_DBG_STALL_Pos)              /*!< 0x01000000 */
#define DDRCTRL_DBGCAM_DBG_STALL                  DDRCTRL_DBGCAM_DBG_STALL_Msk                        /*!< Stall */
#define DDRCTRL_DBGCAM_DBG_RD_Q_EMPTY_Pos         (25U)
#define DDRCTRL_DBGCAM_DBG_RD_Q_EMPTY_Msk         (0x1U << DDRCTRL_DBGCAM_DBG_RD_Q_EMPTY_Pos)         /*!< 0x02000000 */
#define DDRCTRL_DBGCAM_DBG_RD_Q_EMPTY             DDRCTRL_DBGCAM_DBG_RD_Q_EMPTY_Msk                   /*!< When 1, all the Read command queues and Read data buffers inside DDRC are empty. This register is to be used for debug purpose. */
#define DDRCTRL_DBGCAM_DBG_WR_Q_EMPTY_Pos         (26U)
#define DDRCTRL_DBGCAM_DBG_WR_Q_EMPTY_Msk         (0x1U << DDRCTRL_DBGCAM_DBG_WR_Q_EMPTY_Pos)         /*!< 0x04000000 */
#define DDRCTRL_DBGCAM_DBG_WR_Q_EMPTY             DDRCTRL_DBGCAM_DBG_WR_Q_EMPTY_Msk                   /*!< When 1, all the Write command queues and Write data buffers inside DDRC are empty. This register is to be used for debug purpose. */
#define DDRCTRL_DBGCAM_RD_DATA_PIPELINE_EMPTY_Pos (28U)
#define DDRCTRL_DBGCAM_RD_DATA_PIPELINE_EMPTY_Msk (0x1U << DDRCTRL_DBGCAM_RD_DATA_PIPELINE_EMPTY_Pos) /*!< 0x10000000 */
#define DDRCTRL_DBGCAM_RD_DATA_PIPELINE_EMPTY     DDRCTRL_DBGCAM_RD_DATA_PIPELINE_EMPTY_Msk           /*!< This bit indicates that the read data pipeline on the DFI interface is empty. This register is intended to be polled at least twice after setting DBG1.dis_dq, to ensure that all remaining commands/data have completed. */
#define DDRCTRL_DBGCAM_WR_DATA_PIPELINE_EMPTY_Pos (29U)
#define DDRCTRL_DBGCAM_WR_DATA_PIPELINE_EMPTY_Msk (0x1U << DDRCTRL_DBGCAM_WR_DATA_PIPELINE_EMPTY_Pos) /*!< 0x20000000 */
#define DDRCTRL_DBGCAM_WR_DATA_PIPELINE_EMPTY     DDRCTRL_DBGCAM_WR_DATA_PIPELINE_EMPTY_Msk           /*!< This bit indicates that the write data pipeline on the DFI interface is empty. This register is intended to be polled at least twice after setting DBG1.dis_dq, to ensure that all remaining commands/data have completed. */

/****************  Bit definition for DDRCTRL_DBGCMD register  ****************/
#define DDRCTRL_DBGCMD_RANK0_REFRESH_Pos  (0U)
#define DDRCTRL_DBGCMD_RANK0_REFRESH_Msk  (0x1U << DDRCTRL_DBGCMD_RANK0_REFRESH_Pos)  /*!< 0x00000001 */
#define DDRCTRL_DBGCMD_RANK0_REFRESH      DDRCTRL_DBGCMD_RANK0_REFRESH_Msk            /*!< Setting this register bit to 1 indicates to the DDRCTRL to issue a refresh to rank 0. Writing to this bit causes DBGSTAT.rank0_refresh_busy to be set. When DBGSTAT.rank0_refresh_busy is cleared, the command has been stored in DDRCTRL. */
#define DDRCTRL_DBGCMD_ZQ_CALIB_SHORT_Pos (4U)
#define DDRCTRL_DBGCMD_ZQ_CALIB_SHORT_Msk (0x1U << DDRCTRL_DBGCMD_ZQ_CALIB_SHORT_Pos) /*!< 0x00000010 */
#define DDRCTRL_DBGCMD_ZQ_CALIB_SHORT     DDRCTRL_DBGCMD_ZQ_CALIB_SHORT_Msk           /*!< Setting this register bit to 1 indicates to the DDRCTRL to issue a ZQCS (ZQ calibration short)/MPC(ZQ calibration) command to the SDRAM. When this request is stored in the DDRCTRL, the bit is automatically cleared. This operation can be performed only when ZQCTL0.dis_auto_zq=1. It is recommended NOT to set this register bit if in Init, in Self-Refresh(except LPDDR4) or SR-Powerdown(LPDDR4) or Deep power-down operating modes or maximum power saving mode. */
#define DDRCTRL_DBGCMD_CTRLUPD_Pos        (5U)
#define DDRCTRL_DBGCMD_CTRLUPD_Msk        (0x1U << DDRCTRL_DBGCMD_CTRLUPD_Pos)        /*!< 0x00000020 */
#define DDRCTRL_DBGCMD_CTRLUPD            DDRCTRL_DBGCMD_CTRLUPD_Msk                  /*!< Setting this register bit to 1 indicates to the DDRCTRL to issue a dfi_ctrlupd_req to the PHY. When this request is stored in the DDRCTRL, the bit is automatically cleared. This operation must only be performed when DFIUPD0.dis_auto_ctrlupd=1. */

/***************  Bit definition for DDRCTRL_DBGSTAT register  ****************/
#define DDRCTRL_DBGSTAT_RANK0_REFRESH_BUSY_Pos  (0U)
#define DDRCTRL_DBGSTAT_RANK0_REFRESH_BUSY_Msk  (0x1U << DDRCTRL_DBGSTAT_RANK0_REFRESH_BUSY_Pos)  /*!< 0x00000001 */
#define DDRCTRL_DBGSTAT_RANK0_REFRESH_BUSY      DDRCTRL_DBGSTAT_RANK0_REFRESH_BUSY_Msk            /*!< SoC core may initiate a rank0_refresh operation (refresh operation to rank 0) only if this signal is low. This signal goes high in the clock after DBGCMD.rank0_refresh is set to one. It goes low when the rank0_refresh operation is stored in the DDRCTRL. It is recommended not to perform rank0_refresh operations when this signal is high. */
#define DDRCTRL_DBGSTAT_ZQ_CALIB_SHORT_BUSY_Pos (4U)
#define DDRCTRL_DBGSTAT_ZQ_CALIB_SHORT_BUSY_Msk (0x1U << DDRCTRL_DBGSTAT_ZQ_CALIB_SHORT_BUSY_Pos) /*!< 0x00000010 */
#define DDRCTRL_DBGSTAT_ZQ_CALIB_SHORT_BUSY     DDRCTRL_DBGSTAT_ZQ_CALIB_SHORT_BUSY_Msk           /*!< SoC core may initiate a ZQCS (ZQ calibration short) operation only if this signal is low. This signal goes high in the clock after the DDRCTRL accepts the ZQCS request. It goes low when the ZQCS operation is initiated in the DDRCTRL. It is recommended not to perform ZQCS operations when this signal is high. */
#define DDRCTRL_DBGSTAT_CTRLUPD_BUSY_Pos        (5U)
#define DDRCTRL_DBGSTAT_CTRLUPD_BUSY_Msk        (0x1U << DDRCTRL_DBGSTAT_CTRLUPD_BUSY_Pos)        /*!< 0x00000020 */
#define DDRCTRL_DBGSTAT_CTRLUPD_BUSY            DDRCTRL_DBGSTAT_CTRLUPD_BUSY_Msk                  /*!< SoC core may initiate a ctrlupd operation only if this signal is low. This signal goes high in the clock after the DDRCTRL accepts the ctrlupd request. It goes low when the ctrlupd operation is initiated in the DDRCTRL. It is recommended not to perform ctrlupd operations when this signal is high. */

/****************  Bit definition for DDRCTRL_SWCTL register  *****************/
#define DDRCTRL_SWCTL_SW_DONE_Pos (0U)
#define DDRCTRL_SWCTL_SW_DONE_Msk (0x1U << DDRCTRL_SWCTL_SW_DONE_Pos) /*!< 0x00000001 */
#define DDRCTRL_SWCTL_SW_DONE     DDRCTRL_SWCTL_SW_DONE_Msk           /*!< Enable quasi-dynamic register programming outside reset. Program register to 0 to enable quasi-dynamic programming. Set back register to 1 once programming is done. */

/****************  Bit definition for DDRCTRL_SWSTAT register  ****************/
#define DDRCTRL_SWSTAT_SW_DONE_ACK_Pos (0U)
#define DDRCTRL_SWSTAT_SW_DONE_ACK_Msk (0x1U << DDRCTRL_SWSTAT_SW_DONE_ACK_Pos) /*!< 0x00000001 */
#define DDRCTRL_SWSTAT_SW_DONE_ACK     DDRCTRL_SWSTAT_SW_DONE_ACK_Msk           /*!< Register programming done. This register is the echo of SWCTL.sw_done. Wait for sw_done value 1 to propagate to sw_done_ack at the end of the programming sequence to ensure that the correct registers values are propagated to the destination clock domains. */

/**************  Bit definition for DDRCTRL_POISONCFG register  ***************/
#define DDRCTRL_POISONCFG_WR_POISON_SLVERR_EN_Pos (0U)
#define DDRCTRL_POISONCFG_WR_POISON_SLVERR_EN_Msk (0x1U << DDRCTRL_POISONCFG_WR_POISON_SLVERR_EN_Pos) /*!< 0x00000001 */
#define DDRCTRL_POISONCFG_WR_POISON_SLVERR_EN     DDRCTRL_POISONCFG_WR_POISON_SLVERR_EN_Msk           /*!< If set to 1, enables SLVERR response for write transaction poisoning */
#define DDRCTRL_POISONCFG_WR_POISON_INTR_EN_Pos   (4U)
#define DDRCTRL_POISONCFG_WR_POISON_INTR_EN_Msk   (0x1U << DDRCTRL_POISONCFG_WR_POISON_INTR_EN_Pos)   /*!< 0x00000010 */
#define DDRCTRL_POISONCFG_WR_POISON_INTR_EN       DDRCTRL_POISONCFG_WR_POISON_INTR_EN_Msk             /*!< If set to 1, enables interrupts for write transaction poisoning */
#define DDRCTRL_POISONCFG_WR_POISON_INTR_CLR_Pos  (8U)
#define DDRCTRL_POISONCFG_WR_POISON_INTR_CLR_Msk  (0x1U << DDRCTRL_POISONCFG_WR_POISON_INTR_CLR_Pos)  /*!< 0x00000100 */
#define DDRCTRL_POISONCFG_WR_POISON_INTR_CLR      DDRCTRL_POISONCFG_WR_POISON_INTR_CLR_Msk            /*!< Interrupt clear for write transaction poisoning. Allow 2/3 clock cycles for correct value to propagate to core logic and clear the interrupts. */
#define DDRCTRL_POISONCFG_RD_POISON_SLVERR_EN_Pos (16U)
#define DDRCTRL_POISONCFG_RD_POISON_SLVERR_EN_Msk (0x1U << DDRCTRL_POISONCFG_RD_POISON_SLVERR_EN_Pos) /*!< 0x00010000 */
#define DDRCTRL_POISONCFG_RD_POISON_SLVERR_EN     DDRCTRL_POISONCFG_RD_POISON_SLVERR_EN_Msk           /*!< If set to 1, enables SLVERR response for read transaction poisoning */
#define DDRCTRL_POISONCFG_RD_POISON_INTR_EN_Pos   (20U)
#define DDRCTRL_POISONCFG_RD_POISON_INTR_EN_Msk   (0x1U << DDRCTRL_POISONCFG_RD_POISON_INTR_EN_Pos)   /*!< 0x00100000 */
#define DDRCTRL_POISONCFG_RD_POISON_INTR_EN       DDRCTRL_POISONCFG_RD_POISON_INTR_EN_Msk             /*!< If set to 1, enables interrupts for read transaction poisoning */
#define DDRCTRL_POISONCFG_RD_POISON_INTR_CLR_Pos  (24U)
#define DDRCTRL_POISONCFG_RD_POISON_INTR_CLR_Msk  (0x1U << DDRCTRL_POISONCFG_RD_POISON_INTR_CLR_Pos)  /*!< 0x01000000 */
#define DDRCTRL_POISONCFG_RD_POISON_INTR_CLR      DDRCTRL_POISONCFG_RD_POISON_INTR_CLR_Msk            /*!< Interrupt clear for read transaction poisoning. Allow 2/3 clock cycles for correct value to propagate to core logic and clear the interrupts. */

/**************  Bit definition for DDRCTRL_POISONSTAT register  **************/
#define DDRCTRL_POISONSTAT_WR_POISON_INTR_0_Pos (0U)
#define DDRCTRL_POISONSTAT_WR_POISON_INTR_0_Msk (0x1U << DDRCTRL_POISONSTAT_WR_POISON_INTR_0_Pos) /*!< 0x00000001 */
#define DDRCTRL_POISONSTAT_WR_POISON_INTR_0     DDRCTRL_POISONSTAT_WR_POISON_INTR_0_Msk           /*!< Write transaction poisoning error interrupt for port 0. This register is a APB clock copy (double register synchronizer) of the interrupt asserted when a transaction is poisoned on the corresponding AXI port\qs write address channel. Bit 0 corresponds to Port 0, and so on. Interrupt is cleared by register wr_poison_intr_clr, then value propagated to APB clock. */
#define DDRCTRL_POISONSTAT_WR_POISON_INTR_1_Pos (1U)
#define DDRCTRL_POISONSTAT_WR_POISON_INTR_1_Msk (0x1U << DDRCTRL_POISONSTAT_WR_POISON_INTR_1_Pos) /*!< 0x00000002 */
#define DDRCTRL_POISONSTAT_WR_POISON_INTR_1     DDRCTRL_POISONSTAT_WR_POISON_INTR_1_Msk           /*!< Write transaction poisoning error interrupt for port 1. This register is a APB clock copy (double register synchronizer) of the interrupt asserted when a transaction is poisoned on the corresponding AXI port\qs write address channel. Bit 0 corresponds to Port 0, and so on. Interrupt is cleared by register wr_poison_intr_clr, then value propagated to APB clock. */
#define DDRCTRL_POISONSTAT_RD_POISON_INTR_0_Pos (16U)
#define DDRCTRL_POISONSTAT_RD_POISON_INTR_0_Msk (0x1U << DDRCTRL_POISONSTAT_RD_POISON_INTR_0_Pos) /*!< 0x00010000 */
#define DDRCTRL_POISONSTAT_RD_POISON_INTR_0     DDRCTRL_POISONSTAT_RD_POISON_INTR_0_Msk           /*!< Read transaction poisoning error interrupt for port 0. This register is a APB clock copy (double register synchronizer) of the interrupt asserted when a transaction is poisoned on the corresponding AXI port\qs read address channel. Bit 0 corresponds to Port 0, and so on. Interrupt is cleared by register rd_poison_intr_clr, then value propagated to APB clock. */
#define DDRCTRL_POISONSTAT_RD_POISON_INTR_1_Pos (17U)
#define DDRCTRL_POISONSTAT_RD_POISON_INTR_1_Msk (0x1U << DDRCTRL_POISONSTAT_RD_POISON_INTR_1_Pos) /*!< 0x00020000 */
#define DDRCTRL_POISONSTAT_RD_POISON_INTR_1     DDRCTRL_POISONSTAT_RD_POISON_INTR_1_Msk           /*!< Read transaction poisoning error interrupt for port 1. This register is a APB clock copy (double register synchronizer) of the interrupt asserted when a transaction is poisoned on the corresponding AXI port\qs read address channel. Bit 0 corresponds to Port 0, and so on. Interrupt is cleared by register rd_poison_intr_clr, then value propagated to APB clock. */

/****************  Bit definition for DDRCTRL_PSTAT register  *****************/
#define DDRCTRL_PSTAT_RD_PORT_BUSY_0_Pos (0U)
#define DDRCTRL_PSTAT_RD_PORT_BUSY_0_Msk (0x1U << DDRCTRL_PSTAT_RD_PORT_BUSY_0_Pos) /*!< 0x00000001 */
#define DDRCTRL_PSTAT_RD_PORT_BUSY_0     DDRCTRL_PSTAT_RD_PORT_BUSY_0_Msk           /*!< Indicates if there are outstanding reads for AXI port 0. */
#define DDRCTRL_PSTAT_RD_PORT_BUSY_1_Pos (1U)
#define DDRCTRL_PSTAT_RD_PORT_BUSY_1_Msk (0x1U << DDRCTRL_PSTAT_RD_PORT_BUSY_1_Pos) /*!< 0x00000002 */
#define DDRCTRL_PSTAT_RD_PORT_BUSY_1     DDRCTRL_PSTAT_RD_PORT_BUSY_1_Msk           /*!< Indicates if there are outstanding reads for AXI port 1. */
#define DDRCTRL_PSTAT_WR_PORT_BUSY_0_Pos (16U)
#define DDRCTRL_PSTAT_WR_PORT_BUSY_0_Msk (0x1U << DDRCTRL_PSTAT_WR_PORT_BUSY_0_Pos) /*!< 0x00010000 */
#define DDRCTRL_PSTAT_WR_PORT_BUSY_0     DDRCTRL_PSTAT_WR_PORT_BUSY_0_Msk           /*!< Indicates if there are outstanding writes for AXI port 0. */
#define DDRCTRL_PSTAT_WR_PORT_BUSY_1_Pos (17U)
#define DDRCTRL_PSTAT_WR_PORT_BUSY_1_Msk (0x1U << DDRCTRL_PSTAT_WR_PORT_BUSY_1_Pos) /*!< 0x00020000 */
#define DDRCTRL_PSTAT_WR_PORT_BUSY_1     DDRCTRL_PSTAT_WR_PORT_BUSY_1_Msk           /*!< Indicates if there are outstanding writes for AXI port 1. */

/****************  Bit definition for DDRCTRL_PCCFG register  *****************/
#define DDRCTRL_PCCFG_GO2CRITICAL_EN_Pos  (0U)
#define DDRCTRL_PCCFG_GO2CRITICAL_EN_Msk  (0x1U << DDRCTRL_PCCFG_GO2CRITICAL_EN_Pos) /*!< 0x00000001 */
#define DDRCTRL_PCCFG_GO2CRITICAL_EN      DDRCTRL_PCCFG_GO2CRITICAL_EN_Msk           /*!< If set to 1 (enabled), sets co_gs_go2critical_wr and co_gs_go2critical_lpr/co_gs_go2critical_hpr signals going to DDRC based on urgent input (awurgent, arurgent) coming from AXI master. If set to 0 (disabled), co_gs_go2critical_wr and co_gs_go2critical_lpr/co_gs_go2critical_hpr signals at DDRC are driven to 1b\q0. */
#define DDRCTRL_PCCFG_PAGEMATCH_LIMIT_Pos (4U)
#define DDRCTRL_PCCFG_PAGEMATCH_LIMIT_Msk (0x1U << DDRCTRL_PCCFG_PAGEMATCH_LIMIT_Pos) /*!< 0x00000010 */
#define DDRCTRL_PCCFG_PAGEMATCH_LIMIT     DDRCTRL_PCCFG_PAGEMATCH_LIMIT_Msk           /*!< Page match four limit. If set to 1, limits the number of consecutive same page DDRC transactions that can be granted by the Port Arbiter to four when Page Match feature is enabled. If set to 0, there is no limit imposed on number of consecutive same page DDRC transactions. */
#define DDRCTRL_PCCFG_BL_EXP_MODE_Pos     (8U)
#define DDRCTRL_PCCFG_BL_EXP_MODE_Msk     (0x1U << DDRCTRL_PCCFG_BL_EXP_MODE_Pos)     /*!< 0x00000100 */
#define DDRCTRL_PCCFG_BL_EXP_MODE         DDRCTRL_PCCFG_BL_EXP_MODE_Msk               /*!< Burst length expansion mode. By default (i.e. bl_exp_mode==0) XPI expands every AXI burst into multiple HIF commands, using the memory burst length as a unit. If set to 1, then XPI uses half of the memory burst length as a unit. */

/***************  Bit definition for DDRCTRL_PCFGR_0 register  ****************/
#define DDRCTRL_PCFGR_0_RD_PORT_PRIORITY_Pos     (0U)
#define DDRCTRL_PCFGR_0_RD_PORT_PRIORITY_Msk     (0x3FFU << DDRCTRL_PCFGR_0_RD_PORT_PRIORITY_Pos)   /*!< 0x000003FF */
#define DDRCTRL_PCFGR_0_RD_PORT_PRIORITY         DDRCTRL_PCFGR_0_RD_PORT_PRIORITY_Msk               /*!< Determines the initial load value of read aging counters. These counters are parallel loaded after reset, or after each grant to the corresponding port. The aging counters down-count every clock cycle where the port is requesting but not granted. The higher significant 5-bits of the read aging counter sets the priority of the read channel of a given port. Port\qs priority increases as the higher significant 5-bits of the counter starts to decrease. When the aging counter becomes 0, the corresponding port channel has the highest priority level (timeout condition - Priority0). For multi-port configurations, the aging counters cannot be used to set port priorities when external dynamic priority inputs (arqos) are enabled (timeout is still applicable). For single port configurations, the aging counters are only used when they timeout (become 0) to force read-write direction switching. In this case, external dynamic priority input, arqos (for reads only) can still be used to set the DDRC read priority (2 priority levels: low priority read - LPR, high priority read - HPR) on a command by command basis. */
#define DDRCTRL_PCFGR_0_RD_PORT_PRIORITY_0       (0x1U << DDRCTRL_PCFGR_0_RD_PORT_PRIORITY_Pos)     /*!< 0x00000001 */
#define DDRCTRL_PCFGR_0_RD_PORT_PRIORITY_1       (0x2U << DDRCTRL_PCFGR_0_RD_PORT_PRIORITY_Pos)     /*!< 0x00000002 */
#define DDRCTRL_PCFGR_0_RD_PORT_PRIORITY_2       (0x4U << DDRCTRL_PCFGR_0_RD_PORT_PRIORITY_Pos)     /*!< 0x00000004 */
#define DDRCTRL_PCFGR_0_RD_PORT_PRIORITY_3       (0x8U << DDRCTRL_PCFGR_0_RD_PORT_PRIORITY_Pos)     /*!< 0x00000008 */
#define DDRCTRL_PCFGR_0_RD_PORT_PRIORITY_4       (0x10U << DDRCTRL_PCFGR_0_RD_PORT_PRIORITY_Pos)    /*!< 0x00000010 */
#define DDRCTRL_PCFGR_0_RD_PORT_PRIORITY_5       (0x20U << DDRCTRL_PCFGR_0_RD_PORT_PRIORITY_Pos)    /*!< 0x00000020 */
#define DDRCTRL_PCFGR_0_RD_PORT_PRIORITY_6       (0x40U << DDRCTRL_PCFGR_0_RD_PORT_PRIORITY_Pos)    /*!< 0x00000040 */
#define DDRCTRL_PCFGR_0_RD_PORT_PRIORITY_7       (0x80U << DDRCTRL_PCFGR_0_RD_PORT_PRIORITY_Pos)    /*!< 0x00000080 */
#define DDRCTRL_PCFGR_0_RD_PORT_PRIORITY_8       (0x100U << DDRCTRL_PCFGR_0_RD_PORT_PRIORITY_Pos)   /*!< 0x00000100 */
#define DDRCTRL_PCFGR_0_RD_PORT_PRIORITY_9       (0x200U << DDRCTRL_PCFGR_0_RD_PORT_PRIORITY_Pos)   /*!< 0x00000200 */
#define DDRCTRL_PCFGR_0_RD_PORT_AGING_EN_Pos     (12U)
#define DDRCTRL_PCFGR_0_RD_PORT_AGING_EN_Msk     (0x1U << DDRCTRL_PCFGR_0_RD_PORT_AGING_EN_Pos)     /*!< 0x00001000 */
#define DDRCTRL_PCFGR_0_RD_PORT_AGING_EN         DDRCTRL_PCFGR_0_RD_PORT_AGING_EN_Msk               /*!< If set to 1, enables aging function for the read channel of the port. */
#define DDRCTRL_PCFGR_0_RD_PORT_URGENT_EN_Pos    (13U)
#define DDRCTRL_PCFGR_0_RD_PORT_URGENT_EN_Msk    (0x1U << DDRCTRL_PCFGR_0_RD_PORT_URGENT_EN_Pos)    /*!< 0x00002000 */
#define DDRCTRL_PCFGR_0_RD_PORT_URGENT_EN        DDRCTRL_PCFGR_0_RD_PORT_URGENT_EN_Msk              /*!< If set to 1, enables the AXI urgent sideband signal (arurgent). When enabled and arurgent is asserted by the master, that port becomes the highest priority and co_gs_go2critical_lpr/co_gs_go2critical_hpr signal to DDRC is asserted if enabled in PCCFG.go2critical_en register. Note that arurgent signal can be asserted anytime and as long as required which is independent of address handshaking (it is not associated with any particular command). */
#define DDRCTRL_PCFGR_0_RD_PORT_PAGEMATCH_EN_Pos (14U)
#define DDRCTRL_PCFGR_0_RD_PORT_PAGEMATCH_EN_Msk (0x1U << DDRCTRL_PCFGR_0_RD_PORT_PAGEMATCH_EN_Pos) /*!< 0x00004000 */
#define DDRCTRL_PCFGR_0_RD_PORT_PAGEMATCH_EN     DDRCTRL_PCFGR_0_RD_PORT_PAGEMATCH_EN_Msk           /*!< If set to 1, enables the Page Match feature. If enabled, once a requesting port is granted, the port is continued to be granted if the following immediate commands are to the same memory page (same bank and same row). See also related PCCFG.pagematch_limit register. */
#define DDRCTRL_PCFGR_0_RDWR_ORDERED_EN_Pos      (16U)
#define DDRCTRL_PCFGR_0_RDWR_ORDERED_EN_Msk      (0x1U << DDRCTRL_PCFGR_0_RDWR_ORDERED_EN_Pos)      /*!< 0x00010000 */
#define DDRCTRL_PCFGR_0_RDWR_ORDERED_EN          DDRCTRL_PCFGR_0_RDWR_ORDERED_EN_Msk                /*!< Enables ordered read/writes. If set to 1, preserves the ordering between read transaction and write transaction issued to the same address, on a given port. In other words, the controller ensures that all same address read and write commands from the application port interface are transported to the DFI interface in the order of acceptance. This feature is useful in cases where software coherency is desired for masters issuing back-to-back read/write transactions without waiting for write/read responses. Note that this register has an effect only if necessary logic is instantiated via the UMCTL2_RDWR_ORDERED_n parameter. */

/***************  Bit definition for DDRCTRL_PCFGW_0 register  ****************/
#define DDRCTRL_PCFGW_0_WR_PORT_PRIORITY_Pos     (0U)
#define DDRCTRL_PCFGW_0_WR_PORT_PRIORITY_Msk     (0x3FFU << DDRCTRL_PCFGW_0_WR_PORT_PRIORITY_Pos)   /*!< 0x000003FF */
#define DDRCTRL_PCFGW_0_WR_PORT_PRIORITY         DDRCTRL_PCFGW_0_WR_PORT_PRIORITY_Msk               /*!< Determines the initial load value of write aging counters. These counters are parallel loaded after reset, or after each grant to the corresponding port. The aging counters down-count every clock cycle where the port is requesting but not granted. The higher significant 5-bits of the write aging counter sets the initial priority of the write channel of a given port. Port\qs priority increases as the higher significant 5-bits of the counter starts to decrease. When the aging counter becomes 0, the corresponding port channel has the highest priority level. */
#define DDRCTRL_PCFGW_0_WR_PORT_PRIORITY_0       (0x1U << DDRCTRL_PCFGW_0_WR_PORT_PRIORITY_Pos)     /*!< 0x00000001 */
#define DDRCTRL_PCFGW_0_WR_PORT_PRIORITY_1       (0x2U << DDRCTRL_PCFGW_0_WR_PORT_PRIORITY_Pos)     /*!< 0x00000002 */
#define DDRCTRL_PCFGW_0_WR_PORT_PRIORITY_2       (0x4U << DDRCTRL_PCFGW_0_WR_PORT_PRIORITY_Pos)     /*!< 0x00000004 */
#define DDRCTRL_PCFGW_0_WR_PORT_PRIORITY_3       (0x8U << DDRCTRL_PCFGW_0_WR_PORT_PRIORITY_Pos)     /*!< 0x00000008 */
#define DDRCTRL_PCFGW_0_WR_PORT_PRIORITY_4       (0x10U << DDRCTRL_PCFGW_0_WR_PORT_PRIORITY_Pos)    /*!< 0x00000010 */
#define DDRCTRL_PCFGW_0_WR_PORT_PRIORITY_5       (0x20U << DDRCTRL_PCFGW_0_WR_PORT_PRIORITY_Pos)    /*!< 0x00000020 */
#define DDRCTRL_PCFGW_0_WR_PORT_PRIORITY_6       (0x40U << DDRCTRL_PCFGW_0_WR_PORT_PRIORITY_Pos)    /*!< 0x00000040 */
#define DDRCTRL_PCFGW_0_WR_PORT_PRIORITY_7       (0x80U << DDRCTRL_PCFGW_0_WR_PORT_PRIORITY_Pos)    /*!< 0x00000080 */
#define DDRCTRL_PCFGW_0_WR_PORT_PRIORITY_8       (0x100U << DDRCTRL_PCFGW_0_WR_PORT_PRIORITY_Pos)   /*!< 0x00000100 */
#define DDRCTRL_PCFGW_0_WR_PORT_PRIORITY_9       (0x200U << DDRCTRL_PCFGW_0_WR_PORT_PRIORITY_Pos)   /*!< 0x00000200 */
#define DDRCTRL_PCFGW_0_WR_PORT_AGING_EN_Pos     (12U)
#define DDRCTRL_PCFGW_0_WR_PORT_AGING_EN_Msk     (0x1U << DDRCTRL_PCFGW_0_WR_PORT_AGING_EN_Pos)     /*!< 0x00001000 */
#define DDRCTRL_PCFGW_0_WR_PORT_AGING_EN         DDRCTRL_PCFGW_0_WR_PORT_AGING_EN_Msk               /*!< If set to 1, enables aging function for the write channel of the port. */
#define DDRCTRL_PCFGW_0_WR_PORT_URGENT_EN_Pos    (13U)
#define DDRCTRL_PCFGW_0_WR_PORT_URGENT_EN_Msk    (0x1U << DDRCTRL_PCFGW_0_WR_PORT_URGENT_EN_Pos)    /*!< 0x00002000 */
#define DDRCTRL_PCFGW_0_WR_PORT_URGENT_EN        DDRCTRL_PCFGW_0_WR_PORT_URGENT_EN_Msk              /*!< If set to 1, enables the AXI urgent sideband signal (awurgent). When enabled and awurgent is asserted by the master, that port becomes the highest priority and co_gs_go2critical_wr signal to DDRC is asserted if enabled in PCCFG.go2critical_en register. */
#define DDRCTRL_PCFGW_0_WR_PORT_PAGEMATCH_EN_Pos (14U)
#define DDRCTRL_PCFGW_0_WR_PORT_PAGEMATCH_EN_Msk (0x1U << DDRCTRL_PCFGW_0_WR_PORT_PAGEMATCH_EN_Pos) /*!< 0x00004000 */
#define DDRCTRL_PCFGW_0_WR_PORT_PAGEMATCH_EN     DDRCTRL_PCFGW_0_WR_PORT_PAGEMATCH_EN_Msk           /*!< If set to 1, enables the Page Match feature. If enabled, once a requesting port is granted, the port is continued to be granted if the following immediate commands are to the same memory page (same bank and same row). See also related PCCFG.pagematch_limit register. */

/***************  Bit definition for DDRCTRL_PCTRL_0 register  ****************/
#define DDRCTRL_PCTRL_0_PORT_EN_Pos (0U)
#define DDRCTRL_PCTRL_0_PORT_EN_Msk (0x1U << DDRCTRL_PCTRL_0_PORT_EN_Pos) /*!< 0x00000001 */
#define DDRCTRL_PCTRL_0_PORT_EN     DDRCTRL_PCTRL_0_PORT_EN_Msk           /*!< Enables AXI port n. */

/**************  Bit definition for DDRCTRL_PCFGQOS0_0 register  **************/
#define DDRCTRL_PCFGQOS0_0_RQOS_MAP_LEVEL1_Pos  (0U)
#define DDRCTRL_PCFGQOS0_0_RQOS_MAP_LEVEL1_Msk  (0xFU << DDRCTRL_PCFGQOS0_0_RQOS_MAP_LEVEL1_Pos)  /*!< 0x0000000F */
#define DDRCTRL_PCFGQOS0_0_RQOS_MAP_LEVEL1      DDRCTRL_PCFGQOS0_0_RQOS_MAP_LEVEL1_Msk            /*!< Separation level1 indicating the end of region0 mapping; start of region0 is 0. Possible values for level1 are 0 to 13 (for dual RAQ) or 0 to 14 (for single RAQ) which corresponds to arqos. */
#define DDRCTRL_PCFGQOS0_0_RQOS_MAP_LEVEL1_0    (0x1U << DDRCTRL_PCFGQOS0_0_RQOS_MAP_LEVEL1_Pos)  /*!< 0x00000001 */
#define DDRCTRL_PCFGQOS0_0_RQOS_MAP_LEVEL1_1    (0x2U << DDRCTRL_PCFGQOS0_0_RQOS_MAP_LEVEL1_Pos)  /*!< 0x00000002 */
#define DDRCTRL_PCFGQOS0_0_RQOS_MAP_LEVEL1_2    (0x4U << DDRCTRL_PCFGQOS0_0_RQOS_MAP_LEVEL1_Pos)  /*!< 0x00000004 */
#define DDRCTRL_PCFGQOS0_0_RQOS_MAP_LEVEL1_3    (0x8U << DDRCTRL_PCFGQOS0_0_RQOS_MAP_LEVEL1_Pos)  /*!< 0x00000008 */
#define DDRCTRL_PCFGQOS0_0_RQOS_MAP_LEVEL2_Pos  (8U)
#define DDRCTRL_PCFGQOS0_0_RQOS_MAP_LEVEL2_Msk  (0xFU << DDRCTRL_PCFGQOS0_0_RQOS_MAP_LEVEL2_Pos)  /*!< 0x00000F00 */
#define DDRCTRL_PCFGQOS0_0_RQOS_MAP_LEVEL2      DDRCTRL_PCFGQOS0_0_RQOS_MAP_LEVEL2_Msk            /*!< Separation level2 indicating the end of region1 mapping; start of region1 is (level1 + 1). Possible values for level2 are (level1 + 1) to 14 which corresponds to arqos. */
#define DDRCTRL_PCFGQOS0_0_RQOS_MAP_LEVEL2_0    (0x1U << DDRCTRL_PCFGQOS0_0_RQOS_MAP_LEVEL2_Pos)  /*!< 0x00000100 */
#define DDRCTRL_PCFGQOS0_0_RQOS_MAP_LEVEL2_1    (0x2U << DDRCTRL_PCFGQOS0_0_RQOS_MAP_LEVEL2_Pos)  /*!< 0x00000200 */
#define DDRCTRL_PCFGQOS0_0_RQOS_MAP_LEVEL2_2    (0x4U << DDRCTRL_PCFGQOS0_0_RQOS_MAP_LEVEL2_Pos)  /*!< 0x00000400 */
#define DDRCTRL_PCFGQOS0_0_RQOS_MAP_LEVEL2_3    (0x8U << DDRCTRL_PCFGQOS0_0_RQOS_MAP_LEVEL2_Pos)  /*!< 0x00000800 */
#define DDRCTRL_PCFGQOS0_0_RQOS_MAP_REGION0_Pos (16U)
#define DDRCTRL_PCFGQOS0_0_RQOS_MAP_REGION0_Msk (0x3U << DDRCTRL_PCFGQOS0_0_RQOS_MAP_REGION0_Pos) /*!< 0x00030000 */
#define DDRCTRL_PCFGQOS0_0_RQOS_MAP_REGION0     DDRCTRL_PCFGQOS0_0_RQOS_MAP_REGION0_Msk           /*!< This bitfield indicates the traffic class of region 0. */
#define DDRCTRL_PCFGQOS0_0_RQOS_MAP_REGION0_0   (0x1U << DDRCTRL_PCFGQOS0_0_RQOS_MAP_REGION0_Pos) /*!< 0x00010000 */
#define DDRCTRL_PCFGQOS0_0_RQOS_MAP_REGION0_1   (0x2U << DDRCTRL_PCFGQOS0_0_RQOS_MAP_REGION0_Pos) /*!< 0x00020000 */
#define DDRCTRL_PCFGQOS0_0_RQOS_MAP_REGION1_Pos (20U)
#define DDRCTRL_PCFGQOS0_0_RQOS_MAP_REGION1_Msk (0x3U << DDRCTRL_PCFGQOS0_0_RQOS_MAP_REGION1_Pos) /*!< 0x00300000 */
#define DDRCTRL_PCFGQOS0_0_RQOS_MAP_REGION1     DDRCTRL_PCFGQOS0_0_RQOS_MAP_REGION1_Msk           /*!< This bitfield indicates the traffic class of region 1. */
#define DDRCTRL_PCFGQOS0_0_RQOS_MAP_REGION1_0   (0x1U << DDRCTRL_PCFGQOS0_0_RQOS_MAP_REGION1_Pos) /*!< 0x00100000 */
#define DDRCTRL_PCFGQOS0_0_RQOS_MAP_REGION1_1   (0x2U << DDRCTRL_PCFGQOS0_0_RQOS_MAP_REGION1_Pos) /*!< 0x00200000 */
#define DDRCTRL_PCFGQOS0_0_RQOS_MAP_REGION2_Pos (24U)
#define DDRCTRL_PCFGQOS0_0_RQOS_MAP_REGION2_Msk (0x3U << DDRCTRL_PCFGQOS0_0_RQOS_MAP_REGION2_Pos) /*!< 0x03000000 */
#define DDRCTRL_PCFGQOS0_0_RQOS_MAP_REGION2     DDRCTRL_PCFGQOS0_0_RQOS_MAP_REGION2_Msk           /*!< This bitfield indicates the traffic class of region2. */
#define DDRCTRL_PCFGQOS0_0_RQOS_MAP_REGION2_0   (0x1U << DDRCTRL_PCFGQOS0_0_RQOS_MAP_REGION2_Pos) /*!< 0x01000000 */
#define DDRCTRL_PCFGQOS0_0_RQOS_MAP_REGION2_1   (0x2U << DDRCTRL_PCFGQOS0_0_RQOS_MAP_REGION2_Pos) /*!< 0x02000000 */

/**************  Bit definition for DDRCTRL_PCFGQOS1_0 register  **************/
#define DDRCTRL_PCFGQOS1_0_RQOS_MAP_TIMEOUTB_Pos (0U)
#define DDRCTRL_PCFGQOS1_0_RQOS_MAP_TIMEOUTB_Msk (0x7FFU << DDRCTRL_PCFGQOS1_0_RQOS_MAP_TIMEOUTB_Pos) /*!< 0x000007FF */
#define DDRCTRL_PCFGQOS1_0_RQOS_MAP_TIMEOUTB     DDRCTRL_PCFGQOS1_0_RQOS_MAP_TIMEOUTB_Msk             /*!< Specifies the timeout value for transactions mapped to the blue address queue. */
#define DDRCTRL_PCFGQOS1_0_RQOS_MAP_TIMEOUTB_0   (0x1U << DDRCTRL_PCFGQOS1_0_RQOS_MAP_TIMEOUTB_Pos)   /*!< 0x00000001 */
#define DDRCTRL_PCFGQOS1_0_RQOS_MAP_TIMEOUTB_1   (0x2U << DDRCTRL_PCFGQOS1_0_RQOS_MAP_TIMEOUTB_Pos)   /*!< 0x00000002 */
#define DDRCTRL_PCFGQOS1_0_RQOS_MAP_TIMEOUTB_2   (0x4U << DDRCTRL_PCFGQOS1_0_RQOS_MAP_TIMEOUTB_Pos)   /*!< 0x00000004 */
#define DDRCTRL_PCFGQOS1_0_RQOS_MAP_TIMEOUTB_3   (0x8U << DDRCTRL_PCFGQOS1_0_RQOS_MAP_TIMEOUTB_Pos)   /*!< 0x00000008 */
#define DDRCTRL_PCFGQOS1_0_RQOS_MAP_TIMEOUTB_4   (0x10U << DDRCTRL_PCFGQOS1_0_RQOS_MAP_TIMEOUTB_Pos)  /*!< 0x00000010 */
#define DDRCTRL_PCFGQOS1_0_RQOS_MAP_TIMEOUTB_5   (0x20U << DDRCTRL_PCFGQOS1_0_RQOS_MAP_TIMEOUTB_Pos)  /*!< 0x00000020 */
#define DDRCTRL_PCFGQOS1_0_RQOS_MAP_TIMEOUTB_6   (0x40U << DDRCTRL_PCFGQOS1_0_RQOS_MAP_TIMEOUTB_Pos)  /*!< 0x00000040 */
#define DDRCTRL_PCFGQOS1_0_RQOS_MAP_TIMEOUTB_7   (0x80U << DDRCTRL_PCFGQOS1_0_RQOS_MAP_TIMEOUTB_Pos)  /*!< 0x00000080 */
#define DDRCTRL_PCFGQOS1_0_RQOS_MAP_TIMEOUTB_8   (0x100U << DDRCTRL_PCFGQOS1_0_RQOS_MAP_TIMEOUTB_Pos) /*!< 0x00000100 */
#define DDRCTRL_PCFGQOS1_0_RQOS_MAP_TIMEOUTB_9   (0x200U << DDRCTRL_PCFGQOS1_0_RQOS_MAP_TIMEOUTB_Pos) /*!< 0x00000200 */
#define DDRCTRL_PCFGQOS1_0_RQOS_MAP_TIMEOUTB_10  (0x400U << DDRCTRL_PCFGQOS1_0_RQOS_MAP_TIMEOUTB_Pos) /*!< 0x00000400 */
#define DDRCTRL_PCFGQOS1_0_RQOS_MAP_TIMEOUTR_Pos (16U)
#define DDRCTRL_PCFGQOS1_0_RQOS_MAP_TIMEOUTR_Msk (0x7FFU << DDRCTRL_PCFGQOS1_0_RQOS_MAP_TIMEOUTR_Pos) /*!< 0x07FF0000 */
#define DDRCTRL_PCFGQOS1_0_RQOS_MAP_TIMEOUTR     DDRCTRL_PCFGQOS1_0_RQOS_MAP_TIMEOUTR_Msk             /*!< Specifies the timeout value for transactions mapped to the red address queue. */
#define DDRCTRL_PCFGQOS1_0_RQOS_MAP_TIMEOUTR_0   (0x1U << DDRCTRL_PCFGQOS1_0_RQOS_MAP_TIMEOUTR_Pos)   /*!< 0x00010000 */
#define DDRCTRL_PCFGQOS1_0_RQOS_MAP_TIMEOUTR_1   (0x2U << DDRCTRL_PCFGQOS1_0_RQOS_MAP_TIMEOUTR_Pos)   /*!< 0x00020000 */
#define DDRCTRL_PCFGQOS1_0_RQOS_MAP_TIMEOUTR_2   (0x4U << DDRCTRL_PCFGQOS1_0_RQOS_MAP_TIMEOUTR_Pos)   /*!< 0x00040000 */
#define DDRCTRL_PCFGQOS1_0_RQOS_MAP_TIMEOUTR_3   (0x8U << DDRCTRL_PCFGQOS1_0_RQOS_MAP_TIMEOUTR_Pos)   /*!< 0x00080000 */
#define DDRCTRL_PCFGQOS1_0_RQOS_MAP_TIMEOUTR_4   (0x10U << DDRCTRL_PCFGQOS1_0_RQOS_MAP_TIMEOUTR_Pos)  /*!< 0x00100000 */
#define DDRCTRL_PCFGQOS1_0_RQOS_MAP_TIMEOUTR_5   (0x20U << DDRCTRL_PCFGQOS1_0_RQOS_MAP_TIMEOUTR_Pos)  /*!< 0x00200000 */
#define DDRCTRL_PCFGQOS1_0_RQOS_MAP_TIMEOUTR_6   (0x40U << DDRCTRL_PCFGQOS1_0_RQOS_MAP_TIMEOUTR_Pos)  /*!< 0x00400000 */
#define DDRCTRL_PCFGQOS1_0_RQOS_MAP_TIMEOUTR_7   (0x80U << DDRCTRL_PCFGQOS1_0_RQOS_MAP_TIMEOUTR_Pos)  /*!< 0x00800000 */
#define DDRCTRL_PCFGQOS1_0_RQOS_MAP_TIMEOUTR_8   (0x100U << DDRCTRL_PCFGQOS1_0_RQOS_MAP_TIMEOUTR_Pos) /*!< 0x01000000 */
#define DDRCTRL_PCFGQOS1_0_RQOS_MAP_TIMEOUTR_9   (0x200U << DDRCTRL_PCFGQOS1_0_RQOS_MAP_TIMEOUTR_Pos) /*!< 0x02000000 */
#define DDRCTRL_PCFGQOS1_0_RQOS_MAP_TIMEOUTR_10  (0x400U << DDRCTRL_PCFGQOS1_0_RQOS_MAP_TIMEOUTR_Pos) /*!< 0x04000000 */

/*************  Bit definition for DDRCTRL_PCFGWQOS0_0 register  **************/
#define DDRCTRL_PCFGWQOS0_0_WQOS_MAP_LEVEL1_Pos  (0U)
#define DDRCTRL_PCFGWQOS0_0_WQOS_MAP_LEVEL1_Msk  (0xFU << DDRCTRL_PCFGWQOS0_0_WQOS_MAP_LEVEL1_Pos)  /*!< 0x0000000F */
#define DDRCTRL_PCFGWQOS0_0_WQOS_MAP_LEVEL1      DDRCTRL_PCFGWQOS0_0_WQOS_MAP_LEVEL1_Msk            /*!< Separation level indicating the end of region0 mapping; start of region0 is 0. Possible values for level1 are 0 to 13 which corresponds to awqos. */
#define DDRCTRL_PCFGWQOS0_0_WQOS_MAP_LEVEL1_0    (0x1U << DDRCTRL_PCFGWQOS0_0_WQOS_MAP_LEVEL1_Pos)  /*!< 0x00000001 */
#define DDRCTRL_PCFGWQOS0_0_WQOS_MAP_LEVEL1_1    (0x2U << DDRCTRL_PCFGWQOS0_0_WQOS_MAP_LEVEL1_Pos)  /*!< 0x00000002 */
#define DDRCTRL_PCFGWQOS0_0_WQOS_MAP_LEVEL1_2    (0x4U << DDRCTRL_PCFGWQOS0_0_WQOS_MAP_LEVEL1_Pos)  /*!< 0x00000004 */
#define DDRCTRL_PCFGWQOS0_0_WQOS_MAP_LEVEL1_3    (0x8U << DDRCTRL_PCFGWQOS0_0_WQOS_MAP_LEVEL1_Pos)  /*!< 0x00000008 */
#define DDRCTRL_PCFGWQOS0_0_WQOS_MAP_LEVEL2_Pos  (8U)
#define DDRCTRL_PCFGWQOS0_0_WQOS_MAP_LEVEL2_Msk  (0xFU << DDRCTRL_PCFGWQOS0_0_WQOS_MAP_LEVEL2_Pos)  /*!< 0x00000F00 */
#define DDRCTRL_PCFGWQOS0_0_WQOS_MAP_LEVEL2      DDRCTRL_PCFGWQOS0_0_WQOS_MAP_LEVEL2_Msk            /*!< Separation level2 indicating the end of region1 mapping; start of region1 is (level1 + 1). Possible values for level2 are (level1 + 1) to 14 which corresponds to awqos. */
#define DDRCTRL_PCFGWQOS0_0_WQOS_MAP_LEVEL2_0    (0x1U << DDRCTRL_PCFGWQOS0_0_WQOS_MAP_LEVEL2_Pos)  /*!< 0x00000100 */
#define DDRCTRL_PCFGWQOS0_0_WQOS_MAP_LEVEL2_1    (0x2U << DDRCTRL_PCFGWQOS0_0_WQOS_MAP_LEVEL2_Pos)  /*!< 0x00000200 */
#define DDRCTRL_PCFGWQOS0_0_WQOS_MAP_LEVEL2_2    (0x4U << DDRCTRL_PCFGWQOS0_0_WQOS_MAP_LEVEL2_Pos)  /*!< 0x00000400 */
#define DDRCTRL_PCFGWQOS0_0_WQOS_MAP_LEVEL2_3    (0x8U << DDRCTRL_PCFGWQOS0_0_WQOS_MAP_LEVEL2_Pos)  /*!< 0x00000800 */
#define DDRCTRL_PCFGWQOS0_0_WQOS_MAP_REGION0_Pos (16U)
#define DDRCTRL_PCFGWQOS0_0_WQOS_MAP_REGION0_Msk (0x3U << DDRCTRL_PCFGWQOS0_0_WQOS_MAP_REGION0_Pos) /*!< 0x00030000 */
#define DDRCTRL_PCFGWQOS0_0_WQOS_MAP_REGION0     DDRCTRL_PCFGWQOS0_0_WQOS_MAP_REGION0_Msk           /*!< This bitfield indicates the traffic class of region 0. */
#define DDRCTRL_PCFGWQOS0_0_WQOS_MAP_REGION0_0   (0x1U << DDRCTRL_PCFGWQOS0_0_WQOS_MAP_REGION0_Pos) /*!< 0x00010000 */
#define DDRCTRL_PCFGWQOS0_0_WQOS_MAP_REGION0_1   (0x2U << DDRCTRL_PCFGWQOS0_0_WQOS_MAP_REGION0_Pos) /*!< 0x00020000 */
#define DDRCTRL_PCFGWQOS0_0_WQOS_MAP_REGION1_Pos (20U)
#define DDRCTRL_PCFGWQOS0_0_WQOS_MAP_REGION1_Msk (0x3U << DDRCTRL_PCFGWQOS0_0_WQOS_MAP_REGION1_Pos) /*!< 0x00300000 */
#define DDRCTRL_PCFGWQOS0_0_WQOS_MAP_REGION1     DDRCTRL_PCFGWQOS0_0_WQOS_MAP_REGION1_Msk           /*!< This bitfield indicates the traffic class of region 1. */
#define DDRCTRL_PCFGWQOS0_0_WQOS_MAP_REGION1_0   (0x1U << DDRCTRL_PCFGWQOS0_0_WQOS_MAP_REGION1_Pos) /*!< 0x00100000 */
#define DDRCTRL_PCFGWQOS0_0_WQOS_MAP_REGION1_1   (0x2U << DDRCTRL_PCFGWQOS0_0_WQOS_MAP_REGION1_Pos) /*!< 0x00200000 */
#define DDRCTRL_PCFGWQOS0_0_WQOS_MAP_REGION2_Pos (24U)
#define DDRCTRL_PCFGWQOS0_0_WQOS_MAP_REGION2_Msk (0x3U << DDRCTRL_PCFGWQOS0_0_WQOS_MAP_REGION2_Pos) /*!< 0x03000000 */
#define DDRCTRL_PCFGWQOS0_0_WQOS_MAP_REGION2     DDRCTRL_PCFGWQOS0_0_WQOS_MAP_REGION2_Msk           /*!< This bitfield indicates the traffic class of region 2. */
#define DDRCTRL_PCFGWQOS0_0_WQOS_MAP_REGION2_0   (0x1U << DDRCTRL_PCFGWQOS0_0_WQOS_MAP_REGION2_Pos) /*!< 0x01000000 */
#define DDRCTRL_PCFGWQOS0_0_WQOS_MAP_REGION2_1   (0x2U << DDRCTRL_PCFGWQOS0_0_WQOS_MAP_REGION2_Pos) /*!< 0x02000000 */

/*************  Bit definition for DDRCTRL_PCFGWQOS1_0 register  **************/
#define DDRCTRL_PCFGWQOS1_0_WQOS_MAP_TIMEOUT1_Pos (0U)
#define DDRCTRL_PCFGWQOS1_0_WQOS_MAP_TIMEOUT1_Msk (0x7FFU << DDRCTRL_PCFGWQOS1_0_WQOS_MAP_TIMEOUT1_Pos) /*!< 0x000007FF */
#define DDRCTRL_PCFGWQOS1_0_WQOS_MAP_TIMEOUT1     DDRCTRL_PCFGWQOS1_0_WQOS_MAP_TIMEOUT1_Msk             /*!< Specifies the timeout value for write transactions in region 0 and 1. */
#define DDRCTRL_PCFGWQOS1_0_WQOS_MAP_TIMEOUT1_0   (0x1U << DDRCTRL_PCFGWQOS1_0_WQOS_MAP_TIMEOUT1_Pos)   /*!< 0x00000001 */
#define DDRCTRL_PCFGWQOS1_0_WQOS_MAP_TIMEOUT1_1   (0x2U << DDRCTRL_PCFGWQOS1_0_WQOS_MAP_TIMEOUT1_Pos)   /*!< 0x00000002 */
#define DDRCTRL_PCFGWQOS1_0_WQOS_MAP_TIMEOUT1_2   (0x4U << DDRCTRL_PCFGWQOS1_0_WQOS_MAP_TIMEOUT1_Pos)   /*!< 0x00000004 */
#define DDRCTRL_PCFGWQOS1_0_WQOS_MAP_TIMEOUT1_3   (0x8U << DDRCTRL_PCFGWQOS1_0_WQOS_MAP_TIMEOUT1_Pos)   /*!< 0x00000008 */
#define DDRCTRL_PCFGWQOS1_0_WQOS_MAP_TIMEOUT1_4   (0x10U << DDRCTRL_PCFGWQOS1_0_WQOS_MAP_TIMEOUT1_Pos)  /*!< 0x00000010 */
#define DDRCTRL_PCFGWQOS1_0_WQOS_MAP_TIMEOUT1_5   (0x20U << DDRCTRL_PCFGWQOS1_0_WQOS_MAP_TIMEOUT1_Pos)  /*!< 0x00000020 */
#define DDRCTRL_PCFGWQOS1_0_WQOS_MAP_TIMEOUT1_6   (0x40U << DDRCTRL_PCFGWQOS1_0_WQOS_MAP_TIMEOUT1_Pos)  /*!< 0x00000040 */
#define DDRCTRL_PCFGWQOS1_0_WQOS_MAP_TIMEOUT1_7   (0x80U << DDRCTRL_PCFGWQOS1_0_WQOS_MAP_TIMEOUT1_Pos)  /*!< 0x00000080 */
#define DDRCTRL_PCFGWQOS1_0_WQOS_MAP_TIMEOUT1_8   (0x100U << DDRCTRL_PCFGWQOS1_0_WQOS_MAP_TIMEOUT1_Pos) /*!< 0x00000100 */
#define DDRCTRL_PCFGWQOS1_0_WQOS_MAP_TIMEOUT1_9   (0x200U << DDRCTRL_PCFGWQOS1_0_WQOS_MAP_TIMEOUT1_Pos) /*!< 0x00000200 */
#define DDRCTRL_PCFGWQOS1_0_WQOS_MAP_TIMEOUT1_10  (0x400U << DDRCTRL_PCFGWQOS1_0_WQOS_MAP_TIMEOUT1_Pos) /*!< 0x00000400 */
#define DDRCTRL_PCFGWQOS1_0_WQOS_MAP_TIMEOUT2_Pos (16U)
#define DDRCTRL_PCFGWQOS1_0_WQOS_MAP_TIMEOUT2_Msk (0x7FFU << DDRCTRL_PCFGWQOS1_0_WQOS_MAP_TIMEOUT2_Pos) /*!< 0x07FF0000 */
#define DDRCTRL_PCFGWQOS1_0_WQOS_MAP_TIMEOUT2     DDRCTRL_PCFGWQOS1_0_WQOS_MAP_TIMEOUT2_Msk             /*!< Specifies the timeout value for write transactions in region 2. */
#define DDRCTRL_PCFGWQOS1_0_WQOS_MAP_TIMEOUT2_0   (0x1U << DDRCTRL_PCFGWQOS1_0_WQOS_MAP_TIMEOUT2_Pos)   /*!< 0x00010000 */
#define DDRCTRL_PCFGWQOS1_0_WQOS_MAP_TIMEOUT2_1   (0x2U << DDRCTRL_PCFGWQOS1_0_WQOS_MAP_TIMEOUT2_Pos)   /*!< 0x00020000 */
#define DDRCTRL_PCFGWQOS1_0_WQOS_MAP_TIMEOUT2_2   (0x4U << DDRCTRL_PCFGWQOS1_0_WQOS_MAP_TIMEOUT2_Pos)   /*!< 0x00040000 */
#define DDRCTRL_PCFGWQOS1_0_WQOS_MAP_TIMEOUT2_3   (0x8U << DDRCTRL_PCFGWQOS1_0_WQOS_MAP_TIMEOUT2_Pos)   /*!< 0x00080000 */
#define DDRCTRL_PCFGWQOS1_0_WQOS_MAP_TIMEOUT2_4   (0x10U << DDRCTRL_PCFGWQOS1_0_WQOS_MAP_TIMEOUT2_Pos)  /*!< 0x00100000 */
#define DDRCTRL_PCFGWQOS1_0_WQOS_MAP_TIMEOUT2_5   (0x20U << DDRCTRL_PCFGWQOS1_0_WQOS_MAP_TIMEOUT2_Pos)  /*!< 0x00200000 */
#define DDRCTRL_PCFGWQOS1_0_WQOS_MAP_TIMEOUT2_6   (0x40U << DDRCTRL_PCFGWQOS1_0_WQOS_MAP_TIMEOUT2_Pos)  /*!< 0x00400000 */
#define DDRCTRL_PCFGWQOS1_0_WQOS_MAP_TIMEOUT2_7   (0x80U << DDRCTRL_PCFGWQOS1_0_WQOS_MAP_TIMEOUT2_Pos)  /*!< 0x00800000 */
#define DDRCTRL_PCFGWQOS1_0_WQOS_MAP_TIMEOUT2_8   (0x100U << DDRCTRL_PCFGWQOS1_0_WQOS_MAP_TIMEOUT2_Pos) /*!< 0x01000000 */
#define DDRCTRL_PCFGWQOS1_0_WQOS_MAP_TIMEOUT2_9   (0x200U << DDRCTRL_PCFGWQOS1_0_WQOS_MAP_TIMEOUT2_Pos) /*!< 0x02000000 */
#define DDRCTRL_PCFGWQOS1_0_WQOS_MAP_TIMEOUT2_10  (0x400U << DDRCTRL_PCFGWQOS1_0_WQOS_MAP_TIMEOUT2_Pos) /*!< 0x04000000 */

/***************  Bit definition for DDRCTRL_PCFGR_1 register  ****************/
#define DDRCTRL_PCFGR_1_RD_PORT_PRIORITY_Pos     (0U)
#define DDRCTRL_PCFGR_1_RD_PORT_PRIORITY_Msk     (0x3FFU << DDRCTRL_PCFGR_1_RD_PORT_PRIORITY_Pos)   /*!< 0x000003FF */
#define DDRCTRL_PCFGR_1_RD_PORT_PRIORITY         DDRCTRL_PCFGR_1_RD_PORT_PRIORITY_Msk               /*!< Determines the initial load value of read aging counters. These counters are parallel loaded after reset, or after each grant to the corresponding port. The aging counters down-count every clock cycle where the port is requesting but not granted. The higher significant 5-bits of the read aging counter sets the priority of the read channel of a given port. Port\qs priority increases as the higher significant 5-bits of the counter starts to decrease. When the aging counter becomes 0, the corresponding port channel has the highest priority level (timeout condition - Priority0). For multi-port configurations, the aging counters cannot be used to set port priorities when external dynamic priority inputs (arqos) are enabled (timeout is still applicable). For single port configurations, the aging counters are only used when they timeout (become 0) to force read-write direction switching. In this case, external dynamic priority input, arqos (for reads only) can still be used to set the DDRC read priority (2 priority levels: low priority read - LPR, high priority read - HPR) on a command by command basis. */
#define DDRCTRL_PCFGR_1_RD_PORT_PRIORITY_0       (0x1U << DDRCTRL_PCFGR_1_RD_PORT_PRIORITY_Pos)     /*!< 0x00000001 */
#define DDRCTRL_PCFGR_1_RD_PORT_PRIORITY_1       (0x2U << DDRCTRL_PCFGR_1_RD_PORT_PRIORITY_Pos)     /*!< 0x00000002 */
#define DDRCTRL_PCFGR_1_RD_PORT_PRIORITY_2       (0x4U << DDRCTRL_PCFGR_1_RD_PORT_PRIORITY_Pos)     /*!< 0x00000004 */
#define DDRCTRL_PCFGR_1_RD_PORT_PRIORITY_3       (0x8U << DDRCTRL_PCFGR_1_RD_PORT_PRIORITY_Pos)     /*!< 0x00000008 */
#define DDRCTRL_PCFGR_1_RD_PORT_PRIORITY_4       (0x10U << DDRCTRL_PCFGR_1_RD_PORT_PRIORITY_Pos)    /*!< 0x00000010 */
#define DDRCTRL_PCFGR_1_RD_PORT_PRIORITY_5       (0x20U << DDRCTRL_PCFGR_1_RD_PORT_PRIORITY_Pos)    /*!< 0x00000020 */
#define DDRCTRL_PCFGR_1_RD_PORT_PRIORITY_6       (0x40U << DDRCTRL_PCFGR_1_RD_PORT_PRIORITY_Pos)    /*!< 0x00000040 */
#define DDRCTRL_PCFGR_1_RD_PORT_PRIORITY_7       (0x80U << DDRCTRL_PCFGR_1_RD_PORT_PRIORITY_Pos)    /*!< 0x00000080 */
#define DDRCTRL_PCFGR_1_RD_PORT_PRIORITY_8       (0x100U << DDRCTRL_PCFGR_1_RD_PORT_PRIORITY_Pos)   /*!< 0x00000100 */
#define DDRCTRL_PCFGR_1_RD_PORT_PRIORITY_9       (0x200U << DDRCTRL_PCFGR_1_RD_PORT_PRIORITY_Pos)   /*!< 0x00000200 */
#define DDRCTRL_PCFGR_1_RD_PORT_AGING_EN_Pos     (12U)
#define DDRCTRL_PCFGR_1_RD_PORT_AGING_EN_Msk     (0x1U << DDRCTRL_PCFGR_1_RD_PORT_AGING_EN_Pos)     /*!< 0x00001000 */
#define DDRCTRL_PCFGR_1_RD_PORT_AGING_EN         DDRCTRL_PCFGR_1_RD_PORT_AGING_EN_Msk               /*!< If set to 1, enables aging function for the read channel of the port. */
#define DDRCTRL_PCFGR_1_RD_PORT_URGENT_EN_Pos    (13U)
#define DDRCTRL_PCFGR_1_RD_PORT_URGENT_EN_Msk    (0x1U << DDRCTRL_PCFGR_1_RD_PORT_URGENT_EN_Pos)    /*!< 0x00002000 */
#define DDRCTRL_PCFGR_1_RD_PORT_URGENT_EN        DDRCTRL_PCFGR_1_RD_PORT_URGENT_EN_Msk              /*!< If set to 1, enables the AXI urgent sideband signal (arurgent). When enabled and arurgent is asserted by the master, that port becomes the highest priority and co_gs_go2critical_lpr/co_gs_go2critical_hpr signal to DDRC is asserted if enabled in PCCFG.go2critical_en register. Note that arurgent signal can be asserted anytime and as long as required which is independent of address handshaking (it is not associated with any particular command). */
#define DDRCTRL_PCFGR_1_RD_PORT_PAGEMATCH_EN_Pos (14U)
#define DDRCTRL_PCFGR_1_RD_PORT_PAGEMATCH_EN_Msk (0x1U << DDRCTRL_PCFGR_1_RD_PORT_PAGEMATCH_EN_Pos) /*!< 0x00004000 */
#define DDRCTRL_PCFGR_1_RD_PORT_PAGEMATCH_EN     DDRCTRL_PCFGR_1_RD_PORT_PAGEMATCH_EN_Msk           /*!< If set to 1, enables the Page Match feature. If enabled, once a requesting port is granted, the port is continued to be granted if the following immediate commands are to the same memory page (same bank and same row). See also related PCCFG.pagematch_limit register. */
#define DDRCTRL_PCFGR_1_RDWR_ORDERED_EN_Pos      (16U)
#define DDRCTRL_PCFGR_1_RDWR_ORDERED_EN_Msk      (0x1U << DDRCTRL_PCFGR_1_RDWR_ORDERED_EN_Pos)      /*!< 0x00010000 */
#define DDRCTRL_PCFGR_1_RDWR_ORDERED_EN          DDRCTRL_PCFGR_1_RDWR_ORDERED_EN_Msk                /*!< Enables ordered read/writes. If set to 1, preserves the ordering between read transaction and write transaction issued to the same address, on a given port. In other words, the controller ensures that all same address read and write commands from the application port interface are transported to the DFI interface in the order of acceptance. This feature is useful in cases where software coherency is desired for masters issuing back-to-back read/write transactions without waiting for write/read responses. Note that this register has an effect only if necessary logic is instantiated via the UMCTL2_RDWR_ORDERED_n parameter. */

/***************  Bit definition for DDRCTRL_PCFGW_1 register  ****************/
#define DDRCTRL_PCFGW_1_WR_PORT_PRIORITY_Pos     (0U)
#define DDRCTRL_PCFGW_1_WR_PORT_PRIORITY_Msk     (0x3FFU << DDRCTRL_PCFGW_1_WR_PORT_PRIORITY_Pos)   /*!< 0x000003FF */
#define DDRCTRL_PCFGW_1_WR_PORT_PRIORITY         DDRCTRL_PCFGW_1_WR_PORT_PRIORITY_Msk               /*!< Determines the initial load value of write aging counters. These counters are parallel loaded after reset, or after each grant to the corresponding port. The aging counters down-count every clock cycle where the port is requesting but not granted. The higher significant 5-bits of the write aging counter sets the initial priority of the write channel of a given port. Port\qs priority increases as the higher significant 5-bits of the counter starts to decrease. When the aging counter becomes 0, the corresponding port channel has the highest priority level. */
#define DDRCTRL_PCFGW_1_WR_PORT_PRIORITY_0       (0x1U << DDRCTRL_PCFGW_1_WR_PORT_PRIORITY_Pos)     /*!< 0x00000001 */
#define DDRCTRL_PCFGW_1_WR_PORT_PRIORITY_1       (0x2U << DDRCTRL_PCFGW_1_WR_PORT_PRIORITY_Pos)     /*!< 0x00000002 */
#define DDRCTRL_PCFGW_1_WR_PORT_PRIORITY_2       (0x4U << DDRCTRL_PCFGW_1_WR_PORT_PRIORITY_Pos)     /*!< 0x00000004 */
#define DDRCTRL_PCFGW_1_WR_PORT_PRIORITY_3       (0x8U << DDRCTRL_PCFGW_1_WR_PORT_PRIORITY_Pos)     /*!< 0x00000008 */
#define DDRCTRL_PCFGW_1_WR_PORT_PRIORITY_4       (0x10U << DDRCTRL_PCFGW_1_WR_PORT_PRIORITY_Pos)    /*!< 0x00000010 */
#define DDRCTRL_PCFGW_1_WR_PORT_PRIORITY_5       (0x20U << DDRCTRL_PCFGW_1_WR_PORT_PRIORITY_Pos)    /*!< 0x00000020 */
#define DDRCTRL_PCFGW_1_WR_PORT_PRIORITY_6       (0x40U << DDRCTRL_PCFGW_1_WR_PORT_PRIORITY_Pos)    /*!< 0x00000040 */
#define DDRCTRL_PCFGW_1_WR_PORT_PRIORITY_7       (0x80U << DDRCTRL_PCFGW_1_WR_PORT_PRIORITY_Pos)    /*!< 0x00000080 */
#define DDRCTRL_PCFGW_1_WR_PORT_PRIORITY_8       (0x100U << DDRCTRL_PCFGW_1_WR_PORT_PRIORITY_Pos)   /*!< 0x00000100 */
#define DDRCTRL_PCFGW_1_WR_PORT_PRIORITY_9       (0x200U << DDRCTRL_PCFGW_1_WR_PORT_PRIORITY_Pos)   /*!< 0x00000200 */
#define DDRCTRL_PCFGW_1_WR_PORT_AGING_EN_Pos     (12U)
#define DDRCTRL_PCFGW_1_WR_PORT_AGING_EN_Msk     (0x1U << DDRCTRL_PCFGW_1_WR_PORT_AGING_EN_Pos)     /*!< 0x00001000 */
#define DDRCTRL_PCFGW_1_WR_PORT_AGING_EN         DDRCTRL_PCFGW_1_WR_PORT_AGING_EN_Msk               /*!< If set to 1, enables aging function for the write channel of the port. */
#define DDRCTRL_PCFGW_1_WR_PORT_URGENT_EN_Pos    (13U)
#define DDRCTRL_PCFGW_1_WR_PORT_URGENT_EN_Msk    (0x1U << DDRCTRL_PCFGW_1_WR_PORT_URGENT_EN_Pos)    /*!< 0x00002000 */
#define DDRCTRL_PCFGW_1_WR_PORT_URGENT_EN        DDRCTRL_PCFGW_1_WR_PORT_URGENT_EN_Msk              /*!< If set to 1, enables the AXI urgent sideband signal (awurgent). When enabled and awurgent is asserted by the master, that port becomes the highest priority and co_gs_go2critical_wr signal to DDRC is asserted if enabled in PCCFG.go2critical_en register. */
#define DDRCTRL_PCFGW_1_WR_PORT_PAGEMATCH_EN_Pos (14U)
#define DDRCTRL_PCFGW_1_WR_PORT_PAGEMATCH_EN_Msk (0x1U << DDRCTRL_PCFGW_1_WR_PORT_PAGEMATCH_EN_Pos) /*!< 0x00004000 */
#define DDRCTRL_PCFGW_1_WR_PORT_PAGEMATCH_EN     DDRCTRL_PCFGW_1_WR_PORT_PAGEMATCH_EN_Msk           /*!< If set to 1, enables the Page Match feature. If enabled, once a requesting port is granted, the port is continued to be granted if the following immediate commands are to the same memory page (same bank and same row). See also related PCCFG.pagematch_limit register. */

/***************  Bit definition for DDRCTRL_PCTRL_1 register  ****************/
#define DDRCTRL_PCTRL_1_PORT_EN_Pos (0U)
#define DDRCTRL_PCTRL_1_PORT_EN_Msk (0x1U << DDRCTRL_PCTRL_1_PORT_EN_Pos) /*!< 0x00000001 */
#define DDRCTRL_PCTRL_1_PORT_EN     DDRCTRL_PCTRL_1_PORT_EN_Msk           /*!< Enables AXI port n. */

/**************  Bit definition for DDRCTRL_PCFGQOS0_1 register  **************/
#define DDRCTRL_PCFGQOS0_1_RQOS_MAP_LEVEL1_Pos  (0U)
#define DDRCTRL_PCFGQOS0_1_RQOS_MAP_LEVEL1_Msk  (0xFU << DDRCTRL_PCFGQOS0_1_RQOS_MAP_LEVEL1_Pos)  /*!< 0x0000000F */
#define DDRCTRL_PCFGQOS0_1_RQOS_MAP_LEVEL1      DDRCTRL_PCFGQOS0_1_RQOS_MAP_LEVEL1_Msk            /*!< Separation level1 indicating the end of region0 mapping; start of region0 is 0. Possible values for level1 are 0 to 13 (for dual RAQ) or 0 to 14 (for single RAQ) which corresponds to arqos. */
#define DDRCTRL_PCFGQOS0_1_RQOS_MAP_LEVEL1_0    (0x1U << DDRCTRL_PCFGQOS0_1_RQOS_MAP_LEVEL1_Pos)  /*!< 0x00000001 */
#define DDRCTRL_PCFGQOS0_1_RQOS_MAP_LEVEL1_1    (0x2U << DDRCTRL_PCFGQOS0_1_RQOS_MAP_LEVEL1_Pos)  /*!< 0x00000002 */
#define DDRCTRL_PCFGQOS0_1_RQOS_MAP_LEVEL1_2    (0x4U << DDRCTRL_PCFGQOS0_1_RQOS_MAP_LEVEL1_Pos)  /*!< 0x00000004 */
#define DDRCTRL_PCFGQOS0_1_RQOS_MAP_LEVEL1_3    (0x8U << DDRCTRL_PCFGQOS0_1_RQOS_MAP_LEVEL1_Pos)  /*!< 0x00000008 */
#define DDRCTRL_PCFGQOS0_1_RQOS_MAP_LEVEL2_Pos  (8U)
#define DDRCTRL_PCFGQOS0_1_RQOS_MAP_LEVEL2_Msk  (0xFU << DDRCTRL_PCFGQOS0_1_RQOS_MAP_LEVEL2_Pos)  /*!< 0x00000F00 */
#define DDRCTRL_PCFGQOS0_1_RQOS_MAP_LEVEL2      DDRCTRL_PCFGQOS0_1_RQOS_MAP_LEVEL2_Msk            /*!< Separation level2 indicating the end of region1 mapping; start of region1 is (level1 + 1). Possible values for level2 are (level1 + 1) to 14 which corresponds to arqos. */
#define DDRCTRL_PCFGQOS0_1_RQOS_MAP_LEVEL2_0    (0x1U << DDRCTRL_PCFGQOS0_1_RQOS_MAP_LEVEL2_Pos)  /*!< 0x00000100 */
#define DDRCTRL_PCFGQOS0_1_RQOS_MAP_LEVEL2_1    (0x2U << DDRCTRL_PCFGQOS0_1_RQOS_MAP_LEVEL2_Pos)  /*!< 0x00000200 */
#define DDRCTRL_PCFGQOS0_1_RQOS_MAP_LEVEL2_2    (0x4U << DDRCTRL_PCFGQOS0_1_RQOS_MAP_LEVEL2_Pos)  /*!< 0x00000400 */
#define DDRCTRL_PCFGQOS0_1_RQOS_MAP_LEVEL2_3    (0x8U << DDRCTRL_PCFGQOS0_1_RQOS_MAP_LEVEL2_Pos)  /*!< 0x00000800 */
#define DDRCTRL_PCFGQOS0_1_RQOS_MAP_REGION0_Pos (16U)
#define DDRCTRL_PCFGQOS0_1_RQOS_MAP_REGION0_Msk (0x3U << DDRCTRL_PCFGQOS0_1_RQOS_MAP_REGION0_Pos) /*!< 0x00030000 */
#define DDRCTRL_PCFGQOS0_1_RQOS_MAP_REGION0     DDRCTRL_PCFGQOS0_1_RQOS_MAP_REGION0_Msk           /*!< This bitfield indicates the traffic class of region 0. */
#define DDRCTRL_PCFGQOS0_1_RQOS_MAP_REGION0_0   (0x1U << DDRCTRL_PCFGQOS0_1_RQOS_MAP_REGION0_Pos) /*!< 0x00010000 */
#define DDRCTRL_PCFGQOS0_1_RQOS_MAP_REGION0_1   (0x2U << DDRCTRL_PCFGQOS0_1_RQOS_MAP_REGION0_Pos) /*!< 0x00020000 */
#define DDRCTRL_PCFGQOS0_1_RQOS_MAP_REGION1_Pos (20U)
#define DDRCTRL_PCFGQOS0_1_RQOS_MAP_REGION1_Msk (0x3U << DDRCTRL_PCFGQOS0_1_RQOS_MAP_REGION1_Pos) /*!< 0x00300000 */
#define DDRCTRL_PCFGQOS0_1_RQOS_MAP_REGION1     DDRCTRL_PCFGQOS0_1_RQOS_MAP_REGION1_Msk           /*!< This bitfield indicates the traffic class of region 1. */
#define DDRCTRL_PCFGQOS0_1_RQOS_MAP_REGION1_0   (0x1U << DDRCTRL_PCFGQOS0_1_RQOS_MAP_REGION1_Pos) /*!< 0x00100000 */
#define DDRCTRL_PCFGQOS0_1_RQOS_MAP_REGION1_1   (0x2U << DDRCTRL_PCFGQOS0_1_RQOS_MAP_REGION1_Pos) /*!< 0x00200000 */
#define DDRCTRL_PCFGQOS0_1_RQOS_MAP_REGION2_Pos (24U)
#define DDRCTRL_PCFGQOS0_1_RQOS_MAP_REGION2_Msk (0x3U << DDRCTRL_PCFGQOS0_1_RQOS_MAP_REGION2_Pos) /*!< 0x03000000 */
#define DDRCTRL_PCFGQOS0_1_RQOS_MAP_REGION2     DDRCTRL_PCFGQOS0_1_RQOS_MAP_REGION2_Msk           /*!< This bitfield indicates the traffic class of region2. */
#define DDRCTRL_PCFGQOS0_1_RQOS_MAP_REGION2_0   (0x1U << DDRCTRL_PCFGQOS0_1_RQOS_MAP_REGION2_Pos) /*!< 0x01000000 */
#define DDRCTRL_PCFGQOS0_1_RQOS_MAP_REGION2_1   (0x2U << DDRCTRL_PCFGQOS0_1_RQOS_MAP_REGION2_Pos) /*!< 0x02000000 */

/**************  Bit definition for DDRCTRL_PCFGQOS1_1 register  **************/
#define DDRCTRL_PCFGQOS1_1_RQOS_MAP_TIMEOUTB_Pos (0U)
#define DDRCTRL_PCFGQOS1_1_RQOS_MAP_TIMEOUTB_Msk (0x7FFU << DDRCTRL_PCFGQOS1_1_RQOS_MAP_TIMEOUTB_Pos) /*!< 0x000007FF */
#define DDRCTRL_PCFGQOS1_1_RQOS_MAP_TIMEOUTB     DDRCTRL_PCFGQOS1_1_RQOS_MAP_TIMEOUTB_Msk             /*!< Specifies the timeout value for transactions mapped to the blue address queue. */
#define DDRCTRL_PCFGQOS1_1_RQOS_MAP_TIMEOUTB_0   (0x1U << DDRCTRL_PCFGQOS1_1_RQOS_MAP_TIMEOUTB_Pos)   /*!< 0x00000001 */
#define DDRCTRL_PCFGQOS1_1_RQOS_MAP_TIMEOUTB_1   (0x2U << DDRCTRL_PCFGQOS1_1_RQOS_MAP_TIMEOUTB_Pos)   /*!< 0x00000002 */
#define DDRCTRL_PCFGQOS1_1_RQOS_MAP_TIMEOUTB_2   (0x4U << DDRCTRL_PCFGQOS1_1_RQOS_MAP_TIMEOUTB_Pos)   /*!< 0x00000004 */
#define DDRCTRL_PCFGQOS1_1_RQOS_MAP_TIMEOUTB_3   (0x8U << DDRCTRL_PCFGQOS1_1_RQOS_MAP_TIMEOUTB_Pos)   /*!< 0x00000008 */
#define DDRCTRL_PCFGQOS1_1_RQOS_MAP_TIMEOUTB_4   (0x10U << DDRCTRL_PCFGQOS1_1_RQOS_MAP_TIMEOUTB_Pos)  /*!< 0x00000010 */
#define DDRCTRL_PCFGQOS1_1_RQOS_MAP_TIMEOUTB_5   (0x20U << DDRCTRL_PCFGQOS1_1_RQOS_MAP_TIMEOUTB_Pos)  /*!< 0x00000020 */
#define DDRCTRL_PCFGQOS1_1_RQOS_MAP_TIMEOUTB_6   (0x40U << DDRCTRL_PCFGQOS1_1_RQOS_MAP_TIMEOUTB_Pos)  /*!< 0x00000040 */
#define DDRCTRL_PCFGQOS1_1_RQOS_MAP_TIMEOUTB_7   (0x80U << DDRCTRL_PCFGQOS1_1_RQOS_MAP_TIMEOUTB_Pos)  /*!< 0x00000080 */
#define DDRCTRL_PCFGQOS1_1_RQOS_MAP_TIMEOUTB_8   (0x100U << DDRCTRL_PCFGQOS1_1_RQOS_MAP_TIMEOUTB_Pos) /*!< 0x00000100 */
#define DDRCTRL_PCFGQOS1_1_RQOS_MAP_TIMEOUTB_9   (0x200U << DDRCTRL_PCFGQOS1_1_RQOS_MAP_TIMEOUTB_Pos) /*!< 0x00000200 */
#define DDRCTRL_PCFGQOS1_1_RQOS_MAP_TIMEOUTB_10  (0x400U << DDRCTRL_PCFGQOS1_1_RQOS_MAP_TIMEOUTB_Pos) /*!< 0x00000400 */
#define DDRCTRL_PCFGQOS1_1_RQOS_MAP_TIMEOUTR_Pos (16U)
#define DDRCTRL_PCFGQOS1_1_RQOS_MAP_TIMEOUTR_Msk (0x7FFU << DDRCTRL_PCFGQOS1_1_RQOS_MAP_TIMEOUTR_Pos) /*!< 0x07FF0000 */
#define DDRCTRL_PCFGQOS1_1_RQOS_MAP_TIMEOUTR     DDRCTRL_PCFGQOS1_1_RQOS_MAP_TIMEOUTR_Msk             /*!< Specifies the timeout value for transactions mapped to the red address queue. */
#define DDRCTRL_PCFGQOS1_1_RQOS_MAP_TIMEOUTR_0   (0x1U << DDRCTRL_PCFGQOS1_1_RQOS_MAP_TIMEOUTR_Pos)   /*!< 0x00010000 */
#define DDRCTRL_PCFGQOS1_1_RQOS_MAP_TIMEOUTR_1   (0x2U << DDRCTRL_PCFGQOS1_1_RQOS_MAP_TIMEOUTR_Pos)   /*!< 0x00020000 */
#define DDRCTRL_PCFGQOS1_1_RQOS_MAP_TIMEOUTR_2   (0x4U << DDRCTRL_PCFGQOS1_1_RQOS_MAP_TIMEOUTR_Pos)   /*!< 0x00040000 */
#define DDRCTRL_PCFGQOS1_1_RQOS_MAP_TIMEOUTR_3   (0x8U << DDRCTRL_PCFGQOS1_1_RQOS_MAP_TIMEOUTR_Pos)   /*!< 0x00080000 */
#define DDRCTRL_PCFGQOS1_1_RQOS_MAP_TIMEOUTR_4   (0x10U << DDRCTRL_PCFGQOS1_1_RQOS_MAP_TIMEOUTR_Pos)  /*!< 0x00100000 */
#define DDRCTRL_PCFGQOS1_1_RQOS_MAP_TIMEOUTR_5   (0x20U << DDRCTRL_PCFGQOS1_1_RQOS_MAP_TIMEOUTR_Pos)  /*!< 0x00200000 */
#define DDRCTRL_PCFGQOS1_1_RQOS_MAP_TIMEOUTR_6   (0x40U << DDRCTRL_PCFGQOS1_1_RQOS_MAP_TIMEOUTR_Pos)  /*!< 0x00400000 */
#define DDRCTRL_PCFGQOS1_1_RQOS_MAP_TIMEOUTR_7   (0x80U << DDRCTRL_PCFGQOS1_1_RQOS_MAP_TIMEOUTR_Pos)  /*!< 0x00800000 */
#define DDRCTRL_PCFGQOS1_1_RQOS_MAP_TIMEOUTR_8   (0x100U << DDRCTRL_PCFGQOS1_1_RQOS_MAP_TIMEOUTR_Pos) /*!< 0x01000000 */
#define DDRCTRL_PCFGQOS1_1_RQOS_MAP_TIMEOUTR_9   (0x200U << DDRCTRL_PCFGQOS1_1_RQOS_MAP_TIMEOUTR_Pos) /*!< 0x02000000 */
#define DDRCTRL_PCFGQOS1_1_RQOS_MAP_TIMEOUTR_10  (0x400U << DDRCTRL_PCFGQOS1_1_RQOS_MAP_TIMEOUTR_Pos) /*!< 0x04000000 */

/*************  Bit definition for DDRCTRL_PCFGWQOS0_1 register  **************/
#define DDRCTRL_PCFGWQOS0_1_WQOS_MAP_LEVEL1_Pos  (0U)
#define DDRCTRL_PCFGWQOS0_1_WQOS_MAP_LEVEL1_Msk  (0xFU << DDRCTRL_PCFGWQOS0_1_WQOS_MAP_LEVEL1_Pos)  /*!< 0x0000000F */
#define DDRCTRL_PCFGWQOS0_1_WQOS_MAP_LEVEL1      DDRCTRL_PCFGWQOS0_1_WQOS_MAP_LEVEL1_Msk            /*!< Separation level indicating the end of region0 mapping; start of region0 is 0. Possible values for level1 are 0 to 13 which corresponds to awqos. */
#define DDRCTRL_PCFGWQOS0_1_WQOS_MAP_LEVEL1_0    (0x1U << DDRCTRL_PCFGWQOS0_1_WQOS_MAP_LEVEL1_Pos)  /*!< 0x00000001 */
#define DDRCTRL_PCFGWQOS0_1_WQOS_MAP_LEVEL1_1    (0x2U << DDRCTRL_PCFGWQOS0_1_WQOS_MAP_LEVEL1_Pos)  /*!< 0x00000002 */
#define DDRCTRL_PCFGWQOS0_1_WQOS_MAP_LEVEL1_2    (0x4U << DDRCTRL_PCFGWQOS0_1_WQOS_MAP_LEVEL1_Pos)  /*!< 0x00000004 */
#define DDRCTRL_PCFGWQOS0_1_WQOS_MAP_LEVEL1_3    (0x8U << DDRCTRL_PCFGWQOS0_1_WQOS_MAP_LEVEL1_Pos)  /*!< 0x00000008 */
#define DDRCTRL_PCFGWQOS0_1_WQOS_MAP_LEVEL2_Pos  (8U)
#define DDRCTRL_PCFGWQOS0_1_WQOS_MAP_LEVEL2_Msk  (0xFU << DDRCTRL_PCFGWQOS0_1_WQOS_MAP_LEVEL2_Pos)  /*!< 0x00000F00 */
#define DDRCTRL_PCFGWQOS0_1_WQOS_MAP_LEVEL2      DDRCTRL_PCFGWQOS0_1_WQOS_MAP_LEVEL2_Msk            /*!< Separation level2 indicating the end of region1 mapping; start of region1 is (level1 + 1). Possible values for level2 are (level1 + 1) to 14 which corresponds to awqos. */
#define DDRCTRL_PCFGWQOS0_1_WQOS_MAP_LEVEL2_0    (0x1U << DDRCTRL_PCFGWQOS0_1_WQOS_MAP_LEVEL2_Pos)  /*!< 0x00000100 */
#define DDRCTRL_PCFGWQOS0_1_WQOS_MAP_LEVEL2_1    (0x2U << DDRCTRL_PCFGWQOS0_1_WQOS_MAP_LEVEL2_Pos)  /*!< 0x00000200 */
#define DDRCTRL_PCFGWQOS0_1_WQOS_MAP_LEVEL2_2    (0x4U << DDRCTRL_PCFGWQOS0_1_WQOS_MAP_LEVEL2_Pos)  /*!< 0x00000400 */
#define DDRCTRL_PCFGWQOS0_1_WQOS_MAP_LEVEL2_3    (0x8U << DDRCTRL_PCFGWQOS0_1_WQOS_MAP_LEVEL2_Pos)  /*!< 0x00000800 */
#define DDRCTRL_PCFGWQOS0_1_WQOS_MAP_REGION0_Pos (16U)
#define DDRCTRL_PCFGWQOS0_1_WQOS_MAP_REGION0_Msk (0x3U << DDRCTRL_PCFGWQOS0_1_WQOS_MAP_REGION0_Pos) /*!< 0x00030000 */
#define DDRCTRL_PCFGWQOS0_1_WQOS_MAP_REGION0     DDRCTRL_PCFGWQOS0_1_WQOS_MAP_REGION0_Msk           /*!< This bitfield indicates the traffic class of region 0. */
#define DDRCTRL_PCFGWQOS0_1_WQOS_MAP_REGION0_0   (0x1U << DDRCTRL_PCFGWQOS0_1_WQOS_MAP_REGION0_Pos) /*!< 0x00010000 */
#define DDRCTRL_PCFGWQOS0_1_WQOS_MAP_REGION0_1   (0x2U << DDRCTRL_PCFGWQOS0_1_WQOS_MAP_REGION0_Pos) /*!< 0x00020000 */
#define DDRCTRL_PCFGWQOS0_1_WQOS_MAP_REGION1_Pos (20U)
#define DDRCTRL_PCFGWQOS0_1_WQOS_MAP_REGION1_Msk (0x3U << DDRCTRL_PCFGWQOS0_1_WQOS_MAP_REGION1_Pos) /*!< 0x00300000 */
#define DDRCTRL_PCFGWQOS0_1_WQOS_MAP_REGION1     DDRCTRL_PCFGWQOS0_1_WQOS_MAP_REGION1_Msk           /*!< This bitfield indicates the traffic class of region 1. */
#define DDRCTRL_PCFGWQOS0_1_WQOS_MAP_REGION1_0   (0x1U << DDRCTRL_PCFGWQOS0_1_WQOS_MAP_REGION1_Pos) /*!< 0x00100000 */
#define DDRCTRL_PCFGWQOS0_1_WQOS_MAP_REGION1_1   (0x2U << DDRCTRL_PCFGWQOS0_1_WQOS_MAP_REGION1_Pos) /*!< 0x00200000 */
#define DDRCTRL_PCFGWQOS0_1_WQOS_MAP_REGION2_Pos (24U)
#define DDRCTRL_PCFGWQOS0_1_WQOS_MAP_REGION2_Msk (0x3U << DDRCTRL_PCFGWQOS0_1_WQOS_MAP_REGION2_Pos) /*!< 0x03000000 */
#define DDRCTRL_PCFGWQOS0_1_WQOS_MAP_REGION2     DDRCTRL_PCFGWQOS0_1_WQOS_MAP_REGION2_Msk           /*!< This bitfield indicates the traffic class of region 2. */
#define DDRCTRL_PCFGWQOS0_1_WQOS_MAP_REGION2_0   (0x1U << DDRCTRL_PCFGWQOS0_1_WQOS_MAP_REGION2_Pos) /*!< 0x01000000 */
#define DDRCTRL_PCFGWQOS0_1_WQOS_MAP_REGION2_1   (0x2U << DDRCTRL_PCFGWQOS0_1_WQOS_MAP_REGION2_Pos) /*!< 0x02000000 */

/*************  Bit definition for DDRCTRL_PCFGWQOS1_1 register  **************/
#define DDRCTRL_PCFGWQOS1_1_WQOS_MAP_TIMEOUT1_Pos (0U)
#define DDRCTRL_PCFGWQOS1_1_WQOS_MAP_TIMEOUT1_Msk (0x7FFU << DDRCTRL_PCFGWQOS1_1_WQOS_MAP_TIMEOUT1_Pos) /*!< 0x000007FF */
#define DDRCTRL_PCFGWQOS1_1_WQOS_MAP_TIMEOUT1     DDRCTRL_PCFGWQOS1_1_WQOS_MAP_TIMEOUT1_Msk             /*!< Specifies the timeout value for write transactions in region 0 and 1. */
#define DDRCTRL_PCFGWQOS1_1_WQOS_MAP_TIMEOUT1_0   (0x1U << DDRCTRL_PCFGWQOS1_1_WQOS_MAP_TIMEOUT1_Pos)   /*!< 0x00000001 */
#define DDRCTRL_PCFGWQOS1_1_WQOS_MAP_TIMEOUT1_1   (0x2U << DDRCTRL_PCFGWQOS1_1_WQOS_MAP_TIMEOUT1_Pos)   /*!< 0x00000002 */
#define DDRCTRL_PCFGWQOS1_1_WQOS_MAP_TIMEOUT1_2   (0x4U << DDRCTRL_PCFGWQOS1_1_WQOS_MAP_TIMEOUT1_Pos)   /*!< 0x00000004 */
#define DDRCTRL_PCFGWQOS1_1_WQOS_MAP_TIMEOUT1_3   (0x8U << DDRCTRL_PCFGWQOS1_1_WQOS_MAP_TIMEOUT1_Pos)   /*!< 0x00000008 */
#define DDRCTRL_PCFGWQOS1_1_WQOS_MAP_TIMEOUT1_4   (0x10U << DDRCTRL_PCFGWQOS1_1_WQOS_MAP_TIMEOUT1_Pos)  /*!< 0x00000010 */
#define DDRCTRL_PCFGWQOS1_1_WQOS_MAP_TIMEOUT1_5   (0x20U << DDRCTRL_PCFGWQOS1_1_WQOS_MAP_TIMEOUT1_Pos)  /*!< 0x00000020 */
#define DDRCTRL_PCFGWQOS1_1_WQOS_MAP_TIMEOUT1_6   (0x40U << DDRCTRL_PCFGWQOS1_1_WQOS_MAP_TIMEOUT1_Pos)  /*!< 0x00000040 */
#define DDRCTRL_PCFGWQOS1_1_WQOS_MAP_TIMEOUT1_7   (0x80U << DDRCTRL_PCFGWQOS1_1_WQOS_MAP_TIMEOUT1_Pos)  /*!< 0x00000080 */
#define DDRCTRL_PCFGWQOS1_1_WQOS_MAP_TIMEOUT1_8   (0x100U << DDRCTRL_PCFGWQOS1_1_WQOS_MAP_TIMEOUT1_Pos) /*!< 0x00000100 */
#define DDRCTRL_PCFGWQOS1_1_WQOS_MAP_TIMEOUT1_9   (0x200U << DDRCTRL_PCFGWQOS1_1_WQOS_MAP_TIMEOUT1_Pos) /*!< 0x00000200 */
#define DDRCTRL_PCFGWQOS1_1_WQOS_MAP_TIMEOUT1_10  (0x400U << DDRCTRL_PCFGWQOS1_1_WQOS_MAP_TIMEOUT1_Pos) /*!< 0x00000400 */
#define DDRCTRL_PCFGWQOS1_1_WQOS_MAP_TIMEOUT2_Pos (16U)
#define DDRCTRL_PCFGWQOS1_1_WQOS_MAP_TIMEOUT2_Msk (0x7FFU << DDRCTRL_PCFGWQOS1_1_WQOS_MAP_TIMEOUT2_Pos) /*!< 0x07FF0000 */
#define DDRCTRL_PCFGWQOS1_1_WQOS_MAP_TIMEOUT2     DDRCTRL_PCFGWQOS1_1_WQOS_MAP_TIMEOUT2_Msk             /*!< Specifies the timeout value for write transactions in region 2. */
#define DDRCTRL_PCFGWQOS1_1_WQOS_MAP_TIMEOUT2_0   (0x1U << DDRCTRL_PCFGWQOS1_1_WQOS_MAP_TIMEOUT2_Pos)   /*!< 0x00010000 */
#define DDRCTRL_PCFGWQOS1_1_WQOS_MAP_TIMEOUT2_1   (0x2U << DDRCTRL_PCFGWQOS1_1_WQOS_MAP_TIMEOUT2_Pos)   /*!< 0x00020000 */
#define DDRCTRL_PCFGWQOS1_1_WQOS_MAP_TIMEOUT2_2   (0x4U << DDRCTRL_PCFGWQOS1_1_WQOS_MAP_TIMEOUT2_Pos)   /*!< 0x00040000 */
#define DDRCTRL_PCFGWQOS1_1_WQOS_MAP_TIMEOUT2_3   (0x8U << DDRCTRL_PCFGWQOS1_1_WQOS_MAP_TIMEOUT2_Pos)   /*!< 0x00080000 */
#define DDRCTRL_PCFGWQOS1_1_WQOS_MAP_TIMEOUT2_4   (0x10U << DDRCTRL_PCFGWQOS1_1_WQOS_MAP_TIMEOUT2_Pos)  /*!< 0x00100000 */
#define DDRCTRL_PCFGWQOS1_1_WQOS_MAP_TIMEOUT2_5   (0x20U << DDRCTRL_PCFGWQOS1_1_WQOS_MAP_TIMEOUT2_Pos)  /*!< 0x00200000 */
#define DDRCTRL_PCFGWQOS1_1_WQOS_MAP_TIMEOUT2_6   (0x40U << DDRCTRL_PCFGWQOS1_1_WQOS_MAP_TIMEOUT2_Pos)  /*!< 0x00400000 */
#define DDRCTRL_PCFGWQOS1_1_WQOS_MAP_TIMEOUT2_7   (0x80U << DDRCTRL_PCFGWQOS1_1_WQOS_MAP_TIMEOUT2_Pos)  /*!< 0x00800000 */
#define DDRCTRL_PCFGWQOS1_1_WQOS_MAP_TIMEOUT2_8   (0x100U << DDRCTRL_PCFGWQOS1_1_WQOS_MAP_TIMEOUT2_Pos) /*!< 0x01000000 */
#define DDRCTRL_PCFGWQOS1_1_WQOS_MAP_TIMEOUT2_9   (0x200U << DDRCTRL_PCFGWQOS1_1_WQOS_MAP_TIMEOUT2_Pos) /*!< 0x02000000 */
#define DDRCTRL_PCFGWQOS1_1_WQOS_MAP_TIMEOUT2_10  (0x400U << DDRCTRL_PCFGWQOS1_1_WQOS_MAP_TIMEOUT2_Pos) /*!< 0x04000000 */

/******************************************************************************/
/*                                                                            */
/*                   DDRPERFM block description (DDRPERFM)                    */
/*                                                                            */
/******************************************************************************/
/*****************  Bit definition for DDRPERFM_CTL register  *****************/
#define DDRPERFM_CTL_START_Pos (0U)
#define DDRPERFM_CTL_START_Msk (0x1U << DDRPERFM_CTL_START_Pos) /*!< 0x00000001 */
#define DDRPERFM_CTL_START     DDRPERFM_CTL_START_Msk           /*!< Start counters which are enabled, the time counter (TCNT) is always enabled. */
#define DDRPERFM_CTL_STOP_Pos  (1U)
#define DDRPERFM_CTL_STOP_Msk  (0x1U << DDRPERFM_CTL_STOP_Pos)  /*!< 0x00000002 */
#define DDRPERFM_CTL_STOP      DDRPERFM_CTL_STOP_Msk            /*!< stop all the counters. */

/*****************  Bit definition for DDRPERFM_CFG register  *****************/
#define DDRPERFM_CFG_EN_Pos  (0U)
#define DDRPERFM_CFG_EN_Msk  (0xFU << DDRPERFM_CFG_EN_Pos)  /*!< 0x0000000F */
#define DDRPERFM_CFG_EN      DDRPERFM_CFG_EN_Msk            /*!< enable counter x (from 0 to 3) */
#define DDRPERFM_CFG_EN_0    (0x1U << DDRPERFM_CFG_EN_Pos)  /*!< 0x00000001 */
#define DDRPERFM_CFG_EN_1    (0x2U << DDRPERFM_CFG_EN_Pos)  /*!< 0x00000002 */
#define DDRPERFM_CFG_EN_2    (0x4U << DDRPERFM_CFG_EN_Pos)  /*!< 0x00000004 */
#define DDRPERFM_CFG_EN_3    (0x8U << DDRPERFM_CFG_EN_Pos)  /*!< 0x00000008 */
#define DDRPERFM_CFG_SEL_Pos (16U)
#define DDRPERFM_CFG_SEL_Msk (0x3U << DDRPERFM_CFG_SEL_Pos) /*!< 0x00030000 */
#define DDRPERFM_CFG_SEL     DDRPERFM_CFG_SEL_Msk           /*!< select set of signals to be monitored (from 0 to 3) (see signal set description in Table 34: DDRPERFM signal sets) and counters to be enabled */
#define DDRPERFM_CFG_SEL_0   (0x1U << DDRPERFM_CFG_SEL_Pos) /*!< 0x00010000 */
#define DDRPERFM_CFG_SEL_1   (0x2U << DDRPERFM_CFG_SEL_Pos) /*!< 0x00020000 */

/***************  Bit definition for DDRPERFM_STATUS register  ****************/
#define DDRPERFM_STATUS_COVF_Pos (0U)
#define DDRPERFM_STATUS_COVF_Msk (0xFU << DDRPERFM_STATUS_COVF_Pos) /*!< 0x0000000F */
#define DDRPERFM_STATUS_COVF     DDRPERFM_STATUS_COVF_Msk           /*!< Counter x Overflow (with x from 0 to 3) */
#define DDRPERFM_STATUS_COVF_0   (0x1U << DDRPERFM_STATUS_COVF_Pos) /*!< 0x00000001 */
#define DDRPERFM_STATUS_COVF_1   (0x2U << DDRPERFM_STATUS_COVF_Pos) /*!< 0x00000002 */
#define DDRPERFM_STATUS_COVF_2   (0x4U << DDRPERFM_STATUS_COVF_Pos) /*!< 0x00000004 */
#define DDRPERFM_STATUS_COVF_3   (0x8U << DDRPERFM_STATUS_COVF_Pos) /*!< 0x00000008 */
#define DDRPERFM_STATUS_BUSY_Pos (16U)
#define DDRPERFM_STATUS_BUSY_Msk (0x1U << DDRPERFM_STATUS_BUSY_Pos) /*!< 0x00010000 */
#define DDRPERFM_STATUS_BUSY     DDRPERFM_STATUS_BUSY_Msk           /*!< Busy Status */
#define DDRPERFM_STATUS_TOVF_Pos (31U)
#define DDRPERFM_STATUS_TOVF_Msk (0x1U << DDRPERFM_STATUS_TOVF_Pos) /*!< 0x80000000 */
#define DDRPERFM_STATUS_TOVF     DDRPERFM_STATUS_TOVF_Msk           /*!< total counter overflow */

/*****************  Bit definition for DDRPERFM_CCR register  *****************/
#define DDRPERFM_CCR_CCLR_Pos (0U)
#define DDRPERFM_CCR_CCLR_Msk (0xFU << DDRPERFM_CCR_CCLR_Pos) /*!< 0x0000000F */
#define DDRPERFM_CCR_CCLR     DDRPERFM_CCR_CCLR_Msk           /*!< counter x Clear (with x from 0 to 3) */
#define DDRPERFM_CCR_CCLR_0   (0x1U << DDRPERFM_CCR_CCLR_Pos) /*!< 0x00000001 */
#define DDRPERFM_CCR_CCLR_1   (0x2U << DDRPERFM_CCR_CCLR_Pos) /*!< 0x00000002 */
#define DDRPERFM_CCR_CCLR_2   (0x4U << DDRPERFM_CCR_CCLR_Pos) /*!< 0x00000004 */
#define DDRPERFM_CCR_CCLR_3   (0x8U << DDRPERFM_CCR_CCLR_Pos) /*!< 0x00000008 */
#define DDRPERFM_CCR_TCLR_Pos (31U)
#define DDRPERFM_CCR_TCLR_Msk (0x1U << DDRPERFM_CCR_TCLR_Pos) /*!< 0x80000000 */
#define DDRPERFM_CCR_TCLR     DDRPERFM_CCR_TCLR_Msk           /*!< time counter clear */

/*****************  Bit definition for DDRPERFM_IER register  *****************/
#define DDRPERFM_IER_OVFIE_Pos (0U)
#define DDRPERFM_IER_OVFIE_Msk (0x1U << DDRPERFM_IER_OVFIE_Pos) /*!< 0x00000001 */
#define DDRPERFM_IER_OVFIE     DDRPERFM_IER_OVFIE_Msk           /*!< overflow interrupt enable */

/*****************  Bit definition for DDRPERFM_ISR register  *****************/
#define DDRPERFM_ISR_OVFF_Pos (0U)
#define DDRPERFM_ISR_OVFF_Msk (0x1U << DDRPERFM_ISR_OVFF_Pos) /*!< 0x00000001 */
#define DDRPERFM_ISR_OVFF     DDRPERFM_ISR_OVFF_Msk           /*!< overflow flag */

/*****************  Bit definition for DDRPERFM_ICR register  *****************/
#define DDRPERFM_ICR_OVF_Pos (0U)
#define DDRPERFM_ICR_OVF_Msk (0x1U << DDRPERFM_ICR_OVF_Pos) /*!< 0x00000001 */
#define DDRPERFM_ICR_OVF     DDRPERFM_ICR_OVF_Msk           /*!< overflow flag */

/****************  Bit definition for DDRPERFM_TCNT register  *****************/
#define DDRPERFM_TCNT_CNT_Pos (0U)
#define DDRPERFM_TCNT_CNT_Msk (0xFFFFFFFFU << DDRPERFM_TCNT_CNT_Pos) /*!< 0xFFFFFFFF */
#define DDRPERFM_TCNT_CNT     DDRPERFM_TCNT_CNT_Msk                  /*!< total time, this is number of DDR controller clocks elapsed while DDRPERFM has been running. */
#define DDRPERFM_TCNT_CNT_0   (0x1U << DDRPERFM_TCNT_CNT_Pos)        /*!< 0x00000001 */
#define DDRPERFM_TCNT_CNT_1   (0x2U << DDRPERFM_TCNT_CNT_Pos)        /*!< 0x00000002 */
#define DDRPERFM_TCNT_CNT_2   (0x4U << DDRPERFM_TCNT_CNT_Pos)        /*!< 0x00000004 */
#define DDRPERFM_TCNT_CNT_3   (0x8U << DDRPERFM_TCNT_CNT_Pos)        /*!< 0x00000008 */
#define DDRPERFM_TCNT_CNT_4   (0x10U << DDRPERFM_TCNT_CNT_Pos)       /*!< 0x00000010 */
#define DDRPERFM_TCNT_CNT_5   (0x20U << DDRPERFM_TCNT_CNT_Pos)       /*!< 0x00000020 */
#define DDRPERFM_TCNT_CNT_6   (0x40U << DDRPERFM_TCNT_CNT_Pos)       /*!< 0x00000040 */
#define DDRPERFM_TCNT_CNT_7   (0x80U << DDRPERFM_TCNT_CNT_Pos)       /*!< 0x00000080 */
#define DDRPERFM_TCNT_CNT_8   (0x100U << DDRPERFM_TCNT_CNT_Pos)      /*!< 0x00000100 */
#define DDRPERFM_TCNT_CNT_9   (0x200U << DDRPERFM_TCNT_CNT_Pos)      /*!< 0x00000200 */
#define DDRPERFM_TCNT_CNT_10  (0x400U << DDRPERFM_TCNT_CNT_Pos)      /*!< 0x00000400 */
#define DDRPERFM_TCNT_CNT_11  (0x800U << DDRPERFM_TCNT_CNT_Pos)      /*!< 0x00000800 */
#define DDRPERFM_TCNT_CNT_12  (0x1000U << DDRPERFM_TCNT_CNT_Pos)     /*!< 0x00001000 */
#define DDRPERFM_TCNT_CNT_13  (0x2000U << DDRPERFM_TCNT_CNT_Pos)     /*!< 0x00002000 */
#define DDRPERFM_TCNT_CNT_14  (0x4000U << DDRPERFM_TCNT_CNT_Pos)     /*!< 0x00004000 */
#define DDRPERFM_TCNT_CNT_15  (0x8000U << DDRPERFM_TCNT_CNT_Pos)     /*!< 0x00008000 */
#define DDRPERFM_TCNT_CNT_16  (0x10000U << DDRPERFM_TCNT_CNT_Pos)    /*!< 0x00010000 */
#define DDRPERFM_TCNT_CNT_17  (0x20000U << DDRPERFM_TCNT_CNT_Pos)    /*!< 0x00020000 */
#define DDRPERFM_TCNT_CNT_18  (0x40000U << DDRPERFM_TCNT_CNT_Pos)    /*!< 0x00040000 */
#define DDRPERFM_TCNT_CNT_19  (0x80000U << DDRPERFM_TCNT_CNT_Pos)    /*!< 0x00080000 */
#define DDRPERFM_TCNT_CNT_20  (0x100000U << DDRPERFM_TCNT_CNT_Pos)   /*!< 0x00100000 */
#define DDRPERFM_TCNT_CNT_21  (0x200000U << DDRPERFM_TCNT_CNT_Pos)   /*!< 0x00200000 */
#define DDRPERFM_TCNT_CNT_22  (0x400000U << DDRPERFM_TCNT_CNT_Pos)   /*!< 0x00400000 */
#define DDRPERFM_TCNT_CNT_23  (0x800000U << DDRPERFM_TCNT_CNT_Pos)   /*!< 0x00800000 */
#define DDRPERFM_TCNT_CNT_24  (0x1000000U << DDRPERFM_TCNT_CNT_Pos)  /*!< 0x01000000 */
#define DDRPERFM_TCNT_CNT_25  (0x2000000U << DDRPERFM_TCNT_CNT_Pos)  /*!< 0x02000000 */
#define DDRPERFM_TCNT_CNT_26  (0x4000000U << DDRPERFM_TCNT_CNT_Pos)  /*!< 0x04000000 */
#define DDRPERFM_TCNT_CNT_27  (0x8000000U << DDRPERFM_TCNT_CNT_Pos)  /*!< 0x08000000 */
#define DDRPERFM_TCNT_CNT_28  (0x10000000U << DDRPERFM_TCNT_CNT_Pos) /*!< 0x10000000 */
#define DDRPERFM_TCNT_CNT_29  (0x20000000U << DDRPERFM_TCNT_CNT_Pos) /*!< 0x20000000 */
#define DDRPERFM_TCNT_CNT_30  (0x40000000U << DDRPERFM_TCNT_CNT_Pos) /*!< 0x40000000 */
#define DDRPERFM_TCNT_CNT_31  (0x80000000U << DDRPERFM_TCNT_CNT_Pos) /*!< 0x80000000 */

/****************  Bit definition for DDRPERFM_CNT0 register  *****************/
#define DDRPERFM_CNT0_CNT_Pos (0U)
#define DDRPERFM_CNT0_CNT_Msk (0xFFFFFFFFU << DDRPERFM_CNT0_CNT_Pos) /*!< 0xFFFFFFFF */
#define DDRPERFM_CNT0_CNT     DDRPERFM_CNT0_CNT_Msk                  /*!< event counter value. */
#define DDRPERFM_CNT0_CNT_0   (0x1U << DDRPERFM_CNT0_CNT_Pos)        /*!< 0x00000001 */
#define DDRPERFM_CNT0_CNT_1   (0x2U << DDRPERFM_CNT0_CNT_Pos)        /*!< 0x00000002 */
#define DDRPERFM_CNT0_CNT_2   (0x4U << DDRPERFM_CNT0_CNT_Pos)        /*!< 0x00000004 */
#define DDRPERFM_CNT0_CNT_3   (0x8U << DDRPERFM_CNT0_CNT_Pos)        /*!< 0x00000008 */
#define DDRPERFM_CNT0_CNT_4   (0x10U << DDRPERFM_CNT0_CNT_Pos)       /*!< 0x00000010 */
#define DDRPERFM_CNT0_CNT_5   (0x20U << DDRPERFM_CNT0_CNT_Pos)       /*!< 0x00000020 */
#define DDRPERFM_CNT0_CNT_6   (0x40U << DDRPERFM_CNT0_CNT_Pos)       /*!< 0x00000040 */
#define DDRPERFM_CNT0_CNT_7   (0x80U << DDRPERFM_CNT0_CNT_Pos)       /*!< 0x00000080 */
#define DDRPERFM_CNT0_CNT_8   (0x100U << DDRPERFM_CNT0_CNT_Pos)      /*!< 0x00000100 */
#define DDRPERFM_CNT0_CNT_9   (0x200U << DDRPERFM_CNT0_CNT_Pos)      /*!< 0x00000200 */
#define DDRPERFM_CNT0_CNT_10  (0x400U << DDRPERFM_CNT0_CNT_Pos)      /*!< 0x00000400 */
#define DDRPERFM_CNT0_CNT_11  (0x800U << DDRPERFM_CNT0_CNT_Pos)      /*!< 0x00000800 */
#define DDRPERFM_CNT0_CNT_12  (0x1000U << DDRPERFM_CNT0_CNT_Pos)     /*!< 0x00001000 */
#define DDRPERFM_CNT0_CNT_13  (0x2000U << DDRPERFM_CNT0_CNT_Pos)     /*!< 0x00002000 */
#define DDRPERFM_CNT0_CNT_14  (0x4000U << DDRPERFM_CNT0_CNT_Pos)     /*!< 0x00004000 */
#define DDRPERFM_CNT0_CNT_15  (0x8000U << DDRPERFM_CNT0_CNT_Pos)     /*!< 0x00008000 */
#define DDRPERFM_CNT0_CNT_16  (0x10000U << DDRPERFM_CNT0_CNT_Pos)    /*!< 0x00010000 */
#define DDRPERFM_CNT0_CNT_17  (0x20000U << DDRPERFM_CNT0_CNT_Pos)    /*!< 0x00020000 */
#define DDRPERFM_CNT0_CNT_18  (0x40000U << DDRPERFM_CNT0_CNT_Pos)    /*!< 0x00040000 */
#define DDRPERFM_CNT0_CNT_19  (0x80000U << DDRPERFM_CNT0_CNT_Pos)    /*!< 0x00080000 */
#define DDRPERFM_CNT0_CNT_20  (0x100000U << DDRPERFM_CNT0_CNT_Pos)   /*!< 0x00100000 */
#define DDRPERFM_CNT0_CNT_21  (0x200000U << DDRPERFM_CNT0_CNT_Pos)   /*!< 0x00200000 */
#define DDRPERFM_CNT0_CNT_22  (0x400000U << DDRPERFM_CNT0_CNT_Pos)   /*!< 0x00400000 */
#define DDRPERFM_CNT0_CNT_23  (0x800000U << DDRPERFM_CNT0_CNT_Pos)   /*!< 0x00800000 */
#define DDRPERFM_CNT0_CNT_24  (0x1000000U << DDRPERFM_CNT0_CNT_Pos)  /*!< 0x01000000 */
#define DDRPERFM_CNT0_CNT_25  (0x2000000U << DDRPERFM_CNT0_CNT_Pos)  /*!< 0x02000000 */
#define DDRPERFM_CNT0_CNT_26  (0x4000000U << DDRPERFM_CNT0_CNT_Pos)  /*!< 0x04000000 */
#define DDRPERFM_CNT0_CNT_27  (0x8000000U << DDRPERFM_CNT0_CNT_Pos)  /*!< 0x08000000 */
#define DDRPERFM_CNT0_CNT_28  (0x10000000U << DDRPERFM_CNT0_CNT_Pos) /*!< 0x10000000 */
#define DDRPERFM_CNT0_CNT_29  (0x20000000U << DDRPERFM_CNT0_CNT_Pos) /*!< 0x20000000 */
#define DDRPERFM_CNT0_CNT_30  (0x40000000U << DDRPERFM_CNT0_CNT_Pos) /*!< 0x40000000 */
#define DDRPERFM_CNT0_CNT_31  (0x80000000U << DDRPERFM_CNT0_CNT_Pos) /*!< 0x80000000 */

/****************  Bit definition for DDRPERFM_CNT1 register  *****************/
#define DDRPERFM_CNT1_CNT_Pos (0U)
#define DDRPERFM_CNT1_CNT_Msk (0xFFFFFFFFU << DDRPERFM_CNT1_CNT_Pos) /*!< 0xFFFFFFFF */
#define DDRPERFM_CNT1_CNT     DDRPERFM_CNT1_CNT_Msk                  /*!< event counter value. */
#define DDRPERFM_CNT1_CNT_0   (0x1U << DDRPERFM_CNT1_CNT_Pos)        /*!< 0x00000001 */
#define DDRPERFM_CNT1_CNT_1   (0x2U << DDRPERFM_CNT1_CNT_Pos)        /*!< 0x00000002 */
#define DDRPERFM_CNT1_CNT_2   (0x4U << DDRPERFM_CNT1_CNT_Pos)        /*!< 0x00000004 */
#define DDRPERFM_CNT1_CNT_3   (0x8U << DDRPERFM_CNT1_CNT_Pos)        /*!< 0x00000008 */
#define DDRPERFM_CNT1_CNT_4   (0x10U << DDRPERFM_CNT1_CNT_Pos)       /*!< 0x00000010 */
#define DDRPERFM_CNT1_CNT_5   (0x20U << DDRPERFM_CNT1_CNT_Pos)       /*!< 0x00000020 */
#define DDRPERFM_CNT1_CNT_6   (0x40U << DDRPERFM_CNT1_CNT_Pos)       /*!< 0x00000040 */
#define DDRPERFM_CNT1_CNT_7   (0x80U << DDRPERFM_CNT1_CNT_Pos)       /*!< 0x00000080 */
#define DDRPERFM_CNT1_CNT_8   (0x100U << DDRPERFM_CNT1_CNT_Pos)      /*!< 0x00000100 */
#define DDRPERFM_CNT1_CNT_9   (0x200U << DDRPERFM_CNT1_CNT_Pos)      /*!< 0x00000200 */
#define DDRPERFM_CNT1_CNT_10  (0x400U << DDRPERFM_CNT1_CNT_Pos)      /*!< 0x00000400 */
#define DDRPERFM_CNT1_CNT_11  (0x800U << DDRPERFM_CNT1_CNT_Pos)      /*!< 0x00000800 */
#define DDRPERFM_CNT1_CNT_12  (0x1000U << DDRPERFM_CNT1_CNT_Pos)     /*!< 0x00001000 */
#define DDRPERFM_CNT1_CNT_13  (0x2000U << DDRPERFM_CNT1_CNT_Pos)     /*!< 0x00002000 */
#define DDRPERFM_CNT1_CNT_14  (0x4000U << DDRPERFM_CNT1_CNT_Pos)     /*!< 0x00004000 */
#define DDRPERFM_CNT1_CNT_15  (0x8000U << DDRPERFM_CNT1_CNT_Pos)     /*!< 0x00008000 */
#define DDRPERFM_CNT1_CNT_16  (0x10000U << DDRPERFM_CNT1_CNT_Pos)    /*!< 0x00010000 */
#define DDRPERFM_CNT1_CNT_17  (0x20000U << DDRPERFM_CNT1_CNT_Pos)    /*!< 0x00020000 */
#define DDRPERFM_CNT1_CNT_18  (0x40000U << DDRPERFM_CNT1_CNT_Pos)    /*!< 0x00040000 */
#define DDRPERFM_CNT1_CNT_19  (0x80000U << DDRPERFM_CNT1_CNT_Pos)    /*!< 0x00080000 */
#define DDRPERFM_CNT1_CNT_20  (0x100000U << DDRPERFM_CNT1_CNT_Pos)   /*!< 0x00100000 */
#define DDRPERFM_CNT1_CNT_21  (0x200000U << DDRPERFM_CNT1_CNT_Pos)   /*!< 0x00200000 */
#define DDRPERFM_CNT1_CNT_22  (0x400000U << DDRPERFM_CNT1_CNT_Pos)   /*!< 0x00400000 */
#define DDRPERFM_CNT1_CNT_23  (0x800000U << DDRPERFM_CNT1_CNT_Pos)   /*!< 0x00800000 */
#define DDRPERFM_CNT1_CNT_24  (0x1000000U << DDRPERFM_CNT1_CNT_Pos)  /*!< 0x01000000 */
#define DDRPERFM_CNT1_CNT_25  (0x2000000U << DDRPERFM_CNT1_CNT_Pos)  /*!< 0x02000000 */
#define DDRPERFM_CNT1_CNT_26  (0x4000000U << DDRPERFM_CNT1_CNT_Pos)  /*!< 0x04000000 */
#define DDRPERFM_CNT1_CNT_27  (0x8000000U << DDRPERFM_CNT1_CNT_Pos)  /*!< 0x08000000 */
#define DDRPERFM_CNT1_CNT_28  (0x10000000U << DDRPERFM_CNT1_CNT_Pos) /*!< 0x10000000 */
#define DDRPERFM_CNT1_CNT_29  (0x20000000U << DDRPERFM_CNT1_CNT_Pos) /*!< 0x20000000 */
#define DDRPERFM_CNT1_CNT_30  (0x40000000U << DDRPERFM_CNT1_CNT_Pos) /*!< 0x40000000 */
#define DDRPERFM_CNT1_CNT_31  (0x80000000U << DDRPERFM_CNT1_CNT_Pos) /*!< 0x80000000 */

/****************  Bit definition for DDRPERFM_CNT2 register  *****************/
#define DDRPERFM_CNT2_CNT_Pos (0U)
#define DDRPERFM_CNT2_CNT_Msk (0xFFFFFFFFU << DDRPERFM_CNT2_CNT_Pos) /*!< 0xFFFFFFFF */
#define DDRPERFM_CNT2_CNT     DDRPERFM_CNT2_CNT_Msk                  /*!< event counter value. */
#define DDRPERFM_CNT2_CNT_0   (0x1U << DDRPERFM_CNT2_CNT_Pos)        /*!< 0x00000001 */
#define DDRPERFM_CNT2_CNT_1   (0x2U << DDRPERFM_CNT2_CNT_Pos)        /*!< 0x00000002 */
#define DDRPERFM_CNT2_CNT_2   (0x4U << DDRPERFM_CNT2_CNT_Pos)        /*!< 0x00000004 */
#define DDRPERFM_CNT2_CNT_3   (0x8U << DDRPERFM_CNT2_CNT_Pos)        /*!< 0x00000008 */
#define DDRPERFM_CNT2_CNT_4   (0x10U << DDRPERFM_CNT2_CNT_Pos)       /*!< 0x00000010 */
#define DDRPERFM_CNT2_CNT_5   (0x20U << DDRPERFM_CNT2_CNT_Pos)       /*!< 0x00000020 */
#define DDRPERFM_CNT2_CNT_6   (0x40U << DDRPERFM_CNT2_CNT_Pos)       /*!< 0x00000040 */
#define DDRPERFM_CNT2_CNT_7   (0x80U << DDRPERFM_CNT2_CNT_Pos)       /*!< 0x00000080 */
#define DDRPERFM_CNT2_CNT_8   (0x100U << DDRPERFM_CNT2_CNT_Pos)      /*!< 0x00000100 */
#define DDRPERFM_CNT2_CNT_9   (0x200U << DDRPERFM_CNT2_CNT_Pos)      /*!< 0x00000200 */
#define DDRPERFM_CNT2_CNT_10  (0x400U << DDRPERFM_CNT2_CNT_Pos)      /*!< 0x00000400 */
#define DDRPERFM_CNT2_CNT_11  (0x800U << DDRPERFM_CNT2_CNT_Pos)      /*!< 0x00000800 */
#define DDRPERFM_CNT2_CNT_12  (0x1000U << DDRPERFM_CNT2_CNT_Pos)     /*!< 0x00001000 */
#define DDRPERFM_CNT2_CNT_13  (0x2000U << DDRPERFM_CNT2_CNT_Pos)     /*!< 0x00002000 */
#define DDRPERFM_CNT2_CNT_14  (0x4000U << DDRPERFM_CNT2_CNT_Pos)     /*!< 0x00004000 */
#define DDRPERFM_CNT2_CNT_15  (0x8000U << DDRPERFM_CNT2_CNT_Pos)     /*!< 0x00008000 */
#define DDRPERFM_CNT2_CNT_16  (0x10000U << DDRPERFM_CNT2_CNT_Pos)    /*!< 0x00010000 */
#define DDRPERFM_CNT2_CNT_17  (0x20000U << DDRPERFM_CNT2_CNT_Pos)    /*!< 0x00020000 */
#define DDRPERFM_CNT2_CNT_18  (0x40000U << DDRPERFM_CNT2_CNT_Pos)    /*!< 0x00040000 */
#define DDRPERFM_CNT2_CNT_19  (0x80000U << DDRPERFM_CNT2_CNT_Pos)    /*!< 0x00080000 */
#define DDRPERFM_CNT2_CNT_20  (0x100000U << DDRPERFM_CNT2_CNT_Pos)   /*!< 0x00100000 */
#define DDRPERFM_CNT2_CNT_21  (0x200000U << DDRPERFM_CNT2_CNT_Pos)   /*!< 0x00200000 */
#define DDRPERFM_CNT2_CNT_22  (0x400000U << DDRPERFM_CNT2_CNT_Pos)   /*!< 0x00400000 */
#define DDRPERFM_CNT2_CNT_23  (0x800000U << DDRPERFM_CNT2_CNT_Pos)   /*!< 0x00800000 */
#define DDRPERFM_CNT2_CNT_24  (0x1000000U << DDRPERFM_CNT2_CNT_Pos)  /*!< 0x01000000 */
#define DDRPERFM_CNT2_CNT_25  (0x2000000U << DDRPERFM_CNT2_CNT_Pos)  /*!< 0x02000000 */
#define DDRPERFM_CNT2_CNT_26  (0x4000000U << DDRPERFM_CNT2_CNT_Pos)  /*!< 0x04000000 */
#define DDRPERFM_CNT2_CNT_27  (0x8000000U << DDRPERFM_CNT2_CNT_Pos)  /*!< 0x08000000 */
#define DDRPERFM_CNT2_CNT_28  (0x10000000U << DDRPERFM_CNT2_CNT_Pos) /*!< 0x10000000 */
#define DDRPERFM_CNT2_CNT_29  (0x20000000U << DDRPERFM_CNT2_CNT_Pos) /*!< 0x20000000 */
#define DDRPERFM_CNT2_CNT_30  (0x40000000U << DDRPERFM_CNT2_CNT_Pos) /*!< 0x40000000 */
#define DDRPERFM_CNT2_CNT_31  (0x80000000U << DDRPERFM_CNT2_CNT_Pos) /*!< 0x80000000 */

/****************  Bit definition for DDRPERFM_CNT3 register  *****************/
#define DDRPERFM_CNT3_CNT_Pos (0U)
#define DDRPERFM_CNT3_CNT_Msk (0xFFFFFFFFU << DDRPERFM_CNT3_CNT_Pos) /*!< 0xFFFFFFFF */
#define DDRPERFM_CNT3_CNT     DDRPERFM_CNT3_CNT_Msk                  /*!< event counter value. */
#define DDRPERFM_CNT3_CNT_0   (0x1U << DDRPERFM_CNT3_CNT_Pos)        /*!< 0x00000001 */
#define DDRPERFM_CNT3_CNT_1   (0x2U << DDRPERFM_CNT3_CNT_Pos)        /*!< 0x00000002 */
#define DDRPERFM_CNT3_CNT_2   (0x4U << DDRPERFM_CNT3_CNT_Pos)        /*!< 0x00000004 */
#define DDRPERFM_CNT3_CNT_3   (0x8U << DDRPERFM_CNT3_CNT_Pos)        /*!< 0x00000008 */
#define DDRPERFM_CNT3_CNT_4   (0x10U << DDRPERFM_CNT3_CNT_Pos)       /*!< 0x00000010 */
#define DDRPERFM_CNT3_CNT_5   (0x20U << DDRPERFM_CNT3_CNT_Pos)       /*!< 0x00000020 */
#define DDRPERFM_CNT3_CNT_6   (0x40U << DDRPERFM_CNT3_CNT_Pos)       /*!< 0x00000040 */
#define DDRPERFM_CNT3_CNT_7   (0x80U << DDRPERFM_CNT3_CNT_Pos)       /*!< 0x00000080 */
#define DDRPERFM_CNT3_CNT_8   (0x100U << DDRPERFM_CNT3_CNT_Pos)      /*!< 0x00000100 */
#define DDRPERFM_CNT3_CNT_9   (0x200U << DDRPERFM_CNT3_CNT_Pos)      /*!< 0x00000200 */
#define DDRPERFM_CNT3_CNT_10  (0x400U << DDRPERFM_CNT3_CNT_Pos)      /*!< 0x00000400 */
#define DDRPERFM_CNT3_CNT_11  (0x800U << DDRPERFM_CNT3_CNT_Pos)      /*!< 0x00000800 */
#define DDRPERFM_CNT3_CNT_12  (0x1000U << DDRPERFM_CNT3_CNT_Pos)     /*!< 0x00001000 */
#define DDRPERFM_CNT3_CNT_13  (0x2000U << DDRPERFM_CNT3_CNT_Pos)     /*!< 0x00002000 */
#define DDRPERFM_CNT3_CNT_14  (0x4000U << DDRPERFM_CNT3_CNT_Pos)     /*!< 0x00004000 */
#define DDRPERFM_CNT3_CNT_15  (0x8000U << DDRPERFM_CNT3_CNT_Pos)     /*!< 0x00008000 */
#define DDRPERFM_CNT3_CNT_16  (0x10000U << DDRPERFM_CNT3_CNT_Pos)    /*!< 0x00010000 */
#define DDRPERFM_CNT3_CNT_17  (0x20000U << DDRPERFM_CNT3_CNT_Pos)    /*!< 0x00020000 */
#define DDRPERFM_CNT3_CNT_18  (0x40000U << DDRPERFM_CNT3_CNT_Pos)    /*!< 0x00040000 */
#define DDRPERFM_CNT3_CNT_19  (0x80000U << DDRPERFM_CNT3_CNT_Pos)    /*!< 0x00080000 */
#define DDRPERFM_CNT3_CNT_20  (0x100000U << DDRPERFM_CNT3_CNT_Pos)   /*!< 0x00100000 */
#define DDRPERFM_CNT3_CNT_21  (0x200000U << DDRPERFM_CNT3_CNT_Pos)   /*!< 0x00200000 */
#define DDRPERFM_CNT3_CNT_22  (0x400000U << DDRPERFM_CNT3_CNT_Pos)   /*!< 0x00400000 */
#define DDRPERFM_CNT3_CNT_23  (0x800000U << DDRPERFM_CNT3_CNT_Pos)   /*!< 0x00800000 */
#define DDRPERFM_CNT3_CNT_24  (0x1000000U << DDRPERFM_CNT3_CNT_Pos)  /*!< 0x01000000 */
#define DDRPERFM_CNT3_CNT_25  (0x2000000U << DDRPERFM_CNT3_CNT_Pos)  /*!< 0x02000000 */
#define DDRPERFM_CNT3_CNT_26  (0x4000000U << DDRPERFM_CNT3_CNT_Pos)  /*!< 0x04000000 */
#define DDRPERFM_CNT3_CNT_27  (0x8000000U << DDRPERFM_CNT3_CNT_Pos)  /*!< 0x08000000 */
#define DDRPERFM_CNT3_CNT_28  (0x10000000U << DDRPERFM_CNT3_CNT_Pos) /*!< 0x10000000 */
#define DDRPERFM_CNT3_CNT_29  (0x20000000U << DDRPERFM_CNT3_CNT_Pos) /*!< 0x20000000 */
#define DDRPERFM_CNT3_CNT_30  (0x40000000U << DDRPERFM_CNT3_CNT_Pos) /*!< 0x40000000 */
#define DDRPERFM_CNT3_CNT_31  (0x80000000U << DDRPERFM_CNT3_CNT_Pos) /*!< 0x80000000 */

/****************  Bit definition for DDRPERFM_HWCFG register  ****************/
#define DDRPERFM_HWCFG_NCNT_Pos (0U)
#define DDRPERFM_HWCFG_NCNT_Msk (0xFU << DDRPERFM_HWCFG_NCNT_Pos) /*!< 0x0000000F */
#define DDRPERFM_HWCFG_NCNT     DDRPERFM_HWCFG_NCNT_Msk           /*!< number of counters for this configuration (4) */
#define DDRPERFM_HWCFG_NCNT_0   (0x1U << DDRPERFM_HWCFG_NCNT_Pos) /*!< 0x00000001 */
#define DDRPERFM_HWCFG_NCNT_1   (0x2U << DDRPERFM_HWCFG_NCNT_Pos) /*!< 0x00000002 */
#define DDRPERFM_HWCFG_NCNT_2   (0x4U << DDRPERFM_HWCFG_NCNT_Pos) /*!< 0x00000004 */
#define DDRPERFM_HWCFG_NCNT_3   (0x8U << DDRPERFM_HWCFG_NCNT_Pos) /*!< 0x00000008 */

/*****************  Bit definition for DDRPERFM_VER register  *****************/
#define DDRPERFM_VER_MINREV_Pos (0U)
#define DDRPERFM_VER_MINREV_Msk (0xFU << DDRPERFM_VER_MINREV_Pos) /*!< 0x0000000F */
#define DDRPERFM_VER_MINREV     DDRPERFM_VER_MINREV_Msk           /*!< Minor revision number. */
#define DDRPERFM_VER_MINREV_0   (0x1U << DDRPERFM_VER_MINREV_Pos) /*!< 0x00000001 */
#define DDRPERFM_VER_MINREV_1   (0x2U << DDRPERFM_VER_MINREV_Pos) /*!< 0x00000002 */
#define DDRPERFM_VER_MINREV_2   (0x4U << DDRPERFM_VER_MINREV_Pos) /*!< 0x00000004 */
#define DDRPERFM_VER_MINREV_3   (0x8U << DDRPERFM_VER_MINREV_Pos) /*!< 0x00000008 */
#define DDRPERFM_VER_MAJREV_Pos (4U)
#define DDRPERFM_VER_MAJREV_Msk (0xFU << DDRPERFM_VER_MAJREV_Pos) /*!< 0x000000F0 */
#define DDRPERFM_VER_MAJREV     DDRPERFM_VER_MAJREV_Msk           /*!< Major revision number. */
#define DDRPERFM_VER_MAJREV_0   (0x1U << DDRPERFM_VER_MAJREV_Pos) /*!< 0x00000010 */
#define DDRPERFM_VER_MAJREV_1   (0x2U << DDRPERFM_VER_MAJREV_Pos) /*!< 0x00000020 */
#define DDRPERFM_VER_MAJREV_2   (0x4U << DDRPERFM_VER_MAJREV_Pos) /*!< 0x00000040 */
#define DDRPERFM_VER_MAJREV_3   (0x8U << DDRPERFM_VER_MAJREV_Pos) /*!< 0x00000080 */

/*****************  Bit definition for DDRPERFM_ID register  ******************/
#define DDRPERFM_ID_ID_Pos (0U)
#define DDRPERFM_ID_ID_Msk (0xFFFFFFFFU << DDRPERFM_ID_ID_Pos) /*!< 0xFFFFFFFF */
#define DDRPERFM_ID_ID     DDRPERFM_ID_ID_Msk                  /*!< DDRPERFM unique identification. */
#define DDRPERFM_ID_ID_0   (0x1U << DDRPERFM_ID_ID_Pos)        /*!< 0x00000001 */
#define DDRPERFM_ID_ID_1   (0x2U << DDRPERFM_ID_ID_Pos)        /*!< 0x00000002 */
#define DDRPERFM_ID_ID_2   (0x4U << DDRPERFM_ID_ID_Pos)        /*!< 0x00000004 */
#define DDRPERFM_ID_ID_3   (0x8U << DDRPERFM_ID_ID_Pos)        /*!< 0x00000008 */
#define DDRPERFM_ID_ID_4   (0x10U << DDRPERFM_ID_ID_Pos)       /*!< 0x00000010 */
#define DDRPERFM_ID_ID_5   (0x20U << DDRPERFM_ID_ID_Pos)       /*!< 0x00000020 */
#define DDRPERFM_ID_ID_6   (0x40U << DDRPERFM_ID_ID_Pos)       /*!< 0x00000040 */
#define DDRPERFM_ID_ID_7   (0x80U << DDRPERFM_ID_ID_Pos)       /*!< 0x00000080 */
#define DDRPERFM_ID_ID_8   (0x100U << DDRPERFM_ID_ID_Pos)      /*!< 0x00000100 */
#define DDRPERFM_ID_ID_9   (0x200U << DDRPERFM_ID_ID_Pos)      /*!< 0x00000200 */
#define DDRPERFM_ID_ID_10  (0x400U << DDRPERFM_ID_ID_Pos)      /*!< 0x00000400 */
#define DDRPERFM_ID_ID_11  (0x800U << DDRPERFM_ID_ID_Pos)      /*!< 0x00000800 */
#define DDRPERFM_ID_ID_12  (0x1000U << DDRPERFM_ID_ID_Pos)     /*!< 0x00001000 */
#define DDRPERFM_ID_ID_13  (0x2000U << DDRPERFM_ID_ID_Pos)     /*!< 0x00002000 */
#define DDRPERFM_ID_ID_14  (0x4000U << DDRPERFM_ID_ID_Pos)     /*!< 0x00004000 */
#define DDRPERFM_ID_ID_15  (0x8000U << DDRPERFM_ID_ID_Pos)     /*!< 0x00008000 */
#define DDRPERFM_ID_ID_16  (0x10000U << DDRPERFM_ID_ID_Pos)    /*!< 0x00010000 */
#define DDRPERFM_ID_ID_17  (0x20000U << DDRPERFM_ID_ID_Pos)    /*!< 0x00020000 */
#define DDRPERFM_ID_ID_18  (0x40000U << DDRPERFM_ID_ID_Pos)    /*!< 0x00040000 */
#define DDRPERFM_ID_ID_19  (0x80000U << DDRPERFM_ID_ID_Pos)    /*!< 0x00080000 */
#define DDRPERFM_ID_ID_20  (0x100000U << DDRPERFM_ID_ID_Pos)   /*!< 0x00100000 */
#define DDRPERFM_ID_ID_21  (0x200000U << DDRPERFM_ID_ID_Pos)   /*!< 0x00200000 */
#define DDRPERFM_ID_ID_22  (0x400000U << DDRPERFM_ID_ID_Pos)   /*!< 0x00400000 */
#define DDRPERFM_ID_ID_23  (0x800000U << DDRPERFM_ID_ID_Pos)   /*!< 0x00800000 */
#define DDRPERFM_ID_ID_24  (0x1000000U << DDRPERFM_ID_ID_Pos)  /*!< 0x01000000 */
#define DDRPERFM_ID_ID_25  (0x2000000U << DDRPERFM_ID_ID_Pos)  /*!< 0x02000000 */
#define DDRPERFM_ID_ID_26  (0x4000000U << DDRPERFM_ID_ID_Pos)  /*!< 0x04000000 */
#define DDRPERFM_ID_ID_27  (0x8000000U << DDRPERFM_ID_ID_Pos)  /*!< 0x08000000 */
#define DDRPERFM_ID_ID_28  (0x10000000U << DDRPERFM_ID_ID_Pos) /*!< 0x10000000 */
#define DDRPERFM_ID_ID_29  (0x20000000U << DDRPERFM_ID_ID_Pos) /*!< 0x20000000 */
#define DDRPERFM_ID_ID_30  (0x40000000U << DDRPERFM_ID_ID_Pos) /*!< 0x40000000 */
#define DDRPERFM_ID_ID_31  (0x80000000U << DDRPERFM_ID_ID_Pos) /*!< 0x80000000 */

/*****************  Bit definition for DDRPERFM_SID register  *****************/
#define DDRPERFM_SID_SID_Pos (0U)
#define DDRPERFM_SID_SID_Msk (0xFFFFFFFFU << DDRPERFM_SID_SID_Pos) /*!< 0xFFFFFFFF */
#define DDRPERFM_SID_SID     DDRPERFM_SID_SID_Msk                  /*!< magic ID for automatic IP discovery. */
#define DDRPERFM_SID_SID_0   (0x1U << DDRPERFM_SID_SID_Pos)        /*!< 0x00000001 */
#define DDRPERFM_SID_SID_1   (0x2U << DDRPERFM_SID_SID_Pos)        /*!< 0x00000002 */
#define DDRPERFM_SID_SID_2   (0x4U << DDRPERFM_SID_SID_Pos)        /*!< 0x00000004 */
#define DDRPERFM_SID_SID_3   (0x8U << DDRPERFM_SID_SID_Pos)        /*!< 0x00000008 */
#define DDRPERFM_SID_SID_4   (0x10U << DDRPERFM_SID_SID_Pos)       /*!< 0x00000010 */
#define DDRPERFM_SID_SID_5   (0x20U << DDRPERFM_SID_SID_Pos)       /*!< 0x00000020 */
#define DDRPERFM_SID_SID_6   (0x40U << DDRPERFM_SID_SID_Pos)       /*!< 0x00000040 */
#define DDRPERFM_SID_SID_7   (0x80U << DDRPERFM_SID_SID_Pos)       /*!< 0x00000080 */
#define DDRPERFM_SID_SID_8   (0x100U << DDRPERFM_SID_SID_Pos)      /*!< 0x00000100 */
#define DDRPERFM_SID_SID_9   (0x200U << DDRPERFM_SID_SID_Pos)      /*!< 0x00000200 */
#define DDRPERFM_SID_SID_10  (0x400U << DDRPERFM_SID_SID_Pos)      /*!< 0x00000400 */
#define DDRPERFM_SID_SID_11  (0x800U << DDRPERFM_SID_SID_Pos)      /*!< 0x00000800 */
#define DDRPERFM_SID_SID_12  (0x1000U << DDRPERFM_SID_SID_Pos)     /*!< 0x00001000 */
#define DDRPERFM_SID_SID_13  (0x2000U << DDRPERFM_SID_SID_Pos)     /*!< 0x00002000 */
#define DDRPERFM_SID_SID_14  (0x4000U << DDRPERFM_SID_SID_Pos)     /*!< 0x00004000 */
#define DDRPERFM_SID_SID_15  (0x8000U << DDRPERFM_SID_SID_Pos)     /*!< 0x00008000 */
#define DDRPERFM_SID_SID_16  (0x10000U << DDRPERFM_SID_SID_Pos)    /*!< 0x00010000 */
#define DDRPERFM_SID_SID_17  (0x20000U << DDRPERFM_SID_SID_Pos)    /*!< 0x00020000 */
#define DDRPERFM_SID_SID_18  (0x40000U << DDRPERFM_SID_SID_Pos)    /*!< 0x00040000 */
#define DDRPERFM_SID_SID_19  (0x80000U << DDRPERFM_SID_SID_Pos)    /*!< 0x00080000 */
#define DDRPERFM_SID_SID_20  (0x100000U << DDRPERFM_SID_SID_Pos)   /*!< 0x00100000 */
#define DDRPERFM_SID_SID_21  (0x200000U << DDRPERFM_SID_SID_Pos)   /*!< 0x00200000 */
#define DDRPERFM_SID_SID_22  (0x400000U << DDRPERFM_SID_SID_Pos)   /*!< 0x00400000 */
#define DDRPERFM_SID_SID_23  (0x800000U << DDRPERFM_SID_SID_Pos)   /*!< 0x00800000 */
#define DDRPERFM_SID_SID_24  (0x1000000U << DDRPERFM_SID_SID_Pos)  /*!< 0x01000000 */
#define DDRPERFM_SID_SID_25  (0x2000000U << DDRPERFM_SID_SID_Pos)  /*!< 0x02000000 */
#define DDRPERFM_SID_SID_26  (0x4000000U << DDRPERFM_SID_SID_Pos)  /*!< 0x04000000 */
#define DDRPERFM_SID_SID_27  (0x8000000U << DDRPERFM_SID_SID_Pos)  /*!< 0x08000000 */
#define DDRPERFM_SID_SID_28  (0x10000000U << DDRPERFM_SID_SID_Pos) /*!< 0x10000000 */
#define DDRPERFM_SID_SID_29  (0x20000000U << DDRPERFM_SID_SID_Pos) /*!< 0x20000000 */
#define DDRPERFM_SID_SID_30  (0x40000000U << DDRPERFM_SID_SID_Pos) /*!< 0x40000000 */
#define DDRPERFM_SID_SID_31  (0x80000000U << DDRPERFM_SID_SID_Pos) /*!< 0x80000000 */

/******************************************************************************/
/*                                                                            */
/*                    DDRPHYC block description (DDRPHYC)                     */
/*                                                                            */
/******************************************************************************/

/*****************  Bit definition for DDRPHYC_RIDR register  *****************/
#define DDRPHYC_RIDR_PUBMNR_Pos (0U)
#define DDRPHYC_RIDR_PUBMNR_Msk (0xFU << DDRPHYC_RIDR_PUBMNR_Pos) /*!< 0x0000000F */
#define DDRPHYC_RIDR_PUBMNR     DDRPHYC_RIDR_PUBMNR_Msk           /*!< PUB minor rev */
#define DDRPHYC_RIDR_PUBMNR_0   (0x1U << DDRPHYC_RIDR_PUBMNR_Pos) /*!< 0x00000001 */
#define DDRPHYC_RIDR_PUBMNR_1   (0x2U << DDRPHYC_RIDR_PUBMNR_Pos) /*!< 0x00000002 */
#define DDRPHYC_RIDR_PUBMNR_2   (0x4U << DDRPHYC_RIDR_PUBMNR_Pos) /*!< 0x00000004 */
#define DDRPHYC_RIDR_PUBMNR_3   (0x8U << DDRPHYC_RIDR_PUBMNR_Pos) /*!< 0x00000008 */
#define DDRPHYC_RIDR_PUBMDR_Pos (4U)
#define DDRPHYC_RIDR_PUBMDR_Msk (0xFU << DDRPHYC_RIDR_PUBMDR_Pos) /*!< 0x000000F0 */
#define DDRPHYC_RIDR_PUBMDR     DDRPHYC_RIDR_PUBMDR_Msk           /*!< PUB moderate rev */
#define DDRPHYC_RIDR_PUBMDR_0   (0x1U << DDRPHYC_RIDR_PUBMDR_Pos) /*!< 0x00000010 */
#define DDRPHYC_RIDR_PUBMDR_1   (0x2U << DDRPHYC_RIDR_PUBMDR_Pos) /*!< 0x00000020 */
#define DDRPHYC_RIDR_PUBMDR_2   (0x4U << DDRPHYC_RIDR_PUBMDR_Pos) /*!< 0x00000040 */
#define DDRPHYC_RIDR_PUBMDR_3   (0x8U << DDRPHYC_RIDR_PUBMDR_Pos) /*!< 0x00000080 */
#define DDRPHYC_RIDR_PUBMJR_Pos (8U)
#define DDRPHYC_RIDR_PUBMJR_Msk (0xFU << DDRPHYC_RIDR_PUBMJR_Pos) /*!< 0x00000F00 */
#define DDRPHYC_RIDR_PUBMJR     DDRPHYC_RIDR_PUBMJR_Msk           /*!< PUB maj rev */
#define DDRPHYC_RIDR_PUBMJR_0   (0x1U << DDRPHYC_RIDR_PUBMJR_Pos) /*!< 0x00000100 */
#define DDRPHYC_RIDR_PUBMJR_1   (0x2U << DDRPHYC_RIDR_PUBMJR_Pos) /*!< 0x00000200 */
#define DDRPHYC_RIDR_PUBMJR_2   (0x4U << DDRPHYC_RIDR_PUBMJR_Pos) /*!< 0x00000400 */
#define DDRPHYC_RIDR_PUBMJR_3   (0x8U << DDRPHYC_RIDR_PUBMJR_Pos) /*!< 0x00000800 */
#define DDRPHYC_RIDR_PHYMNR_Pos (12U)
#define DDRPHYC_RIDR_PHYMNR_Msk (0xFU << DDRPHYC_RIDR_PHYMNR_Pos) /*!< 0x0000F000 */
#define DDRPHYC_RIDR_PHYMNR     DDRPHYC_RIDR_PHYMNR_Msk           /*!< PHY minor rev */
#define DDRPHYC_RIDR_PHYMNR_0   (0x1U << DDRPHYC_RIDR_PHYMNR_Pos) /*!< 0x00001000 */
#define DDRPHYC_RIDR_PHYMNR_1   (0x2U << DDRPHYC_RIDR_PHYMNR_Pos) /*!< 0x00002000 */
#define DDRPHYC_RIDR_PHYMNR_2   (0x4U << DDRPHYC_RIDR_PHYMNR_Pos) /*!< 0x00004000 */
#define DDRPHYC_RIDR_PHYMNR_3   (0x8U << DDRPHYC_RIDR_PHYMNR_Pos) /*!< 0x00008000 */
#define DDRPHYC_RIDR_PHYMDR_Pos (16U)
#define DDRPHYC_RIDR_PHYMDR_Msk (0xFU << DDRPHYC_RIDR_PHYMDR_Pos) /*!< 0x000F0000 */
#define DDRPHYC_RIDR_PHYMDR     DDRPHYC_RIDR_PHYMDR_Msk           /*!< PHY moderate rev */
#define DDRPHYC_RIDR_PHYMDR_0   (0x1U << DDRPHYC_RIDR_PHYMDR_Pos) /*!< 0x00010000 */
#define DDRPHYC_RIDR_PHYMDR_1   (0x2U << DDRPHYC_RIDR_PHYMDR_Pos) /*!< 0x00020000 */
#define DDRPHYC_RIDR_PHYMDR_2   (0x4U << DDRPHYC_RIDR_PHYMDR_Pos) /*!< 0x00040000 */
#define DDRPHYC_RIDR_PHYMDR_3   (0x8U << DDRPHYC_RIDR_PHYMDR_Pos) /*!< 0x00080000 */
#define DDRPHYC_RIDR_PHYMJR_Pos (20U)
#define DDRPHYC_RIDR_PHYMJR_Msk (0xFU << DDRPHYC_RIDR_PHYMJR_Pos) /*!< 0x00F00000 */
#define DDRPHYC_RIDR_PHYMJR     DDRPHYC_RIDR_PHYMJR_Msk           /*!< PHY maj rev */
#define DDRPHYC_RIDR_PHYMJR_0   (0x1U << DDRPHYC_RIDR_PHYMJR_Pos) /*!< 0x00100000 */
#define DDRPHYC_RIDR_PHYMJR_1   (0x2U << DDRPHYC_RIDR_PHYMJR_Pos) /*!< 0x00200000 */
#define DDRPHYC_RIDR_PHYMJR_2   (0x4U << DDRPHYC_RIDR_PHYMJR_Pos) /*!< 0x00400000 */
#define DDRPHYC_RIDR_PHYMJR_3   (0x8U << DDRPHYC_RIDR_PHYMJR_Pos) /*!< 0x00800000 */
#define DDRPHYC_RIDR_UDRID_Pos  (24U)
#define DDRPHYC_RIDR_UDRID_Msk  (0xFFU << DDRPHYC_RIDR_UDRID_Pos) /*!< 0xFF000000 */
#define DDRPHYC_RIDR_UDRID      DDRPHYC_RIDR_UDRID_Msk            /*!< User-defined rev ID */
#define DDRPHYC_RIDR_UDRID_0    (0x1U << DDRPHYC_RIDR_UDRID_Pos)  /*!< 0x01000000 */
#define DDRPHYC_RIDR_UDRID_1    (0x2U << DDRPHYC_RIDR_UDRID_Pos)  /*!< 0x02000000 */
#define DDRPHYC_RIDR_UDRID_2    (0x4U << DDRPHYC_RIDR_UDRID_Pos)  /*!< 0x04000000 */
#define DDRPHYC_RIDR_UDRID_3    (0x8U << DDRPHYC_RIDR_UDRID_Pos)  /*!< 0x08000000 */
#define DDRPHYC_RIDR_UDRID_4    (0x10U << DDRPHYC_RIDR_UDRID_Pos) /*!< 0x10000000 */
#define DDRPHYC_RIDR_UDRID_5    (0x20U << DDRPHYC_RIDR_UDRID_Pos) /*!< 0x20000000 */
#define DDRPHYC_RIDR_UDRID_6    (0x40U << DDRPHYC_RIDR_UDRID_Pos) /*!< 0x40000000 */
#define DDRPHYC_RIDR_UDRID_7    (0x80U << DDRPHYC_RIDR_UDRID_Pos) /*!< 0x80000000 */

/*****************  Bit definition for DDRPHYC_PIR register  ******************/
#define DDRPHYC_PIR_INIT_Pos     (0U)
#define DDRPHYC_PIR_INIT_Msk     (0x1U << DDRPHYC_PIR_INIT_Pos)     /*!< 0x00000001 */
#define DDRPHYC_PIR_INIT         DDRPHYC_PIR_INIT_Msk               /*!< Initialization trigger */
#define DDRPHYC_PIR_DLLSRST_Pos  (1U)
#define DDRPHYC_PIR_DLLSRST_Msk  (0x1U << DDRPHYC_PIR_DLLSRST_Pos)  /*!< 0x00000002 */
#define DDRPHYC_PIR_DLLSRST      DDRPHYC_PIR_DLLSRST_Msk            /*!< DLL soft reset */
#define DDRPHYC_PIR_DLLLOCK_Pos  (2U)
#define DDRPHYC_PIR_DLLLOCK_Msk  (0x1U << DDRPHYC_PIR_DLLLOCK_Pos)  /*!< 0x00000004 */
#define DDRPHYC_PIR_DLLLOCK      DDRPHYC_PIR_DLLLOCK_Msk            /*!< DLL lock */
#define DDRPHYC_PIR_ZCAL_Pos     (3U)
#define DDRPHYC_PIR_ZCAL_Msk     (0x1U << DDRPHYC_PIR_ZCAL_Pos)     /*!< 0x00000008 */
#define DDRPHYC_PIR_ZCAL         DDRPHYC_PIR_ZCAL_Msk               /*!< Impedance calibration (Driver and ODT) */
#define DDRPHYC_PIR_ITMSRST_Pos  (4U)
#define DDRPHYC_PIR_ITMSRST_Msk  (0x1U << DDRPHYC_PIR_ITMSRST_Pos)  /*!< 0x00000010 */
#define DDRPHYC_PIR_ITMSRST      DDRPHYC_PIR_ITMSRST_Msk            /*!< ITM reset */
#define DDRPHYC_PIR_DRAMRST_Pos  (5U)
#define DDRPHYC_PIR_DRAMRST_Msk  (0x1U << DDRPHYC_PIR_DRAMRST_Pos)  /*!< 0x00000020 */
#define DDRPHYC_PIR_DRAMRST      DDRPHYC_PIR_DRAMRST_Msk            /*!< DRAM reset (DDR3 only) */
#define DDRPHYC_PIR_DRAMINIT_Pos (6U)
#define DDRPHYC_PIR_DRAMINIT_Msk (0x1U << DDRPHYC_PIR_DRAMINIT_Pos) /*!< 0x00000040 */
#define DDRPHYC_PIR_DRAMINIT     DDRPHYC_PIR_DRAMINIT_Msk           /*!< DRAM initialization */
#define DDRPHYC_PIR_QSTRN_Pos    (7U)
#define DDRPHYC_PIR_QSTRN_Msk    (0x1U << DDRPHYC_PIR_QSTRN_Pos)    /*!< 0x00000080 */
#define DDRPHYC_PIR_QSTRN        DDRPHYC_PIR_QSTRN_Msk              /*!< Read DQS training */
#define DDRPHYC_PIR_RVTRN_Pos    (8U)
#define DDRPHYC_PIR_RVTRN_Msk    (0x1U << DDRPHYC_PIR_RVTRN_Pos)    /*!< 0x00000100 */
#define DDRPHYC_PIR_RVTRN        DDRPHYC_PIR_RVTRN_Msk              /*!< Read DQS gate training DQSTRN) and RV training (RVTRN) should normally be run */
#define DDRPHYC_PIR_ICPC_Pos     (16U)
#define DDRPHYC_PIR_ICPC_Msk     (0x1U << DDRPHYC_PIR_ICPC_Pos)     /*!< 0x00010000 */
#define DDRPHYC_PIR_ICPC         DDRPHYC_PIR_ICPC_Msk               /*!< Initialization complete pin configuration */
#define DDRPHYC_PIR_DLLBYP_Pos   (17U)
#define DDRPHYC_PIR_DLLBYP_Msk   (0x1U << DDRPHYC_PIR_DLLBYP_Pos)   /*!< 0x00020000 */
#define DDRPHYC_PIR_DLLBYP       DDRPHYC_PIR_DLLBYP_Msk             /*!< DLL bypass */
#define DDRPHYC_PIR_CTLDINIT_Pos (18U)
#define DDRPHYC_PIR_CTLDINIT_Msk (0x1U << DDRPHYC_PIR_CTLDINIT_Pos) /*!< 0x00040000 */
#define DDRPHYC_PIR_CTLDINIT     DDRPHYC_PIR_CTLDINIT_Msk           /*!< Controller DRAM initialization */
#define DDRPHYC_PIR_CLRSR_Pos    (28U)
#define DDRPHYC_PIR_CLRSR_Msk    (0x1U << DDRPHYC_PIR_CLRSR_Pos)    /*!< 0x10000000 */
#define DDRPHYC_PIR_CLRSR        DDRPHYC_PIR_CLRSR_Msk              /*!< clear status register */
#define DDRPHYC_PIR_LOCKBYP_Pos  (29U)
#define DDRPHYC_PIR_LOCKBYP_Msk  (0x1U << DDRPHYC_PIR_LOCKBYP_Pos)  /*!< 0x20000000 */
#define DDRPHYC_PIR_LOCKBYP      DDRPHYC_PIR_LOCKBYP_Msk            /*!< DLL lock bypass */
#define DDRPHYC_PIR_ZCALBYP_Pos  (30U)
#define DDRPHYC_PIR_ZCALBYP_Msk  (0x1U << DDRPHYC_PIR_ZCALBYP_Pos)  /*!< 0x40000000 */
#define DDRPHYC_PIR_ZCALBYP      DDRPHYC_PIR_ZCALBYP_Msk            /*!< zcal bypass */
#define DDRPHYC_PIR_INITBYP_Pos  (31U)
#define DDRPHYC_PIR_INITBYP_Msk  (0x1U << DDRPHYC_PIR_INITBYP_Pos)  /*!< 0x80000000 */
#define DDRPHYC_PIR_INITBYP      DDRPHYC_PIR_INITBYP_Msk            /*!< Initialization bypass */

/*****************  Bit definition for DDRPHYC_PGCR register  *****************/
#define DDRPHYC_PGCR_ITMDMD_Pos  (0U)
#define DDRPHYC_PGCR_ITMDMD_Msk  (0x1U << DDRPHYC_PGCR_ITMDMD_Pos)  /*!< 0x00000001 */
#define DDRPHYC_PGCR_ITMDMD      DDRPHYC_PGCR_ITMDMD_Msk            /*!< ITM DDR mode */
#define DDRPHYC_PGCR_DQSCFG_Pos  (1U)
#define DDRPHYC_PGCR_DQSCFG_Msk  (0x1U << DDRPHYC_PGCR_DQSCFG_Pos)  /*!< 0x00000002 */
#define DDRPHYC_PGCR_DQSCFG      DDRPHYC_PGCR_DQSCFG_Msk            /*!< DQS gating configuration */
#define DDRPHYC_PGCR_DFTCMP_Pos  (2U)
#define DDRPHYC_PGCR_DFTCMP_Msk  (0x1U << DDRPHYC_PGCR_DFTCMP_Pos)  /*!< 0x00000004 */
#define DDRPHYC_PGCR_DFTCMP      DDRPHYC_PGCR_DFTCMP_Msk            /*!< DQS drift compensation */
#define DDRPHYC_PGCR_DFTLMT_Pos  (3U)
#define DDRPHYC_PGCR_DFTLMT_Msk  (0x3U << DDRPHYC_PGCR_DFTLMT_Pos)  /*!< 0x00000018 */
#define DDRPHYC_PGCR_DFTLMT      DDRPHYC_PGCR_DFTLMT_Msk            /*!< DQS drift limit */
#define DDRPHYC_PGCR_DFTLMT_0    (0x1U << DDRPHYC_PGCR_DFTLMT_Pos)  /*!< 0x00000008 */
#define DDRPHYC_PGCR_DFTLMT_1    (0x2U << DDRPHYC_PGCR_DFTLMT_Pos)  /*!< 0x00000010 */
#define DDRPHYC_PGCR_DTOSEL_Pos  (5U)
#define DDRPHYC_PGCR_DTOSEL_Msk  (0xFU << DDRPHYC_PGCR_DTOSEL_Pos)  /*!< 0x000001E0 */
#define DDRPHYC_PGCR_DTOSEL      DDRPHYC_PGCR_DTOSEL_Msk            /*!< Digital test output select */
#define DDRPHYC_PGCR_DTOSEL_0    (0x1U << DDRPHYC_PGCR_DTOSEL_Pos)  /*!< 0x00000020 */
#define DDRPHYC_PGCR_DTOSEL_1    (0x2U << DDRPHYC_PGCR_DTOSEL_Pos)  /*!< 0x00000040 */
#define DDRPHYC_PGCR_DTOSEL_2    (0x4U << DDRPHYC_PGCR_DTOSEL_Pos)  /*!< 0x00000080 */
#define DDRPHYC_PGCR_DTOSEL_3    (0x8U << DDRPHYC_PGCR_DTOSEL_Pos)  /*!< 0x00000100 */
#define DDRPHYC_PGCR_CKEN_Pos    (9U)
#define DDRPHYC_PGCR_CKEN_Msk    (0x7U << DDRPHYC_PGCR_CKEN_Pos)    /*!< 0x00000E00 */
#define DDRPHYC_PGCR_CKEN        DDRPHYC_PGCR_CKEN_Msk              /*!< CK enable */
#define DDRPHYC_PGCR_CKEN_0      (0x1U << DDRPHYC_PGCR_CKEN_Pos)    /*!< 0x00000200 */
#define DDRPHYC_PGCR_CKEN_1      (0x2U << DDRPHYC_PGCR_CKEN_Pos)    /*!< 0x00000400 */
#define DDRPHYC_PGCR_CKEN_2      (0x4U << DDRPHYC_PGCR_CKEN_Pos)    /*!< 0x00000800 */
#define DDRPHYC_PGCR_CKDV_Pos    (12U)
#define DDRPHYC_PGCR_CKDV_Msk    (0x3U << DDRPHYC_PGCR_CKDV_Pos)    /*!< 0x00003000 */
#define DDRPHYC_PGCR_CKDV        DDRPHYC_PGCR_CKDV_Msk              /*!< CK disable value */
#define DDRPHYC_PGCR_CKDV_0      (0x1U << DDRPHYC_PGCR_CKDV_Pos)    /*!< 0x00001000 */
#define DDRPHYC_PGCR_CKDV_1      (0x2U << DDRPHYC_PGCR_CKDV_Pos)    /*!< 0x00002000 */
#define DDRPHYC_PGCR_CKINV_Pos   (14U)
#define DDRPHYC_PGCR_CKINV_Msk   (0x1U << DDRPHYC_PGCR_CKINV_Pos)   /*!< 0x00004000 */
#define DDRPHYC_PGCR_CKINV       DDRPHYC_PGCR_CKINV_Msk             /*!< CK invert */
#define DDRPHYC_PGCR_IOLB_Pos    (15U)
#define DDRPHYC_PGCR_IOLB_Msk    (0x1U << DDRPHYC_PGCR_IOLB_Pos)    /*!< 0x00008000 */
#define DDRPHYC_PGCR_IOLB        DDRPHYC_PGCR_IOLB_Msk              /*!< I/O loop back select */
#define DDRPHYC_PGCR_IODDRM_Pos  (16U)
#define DDRPHYC_PGCR_IODDRM_Msk  (0x3U << DDRPHYC_PGCR_IODDRM_Pos)  /*!< 0x00030000 */
#define DDRPHYC_PGCR_IODDRM      DDRPHYC_PGCR_IODDRM_Msk            /*!< I/O DDR mode */
#define DDRPHYC_PGCR_IODDRM_0    (0x1U << DDRPHYC_PGCR_IODDRM_Pos)  /*!< 0x00010000 */
#define DDRPHYC_PGCR_IODDRM_1    (0x2U << DDRPHYC_PGCR_IODDRM_Pos)  /*!< 0x00020000 */
#define DDRPHYC_PGCR_RANKEN_Pos  (18U)
#define DDRPHYC_PGCR_RANKEN_Msk  (0xFU << DDRPHYC_PGCR_RANKEN_Pos)  /*!< 0x003C0000 */
#define DDRPHYC_PGCR_RANKEN      DDRPHYC_PGCR_RANKEN_Msk            /*!< Rank enable */
#define DDRPHYC_PGCR_RANKEN_0    (0x1U << DDRPHYC_PGCR_RANKEN_Pos)  /*!< 0x00040000 */
#define DDRPHYC_PGCR_RANKEN_1    (0x2U << DDRPHYC_PGCR_RANKEN_Pos)  /*!< 0x00080000 */
#define DDRPHYC_PGCR_RANKEN_2    (0x4U << DDRPHYC_PGCR_RANKEN_Pos)  /*!< 0x00100000 */
#define DDRPHYC_PGCR_RANKEN_3    (0x8U << DDRPHYC_PGCR_RANKEN_Pos)  /*!< 0x00200000 */
#define DDRPHYC_PGCR_ZKSEL_Pos   (22U)
#define DDRPHYC_PGCR_ZKSEL_Msk   (0x3U << DDRPHYC_PGCR_ZKSEL_Pos)   /*!< 0x00C00000 */
#define DDRPHYC_PGCR_ZKSEL       DDRPHYC_PGCR_ZKSEL_Msk             /*!< Impedance clock divider selection */
#define DDRPHYC_PGCR_ZKSEL_0     (0x1U << DDRPHYC_PGCR_ZKSEL_Pos)   /*!< 0x00400000 */
#define DDRPHYC_PGCR_ZKSEL_1     (0x2U << DDRPHYC_PGCR_ZKSEL_Pos)   /*!< 0x00800000 */
#define DDRPHYC_PGCR_PDDISDX_Pos (24U)
#define DDRPHYC_PGCR_PDDISDX_Msk (0x1U << DDRPHYC_PGCR_PDDISDX_Pos) /*!< 0x01000000 */
#define DDRPHYC_PGCR_PDDISDX     DDRPHYC_PGCR_PDDISDX_Msk           /*!< Power down disabled byte */
#define DDRPHYC_PGCR_RFSHDT_Pos  (25U)
#define DDRPHYC_PGCR_RFSHDT_Msk  (0xFU << DDRPHYC_PGCR_RFSHDT_Pos)  /*!< 0x1E000000 */
#define DDRPHYC_PGCR_RFSHDT      DDRPHYC_PGCR_RFSHDT_Msk            /*!< Refresh during training */
#define DDRPHYC_PGCR_RFSHDT_0    (0x1U << DDRPHYC_PGCR_RFSHDT_Pos)  /*!< 0x02000000 */
#define DDRPHYC_PGCR_RFSHDT_1    (0x2U << DDRPHYC_PGCR_RFSHDT_Pos)  /*!< 0x04000000 */
#define DDRPHYC_PGCR_RFSHDT_2    (0x4U << DDRPHYC_PGCR_RFSHDT_Pos)  /*!< 0x08000000 */
#define DDRPHYC_PGCR_RFSHDT_3    (0x8U << DDRPHYC_PGCR_RFSHDT_Pos)  /*!< 0x10000000 */
#define DDRPHYC_PGCR_LBDQSS_Pos  (29U)
#define DDRPHYC_PGCR_LBDQSS_Msk  (0x1U << DDRPHYC_PGCR_LBDQSS_Pos)  /*!< 0x20000000 */
#define DDRPHYC_PGCR_LBDQSS      DDRPHYC_PGCR_LBDQSS_Msk            /*!< Loop back DQS shift */
#define DDRPHYC_PGCR_LBGDQS_Pos  (30U)
#define DDRPHYC_PGCR_LBGDQS_Msk  (0x1U << DDRPHYC_PGCR_LBGDQS_Pos)  /*!< 0x40000000 */
#define DDRPHYC_PGCR_LBGDQS      DDRPHYC_PGCR_LBGDQS_Msk            /*!< Loop back DQS gating */
#define DDRPHYC_PGCR_LBMODE_Pos  (31U)
#define DDRPHYC_PGCR_LBMODE_Msk  (0x1U << DDRPHYC_PGCR_LBMODE_Pos)  /*!< 0x80000000 */
#define DDRPHYC_PGCR_LBMODE      DDRPHYC_PGCR_LBMODE_Msk            /*!< Loop back mode */

/*****************  Bit definition for DDRPHYC_PGSR register  *****************/
#define DDRPHYC_PGSR_IDONE_Pos   (0U)
#define DDRPHYC_PGSR_IDONE_Msk   (0x1U << DDRPHYC_PGSR_IDONE_Pos)   /*!< 0x00000001 */
#define DDRPHYC_PGSR_IDONE       DDRPHYC_PGSR_IDONE_Msk             /*!< Initialization done */
#define DDRPHYC_PGSR_DLDONE_Pos  (1U)
#define DDRPHYC_PGSR_DLDONE_Msk  (0x1U << DDRPHYC_PGSR_DLDONE_Pos)  /*!< 0x00000002 */
#define DDRPHYC_PGSR_DLDONE      DDRPHYC_PGSR_DLDONE_Msk            /*!< DLL lock done */
#define DDRPHYC_PGSR_ZCDDONE_Pos (2U)
#define DDRPHYC_PGSR_ZCDDONE_Msk (0x1U << DDRPHYC_PGSR_ZCDDONE_Pos) /*!< 0x00000004 */
#define DDRPHYC_PGSR_ZCDDONE     DDRPHYC_PGSR_ZCDDONE_Msk           /*!< zcal done */
#define DDRPHYC_PGSR_DIDONE_Pos  (3U)
#define DDRPHYC_PGSR_DIDONE_Msk  (0x1U << DDRPHYC_PGSR_DIDONE_Pos)  /*!< 0x00000008 */
#define DDRPHYC_PGSR_DIDONE      DDRPHYC_PGSR_DIDONE_Msk            /*!< DRAM initialization done */
#define DDRPHYC_PGSR_DTDONE_Pos  (4U)
#define DDRPHYC_PGSR_DTDONE_Msk  (0x1U << DDRPHYC_PGSR_DTDONE_Pos)  /*!< 0x00000010 */
#define DDRPHYC_PGSR_DTDONE      DDRPHYC_PGSR_DTDONE_Msk            /*!< Data training done */
#define DDRPHYC_PGSR_DTERR_Pos   (5U)
#define DDRPHYC_PGSR_DTERR_Msk   (0x1U << DDRPHYC_PGSR_DTERR_Pos)   /*!< 0x00000020 */
#define DDRPHYC_PGSR_DTERR       DDRPHYC_PGSR_DTERR_Msk             /*!< DQS gate training error */
#define DDRPHYC_PGSR_DTIERR_Pos  (6U)
#define DDRPHYC_PGSR_DTIERR_Msk  (0x1U << DDRPHYC_PGSR_DTIERR_Pos)  /*!< 0x00000040 */
#define DDRPHYC_PGSR_DTIERR      DDRPHYC_PGSR_DTIERR_Msk            /*!< DQS gate training intermittent error */
#define DDRPHYC_PGSR_DFTERR_Pos  (7U)
#define DDRPHYC_PGSR_DFTERR_Msk  (0x1U << DDRPHYC_PGSR_DFTERR_Pos)  /*!< 0x00000080 */
#define DDRPHYC_PGSR_DFTERR      DDRPHYC_PGSR_DFTERR_Msk            /*!< DQS drift error */
#define DDRPHYC_PGSR_RVERR_Pos   (8U)
#define DDRPHYC_PGSR_RVERR_Msk   (0x1U << DDRPHYC_PGSR_RVERR_Pos)   /*!< 0x00000100 */
#define DDRPHYC_PGSR_RVERR       DDRPHYC_PGSR_RVERR_Msk             /*!< Read valid training error */
#define DDRPHYC_PGSR_RVEIRR_Pos  (9U)
#define DDRPHYC_PGSR_RVEIRR_Msk  (0x1U << DDRPHYC_PGSR_RVEIRR_Pos)  /*!< 0x00000200 */
#define DDRPHYC_PGSR_RVEIRR      DDRPHYC_PGSR_RVEIRR_Msk            /*!< Read valid training intermittent error */
#define DDRPHYC_PGSR_TQ_Pos      (31U)
#define DDRPHYC_PGSR_TQ_Msk      (0x1U << DDRPHYC_PGSR_TQ_Pos)      /*!< 0x80000000 */
#define DDRPHYC_PGSR_TQ          DDRPHYC_PGSR_TQ_Msk                /*!< Temperature output (LPDDR only) N/A */

/****************  Bit definition for DDRPHYC_DLLGCR register  ****************/
#define DDRPHYC_DLLGCR_DRES_Pos     (0U)
#define DDRPHYC_DLLGCR_DRES_Msk     (0x3U << DDRPHYC_DLLGCR_DRES_Pos)     /*!< 0x00000003 */
#define DDRPHYC_DLLGCR_DRES         DDRPHYC_DLLGCR_DRES_Msk               /*!< Trim reference current versus resistor value variation */
#define DDRPHYC_DLLGCR_DRES_0       (0x1U << DDRPHYC_DLLGCR_DRES_Pos)     /*!< 0x00000001 */
#define DDRPHYC_DLLGCR_DRES_1       (0x2U << DDRPHYC_DLLGCR_DRES_Pos)     /*!< 0x00000002 */
#define DDRPHYC_DLLGCR_IPUMP_Pos    (2U)
#define DDRPHYC_DLLGCR_IPUMP_Msk    (0x7U << DDRPHYC_DLLGCR_IPUMP_Pos)    /*!< 0x0000001C */
#define DDRPHYC_DLLGCR_IPUMP        DDRPHYC_DLLGCR_IPUMP_Msk              /*!< Charge pump current trim */
#define DDRPHYC_DLLGCR_IPUMP_0      (0x1U << DDRPHYC_DLLGCR_IPUMP_Pos)    /*!< 0x00000004 */
#define DDRPHYC_DLLGCR_IPUMP_1      (0x2U << DDRPHYC_DLLGCR_IPUMP_Pos)    /*!< 0x00000008 */
#define DDRPHYC_DLLGCR_IPUMP_2      (0x4U << DDRPHYC_DLLGCR_IPUMP_Pos)    /*!< 0x00000010 */
#define DDRPHYC_DLLGCR_TESTEN_Pos   (5U)
#define DDRPHYC_DLLGCR_TESTEN_Msk   (0x1U << DDRPHYC_DLLGCR_TESTEN_Pos)   /*!< 0x00000020 */
#define DDRPHYC_DLLGCR_TESTEN       DDRPHYC_DLLGCR_TESTEN_Msk             /*!< Test enable */
#define DDRPHYC_DLLGCR_DTC_Pos      (6U)
#define DDRPHYC_DLLGCR_DTC_Msk      (0x7U << DDRPHYC_DLLGCR_DTC_Pos)      /*!< 0x000001C0 */
#define DDRPHYC_DLLGCR_DTC          DDRPHYC_DLLGCR_DTC_Msk                /*!< Digital test control */
#define DDRPHYC_DLLGCR_DTC_0        (0x1U << DDRPHYC_DLLGCR_DTC_Pos)      /*!< 0x00000040 */
#define DDRPHYC_DLLGCR_DTC_1        (0x2U << DDRPHYC_DLLGCR_DTC_Pos)      /*!< 0x00000080 */
#define DDRPHYC_DLLGCR_DTC_2        (0x4U << DDRPHYC_DLLGCR_DTC_Pos)      /*!< 0x00000100 */
#define DDRPHYC_DLLGCR_ATC_Pos      (9U)
#define DDRPHYC_DLLGCR_ATC_Msk      (0x3U << DDRPHYC_DLLGCR_ATC_Pos)      /*!< 0x00000600 */
#define DDRPHYC_DLLGCR_ATC          DDRPHYC_DLLGCR_ATC_Msk                /*!< Analog test control */
#define DDRPHYC_DLLGCR_ATC_0        (0x1U << DDRPHYC_DLLGCR_ATC_Pos)      /*!< 0x00000200 */
#define DDRPHYC_DLLGCR_ATC_1        (0x2U << DDRPHYC_DLLGCR_ATC_Pos)      /*!< 0x00000400 */
#define DDRPHYC_DLLGCR_TESTSW_Pos   (11U)
#define DDRPHYC_DLLGCR_TESTSW_Msk   (0x1U << DDRPHYC_DLLGCR_TESTSW_Pos)   /*!< 0x00000800 */
#define DDRPHYC_DLLGCR_TESTSW       DDRPHYC_DLLGCR_TESTSW_Msk             /*!< Test switch */
#define DDRPHYC_DLLGCR_MBIAS_Pos    (12U)
#define DDRPHYC_DLLGCR_MBIAS_Msk    (0xFFU << DDRPHYC_DLLGCR_MBIAS_Pos)   /*!< 0x000FF000 */
#define DDRPHYC_DLLGCR_MBIAS        DDRPHYC_DLLGCR_MBIAS_Msk              /*!< Master bias trim */
#define DDRPHYC_DLLGCR_MBIAS_0      (0x1U << DDRPHYC_DLLGCR_MBIAS_Pos)    /*!< 0x00001000 */
#define DDRPHYC_DLLGCR_MBIAS_1      (0x2U << DDRPHYC_DLLGCR_MBIAS_Pos)    /*!< 0x00002000 */
#define DDRPHYC_DLLGCR_MBIAS_2      (0x4U << DDRPHYC_DLLGCR_MBIAS_Pos)    /*!< 0x00004000 */
#define DDRPHYC_DLLGCR_MBIAS_3      (0x8U << DDRPHYC_DLLGCR_MBIAS_Pos)    /*!< 0x00008000 */
#define DDRPHYC_DLLGCR_MBIAS_4      (0x10U << DDRPHYC_DLLGCR_MBIAS_Pos)   /*!< 0x00010000 */
#define DDRPHYC_DLLGCR_MBIAS_5      (0x20U << DDRPHYC_DLLGCR_MBIAS_Pos)   /*!< 0x00020000 */
#define DDRPHYC_DLLGCR_MBIAS_6      (0x40U << DDRPHYC_DLLGCR_MBIAS_Pos)   /*!< 0x00040000 */
#define DDRPHYC_DLLGCR_MBIAS_7      (0x80U << DDRPHYC_DLLGCR_MBIAS_Pos)   /*!< 0x00080000 */
#define DDRPHYC_DLLGCR_SBIAS2_0_Pos (20U)
#define DDRPHYC_DLLGCR_SBIAS2_0_Msk (0x7U << DDRPHYC_DLLGCR_SBIAS2_0_Pos) /*!< 0x00700000 */
#define DDRPHYC_DLLGCR_SBIAS2_0     DDRPHYC_DLLGCR_SBIAS2_0_Msk           /*!< Slave bias trim */
#define DDRPHYC_DLLGCR_SBIAS2_0_0   (0x1U << DDRPHYC_DLLGCR_SBIAS2_0_Pos) /*!< 0x00100000 */
#define DDRPHYC_DLLGCR_SBIAS2_0_1   (0x2U << DDRPHYC_DLLGCR_SBIAS2_0_Pos) /*!< 0x00200000 */
#define DDRPHYC_DLLGCR_SBIAS2_0_2   (0x4U << DDRPHYC_DLLGCR_SBIAS2_0_Pos) /*!< 0x00400000 */
#define DDRPHYC_DLLGCR_BPS200_Pos   (23U)
#define DDRPHYC_DLLGCR_BPS200_Msk   (0x1U << DDRPHYC_DLLGCR_BPS200_Pos)   /*!< 0x00800000 */
#define DDRPHYC_DLLGCR_BPS200       DDRPHYC_DLLGCR_BPS200_Msk             /*!< Bypass mode frequency range */
#define DDRPHYC_DLLGCR_SBIAS5_3_Pos (24U)
#define DDRPHYC_DLLGCR_SBIAS5_3_Msk (0x7U << DDRPHYC_DLLGCR_SBIAS5_3_Pos) /*!< 0x07000000 */
#define DDRPHYC_DLLGCR_SBIAS5_3     DDRPHYC_DLLGCR_SBIAS5_3_Msk           /*!< Slave bias trim */
#define DDRPHYC_DLLGCR_SBIAS5_3_0   (0x1U << DDRPHYC_DLLGCR_SBIAS5_3_Pos) /*!< 0x01000000 */
#define DDRPHYC_DLLGCR_SBIAS5_3_1   (0x2U << DDRPHYC_DLLGCR_SBIAS5_3_Pos) /*!< 0x02000000 */
#define DDRPHYC_DLLGCR_SBIAS5_3_2   (0x4U << DDRPHYC_DLLGCR_SBIAS5_3_Pos) /*!< 0x04000000 */
#define DDRPHYC_DLLGCR_FDTRMSL_Pos  (27U)
#define DDRPHYC_DLLGCR_FDTRMSL_Msk  (0x3U << DDRPHYC_DLLGCR_FDTRMSL_Pos)  /*!< 0x18000000 */
#define DDRPHYC_DLLGCR_FDTRMSL      DDRPHYC_DLLGCR_FDTRMSL_Msk            /*!< Slave bypass fixed delay trim */
#define DDRPHYC_DLLGCR_FDTRMSL_0    (0x1U << DDRPHYC_DLLGCR_FDTRMSL_Pos)  /*!< 0x08000000 */
#define DDRPHYC_DLLGCR_FDTRMSL_1    (0x2U << DDRPHYC_DLLGCR_FDTRMSL_Pos)  /*!< 0x10000000 */
#define DDRPHYC_DLLGCR_LOCKDET_Pos  (29U)
#define DDRPHYC_DLLGCR_LOCKDET_Msk  (0x1U << DDRPHYC_DLLGCR_LOCKDET_Pos)  /*!< 0x20000000 */
#define DDRPHYC_DLLGCR_LOCKDET      DDRPHYC_DLLGCR_LOCKDET_Msk            /*!< Master lock detect enable */
#define DDRPHYC_DLLGCR_DLLRSVD2_Pos (30U)
#define DDRPHYC_DLLGCR_DLLRSVD2_Msk (0x3U << DDRPHYC_DLLGCR_DLLRSVD2_Pos) /*!< 0xC0000000 */
#define DDRPHYC_DLLGCR_DLLRSVD2     DDRPHYC_DLLGCR_DLLRSVD2_Msk           /*!< These bit are connected to the DLL control bus and reserved for future use. */
#define DDRPHYC_DLLGCR_DLLRSVD2_0   (0x1U << DDRPHYC_DLLGCR_DLLRSVD2_Pos) /*!< 0x40000000 */
#define DDRPHYC_DLLGCR_DLLRSVD2_1   (0x2U << DDRPHYC_DLLGCR_DLLRSVD2_Pos) /*!< 0x80000000 */

/***************  Bit definition for DDRPHYC_ACDLLCR register  ****************/
#define DDRPHYC_ACDLLCR_MFBDLY_Pos  (6U)
#define DDRPHYC_ACDLLCR_MFBDLY_Msk  (0x7U << DDRPHYC_ACDLLCR_MFBDLY_Pos)  /*!< 0x000001C0 */
#define DDRPHYC_ACDLLCR_MFBDLY      DDRPHYC_ACDLLCR_MFBDLY_Msk            /*!< Master DLL feed-back delay trim */
#define DDRPHYC_ACDLLCR_MFBDLY_0    (0x1U << DDRPHYC_ACDLLCR_MFBDLY_Pos)  /*!< 0x00000040 */
#define DDRPHYC_ACDLLCR_MFBDLY_1    (0x2U << DDRPHYC_ACDLLCR_MFBDLY_Pos)  /*!< 0x00000080 */
#define DDRPHYC_ACDLLCR_MFBDLY_2    (0x4U << DDRPHYC_ACDLLCR_MFBDLY_Pos)  /*!< 0x00000100 */
#define DDRPHYC_ACDLLCR_MFWDLY_Pos  (9U)
#define DDRPHYC_ACDLLCR_MFWDLY_Msk  (0x7U << DDRPHYC_ACDLLCR_MFWDLY_Pos)  /*!< 0x00000E00 */
#define DDRPHYC_ACDLLCR_MFWDLY      DDRPHYC_ACDLLCR_MFWDLY_Msk            /*!< Master DLL feed-forward delay trim */
#define DDRPHYC_ACDLLCR_MFWDLY_0    (0x1U << DDRPHYC_ACDLLCR_MFWDLY_Pos)  /*!< 0x00000200 */
#define DDRPHYC_ACDLLCR_MFWDLY_1    (0x2U << DDRPHYC_ACDLLCR_MFWDLY_Pos)  /*!< 0x00000400 */
#define DDRPHYC_ACDLLCR_MFWDLY_2    (0x4U << DDRPHYC_ACDLLCR_MFWDLY_Pos)  /*!< 0x00000800 */
#define DDRPHYC_ACDLLCR_ATESTEN_Pos (18U)
#define DDRPHYC_ACDLLCR_ATESTEN_Msk (0x1U << DDRPHYC_ACDLLCR_ATESTEN_Pos) /*!< 0x00040000 */
#define DDRPHYC_ACDLLCR_ATESTEN     DDRPHYC_ACDLLCR_ATESTEN_Msk           /*!< Analog test enable */
#define DDRPHYC_ACDLLCR_DLLSRST_Pos (30U)
#define DDRPHYC_ACDLLCR_DLLSRST_Msk (0x1U << DDRPHYC_ACDLLCR_DLLSRST_Pos) /*!< 0x40000000 */
#define DDRPHYC_ACDLLCR_DLLSRST     DDRPHYC_ACDLLCR_DLLSRST_Msk           /*!< DLL soft reset */
#define DDRPHYC_ACDLLCR_DLLDIS_Pos  (31U)
#define DDRPHYC_ACDLLCR_DLLDIS_Msk  (0x1U << DDRPHYC_ACDLLCR_DLLDIS_Pos)  /*!< 0x80000000 */
#define DDRPHYC_ACDLLCR_DLLDIS      DDRPHYC_ACDLLCR_DLLDIS_Msk            /*!< DLL disable */

/*****************  Bit definition for DDRPHYC_PTR0 register  *****************/
#define DDRPHYC_PTR0_TDLLSRST_Pos (0U)
#define DDRPHYC_PTR0_TDLLSRST_Msk (0x3FU << DDRPHYC_PTR0_TDLLSRST_Pos)  /*!< 0x0000003F */
#define DDRPHYC_PTR0_TDLLSRST     DDRPHYC_PTR0_TDLLSRST_Msk             /*!< DLL soft reset */
#define DDRPHYC_PTR0_TDLLSRST_0   (0x1U << DDRPHYC_PTR0_TDLLSRST_Pos)   /*!< 0x00000001 */
#define DDRPHYC_PTR0_TDLLSRST_1   (0x2U << DDRPHYC_PTR0_TDLLSRST_Pos)   /*!< 0x00000002 */
#define DDRPHYC_PTR0_TDLLSRST_2   (0x4U << DDRPHYC_PTR0_TDLLSRST_Pos)   /*!< 0x00000004 */
#define DDRPHYC_PTR0_TDLLSRST_3   (0x8U << DDRPHYC_PTR0_TDLLSRST_Pos)   /*!< 0x00000008 */
#define DDRPHYC_PTR0_TDLLSRST_4   (0x10U << DDRPHYC_PTR0_TDLLSRST_Pos)  /*!< 0x00000010 */
#define DDRPHYC_PTR0_TDLLSRST_5   (0x20U << DDRPHYC_PTR0_TDLLSRST_Pos)  /*!< 0x00000020 */
#define DDRPHYC_PTR0_TDLLLOCK_Pos (6U)
#define DDRPHYC_PTR0_TDLLLOCK_Msk (0xFFFU << DDRPHYC_PTR0_TDLLLOCK_Pos) /*!< 0x0003FFC0 */
#define DDRPHYC_PTR0_TDLLLOCK     DDRPHYC_PTR0_TDLLLOCK_Msk             /*!< DLL lock time */
#define DDRPHYC_PTR0_TDLLLOCK_0   (0x1U << DDRPHYC_PTR0_TDLLLOCK_Pos)   /*!< 0x00000040 */
#define DDRPHYC_PTR0_TDLLLOCK_1   (0x2U << DDRPHYC_PTR0_TDLLLOCK_Pos)   /*!< 0x00000080 */
#define DDRPHYC_PTR0_TDLLLOCK_2   (0x4U << DDRPHYC_PTR0_TDLLLOCK_Pos)   /*!< 0x00000100 */
#define DDRPHYC_PTR0_TDLLLOCK_3   (0x8U << DDRPHYC_PTR0_TDLLLOCK_Pos)   /*!< 0x00000200 */
#define DDRPHYC_PTR0_TDLLLOCK_4   (0x10U << DDRPHYC_PTR0_TDLLLOCK_Pos)  /*!< 0x00000400 */
#define DDRPHYC_PTR0_TDLLLOCK_5   (0x20U << DDRPHYC_PTR0_TDLLLOCK_Pos)  /*!< 0x00000800 */
#define DDRPHYC_PTR0_TDLLLOCK_6   (0x40U << DDRPHYC_PTR0_TDLLLOCK_Pos)  /*!< 0x00001000 */
#define DDRPHYC_PTR0_TDLLLOCK_7   (0x80U << DDRPHYC_PTR0_TDLLLOCK_Pos)  /*!< 0x00002000 */
#define DDRPHYC_PTR0_TDLLLOCK_8   (0x100U << DDRPHYC_PTR0_TDLLLOCK_Pos) /*!< 0x00004000 */
#define DDRPHYC_PTR0_TDLLLOCK_9   (0x200U << DDRPHYC_PTR0_TDLLLOCK_Pos) /*!< 0x00008000 */
#define DDRPHYC_PTR0_TDLLLOCK_10  (0x400U << DDRPHYC_PTR0_TDLLLOCK_Pos) /*!< 0x00010000 */
#define DDRPHYC_PTR0_TDLLLOCK_11  (0x800U << DDRPHYC_PTR0_TDLLLOCK_Pos) /*!< 0x00020000 */
#define DDRPHYC_PTR0_TITMSRST_Pos (18U)
#define DDRPHYC_PTR0_TITMSRST_Msk (0xFU << DDRPHYC_PTR0_TITMSRST_Pos)   /*!< 0x003C0000 */
#define DDRPHYC_PTR0_TITMSRST     DDRPHYC_PTR0_TITMSRST_Msk             /*!< ITM soft reset */
#define DDRPHYC_PTR0_TITMSRST_0   (0x1U << DDRPHYC_PTR0_TITMSRST_Pos)   /*!< 0x00040000 */
#define DDRPHYC_PTR0_TITMSRST_1   (0x2U << DDRPHYC_PTR0_TITMSRST_Pos)   /*!< 0x00080000 */
#define DDRPHYC_PTR0_TITMSRST_2   (0x4U << DDRPHYC_PTR0_TITMSRST_Pos)   /*!< 0x00100000 */
#define DDRPHYC_PTR0_TITMSRST_3   (0x8U << DDRPHYC_PTR0_TITMSRST_Pos)   /*!< 0x00200000 */

/*****************  Bit definition for DDRPHYC_PTR1 register  *****************/
#define DDRPHYC_PTR1_TDINIT0_Pos (0U)
#define DDRPHYC_PTR1_TDINIT0_Msk (0x7FFFFU << DDRPHYC_PTR1_TDINIT0_Pos) /*!< 0x0007FFFF */
#define DDRPHYC_PTR1_TDINIT0     DDRPHYC_PTR1_TDINIT0_Msk               /*!< tDINIT0 */
#define DDRPHYC_PTR1_TDINIT0_0   (0x1U << DDRPHYC_PTR1_TDINIT0_Pos)     /*!< 0x00000001 */
#define DDRPHYC_PTR1_TDINIT0_1   (0x2U << DDRPHYC_PTR1_TDINIT0_Pos)     /*!< 0x00000002 */
#define DDRPHYC_PTR1_TDINIT0_2   (0x4U << DDRPHYC_PTR1_TDINIT0_Pos)     /*!< 0x00000004 */
#define DDRPHYC_PTR1_TDINIT0_3   (0x8U << DDRPHYC_PTR1_TDINIT0_Pos)     /*!< 0x00000008 */
#define DDRPHYC_PTR1_TDINIT0_4   (0x10U << DDRPHYC_PTR1_TDINIT0_Pos)    /*!< 0x00000010 */
#define DDRPHYC_PTR1_TDINIT0_5   (0x20U << DDRPHYC_PTR1_TDINIT0_Pos)    /*!< 0x00000020 */
#define DDRPHYC_PTR1_TDINIT0_6   (0x40U << DDRPHYC_PTR1_TDINIT0_Pos)    /*!< 0x00000040 */
#define DDRPHYC_PTR1_TDINIT0_7   (0x80U << DDRPHYC_PTR1_TDINIT0_Pos)    /*!< 0x00000080 */
#define DDRPHYC_PTR1_TDINIT0_8   (0x100U << DDRPHYC_PTR1_TDINIT0_Pos)   /*!< 0x00000100 */
#define DDRPHYC_PTR1_TDINIT0_9   (0x200U << DDRPHYC_PTR1_TDINIT0_Pos)   /*!< 0x00000200 */
#define DDRPHYC_PTR1_TDINIT0_10  (0x400U << DDRPHYC_PTR1_TDINIT0_Pos)   /*!< 0x00000400 */
#define DDRPHYC_PTR1_TDINIT0_11  (0x800U << DDRPHYC_PTR1_TDINIT0_Pos)   /*!< 0x00000800 */
#define DDRPHYC_PTR1_TDINIT0_12  (0x1000U << DDRPHYC_PTR1_TDINIT0_Pos)  /*!< 0x00001000 */
#define DDRPHYC_PTR1_TDINIT0_13  (0x2000U << DDRPHYC_PTR1_TDINIT0_Pos)  /*!< 0x00002000 */
#define DDRPHYC_PTR1_TDINIT0_14  (0x4000U << DDRPHYC_PTR1_TDINIT0_Pos)  /*!< 0x00004000 */
#define DDRPHYC_PTR1_TDINIT0_15  (0x8000U << DDRPHYC_PTR1_TDINIT0_Pos)  /*!< 0x00008000 */
#define DDRPHYC_PTR1_TDINIT0_16  (0x10000U << DDRPHYC_PTR1_TDINIT0_Pos) /*!< 0x00010000 */
#define DDRPHYC_PTR1_TDINIT0_17  (0x20000U << DDRPHYC_PTR1_TDINIT0_Pos) /*!< 0x00020000 */
#define DDRPHYC_PTR1_TDINIT0_18  (0x40000U << DDRPHYC_PTR1_TDINIT0_Pos) /*!< 0x00040000 */
#define DDRPHYC_PTR1_TDINIT1_Pos (19U)
#define DDRPHYC_PTR1_TDINIT1_Msk (0xFFU << DDRPHYC_PTR1_TDINIT1_Pos)    /*!< 0x07F80000 */
#define DDRPHYC_PTR1_TDINIT1     DDRPHYC_PTR1_TDINIT1_Msk               /*!< tDINIT1 */
#define DDRPHYC_PTR1_TDINIT1_0   (0x1U << DDRPHYC_PTR1_TDINIT1_Pos)     /*!< 0x00080000 */
#define DDRPHYC_PTR1_TDINIT1_1   (0x2U << DDRPHYC_PTR1_TDINIT1_Pos)     /*!< 0x00100000 */
#define DDRPHYC_PTR1_TDINIT1_2   (0x4U << DDRPHYC_PTR1_TDINIT1_Pos)     /*!< 0x00200000 */
#define DDRPHYC_PTR1_TDINIT1_3   (0x8U << DDRPHYC_PTR1_TDINIT1_Pos)     /*!< 0x00400000 */
#define DDRPHYC_PTR1_TDINIT1_4   (0x10U << DDRPHYC_PTR1_TDINIT1_Pos)    /*!< 0x00800000 */
#define DDRPHYC_PTR1_TDINIT1_5   (0x20U << DDRPHYC_PTR1_TDINIT1_Pos)    /*!< 0x01000000 */
#define DDRPHYC_PTR1_TDINIT1_6   (0x40U << DDRPHYC_PTR1_TDINIT1_Pos)    /*!< 0x02000000 */
#define DDRPHYC_PTR1_TDINIT1_7   (0x80U << DDRPHYC_PTR1_TDINIT1_Pos)    /*!< 0x04000000 */

/*****************  Bit definition for DDRPHYC_PTR2 register  *****************/
#define DDRPHYC_PTR2_TDINIT2_Pos (0U)
#define DDRPHYC_PTR2_TDINIT2_Msk (0x1FFFFU << DDRPHYC_PTR2_TDINIT2_Pos) /*!< 0x0001FFFF */
#define DDRPHYC_PTR2_TDINIT2     DDRPHYC_PTR2_TDINIT2_Msk               /*!< tDINIT2 */
#define DDRPHYC_PTR2_TDINIT2_0   (0x1U << DDRPHYC_PTR2_TDINIT2_Pos)     /*!< 0x00000001 */
#define DDRPHYC_PTR2_TDINIT2_1   (0x2U << DDRPHYC_PTR2_TDINIT2_Pos)     /*!< 0x00000002 */
#define DDRPHYC_PTR2_TDINIT2_2   (0x4U << DDRPHYC_PTR2_TDINIT2_Pos)     /*!< 0x00000004 */
#define DDRPHYC_PTR2_TDINIT2_3   (0x8U << DDRPHYC_PTR2_TDINIT2_Pos)     /*!< 0x00000008 */
#define DDRPHYC_PTR2_TDINIT2_4   (0x10U << DDRPHYC_PTR2_TDINIT2_Pos)    /*!< 0x00000010 */
#define DDRPHYC_PTR2_TDINIT2_5   (0x20U << DDRPHYC_PTR2_TDINIT2_Pos)    /*!< 0x00000020 */
#define DDRPHYC_PTR2_TDINIT2_6   (0x40U << DDRPHYC_PTR2_TDINIT2_Pos)    /*!< 0x00000040 */
#define DDRPHYC_PTR2_TDINIT2_7   (0x80U << DDRPHYC_PTR2_TDINIT2_Pos)    /*!< 0x00000080 */
#define DDRPHYC_PTR2_TDINIT2_8   (0x100U << DDRPHYC_PTR2_TDINIT2_Pos)   /*!< 0x00000100 */
#define DDRPHYC_PTR2_TDINIT2_9   (0x200U << DDRPHYC_PTR2_TDINIT2_Pos)   /*!< 0x00000200 */
#define DDRPHYC_PTR2_TDINIT2_10  (0x400U << DDRPHYC_PTR2_TDINIT2_Pos)   /*!< 0x00000400 */
#define DDRPHYC_PTR2_TDINIT2_11  (0x800U << DDRPHYC_PTR2_TDINIT2_Pos)   /*!< 0x00000800 */
#define DDRPHYC_PTR2_TDINIT2_12  (0x1000U << DDRPHYC_PTR2_TDINIT2_Pos)  /*!< 0x00001000 */
#define DDRPHYC_PTR2_TDINIT2_13  (0x2000U << DDRPHYC_PTR2_TDINIT2_Pos)  /*!< 0x00002000 */
#define DDRPHYC_PTR2_TDINIT2_14  (0x4000U << DDRPHYC_PTR2_TDINIT2_Pos)  /*!< 0x00004000 */
#define DDRPHYC_PTR2_TDINIT2_15  (0x8000U << DDRPHYC_PTR2_TDINIT2_Pos)  /*!< 0x00008000 */
#define DDRPHYC_PTR2_TDINIT2_16  (0x10000U << DDRPHYC_PTR2_TDINIT2_Pos) /*!< 0x00010000 */
#define DDRPHYC_PTR2_TDINIT3_Pos (17U)
#define DDRPHYC_PTR2_TDINIT3_Msk (0x3FFU << DDRPHYC_PTR2_TDINIT3_Pos)   /*!< 0x07FE0000 */
#define DDRPHYC_PTR2_TDINIT3     DDRPHYC_PTR2_TDINIT3_Msk               /*!< tDINIT3 */
#define DDRPHYC_PTR2_TDINIT3_0   (0x1U << DDRPHYC_PTR2_TDINIT3_Pos)     /*!< 0x00020000 */
#define DDRPHYC_PTR2_TDINIT3_1   (0x2U << DDRPHYC_PTR2_TDINIT3_Pos)     /*!< 0x00040000 */
#define DDRPHYC_PTR2_TDINIT3_2   (0x4U << DDRPHYC_PTR2_TDINIT3_Pos)     /*!< 0x00080000 */
#define DDRPHYC_PTR2_TDINIT3_3   (0x8U << DDRPHYC_PTR2_TDINIT3_Pos)     /*!< 0x00100000 */
#define DDRPHYC_PTR2_TDINIT3_4   (0x10U << DDRPHYC_PTR2_TDINIT3_Pos)    /*!< 0x00200000 */
#define DDRPHYC_PTR2_TDINIT3_5   (0x20U << DDRPHYC_PTR2_TDINIT3_Pos)    /*!< 0x00400000 */
#define DDRPHYC_PTR2_TDINIT3_6   (0x40U << DDRPHYC_PTR2_TDINIT3_Pos)    /*!< 0x00800000 */
#define DDRPHYC_PTR2_TDINIT3_7   (0x80U << DDRPHYC_PTR2_TDINIT3_Pos)    /*!< 0x01000000 */
#define DDRPHYC_PTR2_TDINIT3_8   (0x100U << DDRPHYC_PTR2_TDINIT3_Pos)   /*!< 0x02000000 */
#define DDRPHYC_PTR2_TDINIT3_9   (0x200U << DDRPHYC_PTR2_TDINIT3_Pos)   /*!< 0x04000000 */

/****************  Bit definition for DDRPHYC_ACIOCR register  ****************/
#define DDRPHYC_ACIOCR_ACIOM_Pos   (0U)
#define DDRPHYC_ACIOCR_ACIOM_Msk   (0x1U << DDRPHYC_ACIOCR_ACIOM_Pos)   /*!< 0x00000001 */
#define DDRPHYC_ACIOCR_ACIOM       DDRPHYC_ACIOCR_ACIOM_Msk             /*!< AC pins I/O mode */
#define DDRPHYC_ACIOCR_ACOE_Pos    (1U)
#define DDRPHYC_ACIOCR_ACOE_Msk    (0x1U << DDRPHYC_ACIOCR_ACOE_Pos)    /*!< 0x00000002 */
#define DDRPHYC_ACIOCR_ACOE        DDRPHYC_ACIOCR_ACOE_Msk              /*!< AC pins output enable */
#define DDRPHYC_ACIOCR_ACODT_Pos   (2U)
#define DDRPHYC_ACIOCR_ACODT_Msk   (0x1U << DDRPHYC_ACIOCR_ACODT_Pos)   /*!< 0x00000004 */
#define DDRPHYC_ACIOCR_ACODT       DDRPHYC_ACIOCR_ACODT_Msk             /*!< AC pins ODT */
#define DDRPHYC_ACIOCR_ACPDD_Pos   (3U)
#define DDRPHYC_ACIOCR_ACPDD_Msk   (0x1U << DDRPHYC_ACIOCR_ACPDD_Pos)   /*!< 0x00000008 */
#define DDRPHYC_ACIOCR_ACPDD       DDRPHYC_ACIOCR_ACPDD_Msk             /*!< AC pins power down drivers */
#define DDRPHYC_ACIOCR_ACPDR_Pos   (4U)
#define DDRPHYC_ACIOCR_ACPDR_Msk   (0x1U << DDRPHYC_ACIOCR_ACPDR_Pos)   /*!< 0x00000010 */
#define DDRPHYC_ACIOCR_ACPDR       DDRPHYC_ACIOCR_ACPDR_Msk             /*!< AC pins power down receivers */
#define DDRPHYC_ACIOCR_CKODT_Pos   (5U)
#define DDRPHYC_ACIOCR_CKODT_Msk   (0x7U << DDRPHYC_ACIOCR_CKODT_Pos)   /*!< 0x000000E0 */
#define DDRPHYC_ACIOCR_CKODT       DDRPHYC_ACIOCR_CKODT_Msk             /*!< CK pin ODT */
#define DDRPHYC_ACIOCR_CKODT_0     (0x1U << DDRPHYC_ACIOCR_CKODT_Pos)   /*!< 0x00000020 */
#define DDRPHYC_ACIOCR_CKODT_1     (0x2U << DDRPHYC_ACIOCR_CKODT_Pos)   /*!< 0x00000040 */
#define DDRPHYC_ACIOCR_CKODT_2     (0x4U << DDRPHYC_ACIOCR_CKODT_Pos)   /*!< 0x00000080 */
#define DDRPHYC_ACIOCR_CKPDD_Pos   (8U)
#define DDRPHYC_ACIOCR_CKPDD_Msk   (0x7U << DDRPHYC_ACIOCR_CKPDD_Pos)   /*!< 0x00000700 */
#define DDRPHYC_ACIOCR_CKPDD       DDRPHYC_ACIOCR_CKPDD_Msk             /*!< CK pin power down driver */
#define DDRPHYC_ACIOCR_CKPDD_0     (0x1U << DDRPHYC_ACIOCR_CKPDD_Pos)   /*!< 0x00000100 */
#define DDRPHYC_ACIOCR_CKPDD_1     (0x2U << DDRPHYC_ACIOCR_CKPDD_Pos)   /*!< 0x00000200 */
#define DDRPHYC_ACIOCR_CKPDD_2     (0x4U << DDRPHYC_ACIOCR_CKPDD_Pos)   /*!< 0x00000400 */
#define DDRPHYC_ACIOCR_CKPDR_Pos   (11U)
#define DDRPHYC_ACIOCR_CKPDR_Msk   (0x7U << DDRPHYC_ACIOCR_CKPDR_Pos)   /*!< 0x00003800 */
#define DDRPHYC_ACIOCR_CKPDR       DDRPHYC_ACIOCR_CKPDR_Msk             /*!< CK pin power down receiver */
#define DDRPHYC_ACIOCR_CKPDR_0     (0x1U << DDRPHYC_ACIOCR_CKPDR_Pos)   /*!< 0x00000800 */
#define DDRPHYC_ACIOCR_CKPDR_1     (0x2U << DDRPHYC_ACIOCR_CKPDR_Pos)   /*!< 0x00001000 */
#define DDRPHYC_ACIOCR_CKPDR_2     (0x4U << DDRPHYC_ACIOCR_CKPDR_Pos)   /*!< 0x00002000 */
#define DDRPHYC_ACIOCR_RANKODT_Pos (14U)
#define DDRPHYC_ACIOCR_RANKODT_Msk (0x1U << DDRPHYC_ACIOCR_RANKODT_Pos) /*!< 0x00004000 */
#define DDRPHYC_ACIOCR_RANKODT     DDRPHYC_ACIOCR_RANKODT_Msk           /*!< Rank ODT */
#define DDRPHYC_ACIOCR_CSPDD_Pos   (18U)
#define DDRPHYC_ACIOCR_CSPDD_Msk   (0x1U << DDRPHYC_ACIOCR_CSPDD_Pos)   /*!< 0x00040000 */
#define DDRPHYC_ACIOCR_CSPDD       DDRPHYC_ACIOCR_CSPDD_Msk             /*!< CS power down driver */
#define DDRPHYC_ACIOCR_RANKPDR_Pos (22U)
#define DDRPHYC_ACIOCR_RANKPDR_Msk (0x1U << DDRPHYC_ACIOCR_RANKPDR_Pos) /*!< 0x00400000 */
#define DDRPHYC_ACIOCR_RANKPDR     DDRPHYC_ACIOCR_RANKPDR_Msk           /*!< Rank power down receiver */
#define DDRPHYC_ACIOCR_RSTODT_Pos  (26U)
#define DDRPHYC_ACIOCR_RSTODT_Msk  (0x1U << DDRPHYC_ACIOCR_RSTODT_Pos)  /*!< 0x04000000 */
#define DDRPHYC_ACIOCR_RSTODT      DDRPHYC_ACIOCR_RSTODT_Msk            /*!< RST pin ODT */
#define DDRPHYC_ACIOCR_RSTPDD_Pos  (27U)
#define DDRPHYC_ACIOCR_RSTPDD_Msk  (0x1U << DDRPHYC_ACIOCR_RSTPDD_Pos)  /*!< 0x08000000 */
#define DDRPHYC_ACIOCR_RSTPDD      DDRPHYC_ACIOCR_RSTPDD_Msk            /*!< RST pin power down driver */
#define DDRPHYC_ACIOCR_RSTPDR_Pos  (28U)
#define DDRPHYC_ACIOCR_RSTPDR_Msk  (0x1U << DDRPHYC_ACIOCR_RSTPDR_Pos)  /*!< 0x10000000 */
#define DDRPHYC_ACIOCR_RSTPDR      DDRPHYC_ACIOCR_RSTPDR_Msk            /*!< RST pin power down receiver */
#define DDRPHYC_ACIOCR_RSTIOM_Pos  (29U)
#define DDRPHYC_ACIOCR_RSTIOM_Msk  (0x1U << DDRPHYC_ACIOCR_RSTIOM_Pos)  /*!< 0x20000000 */
#define DDRPHYC_ACIOCR_RSTIOM      DDRPHYC_ACIOCR_RSTIOM_Msk            /*!< Reset I/O mode */
#define DDRPHYC_ACIOCR_ACSR_Pos    (30U)
#define DDRPHYC_ACIOCR_ACSR_Msk    (0x3U << DDRPHYC_ACIOCR_ACSR_Pos)    /*!< 0xC0000000 */
#define DDRPHYC_ACIOCR_ACSR        DDRPHYC_ACIOCR_ACSR_Msk              /*!< AC slew rate */
#define DDRPHYC_ACIOCR_ACSR_0      (0x1U << DDRPHYC_ACIOCR_ACSR_Pos)    /*!< 0x40000000 */
#define DDRPHYC_ACIOCR_ACSR_1      (0x2U << DDRPHYC_ACIOCR_ACSR_Pos)    /*!< 0x80000000 */

/****************  Bit definition for DDRPHYC_DXCCR register  *****************/
#define DDRPHYC_DXCCR_DXODT_Pos   (0U)
#define DDRPHYC_DXCCR_DXODT_Msk   (0x1U << DDRPHYC_DXCCR_DXODT_Pos)   /*!< 0x00000001 */
#define DDRPHYC_DXCCR_DXODT       DDRPHYC_DXCCR_DXODT_Msk             /*!< Data on die termination */
#define DDRPHYC_DXCCR_DXIOM_Pos   (1U)
#define DDRPHYC_DXCCR_DXIOM_Msk   (0x1U << DDRPHYC_DXCCR_DXIOM_Pos)   /*!< 0x00000002 */
#define DDRPHYC_DXCCR_DXIOM       DDRPHYC_DXCCR_DXIOM_Msk             /*!< Data I/O mode */
#define DDRPHYC_DXCCR_DXPDD_Pos   (2U)
#define DDRPHYC_DXCCR_DXPDD_Msk   (0x1U << DDRPHYC_DXCCR_DXPDD_Pos)   /*!< 0x00000004 */
#define DDRPHYC_DXCCR_DXPDD       DDRPHYC_DXCCR_DXPDD_Msk             /*!< Data power down driver */
#define DDRPHYC_DXCCR_DXPDR_Pos   (3U)
#define DDRPHYC_DXCCR_DXPDR_Msk   (0x1U << DDRPHYC_DXCCR_DXPDR_Pos)   /*!< 0x00000008 */
#define DDRPHYC_DXCCR_DXPDR       DDRPHYC_DXCCR_DXPDR_Msk             /*!< Data power down receiver */
#define DDRPHYC_DXCCR_DQSRES_Pos  (4U)
#define DDRPHYC_DXCCR_DQSRES_Msk  (0xFU << DDRPHYC_DXCCR_DQSRES_Pos)  /*!< 0x000000F0 */
#define DDRPHYC_DXCCR_DQSRES      DDRPHYC_DXCCR_DQSRES_Msk            /*!< DQS resistor */
#define DDRPHYC_DXCCR_DQSRES_0    (0x1U << DDRPHYC_DXCCR_DQSRES_Pos)  /*!< 0x00000010 */
#define DDRPHYC_DXCCR_DQSRES_1    (0x2U << DDRPHYC_DXCCR_DQSRES_Pos)  /*!< 0x00000020 */
#define DDRPHYC_DXCCR_DQSRES_2    (0x4U << DDRPHYC_DXCCR_DQSRES_Pos)  /*!< 0x00000040 */
#define DDRPHYC_DXCCR_DQSRES_3    (0x8U << DDRPHYC_DXCCR_DQSRES_Pos)  /*!< 0x00000080 */
#define DDRPHYC_DXCCR_DQSNRES_Pos (8U)
#define DDRPHYC_DXCCR_DQSNRES_Msk (0xFU << DDRPHYC_DXCCR_DQSNRES_Pos) /*!< 0x00000F00 */
#define DDRPHYC_DXCCR_DQSNRES     DDRPHYC_DXCCR_DQSNRES_Msk           /*!< DQS# resistor */
#define DDRPHYC_DXCCR_DQSNRES_0   (0x1U << DDRPHYC_DXCCR_DQSNRES_Pos) /*!< 0x00000100 */
#define DDRPHYC_DXCCR_DQSNRES_1   (0x2U << DDRPHYC_DXCCR_DQSNRES_Pos) /*!< 0x00000200 */
#define DDRPHYC_DXCCR_DQSNRES_2   (0x4U << DDRPHYC_DXCCR_DQSNRES_Pos) /*!< 0x00000400 */
#define DDRPHYC_DXCCR_DQSNRES_3   (0x8U << DDRPHYC_DXCCR_DQSNRES_Pos) /*!< 0x00000800 */
#define DDRPHYC_DXCCR_DQSNRST_Pos (14U)
#define DDRPHYC_DXCCR_DQSNRST_Msk (0x1U << DDRPHYC_DXCCR_DQSNRST_Pos) /*!< 0x00004000 */
#define DDRPHYC_DXCCR_DQSNRST     DDRPHYC_DXCCR_DQSNRST_Msk           /*!< DQS reset */
#define DDRPHYC_DXCCR_RVSEL_Pos   (15U)
#define DDRPHYC_DXCCR_RVSEL_Msk   (0x1U << DDRPHYC_DXCCR_RVSEL_Pos)   /*!< 0x00008000 */
#define DDRPHYC_DXCCR_RVSEL       DDRPHYC_DXCCR_RVSEL_Msk             /*!< ITMD read valid select */
#define DDRPHYC_DXCCR_AWDT_Pos    (16U)
#define DDRPHYC_DXCCR_AWDT_Msk    (0x1U << DDRPHYC_DXCCR_AWDT_Pos)    /*!< 0x00010000 */
#define DDRPHYC_DXCCR_AWDT        DDRPHYC_DXCCR_AWDT_Msk              /*!< Active window data train */

/****************  Bit definition for DDRPHYC_DSGCR register  *****************/
#define DDRPHYC_DSGCR_PUREN_Pos   (0U)
#define DDRPHYC_DSGCR_PUREN_Msk   (0x1U << DDRPHYC_DSGCR_PUREN_Pos)   /*!< 0x00000001 */
#define DDRPHYC_DSGCR_PUREN       DDRPHYC_DSGCR_PUREN_Msk             /*!< PHY update request enable */
#define DDRPHYC_DSGCR_BDISEN_Pos  (1U)
#define DDRPHYC_DSGCR_BDISEN_Msk  (0x1U << DDRPHYC_DSGCR_BDISEN_Pos)  /*!< 0x00000002 */
#define DDRPHYC_DSGCR_BDISEN      DDRPHYC_DSGCR_BDISEN_Msk            /*!< Byte disable enable */
#define DDRPHYC_DSGCR_ZUEN_Pos    (2U)
#define DDRPHYC_DSGCR_ZUEN_Msk    (0x1U << DDRPHYC_DSGCR_ZUEN_Pos)    /*!< 0x00000004 */
#define DDRPHYC_DSGCR_ZUEN        DDRPHYC_DSGCR_ZUEN_Msk              /*!< zcal on DFI update request */
#define DDRPHYC_DSGCR_LPIOPD_Pos  (3U)
#define DDRPHYC_DSGCR_LPIOPD_Msk  (0x1U << DDRPHYC_DSGCR_LPIOPD_Pos)  /*!< 0x00000008 */
#define DDRPHYC_DSGCR_LPIOPD      DDRPHYC_DSGCR_LPIOPD_Msk            /*!< Low power I/O power down */
#define DDRPHYC_DSGCR_LPDLLPD_Pos (4U)
#define DDRPHYC_DSGCR_LPDLLPD_Msk (0x1U << DDRPHYC_DSGCR_LPDLLPD_Pos) /*!< 0x00000010 */
#define DDRPHYC_DSGCR_LPDLLPD     DDRPHYC_DSGCR_LPDLLPD_Msk           /*!< Low power DLL power down */
#define DDRPHYC_DSGCR_DQSGX_Pos   (5U)
#define DDRPHYC_DSGCR_DQSGX_Msk   (0x7U << DDRPHYC_DSGCR_DQSGX_Pos)   /*!< 0x000000E0 */
#define DDRPHYC_DSGCR_DQSGX       DDRPHYC_DSGCR_DQSGX_Msk             /*!< DQS gate extension */
#define DDRPHYC_DSGCR_DQSGX_0     (0x1U << DDRPHYC_DSGCR_DQSGX_Pos)   /*!< 0x00000020 */
#define DDRPHYC_DSGCR_DQSGX_1     (0x2U << DDRPHYC_DSGCR_DQSGX_Pos)   /*!< 0x00000040 */
#define DDRPHYC_DSGCR_DQSGX_2     (0x4U << DDRPHYC_DSGCR_DQSGX_Pos)   /*!< 0x00000080 */
#define DDRPHYC_DSGCR_DQSGE_Pos   (8U)
#define DDRPHYC_DSGCR_DQSGE_Msk   (0x7U << DDRPHYC_DSGCR_DQSGE_Pos)   /*!< 0x00000700 */
#define DDRPHYC_DSGCR_DQSGE       DDRPHYC_DSGCR_DQSGE_Msk             /*!< DQS gate early */
#define DDRPHYC_DSGCR_DQSGE_0     (0x1U << DDRPHYC_DSGCR_DQSGE_Pos)   /*!< 0x00000100 */
#define DDRPHYC_DSGCR_DQSGE_1     (0x2U << DDRPHYC_DSGCR_DQSGE_Pos)   /*!< 0x00000200 */
#define DDRPHYC_DSGCR_DQSGE_2     (0x4U << DDRPHYC_DSGCR_DQSGE_Pos)   /*!< 0x00000400 */
#define DDRPHYC_DSGCR_NOBUB_Pos   (11U)
#define DDRPHYC_DSGCR_NOBUB_Msk   (0x1U << DDRPHYC_DSGCR_NOBUB_Pos)   /*!< 0x00000800 */
#define DDRPHYC_DSGCR_NOBUB       DDRPHYC_DSGCR_NOBUB_Msk             /*!< No bubble */
#define DDRPHYC_DSGCR_FXDLAT_Pos  (12U)
#define DDRPHYC_DSGCR_FXDLAT_Msk  (0x1U << DDRPHYC_DSGCR_FXDLAT_Pos)  /*!< 0x00001000 */
#define DDRPHYC_DSGCR_FXDLAT      DDRPHYC_DSGCR_FXDLAT_Msk            /*!< Fixed latency */
#define DDRPHYC_DSGCR_CKEPDD_Pos  (16U)
#define DDRPHYC_DSGCR_CKEPDD_Msk  (0x1U << DDRPHYC_DSGCR_CKEPDD_Pos)  /*!< 0x00010000 */
#define DDRPHYC_DSGCR_CKEPDD      DDRPHYC_DSGCR_CKEPDD_Msk            /*!< CKE power down driver */
#define DDRPHYC_DSGCR_ODTPDD_Pos  (20U)
#define DDRPHYC_DSGCR_ODTPDD_Msk  (0x1U << DDRPHYC_DSGCR_ODTPDD_Pos)  /*!< 0x00100000 */
#define DDRPHYC_DSGCR_ODTPDD      DDRPHYC_DSGCR_ODTPDD_Msk            /*!< ODT power down driver */
#define DDRPHYC_DSGCR_NL2PD_Pos   (24U)
#define DDRPHYC_DSGCR_NL2PD_Msk   (0x1U << DDRPHYC_DSGCR_NL2PD_Pos)   /*!< 0x01000000 */
#define DDRPHYC_DSGCR_NL2PD       DDRPHYC_DSGCR_NL2PD_Msk             /*!< Non LPDDR2 power down */
#define DDRPHYC_DSGCR_NL2OE_Pos   (25U)
#define DDRPHYC_DSGCR_NL2OE_Msk   (0x1U << DDRPHYC_DSGCR_NL2OE_Pos)   /*!< 0x02000000 */
#define DDRPHYC_DSGCR_NL2OE       DDRPHYC_DSGCR_NL2OE_Msk             /*!< Non LPDDR2 output enable */
#define DDRPHYC_DSGCR_TPDPD_Pos   (26U)
#define DDRPHYC_DSGCR_TPDPD_Msk   (0x1U << DDRPHYC_DSGCR_TPDPD_Pos)   /*!< 0x04000000 */
#define DDRPHYC_DSGCR_TPDPD       DDRPHYC_DSGCR_TPDPD_Msk             /*!< TPD power down driver (N/A LPDDR only) */
#define DDRPHYC_DSGCR_TPDOE_Pos   (27U)
#define DDRPHYC_DSGCR_TPDOE_Msk   (0x1U << DDRPHYC_DSGCR_TPDOE_Pos)   /*!< 0x08000000 */
#define DDRPHYC_DSGCR_TPDOE       DDRPHYC_DSGCR_TPDOE_Msk             /*!< TPD output enable (N/A LPDDR only) */
#define DDRPHYC_DSGCR_CKOE_Pos    (28U)
#define DDRPHYC_DSGCR_CKOE_Msk    (0x1U << DDRPHYC_DSGCR_CKOE_Pos)    /*!< 0x10000000 */
#define DDRPHYC_DSGCR_CKOE        DDRPHYC_DSGCR_CKOE_Msk              /*!< CK output enable */
#define DDRPHYC_DSGCR_ODTOE_Pos   (29U)
#define DDRPHYC_DSGCR_ODTOE_Msk   (0x1U << DDRPHYC_DSGCR_ODTOE_Pos)   /*!< 0x20000000 */
#define DDRPHYC_DSGCR_ODTOE       DDRPHYC_DSGCR_ODTOE_Msk             /*!< ODT output enable */
#define DDRPHYC_DSGCR_RSTOE_Pos   (30U)
#define DDRPHYC_DSGCR_RSTOE_Msk   (0x1U << DDRPHYC_DSGCR_RSTOE_Pos)   /*!< 0x40000000 */
#define DDRPHYC_DSGCR_RSTOE       DDRPHYC_DSGCR_RSTOE_Msk             /*!< RST output enable */
#define DDRPHYC_DSGCR_CKEOE_Pos   (31U)
#define DDRPHYC_DSGCR_CKEOE_Msk   (0x1U << DDRPHYC_DSGCR_CKEOE_Pos)   /*!< 0x80000000 */
#define DDRPHYC_DSGCR_CKEOE       DDRPHYC_DSGCR_CKEOE_Msk             /*!< CKE output enable */

/*****************  Bit definition for DDRPHYC_DCR register  ******************/
#define DDRPHYC_DCR_DDRMD_Pos   (0U)
#define DDRPHYC_DCR_DDRMD_Msk   (0x7U << DDRPHYC_DCR_DDRMD_Pos)   /*!< 0x00000007 */
#define DDRPHYC_DCR_DDRMD       DDRPHYC_DCR_DDRMD_Msk             /*!< SDRAM DDR mode */
#define DDRPHYC_DCR_DDRMD_0     (0x1U << DDRPHYC_DCR_DDRMD_Pos)   /*!< 0x00000001 */
#define DDRPHYC_DCR_DDRMD_1     (0x2U << DDRPHYC_DCR_DDRMD_Pos)   /*!< 0x00000002 */
#define DDRPHYC_DCR_DDRMD_2     (0x4U << DDRPHYC_DCR_DDRMD_Pos)   /*!< 0x00000004 */
#define DDRPHYC_DCR_DDR8BNK_Pos (3U)
#define DDRPHYC_DCR_DDR8BNK_Msk (0x1U << DDRPHYC_DCR_DDR8BNK_Pos) /*!< 0x00000008 */
#define DDRPHYC_DCR_DDR8BNK     DDRPHYC_DCR_DDR8BNK_Msk           /*!< DDR 8 banks */
#define DDRPHYC_DCR_PDQ_Pos     (4U)
#define DDRPHYC_DCR_PDQ_Msk     (0x7U << DDRPHYC_DCR_PDQ_Pos)     /*!< 0x00000070 */
#define DDRPHYC_DCR_PDQ         DDRPHYC_DCR_PDQ_Msk               /*!< Primary DQ(DDR3 Only) */
#define DDRPHYC_DCR_PDQ_0       (0x1U << DDRPHYC_DCR_PDQ_Pos)     /*!< 0x00000010 */
#define DDRPHYC_DCR_PDQ_1       (0x2U << DDRPHYC_DCR_PDQ_Pos)     /*!< 0x00000020 */
#define DDRPHYC_DCR_PDQ_2       (0x4U << DDRPHYC_DCR_PDQ_Pos)     /*!< 0x00000040 */
#define DDRPHYC_DCR_MPRDQ_Pos   (7U)
#define DDRPHYC_DCR_MPRDQ_Msk   (0x1U << DDRPHYC_DCR_MPRDQ_Pos)   /*!< 0x00000080 */
#define DDRPHYC_DCR_MPRDQ       DDRPHYC_DCR_MPRDQ_Msk             /*!< MPR DQ */
#define DDRPHYC_DCR_DDRTYPE_Pos (8U)
#define DDRPHYC_DCR_DDRTYPE_Msk (0x3U << DDRPHYC_DCR_DDRTYPE_Pos) /*!< 0x00000300 */
#define DDRPHYC_DCR_DDRTYPE     DDRPHYC_DCR_DDRTYPE_Msk           /*!< DDR type (LPDDR2 S4) */
#define DDRPHYC_DCR_DDRTYPE_0   (0x1U << DDRPHYC_DCR_DDRTYPE_Pos) /*!< 0x00000100 */
#define DDRPHYC_DCR_DDRTYPE_1   (0x2U << DDRPHYC_DCR_DDRTYPE_Pos) /*!< 0x00000200 */
#define DDRPHYC_DCR_NOSRA_Pos   (27U)
#define DDRPHYC_DCR_NOSRA_Msk   (0x1U << DDRPHYC_DCR_NOSRA_Pos)   /*!< 0x08000000 */
#define DDRPHYC_DCR_NOSRA       DDRPHYC_DCR_NOSRA_Msk             /*!< No simultaneous rank access */
#define DDRPHYC_DCR_DDR2T_Pos   (28U)
#define DDRPHYC_DCR_DDR2T_Msk   (0x1U << DDRPHYC_DCR_DDR2T_Pos)   /*!< 0x10000000 */
#define DDRPHYC_DCR_DDR2T       DDRPHYC_DCR_DDR2T_Msk             /*!< 2T timing */
#define DDRPHYC_DCR_UDIMM_Pos   (29U)
#define DDRPHYC_DCR_UDIMM_Msk   (0x1U << DDRPHYC_DCR_UDIMM_Pos)   /*!< 0x20000000 */
#define DDRPHYC_DCR_UDIMM       DDRPHYC_DCR_UDIMM_Msk             /*!< Unbuffered DIMM */
#define DDRPHYC_DCR_RDIMM_Pos   (30U)
#define DDRPHYC_DCR_RDIMM_Msk   (0x1U << DDRPHYC_DCR_RDIMM_Pos)   /*!< 0x40000000 */
#define DDRPHYC_DCR_RDIMM       DDRPHYC_DCR_RDIMM_Msk             /*!< Registered DIMM */
#define DDRPHYC_DCR_TPD_Pos     (31U)
#define DDRPHYC_DCR_TPD_Msk     (0x1U << DDRPHYC_DCR_TPD_Pos)     /*!< 0x80000000 */
#define DDRPHYC_DCR_TPD         DDRPHYC_DCR_TPD_Msk               /*!< Test power down (N/A LPDDR only) */

/****************  Bit definition for DDRPHYC_DTPR0 register  *****************/
#define DDRPHYC_DTPR0_TMRD_Pos (0U)
#define DDRPHYC_DTPR0_TMRD_Msk (0x3U << DDRPHYC_DTPR0_TMRD_Pos)  /*!< 0x00000003 */
#define DDRPHYC_DTPR0_TMRD     DDRPHYC_DTPR0_TMRD_Msk            /*!< tMRD */
#define DDRPHYC_DTPR0_TMRD_0   (0x1U << DDRPHYC_DTPR0_TMRD_Pos)  /*!< 0x00000001 */
#define DDRPHYC_DTPR0_TMRD_1   (0x2U << DDRPHYC_DTPR0_TMRD_Pos)  /*!< 0x00000002 */
#define DDRPHYC_DTPR0_TRTP_Pos (2U)
#define DDRPHYC_DTPR0_TRTP_Msk (0x7U << DDRPHYC_DTPR0_TRTP_Pos)  /*!< 0x0000001C */
#define DDRPHYC_DTPR0_TRTP     DDRPHYC_DTPR0_TRTP_Msk            /*!< tRTP */
#define DDRPHYC_DTPR0_TRTP_0   (0x1U << DDRPHYC_DTPR0_TRTP_Pos)  /*!< 0x00000004 */
#define DDRPHYC_DTPR0_TRTP_1   (0x2U << DDRPHYC_DTPR0_TRTP_Pos)  /*!< 0x00000008 */
#define DDRPHYC_DTPR0_TRTP_2   (0x4U << DDRPHYC_DTPR0_TRTP_Pos)  /*!< 0x00000010 */
#define DDRPHYC_DTPR0_TWTR_Pos (5U)
#define DDRPHYC_DTPR0_TWTR_Msk (0x7U << DDRPHYC_DTPR0_TWTR_Pos)  /*!< 0x000000E0 */
#define DDRPHYC_DTPR0_TWTR     DDRPHYC_DTPR0_TWTR_Msk            /*!< tWTR */
#define DDRPHYC_DTPR0_TWTR_0   (0x1U << DDRPHYC_DTPR0_TWTR_Pos)  /*!< 0x00000020 */
#define DDRPHYC_DTPR0_TWTR_1   (0x2U << DDRPHYC_DTPR0_TWTR_Pos)  /*!< 0x00000040 */
#define DDRPHYC_DTPR0_TWTR_2   (0x4U << DDRPHYC_DTPR0_TWTR_Pos)  /*!< 0x00000080 */
#define DDRPHYC_DTPR0_TRP_Pos  (8U)
#define DDRPHYC_DTPR0_TRP_Msk  (0xFU << DDRPHYC_DTPR0_TRP_Pos)   /*!< 0x00000F00 */
#define DDRPHYC_DTPR0_TRP      DDRPHYC_DTPR0_TRP_Msk             /*!< tRP */
#define DDRPHYC_DTPR0_TRP_0    (0x1U << DDRPHYC_DTPR0_TRP_Pos)   /*!< 0x00000100 */
#define DDRPHYC_DTPR0_TRP_1    (0x2U << DDRPHYC_DTPR0_TRP_Pos)   /*!< 0x00000200 */
#define DDRPHYC_DTPR0_TRP_2    (0x4U << DDRPHYC_DTPR0_TRP_Pos)   /*!< 0x00000400 */
#define DDRPHYC_DTPR0_TRP_3    (0x8U << DDRPHYC_DTPR0_TRP_Pos)   /*!< 0x00000800 */
#define DDRPHYC_DTPR0_TRCD_Pos (12U)
#define DDRPHYC_DTPR0_TRCD_Msk (0xFU << DDRPHYC_DTPR0_TRCD_Pos)  /*!< 0x0000F000 */
#define DDRPHYC_DTPR0_TRCD     DDRPHYC_DTPR0_TRCD_Msk            /*!< tRCD */
#define DDRPHYC_DTPR0_TRCD_0   (0x1U << DDRPHYC_DTPR0_TRCD_Pos)  /*!< 0x00001000 */
#define DDRPHYC_DTPR0_TRCD_1   (0x2U << DDRPHYC_DTPR0_TRCD_Pos)  /*!< 0x00002000 */
#define DDRPHYC_DTPR0_TRCD_2   (0x4U << DDRPHYC_DTPR0_TRCD_Pos)  /*!< 0x00004000 */
#define DDRPHYC_DTPR0_TRCD_3   (0x8U << DDRPHYC_DTPR0_TRCD_Pos)  /*!< 0x00008000 */
#define DDRPHYC_DTPR0_TRAS_Pos (16U)
#define DDRPHYC_DTPR0_TRAS_Msk (0x1FU << DDRPHYC_DTPR0_TRAS_Pos) /*!< 0x001F0000 */
#define DDRPHYC_DTPR0_TRAS     DDRPHYC_DTPR0_TRAS_Msk            /*!< tRAS */
#define DDRPHYC_DTPR0_TRAS_0   (0x1U << DDRPHYC_DTPR0_TRAS_Pos)  /*!< 0x00010000 */
#define DDRPHYC_DTPR0_TRAS_1   (0x2U << DDRPHYC_DTPR0_TRAS_Pos)  /*!< 0x00020000 */
#define DDRPHYC_DTPR0_TRAS_2   (0x4U << DDRPHYC_DTPR0_TRAS_Pos)  /*!< 0x00040000 */
#define DDRPHYC_DTPR0_TRAS_3   (0x8U << DDRPHYC_DTPR0_TRAS_Pos)  /*!< 0x00080000 */
#define DDRPHYC_DTPR0_TRAS_4   (0x10U << DDRPHYC_DTPR0_TRAS_Pos) /*!< 0x00100000 */
#define DDRPHYC_DTPR0_TRRD_Pos (21U)
#define DDRPHYC_DTPR0_TRRD_Msk (0xFU << DDRPHYC_DTPR0_TRRD_Pos)  /*!< 0x01E00000 */
#define DDRPHYC_DTPR0_TRRD     DDRPHYC_DTPR0_TRRD_Msk            /*!< tRRD */
#define DDRPHYC_DTPR0_TRRD_0   (0x1U << DDRPHYC_DTPR0_TRRD_Pos)  /*!< 0x00200000 */
#define DDRPHYC_DTPR0_TRRD_1   (0x2U << DDRPHYC_DTPR0_TRRD_Pos)  /*!< 0x00400000 */
#define DDRPHYC_DTPR0_TRRD_2   (0x4U << DDRPHYC_DTPR0_TRRD_Pos)  /*!< 0x00800000 */
#define DDRPHYC_DTPR0_TRRD_3   (0x8U << DDRPHYC_DTPR0_TRRD_Pos)  /*!< 0x01000000 */
#define DDRPHYC_DTPR0_TRC_Pos  (25U)
#define DDRPHYC_DTPR0_TRC_Msk  (0x3FU << DDRPHYC_DTPR0_TRC_Pos)  /*!< 0x7E000000 */
#define DDRPHYC_DTPR0_TRC      DDRPHYC_DTPR0_TRC_Msk             /*!< tRC */
#define DDRPHYC_DTPR0_TRC_0    (0x1U << DDRPHYC_DTPR0_TRC_Pos)   /*!< 0x02000000 */
#define DDRPHYC_DTPR0_TRC_1    (0x2U << DDRPHYC_DTPR0_TRC_Pos)   /*!< 0x04000000 */
#define DDRPHYC_DTPR0_TRC_2    (0x4U << DDRPHYC_DTPR0_TRC_Pos)   /*!< 0x08000000 */
#define DDRPHYC_DTPR0_TRC_3    (0x8U << DDRPHYC_DTPR0_TRC_Pos)   /*!< 0x10000000 */
#define DDRPHYC_DTPR0_TRC_4    (0x10U << DDRPHYC_DTPR0_TRC_Pos)  /*!< 0x20000000 */
#define DDRPHYC_DTPR0_TRC_5    (0x20U << DDRPHYC_DTPR0_TRC_Pos)  /*!< 0x40000000 */
#define DDRPHYC_DTPR0_TCCD_Pos (31U)
#define DDRPHYC_DTPR0_TCCD_Msk (0x1U << DDRPHYC_DTPR0_TCCD_Pos)  /*!< 0x80000000 */
#define DDRPHYC_DTPR0_TCCD     DDRPHYC_DTPR0_TCCD_Msk            /*!< tCCDRead to read and write to write command delay */

/****************  Bit definition for DDRPHYC_DTPR1 register  *****************/
#define DDRPHYC_DTPR1_TAOND_Pos     (0U)
#define DDRPHYC_DTPR1_TAOND_Msk     (0x3U << DDRPHYC_DTPR1_TAOND_Pos)     /*!< 0x00000003 */
#define DDRPHYC_DTPR1_TAOND         DDRPHYC_DTPR1_TAOND_Msk               /*!< tAOND/tAOFD */
#define DDRPHYC_DTPR1_TAOND_0       (0x1U << DDRPHYC_DTPR1_TAOND_Pos)     /*!< 0x00000001 */
#define DDRPHYC_DTPR1_TAOND_1       (0x2U << DDRPHYC_DTPR1_TAOND_Pos)     /*!< 0x00000002 */
#define DDRPHYC_DTPR1_TRTW_Pos      (2U)
#define DDRPHYC_DTPR1_TRTW_Msk      (0x1U << DDRPHYC_DTPR1_TRTW_Pos)      /*!< 0x00000004 */
#define DDRPHYC_DTPR1_TRTW          DDRPHYC_DTPR1_TRTW_Msk                /*!< tRTW */
#define DDRPHYC_DTPR1_TFAW_Pos      (3U)
#define DDRPHYC_DTPR1_TFAW_Msk      (0x3FU << DDRPHYC_DTPR1_TFAW_Pos)     /*!< 0x000001F8 */
#define DDRPHYC_DTPR1_TFAW          DDRPHYC_DTPR1_TFAW_Msk                /*!< tFAW */
#define DDRPHYC_DTPR1_TFAW_0        (0x1U << DDRPHYC_DTPR1_TFAW_Pos)      /*!< 0x00000008 */
#define DDRPHYC_DTPR1_TFAW_1        (0x2U << DDRPHYC_DTPR1_TFAW_Pos)      /*!< 0x00000010 */
#define DDRPHYC_DTPR1_TFAW_2        (0x4U << DDRPHYC_DTPR1_TFAW_Pos)      /*!< 0x00000020 */
#define DDRPHYC_DTPR1_TFAW_3        (0x8U << DDRPHYC_DTPR1_TFAW_Pos)      /*!< 0x00000040 */
#define DDRPHYC_DTPR1_TFAW_4        (0x10U << DDRPHYC_DTPR1_TFAW_Pos)     /*!< 0x00000080 */
#define DDRPHYC_DTPR1_TFAW_5        (0x20U << DDRPHYC_DTPR1_TFAW_Pos)     /*!< 0x00000100 */
#define DDRPHYC_DTPR1_TMOD_Pos      (9U)
#define DDRPHYC_DTPR1_TMOD_Msk      (0x3U << DDRPHYC_DTPR1_TMOD_Pos)      /*!< 0x00000600 */
#define DDRPHYC_DTPR1_TMOD          DDRPHYC_DTPR1_TMOD_Msk                /*!< tMOD */
#define DDRPHYC_DTPR1_TMOD_0        (0x1U << DDRPHYC_DTPR1_TMOD_Pos)      /*!< 0x00000200 */
#define DDRPHYC_DTPR1_TMOD_1        (0x2U << DDRPHYC_DTPR1_TMOD_Pos)      /*!< 0x00000400 */
#define DDRPHYC_DTPR1_TRTODT_Pos    (11U)
#define DDRPHYC_DTPR1_TRTODT_Msk    (0x1U << DDRPHYC_DTPR1_TRTODT_Pos)    /*!< 0x00000800 */
#define DDRPHYC_DTPR1_TRTODT        DDRPHYC_DTPR1_TRTODT_Msk              /*!< tRTODT */
#define DDRPHYC_DTPR1_TRFC_Pos      (16U)
#define DDRPHYC_DTPR1_TRFC_Msk      (0xFFU << DDRPHYC_DTPR1_TRFC_Pos)     /*!< 0x00FF0000 */
#define DDRPHYC_DTPR1_TRFC          DDRPHYC_DTPR1_TRFC_Msk                /*!< tRFC */
#define DDRPHYC_DTPR1_TRFC_0        (0x1U << DDRPHYC_DTPR1_TRFC_Pos)      /*!< 0x00010000 */
#define DDRPHYC_DTPR1_TRFC_1        (0x2U << DDRPHYC_DTPR1_TRFC_Pos)      /*!< 0x00020000 */
#define DDRPHYC_DTPR1_TRFC_2        (0x4U << DDRPHYC_DTPR1_TRFC_Pos)      /*!< 0x00040000 */
#define DDRPHYC_DTPR1_TRFC_3        (0x8U << DDRPHYC_DTPR1_TRFC_Pos)      /*!< 0x00080000 */
#define DDRPHYC_DTPR1_TRFC_4        (0x10U << DDRPHYC_DTPR1_TRFC_Pos)     /*!< 0x00100000 */
#define DDRPHYC_DTPR1_TRFC_5        (0x20U << DDRPHYC_DTPR1_TRFC_Pos)     /*!< 0x00200000 */
#define DDRPHYC_DTPR1_TRFC_6        (0x40U << DDRPHYC_DTPR1_TRFC_Pos)     /*!< 0x00400000 */
#define DDRPHYC_DTPR1_TRFC_7        (0x80U << DDRPHYC_DTPR1_TRFC_Pos)     /*!< 0x00800000 */
#define DDRPHYC_DTPR1_TDQSCKMIN_Pos (24U)
#define DDRPHYC_DTPR1_TDQSCKMIN_Msk (0x7U << DDRPHYC_DTPR1_TDQSCKMIN_Pos) /*!< 0x07000000 */
#define DDRPHYC_DTPR1_TDQSCKMIN     DDRPHYC_DTPR1_TDQSCKMIN_Msk           /*!< tDQSCKmin */
#define DDRPHYC_DTPR1_TDQSCKMIN_0   (0x1U << DDRPHYC_DTPR1_TDQSCKMIN_Pos) /*!< 0x01000000 */
#define DDRPHYC_DTPR1_TDQSCKMIN_1   (0x2U << DDRPHYC_DTPR1_TDQSCKMIN_Pos) /*!< 0x02000000 */
#define DDRPHYC_DTPR1_TDQSCKMIN_2   (0x4U << DDRPHYC_DTPR1_TDQSCKMIN_Pos) /*!< 0x04000000 */
#define DDRPHYC_DTPR1_TDQSCKMAX_Pos (27U)
#define DDRPHYC_DTPR1_TDQSCKMAX_Msk (0x7U << DDRPHYC_DTPR1_TDQSCKMAX_Pos) /*!< 0x38000000 */
#define DDRPHYC_DTPR1_TDQSCKMAX     DDRPHYC_DTPR1_TDQSCKMAX_Msk           /*!< tDQSCKmax */
#define DDRPHYC_DTPR1_TDQSCKMAX_0   (0x1U << DDRPHYC_DTPR1_TDQSCKMAX_Pos) /*!< 0x08000000 */
#define DDRPHYC_DTPR1_TDQSCKMAX_1   (0x2U << DDRPHYC_DTPR1_TDQSCKMAX_Pos) /*!< 0x10000000 */
#define DDRPHYC_DTPR1_TDQSCKMAX_2   (0x4U << DDRPHYC_DTPR1_TDQSCKMAX_Pos) /*!< 0x20000000 */

/****************  Bit definition for DDRPHYC_DTPR2 register  *****************/
#define DDRPHYC_DTPR2_TXS_Pos   (0U)
#define DDRPHYC_DTPR2_TXS_Msk   (0x3FFU << DDRPHYC_DTPR2_TXS_Pos)   /*!< 0x000003FF */
#define DDRPHYC_DTPR2_TXS       DDRPHYC_DTPR2_TXS_Msk               /*!< tXS */
#define DDRPHYC_DTPR2_TXS_0     (0x1U << DDRPHYC_DTPR2_TXS_Pos)     /*!< 0x00000001 */
#define DDRPHYC_DTPR2_TXS_1     (0x2U << DDRPHYC_DTPR2_TXS_Pos)     /*!< 0x00000002 */
#define DDRPHYC_DTPR2_TXS_2     (0x4U << DDRPHYC_DTPR2_TXS_Pos)     /*!< 0x00000004 */
#define DDRPHYC_DTPR2_TXS_3     (0x8U << DDRPHYC_DTPR2_TXS_Pos)     /*!< 0x00000008 */
#define DDRPHYC_DTPR2_TXS_4     (0x10U << DDRPHYC_DTPR2_TXS_Pos)    /*!< 0x00000010 */
#define DDRPHYC_DTPR2_TXS_5     (0x20U << DDRPHYC_DTPR2_TXS_Pos)    /*!< 0x00000020 */
#define DDRPHYC_DTPR2_TXS_6     (0x40U << DDRPHYC_DTPR2_TXS_Pos)    /*!< 0x00000040 */
#define DDRPHYC_DTPR2_TXS_7     (0x80U << DDRPHYC_DTPR2_TXS_Pos)    /*!< 0x00000080 */
#define DDRPHYC_DTPR2_TXS_8     (0x100U << DDRPHYC_DTPR2_TXS_Pos)   /*!< 0x00000100 */
#define DDRPHYC_DTPR2_TXS_9     (0x200U << DDRPHYC_DTPR2_TXS_Pos)   /*!< 0x00000200 */
#define DDRPHYC_DTPR2_TXP_Pos   (10U)                             
#define DDRPHYC_DTPR2_TXP_Msk   (0x1FU << DDRPHYC_DTPR2_TXP_Pos)    /*!< 0x00007C00 */
#define DDRPHYC_DTPR2_TXP       DDRPHYC_DTPR2_TXP_Msk               /*!< tXP */
#define DDRPHYC_DTPR2_TXP_0     (0x1U << DDRPHYC_DTPR2_TXP_Pos)     /*!< 0x00000400 */
#define DDRPHYC_DTPR2_TXP_1     (0x2U << DDRPHYC_DTPR2_TXP_Pos)     /*!< 0x00000800 */
#define DDRPHYC_DTPR2_TXP_2     (0x4U << DDRPHYC_DTPR2_TXP_Pos)     /*!< 0x00001000 */
#define DDRPHYC_DTPR2_TXP_3     (0x8U << DDRPHYC_DTPR2_TXP_Pos)     /*!< 0x00002000 */
#define DDRPHYC_DTPR2_TXP_4     (0x10U << DDRPHYC_DTPR2_TXP_Pos)    /*!< 0x00004000 */
#define DDRPHYC_DTPR2_TCKE_Pos  (15U)                             
#define DDRPHYC_DTPR2_TCKE_Msk  (0xFU << DDRPHYC_DTPR2_TCKE_Pos)    /*!< 0x00078000 */
#define DDRPHYC_DTPR2_TCKE      DDRPHYC_DTPR2_TCKE_Msk              /*!< tCKE */
#define DDRPHYC_DTPR2_TCKE_0    (0x1U << DDRPHYC_DTPR2_TCKE_Pos)    /*!< 0x00008000 */
#define DDRPHYC_DTPR2_TCKE_1    (0x2U << DDRPHYC_DTPR2_TCKE_Pos)    /*!< 0x00010000 */
#define DDRPHYC_DTPR2_TCKE_2    (0x4U << DDRPHYC_DTPR2_TCKE_Pos)    /*!< 0x00020000 */
#define DDRPHYC_DTPR2_TCKE_3    (0x8U << DDRPHYC_DTPR2_TCKE_Pos)    /*!< 0x00040000 */
#define DDRPHYC_DTPR2_TDLLK_Pos (19U)
#define DDRPHYC_DTPR2_TDLLK_Msk (0x3FFU << DDRPHYC_DTPR2_TDLLK_Pos) /*!< 0x1FF80000 */
#define DDRPHYC_DTPR2_TDLLK     DDRPHYC_DTPR2_TDLLK_Msk             /*!< tDLLK */
#define DDRPHYC_DTPR2_TDLLK_0   (0x1U << DDRPHYC_DTPR2_TDLLK_Pos)   /*!< 0x00080000 */
#define DDRPHYC_DTPR2_TDLLK_1   (0x2U << DDRPHYC_DTPR2_TDLLK_Pos)   /*!< 0x00100000 */
#define DDRPHYC_DTPR2_TDLLK_2   (0x4U << DDRPHYC_DTPR2_TDLLK_Pos)   /*!< 0x00200000 */
#define DDRPHYC_DTPR2_TDLLK_3   (0x8U << DDRPHYC_DTPR2_TDLLK_Pos)   /*!< 0x00400000 */
#define DDRPHYC_DTPR2_TDLLK_4   (0x10U << DDRPHYC_DTPR2_TDLLK_Pos)  /*!< 0x00800000 */
#define DDRPHYC_DTPR2_TDLLK_5   (0x20U << DDRPHYC_DTPR2_TDLLK_Pos)  /*!< 0x01000000 */
#define DDRPHYC_DTPR2_TDLLK_6   (0x40U << DDRPHYC_DTPR2_TDLLK_Pos)  /*!< 0x02000000 */
#define DDRPHYC_DTPR2_TDLLK_7   (0x80U << DDRPHYC_DTPR2_TDLLK_Pos)  /*!< 0x04000000 */
#define DDRPHYC_DTPR2_TDLLK_8   (0x100U << DDRPHYC_DTPR2_TDLLK_Pos) /*!< 0x08000000 */
#define DDRPHYC_DTPR2_TDLLK_9   (0x200U << DDRPHYC_DTPR2_TDLLK_Pos) /*!< 0x10000000 */

/***************  Bit definition for DDRPHYC_DDR3_MR0 register  ***************/
#define DDRPHYC_DDR3_MR0_BL_Pos   (0U)
#define DDRPHYC_DDR3_MR0_BL_Msk   (0x3U << DDRPHYC_DDR3_MR0_BL_Pos)   /*!< 0x00000003 */
#define DDRPHYC_DDR3_MR0_BL       DDRPHYC_DDR3_MR0_BL_Msk             /*!< Burst length */
#define DDRPHYC_DDR3_MR0_BL_0     (0x1U << DDRPHYC_DDR3_MR0_BL_Pos)   /*!< 0x00000001 */
#define DDRPHYC_DDR3_MR0_BL_1     (0x2U << DDRPHYC_DDR3_MR0_BL_Pos)   /*!< 0x00000002 */
#define DDRPHYC_DDR3_MR0_CL0_Pos  (2U)
#define DDRPHYC_DDR3_MR0_CL0_Msk  (0x1U << DDRPHYC_DDR3_MR0_CL0_Pos)  /*!< 0x00000004 */
#define DDRPHYC_DDR3_MR0_CL0      DDRPHYC_DDR3_MR0_CL0_Msk            /*!< CAS latency */
#define DDRPHYC_DDR3_MR0_BT_Pos   (3U)
#define DDRPHYC_DDR3_MR0_BT_Msk   (0x1U << DDRPHYC_DDR3_MR0_BT_Pos)   /*!< 0x00000008 */
#define DDRPHYC_DDR3_MR0_BT       DDRPHYC_DDR3_MR0_BT_Msk             /*!< Burst type */
#define DDRPHYC_DDR3_MR0_CL_Pos   (4U)
#define DDRPHYC_DDR3_MR0_CL_Msk   (0x7U << DDRPHYC_DDR3_MR0_CL_Pos)   /*!< 0x00000070 */
#define DDRPHYC_DDR3_MR0_CL       DDRPHYC_DDR3_MR0_CL_Msk             /*!< CAS latency */
#define DDRPHYC_DDR3_MR0_CL_0     (0x1U << DDRPHYC_DDR3_MR0_CL_Pos)   /*!< 0x00000010 */
#define DDRPHYC_DDR3_MR0_CL_1     (0x2U << DDRPHYC_DDR3_MR0_CL_Pos)   /*!< 0x00000020 */
#define DDRPHYC_DDR3_MR0_CL_2     (0x4U << DDRPHYC_DDR3_MR0_CL_Pos)   /*!< 0x00000040 */
#define DDRPHYC_DDR3_MR0_TM_Pos   (7U)
#define DDRPHYC_DDR3_MR0_TM_Msk   (0x1U << DDRPHYC_DDR3_MR0_TM_Pos)   /*!< 0x00000080 */
#define DDRPHYC_DDR3_MR0_TM       DDRPHYC_DDR3_MR0_TM_Msk             /*!< Operating mode */
#define DDRPHYC_DDR3_MR0_DR_Pos   (8U)
#define DDRPHYC_DDR3_MR0_DR_Msk   (0x1U << DDRPHYC_DDR3_MR0_DR_Pos)   /*!< 0x00000100 */
#define DDRPHYC_DDR3_MR0_DR       DDRPHYC_DDR3_MR0_DR_Msk             /*!< DLL reset (autoclear) */
#define DDRPHYC_DDR3_MR0_WR_Pos   (9U)
#define DDRPHYC_DDR3_MR0_WR_Msk   (0x7U << DDRPHYC_DDR3_MR0_WR_Pos)   /*!< 0x00000E00 */
#define DDRPHYC_DDR3_MR0_WR       DDRPHYC_DDR3_MR0_WR_Msk             /*!< Write recovery */
#define DDRPHYC_DDR3_MR0_WR_0     (0x1U << DDRPHYC_DDR3_MR0_WR_Pos)   /*!< 0x00000200 */
#define DDRPHYC_DDR3_MR0_WR_1     (0x2U << DDRPHYC_DDR3_MR0_WR_Pos)   /*!< 0x00000400 */
#define DDRPHYC_DDR3_MR0_WR_2     (0x4U << DDRPHYC_DDR3_MR0_WR_Pos)   /*!< 0x00000800 */
#define DDRPHYC_DDR3_MR0_PD_Pos   (12U)
#define DDRPHYC_DDR3_MR0_PD_Msk   (0x1U << DDRPHYC_DDR3_MR0_PD_Pos)   /*!< 0x00001000 */
#define DDRPHYC_DDR3_MR0_PD       DDRPHYC_DDR3_MR0_PD_Msk             /*!< Power-down control */
#define DDRPHYC_DDR3_MR0_RSVD_Pos (13U)
#define DDRPHYC_DDR3_MR0_RSVD_Msk (0x7U << DDRPHYC_DDR3_MR0_RSVD_Pos) /*!< 0x0000E000 */
#define DDRPHYC_DDR3_MR0_RSVD     DDRPHYC_DDR3_MR0_RSVD_Msk           /*!< JEDEC reserved. */
#define DDRPHYC_DDR3_MR0_RSVD_0   (0x1U << DDRPHYC_DDR3_MR0_RSVD_Pos) /*!< 0x00002000 */
#define DDRPHYC_DDR3_MR0_RSVD_1   (0x2U << DDRPHYC_DDR3_MR0_RSVD_Pos) /*!< 0x00004000 */
#define DDRPHYC_DDR3_MR0_RSVD_2   (0x4U << DDRPHYC_DDR3_MR0_RSVD_Pos) /*!< 0x00008000 */

/***************  Bit definition for DDRPHYC_DDR3_MR1 register  ***************/
#define DDRPHYC_DDR3_MR1_DE_Pos    (0U)
#define DDRPHYC_DDR3_MR1_DE_Msk    (0x1U << DDRPHYC_DDR3_MR1_DE_Pos)    /*!< 0x00000001 */
#define DDRPHYC_DDR3_MR1_DE        DDRPHYC_DDR3_MR1_DE_Msk              /*!< DLL enable/disable */
#define DDRPHYC_DDR3_MR1_DIC0_Pos  (1U)
#define DDRPHYC_DDR3_MR1_DIC0_Msk  (0x1U << DDRPHYC_DDR3_MR1_DIC0_Pos)  /*!< 0x00000002 */
#define DDRPHYC_DDR3_MR1_DIC0      DDRPHYC_DDR3_MR1_DIC0_Msk            /*!< Output driver impedance control */
#define DDRPHYC_DDR3_MR1_RTT0_Pos  (2U)
#define DDRPHYC_DDR3_MR1_RTT0_Msk  (0x1U << DDRPHYC_DDR3_MR1_RTT0_Pos)  /*!< 0x00000004 */
#define DDRPHYC_DDR3_MR1_RTT0      DDRPHYC_DDR3_MR1_RTT0_Msk            /*!< On die termination */
#define DDRPHYC_DDR3_MR1_AL_Pos    (3U)
#define DDRPHYC_DDR3_MR1_AL_Msk    (0x3U << DDRPHYC_DDR3_MR1_AL_Pos)    /*!< 0x00000018 */
#define DDRPHYC_DDR3_MR1_AL        DDRPHYC_DDR3_MR1_AL_Msk              /*!< Posted CAS Additive Latency: */
#define DDRPHYC_DDR3_MR1_AL_0      (0x1U << DDRPHYC_DDR3_MR1_AL_Pos)    /*!< 0x00000008 */
#define DDRPHYC_DDR3_MR1_AL_1      (0x2U << DDRPHYC_DDR3_MR1_AL_Pos)    /*!< 0x00000010 */
#define DDRPHYC_DDR3_MR1_DIC1_Pos  (5U)
#define DDRPHYC_DDR3_MR1_DIC1_Msk  (0x1U << DDRPHYC_DDR3_MR1_DIC1_Pos)  /*!< 0x00000020 */
#define DDRPHYC_DDR3_MR1_DIC1      DDRPHYC_DDR3_MR1_DIC1_Msk            /*!< Output driver impedance control */
#define DDRPHYC_DDR3_MR1_RTT1_Pos  (6U)
#define DDRPHYC_DDR3_MR1_RTT1_Msk  (0x1U << DDRPHYC_DDR3_MR1_RTT1_Pos)  /*!< 0x00000040 */
#define DDRPHYC_DDR3_MR1_RTT1      DDRPHYC_DDR3_MR1_RTT1_Msk            /*!< On die termination */
#define DDRPHYC_DDR3_MR1_LEVEL_Pos (7U)
#define DDRPHYC_DDR3_MR1_LEVEL_Msk (0x1U << DDRPHYC_DDR3_MR1_LEVEL_Pos) /*!< 0x00000080 */
#define DDRPHYC_DDR3_MR1_LEVEL     DDRPHYC_DDR3_MR1_LEVEL_Msk           /*!< Write leveling enable (N/A) */
#define DDRPHYC_DDR3_MR1_RTT2_Pos  (9U)
#define DDRPHYC_DDR3_MR1_RTT2_Msk  (0x1U << DDRPHYC_DDR3_MR1_RTT2_Pos)  /*!< 0x00000200 */
#define DDRPHYC_DDR3_MR1_RTT2      DDRPHYC_DDR3_MR1_RTT2_Msk            /*!< On die termination */
#define DDRPHYC_DDR3_MR1_TDQS_Pos  (11U)
#define DDRPHYC_DDR3_MR1_TDQS_Msk  (0x1U << DDRPHYC_DDR3_MR1_TDQS_Pos)  /*!< 0x00000800 */
#define DDRPHYC_DDR3_MR1_TDQS      DDRPHYC_DDR3_MR1_TDQS_Msk            /*!< Termination data strobe */
#define DDRPHYC_DDR3_MR1_QOFF_Pos  (12U)
#define DDRPHYC_DDR3_MR1_QOFF_Msk  (0x1U << DDRPHYC_DDR3_MR1_QOFF_Pos)  /*!< 0x00001000 */
#define DDRPHYC_DDR3_MR1_QOFF      DDRPHYC_DDR3_MR1_QOFF_Msk            /*!< Output enable/disable */
#define DDRPHYC_DDR3_MR1_BL_Pos    (0U)
#define DDRPHYC_DDR3_MR1_BL_Msk    (0x7U << DDRPHYC_DDR3_MR1_BL_Pos)    /*!< 0x00000007 */
#define DDRPHYC_DDR3_MR1_BL        DDRPHYC_DDR3_MR1_BL_Msk              /*!< Burst length */
#define DDRPHYC_DDR3_MR1_BL_0      (0x1U << DDRPHYC_DDR3_MR1_BL_Pos)    /*!< 0x00000001 */
#define DDRPHYC_DDR3_MR1_BL_1      (0x2U << DDRPHYC_DDR3_MR1_BL_Pos)    /*!< 0x00000002 */
#define DDRPHYC_DDR3_MR1_BL_2      (0x4U << DDRPHYC_DDR3_MR1_BL_Pos)    /*!< 0x00000004 */
#define DDRPHYC_DDR3_MR1_BT_Pos    (3U)
#define DDRPHYC_DDR3_MR1_BT_Msk    (0x1U << DDRPHYC_DDR3_MR1_BT_Pos)    /*!< 0x00000008 */
#define DDRPHYC_DDR3_MR1_BT        DDRPHYC_DDR3_MR1_BT_Msk              /*!< Burst Type: Indicates whether a burst is sequential (0) or interleaved (1). , */
#define DDRPHYC_DDR3_MR1_WC_Pos    (4U)
#define DDRPHYC_DDR3_MR1_WC_Msk    (0x1U << DDRPHYC_DDR3_MR1_WC_Pos)    /*!< 0x00000010 */
#define DDRPHYC_DDR3_MR1_WC        DDRPHYC_DDR3_MR1_WC_Msk              /*!< Wrap control */
#define DDRPHYC_DDR3_MR1_NWR_Pos   (5U)
#define DDRPHYC_DDR3_MR1_NWR_Msk   (0x7U << DDRPHYC_DDR3_MR1_NWR_Pos)   /*!< 0x000000E0 */
#define DDRPHYC_DDR3_MR1_NWR       DDRPHYC_DDR3_MR1_NWR_Msk             /*!< Write recovery */
#define DDRPHYC_DDR3_MR1_NWR_0     (0x1U << DDRPHYC_DDR3_MR1_NWR_Pos)   /*!< 0x00000020 */
#define DDRPHYC_DDR3_MR1_NWR_1     (0x2U << DDRPHYC_DDR3_MR1_NWR_Pos)   /*!< 0x00000040 */
#define DDRPHYC_DDR3_MR1_NWR_2     (0x4U << DDRPHYC_DDR3_MR1_NWR_Pos)   /*!< 0x00000080 */
#define DDRPHYC_DDR3_MR1_BL_Pos    (0U)
#define DDRPHYC_DDR3_MR1_BL_Msk    (0x7U << DDRPHYC_DDR3_MR1_BL_Pos)    /*!< 0x00000007 */
#define DDRPHYC_DDR3_MR1_BL        DDRPHYC_DDR3_MR1_BL_Msk              /*!< Burst length */
#define DDRPHYC_DDR3_MR1_BL_0      (0x1U << DDRPHYC_DDR3_MR1_BL_Pos)    /*!< 0x00000001 */
#define DDRPHYC_DDR3_MR1_BL_1      (0x2U << DDRPHYC_DDR3_MR1_BL_Pos)    /*!< 0x00000002 */
#define DDRPHYC_DDR3_MR1_BL_2      (0x4U << DDRPHYC_DDR3_MR1_BL_Pos)    /*!< 0x00000004 */
#define DDRPHYC_DDR3_MR1_NWR_Pos   (5U)
#define DDRPHYC_DDR3_MR1_NWR_Msk   (0x7U << DDRPHYC_DDR3_MR1_NWR_Pos)   /*!< 0x000000E0 */
#define DDRPHYC_DDR3_MR1_NWR       DDRPHYC_DDR3_MR1_NWR_Msk             /*!< Write recovery */
#define DDRPHYC_DDR3_MR1_NWR_0     (0x1U << DDRPHYC_DDR3_MR1_NWR_Pos)   /*!< 0x00000020 */
#define DDRPHYC_DDR3_MR1_NWR_1     (0x2U << DDRPHYC_DDR3_MR1_NWR_Pos)   /*!< 0x00000040 */
#define DDRPHYC_DDR3_MR1_NWR_2     (0x4U << DDRPHYC_DDR3_MR1_NWR_Pos)   /*!< 0x00000080 */

/***************  Bit definition for DDRPHYC_DDR3_MR2 register  ***************/
#define DDRPHYC_DDR3_MR2_PASR_Pos  (0U)
#define DDRPHYC_DDR3_MR2_PASR_Msk  (0x7U << DDRPHYC_DDR3_MR2_PASR_Pos)  /*!< 0x00000007 */
#define DDRPHYC_DDR3_MR2_PASR      DDRPHYC_DDR3_MR2_PASR_Msk            /*!< Partial array self-refresh */
#define DDRPHYC_DDR3_MR2_PASR_0    (0x1U << DDRPHYC_DDR3_MR2_PASR_Pos)  /*!< 0x00000001 */
#define DDRPHYC_DDR3_MR2_PASR_1    (0x2U << DDRPHYC_DDR3_MR2_PASR_Pos)  /*!< 0x00000002 */
#define DDRPHYC_DDR3_MR2_PASR_2    (0x4U << DDRPHYC_DDR3_MR2_PASR_Pos)  /*!< 0x00000004 */
#define DDRPHYC_DDR3_MR2_CWL_Pos   (3U)
#define DDRPHYC_DDR3_MR2_CWL_Msk   (0x7U << DDRPHYC_DDR3_MR2_CWL_Pos)   /*!< 0x00000038 */
#define DDRPHYC_DDR3_MR2_CWL       DDRPHYC_DDR3_MR2_CWL_Msk             /*!< CAS write latency */
#define DDRPHYC_DDR3_MR2_CWL_0     (0x1U << DDRPHYC_DDR3_MR2_CWL_Pos)   /*!< 0x00000008 */
#define DDRPHYC_DDR3_MR2_CWL_1     (0x2U << DDRPHYC_DDR3_MR2_CWL_Pos)   /*!< 0x00000010 */
#define DDRPHYC_DDR3_MR2_CWL_2     (0x4U << DDRPHYC_DDR3_MR2_CWL_Pos)   /*!< 0x00000020 */
#define DDRPHYC_DDR3_MR2_ASR_Pos   (6U)
#define DDRPHYC_DDR3_MR2_ASR_Msk   (0x1U << DDRPHYC_DDR3_MR2_ASR_Pos)   /*!< 0x00000040 */
#define DDRPHYC_DDR3_MR2_ASR       DDRPHYC_DDR3_MR2_ASR_Msk             /*!< Auto self-refresh */
#define DDRPHYC_DDR3_MR2_SRT_Pos   (7U)
#define DDRPHYC_DDR3_MR2_SRT_Msk   (0x1U << DDRPHYC_DDR3_MR2_SRT_Pos)   /*!< 0x00000080 */
#define DDRPHYC_DDR3_MR2_SRT       DDRPHYC_DDR3_MR2_SRT_Msk             /*!< Self-refresh temperature range */
#define DDRPHYC_DDR3_MR2_RTTWR_Pos (9U)
#define DDRPHYC_DDR3_MR2_RTTWR_Msk (0x3U << DDRPHYC_DDR3_MR2_RTTWR_Pos) /*!< 0x00000600 */
#define DDRPHYC_DDR3_MR2_RTTWR     DDRPHYC_DDR3_MR2_RTTWR_Msk           /*!< Dynamic ODT */
#define DDRPHYC_DDR3_MR2_RTTWR_0   (0x1U << DDRPHYC_DDR3_MR2_RTTWR_Pos) /*!< 0x00000200 */
#define DDRPHYC_DDR3_MR2_RTTWR_1   (0x2U << DDRPHYC_DDR3_MR2_RTTWR_Pos) /*!< 0x00000400 */
#define DDRPHYC_DDR3_MR2_RLWL_Pos  (0U)
#define DDRPHYC_DDR3_MR2_RLWL_Msk  (0x7U << DDRPHYC_DDR3_MR2_RLWL_Pos)  /*!< 0x00000007 */
#define DDRPHYC_DDR3_MR2_RLWL      DDRPHYC_DDR3_MR2_RLWL_Msk            /*!< Read and write latency */
#define DDRPHYC_DDR3_MR2_RLWL_0    (0x1U << DDRPHYC_DDR3_MR2_RLWL_Pos)  /*!< 0x00000001 */
#define DDRPHYC_DDR3_MR2_RLWL_1    (0x2U << DDRPHYC_DDR3_MR2_RLWL_Pos)  /*!< 0x00000002 */
#define DDRPHYC_DDR3_MR2_RLWL_2    (0x4U << DDRPHYC_DDR3_MR2_RLWL_Pos)  /*!< 0x00000004 */
#define DDRPHYC_DDR3_MR2_RLWL_Pos  (0U)
#define DDRPHYC_DDR3_MR2_RLWL_Msk  (0x7U << DDRPHYC_DDR3_MR2_RLWL_Pos)  /*!< 0x00000007 */
#define DDRPHYC_DDR3_MR2_RLWL      DDRPHYC_DDR3_MR2_RLWL_Msk            /*!< Read and write latency */
#define DDRPHYC_DDR3_MR2_RLWL_0    (0x1U << DDRPHYC_DDR3_MR2_RLWL_Pos)  /*!< 0x00000001 */
#define DDRPHYC_DDR3_MR2_RLWL_1    (0x2U << DDRPHYC_DDR3_MR2_RLWL_Pos)  /*!< 0x00000002 */
#define DDRPHYC_DDR3_MR2_RLWL_2    (0x4U << DDRPHYC_DDR3_MR2_RLWL_Pos)  /*!< 0x00000004 */
#define DDRPHYC_DDR3_MR2_NWRE_Pos  (4U)
#define DDRPHYC_DDR3_MR2_NWRE_Msk  (0x1U << DDRPHYC_DDR3_MR2_NWRE_Pos)  /*!< 0x00000010 */
#define DDRPHYC_DDR3_MR2_NWRE      DDRPHYC_DDR3_MR2_NWRE_Msk            /*!< New for LPDDR3 (not used by this PHY, leave at zero) */
#define DDRPHYC_DDR3_MR2_WL_Pos    (6U)
#define DDRPHYC_DDR3_MR2_WL_Msk    (0x1U << DDRPHYC_DDR3_MR2_WL_Pos)    /*!< 0x00000040 */
#define DDRPHYC_DDR3_MR2_WL        DDRPHYC_DDR3_MR2_WL_Msk              /*!< New for LPDDR3 (not used by this PHY, leave at zero) */
#define DDRPHYC_DDR3_MR2_WR_Pos    (7U)
#define DDRPHYC_DDR3_MR2_WR_Msk    (0x1U << DDRPHYC_DDR3_MR2_WR_Pos)    /*!< 0x00000080 */
#define DDRPHYC_DDR3_MR2_WR        DDRPHYC_DDR3_MR2_WR_Msk              /*!< New for LPDDR3 (not used by this PHY, leave at zero) */

/***************  Bit definition for DDRPHYC_DDR3_MR3 register  ***************/
#define DDRPHYC_DDR3_MR3_MPRLOC_Pos (0U)
#define DDRPHYC_DDR3_MR3_MPRLOC_Msk (0x3U << DDRPHYC_DDR3_MR3_MPRLOC_Pos) /*!< 0x00000003 */
#define DDRPHYC_DDR3_MR3_MPRLOC     DDRPHYC_DDR3_MR3_MPRLOC_Msk           /*!< Multi-purpose register (MPR) location */
#define DDRPHYC_DDR3_MR3_MPRLOC_0   (0x1U << DDRPHYC_DDR3_MR3_MPRLOC_Pos) /*!< 0x00000001 */
#define DDRPHYC_DDR3_MR3_MPRLOC_1   (0x2U << DDRPHYC_DDR3_MR3_MPRLOC_Pos) /*!< 0x00000002 */
#define DDRPHYC_DDR3_MR3_MPR_Pos    (2U)
#define DDRPHYC_DDR3_MR3_MPR_Msk    (0x1U << DDRPHYC_DDR3_MR3_MPR_Pos)    /*!< 0x00000004 */
#define DDRPHYC_DDR3_MR3_MPR        DDRPHYC_DDR3_MR3_MPR_Msk              /*!< Multi-purpose register enable */

/****************  Bit definition for DDRPHYC_ODTCR register  *****************/
#define DDRPHYC_ODTCR_RDODT_Pos (0U)
#define DDRPHYC_ODTCR_RDODT_Msk (0x1U << DDRPHYC_ODTCR_RDODT_Pos) /*!< 0x00000001 */
#define DDRPHYC_ODTCR_RDODT     DDRPHYC_ODTCR_RDODT_Msk           /*!< Specifies whether ODT should be enabled ('1') or disabled ('0') on read */
#define DDRPHYC_ODTCR_WRODT_Pos (16U)
#define DDRPHYC_ODTCR_WRODT_Msk (0x1U << DDRPHYC_ODTCR_WRODT_Pos) /*!< 0x00010000 */
#define DDRPHYC_ODTCR_WRODT     DDRPHYC_ODTCR_WRODT_Msk           /*!< Specifies whether ODT should be enabled ('1') or disabled ('0') on write */

/*****************  Bit definition for DDRPHYC_DTAR register  *****************/
#define DDRPHYC_DTAR_DTCOL_Pos  (0U)
#define DDRPHYC_DTAR_DTCOL_Msk  (0xFFFU << DDRPHYC_DTAR_DTCOL_Pos)  /*!< 0x00000FFF */
#define DDRPHYC_DTAR_DTCOL      DDRPHYC_DTAR_DTCOL_Msk              /*!< Data training column address: */
#define DDRPHYC_DTAR_DTCOL_0    (0x1U << DDRPHYC_DTAR_DTCOL_Pos)    /*!< 0x00000001 */
#define DDRPHYC_DTAR_DTCOL_1    (0x2U << DDRPHYC_DTAR_DTCOL_Pos)    /*!< 0x00000002 */
#define DDRPHYC_DTAR_DTCOL_2    (0x4U << DDRPHYC_DTAR_DTCOL_Pos)    /*!< 0x00000004 */
#define DDRPHYC_DTAR_DTCOL_3    (0x8U << DDRPHYC_DTAR_DTCOL_Pos)    /*!< 0x00000008 */
#define DDRPHYC_DTAR_DTCOL_4    (0x10U << DDRPHYC_DTAR_DTCOL_Pos)   /*!< 0x00000010 */
#define DDRPHYC_DTAR_DTCOL_5    (0x20U << DDRPHYC_DTAR_DTCOL_Pos)   /*!< 0x00000020 */
#define DDRPHYC_DTAR_DTCOL_6    (0x40U << DDRPHYC_DTAR_DTCOL_Pos)   /*!< 0x00000040 */
#define DDRPHYC_DTAR_DTCOL_7    (0x80U << DDRPHYC_DTAR_DTCOL_Pos)   /*!< 0x00000080 */
#define DDRPHYC_DTAR_DTCOL_8    (0x100U << DDRPHYC_DTAR_DTCOL_Pos)  /*!< 0x00000100 */
#define DDRPHYC_DTAR_DTCOL_9    (0x200U << DDRPHYC_DTAR_DTCOL_Pos)  /*!< 0x00000200 */
#define DDRPHYC_DTAR_DTCOL_10   (0x400U << DDRPHYC_DTAR_DTCOL_Pos)  /*!< 0x00000400 */
#define DDRPHYC_DTAR_DTCOL_11   (0x800U << DDRPHYC_DTAR_DTCOL_Pos)  /*!< 0x00000800 */
#define DDRPHYC_DTAR_DTROW_Pos  (12U)
#define DDRPHYC_DTAR_DTROW_Msk  (0xFFFFU << DDRPHYC_DTAR_DTROW_Pos) /*!< 0x0FFFF000 */
#define DDRPHYC_DTAR_DTROW      DDRPHYC_DTAR_DTROW_Msk              /*!< Data training row address: */
#define DDRPHYC_DTAR_DTROW_0    (0x1U << DDRPHYC_DTAR_DTROW_Pos)    /*!< 0x00001000 */
#define DDRPHYC_DTAR_DTROW_1    (0x2U << DDRPHYC_DTAR_DTROW_Pos)    /*!< 0x00002000 */
#define DDRPHYC_DTAR_DTROW_2    (0x4U << DDRPHYC_DTAR_DTROW_Pos)    /*!< 0x00004000 */
#define DDRPHYC_DTAR_DTROW_3    (0x8U << DDRPHYC_DTAR_DTROW_Pos)    /*!< 0x00008000 */
#define DDRPHYC_DTAR_DTROW_4    (0x10U << DDRPHYC_DTAR_DTROW_Pos)   /*!< 0x00010000 */
#define DDRPHYC_DTAR_DTROW_5    (0x20U << DDRPHYC_DTAR_DTROW_Pos)   /*!< 0x00020000 */
#define DDRPHYC_DTAR_DTROW_6    (0x40U << DDRPHYC_DTAR_DTROW_Pos)   /*!< 0x00040000 */
#define DDRPHYC_DTAR_DTROW_7    (0x80U << DDRPHYC_DTAR_DTROW_Pos)   /*!< 0x00080000 */
#define DDRPHYC_DTAR_DTROW_8    (0x100U << DDRPHYC_DTAR_DTROW_Pos)  /*!< 0x00100000 */
#define DDRPHYC_DTAR_DTROW_9    (0x200U << DDRPHYC_DTAR_DTROW_Pos)  /*!< 0x00200000 */
#define DDRPHYC_DTAR_DTROW_10   (0x400U << DDRPHYC_DTAR_DTROW_Pos)  /*!< 0x00400000 */
#define DDRPHYC_DTAR_DTROW_11   (0x800U << DDRPHYC_DTAR_DTROW_Pos)  /*!< 0x00800000 */
#define DDRPHYC_DTAR_DTROW_12   (0x1000U << DDRPHYC_DTAR_DTROW_Pos) /*!< 0x01000000 */
#define DDRPHYC_DTAR_DTROW_13   (0x2000U << DDRPHYC_DTAR_DTROW_Pos) /*!< 0x02000000 */
#define DDRPHYC_DTAR_DTROW_14   (0x4000U << DDRPHYC_DTAR_DTROW_Pos) /*!< 0x04000000 */
#define DDRPHYC_DTAR_DTROW_15   (0x8000U << DDRPHYC_DTAR_DTROW_Pos) /*!< 0x08000000 */
#define DDRPHYC_DTAR_DTBANK_Pos (28U)
#define DDRPHYC_DTAR_DTBANK_Msk (0x7U << DDRPHYC_DTAR_DTBANK_Pos)   /*!< 0x70000000 */
#define DDRPHYC_DTAR_DTBANK     DDRPHYC_DTAR_DTBANK_Msk             /*!< Data training bank address: */
#define DDRPHYC_DTAR_DTBANK_0   (0x1U << DDRPHYC_DTAR_DTBANK_Pos)   /*!< 0x10000000 */
#define DDRPHYC_DTAR_DTBANK_1   (0x2U << DDRPHYC_DTAR_DTBANK_Pos)   /*!< 0x20000000 */
#define DDRPHYC_DTAR_DTBANK_2   (0x4U << DDRPHYC_DTAR_DTBANK_Pos)   /*!< 0x40000000 */
#define DDRPHYC_DTAR_DTMPR_Pos  (31U)
#define DDRPHYC_DTAR_DTMPR_Msk  (0x1U << DDRPHYC_DTAR_DTMPR_Pos)    /*!< 0x80000000 */
#define DDRPHYC_DTAR_DTMPR      DDRPHYC_DTAR_DTMPR_Msk              /*!< Data training using MPR (DDR3 Only): */

/****************  Bit definition for DDRPHYC_DTDR0 register  *****************/
#define DDRPHYC_DTDR0_DTBYTE0_Pos (0U)
#define DDRPHYC_DTDR0_DTBYTE0_Msk (0xFFU << DDRPHYC_DTDR0_DTBYTE0_Pos) /*!< 0x000000FF */
#define DDRPHYC_DTDR0_DTBYTE0     DDRPHYC_DTDR0_DTBYTE0_Msk            /*!< Data Training Data */
#define DDRPHYC_DTDR0_DTBYTE0_0   (0x1U << DDRPHYC_DTDR0_DTBYTE0_Pos)  /*!< 0x00000001 */
#define DDRPHYC_DTDR0_DTBYTE0_1   (0x2U << DDRPHYC_DTDR0_DTBYTE0_Pos)  /*!< 0x00000002 */
#define DDRPHYC_DTDR0_DTBYTE0_2   (0x4U << DDRPHYC_DTDR0_DTBYTE0_Pos)  /*!< 0x00000004 */
#define DDRPHYC_DTDR0_DTBYTE0_3   (0x8U << DDRPHYC_DTDR0_DTBYTE0_Pos)  /*!< 0x00000008 */
#define DDRPHYC_DTDR0_DTBYTE0_4   (0x10U << DDRPHYC_DTDR0_DTBYTE0_Pos) /*!< 0x00000010 */
#define DDRPHYC_DTDR0_DTBYTE0_5   (0x20U << DDRPHYC_DTDR0_DTBYTE0_Pos) /*!< 0x00000020 */
#define DDRPHYC_DTDR0_DTBYTE0_6   (0x40U << DDRPHYC_DTDR0_DTBYTE0_Pos) /*!< 0x00000040 */
#define DDRPHYC_DTDR0_DTBYTE0_7   (0x80U << DDRPHYC_DTDR0_DTBYTE0_Pos) /*!< 0x00000080 */
#define DDRPHYC_DTDR0_DTBYTE1_Pos (8U)
#define DDRPHYC_DTDR0_DTBYTE1_Msk (0xFFU << DDRPHYC_DTDR0_DTBYTE1_Pos) /*!< 0x0000FF00 */
#define DDRPHYC_DTDR0_DTBYTE1     DDRPHYC_DTDR0_DTBYTE1_Msk            /*!< Data Training Data */
#define DDRPHYC_DTDR0_DTBYTE1_0   (0x1U << DDRPHYC_DTDR0_DTBYTE1_Pos)  /*!< 0x00000100 */
#define DDRPHYC_DTDR0_DTBYTE1_1   (0x2U << DDRPHYC_DTDR0_DTBYTE1_Pos)  /*!< 0x00000200 */
#define DDRPHYC_DTDR0_DTBYTE1_2   (0x4U << DDRPHYC_DTDR0_DTBYTE1_Pos)  /*!< 0x00000400 */
#define DDRPHYC_DTDR0_DTBYTE1_3   (0x8U << DDRPHYC_DTDR0_DTBYTE1_Pos)  /*!< 0x00000800 */
#define DDRPHYC_DTDR0_DTBYTE1_4   (0x10U << DDRPHYC_DTDR0_DTBYTE1_Pos) /*!< 0x00001000 */
#define DDRPHYC_DTDR0_DTBYTE1_5   (0x20U << DDRPHYC_DTDR0_DTBYTE1_Pos) /*!< 0x00002000 */
#define DDRPHYC_DTDR0_DTBYTE1_6   (0x40U << DDRPHYC_DTDR0_DTBYTE1_Pos) /*!< 0x00004000 */
#define DDRPHYC_DTDR0_DTBYTE1_7   (0x80U << DDRPHYC_DTDR0_DTBYTE1_Pos) /*!< 0x00008000 */
#define DDRPHYC_DTDR0_DTBYTE2_Pos (16U)
#define DDRPHYC_DTDR0_DTBYTE2_Msk (0xFFU << DDRPHYC_DTDR0_DTBYTE2_Pos) /*!< 0x00FF0000 */
#define DDRPHYC_DTDR0_DTBYTE2     DDRPHYC_DTDR0_DTBYTE2_Msk            /*!< Data Training Data */
#define DDRPHYC_DTDR0_DTBYTE2_0   (0x1U << DDRPHYC_DTDR0_DTBYTE2_Pos)  /*!< 0x00010000 */
#define DDRPHYC_DTDR0_DTBYTE2_1   (0x2U << DDRPHYC_DTDR0_DTBYTE2_Pos)  /*!< 0x00020000 */
#define DDRPHYC_DTDR0_DTBYTE2_2   (0x4U << DDRPHYC_DTDR0_DTBYTE2_Pos)  /*!< 0x00040000 */
#define DDRPHYC_DTDR0_DTBYTE2_3   (0x8U << DDRPHYC_DTDR0_DTBYTE2_Pos)  /*!< 0x00080000 */
#define DDRPHYC_DTDR0_DTBYTE2_4   (0x10U << DDRPHYC_DTDR0_DTBYTE2_Pos) /*!< 0x00100000 */
#define DDRPHYC_DTDR0_DTBYTE2_5   (0x20U << DDRPHYC_DTDR0_DTBYTE2_Pos) /*!< 0x00200000 */
#define DDRPHYC_DTDR0_DTBYTE2_6   (0x40U << DDRPHYC_DTDR0_DTBYTE2_Pos) /*!< 0x00400000 */
#define DDRPHYC_DTDR0_DTBYTE2_7   (0x80U << DDRPHYC_DTDR0_DTBYTE2_Pos) /*!< 0x00800000 */
#define DDRPHYC_DTDR0_DTBYTE3_Pos (24U)
#define DDRPHYC_DTDR0_DTBYTE3_Msk (0xFFU << DDRPHYC_DTDR0_DTBYTE3_Pos) /*!< 0xFF000000 */
#define DDRPHYC_DTDR0_DTBYTE3     DDRPHYC_DTDR0_DTBYTE3_Msk            /*!< Data training data */
#define DDRPHYC_DTDR0_DTBYTE3_0   (0x1U << DDRPHYC_DTDR0_DTBYTE3_Pos)  /*!< 0x01000000 */
#define DDRPHYC_DTDR0_DTBYTE3_1   (0x2U << DDRPHYC_DTDR0_DTBYTE3_Pos)  /*!< 0x02000000 */
#define DDRPHYC_DTDR0_DTBYTE3_2   (0x4U << DDRPHYC_DTDR0_DTBYTE3_Pos)  /*!< 0x04000000 */
#define DDRPHYC_DTDR0_DTBYTE3_3   (0x8U << DDRPHYC_DTDR0_DTBYTE3_Pos)  /*!< 0x08000000 */
#define DDRPHYC_DTDR0_DTBYTE3_4   (0x10U << DDRPHYC_DTDR0_DTBYTE3_Pos) /*!< 0x10000000 */
#define DDRPHYC_DTDR0_DTBYTE3_5   (0x20U << DDRPHYC_DTDR0_DTBYTE3_Pos) /*!< 0x20000000 */
#define DDRPHYC_DTDR0_DTBYTE3_6   (0x40U << DDRPHYC_DTDR0_DTBYTE3_Pos) /*!< 0x40000000 */
#define DDRPHYC_DTDR0_DTBYTE3_7   (0x80U << DDRPHYC_DTDR0_DTBYTE3_Pos) /*!< 0x80000000 */

/****************  Bit definition for DDRPHYC_DTDR1 register  *****************/
#define DDRPHYC_DTDR1_DTBYTE4_Pos (0U)
#define DDRPHYC_DTDR1_DTBYTE4_Msk (0xFFU << DDRPHYC_DTDR1_DTBYTE4_Pos) /*!< 0x000000FF */
#define DDRPHYC_DTDR1_DTBYTE4     DDRPHYC_DTDR1_DTBYTE4_Msk            /*!< Data Training Data */
#define DDRPHYC_DTDR1_DTBYTE4_0   (0x1U << DDRPHYC_DTDR1_DTBYTE4_Pos)  /*!< 0x00000001 */
#define DDRPHYC_DTDR1_DTBYTE4_1   (0x2U << DDRPHYC_DTDR1_DTBYTE4_Pos)  /*!< 0x00000002 */
#define DDRPHYC_DTDR1_DTBYTE4_2   (0x4U << DDRPHYC_DTDR1_DTBYTE4_Pos)  /*!< 0x00000004 */
#define DDRPHYC_DTDR1_DTBYTE4_3   (0x8U << DDRPHYC_DTDR1_DTBYTE4_Pos)  /*!< 0x00000008 */
#define DDRPHYC_DTDR1_DTBYTE4_4   (0x10U << DDRPHYC_DTDR1_DTBYTE4_Pos) /*!< 0x00000010 */
#define DDRPHYC_DTDR1_DTBYTE4_5   (0x20U << DDRPHYC_DTDR1_DTBYTE4_Pos) /*!< 0x00000020 */
#define DDRPHYC_DTDR1_DTBYTE4_6   (0x40U << DDRPHYC_DTDR1_DTBYTE4_Pos) /*!< 0x00000040 */
#define DDRPHYC_DTDR1_DTBYTE4_7   (0x80U << DDRPHYC_DTDR1_DTBYTE4_Pos) /*!< 0x00000080 */
#define DDRPHYC_DTDR1_DTBYTE5_Pos (8U)
#define DDRPHYC_DTDR1_DTBYTE5_Msk (0xFFU << DDRPHYC_DTDR1_DTBYTE5_Pos) /*!< 0x0000FF00 */
#define DDRPHYC_DTDR1_DTBYTE5     DDRPHYC_DTDR1_DTBYTE5_Msk            /*!< Data Training Data */
#define DDRPHYC_DTDR1_DTBYTE5_0   (0x1U << DDRPHYC_DTDR1_DTBYTE5_Pos)  /*!< 0x00000100 */
#define DDRPHYC_DTDR1_DTBYTE5_1   (0x2U << DDRPHYC_DTDR1_DTBYTE5_Pos)  /*!< 0x00000200 */
#define DDRPHYC_DTDR1_DTBYTE5_2   (0x4U << DDRPHYC_DTDR1_DTBYTE5_Pos)  /*!< 0x00000400 */
#define DDRPHYC_DTDR1_DTBYTE5_3   (0x8U << DDRPHYC_DTDR1_DTBYTE5_Pos)  /*!< 0x00000800 */
#define DDRPHYC_DTDR1_DTBYTE5_4   (0x10U << DDRPHYC_DTDR1_DTBYTE5_Pos) /*!< 0x00001000 */
#define DDRPHYC_DTDR1_DTBYTE5_5   (0x20U << DDRPHYC_DTDR1_DTBYTE5_Pos) /*!< 0x00002000 */
#define DDRPHYC_DTDR1_DTBYTE5_6   (0x40U << DDRPHYC_DTDR1_DTBYTE5_Pos) /*!< 0x00004000 */
#define DDRPHYC_DTDR1_DTBYTE5_7   (0x80U << DDRPHYC_DTDR1_DTBYTE5_Pos) /*!< 0x00008000 */
#define DDRPHYC_DTDR1_DTBYTE6_Pos (16U)
#define DDRPHYC_DTDR1_DTBYTE6_Msk (0xFFU << DDRPHYC_DTDR1_DTBYTE6_Pos) /*!< 0x00FF0000 */
#define DDRPHYC_DTDR1_DTBYTE6     DDRPHYC_DTDR1_DTBYTE6_Msk            /*!< Data Training Data */
#define DDRPHYC_DTDR1_DTBYTE6_0   (0x1U << DDRPHYC_DTDR1_DTBYTE6_Pos)  /*!< 0x00010000 */
#define DDRPHYC_DTDR1_DTBYTE6_1   (0x2U << DDRPHYC_DTDR1_DTBYTE6_Pos)  /*!< 0x00020000 */
#define DDRPHYC_DTDR1_DTBYTE6_2   (0x4U << DDRPHYC_DTDR1_DTBYTE6_Pos)  /*!< 0x00040000 */
#define DDRPHYC_DTDR1_DTBYTE6_3   (0x8U << DDRPHYC_DTDR1_DTBYTE6_Pos)  /*!< 0x00080000 */
#define DDRPHYC_DTDR1_DTBYTE6_4   (0x10U << DDRPHYC_DTDR1_DTBYTE6_Pos) /*!< 0x00100000 */
#define DDRPHYC_DTDR1_DTBYTE6_5   (0x20U << DDRPHYC_DTDR1_DTBYTE6_Pos) /*!< 0x00200000 */
#define DDRPHYC_DTDR1_DTBYTE6_6   (0x40U << DDRPHYC_DTDR1_DTBYTE6_Pos) /*!< 0x00400000 */
#define DDRPHYC_DTDR1_DTBYTE6_7   (0x80U << DDRPHYC_DTDR1_DTBYTE6_Pos) /*!< 0x00800000 */
#define DDRPHYC_DTDR1_DTBYTE7_Pos (24U)
#define DDRPHYC_DTDR1_DTBYTE7_Msk (0xFFU << DDRPHYC_DTDR1_DTBYTE7_Pos) /*!< 0xFF000000 */
#define DDRPHYC_DTDR1_DTBYTE7     DDRPHYC_DTDR1_DTBYTE7_Msk            /*!< Data training data: */
#define DDRPHYC_DTDR1_DTBYTE7_0   (0x1U << DDRPHYC_DTDR1_DTBYTE7_Pos)  /*!< 0x01000000 */
#define DDRPHYC_DTDR1_DTBYTE7_1   (0x2U << DDRPHYC_DTDR1_DTBYTE7_Pos)  /*!< 0x02000000 */
#define DDRPHYC_DTDR1_DTBYTE7_2   (0x4U << DDRPHYC_DTDR1_DTBYTE7_Pos)  /*!< 0x04000000 */
#define DDRPHYC_DTDR1_DTBYTE7_3   (0x8U << DDRPHYC_DTDR1_DTBYTE7_Pos)  /*!< 0x08000000 */
#define DDRPHYC_DTDR1_DTBYTE7_4   (0x10U << DDRPHYC_DTDR1_DTBYTE7_Pos) /*!< 0x10000000 */
#define DDRPHYC_DTDR1_DTBYTE7_5   (0x20U << DDRPHYC_DTDR1_DTBYTE7_Pos) /*!< 0x20000000 */
#define DDRPHYC_DTDR1_DTBYTE7_6   (0x40U << DDRPHYC_DTDR1_DTBYTE7_Pos) /*!< 0x40000000 */
#define DDRPHYC_DTDR1_DTBYTE7_7   (0x80U << DDRPHYC_DTDR1_DTBYTE7_Pos) /*!< 0x80000000 */

/*****************  Bit definition for DDRPHYC_GPR0 register  *****************/
#define DDRPHYC_GPR0_GPR0_Pos (0U)
#define DDRPHYC_GPR0_GPR0_Msk (0xFFFFFFFFU << DDRPHYC_GPR0_GPR0_Pos) /*!< 0xFFFFFFFF */
#define DDRPHYC_GPR0_GPR0     DDRPHYC_GPR0_GPR0_Msk                  /*!< General purpose register 0 bits */
#define DDRPHYC_GPR0_GPR0_0   (0x1U << DDRPHYC_GPR0_GPR0_Pos)        /*!< 0x00000001 */
#define DDRPHYC_GPR0_GPR0_1   (0x2U << DDRPHYC_GPR0_GPR0_Pos)        /*!< 0x00000002 */
#define DDRPHYC_GPR0_GPR0_2   (0x4U << DDRPHYC_GPR0_GPR0_Pos)        /*!< 0x00000004 */
#define DDRPHYC_GPR0_GPR0_3   (0x8U << DDRPHYC_GPR0_GPR0_Pos)        /*!< 0x00000008 */
#define DDRPHYC_GPR0_GPR0_4   (0x10U << DDRPHYC_GPR0_GPR0_Pos)       /*!< 0x00000010 */
#define DDRPHYC_GPR0_GPR0_5   (0x20U << DDRPHYC_GPR0_GPR0_Pos)       /*!< 0x00000020 */
#define DDRPHYC_GPR0_GPR0_6   (0x40U << DDRPHYC_GPR0_GPR0_Pos)       /*!< 0x00000040 */
#define DDRPHYC_GPR0_GPR0_7   (0x80U << DDRPHYC_GPR0_GPR0_Pos)       /*!< 0x00000080 */
#define DDRPHYC_GPR0_GPR0_8   (0x100U << DDRPHYC_GPR0_GPR0_Pos)      /*!< 0x00000100 */
#define DDRPHYC_GPR0_GPR0_9   (0x200U << DDRPHYC_GPR0_GPR0_Pos)      /*!< 0x00000200 */
#define DDRPHYC_GPR0_GPR0_10  (0x400U << DDRPHYC_GPR0_GPR0_Pos)      /*!< 0x00000400 */
#define DDRPHYC_GPR0_GPR0_11  (0x800U << DDRPHYC_GPR0_GPR0_Pos)      /*!< 0x00000800 */
#define DDRPHYC_GPR0_GPR0_12  (0x1000U << DDRPHYC_GPR0_GPR0_Pos)     /*!< 0x00001000 */
#define DDRPHYC_GPR0_GPR0_13  (0x2000U << DDRPHYC_GPR0_GPR0_Pos)     /*!< 0x00002000 */
#define DDRPHYC_GPR0_GPR0_14  (0x4000U << DDRPHYC_GPR0_GPR0_Pos)     /*!< 0x00004000 */
#define DDRPHYC_GPR0_GPR0_15  (0x8000U << DDRPHYC_GPR0_GPR0_Pos)     /*!< 0x00008000 */
#define DDRPHYC_GPR0_GPR0_16  (0x10000U << DDRPHYC_GPR0_GPR0_Pos)    /*!< 0x00010000 */
#define DDRPHYC_GPR0_GPR0_17  (0x20000U << DDRPHYC_GPR0_GPR0_Pos)    /*!< 0x00020000 */
#define DDRPHYC_GPR0_GPR0_18  (0x40000U << DDRPHYC_GPR0_GPR0_Pos)    /*!< 0x00040000 */
#define DDRPHYC_GPR0_GPR0_19  (0x80000U << DDRPHYC_GPR0_GPR0_Pos)    /*!< 0x00080000 */
#define DDRPHYC_GPR0_GPR0_20  (0x100000U << DDRPHYC_GPR0_GPR0_Pos)   /*!< 0x00100000 */
#define DDRPHYC_GPR0_GPR0_21  (0x200000U << DDRPHYC_GPR0_GPR0_Pos)   /*!< 0x00200000 */
#define DDRPHYC_GPR0_GPR0_22  (0x400000U << DDRPHYC_GPR0_GPR0_Pos)   /*!< 0x00400000 */
#define DDRPHYC_GPR0_GPR0_23  (0x800000U << DDRPHYC_GPR0_GPR0_Pos)   /*!< 0x00800000 */
#define DDRPHYC_GPR0_GPR0_24  (0x1000000U << DDRPHYC_GPR0_GPR0_Pos)  /*!< 0x01000000 */
#define DDRPHYC_GPR0_GPR0_25  (0x2000000U << DDRPHYC_GPR0_GPR0_Pos)  /*!< 0x02000000 */
#define DDRPHYC_GPR0_GPR0_26  (0x4000000U << DDRPHYC_GPR0_GPR0_Pos)  /*!< 0x04000000 */
#define DDRPHYC_GPR0_GPR0_27  (0x8000000U << DDRPHYC_GPR0_GPR0_Pos)  /*!< 0x08000000 */
#define DDRPHYC_GPR0_GPR0_28  (0x10000000U << DDRPHYC_GPR0_GPR0_Pos) /*!< 0x10000000 */
#define DDRPHYC_GPR0_GPR0_29  (0x20000000U << DDRPHYC_GPR0_GPR0_Pos) /*!< 0x20000000 */
#define DDRPHYC_GPR0_GPR0_30  (0x40000000U << DDRPHYC_GPR0_GPR0_Pos) /*!< 0x40000000 */
#define DDRPHYC_GPR0_GPR0_31  (0x80000000U << DDRPHYC_GPR0_GPR0_Pos) /*!< 0x80000000 */

/*****************  Bit definition for DDRPHYC_GPR1 register  *****************/
#define DDRPHYC_GPR1_GPR1_Pos (0U)
#define DDRPHYC_GPR1_GPR1_Msk (0xFFFFFFFFU << DDRPHYC_GPR1_GPR1_Pos) /*!< 0xFFFFFFFF */
#define DDRPHYC_GPR1_GPR1     DDRPHYC_GPR1_GPR1_Msk                  /*!< General purpose register 1 bits */
#define DDRPHYC_GPR1_GPR1_0   (0x1U << DDRPHYC_GPR1_GPR1_Pos)        /*!< 0x00000001 */
#define DDRPHYC_GPR1_GPR1_1   (0x2U << DDRPHYC_GPR1_GPR1_Pos)        /*!< 0x00000002 */
#define DDRPHYC_GPR1_GPR1_2   (0x4U << DDRPHYC_GPR1_GPR1_Pos)        /*!< 0x00000004 */
#define DDRPHYC_GPR1_GPR1_3   (0x8U << DDRPHYC_GPR1_GPR1_Pos)        /*!< 0x00000008 */
#define DDRPHYC_GPR1_GPR1_4   (0x10U << DDRPHYC_GPR1_GPR1_Pos)       /*!< 0x00000010 */
#define DDRPHYC_GPR1_GPR1_5   (0x20U << DDRPHYC_GPR1_GPR1_Pos)       /*!< 0x00000020 */
#define DDRPHYC_GPR1_GPR1_6   (0x40U << DDRPHYC_GPR1_GPR1_Pos)       /*!< 0x00000040 */
#define DDRPHYC_GPR1_GPR1_7   (0x80U << DDRPHYC_GPR1_GPR1_Pos)       /*!< 0x00000080 */
#define DDRPHYC_GPR1_GPR1_8   (0x100U << DDRPHYC_GPR1_GPR1_Pos)      /*!< 0x00000100 */
#define DDRPHYC_GPR1_GPR1_9   (0x200U << DDRPHYC_GPR1_GPR1_Pos)      /*!< 0x00000200 */
#define DDRPHYC_GPR1_GPR1_10  (0x400U << DDRPHYC_GPR1_GPR1_Pos)      /*!< 0x00000400 */
#define DDRPHYC_GPR1_GPR1_11  (0x800U << DDRPHYC_GPR1_GPR1_Pos)      /*!< 0x00000800 */
#define DDRPHYC_GPR1_GPR1_12  (0x1000U << DDRPHYC_GPR1_GPR1_Pos)     /*!< 0x00001000 */
#define DDRPHYC_GPR1_GPR1_13  (0x2000U << DDRPHYC_GPR1_GPR1_Pos)     /*!< 0x00002000 */
#define DDRPHYC_GPR1_GPR1_14  (0x4000U << DDRPHYC_GPR1_GPR1_Pos)     /*!< 0x00004000 */
#define DDRPHYC_GPR1_GPR1_15  (0x8000U << DDRPHYC_GPR1_GPR1_Pos)     /*!< 0x00008000 */
#define DDRPHYC_GPR1_GPR1_16  (0x10000U << DDRPHYC_GPR1_GPR1_Pos)    /*!< 0x00010000 */
#define DDRPHYC_GPR1_GPR1_17  (0x20000U << DDRPHYC_GPR1_GPR1_Pos)    /*!< 0x00020000 */
#define DDRPHYC_GPR1_GPR1_18  (0x40000U << DDRPHYC_GPR1_GPR1_Pos)    /*!< 0x00040000 */
#define DDRPHYC_GPR1_GPR1_19  (0x80000U << DDRPHYC_GPR1_GPR1_Pos)    /*!< 0x00080000 */
#define DDRPHYC_GPR1_GPR1_20  (0x100000U << DDRPHYC_GPR1_GPR1_Pos)   /*!< 0x00100000 */
#define DDRPHYC_GPR1_GPR1_21  (0x200000U << DDRPHYC_GPR1_GPR1_Pos)   /*!< 0x00200000 */
#define DDRPHYC_GPR1_GPR1_22  (0x400000U << DDRPHYC_GPR1_GPR1_Pos)   /*!< 0x00400000 */
#define DDRPHYC_GPR1_GPR1_23  (0x800000U << DDRPHYC_GPR1_GPR1_Pos)   /*!< 0x00800000 */
#define DDRPHYC_GPR1_GPR1_24  (0x1000000U << DDRPHYC_GPR1_GPR1_Pos)  /*!< 0x01000000 */
#define DDRPHYC_GPR1_GPR1_25  (0x2000000U << DDRPHYC_GPR1_GPR1_Pos)  /*!< 0x02000000 */
#define DDRPHYC_GPR1_GPR1_26  (0x4000000U << DDRPHYC_GPR1_GPR1_Pos)  /*!< 0x04000000 */
#define DDRPHYC_GPR1_GPR1_27  (0x8000000U << DDRPHYC_GPR1_GPR1_Pos)  /*!< 0x08000000 */
#define DDRPHYC_GPR1_GPR1_28  (0x10000000U << DDRPHYC_GPR1_GPR1_Pos) /*!< 0x10000000 */
#define DDRPHYC_GPR1_GPR1_29  (0x20000000U << DDRPHYC_GPR1_GPR1_Pos) /*!< 0x20000000 */
#define DDRPHYC_GPR1_GPR1_30  (0x40000000U << DDRPHYC_GPR1_GPR1_Pos) /*!< 0x40000000 */
#define DDRPHYC_GPR1_GPR1_31  (0x80000000U << DDRPHYC_GPR1_GPR1_Pos) /*!< 0x80000000 */

/****************  Bit definition for DDRPHYC_ZQ0CR0 register  ****************/
#define DDRPHYC_ZQ0CR0_ZDATA_Pos   (0U)
#define DDRPHYC_ZQ0CR0_ZDATA_Msk   (0xFFFFFU << DDRPHYC_ZQ0CR0_ZDATA_Pos) /*!< 0x000FFFFF */
#define DDRPHYC_ZQ0CR0_ZDATA       DDRPHYC_ZQ0CR0_ZDATA_Msk               /*!< Impedance override */
#define DDRPHYC_ZQ0CR0_ZDATA_0     (0x1U << DDRPHYC_ZQ0CR0_ZDATA_Pos)     /*!< 0x00000001 */
#define DDRPHYC_ZQ0CR0_ZDATA_1     (0x2U << DDRPHYC_ZQ0CR0_ZDATA_Pos)     /*!< 0x00000002 */
#define DDRPHYC_ZQ0CR0_ZDATA_2     (0x4U << DDRPHYC_ZQ0CR0_ZDATA_Pos)     /*!< 0x00000004 */
#define DDRPHYC_ZQ0CR0_ZDATA_3     (0x8U << DDRPHYC_ZQ0CR0_ZDATA_Pos)     /*!< 0x00000008 */
#define DDRPHYC_ZQ0CR0_ZDATA_4     (0x10U << DDRPHYC_ZQ0CR0_ZDATA_Pos)    /*!< 0x00000010 */
#define DDRPHYC_ZQ0CR0_ZDATA_5     (0x20U << DDRPHYC_ZQ0CR0_ZDATA_Pos)    /*!< 0x00000020 */
#define DDRPHYC_ZQ0CR0_ZDATA_6     (0x40U << DDRPHYC_ZQ0CR0_ZDATA_Pos)    /*!< 0x00000040 */
#define DDRPHYC_ZQ0CR0_ZDATA_7     (0x80U << DDRPHYC_ZQ0CR0_ZDATA_Pos)    /*!< 0x00000080 */
#define DDRPHYC_ZQ0CR0_ZDATA_8     (0x100U << DDRPHYC_ZQ0CR0_ZDATA_Pos)   /*!< 0x00000100 */
#define DDRPHYC_ZQ0CR0_ZDATA_9     (0x200U << DDRPHYC_ZQ0CR0_ZDATA_Pos)   /*!< 0x00000200 */
#define DDRPHYC_ZQ0CR0_ZDATA_10    (0x400U << DDRPHYC_ZQ0CR0_ZDATA_Pos)   /*!< 0x00000400 */
#define DDRPHYC_ZQ0CR0_ZDATA_11    (0x800U << DDRPHYC_ZQ0CR0_ZDATA_Pos)   /*!< 0x00000800 */
#define DDRPHYC_ZQ0CR0_ZDATA_12    (0x1000U << DDRPHYC_ZQ0CR0_ZDATA_Pos)  /*!< 0x00001000 */
#define DDRPHYC_ZQ0CR0_ZDATA_13    (0x2000U << DDRPHYC_ZQ0CR0_ZDATA_Pos)  /*!< 0x00002000 */
#define DDRPHYC_ZQ0CR0_ZDATA_14    (0x4000U << DDRPHYC_ZQ0CR0_ZDATA_Pos)  /*!< 0x00004000 */
#define DDRPHYC_ZQ0CR0_ZDATA_15    (0x8000U << DDRPHYC_ZQ0CR0_ZDATA_Pos)  /*!< 0x00008000 */
#define DDRPHYC_ZQ0CR0_ZDATA_16    (0x10000U << DDRPHYC_ZQ0CR0_ZDATA_Pos) /*!< 0x00010000 */
#define DDRPHYC_ZQ0CR0_ZDATA_17    (0x20000U << DDRPHYC_ZQ0CR0_ZDATA_Pos) /*!< 0x00020000 */
#define DDRPHYC_ZQ0CR0_ZDATA_18    (0x40000U << DDRPHYC_ZQ0CR0_ZDATA_Pos) /*!< 0x00040000 */
#define DDRPHYC_ZQ0CR0_ZDATA_19    (0x80000U << DDRPHYC_ZQ0CR0_ZDATA_Pos) /*!< 0x00080000 */
#define DDRPHYC_ZQ0CR0_ZDEN_Pos    (28U)
#define DDRPHYC_ZQ0CR0_ZDEN_Msk    (0x1U << DDRPHYC_ZQ0CR0_ZDEN_Pos)      /*!< 0x10000000 */
#define DDRPHYC_ZQ0CR0_ZDEN        DDRPHYC_ZQ0CR0_ZDEN_Msk                /*!< Impedance override enable */
#define DDRPHYC_ZQ0CR0_ZCALBYP_Pos (29U)
#define DDRPHYC_ZQ0CR0_ZCALBYP_Msk (0x1U << DDRPHYC_ZQ0CR0_ZCALBYP_Pos)   /*!< 0x20000000 */
#define DDRPHYC_ZQ0CR0_ZCALBYP     DDRPHYC_ZQ0CR0_ZCALBYP_Msk             /*!< Impedance calibration bypass */
#define DDRPHYC_ZQ0CR0_ZCAL_Pos    (30U)
#define DDRPHYC_ZQ0CR0_ZCAL_Msk    (0x1U << DDRPHYC_ZQ0CR0_ZCAL_Pos)      /*!< 0x40000000 */
#define DDRPHYC_ZQ0CR0_ZCAL        DDRPHYC_ZQ0CR0_ZCAL_Msk                /*!< ZCAL trigger */
#define DDRPHYC_ZQ0CR0_ZQPD_Pos    (31U)
#define DDRPHYC_ZQ0CR0_ZQPD_Msk    (0x1U << DDRPHYC_ZQ0CR0_ZQPD_Pos)      /*!< 0x80000000 */
#define DDRPHYC_ZQ0CR0_ZQPD        DDRPHYC_ZQ0CR0_ZQPD_Msk                /*!< ZCAL power down */

/****************  Bit definition for DDRPHYC_ZQ0CR1 register  ****************/
#define DDRPHYC_ZQ0CR1_ZPROG_Pos (0U)
#define DDRPHYC_ZQ0CR1_ZPROG_Msk (0xFFU << DDRPHYC_ZQ0CR1_ZPROG_Pos) /*!< 0x000000FF */
#define DDRPHYC_ZQ0CR1_ZPROG     DDRPHYC_ZQ0CR1_ZPROG_Msk            /*!< Impedance divide ratio to ext R */
#define DDRPHYC_ZQ0CR1_ZPROG_0   (0x1U << DDRPHYC_ZQ0CR1_ZPROG_Pos)  /*!< 0x00000001 */
#define DDRPHYC_ZQ0CR1_ZPROG_1   (0x2U << DDRPHYC_ZQ0CR1_ZPROG_Pos)  /*!< 0x00000002 */
#define DDRPHYC_ZQ0CR1_ZPROG_2   (0x4U << DDRPHYC_ZQ0CR1_ZPROG_Pos)  /*!< 0x00000004 */
#define DDRPHYC_ZQ0CR1_ZPROG_3   (0x8U << DDRPHYC_ZQ0CR1_ZPROG_Pos)  /*!< 0x00000008 */
#define DDRPHYC_ZQ0CR1_ZPROG_4   (0x10U << DDRPHYC_ZQ0CR1_ZPROG_Pos) /*!< 0x00000010 */
#define DDRPHYC_ZQ0CR1_ZPROG_5   (0x20U << DDRPHYC_ZQ0CR1_ZPROG_Pos) /*!< 0x00000020 */
#define DDRPHYC_ZQ0CR1_ZPROG_6   (0x40U << DDRPHYC_ZQ0CR1_ZPROG_Pos) /*!< 0x00000040 */
#define DDRPHYC_ZQ0CR1_ZPROG_7   (0x80U << DDRPHYC_ZQ0CR1_ZPROG_Pos) /*!< 0x00000080 */

/****************  Bit definition for DDRPHYC_ZQ0SR0 register  ****************/
#define DDRPHYC_ZQ0SR0_ZCTRL_Pos (0U)
#define DDRPHYC_ZQ0SR0_ZCTRL_Msk (0xFFFFFU << DDRPHYC_ZQ0SR0_ZCTRL_Pos) /*!< 0x000FFFFF */
#define DDRPHYC_ZQ0SR0_ZCTRL     DDRPHYC_ZQ0SR0_ZCTRL_Msk               /*!< Impedance control */
#define DDRPHYC_ZQ0SR0_ZCTRL_0   (0x1U << DDRPHYC_ZQ0SR0_ZCTRL_Pos)     /*!< 0x00000001 */
#define DDRPHYC_ZQ0SR0_ZCTRL_1   (0x2U << DDRPHYC_ZQ0SR0_ZCTRL_Pos)     /*!< 0x00000002 */
#define DDRPHYC_ZQ0SR0_ZCTRL_2   (0x4U << DDRPHYC_ZQ0SR0_ZCTRL_Pos)     /*!< 0x00000004 */
#define DDRPHYC_ZQ0SR0_ZCTRL_3   (0x8U << DDRPHYC_ZQ0SR0_ZCTRL_Pos)     /*!< 0x00000008 */
#define DDRPHYC_ZQ0SR0_ZCTRL_4   (0x10U << DDRPHYC_ZQ0SR0_ZCTRL_Pos)    /*!< 0x00000010 */
#define DDRPHYC_ZQ0SR0_ZCTRL_5   (0x20U << DDRPHYC_ZQ0SR0_ZCTRL_Pos)    /*!< 0x00000020 */
#define DDRPHYC_ZQ0SR0_ZCTRL_6   (0x40U << DDRPHYC_ZQ0SR0_ZCTRL_Pos)    /*!< 0x00000040 */
#define DDRPHYC_ZQ0SR0_ZCTRL_7   (0x80U << DDRPHYC_ZQ0SR0_ZCTRL_Pos)    /*!< 0x00000080 */
#define DDRPHYC_ZQ0SR0_ZCTRL_8   (0x100U << DDRPHYC_ZQ0SR0_ZCTRL_Pos)   /*!< 0x00000100 */
#define DDRPHYC_ZQ0SR0_ZCTRL_9   (0x200U << DDRPHYC_ZQ0SR0_ZCTRL_Pos)   /*!< 0x00000200 */
#define DDRPHYC_ZQ0SR0_ZCTRL_10  (0x400U << DDRPHYC_ZQ0SR0_ZCTRL_Pos)   /*!< 0x00000400 */
#define DDRPHYC_ZQ0SR0_ZCTRL_11  (0x800U << DDRPHYC_ZQ0SR0_ZCTRL_Pos)   /*!< 0x00000800 */
#define DDRPHYC_ZQ0SR0_ZCTRL_12  (0x1000U << DDRPHYC_ZQ0SR0_ZCTRL_Pos)  /*!< 0x00001000 */
#define DDRPHYC_ZQ0SR0_ZCTRL_13  (0x2000U << DDRPHYC_ZQ0SR0_ZCTRL_Pos)  /*!< 0x00002000 */
#define DDRPHYC_ZQ0SR0_ZCTRL_14  (0x4000U << DDRPHYC_ZQ0SR0_ZCTRL_Pos)  /*!< 0x00004000 */
#define DDRPHYC_ZQ0SR0_ZCTRL_15  (0x8000U << DDRPHYC_ZQ0SR0_ZCTRL_Pos)  /*!< 0x00008000 */
#define DDRPHYC_ZQ0SR0_ZCTRL_16  (0x10000U << DDRPHYC_ZQ0SR0_ZCTRL_Pos) /*!< 0x00010000 */
#define DDRPHYC_ZQ0SR0_ZCTRL_17  (0x20000U << DDRPHYC_ZQ0SR0_ZCTRL_Pos) /*!< 0x00020000 */
#define DDRPHYC_ZQ0SR0_ZCTRL_18  (0x40000U << DDRPHYC_ZQ0SR0_ZCTRL_Pos) /*!< 0x00040000 */
#define DDRPHYC_ZQ0SR0_ZCTRL_19  (0x80000U << DDRPHYC_ZQ0SR0_ZCTRL_Pos) /*!< 0x00080000 */
#define DDRPHYC_ZQ0SR0_ZERR_Pos  (30U)
#define DDRPHYC_ZQ0SR0_ZERR_Msk  (0x1U << DDRPHYC_ZQ0SR0_ZERR_Pos)      /*!< 0x40000000 */
#define DDRPHYC_ZQ0SR0_ZERR      DDRPHYC_ZQ0SR0_ZERR_Msk                /*!< Impedance calibration error */
#define DDRPHYC_ZQ0SR0_ZDONE_Pos (31U)
#define DDRPHYC_ZQ0SR0_ZDONE_Msk (0x1U << DDRPHYC_ZQ0SR0_ZDONE_Pos)     /*!< 0x80000000 */
#define DDRPHYC_ZQ0SR0_ZDONE     DDRPHYC_ZQ0SR0_ZDONE_Msk               /*!< Impedance calibration done */

/****************  Bit definition for DDRPHYC_ZQ0SR1 register  ****************/
#define DDRPHYC_ZQ0SR1_ZPD_Pos (0U)
#define DDRPHYC_ZQ0SR1_ZPD_Msk (0x3U << DDRPHYC_ZQ0SR1_ZPD_Pos) /*!< 0x00000003 */
#define DDRPHYC_ZQ0SR1_ZPD     DDRPHYC_ZQ0SR1_ZPD_Msk           /*!< zpd calibration status */
#define DDRPHYC_ZQ0SR1_ZPD_0   (0x1U << DDRPHYC_ZQ0SR1_ZPD_Pos) /*!< 0x00000001 */
#define DDRPHYC_ZQ0SR1_ZPD_1   (0x2U << DDRPHYC_ZQ0SR1_ZPD_Pos) /*!< 0x00000002 */
#define DDRPHYC_ZQ0SR1_ZPU_Pos (2U)
#define DDRPHYC_ZQ0SR1_ZPU_Msk (0x3U << DDRPHYC_ZQ0SR1_ZPU_Pos) /*!< 0x0000000C */
#define DDRPHYC_ZQ0SR1_ZPU     DDRPHYC_ZQ0SR1_ZPU_Msk           /*!< zpu calibration status */
#define DDRPHYC_ZQ0SR1_ZPU_0   (0x1U << DDRPHYC_ZQ0SR1_ZPU_Pos) /*!< 0x00000004 */
#define DDRPHYC_ZQ0SR1_ZPU_1   (0x2U << DDRPHYC_ZQ0SR1_ZPU_Pos) /*!< 0x00000008 */
#define DDRPHYC_ZQ0SR1_OPD_Pos (4U)
#define DDRPHYC_ZQ0SR1_OPD_Msk (0x3U << DDRPHYC_ZQ0SR1_OPD_Pos) /*!< 0x00000030 */
#define DDRPHYC_ZQ0SR1_OPD     DDRPHYC_ZQ0SR1_OPD_Msk           /*!< opd calibration status */
#define DDRPHYC_ZQ0SR1_OPD_0   (0x1U << DDRPHYC_ZQ0SR1_OPD_Pos) /*!< 0x00000010 */
#define DDRPHYC_ZQ0SR1_OPD_1   (0x2U << DDRPHYC_ZQ0SR1_OPD_Pos) /*!< 0x00000020 */
#define DDRPHYC_ZQ0SR1_OPU_Pos (6U)
#define DDRPHYC_ZQ0SR1_OPU_Msk (0x3U << DDRPHYC_ZQ0SR1_OPU_Pos) /*!< 0x000000C0 */
#define DDRPHYC_ZQ0SR1_OPU     DDRPHYC_ZQ0SR1_OPU_Msk           /*!< opu calibration status */
#define DDRPHYC_ZQ0SR1_OPU_0   (0x1U << DDRPHYC_ZQ0SR1_OPU_Pos) /*!< 0x00000040 */
#define DDRPHYC_ZQ0SR1_OPU_1   (0x2U << DDRPHYC_ZQ0SR1_OPU_Pos) /*!< 0x00000080 */

/****************  Bit definition for DDRPHYC_DX0GCR register  ****************/
#define DDRPHYC_DX0GCR_DXEN_Pos   (0U)
#define DDRPHYC_DX0GCR_DXEN_Msk   (0x1U << DDRPHYC_DX0GCR_DXEN_Pos)   /*!< 0x00000001 */
#define DDRPHYC_DX0GCR_DXEN       DDRPHYC_DX0GCR_DXEN_Msk             /*!< DATA byte enable */
#define DDRPHYC_DX0GCR_DQSODT_Pos (1U)
#define DDRPHYC_DX0GCR_DQSODT_Msk (0x1U << DDRPHYC_DX0GCR_DQSODT_Pos) /*!< 0x00000002 */
#define DDRPHYC_DX0GCR_DQSODT     DDRPHYC_DX0GCR_DQSODT_Msk           /*!< DQS ODT enable */
#define DDRPHYC_DX0GCR_DQODT_Pos  (2U)
#define DDRPHYC_DX0GCR_DQODT_Msk  (0x1U << DDRPHYC_DX0GCR_DQODT_Pos)  /*!< 0x00000004 */
#define DDRPHYC_DX0GCR_DQODT      DDRPHYC_DX0GCR_DQODT_Msk            /*!< DQ ODT enable */
#define DDRPHYC_DX0GCR_DXIOM_Pos  (3U)
#define DDRPHYC_DX0GCR_DXIOM_Msk  (0x1U << DDRPHYC_DX0GCR_DXIOM_Pos)  /*!< 0x00000008 */
#define DDRPHYC_DX0GCR_DXIOM      DDRPHYC_DX0GCR_DXIOM_Msk            /*!< Data I/O mode */
#define DDRPHYC_DX0GCR_DXPDD_Pos  (4U)
#define DDRPHYC_DX0GCR_DXPDD_Msk  (0x1U << DDRPHYC_DX0GCR_DXPDD_Pos)  /*!< 0x00000010 */
#define DDRPHYC_DX0GCR_DXPDD      DDRPHYC_DX0GCR_DXPDD_Msk            /*!< Data power-down driver */
#define DDRPHYC_DX0GCR_DXPDR_Pos  (5U)
#define DDRPHYC_DX0GCR_DXPDR_Msk  (0x1U << DDRPHYC_DX0GCR_DXPDR_Pos)  /*!< 0x00000020 */
#define DDRPHYC_DX0GCR_DXPDR      DDRPHYC_DX0GCR_DXPDR_Msk            /*!< Data power-down receiver */
#define DDRPHYC_DX0GCR_DQSRPD_Pos (6U)
#define DDRPHYC_DX0GCR_DQSRPD_Msk (0x1U << DDRPHYC_DX0GCR_DQSRPD_Pos) /*!< 0x00000040 */
#define DDRPHYC_DX0GCR_DQSRPD     DDRPHYC_DX0GCR_DQSRPD_Msk           /*!< DQSR power-down */
#define DDRPHYC_DX0GCR_DSEN_Pos   (7U)
#define DDRPHYC_DX0GCR_DSEN_Msk   (0x3U << DDRPHYC_DX0GCR_DSEN_Pos)   /*!< 0x00000180 */
#define DDRPHYC_DX0GCR_DSEN       DDRPHYC_DX0GCR_DSEN_Msk             /*!< Write DQS enable */
#define DDRPHYC_DX0GCR_DSEN_0     (0x1U << DDRPHYC_DX0GCR_DSEN_Pos)   /*!< 0x00000080 */
#define DDRPHYC_DX0GCR_DSEN_1     (0x2U << DDRPHYC_DX0GCR_DSEN_Pos)   /*!< 0x00000100 */
#define DDRPHYC_DX0GCR_DQSRTT_Pos (9U)
#define DDRPHYC_DX0GCR_DQSRTT_Msk (0x1U << DDRPHYC_DX0GCR_DQSRTT_Pos) /*!< 0x00000200 */
#define DDRPHYC_DX0GCR_DQSRTT     DDRPHYC_DX0GCR_DQSRTT_Msk           /*!< DQS dynamic RTT control */
#define DDRPHYC_DX0GCR_DQRTT_Pos  (10U)
#define DDRPHYC_DX0GCR_DQRTT_Msk  (0x1U << DDRPHYC_DX0GCR_DQRTT_Pos)  /*!< 0x00000400 */
#define DDRPHYC_DX0GCR_DQRTT      DDRPHYC_DX0GCR_DQRTT_Msk            /*!< DQ dynamic RTT control */
#define DDRPHYC_DX0GCR_RTTOH_Pos  (11U)
#define DDRPHYC_DX0GCR_RTTOH_Msk  (0x3U << DDRPHYC_DX0GCR_RTTOH_Pos)  /*!< 0x00001800 */
#define DDRPHYC_DX0GCR_RTTOH      DDRPHYC_DX0GCR_RTTOH_Msk            /*!< RTT output hold */
#define DDRPHYC_DX0GCR_RTTOH_0    (0x1U << DDRPHYC_DX0GCR_RTTOH_Pos)  /*!< 0x00000800 */
#define DDRPHYC_DX0GCR_RTTOH_1    (0x2U << DDRPHYC_DX0GCR_RTTOH_Pos)  /*!< 0x00001000 */
#define DDRPHYC_DX0GCR_RTTOAL_Pos (13U)
#define DDRPHYC_DX0GCR_RTTOAL_Msk (0x1U << DDRPHYC_DX0GCR_RTTOAL_Pos) /*!< 0x00002000 */
#define DDRPHYC_DX0GCR_RTTOAL     DDRPHYC_DX0GCR_RTTOAL_Msk           /*!< RTT ON additive latency */
#define DDRPHYC_DX0GCR_R0RVSL_Pos (14U)
#define DDRPHYC_DX0GCR_R0RVSL_Msk (0x7U << DDRPHYC_DX0GCR_R0RVSL_Pos) /*!< 0x0001C000 */
#define DDRPHYC_DX0GCR_R0RVSL     DDRPHYC_DX0GCR_R0RVSL_Msk           /*!< Read valid system latency in steps */
#define DDRPHYC_DX0GCR_R0RVSL_0   (0x1U << DDRPHYC_DX0GCR_R0RVSL_Pos) /*!< 0x00004000 */
#define DDRPHYC_DX0GCR_R0RVSL_1   (0x2U << DDRPHYC_DX0GCR_R0RVSL_Pos) /*!< 0x00008000 */
#define DDRPHYC_DX0GCR_R0RVSL_2   (0x4U << DDRPHYC_DX0GCR_R0RVSL_Pos) /*!< 0x00010000 */

/***************  Bit definition for DDRPHYC_DX0GSR0 register  ****************/
#define DDRPHYC_DX0GSR0_DTDONE_Pos (0U)
#define DDRPHYC_DX0GSR0_DTDONE_Msk (0x1U << DDRPHYC_DX0GSR0_DTDONE_Pos) /*!< 0x00000001 */
#define DDRPHYC_DX0GSR0_DTDONE     DDRPHYC_DX0GSR0_DTDONE_Msk           /*!< Data training done */
#define DDRPHYC_DX0GSR0_DTERR_Pos  (4U)
#define DDRPHYC_DX0GSR0_DTERR_Msk  (0x1U << DDRPHYC_DX0GSR0_DTERR_Pos)  /*!< 0x00000010 */
#define DDRPHYC_DX0GSR0_DTERR      DDRPHYC_DX0GSR0_DTERR_Msk            /*!< DQS gate training error */
#define DDRPHYC_DX0GSR0_DTIERR_Pos (8U)
#define DDRPHYC_DX0GSR0_DTIERR_Msk (0x1U << DDRPHYC_DX0GSR0_DTIERR_Pos) /*!< 0x00000100 */
#define DDRPHYC_DX0GSR0_DTIERR     DDRPHYC_DX0GSR0_DTIERR_Msk           /*!< DQS gate training intermittent error */
#define DDRPHYC_DX0GSR0_DTPASS_Pos (13U)
#define DDRPHYC_DX0GSR0_DTPASS_Msk (0x7U << DDRPHYC_DX0GSR0_DTPASS_Pos) /*!< 0x0000E000 */
#define DDRPHYC_DX0GSR0_DTPASS     DDRPHYC_DX0GSR0_DTPASS_Msk           /*!< DQS training pass count */
#define DDRPHYC_DX0GSR0_DTPASS_0   (0x1U << DDRPHYC_DX0GSR0_DTPASS_Pos) /*!< 0x00002000 */
#define DDRPHYC_DX0GSR0_DTPASS_1   (0x2U << DDRPHYC_DX0GSR0_DTPASS_Pos) /*!< 0x00004000 */
#define DDRPHYC_DX0GSR0_DTPASS_2   (0x4U << DDRPHYC_DX0GSR0_DTPASS_Pos) /*!< 0x00008000 */

/***************  Bit definition for DDRPHYC_DX0GSR1 register  ****************/
#define DDRPHYC_DX0GSR1_DFTERR_Pos (0U)
#define DDRPHYC_DX0GSR1_DFTERR_Msk (0x1U << DDRPHYC_DX0GSR1_DFTERR_Pos) /*!< 0x00000001 */
#define DDRPHYC_DX0GSR1_DFTERR     DDRPHYC_DX0GSR1_DFTERR_Msk           /*!< DQS drift error */
#define DDRPHYC_DX0GSR1_DQSDFT_Pos (4U)
#define DDRPHYC_DX0GSR1_DQSDFT_Msk (0x3U << DDRPHYC_DX0GSR1_DQSDFT_Pos) /*!< 0x00000030 */
#define DDRPHYC_DX0GSR1_DQSDFT     DDRPHYC_DX0GSR1_DQSDFT_Msk           /*!< DQS drift value */
#define DDRPHYC_DX0GSR1_DQSDFT_0   (0x1U << DDRPHYC_DX0GSR1_DQSDFT_Pos) /*!< 0x00000010 */
#define DDRPHYC_DX0GSR1_DQSDFT_1   (0x2U << DDRPHYC_DX0GSR1_DQSDFT_Pos) /*!< 0x00000020 */
#define DDRPHYC_DX0GSR1_RVERR_Pos  (12U)
#define DDRPHYC_DX0GSR1_RVERR_Msk  (0x1U << DDRPHYC_DX0GSR1_RVERR_Pos)  /*!< 0x00001000 */
#define DDRPHYC_DX0GSR1_RVERR      DDRPHYC_DX0GSR1_RVERR_Msk            /*!< RV training error */
#define DDRPHYC_DX0GSR1_RVIERR_Pos (16U)
#define DDRPHYC_DX0GSR1_RVIERR_Msk (0x1U << DDRPHYC_DX0GSR1_RVIERR_Pos) /*!< 0x00010000 */
#define DDRPHYC_DX0GSR1_RVIERR     DDRPHYC_DX0GSR1_RVIERR_Msk           /*!< RV intermittent error for rank */
#define DDRPHYC_DX0GSR1_RVPASS_Pos (20U)
#define DDRPHYC_DX0GSR1_RVPASS_Msk (0x7U << DDRPHYC_DX0GSR1_RVPASS_Pos) /*!< 0x00700000 */
#define DDRPHYC_DX0GSR1_RVPASS     DDRPHYC_DX0GSR1_RVPASS_Msk           /*!< Read valid training pass count */
#define DDRPHYC_DX0GSR1_RVPASS_0   (0x1U << DDRPHYC_DX0GSR1_RVPASS_Pos) /*!< 0x00100000 */
#define DDRPHYC_DX0GSR1_RVPASS_1   (0x2U << DDRPHYC_DX0GSR1_RVPASS_Pos) /*!< 0x00200000 */
#define DDRPHYC_DX0GSR1_RVPASS_2   (0x4U << DDRPHYC_DX0GSR1_RVPASS_Pos) /*!< 0x00400000 */

/***************  Bit definition for DDRPHYC_DX0DLLCR register  ***************/
#define DDRPHYC_DX0DLLCR_SFBDLY_Pos   (0U)
#define DDRPHYC_DX0DLLCR_SFBDLY_Msk   (0x7U << DDRPHYC_DX0DLLCR_SFBDLY_Pos)   /*!< 0x00000007 */
#define DDRPHYC_DX0DLLCR_SFBDLY       DDRPHYC_DX0DLLCR_SFBDLY_Msk             /*!< Slave DLL feed-back trim */
#define DDRPHYC_DX0DLLCR_SFBDLY_0     (0x1U << DDRPHYC_DX0DLLCR_SFBDLY_Pos)   /*!< 0x00000001 */
#define DDRPHYC_DX0DLLCR_SFBDLY_1     (0x2U << DDRPHYC_DX0DLLCR_SFBDLY_Pos)   /*!< 0x00000002 */
#define DDRPHYC_DX0DLLCR_SFBDLY_2     (0x4U << DDRPHYC_DX0DLLCR_SFBDLY_Pos)   /*!< 0x00000004 */
#define DDRPHYC_DX0DLLCR_SFWDLY_Pos   (3U)
#define DDRPHYC_DX0DLLCR_SFWDLY_Msk   (0x7U << DDRPHYC_DX0DLLCR_SFWDLY_Pos)   /*!< 0x00000038 */
#define DDRPHYC_DX0DLLCR_SFWDLY       DDRPHYC_DX0DLLCR_SFWDLY_Msk             /*!< Slave DLL feed-forward trim */
#define DDRPHYC_DX0DLLCR_SFWDLY_0     (0x1U << DDRPHYC_DX0DLLCR_SFWDLY_Pos)   /*!< 0x00000008 */
#define DDRPHYC_DX0DLLCR_SFWDLY_1     (0x2U << DDRPHYC_DX0DLLCR_SFWDLY_Pos)   /*!< 0x00000010 */
#define DDRPHYC_DX0DLLCR_SFWDLY_2     (0x4U << DDRPHYC_DX0DLLCR_SFWDLY_Pos)   /*!< 0x00000020 */
#define DDRPHYC_DX0DLLCR_MFBDLY_Pos   (6U)
#define DDRPHYC_DX0DLLCR_MFBDLY_Msk   (0x7U << DDRPHYC_DX0DLLCR_MFBDLY_Pos)   /*!< 0x000001C0 */
#define DDRPHYC_DX0DLLCR_MFBDLY       DDRPHYC_DX0DLLCR_MFBDLY_Msk             /*!< Master DLL feed-back trim */
#define DDRPHYC_DX0DLLCR_MFBDLY_0     (0x1U << DDRPHYC_DX0DLLCR_MFBDLY_Pos)   /*!< 0x00000040 */
#define DDRPHYC_DX0DLLCR_MFBDLY_1     (0x2U << DDRPHYC_DX0DLLCR_MFBDLY_Pos)   /*!< 0x00000080 */
#define DDRPHYC_DX0DLLCR_MFBDLY_2     (0x4U << DDRPHYC_DX0DLLCR_MFBDLY_Pos)   /*!< 0x00000100 */
#define DDRPHYC_DX0DLLCR_MFWDLY_Pos   (9U)
#define DDRPHYC_DX0DLLCR_MFWDLY_Msk   (0x7U << DDRPHYC_DX0DLLCR_MFWDLY_Pos)   /*!< 0x00000E00 */
#define DDRPHYC_DX0DLLCR_MFWDLY       DDRPHYC_DX0DLLCR_MFWDLY_Msk             /*!< Master DLL feed-forward trim */
#define DDRPHYC_DX0DLLCR_MFWDLY_0     (0x1U << DDRPHYC_DX0DLLCR_MFWDLY_Pos)   /*!< 0x00000200 */
#define DDRPHYC_DX0DLLCR_MFWDLY_1     (0x2U << DDRPHYC_DX0DLLCR_MFWDLY_Pos)   /*!< 0x00000400 */
#define DDRPHYC_DX0DLLCR_MFWDLY_2     (0x4U << DDRPHYC_DX0DLLCR_MFWDLY_Pos)   /*!< 0x00000800 */
#define DDRPHYC_DX0DLLCR_SSTART_Pos   (12U)
#define DDRPHYC_DX0DLLCR_SSTART_Msk   (0x3U << DDRPHYC_DX0DLLCR_SSTART_Pos)   /*!< 0x00003000 */
#define DDRPHYC_DX0DLLCR_SSTART       DDRPHYC_DX0DLLCR_SSTART_Msk             /*!< Slave DLL autostart */
#define DDRPHYC_DX0DLLCR_SSTART_0     (0x1U << DDRPHYC_DX0DLLCR_SSTART_Pos)   /*!< 0x00001000 */
#define DDRPHYC_DX0DLLCR_SSTART_1     (0x2U << DDRPHYC_DX0DLLCR_SSTART_Pos)   /*!< 0x00002000 */
#define DDRPHYC_DX0DLLCR_SDPHASE_Pos  (14U)
#define DDRPHYC_DX0DLLCR_SDPHASE_Msk  (0xFU << DDRPHYC_DX0DLLCR_SDPHASE_Pos)  /*!< 0x0003C000 */
#define DDRPHYC_DX0DLLCR_SDPHASE      DDRPHYC_DX0DLLCR_SDPHASE_Msk            /*!< Slave DLL phase */
#define DDRPHYC_DX0DLLCR_SDPHASE_0    (0x1U << DDRPHYC_DX0DLLCR_SDPHASE_Pos)  /*!< 0x00004000 */
#define DDRPHYC_DX0DLLCR_SDPHASE_1    (0x2U << DDRPHYC_DX0DLLCR_SDPHASE_Pos)  /*!< 0x00008000 */
#define DDRPHYC_DX0DLLCR_SDPHASE_2    (0x4U << DDRPHYC_DX0DLLCR_SDPHASE_Pos)  /*!< 0x00010000 */
#define DDRPHYC_DX0DLLCR_SDPHASE_3    (0x8U << DDRPHYC_DX0DLLCR_SDPHASE_Pos)  /*!< 0x00020000 */
#define DDRPHYC_DX0DLLCR_ATESTEN_Pos  (18U)
#define DDRPHYC_DX0DLLCR_ATESTEN_Msk  (0x1U << DDRPHYC_DX0DLLCR_ATESTEN_Pos)  /*!< 0x00040000 */
#define DDRPHYC_DX0DLLCR_ATESTEN      DDRPHYC_DX0DLLCR_ATESTEN_Msk            /*!< Enable path to pin 'ATO' */
#define DDRPHYC_DX0DLLCR_SDLBMODE_Pos (19U)
#define DDRPHYC_DX0DLLCR_SDLBMODE_Msk (0x1U << DDRPHYC_DX0DLLCR_SDLBMODE_Pos) /*!< 0x00080000 */
#define DDRPHYC_DX0DLLCR_SDLBMODE     DDRPHYC_DX0DLLCR_SDLBMODE_Msk           /*!< Bypass slave DLL during loopback */
#define DDRPHYC_DX0DLLCR_DLLSRST_Pos  (30U)
#define DDRPHYC_DX0DLLCR_DLLSRST_Msk  (0x1U << DDRPHYC_DX0DLLCR_DLLSRST_Pos)  /*!< 0x40000000 */
#define DDRPHYC_DX0DLLCR_DLLSRST      DDRPHYC_DX0DLLCR_DLLSRST_Msk            /*!< DLL reset */
#define DDRPHYC_DX0DLLCR_DLLDIS_Pos   (31U)
#define DDRPHYC_DX0DLLCR_DLLDIS_Msk   (0x1U << DDRPHYC_DX0DLLCR_DLLDIS_Pos)   /*!< 0x80000000 */
#define DDRPHYC_DX0DLLCR_DLLDIS       DDRPHYC_DX0DLLCR_DLLDIS_Msk             /*!< DLL bypass */

/***************  Bit definition for DDRPHYC_DX0DQTR register  ****************/
#define DDRPHYC_DX0DQTR_DQDLY0_Pos (0U)
#define DDRPHYC_DX0DQTR_DQDLY0_Msk (0xFU << DDRPHYC_DX0DQTR_DQDLY0_Pos) /*!< 0x0000000F */
#define DDRPHYC_DX0DQTR_DQDLY0     DDRPHYC_DX0DQTR_DQDLY0_Msk           /*!< DQ delay for bit 0 */
#define DDRPHYC_DX0DQTR_DQDLY0_0   (0x1U << DDRPHYC_DX0DQTR_DQDLY0_Pos) /*!< 0x00000001 */
#define DDRPHYC_DX0DQTR_DQDLY0_1   (0x2U << DDRPHYC_DX0DQTR_DQDLY0_Pos) /*!< 0x00000002 */
#define DDRPHYC_DX0DQTR_DQDLY0_2   (0x4U << DDRPHYC_DX0DQTR_DQDLY0_Pos) /*!< 0x00000004 */
#define DDRPHYC_DX0DQTR_DQDLY0_3   (0x8U << DDRPHYC_DX0DQTR_DQDLY0_Pos) /*!< 0x00000008 */
#define DDRPHYC_DX0DQTR_DQDLY1_Pos (4U)
#define DDRPHYC_DX0DQTR_DQDLY1_Msk (0xFU << DDRPHYC_DX0DQTR_DQDLY1_Pos) /*!< 0x000000F0 */
#define DDRPHYC_DX0DQTR_DQDLY1     DDRPHYC_DX0DQTR_DQDLY1_Msk           /*!< DQ delay for bit 1 */
#define DDRPHYC_DX0DQTR_DQDLY1_0   (0x1U << DDRPHYC_DX0DQTR_DQDLY1_Pos) /*!< 0x00000010 */
#define DDRPHYC_DX0DQTR_DQDLY1_1   (0x2U << DDRPHYC_DX0DQTR_DQDLY1_Pos) /*!< 0x00000020 */
#define DDRPHYC_DX0DQTR_DQDLY1_2   (0x4U << DDRPHYC_DX0DQTR_DQDLY1_Pos) /*!< 0x00000040 */
#define DDRPHYC_DX0DQTR_DQDLY1_3   (0x8U << DDRPHYC_DX0DQTR_DQDLY1_Pos) /*!< 0x00000080 */
#define DDRPHYC_DX0DQTR_DQDLY2_Pos (8U)
#define DDRPHYC_DX0DQTR_DQDLY2_Msk (0xFU << DDRPHYC_DX0DQTR_DQDLY2_Pos) /*!< 0x00000F00 */
#define DDRPHYC_DX0DQTR_DQDLY2     DDRPHYC_DX0DQTR_DQDLY2_Msk           /*!< DQ delay for bit 2 */
#define DDRPHYC_DX0DQTR_DQDLY2_0   (0x1U << DDRPHYC_DX0DQTR_DQDLY2_Pos) /*!< 0x00000100 */
#define DDRPHYC_DX0DQTR_DQDLY2_1   (0x2U << DDRPHYC_DX0DQTR_DQDLY2_Pos) /*!< 0x00000200 */
#define DDRPHYC_DX0DQTR_DQDLY2_2   (0x4U << DDRPHYC_DX0DQTR_DQDLY2_Pos) /*!< 0x00000400 */
#define DDRPHYC_DX0DQTR_DQDLY2_3   (0x8U << DDRPHYC_DX0DQTR_DQDLY2_Pos) /*!< 0x00000800 */
#define DDRPHYC_DX0DQTR_DQDLY3_Pos (12U)
#define DDRPHYC_DX0DQTR_DQDLY3_Msk (0xFU << DDRPHYC_DX0DQTR_DQDLY3_Pos) /*!< 0x0000F000 */
#define DDRPHYC_DX0DQTR_DQDLY3     DDRPHYC_DX0DQTR_DQDLY3_Msk           /*!< DQ delay for bit 3 */
#define DDRPHYC_DX0DQTR_DQDLY3_0   (0x1U << DDRPHYC_DX0DQTR_DQDLY3_Pos) /*!< 0x00001000 */
#define DDRPHYC_DX0DQTR_DQDLY3_1   (0x2U << DDRPHYC_DX0DQTR_DQDLY3_Pos) /*!< 0x00002000 */
#define DDRPHYC_DX0DQTR_DQDLY3_2   (0x4U << DDRPHYC_DX0DQTR_DQDLY3_Pos) /*!< 0x00004000 */
#define DDRPHYC_DX0DQTR_DQDLY3_3   (0x8U << DDRPHYC_DX0DQTR_DQDLY3_Pos) /*!< 0x00008000 */
#define DDRPHYC_DX0DQTR_DQDLY4_Pos (16U)
#define DDRPHYC_DX0DQTR_DQDLY4_Msk (0xFU << DDRPHYC_DX0DQTR_DQDLY4_Pos) /*!< 0x000F0000 */
#define DDRPHYC_DX0DQTR_DQDLY4     DDRPHYC_DX0DQTR_DQDLY4_Msk           /*!< DQ delay for bit 4 */
#define DDRPHYC_DX0DQTR_DQDLY4_0   (0x1U << DDRPHYC_DX0DQTR_DQDLY4_Pos) /*!< 0x00010000 */
#define DDRPHYC_DX0DQTR_DQDLY4_1   (0x2U << DDRPHYC_DX0DQTR_DQDLY4_Pos) /*!< 0x00020000 */
#define DDRPHYC_DX0DQTR_DQDLY4_2   (0x4U << DDRPHYC_DX0DQTR_DQDLY4_Pos) /*!< 0x00040000 */
#define DDRPHYC_DX0DQTR_DQDLY4_3   (0x8U << DDRPHYC_DX0DQTR_DQDLY4_Pos) /*!< 0x00080000 */
#define DDRPHYC_DX0DQTR_DQDLY5_Pos (20U)
#define DDRPHYC_DX0DQTR_DQDLY5_Msk (0xFU << DDRPHYC_DX0DQTR_DQDLY5_Pos) /*!< 0x00F00000 */
#define DDRPHYC_DX0DQTR_DQDLY5     DDRPHYC_DX0DQTR_DQDLY5_Msk           /*!< DQ delay for bit 5 */
#define DDRPHYC_DX0DQTR_DQDLY5_0   (0x1U << DDRPHYC_DX0DQTR_DQDLY5_Pos) /*!< 0x00100000 */
#define DDRPHYC_DX0DQTR_DQDLY5_1   (0x2U << DDRPHYC_DX0DQTR_DQDLY5_Pos) /*!< 0x00200000 */
#define DDRPHYC_DX0DQTR_DQDLY5_2   (0x4U << DDRPHYC_DX0DQTR_DQDLY5_Pos) /*!< 0x00400000 */
#define DDRPHYC_DX0DQTR_DQDLY5_3   (0x8U << DDRPHYC_DX0DQTR_DQDLY5_Pos) /*!< 0x00800000 */
#define DDRPHYC_DX0DQTR_DQDLY6_Pos (24U)
#define DDRPHYC_DX0DQTR_DQDLY6_Msk (0xFU << DDRPHYC_DX0DQTR_DQDLY6_Pos) /*!< 0x0F000000 */
#define DDRPHYC_DX0DQTR_DQDLY6     DDRPHYC_DX0DQTR_DQDLY6_Msk           /*!< DQ delay for bit 6 */
#define DDRPHYC_DX0DQTR_DQDLY6_0   (0x1U << DDRPHYC_DX0DQTR_DQDLY6_Pos) /*!< 0x01000000 */
#define DDRPHYC_DX0DQTR_DQDLY6_1   (0x2U << DDRPHYC_DX0DQTR_DQDLY6_Pos) /*!< 0x02000000 */
#define DDRPHYC_DX0DQTR_DQDLY6_2   (0x4U << DDRPHYC_DX0DQTR_DQDLY6_Pos) /*!< 0x04000000 */
#define DDRPHYC_DX0DQTR_DQDLY6_3   (0x8U << DDRPHYC_DX0DQTR_DQDLY6_Pos) /*!< 0x08000000 */
#define DDRPHYC_DX0DQTR_DQDLY7_Pos (28U)
#define DDRPHYC_DX0DQTR_DQDLY7_Msk (0xFU << DDRPHYC_DX0DQTR_DQDLY7_Pos) /*!< 0xF0000000 */
#define DDRPHYC_DX0DQTR_DQDLY7     DDRPHYC_DX0DQTR_DQDLY7_Msk           /*!< DQ delay for bit 7 */
#define DDRPHYC_DX0DQTR_DQDLY7_0   (0x1U << DDRPHYC_DX0DQTR_DQDLY7_Pos) /*!< 0x10000000 */
#define DDRPHYC_DX0DQTR_DQDLY7_1   (0x2U << DDRPHYC_DX0DQTR_DQDLY7_Pos) /*!< 0x20000000 */
#define DDRPHYC_DX0DQTR_DQDLY7_2   (0x4U << DDRPHYC_DX0DQTR_DQDLY7_Pos) /*!< 0x40000000 *