#!/bin/sh -xv


#
# Fork Chrome Browser.
# Okajima. May 2010.
#

# IMPORTANT:
# due to chrome bug,
# if no DHCP, chrome does not run.
# but dhclient sets link local address when DHCP fails,
# and this enables chrome to run.
start_chrome()
{
	[ -x $CHROME_PATH/chrome ] || return 1
	echo "CHROMIUM chrome start" >/dev/kmsg
	sudo -u okajima \
	HOME=/home/okajima \
	USER=okajima \
	DISPLAY=:0 \
	$CHROME_PATH/chrome \
	--start-maximized \
	--no-default-browser-check \
	--no-first-run \
	--homepage file:///tmp/booted/index.html
}

failed()
{
	DISPLAY=:0 xterm
	rm /tmp/window_id
}

set_booted()
{
	mkdir /tmp/booted
	INDEX_STR='<META HTTP-EQUIV="refresh" CONTENT="0; URL=file:///tmp/google.mod.html">' \
	INDEX_CMD='/tmp/usb/okajima/booted.sh' \
	/tmp/usb/okajima/hello_fuse -o allow_other /tmp/booted
}

doit()
{
	[ -f /tmp/booted/index.html ] || set_booted
	cp $(ls /tmp/usb/google/google.*.orig.html | tail -1 ) /tmp/google.orig.html
	cp $(ls /tmp/usb/google/google.*.mod.html | tail -1 ) /tmp/google.mod.html
	cp /tmp/usb/okajima/*.png /tmp
	start_chrome || failed
}

CHROME_PATH=$(cat /tmp/CHROME_PATH)
while :
do
	if ps ax -o cmd | grep -q ^[g]nome-session
	then
		wait
	else
		doit
	fi
done

