#!/bin/sh


get_mac1()
{
	ifconfig -a |
	grep "^$1" |
	awk '{print $5}' |
	sort | uniq | head -1
}

get_mac2()
{
	 arping -w 1 -c 1 -D -I $1 $2 |
	 grep "reply from" |
	 sed 's/\[//g' |
	 sed 's/\]//g' |
	 awk '{print $5}' |
	 sort | uniq | head -1
}

get_param()
{
	cat /var/lib/dhcp3/dhclient* |
	sed 's/[\"\;\{\}]//g' |
	sed 's/  //g' |
	sed 's/option //g' |
	grep "^$1 " |
	awk '{print $2}' |
	sort | uniq | head -1
}

old()
{
	local interface
	local fixed_address
	local subnet_mask
	local routers
	local domain_name_servers
	local mac1
	local mac2
	:
}

print_vals()
{
	echo interface $interface
	echo fixed_address $fixed_address
	echo subnet_mask $subnet_mask
	echo routers $routers
	echo domain_name_servers $domain_name_servers
	echo mac1 $mac1
	echo mac2 $mac2
}

set_vals()
{
	interface=$(get_param interface)
	[ -n "$interface" ] || return 1
	fixed_address=$(get_param fixed-address)
	[ -n "$fixed_address" ] || return 1
	subnet_mask=$(get_param subnet-mask)
	[ -n "$subnet_mask" ] || return 1
	routers=$(get_param routers)
	[ -n "$routers" ] || return 1
	domain_name_servers=$(get_param domain-name-servers)
	[ -n "$domain_name_servers" ] || return 1
	mac1=$(get_mac1 $interface)
	[ -n "$mac1" ] || return 1
	mac2=$(get_mac2 $interface $routers)
	[ -n "$mac2" ] || return 1
}

out_vals()
{
	mac1_fn=$(echo $mac1 | sed 's/://g')
	mac2_fn=$(echo $mac2 | sed 's/://g')
	cat <<EOT >/tmp/usb/dhcp/dhcp.${mac1_fn}.${mac2_fn}
magic okajima
interface $interface
fixed-address $fixed_address
subnet-mask $subnet_mask
routers $routers
domain-name-servers $domain_name_servers
mac1 $mac1
mac2 $mac2
EOT
	sync
}

check_vals()
{
	interface=$(get_param interface)
	fixed_address=$(get_param fixed-address)
	[ -n "$subnet_mask" ] || return 1
	[ -n "$routers" ] || return 1
	[ -n "$domain_name_servers" ] || return 1
	[ -n "$mac1" ] || return 1
	[ -n "$mac2" ] || return 1
	return 0
}

doit()
{
	set_vals || exit 1
	out_vals
}

[ -d /tmp/usb/dhcp ] || exit 1
[ -f /tmp/dhcp_save ] && exit 1
touch /tmp/dhcp_save
doit

