#!/bin/sh


#
# Get resolution of the current screen.
# /tmp/res_X -> X size.
# /tmp/res_Y -> Y size.
#  --- Okajima.
#

get_xy_sub()
{
	xdpyinfo |
	grep dimensions |
	grep pixels |
	grep millimeters |
	awk '{print $2}' |
	head -1
}


get_xy()
{
	local str x y
	str=$(get_xy_sub)
	x=$(echo $str | cut -d x -f 1)
	y=$(echo $str | cut -d x -f 2)
	echo $x >/tmp/res_X
	echo $y >/tmp/res_Y
}

export DISPLAY=:0
get_xy

