#!/bin/sh

#
# By Okajima. 2010-.
# NO WARRANTY. GPL.
#

ERR()
{
	sync
	echo $*
	exit 1
}



EXIT()
{
	sync
	exit 1
}



do_syslinux()
{
	[ -s /usr/lib/syslinux/menu.c32 ] || ERR "no menu.c32"
	mv $TO/syslinux $TO/syslinux.$DATE
	sync
	mkdir $TO/syslinux
	sync
	cp /usr/lib/syslinux/menu.c32 $TO/syslinux
	sync
	# SYSLINUX needs 8.3 filename for both kernel and initrd.
	cat <<EOT >$TO/syslinux/syslinux.cfg
default menu.c32
timeout 5

menu title ABSOLUTELY NO WARRANTY

label 1
menu label CHROMIUM
kernel /casper/vmlinuz
append acpi=off boot=casper initrd=/casper/initrd.jun cdrom-detect/try-usb=true


label 2
menu label CHROMIUM LOG
kernel /casper/vmlinuz
append acpi=off boot=casper initrd=/casper/initrd.jun cdrom-detect/try-usb=true use_log


label 3
menu label CHROMIUM SAFE
kernel /casper/vmlinuz
append acpi=off boot=casper initrd=/casper/initrd.jun cdrom-detect/try-usb=true X_DELAY=5 usb_delay=1 use_readahead readahead_chrome


label 4
menu label CHROMIUM FAST
kernel /casper/vmlinuz
append acpi=off boot=casper initrd=/casper/initrd.jun cdrom-detect/try-usb=true use_delay_pci no_drm


label 5
menu label CHROMIUM VESA
kernel /casper/vmlinuz
append acpi=off boot=casper initrd=/casper/initrd.jun cdrom-detect/try-usb=true xforcevesa


label 6
menu label CHROMIUM DEBUG
kernel /casper/vmlinuz
append acpi=off boot=casper initrd=/casper/initrd.jun cdrom-detect/try-usb=true break=init usb_delay=1


label 7
menu label Ubuntu NORMAL
kernel /casper/vmlinuz
append boot=casper initrd=/casper/initrd.lz cdrom-detect/try-usb=true


EOT
	sync
}


get_del_list()
{
	find $1/lib/modules/ -type f |
	grep -vf $FROM/files/scripts/preserve.list
}


do_initrd()
{
	local initrd
	initrd=/tmp/initrd.$DATE
	[ -s $TO/casper/initrd.lz ] || ERR "no initrd"
	mkdir $initrd
	cat $TO/casper/initrd.lz |
	lzma -d |
	(cd $initrd; cpio -idm)
	[ -x $initrd/init ] || ERR "no init"
	mv $initrd/init $initrd/init.true
	cp $FROM/files/scripts/init.okajima $initrd/init
	chmod 755 $initrd/init
	cp $FROM/files/scripts/init.usb $initrd/
	chmod 755 $initrd/init.usb
	get_del_list $initrd | xargs rm
	echo "Making initrd."
	(
	cd $initrd
	find . |
	cpio --dot -H newc -o |
	lzma
	) > /tmp/initrd.jun
	sync
	[ -s /tmp/initrd.jun ] || ERR "no initrd out"
	echo "Writing the initrd image to the USB stick."
	mv $TO/casper/initrd.jun $TO/casper/initrd.$DATE.jun
	sync
	cp /tmp/initrd.jun $TO/casper/initrd.jun
	sync
	[ -s $TO/casper/initrd.jun ] || ERR "no initrd wrote"
	sync
}


mkdir_sub()
{
	[ -d $1 ] || mkdir $1
}


writable()
{
	local ok
	ok="no"
	if touch 2>/dev/null $TO/test.$DATE
	then
		ok="OK"
		rm $TO/test.$DATE
	fi
	[ $ok = "OK" ]
}


cant_write()
{
	cat <<EOT
Cant write "$TO".
EOT
	echo $TO | grep -q "cdrom" && cat <<EOT
Maybe "sudo mount -o remount,rw /cdrom" would work?
And become root?
EOT
	sync
	exit 1
}


check_wget()
{
	echo "Checking the network..."
	wget -O - http://www.google.com/ >/dev/null ||
	ERR "No network."
	echo "Network is Okay."
	echo ""
}


do_init()
{
	which mksquashfs >/dev/null || ERR "No mksquashfs. apt-get squashfs-tools"
	DATE=$(date +"%Y%m%d%H%M%S")
	[ -s $FROM/files/scripts/ver ] || ERR "The first param ($FROM) is wrong."
	[ -s $TO/casper/filesystem.squashfs ] || ERR "The second param ($TO) is wrong."
	writable || cant_write
	check_wget
	mkdir_sub $TO/okajima
	mkdir_sub $TO/log
	mkdir_sub $TO/down
	mkdir_sub $TO/google
	mkdir_sub $TO/bin
	mkdir_sub $TO/save
	mkdir_sub $TO/readahead
	sync
	cp -n $FROM/files/scripts/* $TO/okajima
	sync
	cp -n $FROM/files/bin/* $TO/bin
	sync
	chmod 755 $TO/okajima/*
	chmod 755 $TO/bin/*
	sync
}


get_chrome_ver()
{
	wget -O - http://build.chromium.org/buildbot/snapshots/chromium-rel-linux/LATEST
}


do_chrome()
{
	local url
	local out_zip
	local out_sq
	local out_dir
	url="http://dl.google.com/linux/direct/google-chrome-stable_current_i386.deb"
	out_sq="$TO/down/chrome-linux.$DATE.sq"
	out_dir=/tmp/chrome.$ver.$DATE
	echo "Downloading Chrome."
	wget -O /tmp/chrome-linux.$DATE.deb $url ||
	ERR "no chrome download"
	sync
	echo "Download done. Write the chrome image to the USB stick."
	cp /tmp/chrome-linux.$DATE.deb $TO/down/
	sync
	mkdir $out_dir
	sync
	echo "Convert the chorme image to squashfs format."
	dpkg-deb -x /tmp/chrome-linux.$DATE.deb $out_dir
	sync
	[ -x $out_dir/opt/google/chrome/chrome ] || ERR "No chrome binary found"
	(
	cd $out_dir/opt/google/chrome
	mksquashfs . /tmp/chrome.sq -noappend -all-root ||
	ERR "Fail mksquash"
	)
	sync
	[ -s /tmp/chrome.sq ] || "No squash_out"
	echo "Convert done. Write the squashfs image to the USB stick."
	cp /tmp/chrome.sq $out_sq
	sync
}


do_done()
{
	cat <<EOT



EVERTHING IS DONE.
Just reboot and have a fun.



EOT
}



usage()
{
	cat <<EOT
Chromium Installer. By Okajima.
 - You need a Ubuntu bootable USB stick.
 - Network reachability.

Usage:
	$PROGNAME from to
	ex.
	$PROGNAME ./ /media/usb/
EOT
	exit 1
}



PROGNAME=$0
[ -n "$1" ] || usage
FROM=$1
[ -n "$2" ] || usage
TO=$2

trap EXIT 0 1 2 3 9 15
sync
do_init
sync
do_syslinux
sync
do_initrd
sync
do_chrome
sync
sync
sync
do_done
sync



