#!/bin/sh


#
# The main script of Chromium.
# Almost same as /etc/rc*, but very simple way.
#    By Okajima, Jun. Tokyo, Japan. May 2010 -.
# ABSOLUTELY NO WARRANTY. GPL.
#


# Trace.
T()
{
	echo CHROMIUM $* >/dev/kmsg
}


# exec command with trace and time output.
X()
{
	local ret
	echo CHROMIUM start $* >/dev/kmsg
	$*
	ret=$?
	echo CHROMIUM end $* >/dev/kmsg
	return $ret
}

BASH()
{
	touch /tmp/tty1
	/tmp/usb/okajima/make_log.sh
	getty -l /bin/bash -n 38400 tty1
}

# Print error and enter shell.
ERR()
{
	echo $*
	/tmp/usb/okajima/make_log.sh
	BASH
}

use_log()
{
	grep -q "[^a-z]use_log" /proc/cmdline
}


do_init()
{
	export USER=root
	export HOME=/root
	export DISPLAY=:0
	/tmp/usb/okajima/last_resort.sh &
	/tmp/usb/okajima/startup_init.sh
	DATE=$(cat /tmp/DATE)
}

do_log()
{
	use_log && /tmp/usb/okajima/startup_log.sh
}

use_zip_chrome()
{
	grep -q "[^a-z]use_zip_chrome" /proc/cmdline
}


do_mount_chrome()
{
	CHROME_PATH=$(cat /tmp/CHROME_PATH)
	[ -x $CHROME_PATH/chrome ] && return
	mkdir -p $CHROME_PATH
	if use_zip_chrome
	then
		unzip -q -d /tmp/ /tmp/usb/chrome-linux.[0-9]*.zip
		[ -x $CHROME_PATH/chrome ] || bash
		# unzip makes all files as "root rxw --- ---"
		chmod -R 755 $CHROME_PATH
	else
		PFN_SQUASH=$(ls -1 /tmp/usb/down/chrome-linux.*.sq | tail -1 )
		[ -n "$PFN_SQUASH" ] || ERR
		X mount -o loop $PFN_SQUASH $CHROME_PATH/
		echo $PFN_SQUASH >/tmp/PFN_SQUASH
	fi
}

del_tree()
{
	mount -t tmpfs none /lib/modules/$(uname -r)/$1
}




do_udev()
{
	if /tmp/usb/okajima/no_drm.sh
	then
		del_tree kernel/drivers/gpu
		del_tree kernel/drivers/char/agp
	fi
	udevd --daemon
	if /tmp/usb/okajima/use_delay_pci.sh
	then
		udevadm trigger \
		--subsystem-nomatch=pci
	else
		udevadm trigger
	fi
}



do_dbus()
{
	#dbus-uuidgen >/var/lib/dbus/machine-id
	#export $(dbus-launch)
	mkdir -p /var/run/dbus
	chown messagebus:messagebus /var/run/dbus
	dbus-uuidgen >/var/lib/dbus/machine-id
	dbus-uuidgen --ensure	
	dbus-daemon --system --fork
}


do_xinit()
{
	[ -n "$X_DELAY" ] && sleep $X_DELAY
	while :
	do
		T try X
		xinit /tmp/usb/okajima/x_rc.sh
		T X failed
		sleep 1
	done
}




ifconfig_sub()
{
	ifconfig dummy0:okajima 127.0.0.2 up && return 0
	sleep $1
	return 1
}

# Due to Chrome bug,
# You need dummy address.
# If no interface but only "lo",
# Chrome cant connect to localhost.
set_dummy_ip()
{
	modprobe dummy
	ifconfig_sub 0.1 && return 0
	ifconfig_sub 0.1 && return 0
	ifconfig_sub 0.3 && return 0
	ifconfig_sub 0.5 && return 0
	ifconfig_sub 1 && return 0
	ifconfig_sub 1 && return 0
	ifconfig_sub 5 && return 0
	ifconfig_sub 1 && return 0
	return 1
}



do_dummy_if()
{
	ifconfig lo up
	set_dummy_ip &
}



do_dhcp()
{
	/tmp/usb/okajima/use_delay_pci.sh && return
	dhclient
}


do_getty()
{
	while :
	do
		touch /tmp/tty3
		getty -l /bin/bash -n 38400 tty3
		sleep 1
	done
}


do_httpd()
{
	ifconfig lo up || ERR
	mkdir /tmp/httpd
	cp /tmp/usb/okajima/*.cgi /tmp/usb/okajima/*.png /tmp/httpd/
	/tmp/usb/bin/mini-httpd \
	-c "**.cgi" \
	-d /tmp/httpd \
	-u root
}


do_fake_init()
{
	while :
	do
		sync
		wait
		sync
		sleep 1
	done
}


readahead_rec()
{
	mkdir /var/lib/ureadahead
	mkdir /var/lib/ureadahead/debugfs
	rm /var/lib/ureadahead/pack
	ureadahead &
	echo $! > /tmp/UREADAHEAD_PID
}


use_readahead()
{
	[ -f /tmp/usb/config/USE_READAHEAD ] ||
	grep -q "[^a-z]use_readahead" /proc/cmdline
}

do_readahead()
{
	local pfn
	use_readahead || return
	READAHEAD_FILE="pack.$(cat /tmp/PC_CODE).tgz"
	pfn="/tmp/usb/readahead/$READAHEAD_FILE"
	if [ -s $pfn ]
	then
		mkdir /tmp/readahead
		tar -C /tmp/readahead -xvf $pfn
		/tmp/usb/okajima/readahead_playback.sh &
	else
		readahead_rec
	fi
}


doit()
{
	echo $1
	T start : $1
	do_$1
	T end : $1
}


doit init
doit log
doit mount_chrome
doit readahead
doit httpd
doit dbus
doit udev
doit xinit &
doit dummy_if
doit dhcp
doit getty &
doit fake_init


