#!/usr/bin/perl -w

# $Id: shutdownClamd.pl,v 1.4 2007/04/22 13:13:33 okamura Exp $

use strict;
use utf8;
#-------------------------------------------------------------------------------
# Modules
#-------------------------------------------------------------------------------
# System
use Getopt::Long	qw(:config no_ignore_case);
use IO::Socket;

# Project

#-------------------------------------------------------------------------------
# Declare Global Variables
#-------------------------------------------------------------------------------
use vars qw(
	%Conf
);

#-------------------------------------------------------------------------------
# subroutines
#-------------------------------------------------------------------------------
sub Connect {
	my	($port) = @_;
	my	$con;

	$port = $Conf{port}	unless (defined $port);
	if ($Conf{port} =~ /^\d+$/) {
		$con = IO::Socket::INET->new(
			Type		=> SOCK_STREAM,
			PeerAddr	=> $Conf{host},
			PeerPort	=> $port,
			Proto		=> 'tcp',
			Timeout		=> $Conf{timeout},
		);
	}
	else {
		$con = IO::Socket::UNIX->new(
			Type 		=> SOCK_STREAM,
			Peer 		=> $port,
		);
	}

	return $con;
}

sub Shutdown {
	my	$con = Connect();
	my	$ret = 1;

	if ($con) {
		eval {
			local	$SIG{ALRM};

			$SIG{ALRM} = sub { die 'clamd timeout' };
			alarm $Conf{timeout};
			$con->syswrite('SHUTDOWN', length('SHUTDOWN'));
			$con->getline;
			alarm 0;
		};
		if ($@) {
			alarm 0;
			if ($@ =~ m/^clamd timeout/) {
				print STDERR "clamd does not respond.";
			}
			else {
				printf STDERR $@;
			}
			$ret = 0;
		}
		$con->close;
	}

	return $ret;
}

#-------------------------------------------------------------------------------
# Initialize Global Variables
#-------------------------------------------------------------------------------
%Conf = (
	host	=> 'localhost',
	port	=> '/tmp/clamd',
	timeout	=> 10,
);

#-------------------------------------------------------------------------------
# Interpret Arguments
#-------------------------------------------------------------------------------
GetOptions(
	'host=s'	=> \$Conf{host},
	'port=s'	=> \$Conf{port},
	'timeout=i'	=> \$Conf{timeout},
) or exit(1);
if (
	$Conf{port} =~ m/\D/
		and
	$Conf{host} ne 'localhost'
		and
	$Conf{host} ne '127.0.0.1'
) {
	printf STDERR "Can't connect UNIX domain soket on remote host: %s:%s\n", 
		$Conf{host}, $Conf{port}
	;
	exit(2);
}

#-------------------------------------------------------------------------------
# Main
#-------------------------------------------------------------------------------
if ($> != 0) {
	printf STDERR "Effective user is not root: %d\n", $>;
	exit(3);
}

{
	my	%conf = ();
	my	$ln = 1;

	while (0 < scalar(@ARGV)) {
		my	$fh;

		unless (open $fh, $ARGV[0]) {
			printf STDERR "%s: %s\n", "$!", $ARGV[0];
			exit(2);
		}

		while (my $line = <$fh>) {
			next	if ($line =~ m/^\s*#/ or $line =~ m/^\s*$/);

			my	$orgLine = $line;
			my	$directive;
			my	$args;

			$line =~ s/#.*$//;
			$line =~ s/^\s+//;
			$line =~ s/\s+$//;

			unless ($line =~ m/^(\S+)\s+(.*)$/) {
				printf STDERR "parse error: #%d: %s", $ln, $orgLine;
				next;
			}

			($directive, $args) = ($1, $2);
			$args =~ s/\s+$//;
			$conf{$directive} = { args => $args, line => $ln };
		}
		continue {
			$ln++;
		}

		close $fh;
	}
	continue {
		shift @ARGV;
	}

	if (
		exists $conf{LocalSocket}
			and
		(
			!exists $conf{TCPSocket}
				or
			$conf{TCPSocket}->{line} < $conf{LocalSocket}->{line}
		)
	) {
		$Conf{host} = 'localhost';
		$Conf{port} = $conf{LocalSocket}->{args};
	}
	elsif (
		exists $conf{TCPSocket}
			and
		(
			!exists $conf{LocalSocket}
				or
			$conf{LocalSocket}->{line} < $conf{TCPSocket}->{line}
		)
	) {
		$Conf{host} = $conf{TCPAddr}->{args}	if (exists $conf{TCPAddr});
		$Conf{port} = $conf{TCPSocket}->{args};
	}
}

unless (Shutdown()) {
	exit(4);
}

1;
