#!/usr/bin/perl -w

# $Id: uninstall.pl,v 1.2 2009/02/09 03:21:19 okamura Exp $
# Copyright (C) 2009 Yuji OKAMURA
# 
# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation; either version 3 of the License, or (at your option) any later
# version.
# 
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
# details.
# 
# You should have received a copy of the GNU General Public License along with
# this program. If not, see <http://www.gnu.org/licenses/>.

use strict;
use File::Spec;
use File::Path;
use vars qw(
	$TemplateDir
	$LanuchAgentsDir
	@LaunchAgents
	$BinDir
	@Commands
	$ShareDir
	$ReceiptsDir
	@Packages
	@Error
);

$TemplateDir = '/System/Library/User Template';
$LanuchAgentsDir = 'Library/LaunchAgents';
@LaunchAgents = qw(
	jp.sourceforge.clamav-update.SentryKeeper.plist
	jp.sourceforge.clamav-update.RotateClamXavScanLog.plist
);
$BinDir = '/usr/local/clamXav/bin';
@Commands = qw(SentryKeeper RotateClamXavScanLog);
$ShareDir = '/usr/local/clamXav/share/LaunchAgents';
$ReceiptsDir = '/Library/Receipts';
@Packages = qw(ClamXavHelper.pkg);

@Error = ();

sub UninstallFiles {
	my	($baseDir, @files) = @_;

	foreach (@files) {
		my	$file = File::Spec->catfile($baseDir, $_);

		next	unless (-e $file);

		if (-d $file ? rmtree($file) : unlink($file)) {
			#printf "%s removed.\n", $file;
		}
		else {
			push @Error, $file;
			printf STDERR "ERROR: Can't remove %s: %s\n", $file, $!;
		}
	}
}

sub UninstallLaunchAgents {
	my	($baseDir) = @_;
	my	$launchAgentsDir = File::Spec->catfile($baseDir, $LanuchAgentsDir);

	return	unless (-d $launchAgentsDir);

	UninstallFiles($launchAgentsDir, @LaunchAgents);

	if (opendir(DH, $launchAgentsDir)) {
		my	$dontRemove = 0;

		while (my $file = readdir(DH)) {
			$dontRemove = 1	if ($file ne '.' and $file ne '..');
		}
		closedir(DH);
		unless ($dontRemove) {
			if (rmdir($launchAgentsDir)) {
				#printf "%s removed.\n", $launchAgentsDir;
			}
			else {
				push @Error, $launchAgentsDir;
				printf STDERR "ERROR: Can't remove directory %s: %s\n", $launchAgentsDir, $!;
			}
		}
	}
	else {
		printf STDERR "WARN: Can't open directory %s: %s\n", $launchAgentsDir, $!;
	}
}

{
	my	@lprojs = ();

	unless (opendir(DH, $TemplateDir)) {
		printf STDERR "WARN: Can't open directory %s\n", $TemplateDir;
	}
	@lprojs = grep(/^\w+\.lproj$/, readdir(DH));
	closedir(DH);

	foreach (@lprojs) {
		UninstallLaunchAgents(File::Spec->catfile($TemplateDir, $_));
	}
}

while (my @pwent = getpwent()) {
	next	unless (
		500 < $pwent[2] and $pwent[2] < 4294967294
			and
		-d $pwent[7]
			and
		-d File::Spec->catfile($pwent[7], 'Library')
	);
	
	foreach my $launchAgent (@LaunchAgents) {
		my	$plistPath = File::Spec->catfile($pwent[7], $LanuchAgentsDir, $launchAgent);

		if (system(qw(sudo -H -u), '#'.$pwent[2], qw(launchctl unload), $plistPath) == 0) {
			#printf STDERR "%s unloaded.\n", $launchAgent;
		}
		else {
			printf STDERR "WARN: Can't unload %s: %d\n", $launchAgent, $?;
		}
	}
	UninstallLaunchAgents($pwent[7]);
}
endpwent();

UninstallFiles($BinDir, @Commands);
UninstallFiles($ReceiptsDir, @Packages);

if (-d $ShareDir) {
	my	@files;

	UninstallFiles($ShareDir, @LaunchAgents);
	if (opendir(DH, $ShareDir)) {
		my	$dontRemove = 0;

		while (my $file = readdir(DH)) {
			$dontRemove = 1	if ($file ne '.' and $file ne '..');
		}
		closedir(DH);
		unless ($dontRemove) {
			if (rmdir($ShareDir)) {
				#printf "%s removed.\n", $ShareDir;
			}
			else {
				push @Error, $ShareDir;
				printf STDERR "ERROR: Can't remove directory %s: %s\n", $ShareDir, $!;
			}
		}
	}
	else {
		printf STDERR "WARN: Can't open directory %s: %s\n", $ShareDir, $!;
	}
}

if (0 < scalar(@Error)) {
	print STDERR "\nSorry, some files isn't removed. YOU MUST REMOVE FOLLOWINGS BY HAND.\n";
	foreach (@Error) {
		printf STDERR "\t%s\n", $_;
	}
	print STDERR "Good luck.\n";
	exit(1);
}
