// =====================================================================
//  $Id: Sw01EventDisplay.cc,v 1.1 2004/03/01 09:48:29 goiwai Exp $
//  $Name: CLDAQ-1-14-00 $
//  $Log: Sw01EventDisplay.cc,v $
//  Revision 1.1  2004/03/01 09:48:29  goiwai
//  sw01θǤѹǤ.
//  ۤȤƤѤޤ.
//  ̵Υ٥ȥǥץ쥤Ѱդޤ.
//
// =====================================================================
#include "Sw01EventDisplay.hh"
#include "Trootinit.h"
#include "TSoftwareRunInformationModule.hh"
#include "TRunInformation.hh"
#include "TRunInformationList.hh"
#include "TRunManager.hh"
#include "TSystemLogging.hh"

TApplication* Sw01EventDisplay::theApplication = rootinit( "Default", "SW01 EVENT DISPLAY" );
static const Tint _nch = 8;
static const Tint _fillcolor[_nch] = {42,32,44,34,36,46,50,40};

Sw01EventDisplay::Sw01EventDisplay( TRunManager* manager )
  : theManager( manager ),
    theCanvas( 0 ),
    theAdc( 0 ),
    theInfo( 0 )
{
  Initialize();
}

Sw01EventDisplay::~Sw01EventDisplay()
{
  delete theCanvas;
  delete theInfo;

  for ( Tint i = 0; i < _nch; i ++ ) {
    delete theAdc[i];
  }
  delete theAdc;  
}

Tvoid Sw01EventDisplay::Fill( TEvent& anEvent )
{
  TDataRecord record = anEvent.GetDataRecord();

  if ( record == "EVENT" ) {
    for ( Tint i = 0; i < _nch; i ++ ) {
      Tint databuf;
      record[0][1][i].StorePrimitive(databuf);
      theAdc[i] -> Fill( (Tdouble)databuf );
    }
  }


  theInfo -> Clear();
  Tstring runid = "Run ID: ";
  runid += theManager -> GetRun().GetStringRunID();
  Tstring eventid = "Event ID: ";
  eventid += anEvent.GetStringEventID();
  Tstring elapsed = "Elapsed: ";
  elapsed += dtostr(theManager->GetRunTimer().GetRealElapsedTime());
  elapsed += " (sec)";
  Tstring runstart = "Run Begin: ";
  runstart += theManager->GetRunClock().WhenAllocated();
  Tstring runupdate = "Last Update: ";
  runupdate += theManager->GetRunClock().WhenUpdate();

  theInfo -> AddText( runid.c_str() );
  theInfo -> AddText( eventid.c_str() );
  theInfo -> AddText( elapsed.c_str() );
  theInfo -> AddText( runstart.c_str() );
  theInfo -> AddText( runupdate.c_str() );

 
  TSoftwareRunInformationModule* module = 
    theManager -> GetRunInformationModule();
  TRunInformationList infolist = module -> GetRunInformationTable().GetRunInformationList();
  for ( Tsize_t i = 0; i < infolist.size(); i ++ ) {
    Tstring aline = infolist[i].GetItem() + ": " + infolist[i].GetValue();
    theInfo -> AddText( aline.c_str() );
  }
  theInfo -> AddText("");

  gSystem->ProcessEvents();
  return;
}

Tvoid Sw01EventDisplay::Update()
{
  for ( Tint i = 0; i < _nch; i ++ ) {
    theCanvas -> GetPad(1) -> GetPad(i+1) -> Modified();
    theCanvas -> GetPad(1) -> GetPad(i+1) -> Update();
  }
  theCanvas -> GetPad(2) -> Modified();
  theCanvas -> GetPad(2) -> Update();
  theCanvas -> cd(0);
  gSystem->ProcessEvents();
}

Tvoid Sw01EventDisplay::Clear()
{
  for ( Tint i = 0; i < _nch; i ++ ) {
    theCanvas -> GetPad(1) -> GetPad(i+1) -> Clear();
    theAdc[i] -> Reset();    
    theCanvas -> GetPad(1) -> cd(i+1);
    theAdc[i] -> Draw();
  }

  theCanvas -> GetPad(2) -> Clear();
  theInfo->Clear();
  theCanvas -> GetPad(2) -> cd();
  theInfo->Draw();

  theCanvas -> cd();
  gSystem->ProcessEvents();

  return;
}

Tvoid Sw01EventDisplay::Initialize()
{
  theCanvas = new TCanvas("theCanvas","EVENT DISPLAY",800,600);
  theCanvas -> ToggleEventStatus();
  theCanvas -> Divide(2,1,0,0);
  theCanvas -> GetPad(1) -> Divide(2,4,0,0);

  theAdc = new TH1D*[_nch];
  for ( Tint i = 0; i < _nch; i ++ ) {
    Tstring name = "theAdc" + itostr(i,2);
    Tstring title = "ADC #" + itostr(i,2);
    theAdc[i] = new TH1D( name.c_str(), title.c_str(), 50, 0, 4096 );
    theAdc[i] -> SetFillColor(_fillcolor[i]);
    theAdc[i] -> GetXaxis() -> SetTitle("Pulse height (ADC)");
    theAdc[i] -> GetYaxis() -> SetTitle("Counts");
    theCanvas -> GetPad(1) -> GetPad(i+1) -> SetFillColor(21);
    theCanvas -> GetPad(1) -> GetPad(i+1) -> SetFrameFillColor(41);

    theCanvas -> GetPad(1) -> cd(i+1);
    theAdc[i] -> Draw();
  }

  theCanvas -> GetPad(2) -> SetFillColor(44);
  theCanvas -> GetPad(2) -> cd();
  theInfo = new TPaveText(0.02,0.4,0.96,0.98);
  theInfo -> SetFillStyle(1);
  theInfo -> SetFillColor(42);
  theInfo -> SetTextAlign(12);
  theInfo -> Draw();

  theCanvas -> cd();
  gSystem->ProcessEvents();

  return;
}

Tvoid Sw01EventDisplay::Save()
{
  Tinfo << "Save(): no implementation." << Tendl;
  gSystem->ProcessEvents();
  return;
}
