// ============================================================================
//  $Id: sw01recdisp.cc,v 1.1 2004/03/01 09:48:30 goiwai Exp $
//  $Name: CLDAQ-1-14-00 $
//  $Log: sw01recdisp.cc,v $
//  Revision 1.1  2004/03/01 09:48:30  goiwai
//  sw01θǤѹǤ.
//  ۤȤƤѤޤ.
//  ̵Υ٥ȥǥץ쥤Ѱդޤ.
//
// ============================================================================
#include "TRecordDisplay.hh"
#include "TOption.hh"
#include "TArgument.hh"
#include "TEnvironmentVariableTable.hh"

int main( int argc, char** argv, char** envv )
{
  Tstring usage =
    "recdisp - Data Record Display using ROOT Library\n"
    "\n"
    "Usage: recdisp [FILE]";
  TEnvironmentVariableTable env;
  if ( ! env.HasEnvironmentItem( "CLDAQ_ROOT_USE" ) ) {
    usage +=
      "\n"
      "\n"
      "YOU SHOULD REBUILD YOUR CLDAQ LIBRARY AS FOLLOWING\n"
      "% export CLDAQ_ROOT_USE=1\n"
      "% cd $CLDAQ_INSTALL/source\n"
      "% gmake\n"
      "% cd $CLDAQ_INSTALL/tests\n"
      "% gmake $CLDAQ_INSTALL/bin/recdisp\n";
  }
  TArgument arg( argc, argv, usage );
  if ( arg.GetNumberOfElements() != 1 || !isexist( arg[0] ) ) {
    arg.ShowUsage();
  }

#ifdef __CLDAQ_ROOT_USE
  const Tstring filename = arg[0];
  TRecordDisplay* d = new TRecordDisplay( filename );
  d -> Start();
  delete d;
#endif

  return 0;
}
