// =====================================================================
//  $Id: St00BadChannelMap.cc,v 1.3 2003/10/06 16:28:17 goiwai Exp $
//  $Name: CLDAQ-1-14-00 $
//  $Log: St00BadChannelMap.cc,v $
//  Revision 1.3  2003/10/06 16:28:17  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:15:51  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "St00BadChannelMap.hh"
#include "TDataRecord.hh"
#include "TDataElement.hh"
#include "TInputObjectFile.hh"
#include "St00DataRecordConversion.hh"

St00BadChannelMap::St00BadChannelMap( const Tstring& filename )
  : St00Map( filename ), theOfflineRmsMap( theInputFileName )
{
  // RMS礭ΤХåɥͥˤ
  const TDataMultiplicity& rmsmap = theOfflineRmsMap.GetMap();
  Tdouble threshold = theEnvironmentVariableTable.GetDoubleValue( "ST00_BAD_THRESHOLD_RMS" );
  for ( Tint row = 0; row < rmsmap.num_row(); row ++ ) {
    for ( Tint col = 0; col < rmsmap.num_col(); col ++ ) {
      if ( rmsmap[ row ][ col ] > threshold ) {
	theMap[ row ][ col ] = 1.0;
      } 
    }
  }


  // overflow,underflowޤˤΤХåɥͥˤ
  const St00OfflineDarkAverageMap& ave = theOfflineRmsMap.GetOfflineDarkAverageMap();
  const TDataMultiplicity& cntmap = ave.GetCounterMap();
  Tdouble needevent =
    ave.GetNumberOfFrames() / theEnvironmentVariableTable.GetDoubleValue( "ST00_BAD_OVERFLOW" );
  for ( Tint row = 0; row < cntmap.num_row(); row ++ ) {
    for ( Tint col = 0; col < cntmap.num_col(); col ++ ) {
      if ( cntmap[ row ][ col ] < needevent ) {
	theMap[ row ][ col ] = 1.0;
      } 
    }
  }

}

St00BadChannelMap::~St00BadChannelMap()
{;}

Tbool St00BadChannelMap::IsBadChannel( Tint row, Tint col ) const
{
  if ( row < 0 || row > theNumberOfVerticalPixels - 1 ) {
    Tcerr << "St00BadChannelMap::IsBadChannel(): invalid row." << Tendl;
    return Tfalse;
  }

  if ( col < 0 || col > theNumberOfHorizontalPixels - 1 ) {
    Tcerr << "St00BadChannelMap::IsBadChannel(): invalid column." << Tendl;
    return Tfalse;
  }

  if ( theMap[ row ][ col ] == 1.0 ) {
    return Ttrue;
  } else {
    return Tfalse;
  }
}

Tbool St00BadChannelMap::IsGoodChannel( Tint row, Tint col ) const
{
  if ( row < 0 || row > theNumberOfVerticalPixels - 1 ) {
    Tcerr << "St00BadChannelMap::IsGoodChannel(): invalid row." << Tendl;
    return Tfalse;
  }

  if ( col < 0 || col > theNumberOfHorizontalPixels - 1 ) {
    Tcerr << "St00BadChannelMap::IsGoodChannel(): invalid column." << Tendl;
    return Tfalse;
  }

  if ( theMap[ row ][ col ] == 1.0 ) {
    return Tfalse;
  } else {
    return Ttrue;
  }
}

Tvoid St00BadChannelMap::SetBadChannel( Tint row, Tint col )
{
  if ( row < 0 || row > theNumberOfVerticalPixels - 1 ) {
    Tcerr << "St00BadChannelMap::SetBadChannel(): invalid row." << Tendl;
    return;
  }

  if ( col < 0 || col > theNumberOfHorizontalPixels - 1 ) {
    Tcerr << "St00BadChannelMap::SetBadChannel(): invalid column." << Tendl;
    return;
  }

  theMap[ row ][ col ] = 1.0;

  return;
}

Tvoid St00BadChannelMap::SetGoodChannel( Tint row, Tint col )
{
  if ( row < 0 || row > theNumberOfVerticalPixels - 1 ) {
    Tcerr << "St00BadChannelMap::SetGoodChannel(): invalid row." << Tendl;
    return;
  }

  if ( col < 0 || col > theNumberOfHorizontalPixels - 1 ) {
    Tcerr << "St00BadChannelMap::SetGoodChannel(): invalid column." << Tendl;
    return;
  }

  theMap[ row ][ col ] = 0.0;

  return;
}

Tint St00BadChannelMap::GetNumberOfBadChannels() const
{
  Tint num = 0;
  for ( Tint row = 0; row < theMap.num_row(); row ++ ) {
    for ( Tint col = 0; col < theMap.num_col(); col ++ ) {
      if ( theMap[ row ][ col ] == 1.0 ) {
	num ++;
      }
    }
  }
  return num;
}

Tint St00BadChannelMap::GetNumberOfGoodChannels() const
{
  Tint num = 0;
  for ( Tint row = 0; row < theMap.num_row(); row ++ ) {
    for ( Tint col = 0; col < theMap.num_col(); col ++ ) {
      if ( theMap[ row ][ col ] == 0.0 ) {
	num ++;
      }
    }
  }
  return num;
}
