// =====================================================================
//  $Id: OFFdarkplot.cc,v 1.3 2003/10/06 16:28:18 goiwai Exp $
//  $Name: CLDAQ-1-14-00 $
//  $Log: OFFdarkplot.cc,v $
//  Revision 1.3  2003/10/06 16:28:18  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:16:10  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "Trootinit.h"

#include "St01DarkDataSetInterface.hh"
#include "St01DarkDataSetList.hh"
#include "St01DarkDataSet.hh"

int main( int argc, char** argv, char** envv )
{
  if ( argc != 2 ) {
    Tcerr << "usage: " << argv[ 0 ] << " <rcfile>" << Tendl;
    Tcerr << "format: TEMP[C] CYCLE[sec] FILE" << Tendl;
    return -1;
  }

  Tstring rcfile = argv[ 1 ];

  St01DarkDataSetInterface datasetif( rcfile );
  const St01DarkDataSetList& datasetlist = datasetif.GetDarkDataSetList();
  TdoubleList graphtemp;

  for ( Tsize_t i = 0; i < datasetlist.size(); i ++ ) {
    //()Υդ뤫
    Tdouble t = datasetlist[ i ].GetTemperature();
    Tbool notyet = Ttrue;
    for ( Tsize_t j = 0; j < graphtemp.size(); j ++ ) {    
      if ( graphtemp[ j ] == t ) {
	notyet = Tfalse;
	break;
      }
    }
    if ( notyet ) {
      graphtemp.push_back( t );
    }
  }


  TApplication* theApplication = rootinit();
  TCanvas cv( "CVdark", "CVdark", 600, 800 );
  //cv.SetGridx( kFALSE );
  //cv.SetGridy( kTRUE );


  //TGraph* g = new TGraph[ graphtemp.size() ];
  TGraphErrors* ge = new TGraphErrors[ graphtemp.size() ];
  Tint ngraph = (Tint)graphtemp.size();
  for ( Tint gid = 0; gid < ngraph; gid ++ ) {
    Tstring title = "temp" + dtostr( graphtemp[ gid ] );
    ge[ gid ].SetName( title.c_str() );
    ge[ gid ].SetMarkerColor( gid + 2 );
    ge[ gid ].SetLineColor( gid + 2 );
    Tint pid = 0;
    for ( Tsize_t i = 0; i < datasetlist.size(); i ++ ) {
      Tcout << datasetlist[ i ] << Tendl;
      if ( graphtemp[ gid ] == datasetlist[ i ].GetTemperature() ) {
	Tdouble x = datasetlist[ i ].GetCycle();
	Tdouble xe = 0.0;
	Tdouble y = datasetlist[ i ].GetAverage();
	Tdouble ye = datasetlist[ i ].GetRms() / sqrt( datasetlist[ i ].GetNumberOfData() );
	ge[ gid ].SetPoint( pid, x, y );
	ge[ gid ].SetPointError( pid, xe, ye );
	pid ++;
      }
    }
  }


  Tdouble ymin, ymax;
  Tstring ans;
  while ( ans != "y" ) {
    Tcout << "Ymin? ";
    Tcin >> ymin;
    Tcout << "Ymax? ";
    Tcin >> ymax;

    cv.cd();
    cv.Clear();

    gPad -> DrawFrame( 0.0, ymin, 18.0, ymax );
    for ( Tint gid = 0; gid < ngraph; gid ++ ) {
      if ( gid == 0 ) {
	ge[ gid ].GetXaxis() -> SetTitle( "Accumulation Time (sec)" );
	ge[ gid ].GetYaxis() -> SetTitle( "Average Electron (e^{-}/pixel)" );
      }
      ge[ gid ].Draw( "p" );
    }

    cv.Modified();
    cv.Update();

    gSystem -> ProcessEvents();
    Tcout << "OK? [n/y] ";
    Tcin >> ans;
    gSystem -> ProcessEvents();
  }


  TLegend leg( 0.7, 0.6, 0.9, 0.9 );
  leg.SetName( "leg" );
  for ( Tint gid = 0; gid < ngraph; gid ++ ) {
    Tstring text = dtostr( graphtemp[ gid ] );
    text += "{}^{#circ}C";
    leg.AddEntry( &ge[ gid ], text.c_str(), "p" );
  }
  cv.cd();
  leg.Draw();
  cv.Modified();
  cv.Update();





  TCanvas CVdcplot( "CVdcplot", "CVdcplot" );
  CVdcplot.SetGridx( kFALSE );
  CVdcplot.SetGridy( kTRUE );

  TGraphErrors result;
  result.SetName( "result" );
  //only error bar
  //result.SetMarkerStyle( 0 );
  //result.SetMarkerSize( 0 );
  for ( Tint gid = 0; gid < ngraph; gid ++ ) {
    ge[ gid ].Fit( "pol1", "qm0" );
    TF1* f = ge[ gid ].GetFunction( "pol1" );
    result.SetPoint( gid, graphtemp[ gid ], f -> GetParameter( 1 ) );
    result.SetPointError( gid, 0.0, f -> GetParError( 1 ) );
  }

  CVdcplot.cd();
  CVdcplot.SetLogy();
  result.Draw( "ap" );
  result.GetXaxis() -> SetTitle( "Temperature ({}^{#circ}C)" );
  result.GetYaxis() -> SetTitle( "Dark Current (e^{-}/pixel/sec)" );
  CVdcplot.Modified();
  CVdcplot.Update();


  theApplication -> Run();
  delete [] ge;

  return 0;
}
