// =====================================================================
//  $Id: st02OFFctig-all.cc,v 1.2 2004/03/04 15:11:56 goiwai Exp $
//  $Name: CLDAQ-1-14-00 $
//  $Log: st02OFFctig-all.cc,v $
//  Revision 1.2  2004/03/04 15:11:56  goiwai
//  ۤȤɤؿ̾ѹˤȤʤǤ
//
//  Revision 1.1  2003/12/06 11:13:50  goiwai
//  st02OFFctigΰץǤ.
//
// =====================================================================
#include "TEnvironmentVariableTable.hh"
#include "TArgument.hh"
#include "TRegularExpression.hh"
#include "TInputObjectFile.hh"
#include "TDataRecord.hh"
#include "TUtilities.hh"

static const Tstring _pattern( "^drk([0-9]*)src([0-9]*)\\.dat$" );
static const Tstring _rcfile( "st02setup" );

static Tstring sourcepath( const Tstring& f );
static Tstring darkpath( const Tstring& f );
static Tvoid checkrecord( const Tstring& stype, const Tstring& sdev, const Tstring& stemp, const Tstring& dtype, const Tstring& ddev, const Tstring& dtemp );

int main( int argc, char** argv, char** envv )
{
  const Tstring usage =
    "Usage: st02OFFctig-all <output directoty> <single-pixel-data>,...,...";

  TArgument arg( argc, argv, usage );
  if ( arg.GetNumberOfElements() < 2 ) {
    arg.ShowUsage();
  }

  TstringList e = arg.GetElements();
  Tstring dirroot = e[0];
  if ( !isexist( dirroot ) ) {
    Tstring com = "mkdir -p " + dirroot;
    system( com.c_str() );
    Tcout << com << Tendl;
  }

  TstringList datafiles;
  for ( Tsize_t i = 1; i < e.size(); i ++ ) {
    datafiles.push_back( e[i] );
    if ( !isexist( e[i] ) ) {
      CLDAQ_EXIT("NOT EXIST");
    }
  }

  Tstring logname = "LOGCTI";
  Tofstream ofs( logname.c_str() );
  for ( Tsize_t i = 0; i < datafiles.size(); i ++ ) {
    Tstring sp = sourcepath( datafiles[i] );
    Tstring dp = darkpath( datafiles[i] );

    TInputObjectFile sf( sp );
    Tstring stype, sdev, stemp;
    sf[0][0][1][1].StorePrimitive( stype ); // run type 
    sf[0][0][1][2].StorePrimitive( sdev );  // device id
    sf[0][0][1][3].StorePrimitive( stemp ); // temperature

    TInputObjectFile df( dp );
    Tstring dtype, ddev, dtemp;
    df[0][0][1][1].StorePrimitive( dtype ); // run type 
    df[0][0][1][2].StorePrimitive( ddev );  // device id
    df[0][0][1][3].StorePrimitive( dtemp ); // temperature

    checkrecord( stype, sdev, stemp, dtype, ddev, dtemp );


    Tstring ctig = "./../../../bin/st02OFFctig " + datafiles[i];
    system( ctig.c_str() );
    Tcout << ctig << Tendl;

    Tstring dir = dirroot + "/temp" + stemp;
    if ( !isexist( dir ) ) {
      Tstring com = "mkdir -p " + dir;
      system( com.c_str() );
      Tcout << com << Tendl;
    }

    Tstring mv = "mv CTI* " + dir + "/";
    system( mv.c_str() );    
    Tcout << mv << Tendl;    
  }
  ofs.close();


  Tstring mv = "mv LOGCTI " + dirroot + "/";
  system( mv.c_str() );    
  Tcout << mv << Tendl;    



  return 0;
}

Tstring sourcepath( const Tstring& f )
{
  TEnvironmentVariableTable envtable( _rcfile );
  Tstring recpath = envtable.GetEnvironmentValue( "ST02_RECORD_DIR" );
  Tstring rechead = envtable.GetEnvironmentValue( "ST02_RECORD_HEAD" );

  Tstring b = basename( f );

  TRegularExpression regex( _pattern );
  TstringList list = regex.GetSubMatch( b );

  Tstring retval = recpath + Tslash + rechead + list[1] + ".drec";

  return retval;
}

Tstring darkpath( const Tstring& f )
{
  TEnvironmentVariableTable envtable( _rcfile );
  Tstring recpath = envtable.GetEnvironmentValue( "ST02_RECORD_DIR" );
  Tstring rechead = envtable.GetEnvironmentValue( "ST02_RECORD_HEAD" );

  Tstring b = basename( f );
  TRegularExpression regex( _pattern );
  TstringList list = regex.GetSubMatch( b );

  Tstring retval = recpath + Tslash + rechead + list[0] + ".drec";

  return retval;
}

Tvoid checkrecord( const Tstring& stype, const Tstring& sdev, const Tstring& stemp, const Tstring& dtype, const Tstring& ddev, const Tstring& dtemp )
{
  if ( stype != "SOURCE RUN" ) {
    Tcout << stype << Tendl;
    CLDAQ_EXIT("NOT SOURCE RUN");
  } else if ( dtype != "DARK RUN" ) {
    Tcout << dtype << Tendl;
    CLDAQ_EXIT("NOT DARK RUN");
  } else if ( stemp != dtemp ) {
    Tcout << stemp << "!=" << dtemp << Tendl;
    CLDAQ_EXIT("TEMP INCOMPATIBILITY");
  } else if ( sdev != ddev ) {
    Tcout << sdev << "!=" << ddev << Tendl;
    CLDAQ_EXIT("DEVICE INCOMPATIBILITY");
  } else {
    return;
  }
}
