// ============================================================================
//  $Id: TRecordDisplayComponent.hh,v 1.2 2004/03/07 10:30:27 goiwai Exp $
//  $Name: CLDAQ-1-14-00 $
//  $Log: TRecordDisplayComponent.hh,v $
//  Revision 1.2  2004/03/07 10:30:27  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.1  2004/03/01 02:36:25  goiwai
//  RecordDisplayѤΥ饹֤ޤ.
//  ¢ˤʤäƤΤ˼ľäΤǤ,
//  ޤԽʬߤޤ.˽ƤȻפޤ.
//  DataRecord֥Ȥɽ뤿Υġ뷲ʤΤRecordDisplayȸ
//  Ǥޤ,¿ʬ˥ե饤ǤǤ.
//  饤ˤΤEventDisplay(Eventɽ)Ȥƥߥå
//  ޤ.
//
// ============================================================================
#ifdef __CLDAQ_ROOT_USE
#ifndef CLDAQ__TRECORDDISPLAYCOMPONENT_HH
#define CLDAQ__TRECORDDISPLAYCOMPONENT_HH

#include <TGFrame.h>
#include "Tglobals.h"

class TRecordDisplay;
class TGCompositeFrame;

class TRecordDisplayComponent
{

  protected:
    TRecordDisplay* theRecordDisplay;
    TGCompositeFrame* theParentFrame;
    Tbool theFinishBuild;

  public:
    TRecordDisplayComponent( TRecordDisplay* evd );
    TRecordDisplayComponent( TRecordDisplay* evd, TGCompositeFrame* frame );

  protected:
    virtual ~TRecordDisplayComponent();

  public:
    virtual Tvoid Build() = 0;

  public:
    Tbool IsBuild() const;
    const TRecordDisplay* GetRecordDisplay() const;
    virtual Tvoid SetRecordDisplay( TRecordDisplay* evd );
    const TGCompositeFrame* GetParentFrame() const;
    virtual Tvoid SetParentFrame( TGCompositeFrame* frame );

#ifdef __CLDAQ_ROOT_DLL
    ClassDef(TRecordDisplayComponent,0)
#endif

};

inline Tbool TRecordDisplayComponent::IsBuild() const
{
  return theFinishBuild;
}

inline const TRecordDisplay* TRecordDisplayComponent::GetRecordDisplay() const
{
  return theRecordDisplay;
}

inline Tvoid TRecordDisplayComponent::SetRecordDisplay( TRecordDisplay* evd )
{
  theRecordDisplay = evd;
  return;
}

inline const TGCompositeFrame* TRecordDisplayComponent::GetParentFrame() const
{
  return theParentFrame;
}

inline Tvoid TRecordDisplayComponent::SetParentFrame( TGCompositeFrame* frame )
{
  theParentFrame = frame;
  if ( IsBuild() ) {
    Build();
  }
  return;
}

#endif
#endif
