// =====================================================================
/*!
//
//  \file TCrateDefinition.hh
//  \brief This file contains the TCrateDefinition class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TCrateDefinition.hh,v 1.6 2004/03/07 10:30:31 goiwai Exp $
//  $Name: CLDAQ-1-14-00 $
//  $Log: TCrateDefinition.hh,v $
//  Revision 1.6  2004/03/07 10:30:31  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.5  2004/01/19 21:09:41  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.4  2003/11/03 08:35:13  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.3  2003/10/06 17:02:40  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:19:10  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef CLDAQ__TCRATEDEFINITION_HH
#define CLDAQ__TCRATEDEFINITION_HH

#include "Tglobals.h"

class TCrate;
class TRunManager;


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TCrateDefinition
// \brief This is the TCrateDefinition class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TCrateDefinition class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup ModulesCategory
*/
class TCrateDefinition
{

  protected:
    TRunManager* theRunManager;

  public:
    TCrateDefinition( TRunManager* manager = 0 );
    virtual ~TCrateDefinition();

  public:
    virtual TCrate* Define() = 0;

  public:
    TRunManager* GetRunManager() const;
    Tvoid SetRunManager( TRunManager* manager );

#ifdef __CLDAQ_ROOT_DLL
    ClassDef(TCrateDefinition,0)
#endif

};

inline TRunManager* TCrateDefinition::GetRunManager() const
{
  return theRunManager;
}

inline Tvoid TCrateDefinition::SetRunManager( TRunManager* manager )
{
  theRunManager = manager;
  return;
}

#endif
