// =====================================================================
/*!
//
//  \file TInputObjectFileOnline.hh
//  \brief This file contains the TInputObjectFileOnline class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TInputObjectFileOnline.hh,v 1.6 2004/03/07 10:30:32 goiwai Exp $
//  $Name: CLDAQ-1-14-00 $
//  $Log: TInputObjectFileOnline.hh,v $
//  Revision 1.6  2004/03/07 10:30:32  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.5  2004/01/19 21:09:41  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.4  2003/12/06 10:56:19  goiwai
//  ե륿Ϣν Read(),Write()ͤνǤ.
//  Read()Write()쥳ɥ֤ޤ.
//  ե륿ƱͤǤ.
//  줾Υȥ꡼DataSizeΰǤ,ϰä쥳ɥ
//  Ǥʤäե䥽åȤʤɤΥˤʤޤ.쥳ɥ
//  פȤϸ¤ޤ.
//
//  Revision 1.3  2003/11/03 08:35:13  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.2  2003/10/14 22:05:35  goiwai
//  䤿ΤCPUޤΤ,usleep(100*1000)褦ˤޤ.
//  äѥ쥳ɤ˥ơʤȤǤ.ʲ,ơ
//  8bit:	status
//  32bit:	total size
//
//  Revision 1.1  2003/10/12 13:01:47  goiwai
//  饤ǥե򸫤뤳Ȥ¿Τǥ饤ѤΤΤѰդޤ
//  .1٥ɤळȤޤ Read() дؿäƤޤ
//  Τ,λˤ 쥳ID 򸫤ƥ롼פȴɬפޤ.
//  ǡեޥåȤ˥ơФɬפϤʤäǤ.
//
*/
// =====================================================================
#ifndef CLDAQ__TINPUTOBJECTFILEONLINE_HH
#define CLDAQ__TINPUTOBJECTFILEONLINE_HH

#include "Tglobals.h"
#include "TInputObjectFile.hh"

class TStreamableObject;
class TDataRecord;
class TDataSection;
class TDataSegment;
class TDataElement;
class TObjectFilter;
class TInputObjectFilter;


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TInputObjectFileOnline
// \brief This is the TInputObjectFileOnline class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TInputObjectFileOnline class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup PersistencyCategory
*/
class TInputObjectFileOnline
  : public TInputObjectFile
{

  private:
    enum { DEFAULT = 10 * 1000 };  // 10ms

  private:
    Tint theMicroSleepTime;

  public:
    TInputObjectFileOnline( const Tstring& filename, const Tstring& mode = "r", Tint utime = DEFAULT );
    TInputObjectFileOnline( TInputObjectFilter* filter, const Tstring& filename, const Tstring& mode = "r", Tint utime = DEFAULT );
    ~TInputObjectFileOnline();

  public:
    Tint Read( TStreamableObject& object );

  public:
    Tint GetMicroSleepTime() const;
    Tvoid SetMicroSleepTime( Tint utime );
    Tbool IsSleep() const;
    Tvoid MicroSleep() const;

#ifdef __CLDAQ_ROOT_DLL
    ClassDef(TInputObjectFileOnline,0)
#endif

};

inline Tint TInputObjectFileOnline::GetMicroSleepTime() const
{
  return theMicroSleepTime;
}

inline Tvoid TInputObjectFileOnline::SetMicroSleepTime( Tint utime )
{
  theMicroSleepTime = utime;
  return;
}

inline Tbool TInputObjectFileOnline::IsSleep() const
{
  return ( theMicroSleepTime > 0 );
}

inline Tvoid TInputObjectFileOnline::MicroSleep() const
{
  if ( IsSleep() ) {
    usleep( theMicroSleepTime );
  }
  return;
}

#endif
