// =====================================================================
/*!
//
//  \file TReadoutIndex.hh
//  \brief This file contains the TReadoutIndex class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TReadoutIndex.hh,v 1.6 2004/03/07 10:30:33 goiwai Exp $
//  $Name: CLDAQ-1-14-00 $
//  $Log: TReadoutIndex.hh,v $
//  Revision 1.6  2004/03/07 10:30:33  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.5  2004/01/19 21:09:42  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.4  2003/11/03 08:35:14  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.3  2003/10/06 16:39:00  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:20:11  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef CLDAQ__TREADOUTINDEX_HH
#define CLDAQ__TREADOUTINDEX_HH

#include "Tglobals.h"
#include "TReadoutSpecified.hh"

class TReadoutList;


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TReadoutIndex
// \brief This is the TReadoutIndex class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TReadoutIndex class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup ReadoutCategory
*/
class TReadoutIndex
  : public Tvector<TReadoutSpecified>
{

  public:
    TReadoutIndex();
    ~TReadoutIndex();

  public:
    TReadoutList* FindReadoutList( const Tstring& id ) const;
    Tvoid AddReadoutList( const Tstring& id, TReadoutList* readoutlist );
    Tvoid RemoveReadoutList( Tint index );
    Tint GetSize() const;
    Tvoid Clear();

#ifdef __CLDAQ_ROOT_DLL
    ClassDef(TReadoutIndex,0)
#endif

};

#endif
