// =====================================================================
//  $Id: Rs00ViewCommand.cc,v 1.3 2003/10/06 16:28:15 goiwai Exp $
//  $Name: CLDAQ-1-14-01 $
//  $Log: Rs00ViewCommand.cc,v $
//  Revision 1.3  2003/10/06 16:28:15  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:14:23  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TRunManager.hh"
#include "TUserInterface.hh"
#include "TOutputObjectFile.hh"
#include "TEnvironmentVariableTable.hh"

#include "Rs00ViewCommand.hh"
#include "Rs00RunAction.hh"

static const Tstring _name = "/local/rs00view";
static const Tstring _desc = "view multimeter";

Rs00ViewCommand::Rs00ViewCommand()
  : TCommand( _name, _desc )
{;}

Rs00ViewCommand::~Rs00ViewCommand()
{;}

Tvoid Rs00ViewCommand::Execute( const TstringList& arguments )
{
  const TEnvironmentVariableTable& envtable = 
    theRunManager -> GetEnvironmentVariableTable();
  Tstring bindir = envtable.GetEnvironmentValue( "RS00_BIN_DIR" );
  Tstring comname = bindir + Tslash + "rs00view";

  TUserInterface* ui = theRunManager -> GetUserInterface();
  Rs00RunAction* action = (Rs00RunAction*)( theRunManager -> GetRunAction() );
  Tstring filename = action -> GetOutputFile() -> GetFileName();
  Tstring com = "/system/shell";
  TstringList args;
  args.push_back( comname );
  args.push_back( filename );
  args.push_back( "&" );
  ui -> ExecuteCommand( com, args );
  return;
}
