// =====================================================================
//  $Id: TReadoutIndex.cc,v 1.4 2004/03/07 10:30:33 goiwai Exp $
//  $Name: CLDAQ-1-14-01 $
//  $Log: TReadoutIndex.cc,v $
//  Revision 1.4  2004/03/07 10:30:33  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.3  2003/10/06 16:39:00  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:20:11  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TReadoutIndex.hh"

TReadoutIndex::TReadoutIndex()
  : Tvector<TReadoutSpecified>()
{;}

TReadoutIndex::~TReadoutIndex()
{;}

TReadoutList* TReadoutIndex::FindReadoutList( const Tstring& id ) const
{
  for ( Tsize_t i = 0; i < size(); i ++ ) {
    if ( (*this)[ i ].GetListID() == id ) {
      return (*this)[ i ].GetReadoutList();
    }
  }
  return 0;
}

Tvoid TReadoutIndex::AddReadoutList( const Tstring& id, TReadoutList* readoutlist )
{
  TReadoutSpecified spec( id, readoutlist );
  push_back( spec );
  return;
}

Tvoid TReadoutIndex::RemoveReadoutList( Tint index )
{
  erase( begin() + index );
  return;
}

Tint TReadoutIndex::GetSize() const
{
  return (Tint)size();
}

Tvoid TReadoutIndex::Clear()
{
  clear();
  return;
}


#ifdef __CLDAQ_ROOT_DLL
    ClassImp(TReadoutIndex)
#endif
