// =====================================================================
/*!
//
//  \file TBenchmark.hh
//  \brief This file contains the TBenchmark class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TBenchmark.hh,v 1.7 2004/03/07 10:30:34 goiwai Exp $
//  $Name: CLDAQ-1-14-01 $
//  $Log: TBenchmark.hh,v $
//  Revision 1.7  2004/03/07 10:30:34  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.6  2004/01/19 21:09:43  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.5  2003/12/07 05:44:55  goiwai
//  constGetSystemTimer()GetSystemClock()ɲäޤ.
//
//  Revision 1.4  2003/11/03 08:35:15  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.3  2003/10/06 16:37:49  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:21:20  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef CLDAQ__TBENCHMARK_HH
#define CLDAQ__TBENCHMARK_HH

#include "Tglobals.h"
#include "TSystemTimer.hh"
#include "TSystemClock.hh"

class TSystemTimer;
class TSystemClock;


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TBenchmark
// \brief This is the TBenchmark class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TBenchmark class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup SystemCategory
*/
class TBenchmark
{

  protected:
    TSystemTimer theSystemTimer;
    TSystemClock theSystemClock;
    Tstring theStartTime;
    Tstring theStopTime;

  public:
    TBenchmark( const Tstring& unit = Tsec );
    virtual ~TBenchmark();

  public:
    virtual Tvoid Start();
    virtual Tvoid Pause();
    virtual Tvoid Stop();
    virtual Tvoid Lap();
    virtual Tvoid Restart();
    virtual Tvoid Continue();
    virtual Tvoid PrintResult();

  public:
    friend Tostream& operator<<( Tostream& tos, const TBenchmark& right );

  public:
    const TSystemTimer& GetSystemTimer() const;
    const TSystemClock& GetSystemClock() const;
    TSystemTimer& GetSystemTimer();
    TSystemClock& GetSystemClock();
    const Tstring& GetStartTime() const;
    const Tstring& GetStopTime() const;
    Tvoid SetStartTime( const Tstring& time );
    Tvoid SetStopTime( const Tstring& time );

#ifdef __CLDAQ_ROOT_DLL
    ClassDef(TBenchmark,0)
#endif

};

inline const TSystemTimer& TBenchmark::GetSystemTimer() const
{
  return theSystemTimer;
}

inline const TSystemClock& TBenchmark::GetSystemClock() const
{
  return theSystemClock;
}

inline TSystemTimer& TBenchmark::GetSystemTimer()
{
  return theSystemTimer;
}

inline TSystemClock& TBenchmark::GetSystemClock()
{
  return theSystemClock;
}

inline const Tstring& TBenchmark::GetStartTime() const
{
  return theStartTime;
}

inline const Tstring& TBenchmark::GetStopTime() const
{
  return theStopTime;
}

inline Tvoid TBenchmark::SetStartTime( const Tstring& time )
{
  theStartTime = time;
  return;
}

inline Tvoid TBenchmark::SetStopTime( const Tstring& time )
{
  theStopTime = time;
  return;
}

#endif
