// ============================================================================
/*!
//
//  \file TOption.hh
//  \brief This file contains the TOption class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TOption.hh,v 1.4 2004/03/07 10:30:34 goiwai Exp $
//  $Name: CLDAQ-1-14-01 $
//  $Log: TOption.hh,v $
//  Revision 1.4  2004/03/07 10:30:34  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.3  2004/01/19 21:09:43  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.2  2003/11/03 08:35:15  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.1  2003/10/06 16:32:25  goiwai
//  GNUΰñˤľŪ˲᤹뤿ʤǤ.
//
*/
// ============================================================================
#ifndef CLDAQ__TOPTION_HH
#define CLDAQ__TOPTION_HH

#include "Tglobals.h"


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TOption
// \brief This is the TOption class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TOption class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup SystemCategory
*/
class TOption
{

  public:
    enum { tNeedNot = 0, tNeed = 1, tEither = 2 };

  private:
    Tstring theLongOption;
    Tstring theShortOption;
    Tint theArgumentStyle;
    Tstring theDescription;

  public:
    TOption( const Tstring& longoption, const Tstring& shortoption = "", Tint argstyle = tNeedNot, const Tstring& desc = "" );
    TOption( const Tstring& longoption, Tint argstyle, const Tstring& shortoption = "", const Tstring& desc = "" );
    TOption( const TOption& right );
    ~TOption();

  public:
    const TOption& operator=( const TOption& right );
    Tbool operator==( const TOption& right ) const;
    Tbool operator!=( const TOption& right ) const;
    Tbool operator==( const Tstring& right ) const;
    Tbool operator!=( const Tstring& right ) const;

  public:
    friend Tostream& operator<<( Tostream& tos, const TOption& right );

  public:
    Tbool NeedParameter() const;
    Tbool NeedNotParameter() const;
    Tbool EitherNeedOrNot() const;

  public:
    const Tstring& GetLongOption() const;
    const Tstring& GetShortOption() const;
    Tint GetArgumentStyle() const;
    const Tstring& GetDescription() const;
    Tvoid SetLongOption( const Tstring& longoption );
    Tvoid SetShortOption( const Tstring& shortoption );
    Tvoid SetArgumentStyle( Tint argstyle );
    Tvoid SetDescription( const Tstring& desc );

  private:
    Tvoid initialize();

#ifdef __CLDAQ_ROOT_DLL
    ClassDef(TOption,0)
#endif

};

inline const Tstring& TOption::GetLongOption() const
{
  return theLongOption;
}

inline const Tstring& TOption::GetShortOption() const
{
  return theShortOption;
}

inline Tint TOption::GetArgumentStyle() const
{
  return theArgumentStyle;
}

inline const Tstring& TOption::GetDescription() const
{
  return theDescription;
}

inline Tvoid TOption::SetLongOption( const Tstring& longoption )
{
  theLongOption = longoption;
  initialize();
  return;
}

inline Tvoid TOption::SetShortOption( const Tstring& shortoption )
{
  theShortOption = shortoption;
  initialize();
  return;
}

inline Tvoid TOption::SetArgumentStyle( Tint argstyle )
{
  theArgumentStyle = argstyle;
  initialize();
  return;
}

inline Tvoid TOption::SetDescription( const Tstring& desc )
{
  theDescription = desc;
  initialize();
  return;
}

#endif
