// =====================================================================
/*!
//
//  \file TSystemLogging.hh
//  \brief This file contains the TSystemLogging class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TSystemLogging.hh,v 1.10 2004/06/24 15:15:26 goiwai Exp $
//  $Name: CLDAQ-1-14-01 $
//  $Log: TSystemLogging.hh,v $
//  Revision 1.10  2004/06/24 15:15:26  goiwai
//  ѹ
//  Tcout,Tcerr,TlogХåեͳˤ
//  ĤexternTlog,Tcout,Tcerr,Tinfo...Tcritʤɽϴط
//
//  Revision 1.9  2004/03/07 10:30:34  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.8  2004/01/19 23:10:08  goiwai
//  Tsyslog.hǤäƤȤ򤳤ǹԤʤ褦ˤޤ.(TemergTinfoʤ)
//  ɤexternȶͭ饤֥ĤȤˤƤޤΤ,static
//  ѿȤ.Τ?
//
//  Revision 1.7  2004/01/19 21:09:43  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.6  2003/12/06 10:13:51  goiwai
//  TSystemLogging& operator=() -> const TSystemLogging& operator=()
//  ѹޤ.
//
//  Revision 1.5  2003/12/04 23:19:52  goiwai
//  ƥ˥å뤿ʤǤ.
//  externȥ󥯤ǤʤȤäܤΤ
//  Tsyslog.hȤեexternƤޤ.
//
//  Revision 1.4  2003/11/03 08:35:15  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.3  2003/10/06 16:37:49  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:21:21  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef CLDAQ__TSYSTEMLOGGING_HH
#define CLDAQ__TSYSTEMLOGGING_HH

#include "Tglobals.h"

/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TSystemLogging
// \brief This is the TSystemLogging class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TSystemLogging class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup SystemCategory
*/
class TSystemLogging
{

  public:
    //! theOptionˤORΤ򤢤
    enum {
      //! ƥǥƥॳ󥽡ˤľܽ.
      CONS = LOG_CONS, 
      //! ϿѥץȤ³¨¤˳Ϥ.
      NDELAY = LOG_NDELAY,
      //! åϿݤҥץνλԤʤ.
      NOWAIT = LOG_NOWAIT,
      //! Record()ƤФޤ,³γϤԤʤ.
      ODELAY = LOG_ODELAY,
      //! ɸ२顼Ϥ⤹.
      PERORR = LOG_PERROR,
      //! ġΥåPIDޤ.
      PID = LOG_PID
    };

    //! եƥ,ȹͤƤ褤
    enum {
      //! ƥ/ǧ å
      AUTH = LOG_AUTH,
      //! ƥ/ǧ å (ץ饤١)
      AUTHPRIV = LOG_AUTHPRIV,
      //! åǡ (cron  at)
      CRON = LOG_CRON,
      //!  facility ͤʤƥǡ
      DAEMON = LOG_DAEMON,
      //! ftp ǡ
      FTP = LOG_FTP,
      //! ͥå
      KERN = LOG_KERN,
      //! ʻѤΤ˥ꥶ֤Ƥ
      LOCAL0 = LOG_LOCAL0,
      //! ʻѤΤ˥ꥶ֤Ƥ
      LOCAL1 = LOG_LOCAL1,
      //! ʻѤΤ˥ꥶ֤Ƥ
      LOCAL2 = LOG_LOCAL2,
      //! ʻѤΤ˥ꥶ֤Ƥ
      LOCAL3 = LOG_LOCAL3,
      //! ʻѤΤ˥ꥶ֤Ƥ
      LOCAL4 = LOG_LOCAL4,
      //! ʻѤΤ˥ꥶ֤Ƥ
      LOCAL5 = LOG_LOCAL5,
      //! ʻѤΤ˥ꥶ֤Ƥ
      LOCAL6 = LOG_LOCAL6,
      //! ʻѤΤ˥ꥶ֤Ƥ
      LOCAL7 = LOG_LOCAL7,
      //! 饤ץ󥿡֥ƥ
      LPR = LOG_LPR,
      //! ᡼롦֥ƥ
      MAIL = LOG_MAIL,
      //! USENET ˥塼֥ƥ
      NEWS = LOG_NEWS,
      //! syslogd ˤäŪȯԤå
      SYSLOG = LOG_SYSLOG,
      //! Ūʥ桼٥å
      USER = LOG_USER,
      //! UUCP֥ƥ
      UUCP = LOG_UUCP
    };

    //! ٥ (ץ饤ƥϥեƥȤȤ߹碌)
    enum {
      //! ƥबԲ
      EMERG = LOG_EMERG,
      //! ľ˹ư򵯤ʤФʤʤ
      ALERT = LOG_ALERT,
      //! ʾ  
      CRIT = LOG_CRIT,
      //! 顼ξ
      ERROR = LOG_ERR,
      //! ˥󥰤ξ
      WARNING = LOG_WARNING,
      //! ̾פʾ
      NOTICE = LOG_NOTICE,
      //! ե᡼å
      INFO = LOG_INFO,
      //! ǥХå٥Υå
      DEBUG = LOG_DEBUG
    };


  private:
    Tint theLevel;
    Tint theFacility;
    Tint theOption;
    Tstring theID;
    Tstring theMessageBuffer;

  public:
    TSystemLogging( Tint level=INFO, Tint facility=USER, Tint option=PID|ODELAY );
    TSystemLogging( const TSystemLogging& right );
    ~TSystemLogging();

  public:
    Tvoid Open( Tint option, Tint facility );
    Tvoid Open( Tint option );
    Tvoid Open();
    Tvoid Close();
    Tvoid Record( Tint level, const Tstring& format, ...);
    Tvoid Record( const Tstring& format, ...);
    Tvoid Record( Tint level, const Tstring& format, va_list ap );
    Tvoid Record( const Tstring& format, va_list ap );

  public:
    Tint GetLevel() const;
    Tint GetFacility() const;
    Tint GetOption() const;
    const Tstring& GetID() const;
    const Tstring& GetMessageBuffer() const;
    Tvoid SetLevel( Tint level );
    Tvoid SetFacility( Tint facility );
    Tvoid SetOption( Tint option );
    Tvoid SetID( const Tstring& ident );
    Tvoid SetID();
    Tvoid SetMessageBuffer( const Tstring& buffer );

  public:
    Tvoid AddBuffer( const Tstring& message );
    Tvoid ClearBuffer();

  public:
    const TSystemLogging& operator=( const TSystemLogging& right );
    TSystemLogging& operator<<( Tostream& (*pf)(Tostream&) );
    TSystemLogging& operator<<( Tostream& os );
    TSystemLogging& operator<<( const Tstring& message );
    TSystemLogging& operator<<( Tdouble n );
    TSystemLogging& operator<<( Tdouble* n );
    TSystemLogging& operator<<( Tfloat n );
    TSystemLogging& operator<<( Tfloat* n );
    TSystemLogging& operator<<( Tint n );
    TSystemLogging& operator<<( Tint* n );
    TSystemLogging& operator<<( TUint n );
    TSystemLogging& operator<<( TUint* n );
    TSystemLogging& operator<<( Tshort n );
    TSystemLogging& operator<<( Tshort* n );
    TSystemLogging& operator<<( TUshort n );
    TSystemLogging& operator<<( TUshort* n );
    TSystemLogging& operator<<( Tlong n );
    TSystemLogging& operator<<( Tlong* n );
    TSystemLogging& operator<<( TUlong n );
    TSystemLogging& operator<<( TUlong* n );
    TSystemLogging& operator<<( Tchar n );
    TSystemLogging& operator<<( TUchar n );

#ifdef __CLDAQ_ROOT_DLL
    ClassDef(TSystemLogging,0)
#endif

};

inline Tvoid TSystemLogging::AddBuffer( const Tstring& message )
{
  theMessageBuffer += message;
  return;
}

inline Tvoid TSystemLogging::ClearBuffer()
{
  theMessageBuffer.clear();
  return;
}

inline TSystemLogging& TSystemLogging::operator<<( Tostream& os )
{
  return *this;
}

inline TSystemLogging& TSystemLogging::operator<<( const Tstring& message )
{
  AddBuffer( message );
  return *this;
}

inline TSystemLogging& TSystemLogging::operator<<( Tchar n )
{
  Tstring s(1,n);
  return *this << s;
}

inline TSystemLogging& TSystemLogging::operator<<( TUchar n )
{
  Tstring s(1,(Tchar)n);
  return *this << s;
}

inline TSystemLogging& TSystemLogging::operator<<( Tdouble n )
{
  return *this << dtostr( n, 0 );
}

inline TSystemLogging& TSystemLogging::operator<<( Tdouble* n )
{
  return *this << (Tint*)n;
}

inline TSystemLogging& TSystemLogging::operator<<( Tfloat n )
{
  return *this << ftostr( n, 0 );
}

inline TSystemLogging& TSystemLogging::operator<<( Tfloat* n )
{
  return *this << (Tint*)n;
}

inline TSystemLogging& TSystemLogging::operator<<( Tint n )
{
  return *this << itostr( n, 0 );
}

inline TSystemLogging& TSystemLogging::operator<<( TUint n )
{
  return *this << ultostr( n, 0 );
}

inline TSystemLogging& TSystemLogging::operator<<( TUint* n )
{
  return *this << (Tint*)n;
}

inline TSystemLogging& TSystemLogging::operator<<( Tshort n )
{
  return *this << itostr( n, 0 );
}

inline TSystemLogging& TSystemLogging::operator<<( Tshort* n )
{
  return *this << (Tint*)n;
}

inline TSystemLogging& TSystemLogging::operator<<( TUshort n )
{
  return *this << ultostr( n, 0 );
}

inline TSystemLogging& TSystemLogging::operator<<( TUshort* n )
{
  return *this << (Tint*)n;
}

inline TSystemLogging& TSystemLogging::operator<<( Tlong n )
{
  return *this << ltostr( n, 0 );
}

inline TSystemLogging& TSystemLogging::operator<<( Tlong* n )
{
  return *this << (Tint*)n;
}

inline TSystemLogging& TSystemLogging::operator<<( TUlong n )
{
  return *this << ultostr( n, 0 );
}

inline TSystemLogging& TSystemLogging::operator<<( TUlong* n )
{
  return *this << (Tint*)n;
}

inline Tint TSystemLogging::GetLevel() const
{
  return theLevel;
}

inline Tint TSystemLogging::GetFacility() const
{
  return theFacility;
}

inline Tint TSystemLogging::GetOption() const
{
  return theOption;
}

inline const Tstring& TSystemLogging::GetID() const
{
  return theID;
}

inline const Tstring& TSystemLogging::GetMessageBuffer() const
{
  return theMessageBuffer;
}

inline Tvoid TSystemLogging::SetLevel( Tint level )
{
  theLevel = level;
  SetID();
  return;
}

inline Tvoid TSystemLogging::SetFacility( Tint facility )
{
  theFacility = facility;
  return;
}

inline Tvoid TSystemLogging::SetOption( Tint option )
{
  theOption = option;
  return;
}

inline Tvoid TSystemLogging::SetID( const Tstring& ident )
{
  theID = ident;
  return;
}

inline Tvoid TSystemLogging::SetMessageBuffer( const Tstring& buffer )
{
  theMessageBuffer = buffer;
  return;
}

#ifdef __cplusplus
extern "C" {
#endif
  extern TSystemLogging Temerg;
  extern TSystemLogging Talert;
  extern TSystemLogging Tcrit;
  extern TSystemLogging Terror;
  extern TSystemLogging Twarn;
  extern TSystemLogging Tnotice;
  extern TSystemLogging Tinfo;
  extern TSystemLogging Tdebug;
#ifdef __cplusplus
}
#endif

#endif
