// =====================================================================
//  $Id: Rs00CrateDefinition.cc,v 1.4 2003/10/06 16:28:15 goiwai Exp $
//  $Name: CLDAQ-1-14-02 $
//  $Log: Rs00CrateDefinition.cc,v $
//  Revision 1.4  2003/10/06 16:28:15  goiwai
//  *** empty log message ***
//
//  Revision 1.3  2003/07/30 16:14:23  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TCrate.hh"
#include "TRunManager.hh"
#include "TEnvironmentVariableTable.hh"
#include "TRs232cKeithley2700Module.hh"
#include "TRs232cKeithley2400Module.hh"
#include "TSoftwareTimerModule.hh"
#include "TSoftwareClockModule.hh"
#include "Rs00CrateDefinition.hh"

Rs00CrateDefinition::Rs00CrateDefinition()
  : TCrateDefinition()
{;}

Rs00CrateDefinition::~Rs00CrateDefinition()
{;}

TCrate* Rs00CrateDefinition::Define()
{
  const TEnvironmentVariableTable& envtable = 
    theRunManager -> GetEnvironmentVariableTable();
  Tstring dev = envtable.GetEnvironmentValue( "RS00_KEITHLEY_DEVICE" );
  TCrate* crate = new TCrate();
  crate -> InstallModule( new TRs232cKeithley2400Module( dev ), "MODEL 2400" );
  //crate -> InstallModule( new TRs232cKeithley2700Module( dev ), "MODEL 2700" );
  crate -> InstallModule( new TSoftwareTimerModule(), "TIMER" );
  crate -> InstallModule( new TSoftwareClockModule(), "CLOCK" );
  return crate;
}
