// =====================================================================
//  $Id: OFFtest.cc,v 1.4 2003/10/06 16:28:18 goiwai Exp $
//  $Name: CLDAQ-1-14-02 $
//  $Log: OFFtest.cc,v $
//  Revision 1.4  2003/10/06 16:28:18  goiwai
//  *** empty log message ***
//
//  Revision 1.3  2003/07/30 16:16:10  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"
#include "TEnvironmentVariableTable.hh"
#include "TInputObjectFile.hh"
#include "Trootinit.h"

#include "St01OfflineDarkAverageMap.hh"
#include "St01OfflineDarkRmsMap.hh"
#include "St01SinglePixelInterface.hh"
#include "St01SinglePixelList.hh"
#include "St01DataRecordConversion.hh"
#include "St01RunInformationExtractor.hh"
#include "St01BadChannelMap.hh"

int main( int argc, char** argv, char** envv )
{

  TApplication* theApplication = rootinit();
  TCanvas CVspfind( "CVspfind", "Findout SINGLE PIXEL EVENTs", 720, 810 );
  CVspfind.ToggleEventStatus();
  CVspfind.Divide( 2, 3 );
//   //󥰥ԥ륤٥ȤΥʥADC
//   TH1D H1Dsignal( "H1Dsignal", "Single Pixel Event subtracted D.C.", 100, 0.0, 500.0 );
//   //Υԥ˱ȤADCȤʿ
//   //Ʊ饤H.O.C.ʿѤϰƤ
  TH1D H1Ddrk( "H1Ddrk", "Dark Current subtracted H.O.C.", 100, -50.0, 50.0 );
//   //Υԥ˱RMSADCȤʿ
  TH1D H1Drms( "H1Drms", "RMS of D.C.", 50, 0.0, 50.0 );

  St01BadChannelMap map( argv[ 1 ] );
  const TDataMultiplicity& bad = map.GetMap();
  const TDataMultiplicity& rms = map.GetOfflineDarkRmsMap().GetMap();
  const TDataMultiplicity& ave = map.GetOfflineDarkRmsMap().GetOfflineDarkAverageMap().GetMap();

  Tcout << "BAD PIXEL(s) find " << map.GetNumberOfBadChannels() << Tendl;
  for ( Tint row = 0; row < bad.num_row(); row ++ ) {
    for ( Tint col = 0; col < bad.num_col(); col ++ ) {
      if ( bad[ row ][ col ] == 1.0 ) {
        Tcout << row << "," << col << ": " << bad[ row ][ col ] << Tendl;
        Tcout << ave[ row ][ col ] << Tendl;
        Tcout << rms[ row ][ col ] << Tendl;
      }
    }
  }





  for ( Tint row = 0; row < ave.num_row(); row ++ ) {
    for ( Tint col = 0; col < ave.num_col(); col ++ ) {
      //if ( badmap.IsGoodChannel( row, col ) ) {
      H1Ddrk.Fill( ave[ row ][ col ] );
      H1Drms.Fill( rms[ row ][ col ] );
      //}
    }
  }

  CVspfind.cd(1);
  H1Ddrk.Draw();
  CVspfind.cd(2);
  H1Drms.Draw();
  CVspfind.cd();

  theApplication -> Run();
  //theApplication -> Terminate();

  return 0;
}
