// =====================================================================
//  $Id: St02SignalViewCommand.cc,v 1.3 2003/10/06 16:28:19 goiwai Exp $
//  $Name: CLDAQ-1-14-02 $
//  $Log: St02SignalViewCommand.cc,v $
//  Revision 1.3  2003/10/06 16:28:19  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:16:35  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TRunManager.hh"
#include "TEnvironmentVariableTable.hh"
#include "TUserInterface.hh"
#include "TOutputObjectFile.hh"

#include "St02SignalViewCommand.hh"
#include "St02RunAction.hh"

static const Tstring _name = "/local/st02signalview";
static const Tstring _desc = "view histograms, subtracted H.O.C and dark.";

St02SignalViewCommand::St02SignalViewCommand()
  : TCommand( _name, _desc )
{;}

St02SignalViewCommand::~St02SignalViewCommand()
{;}

Tvoid St02SignalViewCommand::Execute( const TstringList& arguments )
{
  const TEnvironmentVariableTable& envtable = 
    theRunManager -> GetEnvironmentVariableTable();
  Tstring bindir = envtable.GetEnvironmentValue( "ST02_BIN_DIR" );

  TstringList args;
  Tstring comname = bindir + Tslash + "st02signalview";
  Tstring runid = theRunManager -> GetRun().GetStringRunID();
  args.push_back( comname );
  args.push_back( runid );
  args.push_back( "&" );
  

  TUserInterface* ui = theRunManager -> GetUserInterface();
  Tstring com = "/system/shell";
  ui -> ExecuteCommand( com, args );

  return;
}
