// =====================================================================
//  $Id: st02OFFdumpruninfo.cc,v 1.1 2003/12/06 11:18:31 goiwai Exp $
//  $Name: CLDAQ-1-14-02 $
//  $Log: st02OFFdumpruninfo.cc,v $
//  Revision 1.1  2003/12/06 11:18:31  goiwai
//  쥳ɤΥΤ߽Ϥޤ.
//
// =====================================================================
#include "TOption.hh"
#include "TOptionList.hh"
#include "TOptionTable.hh"
#include "TArgument.hh"
#include "TEnvironmentVariableTable.hh"
#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataElement.hh"
#include "TInputObjectFile.hh"

int main( int argc, char** argv, char** envv )
{
  TOption opbegin( "begin-run-number", 1 );
  TOption opend( "end-run-number", 1 );
  TOptionList oplist;
  oplist.push_back( opbegin );
  oplist.push_back( opend );
  TOptionTable table( oplist );
  TArgument arg( argc, argv, table );

  Tint beginid = 0;
  Tint endid = 0x1000;
  if ( arg.HasOption( opbegin ) ) {
    beginid = arg.GetIntegerParameter( opbegin );
  }
  if ( arg.HasOption( opend ) ) {
    endid = arg.GetIntegerParameter( opend );
  }

  TEnvironmentVariableTable envtable( "st02setup" );
  Tstring rechead = envtable.GetEnvironmentValue( "ST02_RECORD_HEAD" );
  Tstring recpath = envtable.GetEnvironmentValue( "ST02_RECORD_DIR" );


  for ( Tint i = beginid; i <= endid; i ++ ) {
    Tstring stringid = itostr( i );
    Tstring filename = recpath + Tslash + rechead + stringid + ".drec";
    if ( isexist( filename ) ) {
      TDataRecord record;
      TInputObjectFile ifile( filename );
      while ( ( ifile.Read( record ) ) != 0 ) {
        if ( record == "RUN BEGIN" ) {
          TDataElement e = record[0][1][1];
          Tstring typebuf;
          e.StorePrimitive( typebuf );
          Tcout << filename << ": " << typebuf << Tendl;
          break;
        }
      }
    }
  }

  return 0;
}
