// =====================================================================
/*!
//
//  \file TAnalysisStatus.hh
//  \brief This file contains the TAnalysisStatus class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TAnalysisStatus.hh,v 1.6 2004/03/07 10:30:27 goiwai Exp $
//  $Name: CLDAQ-1-14-02 $
//  $Log: TAnalysisStatus.hh,v $
//  Revision 1.6  2004/03/07 10:30:27  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.5  2004/01/19 21:09:38  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.4  2003/11/03 08:35:10  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.3  2003/10/06 17:02:36  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:17:10  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef CLDAQ__TANALYSISSTATUS_HH
#define CLDAQ__TANALYSISSTATUS_HH

#include "Tglobals.h"


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TAnalysisStatus
// \brief This is the TAnalysisStatus class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TAnalysisStatus class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup AnalysisCategory
*/
class TAnalysisStatus
{

  private:
    Tstring theID;
    Tobject_t theObjectType;
    Tstring theDrawableObjectID;
    Tstring theCanvasID;
    Tstatus_t theStatus;
    Tthread_t theThreadID;

  public:
    TAnalysisStatus( const Tstring& id = "", Tobject_t type = tObjectUnknown, const Tstring& objectid = "", const Tstring& canvasid = "", Tstatus_t status = tStatusUnknown );
    TAnalysisStatus( const TAnalysisStatus& right );
    ~TAnalysisStatus();

  public:
    const TAnalysisStatus& operator=( const TAnalysisStatus& right );
    Tbool operator==( const TAnalysisStatus& right ) const;
    Tbool operator!=( const TAnalysisStatus& right ) const;
    friend Tostream& operator<<( Tostream& tos, const TAnalysisStatus& right );

  public:
    Tstatus_t GetStatus() const;
    Tobject_t GetObjectType() const;
    const Tstring& GetID() const;
    const Tstring& GetDrawableObjectID() const;
    const Tstring& GetCanvasID() const;
    Tstring& GetID();
    Tstring& GetDrawableObjectID();
    Tstring& GetCanvasID();
    Tvoid SetStatus( Tstatus_t status );
    Tvoid SetObjectType( Tobject_t type );
    Tvoid SetID( const Tstring& id );
    Tvoid SetDrawableObjectID( const Tstring& id );
    Tvoid SetCanvasID( const Tstring& id );
    Tthread_t* GetThreadID();
    Tvoid SetThreadID( Tthread_t thread );

#ifdef __CLDAQ_ROOT_DLL
    ClassDef(TAnalysisStatus,0)
#endif

};

inline Tstatus_t TAnalysisStatus::GetStatus() const
{
  return theStatus;
}

inline Tobject_t TAnalysisStatus::GetObjectType() const
{
  return theObjectType;
}

inline const Tstring& TAnalysisStatus::GetID() const
{
  return theID;
}

inline const Tstring& TAnalysisStatus::GetDrawableObjectID() const
{
  return theDrawableObjectID;
}

inline const Tstring& TAnalysisStatus::GetCanvasID() const
{
  return theCanvasID;
}

inline Tstring& TAnalysisStatus::GetID()
{
  return theID;
}

inline Tstring& TAnalysisStatus::GetDrawableObjectID()
{
  return theDrawableObjectID;
}

inline Tstring& TAnalysisStatus::GetCanvasID()
{
  return theCanvasID;
}

inline Tvoid TAnalysisStatus::SetStatus( Tstatus_t status )
{
  theStatus = status;
  return;
}

inline Tvoid TAnalysisStatus::SetID( const Tstring& id )
{
  theID = id;
  return;
}

inline Tvoid TAnalysisStatus::SetDrawableObjectID( const Tstring& id )
{
  theDrawableObjectID = id;
  return;
}

inline Tvoid TAnalysisStatus::SetCanvasID( const Tstring& id )
{
  theCanvasID = id;
  return;
}

inline Tthread_t* TAnalysisStatus::GetThreadID()
{
  return &theThreadID;
}

inline Tvoid TAnalysisStatus::SetThreadID( Tthread_t thread )
{
  theThreadID = thread;
  return;
}

#endif
