// ============================================================================
//  $Id: TRecordAssociationTable.hh,v 1.2 2004/03/07 10:30:27 goiwai Exp $
//  $Name: CLDAQ-1-14-02 $
//  $Log: TRecordAssociationTable.hh,v $
//  Revision 1.2  2004/03/07 10:30:27  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.1  2004/03/01 02:36:25  goiwai
//  RecordDisplayѤΥ饹֤ޤ.
//  ¢ˤʤäƤΤ˼ľäΤǤ,
//  ޤԽʬߤޤ.˽ƤȻפޤ.
//  DataRecord֥Ȥɽ뤿Υġ뷲ʤΤRecordDisplayȸ
//  Ǥޤ,¿ʬ˥ե饤ǤǤ.
//  饤ˤΤEventDisplay(Eventɽ)Ȥƥߥå
//  ޤ.
//
// ============================================================================
#ifdef __CLDAQ_ROOT_USE
#ifndef CLDAQ__TRECORDASSOCIATIONTABLE_HH
#define CLDAQ__TRECORDASSOCIATIONTABLE_HH

#include <TH1.h>
#include "Tglobals.h"
#include "TRecordDisplayCanvas.hh"
#include "TRecordAssociationList.hh"
#include "TRecordAssociation.hh"

class TRecordDisplayCanvas;
class TH1D;

class TRecordAssociationTable
{

  private:
    TRecordAssociationList theAssociationList;

  public:
    TRecordAssociationTable();
    TRecordAssociationTable( const TRecordAssociationList& list );
    TRecordAssociationTable( const TRecordAssociationTable& right );
    ~TRecordAssociationTable();

  public:
    const TRecordAssociationTable& operator=( const TRecordAssociationTable& right );
    Tbool operator==( const TRecordAssociationTable& right ) const;
    Tbool operator!=( const TRecordAssociationTable& right ) const;

  public:
    friend Tostream& operator<<( Tostream& tos, const TRecordAssociationTable& right );

  public:
    const TRecordAssociationList& GetAssociationList() const;
    TRecordAssociationList& GetAssociationList();
    Tvoid SetAssociationList( const TRecordAssociationList& list );

  public:
    Tint FindAssociation( const TRecordAssociation& asso ) const;
    Tint FindAssociation( const Tstring& recordtag, const Tstring& sectiontag, const Tstring& segmenttag, const Tstring& elementtag ) const;
    Tint FindAssociation( Tstring* tags ) const;

    Tbool HasAssociation( const TRecordAssociation& asso ) const;
    Tbool HasAssociation( const Tstring& recordtag, const Tstring& sectiontag, const Tstring& segmenttag, const Tstring& elementtag ) const;
    Tbool HasAssociation( Tstring* tags ) const;

    Tvoid AddAssociation( const TRecordAssociation& asso );
    Tvoid AddAssociation( const Tstring& recordtag, const Tstring& sectiontag, const Tstring& segmenttag, const Tstring& elementtag );
    Tvoid AddAssociation( Tstring* tags );

    Tvoid SetNumberOfBins( Tint index, Tint nbin );
    Tvoid SetNumberOfBins( const TRecordAssociation& asso, Tint nbin );
    Tvoid SetNumberOfBins( const Tstring& recordtag, const Tstring& sectiontag, const Tstring& segmenttag, const Tstring& elementtag, Tint nbin );
    Tvoid SetNumberOfBins( Tstring* tags, Tint nbin );

    Tvoid SetMinimumX( Tint index, Tdouble xmin );
    Tvoid SetMinimumX( const TRecordAssociation& asso, Tdouble xmin );
    Tvoid SetMinimumX( const Tstring& recordtag, const Tstring& sectiontag, const Tstring& segmenttag, const Tstring& elementtag, Tdouble xmin );
    Tvoid SetMinimumX( Tstring* tags, Tdouble xmin );

    Tvoid SetMaximumX( Tint index, Tdouble xmax );
    Tvoid SetMaximumX( const TRecordAssociation& asso, Tdouble xmax );
    Tvoid SetMaximumX( const Tstring& recordtag, const Tstring& sectiontag, const Tstring& segmenttag, const Tstring& elementtag, Tdouble xmax );
    Tvoid SetMaximumX( Tstring* tags, Tdouble xmax );

    Tvoid SetCanvas( Tint index, TRecordDisplayCanvas* cv );
    Tvoid SetCanvas( const TRecordAssociation& asso, TRecordDisplayCanvas* cv );
    Tvoid SetCanvas( const Tstring& recordtag, const Tstring& sectiontag, const Tstring& segmenttag, const Tstring& elementtag, TRecordDisplayCanvas* cv );
    Tvoid SetCanvas( Tstring* tags, TRecordDisplayCanvas* cv );

    Tvoid SetHistogram( Tint index, TH1D* h );
    Tvoid SetHistogram( const TRecordAssociation& asso, TH1D* h );
    Tvoid SetHistogram( const Tstring& recordtag, const Tstring& sectiontag, const Tstring& segmenttag, const Tstring& elementtag, TH1D* h );
    Tvoid SetHistogram( Tstring* tags, TH1D* h );

    Tint GetNumberOfBins( Tint index ) const;
    Tint GetNumberOfBins( const TRecordAssociation& asso ) const;
    Tint GetNumberOfBins( const Tstring& recordtag, const Tstring& sectiontag, const Tstring& segmenttag, const Tstring& elementtag ) const;
    Tint GetNumberOfBins( Tstring* tags ) const;

    Tdouble GetMinimumX( Tint index ) const;
    Tdouble GetMinimumX( const TRecordAssociation& asso ) const;
    Tdouble GetMinimumX( const Tstring& recordtag, const Tstring& sectiontag, const Tstring& segmenttag, const Tstring& elementtag ) const;
    Tdouble GetMinimumX( Tstring* tags ) const;

    Tdouble GetMaximumX( Tint index ) const;
    Tdouble GetMaximumX( const TRecordAssociation& asso ) const;
    Tdouble GetMaximumX( const Tstring& recordtag, const Tstring& sectiontag, const Tstring& segmenttag, const Tstring& elementtag ) const;
    Tdouble GetMaximumX( Tstring* tags ) const;

    TRecordDisplayCanvas* GetCanvas( Tint index ) const;
    TRecordDisplayCanvas* GetCanvas( const TRecordAssociation& asso ) const;
    TRecordDisplayCanvas* GetCanvas( const Tstring& recordtag, const Tstring& sectiontag, const Tstring& segmenttag, const Tstring& elementtag ) const;
    TRecordDisplayCanvas* GetCanvas( Tstring* tags ) const;

    TH1D* GetHistogram( Tint index ) const;
    TH1D* GetHistogram( const TRecordAssociation& asso ) const;
    TH1D* GetHistogram( const Tstring& recordtag, const Tstring& sectiontag, const Tstring& segmenttag, const Tstring& elementtag ) const;
    TH1D* GetHistogram( Tstring* tags ) const;

    Tbool IsValid( Tint index ) const;
    Tbool IsValid( const Tstring& recordtag, const Tstring& sectiontag, const Tstring& segmenttag, const Tstring& elementtag ) const;
    Tbool IsValid( Tstring* tags ) const;
    Tbool IsValid( const TRecordAssociation& asso ) const;

    Tint Size() const;
    Tbool Empty() const;

#ifdef __CLDAQ_ROOT_DLL
    ClassDef(TRecordAssociationTable,0)
#endif

};

inline const TRecordAssociationList& TRecordAssociationTable::GetAssociationList() const
{
  return theAssociationList;
}

inline TRecordAssociationList& TRecordAssociationTable::GetAssociationList()
{
  return theAssociationList;
}

inline Tvoid TRecordAssociationTable::SetAssociationList( const TRecordAssociationList& list )
{
  theAssociationList = list;
  return;
}

inline Tint TRecordAssociationTable::FindAssociation( const TRecordAssociation& asso ) const
{
  for ( Tsize_t i = 0; i < theAssociationList.size(); i ++ ) {
    if ( theAssociationList[ i ] == asso ) {
      return i;
    }
  }
  return -1;
}

inline Tint TRecordAssociationTable::FindAssociation( const Tstring& recordtag, const Tstring& sectiontag, const Tstring& segmenttag, const Tstring& elementtag ) const
{
  return FindAssociation( TRecordAssociation( recordtag, sectiontag, segmenttag, elementtag ) );
}

inline Tint TRecordAssociationTable::FindAssociation( Tstring* tags ) const
{
  return FindAssociation( tags[0], tags[1], tags[2], tags[3] );
}

inline Tbool TRecordAssociationTable::HasAssociation( const TRecordAssociation& asso ) const
{
  if ( FindAssociation( asso ) < 0 ) {
    return Tfalse;
  } else {
    return Ttrue;
  }
}

inline Tbool TRecordAssociationTable::HasAssociation( const Tstring& recordtag, const Tstring& sectiontag, const Tstring& segmenttag, const Tstring& elementtag ) const
{
  return HasAssociation( TRecordAssociation( recordtag, sectiontag, segmenttag, elementtag ) );
}

inline Tbool TRecordAssociationTable::HasAssociation( Tstring* tags ) const
{
  return HasAssociation( tags[0], tags[1], tags[2], tags[3] );
}

inline Tvoid TRecordAssociationTable::AddAssociation( const TRecordAssociation& asso )
{
  if ( !HasAssociation( asso ) ) {
    theAssociationList.push_back( asso );
  }
  return;
}

inline Tvoid TRecordAssociationTable::AddAssociation( const Tstring& recordtag, const Tstring& sectiontag, const Tstring& segmenttag, const Tstring& elementtag )
{
  AddAssociation( TRecordAssociation( recordtag, sectiontag, segmenttag, elementtag ) );
  return;
}

inline Tvoid TRecordAssociationTable::AddAssociation( Tstring* tags )
{
  AddAssociation( tags[0], tags[1], tags[2], tags[3] );
  return;
}

inline Tvoid TRecordAssociationTable::SetNumberOfBins( Tint index, Tint nbin )
{
  if ( index >= 0 && index < (Tint)theAssociationList.size() ) {
    theAssociationList[ index ].SetNumberOfBins( nbin );
  }
  return;
}

inline Tvoid TRecordAssociationTable::SetNumberOfBins( const TRecordAssociation& asso, Tint nbin )
{
  SetNumberOfBins( FindAssociation( asso ), nbin );
  return;
}

inline Tvoid TRecordAssociationTable::SetNumberOfBins( const Tstring& recordtag, const Tstring& sectiontag, const Tstring& segmenttag, const Tstring& elementtag, Tint nbin )
{
  SetNumberOfBins( TRecordAssociation( recordtag, sectiontag, segmenttag, elementtag ), nbin );
  return;
}

inline Tvoid TRecordAssociationTable::SetNumberOfBins( Tstring* tags, Tint nbin )
{
  SetNumberOfBins( tags[0], tags[1], tags[2], tags[3], nbin );
  return;
}

inline Tvoid TRecordAssociationTable::SetMinimumX( Tint index, Tdouble xmin )
{
  if ( index >= 0 && index < (Tint)theAssociationList.size() ) {
    theAssociationList[ index ].SetMinimumX( xmin );
  }
  return;
}

inline Tvoid TRecordAssociationTable::SetMinimumX( const TRecordAssociation& asso, Tdouble xmin )
{
  SetMinimumX( FindAssociation( asso ), xmin );
  return;
}

inline Tvoid TRecordAssociationTable::SetMinimumX( const Tstring& recordtag, const Tstring& sectiontag, const Tstring& segmenttag, const Tstring& elementtag, Tdouble xmin )
{
  SetMinimumX( TRecordAssociation( recordtag, sectiontag, segmenttag, elementtag ), xmin );
  return;
}

inline Tvoid TRecordAssociationTable::SetMinimumX( Tstring* tags, Tdouble xmin )
{
  SetMinimumX( tags[0], tags[1], tags[2], tags[3], xmin );
  return;
}

inline Tvoid TRecordAssociationTable::SetMaximumX( Tint index, Tdouble xmax )
{
  if ( index >= 0 && index < (Tint)theAssociationList.size() ) {
    theAssociationList[ index ].SetMaximumX( xmax );
  }
  return;
}

inline Tvoid TRecordAssociationTable::SetMaximumX( const TRecordAssociation& asso, Tdouble xmax )
{
  SetMaximumX( FindAssociation( asso ), xmax );
  return;
}

inline Tvoid TRecordAssociationTable::SetMaximumX( const Tstring& recordtag, const Tstring& sectiontag, const Tstring& segmenttag, const Tstring& elementtag, Tdouble xmax )
{
  SetMaximumX( TRecordAssociation( recordtag, sectiontag, segmenttag, elementtag ), xmax );
  return;
}

inline Tvoid TRecordAssociationTable::SetMaximumX( Tstring* tags, Tdouble xmax )
{
  SetMaximumX( tags[0], tags[1], tags[2], tags[3], xmax );
  return;
}

inline Tvoid TRecordAssociationTable::SetCanvas( Tint index, TRecordDisplayCanvas* cv )
{
  if ( index >= 0 && index < (Tint)theAssociationList.size() ) {
    theAssociationList[ index ].SetCanvas( cv );
  }
  return;
}

inline Tvoid TRecordAssociationTable::SetCanvas( const TRecordAssociation& asso, TRecordDisplayCanvas* cv )
{
  SetCanvas( FindAssociation( asso ), cv );
  return;
}

inline Tvoid TRecordAssociationTable::SetCanvas( const Tstring& recordtag, const Tstring& sectiontag, const Tstring& segmenttag, const Tstring& elementtag, TRecordDisplayCanvas* cv )
{
  SetCanvas( TRecordAssociation( recordtag, sectiontag, segmenttag, elementtag ), cv );
  return;
}

inline Tvoid TRecordAssociationTable::SetCanvas( Tstring* tags, TRecordDisplayCanvas* cv )
{
  SetCanvas( tags[0], tags[1], tags[2], tags[3], cv );
  return;
}

inline Tvoid TRecordAssociationTable::SetHistogram( Tint index, TH1D* h )
{
  if ( index >= 0 && index < (Tint)theAssociationList.size() ) {
    theAssociationList[ index ].SetHistogram( h );
  }
  return;
}

inline Tvoid TRecordAssociationTable::SetHistogram( const TRecordAssociation& asso, TH1D* h )
{
  SetHistogram( FindAssociation( asso ), h );
  return;
}

inline Tvoid TRecordAssociationTable::SetHistogram( const Tstring& recordtag, const Tstring& sectiontag, const Tstring& segmenttag, const Tstring& elementtag, TH1D* h )
{
  SetHistogram( TRecordAssociation( recordtag, sectiontag, segmenttag, elementtag ), h );
  return;
}

inline Tvoid TRecordAssociationTable::SetHistogram( Tstring* tags, TH1D* h )
{
  SetHistogram( tags[0], tags[1], tags[2], tags[3], h );
  return;
}

inline Tint TRecordAssociationTable::GetNumberOfBins( Tint index ) const
{
  if ( index >= 0 && index < (Tint)theAssociationList.size() ) {
    return theAssociationList[ index ].GetNumberOfBins();
  } else {
    return -1;
  }
}

inline Tint TRecordAssociationTable::GetNumberOfBins( const TRecordAssociation& asso ) const
{
  return GetNumberOfBins( FindAssociation( asso ) );
}

inline Tint TRecordAssociationTable::GetNumberOfBins( const Tstring& recordtag, const Tstring& sectiontag, const Tstring& segmenttag, const Tstring& elementtag ) const
{
  return GetNumberOfBins( TRecordAssociation( recordtag, sectiontag, segmenttag, elementtag ) );
}

inline Tint TRecordAssociationTable::GetNumberOfBins( Tstring* tags ) const
{
  return GetNumberOfBins( tags[0], tags[1], tags[2], tags[3] );
}

inline Tdouble TRecordAssociationTable::GetMinimumX( Tint index ) const
{
  if ( index >= 0 && index < (Tint)theAssociationList.size() ) {
    return theAssociationList[ index ].GetMinimumX();
  } else {
    return DBL_MAX;
  }
}

inline Tdouble TRecordAssociationTable::GetMinimumX( const TRecordAssociation& asso ) const
{
  return GetMinimumX( FindAssociation( asso ) );
}

inline Tdouble TRecordAssociationTable::GetMinimumX( const Tstring& recordtag, const Tstring& sectiontag, const Tstring& segmenttag, const Tstring& elementtag ) const
{
  return GetMinimumX( TRecordAssociation( recordtag, sectiontag, segmenttag, elementtag ) );
}

inline Tdouble TRecordAssociationTable::GetMinimumX( Tstring* tags ) const
{
  return GetMinimumX( tags[0], tags[1], tags[2], tags[3] );
}

inline Tdouble TRecordAssociationTable::GetMaximumX( Tint index ) const
{
  if ( index >= 0 && index < (Tint)theAssociationList.size() ) {
    return theAssociationList[ index ].GetMaximumX();
  } else {
    return DBL_MIN;
  }
}

inline Tdouble TRecordAssociationTable::GetMaximumX( const TRecordAssociation& asso ) const
{
  return GetMaximumX( FindAssociation( asso ) );
}

inline Tdouble TRecordAssociationTable::GetMaximumX( const Tstring& recordtag, const Tstring& sectiontag, const Tstring& segmenttag, const Tstring& elementtag ) const
{
  return GetMaximumX( TRecordAssociation( recordtag, sectiontag, segmenttag, elementtag ) );
}

inline Tdouble TRecordAssociationTable::GetMaximumX( Tstring* tags ) const
{
  return GetMaximumX( tags[0], tags[1], tags[2], tags[3] );
}

inline TRecordDisplayCanvas* TRecordAssociationTable::GetCanvas( Tint index ) const
{
  if ( index >= 0 && index < (Tint)theAssociationList.size() ) {
    return theAssociationList[ index ].GetCanvas();
  } else {
    return 0;
  }
}

inline TRecordDisplayCanvas* TRecordAssociationTable::GetCanvas( const TRecordAssociation& asso ) const
{
  return GetCanvas( FindAssociation( asso ) );
}

inline TRecordDisplayCanvas* TRecordAssociationTable::GetCanvas( const Tstring& recordtag, const Tstring& sectiontag, const Tstring& segmenttag, const Tstring& elementtag ) const
{
  return GetCanvas( TRecordAssociation( recordtag, sectiontag, segmenttag, elementtag ) );
}

inline TRecordDisplayCanvas* TRecordAssociationTable::GetCanvas( Tstring* tags ) const
{
  return GetCanvas( tags[0], tags[1], tags[2], tags[3] );
}

inline TH1D* TRecordAssociationTable::GetHistogram( Tint index ) const
{
  if ( index >= 0 && index < (Tint)theAssociationList.size() ) {
    return theAssociationList[ index ].GetHistogram();
  } else {
    return 0;
  }
}

inline TH1D* TRecordAssociationTable::GetHistogram( const TRecordAssociation& asso ) const
{
  return GetHistogram( FindAssociation( asso ) );
}

inline TH1D* TRecordAssociationTable::GetHistogram( const Tstring& recordtag, const Tstring& sectiontag, const Tstring& segmenttag, const Tstring& elementtag ) const
{
  return GetHistogram( TRecordAssociation( recordtag, sectiontag, segmenttag, elementtag ) );
}

inline TH1D* TRecordAssociationTable::GetHistogram( Tstring* tags ) const
{
  return GetHistogram( tags[0], tags[1], tags[2], tags[3] );
}

inline Tbool TRecordAssociationTable::IsValid( Tint index ) const
{
  if ( index >= 0 && index < (Tint)theAssociationList.size() ) {
    return theAssociationList[ index ].IsValid();
  } else {
    return Tfalse;
  }
}

inline Tbool TRecordAssociationTable::IsValid( const TRecordAssociation& asso ) const
{
  return IsValid( FindAssociation( asso ) );
}

inline Tbool TRecordAssociationTable::IsValid( const Tstring& recordtag, const Tstring& sectiontag, const Tstring& segmenttag, const Tstring& elementtag ) const
{
  return IsValid( TRecordAssociation( recordtag, sectiontag, segmenttag, elementtag ) );
}

inline Tbool TRecordAssociationTable::IsValid( Tstring* tags ) const
{
  return IsValid( tags[0], tags[1], tags[2], tags[3] );
}

inline Tint TRecordAssociationTable::Size() const
{
  return (Tint)theAssociationList.size();
}

inline Tbool TRecordAssociationTable::Empty() const
{
  if ( Size() == 0 ) {
    return Ttrue;
  } else {
    return Tfalse;
  }
}

#endif
#endif
