// =====================================================================
//  $Id: TShellCommand.cc,v 1.4 2004/03/07 10:30:28 goiwai Exp $
//  $Name: CLDAQ-1-14-02 $
//  $Log: TShellCommand.cc,v $
//  Revision 1.4  2004/03/07 10:30:28  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.3  2003/10/06 17:02:37  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:17:33  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TShellCommand.hh"

static const Tstring _name = "/system/shell";
static const Tstring _desc = "execute shell command.\nexample> shell ls -l\nexample> /system/shell ps aux";

TShellCommand::TShellCommand( TRunManager* manager )
  : TCommand( manager, _name, _desc )
{;}

TShellCommand::~TShellCommand()
{;}

Tvoid TShellCommand::Execute( const TstringList& arguments )
{
  if ( arguments.empty() ) {
    ShowCommandDetail();
    return;
  }

  Tstring shcom;
  for ( Tsize_t i = 0; i < arguments.size(); i ++ ) {
    shcom += arguments[ i ];
    if ( i != arguments.size() - 1 )
      shcom += Tspace;
  }
  system( shcom.c_str() );

  return;
}

#ifdef __CLDAQ_ROOT_DLL
    ClassImp(TShellCommand)
#endif
