// =====================================================================
//  $Id: TWaitCommand.cc,v 1.4 2004/03/07 10:30:28 goiwai Exp $
//  $Name: CLDAQ-1-14-02 $
//  $Log: TWaitCommand.cc,v $
//  Revision 1.4  2004/03/07 10:30:28  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.3  2003/11/27 07:35:07  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/11/25 19:13:10  goiwai
//  *** empty log message ***
//
//  Revision 1.1  2003/11/25 13:41:59  goiwai
//  ޤ꤫Ǥ.
//  ǤϤưǤ,ޥȤƼ¹Ԥ,äȥ꡼פޤ.
//
// =====================================================================
#include "TWaitCommand.hh"
#include "TRunManager.hh"
#include "TRegularExpression.hh"

static const Tstring _name = "/system/wait";
static const Tstring _desc =
"ޥ͡㡼ΥơSleep a parent process."
"\n"
"Some thread processes go on."
"\n"
"This command can accept only one argument and must be digit."
"\n"
"CLDAQ> /system/wait 10";

TWaitCommand::TWaitCommand( TRunManager* manager )
  : TCommand( manager, _name, _desc )
{;}

TWaitCommand::~TWaitCommand()
{;}

Tvoid TWaitCommand::Execute( const TstringList& arguments )
{
  static TRegularExpression regex( "^[0-9]+$" );

  // ޤ꤫
  // Ȥꤢ, RunManagerХˤʤޤԤ
  // ưȤޤȤư뤱
  // /system/execute ǤȤäsleep äѤʤˤʤ
  Tint sec = 1;
  if ( !arguments.empty() ) {
    Tstring strtime = arguments[ 0 ];
    if ( regex == strtime ) {
      sec = strtoi( strtime );
    }
  }

  // TODO: Хå⡼ɤǼ¹ԤȤʤΤǤ
  // ޥɤޤƤ⤳νִ֤ tStatusReady ν
  //Tcout << __FILE__ << __LINE__ << " " << theRunManager -> GetStatus() << Tendl;
  // ٥ȥ롼פʹԤʤΤ eventlimit ϤĤޤǤäƤ
  // ʤ
  // timelimit ϤȽλƤ
  // ޥǤμ¹Ԥʤ
  // ǤϤư
  // doEventLoop() ꤫?
  // ä EventManagerRunManagerεư򤵤ɬפ
  while ( theRunManager -> GetStatus() != tStatusStandby ) {
    sleep( sec );
  }

  return;
}

#ifdef __CLDAQ_ROOT_DLL
    ClassImp(TWaitCommand)
#endif
