// =====================================================================
//  $Id: TInputObjectFileOnline.cc,v 1.4 2004/03/07 10:30:32 goiwai Exp $
//  $Name: CLDAQ-1-14-02 $
//  $Log: TInputObjectFileOnline.cc,v $
//  Revision 1.4  2004/03/07 10:30:32  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.3  2003/12/06 10:56:19  goiwai
//  ե륿Ϣν Read(),Write()ͤνǤ.
//  Read()Write()쥳ɥ֤ޤ.
//  ե륿ƱͤǤ.
//  줾Υȥ꡼DataSizeΰǤ,ϰä쥳ɥ
//  Ǥʤäե䥽åȤʤɤΥˤʤޤ.쥳ɥ
//  פȤϸ¤ޤ.
//
//  Revision 1.2  2003/10/14 22:05:35  goiwai
//  䤿ΤCPUޤΤ,usleep(100*1000)褦ˤޤ.
//  äѥ쥳ɤ˥ơʤȤǤ.ʲ,ơ
//  8bit:	status
//  32bit:	total size
//
//  Revision 1.1  2003/10/12 13:01:47  goiwai
//  饤ǥե򸫤뤳Ȥ¿Τǥ饤ѤΤΤѰդޤ
//  .1٥ɤळȤޤ Read() дؿäƤޤ
//  Τ,λˤ 쥳ID 򸫤ƥ롼פȴɬפޤ.
//  ǡեޥåȤ˥ơФɬפϤʤäǤ.
//
// =====================================================================
#include "TInputObjectFileOnline.hh"
#include "TStreamableObject.hh"
#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"
#include "TInputObjectFilter.hh"
#include "TFileProperty.hh"

TInputObjectFileOnline::TInputObjectFileOnline( const Tstring& filename, const Tstring& mode, Tint utime )
  : TInputObjectFile( filename, mode ),
    theMicroSleepTime( utime )
{;}

TInputObjectFileOnline::TInputObjectFileOnline( TInputObjectFilter* filter, const Tstring& filename, const Tstring& mode, Tint utime )
  : TInputObjectFile( filter, filename, mode ),
    theMicroSleepTime( utime )
{;}

TInputObjectFileOnline::~TInputObjectFileOnline()
{;}

Tint TInputObjectFileOnline::Read( TStreamableObject& object )
{
  if ( HasFilter() ) {
    return theObjectFilter -> Filtering( object, this );
  }  

  theLastDataSize = theDataSize;
  theDataSize = 0;

  static Tobject_t objecttype = object.GetObjectType();

  switch ( objecttype ) {
    case tObjectDataRecord:
      *( (TDataRecord*)(&object) ) = getDataRecord();
      break;
    case tObjectDataSection:
      *( (TDataSection*)(&object) ) = getDataSection();
      break;
    case tObjectDataSegment:
      *( (TDataSegment*)(&object) ) = getDataSegment();
      break;
    case tObjectDataElement:
      *( (TDataElement*)(&object) ) = getDataElement();
      break;
    default:
      break;
  }

  if ( theDataSize <= 0 ) {
    SetOffset( theTotalDataSize, TObjectFile::tSeekBegin );
    TFileProperty pp( theFileName );
    Tint ss = pp.GetTotalSize();
    while ( ss == pp.GetTotalSize() ) {
      MicroSleep();
      pp.Update();
    }
    Read( object );
  } else {
    theTotalDataSize += theDataSize;
  }

  return theDataSize;
}

#ifdef __CLDAQ_ROOT_DLL
    ClassImp(TInputObjectFileOnline)
#endif
