// =====================================================================
/*!
//
//  \file TOutputObjectSocket.hh
//  \brief This file contains the TOutputObjectSocket class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TOutputObjectSocket.hh,v 1.7 2004/03/07 10:30:32 goiwai Exp $
//  $Name: CLDAQ-1-14-02 $
//  $Log: TOutputObjectSocket.hh,v $
//  Revision 1.7  2004/03/07 10:30:32  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.6  2004/01/19 21:09:41  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.5  2003/12/06 10:56:19  goiwai
//  ե륿Ϣν Read(),Write()ͤνǤ.
//  Read()Write()쥳ɥ֤ޤ.
//  ե륿ƱͤǤ.
//  줾Υȥ꡼DataSizeΰǤ,ϰä쥳ɥ
//  Ǥʤäե䥽åȤʤɤΥˤʤޤ.쥳ɥ
//  פȤϸ¤ޤ.
//
//  Revision 1.4  2003/11/03 08:35:13  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.3  2003/10/06 17:02:42  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:19:31  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef CLDAQ__TOUTPUTOBJECTSOCKET_HH
#define CLDAQ__TOUTPUTOBJECTSOCKET_HH

#include "Tglobals.h"
#include "TObjectSocket.hh"
#include "TOutputObjectStream.hh"

class TStreamableObject;
class TObjectFilter;
class TOutputObjectFilter;


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TOutputObjectSocket
// \brief This is the TOutputObjectSocket class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TOutputObjectSocket class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup PersistencyCategory
*/
class TOutputObjectSocket
  : public TObjectSocket, public TOutputObjectStream
{

  private:
    Tstring theServerName;
    struct hostent* theHostInformation;

  public:
    TOutputObjectSocket( const Tstring& hostname = "localhost", Tint port = tDefaultPortNumber );
    TOutputObjectSocket( Tint port );
    TOutputObjectSocket( TOutputObjectFilter* filter, const Tstring& hostname = "localhost", Tint port = tDefaultPortNumber );
    TOutputObjectSocket( TOutputObjectFilter* filter, Tint port );
    ~TOutputObjectSocket();

  public:
    Tint Write( TStreamableObject& object );

  public:
    const Tstring& GetServerName() const;

  private:
    Tvoid initialize();

#ifdef __CLDAQ_ROOT_DLL
    ClassDef(TOutputObjectSocket,0)
#endif

};

inline const Tstring& TOutputObjectSocket::GetServerName() const
{
  return theServerName;
}

#endif
