// =====================================================================
/*!
//
//  \file TReadoutElement.hh
//  \brief This file contains the TReadoutElement class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TReadoutElement.hh,v 1.7 2004/03/07 10:30:33 goiwai Exp $
//  $Name: CLDAQ-1-14-02 $
//  $Log: TReadoutElement.hh,v $
//  Revision 1.7  2004/03/07 10:30:33  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.6  2004/01/19 21:09:42  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.5  2003/11/03 08:35:14  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.4  2003/10/06 16:39:00  goiwai
//  *** empty log message ***
//
//  Revision 1.3  2003/07/30 16:20:11  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef CLDAQ__TREADOUTELEMENT_HH
#define CLDAQ__TREADOUTELEMENT_HH

#include "Tglobals.h"
#include "TReadoutIdentification.hh"

class TModule;
class TDataElement;


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TReadoutElement
// \brief This is the TReadoutElement class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TReadoutElement class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup ReadoutCategory
*/
class TReadoutElement
  : public TReadoutIdentification
{

  private:
    TModule* theModule;
    Tint theChannelNumber;

  public:
    TReadoutElement( TModule* module, const Tstring& id = TunknownID, Tint ch = -1 );
    TReadoutElement( TModule* module, Tint ch, const Tstring& id = TunknownID );
    TReadoutElement( const TReadoutElement& right );
    ~TReadoutElement();

  public:
    const TReadoutElement& operator=( const TReadoutElement& right );
    Tbool operator==( const TReadoutElement& right ) const;
    Tbool operator!=( const TReadoutElement& right ) const;

  public:
    TDataElement Read();
    TDataElement Read( Tint ch );

  public:
    TModule* GetModule() const;
    Tvoid SetModule( TModule* module );
    Tint GetChannelNumber() const;
    Tvoid SetChannelNumber( Tint ch );

#ifdef __CLDAQ_ROOT_DLL
    ClassDef(TReadoutElement,0)
#endif

};

inline TModule* TReadoutElement::GetModule() const
{
  return theModule;
}

inline Tvoid TReadoutElement::SetModule( TModule* module )
{
  theModule = module;
  return;
}

inline Tint TReadoutElement::GetChannelNumber() const
{
  return theChannelNumber;
}

inline Tvoid TReadoutElement::SetChannelNumber( Tint ch )
{
  theChannelNumber = ch;
  return;
}

#endif
