// =====================================================================
/*!
//
//  \file TMacroFileParser.hh
//  \brief This file contains the TMacroFileParser class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TMacroFileParser.hh,v 1.6 2004/03/07 10:30:34 goiwai Exp $
//  $Name: CLDAQ-1-14-02 $
//  $Log: TMacroFileParser.hh,v $
//  Revision 1.6  2004/03/07 10:30:34  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.5  2004/01/19 21:09:43  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.4  2003/11/03 08:35:15  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.3  2003/10/06 16:37:49  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:21:21  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef CLDAQ__TMACROFILEPARSER_HH
#define CLDAQ__TMACROFILEPARSER_HH

#include "Tglobals.h"


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TMacroFileParser
// \brief This is the TMacroFileParser class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TMacroFileParser class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup SystemCategory
*/
class TMacroFileParser
{

  private:
    Tstring theMacroFileName;
    TstringList theCommentStringList;
    Tifstream theMacroFileStream;

  public:
    TMacroFileParser();
    TMacroFileParser( const Tstring& input );
    TMacroFileParser( const Tstring& input, const TstringList& comment );
    TMacroFileParser( const TMacroFileParser& right );
    ~TMacroFileParser();

  public:
    Tvoid Open();
    Tvoid Open( const Tstring& filename );
    Tbool IsOpen();
    Tbool IsGood() const;
    Tbool IsFail() const;
    Tbool IsEndOfFile() const;
    Tbool IsSuccess();
    Tvoid Close();
    TstringList ReadLine();
    Tbool IsExecutable( const TstringList& readbuf ) const;
    Tstring GetCommand( const TstringList& readbuf ) const;
    TstringList GetArguments( const TstringList& readbuf ) const;

  public:
    const Tstring& GetMacroFileName() const;
    Tvoid SetMacroFileName( const Tstring& filename );
    const TstringList& GetCommentStringList() const;
    TstringList GetCommentStringList();
    Tvoid SetCommentStringList( const TstringList& list );
    Tifstream& GetMacroFileStream();

  private:
    Tvoid checkFileStream();
    TstringList divideLine( Tstring& readline ) const;
    const Tstring& eraseComment( Tstring& readline ) const;

#ifdef __CLDAQ_ROOT_DLL
    ClassDef(TMacroFileParser,0)
#endif

};

inline const Tstring& TMacroFileParser::GetMacroFileName() const
{
  return theMacroFileName;
}

inline Tvoid TMacroFileParser::SetMacroFileName( const Tstring& filename )
{
  theMacroFileName = filename;
  return;
}

inline const TstringList& TMacroFileParser::GetCommentStringList() const
{
  return theCommentStringList;
}

inline TstringList TMacroFileParser::GetCommentStringList()
{
  return theCommentStringList;
}

inline Tvoid TMacroFileParser::SetCommentStringList( const TstringList& list )
{
  theCommentStringList = list;
  return;
}

inline Tifstream& TMacroFileParser::GetMacroFileStream()
{
  return theMacroFileStream;
}


#endif
