// =====================================================================
/*!
//
//  \file Ttypes.h
//  \brief ƥ¸(ä˷)ʬϤʤ٤Υեǵۼޤ.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: Ttypes.h,v 1.26 2004/06/28 04:50:16 goiwai Exp $
//  $Name: CLDAQ-1-14-02 $
//  $Log: Ttypes.h,v $
//  Revision 1.26  2004/06/28 04:50:16  goiwai
//  С1.4.2ˤऱȯʡ
//
//  Revision 1.25  2004/06/28 04:02:50  goiwai
//  TlogTclogѹ
//
//  Revision 1.24  2004/06/24 15:20:38  goiwai
//  äƥ1.4.0Ȥޤ
//
//  Revision 1.23  2004/06/24 15:15:26  goiwai
//  ѹ
//  Tcout,Tcerr,TlogХåեͳˤ
//  ĤexternTlog,Tcout,Tcerr,Tinfo...Tcritʤɽϴط
//
//  Revision 1.22  2004/03/26 18:54:49  goiwai
//  Сˤफäȯʡ
//
//  Revision 1.21  2004/03/07 16:58:24  goiwai
//  ʤ줿Τǻ꡼ΥС1.13.0ˤʤޤ
//
//  Revision 1.20  2004/03/01 09:54:15  goiwai
//  С1.12.1ˤऱƻư
//
//  Revision 1.19  2004/01/19 21:09:43  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.18  2004/01/11 13:15:51  goiwai
//  إåե<iostream.h><iostream>ˤޤ.
//  -Wno-deprecatedʤǤȤꤢ,Warning򤹤褦ˤޤ.
//
//  Revision 1.17  2003/12/08 16:09:28  goiwai
//  С(1.12.0)ˤऱƳȯ
//
//  Revision 1.16  2003/12/04 23:20:52  goiwai
//  DEBUGΤȤʤ󤫤ˤ CLDAQ_DEBUG() ޥΤ礤.
//
//  Revision 1.15  2003/11/04 17:02:24  goiwai
//  Сֹѹ
//
//  Revision 1.14  2003/11/03 08:39:23  goiwai
//  DoxygenѤΥȥȤ򤦤Ļߤ򳫻Ϥޤ.
//
//  Revision 1.13  2003/10/06 16:38:26  goiwai
//  *** empty log message ***
//
//  Revision 1.12  2003/09/19 03:21:54  goiwai
//  2003ǯ7˹Ԥʤ줿ӡƥȤβϤĤΤ,С
//  夲ޤ.
//
//  Revision 1.11  2003/09/09 22:21:44  goiwai
//  С1.8.1ѹޤ.
//
//  Revision 1.10  2003/09/07 02:43:15  goiwai
//  ŻζڤȤȤ˥С򹹿ޤ.
//  1.7.1 -> 1.8.0
//
//  Revision 1.9  2003/08/17 02:02:53  goiwai
//  std::multimap  std::pair 򤽤줾 Tmultimap, Tpair  typedef 
//  .
//  n2Υơ֥ݤǤ.
//  ٥ꥹȤȻƤޤ,ɤǤ򻲾ȤǤ,
//  ͥƤ,䤹Ǥ.
//  դս,ȤݤȤȤǤ.Ȥ,
//    Map::iterator itr = map.find( "KEY" );
//    if ( itr ) {
//      itr -> second; // 
//      itr -> first;  // 
//    }
//  Ȥääˤʤޤ.
//
//  Revision 1.8  2003/08/17 00:55:50  goiwai
//  STL  std::map  TmapȤ typedef ޤ.
//
//  Revision 1.7  2003/08/05 23:05:00  goiwai
//  С1.7.1ˤ뤿Tversionͤѹޤ.
//
//  Revision 1.6  2003/07/30 18:31:09  goiwai
//  С1.7.0Ȥޤ.
//  ޤǤΤΤ CLDAQ-1-07-00 Ȥƥޤ.
//
//  Revision 1.5  2003/07/30 16:21:22  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef CLDAQ__TTYPES_H
#define CLDAQ__TTYPES_H

#include <iostream>
#include <iomanip>
#include <fstream>
#include <string>
#include <list>
#include <vector>
#include <map>
#if (__GNUC__==3) && (__GNUC_MINOR__>0)
#undef __DEPRECATED
#endif
#include <strstream>
#include <stdio.h>
#include <unistd.h>

#define Tfalse 0
#define Ttrue 1
//#define Tstd std
#define Tios std::ios
#define Tin ios::inin
#define Tout ios::out
#define Tate ios::ate
#define Tapp ios::app
#define Ttrunc ios::trunc
#define Tnocreate ios::nocreate
#define Tnoreplace ios::noreplace
#define Tbin ios::bin
#define Tbinary ios::binary
#define Tgoodbit ios::goodbit
#define Teofbit ios::eofbit
#define Tfailbit ios::failbit
#define Tbadbit ios::badbit
#define Tostream std::ostream
#define Tstreambuf std::streambuf
#define Tostrstream std::ostrstream
#define Tistream std::istream
#define Tlist std::list
#define Tvector std::vector
#define Tmap std::map
#define Tmultimap std::multimap
#define Tpair std::pair
#define Tcin std::cin

#include "TOutputStream.hh"
#ifdef __cplusplus
extern "C" {
#endif
  class TOutputStream;
  extern TOutputStream Tcout;
  extern TOutputStream Tcerr;
  extern TOutputStream Tclog;

  class TStringStreamBuffer;
  extern TStringStreamBuffer coutbuf;
  extern TStringStreamBuffer cerrbuf;
  extern TStringStreamBuffer clogbuf;

#ifdef __cplusplus
}
#endif

#define Tendl std::endl
#define Tends std::ends
#define Tdec std::dec
#define Thex std::hex
#define Toct std::oct
#define Tflush std::flush
#define Tsizeof(_type_) sizeof(_type_)


#define CLDAQ_DEBUG(m) \
if ( strlen(m) ) {\
  Tcout << "[CLDAQ:DEBUG]: " << m << " in \"" << __PRETTY_FUNCTION__ << "\" at " << __FILE__ << " line " << __LINE__ << "." << Tendl;\
} else {\
  Tcout << "[CLDAQ:DEBUG]: in \"" << __PRETTY_FUNCTION__ << "\" at " << __FILE__ << " line " << __LINE__ << "." << Tendl;\
}
#define CLDAQ_WARN(m) \
if ( strlen(m) ) {\
  Tcerr << "[CLDAQ:WARNIG]: " << m << " in \"" << __PRETTY_FUNCTION__ << "\" at " << __FILE__ << " line " << __LINE__ << "." << Tendl;\
} else {\
  Tcerr << "[CLDAQ:WARNIG]: in \"" << __PRETTY_FUNCTION__ << "\" at " << __FILE__ << " line " << __LINE__ << "." << Tendl;\
}\
perror( "[CLDAQ:WARNING]" );
#define CLDAQ_EMERG(m) \
if ( strlen(m) ) {\
  Tcerr << "[CLDAQ:EMERG]: " << m << " in \"" << __PRETTY_FUNCTION__ << "\" at " << __FILE__ << " line " << __LINE__ << "." << Tendl;\
} else {\
  Tcerr << "[CLDAQ:EMERG]: in \"" << __PRETTY_FUNCTION__ << "\" at " << __FILE__ << " line " << __LINE__ << "." << Tendl;\
}\
perror( "[CLDAQ:EMERG]" );\
abort();
#define CLDAQ_ABORT(m) CLDAQ_EMERG(m)
#define CLDAQ_EXIT(m) \
if ( strlen(m) ) {\
  Tcerr << "[CLDAQ:EXIT]: " << m << " in \"" << __PRETTY_FUNCTION__ << "\" at " << __FILE__ << " line " << __LINE__ << "." << Tendl;\
} else {\
  Tcerr << "[CLDAQ:EXIT]: in \"" << __PRETTY_FUNCTION__ << "\" at " << __FILE__ << " line " << __LINE__ << "." << Tendl;\
}\
perror( "[CLDAQ:EXIT]" );\
exit(EXIT_SUCCESS);


typedef double Tdouble;
typedef int Tint;
typedef float Tfloat;
typedef char Tchar;
typedef long Tlong;
typedef unsigned char TUchar;
typedef unsigned int TUint;
typedef unsigned long TUlong;
typedef short Tshort;
typedef unsigned short TUshort;
typedef bool Tbool;
typedef Tbool Tbit;
typedef FILE TFileStream;
typedef size_t Tsize_t;
typedef void Tvoid;
typedef std::string Tstring;
typedef std::ofstream Tofstream;
typedef std::ifstream Tifstream;
typedef Tvector<Tint> TintList;
typedef Tvector<TUint> TUintList;
typedef Tvector<TUshort> TUshortList;
typedef Tvector<Tdouble> TdoubleList;
typedef Tvector<Tfloat> TfloatList;
typedef Tvector<Tstring> TstringList;

static const Tstring Tspace = " ";
static const Tstring Thyphen = "-";
static const Tstring Tslash = "/";
static const Tstring Twslash = Tslash + Tslash;
static const Tstring Tbslash = "\\";
static const Tstring Tbackslash = Tbslash;
static const Tstring Twquote = "\"";
static const Tstring Tquote = "'";
static const Tstring Tsharp = "#";
static const Tstring Tpipe = "|";
static const Tstring Tcolon = ":";
static const Tstring Twspace = Tspace + Tspace;
static const Tstring Ttab = "\t";
static const Tstring Tbeep = "\b";
static const Tstring Thour = "h";
static const Tstring Tmin = "m";
static const Tstring Tsec = "s";
static const Tstring Tmsec = "ms";
static const Tstring Tusec = "us";
static const Tstring Tnsec = "ns";
static const Tstring Tid = "$Id: Ttypes.h,v 1.26 2004/06/28 04:50:16 goiwai Exp $";
static const Tstring Tname = "$Name: CLDAQ-1-14-02 $";
static const Tstring Tproject = "CLDAQ";
static const Tstring Tversion = "1.14.2";
static const Tstring Texit = "exit";
static const Tstring Tprompt = Tproject + Thyphen + Tversion + ">" + Tspace;
static const Tchar Tkey = '\x01';
static const Tchar Teol = '\n';

enum Tobject_t { 
  tObjectDataRecord,
  tObjectDataSection,
  tObjectDataSegment,
  tObjectDataElement,
  tObject1DHistogram,
  tObject2DHistogram,
  tObjectAppendGraph,
  tObjectSubstituteGraph,
  tObjectNtuple,
  tNumberOfObjectTypes,
  tObjectUnknown = -1
};

enum Telement_t {
  tTypeInt,
  tTypeString,
  tTypeDouble,
  tTypeObject,
  tTypeFloat,
  tTypeUnsignedShort,
  tTypeShort,
  tTypeWord,
  tTypeLong,
  tTypeUnsignedLong,
  tTypeUnsignedInt,
  tNumberOfElementTypes,
  tTypeUnknown = -1
};

enum Tstream_t { 
  tFileStream,
  tSocketStream,
  tSharedMemoryStream,
  tNumberOfStreamTypes,
  tUnknownStream = -1
};

enum Trandom_t {
  tRandomExponential,
  tRandomGaussian,
  tRandomChiSquare,
  tRandomLandau,
  tRandomGamma,
  tRandomPoisson,
  tNumberOfRandomTypes,
  tRandomUnknown = -1
};

enum Tstatus_t {
  tStatusStandby,
  tStatusReady,
  tStatusBusy,
  tStatusIdle,
  tStatusWaitingReady,
  tStatusJustTakingEvent,
  tStatusJustRecordingEvent,
  tStatusSleep,
  tStatusDead,
  tNumberOfStatusTypes,
  tStatusUnknown = -1
};

enum TvmeTransfer_t {
  tA16D16,
  tA16D32,
  tA24D16,
  tA24D32,
  tA32D16,
  tA32D32,
  tA24D16dma,
  tA32D16dma,
  tA24D32dma,
  tA32D32dma, 
  tNumberOfVmeTransferModes,
  tTransferModeUnknown = -1
};

// with Sanshiro driver
static const Tstring TvmeDevices[ tNumberOfVmeTransferModes ] =
{
  "/dev/vmedrv16d16",
  "/dev/vmedrv16d32",
  "/dev/vmedrv24d16",
  "/dev/vmedrv24d32",
  "/dev/vmedrv32d16",
  "/dev/vmedrv32d32",
  "/dev/vmedrv24d16dma",
  "/dev/vmedrv32d16dma",
  "/dev/vmedrv24d32dma",
  "/dev/vmedrv32d32dma"
};

enum TcamacCrateController_t {
  tISAcc7000_1,
  tISAcc7000_2,
  tISAcc7000_3,
  tISAcc7000_4,
  tISAcc7700_1,
  tISAcc7700_2,
  tISAcc7700_3,
  tISAcc7700_4, 
  tPCIcc7700_1,
  tPCIcc7700_2,
  tPCIcc7700_3,
  tPCIcc7700_4,
  tNumberOfCamacCrateController,
  tCamacCrateControllerUnknown = -1
};

// with Yasu driver
static const Tstring TcamacDevices[ tNumberOfCamacCrateController ] =
{
  "/dev/ISAcc7000.1",
  "/dev/ISAcc7000.2",
  "/dev/ISAcc7000.3",
  "/dev/ISAcc7000.4",
  "/dev/ISAcc7700.1",
  "/dev/ISAcc7700.2",
  "/dev/ISAcc7700.3",
  "/dev/ISAcc7700.4",
  "/dev/PCIcc7700.1",
  "/dev/PCIcc7700.2",
  "/dev/PCIcc7700.3",
  "/dev/PCIcc7700.4"
};

enum Truninfo_t { 
  tInfoFreeValue,
  tInfoSelectableValue,
  tInfoFreeText,
  tNumberOfInformations,
  tInfoUnknown = -1
};

enum { 
  tIDunknown = -1
};

static const Tstring TunknownID = "unkown ID";

using namespace std;

#endif
