// =====================================================================
//  $Id: ifile2.cc,v 1.2 2003/11/29 14:44:10 goiwai Exp $
//  $Name: CLDAQ-1-14-02 $
//  $Log: ifile2.cc,v $
//  Revision 1.2  2003/11/29 14:44:10  goiwai
//  *** empty log message ***
//
//  Revision 1.1  2003/11/24 22:41:37  goiwai
//  ifile2.ccɲäޤ.
//  ⤦ҤȤĤΥȥ꡼(ΤȤեò)ؤΥˡ򼨤
//  Ǥ.
//
// =====================================================================
#include "TDataRecord.hh"
#include "TInputObjectFile.hh"
#include "TBenchmark.hh"
#include "TArgument.hh"

int main( int argc, char** argv, char** envv )
{
  TArgument arg( argc, argv );
  if ( arg.GetNumberOfElements() != 1 || !isexist( arg[ 0 ] ) ) {
    arg.ShowUsage();
  }
  const Tstring filename = arg[ 0 ];
 
  TInputObjectFile ifile2( filename );
  Tint nevents = 0;
  Tint datasize = 0;

  TDataRecord record;
  TBenchmark bench;
  bench.Start();

  //   const Tstring id = "This is a Data Record.";  // for "ofile.drec"
  //   while ( record = ifile2[ id ], record == id ) {
  //     Tcout << record[0][1][0] << Tendl;
  //     datasize += record.GetRecordSize();  
  //     nevents ++;
  //   }

  for ( Tint i = 0; i < ifile2.Size(); i ++ ) {
    record = ifile2[ i ];
    //Tcout << record << Tendl;
    datasize += record.GetRecordSize();  
    nevents ++;
  }


  bench.Stop();
  Tcout << bench << Tendl;

  Tcout << nevents << " events, ";
  Tcout << datasize << Tslash << ifile2.GetTotalDataSize();
  Tcout << " byte data has been read from " << filename << "." << Tendl;

  return 0;
}
