// =====================================================================
//  $Id: regex1.cc,v 1.1 2004/02/27 20:05:38 goiwai Exp $
//  $Name: CLDAQ-1-14-02 $
//  $Log: regex1.cc,v $
//  Revision 1.1  2004/02/27 20:05:38  goiwai
//  renamed regex.cc -> regex1.cc
//
//  Revision 1.1  2003/10/06 04:03:07  goiwai
//  ɽ᤹TRegulaExpressionλǤ.
//  Υץ grep ޥɤȤۤǤ.
//
// =====================================================================
#include "TRegularExpression.hh"
#include "TBenchmark.hh"
#include "TOption.hh"
#include "TOptionTable.hh"
#include "TArgument.hh"

int main( int argc, char** argv, char** envv )
{
  TOption ignore( "ignore-case", "i", 0, "ignore case distinctions" );
  TArgument arg( argc, argv, TOptionTable( &ignore ) );

  if ( arg.GetNumberOfElements() != 2 ) {
    arg.ShowUsage();
  }

  const Tstring pattern = arg.GetElement( 0 );
  const Tstring file = arg.GetElement( 1 );

  TRegularExpression regex( pattern );
  if ( arg.HasOption( "i" ) ) {
    regex.IgnoreCase();
  }

  const Tint buflen = 1024;
  Tchar buf[ buflen ];
  Tifstream ifs( file.c_str() );

  TBenchmark bench;
  bench.Start();
  while ( ifs.getline( buf, buflen ) ) {
    Tstring source = buf;
    if ( regex == source ) {
      Tcout << source << Tendl;
    }
  }
  bench.Stop();
  Tcout << bench << Tendl;

  ifs.close();

  return 0;
}
